(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[         0,          0]
NotebookDataLength[     26202,        771]
NotebookOptionsPosition[     21762,        658]
NotebookOutlinePosition[     22295,        677]
CellTagsIndexPosition[     22252,        674]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["02 Vector Operations", "Title",
 CellChangeTimes->{{3.544391134969587*^9, 3.5443911398658667`*^9}}],

Cell[CellGroupData[{

Cell["[Your name(s) here!]", "Subsubsection",
 CellChangeTimes->{{3.6502200811704893`*^9, 3.65022008791844*^9}}],

Cell["\<\
Two people can do this together.  Just make sure to hand in at least one \
notebook with both names included.\
\>", "Text",
 CellChangeTimes->{{3.543847682631153*^9, 3.543847690566946*^9}, {
  3.5442904675915427`*^9, 3.5442905126305428`*^9}, {3.576599489007595*^9, 
  3.5765994903973227`*^9}, {3.6502200240066423`*^9, 3.6502200614124126`*^9}, {
  3.65022504270975*^9, 3.650225077793158*^9}, {3.682088113018442*^9, 
  3.682088114606874*^9}, {3.682089744832211*^9, 3.6820897950637207`*^9}, {
  3.734423034486733*^9, 
  3.734423039212042*^9}},ExpressionUUID->"14639052-3770-4a9f-8f41-\
8e379f28a54c"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Computations with vectors (examples)", "Section",
 CellChangeTimes->{{3.5443911954340453`*^9, 3.544391201833411*^9}, {
  3.682088705342061*^9, 3.682088714350313*^9}}],

Cell[TextData[{
 "Execute each input cell in turn and see if the results make sense to you!\
\[LineSeparator]\nDefine two vectors,  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "0", ",", "1"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["b",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"1", ",", "1", ",", "0"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]]]
}], "Text",
 CellChangeTimes->{{3.544391331030801*^9, 3.544391408961258*^9}, {
  3.544391543356945*^9, 3.5443915999081798`*^9}, {3.544391702073023*^9, 
  3.5443917213101234`*^9}, {3.5443918679255095`*^9, 3.5443918939419975`*^9}, {
  3.5443919570996103`*^9, 3.54439198629128*^9}, {3.6820883699256907`*^9, 
  3.682088390294242*^9}, {3.6820885207672873`*^9, 3.682088523204335*^9}, {
  3.682088717335326*^9, 3.682088738630501*^9}, {3.68208890798011*^9, 
  3.682088930420738*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], ";"}]], "Input"],

Cell[TextData[{
 "Calculate the scalar product ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "\[CenterDot]", 
    StyleBox["b",
     FontWeight->"Bold"]}], TraditionalForm]]],
 " (two ways):"
}], "Text",
 CellChangeTimes->{{3.682088459166759*^9, 3.6820884862421227`*^9}}],

Cell[BoxData[{
 RowBox[{"a", ".", "b"}], "\[IndentingNewLine]", 
 RowBox[{"Dot", "[", 
  RowBox[{"a", ",", "b"}], "]"}]}], "Input"],

Cell[TextData[{
 "Calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{"||", 
    StyleBox["a",
     FontWeight->"Bold"], "||"}], TraditionalForm]]],
 ", the magnitude / norm / length of a vector (three ways)"
}], "Text",
 CellChangeTimes->{{3.6820883983505497`*^9, 3.682088435011009*^9}, {
  3.682088750878441*^9, 3.68208875215187*^9}, {3.682088998348392*^9, 
  3.682089002835359*^9}}],

Cell[BoxData[{
 SqrtBox[
  RowBox[{"a", ".", "a"}]], "\[IndentingNewLine]", 
 SqrtBox[
  RowBox[{"Dot", "[", 
   RowBox[{"a", ",", "a"}], "]"}]], "\[IndentingNewLine]", 
 RowBox[{"Norm", "[", "a", "]"}]}], "Input",
 CellChangeTimes->{{3.682089010533164*^9, 3.6820890179389763`*^9}}],

Cell[TextData[{
 "Calculate the angle between ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ": (What do you think...is the answer in radians or degrees?)"
}], "Text",
 CellChangeTimes->{{3.682088540822051*^9, 3.682088550344308*^9}, {
  3.682088765040207*^9, 3.682088780117651*^9}}],

Cell[BoxData[
 RowBox[{"ArcCos", "[", 
  FractionBox[
   RowBox[{"a", ".", "b"}], 
   RowBox[{
    RowBox[{"Norm", "[", "a", "]"}], 
    RowBox[{"Norm", "[", "b", "]"}]}]], "]"}]], "Input"],

Cell[TextData[{
 "Calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["proj", 
     StyleBox["b",
      FontWeight->"Bold"]], "(", 
    StyleBox["a",
     FontWeight->"Bold"], ")"}], TraditionalForm]]]
}], "Text",
 CellChangeTimes->{{3.682088595713911*^9, 3.6820885981624613`*^9}}],

Cell[BoxData[
 RowBox[{"Projection", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input"],

Cell[TextData[{
 "Calculate the cross product (vector product) ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "\[Cross]", 
    StyleBox["b",
     FontWeight->"Bold"]}], TraditionalForm]]],
 " (two ways):  BTW, You get that particular \[Cross] operator off the \
typesetting palette (the smaller \[OpenCurlyQuote]x\[CloseCurlyQuote]) or by \
typing [esc]-cross-[esc]."
}], "Text",
 CellChangeTimes->{{3.682088632297578*^9, 3.682088677015348*^9}, {
  3.683897079134817*^9, 3.683897143190174*^9}}],

Cell[BoxData[{
 RowBox[{"a", "\[Cross]", "b"}], "\[IndentingNewLine]", 
 RowBox[{"Cross", "[", 
  RowBox[{"a", ",", "b"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5443912673101563`*^9, 3.544391272546456*^9}, {
   3.544391468546666*^9, 3.5443915327123365`*^9}, {3.5443916056495085`*^9, 
   3.5443916574254694`*^9}, {3.5443917281545153`*^9, 
   3.5443917319937344`*^9}, {3.5443917745971713`*^9, 3.544391821404849*^9}, 
   3.544391933586265*^9, {3.682088333304843*^9, 3.68208835161733*^9}, {
   3.682088490234371*^9, 3.6820884970444307`*^9}, 3.682088560377821*^9, {
   3.6820886039047327`*^9, 3.682088609113875*^9}, {3.682088681519663*^9, 
   3.682088684039625*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphing (example)", "Section",
 CellChangeTimes->{{3.5443956477557034`*^9, 3.5443956488747673`*^9}, {
  3.682089175666637*^9, 3.682089178184519*^9}}],

Cell[TextData[{
 "Here are those two functions to show the axes.  ",
 StyleBox["myAxis",
  FontFamily->"Courier New"],
 " returns graphic primitives that create an axis in the given component \
direction with the given label in the given color from lo to hi; the axis is \
dashed for negative values.  ",
 StyleBox["myPoint",
  FontFamily->"Courier New"],
 " includes dashed lines indicating how one might plot the point by hand and \
a label for the point."
}], "Text",
 CellChangeTimes->{{3.5443931462386246`*^9, 3.5443931949874134`*^9}, {
  3.650220166403576*^9, 3.6502201915958977`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"myAxis", "[", 
    RowBox[{
    "label_", ",", "color_", ",", "component_", ",", "lo_", ",", "hi_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e", ",", "g", ",", "o"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"o", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";", 
      RowBox[{"e", "=", "o"}], ";", 
      RowBox[{
       RowBox[{
       "e", "\[LeftDoubleBracket]", "component", "\[RightDoubleBracket]"}], 
       "=", "1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"g", "=", 
       RowBox[{"{", 
        RowBox[{"color", ",", 
         RowBox[{"Text", "[", 
          RowBox[{"label", ",", 
           RowBox[{"1.05", " ", "hi", " ", "e"}]}], "]"}], ",", 
         RowBox[{"Arrowheads", "[", "0.02", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{"o", ",", 
            RowBox[{"hi", " ", "e"}]}], "}"}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"lo", "<", "0"}], ",", 
        RowBox[{"g", "=", 
         RowBox[{"Join", "[", 
          RowBox[{"g", ",", 
           RowBox[{"{", 
            RowBox[{"Dashed", ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"lo", " ", "e"}], ",", "o"}], "}"}], "]"}], ",", 
             RowBox[{"Dashing", "[", 
              RowBox[{"{", "}"}], "]"}]}], "}"}]}], "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", "g"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"myPoint", "[", 
    RowBox[{"p_", ",", "color_", ",", "label_"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"color", ",", 
     RowBox[{"Text", "[", 
      RowBox[{"label", ",", 
       RowBox[{"1.1", " ", "p"}]}], "]"}], ",", "Dashed", ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"p", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"p", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           ",", 
          RowBox[{"p", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
           ",", "0"}], "}"}], ",", "p"}], "}"}], "]"}], ",", 
     RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
     RowBox[{"Point", "[", "p", "]"}], ",", 
     RowBox[{"Dashing", "[", 
      RowBox[{"{", "}"}], "]"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.544260709698449*^9, 3.5442607186279593`*^9}, {
  3.54428111716831*^9, 3.5442811280423098`*^9}, {3.5442856744219174`*^9, 
  3.5442856853789177`*^9}, {3.5442900062835426`*^9, 3.544290041155543*^9}, {
  3.5443927636957445`*^9, 3.544392786886071*^9}, {3.544392851243752*^9, 
  3.5443928515137672`*^9}}],

Cell[TextData[{
 "Draw a graph of the points and vectors ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "\[Cross]", 
    StyleBox["b",
     FontWeight->"Bold"]}], TraditionalForm]]],
 " along with part of the plane determined by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ". (The vectors are all portrayed as \[OpenCurlyDoubleQuote]position vectors\
\[CloseCurlyDoubleQuote] with their tails at the origin.)"
}], "Text",
 CellChangeTimes->{{3.544393214601535*^9, 3.5443933354354467`*^9}, {
  3.6820892025125837`*^9, 3.682089227112322*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"o", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";", 
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics3D", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Join", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<x\>\"", ",", "Orange", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "]"}], ",", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<y\>\"", ",", 
       RowBox[{"Darker", "[", "Yellow", "]"}], ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "]"}], ",", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<z\>\"", ",", "Green", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"myPoint", "[", 
      RowBox[{"a", ",", "Black", ",", "\"\<a\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"myPoint", "[", 
      RowBox[{"b", ",", "Black", ",", "\"\<b\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"myPoint", "[", 
      RowBox[{
       RowBox[{"a", "\[Cross]", "b"}], ",", "Red", ",", 
       "\"\<a\[Cross]b\>\""}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"Black", ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{"o", ",", "a"}], "}"}], "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{"o", ",", "b"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
       "Red", ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{"o", ",", 
          RowBox[{"a", "\[Cross]", "b"}]}], "}"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Opacity", "[", 
        RowBox[{"0.5", ",", "Blue"}], "]"}], ",", 
       RowBox[{"Polygon", "[", 
        RowBox[{"{", 
         RowBox[{"a", ",", "b", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "b"}]}], "}"}], "]"}]}], "\[IndentingNewLine]", 
      "}"}]}], "\[IndentingNewLine]", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100", ",", "100"}], "}"}]}]}], 
  "\[IndentingNewLine]", "]"}]}], "Input",
 CellChangeTimes->{{3.544188998883645*^9, 3.544189003768761*^9}, {
   3.5441897207364597`*^9, 3.5441897323461676`*^9}, {3.544190060055626*^9, 
   3.54419009446349*^9}, {3.5441901254087315`*^9, 3.5441901463092475`*^9}, {
   3.544190177415721*^9, 3.5441902335381937`*^9}, 3.5441902947152634`*^9, {
   3.5441904213970203`*^9, 3.5441904708429275`*^9}, {3.544191432467061*^9, 
   3.5441914326231127`*^9}, {3.544191466267708*^9, 3.544191473633315*^9}, 
   3.5441915498818345`*^9, {3.5441915858838005`*^9, 3.544191637041529*^9}, {
   3.5441952332194257`*^9, 3.5441952922172594`*^9}, {3.544227068842256*^9, 
   3.5442270705913563`*^9}, {3.544227108415519*^9, 3.544227136351117*^9}, {
   3.54422717940758*^9, 3.544227211334406*^9}, {3.544227258272091*^9, 
   3.5442272583830967`*^9}, {3.544264576475616*^9, 3.544264578367724*^9}, {
   3.544264611410614*^9, 3.5442647285733156`*^9}, {3.5442655755097575`*^9, 
   3.5442656265276756`*^9}, {3.544265668290064*^9, 3.5442656717772636`*^9}, {
   3.5442657178929014`*^9, 3.5442657435013657`*^9}, {3.5442683095971384`*^9, 
   3.544268333300494*^9}, {3.544268372027709*^9, 3.5442684125960293`*^9}, {
   3.544271170958799*^9, 3.5442711717258425`*^9}, {3.5442792389278936`*^9, 
   3.544279242872288*^9}, {3.544279277134714*^9, 3.5442792808680873`*^9}, {
   3.5442793221212125`*^9, 3.54427934140314*^9}, 3.54428111298731*^9, {
   3.544284734286769*^9, 3.544284743923805*^9}, 3.5442855942729177`*^9, {
   3.544392168068677*^9, 3.5443921821414814`*^9}, {3.544392216013419*^9, 
   3.5443922258699827`*^9}, {3.5443922779179597`*^9, 
   3.5443922786930037`*^9}, {3.5443923417416105`*^9, 3.544392424318333*^9}, {
   3.544392455639125*^9, 3.5443925750439544`*^9}, {3.5443926174083776`*^9, 
   3.5443926738816075`*^9}, {3.5443928006498585`*^9, 3.5443928242022057`*^9}, 
   3.5443935385290623`*^9, {3.650202957850041*^9, 3.650203061749638*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercises", "Section",
 CellChangeTimes->{{3.5443956564412003`*^9, 3.5443956579442863`*^9}}],

Cell[CellGroupData[{

Cell["Exercise 1 [3 points]", "Subsection",
 CellChangeTimes->{{3.544392010859685*^9, 3.5443920126677885`*^9}, {
  3.544394878382698*^9, 3.54439490674232*^9}}],

Cell[TextData[{
 "In the graph above, what geometric relationships do you observe among  ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "\[Cross]", 
    StyleBox["b",
     FontWeight->"Bold"]}], TraditionalForm]]],
 "?"
}], "Text",
 CellChangeTimes->{{3.5443947274160633`*^9, 3.544394776024843*^9}, {
  3.682089249961816*^9, 3.6820892568715*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2 [9 points]", "Subsection",
 CellChangeTimes->{{3.544394719096587*^9, 3.54439472072068*^9}, {
  3.544394902094054*^9, 3.5443949187500067`*^9}}],

Cell[TextData[{
 "Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"2", ",", "1", ",", "0"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["b",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"1", ",", "2", ",", "0"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["c",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"0", ",", "1", ",", "1"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]]],
 ".  Graph the parallelepiped defined by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox["c",
    FontWeight->"Bold"], TraditionalForm]]],
 ".  (BTW, Mathematica has a ",
 StyleBox["Parallelipiped [ ]",
  FontFamily->"Source Code Pro",
  FontWeight->"Regular"],
 " function that you might be able to use. Use this together with the \
framework above to display axes.)  "
}], "Text",
 CellChangeTimes->{{3.54439409672499*^9, 3.544394140315483*^9}, {
   3.544394217665907*^9, 3.544394242181309*^9}, 3.650203101333667*^9, 
   3.650220325201194*^9, {3.682089360017219*^9, 3.682089405694059*^9}, {
   3.682089437927988*^9, 3.682089498093018*^9}, {3.682089941104713*^9, 
   3.682089975111785*^9}}],

Cell[TextData[{
 "\[LineSeparator]Calculate the volume (using the triple product definition \
of volume...) and the surface area of the parallelepiped defined by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox["c",
    FontWeight->"Bold"], TraditionalForm]]],
 ". (Show and label your calculations below)."
}], "Text",
 CellChangeTimes->{{3.682089982074315*^9, 3.682089990737327*^9}, {
  3.683900572035191*^9, 3.683900588208535*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3 [9 points]", "Subsection",
 CellChangeTimes->{{3.5443952255485544`*^9, 3.5443952273876595`*^9}, {
  3.544395328843463*^9, 3.5443953322276564`*^9}}],

Cell[TextData[{
 "In two dimensions...\[LineSeparator]Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"2", ",", "1"}], "\[RightAngleBracket]"}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["b",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"4", ",", "0"}], "\[RightAngleBracket]"}]}], TraditionalForm]]],
 ".  Find the vector projection of ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 " onto ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ".  Graph ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and the projection together on the same plot."
}], "Text",
 CellChangeTimes->{{3.5443952354061184`*^9, 3.5443952509410067`*^9}, {
  3.6820895295165977`*^9, 3.682089611812591*^9}}],

Cell[TextData[{
 "\[LineSeparator] Now find the vector projection of ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 " onto ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]],
  FontWeight->"Bold"],
 ".  Graph ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and the projection together on the same plot."
}], "Text",
 CellChangeTimes->{{3.682089622158126*^9, 3.682089645351122*^9}, 
   3.682090000031019*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4 [3 points]", "Subsection",
 CellChangeTimes->{{3.5443956685948954`*^9, 3.5443956745372353`*^9}, {
  3.544396017485851*^9, 3.544396020045997*^9}}],

Cell[TextData[{
 "Try out ",
 StyleBox["L02DotProduct.nb",
  FontSlant->"Italic"],
 " (in our handouts folder) with \[OpenCurlyDoubleQuote]show dot product\
\[CloseCurlyDoubleQuote] checked.  Describe how this demonstration shows the \
dot product."
}], "Text",
 CellChangeTimes->{{3.5443957074411173`*^9, 3.5443958149522667`*^9}, {
   3.544395966511935*^9, 3.5443959685110493`*^9}, {3.650222085754159*^9, 
   3.650222088762722*^9}, 3.650222119714779*^9, {3.6502228177058277`*^9, 
   3.650222856337817*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5 [3 points]", "Subsection",
 CellChangeTimes->{{3.5443958573116894`*^9, 3.54439585907979*^9}, {
  3.5443960229581637`*^9, 3.5443960264303627`*^9}}],

Cell[TextData[{
 "Try out ",
 StyleBox["L02CrossProductOfVectorsInTheYZPlane.nb",
  FontSlant->"Italic"],
 " with \[OpenCurlyDoubleQuote]show parallelogram\[CloseCurlyDoubleQuote] \
checked.  What properties of the cross product does this demonstrate?"
}], "Text",
 CellChangeTimes->{{3.5443957074411173`*^9, 3.5443958149522667`*^9}, {
   3.544395957725433*^9, 3.544396011287496*^9}, {3.650222019874408*^9, 
   3.65022208034408*^9}, {3.6502228609016953`*^9, 3.6502228660013227`*^9}, 
   3.65022290908565*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{791, 670},
WindowMargins->{{429, Automatic}, {Automatic, 83}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.5, 1.5 Inherited],
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 27, \
2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[422, 15, 105, 1, 137, "Title", "ExpressionUUID" -> \
"7b063d69-9311-4499-b1c6-bdbf076d7271"],
Cell[CellGroupData[{
Cell[552, 20, 112, 1, 52, "Subsubsection", "ExpressionUUID" -> \
"203db02e-3104-4449-8796-d51545543380"],
Cell[667, 23, 607, 11, 77, "Text", "ExpressionUUID" -> \
"14639052-3770-4a9f-8f41-8e379f28a54c"],
Cell[1277, 36, 76, 1, 49, "Input", "ExpressionUUID" -> \
"d97a0181-d1c3-47c3-b75c-06c6295d279e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1390, 42, 172, 2, 96, "Section", "ExpressionUUID" -> \
"e2dea9e5-1845-4cad-8fbd-eb82d161dcf7"],
Cell[1565, 46, 1073, 28, 137, "Text", "ExpressionUUID" -> \
"69ace189-d616-4c86-a27b-0feffed5ffc4"],
Cell[2641, 76, 239, 8, 49, "Input", "ExpressionUUID" -> \
"638ead36-2c35-4528-9fbf-b6707a084ed2"],
Cell[2883, 86, 310, 11, 48, "Text", "ExpressionUUID" -> \
"1bc4264f-214b-4955-ac09-9ba1a4e66b3a"],
Cell[3196, 99, 131, 3, 81, "Input", "ExpressionUUID" -> \
"ea0646f2-fecd-4c92-a18c-c8e782dce0df"],
Cell[3330, 104, 383, 11, 79, "Text", "ExpressionUUID" -> \
"12fae20a-102d-4047-b95b-2f26253b4402"],
Cell[3716, 117, 282, 7, 127, "Input", "ExpressionUUID" -> \
"0c810ce6-c7c7-4608-ac74-6060abde06c5"],
Cell[4001, 126, 425, 14, 78, "Text", "ExpressionUUID" -> \
"0a976cc4-f828-4a91-ae1e-946b3b861ae2"],
Cell[4429, 142, 189, 6, 76, "Input", "ExpressionUUID" -> \
"6a2652e9-18c1-4456-b832-02a341c35924"],
Cell[4621, 150, 297, 11, 51, "Text", "ExpressionUUID" -> \
"cdcff203-f707-4a77-9eac-20fc5a887a0c"],
Cell[4921, 163, 86, 2, 49, "Input", "ExpressionUUID" -> \
"af1a8674-3793-47b3-ab34-cfb67ad35690"],
Cell[5010, 167, 532, 14, 107, "Text", "ExpressionUUID" -> \
"2e745162-2bf7-43e6-8990-51ecde359baf"],
Cell[5545, 183, 663, 11, 81, "Input", "ExpressionUUID" -> \
"91889e8a-dd4d-4b3a-8f1f-49adf4850d80"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6245, 199, 156, 2, 96, "Section", "ExpressionUUID" -> \
"c0ed9d0d-8f2a-495b-8a45-b7ae5e23629d"],
Cell[6404, 203, 591, 13, 199, "Text", "ExpressionUUID" -> \
"48f6d9b8-5507-463a-a564-15d19e7439a5"],
Cell[6998, 218, 2942, 77, 422, "Input", "ExpressionUUID" -> \
"4afe9ef0-a4a9-430d-9acc-a7aa61258fb9"],
Cell[9943, 297, 918, 33, 108, "Text", "ExpressionUUID" -> \
"39c6f5bc-670c-49af-8947-c7fad7437f4b"],
Cell[10864, 332, 4266, 87, 515, "Input", "ExpressionUUID" -> \
"e1ef5f54-7144-46bd-8c1f-7aa67496eeca"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15167, 424, 98, 1, 96, "Section", "ExpressionUUID" -> \
"7c4c46d1-7924-43bf-a2ab-0d269c06215c"],
Cell[CellGroupData[{
Cell[15290, 429, 159, 2, 65, "Subsection", "ExpressionUUID" -> \
"64f3a554-03ce-46dc-921d-d2465690cb9a"],
Cell[15452, 433, 578, 22, 78, "Text", "ExpressionUUID" -> \
"4d865a6d-72c7-4bc1-a501-fdcee32b77c9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16067, 460, 159, 2, 65, "Subsection", "ExpressionUUID" -> \
"8ff94f9a-58a8-4bd7-8bf6-5de5d915bf6d"],
Cell[16229, 464, 1569, 54, 140, "Text", "ExpressionUUID" -> \
"7d36ed03-77cb-4e42-9262-aee74197286a"],
Cell[17801, 520, 620, 20, 138, "Text", "ExpressionUUID" -> \
"c30d98e5-5a53-40ae-b06d-5d20575df0cf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18458, 545, 164, 2, 65, "Subsection", "ExpressionUUID" -> \
"d91fcb86-b8ee-4dbe-94a0-b63b1e3acfa2"],
Cell[18625, 549, 1080, 40, 108, "Text", "ExpressionUUID" -> \
"ed782860-b0e3-4d6a-a527-0c0e8e1747d5"],
Cell[19708, 591, 594, 23, 107, "Text", "ExpressionUUID" -> \
"68e950f2-62b5-47a8-9de2-0063bf8b52c9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20339, 619, 162, 2, 65, "Subsection", "ExpressionUUID" -> \
"0bae1d72-76a8-49a2-995d-8f2425dda38c"],
Cell[20504, 623, 507, 11, 106, "Text", "ExpressionUUID" -> \
"c77141b5-bcb1-4c5d-a662-283a07442a5f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21048, 639, 163, 2, 65, "Subsection", "ExpressionUUID" -> \
"45ea2fa4-3e57-4354-9207-9bd4a53fb489"],
Cell[21214, 643, 508, 10, 106, "Text", "ExpressionUUID" -> \
"8582cd55-8747-433d-ac93-182ad25775bc"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

