(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     24812,        659]
NotebookOptionsPosition[     23179,        604]
NotebookOutlinePosition[     23609,        621]
CellTagsIndexPosition[     23566,        618]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Optimization", "Section",
 CellChangeTimes->{{3.577117350884554*^9, 3.5771173532268963`*^9}}],

Cell[CellGroupData[{

Cell["\<\
Finding maxima and minima of single-variable real-valued functions.\
\>", "Subsection",
 CellChangeTimes->{{3.653308767404557*^9, 3.6533087832769957`*^9}}],

Cell[TextData[{
 StyleBox["Example:",
  FontWeight->"Bold"],
 " Finding the maximum and minimum of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", 
    RowBox[{"4", "+", 
     RowBox[{"6", "x"}], "-", 
     SuperscriptBox["x", "2"]}]}], TraditionalForm]]],
 " on the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{"0", ",", "7"}], "]"}], TraditionalForm]]],
 ",  including the 2nd derivative test for concavity."
}], "Text",
 CellChangeTimes->{{3.5450950352727532`*^9, 3.545095093124062*^9}, {
  3.5450951439149675`*^9, 3.5450951456910686`*^9}, {3.5450951983780823`*^9, 
  3.5450952026123247`*^9}, {3.545095288112215*^9, 3.5450952973927455`*^9}, {
  3.545096640956593*^9, 3.545096653645319*^9}, {3.545096842396115*^9, 
  3.5450968540037785`*^9}, {3.653308322395262*^9, 3.653308359035692*^9}, {
  3.653313516397213*^9, 3.653313519823421*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"4", "+", 
   RowBox[{"6", "x"}], "-", 
   SuperscriptBox["x", "2"]}]}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "7"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "'"}], "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "7"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.545095530645087*^9, 3.545095573697549*^9}, 
   3.577382850041854*^9, {3.653306205588087*^9, 3.653306206726119*^9}, {
   3.653310991660734*^9, 3.653311001084009*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
    1.], LineBox[CompressedData["
1:eJwV13k8lNsfB/AZY+aZGUuo7FtlmUdla5PSfEhZUlGWCGmhpJQkynKVRDeE
Ci0qolRS6LZYMpUu7YpLvyRbRBKVpRj5HX/N6/2a85zlOed8v99n2qZda3wl
GAwGl8lgTPxmrbt+N35WzBK5M7ELGQw58P8nte9S2kah0GjJEyMZORT7j6hH
pgUJX+m4dXqqyoFbFNTvn3ZQKGVyrevmXDmYus728ElLEVKv6nrN/OVgI5A6
vj4tS8hVXTxS/0YOa+QP0O5phcIZI2vUlmbJoyG2cMgt7aHw4fusqEazyYjb
qJ1YtPat0PJPTv32Y4q4uM/BO8q8UejsxdqUFqGC3h/RG1aMtApHP+S8jDVT
h+WiJ/rsO51Ciw1Xj9+X1ELdg9Ljrdo9wtGlgpseZdrQqD17POBLnzCyWHb0
9Mg0LLa/2PNy1Q+hRKGxhEh9Bo5Wr9gw/NeAcMXod/sIJR2YTPp6PrRlSFjc
Gjx4WV4XYcG+hkeVfwsV+HkZLzp1YWv4sHXnslHhx2sWvtk5eggulN94NWtM
eLz3nZqplz6WrFlkvO+/cWGAGt9/9aA+ipryOxzUmVDsNs60PSyAabNBrVib
iZNd3844HBGgsCVPlK/LhL5If+HqeAFuteeclTZiInmY5+aYIMCN7nNOLyyZ
8ItLVrY6KUDeYEL5iq1M6My8XNR+SYDzMjtP2Rcx8eXQTyutRwIctZi9zNZW
AueDFetCRwSw/m7vcsVBAt4/S6dRYgH+5Gzz5ThJ4O3JHItTYwLslc6JrXSX
wMfFwpYbDBrejar/IkACe6adqanh0DDdz7VZmCSBk4s7vZoUaHy43W5rUCeB
kpIGA3kDGmnbmO5H30lAO6gVB2bScFLX8u/6IAELO0Pdtlk0/o3xOHq5QwKp
3inrCoxoFK5583T6sAREGpHbzebRONL/wF5NlQX5b1/MJ4OG8awzDtI+LJyt
10pqd6YR/nQ1/9kWFpTfR9y0dCX9+bGr4/xZUO0y9j/vRsMra/dSVjALRTPO
5671oPG3oo35SCwL2iqJVjc20OhgDOh3XWdhRFwmrbGdxpn/VrIqh1m4k7el
7Vskjc49rIcHxSw0ibNltf+iYSJ3P0rIlETierPa1dE0qu11Rkr4kjhgtk33
+iEagxUj/YUakji1+0OvYxwNx2tXPl5YKokX/1Oc5J5Mg/0XsyT8uCSWJNem
rs+ikfDK9UzXCUksH+yPWpVNQ0Ez/4BLhiSaV903wSUa2uWui4yyJFHWbN+j
lUvDfPR6WVuRJIzCggpq8mgEhrpW2NVL4kvMi73DN2k07LpeqaTBxitOCdOj
nOxXBSP38DQ2ysfmPdZ9QOOTrGvsd102Fnd7rugn/nGDsfy5IRtdmddvHhTR
kP7qUhUFNgYiHapPPaaBbYxnHZvZ6FQ+tzDmKY2rPi6vi6+xYVqyRz24jobo
tJXXXzfZUIgL8dP9j8a7t0Y99rfZoO6eQD0xZxmfaitnwxDTc+c00NhCVyyR
e8NGxHCcUdP/aGj+EBTsGGZDYiTErucjjXkzFRebidmY+8vw1JFmGg5bWM9Y
TA7C3FlB2i1kv+ubOs7wOViy7M+71a1kvJJUjacaHDx7uHh7ZjuN1Bhxgq41
B69XfUj5+ZnMt6xb9bstB6uiVjSHdpH5Dtbnla3koEWuvmyEuG9rYeVaNw5s
NlgIxN1kPAc/8cHtHMhlOYt6e8j8p9YEfEzmIPle7uCxPhoaq8p/Xz3FgY/K
c+vfxHPjrsWFnOFgaZOUjm8/jc2/D1+SzuHANqk51ew7Ga9pYaP5XQ4cT702
efWDzP/yJfv0Jg5WLni79/Ygeb8576Ic2jgQx+TM5w3RkMyWKWZ+5mBt/LtT
nsQJmaFqO/o5GL7rO2uc+PzJFV/BoqBZPKVkzi8am1KjtYcoCjLlA36RxHrJ
/zhfl6aQFTW/8AnxzWNa5VMVKTwWNGus+U3mc+hn4hcBRfbziZvHCI3D0YJH
F2ZTUGgp6ssgtovyGnI2pfDZW0K3nvjt/irvikUU4mL+3eowSqN991mjk6so
XNrWvlIgppEXWLPZbi0F2d6PNeuJd+xgZ/xxozCNXvw9kXhg6y6G/0YKS6rV
+N+IORuWvrHYS8Ele9e5zDEazzzD2D/DKDA/hfH/JT7ucWNhXiQFp6b2qb3E
yq5K2QpxFL4OfZRc8IfEl7UO9VXHKMxT2tXlTnzR6SA/MpmCXp+PfzgxvbJn
z+fTFMaf+C8tIf5mr33l3Hmy3srocw3ERbYujU6XKISF/079SWxuXbG0LJ9C
8iS5dfrjNP5YDoQGFVJQ7L2hJyR+LKTz9e5QWH7oRqoLscOiE1NSKihk1r6x
iiKWW1htu7ySQuXxoSPJxHXzxyJGqymcYEVuyyLOmGtaeOslBb6R7+dbxF6m
Wzt831KgFW6yKoinG59TUWug0J/vUf6cuHP2m5U1jRS8xrdOaSC+NpNzKLaF
QgivgdtKHEgvumPeQcHk+ZUz3cSm+ru/9HVTOG39/mk/8bBOrmbuNwq5IYFp
Q8Rl09+v8fhJYb33FsYocbT2pLhJvyjc+1NK/SG21rQurRRTKHcNyR8n5qrv
79vP5GK7X/K3Cb9QKZhhxOGiYrbMq4n2KUrtbp/4XJTl99iLiZOr7hbYTuKS
eL2g+NeEQxPYNyZzYdrR2vlzwvobPeWVuZjM+trRO+GGecUh6lxsDHW51Tnh
OD7/vTYXmlaayz8SH1/Q7LNElwu7zcuv1BEnfS6+m01z0fb+Ze3TCafHy1KG
XHTn3X5ePmEbL98AUy68X44kTbzfxGGTstfzubC2vaiRTZxwhTN57iIuTqnk
hqZO2K3RP0PIhYslL/PghKlbIvFSLg5XvEjcRXzs7mGljbZcaJ/ss/Mk/lvJ
8AntxEUu1uqYTrhKQj3JhYsE5ZNWasRHQxv2/HDnonX53Fks4viGaO3STVz8
dzl142tyvuLjXEK1tnIR8s7xRvGEFxi8igngIsYnsDKNOC69NtxhL1lPcJXz
xHk+YpP39lYYF5bjEq/MJjwcQU+N5IJqzVRQmrCbXkNTLBfNV76PvSb347DS
ftNd6VyUWMl7zZlw1cqjtWfJeg7amPCIY0Kntyy4SPZLsammidy/Qw3PExlX
uQiz1tsTQ3wwXbM7pYQL5RvGFiJyv6NtfgqHHnCx9sLGHQkTHq5K83jMhfjz
dz+3CbsFWc94wcWZCOMH3SQ+RClVXrjdxMV4ke7gOIkvUVUZQ8ptXOSvc/rr
EXFk6M6VkZ1cVDt/qIshjmhQHF3WR/bXUa5NgvhAur9rA4OHEOf+wz+GaYQq
TZIZmcHD3pTkr+kkPnILw+XLBTzo7W92AnGGfdfU6Nk8FBtudvg8QONe5ENN
zgIevFk8pgnxSHuwsYI9D8NrXm0rJvE24ta7tQa7eTA+JjTdS+K1tP2ydb17
eUhxbPzCJj7XXuh5az8PL9qvm6V9o1GueMx3fgwPtcE9J4p6STyIsAi1SuNh
mvkn2/ckHxy0yz7jUcbDyw1l+R0kvyi0y17QeMhDo0TuPR/i7IjwSy1PeKgM
fuT+vpPGo5vO+X6vedCvOLv+aQeJ74rUgz1tPBiKq7zSSL460hbQ+jeXD5tJ
lOdXkv+Ohc8TlDrzkX1aC/Ekv7pWWa6e7c7HoYev3rTWkngxedW+C1587B5a
pG9OXHLNrzLGj4+AOEeNz29odP0v3cchjI+vyzbNN31N7rfZSEbTWT7U5gnU
E0n+Fg884DHa+TD4YHHHhdQH1XhuvOczH5G5BRVxZTROJDS4ferh40N4U8K9
UhoGOv251QN8PFgdskexhMa6tdOsUjhS4J9M3P74Do1/CmMOTDeQwuskH9k2
Un8EBtr2WAdJgbcyWceU1DedUefuXQyRQlLI4AHLizQ2HO+PFe+Xgo65b9bq
C6Q+upWhffuQFA6lb/Helkljzo8ulxknpcC81JZx7DSNXyFHRcy7UtAYa5x0
OoWc38hnpx6IpfCg/DG7htRfI4mam1WZ0nDZFuF1n9Rnwef3GO9jS2O0QBib
FUXqjQrV57NlpREu12kdGEHDhhnAyNSShqVO0eHfoeQ8xEoFhFtJ40uSDach
kNSrCQ4wi5dG1u6t8gXraVw4Ylb6I0EaFeGqUa6kfsyL1pl/I0UaVpcUYsfW
0SjdK545/aw0gmzebrQh9WeLZ76SdIE0Yj4luT5zpDFztnRfc600AoPGZiUu
I/n35fPMOC0ZbKm/mcgxpNEju2K0/o4Mnr/w16wm9bhxaX0GSmVw0UQ0Ze5v
Un9v3TT/WoUMqi4n1Z4fJvV5xf6gyGoZcB6duLZ7QAC5oLzPM97LwL1syQP2
NwHm1rLrdo/JQChSihhsESAqXZTPt5bFJHa9U88T0l57vveSN7KoORTja0y+
HwqfJZ7IY8rhl/zOKW5/9DGm+lvUmS4HPaHCnzpPfRQWeVjxdOTx5V6Bypoi
PURE3N/HLJPHyJvnnaXtuihIlB1vslOAuWLPYLysLmLmejr21Smg4J/GDSEG
OgiUueJcHzAZgeNTHM9qzMDD2V35Wb8mQ6T474d/ZKdjZrTePauUKfil/nNk
Vq02xlTWK1VrTUVL5yaFcSMtBNnFCw9dn4q9x5zkIy6oQ3ytSFVhqSLuuRY1
Il8FfWtr7Y7UKCLDYFlf9yNF/Db8PrPGXwl518U/lHZNRu4FqmEVQxkXc6Ob
V4on4b7blPrCBGXUdMwJY1jy0G6pGf9FRwU+9e03d2YyERKsmUQVq0D7XP84
5TwgvGqu5OW+RBXRnwpz6Ig64cAcmebo/1SB3hFTR+Wuiit7f99O2KQGkco0
i51F4opH88YPSviqQXv44Hy9P+KKj0OSq8O2Tvz/j32P3ViF4n657s07iGen
Pj7dOlZxJFJfY9E+NTBS9Ifj5Mcr/I64xHYfVUN0dnNR3X2GSC+j0GV5oRp8
TJyMo7VZIiv3u9PLitWAPl0PTRuWyFu1vM/kDunv9eaURztZorRz1Uc1Skl/
v1QFGqUsESeruXygkrTv3Dek6iop6rgqo3fpHfHCDsWFiWwRI2DyT+VG8rym
g5LZbbZIfZaKKKmJWE9d16KRLXIu0PE40KYG4/PD29xpjqiyaFGS01c13DI4
l/L+CUfUEmy5vuobGU/HYYzXyxGJ59oILL6roUbou084hRLNvbvmkWCI9Pfx
bXLZJkrkGLbu+PlfpP0mfVPJvynRjoXenlNG1XCR6mhxKqRE8SOb6b/HyPOv
pTJz31GinFL/ofFxNewuOes3Pk6J/g9520Is
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{0, 7}, {-2.9999988571428773`, 12.999999480368576`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.545095574258581*^9, 3.577117410943584*^9, 
  3.5773828555722313`*^9, 3.57743908982307*^9, 3.5774392345765533`*^9, 
  3.653306166983986*^9, 3.653306209609799*^9, 3.653311001685122*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
    1.], LineBox[CompressedData["
1:eJwB4QQe+yFib1JlAgAAAE0AAAACAAAAoVirt4gsgz5Id9Ps//8XQArZC3aj
lmE/Cn0iV5r7F0CzafocfZZxP8uCccE09xdACLJx8GmWgT9Ojg+Wae4XQDJW
LVpglpE/VKVLP9PcF0BHKAuPW5ahP1/Tw5GmuRdAUhF6KVmWsT91L7Q2TXMX
QNeFsfZXlsE/o+eUgJrmFkCHYSCNslPSP8/zW66JtRVAoHZMXn462z8scTY0
sJgUQO3ygF9L+uE/RcMfKG2BE0BBO8UnBbbmPzCxDrZ+UhJA1L67j+Eg6z9L
EBGcxzcRQB3Tm49r6u8/OQsZHGUFEEA8SqDrzU7yP8S1XxQysQ1AichLX/d/
9D93N7SgCIALQDEP7J534PY/z/ATYYgfCUB4c2UuiRj5P4iMmtF25wZASC7B
4W1F+z+40T4ekroEQHOxEWGpof0/jU7unlZeAkA+UjswdtX/P8KtxM+JKgBA
st2s5UwcAUA4iUxpzI77P4k9LUVISAJA3AlL697e9j8wLJpMDGADQEBPl83O
f/I/BX8BunuPBEDYB/QvIoTrP6lgVc+zqgVAuPpUhWGq4j97pqNKl90GQFCY
xVWLJtI/kRfjV+QKCEAAIi/Gr8iFv3cXDw36IwlAcHfx0KA/0r+LezUou1QK
QFjcq0HZpeK/bm5I60RxC0Bwc0NaJ4rrv5aMTEA4iAxAWDIyAeEg8r/rDkv7
1rYNQKw7LO1b2/a/ECA2Xj7RDkBAgNh4+UT7v7HKjZOoARBAxCo3TqIGAMD9
GvnA5pcQQPRr5AObXwLAsbJaQgkkEUDEymoJJZAEwHx8uXYBvBFA8PHl2gXw
BsCujQ7/3UkSQLg2Ovx3JwnAgzRcUO/UEkAM0nBBvVMLwG4Np1TWaxNAuDWc
UlmvDcDBLeisofgTQAS3oLOG4g/AK4AmuEKRFEBWAE1whSIRwP0ZWxfIHxVA
+jO2LpA/EsBxSYg/gqsVQOKSEH8EVxPA/KqyGhJDFkD4VWU1JIYUwO9T00mG
0BZA3qemkwyhFcD5LvEr0GkXQPJd4leg0xbApZ8H104AGEBKPw+unQAYwLlX
FNaxjBhAcq8orGMZGcDjQR6I6iQZQMaDPBDVSRrAdXMejgezGUDq5jwcD2Yb
wKk6F11ZPhpAUnUuurJ8HMD0Mw3fgNUaQOhnGr4Bqx3Ap3T5tIxiG0BO6fJp
GcUewMI1/4ECZRtAhGv+AwXKHsDe9gRPeGcbQLztCZ7wzh7AFnkQ6WNsG0As
8iDSx9gewIZ9Jx07dhtADPtOOnbsHsBmhlWF6YkbQMwMqwrTEx/AJpixVUax
G0BMMGOrjGIfwEJZtyK8sxtAhLJuRXhnH8BeGr3vMbYbQLw0et9jbB/AlpzI
iR27G0AsOZETO3YfwAah3730xBtADEK/e+mJH8DlqQ0mo9gbQMpTG0xGsR/A
AGsT8xjbG0AA1ibmMbYfwBwsGcCO3RtAOFgygB27H8BUriRaeuIbQKhcSbT0
xB/AxLI7jlHsG0CIZXcco9gfwOBzQVvH7htAwOeCto7dH8D8NEcoPfEbQPhp
jlB64h/ANLdSwij2G0BobqWEUewfwFB4WI+e+BtAoPCwHj3xH8BsOV5cFPsb
QNhyvLgo9h/AiPpjKYr9G0AQ9cdSFPsfwKS7afb//xtASHfT7P//H8AiPDAB

     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{0, 7}, {-7.999999714285714, 5.999999714285714}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.545095574258581*^9, 3.577117410943584*^9, 
  3.5773828555722313`*^9, 3.57743908982307*^9, 3.5774392345765533`*^9, 
  3.653306166983986*^9, 3.653306209609799*^9, 3.653311001803645*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"0", "\[LessEqual]", "x", "\[LessEqual]", "7"}]}], "}"}], ",", 
   "x"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"0", "\[LessEqual]", "x", "\[LessEqual]", "7"}]}], "}"}], ",", 
   "x"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], "[", "x", "]"}], "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3.5"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.5450966914714823`*^9, 3.545096721206183*^9}, {
  3.6533107989428*^9, 3.653310844896632*^9}, {3.653320492796504*^9, 
  3.653320513260105*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "7"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.5450967233003025`*^9, 3.5771174142906237`*^9, 3.57738285779558*^9, 
   3.577439238491827*^9, 3.653306169957184*^9, 3.6533062121461353`*^9, 
   3.653310845697439*^9, {3.653320501802696*^9, 3.653320513610694*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"13", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "3"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.5450967233003025`*^9, 3.5771174142906237`*^9, 3.57738285779558*^9, 
   3.577439238491827*^9, 3.653306169957184*^9, 3.6533062121461353`*^9, 
   3.653310845697439*^9, {3.653320501802696*^9, 3.653320513614686*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "3.`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5450967233003025`*^9, 3.5771174142906237`*^9, 3.57738285779558*^9, 
   3.577439238491827*^9, 3.653306169957184*^9, 3.6533062121461353`*^9, 
   3.653310845697439*^9, {3.653320501802696*^9, 3.6533205136176643`*^9}}]
}, Open  ]],

Cell[TextData[{
 "It looks like there\[CloseCurlyQuote]s a maximum at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "3"}], TraditionalForm]]],
 ".  Test the first and second derivative:"
}], "Text",
 CellChangeTimes->{{3.653308393182095*^9, 3.653308429286933*^9}, {
  3.653320529669114*^9, 3.653320531854841*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "'"}], "[", "3", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "''"}], "[", "3", "]"}]}], "Input",
 CellChangeTimes->{{3.6533061563550797`*^9, 3.653306238134611*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.653306162647917*^9, 3.653306238604786*^9}}],

Cell[BoxData[
 RowBox[{"-", "2"}]], "Output",
 CellChangeTimes->{{3.653306162647917*^9, 3.653306238608962*^9}}]
}, Open  ]],

Cell["\<\
The first derivative is zero at 3, so there\[CloseCurlyQuote]s either a \
maximum, a minimum, or an inflection point there.

The second derivative is negative, indicating the function is concave down, \
so it must be a maximum.  This is consistent with the graph of the function.\
\>", "Text",
 CellChangeTimes->{{3.653308440489087*^9, 3.653308520709046*^9}, {
  3.653308606349203*^9, 3.6533086487002087`*^9}}],

Cell[TextData[StyleBox["Exercise 1", "Subsubsection"]], "Text",
 CellChangeTimes->{{3.653308829116776*^9, 3.65330883129976*^9}}],

Cell[TextData[{
 "1.) For the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", "x", ")"}], "=", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"sin", "(", 
      RowBox[{"1.3", " ", 
       SuperscriptBox["x", "2"]}], ")"}]}]}], TraditionalForm]]],
 " find all the maxima, minima and inflection points on the interval \
[0.5,2.5]."
}], "Text",
 CellChangeTimes->{{3.6533088496892843`*^9, 3.653308849993044*^9}, {
  3.653311160055973*^9, 3.6533111647191877`*^9}, {3.653313588656966*^9, 
  3.6533137034093*^9}, {3.6533137550790167`*^9, 3.653313778827181*^9}, {
  3.653313913151507*^9, 3.653313922523508*^9}}],

Cell[TextData[{
 "2.) Consider the more general function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", "x", ")"}], "=", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"sin", "(", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "2"]}], ")"}]}]}], TraditionalForm]]],
 " on the interval [0.5,2.5].  For what values of ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]]],
 " is there only one minimum and one maximum (at the endpoints of the \
interval)? (Maybe \
\[OpenCurlyDoubleQuote]Manipulate\[CloseCurlyDoubleQuote]ing a plot will help \
you find this....]"
}], "Text",
 CellChangeTimes->{{3.653313737188293*^9, 3.6533138463528633`*^9}, {
  3.653315558879019*^9, 3.653315559584269*^9}, {3.685363797849504*^9, 
  3.685363825897848*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Finding maxima and minima of multi-variable real-valued functions.\
\>", "Subsection",
 CellChangeTimes->{{3.653313866481873*^9, 3.6533138755851307`*^9}, {
  3.653314813345276*^9, 3.653314817146056*^9}}],

Cell[TextData[{
 StyleBox["Examples",
  FontWeight->"Bold"],
 " of useful functions, using as an example function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", 
    FractionBox[
     RowBox[{"sin", "(", 
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       RowBox[{"2", 
        SuperscriptBox["y", "2"]}]}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       RowBox[{"2", 
        SuperscriptBox["y", "2"]}]}], ")"}]]}], TraditionalForm]]]
}], "Text",
 CellChangeTimes->{{3.6533140487797403`*^9, 3.653314124087159*^9}, {
  3.653314229265806*^9, 3.6533142322811213`*^9}, {3.65331480297339*^9, 
  3.653314807475033*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  FormBox[
   FractionBox[
    RowBox[{"Sin", "[", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      RowBox[{"2", 
       SuperscriptBox["y", "2"]}]}], "]"}], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      RowBox[{"2", 
       SuperscriptBox["y", "2"]}]}], ")"}]],
   TraditionalForm]}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["f", "x"], "=", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["f", "y"], " ", "=", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["f", "xx"], "=", 
  RowBox[{"D", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], 
    "\[IndentingNewLine]", ",", "x"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.653314149037901*^9, 3.6533142515701103`*^9}, {
  3.653314668648457*^9, 3.653314680366124*^9}, {3.6533150002134533`*^9, 
  3.6533150581342087`*^9}, {3.653315149846785*^9, 3.653315174155917*^9}, {
  3.653315787364633*^9, 3.653315806562262*^9}, {3.653315854384735*^9, 
  3.653315889568988*^9}, {3.6533159428756523`*^9, 3.6533160074337683`*^9}}],

Cell["\<\
\[LineSeparator]Evaluating some derivatives at (1,1): (adding a decimal point \
to one number will give you a numerical answer...)\
\>", "Text",
 CellChangeTimes->{{3.6533152542430353`*^9, 3.653315278439002*^9}}],

Cell[BoxData[{
 RowBox[{
  SubscriptBox["f", "x"], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1"}], ",", 
    RowBox[{"y", "\[Rule]", "1."}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["f", "xx"], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1"}], ",", 
    RowBox[{"y", "\[Rule]", "1."}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.653315141625517*^9, 3.6533151421718884`*^9}, {
  3.6533151780604477`*^9, 3.6533152302050657`*^9}, {3.653315818982649*^9, 
  3.6533158278546343`*^9}, {3.653315912145105*^9, 3.653315932754919*^9}}],

Cell["\[LineSeparator]Finding the solution to two equations simultaneously:", \
"Text",
 CellChangeTimes->{{3.65331449961596*^9, 3.653314516309226*^9}, 
   3.6533149213449793`*^9}],

Cell[BoxData[
 RowBox[{"Solve", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"3", "y"}]}], "\[Equal]", "8"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "x"}], "-", "y"}], "\[Equal]", "2"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.653314519722756*^9, 3.653314598631989*^9}}],

Cell["\[LineSeparator]Visualizations", "Text",
 CellChangeTimes->{{3.6533149096697893`*^9, 3.653314919276786*^9}}],

Cell[BoxData[{
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "5"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "5"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "0.5"}], ",", "1.5"}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "5"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.65331471530379*^9, 3.653314741658917*^9}, {
  3.653314771942689*^9, 3.6533147793112183`*^9}}],

Cell[TextData[StyleBox["Exercise 2", "Subsubsection"]], "Text",
 CellChangeTimes->{{3.653308829116776*^9, 3.65330883129976*^9}, {
  3.653314970617481*^9, 3.6533149708493977`*^9}}],

Cell[TextData[{
 "Find all the maxima, minima, or saddlepoints of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     SuperscriptBox["x", "3"], "+", 
     SuperscriptBox["y", "3"], "-", 
     RowBox[{"12", "x", " ", "y"}]}]}], TraditionalForm]]],
 " on the square interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "\[LessEqual]", "x", "\[LessEqual]", "5"}], ",", 
    RowBox[{
     RowBox[{"-", "1"}], "\[LessEqual]", "y", "\[LessEqual]", "5"}]}], 
   TraditionalForm]]],
 ". Include the 2nd derivative test. Display Plot3D and ContourPlot \
\[OpenCurlyQuote]s of this function."
}], "Text",
 CellChangeTimes->{{3.545095629747755*^9, 3.5450956759263964`*^9}, {
   3.545095853127532*^9, 3.5450958811421337`*^9}, {3.5450959163891497`*^9, 
   3.54509591639015*^9}, {3.54509609629144*^9, 3.5450961583339887`*^9}, {
   3.545096393947465*^9, 3.5450963943504877`*^9}, {3.5450967799885454`*^9, 
   3.545096784251789*^9}, 3.5450969461460485`*^9, {3.6533139622917833`*^9, 
   3.653313995074417*^9}, {3.653315371860608*^9, 3.653315372482273*^9}, {
   3.6533154309024067`*^9, 3.653315471907645*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{740, 867},
WindowMargins->{{4, Automatic}, {Automatic, 4}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"11.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (July 28, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 99, 1, 64, "Section"],
Cell[CellGroupData[{
Cell[703, 27, 165, 3, 44, "Subsection"],
Cell[871, 32, 893, 23, 50, "Text"],
Cell[CellGroupData[{
Cell[1789, 59, 733, 21, 96, "Input"],
Cell[2525, 82, 6480, 117, 234, "Output"],
Cell[9008, 201, 2841, 58, 234, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11886, 264, 837, 24, 75, "Input"],
Cell[12726, 290, 383, 9, 32, "Output"],
Cell[13112, 301, 365, 8, 32, "Output"],
Cell[13480, 311, 319, 6, 32, "Output"]
}, Open  ]],
Cell[13814, 320, 317, 8, 29, "Text"],
Cell[CellGroupData[{
Cell[14156, 332, 216, 5, 54, "Input"],
Cell[14375, 339, 94, 1, 32, "Output"],
Cell[14472, 342, 111, 2, 32, "Output"]
}, Open  ]],
Cell[14598, 347, 420, 8, 101, "Text"],
Cell[15021, 357, 128, 1, 37, "Text"],
Cell[15152, 360, 646, 17, 52, "Text"],
Cell[15801, 379, 777, 21, 70, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16615, 405, 213, 4, 44, "Subsection"],
Cell[16831, 411, 698, 22, 56, "Text"],
Cell[17532, 435, 1456, 44, 171, "Input"],
Cell[18991, 481, 222, 4, 65, "Text"],
Cell[19216, 487, 586, 15, 54, "Input"],
Cell[19805, 504, 180, 3, 47, "Text"],
Cell[19988, 509, 484, 14, 96, "Input"],
Cell[20475, 525, 114, 1, 47, "Text"],
Cell[20592, 528, 1176, 37, 75, "Input"],
Cell[21771, 567, 179, 2, 37, "Text"],
Cell[21953, 571, 1198, 29, 68, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

