<?php $classpath="/213/"; include "../classes/1.h"; ?>
<title>
Problem writeups
</title>
<meta name="week" content="">
<?php include "../classes/2.h" ?>
<h2>Problem writeups</h2>

<p>Advantages of writing -- <i>even</i> in the sciences:<br>
By having to explain your reasoning in more detail than is usually necessary for homework, you will frequently find you need to understand what's going on in more detail, and reveal heretofore unconscious assumptions and insights.  Or, your instructor may find this out from what you write!

<p>We will do two (or at least one)  of these short writing assignments.  When choosing a problem, </p>
<ul><li>Pick one ** problem,  or one *** problem,  or (one 0 and one * problem) from chapter 2.
<li>Not problems that were assigned for another purpose.
<li>Pick your own problem: No two people will work the same problem.
  You *may* consult other people about your problem. 
</ul>

<p>You'll use Mathematica to write up a solution with
  equations, diagrams as appropriate, and text which explains the approach you
  took to the problem, and references the physical principles you're using. See notes on <a href="http://www.goshen.edu/physix/mathphys/gco/Mathematica.php#documents">Mathematica documents</a>.  

<p>Like
  (some) writing assignments from other classes, you'll hand in a first draft
  of this, and after feedback, a final draft. The rubric used to grade this comprises
  these categories:</p>
<ul>
  <li><b>Exposition of the problem</b> - It is easy to do well on this category:  <ul><li>Copy out the statement of the problem exactly and
    <li>use a different font (e.g. bold or italic) to visually distinguish the specification
    of the problem from your work.

<li> Label the problem exposition with chapter and problem number.</ul><br />
    <br />
  </li>
  <li><b>Diagrams and plots</b> - Use a diagram to sketch out the physical system if appropriate,
    and label the names of quantities (angles, coordinates, etc). You may
    hand draw this! Include plots of functions as appropriate, for example to
    indicate maxima or minima, or equipotentials, or a potential energy surface,
    or otherwise enlighten the problem in some way.<br />
    <br />
  </li>
  <li><b>Grammar and spelling </b>-  In addition to following general rules of spelling and grammar, these specific issues crop up in our context:
<ul><li>Use a more formal voice than when speaking,
    e.g. &quot;a maxima&quot; not &quot;a max&quot;, &quot;substitute in&quot; rather than &quot;plug in&quot;. <li>
You should punctuate equations as if
    they were any other part of your writing: periods or commas frequently go
    at the end of a displayed equation.</ul><br />
    <br />
  </li>
  <li><b>Correctness of your solution</b> - Gotta make sure you do the problem
    right! 
See if you can include some sort of &quot;sanity check&quot; on your results as you
    go along:  For example, an order-of-magnitude estimation of the answer by some other means.<br />
    <br />
  </li>
  <li><b>Clarity of narration</b> - Think of your audience as other students
    in this class, with some general familiarity with the material. Name the
    principles and techniques you're using to solve the problem at each section
    of your problem. You may refer to equations in the textbook: give some context
    to say where such an equation comes from. <br />
<br />
  </li>

<li><b>Context</b> &amp; motivation - Why should we care about your problem? What principal of QM does your problem illustrate? <br /><br />

  <li><b>Math typesetting / notation</b> - <ul>
<li> Use real subscripts (not t0 when you
    mean $t_0$). 
<li>Figure out how to get greek letters in Mathematica. (<span class="style1">Esc-a-esc</span>    results in $\alpha$. <span class="style1">Esc-q-esc</span> $\to \theta$.)
    <li>Distinguish visually between vector and scalar quantities: scalars are usually
    displayed as non-bold italic quantities (Mathematica should do this automatically
    in math mode). Vector quantities are generally non-italic, and either have
    a little arrow over them, e.g. $\myv{b}$, or else appear as bold face, e.g.
    $\bf{b}$. 
<li>Mathematica commands will generally appear as a monospaced font
    like this &quot;<tt>Plot[
    Sin[x],......]</tt>&quot; without
    you having to do anything special. 
<li>When displaying definite integrals, use
    the ' notation to distinguish between the integration variable and the integration
    limits, e.g. $$\int_{v_0}^{v(t)} \frac{dv'}{F(v')}.$$ 
<li>It may be useful to
    number equations to refer back to them later.   Or instead of numbering every equation, you could even hand-letter stars or other symbols beside the small number  of equations that you want to refer to in your text.

</li></ul>

</li>
</ul>







<?php include "../classes/3.h" ?>
