(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     55654,       1629]
NotebookOptionsPosition[     52290,       1523]
NotebookOutlinePosition[     52769,       1541]
CellTagsIndexPosition[     52726,       1538]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "01 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " intro / Vectors"
}], "Title",
 CellChangeTimes->{{3.543847653428233*^9, 3.5438476603879285`*^9}, {
  3.6078497124065657`*^9, 3.607849717847302*^9}}],

Cell["\<\
Submit your completed work by placing this file in your folder of \
GCFile:\\Classes\\MATH213.\
\>", "Text",
 CellChangeTimes->{{3.543847682631153*^9, 3.543847690566946*^9}, {
  3.5442904675915427`*^9, 3.5442905126305428`*^9}, {3.576350931148992*^9, 
  3.576350932625811*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Introduction"
}], "Section",
 CellChangeTimes->{{3.5438457632552347`*^9, 3.543845768166725*^9}}],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can be used like a calculator.  Place the cursor anywhere in the input \
cell below and press \[ShiftKey]-\[EnterKey] to execute the computation. \
Multiplication can be represented with an asterisk (*), the times symbol (\
\[Times]), or a blank space (\[SpaceKey]).  Exponentiation is represented \
with a carat (^). Standard operator precedence is follows (e.g., in the \
computation below, exponentiation is performed first, multiplication and \
division are performed next, and subtraction and addition are performed \
last). "
}], "Text",
 CellChangeTimes->{{3.5438457784317517`*^9, 3.543845787704679*^9}, {
   3.543845900260934*^9, 3.543845947008608*^9}, {3.543845979411848*^9, 
   3.543845988492756*^9}, {3.543846062781184*^9, 3.5438461601029153`*^9}, {
   3.543846220107915*^9, 3.5438462848593893`*^9}, {3.5438471896298575`*^9, 
   3.5438472422751217`*^9}, 3.543847420349927*^9, {3.543847511246016*^9, 
   3.5438475253914304`*^9}}],

Cell[BoxData[
 RowBox[{"4", "-", 
  RowBox[{"2.1", "*", 
   RowBox[{"3", "^", "2"}]}], "+", 
  RowBox[{"5", "/", "6"}]}]], "Input",
 CellChangeTimes->{{3.5438457934122496`*^9, 3.543845829886897*^9}, {
  3.5438461689778023`*^9, 3.5438461818180866`*^9}, {3.5438462629471984`*^9, 
  3.5438462675066547`*^9}, {3.543847180494944*^9, 3.5438471807499695`*^9}}],

Cell[TextData[{
 "Typically, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides exact answers.  Built in functions always begin with an uppercase \
letter and use square brackets (e.g., ",
 StyleBox["Cos[x]", "Input"],
 " rather than ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", "(", "x", ")"}], TraditionalForm]]],
 ")."
}], "Text",
 CellChangeTimes->{{3.543845874313339*^9, 3.543845891635071*^9}, {
  3.5438463350004034`*^9, 3.54384641447935*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{"Cos", "[", "Pi", "]"}], "+", "13"}], "]"}], "/", 
  RowBox[{"10", "^", "2"}]}]], "Input",
 CellChangeTimes->{{3.543845996674574*^9, 3.5438460370756135`*^9}, {
  3.5438463119520984`*^9, 3.5438463125191555`*^9}, {3.5438471285857534`*^9, 
  3.5438471440022955`*^9}}],

Cell[TextData[{
 "Numerical approximations can be obtained by using the ",
 StyleBox["N", "Input"],
 " function."
}], "Text",
 CellChangeTimes->{{3.5438464745093527`*^9, 3.543846494143316*^9}, {
  3.54384686852475*^9, 3.543846872285126*^9}, {3.54384694873277*^9, 
  3.5438469519170885`*^9}}],

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"Cos", "[", "Pi", "]"}], "+", "13"}], "]"}], "/", 
   RowBox[{"10", "^", "2"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.5438469317240696`*^9, {3.54384696693659*^9, 3.543846971393036*^9}, {
   3.5438471215690517`*^9, 3.5438471529481897`*^9}, {3.5438472706399574`*^9, 
   3.543847270783972*^9}}],

Cell["\<\
Numerical approximations can be obtained to however many digits are desired.\
\>", "Text",
 CellChangeTimes->{{3.543847018115708*^9, 3.543847049374833*^9}}],

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"Cos", "[", "Pi", "]"}], "+", "13"}], "]"}], "/", 
    RowBox[{"10", "^", "2"}]}], ",", "50"}], "]"}]], "Input",
 CellChangeTimes->{{3.543846998604757*^9, 3.543847010877984*^9}, {
  3.543847264495343*^9, 3.5438472648793817`*^9}}],

Cell["\<\
Typesetting of expressions is possible using the Basic Math Assistant Palette \
or special keys (e.g., a fraction is obtained with \[ControlKey]-/, the \
square root is obtained with \[ControlKey]-2, \[Pi] is obtained with \
\[EscapeKey] p \[EscapeKey], and exponentiation is obtained with \
\[ControlKey]-^). \
\>", "Text",
 CellChangeTimes->{{3.5438473052644196`*^9, 3.543847498419733*^9}, {
  3.5438475377126627`*^9, 3.5438475706279535`*^9}, {3.5438477501028996`*^9, 
  3.543847752943183*^9}}],

Cell[BoxData[
 FractionBox[
  SqrtBox[
   RowBox[{
    RowBox[{"Cos", "[", "\[Pi]", "]"}], "+", "13"}]], 
  SuperscriptBox["10", "2"]]], "Input",
 CellChangeTimes->{{3.5438470766895647`*^9, 3.5438471139122863`*^9}, {
  3.5438472811550093`*^9, 3.543847284723366*^9}, {3.5438473240212955`*^9, 
  3.543847328346728*^9}, {3.5438477259034796`*^9, 3.543847741160005*^9}}],

Cell["\<\
An equation can be solved exactly and/or with a numercal approximation.  \
\>", "Text",
 CellChangeTimes->{{3.543847819810215*^9, 3.543847833445932*^9}, {
  3.5438479348106213`*^9, 3.543848022364752*^9}, {3.5438485032719584`*^9, 
  3.543848504943791*^9}}],

Cell[BoxData[{
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"3", "x"}], "+", "1"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", "%", "]"}], "\[IndentingNewLine]", 
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"3", "x"}], "+", "1"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.5438478368898296`*^9, 3.543847885929654*^9}, {
  3.543847925494014*^9, 3.5438479286271915`*^9}, {3.5438485151377716`*^9, 
  3.5438485184104443`*^9}}],

Cell[TextData[{
 "Note that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a double equals sign (",
 StyleBox["==", "Input"],
 ") to represent the equality in an equation.  The single equals sign (",
 StyleBox["=", "Input"],
 ") is used to assign numbers and expressions to variables."
}], "Text",
 CellChangeTimes->{{3.5438480264011154`*^9, 3.543848099869934*^9}}],

Cell[BoxData[{
 RowBox[{"a", "=", 
  RowBox[{
   SuperscriptBox["x", "2"], "+", "x"}]}], "\[IndentingNewLine]", 
 RowBox[{"b", "=", 
  RowBox[{
   RowBox[{"2", "x"}], "+", "1"}]}], "\[IndentingNewLine]", 
 RowBox[{"c", "=", 
  RowBox[{"a", "+", "b"}]}]}], "Input",
 CellChangeTimes->{{3.543848118866014*^9, 3.5438481503525653`*^9}}],

Cell["\<\
Expressions that represent functions from real numbers to real numbers can be \
evaluated at a particular value, graphed, differentiated, and integrated.\
\>", "Text",
 CellChangeTimes->{{3.543848229150919*^9, 3.543848297753332*^9}, {
  3.5438485623710475`*^9, 3.5438485835279317`*^9}}],

Cell[BoxData[{
 RowBox[{"c", "/.", 
  RowBox[{"x", "\[Rule]", "1"}]}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"c", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "2"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"D", "[", 
  RowBox[{"c", ",", "x"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{"c", ",", "x"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{"c", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.5438483007854223`*^9, 3.543848384146406*^9}, {
  3.5438485866596184`*^9, 3.543848596954589*^9}}],

Cell[CellGroupData[{

Cell["Exercise 1", "Subsection",
 CellChangeTimes->{{3.543848529190366*^9, 3.543848532397045*^9}}],

Cell[TextData[{
 "Consider the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", 
    RowBox[{
     SuperscriptBox["x", "3"], "-", 
     RowBox[{"cos", "(", 
      RowBox[{"2", "x"}], ")"}]}]}], TraditionalForm]]],
 ".  Find the exact value and a numerical approximation of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "4", ")"}], TraditionalForm]]],
 ".  Graph ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]]],
 " on the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "2"}], "]"}], TraditionalForm]]],
 ".  Find ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "'"}], 
    RowBox[{"(", "x", ")"}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "2"}], "2"], 
    RowBox[{
     RowBox[{"f", "(", "x", ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]]],
 " ."
}], "Text",
 CellChangeTimes->{{3.543848544460839*^9, 3.54384854665162*^9}, {
  3.543848614069877*^9, 3.5438489371811056`*^9}, {3.5438494653751054`*^9, 
  3.543849467022105*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2", "Subsection",
 CellChangeTimes->{{3.543849497517105*^9, 3.543849500588105*^9}}],

Cell[TextData[{
 "Attempt to find an approximate solution to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", "0"}], TraditionalForm]]],
 " using the ",
 StyleBox["NSolve", "Input"],
 " function.  "
}], "Text",
 CellChangeTimes->{{3.543849503918105*^9, 3.5438497328441057`*^9}, 
   3.5438497678611054`*^9}],

Cell[TextData[{
 "When that does not work, place the cursor on ",
 StyleBox["NSolve", "Input"],
 " and press the ",
 Cell[BoxData[
  FormBox["F1", TraditionalForm]]],
 " key or select Help | Find Selected Function.  This should open a help page \
on NSolve.  Notice the numerous examples showing how to use the NSolve \
function.  Click on the ",
 Cell[BoxData[
  FormBox[
   FrameBox[
    RowBox[{
     RowBox[{"See", " ", "Also"}], " ", ">>"}]], TraditionalForm]]],
 "  button and explore until you find a function that can find an approximate \
solution to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", "0"}], TraditionalForm]]],
 ".  Do it!"
}], "Text",
 CellChangeTimes->{{3.5438497719661055`*^9, 3.5438499613981056`*^9}, {
  3.543850058524105*^9, 3.543850063397105*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vectors in the Plane", "Section",
 CellChangeTimes->{{3.543844327991749*^9, 3.543844329173684*^9}, {
  3.5438513565971055`*^9, 3.5438513585001054`*^9}}],

Cell[TextData[{
 "A ",
 StyleBox["point",
  FontSlant->"Italic"],
 " is a location in some space.  A point in ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "n"], TraditionalForm]]],
 " is located by a list of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]]],
 " numbers.  For example, we may write ",
 Cell[BoxData[
  FormBox[
   RowBox[{"P", "=", 
    RowBox[{"(", 
     RowBox[{"1", ",", "3"}], ")"}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", "=", 
    RowBox[{"(", 
     RowBox[{"2", ",", "1"}], ")"}]}], TraditionalForm]]],
 " to locate two points ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]]],
 " in ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "2"], TraditionalForm]]],
 ".  In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", we can assign to a variable a list of numbers.  Since ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses parentheses to group together parts of arithmetic expressions, it \
uses braces to indicate the beginning and ending of a list.  Since ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " begins its built in names with a uppercase letter, I usually use names \
that begin with a lowercase letter, which is why I used lowercase p rather \
than uppercase P."
}], "Text",
 CellChangeTimes->{{3.5438443368317857`*^9, 3.543844343169077*^9}, {
  3.543844444557745*^9, 3.5438446898896766`*^9}, {3.5438504266071053`*^9, 
  3.5438506540371056`*^9}, {3.544174725940756*^9, 3.5441747626588564`*^9}, {
  3.544224200660205*^9, 3.5442242191982656`*^9}}],

Cell[BoxData[{
 RowBox[{"p", "=", 
  RowBox[{"{", 
   RowBox[{"1", ",", "3"}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"q", "=", 
  RowBox[{"{", 
   RowBox[{"2", ",", "1"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.5438446925328836`*^9, 3.543844696905571*^9}, {
  3.5442242275987463`*^9, 3.5442242349901686`*^9}}],

Cell["Points can be graphed.", "Text",
 CellChangeTimes->{{3.5438508828371058`*^9, 3.5438508943161054`*^9}, {
  3.5442242412415266`*^9, 3.5442242455787745`*^9}}],

Cell[BoxData[
 RowBox[{"plot1", "=", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Point", "[", "p", "]"}], ",", 
      RowBox[{"Point", "[", "q", "]"}]}], "}"}], ",", 
    RowBox[{"Axes", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "4"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5438506688741055`*^9, 3.5438506860301056`*^9}, 
   3.5438512618321056`*^9, {3.544224251114091*^9, 3.5442242580404873`*^9}, {
   3.544224512424037*^9, 3.5442245150291862`*^9}}],

Cell["\<\
Here is one way to add to the graph a line that passes through the two points.\
\>", "Text",
 CellChangeTimes->{{3.544224563110936*^9, 3.544224592711629*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"plot2", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "t"}], ")"}], "p"}], "+", 
      RowBox[{"t", " ", "q"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plot1", ",", "plot2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5442243257103577`*^9, 3.5442243275244617`*^9}, {
  3.544224424508009*^9, 3.5442245415967054`*^9}}],

Cell[TextData[{
 "A ",
 StyleBox["vector",
  FontSlant->"Italic"],
 " is a list of two points.  For example, if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"P", "=", 
    RowBox[{"(", 
     RowBox[{"1", ",", "3"}], ")"}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", "=", 
    RowBox[{"(", 
     RowBox[{"2", ",", "1"}], ")"}]}], TraditionalForm]]],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox[
     StyleBox["PQ",
      FontSlant->"Italic"], "\[RightVector]"], "=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", ",", "3"}], ")"}], ",", 
      RowBox[{"(", 
       RowBox[{"2", ",", "1"}], ")"}]}], ")"}]}], TraditionalForm]]],
 ". The first point is the ",
 StyleBox["base",
  FontSlant->"Italic"],
 " or ",
 StyleBox["tail",
  FontSlant->"Italic"],
 " and the second point is the ",
 StyleBox["head",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.5438509068841057`*^9, 3.543850968852105*^9}, {
  3.5442225089204435`*^9, 3.544222591369159*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"q", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  OverscriptBox["pq", "\[RightVector]"], "=", 
  RowBox[{"{", 
   RowBox[{"p", ",", "q"}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Point", "[", "p", "]"}], ",", 
     RowBox[{"Point", "[", "q", "]"}], ",", 
     RowBox[{"Arrow", "[", 
      OverscriptBox["pq", "\[RightVector]"], "]"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", "4"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.543845752969206*^9, 3.5438457531662254`*^9}, {
  3.5438510310141053`*^9, 3.5438512434341054`*^9}, {3.544290754148543*^9, 
  3.5442907733255424`*^9}}],

Cell[TextData[{
 "The components of a vector ",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    StyleBox["PQ",
     FontSlant->"Italic"], "\[RightVector]"], TraditionalForm]]],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"P", "=", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["a", "1"], ",", 
      SubscriptBox["b", "1"]}], ")"}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", "=", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["a", "2"], ",", 
      SubscriptBox["b", "2"]}], ")"}]}], TraditionalForm]]],
 ", are the quantities ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["v",
     FontWeight->"Bold"], "=", 
    RowBox[{
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{"a", ",", "b"}], "\[RightAngleBracket]"}], "=", 
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       RowBox[{
        SubscriptBox["a", "2"], "-", 
        SubscriptBox["a", "1"]}], ",", 
       RowBox[{
        SubscriptBox["b", "2"], "-", 
        SubscriptBox["b", "1"]}]}], "\[RightAngleBracket]"}]}]}], 
   TraditionalForm]]],
 ", and the length of ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["PQ", "\[RightVector]"], TraditionalForm]]],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"||", 
     OverscriptBox["PQ", "\[RightVector]"], "||"}], "=", 
    RowBox[{
     RowBox[{"||", 
      StyleBox["v",
       FontWeight->"Bold"], "||"}], "=", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox["b", "2"]}]]}]}], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.5438518459167204`*^9, 3.5438520629071054`*^9}, {
  3.5442223782909718`*^9, 3.5442223910797033`*^9}, {3.544222429887923*^9, 
  3.544222438180397*^9}, {3.544222625323101*^9, 3.5442226489334517`*^9}, {
  3.5442227018684793`*^9, 3.544222934969812*^9}}],

Cell[BoxData[{
 OverscriptBox["pq", "\[RightVector]"], "\[IndentingNewLine]", 
 RowBox[{"v", "=", 
  RowBox[{
   RowBox[{"Last", "[", 
    OverscriptBox["pq", "\[RightVector]"], "]"}], "-", 
   RowBox[{"First", "[", 
    OverscriptBox["pq", "\[RightVector]"], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Norm", "[", "v", "]"}]}], "Input",
 CellChangeTimes->{{3.5438521089161053`*^9, 3.5438521268241053`*^9}, {
  3.5438522161011057`*^9, 3.543852217432105*^9}, {3.5438522700931053`*^9, 
  3.5438522734101057`*^9}, {3.5438523901731052`*^9, 3.5438523912041054`*^9}, {
  3.5442216308422203`*^9, 3.544221631000229*^9}, {3.544222944277344*^9, 
  3.5442229968923535`*^9}}],

Cell[TextData[{
 "In comparison with ",
 Cell[BoxData[
  OverscriptBox["pq", "\[RightVector]"]],
  CellChangeTimes->{{3.5438521089161053`*^9, 3.5438521268241053`*^9}, {
   3.5438522161011057`*^9, 3.543852217432105*^9}, {3.5438522700931053`*^9, 
   3.5438522734101057`*^9}, {3.5438523901731052`*^9, 
   3.5438523912041054`*^9}, {3.5442216308422203`*^9, 3.544221631000229*^9}}],
 ", ",
 Cell[BoxData[Cell[TextData[Cell[BoxData[
   FormBox[
    OverscriptBox["ov", "\[RightVector]"], TraditionalForm]]]]]],
  CellChangeTimes->{{3.5438522775561056`*^9, 3.5438522805451055`*^9}, {
   3.5438524037731056`*^9, 3.5438524571061053`*^9}, {3.5442217005952096`*^9, 
   3.5442217156510706`*^9}, {3.544221754410288*^9, 3.5442217545142937`*^9}, {
   3.5442217924584637`*^9, 3.5442217975907574`*^9}, {3.5442219737508335`*^9, 
   3.5442220255067935`*^9}, {3.544222059754752*^9, 3.5442220978849335`*^9}}],
 " is the equivalent vector with base at the origin, ",
 Cell[BoxData[
  OverscriptBox["av", "\[RightVector]"]],
  CellChangeTimes->{{3.5438522775561056`*^9, 3.5438522805451055`*^9}, {
   3.5438524037731056`*^9, 3.5438524571061053`*^9}, {3.5442217005952096`*^9, 
   3.5442217156510706`*^9}, {3.544221754410288*^9, 3.5442217545142937`*^9}, {
   3.5442217924584637`*^9, 3.5442217975907574`*^9}, {3.5442219737508335`*^9, 
   3.5442220255067935`*^9}, {3.544222059754752*^9, 3.5442220978849335`*^9}}],
 " is an equivalent vector that does not have its base at the origin, ",
 Cell[BoxData[
  OverscriptBox["bv", "\[RightVector]"]],
  CellChangeTimes->{{3.5438522775561056`*^9, 3.5438522805451055`*^9}, {
   3.5438524037731056`*^9, 3.5438524571061053`*^9}, {3.5442217005952096`*^9, 
   3.5442217156510706`*^9}, {3.544221754410288*^9, 3.5442217545142937`*^9}, {
   3.5442217924584637`*^9, 3.5442217975907574`*^9}, {3.5442219737508335`*^9, 
   3.5442220255067935`*^9}, {3.544222059754752*^9, 3.5442220978849335`*^9}}],
 " is a parallel vector that is not equivalent."
}], "Text",
 CellChangeTimes->{{3.5438524789801054`*^9, 3.5438525156921053`*^9}, {
  3.544222129907765*^9, 3.5442222970933275`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"o", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";", 
  RowBox[{
   OverscriptBox["ov", "\[RightVector]"], "=", 
   RowBox[{"{", 
    RowBox[{"o", ",", "v"}], "}"}]}], ";", 
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "1"}], "}"}]}], ";", 
  RowBox[{
   OverscriptBox["av", "\[RightVector]"], "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"a", "+", "v"}]}], "}"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], ";", 
  RowBox[{
   OverscriptBox["bv", "\[RightVector]"], "=", 
   RowBox[{"{", 
    RowBox[{"b", ",", 
     RowBox[{"b", "-", "v"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Arrow", "[", 
      OverscriptBox["pq", "\[RightVector]"], "]"}], ",", 
     RowBox[{"Arrow", "[", 
      OverscriptBox["ov", "\[RightVector]"], "]"}], ",", 
     RowBox[{"Arrow", "[", 
      OverscriptBox["av", "\[RightVector]"], "]"}], ",", 
     RowBox[{"Arrow", "[", 
      OverscriptBox["bv", "\[RightVector]"], "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "4"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.5438522775561056`*^9, 3.5438522805451055`*^9}, {
  3.5438524037731056`*^9, 3.5438524571061053`*^9}, {3.5442217005952096`*^9, 
  3.5442217156510706`*^9}, {3.544221754410288*^9, 3.5442217545142937`*^9}, {
  3.5442217924584637`*^9, 3.5442217975907574`*^9}, {3.5442219737508335`*^9, 
  3.5442220255067935`*^9}, {3.544222059754752*^9, 3.5442220978849335`*^9}}],

Cell[TextData[{
 "The following commands draw a vector ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 ", a vector ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 ", a vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"a", " ", 
     StyleBox["u",
      FontWeight->"Bold"]}], "+", 
    RowBox[{"b", " ", 
     StyleBox["v",
      FontWeight->"Bold"]}]}], TraditionalForm]]],
 ", and an ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]]],
 " by ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]]],
 " grid of vectors equivalent to ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.544223090475706*^9, 3.5442232573232493`*^9}, {
  3.5442233666275015`*^9, 3.5442233763430567`*^9}, {3.5442248261229796`*^9, 
  3.544224831464285*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], ";", 
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", "2"}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m", "=", "3"}], ";", 
  RowBox[{"n", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"o", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g0", "=", 
   RowBox[{"{", 
    RowBox[{"Dotted", ",", 
     RowBox[{"Arrowheads", "[", "0.02", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"i", "-", "1"}], ")"}], "u"}], "+", 
         RowBox[{"j", " ", "v"}]}], ",", 
        RowBox[{
         RowBox[{"i", " ", "u"}], "+", 
         RowBox[{"j", " ", "v"}]}]}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{
        RowBox[{"-", "m"}], "+", "1"}], ",", "m"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"-", "n"}], ",", "n"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"i", " ", "u"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"j", "-", "1"}], ")"}], " ", "v"}]}], ",", 
        RowBox[{
         RowBox[{"i", " ", "u"}], "+", 
         RowBox[{"j", " ", "v"}]}]}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"-", "m"}], ",", "m"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{
        RowBox[{"-", "n"}], "+", "1"}], ",", "n"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Dashing", "[", 
      RowBox[{"{", "}"}], "]"}], ",", "Thick", ",", 
     RowBox[{"Arrowheads", "[", "0.03", "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<u\>\"", ",", "Larger", ",", "Bold"}], "]"}], ",", 
       RowBox[{"1.1", "u"}], ",", 
       RowBox[{"Background", "\[Rule]", "White"}]}], "]"}], ",", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{"o", ",", "u"}], "}"}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<v\>\"", ",", "Larger", ",", "Bold"}], "]"}], ",", 
       RowBox[{"1.1", "v"}], ",", 
       RowBox[{"Background", "\[Rule]", "White"}]}], "]"}], ",", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{"o", ",", "v"}], "}"}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<au+bv\>\"", ",", "Larger", ",", "Bold"}], "]"}], ",", 
       RowBox[{"1.1", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "u"}], "+", 
          RowBox[{"b", " ", "v"}]}], ")"}]}], ",", 
       RowBox[{"Background", "\[Rule]", "White"}]}], "]"}], ",", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{"o", ",", 
        RowBox[{
         RowBox[{"a", " ", "u"}], "+", 
         RowBox[{"b", " ", "v"}]}]}], "}"}], "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"plot3", "=", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{"g0", ",", "g1", ",", "g2", ",", "g3"}], "]"}], ",", 
    RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.5442190062761035`*^9, 3.54421918209816*^9}, {
  3.5442192202393417`*^9, 3.544219267180026*^9}, {3.5442194526836367`*^9, 
  3.544219467715496*^9}, {3.54421954908315*^9, 3.5442195647950487`*^9}, {
  3.544219611381714*^9, 3.5442196399343467`*^9}, {3.5442196897971983`*^9, 
  3.5442197131595345`*^9}, {3.544220173364857*^9, 3.544220247321087*^9}, {
  3.5442202802099686`*^9, 3.5442202893904934`*^9}, {3.5442204107564354`*^9, 
  3.544220534654522*^9}, {3.5442205901266947`*^9, 3.5442206264927745`*^9}, {
  3.544220825237142*^9, 3.5442208344136667`*^9}, {3.5442209296611147`*^9, 
  3.544220943602912*^9}, {3.5442210092456665`*^9, 3.5442211137646446`*^9}, {
  3.5442211553880253`*^9, 3.54422119883051*^9}, {3.5442213360443583`*^9, 
  3.5442213850671625`*^9}, {3.544224690370215*^9, 3.544224692711349*^9}}],

Cell[CellGroupData[{

Cell["Exercise 3", "Subsection",
 CellChangeTimes->{{3.5442233059790325`*^9, 3.544223308328167*^9}}],

Cell[TextData[{
 "Choose a variety of values for u, v, a, b, m, and n in the above commands \
to investigate the following.  Give a precise geometric description of the \
relationship among the vectors ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"a", " ", 
     StyleBox["u",
      FontWeight->"Bold"]}], "+", 
    RowBox[{"b", " ", 
     StyleBox["v",
      FontWeight->"Bold"]}]}], TraditionalForm]]],
 ".  State what choices of ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 " it would ",
 StyleBox["not",
  FontVariations->{"Underline"->True}],
 " be possible to obtain all vectors (with base at the origin) as a linear \
combination of ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.544223401344487*^9, 3.5442235161610537`*^9}, {
  3.544223719911708*^9, 3.544223721726812*^9}, {3.544284938247917*^9, 
  3.544284965339917*^9}, {3.5442850077469177`*^9, 3.544285256275917*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4", "Subsection",
 CellChangeTimes->{{3.54422479886242*^9, 3.5442248007985315`*^9}}],

Cell[TextData[{
 "Add a line passing through ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 " to the previous graph.  Do not change the above commands.  Enter commands \
below that create a graph of the line and then shows both graphs together."
}], "Text",
 CellChangeTimes->{{3.544224854230587*^9, 3.5442249854930954`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vectors in Three Dimensions", "Section",
 CellChangeTimes->{{3.5442238479500313`*^9, 3.5442238547164183`*^9}}],

Cell[TextData[{
 "The default style is to show the bounding box with the axes along three of \
the edges: x is downward right diagonal, y is upward right diagonal, and z is \
upward vertical.  Use the mouse to obtain different viewpoints.  Dragging \
from side to side moves the graphic around the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " axis, while dragging up and down makes the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " axis tumble.  Pressing ",
 StyleBox["Ctrl", "KeyEvent"],
 " while dragging up and down zooms in and out. Pressing ",
 StyleBox["Shift", "KeyEvent"],
 " while dragging pans in the direction of the drag."
}], "Text",
 CellChangeTimes->{{3.5442798077017655`*^9, 3.5442799857195654`*^9}, {
  3.5442804330354223`*^9, 3.5442804505716257`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0", ",", "1"}], "}"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "5"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5442797303350296`*^9, 3.5442797764856443`*^9}, {
  3.5442853648379173`*^9, 3.5442853678059177`*^9}}],

Cell["\<\
The ability to visualize is helped with the judicious use of some options. \
\>", "Text",
 CellChangeTimes->{{3.5442808929752936`*^9, 3.544280909380012*^9}, {
  3.544280981245636*^9, 3.54428100508531*^9}}],

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "0.02", "]"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.544185944353037*^9, 3.544186033896757*^9}, {
   3.5441861941875553`*^9, 3.544186202121267*^9}, {3.54418626573149*^9, 
   3.5441863445086455`*^9}, {3.5441863847017546`*^9, 
   3.5441863903770638`*^9}, {3.5441864579442863`*^9, 
   3.5441864602744117`*^9}, {3.544186498577087*^9, 3.544186516493019*^9}, {
   3.5441865735936832`*^9, 3.544186595082576*^9}, {3.5441866658279667`*^9, 
   3.544186670575291*^9}, {3.5441870060356073`*^9, 3.5441870139341154`*^9}, {
   3.5441917533639455`*^9, 3.5441917631951585`*^9}, {3.544279704248421*^9, 
   3.544279762364232*^9}, {3.544280608871028*^9, 3.5442806573883233`*^9}, {
   3.544280714703955*^9, 3.544280730195856*^9}, {3.544280795016889*^9, 
   3.5442808188851147`*^9}, 3.544280871105668*^9, {3.544280939100067*^9, 
   3.5442809600548754`*^9}, {3.544285372214917*^9, 3.544285372582917*^9}, {
   3.5442899847565427`*^9, 3.544289987491543*^9}}],

Cell["\<\
Here are two functions that helped my ability to visualize.  myAxis returns \
graphic primitives that create an axis in the given component direction with \
the given label in the given color from lo to hi; the axis is dashed for \
negative values.  myPoint includes dashed lines indicating how one might plot \
the point by hand.  (You do not need to understand all of this code.)\
\>", "Text",
 CellChangeTimes->{{3.54428118967031*^9, 3.544281438904513*^9}, {
  3.5442900732715425`*^9, 3.5442900930145426`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"myAxis", "[", 
    RowBox[{
    "label_", ",", "color_", ",", "component_", ",", "lo_", ",", "hi_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e", ",", "g", ",", "o"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"o", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";", 
      RowBox[{"e", "=", "o"}], ";", 
      RowBox[{
       RowBox[{
       "e", "\[LeftDoubleBracket]", "component", "\[RightDoubleBracket]"}], 
       "=", "1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"g", "=", 
       RowBox[{"{", 
        RowBox[{"color", ",", 
         RowBox[{"Text", "[", 
          RowBox[{"label", ",", 
           RowBox[{"1.05", " ", "hi", " ", "e"}]}], "]"}], ",", 
         RowBox[{"Arrowheads", "[", "0.02", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{"o", ",", 
            RowBox[{"hi", " ", "e"}]}], "}"}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"lo", "<", "0"}], ",", 
        RowBox[{"g", "=", 
         RowBox[{"Join", "[", 
          RowBox[{"g", ",", 
           RowBox[{"{", 
            RowBox[{"Dashed", ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"lo", " ", "e"}], ",", "o"}], "}"}], "]"}], ",", 
             RowBox[{"Dashing", "[", 
              RowBox[{"{", "}"}], "]"}]}], "}"}]}], "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", "g"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"myPoint", "[", 
    RowBox[{"p_", ",", "color_"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"color", ",", "Dashed", ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"p", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"p", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           ",", 
          RowBox[{"p", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
           ",", "0"}], "}"}], ",", "p"}], "}"}], "]"}], ",", 
     RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
     RowBox[{"Point", "[", "p", "]"}], ",", 
     RowBox[{"Dashing", "[", 
      RowBox[{"{", "}"}], "]"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.544260709698449*^9, 3.5442607186279593`*^9}, {
  3.54428111716831*^9, 3.5442811280423098`*^9}, {3.5442856744219174`*^9, 
  3.5442856853789177`*^9}, {3.5442900062835426`*^9, 3.544290041155543*^9}}],

Cell["\<\
The following command makes use of myAxis and myPoint and moves the view \
point so that the result is similar to what we did by hand.  You may want to \
change the colors to match your pipe cleaner axes.\
\>", "Text",
 CellChangeTimes->{{3.544281452649887*^9, 3.5442815308497066`*^9}, {
  3.5442865107203045`*^9, 3.544286530905323*^9}}],

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<x\>\"", ",", "Orange", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "7"}], "]"}], ",", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<y\>\"", ",", 
       RowBox[{"Darker", "[", "Yellow", "]"}], ",", "2", ",", 
       RowBox[{"-", "5"}], ",", "7"}], "]"}], ",", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<z\>\"", ",", "Green", ",", "3", ",", 
       RowBox[{"-", "9"}], ",", "8"}], "]"}], ",", 
     RowBox[{"myPoint", "[", 
      RowBox[{"a", ",", "Black"}], "]"}], ",", 
     RowBox[{"myPoint", "[", 
      RowBox[{"b", ",", "Black"}], "]"}]}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100", ",", "100"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.544188998883645*^9, 3.544189003768761*^9}, {
   3.5441897207364597`*^9, 3.5441897323461676`*^9}, {3.544190060055626*^9, 
   3.54419009446349*^9}, {3.5441901254087315`*^9, 3.5441901463092475`*^9}, {
   3.544190177415721*^9, 3.5441902335381937`*^9}, 3.5441902947152634`*^9, {
   3.5441904213970203`*^9, 3.5441904708429275`*^9}, {3.544191432467061*^9, 
   3.5441914326231127`*^9}, {3.544191466267708*^9, 3.544191473633315*^9}, 
   3.5441915498818345`*^9, {3.5441915858838005`*^9, 3.544191637041529*^9}, {
   3.5441952332194257`*^9, 3.5441952922172594`*^9}, {3.544227068842256*^9, 
   3.5442270705913563`*^9}, {3.544227108415519*^9, 3.544227136351117*^9}, {
   3.54422717940758*^9, 3.544227211334406*^9}, {3.544227258272091*^9, 
   3.5442272583830967`*^9}, {3.544264576475616*^9, 3.544264578367724*^9}, {
   3.544264611410614*^9, 3.5442647285733156`*^9}, {3.5442655755097575`*^9, 
   3.5442656265276756`*^9}, {3.544265668290064*^9, 3.5442656717772636`*^9}, {
   3.5442657178929014`*^9, 3.5442657435013657`*^9}, {3.5442683095971384`*^9, 
   3.544268333300494*^9}, {3.544268372027709*^9, 3.5442684125960293`*^9}, {
   3.544271170958799*^9, 3.5442711717258425`*^9}, {3.5442792389278936`*^9, 
   3.544279242872288*^9}, {3.544279277134714*^9, 3.5442792808680873`*^9}, {
   3.5442793221212125`*^9, 3.54427934140314*^9}, 3.54428111298731*^9, {
   3.544284734286769*^9, 3.544284743923805*^9}, 3.5442855942729177`*^9}],

Cell[CellGroupData[{

Cell["Exercise 5", "Subsection",
 CellChangeTimes->{{3.5442854817239175`*^9, 3.5442854844989176`*^9}}],

Cell[TextData[{
 "Add to the above graph the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"c", "=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], ",", 
      RowBox[{"-", "5"}], ",", 
      RowBox[{"-", "8"}]}], ")"}]}], TraditionalForm]]],
 " and the line segments ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["ab", "_"], TraditionalForm]],
  FontSlant->"Italic"],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox[
     StyleBox["bc",
      FontSlant->"Italic"], "_"],
    FontSlant->"Italic"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox[
     StyleBox["ca",
      FontSlant->"Italic"], "_"],
    FontSlant->"Italic"], TraditionalForm]]],
 ".  Explain in what way the hand sketch looks different and why."
}], "Text",
 CellChangeTimes->{{3.5442854998039174`*^9, 3.5442855312509174`*^9}, {
  3.5442857787319174`*^9, 3.5442859677640142`*^9}, {3.5442860469699345`*^9, 
  3.5442860929975367`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6", "Subsection",
 CellChangeTimes->{{3.5442864645226855`*^9, 3.5442864672429576`*^9}}],

Cell[TextData[{
 "Graph the three axes to match the view point given in this diagram.\n  ",
 Cell[BoxData[
  GraphicsBox[
   TagBox[RasterBox[CompressedData["
1:eJzt3D1PG1kYhuEj7TSUadIvHRX9dlugNFRu6OPCjaWVVoo0XSoXpN1iXbqI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     "], {{0, 193}, {224, 0}}, {0, 255},
     ColorFunction->RGBColor],
    BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
    Selectable->False],
   BaseStyle->"ImageGraphics",
   ImageSize->{123.99999999999967`, Automatic},
   ImageSizeRaw->{224, 193},
   PlotRange->{{0, 224}, {0, 193}}]],
  CellChangeTimes->{
   3.544195665069894*^9, {3.5441956963549113`*^9, 3.5441957758713474`*^9}, {
    3.5441958068765025`*^9, 3.544195821559396*^9}, {3.544195858774744*^9, 
    3.544195863362173*^9}}]
}], "Text",
 CellChangeTimes->{{3.5442864799402275`*^9, 3.544286487276961*^9}, {
  3.544286853217551*^9, 3.544286897661995*^9}, {3.5442869853037586`*^9, 
  3.5442870219774256`*^9}, {3.544287111396366*^9, 3.544287111803407*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Lines in Three Dimensions", "Section",
 CellChangeTimes->{{3.544287151727399*^9, 3.544287159864213*^9}, {
  3.544288306376198*^9, 3.544288308352*^9}}],

Cell[TextData[{
 "Graph the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["P", "0"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"3", ",", 
      RowBox[{"-", "1"}], ",", "4"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]]],
 ", the vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["v",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"2", ",", "1", ",", "7"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]]],
 " based at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "0"], TraditionalForm]]],
 ", and the line ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["r",
      FontWeight->"Bold"], "(", "t", ")"}], "=", 
    RowBox[{
     SubscriptBox["P", "0"], "+", 
     RowBox[{"t", " ", 
      StyleBox["v",
       FontWeight->"Bold"]}]}]}], TraditionalForm]]],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "2"}], "\[LessEqual]", "t", "\[LessEqual]", "2"}], 
   TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.544288320134822*^9, 3.5442886177455425`*^9}, {
  3.576569146254602*^9, 3.576569147550625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p0", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"-", "1"}], ",", "4"}], "}"}]}], ";", 
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "7"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Join", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<x\>\"", ",", "Orange", ",", "1", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<y\>\"", ",", 
       RowBox[{"Darker", "[", "Yellow", "]"}], ",", "2", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<z\>\"", ",", "Green", ",", "3", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Black", ",", 
       RowBox[{"PointSize", "[", "0.03", "]"}], ",", 
       RowBox[{"Point", "[", "p0", "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Arrowheads", "[", "0.03", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{"p0", ",", 
          RowBox[{"p0", "+", "v"}]}], "}"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"p0", "-", 
          RowBox[{"2", "v"}]}], ",", 
         RowBox[{"p0", "+", 
          RowBox[{"2", "v"}]}]}], "}"}], "]"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100", ",", "100"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.5442876980321083`*^9, 3.5442877389644356`*^9}, {
  3.5442877712138453`*^9, 3.5442877937340703`*^9}, {3.5442878481839285`*^9, 
  3.5442880899741387`*^9}, {3.5442881470197277`*^9, 3.5442881493382635`*^9}, {
  3.544290136093543*^9, 3.544290176029543*^9}, {3.5442902661325426`*^9, 
  3.544290269044543*^9}}],

Cell[TextData[{
 "Add the red point ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["r",
      FontWeight->"Bold"], "(", "t", ")"}], "=", 
    RowBox[{
     SubscriptBox["P", "0"], "+", 
     RowBox[{"t", " ", 
      StyleBox["v",
       FontWeight->"Bold"]}]}]}], TraditionalForm]]],
 " with ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]]],
 " controlled by a slider."
}], "Text",
 CellChangeTimes->{{3.5442886284225426`*^9, 3.544288684406543*^9}}],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"p0", "=", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       RowBox[{"-", "1"}], ",", "4"}], "}"}]}], ";", 
    RowBox[{"v", "=", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "7"}], "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Graphics3D", "[", 
     RowBox[{
      RowBox[{"Join", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"myAxis", "[", 
         RowBox[{"\"\<x\>\"", ",", "Orange", ",", "1", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"myAxis", "[", 
         RowBox[{"\"\<y\>\"", ",", 
          RowBox[{"Darker", "[", "Yellow", "]"}], ",", "2", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"myAxis", "[", 
         RowBox[{"\"\<z\>\"", ",", "Green", ",", "3", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"Black", ",", 
          RowBox[{"PointSize", "[", "0.03", "]"}], ",", 
          RowBox[{"Point", "[", "p0", "]"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Arrowheads", "[", "0.03", "]"}], ",", 
          RowBox[{"Arrow", "[", 
           RowBox[{"{", 
            RowBox[{"p0", ",", 
             RowBox[{"p0", "+", "v"}]}], "}"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"p0", "-", 
             RowBox[{"2", "v"}]}], ",", 
            RowBox[{"p0", "+", 
             RowBox[{"2", "v"}]}]}], "}"}], "]"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Point", "[", 
           RowBox[{"p0", "+", 
            RowBox[{"t", " ", "v"}]}], "]"}]}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Axes", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"100", ",", "100", ",", "100"}], "}"}]}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", "0"}], "}"}], ",", 
     RowBox[{"-", "2"}], ",", "2", ",", "0.1", ",", " ", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5442881789323435`*^9, 3.544288208242012*^9}, {
   3.544288244126423*^9, 3.5442882682520103`*^9}, 3.544289086103543*^9, {
   3.544289145983543*^9, 3.544289166919543*^9}, {3.544290213079543*^9, 
   3.5442902859135427`*^9}}],

Cell[CellGroupData[{

Cell["Exercise 7", "Subsection",
 CellChangeTimes->{{3.544289255654543*^9, 3.544289263358543*^9}}],

Cell[TextData[{
 "Choose a variety of values for ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]]],
 " in the above manipulator to investigate the following.  Give a precise \
geometric description of the vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["r",
      FontWeight->"Bold"], "(", "t", ")"}], "=", 
    RowBox[{
     SubscriptBox["P", "0"], "+", 
     RowBox[{"t", " ", 
      StyleBox["v",
       FontWeight->"Bold"]}]}]}], TraditionalForm]]],
 ". "
}], "Text",
 CellChangeTimes->{{3.5442892673215427`*^9, 3.5442892981835427`*^9}, {
  3.5442893996575427`*^9, 3.544289419817543*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8", "Subsection",
 CellChangeTimes->{{3.544289534902543*^9, 3.5442895364865427`*^9}}],

Cell[TextData[{
 "Graph the lines ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["r",
       FontWeight->"Bold"], "1"], "(", "t", ")"}], "=", 
    RowBox[{
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{"1", ",", "0", ",", "1"}], "\[RightAngleBracket]"}], "+", 
     RowBox[{"t", 
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{"3", ",", "3", ",", "5"}], "\[RightAngleBracket]"}]}]}]}], 
   TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["r",
       FontWeight->"Bold"], "2"], "(", "t", ")"}], "=", 
    RowBox[{
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{"3", ",", "6", ",", "1"}], "\[RightAngleBracket]"}], "+", 
     RowBox[{"t", 
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{"4", ",", 
        RowBox[{"-", "2"}], ",", "7"}], "\[RightAngleBracket]"}]}]}]}], 
   TraditionalForm]]],
 " in a manner that makes it clear that the two lines either do or do not \
intersect."
}], "Text",
 CellChangeTimes->{{3.544289548350543*^9, 3.5442896890385427`*^9}, 
   3.576569154150428*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{726, 719},
WindowMargins->{{213, Automatic}, {-57, Automatic}},
PrintingPageRange->{Automatic, Automatic},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, \
2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 224, 7, 92, "Title"],
Cell[806, 31, 286, 6, 30, "Text"],
Cell[CellGroupData[{
Cell[1117, 41, 164, 5, 80, "Section"],
Cell[1284, 48, 1007, 17, 125, "Text"],
Cell[2294, 67, 353, 7, 28, "Input"],
Cell[2650, 76, 464, 14, 50, "Text"],
Cell[3117, 92, 336, 8, 28, "Input"],
Cell[3456, 102, 291, 7, 31, "Text"],
Cell[3750, 111, 392, 10, 28, "Input"],
Cell[4145, 123, 166, 3, 30, "Text"],
Cell[4314, 128, 340, 9, 28, "Input"],
Cell[4657, 139, 506, 9, 68, "Text"],
Cell[5166, 150, 365, 8, 55, "Input"],
Cell[5534, 160, 265, 5, 30, "Text"],
Cell[5802, 167, 627, 18, 75, "Input"],
Cell[6432, 187, 378, 10, 51, "Text"],
Cell[6813, 199, 332, 9, 67, "Input"],
Cell[7148, 210, 296, 5, 49, "Text"],
Cell[7447, 217, 691, 18, 97, "Input"],
Cell[CellGroupData[{
Cell[8163, 239, 98, 1, 44, "Subsection"],
Cell[8264, 242, 1143, 42, 58, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9444, 289, 98, 1, 44, "Subsection"],
Cell[9545, 292, 337, 11, 31, "Text"],
Cell[9885, 305, 810, 23, 101, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10744, 334, 158, 2, 80, "Section"],
Cell[10905, 338, 1654, 50, 129, "Text"],
Cell[12562, 390, 316, 8, 46, "Input"],
Cell[12881, 400, 161, 2, 30, "Text"],
Cell[13045, 404, 519, 12, 28, "Input"],
Cell[13567, 418, 168, 3, 30, "Text"],
Cell[13738, 423, 573, 17, 46, "Input"],
Cell[14314, 442, 1038, 41, 54, "Text"],
Cell[15355, 485, 848, 22, 110, "Input"],
Cell[16206, 509, 1818, 64, 66, "Text"],
Cell[18027, 575, 665, 13, 69, "Input"],
Cell[18695, 590, 2080, 36, 55, "Text"],
Cell[20778, 628, 1656, 45, 93, "Input"],
Cell[22437, 675, 1007, 41, 51, "Text"],
Cell[23447, 718, 4607, 130, 233, "Input"],
Cell[CellGroupData[{
Cell[28079, 852, 100, 1, 44, "Subsection"],
Cell[28182, 855, 1406, 51, 90, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29625, 911, 99, 1, 44, "Subsection"],
Cell[29727, 914, 468, 14, 50, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30244, 934, 116, 1, 80, "Section"],
Cell[30363, 937, 818, 17, 108, "Text"],
Cell[31184, 956, 459, 12, 46, "Input"],
Cell[31646, 970, 215, 4, 30, "Text"],
Cell[31864, 976, 1630, 34, 63, "Input"],
Cell[33497, 1012, 523, 8, 87, "Text"],
Cell[34023, 1022, 2720, 72, 131, "Input"],
Cell[36746, 1096, 347, 6, 68, "Text"],
Cell[37096, 1104, 2312, 41, 80, "Input"],
Cell[CellGroupData[{
Cell[39433, 1149, 102, 1, 44, "Subsection"],
Cell[39538, 1152, 969, 35, 51, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40544, 1192, 102, 1, 44, "Subsection"],
Cell[40649, 1195, 3019, 55, 140, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43717, 1256, 156, 2, 80, "Section"],
Cell[43876, 1260, 1140, 44, 52, "Text"],
Cell[45019, 1306, 2106, 52, 165, "Input"],
Cell[47128, 1360, 473, 18, 32, "Text"],
Cell[47604, 1380, 2645, 67, 182, "Input"],
Cell[CellGroupData[{
Cell[50274, 1451, 98, 1, 44, "Subsection"],
Cell[50375, 1454, 621, 20, 52, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51033, 1479, 100, 1, 44, "Subsection"],
Cell[51136, 1482, 1114, 36, 51, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
