(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     20197,        623]
NotebookOptionsPosition[     18662,        568]
NotebookOutlinePosition[     19195,        587]
CellTagsIndexPosition[     19152,        584]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["02 Vector Operations", "Title",
 CellChangeTimes->{{3.544391134969587*^9, 3.5443911398658667`*^9}}],

Cell["\<\
Submit your completed work by placing this file in your folder of \
GCFile:\\Classes\\MATH213.\
\>", "Text",
 CellChangeTimes->{{3.543847682631153*^9, 3.543847690566946*^9}, {
  3.5442904675915427`*^9, 3.5442905126305428`*^9}, {3.576353741665018*^9, 
  3.57635374367957*^9}}],

Cell[CellGroupData[{

Cell["Computation", "Section",
 CellChangeTimes->{{3.5443911954340453`*^9, 3.544391201833411*^9}}],

Cell[TextData[{
 "Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "0", ",", "1"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["b",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"1", ",", "1", ",", "0"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]]],
 ".  Calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{"||", 
    StyleBox["a",
     FontWeight->"Bold"], "||"}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "\[CenterDot]", 
    StyleBox["b",
     FontWeight->"Bold"]}], TraditionalForm]]],
 ", the angle between ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["proj", 
     StyleBox["b",
      FontWeight->"Bold"]], "(", 
    StyleBox["a",
     FontWeight->"Bold"], ")"}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "\[Cross]", 
    StyleBox["b",
     FontWeight->"Bold"]}], TraditionalForm]]],
 ", and the unit vector ",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    StyleBox["a",
     FontWeight->"Bold"], "^"], TraditionalForm]]],
 ".  Each computation is done in two different ways.  \[LineSeparator](To get \
the cross product operator, you can either pick the smaller \
\[OpenCurlyDoubleQuote]\[Cross]\[CloseCurlyDoubleQuote] off the typesetting \
palette, or type \[EscapeKey] ",
 StyleBox["cross",
  FontFamily->"Courier New"],
 " \[EscapeKey].)"
}], "Text",
 CellChangeTimes->{{3.544391331030801*^9, 3.544391408961258*^9}, {
  3.544391543356945*^9, 3.5443915999081798`*^9}, {3.544391702073023*^9, 
  3.5443917213101234`*^9}, {3.5443918679255095`*^9, 3.5443918939419975`*^9}, {
  3.5443919570996103`*^9, 3.54439198629128*^9}, {3.544562041772868*^9, 
  3.5445620500053387`*^9}, {3.5445622777483644`*^9, 3.544562337163763*^9}, {
  3.544562367405493*^9, 3.544562367757513*^9}, {3.5888933448647213`*^9, 
  3.588893403365162*^9}, {3.607878299639065*^9, 3.607878390657113*^9}, {
  3.6078784284671507`*^9, 3.607878436323482*^9}, {3.607878492957548*^9, 
  3.607878502145116*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 SqrtBox[
  RowBox[{"a", ".", "a"}]], "\[IndentingNewLine]", 
 RowBox[{"Norm", "[", "a", "]"}], "\[IndentingNewLine]", 
 RowBox[{"a", ".", "b"}], "\[IndentingNewLine]", 
 RowBox[{"Dot", "[", 
  RowBox[{"a", ",", "b"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ArcCos", "[", 
  FractionBox[
   RowBox[{"a", ".", "b"}], 
   RowBox[{
    RowBox[{"Norm", "[", "a", "]"}], 
    RowBox[{"Norm", "[", "b", "]"}]}]], "]"}], "\[IndentingNewLine]", 
 RowBox[{"VectorAngle", "[", 
  RowBox[{"a", ",", "b"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  FractionBox[
   RowBox[{"a", ".", "b"}], 
   RowBox[{"b", ".", "b"}]], "b"}], "\[IndentingNewLine]", 
 RowBox[{"Projection", "[", 
  RowBox[{"a", ",", "b"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"a", "\[Cross]", "b"}], "\[IndentingNewLine]", 
 RowBox[{"Cross", "[", 
  RowBox[{"a", ",", "b"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"a", "/", 
  RowBox[{"Norm", "[", "a", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Normalize", "[", "a", "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5443912673101563`*^9, 3.544391272546456*^9}, {
   3.544391468546666*^9, 3.5443915327123365`*^9}, {3.5443916056495085`*^9, 
   3.5443916574254694`*^9}, {3.5443917281545153`*^9, 
   3.5443917319937344`*^9}, {3.5443917745971713`*^9, 3.544391821404849*^9}, 
   3.544391933586265*^9, {3.5445619431762285`*^9, 3.5445620074189034`*^9}, {
   3.5445621678480787`*^9, 3.5445622170788946`*^9}, 3.544562250631814*^9, {
   3.6078782718248262`*^9, 3.607878273624487*^9}, {3.607878329710154*^9, 
   3.6078783356430387`*^9}, {3.6078785161615553`*^9, 3.607878522354848*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphing", "Section",
 CellChangeTimes->{{3.5443956477557034`*^9, 3.5443956488747673`*^9}}],

Cell["\<\
Here are two functions that help my ability to visualize.  myAxis returns \
graphic primitives that create an axis in the given component direction with \
the given label in the given color from lo to hi; the axis is dashed for \
negative values.  myPoint includes dashed lines indicating how one might plot \
the point by hand and a label for the point.\
\>", "Text",
 CellChangeTimes->{{3.5443931462386246`*^9, 3.5443931949874134`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"myAxis", "[", 
    RowBox[{
    "label_", ",", "color_", ",", "component_", ",", "lo_", ",", "hi_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e", ",", "g", ",", "o"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"o", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";", 
      RowBox[{"e", "=", "o"}], ";", 
      RowBox[{
       RowBox[{
       "e", "\[LeftDoubleBracket]", "component", "\[RightDoubleBracket]"}], 
       "=", "1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"g", "=", 
       RowBox[{"{", 
        RowBox[{"color", ",", 
         RowBox[{"Text", "[", 
          RowBox[{"label", ",", 
           RowBox[{"1.05", " ", "hi", " ", "e"}]}], "]"}], ",", 
         RowBox[{"Arrowheads", "[", "0.02", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{"o", ",", 
            RowBox[{"hi", " ", "e"}]}], "}"}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"lo", "<", "0"}], ",", 
        RowBox[{"g", "=", 
         RowBox[{"Join", "[", 
          RowBox[{"g", ",", 
           RowBox[{"{", 
            RowBox[{"Dashed", ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"lo", " ", "e"}], ",", "o"}], "}"}], "]"}], ",", 
             RowBox[{"Dashing", "[", 
              RowBox[{"{", "}"}], "]"}]}], "}"}]}], "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", "g"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"myPoint", "[", 
    RowBox[{"p_", ",", "color_", ",", "label_"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"color", ",", 
     RowBox[{"Text", "[", 
      RowBox[{"label", ",", 
       RowBox[{"1.1", " ", "p"}]}], "]"}], ",", "Dashed", ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"p", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"p", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           ",", 
          RowBox[{"p", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
           ",", "0"}], "}"}], ",", "p"}], "}"}], "]"}], ",", 
     RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
     RowBox[{"Point", "[", "p", "]"}], ",", 
     RowBox[{"Dashing", "[", 
      RowBox[{"{", "}"}], "]"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.544260709698449*^9, 3.5442607186279593`*^9}, {
  3.54428111716831*^9, 3.5442811280423098`*^9}, {3.5442856744219174`*^9, 
  3.5442856853789177`*^9}, {3.5442900062835426`*^9, 3.544290041155543*^9}, {
  3.5443927636957445`*^9, 3.544392786886071*^9}, {3.544392851243752*^9, 
  3.5443928515137672`*^9}}],

Cell[TextData[{
 "Draw a graph of the points and vectors ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "\[Cross]", 
    StyleBox["b",
     FontWeight->"Bold"]}], TraditionalForm]]],
 " along with part of the plane determined by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.544393214601535*^9, 3.5443933354354467`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"o", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";", 
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], ";", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"myAxis", "[", 
       RowBox[{"\"\<x\>\"", ",", "Orange", ",", "1", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "]"}], ",", 
      RowBox[{"myAxis", "[", 
       RowBox[{"\"\<y\>\"", ",", 
        RowBox[{"Darker", "[", "Yellow", "]"}], ",", "2", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "]"}], ",", 
      RowBox[{"myAxis", "[", 
       RowBox[{"\"\<z\>\"", ",", "Green", ",", "3", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "]"}], ",", 
      RowBox[{"myPoint", "[", 
       RowBox[{"a", ",", "Black", ",", "\"\<a\>\""}], "]"}], ",", 
      RowBox[{"myPoint", "[", 
       RowBox[{"b", ",", "Black", ",", "\"\<b\>\""}], "]"}], ",", 
      RowBox[{"myPoint", "[", 
       RowBox[{
        RowBox[{"a", "\[Cross]", "b"}], ",", "Red", ",", 
        "\"\<a\[Cross]b\>\""}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"Black", ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{"o", ",", "a"}], "}"}], "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{"o", ",", "b"}], "}"}], "]"}], ",", "Red", ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{"o", ",", 
           RowBox[{"a", "\[Cross]", "b"}]}], "}"}], "]"}], ",", 
        RowBox[{"Opacity", "[", 
         RowBox[{"0.5", ",", "Blue"}], "]"}], ",", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{"a", ",", "b", ",", 
           RowBox[{"-", "a"}], ",", 
           RowBox[{"-", "b"}]}], "}"}], "]"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"Axes", "\[Rule]", "True"}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"100", ",", "100", ",", "100"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.544188998883645*^9, 3.544189003768761*^9}, {
   3.5441897207364597`*^9, 3.5441897323461676`*^9}, {3.544190060055626*^9, 
   3.54419009446349*^9}, {3.5441901254087315`*^9, 3.5441901463092475`*^9}, {
   3.544190177415721*^9, 3.5441902335381937`*^9}, 3.5441902947152634`*^9, {
   3.5441904213970203`*^9, 3.5441904708429275`*^9}, {3.544191432467061*^9, 
   3.5441914326231127`*^9}, {3.544191466267708*^9, 3.544191473633315*^9}, 
   3.5441915498818345`*^9, {3.5441915858838005`*^9, 3.544191637041529*^9}, {
   3.5441952332194257`*^9, 3.5441952922172594`*^9}, {3.544227068842256*^9, 
   3.5442270705913563`*^9}, {3.544227108415519*^9, 3.544227136351117*^9}, {
   3.54422717940758*^9, 3.544227211334406*^9}, {3.544227258272091*^9, 
   3.5442272583830967`*^9}, {3.544264576475616*^9, 3.544264578367724*^9}, {
   3.544264611410614*^9, 3.5442647285733156`*^9}, {3.5442655755097575`*^9, 
   3.5442656265276756`*^9}, {3.544265668290064*^9, 3.5442656717772636`*^9}, {
   3.5442657178929014`*^9, 3.5442657435013657`*^9}, {3.5442683095971384`*^9, 
   3.544268333300494*^9}, {3.544268372027709*^9, 3.5442684125960293`*^9}, {
   3.544271170958799*^9, 3.5442711717258425`*^9}, {3.5442792389278936`*^9, 
   3.544279242872288*^9}, {3.544279277134714*^9, 3.5442792808680873`*^9}, {
   3.5442793221212125`*^9, 3.54427934140314*^9}, 3.54428111298731*^9, {
   3.544284734286769*^9, 3.544284743923805*^9}, 3.5442855942729177`*^9, {
   3.544392168068677*^9, 3.5443921821414814`*^9}, {3.544392216013419*^9, 
   3.5443922258699827`*^9}, {3.5443922779179597`*^9, 
   3.5443922786930037`*^9}, {3.5443923417416105`*^9, 3.544392424318333*^9}, {
   3.544392455639125*^9, 3.5443925750439544`*^9}, {3.5443926174083776`*^9, 
   3.5443926738816075`*^9}, {3.5443928006498585`*^9, 3.5443928242022057`*^9}, 
   3.5443935385290623`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercises", "Section",
 CellChangeTimes->{{3.5443956564412003`*^9, 3.5443956579442863`*^9}}],

Cell[CellGroupData[{

Cell["Exercise 1 [3 points]", "Subsection",
 CellChangeTimes->{{3.544392010859685*^9, 3.5443920126677885`*^9}, {
  3.544394878382698*^9, 3.54439490674232*^9}}],

Cell[TextData[{
 "What geometric relationships do you observe among  ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "\[Cross]", 
    StyleBox["b",
     FontWeight->"Bold"]}], TraditionalForm]]],
 "?"
}], "Text",
 CellChangeTimes->{{3.5443947274160633`*^9, 3.544394776024843*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2 [9 points]", "Subsection",
 CellChangeTimes->{{3.544394719096587*^9, 3.54439472072068*^9}, {
  3.544394902094054*^9, 3.5443949187500067`*^9}}],

Cell[TextData[{
 "Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"2", ",", "1", ",", "0"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["b",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"1", ",", "2", ",", "0"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["c",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"0", ",", "1", ",", "1"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]]],
 ".  Graph the parallelpiped defined by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox["c",
    FontWeight->"Bold"], TraditionalForm]]],
 ".  Find the volume and surface area of the parallelpiped defined by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox["c",
    FontWeight->"Bold"], TraditionalForm]]],
 ".  "
}], "Text",
 CellChangeTimes->{{3.54439409672499*^9, 3.544394140315483*^9}, {
  3.544394217665907*^9, 3.544394242181309*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3 [9 points]", "Subsection",
 CellChangeTimes->{{3.5443952255485544`*^9, 3.5443952273876595`*^9}, {
  3.544395328843463*^9, 3.5443953322276564`*^9}}],

Cell[TextData[{
 "Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"2", ",", "1"}], "\[RightAngleBracket]"}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["b",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"4", ",", "0"}], "\[RightAngleBracket]"}]}], TraditionalForm]]],
 ".  Find (1) the vector projection of ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 " onto ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and (2) the vector projection of ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 " onto ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]],
  FontWeight->"Bold"],
 ".  Graph all four vectors."
}], "Text",
 CellChangeTimes->{{3.5443952354061184`*^9, 3.5443952509410067`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4 [3 points]", "Subsection",
 CellChangeTimes->{{3.5443956685948954`*^9, 3.5443956745372353`*^9}, {
  3.544396017485851*^9, 3.544396020045997*^9}}],

Cell[TextData[{
 "Investigate ",
 StyleBox["DotProduct.nb",
  FontSlant->"Italic"],
 " with \[OpenCurlyDoubleQuote]show dot product\[CloseCurlyDoubleQuote] \
checked.  How is this demonstration showing the dot product?"
}], "Text",
 CellChangeTimes->{{3.5443957074411173`*^9, 3.5443958149522667`*^9}, {
  3.544395966511935*^9, 3.5443959685110493`*^9}, {3.607878639405305*^9, 
  3.607878639733653*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5 [3 points]", "Subsection",
 CellChangeTimes->{{3.5443958573116894`*^9, 3.54439585907979*^9}, {
  3.5443960229581637`*^9, 3.5443960264303627`*^9}}],

Cell[TextData[{
 "Investigate ",
 StyleBox["CrossProductOfVectorsInTheYZPlane.nb",
  FontSlant->"Italic"],
 " with \[OpenCurlyDoubleQuote]show parallelogram\[CloseCurlyDoubleQuote] \
checked.  What properties of the cross product does this demonstrate?"
}], "Text",
 CellChangeTimes->{{3.5443957074411173`*^9, 3.5443958149522667`*^9}, {
  3.544395957725433*^9, 3.544396011287496*^9}, {3.588893931765774*^9, 
  3.588893937754442*^9}, {3.607878650554593*^9, 3.607878650890706*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{844, 823},
WindowMargins->{{123, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.5, 1.5 Inherited],
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, \
2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 105, 1, 137, "Title"],
Cell[687, 25, 285, 6, 76, "Text"],
Cell[CellGroupData[{
Cell[997, 35, 98, 1, 119, "Section"],
Cell[1098, 38, 2455, 83, 171, "Text"],
Cell[3556, 123, 1856, 42, 443, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5449, 170, 97, 1, 119, "Section"],
Cell[5549, 173, 448, 7, 164, "Text"],
Cell[6000, 182, 2942, 77, 319, "Input"],
Cell[8945, 261, 734, 31, 78, "Text"],
Cell[9682, 294, 3926, 81, 244, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13645, 380, 98, 1, 119, "Section"],
Cell[CellGroupData[{
Cell[13768, 385, 159, 2, 65, "Subsection"],
Cell[13930, 389, 511, 21, 47, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14478, 415, 159, 2, 65, "Subsection"],
Cell[14640, 419, 1503, 61, 108, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16180, 485, 164, 2, 65, "Subsection"],
Cell[16347, 489, 990, 38, 78, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17374, 532, 162, 2, 65, "Subsection"],
Cell[17539, 536, 401, 9, 76, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17977, 550, 163, 2, 65, "Subsection"],
Cell[18143, 554, 479, 9, 105, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
