(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     40904,        850]
NotebookOptionsPosition[     40075,        817]
NotebookOutlinePosition[     40431,        833]
CellTagsIndexPosition[     40388,        830]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Graphing", "Section",
 CellChangeTimes->{{3.5443956477557034`*^9, 3.5443956488747673`*^9}}],

Cell["\<\
Here are two functions that help my ability to visualize.  myAxis returns \
graphic primitives that create an axis in the given component direction with \
the given label in the given color from lo to hi; the axis is dashed for \
negative values.  myPoint includes dashed lines indicating how one might plot \
the point by hand and a label for the point.\
\>", "Text",
 CellChangeTimes->{{3.5443931462386246`*^9, 3.5443931949874134`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"myAxis", "[", 
    RowBox[{
    "label_", ",", "color_", ",", "component_", ",", "lo_", ",", "hi_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e", ",", "g", ",", "o"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"o", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";", 
      RowBox[{"e", "=", "o"}], ";", 
      RowBox[{
       RowBox[{
       "e", "\[LeftDoubleBracket]", "component", "\[RightDoubleBracket]"}], 
       "=", "1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"g", "=", 
       RowBox[{"{", 
        RowBox[{"color", ",", 
         RowBox[{"Text", "[", 
          RowBox[{"label", ",", 
           RowBox[{"1.05", " ", "hi", " ", "e"}]}], "]"}], ",", 
         RowBox[{"Arrowheads", "[", "0.02", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{"o", ",", 
            RowBox[{"hi", " ", "e"}]}], "}"}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"lo", "<", "0"}], ",", 
        RowBox[{"g", "=", 
         RowBox[{"Join", "[", 
          RowBox[{"g", ",", 
           RowBox[{"{", 
            RowBox[{"Dashed", ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"lo", " ", "e"}], ",", "o"}], "}"}], "]"}], ",", 
             RowBox[{"Dashing", "[", 
              RowBox[{"{", "}"}], "]"}]}], "}"}]}], "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", "g"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"myPoint", "[", 
    RowBox[{"p_", ",", "color_", ",", "label_"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"color", ",", 
     RowBox[{"Text", "[", 
      RowBox[{"label", ",", 
       RowBox[{"1.1", " ", "p"}]}], "]"}], ",", "Dashed", ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"p", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"p", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           ",", 
          RowBox[{"p", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
           ",", "0"}], "}"}], ",", "p"}], "}"}], "]"}], ",", 
     RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
     RowBox[{"Point", "[", "p", "]"}], ",", 
     RowBox[{"Dashing", "[", 
      RowBox[{"{", "}"}], "]"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.544260709698449*^9, 3.5442607186279593`*^9}, {
  3.54428111716831*^9, 3.5442811280423098`*^9}, {3.5442856744219174`*^9, 
  3.5442856853789177`*^9}, {3.5442900062835426`*^9, 3.544290041155543*^9}, {
  3.5443927636957445`*^9, 3.544392786886071*^9}, {3.544392851243752*^9, 
  3.5443928515137672`*^9}}],

Cell[TextData[{
 "Draw a graph of the points and vectors ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 " along with part of the plane determined by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.544393214601535*^9, 3.5443933354354467`*^9}, 
   3.576924386481578*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"o", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";", 
  RowBox[{"p", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "6", ",", "3"}], "}"}]}], ";", 
  RowBox[{"q", "=", 
   RowBox[{"{", 
    RowBox[{"6", ",", "3", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], ";", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"myAxis", "[", 
       RowBox[{"\"\<x\>\"", ",", "Orange", ",", "1", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "]"}], ",", 
      RowBox[{"myAxis", "[", 
       RowBox[{"\"\<y\>\"", ",", 
        RowBox[{"Darker", "[", "Yellow", "]"}], ",", "2", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "]"}], ",", 
      RowBox[{"myAxis", "[", 
       RowBox[{"\"\<z\>\"", ",", "Green", ",", "3", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "]"}], ",", 
      RowBox[{"myPoint", "[", 
       RowBox[{"p", ",", "Black", ",", "\"\<p\>\""}], "]"}], ",", 
      RowBox[{"myPoint", "[", 
       RowBox[{"q", ",", "Black", ",", "\"\<q\>\""}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"Black", ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{"o", ",", "p"}], "}"}], "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{"o", ",", "q"}], "}"}], "]"}], ",", "Red"}], "}"}]}], "]"}],
     ",", 
    RowBox[{"Axes", "\[Rule]", "True"}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"100", ",", "100", ",", "100"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.544188998883645*^9, 3.544189003768761*^9}, {
   3.5441897207364597`*^9, 3.5441897323461676`*^9}, {3.544190060055626*^9, 
   3.54419009446349*^9}, {3.5441901254087315`*^9, 3.5441901463092475`*^9}, {
   3.544190177415721*^9, 3.5441902335381937`*^9}, 3.5441902947152634`*^9, {
   3.5441904213970203`*^9, 3.5441904708429275`*^9}, {3.544191432467061*^9, 
   3.5441914326231127`*^9}, {3.544191466267708*^9, 3.544191473633315*^9}, 
   3.5441915498818345`*^9, {3.5441915858838005`*^9, 3.544191637041529*^9}, {
   3.5441952332194257`*^9, 3.5441952922172594`*^9}, {3.544227068842256*^9, 
   3.5442270705913563`*^9}, {3.544227108415519*^9, 3.544227136351117*^9}, {
   3.54422717940758*^9, 3.544227211334406*^9}, {3.544227258272091*^9, 
   3.5442272583830967`*^9}, {3.544264576475616*^9, 3.544264578367724*^9}, {
   3.544264611410614*^9, 3.5442647285733156`*^9}, {3.5442655755097575`*^9, 
   3.5442656265276756`*^9}, {3.544265668290064*^9, 3.5442656717772636`*^9}, {
   3.5442657178929014`*^9, 3.5442657435013657`*^9}, {3.5442683095971384`*^9, 
   3.544268333300494*^9}, {3.544268372027709*^9, 3.5442684125960293`*^9}, {
   3.544271170958799*^9, 3.5442711717258425`*^9}, {3.5442792389278936`*^9, 
   3.544279242872288*^9}, {3.544279277134714*^9, 3.5442792808680873`*^9}, {
   3.5442793221212125`*^9, 3.54427934140314*^9}, 3.54428111298731*^9, {
   3.544284734286769*^9, 3.544284743923805*^9}, 3.5442855942729177`*^9, {
   3.544392168068677*^9, 3.5443921821414814`*^9}, {3.544392216013419*^9, 
   3.5443922258699827`*^9}, {3.5443922779179597`*^9, 
   3.5443922786930037`*^9}, {3.5443923417416105`*^9, 3.544392424318333*^9}, {
   3.544392455639125*^9, 3.5443925750439544`*^9}, {3.5443926174083776`*^9, 
   3.5443926738816075`*^9}, {3.5443928006498585`*^9, 3.5443928242022057`*^9}, 
   3.5443935385290623`*^9, {3.5769242218356524`*^9, 3.5769242457587357`*^9}, {
   3.5769242830939283`*^9, 3.576924283758156*^9}, {3.576924358430511*^9, 
   3.576924358828824*^9}, {3.5769243911563253`*^9, 3.576924417347826*^9}, {
   3.576924611834613*^9, 3.5769247093529453`*^9}}],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.5, 0], Text3DBox["\<\"x\"\>", {2.1, 0., 0.}], 
   {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {2, 0, 0}}], 
    {Dashing[{Small, Small}], Line3DBox[{{-2, 0, 0}, {0, 0, 0}}]}, 
    {RGBColor[
      NCache[
       Rational[2, 3], 0.6666666666666666], 
      NCache[
       Rational[2, 3], 0.6666666666666666], 0], Dashing[{}], 
     Text3DBox["\<\"y\"\>", {0., 2.1, 0.}], 
     {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 2, 0}}], 
      {Dashing[{Small, Small}], Line3DBox[{{0, -2, 0}, {0, 0, 0}}]}, 
      {RGBColor[0, 1, 0], Dashing[{}], 
       Text3DBox["\<\"z\"\>", {0., 0., 2.1}], 
       {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 0, 2}}], 
        {Dashing[{Small, Small}], Line3DBox[{{0, 0, -2}, {0, 0, 0}}]}, 
        {GrayLevel[0], Dashing[{}], 
         Text3DBox["\<\"p\"\>", {-2.2, 6.6000000000000005`, 
          3.3000000000000003`}], 
         {Dashing[{Small, Small}], 
          Line3DBox[{{-2, 0, 0}, {-2, 6, 0}, {-2, 6, 3}}], 
          {PointSize[Medium], Point3DBox[{-2, 6, 3}], 
           {GrayLevel[0], Dashing[{}], 
            Text3DBox["\<\"q\"\>", {6.6000000000000005`, 
             3.3000000000000003`, -2.2}], 
            {Dashing[{Small, Small}], 
             Line3DBox[{{6, 0, 0}, {6, 3, 0}, {6, 3, -2}}], 
             {PointSize[Medium], Point3DBox[{6, 3, -2}], 
              {GrayLevel[0], Dashing[{}], Arrow3DBox[{{0, 0, 0}, {-2, 6, 3}}],
                Arrow3DBox[{{0, 0, 0}, {6, 3, -2}}], 
               {RGBColor[1, 0, 0]}}}}}}}}}}}}}},
  Axes->True,
  ViewPoint->{100, 100, 100}]], "Output",
 CellChangeTimes->{{3.57692467474612*^9, 3.576924713233317*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"pc", ":=", 
  RowBox[{"ContourPlot3D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", 
         RowBox[{"26", "/", "3"}]}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", "2"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "+", 
         RowBox[{"11", "/", "3"}]}], ")"}], "^", "2"}]}], "\[Equal]", 
     RowBox[{"392", "/", "9"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "5"}], ",", "20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "5"}], ",", "20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{"-", "20"}], ",", "5"}], "}"}], ",", 
    RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
    RowBox[{"ContourStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"Opacity", "[", "0.5", "]"}], ",", 
       RowBox[{"Specularity", "[", 
        RowBox[{"White", ",", "30"}], "]"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.576924432949189*^9, 3.576924573063615*^9}, 
   3.576924717311811*^9, {3.576924770071267*^9, 3.576924776733779*^9}, {
   3.576924822448132*^9, 3.576924859053269*^9}, {3.5769250103770857`*^9, 
   3.576925011227201*^9}}],

Cell[BoxData[
 RowBox[{"p1", ":=", 
  RowBox[{"ParametricPlot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "t"}], ",", 
      RowBox[{"6", "t"}], ",", 
      RowBox[{"3", "t"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.576924880331388*^9, 3.576924883100051*^9}, {
  3.5769249203708897`*^9, 3.576924980371174*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"6", "t"}], ",", 
     RowBox[{"3", "t"}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], "t"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.576924982978907*^9, 3.576925003969022*^9}, 
   3.5769250658121443`*^9}],

Cell[BoxData[
 Graphics3DBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Line3DBox[CompressedData["
1:eJwlxXlUjWkYAPBbXb5kKpfqm1uKqIssOcZStvchR0R2soY2SZLGWAcVN1s3
IQalxd5EocIhPSZJSA1l0kzrLbRRabkt6h3nPH/8zs/SbdsST22JROL8g84P
7fP8Li3aFjid9p/u5Fn99mmNZ3qIx7DheQpXRi9gUgdT/zL5LMz5WuWjUvgx
2pX9EnM+Klm+DBuTHUJ9FQcY7cfmvSm8d0nugcEmzQPXKsIYfYC5eGienJbv
wJwXTh+XKqIZHcZKbI84qOSH0T9258uFikRGR7NY44Uhx+URmBEa+thZkc7o
RBakmzzsmPwqSnsHCDU+eYxGtnJVXFJjUwrOObhRmbqikNEvWF8etNbRAvHh
Hs+Sa29LGZ3LrBd/rX52IhOLVm+xDdhVyeh8tivXnp1veYkyR5XXX/CZ0YVM
TJGVamnloazA896kNXWM/o/dVzvk5E19h0MH+8Yr3RoYXcYyfC6ZraovQLuS
ra9nnG5idAVrVUwzvL21EDM6A+cXRDYzupJpdyT0M7P+F70xOzs9uJXRH9lE
vuH+0sRivOB+w9R4g4bRn1nO4fG5WTZlOGZlRVuPZweja9ig8LqO+K/lWN68
MBfmdjG6jtVpykrfj1VjW5l8rMnybkZ/YVdrH78yCKvEswl7N7m4cEY3MAPz
Gw1VVVU4wlDXeXekBOhGFro51SvW6hM+9A9MCIvRArqJtUFClffBz1hofUZY
fFob6G9sx7jMFJNn1TjsUP7wdRd0gG5mZYmZJ95a1uLURWXjYyKlQLewLp+C
yBF767DcXzldFdoL6FY2cobQ4/W4HlPtV+k/P9Ub6DbmeNly013xK8pXvCi6
qRSA1rBd5uuHVKxtwJlqyamMHbpAt7NR9cv7Fjo3YpSJt75idx+gO9gAw0bd
zM5GDInefGSCjx7QnUyKkUlDo5owNvd8Vph/X6C72Jbxj4v6zPuGgX5nGs0D
fgL6O0uY6xab3vYNGzcO/3mVmz7Q3ay1zrTfp3PNGN5dKy31MgC6h6UuddSJ
mNWC6fWODQarDYHm7OAcZUzKpxYssrZTT7bqB7QELEucPlxRtqLvCHfbM9f6
AS2ByZMOR8jHteHzFWv2zbCQAa0Fay3yOrTy29BuZW28UZwMaC1ofaVS+wdp
MODQ7MJpZv2B1obzUtcdS6zaMcxLt1PrTH+gtWFAaepl7cx2zDTfyGuNBgCt
A732By2z396BT3tCdGzCBgCtA5J41yR1/078J9mhViUzAloKAReTVP0zOjF3
sFdW6GkjoKXwZORRXZlfF6oeLI+r0DMGuhfInAJGBRt8R88hxa5rVMZA94Li
0X/n70n7jtIHtmYjBROge8OdaGZV5dqNITo1OWcPmADdG9YlTZSZ93TjYCv7
jdYSEWgBApVxQcV/9mCw34oWvT0i0ALcrjaPNJjPUTHRI1uxTwRagKOXlBtK
F3B83b09auZ+EWgBPJZ8sU5czNFYpZq1N0gEWoCBaWl3nF043kzIjKg5JgIt
wPGTa7JC3TjmVo+bkH1RBFoA74kXmvT2cDR1N9ypTBOBFmDIYaM5wnWO6Tbm
TnHpItAC9Nj9rl94k6P7NxuLJ09FoAUo+lL57noCx1tBs7NaMkWgBQh3SV43
+y5HFrvfxOONCLQA3GbJr8o0jp4ldfdnlopAC1D89mS0Tj5HvWsdx13LRaAF
eBiicc9/zzHJV1i/Vy0CLUDElPUjrnzg2N41RLj3SQRagHnXxqTMLOUYarra
xbJBBFqAR7vfvAyq4ThWvWnktCYRaAHOjZ5wcnE9x/fxv/GVzSLQAmxXRy2z
bOBoYX/qRrhGBFqA4fN9y562cHwmidl3q0MEWgCpVsHVcA1H7+xbC7O7RKAF
KE+d4rOhk6N++KOhVd0i0AKk+VyxHdvN8a5LtoZzEWgB/hjUt5Vzjv8Dp0GN
VA==
     "]]}},
  Axes->True,
  Method->{},
  PlotRange->{{0., 5.99999987755102}, {0., 
   2.99999993877551}, {-1.9999999591836735`, 0.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.57692506630824*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"p1", ",", "p2", ",", "pc", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "5"}], ",", "20"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "5"}], ",", "20"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "20"}], ",", "5"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.576925014155875*^9, 3.5769250518559923`*^9}, 
   3.576925110672018*^9, {3.5769251818490067`*^9, 3.576925223375805*^9}}],

Cell[BoxData[
 Graphics3DBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], Line3DBox[CompressedData["
1:eJwlxXlUjWkYAPBbXb5kKpfqm1uKqIssOcZStvchR0R2soY2SZLGWAcVN1s3
IQalxd5EocIhPSZJSA1l0kzrLbRRabkt6h3nPH/8zs/SbdsST22JROL8g84P
Tp7Vb5/WeKa3z/O7tGhb4HTaf7rUwdS/TD4LQzyGDc9TuDJ6Afsl5nxUsnwZ
5nyt8lEp/Bjtyua9Kbx3Se6BjckOob6KA4z2Yy4emien5Tsw2KR54FpFGKMP
sBLbIw4q+WHMeeH0cakimtFhLNZ4YchxeQT6x+58uVCRyOhoFqSbPOyY/Cpm
hIY+dlakMzqRrVwVl9TYlILS3gFCjU8eo5H15UFrHS0Q5xzcqExdUcjoF8x6
8dfqZycy8eEez5Jrb0sZnct25dqz8y0vsWj1FtuAXZWMzmdiiqxUSysPZY4q
r7/gM6ML2X21Q07e1HcoK/C8N2lNHaP/Yxk+l8xW1Rfg0MG+8Uq3BkaXsVbF
NMPbWwvRrmTr6xmnmxhdwbQ7EvqZWf+LGZ2B8wsimxldySbyDfeXJhajN2Zn
pwe3Mvojyzk8PjfLpgwvuN8wNd6gYfRnNii8riP+azmOWVnR1uPZwegaVqcp
K30/Vo3lzQtzYW4Xo+vY1drHrwzCKrGtTD7WZHk3o78wA/MbDVVVVXg2Ye8m
FxfO6AYWujnVK9bqE44w1HXeHSkBupG1QUKV98HP+NA/MCEsRgvoJrZjXGaK
ybNqLLQ+Iyw+rQ30N1aWmHnirWUtDjuUP3zdBR2gm1mXT0HkiL11OHVR2fiY
SCnQLWzkDKHH63E9lvsrp6tCewHdyhwvW266K37FVPtV+s9P9Qa6je0yXz+k
Ym0Dyle8KLqpFIDWsFH1y/sWOjfiTLXkVMYOXaDb2QDDRt3MzkaMMvHWV+zu
A3QHk2Jk0tCoJgyJ3nxkgo8e0J1sy/jHRX3mfcPY3PNZYf59ge5iCXPdYtPb
vmGg35lG84CfgP7OWutM+30614yNG4f/vMpNH+hulrrUUSdiVguGd9dKS70M
gO5hB+coY1I+tWB6vWODwWpDoDmzLHH6cEXZikXWdurJVv2AlsDkSYcj5OPa
0HeEu+2Za/2AlsBai7wOrfw2fL5izb4ZFjKgtaD1lUrtH6RBu5W18UZxMqC1
4LzUdccSq3YMODS7cJpZf6C1YUBp6mXtzHYM89Lt1DrTH2ht6LU/aJn99g7M
NN/Ia40GAK0DknjXJHX/TnzaE6JjEzYAaB0IuJik6p/Rif8kO9SqZEZAS+HJ
yKO6Mr8uzB3slRV62ghoKcicAkYFG3xH1YPlcRV6xkD3guLRf+fvSfuOnkOK
XdeojIHuBXeimVWVazdKH9iajRRMgO4N65Imysx7ujFEpybn7AEToHtDoDIu
qPjPHhxsZb/RWiICLcDtavNIg/kcg/1WtOjtEYEW4Ogl5YbSBRwVEz2yFftE
oAXwWPLFOnExx9fd26Nm7heBFmBgWtodZxeOxirVrL1BItACHD+5JivUjePN
hMyImmMi0AJ4T7zQpLeHY271uAnZF0WgBRhy2GiOcJ2jqbvhTmWaCLQAPXa/
6xfe5JhuY+4Uly4CLUDRl8p31xM4un+zsXjyVARagHCX5HWz73K8FTQ7qyVT
BFoAbrPkV2UaRxa738TjjQi0AMVvT0br5HP0LKm7P7NUBFqAhyEa9/z3HPWu
dRx3LReBFiBiyvoRVz5wTPIV1u9Vi0ALMO/amJSZpRzbu4YI9z6JQAvwaPeb
l0E1HENNV7tYNohAC3Bu9ISTi+s5jlVvGjmtSQRagO3qqGWWDRzfx//GVzaL
QAswfL5v2dMWjhb2p26Ea0SgBZBqFVwN13B8JonZd6tDBFqA8tQpPhs6OXpn
31qY3SUCLUCazxXbsd0c9cMfDa3qFoEW4I9BfVs553jXJVvDuQi0AP8D/6yN
VA==
      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], Line3DBox[CompressedData["
1:eJwlxXlUjWkYAPBbXb5kKpfqm1uKqIssOcZStvchR0R2soY2SZLGWAcVN1s3
IQalxd5EocIhPSZJSA1l0kzrLbRRabkt6h3nPH/8zs/SbdsST22JROL8g84P
7fP8Li3aFjid9p/u5Fn99mmNZ3qIx7DheQpXRi9gUgdT/zL5LMz5WuWjUvgx
2pX9EnM+Klm+DBuTHUJ9FQcY7cfmvSm8d0nugcEmzQPXKsIYfYC5eGienJbv
wJwXTh+XKqIZHcZKbI84qOSH0T9258uFikRGR7NY44Uhx+URmBEa+thZkc7o
RBakmzzsmPwqSnsHCDU+eYxGtnJVXFJjUwrOObhRmbqikNEvWF8etNbRAvHh
Hs+Sa29LGZ3LrBd/rX52IhOLVm+xDdhVyeh8tivXnp1veYkyR5XXX/CZ0YVM
TJGVamnloazA896kNXWM/o/dVzvk5E19h0MH+8Yr3RoYXcYyfC6ZraovQLuS
ra9nnG5idAVrVUwzvL21EDM6A+cXRDYzupJpdyT0M7P+F70xOzs9uJXRH9lE
vuH+0sRivOB+w9R4g4bRn1nO4fG5WTZlOGZlRVuPZweja9ig8LqO+K/lWN68
MBfmdjG6jtVpykrfj1VjW5l8rMnybkZ/YVdrH78yCKvEswl7N7m4cEY3MAPz
Gw1VVVU4wlDXeXekBOhGFro51SvW6hM+9A9MCIvRArqJtUFClffBz1hofUZY
fFob6G9sx7jMFJNn1TjsUP7wdRd0gG5mZYmZJ95a1uLURWXjYyKlQLewLp+C
yBF767DcXzldFdoL6FY2cobQ4/W4HlPtV+k/P9Ub6DbmeNly013xK8pXvCi6
qRSA1rBd5uuHVKxtwJlqyamMHbpAt7NR9cv7Fjo3YpSJt75idx+gO9gAw0bd
zM5GDInefGSCjx7QnUyKkUlDo5owNvd8Vph/X6C72Jbxj4v6zPuGgX5nGs0D
fgL6O0uY6xab3vYNGzcO/3mVmz7Q3ay1zrTfp3PNGN5dKy31MgC6h6UuddSJ
mNWC6fWODQarDYHm7OAcZUzKpxYssrZTT7bqB7QELEucPlxRtqLvCHfbM9f6
AS2ByZMOR8jHteHzFWv2zbCQAa0Fay3yOrTy29BuZW28UZwMaC1ofaVS+wdp
MODQ7MJpZv2B1obzUtcdS6zaMcxLt1PrTH+gtWFAaepl7cx2zDTfyGuNBgCt
A732By2z396BT3tCdGzCBgCtA5J41yR1/078J9mhViUzAloKAReTVP0zOjF3
sFdW6GkjoKXwZORRXZlfF6oeLI+r0DMGuhfInAJGBRt8R88hxa5rVMZA94Li
0X/n70n7jtIHtmYjBROge8OdaGZV5dqNITo1OWcPmADdG9YlTZSZ93TjYCv7
jdYSEWgBApVxQcV/9mCw34oWvT0i0ALcrjaPNJjPUTHRI1uxTwRagKOXlBtK
F3B83b09auZ+EWgBPJZ8sU5czNFYpZq1N0gEWoCBaWl3nF043kzIjKg5JgIt
wPGTa7JC3TjmVo+bkH1RBFoA74kXmvT2cDR1N9ypTBOBFmDIYaM5wnWO6Tbm
TnHpItAC9Nj9rl94k6P7NxuLJ09FoAUo+lL57noCx1tBs7NaMkWgBQh3SV43
+y5HFrvfxOONCLQA3GbJr8o0jp4ldfdnlopAC1D89mS0Tj5HvWsdx13LRaAF
eBiicc9/zzHJV1i/Vy0CLUDElPUjrnzg2N41RLj3SQRagHnXxqTMLOUYarra
xbJBBFqAR7vfvAyq4ThWvWnktCYRaAHOjZ5wcnE9x/fxv/GVzSLQAmxXRy2z
bOBoYX/qRrhGBFqA4fN9y562cHwmidl3q0MEWgCpVsHVcA1H7+xbC7O7RKAF
KE+d4rOhk6N++KOhVd0i0AKk+VyxHdvN8a5LtoZzEWgB/hjUt5Vzjv8Dp0GN
VA==
      "]]}}, GraphicsComplex3DBox[CompressedData["
1:eJx1mXk81ekXx+917WS59n25djGWKdVU92toT7smS02SIpoI00h0RRFSiaJR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    "], {
     {Opacity[0.5], EdgeForm[None], Specularity[
       GrayLevel[1], 30], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtlWlskEUQhvdrgba0hB4WsBUKiUITalVoEaEcphcKraUBD2hRCxrlPgxy
Hz+Q+7QtEKKGgP8IgRCOlpCgVvCIidGosYAJKibGEJFw/ZPnzb4/nszsfrOz
s7Mz+w1pWdS4MCWEcBBSoSUJ4QwyD5rRS5BlMBcWwzvwCTwPo+FFbCbDS1AB
W5hbbz8nQvS1CMYzXogcl0R9bBJtBoVodxteYHwHWQlLoQKq4SM4ArV8r4Fq
r1WM/byXpHwtgPkwD+ptPymJcQYoUqyo2dAG38C38DW85XgGWi9GXrCuuSJ4
3PlQXq7Dz/ADPIlNqfIFQ+EJKIPZzmcnnIMOOAvvwwpYDhOVa2gK0T7H+f9Q
OYEd8JP3+hV+gW74EVbBe7ASGmAjjIDXYCZsch5ehTqYoDvTPYSYh3qoky3f
+iN7Wy/1GT+Fozo3c8eRx2C4Y8x1nJmQDxmuk3ed/37Y5eqe4DfGl+ER5RWG
uQYyvaf2LlT+fUf59i+fOYxvIP9wbCW2V/4LFHcS5+VHcb+M/gpMT2Jux8NY
eBZGQbltpsEMqLJ9JYzw3em8Y7B7znX+AWyF1dDIt6nQAE/r7uEZmOT7qtVY
3xzDEt/RMtdzDVTZz1NJzGdTEu+h1Htt9t2p9lR3xdYvuM7VmwOch9fRH0Pu
h22wAdaE6FM9nVhXflK9tsz1PNL25baRrXpjiutkF/wfopN/EdcgDf0S8ivo
g57l+LNdU5naCzJgFuwLsddUz61w3jH0d43N8to0n0Vv0WDfu+onG96Adub2
hvhW/Ae34C/rf8IDuAf37acwxLxobV/Far0gxPGb6Hts0+Sa7+15zT1qXbLA
+vYQ16Sg94QeSZzXd327C9/Dd/apfNQ5Hp2p0Lru6qDPnh5ijtS/6scvYY7n
e1qX7GW90zmUft451Tug9+QivJ3Es2aF2O+q/wMhvi1aq97Vm3syxLfpd7gK
V+yzl230Rq2Fz503+Wy3nzyvVQ2ory/ZZq9zpXPpPtPtU/46HVuW71fjDp/l
UIi9Ntlr21yH6qndsNO+Wp2rZvfFAPv8DNllXb41Pgwfh9hrenvVd7W26XI9
/AM34W/H2ep9TsOpEN/qdSG+q1+E+L/odo09BKsIrnQ=
         "]], 
        Polygon3DBox[CompressedData["
1:eJxNlltsVUUUhme3tILWYiJUSks9baE3uVpoEWukXGJMIUJboK2AQPGWcBOi
ieFioiYqKqiJgAoCKldBAfUNRFEejIoSNUIEa1SsF9QHxUAB9fsz/4k+fNlz
ZtbMXutfa9bZxXMWNi7ICCHshm6QC/lQCAXQH0qgGEqhCPKgF/SDa6AGHoIq
yPEZ2pvynNYehgf91O+50O6x9td67l5YDGNhDCyDFbAclsIQ+1Ll8+6CRbAQ
FnhPPTRCs32Ur33gaqjz+XfD9XAPzPA52j/dvzW/BAZAmWOvhEzrJM0S+1Ji
HeTTm/AW7IXXYZ/n3oaDsMtaH4D98DJsgBegwXNaq4BymOxYtsJ2mACrva/B
89tgh9fXw4vwEuyEjfC8bbZ6bTNsss3j8CSsgqfgaXjC833t1wafq3Oeg7XW
Sfo8C89435oQ60bnrLPd7bASHoM7oA3RmqEJWpP47tWOa5XtVjrvS61BhXMw
wHEorlcdc6PzvdHxlTonQ5wv5WYQDHWONB4ME2EY3ACjQqy3Ouf1ErjC+VWu
syHLa5dDzxBrPMdj6ZTvOdl19xkZ1lhavwJbHIvqcLhjKvO4v33f6T1bHOMb
IdaTamifc7DedtKi2rEplmtDrDnVl+rsNb97s8/RftXlHtvIttkaqs6a4FF4
BO6DB2AqtMKd0OI4Nvks1fPNiHQTjIc/FQvPMVAP1TDa67K7ESphJCSQDbPZ
MwdmwW32Qb4MYq0IJsBEOM5cH79jvOd/lM48u0NPuAzOMXdReWLcwz7IlwYY
6D3aq7M6GffjWQgFkAX3qyZ41iUx/nrHM9r+HwuxdifBz4xPu0ZVm7/Apcyf
D9GPHrabnEQ72euscTDWZ2ptv8+QTR6/+0I+9Lbf9X73LdaiBb4IURM9W3yX
Pg/x2WQ/9Vtaj4JMa95pHa+CK/8Xg3z/Cb6BI/ARdPj5CRz17w6Pv4WvQtQ9
N4lxS/+PmfvUe7T3cIh9QffmfXjPz3fhUIh+KN48+6M+v8J2h+yXtNVd/tV5
VX7/gJwknpMKsS+9AydgCkyDk3AKfoDv4Tvoxp5/eP4NXdZIWn0Jn3mf6kl1
ddJxzHZtKu6ZPv+ENZBWH4YYt+LNts4XQqyDo9470/a5rvvzrpWvrXmH9ZR2
7X6n3q07l3KNT3McquFOx1PKfIlzoFxUwXW+Y5XOu/Jfm8RaV89UXyljPMJo
PNx3pcvaXHQNS3f10rPWX2fPC/HMkc6F7H9zTmqS+B+u/+Fma3DBWp+zrfT/
3XvUb3TXipPYY+aHuL/GPg+2j9W+v/qPUwwjvKa7K1u9S71DvUT/OfqvmQVt
IfawKc6BvjFqbZPuO7K91bZnHa++Lf5yLubaNl0H6XPTtTDVeVJ+au1PofVW
H1M/k9/yV98B6uXqverP6sPqx/quOmA/Wn1mm7XLSGLddrlOVa+6t7qv+u5Z
5Lwo9+rJesdQxsOc+3nWVb6VQ4VrJl07la7JXK9Vea7EdZeyrerrTIjfcO2u
1ZRzV26bxDWX4TugnBb7jJbw3zfgGeurGtD9POX6+SDE+6R7le9zMq1llvvi
Ed8Z9ccCa63cF7lnak33qhfjfwEtCytk
         "]], Polygon3DBox[CompressedData["
1:eJwt00dPlUEUgOH5EEkQFqBcFHYQigFpVwFpglx6pCN9RYJEFDBWdKMuLCga
lSJSN7iC8AsIgkosS1AS3BEQWFHEH8B7Mmfx5Nyp38ycc8Nauqo6vYwxZ3EU
79CPPvTiLQ7wF4GOMQHwxy7tPexjEzs4Rf8qcQVrOEl7i3iCeNyx69dpv8Fr
lCAbQ2jAEzzDc7ThvY5dQA6akYpkPMILtKIJV9CDp7pPqGPPsIQfCKGdRhzB
MCZwXs//D/+xjQ1j7xiEb/z+bux9x4j5yMM4RvV9ilGEV3ipa+WuwXDpPo1o
QD3KUAQPc9P1DBeRK/ekv4sYQzyNDFSjBgmoQgUMSlDu2BxILlIQi0TNpbzR
NGZRqWtj4UYSLqMOeY59X8lDFjKRIfvoN+XbtTp/iv6PiOB3JKLkrlIX8IE3
fKUOEAQX/KQOjJ3n0v5gqQnEIw7hsifO4DrS2PcGsR3XEE07DJnI0neRs8kZ
5xifMfZuScRSlKECbmPP6dZ75uIcHuv4Ir7iCzz6HrWaL8mR7FOOAQzq/Nt4
gHl8wC104x4+Y0HH5D/wG7+wrHV4V+fK+vt4KDXFdwq0LkpxSfOajWLH1uae
rpd9/uCn1rRHzynrC5GDSfo/GZtjubfk6irtm7iDDn1TydURHNMcSd4OAVQF
Zuk=
         "]], Polygon3DBox[CompressedData["
1:eJwt0D0vA1AUBuDbptU0In6AhNhZmJCKwWdrsncxtR0qEiHSEl0YO/gF4heI
tIqdhpgllN1g9LG1z3CHJ+8Z7jk5505u72xVkyGEUYZ445UvvvnnjxNmmaHB
MXVuuaPNFS1uSCdCGGOCQF+k5KP85J0eHzzQZJ01VlnhMtadOPOaC5YZMasb
ezPqYbKMM80UBfJxhzPvTqlxxAH75NmkwBzz5FjUk+NQvccuVTY45z7e3ok7
P/MU/+qXH14ossQCZSqUGADT/S4i
         "]]}]}, {}, {}, {}, {}},
    VertexNormals->CompressedData["
1:eJwVWHk41F8Xr2ilkMhW0qaEoiyhrl+hxVIqJUukRIslW1JaiJCIQmUJaWeQ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     "]]},
  AutomaticImageSize->True,
  Axes->True,
  ImageSize->{359.5427128460386, 395.4253847775404},
  Method->{},
  PlotRange->{{-5, 20}, {-5, 20}, {-20, 5}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewPoint->{1.3445122363483928`, -2.534366314379427, 1.7942336054283132`},
  ViewVertical->{0.021873213863788724`, -0.07157188432348838, 
   0.9971955815634433}]], "Output",
 CellChangeTimes->{{3.576925023929056*^9, 3.5769250523505907`*^9}, 
   3.576925111164242*^9, {3.57692521307689*^9, 3.57692522395033*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{740, 821},
WindowMargins->{{12, Automatic}, {Automatic, 24}},
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, \
2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 97, 1, 80, "Section"],
Cell[679, 25, 448, 7, 87, "Text"],
Cell[1130, 34, 2942, 77, 148, "Input"],
Cell[4075, 113, 588, 24, 31, "Text"],
Cell[CellGroupData[{
Cell[4688, 141, 3636, 71, 114, "Input"],
Cell[8327, 214, 1653, 34, 335, "Output"]
}, Open  ]],
Cell[9995, 251, 1320, 37, 63, "Input"],
Cell[11318, 290, 446, 13, 28, "Input"],
Cell[CellGroupData[{
Cell[11789, 307, 389, 12, 28, "Input"],
Cell[12181, 321, 2316, 45, 267, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14534, 371, 584, 16, 28, "Input"],
Cell[15121, 389, 24926, 424, 444, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

