(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    110449,       2106]
NotebookOptionsPosition[    108218,       2028]
NotebookOutlinePosition[    108562,       2043]
CellTagsIndexPosition[    108519,       2040]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Catapult Problem", "Title",
 CellChangeTimes->{{3.5770432430825787`*^9, 3.57704324680157*^9}}],

Cell["\<\
A medieval city has the shape of a square and is protected by walls with \
length 500 meters and height 15 meters.You are the commander of an attacking \
army and the closest you can get to the wall is 100 meters.Your plan is to \
set fire to the city by catapulting heated rocks over the wall with an \
initial speed of 80 meters per second.At what range of angles should you tell \
your men to set the catapult?Assume that you will be firing from exactly 100 \
meters from the wall and that you will be firing perpendicular to the wall.We \
also assume that the walls of the city are impervious to heated rocks.\
\>", "Text",
 CellChangeTimes->{3.577043269224084*^9}],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzs3QdcU9cCBnD31qp1W+ustVqx1lZrbavY2ldHS7XD2tLaSbXaau0Sq8he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    "], {{0, 580}, {875, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJyVlwdQU+kWx797b3qhBSIgJfTepUsJPRRBOohKSAKEEkJCaHZFXMEVRUQE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      "], "RGB", 
      "XYZ"], Interleaving -> True],
   Selectable->False],
  BaseStyle->"ImageGraphics",
  ImageSizeRaw->{875, 580},
  PlotRange->{{0, 875}, {0, 580}}]], "Input"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.577043260079913*^9, 3.577043264425056*^9}}],

Cell["\<\
The projectile sometimes hits the front wall - and therefore doesn\
\[CloseCurlyQuote]t get into the city. The projectile sometiimes goes past \
the back wall and doesn\[CloseCurlyQuote]t get into the city. \
\>", "Text",
 CellChangeTimes->{{3.5770440648868837`*^9, 3.577044120293538*^9}}],

Cell[TextData[{
 "There is a range of angles that we are looking for\nFrom (0,",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ") the projectile hits the front wall.\nFrom (",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ",",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "2"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ") the projectile makes it into the city.\nFrom (",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "2"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ",",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "3"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ") the projectile misses the city and flies past the back wall.\nFrom (",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "3"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ",",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "4"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ") the projectile again hits the interior of the city.\nFrom (",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "4"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ",90) the projectile does not make to to the front wall."
}], "Text",
 CellChangeTimes->{{3.577044468202783*^9, 3.57704472222932*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.577044459512603*^9, 3.577044460363768*^9}}],

Cell[CellGroupData[{

Cell["The Model", "Section",
 CellChangeTimes->{{3.577044453915156*^9, 3.57704445550483*^9}}],

Cell[TextData[{
 "Parametric Equations for the Path of the Projectile\n\n",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    RowBox[{"80", "*", "t", "*", "cos", 
     RowBox[{"\[LeftAngleBracket]", "\[Theta]", "\[RightAngleBracket]"}]}]}], 
   TraditionalForm]]],
 "\n",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"80", "*", "t", "*", "sin", 
     RowBox[{"{", "\[Theta]", "}"}]}]}], TraditionalForm]]],
 " - 4.9",
 Cell[BoxData[
  FormBox[
   RowBox[{"*", 
    SuperscriptBox["t", "2"]}], TraditionalForm]]]
}], "Text",
 CellChangeTimes->{{3.577043498528852*^9, 3.577043685506493*^9}, {
  3.5771765692642*^9, 3.5771765720566*^9}}],

Cell["", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"80", "t", "*", 
          RowBox[{"Cos", "[", "theta", "]"}]}], ",", 
         RowBox[{
          RowBox[{"80", "t", "*", 
           RowBox[{"Sin", "[", "theta", "]"}]}], "-", 
          RowBox[{"4.9", "\[IndentingNewLine]", 
           RowBox[{"t", "^", "2"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"100", "+", 
          RowBox[{"10", "t"}]}], ",", "15"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "50"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "700"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "200"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"theta", ",", "0", ",", 
     RowBox[{"Pi", "/", "2"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.57703590678804*^9, 3.57703604896598*^9}, {
   3.577042096342194*^9, 3.577042096700368*^9}, {3.577042245908386*^9, 
   3.577042271841467*^9}, {3.577042302971974*^9, 3.577042337315282*^9}, {
   3.5770423687058573`*^9, 3.577042391384057*^9}, {3.577042529488461*^9, 
   3.577042535534046*^9}, {3.577043426283783*^9, 3.577043426393469*^9}, 
   3.577176470561*^9}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`theta$$ = 0.9707521299592461, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`theta$$], 0, Rational[1, 2] Pi}}, Typeset`size$$ = {
    360., {57., 60.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`theta$369$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`theta$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`theta$$, $CellContext`theta$369$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      ParametricPlot[{{
         80 $CellContext`t Cos[$CellContext`theta$$], 
          80 $CellContext`t Sin[$CellContext`theta$$] - 
          4.9 $CellContext`t^2}, {
         100 + 10 $CellContext`t, 15}}, {$CellContext`t, 0, 50}, 
        PlotRange -> {{0, 700}, {0, 200}}], 
      "Specifications" :> {{$CellContext`theta$$, 0, Rational[1, 2] Pi}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{407., {114., 119.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.577035946361485*^9, 3.577035972204008*^9}, {
   3.577036035710704*^9, 3.577036049438677*^9}, 3.577042098208205*^9, {
   3.577042249810299*^9, 3.577042273109788*^9}, {3.577042315458764*^9, 
   3.577042337873473*^9}, 3.577042536438631*^9, 3.57704342699065*^9, 
   3.5771764785326*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"100", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"100", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"600", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"600", ",", "0"}], "}"}]}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.577036378554247*^9, 3.5770364336005077`*^9}, {
  3.577036636309875*^9, 3.5770366411593246`*^9}, {3.577043375348157*^9, 
  3.5770433957456713`*^9}}],

Cell[BoxData[
 GraphicsBox[
  PolygonBox[{{100, 0}, {100, 15}, {600, 15}, {600, 0}}]]], "Output",
 CellChangeTimes->{{3.577036410474072*^9, 3.577036434107877*^9}, 
   3.577036641676306*^9, {3.577043383267153*^9, 3.577043396076097*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Front Wall", "Section",
 CellChangeTimes->{{3.57704399910394*^9, 3.5770440011671267`*^9}}],

Cell[TextData[{
 "When will the projectile clear the front wall?\n\nThe projectile will hit \
the top of the front wall when ",
 StyleBox["x",
  FontSlant->"Italic"],
 " = 100 and when ",
 StyleBox["y",
  FontSlant->"Italic"],
 " = 15.\n\n"
}], "Text",
 CellChangeTimes->{{3.577043473656802*^9, 3.577043488966304*^9}, {
   3.577043699510313*^9, 3.577043737202834*^9}, {3.577043795412178*^9, 
   3.5770438228102407`*^9}, 3.57704416218396*^9, {3.577044205412635*^9, 
   3.5770442094365597`*^9}, {3.577044260468281*^9, 3.577044261691495*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"80", "*", "t", "*", 
     RowBox[{"Cos", "[", "theta", "]"}]}], "==", "100"}], ",", "t"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.577043745565235*^9, 3.577043777133658*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"t", "\[Rule]", 
    FractionBox[
     RowBox[{"5", " ", 
      RowBox[{"Sec", "[", "theta", "]"}]}], "4"]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.57704376674619*^9, 3.577043777911663*^9}, 
   3.5771765284058*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"80", "*", "t", "*", 
       RowBox[{"Cos", "[", "theta", "]"}]}], "==", "100"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"80", "t", "*", 
        RowBox[{"Sin", "[", "theta", "]"}]}], "-", 
       RowBox[{"4.9", "\[IndentingNewLine]", 
        RowBox[{"t", "^", "2"}]}]}], "\[Equal]", "15"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "theta"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.577043842236166*^9, 3.57704390104712*^9}, {
  3.577044280838449*^9, 3.577044281366375*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NSolve", "::", "ifun"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Inverse functions are being used by \[NoBreak]\\!\\(NSolve\
\\)\[NoBreak], so some solutions may not be found; use Reduce for complete \
solution information. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/NSolve\\\", ButtonNote -> \\\"NSolve::ifun\\\"]\\)\
\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.577043879859068*^9, 3.577043901490953*^9}, 
   3.577044282419467*^9, 3.5771765793417997`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", 
      RowBox[{"-", "16.08687475952258`"}]}], ",", 
     RowBox[{"theta", "\[Rule]", 
      RowBox[{"-", "1.648577829896174`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", 
      RowBox[{"-", "1.282814610305484`"}]}], ",", 
     RowBox[{"theta", "\[Rule]", 
      RowBox[{"-", "2.9149212028790186`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", "1.282814610305484`"}], ",", 
     RowBox[{"theta", "\[Rule]", "0.22667145071077463`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", "16.08687475952258`"}], ",", 
     RowBox[{"theta", "\[Rule]", "1.4930148236936192`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.577043879859997*^9, 3.577043901492482*^9}, 
   3.5770442824219933`*^9, 3.5771765793574*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t1deg", "=", 
  RowBox[{
   RowBox[{"0.226671", "/", "Pi"}], "*", "180"}]}]], "Input",
 CellChangeTimes->{{3.577043939708416*^9, 3.577043964139162*^9}, 
   3.577044290383047*^9}],

Cell[BoxData["12.987291638009886`"], "Output",
 CellChangeTimes->{3.577043965090088*^9, 3.577044291788028*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t2deg", "=", 
  RowBox[{
   RowBox[{"1.49301", "/", "Pi"}], "*", "180"}]}]], "Input",
 CellChangeTimes->{{3.577043967044531*^9, 3.577043977824946*^9}, 
   3.5770443053439903`*^9}],

Cell[BoxData["85.54317177082704`"], "Output",
 CellChangeTimes->{3.5770439788172407`*^9, 3.577044306502891*^9}]
}, Open  ]],

Cell[TextData[{
 "So we need our angles to be larger than 12.99 degrees and less than 85.54 \
degrees.\n\nThese two angles are ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "4"], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.577044219623129*^9, 3.577044249412202*^9}, {
  3.5770442974857883`*^9, 3.577044313227323*^9}, {3.577044736325201*^9, 
  3.577044781476297*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Back Wall", "Section",
 CellChangeTimes->{{3.57704399910394*^9, 3.5770440126471148`*^9}}],

Cell[TextData[{
 "When will the projectile go past the back wall?\n\nThe projectile will hit \
the top of the back wall when ",
 StyleBox["x",
  FontSlant->"Italic"],
 " = 600 and when ",
 StyleBox["y",
  FontSlant->"Italic"],
 " = 15\n\n"
}], "Text",
 CellChangeTimes->{{3.577043473656802*^9, 3.577043488966304*^9}, {
  3.577043699510313*^9, 3.577043737202834*^9}, {3.577043795412178*^9, 
  3.5770438228102407`*^9}, {3.5770440305034113`*^9, 3.577044032782607*^9}, {
  3.577044177423098*^9, 3.5770442011885443`*^9}, {3.577044254843997*^9, 
  3.57704425881177*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"80", "*", "t", "*", 
       RowBox[{"Cos", "[", "theta", "]"}]}], "\[Equal]", "600"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"80", "t", "*", 
        RowBox[{"Sin", "[", "theta", "]"}]}], "-", 
       RowBox[{"4.9", "\[IndentingNewLine]", 
        RowBox[{"t", "^", "2"}]}]}], "\[Equal]", "15"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "theta"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.577043842236166*^9, 3.57704390104712*^9}, {
  3.577044274495667*^9, 3.577044274789934*^9}, {3.57704431785366*^9, 
  3.5770443180449867`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NSolve", "::", "ifun"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Inverse functions are being used by \[NoBreak]\\!\\(NSolve\
\\)\[NoBreak], so some solutions may not be found; use Reduce for complete \
solution information. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/NSolve\\\", ButtonNote -> \\\"NSolve::ifun\\\"]\\)\
\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.577043879859068*^9, 3.577043901490953*^9}, 
   3.577044318839102*^9, 3.577176712617*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", 
      RowBox[{"-", "13.206512522017062`"}]}], ",", 
     RowBox[{"theta", "\[Rule]", 
      RowBox[{"-", "2.174750573233465`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", 
      RowBox[{"-", "9.274760366650153`"}]}], ",", 
     RowBox[{"theta", "\[Rule]", 
      RowBox[{"-", "2.5126436135323047`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", "9.274760366650153`"}], ",", 
     RowBox[{"theta", "\[Rule]", "0.6289490400574884`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", "13.206512522017062`"}], ",", 
     RowBox[{"theta", "\[Rule]", "0.9668420803563283`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.577043879859997*^9, 3.577043901492482*^9}, 
   3.577044318841535*^9, 3.577176712617*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t1deg", "=", 
  RowBox[{
   RowBox[{"0.628949", "/", "Pi"}], "*", "180"}]}]], "Input",
 CellChangeTimes->{{3.577043939708416*^9, 3.577043964139162*^9}, {
  3.577044328384617*^9, 3.577044349797514*^9}}],

Cell[BoxData["36.036123228973615`"], "Output",
 CellChangeTimes->{
  3.577043965090088*^9, {3.577044336457951*^9, 3.577044350634899*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t2deg", "=", 
  RowBox[{
   RowBox[{"0.966842", "/", "Pi"}], "*", "180"}]}]], "Input",
 CellChangeTimes->{{3.577043967044531*^9, 3.577043977824946*^9}, {
  3.5770443555249443`*^9, 3.57704435725312*^9}}],

Cell[BoxData["55.39596605598754`"], "Output",
 CellChangeTimes->{3.5770439788172407`*^9, 3.577044358151308*^9}]
}, Open  ]],

Cell[TextData[{
 "We have just computed ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "2"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "3"], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{
  3.577044379621958*^9, {3.5770448031162567`*^9, 3.5770448256777687`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Conclusion", "Section",
 CellChangeTimes->{{3.57704399910394*^9, 3.5770440126471148`*^9}, {
   3.577044837277952*^9, 3.577044839083811*^9}, 3.577045088301484*^9}],

Cell["\<\
Therefore

For angles between (0, 12.99\[Degree]) the projectile strikes the front wall \
and misses the city.

For angles between (12.99\[Degree], 36.04\[Degree]) the projectile makes it \
into the city.

For angles between (36.04\[Degree], 55.40\[Degree]) the projectiles clears \
the city and strikes the ground past the back wall.\[LineSeparator]\
\[LineSeparator]For angles between (55.40\[Degree], 85.54\[Degree]) the \
projectile again strikes the city.

For angles between (85.54\[Degree], 90\[Degree]) the projectile hits the \
ground in front of the front wall.
\
\>", "Text",
 CellChangeTimes->{{3.577043473656802*^9, 3.577043488966304*^9}, {
  3.577043699510313*^9, 3.577043737202834*^9}, {3.577043795412178*^9, 
  3.5770438228102407`*^9}, {3.5770440305034113`*^9, 3.577044032782607*^9}, {
  3.577044177423098*^9, 3.5770442011885443`*^9}, {3.577044254843997*^9, 
  3.57704425881177*^9}, {3.577044865605749*^9, 3.57704508830179*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1008, 629},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (November 20, 2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 100, 1, 90, "Title"],
Cell[682, 25, 679, 10, 106, "Text"],
Cell[1364, 37, 89964, 1480, 548, "Input"],
Cell[91331, 1519, 92, 1, 31, "Input"],
Cell[91426, 1522, 299, 5, 49, "Text"],
Cell[91728, 1529, 1382, 43, 125, "Text"],
Cell[93113, 1574, 92, 1, 31, "Input"],
Cell[CellGroupData[{
Cell[93230, 1579, 93, 1, 79, "Section"],
Cell[93326, 1582, 651, 21, 86, "Text"],
Cell[93980, 1605, 16, 0, 30, "Text"],
Cell[CellGroupData[{
Cell[94021, 1609, 1413, 37, 52, "Input"],
Cell[95437, 1648, 2073, 41, 250, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[97547, 1694, 556, 15, 31, "Input"],
Cell[98106, 1711, 235, 4, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[98390, 1721, 96, 1, 79, "Section"],
Cell[98489, 1724, 539, 13, 106, "Text"],
Cell[CellGroupData[{
Cell[99053, 1741, 250, 7, 31, "Input"],
Cell[99306, 1750, 279, 8, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[99622, 1763, 616, 17, 52, "Input"],
Cell[100241, 1782, 596, 12, 21, "Message"],
Cell[100840, 1796, 906, 25, 52, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[101783, 1826, 202, 5, 31, "Input"],
Cell[101988, 1833, 110, 1, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[102135, 1839, 203, 5, 31, "Input"],
Cell[102341, 1846, 111, 1, 31, "Output"]
}, Open  ]],
Cell[102467, 1850, 514, 15, 68, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[103018, 1870, 95, 1, 79, "Section"],
Cell[103116, 1873, 564, 14, 106, "Text"],
Cell[CellGroupData[{
Cell[103705, 1891, 672, 18, 52, "Input"],
Cell[104380, 1911, 591, 12, 21, "Message"],
Cell[104974, 1925, 904, 25, 52, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[105915, 1955, 225, 5, 31, "Input"],
Cell[106143, 1962, 137, 2, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[106317, 1969, 226, 5, 31, "Input"],
Cell[106546, 1976, 111, 1, 31, "Output"]
}, Open  ]],
Cell[106672, 1980, 356, 13, 30, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[107065, 1998, 168, 2, 79, "Section"],
Cell[107236, 2002, 954, 22, 239, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
