(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     21067,        473]
NotebookOptionsPosition[     20090,        434]
NotebookOutlinePosition[     20444,        450]
CellTagsIndexPosition[     20401,        447]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Log", "[", "x", "]"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "^", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.5", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6088379614310627`*^9, 3.608837988311706*^9}, {
  3.608838040428149*^9, 3.608838062188785*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVlHs0lHkAhqfVGpk2itPpJNcyCo02amXjlayypZSVhCSXaIvSShElulBK
5LRskrWSTAiLwn5IgxDZmmpCY/i+mNxH7vzW/vGe5//nPOfVPhyw1/sbFotl
N7f/mWIfoMxiiSH4Xa3disdQvfPpD9VyYuhp/8J7xmWozU8PpEezxWhI2Wht
rMlQIm2bjSpKYjSvzCjXV2aopbIVrlwNMQr7Jpt4wzQVl/gyc+dmMXLV5Epj
imjqokgXSWfE4H+Y5Fy3pCkfr9bj64fEuDe85Ndo5y7KQys4Lme0A9wb6Tpj
ZyWU1IifJ5RKoFXil8NrEVOmufxSE1EneIZ9L/ti26kSoehaa1sXgormC666
faQEe9Kd1zXTOJSWEvrw8ntKPiipt1HIwMLX6kVR4luKo+ByNO39ZwQrubwo
bGmhUvuLaK26blRtaxKmOTdTXmGWXGljD/h7ZBL/a/VUibuXl3ulFPJXvrON
6BFQr584xCrmfYFPXaNM50oVpcY/EUrye+FlbsrJai+lRib0jtz/qw8C7+CB
mcQCigwsXHbtUT/M656+9m/IoJocywuyswdg4hv1mPP9JeoOO4pbZjeINSRi
6KhlAg6aVjjWNA1CfLbb9YVjFvri6yJX2w4h0HQmMqWuAImVfrdzGoagLlr7
RcW2FJoPA5Kb7IZhlawX94NpJU6UWKXaCIbhmBSuMx1cDdFd/mXJdhlCuYsi
bzI14GR3HntTJYNmZwNLU74emicvbPcwG8GrLeLD5+ReYSenUF6lbASKeb8p
KdxphmVT4fPlG77idOvgAj+FFtgd2em5reQreC6GSnE3/8XmYtvxRZtGwVFf
NpIv/xaydarXDZ+M4rybwbpv3YSoCg/6JsB4DBbCwfNOte/gPJoezH48hjsd
yfGHVD+gRddUYrZqHINygbvPOIjgtcbTKCFjHItL/XlvHnxE+T6X0C0aEwj9
XBNm3tYKo/3SLNW0CYRd+cr+Ua8dvpE278zVJnHStLo4xPETonwUJuclTALe
5Q4Wc909VfcgUtUpGFpcGjd+J8bfs5fl9G9MobDBadjMuwMvC7ZKYxdPY8cO
61nf6Q5UavkIrsdP4yeEbDW4IcGFYse0DsUZ7LIvpIQqndiv03rQJXYG7qf8
8w/82YmxIiM1A/YsAknnCRPdLpyR62lIDJ+FdW7annPpXViyapOHLosgs8ew
zEGfxin/fSOKZwmEUa7GvAc0lm30quWGElzc9p7sfUijbObkXaswAlFqfGbw
IxrysbHWIREEzRXCqxU5NJKzq2/3RBMscOIm2BfTqOpev6E2mUDOxLDer5bG
Ek+l05fKCO47SqUXpDSK9dV/TvuHwIybuzqtl4brsL5GeQXB7OpdVpX9NB5E
2AhGqgkEY2sXzJPRMLsfttSrkYDbPUmHT9E43PalyKqdQNVz/NOphQzYGRMx
B8UEK+zvtd1axIB/jO0eIiGYqj9anKvMYHRKh53PEOz1iZnzziBm+QEn7QGC
tdm+End1BkaSIwbmQwRuf9RUntNk8CYriOyXEWj2B4YlaTPQ2HQrM26M4HhC
ZXSLLoPnrNRQ/gRB3m5/Ub8eA99a/u7aKYKhLSFsjj6DhXHPVnbNEJSskCrr
GTJ44lQ7RghB6q2q0bn/wn9S3ohj
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwVlnk0lW0Xxk0REaVQQoYkc4lUOldUlJIkkillKpRUKDIlilQiypCMrzlE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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0.6000000000000001, 0},
  Method->{},
  PlotRange->{{0.5, 2}, {-0.6931471193354575, 0.999999938775511}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.6088379897156067`*^9, {3.608838052101096*^9, 3.6088380632273283`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "\[Equal]", 
    RowBox[{"Log", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1.6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6088381957722187`*^9, 3.60883823104568*^9}, {
  3.6088383225771627`*^9, 3.608838350737529*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "1.7468817423085286`"}], "}"}]], "Output",
 CellChangeTimes->{{3.608838221789575*^9, 3.608838231975683*^9}, {
  3.60883833988303*^9, 3.608838351755169*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", "x", "]"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "1.74688"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.608838096153697*^9, 3.60883812764634*^9}, {
  3.608838371753956*^9, 3.608838383514495*^9}}],

Cell[BoxData["0.08870712059169228`"], "Output",
 CellChangeTimes->{3.608838129610697*^9, 3.608838385519055*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Log", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.608838409422925*^9, 3.608838421955916*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "x"}], "+", 
  RowBox[{"x", " ", 
   RowBox[{"Log", "[", "x", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.608839232634932*^9, 3.608839235050261*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"t", "^", "2"}], ",", "t"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "-", "t"}], ",", "t"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p1", ",", "p2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.608839237574416*^9, 3.608839337671404*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdmGc81f//xu0VjtmghPBNiqLQ4PVJMqPILJmVIip7Zq8KJ06yyRaOESLy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      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwtlH0w1Hkcx9fjyp3ykOL2enCsOT3ISVxUn58dhUJ3TqnzEHVum+vs0chx
zCF2qFEpD0UYN+vUpUE3PUjOB0eW66LdC4NkKWzs/pa1tZ72e3fz6zvznddn
PvN+v/782B3/IThGn8ViBf73/yfzTKj3Q/PGF8bdqctsyrvBrHx+gSBDNnU2
gbNLrSHIkE0Zyt2TxqcIMmRTKySxqid9BBmyKcvKwZHiWoIM2ZSD34OW7ccI
MmRT/nmCTH6TDqVdC2SkzpiqKtSQluhlTGreUshZaUzR6Uc3eXy8hD5r+i5k
C4yo7C01nFUvFrC4yswgtsWQcg3kGA+cncfXv7l2v9xgSHV9FVOOoMWGibG1
T+IMqDPdHduuyd7iA6FZm7xNnxJ8wMmRntPgrSJuR4GDPhWy9cBFJ/85dBzt
3PcwUY8KbMu/cFoxiyUV4etO/cOitns/9Oy9OYNuyA8N2sGi+D9315R+p8Ja
Fx3nsAWByOglj9ufKPGVeIXHpu5l6LhsJQgpn8LNvVsPzMQvweHbYUWjY5PY
KuI5cjiLkOkrDHB3H0efULfaY4PzcK7mZCTeH8OBtD2fXU3Xwj2SetxZT4YR
F7nR8l3vIGFnUdav6iFUW3DPOw9r4C/fgk8bkvqw75D1T73COYgIPTR5dK0E
b6aNri32UQNv2QrFDl2Yu15cEzQ5A+2TGdNvspowQnRevV6kgrJTIfHDJypR
25OiE4mVkKzi2TSfEUHEXisT1eppsH4eg2lHEK4Lv4mNvySHfHnsfs/WTmDV
jbf1S8dBr8I1MeiIBPTD9t8y4r6CZf9T1XP3+mDoGX+KXykD33AXJ5cHQ9AQ
8/3uqMEXYP+3v+ygpQwEmBoW1tUP/hXewZKSMYj86ItCmUQKz2ZDd1xaMw5u
+aZ8/vAT2B622/Fb8SSY24VbyrpbofHdyUfsgCkwj2y37RLVwoZbJyL/NFIC
y/rKXTenKxjiJ5FU+qmg7u4GbXB6PR5YzNhmlDMDcZ2d1wqsOtB5p23+6dFZ
KPAJsre+2oPcy1K/du4cOPQ8ty4w78UVCWeMuFkaSPq6ZDo7bhDLixwX7Ybe
wsUqjdDEcwR9pQs8w3VaqN8Raz8xM4pDJfcvq5PmwXR+U0xeymsUpha6iv9Y
gCYvtm2CdgJflmV+6Lm0CAEFvw/EV79Bx/1HFfWHloFlV0l5uigw3Tx447pr
OkjN+yU02UuBe8Q91Y1lOtCSckH9PgUupR30CBfpQDVcXOoeocAkOiDoeo0O
RkovaV3PKzDuqW+qbbsOmm1S6ja/UmBU7u5+61kdMF4lUiZOeSsDCDAeJerw
BqfmSwKMR4mNPzreCAwlwHiU+PmEfVPucQKMR4kuj9dPmyYTYDw0bsxa7ceu
IsD0aBz2ypdWVRNgejSWqi2O7btDgOnRaHNiVaKwkQDTo9GcZ1ppICXA5Gh8
Op+zTdRPgMnRmHuH/Yg3TIDJ0WhiZyTJkBNg9jQ+7s+MsKMJMHsas/L05c1z
BBjSyPPLSIhaIMCcLRW+v1/Uv48teWE=
      "]]}}},
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0., 4.}, {-2., 2.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.608839273478016*^9, 3.6088393385736017`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "^", "2"}], "\[Equal]", 
    RowBox[{"1", "-", "y"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0.3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.608839628743415*^9, 3.608839660782771*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"y", "\[Rule]", "0.6180339887498949`"}], "}"}]], "Output",
 CellChangeTimes->{3.608839661409101*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "-", "y", "-", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", ".618034"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6088396662055397`*^9, 3.608839731209818*^9}}],

Cell[BoxData["0.3483616572915789`"], "Output",
 CellChangeTimes->{3.608839731878827*^9}]
}, Open  ]]
},
WindowSize->{740, 652},
WindowMargins->{{4, Automatic}, {Automatic, 4}},
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, \
2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 421, 12, 28, "Input"],
Cell[1003, 36, 8066, 141, 238, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9106, 182, 394, 11, 28, "Input"],
Cell[9503, 195, 211, 4, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9751, 204, 398, 11, 28, "Input"],
Cell[10152, 217, 111, 1, 28, "Output"]
}, Open  ]],
Cell[10278, 221, 182, 4, 28, "Input"],
Cell[10463, 227, 187, 5, 28, InheritFromParent],
Cell[CellGroupData[{
Cell[10675, 236, 762, 25, 63, "Input"],
Cell[11440, 263, 7768, 135, 368, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19245, 403, 282, 8, 28, "Input"],
Cell[19530, 413, 139, 3, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19706, 421, 277, 7, 28, "Input"],
Cell[19986, 430, 88, 1, 62, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

