(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     78478,       1835]
NotebookOptionsPosition[     75202,       1722]
NotebookOutlinePosition[     75636,       1739]
CellTagsIndexPosition[     75593,       1736]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["01 Vectors - Answers", "Title",
 CellChangeTimes->{{3.543847653428233*^9, 3.5438476603879285`*^9}, {
  3.682791913689695*^9, 3.6827919154436893`*^9}}],

Cell["\<\
Submit your completed work by placing this file in your folder of M:\\Classes\
\\MATH213.\
\>", "Text",
 CellChangeTimes->{{3.543847682631153*^9, 3.543847690566946*^9}, {
  3.5442904675915427`*^9, 3.5442905126305428`*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Introduction"
}], "Section",
 CellChangeTimes->{{3.5438457632552347`*^9, 3.543845768166725*^9}}],

Cell[CellGroupData[{

Cell["Exercise 1 - 4 pts", "Subsection",
 CellChangeTimes->{{3.543848529190366*^9, 3.543848532397045*^9}, {
  3.682792747379746*^9, 3.682792781281335*^9}}],

Cell[TextData[{
 "Consider the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", 
    RowBox[{
     SuperscriptBox["x", "3"], "-", 
     RowBox[{"cos", "(", 
      RowBox[{"2", "x"}], ")"}]}]}], TraditionalForm]]],
 ".  Find the exact value and a numerical approximation of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "4", ")"}], TraditionalForm]]],
 ".  Graph ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]]],
 " on the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "2"}], "]"}], TraditionalForm]]],
 ".  Find ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "'"}], 
    RowBox[{"(", "x", ")"}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "2"}], "2"], 
    RowBox[{
     RowBox[{"f", "(", "x", ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]]],
 " .",
 StyleBox[" yup 4/4.",
  Background->RGBColor[1, 0.9, 0.8]]
}], "Text",
 CellChangeTimes->{{3.543848544460839*^9, 3.54384854665162*^9}, {
  3.543848614069877*^9, 3.5438489371811056`*^9}, {3.5438494653751054`*^9, 
  3.543849467022105*^9}, {3.6827966169876423`*^9, 3.682796626977572*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"y", "=", 
   RowBox[{
    SuperscriptBox["x", "3"], "-", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", "x"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"y", "/.", 
  RowBox[{"x", "\[Rule]", "4"}]}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", "%", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"y", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"D", "[", 
  RowBox[{"y", ",", "x"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{"y", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.5438489462161055`*^9, 3.5438490370001054`*^9}, 
   3.5438496182251053`*^9, {3.6827922328576612`*^9, 3.6827922333199673`*^9}}],

Cell[BoxData[
 RowBox[{"64", "-", 
  RowBox[{"Cos", "[", "8", "]"}]}]], "Output",
 CellChangeTimes->{3.543849038411105*^9, 3.5438496198321056`*^9, 
  3.6827922345669937`*^9}],

Cell[BoxData["64.14550003380862`"], "Output",
 CellChangeTimes->{3.543849038411105*^9, 3.5438496198321056`*^9, 
  3.682792234576653*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwtmXk0VP//x2WvfNAmyl6WJBGR9T0hrSRbiqxZolVEJSTJVkmRJCqRLWQp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      "]]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->{188.6666666666666, Automatic},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-2, 2}, {-7.346355275985009, 8.653642764831398}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.543849038411105*^9, 3.5438496198321056`*^9, 
  3.6827922346388807`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "x"}], "]"}]}]}]], "Output",
 CellChangeTimes->{3.543849038411105*^9, 3.5438496198321056`*^9, 
  3.682792234649847*^9}],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Sin", "[", "4", "]"}]}]], "Output",
 CellChangeTimes->{3.543849038411105*^9, 3.5438496198321056`*^9, 
  3.682792234700316*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2 - 4 pts", "Subsection",
 CellChangeTimes->{{3.543849497517105*^9, 3.543849500588105*^9}, {
  3.682792784497161*^9, 3.682792786809451*^9}}],

Cell["Now, using function syntax:", "Text",
 CellChangeTimes->{{3.682792064731707*^9, 3.682792070297338*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"myY", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"x", "^", "3"}], "-", 
   RowBox[{"Cos", "[", 
    RowBox[{"2", "x"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"myY", "[", "4", "]"}], ",", 
   RowBox[{"myY", "[", "4.0", "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"myY", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"myY", "[", "x", "]"}], ",", "x"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"myY", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{{3.682792078136084*^9, 3.682792198536538*^9}, {
  3.6827922663050623`*^9, 3.68279227108081*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"64", "-", 
    RowBox[{"Cos", "[", "8", "]"}]}], ",", "64.14550003380862`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.682792202722623*^9, {3.682792271908896*^9, 3.68279227914686*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwtmXk0VP//x2WvfNAmyl6WJBGR9T0hrSRbiqxZolVEJSTJVkmRJCqRLWQp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      "]]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-2, 2}, {-7.346355275985009, 8.653642764831398}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.682792202722623*^9, {3.682792271908896*^9, 3.6827922791970177`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "x"}], "]"}]}]}]], "Output",
 CellChangeTimes->{
  3.682792202722623*^9, {3.682792271908896*^9, 3.6827922792045937`*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Sin", "[", "4", "]"}]}]], "Output",
 CellChangeTimes->{
  3.682792202722623*^9, {3.682792271908896*^9, 3.682792279249082*^9}}],

Cell[BoxData["0.7568024953079282`"], "Output",
 CellChangeTimes->{
  3.682792202722623*^9, {3.682792271908896*^9, 3.68279227925602*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3 - 2 pts", "Subsection",
 CellChangeTimes->{{3.543849497517105*^9, 3.543849500588105*^9}, {
  3.682792054188003*^9, 3.6827920547699127`*^9}, {3.6827927936408863`*^9, 
  3.682792800320815*^9}, {3.682796900926219*^9, 3.682796901262145*^9}}],

Cell[TextData[{
 "Attempt to find an approximate solution to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", "0"}], TraditionalForm]]],
 " using the ",
 StyleBox["NSolve", "Input"],
 " function.  "
}], "Text",
 CellChangeTimes->{{3.543849503918105*^9, 3.5438497328441057`*^9}, 
   3.5438497678611054`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"y", "\[Equal]", "0"}], ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{3.543849624958105*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NSolve", "::", "nsmet"}], "MessageName"], ":", 
  " ", "\<\"This system cannot be solved with the methods available to \
NSolve. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/NSolve\\\", ButtonNote -> \
\\\"NSolve::nsmet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.5438496257431054`*^9}],

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "3"], "-", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}]}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Output",
 CellChangeTimes->{3.5438496257441053`*^9}]
}, Open  ]],

Cell[TextData[{
 "When that does not work, place the cursor on ",
 StyleBox["NSolve", "Input"],
 " and press the ",
 Cell[BoxData[
  FormBox["F1", TraditionalForm]]],
 " key or select Help | Find Selected Function.  This should open a help page \
on NSolve.  Notice the numerous examples showing how to use the NSolve \
function.  Click on the ",
 Cell[BoxData[
  FormBox[
   FrameBox[
    RowBox[{
     RowBox[{"See", " ", "Also"}], " ", ">>"}]], TraditionalForm]]],
 "  button and explore until you find a function that can find an approximate \
solution to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", "0"}], TraditionalForm]]],
 ".  Do it!"
}], "Text",
 CellChangeTimes->{{3.5438497719661055`*^9, 3.5438499613981056`*^9}, {
  3.543850058524105*^9, 3.543850063397105*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"y", "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", ".6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.543849988371105*^9, 3.5438500020941057`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "0.6477654334582033`"}], "}"}]], "Output",
 CellChangeTimes->{3.543850003194105*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vectors in the Plane", "Section",
 CellChangeTimes->{{3.543844327991749*^9, 3.543844329173684*^9}, {
  3.5438513565971055`*^9, 3.5438513585001054`*^9}}],

Cell[CellGroupData[{

Cell["Exercise 4 - 4 pts", "Subsection",
 CellChangeTimes->{{3.5442233059790325`*^9, 3.544223308328167*^9}, {
  3.682792388735826*^9, 3.682792389389801*^9}, {3.6827928076169567`*^9, 
  3.682792809336871*^9}, {3.682796892552726*^9, 3.6827968965820227`*^9}}],

Cell[TextData[{
 "Choose a variety of values for u, v, a, b, m, and n in the above commands \
to investigate the following.  Give a precise geometric description of the \
relationship among the vectors ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"a", " ", 
     StyleBox["u",
      FontWeight->"Bold"]}], "+", 
    RowBox[{"b", " ", 
     StyleBox["v",
      FontWeight->"Bold"]}]}], TraditionalForm]]],
 ".  State what choices of ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 " it would ",
 StyleBox["not",
  FontVariations->{"Underline"->True}],
 " be possible to obtain all vectors (with base at the origin) as a linear \
combination of ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.544223401344487*^9, 3.5442235161610537`*^9}, {
  3.544223719911708*^9, 3.544223721726812*^9}, {3.544284938247917*^9, 
  3.544284965339917*^9}, {3.5442850077469177`*^9, 3.544285256275917*^9}}],

Cell[TextData[{
 StyleBox["To obtain ",
  FontWeight->"Bold"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"a", " ", 
     StyleBox["u",
      FontWeight->"Bold"]}], "+", 
    RowBox[{"b", " ", 
     StyleBox["v",
      FontWeight->"Bold"]}]}], TraditionalForm]],
  FontWeight->"Bold"],
 StyleBox[", start at the origin, move ",
  FontWeight->"Bold"],
 Cell[BoxData[
  FormBox["a", TraditionalForm]],
  FontWeight->"Bold"],
 StyleBox[" lengths of ",
  FontWeight->"Bold"],
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]],
  FontWeight->"Bold"],
 StyleBox[" in the direction of ",
  FontWeight->"Bold"],
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]],
  FontWeight->"Bold"],
 StyleBox[", and move ",
  FontWeight->"Bold"],
 Cell[BoxData[
  FormBox["b", TraditionalForm]],
  FontWeight->"Bold"],
 StyleBox[" lengths of ",
  FontWeight->"Bold"],
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]],
  FontWeight->"Bold"],
 StyleBox[" in the direction of ",
  FontWeight->"Bold"],
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]],
  FontWeight->"Bold"],
 StyleBox[".  \n\nIt would ",
  FontWeight->"Bold"],
 StyleBox["not",
  FontWeight->"Bold",
  FontVariations->{"Underline"->True}],
 StyleBox[" be possible to obtain all vectors (with base at the origin) as a \
linear combination of ",
  FontWeight->"Bold"],
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]],
  FontWeight->"Bold"],
 StyleBox[" and ",
  FontWeight->"Bold"],
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]],
  FontWeight->"Bold"],
 StyleBox[" if and only if they are parallel.",
  FontWeight->"Bold"]
}], "Text",
 CellChangeTimes->{{3.5442235329750156`*^9, 3.5442237726167226`*^9}, {
  3.544285278570917*^9, 3.5442853300669174`*^9}, {3.682793869216382*^9, 
  3.6827938697263412`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise [not in 2016]", "Subsection",
 CellChangeTimes->{{3.54422479886242*^9, 3.5442248007985315`*^9}, {
  3.682792440270656*^9, 3.682792445245195*^9}}],

Cell[TextData[{
 "Add a line passing through ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 " to the previous graph.  Do not change the above commands.  Enter commands \
below that create a graph of the line and then shows both graphs together."
}], "Text",
 CellChangeTimes->{{3.544224854230587*^9, 3.5442249854930954`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"plot4", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "t"}], ")"}], "u"}], "+", 
      RowBox[{"t", " ", "v"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "m"}], ",", "m"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plot3", ",", "plot4"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5442247035759706`*^9, 3.544224730407505*^9}, {
  3.5442247700887747`*^9, 3.544224773648978*^9}}],

Cell[BoxData[
 GraphicsBox[{{
    {Dashing[{0, Small}], Arrowheads[
     0.02], {ArrowBox[{{-9, 4}, {-8, 2}}], ArrowBox[{{-6, 5}, {-5, 3}}], 
      ArrowBox[{{-3, 6}, {-2, 4}}], ArrowBox[{{0, 7}, {1, 5}}], 
      ArrowBox[{{3, 8}, {4, 6}}]}, {ArrowBox[{{-8, 2}, {-7, 0}}], 
      ArrowBox[{{-5, 3}, {-4, 1}}], ArrowBox[{{-2, 4}, {-1, 2}}], 
      ArrowBox[{{1, 5}, {2, 3}}], ArrowBox[{{4, 6}, {5, 4}}]}, {
      ArrowBox[{{-7, 0}, {-6, -2}}], ArrowBox[{{-4, 1}, {-3, -1}}], 
      ArrowBox[{{-1, 2}, {0, 0}}], ArrowBox[{{2, 3}, {3, 1}}], 
      ArrowBox[{{5, 4}, {6, 2}}]}, {ArrowBox[{{-6, -2}, {-5, -4}}], 
      ArrowBox[{{-3, -1}, {-2, -3}}], ArrowBox[{{0, 0}, {1, -2}}], 
      ArrowBox[{{3, 1}, {4, -1}}], ArrowBox[{{6, 2}, {7, 0}}]}, {
      ArrowBox[{{-5, -4}, {-4, -6}}], ArrowBox[{{-2, -3}, {-1, -5}}], 
      ArrowBox[{{1, -2}, {2, -4}}], ArrowBox[{{4, -1}, {5, -3}}], 
      ArrowBox[{{7, 0}, {8, -2}}]}, {ArrowBox[{{-4, -6}, {-3, -8}}], 
      ArrowBox[{{-1, -5}, {0, -7}}], ArrowBox[{{2, -4}, {3, -6}}], 
      ArrowBox[{{5, -3}, {6, -5}}], ArrowBox[{{8, -2}, {9, -4}}]}, {
      ArrowBox[{{-9, 4}, {-6, 5}}], ArrowBox[{{-6, 5}, {-3, 6}}], 
      ArrowBox[{{-3, 6}, {0, 7}}], ArrowBox[{{0, 7}, {3, 8}}]}, {
      ArrowBox[{{-8, 2}, {-5, 3}}], ArrowBox[{{-5, 3}, {-2, 4}}], 
      ArrowBox[{{-2, 4}, {1, 5}}], ArrowBox[{{1, 5}, {4, 6}}]}, {
      ArrowBox[{{-7, 0}, {-4, 1}}], ArrowBox[{{-4, 1}, {-1, 2}}], 
      ArrowBox[{{-1, 2}, {2, 3}}], ArrowBox[{{2, 3}, {5, 4}}]}, {
      ArrowBox[{{-6, -2}, {-3, -1}}], ArrowBox[{{-3, -1}, {0, 0}}], 
      ArrowBox[{{0, 0}, {3, 1}}], ArrowBox[{{3, 1}, {6, 2}}]}, {
      ArrowBox[{{-5, -4}, {-2, -3}}], ArrowBox[{{-2, -3}, {1, -2}}], 
      ArrowBox[{{1, -2}, {4, -1}}], ArrowBox[{{4, -1}, {7, 0}}]}, {
      ArrowBox[{{-4, -6}, {-1, -5}}], ArrowBox[{{-1, -5}, {2, -4}}], 
      ArrowBox[{{2, -4}, {5, -3}}], ArrowBox[{{5, -3}, {8, -2}}]}, {
      ArrowBox[{{-3, -8}, {0, -7}}], ArrowBox[{{0, -7}, {3, -6}}], 
      ArrowBox[{{3, -6}, {6, -5}}], ArrowBox[{{6, -5}, {9, -4}}]}}, 
    {Thickness[Large], Dashing[{}], Arrowheads[0.03], InsetBox[
      StyleBox["\<\"u\"\>",
       StripOnInput->False,
       FontSize->Larger,
       FontWeight->Bold], {1.1, -2.2},
      Background->GrayLevel[1]], ArrowBox[{{0, 0}, {1, -2}}], InsetBox[
      StyleBox["\<\"v\"\>",
       StripOnInput->False,
       FontSize->Larger,
       FontWeight->Bold], {3.3000000000000003, 1.1},
      Background->GrayLevel[1]], ArrowBox[{{0, 0}, {3, 1}}], InsetBox[
      StyleBox["\<\"au+bv\"\>",
       StripOnInput->False,
       FontSize->Larger,
       FontWeight->Bold], {-1.1, -5.5},
      Background->GrayLevel[1]], ArrowBox[{{0, 0}, {-1, -5}}]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxF1H8w1HkYwPG1LWr9yNplt+9nV2y71cb2Q7Up9H1ypSKMVXeIatjMNoVS
bRfpx1V75+eJqDMXVxupZNgMGen7CclxruLqUOd3xVHRyiJ7XTc13TPzzHvm
Nc/fj0NYtHwnnUaj+Xzc//ppOPhT52Ktd6LMdYqN7916qXQyiHH4OU6kapyN
E/c9eBQ4Kca1CyXtQ8NszO7N0ZSMirE6VF7a1s3G4jr39eEDYmxReVl5s4aN
vZLjUuuaxZiv2vgo4ns2zuTp+Sl5YiwbSr/UZMnGkiWvVxLeYuy2ePyY/wxr
LBVNzjaoRVhrX7NdYsPC6sBm084Hc3DExerNjWIrbD5x5lggfw5u1M2fsX6t
Jd6zNVqTHSTENwznInO3m2OHD7xfn2ocsLT8+nqFnIlLFF3ZzzvssejM/E1V
vtNxlOzHKbXAHhtq9m65E2mC/0nnYN9mO6zKD/3DUcHAf7p5dtp7C3BTt03g
mng6Dt5lRR/5C+Ec9xUmg7k0vDzq6trhQwTmpE8G0JcZqLqx+M7jOh4uDhbk
HY2coOj0wfiZCVz8w3cJ3S1b3lG6tIwDi2i2eNPg/Rh//xHKbZyZdPQoBxeY
rUKrRYPU4h4ir9GWjRd8UM1LmtZLtfpFcK+lsfC3hdUpw+1PKEfwSlGLrHBX
qO5FRUEFFaFsKetfaoGLdR9S+vbXkBKj4nShlInNGWHdzfWt5OrcqoOBwab4
xga/l/NS+0hqrceMEi8GbnDEXp7SITLzjV5jHG2E1Z6edGbLCCnLypra+5WB
esPt1Z3rekfyQhyt+Yv0VMaKgaePCybIPCehjPpuhJrS57WuqjaQ5jxLlV/F
C6rKdQN27aOBaOmFKWefx1S2MGamtpYO+O1PmUmnM8i2IH1/ZRMD5srOD/5+
uY2UuZRUCUpNYLX/vBitSz9JjBkpB9Omg3+PsUu1doRUMIp+3pTFBCcL5pPn
1XqyoSL1N+PD5rBNWriTtdtAnqUa1PJTlrBt9uKGuDojcC8T5MTJrOCWMKg9
RsMA1ZGLvdPmsiDsYN81sxhT6Ppb/vqxxBp+weMNJ+KZ0FaYMxbAZ0OiybPe
95stgM7l1aI5HDglFOVfXWYFb4dDjswS28CeXUmr8stZEGPn5lxjYwvXpMGN
l+3ZIBzdcKOM4IJz1Ktp1gUc2CEYFn9tyQMrp36XEx/vFGVhCY4GHmSxOL53
47iQradrvWgEROxnmO2lzYJtye6tNm8JSJaH1NrvJsAp69lxnzECPLq91hzY
R8D73DjJ6UkC9NEr79w/RMD5mxWxo3QEihTbW1GnCGhpXy5oYSNwrX94/fYF
AtZJFoalLUcw4L4uI/AhAdI6uyHmYfTFpx5UnfWIRzBZzu/sdUXQ0BbiHnsC
QbGnWcgKDwTKV9mpAwkI+Ir+LR2+CDQc7pL6bAS6nEsbnZQIbMNnqk7fRnDp
sz/fU2RXhREEaYyL0EUEpSqf+6O1CCydRxdEX0EQkJjEUzQhiPN7JLItRZBc
Ylrp0YFA/tm3VuaHx/YgMJ0Vm1negmDBvXXm2hcI7lxRWpu1I7jXejLU4Q0C
yWc/2yM0CdIh6AhYlmD8CkHY0N2iNP3/vnRsxzf17xF472OdLJxA8Olv8b/0
Xzo7I/A=
      "]]}}},
  Axes->True,
  ImageSize->{182.00000000000009`, Automatic}]], "Output",
 CellChangeTimes->{3.5442247336966934`*^9, 3.5442247750360575`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vectors in Three Dimensions", "Section",
 CellChangeTimes->{{3.5442238479500313`*^9, 3.5442238547164183`*^9}}],

Cell[CellGroupData[{

Cell["Exercise 5 - 4 pts", "Subsection",
 CellChangeTimes->{{3.5442854817239175`*^9, 3.5442854844989176`*^9}, {
  3.682792815592442*^9, 3.6827928231287613`*^9}}],

Cell[TextData[{
 "Add to the above graph the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"c", "=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], ",", 
      RowBox[{"-", "5"}], ",", 
      RowBox[{"-", "8"}]}], ")"}]}], TraditionalForm]]],
 " and the line segments ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["ab", "_"], TraditionalForm]],
  FontSlant->"Italic"],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox[
     StyleBox["bc",
      FontSlant->"Italic"], "_"],
    FontSlant->"Italic"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox[
     StyleBox["ca",
      FontSlant->"Italic"], "_"],
    FontSlant->"Italic"], TraditionalForm]]],
 ".  Explain in what way the hand sketch looks different and why."
}], "Text",
 CellChangeTimes->{{3.5442854998039174`*^9, 3.5442855312509174`*^9}, {
  3.5442857787319174`*^9, 3.5442859677640142`*^9}, {3.5442860469699345`*^9, 
  3.5442860929975367`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "5"}], ",", 
     RowBox[{"-", "8"}]}], "}"}]}], ";", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"myAxis", "[", 
       RowBox[{"\"\<x\>\"", ",", "Orange", ",", "1", ",", 
        RowBox[{"-", "2"}], ",", "7"}], "]"}], ",", 
      RowBox[{"myAxis", "[", 
       RowBox[{"\"\<y\>\"", ",", 
        RowBox[{"Darker", "[", "Yellow", "]"}], ",", "2", ",", 
        RowBox[{"-", "5"}], ",", "7"}], "]"}], ",", 
      RowBox[{"myAxis", "[", 
       RowBox[{"\"\<z\>\"", ",", "Green", ",", "3", ",", 
        RowBox[{"-", "9"}], ",", "8"}], "]"}], ",", 
      RowBox[{"myPoint", "[", 
       RowBox[{"a", ",", "Black"}], "]"}], ",", 
      RowBox[{"myPoint", "[", 
       RowBox[{"b", ",", "Black"}], "]"}], ",", 
      RowBox[{"myPoint", "[", 
       RowBox[{"c", ",", "Black"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{"a", ",", "b"}], "}"}], "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{"a", ",", "c"}], "}"}], "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{"b", ",", "c"}], "}"}], "]"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"Axes", "\[Rule]", "True"}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"100", ",", "100", ",", "100"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.544188998883645*^9, 3.544189003768761*^9}, {
   3.5441897207364597`*^9, 3.5441897323461676`*^9}, {3.544190060055626*^9, 
   3.54419009446349*^9}, {3.5441901254087315`*^9, 3.5441901463092475`*^9}, {
   3.544190177415721*^9, 3.5441902335381937`*^9}, 3.5441902947152634`*^9, {
   3.5441904213970203`*^9, 3.5441904708429275`*^9}, {3.544191432467061*^9, 
   3.5441914326231127`*^9}, {3.544191466267708*^9, 3.544191473633315*^9}, 
   3.5441915498818345`*^9, {3.5441915858838005`*^9, 3.544191637041529*^9}, {
   3.5441952332194257`*^9, 3.5441952922172594`*^9}, {3.544227068842256*^9, 
   3.5442270705913563`*^9}, {3.544227108415519*^9, 3.544227136351117*^9}, {
   3.54422717940758*^9, 3.544227211334406*^9}, {3.544227258272091*^9, 
   3.5442272583830967`*^9}, {3.544264576475616*^9, 3.544264578367724*^9}, {
   3.544264611410614*^9, 3.5442647285733156`*^9}, {3.5442655755097575`*^9, 
   3.5442656265276756`*^9}, {3.544265668290064*^9, 3.5442656717772636`*^9}, {
   3.5442657178929014`*^9, 3.5442657435013657`*^9}, {3.5442683095971384`*^9, 
   3.544268333300494*^9}, {3.544268372027709*^9, 3.5442684125960293`*^9}, {
   3.544271170958799*^9, 3.5442711717258425`*^9}, {3.5442792389278936`*^9, 
   3.544279242872288*^9}, {3.544279277134714*^9, 3.5442792808680873`*^9}, {
   3.5442793221212125`*^9, 3.54427934140314*^9}, 3.54428111298731*^9, {
   3.544284734286769*^9, 3.544284743923805*^9}, 3.5442855764729176`*^9, {
   3.5442856103849173`*^9, 3.5442856393849173`*^9}, {3.5442857099219174`*^9, 
   3.544285723360917*^9}, {3.544286375169751*^9, 3.5442864053797717`*^9}}],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.5, 0], Text3DBox[
    FormBox["\<\"x\"\>", StandardForm], {7.3500000000000005`, 0., 0.}], 
   {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {7, 0, 0}}], 
    {Dashing[{Small, Small}], Line3DBox[{{-2, 0, 0}, {0, 0, 0}}]}, 
    {RGBColor[
      NCache[
       Rational[2, 3], 0.6666666666666666], 
      NCache[
       Rational[2, 3], 0.6666666666666666], 0], Dashing[{}], Text3DBox[
      FormBox["\<\"y\"\>", StandardForm], {0., 7.3500000000000005`, 0.}], 
     {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 7, 0}}], 
      {Dashing[{Small, Small}], Line3DBox[{{0, -5, 0}, {0, 0, 0}}]}, 
      {RGBColor[0, 1, 0], Dashing[{}], Text3DBox[
        FormBox["\<\"z\"\>", StandardForm], {0., 0., 8.4}], 
       {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 0, 8}}], 
        {Dashing[{Small, Small}], Line3DBox[{{0, 0, -9}, {0, 0, 0}}]}, 
        {GrayLevel[0], Dashing[{Small, Small}], 
         Line3DBox[{{3, 0, 0}, {3, 0, 0}, {3, 0, 1}}], 
         {PointSize[Medium], Point3DBox[{3, 0, 1}], 
          {GrayLevel[0], Dashing[{Small, Small}], 
           Line3DBox[{{2, 0, 0}, {2, 3, 0}, {2, 3, 5}}], 
           {PointSize[Medium], Point3DBox[{2, 3, 5}], 
            {GrayLevel[0], Dashing[{Small, Small}], 
             Line3DBox[{{-2, 0, 0}, {-2, -5, 0}, {-2, -5, -8}}], 
             {PointSize[Medium], Point3DBox[{-2, -5, -8}], 
              {RGBColor[0, 0, 1], Dashing[{}], 
               Line3DBox[{{3, 0, 1}, {2, 3, 5}}], 
               Line3DBox[{{3, 0, 1}, {-2, -5, -8}}], 
               Line3DBox[{{2, 3, 5}, {-2, -5, -8}}]}}}}}}}}}}}}},
  Axes->True,
  ImageSize->{182.79692592702392`, Automatic},
  ViewPoint->{91.48391453239836, 109.56246400838167`, 98.116053030281},
  ViewVertical->{0.15715519747121287`, -0.06909050990787098, 
   0.9952204355977663}]], "Output",
 CellChangeTimes->{3.544286127325969*^9, 3.544286380298264*^9, 
  3.544286411549389*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "The hand sketch x-axis scale is not linear (0 to 1 is longer than 1 to 2) \
while the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " scales are linear.  "
}], "Text",
 CellChangeTimes->{{3.5442861461798544`*^9, 3.5442862601192474`*^9}, 
   3.5442864385370874`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6 - 2 pts", "Subsection",
 CellChangeTimes->{{3.5442864645226855`*^9, 3.5442864672429576`*^9}, {
  3.6827928285126762`*^9, 3.682792831464513*^9}}],

Cell[TextData[{
 "Graph the three axes to match the view point given in this diagram.\n  ",
 Cell[BoxData[
  GraphicsBox[
   TagBox[RasterBox[CompressedData["
1:eJzt3D1PG1kYhuEj7TSUadIvHRX9dlugNFRu6OPCjaWVVoo0XSoXpN1iXbqI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     "], {{0, 193}, {224, 0}}, {0, 255},
     ColorFunction->RGBColor],
    BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
    Selectable->False],
   BaseStyle->"ImageGraphics",
   ImageSize->{123.99999999999967`, Automatic},
   ImageSizeRaw->{224, 193},
   PlotRange->{{0, 224}, {0, 193}}]],
  CellChangeTimes->{
   3.544195665069894*^9, {3.5441956963549113`*^9, 3.5441957758713474`*^9}, {
    3.5441958068765025`*^9, 3.544195821559396*^9}, {3.544195858774744*^9, 
    3.544195863362173*^9}}]
}], "Text",
 CellChangeTimes->{{3.5442864799402275`*^9, 3.544286487276961*^9}, {
  3.544286853217551*^9, 3.544286897661995*^9}, {3.5442869853037586`*^9, 
  3.5442870219774256`*^9}, {3.544287111396366*^9, 3.544287111803407*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", "Thick", "}"}], ",", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<x\>\"", ",", "Orange", ",", "1", ",", "0", ",", "2"}], 
      "]"}], ",", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<y\>\"", ",", 
       RowBox[{"Darker", "[", "Yellow", "]"}], ",", "2", ",", "0", ",", "2"}],
       "]"}], ",", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<z\>\"", ",", "Green", ",", "3", ",", "0", ",", "4"}], 
      "]"}]}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100", ",", 
      RowBox[{"-", "100"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5442794950785065`*^9, 3.54427954061806*^9}, {
   3.544279573998398*^9, 3.5442795753415318`*^9}, {3.544286568354068*^9, 
   3.5442866234715786`*^9}, 3.544286663667598*^9, {3.544286694422673*^9, 
   3.5442867254807787`*^9}, {3.5442868018254128`*^9, 3.54428681980221*^9}, {
   3.544286902155444*^9, 3.544286908259055*^9}, {3.544287032672495*^9, 
   3.544287092765504*^9}}],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.5, 0], Thickness[Large], Text3DBox[
    FormBox["\<\"x\"\>", StandardForm], {2.1, 0., 0.}], 
   {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {2, 0, 0}}], 
    {RGBColor[
      NCache[
       Rational[2, 3], 0.6666666666666666], 
      NCache[
       Rational[2, 3], 0.6666666666666666], 0], Text3DBox[
      FormBox["\<\"y\"\>", StandardForm], {0., 2.1, 0.}], 
     {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 2, 0}}], 
      {RGBColor[0, 1, 0], Text3DBox[
        FormBox["\<\"z\"\>", StandardForm], {0., 0., 4.2}], 
       {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 0, 4}}]}}}}}},
  Axes->True,
  ImageSize->{163.18440211923536`, Automatic},
  ViewPoint->{100, 100, -100}]], "Output",
 CellChangeTimes->{{3.544286546357868*^9, 3.5442866245636883`*^9}, 
   3.54428666448368*^9, {3.5442866980930405`*^9, 3.544286726175848*^9}, {
   3.5442868027745075`*^9, 3.544286820425272*^9}, 3.544286913771606*^9, {
   3.544287044505678*^9, 3.544287093421569*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Lines in Three Dimensions", "Section",
 CellChangeTimes->{{3.544287151727399*^9, 3.544287159864213*^9}, {
  3.544288306376198*^9, 3.544288308352*^9}}],

Cell[CellGroupData[{

Cell["Exercise 7 - 2 pts", "Subsection",
 CellChangeTimes->{{3.544289255654543*^9, 3.544289263358543*^9}, {
  3.682792840112515*^9, 3.6827928420567083`*^9}}],

Cell[TextData[{
 "Choose a variety of values for ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]]],
 " in the above manipulator to investigate the following.  Give a precise \
geometric description of the vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["r",
      FontWeight->"Bold"], "(", "t", ")"}], "=", 
    RowBox[{
     SubscriptBox["P", "0"], "+", 
     RowBox[{"t", " ", 
      StyleBox["v",
       FontWeight->"Bold"]}]}]}], TraditionalForm]]],
 ". "
}], "Text",
 CellChangeTimes->{{3.5442892673215427`*^9, 3.5442892981835427`*^9}, {
  3.5442893996575427`*^9, 3.544289419817543*^9}}],

Cell[TextData[{
 "To obtain ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["r",
     FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
 ", start at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "0"], TraditionalForm]]],
 " and move ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]]],
 " lengths of ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 " in the direction of ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 ".  "
}], "Text",
 CellChangeTimes->{
  3.544289362338543*^9, {3.5442894526465425`*^9, 3.5442895083515425`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8 - 3 pts", "Subsection",
 CellChangeTimes->{{3.544289534902543*^9, 3.5442895364865427`*^9}, {
  3.682792847520515*^9, 3.6827928498723507`*^9}}],

Cell[TextData[{
 "Graph the lines ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["r",
       FontWeight->"Bold"], "1"], "(", "t", ")"}], "=", 
    RowBox[{
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{"1", ",", "0", ",", "1"}], "\[RightAngleBracket]"}], "+", 
     RowBox[{"t", 
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{"3", ",", "3", ",", "5"}], "\[RightAngleBracket]"}]}]}]}], 
   TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["r",
       FontWeight->"Bold"], "2"], "(", "t", ")"}], "=", 
    RowBox[{
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{"3", ",", "6", ",", "1"}], "\[RightAngleBracket]"}], "+", 
     RowBox[{"t", 
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{"4", ",", 
        RowBox[{"-", "2"}], ",", "7"}], "\[RightAngleBracket]"}]}]}]}], 
   TraditionalForm]]],
 " in a manner that makes it clear that the two lines either do or do not \
intersect.  See Section 13.2 Example 5."
}], "Text",
 CellChangeTimes->{{3.544289548350543*^9, 3.5442896890385427`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], ";", 
  RowBox[{"v1", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "5"}], "}"}]}], ";", 
  RowBox[{"p2", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "6", ",", "1"}], "}"}]}], ";", 
  RowBox[{"v2", "=", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"-", "2"}], ",", "7"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Join", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<x\>\"", ",", "Orange", ",", "1", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<y\>\"", ",", 
       RowBox[{"Darker", "[", "Yellow", "]"}], ",", "2", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<z\>\"", ",", "Green", ",", "3", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"Black", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"p1", "-", 
           RowBox[{"3", "v1"}]}], ",", 
          RowBox[{"p1", "+", 
           RowBox[{"3", "v1"}]}]}], "}"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"Blue", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"p2", "-", 
           RowBox[{"2", "v2"}]}], ",", 
          RowBox[{"p2", "+", 
           RowBox[{"2", "v2"}]}]}], "}"}], "]"}]}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100", ",", "100"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.5442897223965425`*^9, 3.544289759185543*^9}, {
  3.5442897953635426`*^9, 3.5442898635405426`*^9}, {3.544290302780543*^9, 
  3.5442903298685427`*^9}}],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.5, 0], Text3DBox[
    FormBox["\<\"x\"\>", StandardForm], {5.25, 0., 0.}], 
   {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {5, 0, 0}}], 
    {Dashing[{Small, Small}], Line3DBox[{{-5, 0, 0}, {0, 0, 0}}]}, 
    {RGBColor[
      NCache[
       Rational[2, 3], 0.6666666666666666], 
      NCache[
       Rational[2, 3], 0.6666666666666666], 0], Dashing[{}], Text3DBox[
      FormBox["\<\"y\"\>", StandardForm], {0., 5.25, 0.}], 
     {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 5, 0}}], 
      {Dashing[{Small, Small}], Line3DBox[{{0, -5, 0}, {0, 0, 0}}]}, 
      {RGBColor[0, 1, 0], Dashing[{}], Text3DBox[
        FormBox["\<\"z\"\>", StandardForm], {0., 0., 5.25}], 
       {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 0, 5}}], 
        {Dashing[{Small, Small}], Line3DBox[{{0, 0, -5}, {0, 0, 0}}]}, 
        {GrayLevel[0], Dashing[{}], Line3DBox[{{-8, -9, -14}, {10, 9, 16}}], 
         {RGBColor[0, 0, 1], Line3DBox[{{-5, 10, -13}, {11, 2, 15}}]}}}}}}}},
  Axes->True,
  ImageSize->{217.95254283505014`, 306.6666666666667},
  ViewPoint->{72.15948039869357, 113.81373533208881`, 108.80920475009358`},
  ViewVertical->{-0.44440737854013845`, -0.749927525418448, 
   0.8337865398658387}]], "Output",
 CellChangeTimes->{{3.544289836544543*^9, 3.544289864694543*^9}, 
   3.5442903373285427`*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{905, 800},
WindowMargins->{{Automatic, -207}, {37, Automatic}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"11.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (July 28, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 156, 2, 92, "Title"],
Cell[738, 26, 232, 5, 30, "Text"],
Cell[CellGroupData[{
Cell[995, 35, 164, 5, 64, "Section"],
Cell[CellGroupData[{
Cell[1184, 44, 155, 2, 44, "Subsection"],
Cell[1342, 48, 1252, 44, 59, "Text"],
Cell[CellGroupData[{
Cell[2619, 96, 860, 23, 138, "Input"],
Cell[3482, 121, 174, 4, 32, "Output"],
Cell[3659, 127, 136, 2, 32, "Output"],
Cell[3798, 131, 10593, 187, 131, "Output"],
Cell[14394, 320, 268, 8, 32, "Output"],
Cell[14665, 330, 166, 4, 32, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14880, 340, 155, 2, 44, "Subsection"],
Cell[15038, 344, 109, 1, 30, "Text"],
Cell[CellGroupData[{
Cell[15172, 349, 992, 28, 138, "Input"],
Cell[16167, 379, 240, 7, 32, "Output"],
Cell[16410, 388, 10548, 186, 238, "Output"],
Cell[26961, 576, 270, 8, 32, "Output"],
Cell[27234, 586, 166, 4, 32, "Output"],
Cell[27403, 592, 136, 2, 32, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27588, 600, 254, 3, 44, "Subsection"],
Cell[27845, 605, 337, 11, 31, "Text"],
Cell[CellGroupData[{
Cell[28207, 620, 155, 4, 32, "Input"],
Cell[28365, 626, 423, 9, 24, "Message"],
Cell[28791, 637, 273, 9, 35, "Output"]
}, Open  ]],
Cell[29079, 649, 810, 23, 81, "Text"],
Cell[CellGroupData[{
Cell[29914, 676, 233, 6, 32, "Input"],
Cell[30150, 684, 139, 3, 32, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30350, 694, 158, 2, 64, "Section"],
Cell[CellGroupData[{
Cell[30533, 700, 256, 3, 44, "Subsection"],
Cell[30792, 705, 1406, 51, 70, "Text"],
Cell[32201, 758, 1978, 76, 109, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34216, 839, 160, 2, 44, "Subsection"],
Cell[34379, 843, 468, 14, 50, "Text"],
Cell[CellGroupData[{
Cell[34872, 861, 569, 17, 54, "Input"],
Cell[35444, 880, 4558, 80, 206, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40063, 967, 116, 1, 64, "Section"],
Cell[CellGroupData[{
Cell[40204, 972, 161, 2, 44, "Subsection"],
Cell[40368, 976, 969, 35, 52, "Text"],
Cell[CellGroupData[{
Cell[41362, 1015, 3117, 63, 96, "Input"],
Cell[44482, 1080, 10354, 176, 279, 1827, 35, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[54851, 1259, 290, 8, 30, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[55178, 1272, 161, 2, 44, "Subsection"],
Cell[55342, 1276, 3019, 55, 140, "Text"],
Cell[CellGroupData[{
Cell[58386, 1335, 1134, 26, 54, "Input"],
Cell[59523, 1363, 1000, 21, 293, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[60584, 1391, 156, 2, 64, "Section"],
Cell[CellGroupData[{
Cell[60765, 1397, 157, 2, 44, "Subsection"],
Cell[60925, 1401, 621, 20, 52, "Text"],
Cell[61549, 1423, 636, 27, 32, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62222, 1455, 159, 2, 44, "Subsection"],
Cell[62384, 1459, 1117, 35, 51, "Text"],
Cell[CellGroupData[{
Cell[63526, 1498, 2064, 55, 201, "Input"],
Cell[65593, 1555, 9557, 161, 322, 1245, 24, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

