(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     11289,        351]
NotebookOptionsPosition[      8739,        282]
NotebookOutlinePosition[      9092,        298]
CellTagsIndexPosition[      9049,        295]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.734797520970106*^9, 
  3.734797521630393*^9}},ExpressionUUID->"8c01536f-eded-4e20-95a3-\
9aeb5f8841d9"],

Cell["#2 Dot product problem", "Text",
 CellChangeTimes->{{3.7347975303594027`*^9, 
  3.7347975391096478`*^9}},ExpressionUUID->"1fbae77e-ffc7-4ac1-bac6-\
dec64e4f219c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mya", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"u", "+", "v"}], ")"}], ",", "1", ",", "3"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myb", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "u"}], "+", 
       RowBox[{"3", "v"}], "+", "1"}], ")"}], ",", " ", "1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"mya", ".", "myb"}], "]"}]}], "Input",
 CellChangeTimes->{{3.734797547782444*^9, 3.7347977271801567`*^9}, {
   3.734797760020761*^9, 3.734797894730529*^9}, 
   3.734797962882782*^9},ExpressionUUID->"059eeacd-de82-4038-8e33-\
ecbfb46640e2"],

Cell[BoxData[
 RowBox[{"4", "+", 
  RowBox[{"4", " ", "u"}], "+", 
  RowBox[{"5", " ", "v"}]}]], "Output",
 CellChangeTimes->{
  3.7347982482831373`*^9},ExpressionUUID->"f6101b1e-e680-4b09-bccb-\
f51809007c2b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"%", "\[Equal]", "0"}], ",", "v"}], "]"}]], "Input",
 CellChangeTimes->{{3.734798251764312*^9, 
  3.734798263774434*^9}},ExpressionUUID->"f270c8da-000f-4de9-b3e1-\
56df33bc4f3b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"v", "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["4", "5"]}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "u"}], ")"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.734798264364094*^9},ExpressionUUID->"a85dacbd-024f-429e-a38b-\
1cf2435e5d52"]
}, Open  ]],

Cell["\[LineSeparator]\[LineSeparator]#4 cross product", "Text",
 CellChangeTimes->{{3.734798752424697*^9, 
  3.734798760857464*^9}},ExpressionUUID->"b4b0ac56-b43c-438e-92ef-\
0ab7f151492d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mya", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "5"}], ",", "1", ",", "3"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myb", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", " ", "2"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mya", ".", "myb"}]}], "Input",
 CellChangeTimes->{{3.734798779692113*^9, 
  3.734798845265277*^9}},ExpressionUUID->"e07fbc1b-318a-4347-bc40-\
6846d147acc7"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.734798845731311*^9},ExpressionUUID->"8b439f4e-3553-4821-a298-\
0b0e59bfca4a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mya", " ", "\[Cross]", " ", "myb"}]], "Input",
 CellChangeTimes->{{3.7347989962596617`*^9, 
  3.7347990106246147`*^9}},ExpressionUUID->"5a098301-67e1-4a9c-a14e-\
947a3ea0bf0a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "10"}], ",", "16", ",", 
   RowBox[{"-", "22"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.734799011499734*^9},ExpressionUUID->"f4183364-49e2-491a-8332-\
bf88220b7ca5"]
}, Open  ]],

Cell["\[LineSeparator]\[LineSeparator]#6", "Text",
 CellChangeTimes->{{3.7347998103904943`*^9, 
  3.73479981822406*^9}},ExpressionUUID->"a7f1b1c0-dab7-45b6-b8a5-\
1d136c8e0d9d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"myr", "[", "t_", "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"3", " ", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"-", "t"}], ")"}]}]}], ",", 
    RowBox[{"4", 
     RowBox[{"(", " ", 
      RowBox[{
       RowBox[{"Cos", "[", "t", "]"}], "+", "t"}], ")"}]}], ",", 
    RowBox[{
     RowBox[{"t", "^", "2"}], "/", "18"}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"myr", "[", "t", "]"}], "\[IndentingNewLine]", 
 RowBox[{"v", "=", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"myr", "[", "t", "]"}], ",", "t"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.734798829212731*^9, 3.734798832784164*^9}, {
  3.734799828518057*^9, 3.7347998579416647`*^9}, {3.734799950592741*^9, 
  3.734799985119322*^9}, {3.7348000360138063`*^9, 3.734800072010922*^9}, {
  3.734800118923037*^9, 3.7348001767561197`*^9}, {3.7348003208694763`*^9, 
  3.734800321425281*^9}, {3.734800355314992*^9, 3.734800358927593*^9}, {
  3.7348004315122643`*^9, 3.734800460609235*^9}, {3.7348005210734253`*^9, 
  3.7348005435659637`*^9}, {3.734801387302649*^9, 3.734801388637834*^9}, {
  3.734801716628537*^9, 3.734801718097369*^9}, {3.734805929301087*^9, 
  3.734805936474409*^9}},ExpressionUUID->"2b086ae3-d1d3-43b7-89e7-\
52d74304ddd6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"3", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "t"}]]}], ",", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"t", "+", 
      RowBox[{"Cos", "[", "t", "]"}]}], ")"}]}], ",", 
   FractionBox[
    SuperscriptBox["t", "2"], "18"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.734801404402589*^9, {3.734801710745633*^9, 3.7348017188020563`*^9}, 
   3.734805937877413*^9},ExpressionUUID->"04bff056-a882-4af7-b402-\
702a25e772c1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "3"}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "t"}]]}], ",", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"Sin", "[", "t", "]"}]}], ")"}]}], ",", 
   FractionBox["t", "9"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.734801404402589*^9, {3.734801710745633*^9, 3.7348017188020563`*^9}, 
   3.734805937890842*^9},ExpressionUUID->"e65fc4d7-af23-4ce7-8094-\
f4b01bda2bbb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"v", "/.", 
  RowBox[{"t", "\[Rule]", "0"}]}], "\[IndentingNewLine]", 
 RowBox[{"v", "/.", 
  RowBox[{"t", "\[Rule]", "2."}]}], "\[IndentingNewLine]", 
 RowBox[{"Norm", "[", 
  RowBox[{"v", "/.", 
   RowBox[{"t", "\[Rule]", "0"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.734800233469446*^9, 3.734800253952182*^9}, {
  3.7348017237061787`*^9, 3.7348017428657227`*^9}, {3.7348059510655527`*^9, 
  3.734805969729698*^9}},ExpressionUUID->"c088fb59-d456-4582-83ae-\
bfb098abde60"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3"}], ",", "4", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.734800254530828*^9, 3.73480032989039*^9, 3.734800386069879*^9, 
   3.734800445028914*^9, 3.734800475288932*^9, 3.7348005507302628`*^9, 
   3.734801305835307*^9, 3.734801410519011*^9, {3.734801728468547*^9, 
   3.734801743880869*^9}, {3.73480594200311*^9, 
   3.734805970783445*^9}},ExpressionUUID->"2523bb9c-2028-4bbe-82b0-\
b0f86f77f4b9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.4060058497098381`"}], ",", "0.36281029269727316`", ",", 
   "0.2222222222222222`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.734800254530828*^9, 3.73480032989039*^9, 3.734800386069879*^9, 
   3.734800445028914*^9, 3.734800475288932*^9, 3.7348005507302628`*^9, 
   3.734801305835307*^9, 3.734801410519011*^9, {3.734801728468547*^9, 
   3.734801743880869*^9}, {3.73480594200311*^9, 
   3.734805970796047*^9}},ExpressionUUID->"30ad6e62-6102-406d-884a-\
3240476d60cb"],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{
  3.734800254530828*^9, 3.73480032989039*^9, 3.734800386069879*^9, 
   3.734800445028914*^9, 3.734800475288932*^9, 3.7348005507302628`*^9, 
   3.734801305835307*^9, 3.734801410519011*^9, {3.734801728468547*^9, 
   3.734801743880869*^9}, {3.73480594200311*^9, 
   3.734805970805235*^9}},ExpressionUUID->"c1c8db0f-2212-4a1c-b9bb-\
1aa920000302"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7347999895173903`*^9, 
  3.73480003384433*^9}},ExpressionUUID->"5a93d936-0014-4c6c-9274-\
cf64c59bb7af"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["t", "2"], ",", 
   RowBox[{"3", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "t"}]]}], ",", 
   FractionBox[
    SqrtBox["t"], 
    SqrtBox["2"]]}], "}"}]], "Output",
 CellChangeTimes->{{3.73479999459477*^9, 
  3.734800019583109*^9}},ExpressionUUID->"f2e583dd-58c1-4ad0-8642-\
8b813bf443bc"]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{4, Automatic}, {Automatic, 4}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 27, \
2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 152, 3, 32, "Input", "ExpressionUUID" -> \
"8c01536f-eded-4e20-95a3-9aeb5f8841d9"],
Cell[713, 25, 168, 3, 30, "Text", "ExpressionUUID" -> \
"1fbae77e-ffc7-4ac1-bac6-dec64e4f219c"],
Cell[CellGroupData[{
Cell[906, 32, 722, 22, 75, "Input", "ExpressionUUID" -> \
"059eeacd-de82-4038-8e33-ecbfb46640e2"],
Cell[1631, 56, 210, 6, 32, "Output", "ExpressionUUID" -> \
"f6101b1e-e680-4b09-bccb-f51809007c2b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1878, 67, 238, 6, 32, "Input", "ExpressionUUID" -> \
"f270c8da-000f-4de9-b3e1-56df33bc4f3b"],
Cell[2119, 75, 329, 11, 49, "Output", "ExpressionUUID" -> \
"a85dacbd-024f-429e-a38b-1cf2435e5d52"]
}, Open  ]],
Cell[2463, 89, 190, 3, 68, "Text", "ExpressionUUID" -> \
"b4b0ac56-b43c-438e-92ef-0ab7f151492d"],
Cell[CellGroupData[{
Cell[2678, 96, 471, 15, 75, "Input", "ExpressionUUID" -> \
"e07fbc1b-318a-4347-bc40-6846d147acc7"],
Cell[3152, 113, 130, 3, 32, "Output", "ExpressionUUID" -> \
"8b439f4e-3553-4821-a298-0b0e59bfca4a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3319, 121, 200, 4, 32, "Input", "ExpressionUUID" -> \
"5a098301-67e1-4a9c-a14e-947a3ea0bf0a"],
Cell[3522, 127, 226, 7, 32, "Output", "ExpressionUUID" -> \
"f4183364-49e2-491a-8332-bf88220b7ca5"]
}, Open  ]],
Cell[3763, 137, 177, 3, 68, "Text", "ExpressionUUID" -> \
"a7f1b1c0-dab7-45b6-b8a5-1d136c8e0d9d"],
Cell[CellGroupData[{
Cell[3965, 144, 1264, 29, 75, "Input", "ExpressionUUID" -> \
"2b086ae3-d1d3-43b7-89e7-52d74304ddd6"],
Cell[5232, 175, 502, 15, 52, "Output", "ExpressionUUID" -> \
"04bff056-a882-4af7-b402-702a25e772c1"],
Cell[5737, 192, 495, 15, 48, "Output", "ExpressionUUID" -> \
"e65fc4d7-af23-4ce7-8094-f4b01bda2bbb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6269, 212, 501, 11, 75, "Input", "ExpressionUUID" -> \
"c088fb59-d456-4582-83ae-bfb098abde60"],
Cell[6773, 225, 466, 10, 32, "Output", "ExpressionUUID" -> \
"2523bb9c-2028-4bbe-82b0-b0f86f77f4b9"],
Cell[7242, 237, 525, 11, 32, "Output", "ExpressionUUID" -> \
"30ad6e62-6102-406d-884a-3240476d60cb"],
Cell[7770, 250, 392, 7, 66, "Output", "ExpressionUUID" -> \
"c1c8db0f-2212-4a1c-b9bb-1aa920000302"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8199, 262, 153, 3, 32, "Input", "ExpressionUUID" -> \
"5a93d936-0014-4c6c-9274-cf64c59bb7af"],
Cell[8355, 267, 368, 12, 56, "Output", "ExpressionUUID" -> \
"f2e583dd-58c1-4ad0-8642-8b813bf443bc"]
}, Open  ]]
}
]
*)

