(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    184454,       3165]
NotebookOptionsPosition[    184124,       3148]
NotebookOutlinePosition[    184480,       3164]
CellTagsIndexPosition[    184437,       3161]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"ContourPlot", "[", 
   RowBox[{
    RowBox[{"4", "+", 
     RowBox[{"x", "^", "3"}], "+", 
     RowBox[{"y", "^", "3"}], "-", 
     RowBox[{"3", "x", " ", "y"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
    RowBox[{"Contours", "\[Rule]", "20"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.654989063175415*^9, 3.6549891875319767`*^9}}],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyEvQd4VcXz/09TkSJK7yjSey8iHDrSmxQRUYp0FEJvgiAKSBFEBAEpAtJF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   "], {{
     {RGBColor[0.148, 0.33, 0.54], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkD8vg2EUxQ8GUpXnrfoTz8Rm9A3sRltj0tSC8KEEacNiEiEx+DO0n0OQ
VkQ6EKH93Zx3OO85uffc89z7rjWPt48mJa2CKXCWpd1ZaX9FOgBN9CH8RL2C
4aouLdWkVlW6ofYIeuhXat2q9bo8FzkT6N6iVJuhDw/xbU1L/wtSh9lr/Ofw
DthD38N/yW99wg/Zuc/ZvvBfZvfC8wt/Jb+lQtokl7Zu+Yyix3EfyQj9A2/g
mcPTzr4hbmnAJ3V7TtGD5Jz35J1it2V2/06e7Sf/i9jhhfpF9mxk9EvPGzws
cyLvrsyJWyuFPbHLfGFP7D4GFLM9XA==
         "]], PolygonBox[CompressedData["
1:eJwtkblOA0EQRJtDAhmj8SI22IGEjI+AH3BIRoiFE4zgq0ACQe4AMo4A/wE5
4ggQl8EYDK9UDlp6PVNV3bO70trf2JuMiExNU58pol13/w5vAtv08/S1RsQp
fZf+FdMJPELT57I2FfELD5P5Bs0P/EJN4N2awwMPkr3K+Iavs7XyXMEPybM0
sw8/Ju+iGZq1UzmrRXXg+yKiV3fGBcLmYsRq+OySfreyVjtU3JXon8l5o9aW
OWyMd2OnP87WOftI1kg7wtOccaayD7K18hxmZyq7mGVm6Td1x9/rC74r/Dbt
f7vkb6JdlfcEH2Vr5TnO1kirNy+w21k265+cA//kAkMo
         "]], 
        PolygonBox[{{4375, 3173, 4087, 4085, 7229}, {7228, 4083, 4086, 3172, 
         4374}}]}]}, 
     {RGBColor[0.23321239621548573`, 0.3773402201197143, 0.6198020853446613], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkDsvRFEUhVcQyRiFE3Pnzj0RiUL8AyKhluhGolMpEToVpX8yJAyVQrwf
YUZkJl4NfgGdgk4mvp19i5219tr7rKyzRxbX5la7JI1S3VQrkeq9UlaSPoJ0
3y9dRmnMOHpSkWZLzjtgg1mbnSaYsNPBbHpIKud8Ct5Tlr4x38ikl1T6LUiv
qc9sx97dRfc079qgNAOvDngZrzFfgM/DD5lvZs5Ns6yWeQVtmH69KG3BH1PX
C/hf8L5Jznf4PvwEfhA9i+20yNdm/wG8Dv4Hy5bCr4LrNn+mfnjzBN5G/9dn
8BtYHut30I/ot8EJ7jXZJ42Dp/QN9Lf8lqb/sV9HP0a/QT/Pc56BX8H97H57
+c5u9HuYv2VazhyXwH+ZCkuh
         "]], PolygonBox[CompressedData["
1:eJwtkL0vQwEUxU+QJm3f0Od5fX2vMZisLMTE1l1iqNGIsJkY/SXKUpNFUoMK
qqE0GJl9bIbapPG7uR1Ocu895577MbOxu7ozJmkaTIDDVNorSn/jUrUsHUVS
LSe1Auk0k4ZTUjfn/CCULql14YaYNNHu0/8Dt4bmgPgO/jHw2g3xJz0f4K0q
vYOv0DnzvIWPKx5b7RuuRa0z8i+TP8RSD66Jphf7TONMc5G5p3lPlqSo5DfY
rksFaRHvKzzuR/39RDqm5zzwG+3WhYprbYdZtJup601zgjYJfZ7d3Ca/Dv03
1t+IfKbNXuZPK+As8l/YDzro10EdFNAUwXbqu9iMLeJG5l6Wt/F+ZcffvN/8
FDssHlB7TtzDvOaYNQ/yoftZzwv8P132UBY=
         "]], 
        PolygonBox[{{6824, 6823, 6829, 3258, 4547}, {4569, 3271, 6845, 6747, 
         6748}, {5169, 5168, 6825, 3257, 6827}, {4546, 3257, 6826, 6823, 
         6824}, {5184, 5183, 6844, 3271, 6846}, {5043, 1621, 5042, 4582, 
         4583}, {4568, 3270, 6842, 6745, 6746}, {6748, 6747, 6848, 3272, 
         4570}}]}]}, 
     {RGBColor[
      0.29589307781424995`, 0.40769405290596644`, 0.6451299478663834], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUjsvBGEUvUGwu6wdM7uzZikkElF5xW6L6CQKFaJSqVAoKf0TEolS4hGJ
Z1CIXY/EY1kFhagkNsFWnJMzxZd753733HvO+aZ9Zn58rsrMhnGqcTZcs7Fa
s4PArCNqlqs383BR8cy6cD+E+OeY1deYTSDvS+t+G7jTBmFf8e0C14zD2Z2O
erLoHQ3ncN4J6heor2PXj28Wx75vxDzOV8TsBbE1BQzm9AM7jb439D8C1wZ8
AfkZ8kJS+64Q733tvUR+iLstcFoFrhf4LOaXUZsKxPEBeT6p/ltfPMjnGPUN
5LvQ0os9O4G07YY18iT+GPlIndkn8raEdFHfU8ifOkr47kHPiycurMfRl0tL
Vwb6Vl3tpR9NUc2lzp60/K9GT2NCuAHMKWFuGcauAffrC1NBzISenGOOmxCv
54xZ0dE8+sed9CGHWdehV/Tg3VH/pqu35Ht1Y/9eoDflfzHp6d35/l0p5az9
evLhxxMncrvD7OUWs4WY2RJiLCHP6D09KEfUR23U6CN+OPrnkml5Rq/pC/fP
xqSB2qiR778fyKtB5DehJxHc93nyip4NhHnRlxfUSK3cSW58s0z4j62A52KL
djUAW/DF8wj9/xFOc1g=
         "]], PolygonBox[CompressedData["
1:eJwtUksrhGEYPTENhpjPfOMd41JKycZliC2yU4oNysrKCgtLlv6JnaWSSbmV
lTQu5RoLVlYKueyc48ziqfO+z3nPc57zfR0Ly9NLFQB6WAnWWxZ4qQQWa4HV
ZuAjAoZSwEQ10NoEPAXgvYb3fPRIPBMDwzCnP8c+z31VwCk1Bol/yWlIWVPa
a9RcofYw9RLUm08D3fDdOntZanSSH5PfxdmbeWCnDqgnZ4rcgZy9qF8grons
5YOeSsEccTV/MwMcR8bFJLBFrVl6qk7Ys7wf8G4yaX/35HawjpP2/EO90dj+
3tgfI85F1tKOjzznWcqvxH4L8V1kLWnsU/usnJd2OGTvlvVc6Zl77M+ljU/Y
3+X5M7hfz/nfxF/BWDM1+4wZNnL/DKuUdYbKUpm9sn8dnIc4N8S9OWclTh9x
f2wtzajl7I1m56k82nm+D85Pnh+IjyJnq7N2+eb78Srvp6yKeXuXnryfB+eh
+RfEI7G5yi9D/e2MsTLVt9c/ou+jmQXi86x3k4ayHSr7//dIHMr76n0b318F
z9LOl8HfSPry+ENcl/a/rIyV9R9D0WT5
         "]]}]}, 
     {RGBColor[0.3684469492179958, 0.4331922185750145, 0.6024784707472485], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkk1vjVEUhbc2bktJ7q3z3vf2bUk6EUblatMatomGAYNOyk0MmJkw8Q/4
ORhjimFpkRb9+AFIaIl7+4VnZZ3Byf44a6+zzt57/O6Dhft9ETHP6ef8LiNO
Ho94UUWcG4w4iz/ERdWM2Mc+Gon4UfhuF+yTWkTvWMQSd62W8V8bEZdTxFty
K2AX8ZfB3cQ+pr6Df6cecQH8FPgJbJu7l+Qnsevw7sL5Bfu5NP8n7Hu4roJZ
qFvjMGcUzYel/Q3e3eScwv9L7nXDuj7iP6+MvUXtGjwl+lczXzfrXyvtr5bG
CX+i7veEe1ZZn3RuYd8VrlvCbhL/o5EtaaB+D56t0tjZAd91c2/V4zZ/nsa/
hN2mZg+eG3BMEs+Qn8L2iF9RP4cdy/3/BXYn468n18hX7uGI56L5DBE/pXYs
udfq+QH+TrKede6r5PktF8YJ/wH/SN27cCbn2gOO3zQ8U822V3ovxqWF+AqY
b/gzg9ag3h1tOq41/SftgP4wnXdDfBdbzmtH7iXvYR8avnM3D+c+udGsU3pP
o+0anCWci9iVmmukQ3q6yX3t5Lc0D/X+D3p/wnuemu3CPVVvZ5Pfka967Y5m
pJr+wvydZD7tqnqtWPkJuBvDEbepLwrPXHuiv/0HO914EQ==
         "]], 
        PolygonBox[CompressedData["
1:eJwtkztPVFEUhbcz8nCQhOvcM/cyPhIbI43ojARiR1SihYmx8ZHY2Nlo4z/Q
v2IHViY+Wo1WKKgRiAyxVmN8RGcAFb+VNcVJ9r5r7b3XXufcwzduX7pViYhT
nN2ch/WIkWrEkVpEWUY8Ir82GDFN3iKf4swQb8NpNiJqWcQ8eHso4mMe8Slz
7dHhiK8p4gP5LNhTccBfkLfIF8gPkr/MXKse+8lfFRx6b+6hlvgdZ5G8R75G
vHcMXrj/nfGIder3MW+U8wt8mx5zQ95Bu5zJzRfnL3hC03XwOb7dBKuywxbc
KfDj7LaYPK/LvBX4k6UxeSAvRpk/Mex9WtT/hrNT8fwu8fvCtefA78NfLaxd
+8mrdmkv5d8BZs/XXS+PftDvM5yzxM/gn87tabvv1wjYVfJl4stomKD+T25t
2uE7+IXc8XnwEvwK+RL4RXrsgD9oWpt2fE6+XthreT6dmyOuZmjWbG4t0rRJ
vAF/q8/XXelO5YU8+YZ3PzPvppknSr8B3dUMZwA9T5r2SnfymPjuuPna4R7x
P3rWa/ZE3iwnz5LmN8RLyV5K/2viouFdtbPuciBZv+YfQ0sl+a61TzXZU+2j
N/Il8x2pt3bqyIvCevV+eoXf6EL/feutTmbupRmaNdjwbtpHb22j74f0d4gP
6Y2BFXBWkjVJm/6hk/jTzT1LmnrEb5PnqWbXmN+0/JInHWr/A9p1hcI=
         "]], 
        PolygonBox[{{5656, 2121, 4125, 5195, 5196}, {5174, 5173, 6106, 2553, 
         6108}, {5617, 2089, 4109, 5173, 5174}, {5196, 5195, 5369, 1861, 
         5370}}]}]}, 
     {RGBColor[0.44100082062174173`, 0.4586903842440626, 0.5598269936281135], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVD1PVEEUveJ+wC6RfdmZN+89jIYQAzZaiIuxxYIoSmKChSYWdiSKsbAy
sdH/YmOo7NZGQ8FaGASNGjCiYqPGCEELWcBzPFNM7pl778w997w7b+jG7ctz
PWZ2Fesglze7VDXrgX3Zb3alYraJwO9g9hV2LTF71DRbAl4EvunMqiWz0dTM
95rNVxQznH8BPI34BNYWfN+R3+0z+4O1jaIL2LdRY74wy3C+g/yLyP3pVfMb
4utB+W9gO8idRs4GYgcaqrfixYM1h3F23enuGnynnHJXgUdrup88HPBCRf2c
xx1362ZnTHfP1uVn33fqyidHchhAzsNc+Q9oc+UfApf7ufId8PvI+XUQJ3Lr
gMNiIU07sCewH4S/DP5HkVOi9g3xJv93QdpRw+PwTVaFyfOtl85HEK/HfPZ9
1onjR5y9BzwD3ETuMpZDn69gPzud7ce5Y7FuGXWfFdL3OewvL92o3zWnmvuw
bZxLaop1g/AO7GAmfQ/DjmXqi/1R28ma9hcy4V34C+AR4Bx2oCHO5M7+yYe8
ilTnTyPnQ6Jvwhnkd+NZzsd+0Lc05LSq6msZ/t2Ydw73DDfE/38fWE/h30Z/
s8CrwB64FXvb5MzGGf0UFL+OewuQKqeqydnMI7cR2CEvnal3M+JbwH+d5m2K
s+80W4/xbp40NVs7Tnv691AreNVKOfvxe3epQyLO5P7Fqc8Np7mhricRXwvi
zz5aiXiXEB+PfTFOLahJJdV9nAfqznfL99sGlywTN3LcS+Tn+/6R6B1MRM34
f2BsKvbIt/sPUUGVRA==
         "]], PolygonBox[CompressedData["
1:eJwtUz1PVFEQPbK4Txcie+W+9/Y9iAYtwMqYKGpvgRoxIdGCRBPtKMRY0Nro
b9HOHyA0GkxcCqP4HTT4gY1auKuxgF3wHM8WNzlz587MmTNzx67fnJnvA3CG
p59ntAFM1IB2BUgy4FUO/N0LLA4CywEoeBarwLEEWI/AtTpwinELA8DdApil
fZH+Jt8/Kp1DuW7Rf5v+WDe+zDdXiO8Ujj23Byj5doZ3Q8wXaa+mwIvUeInv
T7MeyC+S3zfm/E1fh3dTiTmIyw3al4hLNjNP/CH47TLju+zlDWNWaT+g/Zb4
T+rcqjnE+GnGrFSdsxVcQ/Fz5LhArlvMEWrWQFr8CO6vSXuTsQX5jddc7xB9
R3lGpCX5zEb3sNTT7wl9r3v6dnhWaG/S3qi4Rof43jA5ckDPeXefuBmMxf8L
cx2Ixik12kX+j0trrxzKtZ17HurhI2NHo+OVc4D2u9xYHN4Tt1L3pvhfxGPR
emk3DhJv8EwmvpNvMLi+7r5Gz1SzfUYOT8llJ3o20hTKPWwtpMlD4n7erVV9
t61cpXdN89AurOfG4veJ+ETDu6L44w1rLK21Ezv0b0XX10x+0lfN7G/R3k2c
9uppP8J+z0S1p8m/Ql+bMWcT89UuHAnGuutGz0yzk0YnaV+Inr38itWfkF8z
LoNj5NObCdprwdpqJm36vgdzE+cG+8nI4WpijpP0vUw9W81Ms9tX9y4qXn+t
WVpr5cgY35e6F8XP8f14Zr00g8N1ay7tpqjX+Yb/iLRQzTx1DuXSDpfEn3Pv
pnZEu9gNjlXOInNP/3vj3Qjf/wMx7Zr4
         "]]}]}, 
     {RGBColor[0.5135546920254876, 0.48418854991311067`, 0.5171755165089785], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtU01vjGEUvdrJfNRg3vb9bnXS1tdMNyKpVBMbC0lT4iOxUY2kFoS0bLAR
iQ1bv6LssCUi2CixMEk3DFMtUxssaCVqOs7JeRZP7n2f99x7zz33PgPTl0/O
dpjZBZxOnO7ArJ41u+SbPe4xOwv/CWxvbBYAsMczG+4y24lTxPfz1KwPcadL
Zi18T2aFW/P0fQJ5FiOz9YJZA/YP7jdw3x+apbHyhLA1xI3Dz2bMlhAzkjOb
B/anq1cG5hEwad5sAfEbuD8GTAZ825G4DOJuALEPgPviiyu5tOAPgd8pxO5G
3fOIawJTzegfMRVgfyFXFRhDrRxwB+D3xco3iphVCPUauHfAL6DmnUT9Tpd0
6NegxzDinsJvOj3YL2uM5ZWfepE7dR7qlE6sVTXpzvuLsLM4H+HPwK6B2wpw
1xLpRd3mUeuwr/tF8Cp1yWf+q4lqsaeJWHPkPCfB8zj8l4htooc25vIVNgpU
izW3A19Bru/IedCTVjd85au4uf+NVO8F8rz1NJM6cozG6ofz74dfBeaHJ770
2SNnPZGTLu8RXy+afUi1E7y7De6tgjSk1omn5VxHzX3gf2uz2d1EfbBf/tvl
az+2AHszkZ6cIXeCfJNYGhFPLe9Bi3Hg52D/uV7Y015P/MaAP5OTJpzRIPI/
hL8DdtXtNnu97nhQV86bPvnwPXAOW2FTx7/hix95rqBW2e0qd7YzVr+91NvX
vr3hTLvFw+f8fe3gfXBOQr2VFjBLkfRajqQlZ81/c67Hz7g/Gut9HYHdVtKO
/g7EyZzG1IY68PtZj/r2AvXM3r/50rXl9pl8+a45oyux9oT7kg+16wXYGehz
DvPqQM2pkubvwx4K9f7K6G9TLO0aiP3kyecda464d2eBdqYNDstOhyKw+z3x
DAP1ylrk8ypVrSn37mtOk/9MqqQc
         "]], PolygonBox[CompressedData["
1:eJwtlMFvDXEQxyd99do+je727b7dty1VVfT14oBUjxKSpmgRLpVIODSRVl1w
IBIXrv4Lbjg4iQguLXHQpIlQqq28uiAR4lBtfb5mD7/kOzvzm/nOd+a33een
Tl5qMLPjnEbO7arZesFsrGh2B3wjMquDx5rM2trNXmZmo9h1Yj6FZj34H2Lv
wz+N3VIxG2w26yTXYXzbOQ/wp3x7F5vNELO/ye/o7mLkd2XvAN+l5q3NZjXI
HCJXyJ0eas3jbwd/yfP9hvQy+H7Z8QA56tivQ8eKUe1C4LVld2F/zfnqzgp4
S+Bca8RcoXZnanYQHFOzA/yBfudbzYrwGUq9J8Wv4D8CnuR8zPUpw+9i5FzP
kGMnua/n+o3j78Y/SI7Zomv8B66VvD/lSGKv8b9WyewYuIvTD24l5jG9/iKm
v9n1HyD3SmL2iLtz2G/IN4f9FrzaYvYZvMgZKvq3V/hPBW5Lc2m/p+JcxXkC
uy/03sVvJPKaqt0Hh61weYEeQck1eJ45B3ExTsbdQeynRefYRq2pXJ+z1AvY
n47Q/WvwW4JbV7vPWhpdJn9v5P1oZppdxKmZz+Qm8zmaujbScC+55mPvfYN8
dfI1Yo80uaYH8C+Ezk81C9wdi/zuafL1kHsudm0usHOT5F8LXf9zxAwTv5C4
lrqv3iby+arGOrEzaNBbco7T4O98q5X8W8L9E8SvFdw/Grmm0naY+0btjcix
OInbz9h3UW+omdlEsWunfp4xi6tV3z29wWtgSz1eM9pI/I1qF6W5tNdOypa+
2kW9QWkrjXdhryY+O830L3g287cvzr/pZRMaZXm8ZjMeuDZ6E+8z70m9qedt
qe+89kkxil1OfNbSWFo/KbtPMdq9hsC1105qN/UP0W7Kvld2DaWl3sAPfLsr
PjvNqAqupt67YjLwt9B3VZpIy9bQ37r+OUtw/Qdt/p99
         "]]}]}, 
     {RGBColor[0.5861085634292336, 0.5096867155821587, 0.47452403938984355`], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVEtLVGEY/hp1nE5W54znnPkcHUclL2lSu8FLUIaJpl1sIUWLKMkQUle5
qZbVskU/orZB0aqIaJMVXRTEamQsVOgGmbXteXo+aHHmfef93uvzPt/XeG56
dCphjLmOrwzfBn72esZ0QJ8OjakpN2Zn2piD1phu2Lsgi0ljLOwD8PkZKeZb
YEypypjz7uyIJz/6zOP8EXQf+kjKmF9lyl+GXDH8lhHbalW3GTJj5fMd9vvV
xowhNm8lN1zsKddHAT6FSmOGoL/D2aUa5ESNBfQ1Ap8B5ByE7IUchr0OPqlY
edj7DfjPbsP8kKOhcrfAP+fqsf5ZxK0l/2NBeQW+qxljanH2AXm+4P9vAHkX
/p0p9cB5FyP11YDzllA6bUnkj9BTAvIhYmLYe6Gv4GwR+mvMNYWextFbORL5
ri538iMQPhk3H7EmzpOoeQH6OPQO+BfgfxP+PbDNJVWDO+R/6sRjyBMms6g1
iVqXIa+FmvcqZHuoft6g5rCnevSfQe2L0PNp1aXeDnsiLb9jOO9ye+H+KTnL
vKtLzLuM9kSsPgHLKav+c2nNR66wzzbYt0M+AE5t6Ocecn2FbPaV40wo3p2u
FPcWqhxXcZaLVa8dst4Kh+OhPuonICd84bfLF//Iw91WfVnoW1C73EovBboD
zH8I8k8gbnVDrwvE888Z9cT6B2Dvs5qDe35SLZzymLsvFna3gHk6Uv9BpPnI
E/LpcbVmC2FvCsWpEuTtGu13BDkO4/8z+PQ7HMhXcoUf98h6EQJziB0I9VGv
QF8vAu1kCfmL0J8Du6dZ8ZU9zMGW93UveD/ysfbSEOvu8Q7OkC+h9r0OedJX
nwn8FLN6F5YhV+CfBVaVDmPeQe51NRQ/7mDWlYzwrg10zrnowzk5L3k96Hj/
HjknPGHIGTcD7f4t7JuYZw/sHuLGrHixA7HG050ltq2OS+RUv8NwK/ybrGKZ
oy4l/wqENkTCk/djKSvOkDvkEfnKHe8LdD+GrfjK3huh16fV67TLzbvGHTCO
7wzxJXc63buR8eTH+P1WmBN73kPeR74TPaFiyLuPrtdiJB7/ew9wvk48ketV
oFn5VnKvnIl24sB3KHY8LzmOcYcvA+G1lhEv6MeeiRP7Y2/cZ+Rij1q9Jwaz
/gUEKLVS
         "]], PolygonBox[CompressedData["
1:eJwtlMtLlGEUxs9cvPSpMTN+znyOjqNSmpYUbcoblEKCaVEIUm3CpIuRuspN
bbNlf0Yt2rSOIqJNVosyCC1LKxW6LSrd9ns6A98L57zvOc95zu1rmZg5PR03
szFOkjMSmTUmzIYCs1Hkk5yRwO8e1poV68w6kTfKzZqRv4ZmhyrMHqC3I98M
/e18pVlXyiyNzVneL3D3GP/vodtuEfQbcmcWfGy7ib0b+6vcRUn3yeD7Km0W
I34DNsvozdiPIu/Fvoj9nXqzKfRJ9IPos/ivgH8cn1jG7C4xh9G7wdvgLcB/
H/YF7OuwH0v5u3JQLldSznW1Gpy82b1a5yoOmzmzbTh04f8Im17sZ6jPpcBr
8gTbsqiEzV058k/4/+FtAfsm9I/o2cDfY+ir6BFyFsxFsBfQ3ySc0zr4NWmP
r7s29B/ov5HHeS/g/xVOZeb1WUd+Dee31V7PCXLpCP39HT6dyDc49Unn2w/W
Bj4WeAzFWoFDY6X7yFecxE05K/ckmJNVzk+1u0/OsYTnkITPzoz3Tz04g35d
/anymm/hfyr0WvQqJvE+cXLIz7g7xlsfPtmE97gfOU4Mvv8croF1LuX1FeYc
+mFsegLP+W/aa6raPlf/0j4zqo1y+oC8xFlMeA7T+Deknb96ksC3hVOTcL6t
yE/zjqWYir2c990YQl9CDut8XlTTFLkXOZcDn8kBZq0t8lndz1078nDk/tqp
OLbvS/zUg5dwaSrtQx/6dtprJi6qkWpVgX8+cM6q/WDWY2kGm8C7RU5zVY4h
rJ7IsbS/B/A3bIYDfy9kfUe0K+Ikbtpx2crmROQzpFkS5jzY8VJ9xWENvMFS
/dWzAeQjkdvr7qjmPe+7pJkYR98Vev3V01bk+dB39yL205HPpGZTNZxFL0Y+
69qhX7x9zvksKP815Nv6/yQdQ1iboe+6YiiWZkyzJj6alY7Ie6Ee74n8H6V/
lXqo3S9knItqqtruyPpsaucqkb/kfPeF/wLsqdBnQfnp3/UPB72VBQ==
         "]]}]}, 
     {RGBColor[0.6586624348329795, 0.5351848812512069, 0.4318725622707086], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVctLlFEUvz4aZ74xmXG+b+bO5LPs4ZRDBrlI00wDKTCMsrEMKkiQSEM3
QoSLjFz2bxTUpm1QbVyU5EIpSPJdaVoQPdxVvx+/u7ic8517nr9zzv1qrw+f
Gyo0xjzEKcJ5kjCmJ2RMiTWmucSYM+Df4+IV5APghyG/FjbGKzamC/rt+D7h
4YDOhsQb3FWVG1MP2pE05ktgTC1sPoOetrItwP0PKx9hyLdSsIHOMvhFyKsg
90AncBoRfwrx74Efg/8sbEfC4keh1wd5L/gyyNeRwwH474U8FZMf+puOG/M3
YsxaSjkxt0roV0L+AjYbKfm84yneBdC8Jz/k6b8O8uqw8gyxTE/8NgD8iLzf
4X4e9JNvDNya84jfGldO45Adgf40+D/Q2+90qPsA5zvkk74w7AHuEeS36asH
W6AnPd0R206r71OkOO3gO0AHY8q3AbTPU97M+aYVJhXlisPaWWMb5G3QabXq
AXtxBbE2cI4h7lfQlVL1nfb1+H4GfiFQP+ijDnw37K9C/hyyobQxaWDyAfIm
xBuFn0OB9KjfiaJnM8AKfucy6gn1C3H3Gt8zkL/JqCe5sDAixkWeMGd84k7M
b1lhS4w5U8yBNVSj/m7Y1KDPM3HN71KgmjjP7NNFK3wWEeubL3+Pkf/LhDC7
ZNV/+iemR5Oa+ybQGvgagK/qQLuyXqQ5I06UE6t5Nw9vEb/Ckw5rZAzG2sS8
rQaapzXQYitf3D/OIPtEvJpxPwX+N/iNIukwFnHKOzn73+9mo8vXPWc/iMne
Q86VSc2UQU+afeWzHQjjtMOZ35TPgS5l1Ptl0Mtu54lB1KqeCLFPCc9HCc06
fRTHJLsRFe6F5eoN937Iqi7O+5yLtez6w37TPuL87wQ9jtMKvgU0a7U/B0G7
k9rV+1b7dNjTThW4WLd9UebMXhIb+vnHvbPS38ed4NsCvh70J3cMvfsFuhc1
5GGbTWqX2P+7vmaWvuhnIqoc+P5w1qadnDMwGNaOtSfFN8Z03+ZyCCFeGvwO
q96SZ29bfOHAN4nYEAf2ciWu+0KrXu3yNEu5mOad7yh3j/N/Fnyp1f3ThGaQ
O8OZq4M8B9s9VrMzEhVuk9jZMfA18Jd1O17v8GB+Gw5D6nDGaNvgafZ2W/G1
oCWB3q4QaKJcb1A/5AsZYcj3aTit2QjF5Dvn/LAPefc2hq1qXI2rpoj715TF
VQf3lf2ZdXfjadWShM//sOPLtg==
         "]], PolygonBox[CompressedData["
1:eJwtlMtr1VcQx4fc9N74Syo3N/fenNiYh9YabzTULioaW020aBEjCtqrRvGB
ARGTohtBqgsVdOOq/4QbN0LpTt24UPGBxaJQa6JgfODG56r18/WbxYGZM3Nm
vvOdOdO7b2LLeENEjHEaOd3ViP9zET9mET+kiP5yxH30DzjNbo142h7x36yI
Bu460b/EpzOz3oLczPv3yEeaI052RFSLluv5iN3Iu4i3njyzSLYbeSP+R5oi
TuPzO/5/tNl3KTH7iJdxusI5mpF/48029D7en0BemYx1lDd/8vYJmL5C7yDm
gwo1kZOrz/o48TPyDSK/A+M77BfbjF1vmog1yV0X9m7OE+TOknNNE/9w8hu9
XYL/PPTvibe3yTUNkGsxmHCNXu6e4fuIcylvDv9B7ufNd5k5EleLkmuVvgB5
LvkWke81b8ZVG2cV9pvoNQpZntyo1dwNIQ8m90s+q5I5EBdD6MPoJ8vGXkcv
Eftn9Oc5c7peWMG0uRBxT5wT/wV3KwrGq973cf7OmcOFyGfLxnaceP0l91C9
VIwCsT5yBqj9Mj4rsUXJ9j3oI+C5Q6BcZo6nKp4J9ft2S8T1OREPK+6VZuwm
vrdajWUDPtPM3itiDhaMSdi68R9DH8N+ldr/JcbWzDPyCPktPsMF16zaR8Gw
HfvX6FfwP5M8f0vRTyN/w/l2hu8t+NfoUb3JNcxF7knu/4BiIM8H37W8c7zB
f00y9+qReqWeqreKuRB5dXLvxPco/j+hD8/491bdA9l0txbbr/hkjca7DFsN
Po9lxjxSNUZhHdHMwuW6svFoxivok3Aw1eIZPkS889iPhmOcSu7h8Zl4+oua
McXTjNawTyRzq5nswvcv4t1v8cxp9lSD8IqjBeS7Mce9FEfialNy71VDA+8P
FR1PmB7j21M1dsXT7qkn9089asO/gL457/5NgW2SM53zXWPyH9e8aOY0e2tb
3UvhPVf2jGnWGol3t9U7Q1xoZnoq3mH6/4o5qP8AvgPNnretyPuL/k+q+R54
vyBnR2aOxfXLdu9G5XiF3JCMVT555N7kXaEZ125Tj9XrY+Q4yz6anzxLiqdZ
EmZhP0i8IXwXg/FowT1T7zQDmoVt4ki7o2hfcSpuZ5dsE4e/YH9c8V9RTRMd
3gH1Gbu43pEcTztsJ3JP0dhUs2oXB+JCO+E5+Z9WvBu147TrxKm41Y6roV9o
s7/+6EvtmnbvAmG4je8nBH+73g==
         "]]}]}, 
     {RGBColor[0.7312163062367253, 0.5606830469202548, 0.38922108515157366`], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VllvVVUU3tDrPc3tpdx7e87tPqcttDhE2oIhUh+0dQjFIVHRJloHhlgh
sTaIGF/UBwScqnQgJv4LEbXwJMEhEWdabyEtrXbCKODw0FZLNNHv41s+nKx9
9ll7rW99a9inoWtPxzPLnXOLeMrwfJR17t60c+N4uTrvXCWld+79xLlzWD8b
Qyfl3MaMc3/hfSB0bgH690F3vdf+Osi2culRZwv2vsf7JN4fyjlXgJ805E48
23D2DGx/XIV3rLfi7HLoteFMNc5ejpy7AWfPeOFKZ4RtPc52Yf+monMX8V6P
/dWwWwm91VifB566cq3L8H0EclPg3CWsK6BTh/cM5DDifTQtnBXw+wTWdViP
R7I7Bzu/VsvvJcinctKZBOY3wMUW+GgAhmPYCwzbmozw0O/ESvCG5xCesazi
Ynw/5aVX8OKJeIhtH2y2wmYFbG6Hr2bEVITcGyv+h7GuxNkhrJvA/Z04vwzn
L2Pvq0T6PNcPf314RuCzG7oHK8AV9N6ObW3cEwt5fhH+59PSeQnff8S5LNYB
bJTjGcJ6Q17cpMHN7eCiBXtrkcyygrh7wCtXgekTY2uguiFntEubp4xv1taJ
rPRZE6dhfzlwXIDtJXxrzkhnEN9/wDNgPJIfxtnohb0R5yZNp5QSrj/gY5fT
GX4jPuaB+fgS67di4bkOPGwHj6PQ3wb5DoBcu8I5X4O4Yb8D+0eq5JfnyfVw
RvusN8bB+iFOfiOnxPRmrDVrfAx5mUCc44nwsGZuxtkYPO4APx7ym0S1+C3k
7pxytt9L9gSKqSNQL7GPprJak09iYa0SD2uMfNE+/QxY7ORm0Pgh/+xPYqdN
xp41nUnj+UKonLBfyS9jutXLxmGzcy6rNX3+Xq36/w2ygIO1+L4vVE93Yr8m
pVpkTpnb1lCYlxB7D/Z24mnCe96rd1ZC3hMK6wJkAByA6kbZs+BoFLZGIB/3
sv+Yl41dZme317oWWG7E2U6cXcDe9QVxyfqdzggfsfWAj247u9drXV9QrR2y
vE9YT7F+6OvpjGqsz+qSNXkVsB6A7I0Ub5/tZ2FzFfRXQD6ZU37qc+oZ5icF
X4uhZtSfkPtj1dUOxh0pR6xTckPeOFvofy4lDLUWA/FzHjH3m2H7+UDzeRO+
v5dovh9NNF8YWxN0HvE6z7x12ZwmJx9yLkN/CLInJz8bcvJD/U7zeyXHWLd7
zQfOiUGrI8a56IW1AfZLWc2m/7npNz7pk71QY7XN+cM7o896lvzOw84M7Lxr
OKesF47D/0SZ6uM1r1n2OuQtXvN2NBFPLcbVP+jtk7D/QSLsrAPi5+zhnUFu
2R+nM5rNrDnaLs9pVnHGsTc43zi/uL6jqJnTG8rejNlsDnU3nEcOZzP6VmOx
ztq6VK53xsL+uNInODsX6T6ZiVQXX1QIDzmkDvuIc4V9yDnOXuSavdleVJ42
F1X3xJIKNeNZE6wH9lDJ7PTbt+ZIdbHM7oX7i7oTGhFkLi+u14Xij7FztvcX
NO+PFJW3Kbs7fE4zacZrVk1ZTj8tSn4GeY1XzPWQP0fiipztiZWLaey9gm8v
QOdVL37Jczuw3G3zgXPioBd+xsF5SZ0Wq422QPXB+5I5uxhq75jVzSqb57x/
pxPVCOudea6zXM+H9i+UV2+zx9dG6jP2L+ueNobtHuedSY7IC+u0w/JLLshJ
zkt3xPTJKbH+EunO5F1Pbhsj9S//s8j3kO2zL08a/7yvhu3/57DNec7kKpvD
7G/mY9T+bch9yfqc+d9aqR68y0uetdmzZHf0bdZH7Cf2RJ31xZL9I/Ffibln
rJ/HyjXjpU9iJBfE3mMzeiZR/TEu8uhqcVcCwydF1TltkxPmvNv+SeifMXGe
zMbq51NF1fuY1f9SXnXLfyLOFcbGeP6tUYwnTJ++2CMHvOzQXimRbc5m2uX+
8YJ6bqPFyzgCi+VBLxsTsWJm7H/Dz3eJeHsZe2sKutueg+7ZRBh7Y/0LZa1m
6q3+v8b3/wDRRoPK
         "]], PolygonBox[CompressedData["
1:eJwtldtvlGUQxscu2V230O5uu7vfblspiEbagjFKL7DFGEr0omrshcRDQySY
iBUR4o16gRw8JybGRP8HE8VD5UoDYuIRpNiC0hLbUlApgtGCQjTR3+PTi8k3
7zvzPnOeb8nGrQNP1EXEdmgBdFM+4hG+v6Ujbi9HZEsRA5mIyVzE70nEYHPE
WNp3kk1CbdmIG6Er8GsKEZ0pMNDfgn4j54/Q70X/Am+fq0ZcRn4/dzvhn0fn
aXS7MX439v5uiRiG378w4h/4BMwNvB0F/3V8O10y3gkwZuAXFCPq0T/ZGHFr
a8R5bPSgP4xOQ8E2ZXsf5zzn6VrEppxjnIJ/i/dHOY9AU/hyPTaerY94GP1H
4V/k7pl5//rx7yHOm5C1cm7i7U/4MJGyTz/DD4N5AN/HuXsfvh2M1di6B/9f
It4V6DyFP3Po9+NPa9G5kk9DiWNUrN9BB7H3eVPE5rRztAf5Mt4PZXwn2bHE
uVfOXgMrrXqkXKOM8kP867E/zfs5dH8pORdARAZbyznvgr/IXQf8usS+CqMP
/g9oirenoHfBf5kY6rA1iP4r8N8T4zjxTkA/wD9Zdez9yLfBL+fNKvRnoF1g
pbHJ1f89sxV5X8G9ppgUm3pMvbYR+Up0P6i5F5TTD+H/JJ61GddMtTvC3Siy
MWgE/q6CY1GOlevD3I0g+wufusDuhHrArnDugN8ODeXcswfJ5zpyPpR1zm7G
/jtF5045UC6+Aa8Lvgv51/AJPXrdoojFnBP0L+LfF+o98Obgr+DPVcQ+Tn+u
pj93Jq6dcnID2EXOS8FLob8X+0drjkUz8i18BczerDHvBO++vHP7MTp7a+55
9f4oePeCVc7bN8W4g/yeq5DznN+8Df50ybOju1+RPZ7M9x60FH+O1Vxb+XwZ
3/cVXbvHkF9Cd4a7Wd4PoJPlPFsxXgb5Bfg1iXPby/k2+BM194Z65jj8hrxn
XzU5xLmt4NiF2UN8V/PmHHwb7+vhz1eMrfnSLlnE3TU560h3rGZbmrFR+I6i
Z1XztTtxz6p3tUOqxJ5LjH0EmoRfAd0C/yUzvyfvHlAvbOZum943OVbZXJi4
RvJ3MecGzp/SL4MNngHNwns110Y5UW66SvZlLT5148sn2iEN7ln17kTVtRNG
UMtVyFs4rwf/QfCvTdxL6rlliXtIvfQVOndw/qzsXfEjeJ1lk3jtsFfBXlJ0
7VRj1XpHs3eXYtSu1g6Sf9pxLyA/WfPu005NFb3zlM/d4L0BXnfZsykf5atm
SrOlHK5MnFPlVj2r3j1dcK407/pX5BPPSjt3Be2W+f9HnWpS8A7WLtZMvYn9
sxXLlHP1ymyzd7t2yFn47rx900xtybuGqqV2xCXkjYltacbO8P6BxLnVDj9A
LY9XnUvV5N8Wz4hmRf8Q/Uvai+4F7YQ+4v0PDRD2PQ==
         "]]}]}, 
     {RGBColor[0.8037701776404712, 0.586181212589303, 0.3465696080324387], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmG1slWcZx29W6Pva03PgnOecNlCWoLAV2KiYAk4Etmh1EF8iKE4oJJs6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         "]], PolygonBox[CompressedData["
1:eJwtlntMlnUUx3/Ei9x88b35PO/zwgzcbF5ASsKJVopozRquy8IuWzlWVmYX
RC3/i8rUbNF0Q9fWf9ZWyy5gWpo2pWw2ckCAsXjDFLCWSFtpaGl9vjv+cbbz
+537ec75/p6S+ufuffY659xbUAj6K+ncmTzn1uQ4VxFxLsb5vgnOjWY6Nxx1
bovvXBWKq9DdDL8N+dPIq7mriDk3Y7JzDdnOdUBb4UfRGSdAFj7Pw3+SMj6O
/cfwc4uc+3CScwsznFuA/G781SJPT3QuE39VvsWqyXVuPnyIu+V5piPdPuhG
cv2M+M3ImhPOLQ5ZDjOJH/acW4S8GB8p6vkF/W5s55FzkvNazk/Al2IzFfvt
6HeTbwc5zSuyGlTLLnSy8D0G1cIP0I9u+lGCzmiBc53YjOCvB39H8T+VmNmc
t2A/g9rO5BM7cO4cd3dSyzKomnpOBSY7DQ3C99KTk9S+gHwfQ7ePux5kS/B5
B75/4pzOtx7cw3kgZb1ahv6T6J9GPoT8BeQvIx+m0RvItT7sXF2hc9Og8rDd
SaYYirURm9ex3cT5fvizWfQG+QB3g5xPQWn4cuTzqf9xaDV8Scx6N0S8C8Q7
iE4y03qi3uwnv3byS3PXQ7/WBsarh43wf8cstzg6YXT3xczXSfr3Ld9iDj26
NddyKtL3CCzXfvT70J+UtNkswSYKv5icu/DXCX1BrZei1rsa6HbkXdh0Y9uB
/074YuLNCtkMNMieeHcRbz20FNsD5HAc3e+gg/BN3L2fa3eSnSVGC7Z7qDcg
v7qIzfYqcmwg14BzC71ciP5K+GSR6cqHfD3KXRn6jeg3oT+LeRkJ2QxXktsi
32ZlA/lP57zPt11Jc7cf/jaCXc6+FiNu30Tf5jzn9Zz3+qbbR/xj5Nufst51
cf4R/nfiVSC/CZqO7h/Mdxux25C/h/5LgeWmnp3QrOG/Et1i5MPYriNGHvwY
8V6EX+FZ7sKEB+CfD6wXh7H/NGU2stXOXoavR2clsn71GH4I/ZF864F68XNg
s6cd0i5l4GOQeouztNDkTc4PT7QZqfBtB7WLuqvTfEAJ+Hewz8A+WWi7fwj/
LfTzYsL4BPIL8L3MQDu9PsdMXUK/KWm9X0e4Z/B9pdCwRjN9Ff5t8tuabzWo
lil809W51qOZ5DMWs1x1txz9oaj5FqYW4Ptz5MMhw4SLScMcYc8UdHbgryxh
WCMMjWBbqe+faxglrGrzbTY98m+Fb6Xew5wfYsb+JV4kabshzBP2LfUM2zXz
S+Bv8Q1bhcHC4uOefQt9g53U+0+h+TrC+VhgGCWsEobsJvc9UBpfO6nnT/zf
EDEsehAf29A94tmsCbMc/m+O2Vuhmt9Qb+M2q5qhLmId8mw3hXn/cZ4bsd43
cLdD2KJ5zbCYAfx25L3Sh77Gdhp3a7LtjSrVexQzLNQOaZfKkvatK7ibLbwi
RnfYMOtL/D9FPr+FDfOEfY8E9i10dwLdFYWGDbPJeVy+4zb7ykG55EBzJtgb
oLdAO6/dF0Zk8i1DCeuV3li9tcIoYZVyqMHX9ynLTZjQAd8YNyzWjmvXhZHC
Ss10AXwsZbmo5jj85qT1qoqcX4N/l5605tiOa9eFAcKCDzi/wjx941nvNFOl
nt1JJoxvJl67Z99SPT/qGSYLm/XG6K3RTGg2vuLuI89IvHboTfpTG7VchAl6
m3+dbG+jZlqzXX0N34S5o/TqVd/e6uupaZNvO6vdFaYfoFcbI4ZNqmk3sX6I
mi9hlrDrSmC2woir8HtThj3aiTb1yrdd0T9BuW9vgt4Gvbnj+PofaM1O3A==

         "]]}]}, 
     {RGBColor[0.8763240490442171, 0.6116793782583511, 0.30391813091330366`], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmH2wlVUVxvf94nLi3nMO59xzXs45pCIylTBcUTQVwkQsQ0EkR69G1qDI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         "]], 
        PolygonBox[CompressedData["
1:eJwtlmdslWUUxx+6bwfcwe3t7UWNDFFBhhQFy4hAkWXVSqDFxBhGDCIQyxAx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         "]]}]}, 
     {RGBColor[0.9078079745124542, 0.6395199362811353, 0.31420472098860786`], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3mYlMW1xrt7ZhgGZ3p6saeZ7gGMIhg3SGKiAuICAnEDBQURg7uAiEsE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         "]], 
        PolygonBox[CompressedData["
1:eJwtl3lw1dUVx28SQhLIS96Sl5e8nwVtpW5oHcRSBSOILBWUXXZBC7WdCmpF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         "]]}]}, 
     {RGBColor[0.9193980498165669, 0.6684951245414174, 0.3501339544313574], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3mYldWRxm830HTT996+C9237/cxoyAaXGJEEES2dgkQxxWjZoysaiZE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         "]], 
        PolygonBox[CompressedData["
1:eJwlmHl0VdUVxm8ICIG88JKXvJd3L60iiIg4IDJJwAASrAULaJ3KjGi1SMCB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         "]]}]}, 
     {RGBColor[0.9309881251206797, 0.6974703128016992, 0.38606318787410704`], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmUVdWVhm8VNVA8qt6rd6te1X23oqitxgEUbEVRVDRoq3EIJhoTFQSN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         "]], 
        PolygonBox[CompressedData["
1:eJwtmHl01NUVx19CJgkkE4ZMZpLML1pAZVGroGUREFQEBYUKVC0tmyAuyGoF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         "]]}]}, 
     {RGBColor[0.9425782004247925, 0.7264455010619811, 0.4219924213168566], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mXmQVdURxi8y772Z95hh5m1zLzMoCAQTS6U0ZlEHopUoIC4YNQpqBAKo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         "]], PolygonBox[CompressedData["
1:eJwtl3mQVdURxg/Mm3nDDAPDe/Peu/c9ICwaTKzExIohokCgIMgiBiJGQERA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         "]]}]}, 
     {RGBColor[0.9541682757289052, 0.755420689322263, 0.4579216547596061], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mH2QlWUZxp9ld9nlLAn7nvOe8x7APiz5qJnsY5oR8w8lcUumoagUNzBA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         "]], 
        PolygonBox[CompressedData["
1:eJw1lnds1VUUx28XlPeQtq/v9/p7DCNGRjVxQEwAMQERUTBhiOxVhKIRC6VF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         "]]}]}, 
     {RGBColor[0.965758351033018, 0.7843958775825449, 0.4938508882023557], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l3uMXVUVxndf87gzLefee+45584MUaDaSlpDpCaAEBMbUCyB8mgBKxEm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         "]], PolygonBox[CompressedData["
1:eJwtlnuQz2UUxl927a5dsr/f/i7fRVOGYgxlRs1QmmZqpNKF3MmMTIhcdl0K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         "]]}]}, 
     {RGBColor[0.9773484263371307, 0.8133710658428268, 0.5297801216451052], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VmtsVFUQPpSye3eXlnt3797d7UKQYiQREIwQMSbgDxIXUBJoi6CERF5t
QYFAwGCr0Mo/hKiEhPqiCUKqqUQDSAyCEVpaH1R+QBGMBjXGRwyoKMgr+H18
w4/NzJ4zZ843c76ZuSMWrpy9osw5Fxvg3EDIlsi5F8udW5x27nDcueqUc03Y
qwud64s5N6ng3Fj8RmI9lXFu+iDZ0eZa4Fw5zo6Fj9PYm4G9Ssi/PNnRZjhs
z+OiBvy6sdcAnzNgPx4+74HPcZDPZJ2rwv5Y+LsA2ZFwbjvOnsTZu2Fzs1yy
2vQH4WMnbPD39tpIw/wwzv+EvbXAPqXCuRFmHyTkqwRMS6qc8/D/OjAsyzm3
CfpyyKW+cwtwtrro3M+QC5POjcLZZXnnFkFvzCsfvXFhLS8oDy3I21zcW8Ja
M+Joxb1rYrqrAThC+EjCpiEvn/WQkyuEh9hGJhUv4z6M/CzE2SOQW7Oy2QLZ
Dj/HEOsM6H/EhIfYbiSV808RezfO9yeU5xbE0w69Cbh6Q73B53xPrPXgdxEE
mIe9W/DVCTz74ScVFw8yeWEK87LtNftLnu7jXeeKyhvzV2Gc+AzY2nDHTfis
RG4mIp+rgXlzqJjmxJULYiTWBPwcgr9e+E1Db00ob4+SJ7j7APaOQ65My64P
+jHD2gXZllCMR8uUd+b/CcT0DjB9hfW3Lb5Xce+qcvGlzTjzhuk8+w/un4XF
5gHKO7GOjxQr+cn80t/0lGJnTk7gdwR+enB2Ykr43w+Vw72QMcR/HedPpuWf
+rPAsA97lbDZH8rfNcvnS6He9RHcuzOnnL8ZqI54N23IIeZvMWxfG6w8MofE
N904wBz6CXHvAHKSQE7ugp8lyNfTuGupcY91QZuOQL42VelcYGdZU4eNn93A
kLB6XGq1U1+lOmG9fGzvT6zEsMdXLQ4JxZlLltuLBekXIE8k5fOO72Cw/LdY
D9oF7Nsgk3HxvpgTZ3rgMw3MN/Bu70XK986UeNuQE3fmYH8L1menlPNh0P+O
qy6+TivngwriWqvFmy0KRwQ5H37qoT8FuXywbO74pQyAoQJ+5sGnn1Vvo/1t
TAXhmYkcNEJfgfvPFlUPrIvXcXZ2WnzsgN5UUN1/mNF7nrH67QwV+yLcecjT
OzI/a2OqO/rdFaied+dU36mksMwviM9PwueX0Lugf1FQnXUZV+uBoQ1n5gH/
MevJ7M3kMmuNNsdD5W7CUOie3ozvlStK/y4vn59Av8reE1eMrEPi5H/qs9LC
uxrv5QHzu9iLQuWV+SXvLnviCnnyr6eaoc6eQm6dArajedUOa2haVm9cosxo
HrwM2Wf9hHjqjavs9wdx5hR4VJvV+18yrhIv/ZAnj2PvFegzs+IOMXD9Mvxu
hl1uqHjqWS28lVMv2FilPrM1rjhr0+LuLPj5IVJd/Bgpj8xnN7DszYqTEzLq
c5XWe//LiEfkeO0Q9B9P/3+JlJdfIeuGaI+YYoF68yn4rLF12nNmc1bVYn1M
oHnFGUt/5AhtqI+y/8wX7Wm3J6V17j+GM+uw/g1wnYavqdDboZeF6j0bfevl
1s/nhPoe4HcB+yj7VQ3yXvLk/6rZXjA+l0XSWQfEXmcx1+DXH5OvBSaJ7YOM
zrO3sYaIjf2BuWD87Of8FqH99UA9iL1oN3BuqFLPnuarf5OH/P9nIFw1sB2H
s/Nx92hf702/V3DnOfyeg342oxodbv1kh6d1cuu3SDz+PRJ2+mH87DNTba7t
DoWbPaA5pxm0HnKur7zvY4/MaEY15TS7GCPPbE+L39+jDroK6guduOtEqLi/
9VVj5CB7D+dtv70B67sxrnlMjt8yn6zrbpu/rAXynTU7xte7rYHvTTabOKP4
Fnwb5veK1UVfqLerMU4OzKmmyyGfD/UttR7yYKR5+VEkfg2z78JSXjgfCFRD
7B2MYYMvTpFrdTizDmdqIcsK+ra7vyjsPYZ/f6R4DkBODsVLzo11geb9C9B3
hIpxVaQZyFnIGcfvLOqcBTcizQLOBPZU9vbzxtvbvXiAevBa63WcA/zmZL4e
wtnFsJkUaY061+8t6L7RBfkaZvxhXfF9z2SUL+atMadvzAVWj/0Z3bUG+ZgS
6btvcqQ+RDyso6G+aiyK1I9L1gM585l/numweUv7uqx4S14TV6vFztomV0u+
5s82T/VF7nKdvaY50npTpG99fn/ch7j+B0UbqKo=
         "]], 
        PolygonBox[CompressedData["
1:eJwtlmlslFUUhi90YdpSnel883VaahRQSGQ1StRowESjBRQDpRWEGC2lFIhA
RGqgIGDwF4GoaASVJSAIWIkKiIj4AwrUpRUTlgBqoohbCIgoUYHo8/rOj5uc
c8+5Z19uz/qZY2Z0DSFs5ORzHs6E8GK3EP4tDGF8KoQR4Mtz+OoohDXlIRwq
CqGTswF6bVkIL0Mv5rwNfT14O3An/LXgBfCcR0E7/Gt5exj65eIQ/kiEcCYO
YTTyV8C/H93r4K8GXwZ+lferwDvhv4phe7nLrwhhHjJWSRZnHrK3wVPSzTbI
llbox6C91D2EzdCXVBou6hLCwiR+clqAe5eEMAB5p8D3Yd863izmbW/0T0NW
E/r3p0MYk7Fs6WhA3nR4lsBbnRfCOPDXItt6DPrX6N+JTwfxrQwdTbztU2Z5
Z+FZAm/M2QLcgYz1vC9J25ZenP7YMzUbwqRi898LfTt3m6D1Qeb7wKOQ+QLy
ZhGTjZFjoFjcDv8yZJ3oEcKMfNt4Evh77LmQsM+b8PUm7Jma868tbZmSXXtt
CAOryDnyV0E/Qj52If+NlHOnnK/G91LoddDreb+X97s5jxU658p9JacB+Ax3
83hfhM6+CfswDnhuLn+vc5qRPTi2rBr09Ye+ObJvqoe3gKfCn4R3OjmsJ5c/
wH8Ref8Qoy/L7IN8UYwV6+7wpJRv3lyB92li8FxpCD3RfzO+NiPzdKFtlK0p
8AfyXKOq1WX4dxhaivcfYc8O6NeAv8pphL8l5VqRD6rFQYofsq9gz1fQB4KP
LPDdYOBF8G+Gtzf0dNY1olqZo5rB9h9j98IY+CeAf4q+66Ef580W3t7AKcK+
A5yh0Koytl0+3JVyTBQb+dCEPZe5yyd+x6BXo29k7Pg8RTyHJO2DfHmGu1Po
i6FXo/9j7JsFbTv4gYRtlu3d4bmxxDFZju5vkdkJ79/o+w36IvifRd9aeLbi
7+SU47UTngPw7obenvCbV5A/AHplnm2sw597Ytd6X/BhwK2cPfAn0N9Y6R44
m8uvevMW8jms1DNBs6EBGRHwRN4M4m0vfKxJuCYbVW+Ra/EJ9E/GnjXI+6LI
PfEd/HNy9TAe+aVl7smOXL1r1s2OXJsN8N8J/23E43d4r+MchHYocm6aOHN5
OyXHL5uaIudUudVMG479SyPnolk9h7xHoY8ucQ2oFhbAM7+L7yYSz7tTtl85
V+77Je2r8vs4sjaWexarfgvh/Yw3bSWOuWLfwlmR8HxujWyjbJUP25D3M/Q/
E9bZknENqBb0/sPYd6JdROb5CvekelMy58eecZp10vk59HMV5lWPqlcXJT17
ldO2Ctecam8l+POiVzrWnyBzIXAy41wohoqlZq5m7w5s2p+1TbJtD/hM5b/M
9aea25f1DpKv2iljy9xD6iXtBO2GD3h/KOEaV61rp2m3aaY+hO5JKb/XzNfs
vyN27lUjmh3foKOj2DN+h3olci1oxmnWtaAD9/+fD/OBj+DviALPhKPABRWe
XSNgqgOfhYwn870TCys8QzRLFL/T0OIenmXSWQ48KuleU0zeibwztDvUo+rV
W1OuDc1ozWrViHD1hHrjguwr9oxpjzzjNOs0Y/OgtWYdD+2Q0djSCc/SQu/I
DuBHUt59snkl+P2xe1c7axpvfwW/lKsn1fIU7uqLXcOq5aE5ft01QTuY9axQ
DjVL2rLOtfDF4J1Z53oI/g3Bv34VnuWaAV2B6zKeZ8q/Zs/YyH8PzbQqfNuK
jCvYPgX/JuLfe8g4l+eZ+i5wNTz3wT9bMxL4SORe0t1R4JO5/0EN+3FAlW2Q
LaqhXbHvRJOOv9Leodqlitkl8JrIs1Izr3/KOVfuNYPexJ7GrGeTYqJYbsj4
r6OaKU3bJtmmHaZdNqHcviiHyuXp3D5UzH+J/afSLFFP/wQcZb175HNX8JEZ
928zMh8EPp42rD+f/n6zk95N+vPp73ci16+KsWI9NuO/ge5qgS/HntXaudq9
C8q92xUzxe4/5mF0OA==
         "]]}]}, 
     {RGBColor[0.9889385016412435, 0.8423462541031088, 0.5657093550878548], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFV2lslFUUfbTTmelMS2ef+aYFAS2KQKtSsLgguCSIIlJaNG5BaEqDRBQx
KkukgBZbmyo/TFRqCKUUFVlNkcSEtoBLRKJYdqImGFdiNBCBiMs5nEv48eW9
ee++++5y7nl3Bs+cV/VkjnOuop9zuRhfTzrXF3DuUMy5I8XOnSl07jDGyrBz
XZiPxFiewp7fudqEc01Fzh3F9wq+Izb3Ya+3UGdzMV+Abznm3dB/OiA5yiyA
3l1Ymx+BXuz/hO+Az7kH4ljPc26a51x7gXNr8W2Dca1ZjcOzWuPeNfnO5UDu
XAjrGFfDvgm8F+O+Yumsg7467JXj7m1R59bg3LqwdF2yeznuq804Nzvo3K3w
rx/2/4PODtgzG34eg70RxKYd51fj3Dtp2AC9fyJ4h7AfgO5VONsLf2Ke5guh
ZwfOnMfeUMg34Y5mfEMhMySt+RT6YjpT0PMcvh9wVwXOtmL8GHrmYK/U7GEM
K6KK/yzI/gi5z6HnIdjSXKS4MLYHcOdneZJnLCjTg/nPtr4Ofv0TUpyZg/Vp
zRn7l6CzAfvHMd+IOxZjvghrdyel52GsD4S8H/csxfwMdK7EeiO+hWnZuygq
fW250k+7aN8ay+f0/rKz3mI+LiXsNBk2jsWUy4IS51qgpxU2bM4RflbkKV+M
TYtf950LKJ6M8XboehprXRiH5esu4uQsZHr8kuHaWsPPWeh5z385rxyZk8mQ
zxYJkyMKNb/TCavFRVrbA/9HYb80JoxUI6Zp/L4QV/72IX5lhTrzlU/jCJuf
x73r/YoR9Y00/JeFdYYyy+DDG5B731Nsmi0+zA1zVId7D2EehE8nMP8L8w6e
L5G9xWb/kpTyODMmPcQ9Qu8+SSiWFXHlpsnWWR+diNHcXOnb0N9qxtPv7Z5q
+1Wc3Yi8zMNatV/Y/jekeiTGtsS1vhXjDtjwMuRHYx7PKEdLo7p/henhufN2
dmBAe1w/anVKu4kF6iEeiLkxQd3r83R2P3x8Kia5FO48ic9B7uuYPs7LjTMu
1oBTzokB1nN7TDHrxrmdaa2nEaf8iGKzN6EaIq+xvuhHo9nDmmi0Gj+c0NkM
xhkh4XwYZAsCysUUzP82nGzCPaNSws4NGHcFVGvkn3cjwsoprB+MqbZbUYtD
IsLjDOMM3kH9bcbXt3viVvo3EWN9UDbMwm9/VNjrwL0ladXBAIwH4/KrLy4/
Vppf1VY39Cs3KBnGYHBaMpPAYyW4YzT2q2HPPIv/R7C5LC57aNeSpHz7NaVa
vDpf+f3FcnTSeI81vRvrhXFxVntS9rJWmSvWL2ubtXBbSr6Nx7glKT4aBLv+
wO8QdP6OcWFUOslPNQnV1lrY2Il5EPIbMOZBV6v5y3eC78UExLDO4sx40yfy
Ef2kbIvJb04or1sSwjQxQR5qidu9WPsSe0Mgsx9jV1KcNS2rGmoynLPWtyOP
30B/Q1r8dhz39ma0Xgubd2eEndqo4kubiHfWfIfVKPV0hSRHP/xWm8wV/aTN
tD3fL18YS3Ir49lsPEw+eCGqOvw0oRplzdPOOzzpeRH+laYVi6swXpmWzmr4
dcE49BTsvcLeC74bxDpzTI6cnhFn1mTEMZ3GM494wgnxMtze/RDO+YLqT4g9
vofOauTmqLBfklSfQg5lr/JbSvy6Liqs0Rfan5MSbyRw7+Sk3u02+DjfeoNL
vMc5a/5Bq31ywACrl9dg14ICnaE8OYl5Z2x5br71LfdkhUlic2hM7wXfDeaH
mGGOHOTfDotPrvP03pdhrEpqfxbsbwvrTeQ7/rzVPPuFvpg4N+Cp9/GF9eZX
GbamZhVXYo923oXfU2DbgYhyzjlz+x30BHAu6omHqJ8x9Yd1N+/NGKeRFxen
VDusofuzwjNxfYvlYjYCdjSmXirkyRbKEOuTLObPwIb11j89HhWO2C8RmzVZ
zdlDkX/O2tk3E7JlYlKYYmwbDX88f1NcuGOPxLqdanGoxHrEkz/fwq566+vY
37F3YJ2wRp6wvM7F+EVCPHQioveA78Kjnt7VrPUAY6H3Meis98Q15JzvoX9T
UnhjDbGOuw1XW0OKG98A4pc4J4aJXcaN8aOfPVZrvIf+0JcG6wf2ILZ7Pelc
BtsKY8rZs8YxvI93kTvJ16wXfqwdvq3sq4ilTuhoiKtmWbusCb7ljMPmYvlF
/1gbzBfztrFY/f0HxTpHGXLIqqR8J++yF2FP8lZC9+QafvimcU5/2SNTvtfe
MPo3PKK1oK2zv2Gf8yH5OazcUQ+5j3XB+iCPk893xlVDfB+7rYchh2Ws/1xj
9Vhp3ECbiS/6QLzNySqejCvj0Gj13Gv/Y1gj5Dvy3nhPvcO9YfW57InpG/vx
MXHxLN9G9jrkhf0Z9S+nracZ64mjyg07lWZPjSed1RhvjAuX/K/QYTVyX1K2
8yx9LvRU78cRg4OQGQaZvoRxo/FJd0aY68GY72n9COTHJYSxQdYL8Cy5kvnx
WY4YS1/wMt+Sl4jZFQnxGPmM/Rb7ruuBh2s99RsX/9tlxG98G/n/r9TsIccw
l8zx//zG6lc=
         "]], PolygonBox[CompressedData["
1:eJwtlmlslFUUhq+dzkxpaZmt3/TrEEUUFZFWpSBqRFBMcMESaNUYNUoRKhKJ
W2IsJg4QoxFT4YeJCsakUKoii2iNiUmhuMSIRqEsQlx+mLjxx0iExvV5eefH
zZzznXve+57lnjvnLl658KGqEMIGVjVrdyGEg/qtDWG4KYQnI2w1IaTTIfRj
mxKHcBrbEHsuRi5nQvgQe28qhL/yIazJhbAFoOq6EOqxF8CYgf3hRAh55Jua
Q3g2GcJJ8G5GLoL5Jr6n2DMA1nf4p/BNssbhfxj771XecwT5eM7Yc+pDaCuF
sBfMXfBZxZlPwXV/wVz24fM58pKcY3kJ/DL2ETg+hj2BvrcxhBx7+tFH0d/g
/A44jZEOv07k2fh0Y+si3jXsHcX/hZRjVuwl8O8F/0e+PYE9Ded/0TfDZzW2
GvT/0M+C8zfo97MGK3xWg90Hh5/T3l/GViqGcOEYuIE3C7xXWDVJ56MBrEc5
czj422G4JCr10Jkj+Heg38Lef9APol/OGUWwO9BvI1fdxPTIWHLAehD5Y/D5
HJ4bRz7HU7ui87GRevVlQ1gE3lDSmJ3I7fg8j34azguaXSNxS7O+z7kmqs1G
9GPoX8N3MvFcxBpfdIyKdRQ+1fgezzifE8H7Ai7X8W0mvvewdoDVS34OYHsV
vT92j6hXxFG162xybMfQp8P3NXwG643RQn7m4b+X+D6D843I52Gfir2FdT7y
1thcN7EGkFtYk5DXYG/A/868fYfgcBe2o/APda6pansN+V1W4x5QL0wourdT
8DkHeQ57WtPO2RVgtUXuFdVkGvIROJzkrGHWNuR3ialcXbmDyAOqP/4bWAvB
vxu8A9h/Yv9+9vcQ8/KEc1jmvG9z7o1a1gbizcaujb7J9il4Z6fdY+q1pXlj
KSfKTZvucNJ7tiv35LudXvkDfQf6XGq+NulvNyCvZ/UhvwOHXuRMo2uh+Oo5
7wT1mZ825z70Ij020ECfwelPznq75NiFKeyn886dcrYU7rMq+dUdvDbyHVC/
qaYvE0tP5LuvHK1C/jVyrQJ4v0SuqWqrmZJB3gV+B/gr0Xti97x6XzF/Al5U
cO9r5tSQ28cLjmUy367OugfVi+qBMchfEt8z+PayZyXxdbH/aMox/83+mZy3
DnuCb9uJ9QFiXAHWHvyXI88EYyryV/h34juRPZeQj7kcsZTc/5Cr1JL4c+xd
nHO8Y8Ef4uzVGWOp/ppNtbFnjWawZrHO1NnqsaMlx6zYNZOryE8Umft0zhsP
1ovNvquqqWp7FZi9mj9gXK94C76rW6nhqbxnombjNDDWIi9odK+qHouJ/z30
U2nnfGfePSy73pMtBfeUekszQrOilT0tdb7DussnIs/mTeTsN+SOgrkqZ8rd
7Njc9KbMwPeDvHOpHCqXtUX3pmaeZl8XnNoTzuE2sA7DZ4TzqzljGC6v533W
ZL4dwn5ro7lq5s5HbmDdnnaN27Ke8ZpnwliPbaRgX82nFPbanPfrTnQXPFM0
W/QGHUJujd2rmjmXxp5Jmk3KwZWxZ7hmuWa8Zv2iZs9e9dRC5MHIb6t68P3I
OVfu9SbuoT/uy5q/cq7aXFby7BVeVew3UG+h3qB6+GzOOn7N/H5yt6LZb4V6
Vr2rGatYFJNyMSXjXlU+WiP3hHpDd1x3fUnlPmi/crEu77f5zMxCnpD1W6ce
Ua8sa/JdO3Pnkedl/F9DnFSb7thvg97oct41U+30RhwC/63Yb6vmZzu+u2PP
Gr1xd6B3Nblfhb8E+YKi33r1+CTkj5rsrx7Zh7yz4LumN1tv9/85FzKS
         "]]}]}, 
     {RGBColor[1., 0.87169144622514, 0.6031714616721376], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNWFlslFUUvraUznSm7WztdP4BAWWJyL4KiQmU4sIupaBRQEGgiMEHIxoF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         "]], 
        PolygonBox[CompressedData["
1:eJwtlllsFUQUhgdKKbe3Nb0LvRu7UiPIWgQhMXFFBUGhLWgUK6iIYuDBBIwC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         "]]}]}, 
     {RGBColor[1., 0.95, 0.75], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNll1M1nUUx3/88UHoeeRd4HkeNdtCN5otULDuuqiE0NWEvLPXzXmlm5t5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         "]], PolygonBox[CompressedData["
1:eJwllDlM1GEQxYdLRBZlD1h2VxQLsVASWdRoZ6FBI0aDtKIxEamwUhqxcKUR
DzzAo0AuIbAe8Sg0RgsvLCRhUUPEylgp0QhGChOjv+cUk8z3/2be92bmzX/F
gcP1Ldlm1oDlYuGo2dMcs53Y/qDZsrBZY55ZO7YhZvYGOxIwGys0G8e/Tcwo
sZkCs8fknkqYNRE7UGR2Gv81375z94SYF/jvyMmQW55FbLFZMm62Ebxe4lfy
Vg3nTQH/pruzYAwWOaawU1hgkXMqJz7C+38o4BP4jeA/w77w3gz2iLtUsXO9
Cd418C6QPwpeM/md+B0J51qVbzYdMXtbZtaFP0wz2kNmteTsDnjNql01qJZv
4L/CP4H14Q9gbby3Fk6tYFdw7gW7fKnZy8VmXzlvIf8DNsX9R2qYxr9XYvaL
9/IXmh0id5Zv8/DNI+YH/smQc9nFeRJuA/Cpgct6au7H3xb32Yjjdvw67G62
93gn/kFq2spcS8Fowh+G7wRcOom/EfSeq/fq8Rn4riEnGfA3qvBH4NADVhv5
x0vN5rC/cJ0EYxZ/X9C1Ig20gN0K325iG4jJwDcN5jz1ZS8gRvj0Y8cS70Ez
b/eJb8A59+JPkJPJdYyjIZ+JZqOejDLL59jqQp/hefCGgq491aTaKkv9bdWs
2gPw/825FvzCmPdQvVwFRjLmGpAW0uBdwq+O+Z1qvMVbIwnnLs7i/jDos5TG
pLVjnPsLXAPSwm9qopz/31Kck+RvBvs9NUyFfKaarb7VcPcy6lray5uHuLuY
cC7D2Cqwqkt9dvXopQHufQnHksaqw655aV878TPqOcodws4lfAe0C9rBsahr
TFrTTB6gvUjUtaqd1+53MYPH+GmKuIp/Je7+IHYfrL3EDOT4zoWDvlParVGs
G7+zxHutHV7HuSfuWtWMr+On4q69cXpUR387iv1foB3RrizHPi/2GWvWI8ww
Y76Te0qcg7hIo9Lqnajvnjil9S+KuFaVo9w0GCeyXANzMdestBvDCsldttR9
vVmBfznutagH6sVMme+qNCltqqfqrTArwz4zzU47fBd+/wBbnMpI
         "]]}]}}, {{}, 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVjr1yAWEUhl81hSDEzwQF2lgug4YZrST6dQfbiCbxG3oUGMu6AEpdSorM
uIdMrCvwKJ555jvnvOc76fdmxfRIKkPJL7Vi0vxBWkakBd7jLd5hB5u4jpv4
FQdxCH7ITuPSS1Ca4Dye4d+AZOACXKKSCzaz55D0Ra0Dn9CDLmTIGdxQgCIM
HqUaGS/44C8sXfGaHRa9Dc6S6ZPN4REewwC+YQgHZpIJKQXP4OVe974HHHp5
9hlwfJI+uPefehufeL/hKv+suNeGBm+L/or5MtkbDzIvOA==
         "]], 
        LineBox[CompressedData["
1:eJwV0DsvBFEYgOFPr8Cuu5UoqJZEwS8Ql4QGrS0krIqOhsZ21K6Je2U3IqyC
SuJe2ISg4CfQ0ak8iifvOWdmvsxMy/jM8HRZRGT4TUTkaiPmKyMWdUGPtaBH
mtcxTfzvayKSmrH/4ZtcY0TKjK76iGbt1v6GiAF66ePRWYlcRcSm/SprrLDB
OkVz09pOBwfsc+mZbd1hiz12eXE+qEP/a7NfWXL2psuaaorosb72judmX+mF
3usDN9xxS9Z9J9URp2R9w5kWKfi2PIekzZtyrWT97v4PPusivnhitsq7+j9z
+mzfat3GRDJiknLnnfajro3wB8iQPc8=
         "]]},
       "15.400000000000002`"],
      Annotation[#, 15.400000000000002`, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{4175, 6571, 5762, 4709, 5296, 5295, 6335, 4706, 5757, 6337, 
         6336, 4450, 5456, 4449, 5286, 5754, 6418, 4832, 5870, 5872, 5522, 
         4829, 6417, 4831, 6415, 4830, 6416, 6568, 6567, 7180, 4826, 6964, 
         4827, 6413, 4739, 6410, 4825, 6408, 4824, 6409, 6566, 5519, 4821, 
         5570, 4822, 5521, 4738, 6407, 4820, 6403, 4819, 6484, 6485, 6483, 
         4951, 6054, 4516, 5867, 5868, 4265, 5138, 4264, 5143, 6073, 5144, 
         5335, 5334, 5026}], LineBox[CompressedData["
1:eJwN0LsuRGEUhuGlVYjzaZyGoZGQOJNIHBsKDKPTzMjEKZR0jBvABdBomREF
rUZFQ0PhEtyAUHiKN+9e3/r+/e/sZPYgvV8WEVl8VUa81Ea84q8motgQ8csF
+Q+f8nNTxE5zxDb2sIstlOv28hkucI5WWQvenCvVRbzzvHwOt4mIG3zgE0WM
uWPFLo1VPDizzEvo9J5R+2n331dF5PnE3CZvRwfu9Bd1F5A0j9hP6R3zLE9w
St6NHjzqZ3TX0GUu2G/pjXPJ98x4vuQ+8xX387gs5bkLefMrb8ie6iOuqyO+
G/0735fzD4e4wh3DnJGvY0BvEEM41DlCwrlJ86Z9Dv/xKjRv
         "]]},
       "14.000000000000002`"],
      Annotation[#, 14.000000000000002`, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{4360, 5142, 4514, 6046, 4515, 6053, 4358, 5332, 5333, 5024, 
         4168, 4210, 7028, 6442, 6443, 6402, 6961, 4814, 6404, 4737, 5539, 
         4877, 5569, 5076, 5077, 4878, 6446, 6448, 6447, 4817, 5859, 5865, 
         5866, 5501, 6492, 4954, 5862, 4955, 5449, 5448, 5273, 6414, 5274, 
         4828, 5078, 4211, 5450, 5277, 5453, 5454, 5285, 4690, 5288, 5287, 
         5756, 5755, 5292, 4451, 5458, 4452, 6339, 6340, 5761, 4708, 6338, 
         5299, 5300, 4710, 5083, 5765}], LineBox[CompressedData["
1:eJwNjjsOQVEURTcdiQTPN16BhEZCQyIhGIBKSJQiggqNAg2hZBIGID7x630q
JmAetFaxsu45Z997bqTZr/QsksoQc0s3Q4rjhUeaQ8knFaEA3YDUgbxLMr1S
Dg/JOMg7qTucu2CnbuEUdxJOqcE5itsQDUlXdqzJ1Ohng1IVm8x85Af0L7iP
3+zKkD1Tn+AAU3Ya9D1gpZ5wf0dmC0f+EGZe4L2QX3riEfWGfpr5gzptSnds
Y18dDtzfQ5L+l4wf//CbzAs+ZGa8NeGdMR7jFfMl/AGODCeq
         "]]},
       "12.600000000000001`"],
      Annotation[#, 12.600000000000001`, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVjj1vgWEYhY/4WCrhrbaoyd7+kIb4Sr2865tIfSSItU3qD9RsQA0YKGsT
e7vWVmyEtBN/wWW4cu7nuc85zxO1a5mqQ1IKHvzS663UhG5Q6hjSO+pGjSvJ
RIucbfYl1AVOmJN7u5Za4A1Id2HpAr1Hh+x8ZEfo9kbaQI+eATkTjxvPz6W0
4/7AfIRnev45/8EeFuw93NeZ23TlyL/gyaMVesqwjkgrKOFr4EuT+QhJFp4k
3l/eWkKcOQZ9etLoI74JcxadoVNI8NcxPU16vun4ggI9Jv4VHWvInrPwid9C
n8ifAKzVMJ4=
         "]], LineBox[CompressedData["
1:eJwNzksrBGAUxvGHNcVgxm0j25lSUqyVlI3cNqzUjEtioabGJRZ21r4DsmRh
wQbl8g0Un4FshIXf4t9zznnOed53YHlrZrMpyTS+OpLdUrKHBurtyT59bUsq
/ck3v2B2XkyWzBfxicfO5AlnvAv9KT3qTQ7cNZsf0vsenrua+Qqq+NW30D/a
1ZcUUcJbd3JpdoXVruTF7TOu9SeF5J3/4Y1Z2WW6YadCF/Q/tGLvl07aG6at
/Bt/v8UQr+w/23bH1KOoq3vl7tAGqu5qmOCt0zWMyxmUcyfjAVO8ETnH9ufV
c/gHgxsvkw==
         "]]},
       "11.200000000000001`"],
      Annotation[#, 11.200000000000001`, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwN0Lsvw2EUh/HTUQzUXWNpSIjBwELZDQaJwUobRpUIIYa2JGz0srO6rfgD
VEIkYlWbW8Iq7D7Dk+ec837fk/f3S+dW5/KJiMih0RpR74i4xV97xC8KZj9c
7424wUVXxGYy4rxbjVOc6M+4vy9iS72Uck9fQhFvdjzY+cqjMqEe44Rdl3Ze
4RpJ59vc6ImotkU8c41feIUfOc8H7h2ijF35D/Mj83c+5k9e5yfe4IpcFcv2
p/FtPsxld7/UI86a5HLelUVLZ0Szfk094XtS+gxnZXPIyE9iCjsyNXuqmNYP
uLdvtoeC7KB+1rykLmLGniH77vzTe8w7G/eWivyiegH/ZkQ7ug==
         "]], 
        LineBox[CompressedData["
1:eJwNzzsvw1EcxvFfY0EMLq1LWCQSTLwHs4VBU5GIQUyo2ivhXbSlrRpc6pZY
TCYlDNqubpMXYeEzfPM95/yf5/c/Z3xta2EzERGr2OiPWElF3CcjljiNj4GI
d2Ss1/siGsMRTzgYjLgYiajjRv4Waf288yW+kzl2dsmL9nW+xhWWzZkzL8OH
MjmdXRSsi5iXz9qXZU/MP+IETyPbG9F2n308m9HNVd7T+ZN75dnRiBeeGoNO
l0wLTTzIdnKF8zK/Og2e0XnkSZ0JnZz9Drb9702+hCLa7tfh3tUh70MZJfsK
1/ROzTvHj+4ZF3z79JYvfKNHv2ZmklNooYmK2f8rij4v
         "]]},
       "9.8`"],
      Annotation[#, 9.8, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwV0EkrxWEUx/FzbW5ZCNe8kQXegxXFRookC1OxIGVYGBJ2ko29yHRlKTIm
KQsUSlmZFrwAvAAZ8rH49j3nPL/z3Od/y3qGm4cSETGAZE5EKi9iiTM5+I4T
3FsY0Yf1gohjni2J2DJPqEvVGTzJU5jGon4J9/Lr2RFZ7llARXFEJcqRTEXU
5EdUo1HfhM+iiPPciAd7b/p3jDgfxaX5GV/wPKedfctf6b/4mn94msedP7nj
ETf6X/MWvxd2bvXP5h/qtLdNyG7wiswqltEgU2Vexxv6Rh6wM4g62TXfUs9j
+rS6w39RK9/J+/IH2EWrvT3elDnhNv2MnXY+MjvEjndsY+7/rf/fgT73dLnv
xZtf0aFux6l8N/fb/wOENEPR
         "]], LineBox[CompressedData["
1:eJwV0Dsox2EUxvGjmCzu/q5F2cXKwOIyIQbKdXBJUaIMlMn9VsTgltGIhUWx
MRpQWAyMLAyKfAzfnvOe85znfX+/kr7RlpGkiBjDYmbEEibSIxboPK6yIh7S
ItpzIzqwlBOxjA/1Pd87vaOTdJwemV3mRUzbSbJbjdaCiDYk9D8zIvazI/Zw
ypOaH/FtJ8M8E1m4T0Qc652gn28Am/Ye9TfoE/2iefLKCiN21IX2dumL2Rgd
tnNrXqR/4JzM9yMvzX2/NMX5UP+V/w0XemveM2pvnc7SOZzjDKv+RZ28OtrC
/yynhyZkdNJudGHc9xbxF2NGXeOflKpr6ZT5NOrd1YBGLPJsy91Ck3O5vBW9
ZczzVjh3/PvUC2iWUynv2jtu0GtW5b0b/EPqQfwBiBRDVQ==
         "]]},
       "8.4`"],
      Annotation[#, 8.4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwV0ktLAlEYxvGn66ZNZVdntKxVRe3aupAulCTkpizQcBWoMxlE21bRXlHJ
orI+QG1qBsJ2EVi6qX216fIdgv4ufjxz3nnfc46DgaQdtVokHWCuWyp7pFyP
9DogveGMWlefVEBgWBrDKDrpGyeXeqVgv7RMHg9JYbJM5tmjMCiVUMQf+4To
KzJXQh0NtCJlSG1kmrxn/oVz62hglxmLuo0MstiBw36GVzLxxT2+cUJtj36D
ZxNe+OGDyzsfvX78sP7FKbV9+s/RzvlPZAe5wbtNrCHGusZ5681njGCadZV7
zpAPZIRatDnPepWcNKUpTGCFdyl+R4S+C77LAnlJXsGibmORe1T4vmEyzbfK
oEI9zjd06HNxixizd+Q896yScdaH9CVIl3kHN5x3jSPqz/TUsM0+SWbeudsH
tnhOYJb7fjLrof+RP8E/fO5I3Q==
         "]], LineBox[CompressedData["
1:eJwV0L1Pk2EUxuHDwEcCg18UCg50cqxMjSSGtUUYBDY2wKUDJlZaAVncTAQr
Cxj4Axg7EQa+wgSBASbYYLe1OKkhWi6GX+7nnOc+9/u8JzX5dnSmKSIWseXw
uzvi8FHEHzr4ICKfiDh9HHGCTGfE+MOIsrtv+IoB3mqP+knECl6oJ8ysJSO+
45mZMfUoXuOV3tA9ctbV010RU1iQ9cn8ezqLAkooIikzZybnDVmapfu9Ee2y
O5Bwn5FV4/2JG9SxzLuEL9jj38UCbxudpzNml/3jpfsLpPT7sIMWtKIZBd48
72fec74z9Or3YBuBJvyzhwb+4w3/Md8RKt5WllHheentH/TmEPoNvudPI/rR
cJemV76zoX9Ni3ZTwuz9nuQW7K3TbFXeX/O3zqu8P9RdzjWaoCO+NYy0nf6S
+1HWgf6mmXcybvTquAMIWUxS
         "]], 
        LineBox[{4952, 5566, 5476, 6646, 6645, 6970, 4838, 7181, 5893, 6690, 
         4283, 6691, 5894, 7182, 4839, 6420, 5879, 5880, 5523, 5878, 5877}]},
       "7.000000000000001`"],
      Annotation[#, 7.000000000000001, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwV1Ftsz2ccx/FHJ1yJdlRVXTBWtRu6ZG2pw2xU2LKIxRaJVhVz2LT9M/pv
ZcvSbHU2bBXqPMOWiNmFidMSFyK2UIcxst3QorU4tgvmtNdz8e7n+3zPv//z
+7VvWcXE8g4hhFn+pKSF0KV7CGvptxkhrKP19ElqCCPT+bo54zSmZoZQTV/0
UCxnm/iLl0OYmxVCB/7ZNNA5dJP6Tvp2xho9q3uF8DXt3zuELfpsxVtyvtHn
A3yISXjMN03u+3J/lVOsVxvakcl/QLwXzdbnkNkD+a/Lu4ENYpV2mspXihKU
YRp+ETss/w57Izsh76lzV32e0YN8/4o9Z680u8qMZNzZTqvxn/gMzz0TH+GY
vAbPuhEn9aqlK+hyjBY7pddv2Gav7XhbfaFYEd3p/B0e6f8Qk8zboeeuniHs
xg/Ygz/Uz5A3E8MwAsMxQf/H6o7JKWYfoVPoUVpkxliUOlfpmUQ1jriHCWYv
Y18Va6NterXjC/n7xNr5Xvcc6Z63BzKwV+z3eCfyylCKz+RMp5U0gfv2/EnO
X2b8jRy+N+yXh3z8qMdQOgQFGBjfKTU3aQuykOoeetMmuzXjgfh+PS/rV8PO
RwHy4n2LD6Fz6XS9P6ZP9P2EPqU7/J4LxVP16+PcF9/L6+pczZ9GF9EkqlCL
K+bsMe8eu0L8vF7L2P3ZS2m/uKOcjnpfcF7snBOfBa/hhP4D4nuJV/G5+C20
Yqe+d+N7p7aRvYT9Cv+XtA5fYbj6YchVOxiD4t5yLriTrWpqxM6zz+Esjsff
gK8gfqP2Wu/u3+Srp6NoLv9glMgtxhS8p9+77i1XfJW81ZjMP5Sv2Q6F5tSz
82lTPLO3iG9GA8bF71hNDZJoseNNZJnTRJtxDTdwHRnmDNAnB9nY69wY780e
+d6tFnPyaCstl1+Beag1p0hOmndiTLwzdSnsJJ1n1ir5/+iz3Xm0+EvsjkhB
gm+OnKVyGu1/Bg18mWKj5B6gB+P/AxwWO4Rs80rizmq6e850ZLHr7LYfP2M+
yuUlaAV9rtczLJY3Xq9WM8bRW/QdelHOffdSKGdM/H5pEV2u9232JXXr7fkn
/VTPhPwFtJIuEa/D/7bB048=
         "]]},
       "5.6000000000000005`"],
      Annotation[#, 5.6000000000000005`, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwV1XlM13Ucx/FP6w+BPDg8kFp2buVRm2ZmGYeW+IcmYC23NLQy//GqzMoE
wgwEwSm3wMR5r9a6LFvchppGx1r1T7VaWXPrmAdS0bIenz+evj7v+/35+v19
uf6xtQVrrggh7PVPTnIIDWkhbE8J4eOxIfSjmS9hdAj1eOLqEFbgcazEk5iT
GsLFjBAG0DI+hFZkq6kZF0I+CpCHB7EIK7BE3ZC6R+g/9M4xIUzHLOdz+txL
z9Nt9lggf0C/+fQSXca/kL/TnLPqf7FvPX+f+gb6O98qvn1238B+mX8LqvVM
FquiKXSmWK87lTqPl/8SzaCH5B5El3iimQnINa/Q3ArnSrzCLkOfnM1yK/W8
8hr70jf5K+LuqMQ89i67bFNXhXJ2Nd1o1hdmjqPFNJ2W0FRaREfTF2ka3USf
M6tC7Xo9N+BZ5LF3692GteJ3Y6femfRnNTucV4qNoMMxCiPxqp0n6ttBa2gt
FuKEmjx6ks5zl0tm5NJBOol/hmd+g3te1n8x3390Jnuxnllih9QdxmyxOfhU
/HUzPqE57Ax5X4t/hWn67acHcQA95nTK3c3fhodQoGc+huKd3SNFfTJO6Fci
t1FdExowWf4uelIsVc7f0e/5tDp/q/Y7HGU387fgHj1n4SP5r+l1imbGdw9T
9GqVs5quwVvqqvi3oxp72KW0jW6mz6stpo3sItpEa2kdavAu+zp9jsmbQP/U
u9f5sLk9dJC9if+IvG77duEb+9azW+LvRixJTrFnlEiL6Atqj6ttSndvNGI2
/wXzporVsTPZtTSLTorPCBPRzu6jx/EhFuh/u5p+/bLVZ2Ef/9742zA/HX85
D4o/LNbD7sV79uvlPxb//zBfn3Z9vpT3gLx+Od3xWxLvROfSc2IzvDPnaS77
FE6jQ3xIj076uVir+vZ4f/oB/cxvtVPeKrEM9R3OTZ5RttjTcp7BOmxhPxV/
H/JG6rfVXUfQCjqK3kgP2HFMfN/pDroTY3GHd20aGvVtwHRz7tKvXL+tKMMb
7GVy08QKaakenfEbqe8P+t/qXK+2DsvtOFX+MHqT2o74TZGfhGHyv5d/C1+X
u13rPAHDUSZ2FS2nj5qRatZSul7uj3QJTuvxEz2D5XhbfnZ8V+kRvIP33eUo
brbDUvPPqE+xVyrSUMKfL++COQniiUhCs94tGOAvEL9IF9FC95iMKfhX/DKS
9VzHzhbPQVb8mxC/ATirLjd+S3Af5uJ+3Oa+f9h1o9ru+N2wy2q7/Mb3K/4H
mq3z7g==
         "]]},
       "4.2`"],
      Annotation[#, 4.2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwV0stL1GEUxvFj3gtKc0YrA8kkEUFdDBSYuugCKWi40jaB5sIUw3/AlTfE
VhXkOiovC9MUIYgC/4a2QrUIx2u6MM2Fn1l8ed5znucc3vc3c6PnRedQVkS8
w2lRRGEi4mVxRHtZxJG6tzTiH+1Qd+p3l0c8Qdm1iCtY4aWSEY2XI3bUe9jF
lGyrmQP+I3pI22i7fpf5Y/mEXBKlqLPjtl7a+Q7dopOy983smr1H9+gD+lB/
TWbbntd6t8zWqbOuR9TT5/xmuTSviW7RFtqiP1AS8Ur9xUyrcxt+2ZPS++7t
y+bP2/OZLmEVF9QrdJi/SAvVnzL3RxI/zTeY/8afVefz5+hHLKBAPU+f8t/T
PPUHmps5Y8N8tfmv/F73SfCf0R6su+c0r8+51v1T3vFHXel3uYkq9Ou/tWfT
nnHemJkJmlbP6FfxG8z91rsofwlFGNHvkNmXOed7ZyMHM+bzaR5y8Zf/WK5C
vtaeDXs2Zf7jFAP6jfy7OLrq/4IlmTe8ZXqiPkYzvwnF8jX2/MjcUWYbOxjU
H/POUZwBdTNb7A==
         "]]},
       "2.8000000000000003`"],
      Annotation[#, 2.8000000000000003`, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwV0TtI1XEYxvH30JqW17wROEhRlpQZdidDaGpw0CaRs+VgoFk6ikpCgXAK
imZraRAsNT2OXqpBzKKpY4VZRKZNGlHmx+HL83vf93kv/3PKk9cb2hIR8RTn
9kY8Ko5IFka8xis8kPsid7ggoiY3IlUU0SR/FW1qd8TV8pf3RZygd8XL/C/V
X4g3xKt8F9V/0jpan2NGacRv9ZySiFzkocKOSrnv3kfoAO9tnMJp1OIsTpZF
nKFJjGEco3iOWXt7zR/Mi6iyrxWd3gv23aRv6A3ahUJzbtEUz7S+GVSixpwU
rVW/R5t9z7y+a7wfvDNYwoB7P9NP+IghN1fwrfA10k1xlm/Jxh4k+Cfl69Qn
6CWaplN60yi376tbGnmPuaEapXLHaRntV2vXU+DdQc/jAjJmFKu1YFd+xLed
mKcIPX6LSd+QxhSemTWCFhxFFXbLZ6FEf5+4H2tu/+umf9jCQ7cn3BX4L15X
v2LPfvMP8Wf0rvD8wXv/+aD6sJlzOzP4tjCmdxzv9IzSdrUONOldd/ei/H39
b+kv8RP93WpD9DF+qB206wC2AT3eZ/A=
         "]]},
       "1.4000000000000001`"],
      Annotation[#, 1.4000000000000001`, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwV0b9L1HEcx/F3dGGT90PLu2rwHMKzriVo0KWhdDmhHFoDcXDI7PwLOglF
gyKC/Cu86xduDV5Qi5VCdykKWhRIoEN1kRTUo+HJ6/P6vH9+vt/86OTIzUMR
MY2jqYj32Yg2unssotgZkUpH7NMk3etyxlc8PhFRwzW55VzELTzhn+MZnuLP
yYjfeCVWPR5xLxPR0P9A72181rOdr3VEZOgXPknTSOEjsvpn9XikdodfoD/t
08IdsaK7cziLN2au4Lr7ipm38ZZfwyre4YU9/urXFBtS03/KPuYOOv+iDTlj
6ufF59DkN7COD1hWH2o2xa6qGXBO2OmK82G6JWdc/WnclXNG/kvU8eD/W7w7
h6rcb2oW6Xea8J4f9Lycy3IvoVus7K7u+0zRHv4GzdMWXaKv5X0yZ5ov8Bf9
m15a4Sf0uoCH4iV5s+5mUPLOoh2G6X1z+5wLmMMR/h/KtlE5
         "]]},
       "0"],
      Annotation[#, 0, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVzj0vw3EUxfFrqXoMLS1CQnRqG0kHXQiRkLAYJBLx0IGYGvoSOiBh8UIM
XoPJwGBgMakQ4mkQBqNPh2/O//7Puef+xrZrK/stEbGLciqi2B9x2hdxMBCR
Ny9nIo58H+IyHZHjz/dGnMjM8Uo9EVU0hiIeUZUbtrdHZ+TqcinzmjlNN+mF
nnW6gUkdZUzo+DYn9W/ZqaDVdwIlPfO8BYzJHg9GjMrv4NbNO0zxZps3m++W
z9MCOuTr8hnZCq5krzHKy2G8ifyPe79YwiKysg+89mYH2tCFTpx7f5I+2bv3
vj9M2xkxv2UjbmjDv5q7CT2reOO/o4Bu/hc90/Mh/4lH+Sc8o8h7pS/4B8MC
NNU=
         "]]},
       RowBox[{"-", "1.4000000000000001`"}]],
      Annotation[#, -1.4000000000000001`, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwV0E0rhFEYxvF7pkFZyNt4C8+MGvMiawmFWSiFmpQUGzubZ3wBtnwAX8LC
VhY29hJlRchEKbay9bP4d3Xd5999Tqe412ykmYjYxV1PRCsfcS9r/RFVvOjP
eMKt+edgxFlfxJezb1RQxgc2uyNySIcjHvk3/Hf+qJxz/mv2gDc9NxRxbk+H
bOlZ2Y42rHDz9nQORPzwJ8yKuOBXZBUllDGJBj/hF/gJFszmcclflnXMYgmL
2OGX+DXuGKI3Yt38ir8hs/qqzMgD7oz3betd+pZ8HfEv2LdjGoecIxS8NcG1
PU3eOL/+f4dM9WPOCab0NfNT//QHVdouRw==
         "]]},
       RowBox[{"-", "2.8000000000000003`"}]],
      Annotation[#, -2.8000000000000003`, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVz70rxXEUx/EPFga597qe4yKZZZKyKEpRHkabRZGHicXM6s/wD5gNRlmU
EvKYey0o5Vq9DO/ev3N+53xO36G1neXthiQrGC8kxz3JdGdSKSW73clUMTko
J23qHS5wuSM5a0+KXMKm/gZG7K/jtje5w5z9BcxjTM4k//KA/EN3jrBm/srs
j/6E/3VekrWIAfWnuou/uMKn7vbzh/rb7WZZLZgxP4sn/br+nux9rMo/l/+g
32DvkZu4j1+6kldcm98y22h2Bc9yhv/fg3fUcOJulS/sDfKNnVFuVddkXPK9
XtX3G/4A/g0wbQ==
         "]]},
       RowBox[{"-", "4.2`"}]],
      Annotation[#, -4.2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{4101, 5157, 4099, 5151, 5153, 5348, 5347, 4364, 5346, 4553, 
         5155, 4552, 5031, 5030, 6113, 4554, 6101, 6112, 6111, 5178, 4111, 
         5620, 5176, 4378, 5343, 4377, 6139, 6140, 6138, 6850, 6849, 4186, 
         4110, 6517, 5619, 6144, 6143, 4386, 6169, 6170, 6166, 6857, 6856, 
         4189, 4116, 6526, 5639, 6172, 6171, 4392, 5373, 4393, 5199, 5376, 
         5375, 5211, 4131, 5671, 5657, 4605, 6219, 5050, 5051, 5672, 5228, 
         4606, 5380, 4406, 5398, 5399, 5230, 5229, 5395, 5243, 5409}]},
       RowBox[{"-", "5.6000000000000005`"}]],
      Annotation[#, -5.6000000000000005`, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{4625, 5397, 5225, 5378, 5379, 5210, 4399, 5381, 4398, 6196, 
         6197, 5658, 6531, 6532, 4193, 5372, 4593, 5198, 4594, 5197, 5656, 
         5196, 5370, 4587, 5187, 4588, 5371, 5044, 6168, 4586, 5614, 5637, 
         5638, 5188, 6141, 4572, 6133, 4573, 6142, 5036, 5362, 4571, 5171, 
         5616, 5617, 5174, 6108, 5175, 4549, 5177, 5585, 5586, 4178, 6830, 
         4548, 6100, 6105, 6104, 4362, 5344, 4363, 5148, 5587, 4097, 5150, 
         5591, 5590}]},
       RowBox[{"-", "7.000000000000001`"}]],
      Annotation[#, -7.000000000000001, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{4550, 5149, 4551, 5147, 5146, 5584, 5583, 5581, 6103, 6102, 
         5029, 6109, 6110, 6094, 6107, 6106, 5173, 4109, 5170, 5172, 5342, 
         5341, 4376, 6134, 6135, 6132, 6841, 6840, 4185, 4108, 6516, 5615, 
         6137, 6136, 4385, 5367, 5368, 5186, 5185, 5369, 5195, 4125, 5655, 
         5635, 6192, 6191, 5047, 6194, 6195, 5660, 4595, 6193, 5207, 5208, 
         4607, 5209, 5673}]},
       RowBox[{"-", "8.4`"}]],
      Annotation[#, -8.4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{4126, 6533, 5659, 6199, 6198, 4391, 6165, 4585, 5636, 6524, 
         6525, 4188, 5043, 4583, 7132, 4115, 5184, 6846, 4569, 6748, 4570, 
         6847, 5035, 6843, 4568, 6746, 4107, 5169, 6827, 4546, 6824, 4547, 
         5028, 4177, 6820, 4544, 6093, 4545, 6095, 4361, 6098, 6099, 5582, 
         6097, 6096}]},
       RowBox[{"-", "9.8`"}]],
      Annotation[#, -9.8, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{4596, 5374, 5194, 6853, 4584, 6852, 6855, 6854, 5042, 4582, 
         7131, 4114, 5183, 6844, 6845, 6747, 6848, 4375, 7229, 4373, 7228, 
         4374, 6842, 6745, 4106, 5168, 6825, 6826, 6823, 6829, 6828, 5027, 
         6821, 6822, 6506, 6507, 6508, 5145, 5580, 5579}]},
       RowBox[{"-", "11.200000000000001`"}]],
      Annotation[#, -11.200000000000001`, "Tooltip"]& ], {}, {}}}],
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic},
  PlotRange->{{-2, 2}, {-2, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.654989116848946*^9, {3.654989163137479*^9, 3.6549891884011917`*^9}}]
}, Open  ]]
},
WindowSize->{808, 871},
WindowMargins->{{420, Automatic}, {-566, Automatic}},
FrontEndVersion->"10.2 for Mac OS X x86 (32-bit, 64-bit Kernel) (July 6, \
2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 545, 15, 46, "Input"],
Cell[1128, 39, 182980, 3106, 376, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
