(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    784880,      13382]
NotebookOptionsPosition[    783472,      13329]
NotebookOutlinePosition[    783828,      13345]
CellTagsIndexPosition[    783785,      13342]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
Problem 5

\
\>", "Text",
 CellChangeTimes->{{3.687187380597857*^9, 3.6871873847704773`*^9}, {
  3.687187423713944*^9, 3.687187503193817*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{
   SubsuperscriptBox["\[Integral]", "0", "2"], 
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{
      RowBox[{"x", "^", "2"}], " ", "/", "2"}], 
     RowBox[{" ", "x"}]], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", 
       RowBox[{"3", 
        RowBox[{"y", "^", "2"}]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "y"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], TraditionalForm]], "Input",
 CellChangeTimes->{3.6871876459357853`*^9}],

Cell[BoxData[
 FractionBox["50", "21"]], "Output",
 CellChangeTimes->{3.68718751397657*^9, 3.687187651677956*^9, 
  3.687188985222074*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"8", "/", "3"}], "+", "2", "-", 
  RowBox[{"128", "/", "56"}]}]], "Input",
 CellChangeTimes->{{3.687187523091139*^9, 3.687187531440198*^9}, {
  3.687187575705583*^9, 3.687187599127611*^9}}],

Cell[BoxData[
 FractionBox["50", "21"]], "Output",
 CellChangeTimes->{
  3.687187532419187*^9, {3.6871875776694*^9, 3.6871875997306547`*^9}, 
   3.687187686511973*^9, 3.687188985271661*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.687187688496564*^9, 3.687187690648204*^9}}],

Cell[BoxData["2.380952380952381`"], "Output",
 CellChangeTimes->{3.687187691331839*^9, 3.687188985298867*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", 
   RowBox[{
    RowBox[{"1", "/", "2"}], 
    RowBox[{"(", 
     RowBox[{"x", "^", "2"}], ")"}]}], "\[Placeholder]"], 
  RowBox[{"\[Placeholder]", 
   RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}]], "Input",
 CellChangeTimes->{{3.687187633721141*^9, 3.687187637879643*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["x", "4"], "8"]}], "+", 
  FractionBox[
   SuperscriptBox["\[Placeholder]", "2"], "2"]}]], "Output",
 CellChangeTimes->{3.687188985344702*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mytop", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"9", "-", 
      RowBox[{"x", "^", "2"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6871786805654984`*^9, 3.687178760626651*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJw12Hk0Vd/7B3DDvfdkiAihQoSUKBFl2LsiUYoG1McUIkoyF0pR5pkyVWgQ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      "]]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-3, 3}, {0., 2.9999999644585054`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.687178754460601*^9, 3.687178761367597*^9}, 
   3.6871889853976393`*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myquad", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.687178892842334*^9, 3.687178947642426*^9}, {
  3.687179000459599*^9, 3.687179052519342*^9}, {3.687179101474867*^9, 
  3.687179110787475*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJw1mHk01VvYxw0hQw7S4CYhhFNkiNzS3iR1K2NIpaQbuiRDhAgJIUWFJlJp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      "]]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-4, 4}, {-1.9999996208907247`, 13.999998693877577`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.6871789486226177`*^9, 3.68717911191495*^9, 
  3.687188985452015*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"mycp", "=", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"x", " ", "y"}], "+", 
      RowBox[{"y", "^", "2"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"Contours", "\[Rule]", "30"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.654989063175415*^9, 3.6549891875319767`*^9}, {
  3.6871785714941196`*^9, 3.687178595345471*^9}, {3.687178765563637*^9, 
  3.687178769713572*^9}, {3.687188969009021*^9, 3.687188969607532*^9}}],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyUvQe0FkXy/3253BzBnHOOa0IMuzOYUMw5Yw6IkTVHzGnNrhHFrGsWwVVB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   "], {{
     {RGBColor[0.148, 0.33, 0.54], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmWlw1tUVxm/+2cFCSMKb5DUJgfC+eVOXUQRUHEVUFnFjhARsFRWYymIr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         "]], 
        PolygonBox[CompressedData["
1:eJwllU1slGUQx4dCt7vd2m532/3q7tJa3ne3ApWABKMXPZhw8GA0EC9qYohI
MFZTW9RYo7ShUqjSbqlSrYgHDiSYGAlq1KCeNAGKLa0QEwSr8SPxQhMjVom/
f+Ywyf95Zp6Zeeaz4/GeB5+uMbO90CroYNmss9ns84hZIc85bbYFga9jZn8V
zboKZr3InUuYZZDdAH8c2S+gEvIz0Mt1ZkfQkaqYRTlfirlMDHyEu0TSLBs1
a8uYDbWbvRk3+wMbr4ILATKNZjfgL2NrDBs7cGwt+qrgLdg72WS2BP86/BP4
9CL6X+GuA149Ni5znkJHCV0NofMOYD8OTpbM7gQP42MKPF523U+grx9/RjP+
t7NQGp7h7z74A8ifR/cxdHyA/h9rzd4DP9dlFkkRF/wfwX6Su/3Ye4v3zeB/
8WFdretYga4m7u7mPMY5XnGd0n2Ic5TzJvgnV5o9D20Ef9hq1oMb3/GfXeia
47+/4f9O7M2C6yuuSzFX7J8MXPYCtBO8krsF/B3mzSpwiruPiH8z/g2iP5d2
3gwUwh9Nu+5vsP8T59uJ8RvYv4LPG8DToWPF4F1wDTJDvJ3nvAJ8B3fbaj1H
m8EtFa+F+7hbzfnenFk3uMCbe8BzUB58HgryrkO6JvC/JfCYKrZD3J3mv1n4
HyO7Hf8/RV8V/gvwz+DvIrzfuZuknh7lvJtcLqJ/K/JfkV8jV8uB8x6B/gHX
cddHPM7C/5L/tQZuWzFSrCLw74+4TBR8nHw8ZK7zmbznWLnOQgfAM9gbqPGa
UG2oplRbcd6PE4uWstv+FvlW8M95911vJvnLHDpeSngPqhcv8GZbwv84A94b
eu6q+NiD/EjZc70bHfvBI6H7cgp7vfBXB94LZ/C3DZzCnwT+HEN/AX3Vivs2
T06qoZNwgI4JxRKqgBe4OwxuoGcWY16DqsW+tMue4O6HoudEuZHPn4QeU8V2
H/XQiewefLjW6DWl2lLPq/eVs8F272n1tnr+sSz1WfZe3MH/smWfCZoNu6D1
4KvQr+CHkd+O/HLRa0U9foVc/JL3Wh7GxjT2Z/HpZo3H+KLqM3TdT0Gt4Hrl
LOk5V+738H5rnd/FOHeGHutnoTXgPD69Vuc9+zqx7cs47zj6/4bfm3HdmglL
oedMuZuiPsbQ907Ze/0qd9PgvsCxYtQPbsP+ZxHvYfVyd8H//ifnbvVb2mfZ
UeRD5GdzPqvVUxfB15CZrPOcxcnd0dBnl2bwFLmfgBqSXhOqDeVYudbdYXjX
1xCrRp+pmq1RzeuI3y3BS4SeW800zTbVmGpNM7wIvq3gudHO0O6Qz/JdMbsM
vhF6rJQT5SZW8Vl4F/pu4VzM+y7SDtEuGe/y2GlnHALfDLy3NWP/C7wGVYuq
2f6094B6QTHM8z6G/x1x/4P+civ8wSbfIdolxYr3xgPoWxu6D/JFMo2h7xDt
krfRuQn7G7scq0ZUK9qB2oVF6PuczzTNNs3ITNpnrGatZmA27TlT7uTTZvUr
9t9v9hmqWdoe+uwcwL8O8KWc69YMPAdeyPksVY6V6/mc17p2tnZ3KfS3o/JJ
OO9YO0W7JVX2WaSZdpD8rwv97+qp9aHvaO1q+VTCt/8BH6EcEQ==
         "]]}]}, 
     {RGBColor[0.2070625, 0.36281250000000004`, 0.5953125], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnl0VVWWxm8SkhACvJf3wgsJJAQh971YraJiQ5cTYtlq21W9Sl1q/+XQ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         "]], 
        PolygonBox[CompressedData["
1:eJwtl3lwlVcZxk8gZIXcLOSGe8kGJN+9oVLCVup0HCBTB8cujssg/3RosZUS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         "]]}]}, 
     {RGBColor[0.2464375, 0.3846875, 0.6321875], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgmQldWVx78GmqZpoF9vj35NP7rT0N97D1EUR3SSSQRipqxMxJISJ0aW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         "]], PolygonBox[CompressedData["
1:eJwlmHlw1dUVxy8JIYQALwnkkRfySADzy+9ZNhGR6qgI2DJ1CiMzzpSWzUCV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         "]]}]}, 
     {RGBColor[0.288671875, 0.40515625, 0.649375], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmU1NWVxv/s9E53001X09VVFNVV1VGjYkTBDYTgyOZEMwbQQGhAnHEl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         "]], PolygonBox[CompressedData["
1:eJwtmHl0lNUZxm8wYUmAGCTLhCQzTDKZDwEXUFxQNtFW1rpVqRQkgNCjoLS2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         "]]}]}, 
     {RGBColor[0.337578125, 0.42234375, 0.620625], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgl0ldW1x79ABpKQAAm5yb3JTS43Nzc3DvgqtOJUFO2rDF0CxVlwYLJ9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         "]], PolygonBox[CompressedData["
1:eJwtmHu4zWUWx1/OOTg3l2I7+9z2ts/e5+wzTTWDniIlmqZQT0hqKCUcTc8T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         "]]}]}, 
     {RGBColor[0.386484375, 0.43953125000000004`, 0.591875], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgeUldXVhj+YCjPMDFMuc6fdz8udmXvRgFhiVIrR3w4WolEBs36RouAf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         "]], PolygonBox[CompressedData["
1:eJwtmXec1OURxt/jbq9zfZfbu9u7Zdm727OAYI0BNBpFAgaCEKWYRIRDlCgq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         "]]}]}, 
     {RGBColor[0.43539062500000003`, 0.45671875, 0.563125], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmnmYlMW1xj9ghmX2hVl6ema66emZ7lGixAVcQL1XQXBDjYkKuMVsiqBs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         "]], PolygonBox[CompressedData["
1:eJwtmXd41EUaxwfSE9LQNJLNLsuG3QBiFzmaz3kgxV4piu08xYYoKE3PhooC
KihiBSkCNqScFUVFQQERVKIJIEUJYMF7pKknd/f58s0f8+w7v3nnbTPztm19
xdBzb2weQljWLIR0fj+MhtCQG8LFjF3VIbxUGsLwvBBuYVwRC2Ee85uBrysK
YUVbRjKEc4rBY/Oy8hAKKkLYCjw6P4TdbUJIlbAOrX5ZISwAPsjYC58TCkP4
siaETPDrwB8B/nbwT4HGshYhvMW4Ph5CYYVprYXGIsnGnu6FluFy5BmIDJuZ
j0f+M5HtavbvaGH5dyL/Lezfzf5u4MfB/4T97cDfzvpq6L3bGlzwOyLf+a1C
qK0NYVJGCJ3AaQe8BJzPwb2yIIRvEyHMZr6MeRd0mIouraD/K/JvhMcZrO+C
xnRo7QbnAOuzSz1/CP7D4T+H+fPMn8hBlkgInZF/IbyGIP9fWHuNMZ/1JeC/
AH43aI6H12rodweuhd8TwL9Avw5Zrqww73mcQSoVwiz2P8f+G6H/LPTPwgZZ
4A5Gx/fRdSH4MXTJbhnCRPAfQd6LwP8v6w3Yezc898D7VMZAaO1i/nqav/0A
/FIVNsuGLjLNRr8vkWGKdGf9RNYXQT8O/daMScjbsZIzxp7TwClgfjfza4LP
czF7f+bMB2K/euZ7gD+CxmeyFfdrFbbppDPAPoOgcRLwCskTjLMS+CbuXy66
H8+3KchTiXyIcNgGVcCb4Lk+E9ti343AzdFxAxe+FH5pwKVlIbREnx8Y34M/
hPuzE1tsYcxjfTz2yU7znVrA/F/IPyUYZyHz1jD7Hfl3od8A6PdEhgWsj4X+
Hdy1F7H/nizLV8jaFmTejuz3od8U2auJ3jDws7HHN8iwFVlG820x+PXQvBRb
Pgn99vD6BXqX6+yZ92ZtAvM2ueZxWaVtIF76NpG1F+OWX/q8BPzbkSEg1mH9
+wJsSfhun42NNgOPhP+WLOPcBrwemZph+8nwy2X9JEZf9H2feSfggax3yfb7
HwD8Kva6gf07uX9F8P8OnOuhXw9+P50/8mHiw3fybMnHHeyFLa6Ex3zgfnxr
nu43+R73NavCvkFvblbUd1h3eSo8V3F2T2LDDsE+6ingLAQfX2Ce4l3Dt7ug
/SM0LmZexpvIzfEZvY+96pnPy7HNz0Ww58GZyF05hv0zgbsi09AM+5huwKur
7Mtkg97gr2X/dPZfCP8hvJfTmXdgvpT1dOh3AL8qy2+4PfBMvvWF3j/BeQ3c
lYypwGex/zL2n8edr4PXUcxbIvu/S31fR6HzH+h+LPZdyP4Z7FnH3s8jhuUz
5DsOyGdKV/kYcOcgYyrf9zGC/faC/y741YwPWDsW+85ifSajDH17oOPd0P8O
GU4BbmR9FbgzsEcS214Kj52FllmyJ3l/9ZxfPTZrCzyc80vP8BneAjwDnGE5
9gHyBUneeCX3MQG/FHAH3vRZ0FvEenvgztBfwPx15D+E/LnYoH+Gv3XCNm9A
b1yObXpSK/s4+Tr5WPnaHozl4F7Gt8mspSHDOuA3pS+6/IP1F5D1ADjXQe9a
5hlFPkOd5Vzwf4ZWHPnnAOfB//IM0+wF/jRwrgH3r5zPRex9BRmGZ5pHOviN
jOJs+7QdwN9wHoc4u/Z8W47+S7DRafirRmR4Dvsfic0r5a+wR4nsH7MtJNOt
8DsSGiOgvx76JcAZ5b4LtzEOcB+6wv9e8B+Rfsj2fqQJRoePZMuI79o5zO8D
tzVnOiDDMScOnBG3vxC9zLh9jHyN/HUh8mRUm7fetN72enDGpluneuAupY5d
8tFdkPeuUuumN72AeYo9m9k/i/vTvsZvRG/lAkY3dL2C+Wzwf2L/VeBfhEwt
kO8X5v2BSxTTgV+B/35oDUz57PLBGQD8I3e6XYZxDkL/GvxLBnA6Yz7z+5Fx
DbKez/3fiC6vod+9yDKO0Yz1DPZPSPebOQjubGRajGwrkL+Is8oB5yFwl3AG
45BlFuvnpBlnDvAJMcc+vQm9jSHosLfQd+wq5kdE/BbFYyJnd3Vb6yadr2T9
FvY/yP6pyHchslzW1m9vMuv9WT8NGfYgy0x49krax8rXKqcZyPkM5Q31ybcP
7lFmnyPfs5IzTQN+DflzCh1zvoXX/oh10RvfB1wFzXU6K+g3st7AfDD380xw
HsAe6XpT7D+bM7wX/ALmRc38Zhuh3RL8leyfqxjJ/jcZy8ULm3XmLHYi480F
tqFsmSx1LC4Gpwxdb+JbQ4FzzuXo9hD7n8nz+18Kbkf5VPAr+ZYCf3+1c7uN
7BlW4xijWLOU8TFnOwyZ9+Avu4JzM/CcVvY38oHt21gmyfYt60uBjwZnagu/
+QPwaldhX/UM+C2RvV3cvkA4xwB3hMa7wf7raPkyfNZe1n+GZhXwx+iQl2Yd
JqDLN9DokukY3gD8Mt/eyvN9Xgi/N5iPSbPN3gKei05p2La57hDwY3ybleec
UbnjIOh3zbYMA5F/bVvHCt2hz4HHsL4imMY89h8p/5bnMyrmrAbxZuqKHTMf
Vq7Gtw2svYGNWyed8yn3k//I5P7UwX8z82XMl7M2CpzCYttEtlkAjXUZzvke
Rr87mD/M/DTO41rm53Hnt2c7xirWDkDmT4N9lnzX9eBUKRZD81Rku7PC8EHs
e13COZlyM/nUEu73U9C4Nsc+Rb6liG+ZrNUx1oC7GJ0L0H0ANOfB6yvs8WOu
c1TlqlG+XRK8Z021fZx83VOMDvC+BBvemWEfPxj4EDT/k+0cWblys5jv4irw
zwP//lb2rcrJlJvt0RtM95nfwd4z0f/sdMv/hXKrlG19Jvn3VuDsuH2vYnwW
8MPQSOQ6Jis211U6V1HOUq73x0gHfhue73Eej0A/L8c+ZhqyfBB1Lq03pbc1
JeLcSjWKapWVfKstdA2kWqi61rXTBOSJAp+YcG73OGfQV2eZci6vNzgJuGvC
tchnjAtYH4p8ByQL+h1V7pgkfZSTpzO/Ne5aTm9yBPC0pHNR5bxPAL+EPScX
Nb0J4I1x1yKKMYdjTSvnW6v5No7518jQE1lbYt864C+irrWUoypXPYY32T7f
b15vfyk4x4K/gFHC/DbVAOiTznhQ/qLaubBsPgn47ajPazvjHeBJ5fbdit+l
2HIDMr5X5DfxtXw3Mq1t4T3fsn8C9KMFzvGU690Xt+z9WL8r7hpatfQIxsuc
X7Hy1zznfMr9VkTtm+RD5EterHEsE0/xfrSpXtOdHIFs3/OtMc82lC2/jro2
/DMoyQ/h7zHzUs2s2lkxTbFNe75j7VAb18JPI9+fwH3LLWtv5L8XeXOjPgvx
zAP+bxvnjn/wLY799iLPWUegP2M892dDjWtn1fi/qRbCBtFsx5hKeKdqXfs3
h34SeHLc/lw1yqPAqRrnmqrZVLv1AacMeCHn1xd4Ne9rGvSSyNMH3vkJ1wLK
OVPIcztvbEa2a5hG9M9En/nZ9u+DkWUH6+OQrQ56V0Dvnkr3K/qj04PKjbkv
x7X0ndHdkc/R29UZj0e+nKhrNd1f1YKKuYq9ZezvwP4G1ROZ9onyjZuqnXuo
5p1Y6ZpbtbdyEOUiFzMvyLBPvgS4Fv2fZ20V+EOw34FKwxHoHx+xzJJdNWsj
uoxmz/5i5+iHlP+VG1c5vnL9jSm/lT7s2QQ8JmLfLJ/4e4lzUt3t25n3Yn47
+s0D7sm3fZU+U52tfOqv2PtB5NtT4Bpctfjx8PsQ3CXK5xOuMVRrPMA4Gfjc
Ct8lxYAurLeNOXdWTabarG2tY518bg1wETxeRNZ96DQKeV+usm+Rjwll7gGp
d6CejHoz36dce5zLnh3qf5T7LutM2qHrEQnn1jMUr5FlKf5pUJO/VW11NOtv
s7aU0Yv1CVW+L6qnD6rWqXBtLJlO1X2JOPdUz0q9K/UI5M92Ma4td06i3ER3
7MQS3wndDcXsU5D/14hzFfUM1DsYH/HdC6znljmGKZbJ58n3rU75rXSH/5qU
fazscZD1mzifz6qd66gfE4PfESXuTd1Nnf9qrYdg1YyqHb9KObeUD90AfEaZ
z1ox9UlkubPSsuhMdbZljDbptv/xcfMUb/WAOrB2It86ZxmnvNw1nXKjvpzf
G7z3o8HfkOX6TL2xT2vsO9QzVO/w9aRxFZNmsr8+ad97Kd82AXeO+i4pBioW
RqO+q/LJyt2Vs+lt68x0du822eMV9fSg90qVbSOZXwVuVmZYNtTd2h/3fVW8
2KdeSZlj1Tvsv5F5bcq9tQZ0eoy78jdkerqZc/KewGfAI17sGkO1hnowe5rk
ke8paMov1PPowNpxCd81+Rz1SlWjKdfaypvYyHsYG3UtoBxOuZxyMK33ZH1Q
qWti5cbyqfKtp2PPp/Pd8+pX45xdubtkeijpHFr4qplVOxclnOsox1WuuyPp
XFc0ill7Bxk+ynNOqty0NuG3rRpLtdbcmHuTqoFUC93DfduW5xpDtcbKpOsT
1SSfAD+nfLS5cTbH3JNQrqKcpQJ5fo64Nv+NPTHkOYU9u4vcc+yRdI6lXEs9
5Lpq9wz1/mU/+e5t0Pw+z3dMd+2YhHM/veljgbfGXDsJZ7vyccZ09cOYNwDX
xwyrZlTtODLh2KkcYRTwppjPRnu0d1DCvSTVNKptnq90r04xX7G/eY1rS8WA
3uB3LfddUg50Xdw+TG/pSeadmD9Q49pBPnV8jWtc1QbK2ZW7d4+5Vh7GeW5D
95yEe3GKgYqFyZhz6Z/4Npi1ioR7OWl6j8CXJLwmny7fXpqwL1zPevMK1yDi
N5IzmMtZ/K/K8UAx/1Zkb0g5duzjztcD38D+uXnO2ZW7d0t6TWfWHbh3K8dm
9XymQ29owrm8aoIbE/bp8u2KWYpdE0vce58OzzEQ3Z5ybqyYvy3lnrzWFdMV
29skXWuqZkkA39yUv8mn/4Q9ToDHsnznY8q9paN0VU9hLPKMTjj3U46uXD2V
dO2rHlYt8Naoa13F5C3AvWude6jmrUCW36OuXcWjD7R3phx71FNpBD457rOV
P5yv3k21z0I63Ao8L2JbK2dS7jQwbl8lnyPfU1ru2ko+tWPc/7HovxbZfC5n
NbbKttJ/APovQD0V9VaUMyShNyPh3uVxjBV6OynHDvmsT1PuOav3rJryceA2
Mf83op7n+dC/J+m7qhrpbvWqap07qwe1tZVrAtUG+o9muPwd/D8psM+V7z09
4V6vembqnclnynfOVX8euEA5R4H1exa4T8K9bPX41OuTD5AvUM/1iYhrHNU6
8klvs16CDk8X+z+MieztFHPvVP/ZnBSzzWV78RikWJx0LFFPQ72N6ezZme8a
9LmEa1rVturZ9oPfrIRtpxxQueC2pHuJqvErKyyzZFcNPJK1sex/NdM9Z/We
eyRcG0lGyToi5v9+5APlCxtK3JtRz1C9w+4p/3cgmfqzd0fE/3WIZiPwmrb+
L0Q1wmr102KOBXrzevuJpnirmueFcv8no3inM7kceRbFnZsov9Z/GfIh8iXq
6Wxk/f+TjxNq
         "]], 
        PolygonBox[{{6287, 2314, 7447, 7105, 7106}, {7106, 7105, 7450, 2315, 
         6288}, {6261, 2299, 7422, 7091, 7092}, {7092, 7091, 7944, 2673, 
         7943}}]}]}, 
     {RGBColor[0.484296875, 0.47390625000000003`, 0.534375], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3eYldW1xj8cygzDDAfmzJzpc2bmzCmIWMBCsOWigBoVRWMBEYgVo2DH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         "]], 
        PolygonBox[CompressedData["
1:eJwtmXl81dXRxn+QAAlZSALJDVlu7k3uzb1XwGpF2Ze+KKsFFBVlx6ooVFBx
RauIraiIgAVZRJG3Kr5KK9r39RUQlE12lF0BWxEIaysqyOJCv49P/vh9Muee
c2bmzJkz88wkevOYa0fXDYLgVJ0gSOfvyuoguCUvCC5pEgQ7Y0HwWSIIBuYH
QU5WEByuCoJdlUHwY3YQVGUEQTIUBNckg2AD8zPqBUFf6Kf47RBrT8KjK3t3
sP7hdO/ZDd09FQSL6wfBuwVB0BP6IGtGsf8n1nwFPYA1PzcIgl8zvrg4CD5v
GgQVrO8GzyXosyIaBEPhVY89J5H1egU6NwyCqcy/Bn0iEgTfQDeGx3HO8Awy
+jVGD9YMh74dnqPgXYr+i5C1GJ1T6PIGv70P/Tz757P/GvR/D1us4rc2zD+H
fVZCL+S3LsxdyfdX6KvD2A3ebdBpLfpk8X2LQdvA7/HSIFhdFgSZyOrKuAuy
93PGW9H9Xvg9Xx4EechLIe9RxlcWBUE1498wnsa4P+NlyBiKrGrOsp3zjy1h
HWfrjsyNyE6y/krWT2f9QNb/Ax2LsVcfdP4S+p9J02+y5xv2fsW4b4HXaG1/
bFaOfcr4/oB9Ith3W1oQNOU8ldB1+QLoBzhDB86ygz1d2X8/4/aMN6Pf/eg3
jT0F6LKX+V7Mf5QZBJ9yd69x3nb59gH5Qg/OUIm+wxh3h55YYjqN/U9C72F/
T/Y3Qb/PoA+X+a4Gs2Yg9lsMv17wm8s4hT/uZk031jdm/Xbod5HRj7P+nvmR
xeYhXtJpH/QwzvhAYJ+Qb5zmjpaz9iLk9+bubuEMXaDnc4cLsWcJ5/+EcSE2
KIPuAY+PkX8GHhM4XwoeM+D9XQ72Y3yc/e+n2Qf/FbFO0k022wldDo9PmQ/B
rwL6AL+Fme/H/CHog0nTUznDOOTviGO7+pZxEbL+jI5fw/s4Nu+ELT7C/jdD
N8M/dmDPWcx/DP8s+B9kbzhqWXewZj78usN/JfpP4712kzxs9CHn74aN++KP
U9h/DP5H+WrQv0PKb/tV5HeEXseebPTpzHgT9IQS300dZD4OXRq1rW5H3ivI
25j02jH4QzX2ORqxr/4L/segx/PbVPifxX5dWDuaO+0O3YtvNbrVgd9HafbB
NOjelY4NbzHuD/0I/rugoX1Yvjwbnm8oFsBzCryXl/hudcYPodtjrw652AR7
zeY8zZGXQlZLzt8q5Demtxbne5n5Tay/j7O8jz9sgL4Tm+7KtQ9dXEh8QMe/
wrsD+9tgvxsqrZti2KP41lD0uQt9fgePudjjEnSaj7wz6PwP9J0acWyZpzcP
PQgb7M73Gq19DHlHkDcZGbPQvx9vPpO9JzlTM/i/zW+VadZhEfQdxfZ9xed3
0CXG+V6Sf8PvV9CtOcMA3ScyKpGVg03XsD8TnRtB50ZND0PfOeg7C52aYNtM
vvsUuyscS/vAcxryO8FjKbymcL/3oe/XrP82y29AbyHFmn9DT0d+Vsxv9pe3
y7gFdII9M3I8n838UPR7op55dob3Ln67nLtoyTcf+Y/wlTb2nb+BbX4b8v3q
DZ9CVhn8noLXRL7z8L+r1p+uhd863stgdBqDfsM534uc72r4xzSG/0J4f86a
Qazdic1/D//DrD/B/FzFJ2RNK3EsU0x7lbVrE+bdrBH+he3/wv1cyvyb2PB6
7P8GMubVdUwZDq8a9Pki3TlVufW6Sq/tiL+Mgveb2Hd6ln1mGOvnoMP36LIG
f7ux0G9cb/0ivnnou4fzRniPYcZzGG9h/23wboE+G9lbD3u2ZX8+87OYv4ev
Lvb7Dp/7E7r9Dhkd0/xm5kC/Vuz7uRV9mqHrNvgdwdbfIv97yWd8jPFpxucY
L6+2LXfCIx/fOQzP5+A1me9B+H3C+hHoczH6bEKfA5y5a5ZzvnK/crZyt+5k
iOKBYjD0Jr6VEWMQYZFf8b2C7nfGHCvkk/LNEbX5XDH/bWzZBn3ebWQfl6+v
4rsN/XYpp6FfATIPw7uM8+dDP6KcCX2BGHU3/FfLn9Od89dAH4k4VinmKvaO
5456I6s/NviSuy5LOFbeDo9S6EasOcV9r+dOn0Cfq4pNr+Ubz3hS3O9R9n0W
uifzG2rnH9d7RYcLudahCro3OvwQGGP1gd6BPi9zlnqsz+I8/RjfnmUffR7Z
RejXsL7vWHcdjTqXj8QG/11kH5GvdEfGzdhmAzw7FTimK7Zfgz/NybdOf0Sf
8aXGMsI0DeG/hj0j8vwm9TYfKjG20fyD0BdXOdYoHh5g7zfsGZZtzCbs9iX6
HsgyRhRWHBZ3PJf/D4d+q8i5Vz4p3xzAd2eWfVq+PYjx6Cz7lHyrATzT4P0g
8jqCFQoYb2JvLr81Ec2aA9zVJHSq5Gy/LXbs2sz8JO5rGOc52MgxR7HnFnTq
nmadVyqX8W1mnMc4BL0AHUfWdwxSLFoVsa8KwwnLXQ/Ps9jnPN9meEWTjrVP
Eh+HIr8oal7yyXmctXHUut7K+GXG7yWNBYVJ/x96SsS5QZj06pAxmrDaEmx0
A2eLMd9ZuZTz3Qv/NYwno+8WflsLfZUwR+Cc3xV6TJXzhWKiYuNgeLZivJ37
XATvj7DPwlo8cBkb9yZsK8XEfaJr7bkRnme4353Yo3UjYxRhlSnFzlXKp8Xs
b8e4Q7ox653400zkrUbeRazP5uw9k8YiwlS9oNvXrlf+HF3pN6m3WcOafPyr
E2fqz9ly8d8XOO/ApHO9cuZg6PrwXJlmn8iA7s6eNXWdL3tAZ1Y4NyqGN4Du
kXItsoL72drUGElYqaveIP49kD2XocvDyulRx1DF0hz038T69thkK7yPsacj
dIeE6efZ8yS8MmOWrRjaEDrJ/N48YyxhLb1Jvc0eyFvGfH7EWHosv63HH5+J
+y6HI+/puDGEsIQw34fMnyv1felOdDeDY86FqgmGQLeE39w6jtmXQxdyJ5mc
tQgZv0Z+Cp7/w9xe+Cc4axf0287c1/C/CvoEZ23CWb4QxmRcFDLWE+Z7EdmD
ilybKaan4F8SMpYXpn+V+WmMt+W5ZlLt9AjjJ9L8Wxh+c8otWzl8NnSE35ZD
72Y+Bl2VMH0E/pPYu483fjDDMpqGXOOp1jvBmt8kXBOqNlQOeijiN6W3pZp2
BfIbkLNCDVwzzoTexPpzeX6zertxvhVpvqMU9JUJ2+Il9tSUGNMK2yoGrobf
D4WuBU7Ab3fcOVyxbCH+ciP+Oxp9/4y+O/itOfYYW2Vsqzco7BbBZ08y3x8f
HoI/nWNPXo7fUJT7XMUdxlXPCQNAH8JG73B/E/mGNfWb0NvQbzXMdUbeOPgd
Rr+2eq9J+2p79m+BXs95p9fq0wJ91oWsXzXjbvB6KuFcNIozTUw4piq2HlTM
T7jmU+2nmHljke9Ed6OceijiGlG14gHWX8b6JtinKbzXYp/50E9Wmr9y5J+g
V8d8tv6sfw5+00stex02aKP3FzNWUU08KOY3obchTL4RulORa2lhuK6M2xQ5
F6vGbMX4Wmy0Psf82rL/zULHolJ8ZAL6bWHNA3muYVXLjo04tuq3TxiPKTWe
a4f+S8n3hUXGDvXhf4b7vqnSd60cptrkAuf/McPv6xJs04941i/dOrRDfjr7
09l/Tm+O/acr3FsRRhtFbNlV5HilOxoDr5GM367jmHc/+jyL/i3Q/yXmH2B+
dNS9h83sOcTahozTsx0DFQt3CT+qdyIMjj5vldk/dabm6PYQ45czvL+G/T9w
/h9Y/wHrz0SM6YTtVFPOZv8r5fYd6TgP+jTfh5nGHMIeH8QcO9WzWRzznepu
VRP8G37FwmDoNwV+yxjXY1wn2zWear2A72fWLmP8I/MTQ8beO3nn72CfuxKO
xwXon47+eVHXun1Vs0dco6hWEeZeUGQf0t3rDmZwl7MTxorCjLexvzf6t8h0
zFQvoE2Fc5cwcGvon6uMHRRjV7B+DPzO5bhmHQV9N/abkeEaR7XOhrBzl3LY
eugpKWOtaexpwPolYfuS7K9aISPmuQB+9aCnovNNeb6D8xHXTKqNMEOQgP++
sPtJwjB7oT8rMx7V+a5FvxzWv5BjfTaw6Xt47IC+EZ5LhNWrjR2Vg19QPYO8
AXm2+QXWzip372k/73sIa6+KOTbthGc3vUfV2A1db36FPl1jnlNNPTrlHpN6
TbvgGVVuLDTWVc/mfcZt4TkL3/g/+LerdkxVbBUGXZ90z0O9jz3qealWKHFs
ko3vKnPNrto9Dx5beNvtisxrDPOXM/+/vMGj2a6Bz2CfJei7E32vV70ddk5W
blaP6fOka1zVuuqxfYA+EwotTzFRsfvxWvzbhf2r2X806VytmusI9Cz2D84z
Rr0pYkwjbKPflsJvNvND8oxZBzI/k/GgPL/RTNZOZzwwz28gnfGUIt/VadZ/
F3EPUr1IYXxhfWE0YbXWur+Ie5DqRapm6h3xnehulF86c7+Dq32XwojCin2Y
P8z5KjlPGmetKHQvUTFRsVE1jWqbIs7/l1K/Ob091RyqPZoVel4+9/dCxxzF
DsWQcdirE99D0DXo1Jr7W4R/dMr1GXXWZ+HfON1veHLYPWThMd3Z35UPEu7F
/lLzQlcm7EvCBMIGyonKjeqJjI87put9q2ZR7VKKvs8UuAegXsAx4ZV0n3kJ
9n0qbiylNWWq9yLu7QgzCzsnEvY9YQBhgcfg8X2O3/xoZH0QNS/xPAHvs4wf
zPZ5hBV1J7obxdzT0Cf5FjM+xfhb6HYJ52b1ANULHFHo2l4132vqN+BT1xW4
J6jeYCv29M4yhhsmrJVwb10YTVhta9JvQTbepnq1iWOFetKt467BVIvpzQ4o
9JvQ29jH+nvi7lmqdykZVyDrUcanGZ/iu4PzPlzuWl+/jWT8drmxl/xjUbl7
UMK3yge70e+/EsZi6iGrlzy/1GvlM/KdS6ocD1QDv068WlDq/u4I4dNC5wTl
BmHEP3CQ9in3HlXDZJcYs+yofZ/CLi/ybUlzTulb7Zyl3HWe85yDnhFy7lMM
VCx8IuHcr/g8Cn/bWWHs9rrwMmt/Ys1PWcYswi6ygWwhH5Av9Krt94f4xkKf
jViWMKWwpXKWcpd4/Ay9P+LeiWrer9RLiNr/x6Hvj9Dr4+4dNefboH5NsXOb
fOw8899E7DvC4MLi94YtWz0z9c7eqjC2Us9IvaMrEsZqqllVu37Jb2cbGnP8
sdw9MfXG9D+IUvZ3TriXrBpGtUyfsHOHYmBf6NFh6yMfPxd1TNB9CoNfh64z
I7adMLSwdJuE37565uqdZ9fmL+WkJPL6hFxbVpBzW6JPx4ixkDBOB+jmCdca
6kmqN9kyYSypml61vXqm6p3qTP+E3lrtXpN6JJ9Cb477f0nK6VuEz9BxR7bj
/xdh96hVv+i3Gdx/vKlzr3qq9dF1adT4Su/7OLpeUei3IsywWLUD8e2GDNe8
ZxlvYE+/XMd0xfb16nHW928bodfyXZPrnK7cvkn9O+avFx6HvidsWe8x7hl3
j0C9AsWAmqR7quqtCmOdKjfmF/Z/hfkreBs/Re1L8qkh3M2FqGtVjeVrqmlV
2+p/Pvvhd7aJZemMwpLKmcqd6pm1Rb+82v7VBn5brv/vxKyrcphy2Sp++yTD
GGQy8ibw1c3wb5pTD1W9VPXUerH3U37bU7s+P+SaUbXjceUI5g6VmVYMUCxQ
zajaUTXR18z9LebaRRhFWOVIyNhX+vcrMaYT9tnPb3tY/3mZaeWnx5i/NGQs
LkyuIPKx+vv1fSfrFM8qnNvVk/0b9LIyn102UC9PPW5hLZ1ha5l7iOolKubM
Dfl/GvrfxnTsm1DuqbSvyceernQNIPm/1NyKpWHHOuHPw2H/j0z/K9P/sHZx
P3dXubei/sw90KcixgLKIcoll1Y5nit+LsC3j4YtT/+T0P8mLi/32xJeVW9A
PWz1soWBlnK+5ug4E1mPYYNDzN2QcK9KPaBB6JpM+SzjmN/GfCrmWkcYKAmd
yx30xVduRoc49qjW/6QK3BN7nfXLosYDipHLo16jtfqfb9MS92zUu5EOzVLG
7MLu6rndGvL/YIS/VQOfxX5Pl7u3KB97ptw6S3fpUKPaptTxRD2MO/DnSWFj
G8Usxa7Dhe49qyZWbawemXpl0jmO/FYpvyVhUmHTM3oTjfzG9dYVkxWb1V9R
L7Gm0L11YRxhHdlIttKe7dD/AeBIkgM=
         "]], PolygonBox[CompressedData["
1:eJwtkEsvQ2EQht9IJG2VxKXtF5ce5yRig1CXTdMFG9bWbLBViYVgY6uS2gkb
Nm4/QoKNVvBD6jcg8UzmLJ7Md+ab75k5E2/trde7JBWhG75L0k1GOhqVlkek
FZhLpMu8NE/c5bsO79CG8yBls1JhTBqCDOdm8DuriXkzDqXgjgrnRlk6hSK5
C3LT5M6obcAzfT/oX+NuZ1jahkXur6hbIC6l5xDca/4HXLM56T71mt/mtvkP
8V3j6/BfrwXpBe4mpWq/dEtc5bvTJ51MSC3ObajBPr6eyOvt3SauDXhMe/WS
m0p8/pnE57R5W9S8QS5yRz7yfdnennhbJRfSPtZvMN3ZAFHwy6wHwR3m+oml
Y3r8xd7f5vjEs4bnq+w7s939A0lTPZo=
         "]]}]}, 
     {RGBColor[0.533203125, 0.49109375, 0.505625], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXeYlNUVxj9YYTt1Z7/Z2WF3ZrYMK2CLjaoxAmoMoqCRaiPFKCgSDZoo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         "]], PolygonBox[CompressedData["
1:eJwtmHeY1dURhg+7AtsoArv3sv1u4e5SRAkiPRaKonRQQMCaRFFAQA02iooY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         "]], 
        PolygonBox[{{7082, 7081, 7914, 2654, 7915}, {7400, 2284, 6235, 7081, 
         7082}, {7141, 7140, 6339, 2337, 7480}, {7479, 2336, 6338, 7140, 
         7141}, {7455, 2318, 7454, 6809, 6810}, {6810, 6809, 7451, 2316, 
         7452}}]}]}, 
     {RGBColor[0.5821093749999999, 0.50828125, 0.47687500000000005`], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmAuQlWUZx19g211pQdjbOXv27Fn2sKdl0cQKATOIEUFsuO1yMRW0SXGU
i5SKZgSpmFLGri55Q8zG0ombTpmAYMkd1moygXGaIKy4R94WDHcX6Pfn/zLO
7DfPc97veZ/77duab89pvKNrCOGuLiF0A+5Ph3CoMIR/APtUh/DzvBB+nQzh
D31DWNo9hKmcnaoMYRPnBznvnQthfn4IpytCuLkOBr1DuAV4grPmniFcCPOR
qRCOwXxrIoQvcnYRz6nPIQ9+fynwu07on9A76LfCvwn+j8O/swe8eU7BemK9
3z9aHsKG4hDWF/v3KM5fBi9Fzupi4+I/tyiEL8O/N7xGlvqdzsfVW68fl/ts
Fc9W+LehwxrwzcCOfPPfGaHktcb3a3m25Bvqt3jdVWs9H67wHdm4qIvhxRGf
h68OgA8rwxZ8hPhwP/jLnHX0Qj5++CSDP9H3e9h+bZ3P38Zv3yzw3QV5pl/N
A2lYAVzJw985uCriei868RzK3R3gl3L3KxeEcA+/N4M/gD5HOR+NDtMKjDeL
BjiQJx87Xqw1/kfsWlZrW94EfybfdKIZXGxcNs6qAcfvtwAr4L+U95+PcVEM
VkWfjipxLJ7HiAHI7Ie9H3ezPZ8Gvxe9aG4otm16rxhcXWIegqN5HkNuO77v
6GGazhg/6ajc/EG+edaS18fR7Y480+tceVWbMt8scBB5PoB3lwEvgb64h3Nx
oGwstr2KqeRLt5qUc6EaeDpr+s6sc/9ElC/YFvV4kHc70eEq7B3Z3Xgb+fMI
Pj3D3bvx8TPQdMWOhSn7VXbIt09yvgf667n7eta2rAP2yllez5xrSPYvjY/u
NnN3V5Hviu+8pPNoD3c3Vrgmn0Pud2vtw4c4a4F2CDlRA12J/FHo3KhLOl5j
s7b7qhLXSxO5+jC+fI1cair1eXuw3waX2HePcd5c6tjq/chII/rFPCMiL0Hl
7b1J18JeZJWA9wGvBs/r4djIhvXIHUPP2QBsSblO/pU1n87YN1bxbgQ0q+sc
P+kinwwqtn7ncrjE+G7ouyCrF7yP11jnq2OOrYl1L96X06POoOOBhO9dFu++
EutOtXldoX8LP8cj2v4xfO/Gvx8BjxcYV49agP5j+f1u2nHriHE/wu80vGqQ
9dsy0+xKWx/llfrPsjLH615sfC/rXK9PuD4kW/k9pd59rLHeudgW839lpWP3
FPf+mbVv3+KsPOZTCriI31Oh2ZD2DNAsWAjslrTuP8HIX5a518xHh+0Z5/eu
jPOwM/8zm3ZGuzriuXr4Fdie4e5XgZfylIMPAPZVLeGfbNb2CVcezEhZ1nL0
+QA/3sn5+8B7+H0x5w28/wU634fOf087387n1zU50zxa5hzUO8U1Ge2V3Uuy
rpnmOvtpc/TVpjLn2Et1ni2Sq1xpKfPvOXWWLf7r0Gcb/hmjuqaffAGej0Of
A54sMK76UnxGlXw2azqiT9pi71B8z/cRxa2h3rNnLHBiznIl/8Fq9/aj4FVV
rtl38cERnleQswNdypKW+SviMqnK9BvRd5N0Jp9/j55DitzDtyB3LTYcgmYc
PIZXembN5OwwuXUW+jnw2Z+1T1R/B6EZhtzB8N6eMK/ZNc455d4kYFHCPa+V
uMyH/jR3CzjbUmhceTYh+uhsuWteMS9F9w+jPh+UuwepF9UnHcOm2EPUS4Sr
t5z/rXkoHzfHGSSoelRd35TzfEzgt4Wa3/SKMf3cy1QXA4DX55x/qrN/xx50
AHglsv+M3pvS7tfqr8fAb8vaRtk6PutcVc6u5v7tmjnAd8rt4+nY1FbjfeUE
sC7r/tsP2MCzHHwicHekvw3+r0E3mfPfAYfhw33w/w6xGEj8blV+IqspZ/wd
ZO3l+RNybwDORd/NBe5X4zLewWor3e+Uy12T3o2Udxfm3H/Vh+9LesZo1hQD
z2Q9G86q32Tdy05yb3mZY5gBruf8v+j5BjCHDNaPcBS/z0xb7p5y57HyeXy9
dzvlfgL+16LnCwXeZw7FfHuxxnmtGa3dVDNTfV7z4vbu7pOKmfqX+lhfamJ7
0vmvOvhPxjQrwPegwz7w3cBc1HlRzN/aC+yvCdxt5O5zle67om/Ic29Vj/2E
uw2RpgWa3fAfDT4P/38t7s/ao9+r8B7zPnl1KmNdP824BpQnPeE3FR2e5fxG
6EclzedJeB4od3wV583QLUbu9Dgj8uN8vznuXZPoP8O5/zx3F+c897TbaYdp
KbTPj+OrL8U9UHv8mbjP36/+Qf6MxZ9zgT9KOFeuSLuHqeerR1yZsI+GUONL
U+ZfDb4m7nLa6TSTlXuyv39f67M86X6k+A1F1qspx0XxWZYz/2nV9sHXC/1O
O4rm/Pehaa30DtICPiJhmsvhPazK8drJ+bZy53YBtPvRYwq8+pfZNtmob5dU
2rP5WwnPnDsLvf9r5uhc83pI2ucPJBx38VGMW5GRQ9ZwZM6MNdUl7T6zOu7b
k6u8Z08B/hC5K7i7ANg/6R18Hjq8VO7cPpZyPauu1Q/0jaTvoX7QtFZ4R3mT
nOlR7RrU98FbFd65N/bzPNDOq/22scpxnQiclXa8ZwPbM955f5ryfGmNM3hk
3EfUDwdV2Rb1iYuinjPQoQgefy10LlbHXXcCdbo97fNt2kMqXQs9q70HKWfU
W7T3a/bvBd6UcD0n0+7d6uGvk7PTqpxTmj8rks4T5YtySzmmeZKN+/nken9n
aha+nfJc13x/qtLfPeKvXvEq51vBByXdZ9Vvm6ApTtieHbwv4vwS4vICvrk1
1o5qKFvtWtE3qPq4+nmSe326W+decdfRztOYc5wUr23Q/CzuDM9mHZf2+D2i
edIed9HDpf7u/UbGPVo1MgR72+HzN96Pr/I3tPYH7Zfqbdo9lFfSVz1Ws1Df
QyviN1FDwj6ULwcmPUd/k3Y/Us6qh3Utsw2PIPdGfn8EzYfQXMPvLpyPzngn
0G5wXc6xVw4oZ2cnnT/rOFsZY6QeMz3nHW8H92ZVel6vBR9a5dpUjQ7ua/ww
75+O/pGfdsT9cEbWPU75pd6p+Oj/D5Pz3POkm3aO/5Uaagd5I+09QbuD9gPJ
rc969pybQTX2o/x5BLtnZexL7exLku4h6iXaXTRTRuds27nvwoxnjM4PJjwn
NC+0gy+J9bAPfGjc/8U7XeUeqF7YyO9CdG7IeM5p3vWXb7hzkrszkf9/YtmH
5Q==
         "]], PolygonBox[CompressedData["
1:eJwtl3mQ1nMcx78dbJlt1W6P5+nZZ5+n57f7eHYLpXNJmqFMTOduG8o1VIOK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         "]], 
        PolygonBox[{{6795, 6794, 7412, 2293, 7413}, {7488, 2341, 7487, 6833, 
         6834}, {8891, 3309, 8890, 6794, 6795}, {5894, 5893, 7346, 2244, 
         7347}, {5859, 5858, 8628, 3157, 8630}, {8786, 3241, 8785, 5893, 
         5894}, {6834, 6833, 9077, 3405, 9079}, {7269, 2189, 7268, 5858, 
         5859}}]}]}, 
     {RGBColor[0.6310156250000001, 0.52546875, 0.448125], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlnmwzWUYx1+XXMTl4txzOufcq/M7juPW9Id9C4UWLWStETKMcC3VjEFD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         "]], 
        PolygonBox[CompressedData["
1:eJwtlnlslGUQxl+gSqmlUmS7C91u833bZS2JiQeHICAKCngUC4hGixIIFMr1
DyKCJqjBI3hGFAIeiUYRgYRKhIoIIoIC0RhBTaDEg1MkeAJKOPw9PvvHlzyz
M++8M/PMzLvR+JkjZ7QNISzhK+J7vDqE1SUhbEVoALd2C+GZ9iHs7RDCJeDe
qRD6oTvLb2vTIZRkQyjvGEKyXQgdwNnKEL5C93wxPpIhfM2Z+ch7OH+uawi9
CucH81tjHEJfzlzN+RrOD8b+6YoQFqFr6RxCXW0IwzIhHEVXw2/Dwa2cuVAa
Qv/yEB7E10LsX0a3EftR2K/OO55mclkF7k4Os8jnLeThiRDOY3+QhDcS33vE
/xE2V2C/Gf0GcIoYuqA7wXcM/Uh87ro4hI/xPwb8CfojhXgmoO+BzznBZ34g
vkHct7DEOa0kvvEFWf7vw7YlCuEu4t9FDPXU5uas76/C503gJ/HRGXtgaIt9
f+rZyl2X8dupLnDBmdHITchnsB1R61ptI8bbwRsS1l9DfZaSzxfEsIZ630Z8
A6tCuJdvL75vRW4AT0M/HX0V8npqO7rWtVTOyn1qQS+fJ8l3uWpWbP7nEtvb
5FNX6pwOU5uQtu8+8H2Us5OQEf/viUbw/IRrd7oTfBHffuSZyDH2/YjnBuo1
v8T81aNrjlyP3dRrDfgOYvqQ+PZhX00tLsS2V/3Og9uknat6eCrnN1PIxo7u
563YD0vYt848mgvhnbx7Sf2xBV1T5PjUc1vIJ8NvX5a5X1eAP6fm1xX5t4mc
f5bv9zJzLO5vzJprcToY3CdhrlQ/cdOfHLMd3O9D8L+beFuL3UPvJzxzilUx
b+J8r6xzk7/e4G8S9q87n+PuMr4WuHoBuVPOM6pZXYzcVTL21yseYrgbeXTe
tVcPTyDX/dx/iPubsHkJPsdif6bMnIibGH+t+NvJHTXgE5G5ECe/RZ5pzfaL
nCnHfwwH+9BXq4fBNZXm/yLkOmp3sot7W+eHYj8t495Wjw/A9hTxnOJAOfHV
Up9x1e5fxfQa9hV8m4jlFeQU+NKcc9fO0O6oq7T/MfTjeuJblzZ34uxa+rEh
5dnWvL6O7QPoXy32PP7E+eMZ68THleR/S8a9qxyOEPvYKve2erye+HKx6/sU
93UH/8GdVyFPRf4TXFGoh/RJ8FDu38PZIr4nuD+Zcy7aYdpl32asEx957h9U
ZS5Ugx0pcybueuJvUuSdqV5STw3AtiFy7/ZCPwU8qsqxauZHgo+nPev3428s
/ranPHu6Yy389ki69uLgNLZzsp4n3b8T20NJ11Yzr9l/N3LtJK8AT458t/jU
7lrQzXd9z29LY8+sZvczOIzAi2Lrv0O/JPZOlD9xMpv7O+fcW+px9frB2Ptc
780B8OWxa6sa58HzKr2btKN6EO/i2L6V80p0v0buTdkfA4/PO3b1zDjw7Lz9
idNZee9U7VbtnHrw35G51Qz8Bd6WNlfibLsw97WUut+0K+YW4hmiHQWfmdiz
qDcoDV6W967Wjv0AeVvGtnojm8FvZhyveqqU8+uR+5Y4vmn4PpLyvhBH98Bv
Y+TeUI9E6GfkHa/OTweXJR2renAH8R4rvKfi/Ch4ctpvt3p+D/34Rsbx6s51
4GWxuRRn4q620C9t2E8/IrfLmhtxVARun/W+1ZtcDO6W827SDGuWz8a2l/4c
+KGUfSkmvfUDE97N8jcP+xVpv92qXxO98kvCvb0K/WPsiubCvKt+PVO2ke1y
/I3A34JKcyOOpqh/UtYpR+X6b8a9Ij7+Af9c2Heq4QHwodjxKL7D4AGF/az3
ZCD4zlr/V9DO1O58OOv51PvwCLhNwlyI03rymZj2rGhmP6WW/wGjDFQs
         "]], 
        PolygonBox[CompressedData["
1:eJwtkLtKQ0EURReCoJKAENCL8QZy02kriI+vsDeFIHlokipfEHtrxQ8QvyBB
RbRQtFTBH7AwCpYRYpM1TIrFHs4+c86eKR909tozwKLMysMK3MttBWp5uFMb
q3A6B3X1dQne5KgITVlL4FrvUi+/DDl59vxu7UVtZNDPeTeLXuhplaCwAMfq
ljO2ZSB9GVtr6v2rOylk8/Doji+9YTHuDhkOy7Dh3JpatW/Tvv00Zg9vOJGe
fJvh1yw/6rkZPrxzlkUv9PxZH+m3krh/MN0T9j1Zqzh3N40ZQ9ZP81/Y3/Xe
ldx4Xk/iX4Q/mQC7LDXQ
         "]]}]}, 
     {RGBColor[0.679921875, 0.5426562500000001, 0.419375], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lX1oVnUUx0/bbC/tsSY+uw97nj3ruZf5UBAo6Kxl0Vw1Ri9sCrVyrwqu
VbP+yIrIVjaDQssg+8NSKoJM0jTUMWnZ3AyyhsTorwiaMt2L1j+9ENHsc/je
/ricc889v+8553vO+d3cxqfWbSkwsyM8hTyfpcw+KDKrj8xOps32YBsJzS7x
LEqYDfB9JDB7vcSsK2P2F08t+s3YHq42W1lq1ob8KGn2AGeTyLmc2dPlZvPI
cXDfL+NsjdleMFuKzXZUmW3Omi0m7gI4E8TIg9MIzmCVfNz3ZFL5rEYeIO7v
2J8gxw3gLgd/Xd6srlz6aYqa4HsBsWYp7F0w3wb/JuJuLVPOjrW71qwXv0kw
n0Me5ts4fruIW8a5v4mTSwurlzh9cax25J9LqQ+MNem4Pnyu52wd2EFC8VrB
/3Kx2TU4XilRLZ3Y27CPYr/OawLrX2Kddw5j+0PIFcU665gew2M9llPNXvtB
cruC/iHfD1PfI2nlsB8u99WK527q/ZaDndg/h5+jfFuN/QzydJVq7oTn7TH/
3oc9YO1GnwCvJFItxcitxPsJ/3rs9ZyZIJ+fwV6Dfhe1zWJ/Jz5r+E9iK+Rp
5r2I9yQ4hZFycd39Xsb/WvRZ+nuE2tbD41Hkrdi/4ewJYp7NCCcBP0P4zePz
JN+7iHsLvI1Tx3BaPfV5nEmph4beWCN+3oKPVEKxvS9tVeJ3hlhfgTkH5gnk
zjL1z3fg7kB1eX1jgeYoIk5/UrUvAv9UqDnxeXmJ2lqI8R3xx2JuT2Hrxe9N
cDYjn6EHiQqzZ5GPgruKOb+EfwP6MvTv0dvR69A3VItH58l7sonzO8H5OtAs
+kxOVtLPhGbY6+yoVX+/yGrWvdbtPgu8Z9EHkNviPF+M1DOv8XZi3cn7Sux3
RMJz3XnwnkwXa0YbIvFzGzm8Wis+fb7WB+qF9+RifFdMh5oP56ojqdlZKNUc
94Xq6Q7i96IPEWNVSnvosUfg50beh7wXGdXjdd2H7968dtfvg+r4nnkhrR76
bHg/GrOKtRbZmlRfG+CjA8zfwLyc0c44Zz4j8xntpt83jV4j+a+NVKfXW47+
KZy3gH8AORNqbudC8ee98zovBOLJd3oYzMvcQ0XYSio0b75jF3PaU9/XqUrx
4rt1KCee709rt33HF/g+Guhee5zvFfH9tQT5T1Yz77O/hFp24VMdao6di1Hk
uZzuj6tgnKvUvdid09z4/PQRJxPqbDZU/P5y5el8e1+8Bu+D5+NcFwSyeX0D
8VxVEP8sz4Nw8nyk/4fPziFsF3LCPI+cyokH3z/vmeN9Ao6llKfnu5x+dRH7
MtjH41rey+su9t5GxG/G5xV8ltVox3zX/D7r4X0f9k3Ilir1wnvSmZR9I/Y8
egv6j+C/ltb91ET87oz4cZ68B87FID4H475PgdMT3//+z2li/o9xP/+xVHei
97E/Ky6ckx7il0a6d8qQ3dRw9QZyQN4TaW/vRU5z3sinibO/BPLpwWd/Wv+K
dvB++L93Gd2Dvju+Q/15zdYWZCG7t4B9G/4B394gz0rkx5wZxh6mNHdu9/ya
Q/XR++l98/+F7/Cv5NGNvgKejnP2DGePZfTPdp9BZGteezyQ1P3r58ao5T8/
MypI
         "]], PolygonBox[CompressedData["
1:eJwtlF9o1XUYxt+2xc4O5ygTz87h7Jwzz+80DwhBkm6QFM3ZRKLY5kUUc027
WCtndmF1E5FNoZBSqC7SxOrCLrISzGG0wqYR4i5EgkC80HDo/tSNdCOtPk/P
Lr7wfn/v+z7f532+z+9b3fXK4J6GiNjLamL9m49YSTDfHDFbjXizELGUiuhk
TbZH3Obb+mbXBLkTJb6Te4rt57mIbtZH4fp7lYjfWP3piG3UH6R/uBzxOv0X
2N+m/zp4K4jHMxF/EH9Tp4b8Yb59SP54xVwq7I9VzEHY+8Bs7YgY4/wZ8nca
I6bhPkG+kfxV1q/kVnW4Vpy+JzfEGQ9xVhfrPPU1Vprev6hfpP5kMWIUvO5s
xBO1iIuc2Z32fGVmm6o7fwI+X8HvNfbZVvNblUSMgP9zg8/YSXyq4Nou8HvA
W5c3f2nagBb7OyOONHnmd4iPgjeXMd9PiB/ocP8G+DxG//nEeXH+iXg9nEbg
10//WeJdzHAoZQ5X2iIW4P88+WEwjjP/FjC6wPqM/SL7PZyRavUd6C5eZAHz
P/8x4r6atVD9w8TNrHzW8/xO/03m+Qcutzj/FPWZmnOa6WNmH6PmbrM9sob9
ozXPIg2l9ZOJ9V2A7zbiIzn7S5zG4fZyxfhnVkRsRZ+pxNpIgx8Tc9B5h8AY
oHceDnsz9udBevs63SuMfs6bQM9j1M6AMU79WvZvp+23lcS1dnvpfTBH0XKi
4tmkz37i0+BvzxhP3Ho6fLbuSHeVZr5C1vPfg99S3r2a6UbVnMTtBzgNwO2+
nGPlNfuzeGJjS8SD4G+n92jR3hBmC9ib6V8if41vm+C61GZ9z8H3C/jmcvaq
NN0B/kLJ3pZfEvB2Fu1VeXYf+s6uxodp/0NrwJtjPU59nTNmuK+7bf7/pOkc
/Kdr5iYNLxAfKNp78uBixR6RV+SxXuKTJfMRxy+J38rZX5qhl/qR5ft4mvpL
nNfHt1jmU4XLgeX/+SKrm/xumr9O+w2ZI+4t2uvy/AvgX6ZmbYtn0Cz3l3zX
+taDto1wymWtqbRNCtZO/ORV/cPS5z3mzRPfrPptkgf+RIuZdntFnqnD/UzJ
3MRRb89G8CYz1v80s2wqm4s4PEJ8lvpfUvb7q5zflHesb5PkdtM/n7G/v0vs
IXlJ/1wK7oN1/5vScIB4vGIvaP/3at+x7loYk4k5i7s8+23VHhd/adAE3jBn
vpsyxg1qhwp+K3Sn8+S2Fvx2a75L7KPkt7sLPYeYZ0fOs+kOP8Vvg3n7Qx5+
rmxP6S51p7fg90Gn/aH//zDxLPgbWnyf00V7WlzEaSrvO1ZONc+U/caJ2yL5
OyVrKP2k+Sjzbi7bu9J8C/1v1OwtcRK3l6p+++UZeact8V3L4/L6f5BG+R4=

         "]], PolygonBox[CompressedData["
1:eJwtks8vXHEUxU9GRlDTIB1emDftkMn8Ay1WJENGupt0wVgYNd23GxISLV2O
sGJFJBUWSFiZNHYsajP+BYxFZ1R/WNnR9nPzfYuT89733Xu+5577EoUPb96H
JL0AYTDkS6lGKQ0fdUolMJqUTp9KOfhLXNoCX2PSWYPU70mzXdIcuOyWLsAt
qI9Ii57rN535HinL2SfY5/tKsxSDH9qlR/CL/p8gzfde6obhc97L4Dt1Yc5q
8CHvB+A3Ht42SX/gSbwU8ZKHr9CqgKmU9K+FGrgYlZZA2XMePqI98FwaBCP0
C50M7KMbBzlmf0kGVepDaNaBnYS0DQqBbqUDD5zfce+E5zyZtwXPea0GWVgm
pmnaJ/QsU1+IuQwty3iQRRt9P4LcbuBVMlsD7/C4ib981OVjOc3gIdIqTcPr
nG8EsOcnUbersaTzbf5raL9innHfzWyzFwLdKfgaX1k87AUz2qyWl+V2/4z9
oZdJOj/mK4TOX+ao813WlvluwmnsJ9y/YP9EH/d+o64Uczu2XW/zfMzZDpzi
7s94eB11e7Z9/wcUGmZR
         "]]}]}, 
     {RGBColor[0.728828125, 0.55984375, 0.390625], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlX1olXUUx0/NtXWb0WSPu95n9857b7Y/LKIgWm+spblesNqMTER0VuDI
NiEKAnNDB5EGFkj/ZFEyCko3C03wtTJj1Qz6t8BmOG1LjSgierE+X77PHw/n
95znnO8553vO+T3ltQM9/ZdHxE6eGp7O+oju2REfzoo4XY5Y3xBxqTniUZ6H
+HZvMWKoaptB5Fgp4npsn0ojJjP7H5B1fL8R+yG+vYNNK/KxBRHjLREriTOM
/TIwl2KzAsyjlYiL+B5BHsRmHP3t+YjGVuLgewD7k7x/xHmG811gniHhg2AM
oN+A/hK6Ub6V8L0Axih59IA5hrwWmxuw2YfNt3MjJuoi1mIzif8/4IxgMyfv
PJVvNbN/HryV2H2HfTvn35DbGmw3r+JzHrmK2k5cHZEkEW/w3Irdc22ur/3K
iO+p+f2ycSaJ/wncnVAtxHkN31/x7cHvm6zGemK+h/3D4L+LPJ+6N0/Axwuc
/wbnADbLi8aewbcvdS8qYBymrinqKqTOQ/n0Fowr/CfBmQK3H/wzwsfnNvJc
A94e3rvR/wjGTvU3F/EW8pUG46h2cScOS6n7pzpr0OUS27+J/RLqWojNVnRn
s1j/Nbt+8bAa+7Gc50pc7CaHpY3MAPkebvP5KPJLnmWcv0JeV+85Ub+vgMO5
zFktshf8m9GvQR4jxjbsesEfaXHP/iXm/hbzJv4mUs9nGzxcLHlmNDujxFhM
rL3IQsU1p8hDqedwU941q/Yu/BZpVjgPJt4B8V/G5mDqXOe0ei6V77Pw8UjB
nIibLwquezpvnXqtWVzYbN/jxJ0m55fo78fg78768gEy8Bng/BPn1WXn0Ane
xrzzVL7ibEOdd3ko7108BWZvq3UdyJbUe3Q3OTbm3BflcK5s/GnknXWebe3D
6+DMg/OGqn3kq118JnEvh8HckTeHY3D4F/n/SS396C5kM7y46h3WHE7kPbua
4fXI+XlzqFnWTiqX0/ARfCuBv4VYm0s+DyOH4XGG3B4Q/62u91RiTsWt9mwH
vKxAP03tm6q22Y/ujtQ7ck/Je6LzIWLtSlzz2+Q+1cRdRvj5fH8129PtyASs
l+GnqeLZ0owVK76nxP+LxD/G+y/YfIrc1WLMdcS9n/cR9A8i12V3yt6S90d7
9HjRHIkr7b185NtVcc/Uu6/B/73JPevDt7PoPaoFoxPfW+jRHmy2ZPxsRm7k
meLckfju0C7MavYsb613nUty1uuO1t5qLnvbPDean0Ewz1W8O9qhI9k9Iy51
52qPquiezvms2dXca/63F8y7+F9Evp8l7stlnMerzl//GemUp+L9XPG/5Dyy
C5t2zvdVPeua+VXE7Ca/P67h/mzznijmTYnves2s7vLaondKu6V/j+rbh29N
0fE0I8IQpmZa/RYfZ+H4qqpnfjZy+QLfgbrjP+e9D/1x7ULGeUfVd4r4OQnG
/+VjDmo=
         "]], PolygonBox[CompressedData["
1:eJwtlF1ojQEYxx+2tY822drZOc6n8x7sAomUkdKsWZGPmYzW2gfKkm1XpGbb
hRJTrtxLi5I2FsrYfE7DptxSIpYYc0EiLvz+PafOW8//fb7+z/953pNu79rd
Od/M9vDk8nwNzPJLzPoBoZTZ80qzhlKzG+ATGbOqmNnrfLPSIrOf5WY7o2bL
wbuLzYbSnqPcmQVmPUvNysDLCsz6eFeKXZU0+5dDHvFXiO+MmP3Gn+S5Ru29
5KSIXUfNRuy2Sq+vnHdh+oB/LTT7CG4i/3LaaylGXGoSZt3YI9SYpvamkHPZ
z7tH2Dfj5DHnX/At7FridxR4/Evij8fct4X5JuHaEvd5Z+g3Rv8NxEwWeIxi
P4R9dvXfRf+OpGsjvpo1hp7nin2mEuwWNJjA7kDjJxmfWbMfUQ7x0+BV4Ar8
F+j1kJzv5HeTcxv7ZMS11Dw5cG+GXybL7x5cRqixEv8EMzejXyjk9kZiLmGf
ov9wkXMQl9ywz6KZ7lDrbcj1086foXUt/mp8VfCpg+9o2LVXzxa0zyVnO/71
hdwO3Hqz/LTzPPhtg/NgsXMSN+1M+Wt414Y9L+GzKKeH3DpipsD8bIb7ao36
LUjDKLXyMq6NNFoLlz5wfYlzFFdpJK3miB/HPpjy3WqmQ9hTEcfaeTW9JzK+
C+nxlF59Eb9f1f9E/vmo19MOHgT+DehbUM9+7L6Qa6GbrEevscB7a/5RdjkU
ce3E7xt4X8L1esN8jdgHUu5TzTbsTNjvQd/EH7TNiztX7ewovdqyepyhRym1
29OupTSNU78u8F1L7yX4E+Af+X5/ZeBZ8Sl0Dtrd+7Dfqm78KrXS+FfkZu8F
f5DFqjEIbkn4rpXfQG4q5vsaAN8HX096rHKGsV9EfDbp34terXGPVc6rCrPH
gWsljbuI/Rz4PWgH/eCLceeieovBXyK+K2kySb1xep7N1hOXYzGfXTe3lVrl
gWslzXRLq9HwtLnGc0n/JqXNADGLsCOB25rhcMxvTLeg/8RZfHfD/q1Jrya4
bU461g3UYP8HKsi4/Q==
         "]], PolygonBox[CompressedData["
1:eJwtkr9P02EQxh8xGqktCUNp1bbkbW0MxonERHBQo4MSOtBJWKwMGhNT/gQN
7UKIIAntJExs/Kirxl8JkACLJLorKPhjIWzqoH4u9x2e3L13z73vc3dvGB0r
V9sknQXHwOWC1A+W09LFhHQV/0rB/WvYvhR5MJeTLsSkZ9hH4HHO45aPwzsF
/yS2dEYaBHXyOfhKSs/PSTc6pVneEJwjoBmkBtilfiguLeF/hPsBvIZfgv8K
u038PfgHrwpvD/8+d98Df4k9JPaZ2FH8NvAiI22ckF5ifxAfI6+032F3TZ2W
noDf5H/B+4Md5nwbfI/437DrnNfAKlof0Nt6wXu23ju5bwJeMi9VssygXbqT
db7VjdD/MJiPZhajpy2wCVrRLFawA5x/dki1oueMs92FVlBBQy9vjGIXg89o
OfhsbcZ30T2J/krG+Vb3Kfg8doL3Y33dRPcl9K+g+Xo3b4NEtK8msR7O5yOY
P150TXXsm2gPS2n/I/ZXatFex6Md2C6+Bt/NfvC+rX/bse26QW0Xbx3Hf8e8
DuC9zfsObBctasrEvqT8P9i/MI2mdRoNh2iZwQ5QswDvVt73bPsuJz3/tOj/
xv7Pfxy0a1U=
         "]]}]}, 
     {RGBColor[0.7777343750000001, 0.57703125, 0.361875], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlWuIlGUUx4+b2u64G27t7Iz7jvPyztswEQmFUbqaVji6FIu1oIuFrlle
uuASpaVYmbekcCuoyG7EKvUh0cUgxBYT0802GCT3S1YaYUUpERkEa5K/4//5
8M55OM+5/s//PJMs6+1aXWdmH/JdxTc+NWtpMhuDnN9mNszlRwkya7af+3uQ
cWT2K8aHcma/cfctNouwHVswGxprdi5PLO5Gr8a+ZPYaPjfj+3+LWS93fzWa
fYm+ik2ZOC+Q60Sr2TfYP0SM94iVR9+Mfp3XQT3DFbMaNsPYLMJmX9HstozZ
AHJL2WwT5xtjsyMlxT+K3E5ehF0gbz6Sbze+t2M/2mA2Hd85+OzAt4M804rS
P4qs4thPnDnIN+ixg3MPNWzkbjL27yPHTaanerPn6WlNpH4PEP9BvpfQf05/
j1fUu2OwAD2l2HOcH8Z3Pjbj0e1IhcNn9N1GvlPguZTzCfIuJ+/vyP/I1wu2
e8izpKK+vL++jHq/MpuSaliLzbPIgYzmcZakl+jrLmIcwWc3trORTxJnFue3
OR8syNfndpg4Czi/Sg1TwX4m32Hs7k913k+/Q23KcQzdaEH2fej+aVGP06gh
l2qOPs9Ozu34DuDbSU8TM+LN+bxqdO54H25TxGdbqrncHQuDlY2y/zjRjHxW
I4n0F6l5XsDQOTUhVYx2zifpsbsZW+TeinByLvud28xONYcPyFULs/H6f+bn
U2q7g3q6sPkiJ87HgUc+X7e7N+BZQ99PDwfQJ/jdmQq7Gcjj1DqTHp/BphCJ
58uoPRP24gF019HnWmq4yfuNVc8jsfJPDZg0FFTjy8TcQI5L5BoDj3qyms+f
xJnA7LaCyVP0ujCn3pxrbwUO70MOot+OfjHxrifOLvTz8GvAroJ+kDhzS9J3
IF8vaxa+KxvDPvpeOnc9/rZYPLjChzbtp2PkO1cta9arwOBN9H+jv8geZ0O/
5/0diMXjubF22m2cl63hLapLxXvn/2rqbQo9RiVh6ti25zUDn0U9fZzJiWf9
9PtTohpWFsV1j92A3BMwcWyW8N3CeXGi3fMdbCH+i2Hff0DfE2wOEvvWnLg9
LtXb59w8w31npN38JNFcfb5nOf8Sdtl3+pWA4XrkuZLieLzTrXpv30m0S75T
vovfReJtNtW77JgMMN8NZWHoWO5N5Otv9ozAvUPY7CwKzxXEyJbUi79hgxVx
ZgQcvq6IV6c5LwxxvJbjxHmMOH+AbbUo3kaR3lnf1aZU8/a5LwXzWujxiYqw
dsw3I78KcYaQ16aq2fnu753v7FZ0qyLNJV/SzjvfViAvtGoWE9E/Tb8/XsPu
Z7U/Xo//b9xXVl8+Kwtvvs9hfcC5LxWnnduN1Nkc+OO78n2i+J6nLmCbR74b
uOFv/7/1moXzb3r4j+hOFMtjTmF2NTC6AX0V3aQQ33namxW2vru+r27vHPV5
+Fx8J0bC/nYhLwNf9wis
         "]], PolygonBox[CompressedData["
1:eJwtlF1ozXEYxx/My45Nm87ZOXbeOuffOruglGKWt4sNkbBihbxlTLSlZblY
yHuEXCLKEoq2xY1MyIUytQvceJ00pI0LFG2t+Tz7novfv+/ze57f9/k+z+/5
/TPbm+uaxpvZBlYBK5w1e8tGMmQWAX/PmDUUmb1k7xt4b072bGL3gLvjZrkp
ZiOstpjZjzLF7iLmNfGLA7PUBLM5xWZLwIdYFdirsQ+Dl6bNzpHrLnxv4FrO
3tmQYpaBd6ZlP8G/JWL2kdULvspeA77TgWznOwPekZZvNXqmJMzOl5utm2z2
YZpZS4XZiohyHSHmGHZdRNye40KFzvjZykJ4qWcinDG0hOGfBP4ZV/wC7LXY
d2PCXt8C7FvlqrcaexV2V0zY81Wi7URa/K65OaI993kPasED7B1Ab32p2Sv6
Gwmk1/OXgcvJ34P/FBwPo/SX+Ov4Wznfhv7SvF63p4OP5/vt9Z1wPTlxOWcH
uCZl9hX/CzhrwbOius9RVkGSfiTF73uF4M9hzmMP0Z955FvCmZFCnU+g7QZ3
3jNe/pvgqoh673fQDR7MSptrHAC3oOE4s7IIzn3gmWn5PedK4uNxcXuOfhL3
ZTRfJcR8Ald7/xncIWIecHfFgfrpdzAV3EnM8iJp6gDXJ9Q/r2Ed+DZ7yBiL
uZORRtf6l3r/4b+Ur8f9l8H9Gc2+v4Ev4OGoZt3tXuwtOcU652ZwLKvavMYZ
4BpWe5H07qe2kvx7c39pVjPks7SQdY/a7icU6zXOx24nx6r8e/S31phSL3yv
Dy3jknqL3r+n1LI1qXl6xvlBzrfGxecaAuy6QLm8Xz679Rndnde8HlyT1Fvw
mV0P/9F8Pq/P4D8X6O2NzRg445qJ/UWOBnI1YTcXqKdD1PI+o3+L1/wO3AXf
3JB61Eh8LNB8+nxEA3E4l8d0Erspodn3O+yl/u8xvZWxGtFfFdfdniRmI7G/
w9LqmmuZ18KIcjnnRfhGw7pP17QG/+6U6neOP3ziWd2N6y0HX0kp1s+E4Gpi
dYWU39/uwZjejr8X/zcOlymX9+Qaerqj0ub6/S1vS2i+/Q0+xvcop/v3f8xD
cE9O/fX/xXPwf2kPyDA=
         "]], PolygonBox[CompressedData["
1:eJwtkEEuQ1EUhr80mpBoo6O+SNvk9RESJhag0UYxFmKiJB21BjpgEbahtkAi
RqhgAaYWwMgGqO/mvsGX/+Wdc/7zn5v2R/vnBWBBinLXgFvJEhjPQ7cJh1U4
kG4dVudgW+0sQlt6NbiahWP1YwWOKvDl7GMGTzK0ZyC7+tzot6O29f/VZ0vd
lJas678mE+s/9j2rr86fleA9i/tDjhl3T91XrMf+MDd1/k8uluGzDJfqS+4z
SmIt9PRS2PDfaRqzhxtaeYaHaqydWLv2lnt3jGsxe7hhL8+/lMT3Ce8U7gt3
ficx55vf/0AlMbg=
         "]]}]}, 
     {RGBColor[0.826640625, 0.59421875, 0.333125], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlW1I1XcUx89K5sOukeH1Xu61Ln8vN0fl5hunw1EsVHqEstSKUlgPtE0M
t3o3BpvzuucXM8waq60IeldmYcM3K1pBhTVqDJmbsPmqoQz2Zmi1fb6c34vL
Of/zO+d7vufh97vRG0daexaZ2cf8FvP7ImvWXmr2JfLkCrNVJWbFcbMV2LoK
zQYLzIaD/QTy30qzIeLG8Rni+zE+u9JmBcvNlgFYkzCrxT6PPoVex9kkPgex
zVaYzaCfjcweRa7LlkdfwP83/DfC4yw5R5Jm0+ToxedetdlDflPk/Qvbfc5G
8fkA36vgNsBtQ5XZs6XwLPTcv0TOrZ38V8H9qAgd7l34x4idx7Yp7Rzex9aO
f03MrCPyGMWqvv/4dYN/E/wbVV7jGmLHUs7tdA4ugUMn+m7inxSbrcP2e8Lr
Un2JrPc0iXwvcBAX1aBaHlDTAXrYSOwc+nrwrzOofcS+FXM+pfh9D+bLfO/B
fjHpvVLPOkPetWC+mHH7Jc5Phz6r1j3Un6cPY2A0kesluLWhb6Gu82CuxP8Y
flvocxO2tkrvWweyl/7HyszeRZYQ+xy5+vDfzDz6qH0NOV/l+zb+1/DfRi/G
l9C/crOf8TkMhx+I3R92QztyN+47dhn7NmqoJ7ZRswJnEfgvkKc45CpCTqbd
pyXjM9AstHdL8B/Bfpy89eS9QN4/yPtK0OuQ33H2J/1cYN+2pnxPvqU3F1LO
rZX8/eCOUMsA8kjc9Tz62/ArpPZuZLN2Aj5NyNUZr70G2YX/GfRD6NvBWg+f
Ofi2J7zP6vebKecgLsKrLfQ9aEm4/07iPgmxsjVrt+D/T7nPXPPVTihOvdU+
lCR9Lu+IW5i75v9j5OdPEt5T9S2V9bqFqb2cAfd5Zp0Wz5TjThLXWe13qQs5
HXb4MPXurfT82s0dkd9r3e/hpL8TtRm3bYr5jJ8mnIO4DOa8z9oF3RXtm3rx
OZzauBc/gfFr2PUp5ESF51LOlir3Vf+0K9qZb9CP5vxu6o5+FnA+RX4dOYdT
yK1Zz6s5j5LjHHxew3ZbdvyvZ/1b9suc53OOr92ciHw+C4nw3tGrhrjfed19
vU9/E9MNzl0wNmYc56uc4wr/EXzrwxuonul+ao6vI5urvBd6w64EbsJoCztz
K+s7pX3QG6G3T29gT9x7rZ73k+th5LPTDO+EvDeQT8PbVYHvLLmKsH+Y9F1Y
Xurxy/BLo5chK7Juj+u/IPJd0V0RhmJ138rAGaC3S5F5/HZg7896P6SLp/oh
Dqrhf2hm6Pc=
         "]], PolygonBox[CompressedData["
1:eJwtlE1IlGEUhS8qqamhoTPDjI588zEJgdVOoUUlKREGZiEqpJAVUlIEtYug
QKtFEKn9/2G0LjPKaFMSSX8WKYRktshVUATu/Mmey5nFwP3e99xzzz33vhPs
P9Z8NMvMmvjl8JuqMusuMpshniQ+VGl2d7XZCJd1xPOlxGvM1ueanS8z+xIz
awF/nO9ncbOBwGwh22xnodlN4nhoVpNn1k/+NbAvnR/sEN8P+V6MmP1EwDCY
wXKzggqzrHyztXAMxvXzOI8av1Nm7XBuhPsVOR/JfQP/hmxpHiduDsV/H/4R
+HvTqt3JWV9aml37v2KzDrR8qJJ27+8T+Frur9B7Dz2fAH8jUC/TYGapdyZp
VgT2BR40cf84plp16N9N7ZVS3W0Cfwmumaj88JrX4WpNmP0iPgdnAbnTgbDO
uQx2oFxeuCcL1KuOqn/3pBBvbsXVS5J+o9Rb4L4wRxyTcHWjbzFbM6pH39tQ
s3R/3hFv434JrlWczaE1Uqleveet6L2cVj/uYT/xlgzePX9OrVH0jaOvEfxJ
ejkb02ycY9lrZ/TMkT8VyAPXlltidgSvGyq1Dz7/euKhQFjX/IPc71HFfnaH
u+0p1aqFv574T0Je+052wh0L5YXPOCvUjHxW1ehtIX80qtjPash9nZJW93SM
eCkq730mX8HfCzQr1zDL3d5Q9dyTJzHtnO9eH2fteNHFTDbnawdbwLeV684x
E2A7q7RrvgP+Nh7F1Lv7uwvu8bhyneMAXPMRaTmM5m/gx0LNroffX3KHM/nu
YRN3PVXy1j2fAJ9IaLYr8NUzjzIwFUXCT3NXwneiSDvku/Q+FLdrcC2fY5m3
Dv4Cd0/jeh/+xi/yfTqp2Xi9U8TrwD8o1HxGktpZ310/a0xpJj4b1xAhLk5p
971H73UmUK8+A39bHWlx+cwjZfrPcT17yO8j/2BSs3Q/u4hbA/XrO9pGvC+Q
9/7dQbwjJT7X1EDcG4rLe/Lebmfek3tylV7+A50nu9E=
         "]], 
        PolygonBox[CompressedData["
1:eJwtkc1KQlEUhVdCP95ugqV0w6thIkLlsKJ6hGaBStOCmiXVrKiJplDRLNQ3
aOogalCvUNQj9AA9Q99m38HHOZy999prccqH7f3TlKQIJuGbS2NOuq9Il3AF
uWVpAdahE0hrnK+LUm9GOoiZLUhLcJOXruE3Jz1npM2qdML7MTzRN6Y/E7mm
aT9Ck10/vHVgIi2li9I7/R+wUXWdLc7tkrQDA1jFw6jkuqY/YLaAznzFfZrf
ET6GkM57/5D+85oUZqWzmtesp0/vmHrbevEYxJ7FMrW4d/H8QtZZdvRDKbvC
HUJoJvVG7Lkt/xdznzBT9DxB0X2b/1ZZqqPxht4fervUj6hPMT8de2bLHvKW
otaNfI/tu0i8B5H32kwv8X7LWU/+Zi/v+82HZbFMdxX/0wfOf7R/OSQ=
         "]]}]}, 
     {RGBColor[0.8755468750000001, 0.61140625, 0.304375], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlFtIlGEQhocKVtZdJdTd393fXdzFlrCkGxUqypsuIjHzkOZFhYcOFAXd
RFRClpoQFB5QIbNuug3Rsi6iE2RmYiodqaC6LDt4aRk9w/wXH+/sfO/MvDPf
/JvfeLzq2AoROcpZydkYE/mCUVwgMpcvciAgMgsu4z+3SqTNEWmPi0xg+1yR
eY+zFBZ5nhQ5EhSZBEM5Ik8zRPaSZ5TYIvhriM3lLg4nCg44Zkewb2FXrBZ5
mBIZj4iMwZ/Dl02tbux+7NvU+Iy23KjIMHXLqXsDHCB/iU9kkJoHuXOVjy8z
IdIBJwNcCon8htOL5nX4Ej7rc4Jap7Cn0PAvm1i/yFli613jlHFfk28xtWAa
NdbC6YNzJmb8VrDQ06l6VYvWjXo9aC+nyd+O3YY9j0Z/nsiGNJEZ7CHy7oB/
FSwpsLqt1MkmxmU+WeAgd9vhfGAG1zz+x7DNResORSyf8vX3DP4a5vmCeY5w
tmGPgrXefALc+x3TGEjYUTsd3/2o6TyP/ZZah6n1HqxExybyj+BfDpv/Hf7N
9D+J5lDU3kbfaJz7AU9zP9jgGmeadyiJGScL7oOUvfujlM1F64aZYcC1Hfvp
2J6p/cMxfaqzHm5T1N70JvelUXvPu9T9nmNv2phnv9Wve62z1hmtJ/8wc/7D
fu6H+4ucz8j5mP7KE5ZT92UM/xb6rUmabtXfQC+fwrZ717HLiD/JDoTIueCY
TtWuu6h7cIK+FsjZgN3HG+0hpojYevAeeb6ibSvaLni7obNfZA8zydmM/0mO
xfropds1bdq3Eze/3nehrwadL8lRHLYeg/BbOJXYdWGrrfx0fDu9d6wA64LG
0R2tTlq/teBUyvZnGvS7xumkZgdz+8bc2sFOzy5Hw2v6OURfr8CgYzumu7Yv
YnPoIUcVd4VwdoGXkpZTc/eQZ5E83eAbL89fNPd6/mryX/a0XgEvev12ghle
Lf3u9RvTPmbxNcVshi0x20t9u1Lsrrjthu6IfmP6re12bRd1J+9QtznPOPrf
8B+SurbV
         "]], PolygonBox[CompressedData["
1:eJwtkr1LXFEQxQ9G2LC6T4IhPtx1l7cPI2Gj2LgWCtqIjYUYjbpFAqKFBBRs
Eku/EoVARBO1UTv/AD9JmyJqrPwTEmsTrUMgv2FeceHMPTNzZs690cTs0EyV
pHZONSfTBH4oLRKshFJXXrp5IF2mpG5wa8H5DfgSeDMnleFyxBnyzxqkn0l+
BW6UeJD80Yz0KZZq6F9Jef9l8g/IuSduI24m/s05B89zN0lufyT9ol+pVhoC
VyLvbTN9pfeLyDnL6cxKvY1SEf45d8NwT0PvbRoDRWmVmS+S/mvgz4m+zR+Q
29HsvaxHGbzI3UK1z3xL/Ts8yBK/p38dcVB0bB68RnuPmr+BdEzOGfEr4u+B
z3BE7Ujks5mG7TaW9X7P0tIWfEPBvTG9ELwUemyep/HjQ8H9NI9WwNMF1zLN
fbS+xb7fG/z+Ab4Onbeaj8SdeffP3qgMvordC6u5I/dlznc3/gR/t/Puje23
A36C3tu0e/KPuDZ03jzcoDaI/W/k0H8MXo/97W0Gm/VP8r42zxT7pJL/YP0W
4Opjr7V9O9D/kndvzCPz/jT5XzbjGHpHLVLfI9c07d1Gx3Z3CDfX4rNbfZr+
Pcl/buMNxvF/osn3t5lu4f8DZxhlmw==
         "]], PolygonBox[CompressedData["
1:eJwtkktLm1EQhgdBEPFCwfLFRJTD54eIm2RhNpbuqiTGtDVRlwarxW70D7RC
C/WyVdEIXn9BsXTfdtFuVLyh1VK1e3dZ2lb6DHMWLzNnzpmZd945bmx6cKpK
RNpBNTh/KHIGvnSI5B+IfMb+dCKv6kT+BSLf8L+DRCjSVi9Sjokk20RS4IC3
RXIOib3l/h3IggzYJdbD+6f4pVaRUXBHvZfUPaHeOOfGWpEX2CRIgXXi/dxv
YrMJfDCHPwuuArvbwN+H7x74SP8n9N/F/uZ8A/Y9pz3sG2q20OO17688vvo5
P8SMp/LNh8b1mVr6PAIj9B4GK+R0UqOG2iNxYuDS63Ph7K3mxL0+zdg+zr2g
iP+YWAG7w9scOdeBzaNzpanfDSa8FpUmkSGf80n5oXEWnPF2ktwfzjgpt+f4
XcQKzmqkvV6q24yf+556BXhXGkSWItuz7nuVnAy5a9gB5smDEvE/vNuMTEfV
Mwduic1GprfqrnvX/b+P7G4Oe+xsr6fO9FGdlLfyX4ys/3Jk/0j/09/A5jl3
tnfd/6/AOJWd/SP9T0doUESL+dA4Ktdtr+OWahja/UJoeqvu/wGE+Gsq
         "]]}]}, 
     {RGBColor[0.90390625, 0.629765625, 0.30210937499999996`], EdgeForm[None],
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlFuIjVEUx1c8mGEuxRlnzMw5p2++ju+NxmWEeZBomNEwF41LLiNyGZE3
knIbM0y5T+6GF+XJrSQvSGlkJkYRUrxK0niRSH6r/y4P+1v7W/u/1/6vtf57
Rxt2tuwYZWb7GaMZ4yvNBsaYNVeZtTAes/hiolmcMaspMBtmPRObVRSblcZa
c8yiyGxpHv9Ysz1Z/Py/xz/C+iFwLeD7sReI+YX4rcT5wLjHmVX41zJmg2l0
LHsnF5nVYxuC/0lidrPCLAfJlfgOhphD+GtyZoc5txLfM/Z0sPcDth7/Cfyd
2NOcewv+ReWslxGPc79z/ilww/D8Cs9d+F/iLwW7KlbMKew9yrjLvAd7KSv+
Lex9kQj/mX3fiDun0GxDRnXx+kTY2wXCey36YvFxXqmAKYmVs+fYge2Hz3Ow
TeS6gHqWgO/Iip/zHGB9M/uv4e/NqU/er1ToW1eB+rGiSvP7abOrxJpE3arh
NoOYP+E5LavcPMcl2PYKxR8mfjuxppLXG+bnI+FrsuLk3M7h2xo4nITzugrl
V1Kt3rsGhsC8jsR/Pb5GYvJrl/m8CzX3M+vS6mkTcZaGOnjPi+HfDP8dcG6L
lNM88G1l0oxrpxf/fHp9GNsU6vaROl0J/m5sQZly8ZzeBm24Rhzn+GPMh2Ll
4nUd4Iyp8BmMtd/jXI+kRdfkcmwtsSYQszmShlxLa8AvDpiFkfrq/b2HRmam
Vf8J+BqCJpfH6qvX50ykfnidl0XSn+vqYqz75vduek7D568q//e7DezoQvn9
jAfwn4w9y969ZeL5KaV76D06D/5OohoOsn4iVr7tcHwe6vM0Ur+dz0bsuNCL
zoxq7TVZkwjn+G2JcvbclzGvZc8v9s7CtsbiU5+WDjzffdjVifRwBA51/P8G
PzcrnOO7XVextOH33s+vKxTX/rz65RrsKlf+xXDblBHmO77tGWG9n48S9egt
Z21JpIfjzHvCG+JvSS5W/fyulBN3N/HT2KZENfRa+pvld9nfgEthr79tXhfn
55odDPpcgi0u1/0/g/9KqIP353jQ5J+U3g7v9XrsAfAG/zEZcXXOrdjuvO6p
v3N/U6qb36dJoT5+h0qrde92Z1VTx4yk9O/+PuzZvLTnGvyRUl6u5TznPoTn
DXj+A3dlznE=
         "]], PolygonBox[CompressedData["
1:eJwtk7trk2EUhw9WMNWkgkmIzZWvL23GIqigOKh0UCipjQneqDWiICoVNxc3
pWKHWtpivZToX6BScNVuLTVoFUVdxNFBRBcRRHwOvw/ywXPe9z2/c0109kp9
YoOZDfFt5GtGZgNJs5ccNuBZvp7NZuvYM3AzmE1jD3SZHYUvVWQv49vKmuWw
r2HvSJi9K5h9xqeVlP9HuIZPBd89KbMR+ERs38DnJNwqme3tNhvFf0uRGFlp
e4y5frOHaPCzg2guAkeqyjfNWQ2+j8ZruI7+A3i5qliu8QJeiZSL57QKP46k
tcpZGz5XNvvdLb1fGfQj2X5fgyeDanf9W/AdvkfkNsjZNHw70lvXnPLag+J7
jePw9bL66TX8Q3+qIn/P+Sq1vudi0JTfB3iYsyVTfyapfz3O3zXewl/R+EN+
K5vMttHv5HazJ/TuG3YTuxjknyeHElwv6M7fzNDfDhp5tD6huQYvFMX+5h48
VlUtnu8peL6s955jIqsZ+6y7yOEmsZeqiuUxn8Fzcb98fvPwq6Beec0dOAp6
38tZBX6eQyehetJop0rS9vtdOdXkuT3lTYp4P/j2xfuSJN9jOen72Xl89+e1
y655nPtCUC99Hr3wcEW259ugnp4+1e81boX/ZlSr2yP0v6+kXLzmAL+J6/ed
P4B/p6rd8HmuwbNF5eqa4+RyN94P36kF+ExWb70fbfQvVjV7j3kB/pLRLvr7
nf2q0Wv1/8h3ah8L2m3fsdNBPfPe+U7sZlY/M5qd78sQ/hMl+XuPLsOHIvXH
/0OH4XZQ/j6zRXg0Uny/r8ONovTdpw6ng/rhM8zA/wGi5I7c
         "]], 
        PolygonBox[{{5572, 5571, 7431, 2304, 7430}, {7012, 7011, 7334, 2234, 
         7333}, {6935, 6934, 7735, 2553, 5345}, {7313, 2223, 7314, 7011, 
         7012}, {5347, 2555, 7740, 6934, 6935}, {5441, 2680, 7960, 5571, 
         5572}, {5613, 5612, 7522, 2362, 7521}, {5488, 2738, 8073, 5612, 
         5613}}]}]}, 
     {RGBColor[0.91171875, 0.649296875, 0.32632812499999997`], EdgeForm[None],
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtks1LlFEUxh+KxOyDKZT3BWca30YZcFltAzMpNZ2R0Y2OWmMu+lCrv6Gd
ukhT0dESF+IuIguitQvNDwR1URERrQMVpU1Bv8u5i8tz7jnPee75uFHfk9zQ
CUm3OCc5mUiqPSu1gQeV0s1SaSYlfeZ+H/9RIC3Gpetw+4lfrZGWzktXwEJC
+o7/dwXclOXuwxklt4Hcr+SueZ1VcMT7h8EVchbJvQFe85o/yqUv5PyLSd1p
uPjf4T/A/wr97nPSPDjF6cTeCYkHVn8WzWPudaelQer6Sc4p9APqGSN2G85L
MIvmJzT/Es94uxWcocdl6p8G59CJ0K/inWTK7AgsUOtCmfQ4KV2sNH33ziax
QTgbYIJThR0Hx/zccnDnuOfx76L9LbB6xqln1vuLbn6+33pwy2sewr/kNWex
35P7nDrb0d4LbSaviQ8krPch8K7Twl8AP4Zm38POMNNjZtuWtrm4+n+V277d
7hoD24fbyzbxST/nCfAZ/mV6H0navt3en4J/yOmnlw16WY/M3gTzadtjD3gm
bnz3X+6Q/wKdVnA4aZqj4JvAasvC7+W9et7tATsqjN8C5wGxkgvSI7CJN9K8
1Qjm4jaTDjBPTh25H0L7r27+bg8lCevL/bsUdoxZXQaLfu+x0Pp3c3B/ucvr
dILVnl+E0+zffQv3MLB6HlLPf94gd/w=
         "]], 
        PolygonBox[{{7152, 2115, 3394, 6327}, {6994, 61, 2603, 7835}, {7249, 
         2178, 5, 6930}, {7120, 165, 2693, 7987}, {9053, 3394, 2115, 7151}, {
         8042, 2721, 2115, 7153}, {7531, 2367, 221, 7179}, {7151, 2115, 2721, 
         5473}}], PolygonBox[CompressedData["
1:eJwtk8tLlGEUxg9BUZE6gdMnNaN+fQ0DBQUzrdokammpM2azsbGLFmSaRssu
qxwLVLoXNWNKq6hFhBZZ21pojkG3RVr0B9TGUNoU9Ducd/Fwvu89t+d93nP8
rjNt/StEZBdYCQ5GRAZWi7RhZzeIFMGrjSJT4HYg0l4ichc7w/80KPLdx9l7
7E1fpGGdyA3sT/J+gd8V5p/Df7JKpBv0RUVq1oicjloNrTWGv4O4B4H10p47
iN0OmsH1tSJN2M/UyxJXIG4A5ECaflvpm8J+o+d3kNnEXUChUmQbuXlsEf8J
4maxi8oNjFBzEv/ZsEgZdw6Bj+R9AEl8g/gS2PPknwNzrsYfT+QKOZfBYrnI
RKlIXYx8+E2i3/2I9VceOcd13N3xi8aQf4m4A8SVExMGjfRpAL3gIX17sKX4
S0C/02yZ3CWwm+/eqPk0ppraPrWrsGNoNw4uwu0C+AG/R/BLwq82ZlzrsZ3c
pwu85U5vQE9cZNV6dIHbIP85cJizfyGRr569p77rNOfH0eCdb/Ohc9LId5yz
/dhjcKiDy1HsY3g8AYmYcdiJTdAzCTpc7WzcdFQ9lzyrPeM4Kbe9YA9oJW6Z
+KeevZO+Vz6weRjFNoMm0On6T6FTHoTQKojam+rbam/l0OrmZsIzHVSPW26G
FzgrkFtNnSj1ykAILJA/DyKB+SqxL4ir4ftQYPOqc3uNu1wFf9H+NfdOce+X
xNUSd8TxVL6qjWrUHliNLPZThe3ZncDmQedC50PnJOP28zn80k6PVNzeWd87
5Lj6bh5GqdUSMw7pmM2wzrLOh87J5qjpswX7zLM33Of0Vt11l3Snhviuxzfi
2w7rLg+73RnCznvmH3Zzo/PT4vY2EzbNVDvdOd29exHbkzz2lJu77rhpptr9
B0XVqxo=
         "]]}]}, 
     {RGBColor[0.91953125, 0.668828125, 0.350546875], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVEtIVVEU3VRgicoTep/et8vt8moQD7QHTSLIMklfTywrTEIeQSn0giaB
NMx+mEZUhlk5qEmD/lpNKxDFDPpRiRU0aRDhtw81aC3WHRzOuXvvs/bea69z
ncLhpuIiMytiLcaqTpp9xqHKMwu4ZheXmF2JmNU6Zp9gvxs2S8K+fqnZZMys
J2XWWWL2I2g2C98yxD935GNMDv6NUTMHMTnYq/B9ATGv4P+A+N/A7IJ9KqZc
6+DPYrUh/gUwjwV1N582+7vcbEWp2VHUeAuY7bC3oZaTiFmDcytimmHP4Hwi
btYA301gPkL9AxHhs6e9ru4S4z321WXqucYTDvFGo+rrUMKsgPjN5Wb7sXfg
uwl97UHtvUHlakfeAmr6A4xNwPgFXylydcKWr1SuG/hujKsX8vEE6wjO14B5
Pap+V+J81a+TfMyGzL7BPg5+KnB3DPZ5+BciOtMWRNwX5H2AnI0xxffBfhlY
Lai5D/sM4kcRXwl7V1wxjGUP7GUQMSOOeiF/P/36tyImEFdMN2YyFRJfecS+
BeYwYo67msnXEs2ed3h3Iaz5sS8HnLX6mtkA+zTmWI47+8BPbZk4J3fUEDk/
gPjbYemNutvlir9h5HwYVr/sm/2wrznY+4GVwHlnTNisk9rKwj6CcwD27yHV
eR6YDY7mXo/9Xljzzzqqj3V6Cc3nX4X63J1Uf3Pwn0ZcDe6ewt6DtQXns9gP
plTPLOqpT6nmDPYOrCGc67BXe9IAdb02qR7LqX3Y55Cr2dcy8Vl/ryOOzmGf
iQmHeOyT/QaQa4K6h85epoVFzDuo82la+nuW1nvju+tH/HhInOyI623wjUzD
P+GKf2p/VUKzozYnw5oPNT7oiZNCUFyyd/ru+xzy//HYx+T7I+/MlYF9m6Mz
87/z9VNMqXZyzd74VsgD75/x+SSvA650SD1u96RVvr86n9vXEf1HyNlH1NLt
SAPULP9HnN087P2+/vm2xhz1QF3wrVK3OU+aZm1vgHnJVW18rxl/pkOw/wfe
0cdg
         "]], PolygonBox[CompressedData["
1:eJwtk0tIVHEUxg8VTIlTCQ1za+bOdJmGsUUINQOttYLSacSwoCLEgjDIqE3Q
vqhQe5CVZuGitr1IaV0LScIWvQt60KalOtmDWvQ7fHdx4fuf53e+c27Ue6yr
f5GZtfIt4WvOmf1ebNbWaHYuMrvItw38B9tx8K2C2YmE2STBrwOzFyWz7iaz
Cd6X8P1Imy0DfyNmmvhD2LYkze5g68yblTNm7/AlG8xmV5ndI/4TtSNsnVmz
aiT8GdsDfPP0eEbuKWwz1NpPv/UJcXyP/36cP4VtB7kvA3FxjleJ354Rl9X0
+0u/UfxX8PdgWxeanczJ55z3gM9Gmt17dKwRZ+deX242XDQ7kBN37+9aXYPz
d2JDYlZQe21BtYd5j/Hug29LQvXn4VqP9XHbFL2eR8pvwPYL34e0artGA/gm
qHEbXx/vfdR+Sr1ak2y7eU/G/s1L0Yb3bEZ8XfODvEf49ialyVxGO/RdbmXG
IXA91reL/COhZvbZfecX8N8INIvXz1GrzMxfYr0r4JWBZvcZRtHibUpcneOT
km7CezuH6+CvKe3Gb2YG/0BevZ3DefDhULv29xy1o1B6+s5GeJ/JSjvX6yda
DZIzHd/HEHgw0my+c999OS/+XqMCvhzJ5xp8JL8/r1v+x37H2W9PQfxdw8f0
W0irl893mt69KcX6DD7Lq0D5PsMYudW8tPKdtINrJd2z3+hdao0XFOs5b8ht
h09zo/bt/0Yl0u27rQNcDFXPZ7hJfC1SrMc8pN7RWC/XYAF/tSi+rtFO8K6s
duU7e0R8d0q37DP6rlpy8ju/DeDWorTxG2gDbyyql8+wCfwfRFmfgw==
         "]], 
        PolygonBox[{{5961, 5960, 9059, 3396, 9058}, {9111, 3418, 9113, 5960, 
         5961}}]}]}, 
     {RGBColor[0.92734375, 0.688359375, 0.374765625], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtk01I1GEQxoe6lClS7LqR67rLn+Wfh7JoN6jIKLqIbixBuUV12MpEQlui
oksUWVSgaRDWIZBAL0ZfRIcugR0SDyUUBRFBt+gQfUrQpd/DvIeXmXfemWee
+Xhz1cHdA4vMrMJZzOmJzLY1mPUjd7WajdWZnUDONZk9x7GUNrueM5tF715l
1tlsliVuGNs09ywg7S1m75NmM9j3ID9z5tGrSY8Xzix4Y+SokOt1bLYjYH7A
XgBzBf5d2B6lzNrqiUPfCI/L8CmBUwx6odXzKW8Hvi/xq+L/C31vqOVF7LjC
P8X7Oc48+pcmx87WOyfdZb8Gx1uBmzg+o64Y/En0RNprmY68BsVtAq8fDh1L
ybvS7AdnK/oxbP8S3h/1aUPOc5Xg8z3hNapWcdze4DUciFx/CkYxY/YXnAJy
Nec3+iFkb4vj9yE/gbOAvhb72aRjfsRW420deHNwX1bnPVFtx+nXXe6jyJ/N
PqOj5NyXcn/FKUb6G+xDSef/DczbcGokVw6fBfynljAD+nEH+3LseeyD1LiF
XPupcU3GubVnfFfU/yu890Veq/alLdS1E3tX7PxVx+bQK/XsZt73sAzn9Xn3
V9xIyFVDjvD2BJ9h5OlgF5dL8JuE5x/4Xs15rHr5Ds4H6fMEXG6EWT9ENmJ/
jP84cZ0pn/u49ijvfaxk/Eg/D14l9v6oT92BcxE5E3tv9Q/uR46jPaoGXdhT
kdelf/Yq9r3SX3kb+Yw0q1qoZRTZG/ZZf7Qc/uYR9Im8+w9guxdqUU3aY838
K3vaEzifQR4Of1PzHwr9uZj2fghHsy9zv4D9ATxPhv+r3f8PMOaUpA==
         "]], 
        PolygonBox[CompressedData["
1:eJwtUjsvhFEUnCyFxyoIVsSu/XLDF4mCQoGwITqESNYrKNYjbLEkgk5oPAqv
QihFYhsiNFrJKogCCVH5BQqR0GnM5Gxxk/nuOWdmztzPS8wPpAIA6nlyee58
IFYEZIgzxDVhoDgfiOYAbSFgIgL88ruE9e9S4LMceCFBOg/YrAK2POAhYD3b
xEcO8Dk7TM5j4i/ORDlbWECdGqA9ZNzSqKVWl2ez4ugkTjrzo55Z4ibeRYNA
Hc81ZxeqgYMC8ztZBkw5+5ZmgnglYlrS/KN2gj0vxKe8O6F+Hz2v0/st9R65
S6raauPUfK8Arpx5F9+lMDUbiNvpMUm/sUqbFUc/uT5KLRvt0Ej+G3J0FNkO
g5x/dTYvjTdnmWo39Yzxu9uzee3YQzwXNi3NjLD33Jl/ebogbvZMX/0txPs8
rUHLb494o8reRm8Up9d4mWWljA7pb82zfFRfJe71LFtxajfNqJbg3T1rz75p
y8MT8YmzrORP2Zxl31v8aeJR3/wo/2Hin5BxSXOIb7PjWU09u9L3bRdl0E08
7cyv8pshXsr+X+pf1r7Z95KfRe72Dx65XfI=
         "]], PolygonBox[CompressedData["

1:eJwtj7FOAmEQhCcmJGKCesbLkXDHcQ2d0nB22kpDBB6BArSRhDcwKHSWUlFC
S0J8DX0DiU+gIUZCyfdnr5jsv/PvzOwm3UHn8UDSKciBaiR5eWlWlL5K0hp8
n0s7uLTMHL0HLnlv4S6oBfpjcI/2Gm6D1gulMzAC80Pphdpipp15Ou96LI2P
pKvYZp3mD+0NHg94ffrSB0h4n8BVqE3fNGlsf27mF/yAfpbfiyzH5U3xXJH/
FtqObtdlID3B3cE16G/Bf2B7Pod2n7uzlt245v4J/IL/bWDzTjck851dXmPL
d3vsAQlkLik=
         "]]}]}, 
     {RGBColor[0.93515625, 0.707890625, 0.39898437499999995`], EdgeForm[None],
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtks9L1FEUxQ8ZmKGWOjojM9/GadDZmW0CzVFRkyBNtE26kRRtbNGYUS6C
Giho0ULd+A+Ev0irhW6qtQsXQYxGqEi4dJEbQQZc9Hnct/hy7rvvvHPPvfeb
GM0OPr0gqZWviO9dTDoqlu5GpXsp6fSq1Ad+TkqjZdJXcKxa+nhZmopLJ8SH
vJsGb3FuvsSZt2vwHsH/BFZwvgjnb0ha5jxC/k9EGgpLD+BPBuTDVquXWg2B
6bSRq4wZJ0NuIrBaruYEOnfQGQebyNeWSN/QzMbN2zMww10PnCfgdo20RV/9
6K17b3vw9yPW1xdyv6h3jochPLTX02u59A/PTcRLxDfAWXQ30Z8H2zwnDa7z
NofP++g/TJnOMHjTvz1Apw6fG/j/if/n1aYzh86Sn8li0u4cpw+cCqz3KjTL
o+a/8Zq0wLkRzgC5zoRUXyp1gx/Ir8Av4KUnant8Bf+93+kxM3js5/advg9D
the3nwLnTmY4Hdg+XF03+5foptF/Aa6FrVYX8S46WXTOePcjYnOeTNru3e7c
Dg98PBC3/8l5cF5+o9OBzht0XicszoG9MevxStR6cz2+JdfC3XU4zeBtH6+G
bZeO72Yz433mye94b3nwP0jnaS0=
         "]], 
        PolygonBox[{{5453, 180, 2105, 7990}, {7243, 4, 1990, 7244}, {7803, 
         2018, 46, 5373}, {6330, 2329, 2105, 7132}, {7537, 2370, 2131, 
         5977}, {8017, 2105, 180, 5462}, {5866, 2018, 2216, 7306}, {7726, 
         1990, 4, 5342}, {7299, 46, 2018, 7300}, {6927, 1990, 2176, 6061}, {
         7245, 2176, 1990, 5834}, {5950, 2105, 2329, 7471}, {7187, 2131, 2370,
          6393}, {7528, 2131, 222, 7526}, {6137, 2216, 2018, 6982}, {7535, 
         222, 2131, 7536}}], PolygonBox[CompressedData["
1:eJwtkr1OVGEQht+QmAgRYrELR9zVHI8nG2zASINmlfBjo2Bi42JDxKhglF0g
arDQLaCBQsFLIKKG9aexES9AsDIIIcIFaEOBJjYWPpP5iiezOTvvzDszXzxS
vjpeJ+kkHIChY1IJqrHUfUjaapFeJNIifICRRmknklZbpU/wkm/DfHtFvHJc
GoQKLDVIZeJsVpqBvQz6Jul8Kr0Pdd4lXsNqLZD7Ec0UuZmclIVT+GiDPryk
eKnh5T559+B5yH9GHKPOReqNEleoVYM35J5AcxbtGeiE7ci9Lifu0/z2hto9
xB/NzNbsuaYZKEh/DjMbtX4flfbhFtp+atwhfqXPOmzwu8y3TeIGuUXqPURf
hgq0M/Mys59OfR6bqxL+v06Pf/T4hq6E/hrcDfN8xu9E2OXNrPc3H38j7/c9
8V3YTtbw/QW6Yp/7HLGY+s4vpH5Tu+1Q6Fcq+F3sPr/Q/YQ5dv76oDRPnMyz
k3r6531Gm3U18tlvB5/md5DcKpqBnPdfCzu0XT6IfRePbLdob6Cthbdkb+pp
eGNPYu9vPh7jZxp2M76zjtTfgr2JlcRrvCVeDre5VPB809nd7f7teD6C9w7i
f+dUb2U=
         "]]}]}, 
     {RGBColor[0.94296875, 0.727421875, 0.42320312499999996`], EdgeForm[None],
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtk01IlFEYhV8q6MdFi9Lvy2lmukwfExEl0UIQpUhamPTHIBmt2khRjZUQ
qODKRbSIEmpti6ZMCdoUWcsWYRBW6pTTInftgshyEfS8nLu4zPude+55/86E
C9UzV9eZ2SnOek5WMFsmCPyupWbvN5ht22m2g+/f4B8Ts6mSWfcmsx7im8Fs
aSNvWsz2wmnAOZCZ1ZvNLoHvz5v1g6+Cd4JXimY1NO8TT7eKcxG9GucG8SxY
nbiC/jn0h9HZBd5bNjsfdT6DN+XM3oKXwbrQ2kM8DrezVfzD1PUBnTly/U11
55x+dPqI720xO00t71qkc4Ieb3O+E/8Aaw/Scb0Hmer0nibQfInmVzTbMnG8
xpNovQCvg8/E+pvRa6TiD3HfFWd1MKdvxyfRWI4c1x4KqrOHvPsKqs17XUzU
u89ygrcj4D/Je6WoHv+gsVASPsfbsyXNeRb8darYsTcx9j08zDTzFXQG4k5/
kWsh5vJ5+w68l+fcH+Ouibdrifbkb5+BHwryzBPwwSCffErkIccfE3cE9eLz
9nz+dp5d/NtulmMXIwX17L2Pwp0saZ5fUvnMa7sMNp9I3/NMJ/Kb+66WKJfX
0p3THm8x/+Gg2DH3qM//aNCOHR8L6tn1rxW1G+f0oVmJnnfvP425dsPvRXcM
/nF+B/H3kc1m1bzunDOVaAe+i+t57cnjxbI84fO8S66lVD16rzO8+cbbreS/
E3fqu61GX7m/2vLyof9vGvAegb9CYzUV3/3+H5A6mL0=
         "]], 
        PolygonBox[CompressedData["
1:eJwtks0rRGEUxk8ojIWFxZ0yH27TNMqEpZKJyGpSJGVrI5LxVQo1a1nIKNYs
DMOkbHwvrdj4HmYs/BGG2fmdzl3ces77POc8z3nf606kRmarRCTOV8P34Rc5
BwzUieQiIn/U99Sj1AXqoYDIXa3IV7VI3hHpdUVaqEvUx9RtIeNUEwf3REXK
1K3UCfAe3wXzFqn3wacRw3pWxOsxZrVmeKcej1nvDzMemT8ftmzKp8BjeLx7
/Cj4xTG/b85WyLYeMNyA/g+uI2pZNXMneAr/aXAW/ga/nGO8zkzQ30T/A1xf
vchcUKSx2fZLkyEJl3Ztvnq+0fvpt130vvLMPosY1rMS3E7UvNRzF/zkWHbd
cYlZV2gOPL4Tv37XsmimE7TPnl7PluHeuJ/VWnujMr0Vx3bVTBvku/abn97Z
JFmGubOMzzxK7LIQtH7dsYL213tvPXtFX/D+B32TLHUmbFrlt8FbYdtPezbB
h/gXvfvtIt8qb9Lss0yD+CVjxqkmi/bI0+v/0o2+PWi7a75LvNdcuxu931e0
sZBptScKnonYbrrjLfp/rLl0Vw==
         "]]}]}, 
     {RGBColor[0.95078125, 0.746953125, 0.44742187499999997`], EdgeForm[None],
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkD0vBFEYhU9o2CCRrJiClckYU9goUSxWpReWUtD5DAqfP0C7kl0tW1ir
QiJR+A9s2CH8BZWPbCPxbN5b3Dxvzpw577nXX9yYXm+SFHKaOWO+FLRJGfjg
SVPt0mogXXOWmG/hSZ90l5Dy8ADfBP4jOJOSEug5+NJt+iH6CMdnHoYfnuXc
kHOFpx89iz7u9lbQ7vF4rdJQLxm+eSZhjJ7rlJ4iadRllvHHZG2SWYNpdv/w
7yB8T0pfzAPMl3xbwFOGK4Hdaw2WuPhfh7TcJW2TmSFzC+64uUr+L3vn2Vtj
b8XlvKGlQ7vvLPmPkXWrwlfXp44nTFmHCBbxf7OrAOvkXrRIxz28VWT5MTx1
njn6nLtuZ3C/8Ub0eea/PTfvws+kdWh0+QfcJkQ+
         "]], 
        PolygonBox[CompressedData["
1:eJwtks1LVWEQxh+CwEyFILnHj4zX2/Fu0kWCudCrghF4d6IWpiDWzo9Eb1Bq
+1oH1VZd+LWyoF1/gxrpVcqNroVECzdCv2HexcPMmTkzzzMzbxh/2T99TdI9
cB3sZ6WZSukAO5yRnoE0kAcb+NkKqRO/sUEKYI1YIPaQWL6WHOi2/4l1YTuC
1+SxD+qkVjBrcWJFbB//F0Bb8D7twXtYr1H6j4CfcOTJvSFXwO8Dk+h7jM4J
bLFa+lYufbgr/cE/A0e3pb83pPvU34SzArwgflUlLafSMf5JhPm7OWnolrST
c42mdYjacvqe0msNnjH4NrLOX4i7sR19Ifac3Ba2RP1T+vxLpG2+d8ArdBXB
Uur8K6nrMV05OM7R+QuOQ3QcgJY7UkKsGbtM/RI4TJx/Pev7sr0tso8u9rKA
fUSvXvC+Xlotk95hv0ZdvxPnNx098TabGb+p3bYpakjjTe22P+I+Sonzm45a
4jWWy/j95oLPZ3NeJv5uSvhPmOGCOT+lPo/NNRh3ORB7WC+7k91rP+5sDzsV
7/qdfgPoHQRv45x7GX8P9i4sbvmPqXN9xr4O/k7mg+/CdvIfOkJoHw==
         "]]}]}, 
     {RGBColor[0.95859375, 0.766484375, 0.4716406249999999], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUksrhVEUXTGia6Dupe7l6vh8LklexcTrDozMlBShZCaUR65kwMhcysQE
A0pKiCQTxcQA5Z1HGUv8AmvZZ/C197fO2XuvtfZxQ+NdY1kA2vll83sNgLE8
4IaxqwRYzgVmGPsKgTpeuCf+4O9cM75ErS6SsH/hDylgjTXfOUAiCawTHyB+
S7zGAb/EA+KVzC85/LEAyMSAfPZ5ZL+GhOXNPJ9gn01yWGFs8rWlrF1kHiHe
y/yC9WfsU07sMDDO4n4aBypI7oDYVdz4PzEfCQzvpKa3wHCdVxcD55z7RC5f
UeMgLoNl9IP5Ee92e09GmT8Hxk0cQ86OR4C0M83SXsU88PhuCNxR/zv7/LB/
rTPO4j7nfegkh2mvd5+9+5Omcd6Zv//7Ia/pmPERrzbfp5W1q6FxE8eUn6v5
x97/DcbrlNV+xsxH+VmetH0or3d2pjvDjLPeZ3E58b7J123fU7vdCI2zuHeQ
JwMyrNsJzUPtttdrSROLe3+6Gfe8/3pfS0VWqx56E/JkwZlf8m2KscXrkt/S
LO2NzrzT/Qln+9Mee2L2jvUmPxgnnc3VfO1eWrYC80VaThn/AEeMcEQ=
         "]], 
        PolygonBox[CompressedData["
1:eJwtkE0rhGEUhu+MDQ2lzMZi9Hh75yXfFmxI8xeU7CzESkaRkCz4C1I2VmZB
SQmRZGNhi2J88wc05Re4jvMunrrOx33OuZ8wNT9WqpHUxqvlLbdKW/XSDTyT
k+Yij9sz0izcHUvlRqlaJ+3SO553tlwXtW1yZfrv0S+hf26WmuR10xaCdM3C
lqyUwMPB6xaPBJ9hvZb7QXvFzskG338J70fOljuAK4lUgr/of4Q3mHHL/Cw3
bMLF2JmzVGXeRM69macdagtpv3lYhKdzfrt52KO+HlxvPWvwe+S7bOcHPJj6
+UU/BL+Q68+4/hV+SPxWm3kHf0eutZ5P+DT1Y/ecwUex/4X5P4SLwWPbMQr3
8Gj/39cLDwRnq/fBJ5HvtvnHcCHvddO84b8zuFfz0wE/pffaTRV4JfhfmedV
+Dzy283DBfwHwqJQ8g==
         "]]}]}, 
     {RGBColor[0.96640625, 0.786015625, 0.495859375], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkMtKglEUhRc1EMRsoviDofxEXrGLb+CscY8g6dDQCMfmK6iTFEGoUQWB
5iUfRMvbG/QAgfT9nDPYfOts1l6bs93i3U3lQFKMOqRmp1L5SJrD3Blvv7QI
Sa9o37H0Drtx03+C3/iq+JdwTdXQK/jLzEdQKuD/5H1Lf+NIvYjJuU5KLebH
5HRg2pVOAlIWvuCJo6/QKSqK7tMbRIwnQ29D5j2ZO/gQNjltci5dM5uHF1QM
fQ6TNicBm1QBvSDv0eoGnJBVInMM947J36J3jrnJF3pk/zL0vOx9Zm+dvT17
E+9mP/Ymf8xNbebWMX/2/v6G5x+PSzgq
         "]], 
        PolygonBox[{{6518, 3565, 3429, 9145}, {8483, 4338, 3099, 8487}, {8086,
          2743, 3565, 6518}, {5336, 2746, 3848, 5496}, {5496, 3848, 3847, 
         9644}, {9311, 3565, 2743, 5493}, {10058, 4338, 3847, 6045}, {9647, 
         3848, 2746, 8092}, {9646, 3847, 4338, 8483}, {9143, 3429, 3565, 
         9311}, {9645, 3847, 3848, 9647}, {6047, 3099, 4338, 10058}}], 
        PolygonBox[CompressedData["
1:eJwtkMsuQ1EUhv9ITATDatqmJzsbcRm4PIG+QjtjJhgSbcIYr8BITGjNJW6h
pkwYMGqJtu8hxLey9uDLv86/11m3sL5T3R6SlINhOM2khxHpDC2WpRIsBSkb
lRbRZxJf4DFKW2Pkou2C9FRw396nySuSP4N+8P4OA2iQ/5eXerBBfINXpU8N
+nibePd4F9CEX7w63neqYbWsj/W7jl7jFv0hb5f4k7hOrQasMfcqVKakq3Fp
BX3jv1foRs//QueYscSss2iH2bs539l2n09v5xPSJN8RltMtLvE6UCE+DN7L
erbwyngLwfPtv2baqZ1uNsj7jDbrCdxx7+N0B7vHPrTw9jKfx+Y6CN7rCO2n
W/ai72N7/QOBgUeg
         "]]}]}, 
     {RGBColor[0.97421875, 0.805546875, 0.520078125], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUbtKA1EUHF+IH2CySTbZhCQo2ugfCIKvUks7sdbCEBTsBL9ARPAtaid2
QhQbEawiYqFRwRjwC2wEXzjDpLjc2bNzZ+ack5uZn5xrBTDA08bTkgDu2oGx
ENiOA48sTvQA/VlgtQMYTwONPHBOzmIEDBWBT3KmM0DIUyPeZP0yCZQ6gQty
1/hdJX+B93u366PUOS3a64T3FP9ViF8D+oXW2aP/ftxYNeVQnl3WDpsZ6oF1
pf9N/BQDHqjfl2NPKeMS35YTzr9O7gczLKvODL3kXRPf8N1B00t9/FHrlpr3
9HnJm19Nuk/1WyO3QPxMfES8krOX/PVGb3+pMRK6riyzBeffiVtLmnVyK3ln
U8bh0DPRHhbTrmv2XSnnDOi5FZmj+X0F7v0q7SP8w1oj8Hy0q1jGvvI/jjuz
sp/lvQvtKpuxvnw2ImfTnDQX1QfZ31Jkvnb41tTXHsrN3WmH/56RZDI=
         "]], 
        PolygonBox[CompressedData["
1:eJwtkL1KA3EQxAc/sLXKHZLLeRyi2PkMgsbWR/ABTHNFAnaCTyAq+G1hZytE
W1vFygRFo49gJaiIv2Wu+MPMzuzOf7fY6Kxvjkma4U3w2vPS57Q0GJeOE6nK
pK0p6R7xO5XWav0RvtyUflNrO5NSF+9ebhy1XfAbeh9cMeO6pD+zfkPtA61i
xhPaF3kD8tpNzx7Cz+HDxFp4tgvpNPHf7uAL8LRlHLUGeKkwf4Zf4h2lzorM
Pvl5y1p4ZsGHubMi8wjcze2P//bAo9L7P1D7Y9ZPvW/UXtBuS3uj5x3tas6z
4kZxy9XMetzgFf0scV7ss8KuJ/U+4Y/b7ufOivkH4MXC3ui5wPsPVsZMeg==

         "]]}]}, 
     {RGBColor[0.98203125, 0.825078125, 0.5442968749999999], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkD1OQlEQhU+0QWvhvYL3gITE6C7k/1m6AkMCJRSioug6IJAQbHAL7ISK
gg2YkFAYQ+E3mVvczJkzM2fOnUp3+DA4k5Twznm/VennQopS6RHcAL9QLKTO
x8Qn8jr4SL1dlD5zDIK/IscduG/yW3rurZd8Ap9dS/OStL6U+nlpBt6Ap8Qm
PR/0pOj/xa4/YnaL5gJ+RH0fu2YG/xZ0xsRO4rzt3NFzA27b7JV7tj+NE//L
KfYdtquBZi1461Xdn+Fl5LnhO+qt4G0F/xp07DZldA7gUuq3MM/P1N+DN/ur
3cVukqHxD+FQMek=
         "]], PolygonBox[CompressedData["
1:eJwtULkNwlAUM4iCQ7QkkRIOQQVTQDhT0tMgami4FI4dWACBhBiETVgAUSMK
bF6KJ8Wxv5/9atPFeJ4G4HIynFkDeBeBVw4olQGnbN/6F3tAFABN4iUxiGPi
PvEhCwx8YJTwwwLQqhL7xh05NweYlIz7a6jdVoB73vyedWBDzxO5LmdD/hEY
Djkf1zz1XvyW3CowThq9XQfGSaNdbe7fZS2jsl6YYZ/kiXzroN3KEDPL2TG9
+uoWyiyt3vSoT3nmJU3om4d4dbw61kF+6vd07Wbykr5D7de1fMqrbsPkPvKU
9w/MXDNQ
         "]], 
        PolygonBox[{{5619, 5618, 7540, 2371, 7539}, {5478, 2726, 8057, 5604, 
         5605}, {7236, 2172, 7238, 6960, 6961}, {5494, 2744, 8088, 5618, 
         5619}, {6922, 6921, 7704, 2542, 5335}, {6961, 6960, 7284, 2203, 
         7283}, {5338, 2545, 7712, 6921, 6922}, {5605, 5604, 7495, 2345, 
         7494}}]}]}, 
     {RGBColor[0.98984375, 0.844609375, 0.568515625], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUc0rRHEUPfNhYYoshvHy3kyT35QpxMJCVuR7aW9h1LBiMRl6kyyl7GVN
wuxY+StGNqKUjWIj8hUWnNN9i9u9v/vOPffc8/Kl1bmVOIABRoKxHgDbTcwe
sOFZXXLAXzew2wIkWS8ynlkvMJ8x9mLAXY/NCL9GjknGFfke2oGQ9QvrUZ88
nUAjCTxyrlGw/jsxg11AG+txYk6dYYStcPae/TdijtgfagXqzN+MLda/zBOc
uaH4wwzwxPdFCtjPAVO+8Wt/mDNOUGNfnv1mIMgCcWd36b75DrulGhiXOGd8
wwnfT70V33RK73RgeM19kGeTer6c3aO9MdYp4uTvbdr8km/nzCfRLbpJHsmr
MvOnMw/l/UGkoZd6l9l/5WyZeYwadogJPbtT99YL9lY/kzW/5FuVebho2qRx
pGi+yb/rtGmTRv0/3XLszCN5NRvYPu29JP+PM/4avyecaZPGWrR3ib1/eyVf
zw==
         "]], PolygonBox[CompressedData["
1:eJwtULtKQ0EUnCRaKEQsDDb35gF7C0HtBB9VRFFT+gUS8VFpIRoQxFIEe8Ef
0GinlV8RsZF0ltqECKKijTPMFsvO7DkzZ/bUmvvre3kAVZ4BntkJ4JX3yQgw
R/wdjM8GgS/i8TJwTnzKtx/yz1iX5iAFyqz3h4BuAVhO6Mn6RdG8QDxPT82T
foH4MLW3POS1RM0o7CGvHN/6sEeeeIOnV7SmRe01+Qy1lzlglbyeuP+DPVus
7QTnFd8lfoh69d8Tv/F0+PHHYeCd+C766e022ENaeSzS+ykz14wO8Vrivykf
2DtZM1f+KeKj1LM0U9mvKp4l/+OKd6hdaCcvY5yfuf5M3ioBjdS9yqS/bpdc
U4+8EPerPCvM8hf9lPeXuBm8K83fJL4JziO/NvF05qzaeZfz/wHdhFP2
         "]]}]}, 
     {RGBColor[0.99765625, 0.864140625, 0.5927343749999999], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFUr9LlWEYPfnjgpm3vlDiEz58L30XFNI0wa7Z4OISTZKIgosNNUQO0TUh
wjGiGqTN21AQ+GOrVb2DZaOt/gc2WGBQaCKdw3mh4eX5+Z7nec7zlGbnxh82
ALjF18g3UwSmLwLDBWAtB67TXqccpbxNfwf9B7SrtP+mwOs24DH10yagqx0I
fK3M+Rj/fKJ822P/nQDsloH+88A3yvmi/z5h/gBjb1qALxnwk5ibCfC8GbjP
/4e071HWIo7wlCv/i2ZjVGMPq8wbor5COcacR9QfEP9ubtxZygHWf0W9WnAv
sqX/ZuwZ8/9QHvMtakbKk9S9/qA+RQ4+FM3PRuIZxYl6qSfuZysxrjDrUZd/
J7PvKPL264JnP0suXhLnUidQKVoXprA3Ig+fM/smg/cwFHO0n67IufCyc8YU
jnLkX2rx7MKRrxL/TgRztEDs49T/TqjvdAM3WeNrt29hKt6D8pR/mrmmasvW
PJprOTN/qrdMezd3zQXG67k5eJq6x5m49++5d7RPOcy9vmOtCuV2Zpyrwbcg
LoQ13wEUyOd62beiOxgM3pX0GjEbcu/3TG7ut5L/dyLeVbc3GF91rgXH1ePl
1HdUo3+EfbxnPzd6PJ8wFWvMjdNE2Rfcl2btLXm2KyVzJu5ki8tK3MVeu++n
r+y4eFDOP6qeeyA=
         "]], PolygonBox[CompressedData["
1:eJwtkj9IlmEUxU9mQpmvKYm+wpvvh6/gB2aaUEkOFbQ1hREODRmUg+QgmVFE
Y0Q1REt8LhVKpS61Vi5hY21O0VqQBf0xUtF+p9tw4Z577/Pc85zzlIbHTl6s
ktRHVBNvO6WBRqm2RpovpO4OaTqRhqhle6RP1MbBx7dLmy3SFvCdOqm3XvrZ
JK1n0iRnzzCzRO83cZ28Qu0X+UYWZ0fBK6n0ldrlJM6sgi+Av3PffWaugivM
T9DbgFx7Gju8q4d4B7c15m9wfoqZP+TNrdJt8CFiDjzLTE197HvQJg1T+8b9
97h/kvvOgl81RO0c+VHe/xLcxPwbdr/viF0L1M7Tf9ws/dgl3WV+K7i6iNz8
NtvZBz6YhH4zRXAyt0fod7gsvQAfSWKnd1sTa/OQfn85OJu7PViES1ceffPd
m4em1raf2sc0PPnnzU76JekL/UtJaLpO/wN3nGiMnc+L8Mz6m+MzcE8e/Kx3
L/kx5l83hOaLWWjk3fZwhfmuUuyyBtaiL4+zt7ZJ+8nXmJ9IgoO57Mvj/E36
3eSDRL5baiMq5fDE3vhPfbZWWWjpO5aL0NTYf6yqCA/shf/ICPnpPLyy5zvw
6gm1A0m82W+3B/bCtafkV9LgYo/t9bU0uPvNfvv8/3lznCoHR3O1Zqfy+JN+
r//cKrN/AeoifnY=
         "]]}]}, 
     {RGBColor[1., 0.8875, 0.6328125], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNUz1LXFEQHaMs6OoiiShX8shb9z55K2r8qCw3XXQrSdzYphMx1kJ+gE2q
ICir/8B0fpUaghLS+FGk0GAlgh+BFImJkeg5nlukeNy5887MnDkzN/96evTN
AzMbx1eLb9ebVXJml6nZ+3qzyaxZLwC/nNkX3P9FZgc4P+P7Afy10/074jzs
2zqzM9jHTpivsD/gG0LOHeScbTVrRL5V+EbgmwOmkDGbwjmTUXwV/nJW/mep
MG+RbyCWfzAW9rRB+DXkKiFmBWfrY/G9As9+4EaA78OZbzEbbRaPsZx6684o
9369OP1BTB6+Q9RqSszeAZfFuR80oTZd7WYnwFwDe+HF468TF9rUhPkmQ86P
wJQRu+ml5WpG/MiXGPJnnQn8+1kDbFH9x6h77pV394niTkLsEv4PZ8X/dyQ/
eS174dpgD+fk550z4CxuIvXDeuudZkdOGm959czeG/H/VVE1Colqk8Me7N5Y
dZ/i/OZUfw+x26nqsD41ptbsh/bYQ2m+Ema04cWL/FiPGtBPrda99OAecc7c
D/JjPPGsQV2oT0eimXCO1ORlrJpVcD9LlY+71pBI90qsfthXkohb7SNxYG7y
pH2RKh/36FOk/KVU8+Mcz2H3INdz6h9rf8qBZym8mRkn31zYgYJTn9VI+pHD
PGadTxTHObA+ebDXS6/3sBhJB/a7UKP9OgjvbrEoLN8Wc0/9t0vsjVr4RDPi
rFiXe887a93PCfaNU17uMrlXAmY7En++P2rKfC9iacZY1rkD5/uYFg==
         "]], 
        PolygonBox[CompressedData["
1:eJwlkTtLwmEUxk8XhNRcumEg+M/XUCijmhobS6eobG4LqYYmob2pKYJC+xhm
W3QzoiG0zxCBZtAgpUn1O53hwHPuz3mOt7m7stMrIpNYP/YZEUkRePGJfIGL
2PaASA6LhUWySZGTHpGzkMgG+If8I7kWsTy4iz3gP2Md6r+xvM9mNJ3ITFRk
OWAzbqhtk6+RO8Yq+PcJkQVml+ipgONx2zWF78BBzAP3DYnssX8Cv0A+RszT
WmLesM0ogsscdhgyfgejIhdwWMT/5dgyuMmObMhufgOvwm8rYDN01h2cTulN
E5slNzZu3HL4fvY16MnQH6S/njBOyk13DpK/csZNa67Bl1ganKF/LmoaqBZL
+NP4JWezlOM5uBAx7VUj1erdmbaqaVf/ETUuR8Ruqe1E7HeqURtchcOrX+SD
37ZG6Atb7Trzn5z9TLXRm9eYVXemjfY0wFVn2qtGNWc92qs/TFG/H7bf6U3/
tyVNL/1JBjwftVs1plr+AXD8YUA=
         "]]}]}, 
     {RGBColor[1., 0.95, 0.75], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNUj0vRFEUHPsSHwlLJF73in25Tyg2Ev4BpdUQ2VerFwWJXqPTaMW/2F2V
LGupFPwDyl1K8VGZydxCcXLm3jtnzjnzXm3vcPugAmCNkTBqBXBZBXLm4RLQ
nAdGzPdTwBsjHwc2+N4iTon7zOc8d4ifGI88n1LwaNn309R5Z31JnQ/mHjkP
5OyT85MBA+LfzNqDqK+eFxNAIN6ddG/d62696r51xmriXprlhOcV4m7iPAbP
UlbNfQnGz8G60hK3HntIa8S3Y3KGzHeMLeLb4HmFVacZ+3Ee7aTaetxbWfOI
L652FFfetCq+U0/df2fe6yuzlnjidIJ3bAdr53HPmcJ+ylfNnv7TUta+Jd9u
OFOTucFoE28yd4O/2bV2p84VcVFYQ97JL/VQ/1f4+2uHXuydx/nVJ40+q05e
yfezFNiZ4/uiteWF/oXPBdbP0vPCvkhL+n9wlFTW
         "]], 
        PolygonBox[CompressedData["
1:eJwlkT0vRGEQhU9Elg2WKG5CdsNyr9yVaPYn0NIQcWu10Ej8BZVGK36F3VXJ
+q4kS4tGuUvto/KcTDHJnJkz7zkzb333YHN/SFKVGCY6S9LWlNQuSWOZ1E+l
w4q0V5bSGWmR2hO9q2mpaEiDXNohT6l14T4TBfxH+O/we+CVUtRe3Ge+OSkd
UevNSQvgM3pd8Dz58qz0wewd8VOLmnstNNYb4cneTpiZIH9D46Ecb9TB37WY
3R6VkmpoWMs7DNB/hX9L/574hZsxc16Jnbybd/AuG9RuyFvEKvnpiHScxJt+
u8DPZx4193yDPvg6jVl7srdL8Bo44c0L8vEsvNuDvfhGvpU9pFlwzLVmm/yv
Fl59E9/mKw9t39S39Z/4b6zRAf8DIIJH9w==
         "]]}]}}, {{}, 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{5621, 9681, 8144, 9451, 9450, 6436, 9399, 9400, 9396, 9398, 
         9397, 5768, 10474, 10475, 9408, 9410, 9409, 6620, 9505, 9506, 9504, 
         10572, 10571}], 
        LineBox[{5767, 9911, 9483, 9485, 10611, 9484, 6619, 7673, 7674, 6698, 
         7672, 7671, 7190, 10476, 10477, 9424, 9426, 9425, 6621, 9508, 9509, 
         9507, 10584, 10583}]},
       "45"],
      Annotation[#, 45, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{6623, 9431, 7676, 6650, 9454, 6652, 9452, 6651, 9453, 7580, 
         6435, 7579, 6649, 7622, 10306, 6524, 9407, 8242, 8243, 7621, 8241, 
         8240}], LineBox[{6646, 7678, 7545, 8277, 10651, 8276, 10653, 10652, 
         9389, 10439, 10438, 9388, 6679, 9482, 8279, 7620, 10305, 6521, 9423, 
         8238, 8239, 7619, 8237, 8236}]},
       "43.5`"],
      Annotation[#, 43.5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{5337, 9518, 7709, 8493, 8492, 6051, 9219, 9220, 9215, 9218, 
         9217, 5620, 9679, 9680, 9318, 9320, 9319, 6523, 9466, 9467, 9465, 
         10555, 10554}], 
        LineBox[{5495, 9643, 8089, 9449, 9448, 6399, 9386, 9387, 9382, 9385, 
         9384, 10461, 9394, 9395, 9313, 9315, 9314, 6520, 9462, 9463, 9461, 
         10553, 10552}]},
       "42"],
      Annotation[#, 42, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{5338, 6922, 5335, 9464, 7703, 6522, 7234, 9317, 7233, 7546, 
         7239, 9216, 7241, 6052, 7237, 7710, 7236, 6961, 7283}], 
        LineBox[{5494, 5619, 7539, 9460, 7541, 6519, 7543, 9312, 7542, 5725, 
         7496, 9383, 7498, 6400, 8058, 8090, 5478, 5605, 7494}]},
       "40.5`"],
      Annotation[#, 40.5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{6103, 7284, 6960, 7238, 6048, 7242, 6049, 7240, 6401, 7235, 
         10057, 6046, 9316, 7702, 7704, 6921, 7712, 7711}], 
        LineBox[{6365, 7495, 5604, 8057, 8056, 9185, 6369, 7497, 8235, 7544, 
         6396, 7618, 6394, 7540, 5618, 8088, 8087}]},
       "39"],
      Annotation[#, 39, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{6053, 7716, 6054, 8497, 5831, 8488, 6047, 10058, 6045, 10056,
          9645, 9647, 8092, 8091, 7708, 6050, 8490, 5849, 8579, 6104, 7771, 
         9536}], LineBox[{6397, 9170, 6398, 9183, 6861, 9179, 6395, 8051, 
         8084, 8086, 6518, 9145, 6367, 9124, 6368, 9147, 6845, 9142, 6366, 
         8019, 8054}]},
       "37.5`"],
      Annotation[#, 37.5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{5359, 9537, 7770, 8578, 8577, 5848, 8489, 8491, 7707, 8093, 
         9517, 5336, 5496, 9644, 9646, 8483, 8487, 8486, 5830, 8496, 8498, 
         7715, 8495, 8494}], 
        LineBox[{5477, 8055, 8018, 9141, 9140, 6844, 9146, 9148, 9123, 9144, 
         9143, 9311, 5493, 8085, 8050, 9178, 9177, 6860, 9182, 9184, 9169, 
         9181, 9180}]},
       "36"],
      Annotation[#, 36, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{5341, 6924, 5339, 7718, 7714, 8503, 8502, 6718, 8511, 8513, 
         8485, 8509, 8508, 6963, 5357, 9516, 7765, 7706, 8563, 8562, 6731, 
         8571, 8573, 7773, 8569, 8568, 6981, 7304}], 
        LineBox[{5492, 5617, 10197, 10199, 9168, 9175, 9174, 5979, 9137, 9139,
          8053, 9635, 5476, 5603, 10192, 10194, 9122, 9129, 9128, 5963, 9067, 
         9069, 8021, 9624, 5463, 5593, 7469}]},
       "34.5`"],
      Annotation[#, 34.5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{6136, 7305, 6980, 8570, 6100, 7772, 6101, 8572, 6730, 8564, 
         6098, 7705, 7764, 7766, 6962, 8510, 6058, 8484, 6059, 8512, 6717, 
         8504, 6056, 7713, 7717, 7719, 6923, 7724, 7723}], 
        LineBox[{6329, 7470, 5592, 9623, 9622, 8020, 6333, 9068, 5962, 9130, 
         6361, 9121, 6359, 10193, 5602, 9634, 9633, 8052, 6364, 9138, 5978, 
         9176, 6392, 9167, 6390, 10198, 5616, 8083, 8082}]},
       "33"],
      Annotation[#, 33, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{5373, 7803, 6982, 6137, 7307, 5865, 8575, 6102, 7769, 9533, 
         9534, 5509, 10073, 6097, 8560, 6099, 8567, 5851, 8515, 6060, 7722, 
         9519, 9520, 5498, 10060, 6055, 8500, 6057, 8507, 5833, 7246, 6061, 
         6927, 7244, 7243}], 
        LineBox[{5462, 8017, 7132, 6330, 7472, 6828, 9065, 6332, 9048, 6331, 
         9063, 7155, 8049, 8047, 8015, 6360, 9127, 6843, 9135, 6363, 9107, 
         6362, 9133, 7189, 8081, 8079, 8045, 6391, 9173, 6859, 7538, 6393, 
         7187, 7536, 7535}]},
       "31.5`"],
      Annotation[#, 31.5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{5344, 6929, 5342, 7726, 6926, 7247, 5834, 7245, 5832, 8505, 
         8506, 8499, 10061, 10059, 5497, 5340, 9521, 7721, 8516, 8514, 5850, 
         8565, 8566, 8559, 10074, 10072, 5508, 5358, 9535, 7768, 8576, 8574, 
         5864, 7306, 5866, 7303, 6984, 7300, 7299, 6993, 7318}], 
        LineBox[{5490, 5615, 7526, 7528, 7186, 7529, 5977, 7537, 6858, 9171, 
         9172, 8044, 8080, 5491, 7188, 9131, 9132, 9106, 9136, 9134, 6842, 
         9125, 9126, 8014, 8048, 5475, 7154, 9061, 9062, 9047, 9066, 9064, 
         6827, 7471, 5950, 7462, 7134, 7990, 5453, 5582, 7456}]},
       "30"],
      Annotation[#, 30, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{6159, 7319, 6992, 7301, 6133, 6983, 6134, 7302, 6741, 8647, 
         6131, 7767, 7799, 5371, 6985, 8589, 8590, 8561, 8592, 8591, 6732, 
         8584, 8585, 7720, 7774, 5360, 6964, 8523, 8524, 8501, 6065, 8525, 
         6719, 7248, 6063, 6925, 7725, 7727, 6928, 7733, 7732}], 
        LineBox[{6297, 7457, 5581, 7989, 7988, 7133, 6301, 7461, 5949, 9052, 
         6326, 9046, 10179, 10178, 5591, 5461, 9621, 8016, 9060, 9058, 5961, 
         9111, 9112, 9105, 10191, 10190, 5601, 5474, 9632, 8046, 6358, 9120, 
         5976, 7530, 6387, 7185, 6385, 7527, 5614, 8078, 8077}]},
       "28.5`"],
      Annotation[#, 28.5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{6067, 6933, 6068, 7251, 5836, 8522, 6064, 8518, 6062, 10063, 
         5500, 9523, 9522, 7731, 6066, 8527, 5853, 8588, 6106, 8581, 6105, 
         10076, 5511, 9539, 9538, 7778, 6107, 8594, 5868, 8650, 6132, 8644, 
         6130, 10089, 5519, 9550, 9549, 7802, 6135, 8652, 5874, 7322, 6160, 
         6996, 7834}], 
        LineBox[{6388, 7182, 6389, 7533, 6857, 9166, 6386, 8040, 8074, 8076, 
         7184, 9116, 6356, 9092, 6357, 9118, 6841, 9110, 6355, 8008, 8042, 
         7153, 9113, 5960, 9059, 7152, 6327, 9036, 6328, 9056, 6826, 9051, 
         6325, 7983, 8011, 8013, 7131, 8990, 6299, 8976, 6300, 8992, 6815, 
         7460, 6298, 7122, 7986}]},
       "27"],
      Annotation[#, 27, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{5347, 6935, 5345, 6930, 7249, 6932, 7252, 7250, 5835, 8520, 
         8521, 8517, 10064, 10062, 5499, 5343, 9524, 7730, 8528, 8526, 5852, 
         8586, 8587, 8580, 10077, 10075, 5510, 5361, 9540, 7777, 8595, 8593, 
         5867, 8648, 8649, 8643, 10090, 10088, 5518, 5372, 9551, 7801, 8653, 
         8651, 5873, 7320, 7321, 6995, 7835, 6994, 7313, 7012, 7333}], 
        LineBox[{5488, 5613, 7521, 7179, 7531, 7181, 7534, 7532, 6856, 9164, 
         9165, 8039, 8075, 5489, 7183, 9114, 9115, 9091, 9119, 9117, 6840, 
         9108, 9109, 8007, 8043, 5473, 7151, 9053, 9054, 9035, 9057, 9055, 
         6825, 9049, 9050, 7982, 8012, 5460, 7130, 8988, 8989, 8975, 8993, 
         8991, 6814, 7458, 7459, 7121, 7987, 7120, 5441, 5572, 7430}]},
       "25.5`"],
      Annotation[#, 25.5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{6181, 7334, 7011, 7314, 6156, 6997, 6157, 7315, 6751, 8718, 
         8719, 7800, 7829, 5384, 6999, 8661, 8662, 8646, 8666, 8664, 6743, 
         8657, 8658, 7776, 7805, 5374, 6987, 8604, 8605, 8583, 8609, 8607, 
         6734, 8599, 8600, 7729, 7780, 5362, 6966, 8529, 8530, 8519, 8533, 
         8532, 6720, 7256, 6070, 6931, 7734, 7735, 6934, 7740, 7739}], 
        LineBox[{6273, 7431, 5571, 7960, 7959, 7123, 6277, 7437, 5941, 8979, 
         8980, 8974, 10163, 10161, 5580, 5452, 9607, 7985, 8987, 8985, 5948, 
         9038, 9039, 9034, 10177, 10175, 5590, 5459, 9620, 8010, 9045, 9043, 
         5959, 9095, 9096, 9090, 10189, 10187, 5600, 5472, 9631, 8041, 9104, 
         9103, 5975, 7525, 6383, 7180, 6381, 7522, 5612, 8073, 8072}]},
       "24"],
      Annotation[#, 24, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{5398, 9566, 7859, 6182, 8780, 5882, 7316, 6158, 7015, 7831, 
         7832, 5529, 10098, 6154, 8716, 6155, 7000, 7830, 6998, 8663, 6140, 
         8645, 6141, 8665, 6742, 8659, 6138, 7775, 7804, 7806, 6986, 8606, 
         6109, 8582, 6110, 8608, 6733, 8601, 6108, 7728, 7779, 7781, 6965, 
         8531, 6967, 6072, 7738, 9525, 9526, 5502, 7254, 6069, 6937, 6071, 
         7258, 5837, 8538, 6073, 7743, 8537, 8536}], 
        LineBox[{5440, 7958, 7933, 6274, 8941, 6805, 7435, 6276, 7101, 6275, 
         7434, 7119, 7981, 7979, 7956, 6295, 6813, 10162, 5579, 9606, 9605, 
         7984, 6296, 8986, 5947, 9040, 6321, 9033, 6319, 10176, 5589, 9619, 
         9618, 8009, 6324, 9044, 5958, 9097, 6352, 9089, 6351, 10188, 5599, 
         9630, 6839, 6354, 9083, 6353, 9100, 7178, 8071, 8069, 7175, 6382, 
         7524, 6855, 9163, 6384, 9154, 9162, 9161}]},
       "22.5`"],
      Annotation[#, 22.5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{5486, 5611, 10195, 10196, 9153, 9159, 9158, 5973, 7492, 5974,
          7523, 7174, 8070, 5487, 7177, 9098, 9099, 9082, 9102, 9101, 6838, 
         9093, 9094, 8002, 8038, 5471, 7150, 9041, 6322, 9020, 6323, 9042, 
         6824, 9037, 6320, 7976, 8005, 8006, 7129, 8981, 8982, 8962, 8984, 
         8983, 6812, 8977, 8978, 7955, 7980, 5451, 7118, 7432, 7433, 7100, 
         7436, 5933, 7428, 5932, 8898, 8900, 7935, 9588, 5432, 5563, 7416}], 
        LineBox[{6201, 7352, 7029, 8772, 8773, 7861, 8776, 8774, 6761, 7329, 
         5883, 7317, 7014, 7833, 5385, 5528, 10097, 10099, 8715, 8721, 8720, 
         5875, 8667, 8668, 7809, 9552, 5375, 5520, 10091, 10092, 8654, 6139, 
         8660, 5869, 8610, 6111, 7784, 9541, 5363, 5512, 10078, 10079, 8596, 
         8603, 8602, 5854, 8534, 8535, 7737, 9527, 5346, 5501, 7253, 7255, 
         6936, 7257, 5838, 7260, 6722, 8541, 8542, 7742, 7745, 5348, 6939, 
         7749, 7748}]},
       "21"],
      Annotation[#, 21, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{6078, 6943, 6079, 7265, 5840, 8546, 6940, 7744, 7741, 6074, 
         8543, 6721, 7261, 6076, 6938, 6075, 7259, 6968, 5364, 7785, 7736, 
         8615, 8614, 6735, 8622, 8623, 8598, 8620, 8619, 6989, 5376, 7811, 
         7783, 8672, 8671, 6745, 8679, 8681, 8656, 8677, 8676, 7002, 5386, 
         7837, 7808, 8725, 8724, 6752, 8730, 8731, 8717, 8729, 8728, 7016, 
         7856, 7855, 7013, 6177, 7330, 6760, 8775, 6180, 7860, 6179, 7030, 
         8778, 5891, 7354, 6202, 7031, 7880}], 
        LineBox[{6379, 7172, 6380, 7520, 6853, 9157, 6854, 6377, 9152, 6378, 
         9160, 5972, 7493, 6350, 7176, 8036, 8037, 5598, 10185, 10186, 9081, 
         9088, 9087, 5957, 9031, 9032, 8004, 9617, 5458, 5588, 10172, 10174, 
         9019, 9024, 9023, 5946, 8971, 8973, 7978, 9604, 5450, 5578, 10158, 
         10160, 8961, 8966, 8965, 5940, 8939, 8940, 7957, 9596, 5439, 5570, 
         7425, 6268, 7099, 6270, 7429, 5931, 8899, 6255, 7934, 9587, 6799, 
         8896, 6798, 7418, 6254, 7084, 7932}]},
       "19.5`"],
      Annotation[#, 19.5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVzk0rBFAUxvGHfAEyyMs0MyUfwo4iUZiFlyRmFsqGlYXVlGZlb0VCVspG
JAt7O/kGM2TyJbz8LJ7+957zP/fccn2/uteVZFE6/UlpJPnE2WJSdK6PJm8D
yTa+/rOc1GRDqhPJsjQKyTR/SibNPA8mW/wW/4bXdr/GFtb4x/yZ8WRpOPlQ
O9F7x1tcMN/0zpHsyI96W32N+4UZ8g/8Ve/gOv+cdyYN6dWvcQ/sObVn1Z4V
udTr0xurJN/+de1/Ffdd8yW8cL/iF2STf8ef585Jt11P+j34iIdmHvBems4v
+AdFOzKF
         "]], LineBox[CompressedData["
1:eJwVz70vQ2EYhvFbGpuFRIjPINIYjSzSsEsYMDVYffwFPoJVGMpfQU0qkZQI
i2gnu1Uqarf5Ga7c57nf67znOWMbu0s7HUkWsdWbfGFlOFlFYShZk8t9SVm+
DCTPExLl0eQE2/xOXsl5o9/7g0lTzptv+fvcN/Mcdx2b+OYs6Nuy+u/qziaT
c7y7r15MrvSznGtZkjN26JKX5in+EfcYr/wbfkUf5xey6d4ipyE/x5MD3Yc8
lC1ZsVfBfnvmO043twf3nuvOH1DDEx5xyv/1jxN2aMsq72ckmfbtGlq6P2YH
Na4=
         "]]},
       "18"],
      Annotation[#, 18, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVkLFLQlEcRr83R4vYe1IqvEL8C8SINkFnW2oQkRdkT1EJVMRdodHVSXDQ
mnRxTsTFNRoltE2hSZ1EPA6H7977nd/lvmc7pYeiIekRwhfST1BqXkkJnzTz
S+eW5F5LDc6inNXIW3JE93YpZeki7IfMTSHAHXWcHn0f8qw/yYMpdck96Wcm
CB38p5B0xkwbymGpCh46C0zY4K9saQ1N/CS+gduCAm4R5nR/sIR//AE5hDx+
An/rld7xM7gOdOk+oA+/+GnetSAr5B3vLTC3Y+ae9SuOCykY8y9yZIzvfsb9
Yh/AiePbZJbum3tcugndzemM9QscAQtxNwI=
         "]], LineBox[CompressedData["
1:eJwVzzkvBUAYheFjSSyNSog1ri1RSRQSW2JNlDQSW0QttAo6foGO0Kp0RGgk
dPwBzS1d21UrbuNRvDkzc95vMtOzvbe8W5VkBcPNSbkruWhP1luT747kqC05
LSTH8kd3pdvQlXWFluRWt2N/I88Gubh3zygq/Dv+L3eIW92ZnLjng/uFIkp4
wwtv0cxAd9KE2t6kBmf8BtmICq9e1uGVv8Sf5vZhytkkLvnzcgEjmMUMvvmb
/O1/F4fODnDNn/GuOe+bkJ+8cTmGIn8D5/3Jlpln/9w3s8xd1b/bV/tbST65
50H3KDd1H86iW7dewx9RoDZx
         "]]},
       "16.5`"],
      Annotation[#, 16.5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{5630, 6864, 6653, 9489, 9490, 9486, 9488, 9487, 5769, 10574, 
         10575, 10573, 10577, 10576, 6687, 6689, 10630, 6688}], 
        LineBox[{5718, 6876, 6667, 9497, 9498, 9494, 9496, 9495, 5771, 10579, 
         10580, 10578, 10582, 10581, 6690, 6692, 10631, 6691}], 
        LineBox[CompressedData["
1:eJwNz78rBGAcx/Hv/QcWufwMXWIkYnBdWWxyRizWC+Ml07nRj0khg03qWM4i
F3ULZ2VVFAk7ceG8hnef53k+777P83QvLGeXEhExi6lkxF17RLk5YgAPnREH
bRHJloh358XWiL2eiH1sYxc7KHG+uV84ss6Z88Ff51f0G7KuO9Mt6j51/WY+
6lbs72VeHvZFVN2bxmoqoqkr4ln3hCH+j/xFHSfcY9S4kyjwU/yG7g+j/OHe
iBEMosI9xy13i7uJDL/k3jH9BH+8I+La/tU7r+Spd+d1ZZnR3Th70dVk2j7h
HznziubM4ZJ7gSp/Xj9tZoM/Y53FG3eNV8A/EEZB2w==
         "]], 
        LineBox[CompressedData["
1:eJwVzz0vQ2EYxvGbwdRYvAZp0kNVWEViECsSFcWiW6XSnDRsFgaL9AP4ABKJ
oaNIWrMEsYqVxdtGvHwAP8M/1/3c1/8855xcZbe00xERZWwMRjyORBwPR1zL
GzTM3QMRd+aMrCURKW6zEdV8RLYvoolz/bTnD/gz8sK5i1/i7ttN2qVySjZ1
6VDEim7C+cRdLbRR5+Ttx9Hz36OACj+RozjinSLjvWX+Vy7iG0/4xQ82+R/y
Eym3gU5+kd+2e/VtZ/JNXspV/p7venGe5dT5c7Kle+73r7or3bzdgm4Rh+5b
K0SsY4u3jSru+TX+g0z4S9z33ogxc9G8jD+Q8zcJ
         "]]},
       "15"],
      Annotation[#, 15, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{5798, 6890, 5983, 7192, 9530, 9529, 6624, 10478, 6094, 9329, 
         6532, 9328, 6531, 10316, 5629, 9331, 6534, 9330, 6535, 9332, 6095, 
         10071, 6096, 9531, 9532, 7194, 5984, 6704, 6703}], 
        LineBox[{5829, 6919, 6021, 7227, 6600, 10430, 6601, 10431, 6599, 9381,
          6603, 9380, 6602, 10432, 5709, 9372, 6591, 9371, 6592, 9373, 6590, 
         10566, 6676, 10565, 6675, 7224, 6017, 6715, 6714}], 
        LineBox[CompressedData["
1:eJwNz78rBHAYx/HHH8Am4vy6I2WxyF0i5R/wIwx+DRYbCxJ1zAZyyiBWoSgD
IQPFwOy6RYmSK6skSV7Du8/3+fR+nvo2TM4MTJdExBR6KiNuEhFH5RGNWKuO
WEde94hsVURB9vNy+j65KysqIraSESPmTbnebBenbrTiozbikFe028D9lKtu
XXKvcIwLnOOMV1YXUYovewtuPutz/Fe5ZM7LRfkiH/gpbhK33hv6RE3ENr9O
bprv9TlZYy54d3E7UY99fVsqYo+fkYfmFnkg0/KdP+YPE9wOzOvmcMLvdq/H
fzLyjZeW7Xjij2KnKWLczp1bs3b6uH+8Fd23fNMP8q/dGpLD+NX/oNe76MYy
N4t/leZEag==
         "]], LineBox[CompressedData["
1:eJwV0LErxHEYx/HnSHbunBCRc/gjZEAMyt1NDBRn4pxN0S0msRkwGBR/gRgu
Rs4fgElRUlKK5TLyMrz7PN/neT/fft9f72I5v5aIiGXMt0d8d0WcdEY8yUN5
hBf1M1rSEXdygneg/9AdsdURsYntvogx/ZrePTKpiB3OFf8aFXWz/XN1k8zx
C6hyFzIRaf4pKtmIrHumzYbkjPxtU8uU8xl/lj+HY/4Gv1W/xzwp+2WdX++N
aHTe5ee5Bezzy/yE/qd5w/975Re/Kt99V5k/yZ3CHn+JX8S5+SUu8Moveseb
HPGudTs/yYhR9Yr5Koqoua8kx/yfcdw4D3Ju5Yr9R/ursoQB/Qw+3DMs8+7M
4Q8YsT4A
         "]]},
       "13.5`"],
      Annotation[#, 13.5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwl1ndsl0Ucx/EDRFBAhqwyy94mYBmVoSAtDigbQYaAOAKhrJiAEzAuMEAJ
UAqEIaBxsKIiLZu2zLYCQhGCiQGkDFnKKtPXE/9453P3vc997p577ve0dUaO
65NcJIQQVzSEpU1CuK6dWT+EbGRhVuUQLseGcAUXcQl/R+2KIXRuFEIXxNYJ
oS7q4Cv+reZtw/nGIZzDiZgQFske2TCEYcZna5cwPp6WpMXRgOdRekFu31oh
NKsewjHeiTVCyKfj6L4qIbRQ30u7VQshEePVJ6CJeinzG9HR+tMqWVtWuwYh
dJe3x5xk+/tL1rvGz+t34T1H+8rpg83GL+r/SC/QDNqTp5ismTKSUah2G4P5
H9CHuIR7uIuh/GX4v+b9Ai3qhtAco/jjaBvUQSu0RDJ/Vf4M3pXor9YPY/gH
0kFIwisYgA/59/Ptwya0rxrCWPWJ/JNwQG0GT0f1rZ6zrOf42HiC/lT6uff1
GdZasyHm8cY7t/n0BP9xfCRnKv6M9qTez9yT6jGyrtFqdJX6Fe3LiPWOh3l/
CXK6Yaz3mkiTaQfn3cF7T9PO4znEexgbjK/HPOOPOLfiKIJiKIqOcp+2zzhU
0K+IJ7GUf6e8XThq/nK577jA+7QPYD9SeR7jfRyPoiRKoJPM1vLaoJJ+FVTG
Mv5MeTHaSzxbW+OLaS+1RGOzrFHV2Fb3/gP1LfR9Wosvhf7AtwZJ6u/xTlXb
pZ2Jcugqo6jzSqAbPfsv+Bnp2IRtzjdLVjbS3NdFGOjdxNvvW3S1/irUl10P
pyK/ednYiUzsQn/5Ja0zx5opmI3u9jKXbrS/vnSufgH9lJaM7gLdIPOIWinP
OE57kJwR/AuMNeVJpaWNbVZbaGwQ76vIq+3M7eusPT5rr+1441GNtwaqYzl/
lnnZyPduVsif733laOchF2k8g+UNwa8yc2QWyHxO5jPy2qOmrNqohRX8m83b
gnQcd68y6BD1JjKa4rQ5Z3AKufLy0KOmd4QbzijJM/XW3uaeb8dpZ3pX/Qzt
pd7TeBxtjUL1XPu6FX1b7Os+nVDPbw7JyDJnEl0nZz126Z/hyaTx5neW1dL4
N/rt5cy0ly9xSNYm+0tHE+Mt0Bxt+W/7rRZG3wr+qbzdePeggryK2Cu/Em0V
3UOaZt3qtKV+oLuNlza3ozk7sNIaq3FE5jHko3H0raM/4Zbf+kTrtOFNRxrv
m/a7xtjbdD2Nje6OdzJY/1v5F8yZbt1pmB99q9T/UDuPsbKekrOEL9+c4d77
DIxAun2lqB9SP4jycrPo8+bPUT9s/hSZk6OzVC9lfJp6lnoNmevMX4uzzup3
+yygN/VHy75Bx9Ca7kLx6L5q57gfuX4feVjnnqxFivGH7kmIvt30Ae6jovwV
+F7Odxiu9hqW8G+XtwNHzF8mt7p7vFt7L/ZgDs8d3ru4hULcRgl5qdHfBHmr
MUxtKBbzb5NX3h7Sor9tnmUhPePsyhibaY1y0X3nfUN9OR0VfVvUrtGd9Cqd
ol7AP5kekncQV5zdQ2smeeae6IHe6IVPnEdH2Z2i7zNK88Y45wRjieiKF9AN
03hfoi/jRUzXvyf3ojl36TF7PRo9k32kWj+H9o9+c3QAHUJP2s9Qut5aC3hu
4HXtO+bnmz/PWG3e+fSmsQz+2Z7nX+3ruIp/cC3638Pf9Ga8zVHG85fFE1jE
v8W8rfit/v//y/wHyMttBg==
         "]]},
       "12"],
      Annotation[#, 12, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwl1XlM13Ucx/FPm2liuTQFDUlBjh9JyGZ4YWIzTTRXacvmgahtDVTw7hDS
vFHMjq2h/dExFZduVtY/mUeHokiWiqbi8AS12qrllZvV47v+ePL6fj7v1/v4
fT7f34/kqWVjSu8KIVz158OkELITQ2ifGkIWLe0WwpLOITzzUAhPY29yCHUJ
IdwnHusawr00g84Tm4tR2M2zC889GEKF/Jb4EF6lj6v3Cn0ZVWre6hTCyLQQ
5sj5Tc2v5fzBe5ve3SWEG7QVnZURwrv8a/mqUKROa/uF9A7PRFpjfxNWIV4s
OyWEafrn0i7WPWgC7UNn8u/kK6OPRPVpFt1qro36TDFTEXbxZNsfL+ce85XS
QdbT6VIzLcEn/N1Rz1upzm417uetp+X6L+ddgTcwUu4y+qzzGujcxtA8Otb+
Kec+hp6Ut0O9XvhIvSrxj+mn4tuxQs2V+F2/EWIFiOsRQr/0EAY4uzti2/kT
zdYNLWLrzBPznIk0ZCAdr/FfioXQjIu4jBZMNlcyTUH/qC4G8uaaLY/mRWv0
ywyhL4r4m83Wgg76z7ZXztfGGV403yhss/cUbWee4XLzxd/hP2+ORPm3e5qX
JvJ1wyq5lViN/XJqsQ/fo05+PQ7hIDrYG0s70h/oYfyIudbPd/cOqjeOlmMh
tqhZbq+Gbka65zTM0z9VziS5hag23zhzpttLw0TzT8BltJW3XGyOvHif+Trv
NcxXI9+5DYnOUY0ivMA3yNk12DuOY/gZJ/ATfyM9g5M4jVNYIecxZzMYgzAE
+dH3wF1eMcsvuIrxfK3d9wQas85AofkmocJnvSY2Ws56s21AzKy9zJ5BM2mx
9+wGTx+xvd6/v+g39B/3kWK2ejXq+A5G96D/HrFaegCzeMqQr36WvCH0QjSL
nPHqXvScLd4bqdgsN4duimaI1DqJtz8G4AR/F3XW2f/W81u0mndR1Fu9B8TW
Rv3F3qTx1jl6/utsF1jvsx+nTjvs4d9oxrflzxf7QqyN/bb40vNnvofF9rfQ
Evo5rYy+O/Ql68u+X9cxW+9ctWrkNOsz1X230Pet4/W+5LkzrZS3Gk1yvtJj
J2bIPWWGM2jEaaziWUNH67HScyP/GaxV77vot5bukLuUrvb5KhGn/uLojuTE
3GsmfuW5qX5n937d3J1oB3U7otk7sEZOT8+p6IEUJONP3rPer3NowgWcxxF3
XeCzjcQIdOVLM097dVv0aUaW/V54L3rH9Vjg3S4RP2zG4uh9tTcY583WyN/K
3jKxc9Zn0YQcuRP1m4QJWGe9Xs4GTMNWOVPpNvoiPa3OFLrFer9+NXS+Gart
zXQOMzBUncXqTPdchlIssi6mr9MSutAcf7vHBjMcQ678RzFZvVqxItrPui8q
5GTq8TAa9D+OW3ITnMdNesz6KGLiGUjnP2SGehxAHQ5Gv6XO8AlnPgxD8SSG
R++Auzmnz4XorNDb3V7hvaH2UbMdQVz0G4NDvAViI/BB0v//n/8DYXAtqg==

         "]]},
       "10.5`"],
      Annotation[#, 10.5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwl1WtM11Ucx/EDKPiggQaIoHLT5JKFOENrWG2WWZoPspZQW0uz7LIK856z
OZ90UdSwrDbJBEO5KmpkkmmEubnWZQu5qdlF6wE8sNLpovX6rQdvPr9zzvf7
+X7P+Z3fn5xFLz30YkwI4bA/I3JDuJoTQjwdjifHhpCUGkJ9ZghPeL46OoRN
40K4QousT0Eh1uSFsBo7xSbisZtC2CdnhrXpCGkhNMqLoRV8mj034TXP2eK/
EduOZWIrsDwjhBV0JV7A3WNCWBXN44H0EG6byBcluN9a4/gQ5tDTPFv45aOL
3wKxMdnGk0K4Vc/X+b6vZmV+CFtQKb9VzBbaQnv5bBM7R06sPcRgv/nNYg9E
Ki7V8130EeNSeidmYituVn8ypqtTgjZ+7eq+xW8TOrNCOIl2/d2OT80dQRuO
4jMcE58o70hCCMW8dqlXxXs7CjznY7HaDxpn0CqxN8jbZ74ezfpvwQY++daq
ncsh76apQI9xIYynWcjEVOvzxZWLL8NM+aVI5rfDWjb/AXqCxjnPYWiyr169
D5q/Q39xznMY5hnPRQe/Lvln8CPqo7uApXJ6jHvRjX704Svxx6MaKOVdJq4P
R/VRbY8fYmF0zsbL9FHmOYdeFt9JR+qpWd5wGo9UpOAnc/fZYyptl/s5auSe
lLOL7sZHWKB+jP4fphP0k4tXxJRbK/OuynHBeqF6Nc7yGK2l/0wIYQinrZ+y
v69x2DnvtvYJbUO+9TyUuPd/ubt/I1P8erH32mMnRvE7zj8tOgOaQdOxQ99X
ou8x+hblZGG2+A4x3eZ68D360Iut4oe8j39xUMwI8a10WnTPsEM/76FObAPq
kaWvbfRt/O7MvpTTgZf1d4IO6n0AC+1phvP4TcxFfMD3B3Xmm58WfYPO65r4
NHcozzle08sk2metH/n88nBR3JC9rfUu1mCkuFne0SXzZ8WdxzkcinpHkvk/
1E+kU83PpkW0GFMw1r724iDvVtTxuszzDfon3atWHQ7opdF7bUIDfsUvGOk8
auke1KAOH2O/+G/lfYdiPs38ktWZaM/x9F3U6q8GCXr6WY/xdKP4s+bK7K0c
zzmP5/E0v0q5S+izxkvRwPMe3+NTnpdgkbUNYhbTZ6IcLOTxKPp5ruMdq8Zo
+y6iydFvEVJwPcV3LTfVb8YpcXt4bLePd1CF8zgX7csZbdT762qfNa7mu4Iu
R62cndEdp5fseRy/sbjGe668eRgV3QFndov6N3oujL4/OpkmRb9/tIf2ohsX
jNfzGHTP1hq/abyKrsFqzHKPBtQKap7RSxcKxKyT8yo263Wl+7YCX/i/NMBn
jLx0pEX3IPrttlaJCsS5x7F4nGdC7v//z/4DGBwLeA==
         "]]},
       "9"],
      Annotation[#, 9, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwl1WtM11Ucx/GjgIX1oFaaXFSwFIilabW0tLZutlULSewCT0SguyigrRRp
xBIUL5WylQIF5kRcwaY9KIOyHmRby3RuYnFJSmuRiIBSGvX6rwdvPr/zPd/P
93vO+Z3fn+TcwszlY0IILf4kTgohfVoICXQ+LUoIoX1KCG3Yg1ni2eIvxYfw
MnKnh/Cl+K3iOeKxN4RQTO81LqT30IqUEJonhJCMAvnfy780NYS/kToxhO8S
Q0ijk2aEcFnskbgQNtwUwm5aRT+kqXJWqH2Hnrfjo8khfMJTlSQXB/k+RxsK
9bg2LYQ/+RrpcuPFns+pNVZuFKr5O62rC/03hjCAczglJ1p+DLr16UKU57P8
0Xyz9RwVm0NnWm+M2GN4FGvEetX9JbI2+bWpIRygdXSBua3i3fr1YESvOHN/
RfrS661zIiZgnX22qfcF2vEwbwrvQpqp5yLcpuYclMltpvvQIt6Kcnmz5b9B
v+E/jBg9o1EuP1mPaUjCkN5Z9ryCJsrL5n+cbzt/Bj0k/qnaX0XOT6wfFeIZ
chdhMqZEnsVi3JVu9OBr+Zni+9U7gAG+X/VZgicx1VyOeCZfjblk4yTc7KxX
8p6WM0yf8j53iP1grsLaj9BjOIpDvO28c72PeWjELnzG9y7/QfoeLaTx8hMi
74knneeSc5+OGYjX406U6pPhjh63/vPu7kZ39yytpoO0Ru0BusE4Sn4i2uXO
sq5j4iXi48ReVec1tKnV4MyLxI+YL6ZHaYr8Vr4841rjfLqPVqrfRJcZ9/pG
BjGE3XI3iW+OfHf2sJVuQZ+19/ouboncD2cZzGXY6wt6N3i3fZ6voS8an1Sn
A03Ge3FRrz10P2+z8zhAW/hb8TH61Cu0zj/oemfYqNabdBetpAvpkL1GmY9G
pRqJagyKncf9atyHIrHj5h7y/CAewPu8JfZUjCHruE7OBWscxm9qncFa51Zn
b/Wolb/SHdxJi+jV8tereRU9o9dppFjTXebL7Gm+HqvUKMHz8p/DMnupFa9H
HcbzblF72NwFDGEEF5Ert0D/Z5Ef+X0wLpebx7ODdydOqf0zlprrpj1YwpsV
6eV5nfVstp41tBRrsc6ao9RYLKfa3BN0E31d7TL0G3fyduGEs+jAWPm/O6Mx
9Ef73Ch/rv6X1fsH/2IUS80/Y+/ZeBrpPDk0jX6r72GU4qQaHTiBmWqt5q2K
fKt6V9LtPDXYhlXm6uW9ot9q7NWjTo0m2qdugb1Pse533Ku3Eevejncvr6Qf
yGvAqJo/2UcnxvHFqxlD89UvQB6iI9+A+mNowDbfTVbkNxtvqXuFerHiI3x3
03jjeTSOFlhHPhZM+/9/13+IlRMH
         "]]},
       "7.5`"],
      Annotation[#, 7.5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwl1GtMlnUYx/HLIs2UN7UQRBBBKBV8IbamVp7aGtpmB8utNgwr8RW1Dpup
4IuWm0kbuk4v2nwgEU1AhbDEXFaWdgLb2nJrKYIu8QCItSiz+tzrxff5/Q+/
6/pf/+u+72fKquceqRoVERv8tGZErM6LaKGVdF5WRHNuxB7UYX5+xH2onBix
iC7GXCzEAkyfGpF1e8QXvJ9jpbVyVPE/Q59FBZ7GKpTy5/Of4D2CddZewcv8
NXQjnk/yZ0ZU0wfVc5LvJ3ShTZ2vqXMTOiZHHMAZOfv5euh52jUpYqn4mjsj
mszX02pswHTx15w1g2YVRVwXf5kOYgBl8q6bFrHNuI5/KyYgA4/LlUlX0AXO
uo3eT5+gC+liLMLowohfciJOodhZPfQ0nuT7kHagxHo7bcP25Bxx2zDVuAAV
vEvMM+lWnnvVU2i9CI3GO1DtDr/aq6FN5jvRYL8eP8s/m96V1G19BZbwdfKX
0eXmj6HEfjHKjN+0t9fdc5zZb3yQhp6PQkq+bs+thfctdb2NZXgYDyGX94KY
ixgxruc/wd/K/479d/Eo5plX2V9uPJle4u+kNzijQcxe+/vQpp52LPM8Rt8R
MQbfGWciC0vdIbIjfkQbfzv243DSY7rd858md4rmF6iHFtBXJ0R8L74bXfhM
nmzvwNf4Bl95dl9it/M2i/mA7sGQd3EQM8V30W6k8R/DWv573PVw8h0YH01y
2D+OYygS00h3Ytg9j4op1+dS/o9wiP8TvGe/HinkitlCa3FWzKdijuAg38dY
K75T7cf16BDtcJcD+N38N7yUxOtxi348YL3O2kn9aDav1Z9Wupluweuo1ccR
/S+UK4N3xFlVcrSKPcc7znnpGI/99vYh3fp5PR1PZybvP51BS1CMie7WlLwz
vM04x3sW4/iu6+k/+At/4xpu5U1hN+8u3MLXxz+WblJ7n3v34irvMP5Ud51v
fY2aX1TzC6i0tho/uMsQzxX0iDmDsXxv8F+1P2B9EKesn8ZG+dOcU6TuObSA
FibfI25S0wXei+jHZVzC3Xx59qcgJ3mfk+8Aafzvy7cDf/D8S2fTRnojncRT
SrPpLHpFPcMYQq95g55X6n2vHvThZnUPuM8YupLnKZQn/xm8FUkP6LdyzxU3
B+m88z2ncK+U+PXJf1re///1/wHgVfdP
         "]]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwl1FtM13UYx/FHzUMXgTkBgRQFxcpDEyeaNcWk1UXpxpVt6grNQypINzpt
AjaErZmbh7lp6VRAQJ3HCVseukrzMGeztXmnU8MjgifanPT6zYs3n9/3+T3P
53m+3+/vz4jS8pKyXhFR4k/76IjCzIg7dBL9ly54N6IU29IiKkdG7M2J2IOt
wyIOp0c0D49oQROWZESsVZMzJGINHUZ/fSdiKC3jsZ3nMroCyxPf7IjHWRH3
+N1FOz6W84uandil50DMHRVxSL+H3j9Aur7dYl/nRhTwnkcn0HV6Nshf6N0C
VFpXowqL5LxQ2y/fXOrXWv+A1djgfQ0Oqs3DVb2+NMcr+Vnys/HcnD+Zt9rc
61GFFjk/0ib6z9CITfIqrZutt79nb9YVzqSTduG4MzqGNv3PWbfSVfJOmrUV
J/Qeiywec3hk0q9oNh1MN+qRRrvynAF9QjvoUfG5tNP99OPfHz8n8yBD/DTv
MziLqfwLnO1EdHmXoX8nHUJT5ReZ6XOzfYYx+r6P6/a+j9YnexVvTvYpb6D8
Wue+39nV0ck8CzFLj8lyF/MtpEvoKbm/Id1saRiMpeKzzPyEltBlyTzic/if
lvud9dTke6FTkm+Gfkhn878g7yK+x1mzVNDf6cZk7zjv7gbYb7F9DTJ/C88D
aOfbyqeJTxttoPvRiJnqe+Smqk/BW1iU3AOvYj3PuP8LvpeL+BOXcQnP3cML
/OF5j7OocBahphd644i6fd59I76XltJ6+kzNU+zyvBuPfXedKNCrQc0NZ3kT
s83Qw2eU+fPx0oxjzbrBzLWowQE5dfQL3lfU3LNOsff7NJW2qW9FnT3V4rj6
N5NevCZitJp8rOKxGm+gWG0f+intSz+hvekH/Mbjb3X9eewWv+ZcZ/AtQpV3
05OZnUWHe623bkQDepLfDA214+hO63KeO+hKmipeJJ5rljxME7/vHh/gIRr1
edvsHZ4f4T89uvGXuoXqv8XK5HeHxfIuyy/3XIYVSJE3nG8OLnm3jf98sXnJ
vdvLVuv14tW47bxuIdcepoivM9dH9recT7XYFrEqujlR+X0zX/8P/R+xG9KL

         "]]},
       "4.5`"],
      Annotation[#, 4.5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwl1Ndvz2EUx/HTGrW1NVtqxKyEtlYkYhWJmIl7IUJithWUmkVrE4lVI2pc
4MYIEpWI8R+IqHljr8QeQY3XNy7e/TznPJ/nnPM8+f7adWbx1KKUiOjtz/de
EcOyIr7Qb/iKeb0jqttEZGBabsTJzhFnOkW8p+/wEaXyH+hi3iPOr+4ZsQZr
cSsnYmHbiFXWK1HIOwrF2RG/+f/gJ+rwC2c7RhTxr+Mtx1K5JbjN35CmobF8
E3ThO61+Z9pInIYCtfNRyl+fNkAK6iEV19TfwrcZm3DMvKVqVnSPqMTcLhE7
+ObRObjUI+Iizrl/LtJ5M9ASk53NpOl0mzky6JtucvQtbaVOJr7p8x256IM8
8x5sZ07vW4A7cndRi13in/RX4kM+BvCv4K+z/oPf6C6+bq4buImhZhvoboV0
up4b23tvnuG8IzAyqS3OUX+4eoXiUQjxX3qKpqDc3gTx+GTfur9cIZ0knoh6
4lRk6ZGNZ95sN53lzv2SN+GZgsveowaz5fPkC5CP0ea74V2LUIyFuKp+Ce1h
vl48M50ZrcYYjEWde5W4zxF9j6IaZbyHeA/jOM8JLFfniZ5lyR3UG48H8g+R
w3+fXvFW92hHcZm5B1sP4f+sxww99qi9D3uxjGef+vsT+KqwjPeRHoesD+IA
Lpi3iqc1/3w9a3ge+408QV/3vShXYb85WqAZxjkzSP+GvtOByXdK76IWGc4d
t1+rz071l6i3ne5AClLRQS7PjNn0rzuF3HZ1Fok3WpfQClqJz/a/IFPujXiB
OT+JP+ID5opbqNUSzbFV3NV7POd9gWd4ivO8P9RoytMMjbGFtwlNT2rbf40V
vGVJH7m17l6OVViD1eiX9LL3ivcllifvivlyG3xPB9x9Pa2ild6gUdb//03/
AJVbsqs=
         "]]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwl1DlPlFEUxvGLGhk2N7YBZoZFQHFFFm31K1igjTGxAdwwImBjwWIhgpFh
STTg0liYmGhijHZ+AcUAKsZoRLCwxcSIuP3eWPx57jn3Oedu71B5ouPw2YwQ
whp/1paGUIaBuhBKaWdRCIO1IVzFZmxBtdw32lkcQiEtQD7OiOPbQihBEYbF
xbQuEcIOHInLiVvoJ/FuNbuwE8ntISSQr2aMjkfIT6Dbeu+TIXTRMfFohPk0
uvnTeo5iBMf1Xtb7AG8zXxPK+VIo471Bb+K2/B3cxYLet+gUJvG4JIR6Pfai
p8Ya6MKU/pO4qM8+vgY04pq4VH6/Nd+5sz0R0fmwioTaJMpQjhSyeZar3SNi
FSFkoVl9rbkmOm8+P+W+8dF+Vu3xGH1CB81f8D7T4nHjDTwTdElNiz6LdFSc
J5+m0877Ck/t9Rni5l+onUefPm9pSq6e97Q4yziGJC6LE3TI+WbVzmEGK/iB
LmevpltRhfPiK7yDaHWWNrTjUWEIl/TJRCJ6b6TwwHkqaUX0TtG3FH0DmObL
pjnYKL8pWsP+nrvPTHuKYT2yo/2ih7+BNiKHNxeV/Pf1r4ruSJyHLP1ieMkf
aAZ+2d9v/MFD/YMei+7kr7kleo73nv0POVu+cxWiACfFK2p+YhWnxF+t0ecN
+tGLAVzXL40RdNhLH09/9JtRU4gCZFhjDVp5inlqjGet3SueozP47ixD5l4b
z0Vv5H2nxF+Mj1rnMx0WZ8t/MJ7hn0WuOAcLcm/UHsQhtOkdj745+RLaLl5X
+v9/wD+UDIuD
         "]]},
       "1.5`"],
      Annotation[#, 1.5, "Tooltip"]& ], {}, {}}}],
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic},
  PlotRange->{{-4, 4}, {-4, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.654989116848946*^9, {3.654989163137479*^9, 3.6549891884011917`*^9}, 
   3.687178599092536*^9, 3.6871787706313953`*^9, {3.687188971245636*^9, 
   3.687188985820153*^9}},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"mycp", ",", "myquad"}], "]"}]], "Input",
 CellChangeTimes->{{3.6871787737337914`*^9, 3.687178788739613*^9}, {
  3.687178935229148*^9, 3.687178936705537*^9}}],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJyUvQe0FkXy/3253BzBnHOOa0IMuzOYUMw5Yw6IkTVHzGnNrhHFrGsWwVVB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    "], {{
      {RGBColor[0.148, 0.33, 0.54], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmWlw1tUVxm/+2cFCSMKb5DUJgfC+eVOXUQRUHEVUFnFjhARsFRWYymIr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          "]], 
         PolygonBox[CompressedData["
1:eJwllU1slGUQx4dCt7vd2m532/3q7tJa3ne3ApWABKMXPZhw8GA0EC9qYohI
MFZTW9RYo7ShUqjSbqlSrYgHDiSYGAlq1KCeNAGKLa0QEwSr8SPxQhMjVom/
f+Ywyf95Zp6Zeeaz4/GeB5+uMbO90CroYNmss9ns84hZIc85bbYFga9jZn8V
zboKZr3InUuYZZDdAH8c2S+gEvIz0Mt1ZkfQkaqYRTlfirlMDHyEu0TSLBs1
a8uYDbWbvRk3+wMbr4ILATKNZjfgL2NrDBs7cGwt+qrgLdg72WS2BP86/BP4
9CL6X+GuA149Ni5znkJHCV0NofMOYD8OTpbM7gQP42MKPF523U+grx9/RjP+
t7NQGp7h7z74A8ifR/cxdHyA/h9rzd4DP9dlFkkRF/wfwX6Su/3Ye4v3zeB/
8WFdretYga4m7u7mPMY5XnGd0n2Ic5TzJvgnV5o9D20Ef9hq1oMb3/GfXeia
47+/4f9O7M2C6yuuSzFX7J8MXPYCtBO8krsF/B3mzSpwiruPiH8z/g2iP5d2
3gwUwh9Nu+5vsP8T59uJ8RvYv4LPG8DToWPF4F1wDTJDvJ3nvAJ8B3fbaj1H
m8EtFa+F+7hbzfnenFk3uMCbe8BzUB58HgryrkO6JvC/JfCYKrZD3J3mv1n4
HyO7Hf8/RV8V/gvwz+DvIrzfuZuknh7lvJtcLqJ/K/JfkV8jV8uB8x6B/gHX
cddHPM7C/5L/tQZuWzFSrCLw74+4TBR8nHw8ZK7zmbznWLnOQgfAM9gbqPGa
UG2oplRbcd6PE4uWstv+FvlW8M95911vJvnLHDpeSngPqhcv8GZbwv84A94b
eu6q+NiD/EjZc70bHfvBI6H7cgp7vfBXB94LZ/C3DZzCnwT+HEN/AX3Vivs2
T06qoZNwgI4JxRKqgBe4OwxuoGcWY16DqsW+tMue4O6HoudEuZHPn4QeU8V2
H/XQiewefLjW6DWl2lLPq/eVs8F272n1tnr+sSz1WfZe3MH/smWfCZoNu6D1
4KvQr+CHkd+O/HLRa0U9foVc/JL3Wh7GxjT2Z/HpZo3H+KLqM3TdT0Gt4Hrl
LOk5V+738H5rnd/FOHeGHutnoTXgPD69Vuc9+zqx7cs47zj6/4bfm3HdmglL
oedMuZuiPsbQ907Ze/0qd9PgvsCxYtQPbsP+ZxHvYfVyd8H//ifnbvVb2mfZ
UeRD5GdzPqvVUxfB15CZrPOcxcnd0dBnl2bwFLmfgBqSXhOqDeVYudbdYXjX
1xCrRp+pmq1RzeuI3y3BS4SeW800zTbVmGpNM7wIvq3gudHO0O6Qz/JdMbsM
vhF6rJQT5SZW8Vl4F/pu4VzM+y7SDtEuGe/y2GlnHALfDLy3NWP/C7wGVYuq
2f6094B6QTHM8z6G/x1x/4P+civ8wSbfIdolxYr3xgPoWxu6D/JFMo2h7xDt
krfRuQn7G7scq0ZUK9qB2oVF6PuczzTNNs3ITNpnrGatZmA27TlT7uTTZvUr
9t9v9hmqWdoe+uwcwL8O8KWc69YMPAdeyPksVY6V6/mc17p2tnZ3KfS3o/JJ
OO9YO0W7JVX2WaSZdpD8rwv97+qp9aHvaO1q+VTCt/8BH6EcEQ==
          "]]}]}, 
      {RGBColor[0.2070625, 0.36281250000000004`, 0.5953125], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnl0VVWWxm8SkhACvJf3wgsJJAQh971YraJiQ5cTYtlq21W9Sl1q/+XQ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          "]], 
         PolygonBox[CompressedData["
1:eJwtl3lwlVcZxk8gZIXcLOSGe8kGJN+9oVLCVup0HCBTB8cujssg/3RosZUS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          "]]}]}, 
      {RGBColor[0.2464375, 0.3846875, 0.6321875], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgmQldWVx78GmqZpoF9vj35NP7rT0N97D1EUR3SSSQRipqxMxJISJ0aW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          "]], PolygonBox[CompressedData["
1:eJwlmHlw1dUVxy8JIYQALwnkkRfySADzy+9ZNhGR6qgI2DJ1CiMzzpSWzUCV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          "]]}]}, 
      {RGBColor[0.288671875, 0.40515625, 0.649375], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmU1NWVxv/s9E53001X09VVFNVV1VGjYkTBDYTgyOZEMwbQQGhAnHEl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          "]], PolygonBox[CompressedData["
1:eJwtmHl0lNUZxm8wYUmAGCTLhCQzTDKZDwEXUFxQNtFW1rpVqRQkgNCjoLS2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          "]]}]}, 
      {RGBColor[0.337578125, 0.42234375, 0.620625], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgl0ldW1x79ABpKQAAm5yb3JTS43Nzc3DvgqtOJUFO2rDF0CxVlwYLJ9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          "]], PolygonBox[CompressedData["
1:eJwtmHu4zWUWx1/OOTg3l2I7+9z2ts/e5+wzTTWDniIlmqZQT0hqKCUcTc8T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          "]]}]}, 
      {RGBColor[0.386484375, 0.43953125000000004`, 0.591875], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgeUldXVhj+YCjPMDFMuc6fdz8udmXvRgFhiVIrR3w4WolEBs36RouAf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          "]], PolygonBox[CompressedData["
1:eJwtmXec1OURxt/jbq9zfZfbu9u7Zdm727OAYI0BNBpFAgaCEKWYRIRDlCgq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          "]]}]}, 
      {RGBColor[0.43539062500000003`, 0.45671875, 0.563125], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmnmYlMW1xj9ghmX2hVl6ema66emZ7lGixAVcQL1XQXBDjYkKuMVsiqBs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          "]], PolygonBox[CompressedData["
1:eJwtmXd41EUaxwfSE9LQNJLNLsuG3QBiFzmaz3kgxV4piu08xYYoKE3PhooC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          "]], 
         PolygonBox[{{6287, 2314, 7447, 7105, 7106}, {7106, 7105, 7450, 2315, 
          6288}, {6261, 2299, 7422, 7091, 7092}, {7092, 7091, 7944, 2673, 
          7943}}]}]}, 
      {RGBColor[0.484296875, 0.47390625000000003`, 0.534375], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3eYldW1xj8cygzDDAfmzJzpc2bmzCmIWMBCsOWigBoVRWMBEYgVo2DH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          "]], 
         PolygonBox[CompressedData["
1:eJwtmXl81dXRxn+QAAlZSALJDVlu7k3uzb1XwGpF2Ze+KKsFFBVlx6ooVFBx
RauIraiIgAVZRJG3Kr5KK9r39RUQlE12lF0BWxEIaysqyOJCv49P/vh9Muee
c2bmzJkz88wkevOYa0fXDYLgVJ0gSOfvyuoguCUvCC5pEgQ7Y0HwWSIIBuYH
QU5WEByuCoJdlUHwY3YQVGUEQTIUBNckg2AD8zPqBUFf6Kf47RBrT8KjK3t3
sP7hdO/ZDd09FQSL6wfBuwVB0BP6IGtGsf8n1nwFPYA1PzcIgl8zvrg4CD5v
GgQVrO8GzyXosyIaBEPhVY89J5H1egU6NwyCqcy/Bn0iEgTfQDeGx3HO8Awy
+jVGD9YMh74dnqPgXYr+i5C1GJ1T6PIGv70P/Tz757P/GvR/D1us4rc2zD+H
fVZCL+S3LsxdyfdX6KvD2A3ebdBpLfpk8X2LQdvA7/HSIFhdFgSZyOrKuAuy
93PGW9H9Xvg9Xx4EechLIe9RxlcWBUE1498wnsa4P+NlyBiKrGrOsp3zjy1h
HWfrjsyNyE6y/krWT2f9QNb/Ax2LsVcfdP4S+p9J02+y5xv2fsW4b4HXaG1/
bFaOfcr4/oB9Ith3W1oQNOU8ldB1+QLoBzhDB86ygz1d2X8/4/aMN6Pf/eg3
jT0F6LKX+V7Mf5QZBJ9yd69x3nb59gH5Qg/OUIm+wxh3h55YYjqN/U9C72F/
T/Y3Qb/PoA+X+a4Gs2Yg9lsMv17wm8s4hT/uZk031jdm/Xbod5HRj7P+nvmR
xeYhXtJpH/QwzvhAYJ+Qb5zmjpaz9iLk9+bubuEMXaDnc4cLsWcJ5/+EcSE2
KIPuAY+PkX8GHhM4XwoeM+D9XQ72Y3yc/e+n2Qf/FbFO0k022wldDo9PmQ/B
rwL6AL+Fme/H/CHog0nTUznDOOTviGO7+pZxEbL+jI5fw/s4Nu+ELT7C/jdD
N8M/dmDPWcx/DP8s+B9kbzhqWXewZj78usN/JfpP4712kzxs9CHn74aN++KP
U9h/DP5H+WrQv0PKb/tV5HeEXseebPTpzHgT9IQS300dZD4OXRq1rW5H3ivI
25j02jH4QzX2ORqxr/4L/segx/PbVPifxX5dWDuaO+0O3YtvNbrVgd9HafbB
NOjelY4NbzHuD/0I/rugoX1Yvjwbnm8oFsBzCryXl/hudcYPodtjrw652AR7
zeY8zZGXQlZLzt8q5Demtxbne5n5Tay/j7O8jz9sgL4Tm+7KtQ9dXEh8QMe/
wrsD+9tgvxsqrZti2KP41lD0uQt9fgePudjjEnSaj7wz6PwP9J0acWyZpzcP
PQgb7M73Gq19DHlHkDcZGbPQvx9vPpO9JzlTM/i/zW+VadZhEfQdxfZ9xed3
0CXG+V6Sf8PvV9CtOcMA3ScyKpGVg03XsD8TnRtB50ZND0PfOeg7C52aYNtM
vvsUuyscS/vAcxryO8FjKbymcL/3oe/XrP82y29AbyHFmn9DT0d+Vsxv9pe3
y7gFdII9M3I8n838UPR7op55dob3Ln67nLtoyTcf+Y/wlTb2nb+BbX4b8v3q
DZ9CVhn8noLXRL7z8L+r1p+uhd863stgdBqDfsM534uc72r4xzSG/0J4f86a
Qazdic1/D//DrD/B/FzFJ2RNK3EsU0x7lbVrE+bdrBH+he3/wv1cyvyb2PB6
7P8GMubVdUwZDq8a9Pki3TlVufW6Sq/tiL+Mgveb2Hd6ln1mGOvnoMP36LIG
f7ux0G9cb/0ivnnou4fzRniPYcZzGG9h/23wboE+G9lbD3u2ZX8+87OYv4ev
Lvb7Dp/7E7r9Dhkd0/xm5kC/Vuz7uRV9mqHrNvgdwdbfIv97yWd8jPFpxucY
L6+2LXfCIx/fOQzP5+A1me9B+H3C+hHoczH6bEKfA5y5a5ZzvnK/crZyt+5k
iOKBYjD0Jr6VEWMQYZFf8b2C7nfGHCvkk/LNEbX5XDH/bWzZBn3ebWQfl6+v
4rsN/XYpp6FfATIPw7uM8+dDP6KcCX2BGHU3/FfLn9Od89dAH4k4VinmKvaO
5456I6s/NviSuy5LOFbeDo9S6EasOcV9r+dOn0Cfq4pNr+Ubz3hS3O9R9n0W
uifzG2rnH9d7RYcLudahCro3OvwQGGP1gd6BPi9zlnqsz+I8/RjfnmUffR7Z
RejXsL7vWHcdjTqXj8QG/11kH5GvdEfGzdhmAzw7FTimK7Zfgz/NybdOf0Sf
8aXGMsI0DeG/hj0j8vwm9TYfKjG20fyD0BdXOdYoHh5g7zfsGZZtzCbs9iX6
HsgyRhRWHBZ3PJf/D4d+q8i5Vz4p3xzAd2eWfVq+PYjx6Cz7lHyrATzT4P0g
8jqCFQoYb2JvLr81Ec2aA9zVJHSq5Gy/LXbs2sz8JO5rGOc52MgxR7HnFnTq
nmadVyqX8W1mnMc4BL0AHUfWdwxSLFoVsa8KwwnLXQ/Ps9jnPN9meEWTjrVP
Eh+HIr8oal7yyXmctXHUut7K+GXG7yWNBYVJ/x96SsS5QZj06pAxmrDaEmx0
A2eLMd9ZuZTz3Qv/NYwno+8WflsLfZUwR+Cc3xV6TJXzhWKiYuNgeLZivJ37
XATvj7DPwlo8cBkb9yZsK8XEfaJr7bkRnme4353Yo3UjYxRhlSnFzlXKp8Xs
b8e4Q7ox653400zkrUbeRazP5uw9k8YiwlS9oNvXrlf+HF3pN6m3WcOafPyr
E2fqz9ly8d8XOO/ApHO9cuZg6PrwXJlmn8iA7s6eNXWdL3tAZ1Y4NyqGN4Du
kXItsoL72drUGElYqaveIP49kD2XocvDyulRx1DF0hz038T69thkK7yPsacj
dIeE6efZ8yS8MmOWrRjaEDrJ/N48YyxhLb1Jvc0eyFvGfH7EWHosv63HH5+J
+y6HI+/puDGEsIQw34fMnyv1felOdDeDY86FqgmGQLeE39w6jtmXQxdyJ5mc
tQgZv0Z+Cp7/w9xe+Cc4axf0287c1/C/CvoEZ23CWb4QxmRcFDLWE+Z7EdmD
ilybKaan4F8SMpYXpn+V+WmMt+W5ZlLt9AjjJ9L8Wxh+c8otWzl8NnSE35ZD
72Y+Bl2VMH0E/pPYu483fjDDMpqGXOOp1jvBmt8kXBOqNlQOeijiN6W3pZp2
BfIbkLNCDVwzzoTexPpzeX6zertxvhVpvqMU9JUJ2+Il9tSUGNMK2yoGrobf
D4WuBU7Ab3fcOVyxbCH+ciP+Oxp9/4y+O/itOfYYW2Vsqzco7BbBZ08y3x8f
HoI/nWNPXo7fUJT7XMUdxlXPCQNAH8JG73B/E/mGNfWb0NvQbzXMdUbeOPgd
Rr+2eq9J+2p79m+BXs95p9fq0wJ91oWsXzXjbvB6KuFcNIozTUw4piq2HlTM
T7jmU+2nmHljke9Ed6OceijiGlG14gHWX8b6JtinKbzXYp/50E9Wmr9y5J+g
V8d8tv6sfw5+00stex02aKP3FzNWUU08KOY3obchTL4RulORa2lhuK6M2xQ5
F6vGbMX4Wmy0Psf82rL/zULHolJ8ZAL6bWHNA3muYVXLjo04tuq3TxiPKTWe
a4f+S8n3hUXGDvXhf4b7vqnSd60cptrkAuf/McPv6xJs04941i/dOrRDfjr7
09l/Tm+O/acr3FsRRhtFbNlV5HilOxoDr5GM367jmHc/+jyL/i3Q/yXmH2B+
dNS9h83sOcTahozTsx0DFQt3CT+qdyIMjj5vldk/dabm6PYQ45czvL+G/T9w
/h9Y/wHrz0SM6YTtVFPOZv8r5fYd6TgP+jTfh5nGHMIeH8QcO9WzWRzznepu
VRP8G37FwmDoNwV+yxjXY1wn2zWear2A72fWLmP8I/MTQ8beO3nn72CfuxKO
xwXon47+eVHXun1Vs0dco6hWEeZeUGQf0t3rDmZwl7MTxorCjLexvzf6t8h0
zFQvoE2Fc5cwcGvon6uMHRRjV7B+DPzO5bhmHQV9N/abkeEaR7XOhrBzl3LY
eugpKWOtaexpwPolYfuS7K9aISPmuQB+9aCnovNNeb6D8xHXTKqNMEOQgP++
sPtJwjB7oT8rMx7V+a5FvxzWv5BjfTaw6Xt47IC+EZ5LhNWrjR2Vg19QPYO8
AXm2+QXWzip372k/73sIa6+KOTbthGc3vUfV2A1db36FPl1jnlNNPTrlHpN6
TbvgGVVuLDTWVc/mfcZt4TkL3/g/+LerdkxVbBUGXZ90z0O9jz3qealWKHFs
ko3vKnPNrto9Dx5beNvtisxrDPOXM/+/vMGj2a6Bz2CfJei7E32vV70ddk5W
blaP6fOka1zVuuqxfYA+EwotTzFRsfvxWvzbhf2r2X806VytmusI9Cz2D84z
Rr0pYkwjbKPflsJvNvND8oxZBzI/k/GgPL/RTNZOZzwwz28gnfGUIt/VadZ/
F3EPUr1IYXxhfWE0YbXWur+Ie5DqRapm6h3xnehulF86c7+Dq32XwojCin2Y
P8z5KjlPGmetKHQvUTFRsVE1jWqbIs7/l1K/Ob091RyqPZoVel4+9/dCxxzF
DsWQcdirE99D0DXo1Jr7W4R/dMr1GXXWZ+HfON1veHLYPWThMd3Z35UPEu7F
/lLzQlcm7EvCBMIGyonKjeqJjI87put9q2ZR7VKKvs8UuAegXsAx4ZV0n3kJ
9n0qbiylNWWq9yLu7QgzCzsnEvY9YQBhgcfg8X2O3/xoZH0QNS/xPAHvs4wf
zPZ5hBV1J7obxdzT0Cf5FjM+xfhb6HYJ52b1ANULHFHo2l4132vqN+BT1xW4
J6jeYCv29M4yhhsmrJVwb10YTVhta9JvQTbepnq1iWOFetKt467BVIvpzQ4o
9JvQ29jH+nvi7lmqdykZVyDrUcanGZ/iu4PzPlzuWl+/jWT8drmxl/xjUbl7
UMK3yge70e+/EsZi6iGrlzy/1GvlM/KdS6ocD1QDv068WlDq/u4I4dNC5wTl
BmHEP3CQ9in3HlXDZJcYs+yofZ/CLi/ybUlzTulb7Zyl3HWe85yDnhFy7lMM
VCx8IuHcr/g8Cn/bWWHs9rrwMmt/Ys1PWcYswi6ygWwhH5Av9Krt94f4xkKf
jViWMKWwpXKWcpd4/Ay9P+LeiWrer9RLiNr/x6Hvj9Dr4+4dNefboH5NsXOb
fOw8899E7DvC4MLi94YtWz0z9c7eqjC2Us9IvaMrEsZqqllVu37Jb2cbGnP8
sdw9MfXG9D+IUvZ3TriXrBpGtUyfsHOHYmBf6NFh6yMfPxd1TNB9CoNfh64z
I7adMLSwdJuE37565uqdZ9fmL+WkJPL6hFxbVpBzW6JPx4ixkDBOB+jmCdca
6kmqN9kyYSypml61vXqm6p3qTP+E3lrtXpN6JJ9Cb477f0nK6VuEz9BxR7bj
/xdh96hVv+i3Gdx/vKlzr3qq9dF1adT4Su/7OLpeUei3IsywWLUD8e2GDNe8
ZxlvYE+/XMd0xfb16nHW928bodfyXZPrnK7cvkn9O+avFx6HvidsWe8x7hl3
j0C9AsWAmqR7quqtCmOdKjfmF/Z/hfkreBs/Re1L8qkh3M2FqGtVjeVrqmlV
2+p/Pvvhd7aJZemMwpLKmcqd6pm1Rb+82v7VBn5brv/vxKyrcphy2Sp++yTD
GGQy8ibw1c3wb5pTD1W9VPXUerH3U37bU7s+P+SaUbXjceUI5g6VmVYMUCxQ
zajaUTXR18z9LebaRRhFWOVIyNhX+vcrMaYT9tnPb3tY/3mZaeWnx5i/NGQs
LkyuIPKx+vv1fSfrFM8qnNvVk/0b9LIyn102UC9PPW5hLZ1ha5l7iOolKubM
Dfl/GvrfxnTsm1DuqbSvyceernQNIPm/1NyKpWHHOuHPw2H/j0z/K9P/sHZx
P3dXubei/sw90KcixgLKIcoll1Y5nit+LsC3j4YtT/+T0P8mLi/32xJeVW9A
PWz1soWBlnK+5ug4E1mPYYNDzN2QcK9KPaBB6JpM+SzjmN/GfCrmWkcYKAmd
yx30xVduRoc49qjW/6QK3BN7nfXLosYDipHLo16jtfqfb9MS92zUu5EOzVLG
7MLu6rndGvL/YIS/VQOfxX5Pl7u3KB97ptw6S3fpUKPaptTxRD2MO/DnSWFj
G8Usxa7Dhe49qyZWbawemXpl0jmO/FYpvyVhUmHTM3oTjfzG9dYVkxWb1V9R
L7Gm0L11YRxhHdlIttKe7dD/AeBIkgM=
          "]], PolygonBox[CompressedData["
1:eJwtkEsvQ2EQht9IJG2VxKXtF5ce5yRig1CXTdMFG9bWbLBViYVgY6uS2gkb
Nm4/QoKNVvBD6jcg8UzmLJ7Md+ab75k5E2/trde7JBWhG75L0k1GOhqVlkek
FZhLpMu8NE/c5bsO79CG8yBls1JhTBqCDOdm8DuriXkzDqXgjgrnRlk6hSK5
C3LT5M6obcAzfT/oX+NuZ1jahkXur6hbIC6l5xDca/4HXLM56T71mt/mtvkP
8V3j6/BfrwXpBe4mpWq/dEtc5bvTJ51MSC3ObajBPr6eyOvt3SauDXhMe/WS
m0p8/pnE57R5W9S8QS5yRz7yfdnennhbJRfSPtZvMN3ZAFHwy6wHwR3m+oml
Y3r8xd7f5vjEs4bnq+w7s939A0lTPZo=
          "]]}]}, 
      {RGBColor[0.533203125, 0.49109375, 0.505625], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXeYlNUVxj9YYTt1Z7/Z2WF3ZrYMK2CLjaoxAmoMoqCRaiPFKCgSDZoo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          "]], PolygonBox[CompressedData["
1:eJwtmHeY1dURhg+7AtsoArv3sv1u4e5SRAkiPRaKonRQQMCaRFFAQA02iooY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          "]], 
         PolygonBox[{{7082, 7081, 7914, 2654, 7915}, {7400, 2284, 6235, 7081, 
          7082}, {7141, 7140, 6339, 2337, 7480}, {7479, 2336, 6338, 7140, 
          7141}, {7455, 2318, 7454, 6809, 6810}, {6810, 6809, 7451, 2316, 
          7452}}]}]}, 
      {RGBColor[0.5821093749999999, 0.50828125, 0.47687500000000005`], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmAuQlWUZx19g211pQdjbOXv27Fn2sKdl0cQKATOIEUFsuO1yMRW0SXGU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          "]], PolygonBox[CompressedData["
1:eJwtl3mQ1nMcx78dbJlt1W6P5+nZZ5+n57f7eHYLpXNJmqFMTOduG8o1VIOK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          "]], 
         PolygonBox[{{6795, 6794, 7412, 2293, 7413}, {7488, 2341, 7487, 6833, 
          6834}, {8891, 3309, 8890, 6794, 6795}, {5894, 5893, 7346, 2244, 
          7347}, {5859, 5858, 8628, 3157, 8630}, {8786, 3241, 8785, 5893, 
          5894}, {6834, 6833, 9077, 3405, 9079}, {7269, 2189, 7268, 5858, 
          5859}}]}]}, 
      {RGBColor[0.6310156250000001, 0.52546875, 0.448125], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlnmwzWUYx1+XXMTl4txzOufcq/M7juPW9Id9C4UWLWStETKMcC3VjEFD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          "]], 
         PolygonBox[CompressedData["
1:eJwtlnlslGUQxl+gSqmlUmS7C91u833bZS2JiQeHICAKCngUC4hGixIIFMr1
DyKCJqjBI3hGFAIeiUYRgYRKhIoIIoIC0RhBTaDEg1MkeAJKOPw9PvvHlzyz
M++8M/PMzLvR+JkjZ7QNISzhK+J7vDqE1SUhbEVoALd2C+GZ9iHs7RDCJeDe
qRD6oTvLb2vTIZRkQyjvGEKyXQgdwNnKEL5C93wxPpIhfM2Z+ch7OH+uawi9
CucH81tjHEJfzlzN+RrOD8b+6YoQFqFr6RxCXW0IwzIhHEVXw2/Dwa2cuVAa
Qv/yEB7E10LsX0a3EftR2K/OO55mclkF7k4Os8jnLeThiRDOY3+QhDcS33vE
/xE2V2C/Gf0GcIoYuqA7wXcM/Uh87ro4hI/xPwb8CfojhXgmoO+BzznBZ34g
vkHct7DEOa0kvvEFWf7vw7YlCuEu4t9FDPXU5uas76/C503gJ/HRGXtgaIt9
f+rZyl2X8dupLnDBmdHITchnsB1R61ptI8bbwRsS1l9DfZaSzxfEsIZ630Z8
A6tCuJdvL75vRW4AT0M/HX0V8npqO7rWtVTOyn1qQS+fJ8l3uWpWbP7nEtvb
5FNX6pwOU5uQtu8+8H2Us5OQEf/viUbw/IRrd7oTfBHffuSZyDH2/YjnBuo1
v8T81aNrjlyP3dRrDfgOYvqQ+PZhX00tLsS2V/3Og9uknat6eCrnN1PIxo7u
563YD0vYt848mgvhnbx7Sf2xBV1T5PjUc1vIJ8NvX5a5X1eAP6fm1xX5t4mc
f5bv9zJzLO5vzJprcToY3CdhrlQ/cdOfHLMd3O9D8L+beFuL3UPvJzxzilUx
b+J8r6xzk7/e4G8S9q87n+PuMr4WuHoBuVPOM6pZXYzcVTL21yseYrgbeXTe
tVcPTyDX/dx/iPubsHkJPsdif6bMnIibGH+t+NvJHTXgE5G5ECe/RZ5pzfaL
nCnHfwwH+9BXq4fBNZXm/yLkOmp3sot7W+eHYj8t495Wjw/A9hTxnOJAOfHV
Up9x1e5fxfQa9hV8m4jlFeQU+NKcc9fO0O6oq7T/MfTjeuJblzZ34uxa+rEh
5dnWvL6O7QPoXy32PP7E+eMZ68THleR/S8a9qxyOEPvYKve2erye+HKx6/sU
93UH/8GdVyFPRf4TXFGoh/RJ8FDu38PZIr4nuD+Zcy7aYdpl32asEx957h9U
ZS5Ugx0pcybueuJvUuSdqV5STw3AtiFy7/ZCPwU8qsqxauZHgo+nPev3428s
/ranPHu6Yy389ki69uLgNLZzsp4n3b8T20NJ11Yzr9l/N3LtJK8AT458t/jU
7lrQzXd9z29LY8+sZvczOIzAi2Lrv0O/JPZOlD9xMpv7O+fcW+px9frB2Ptc
780B8OWxa6sa58HzKr2btKN6EO/i2L6V80p0v0buTdkfA4/PO3b1zDjw7Lz9
idNZee9U7VbtnHrw35G51Qz8Bd6WNlfibLsw97WUut+0K+YW4hmiHQWfmdiz
qDcoDV6W967Wjv0AeVvGtnojm8FvZhyveqqU8+uR+5Y4vmn4PpLyvhBH98Bv
Y+TeUI9E6GfkHa/OTweXJR2renAH8R4rvKfi/Ch4ctpvt3p+D/34Rsbx6s51
4GWxuRRn4q620C9t2E8/IrfLmhtxVARun/W+1ZtcDO6W827SDGuWz8a2l/4c
+KGUfSkmvfUDE97N8jcP+xVpv92qXxO98kvCvb0K/WPsiubCvKt+PVO2ke1y
/I3A34JKcyOOpqh/UtYpR+X6b8a9Ij7+Af9c2Heq4QHwodjxKL7D4AGF/az3
ZCD4zlr/V9DO1O58OOv51PvwCLhNwlyI03rymZj2rGhmP6WW/wGjDFQs
          "]], 
         PolygonBox[CompressedData["
1:eJwtkLtKQ0EURReCoJKAENCL8QZy02kriI+vsDeFIHlokipfEHtrxQ8QvyBB
RbRQtFTBH7AwCpYRYpM1TIrFHs4+c86eKR909tozwKLMysMK3MttBWp5uFMb
q3A6B3X1dQne5KgITVlL4FrvUi+/DDl59vxu7UVtZNDPeTeLXuhplaCwAMfq
ljO2ZSB9GVtr6v2rOylk8/Doji+9YTHuDhkOy7Dh3JpatW/Tvv00Zg9vOJGe
fJvh1yw/6rkZPrxzlkUv9PxZH+m3krh/MN0T9j1Zqzh3N40ZQ9ZP81/Y3/Xe
ldx4Xk/iX4Q/mQC7LDXQ
          "]]}]}, 
      {RGBColor[0.679921875, 0.5426562500000001, 0.419375], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lX1oVnUUx0/bbC/tsSY+uw97nj3ruZf5UBAo6Kxl0Vw1Ri9sCrVyrwqu
VbP+yIrIVjaDQssg+8NSKoJM0jTUMWnZ3AyyhsTorwiaMt2L1j+9ENHsc/je
/ricc889v+8553vO+d3cxqfWbSkwsyM8hTyfpcw+KDKrj8xOps32YBsJzS7x
LEqYDfB9JDB7vcSsK2P2F08t+s3YHq42W1lq1ob8KGn2AGeTyLmc2dPlZvPI
cXDfL+NsjdleMFuKzXZUmW3Omi0m7gI4E8TIg9MIzmCVfNz3ZFL5rEYeIO7v
2J8gxw3gLgd/Xd6srlz6aYqa4HsBsWYp7F0w3wb/JuJuLVPOjrW71qwXv0kw
n0Me5ts4fruIW8a5v4mTSwurlzh9cax25J9LqQ+MNem4Pnyu52wd2EFC8VrB
/3Kx2TU4XilRLZ3Y27CPYr/OawLrX2Kddw5j+0PIFcU665gew2M9llPNXvtB
cruC/iHfD1PfI2nlsB8u99WK527q/ZaDndg/h5+jfFuN/QzydJVq7oTn7TH/
3oc9YO1GnwCvJFItxcitxPsJ/3rs9ZyZIJ+fwV6Dfhe1zWJ/Jz5r+E9iK+Rp
5r2I9yQ4hZFycd39Xsb/WvRZ+nuE2tbD41Hkrdi/4ewJYp7NCCcBP0P4zePz
JN+7iHsLvI1Tx3BaPfV5nEmph4beWCN+3oKPVEKxvS9tVeJ3hlhfgTkH5gnk
zjL1z3fg7kB1eX1jgeYoIk5/UrUvAv9UqDnxeXmJ2lqI8R3xx2JuT2Hrxe9N
cDYjn6EHiQqzZ5GPgruKOb+EfwP6MvTv0dvR69A3VItH58l7sonzO8H5OtAs
+kxOVtLPhGbY6+yoVX+/yGrWvdbtPgu8Z9EHkNviPF+M1DOv8XZi3cn7Sux3
RMJz3XnwnkwXa0YbIvFzGzm8Wis+fb7WB+qF9+RifFdMh5oP56ojqdlZKNUc
94Xq6Q7i96IPEWNVSnvosUfg50beh7wXGdXjdd2H7968dtfvg+r4nnkhrR76
bHg/GrOKtRbZmlRfG+CjA8zfwLyc0c44Zz4j8xntpt83jV4j+a+NVKfXW47+
KZy3gH8AORNqbudC8ee98zovBOLJd3oYzMvcQ0XYSio0b75jF3PaU9/XqUrx
4rt1KCee709rt33HF/g+Guhee5zvFfH9tQT5T1Yz77O/hFp24VMdao6di1Hk
uZzuj6tgnKvUvdid09z4/PQRJxPqbDZU/P5y5el8e1+8Bu+D5+NcFwSyeX0D
8VxVEP8sz4Nw8nyk/4fPziFsF3LCPI+cyokH3z/vmeN9Ao6llKfnu5x+dRH7
MtjH41rey+su9t5GxG/G5xV8ltVox3zX/D7r4X0f9k3Ilir1wnvSmZR9I/Y8
egv6j+C/ltb91ET87oz4cZ68B87FID4H475PgdMT3//+z2li/o9xP/+xVHei
97E/Ky6ckx7il0a6d8qQ3dRw9QZyQN4TaW/vRU5z3sinibO/BPLpwWd/Wv+K
dvB++L93Gd2Dvju+Q/15zdYWZCG7t4B9G/4B394gz0rkx5wZxh6mNHdu9/ya
Q/XR++l98/+F7/Cv5NGNvgKejnP2DGePZfTPdp9BZGteezyQ1P3r58ao5T8/
MypI
          "]], PolygonBox[CompressedData["
1:eJwtlF9o1XUYxt+2xc4O5ygTz87h7Jwzz+80DwhBkm6QFM3ZRKLY5kUUc027
WCtndmF1E5FNoZBSqC7SxOrCLrISzGG0wqYR4i5EgkC80HDo/tSNdCOtPk/P
Lr7wfn/v+z7f532+z+9b3fXK4J6GiNjLamL9m49YSTDfHDFbjXizELGUiuhk
TbZH3Obb+mbXBLkTJb6Te4rt57mIbtZH4fp7lYjfWP3piG3UH6R/uBzxOv0X
2N+m/zp4K4jHMxF/EH9Tp4b8Yb59SP54xVwq7I9VzEHY+8Bs7YgY4/wZ8nca
I6bhPkG+kfxV1q/kVnW4Vpy+JzfEGQ9xVhfrPPU1Vprev6hfpP5kMWIUvO5s
xBO1iIuc2Z32fGVmm6o7fwI+X8HvNfbZVvNblUSMgP9zg8/YSXyq4Nou8HvA
W5c3f2nagBb7OyOONHnmd4iPgjeXMd9PiB/ocP8G+DxG//nEeXH+iXg9nEbg
10//WeJdzHAoZQ5X2iIW4P88+WEwjjP/FjC6wPqM/SL7PZyRavUd6C5eZAHz
P/8x4r6atVD9w8TNrHzW8/xO/03m+Qcutzj/FPWZmnOa6WNmH6PmbrM9sob9
ozXPIg2l9ZOJ9V2A7zbiIzn7S5zG4fZyxfhnVkRsRZ+pxNpIgx8Tc9B5h8AY
oHceDnsz9udBevs63SuMfs6bQM9j1M6AMU79WvZvp+23lcS1dnvpfTBH0XKi
4tmkz37i0+BvzxhP3Ho6fLbuSHeVZr5C1vPfg99S3r2a6UbVnMTtBzgNwO2+
nGPlNfuzeGJjS8SD4G+n92jR3hBmC9ib6V8if41vm+C61GZ9z8H3C/jmcvaq
NN0B/kLJ3pZfEvB2Fu1VeXYf+s6uxodp/0NrwJtjPU59nTNmuK+7bf7/pOkc
/Kdr5iYNLxAfKNp78uBixR6RV+SxXuKTJfMRxy+J38rZX5qhl/qR5ft4mvpL
nNfHt1jmU4XLgeX/+SKrm/xumr9O+w2ZI+4t2uvy/AvgX6ZmbYtn0Cz3l3zX
+taDto1wymWtqbRNCtZO/ORV/cPS5z3mzRPfrPptkgf+RIuZdntFnqnD/UzJ
3MRRb89G8CYz1v80s2wqm4s4PEJ8lvpfUvb7q5zflHesb5PkdtM/n7G/v0vs
IXlJ/1wK7oN1/5vScIB4vGIvaP/3at+x7loYk4k5i7s8+23VHhd/adAE3jBn
vpsyxg1qhwp+K3Sn8+S2Fvx2a75L7KPkt7sLPYeYZ0fOs+kOP8Vvg3n7Qx5+
rmxP6S51p7fg90Gn/aH//zDxLPgbWnyf00V7WlzEaSrvO1ZONc+U/caJ2yL5
OyVrKP2k+Sjzbi7bu9J8C/1v1OwtcRK3l6p+++UZeact8V3L4/L6f5BG+R4=

          "]], PolygonBox[CompressedData["
1:eJwtks8vXHEUxU9GRlDTIB1emDftkMn8Ay1WJENGupt0wVgYNd23GxISLV2O
sGJFJBUWSFiZNHYsajP+BYxFZ1R/WNnR9nPzfYuT89733Xu+5577EoUPb96H
JL0AYTDkS6lGKQ0fdUolMJqUTp9KOfhLXNoCX2PSWYPU70mzXdIcuOyWLsAt
qI9Ii57rN535HinL2SfY5/tKsxSDH9qlR/CL/p8gzfde6obhc97L4Dt1Yc5q
8CHvB+A3Ht42SX/gSbwU8ZKHr9CqgKmU9K+FGrgYlZZA2XMePqI98FwaBCP0
C50M7KMbBzlmf0kGVepDaNaBnYS0DQqBbqUDD5zfce+E5zyZtwXPea0GWVgm
pmnaJ/QsU1+IuQwty3iQRRt9P4LcbuBVMlsD7/C4ib981OVjOc3gIdIqTcPr
nG8EsOcnUbersaTzbf5raL9innHfzWyzFwLdKfgaX1k87AUz2qyWl+V2/4z9
oZdJOj/mK4TOX+ao813WlvluwmnsJ9y/YP9EH/d+o64Uczu2XW/zfMzZDpzi
7s94eB11e7Z9/wcUGmZR
          "]]}]}, 
      {RGBColor[0.728828125, 0.55984375, 0.390625], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlX1olXUUx0/NtXWb0WSPu95n9857b7Y/LKIgWm+spblesNqMTER0VuDI
NiEKAnNDB5EGFkj/ZFEyCko3C03wtTJj1Qz6t8BmOG1LjSgierE+X77PHw/n
95znnO8553vO+T3ltQM9/ZdHxE6eGp7O+oju2REfzoo4XY5Y3xBxqTniUZ6H
+HZvMWKoaptB5Fgp4npsn0ojJjP7H5B1fL8R+yG+vYNNK/KxBRHjLREriTOM
/TIwl2KzAsyjlYiL+B5BHsRmHP3t+YjGVuLgewD7k7x/xHmG811gniHhg2AM
oN+A/hK6Ub6V8L0Axih59IA5hrwWmxuw2YfNt3MjJuoi1mIzif8/4IxgMyfv
PJVvNbN/HryV2H2HfTvn35DbGmw3r+JzHrmK2k5cHZEkEW/w3Irdc22ur/3K
iO+p+f2ycSaJ/wncnVAtxHkN31/x7cHvm6zGemK+h/3D4L+LPJ+6N0/Axwuc
/wbnADbLi8aewbcvdS8qYBymrinqKqTOQ/n0Fowr/CfBmQK3H/wzwsfnNvJc
A94e3rvR/wjGTvU3F/EW8pUG46h2cScOS6n7pzpr0OUS27+J/RLqWojNVnRn
s1j/Nbt+8bAa+7Gc50pc7CaHpY3MAPkebvP5KPJLnmWcv0JeV+85Ub+vgMO5
zFktshf8m9GvQR4jxjbsesEfaXHP/iXm/hbzJv4mUs9nGzxcLHlmNDujxFhM
rL3IQsU1p8hDqedwU941q/Yu/BZpVjgPJt4B8V/G5mDqXOe0ei6V77Pw8UjB
nIibLwquezpvnXqtWVzYbN/jxJ0m55fo78fg78768gEy8Bng/BPn1WXn0Ane
xrzzVL7ibEOdd3ko7108BWZvq3UdyJbUe3Q3OTbm3BflcK5s/GnknXWebe3D
6+DMg/OGqn3kq118JnEvh8HckTeHY3D4F/n/SS396C5kM7y46h3WHE7kPbua
4fXI+XlzqFnWTiqX0/ARfCuBv4VYm0s+DyOH4XGG3B4Q/62u91RiTsWt9mwH
vKxAP03tm6q22Y/ujtQ7ck/Je6LzIWLtSlzz2+Q+1cRdRvj5fH8129PtyASs
l+GnqeLZ0owVK76nxP+LxD/G+y/YfIrc1WLMdcS9n/cR9A8i12V3yt6S90d7
9HjRHIkr7b185NtVcc/Uu6/B/73JPevDt7PoPaoFoxPfW+jRHmy2ZPxsRm7k
meLckfju0C7MavYsb613nUty1uuO1t5qLnvbPDean0Ewz1W8O9qhI9k9Iy51
52qPquiezvms2dXca/63F8y7+F9Evp8l7stlnMerzl//GemUp+L9XPG/5Dyy
C5t2zvdVPeua+VXE7Ca/P67h/mzznijmTYnves2s7vLaondKu6V/j+rbh29N
0fE0I8IQpmZa/RYfZ+H4qqpnfjZy+QLfgbrjP+e9D/1x7ULGeUfVd4r4OQnG
/+VjDmo=
          "]], PolygonBox[CompressedData["
1:eJwtlF1ojQEYxx+2tY822drZOc6n8x7sAomUkdKsWZGPmYzW2gfKkm1XpGbb
hRJTrtxLi5I2FsrYfE7DptxSIpYYc0EiLvz+PafOW8//fb7+z/953pNu79rd
Od/M9vDk8nwNzPJLzPoBoZTZ80qzhlKzG+ATGbOqmNnrfLPSIrOf5WY7o2bL
wbuLzYbSnqPcmQVmPUvNysDLCsz6eFeKXZU0+5dDHvFXiO+MmP3Gn+S5Ru29
5KSIXUfNRuy2Sq+vnHdh+oB/LTT7CG4i/3LaaylGXGoSZt3YI9SYpvamkHPZ
z7tH2Dfj5DHnX/At7FridxR4/Evij8fct4X5JuHaEvd5Z+g3Rv8NxEwWeIxi
P4R9dvXfRf+OpGsjvpo1hp7nin2mEuwWNJjA7kDjJxmfWbMfUQ7x0+BV4Ar8
F+j1kJzv5HeTcxv7ZMS11Dw5cG+GXybL7x5cRqixEv8EMzejXyjk9kZiLmGf
ov9wkXMQl9ywz6KZ7lDrbcj1086foXUt/mp8VfCpg+9o2LVXzxa0zyVnO/71
hdwO3Hqz/LTzPPhtg/NgsXMSN+1M+Wt414Y9L+GzKKeH3DpipsD8bIb7ao36
LUjDKLXyMq6NNFoLlz5wfYlzFFdpJK3miB/HPpjy3WqmQ9hTEcfaeTW9JzK+
C+nxlF59Eb9f1f9E/vmo19MOHgT+DehbUM9+7L6Qa6GbrEevscB7a/5RdjkU
ce3E7xt4X8L1esN8jdgHUu5TzTbsTNjvQd/EH7TNiztX7ewovdqyepyhRym1
29OupTSNU78u8F1L7yX4E+Af+X5/ZeBZ8Sl0Dtrd+7Dfqm78KrXS+FfkZu8F
f5DFqjEIbkn4rpXfQG4q5vsaAN8HX096rHKGsV9EfDbp34terXGPVc6rCrPH
gWsljbuI/Rz4PWgH/eCLceeieovBXyK+K2kySb1xep7N1hOXYzGfXTe3lVrl
gWslzXRLq9HwtLnGc0n/JqXNADGLsCOB25rhcMxvTLeg/8RZfHfD/q1Jrya4
bU461g3UYP8HKsi4/Q==
          "]], PolygonBox[CompressedData["
1:eJwtkr9P02EQxh8xGqktCUNp1bbkbW0MxonERHBQo4MSOtBJWKwMGhNT/gQN
7UKIIAntJExs/Kirxl8JkACLJLorKPhjIWzqoH4u9x2e3L13z73vc3dvGB0r
V9sknQXHwOWC1A+W09LFhHQV/0rB/WvYvhR5MJeTLsSkZ9hH4HHO45aPwzsF
/yS2dEYaBHXyOfhKSs/PSTc6pVneEJwjoBmkBtilfiguLeF/hPsBvIZfgv8K
u038PfgHrwpvD/8+d98Df4k9JPaZ2FH8NvAiI22ckF5ifxAfI6+032F3TZ2W
noDf5H/B+4Md5nwbfI/437DrnNfAKlof0Nt6wXu23ju5bwJeMi9VssygXbqT
db7VjdD/MJiPZhajpy2wCVrRLFawA5x/dki1oueMs92FVlBBQy9vjGIXg89o
OfhsbcZ30T2J/krG+Vb3Kfg8doL3Y33dRPcl9K+g+Xo3b4NEtK8msR7O5yOY
P150TXXsm2gPS2n/I/ZXatFex6Md2C6+Bt/NfvC+rX/bse26QW0Xbx3Hf8e8
DuC9zfsObBctasrEvqT8P9i/MI2mdRoNh2iZwQ5QswDvVt73bPsuJz3/tOj/
xv7Pfxy0a1U=
          "]]}]}, 
      {RGBColor[0.7777343750000001, 0.57703125, 0.361875], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlWuIlGUUx4+b2u64G27t7Iz7jvPyztswEQmFUbqaVji6FIu1oIuFrlle
uuASpaVYmbekcCuoyG7EKvUh0cUgxBYT0802GCT3S1YaYUUpERkEa5K/4//5
8M55OM+5/s//PJMs6+1aXWdmH/JdxTc+NWtpMhuDnN9mNszlRwkya7af+3uQ
cWT2K8aHcma/cfctNouwHVswGxprdi5PLO5Gr8a+ZPYaPjfj+3+LWS93fzWa
fYm+ik2ZOC+Q60Sr2TfYP0SM94iVR9+Mfp3XQT3DFbMaNsPYLMJmX9HstozZ
AHJL2WwT5xtjsyMlxT+K3E5ehF0gbz6Sbze+t2M/2mA2Hd85+OzAt4M804rS
P4qs4thPnDnIN+ixg3MPNWzkbjL27yPHTaanerPn6WlNpH4PEP9BvpfQf05/
j1fUu2OwAD2l2HOcH8Z3Pjbj0e1IhcNn9N1GvlPguZTzCfIuJ+/vyP/I1wu2
e8izpKK+vL++jHq/MpuSaliLzbPIgYzmcZakl+jrLmIcwWc3trORTxJnFue3
OR8syNfndpg4Czi/Sg1TwX4m32Hs7k913k+/Q23KcQzdaEH2fej+aVGP06gh
l2qOPs9Ozu34DuDbSU8TM+LN+bxqdO54H25TxGdbqrncHQuDlY2y/zjRjHxW
I4n0F6l5XsDQOTUhVYx2zifpsbsZW+TeinByLvud28xONYcPyFULs/H6f+bn
U2q7g3q6sPkiJ87HgUc+X7e7N+BZQ99PDwfQJ/jdmQq7Gcjj1DqTHp/BphCJ
58uoPRP24gF019HnWmq4yfuNVc8jsfJPDZg0FFTjy8TcQI5L5BoDj3qyms+f
xJnA7LaCyVP0ujCn3pxrbwUO70MOot+OfjHxrifOLvTz8GvAroJ+kDhzS9J3
IF8vaxa+KxvDPvpeOnc9/rZYPLjChzbtp2PkO1cta9arwOBN9H+jv8geZ0O/
5/0diMXjubF22m2cl63hLapLxXvn/2rqbQo9RiVh6ti25zUDn0U9fZzJiWf9
9PtTohpWFsV1j92A3BMwcWyW8N3CeXGi3fMdbCH+i2Hff0DfE2wOEvvWnLg9
LtXb59w8w31npN38JNFcfb5nOf8Sdtl3+pWA4XrkuZLieLzTrXpv30m0S75T
vovfReJtNtW77JgMMN8NZWHoWO5N5Otv9ozAvUPY7CwKzxXEyJbUi79hgxVx
ZgQcvq6IV6c5LwxxvJbjxHmMOH+AbbUo3kaR3lnf1aZU8/a5LwXzWujxiYqw
dsw3I78KcYaQ16aq2fnu753v7FZ0qyLNJV/SzjvfViAvtGoWE9E/Tb8/XsPu
Z7U/Xo//b9xXVl8+Kwtvvs9hfcC5LxWnnduN1Nkc+OO78n2i+J6nLmCbR74b
uOFv/7/1moXzb3r4j+hOFMtjTmF2NTC6AX0V3aQQ33namxW2vru+r27vHPV5
+Fx8J0bC/nYhLwNf9wis
          "]], PolygonBox[CompressedData["
1:eJwtlF1ozXEYxx/My45Nm87ZOXbeOuffOruglGKWt4sNkbBihbxlTLSlZblY
yHuEXCLKEoq2xY1MyIUytQvceJ00pI0LFG2t+Tz7novfv+/ze57f9/k+z+/5
/TPbm+uaxpvZBlYBK5w1e8tGMmQWAX/PmDUUmb1k7xt4b072bGL3gLvjZrkp
ZiOstpjZjzLF7iLmNfGLA7PUBLM5xWZLwIdYFdirsQ+Dl6bNzpHrLnxv4FrO
3tmQYpaBd6ZlP8G/JWL2kdULvspeA77TgWznOwPekZZvNXqmJMzOl5utm2z2
YZpZS4XZiohyHSHmGHZdRNye40KFzvjZykJ4qWcinDG0hOGfBP4ZV/wC7LXY
d2PCXt8C7FvlqrcaexV2V0zY81Wi7URa/K65OaI993kPasED7B1Ab32p2Sv6
Gwmk1/OXgcvJ34P/FBwPo/SX+Ov4Wznfhv7SvF63p4OP5/vt9Z1wPTlxOWcH
uCZl9hX/CzhrwbOius9RVkGSfiTF73uF4M9hzmMP0Z955FvCmZFCnU+g7QZ3
3jNe/pvgqoh673fQDR7MSptrHAC3oOE4s7IIzn3gmWn5PedK4uNxcXuOfhL3
ZTRfJcR8Ald7/xncIWIecHfFgfrpdzAV3EnM8iJp6gDXJ9Q/r2Ed+DZ7yBiL
uZORRtf6l3r/4b+Ur8f9l8H9Gc2+v4Ev4OGoZt3tXuwtOcU652ZwLKvavMYZ
4BpWe5H07qe2kvx7c39pVjPks7SQdY/a7icU6zXOx24nx6r8e/S31phSL3yv
Dy3jknqL3r+n1LI1qXl6xvlBzrfGxecaAuy6QLm8Xz679Rndnde8HlyT1Fvw
mV0P/9F8Pq/P4D8X6O2NzRg445qJ/UWOBnI1YTcXqKdD1PI+o3+L1/wO3AXf
3JB61Eh8LNB8+nxEA3E4l8d0Erspodn3O+yl/u8xvZWxGtFfFdfdniRmI7G/
w9LqmmuZ18KIcjnnRfhGw7pP17QG/+6U6neOP3ziWd2N6y0HX0kp1s+E4Gpi
dYWU39/uwZjejr8X/zcOlymX9+Qaerqj0ub6/S1vS2i+/Q0+xvcop/v3f8xD
cE9O/fX/xXPwf2kPyDA=
          "]], PolygonBox[CompressedData["
1:eJwtkEEuQ1EUhr80mpBoo6O+SNvk9RESJhag0UYxFmKiJB21BjpgEbahtkAi
RqhgAaYWwMgGqO/mvsGX/+Wdc/7zn5v2R/vnBWBBinLXgFvJEhjPQ7cJh1U4
kG4dVudgW+0sQlt6NbiahWP1YwWOKvDl7GMGTzK0ZyC7+tzot6O29f/VZ0vd
lJas678mE+s/9j2rr86fleA9i/tDjhl3T91XrMf+MDd1/k8uluGzDJfqS+4z
SmIt9PRS2PDfaRqzhxtaeYaHaqydWLv2lnt3jGsxe7hhL8+/lMT3Ce8U7gt3
ficx55vf/0AlMbg=
          "]]}]}, 
      {RGBColor[0.826640625, 0.59421875, 0.333125], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlW1I1XcUx89K5sOukeH1Xu61Ln8vN0fl5hunw1EsVHqEstSKUlgPtE0M
t3o3BpvzuucXM8waq60IeldmYcM3K1pBhTVqDJmbsPmqoQz2Zmi1fb6c34vL
Of/zO+d7vufh97vRG0daexaZ2cf8FvP7ImvWXmr2JfLkCrNVJWbFcbMV2LoK
zQYLzIaD/QTy30qzIeLG8Rni+zE+u9JmBcvNlgFYkzCrxT6PPoVex9kkPgex
zVaYzaCfjcweRa7LlkdfwP83/DfC4yw5R5Jm0+ToxedetdlDflPk/Qvbfc5G
8fkA36vgNsBtQ5XZs6XwLPTcv0TOrZ38V8H9qAgd7l34x4idx7Yp7Rzex9aO
f03MrCPyGMWqvv/4dYN/E/wbVV7jGmLHUs7tdA4ugUMn+m7inxSbrcP2e8Lr
Un2JrPc0iXwvcBAX1aBaHlDTAXrYSOwc+nrwrzOofcS+FXM+pfh9D+bLfO/B
fjHpvVLPOkPetWC+mHH7Jc5Phz6r1j3Un6cPY2A0kesluLWhb6Gu82CuxP8Y
flvocxO2tkrvWweyl/7HyszeRZYQ+xy5+vDfzDz6qH0NOV/l+zb+1/DfRi/G
l9C/crOf8TkMhx+I3R92QztyN+47dhn7NmqoJ7ZRswJnEfgvkKc45CpCTqbd
pyXjM9AstHdL8B/Bfpy89eS9QN4/yPtK0OuQ33H2J/1cYN+2pnxPvqU3F1LO
rZX8/eCOUMsA8kjc9Tz62/ArpPZuZLN2Aj5NyNUZr70G2YX/GfRD6NvBWg+f
Ofi2J7zP6vebKecgLsKrLfQ9aEm4/07iPgmxsjVrt+D/T7nPXPPVTihOvdU+
lCR9Lu+IW5i75v9j5OdPEt5T9S2V9bqFqb2cAfd5Zp0Wz5TjThLXWe13qQs5
HXb4MPXurfT82s0dkd9r3e/hpL8TtRm3bYr5jJ8mnIO4DOa8z9oF3RXtm3rx
OZzauBc/gfFr2PUp5ESF51LOlir3Vf+0K9qZb9CP5vxu6o5+FnA+RX4dOYdT
yK1Zz6s5j5LjHHxew3ZbdvyvZ/1b9suc53OOr92ciHw+C4nw3tGrhrjfed19
vU9/E9MNzl0wNmYc56uc4wr/EXzrwxuonul+ao6vI5urvBd6w64EbsJoCztz
K+s7pX3QG6G3T29gT9x7rZ73k+th5LPTDO+EvDeQT8PbVYHvLLmKsH+Y9F1Y
Xurxy/BLo5chK7Juj+u/IPJd0V0RhmJ138rAGaC3S5F5/HZg7896P6SLp/oh
Dqrhf2hm6Pc=
          "]], PolygonBox[CompressedData["
1:eJwtlE1IlGEUhS8qqamhoTPDjI588zEJgdVOoUUlKREGZiEqpJAVUlIEtYug
QKtFEKn9/2G0LjPKaFMSSX8WKYRktshVUATu/Mmey5nFwP3e99xzzz33vhPs
P9Z8NMvMmvjl8JuqMusuMpshniQ+VGl2d7XZCJd1xPOlxGvM1ueanS8z+xIz
awF/nO9ncbOBwGwh22xnodlN4nhoVpNn1k/+NbAvnR/sEN8P+V6MmP1EwDCY
wXKzggqzrHyztXAMxvXzOI8av1Nm7XBuhPsVOR/JfQP/hmxpHiduDsV/H/4R
+HvTqt3JWV9aml37v2KzDrR8qJJ27+8T+Frur9B7Dz2fAH8jUC/TYGapdyZp
VgT2BR40cf84plp16N9N7ZVS3W0Cfwmumaj88JrX4WpNmP0iPgdnAbnTgbDO
uQx2oFxeuCcL1KuOqn/3pBBvbsXVS5J+o9Rb4L4wRxyTcHWjbzFbM6pH39tQ
s3R/3hFv434JrlWczaE1Uqleveet6L2cVj/uYT/xlgzePX9OrVH0jaOvEfxJ
ejkb02ycY9lrZ/TMkT8VyAPXlltidgSvGyq1Dz7/euKhQFjX/IPc71HFfnaH
u+0p1aqFv574T0Je+052wh0L5YXPOCvUjHxW1ehtIX80qtjPash9nZJW93SM
eCkq730mX8HfCzQr1zDL3d5Q9dyTJzHtnO9eH2fteNHFTDbnawdbwLeV684x
E2A7q7RrvgP+Nh7F1Lv7uwvu8bhyneMAXPMRaTmM5m/gx0LNroffX3KHM/nu
YRN3PVXy1j2fAJ9IaLYr8NUzjzIwFUXCT3NXwneiSDvku/Q+FLdrcC2fY5m3
Dv4Cd0/jeh/+xi/yfTqp2Xi9U8TrwD8o1HxGktpZ310/a0xpJj4b1xAhLk5p
971H73UmUK8+A39bHWlx+cwjZfrPcT17yO8j/2BSs3Q/u4hbA/XrO9pGvC+Q
9/7dQbwjJT7X1EDcG4rLe/Lebmfek3tylV7+A50nu9E=
          "]], 
         PolygonBox[CompressedData["
1:eJwtkc1KQlEUhVdCP95ugqV0w6thIkLlsKJ6hGaBStOCmiXVrKiJplDRLNQ3
aOogalCvUNQj9AA9Q99m38HHOZy999prccqH7f3TlKQIJuGbS2NOuq9Il3AF
uWVpAdahE0hrnK+LUm9GOoiZLUhLcJOXruE3Jz1npM2qdML7MTzRN6Y/E7mm
aT9Ck10/vHVgIi2li9I7/R+wUXWdLc7tkrQDA1jFw6jkuqY/YLaAznzFfZrf
ET6GkM57/5D+85oUZqWzmtesp0/vmHrbevEYxJ7FMrW4d/H8QtZZdvRDKbvC
HUJoJvVG7Lkt/xdznzBT9DxB0X2b/1ZZqqPxht4fervUj6hPMT8de2bLHvKW
otaNfI/tu0i8B5H32kwv8X7LWU/+Zi/v+82HZbFMdxX/0wfOf7R/OSQ=
          "]]}]}, 
      {RGBColor[0.8755468750000001, 0.61140625, 0.304375], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlFtIlGEQhocKVtZdJdTd393fXdzFlrCkGxUqypsuIjHzkOZFhYcOFAXd
RFRClpoQFB5QIbNuug3Rsi6iE2RmYiodqaC6LDt4aRk9w/wXH+/sfO/MvDPf
/JvfeLzq2AoROcpZydkYE/mCUVwgMpcvciAgMgsu4z+3SqTNEWmPi0xg+1yR
eY+zFBZ5nhQ5EhSZBEM5Ik8zRPaSZ5TYIvhriM3lLg4nCg44Zkewb2FXrBZ5
mBIZj4iMwZ/Dl02tbux+7NvU+Iy23KjIMHXLqXsDHCB/iU9kkJoHuXOVjy8z
IdIBJwNcCon8htOL5nX4Ej7rc4Jap7Cn0PAvm1i/yFli613jlHFfk28xtWAa
NdbC6YNzJmb8VrDQ06l6VYvWjXo9aC+nyd+O3YY9j0Z/nsiGNJEZ7CHy7oB/
FSwpsLqt1MkmxmU+WeAgd9vhfGAG1zz+x7DNResORSyf8vX3DP4a5vmCeY5w
tmGPgrXefALc+x3TGEjYUTsd3/2o6TyP/ZZah6n1HqxExybyj+BfDpv/Hf7N
9D+J5lDU3kbfaJz7AU9zP9jgGmeadyiJGScL7oOUvfujlM1F64aZYcC1Hfvp
2J6p/cMxfaqzHm5T1N70JvelUXvPu9T9nmNv2phnv9Wve62z1hmtJ/8wc/7D
fu6H+4ucz8j5mP7KE5ZT92UM/xb6rUmabtXfQC+fwrZ717HLiD/JDoTIueCY
TtWuu6h7cIK+FsjZgN3HG+0hpojYevAeeb6ibSvaLni7obNfZA8zydmM/0mO
xfropds1bdq3Eze/3nehrwadL8lRHLYeg/BbOJXYdWGrrfx0fDu9d6wA64LG
0R2tTlq/teBUyvZnGvS7xumkZgdz+8bc2sFOzy5Hw2v6OURfr8CgYzumu7Yv
YnPoIUcVd4VwdoGXkpZTc/eQZ5E83eAbL89fNPd6/mryX/a0XgEvev12ghle
Lf3u9RvTPmbxNcVshi0x20t9u1Lsrrjthu6IfmP6re12bRd1J+9QtznPOPrf
8B+SurbV
          "]], PolygonBox[CompressedData["
1:eJwtkr1LXFEQxQ9G2LC6T4IhPtx1l7cPI2Gj2LgWCtqIjYUYjbpFAqKFBBRs
Eku/EoVARBO1UTv/AD9JmyJqrPwTEmsTrUMgv2FeceHMPTNzZs690cTs0EyV
pHZONSfTBH4oLRKshFJXXrp5IF2mpG5wa8H5DfgSeDMnleFyxBnyzxqkn0l+
BW6UeJD80Yz0KZZq6F9Jef9l8g/IuSduI24m/s05B89zN0lufyT9ol+pVhoC
VyLvbTN9pfeLyDnL6cxKvY1SEf45d8NwT0PvbRoDRWmVmS+S/mvgz4m+zR+Q
29HsvaxHGbzI3UK1z3xL/Ts8yBK/p38dcVB0bB68RnuPmr+BdEzOGfEr4u+B
z3BE7Ujks5mG7TaW9X7P0tIWfEPBvTG9ELwUemyep/HjQ8H9NI9WwNMF1zLN
fbS+xb7fG/z+Ab4Onbeaj8SdeffP3qgMvordC6u5I/dlznc3/gR/t/Puje23
A36C3tu0e/KPuDZ03jzcoDaI/W/k0H8MXo/97W0Gm/VP8r42zxT7pJL/YP0W
4Opjr7V9O9D/kndvzCPz/jT5XzbjGHpHLVLfI9c07d1Gx3Z3CDfX4rNbfZr+
Pcl/buMNxvF/osn3t5lu4f8DZxhlmw==
          "]], PolygonBox[CompressedData["
1:eJwtkktLm1EQhgdBEPFCwfLFRJTD54eIm2RhNpbuqiTGtDVRlwarxW70D7RC
C/WyVdEIXn9BsXTfdtFuVLyh1VK1e3dZ2lb6DHMWLzNnzpmZd945bmx6cKpK
RNpBNTh/KHIGvnSI5B+IfMb+dCKv6kT+BSLf8L+DRCjSVi9Sjokk20RS4IC3
RXIOib3l/h3IggzYJdbD+6f4pVaRUXBHvZfUPaHeOOfGWpEX2CRIgXXi/dxv
YrMJfDCHPwuuArvbwN+H7x74SP8n9N/F/uZ8A/Y9pz3sG2q20OO17688vvo5
P8SMp/LNh8b1mVr6PAIj9B4GK+R0UqOG2iNxYuDS63Ph7K3mxL0+zdg+zr2g
iP+YWAG7w9scOdeBzaNzpanfDSa8FpUmkSGf80n5oXEWnPF2ktwfzjgpt+f4
XcQKzmqkvV6q24yf+556BXhXGkSWItuz7nuVnAy5a9gB5smDEvE/vNuMTEfV
Mwduic1GprfqrnvX/b+P7G4Oe+xsr6fO9FGdlLfyX4ys/3Jk/0j/09/A5jl3
tnfd/6/AOJWd/SP9T0doUESL+dA4Ktdtr+OWahja/UJoeqvu/wGE+Gsq
          "]]}]}, 
      {RGBColor[0.90390625, 0.629765625, 0.30210937499999996`], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlFuIjVEUx1c8mGEuxRlnzMw5p2++ju+NxmWEeZBomNEwF41LLiNyGZE3
knIbM0y5T+6GF+XJrSQvSGlkJkYRUrxK0niRSH6r/y4P+1v7W/u/1/6vtf57
Rxt2tuwYZWb7GaMZ4yvNBsaYNVeZtTAes/hiolmcMaspMBtmPRObVRSblcZa
c8yiyGxpHv9Ysz1Z/Py/xz/C+iFwLeD7sReI+YX4rcT5wLjHmVX41zJmg2l0
LHsnF5nVYxuC/0lidrPCLAfJlfgOhphD+GtyZoc5txLfM/Z0sPcDth7/Cfyd
2NOcewv+ReWslxGPc79z/ilww/D8Cs9d+F/iLwW7KlbMKew9yrjLvAd7KSv+
Lex9kQj/mX3fiDun0GxDRnXx+kTY2wXCey36YvFxXqmAKYmVs+fYge2Hz3Ow
TeS6gHqWgO/Iip/zHGB9M/uv4e/NqU/er1ToW1eB+rGiSvP7abOrxJpE3arh
NoOYP+E5LavcPMcl2PYKxR8mfjuxppLXG+bnI+FrsuLk3M7h2xo4nITzugrl
V1Kt3rsGhsC8jsR/Pb5GYvJrl/m8CzX3M+vS6mkTcZaGOnjPi+HfDP8dcG6L
lNM88G1l0oxrpxf/fHp9GNsU6vaROl0J/m5sQZly8ZzeBm24Rhzn+GPMh2Ll
4nUd4Iyp8BmMtd/jXI+kRdfkcmwtsSYQszmShlxLa8AvDpiFkfrq/b2HRmam
Vf8J+BqCJpfH6qvX50ykfnidl0XSn+vqYqz75vduek7D568q//e7DezoQvn9
jAfwn4w9y969ZeL5KaV76D06D/5OohoOsn4iVr7tcHwe6vM0Ur+dz0bsuNCL
zoxq7TVZkwjn+G2JcvbclzGvZc8v9s7CtsbiU5+WDjzffdjVifRwBA51/P8G
PzcrnOO7XVextOH33s+vKxTX/rz65RrsKlf+xXDblBHmO77tGWG9n48S9egt
Z21JpIfjzHvCG+JvSS5W/fyulBN3N/HT2KZENfRa+pvld9nfgEthr79tXhfn
55odDPpcgi0u1/0/g/9KqIP353jQ5J+U3g7v9XrsAfAG/zEZcXXOrdjuvO6p
v3N/U6qb36dJoT5+h0qrde92Z1VTx4yk9O/+PuzZvLTnGvyRUl6u5TznPoTn
DXj+A3dlznE=
          "]], PolygonBox[CompressedData["
1:eJwtk7trk2EUhw9WMNWkgkmIzZWvL23GIqigOKh0UCipjQneqDWiICoVNxc3
pWKHWtpivZToX6BScNVuLTVoFUVdxNFBRBcRRHwOvw/ywXPe9z2/c0109kp9
YoOZDfFt5GtGZgNJs5ccNuBZvp7NZuvYM3AzmE1jD3SZHYUvVWQv49vKmuWw
r2HvSJi9K5h9xqeVlP9HuIZPBd89KbMR+ERs38DnJNwqme3tNhvFf0uRGFlp
e4y5frOHaPCzg2guAkeqyjfNWQ2+j8ZruI7+A3i5qliu8QJeiZSL57QKP46k
tcpZGz5XNvvdLb1fGfQj2X5fgyeDanf9W/AdvkfkNsjZNHw70lvXnPLag+J7
jePw9bL66TX8Q3+qIn/P+Sq1vudi0JTfB3iYsyVTfyapfz3O3zXewl/R+EN+
K5vMttHv5HazJ/TuG3YTuxjknyeHElwv6M7fzNDfDhp5tD6huQYvFMX+5h48
VlUtnu8peL6s955jIqsZ+6y7yOEmsZeqiuUxn8Fzcb98fvPwq6Beec0dOAp6
38tZBX6eQyehetJop0rS9vtdOdXkuT3lTYp4P/j2xfuSJN9jOen72Xl89+e1
y655nPtCUC99Hr3wcEW259ugnp4+1e81boX/ZlSr2yP0v6+kXLzmAL+J6/ed
P4B/p6rd8HmuwbNF5eqa4+RyN94P36kF+ExWb70fbfQvVjV7j3kB/pLRLvr7
nf2q0Wv1/8h3ah8L2m3fsdNBPfPe+U7sZlY/M5qd78sQ/hMl+XuPLsOHIvXH
/0OH4XZQ/j6zRXg0Uny/r8ONovTdpw6ng/rhM8zA/wGi5I7c
          "]], 
         PolygonBox[{{5572, 5571, 7431, 2304, 7430}, {7012, 7011, 7334, 2234, 
          7333}, {6935, 6934, 7735, 2553, 5345}, {7313, 2223, 7314, 7011, 
          7012}, {5347, 2555, 7740, 6934, 6935}, {5441, 2680, 7960, 5571, 
          5572}, {5613, 5612, 7522, 2362, 7521}, {5488, 2738, 8073, 5612, 
          5613}}]}]}, 
      {RGBColor[0.91171875, 0.649296875, 0.32632812499999997`], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtks1LlFEUxh+KxOyDKZT3BWca30YZcFltAzMpNZ2R0Y2OWmMu+lCrv6Gd
ukhT0dESF+IuIguitQvNDwR1URERrQMVpU1Bv8u5i8tz7jnPee75uFHfk9zQ
CUm3OCc5mUiqPSu1gQeV0s1SaSYlfeZ+H/9RIC3Gpetw+4lfrZGWzktXwEJC
+o7/dwXclOXuwxklt4Hcr+SueZ1VcMT7h8EVchbJvQFe85o/yqUv5PyLSd1p
uPjf4T/A/wr97nPSPDjF6cTeCYkHVn8WzWPudaelQer6Sc4p9APqGSN2G85L
MIvmJzT/Es94uxWcocdl6p8G59CJ0K/inWTK7AgsUOtCmfQ4KV2sNH33ziax
QTgbYIJThR0Hx/zccnDnuOfx76L9LbB6xqln1vuLbn6+33pwy2sewr/kNWex
35P7nDrb0d4LbSaviQ8krPch8K7Twl8AP4Zm38POMNNjZtuWtrm4+n+V277d
7hoD24fbyzbxST/nCfAZ/mV6H0navt3en4J/yOmnlw16WY/M3gTzadtjD3gm
bnz3X+6Q/wKdVnA4aZqj4JvAasvC7+W9et7tATsqjN8C5wGxkgvSI7CJN9K8
1Qjm4jaTDjBPTh25H0L7r27+bg8lCevL/bsUdoxZXQaLfu+x0Pp3c3B/ucvr
dILVnl+E0+zffQv3MLB6HlLPf94gd/w=
          "]], 
         PolygonBox[{{7152, 2115, 3394, 6327}, {6994, 61, 2603, 7835}, {7249, 
          2178, 5, 6930}, {7120, 165, 2693, 7987}, {9053, 3394, 2115, 7151}, {
          8042, 2721, 2115, 7153}, {7531, 2367, 221, 7179}, {7151, 2115, 2721,
           5473}}], PolygonBox[CompressedData["
1:eJwtk8tLlGEUxg9BUZE6gdMnNaN+fQ0DBQUzrdokammpM2azsbGLFmSaRssu
qxwLVLoXNWNKq6hFhBZZ21pojkG3RVr0B9TGUNoU9Ducd/Fwvu89t+d93nP8
rjNt/StEZBdYCQ5GRAZWi7RhZzeIFMGrjSJT4HYg0l4ichc7w/80KPLdx9l7
7E1fpGGdyA3sT/J+gd8V5p/Df7JKpBv0RUVq1oicjloNrTWGv4O4B4H10p47
iN0OmsH1tSJN2M/UyxJXIG4A5ECaflvpm8J+o+d3kNnEXUChUmQbuXlsEf8J
4maxi8oNjFBzEv/ZsEgZdw6Bj+R9AEl8g/gS2PPknwNzrsYfT+QKOZfBYrnI
RKlIXYx8+E2i3/2I9VceOcd13N3xi8aQf4m4A8SVExMGjfRpAL3gIX17sKX4
S0C/02yZ3CWwm+/eqPk0ppraPrWrsGNoNw4uwu0C+AG/R/BLwq82ZlzrsZ3c
pwu85U5vQE9cZNV6dIHbIP85cJizfyGRr569p77rNOfH0eCdb/Ohc9LId5yz
/dhjcKiDy1HsY3g8AYmYcdiJTdAzCTpc7WzcdFQ9lzyrPeM4Kbe9YA9oJW6Z
+KeevZO+Vz6weRjFNoMm0On6T6FTHoTQKojam+rbam/l0OrmZsIzHVSPW26G
FzgrkFtNnSj1ykAILJA/DyKB+SqxL4ir4ftQYPOqc3uNu1wFf9H+NfdOce+X
xNUSd8TxVL6qjWrUHliNLPZThe3ZncDmQedC50PnJOP28zn80k6PVNzeWd87
5Lj6bh5GqdUSMw7pmM2wzrLOh87J5qjpswX7zLM33Of0Vt11l3Snhviuxzfi
2w7rLg+73RnCznvmH3Zzo/PT4vY2EzbNVDvdOd29exHbkzz2lJu77rhpptr9
B0XVqxo=
          "]]}]}, 
      {RGBColor[0.91953125, 0.668828125, 0.350546875], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVEtIVVEU3VRgicoTep/et8vt8moQD7QHTSLIMklfTywrTEIeQSn0giaB
NMx+mEZUhlk5qEmD/lpNKxDFDPpRiRU0aRDhtw81aC3WHRzOuXvvs/bea69z
ncLhpuIiMytiLcaqTpp9xqHKMwu4ZheXmF2JmNU6Zp9gvxs2S8K+fqnZZMys
J2XWWWL2I2g2C98yxD935GNMDv6NUTMHMTnYq/B9ATGv4P+A+N/A7IJ9KqZc
6+DPYrUh/gUwjwV1N582+7vcbEWp2VHUeAuY7bC3oZaTiFmDcytimmHP4Hwi
btYA301gPkL9AxHhs6e9ru4S4z321WXqucYTDvFGo+rrUMKsgPjN5Wb7sXfg
uwl97UHtvUHlakfeAmr6A4xNwPgFXylydcKWr1SuG/hujKsX8vEE6wjO14B5
Pap+V+J81a+TfMyGzL7BPg5+KnB3DPZ5+BciOtMWRNwX5H2AnI0xxffBfhlY
Lai5D/sM4kcRXwl7V1wxjGUP7GUQMSOOeiF/P/36tyImEFdMN2YyFRJfecS+
BeYwYo67msnXEs2ed3h3Iaz5sS8HnLX6mtkA+zTmWI47+8BPbZk4J3fUEDk/
gPjbYemNutvlir9h5HwYVr/sm/2wrznY+4GVwHlnTNisk9rKwj6CcwD27yHV
eR6YDY7mXo/9Xljzzzqqj3V6Cc3nX4X63J1Uf3Pwn0ZcDe6ewt6DtQXns9gP
plTPLOqpT6nmDPYOrCGc67BXe9IAdb02qR7LqX3Y55Cr2dcy8Vl/ryOOzmGf
iQmHeOyT/QaQa4K6h85epoVFzDuo82la+nuW1nvju+tH/HhInOyI623wjUzD
P+GKf2p/VUKzozYnw5oPNT7oiZNCUFyyd/ru+xzy//HYx+T7I+/MlYF9m6Mz
87/z9VNMqXZyzd74VsgD75/x+SSvA650SD1u96RVvr86n9vXEf1HyNlH1NLt
SAPULP9HnN087P2+/vm2xhz1QF3wrVK3OU+aZm1vgHnJVW18rxl/pkOw/wfe
0cdg
          "]], PolygonBox[CompressedData["
1:eJwtk0tIVHEUxg8VTIlTCQ1za+bOdJmGsUUINQOttYLSacSwoCLEgjDIqE3Q
vqhQe5CVZuGitr1IaV0LScIWvQt60KalOtmDWvQ7fHdx4fuf53e+c27Ue6yr
f5GZtfIt4WvOmf1ebNbWaHYuMrvItw38B9tx8K2C2YmE2STBrwOzFyWz7iaz
Cd6X8P1Imy0DfyNmmvhD2LYkze5g68yblTNm7/AlG8xmV5ndI/4TtSNsnVmz
aiT8GdsDfPP0eEbuKWwz1NpPv/UJcXyP/36cP4VtB7kvA3FxjleJ354Rl9X0
+0u/UfxX8PdgWxeanczJ55z3gM9Gmt17dKwRZ+deX242XDQ7kBN37+9aXYPz
d2JDYlZQe21BtYd5j/Hug29LQvXn4VqP9XHbFL2eR8pvwPYL34e0artGA/gm
qHEbXx/vfdR+Sr1ak2y7eU/G/s1L0Yb3bEZ8XfODvEf49ialyVxGO/RdbmXG
IXA91reL/COhZvbZfecX8N8INIvXz1GrzMxfYr0r4JWBZvcZRtHibUpcneOT
km7CezuH6+CvKe3Gb2YG/0BevZ3DefDhULv29xy1o1B6+s5GeJ/JSjvX6yda
DZIzHd/HEHgw0my+c999OS/+XqMCvhzJ5xp8JL8/r1v+x37H2W9PQfxdw8f0
W0irl893mt69KcX6DD7Lq0D5PsMYudW8tPKdtINrJd2z3+hdao0XFOs5b8ht
h09zo/bt/0Yl0u27rQNcDFXPZ7hJfC1SrMc8pN7RWC/XYAF/tSi+rtFO8K6s
duU7e0R8d0q37DP6rlpy8ju/DeDWorTxG2gDbyyql8+wCfwfRFmfgw==
          "]], 
         PolygonBox[{{5961, 5960, 9059, 3396, 9058}, {9111, 3418, 9113, 5960, 
          5961}}]}]}, 
      {RGBColor[0.92734375, 0.688359375, 0.374765625], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtk01I1GEQxoe6lClS7LqR67rLn+Wfh7JoN6jIKLqIbixBuUV12MpEQlui
oksUWVSgaRDWIZBAL0ZfRIcugR0SDyUUBRFBt+gQfUrQpd/DvIeXmXfemWee
+Xhz1cHdA4vMrMJZzOmJzLY1mPUjd7WajdWZnUDONZk9x7GUNrueM5tF715l
1tlsliVuGNs09ywg7S1m75NmM9j3ID9z5tGrSY8Xzix4Y+SokOt1bLYjYH7A
XgBzBf5d2B6lzNrqiUPfCI/L8CmBUwx6odXzKW8Hvi/xq+L/C31vqOVF7LjC
P8X7Oc48+pcmx87WOyfdZb8Gx1uBmzg+o64Y/En0RNprmY68BsVtAq8fDh1L
ybvS7AdnK/oxbP8S3h/1aUPOc5Xg8z3hNapWcdze4DUciFx/CkYxY/YXnAJy
Nec3+iFkb4vj9yE/gbOAvhb72aRjfsRW420deHNwX1bnPVFtx+nXXe6jyJ/N
PqOj5NyXcn/FKUb6G+xDSef/DczbcGokVw6fBfynljAD+nEH+3LseeyD1LiF
XPupcU3GubVnfFfU/yu890Veq/alLdS1E3tX7PxVx+bQK/XsZt73sAzn9Xn3
V9xIyFVDjvD2BJ9h5OlgF5dL8JuE5x/4Xs15rHr5Ds4H6fMEXG6EWT9ENmJ/
jP84cZ0pn/u49ijvfaxk/Eg/D14l9v6oT92BcxE5E3tv9Q/uR46jPaoGXdhT
kdelf/Yq9r3SX3kb+Yw0q1qoZRTZG/ZZf7Qc/uYR9Im8+w9guxdqUU3aY838
K3vaEzifQR4Of1PzHwr9uZj2fghHsy9zv4D9ATxPhv+r3f8PMOaUpA==
          "]], 
         PolygonBox[CompressedData["
1:eJwtUjsvhFEUnCyFxyoIVsSu/XLDF4mCQoGwITqESNYrKNYjbLEkgk5oPAqv
QihFYhsiNFrJKogCCVH5BQqR0GnM5Gxxk/nuOWdmztzPS8wPpAIA6nlyee58
IFYEZIgzxDVhoDgfiOYAbSFgIgL88ruE9e9S4LMceCFBOg/YrAK2POAhYD3b
xEcO8Dk7TM5j4i/ORDlbWECdGqA9ZNzSqKVWl2ez4ugkTjrzo55Z4ibeRYNA
Hc81ZxeqgYMC8ztZBkw5+5ZmgnglYlrS/KN2gj0vxKe8O6F+Hz2v0/st9R65
S6raauPUfK8Arpx5F9+lMDUbiNvpMUm/sUqbFUc/uT5KLRvt0Ej+G3J0FNkO
g5x/dTYvjTdnmWo39Yzxu9uzee3YQzwXNi3NjLD33Jl/ebogbvZMX/0txPs8
rUHLb494o8reRm8Up9d4mWWljA7pb82zfFRfJe71LFtxajfNqJbg3T1rz75p
y8MT8YmzrORP2Zxl31v8aeJR3/wo/2Hin5BxSXOIb7PjWU09u9L3bRdl0E08
7cyv8pshXsr+X+pf1r7Z95KfRe72Dx65XfI=
          "]], PolygonBox[CompressedData["
1:eJwtj7FOAmEQhCcmJGKCesbLkXDHcQ2d0nB22kpDBB6BArSRhDcwKHSWUlFC
S0J8DX0DiU+gIUZCyfdnr5jsv/PvzOwm3UHn8UDSKciBaiR5eWlWlL5K0hp8
n0s7uLTMHL0HLnlv4S6oBfpjcI/2Gm6D1gulMzAC80Pphdpipp15Ou96LI2P
pKvYZp3mD+0NHg94ffrSB0h4n8BVqE3fNGlsf27mF/yAfpbfiyzH5U3xXJH/
FtqObtdlID3B3cE16G/Bf2B7Pod2n7uzlt245v4J/IL/bWDzTjck851dXmPL
d3vsAQlkLik=
          "]]}]}, 
      {RGBColor[0.93515625, 0.707890625, 0.39898437499999995`], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtks9L1FEUxQ8ZmKGWOjojM9/GadDZmW0CzVFRkyBNtE26kRRtbNGYUS6C
Giho0ULd+A+Ev0irhW6qtQsXQYxGqEi4dJEbQQZc9Hnct/hy7rvvvHPPvfeb
GM0OPr0gqZWviO9dTDoqlu5GpXsp6fSq1Ad+TkqjZdJXcKxa+nhZmopLJ8SH
vJsGb3FuvsSZt2vwHsH/BFZwvgjnb0ha5jxC/k9EGgpLD+BPBuTDVquXWg2B
6bSRq4wZJ0NuIrBaruYEOnfQGQebyNeWSN/QzMbN2zMww10PnCfgdo20RV/9
6K17b3vw9yPW1xdyv6h3jochPLTX02u59A/PTcRLxDfAWXQ30Z8H2zwnDa7z
NofP++g/TJnOMHjTvz1Apw6fG/j/if/n1aYzh86Sn8li0u4cpw+cCqz3KjTL
o+a/8Zq0wLkRzgC5zoRUXyp1gx/Ir8Av4KUnant8Bf+93+kxM3js5/advg9D
the3nwLnTmY4Hdg+XF03+5foptF/Aa6FrVYX8S46WXTOePcjYnOeTNru3e7c
Dg98PBC3/8l5cF5+o9OBzht0XicszoG9MevxStR6cz2+JdfC3XU4zeBtH6+G
bZeO72Yz433mye94b3nwP0jnaS0=
          "]], 
         PolygonBox[{{5453, 180, 2105, 7990}, {7243, 4, 1990, 7244}, {7803, 
          2018, 46, 5373}, {6330, 2329, 2105, 7132}, {7537, 2370, 2131, 
          5977}, {8017, 2105, 180, 5462}, {5866, 2018, 2216, 7306}, {7726, 
          1990, 4, 5342}, {7299, 46, 2018, 7300}, {6927, 1990, 2176, 6061}, {
          7245, 2176, 1990, 5834}, {5950, 2105, 2329, 7471}, {7187, 2131, 
          2370, 6393}, {7528, 2131, 222, 7526}, {6137, 2216, 2018, 6982}, {
          7535, 222, 2131, 7536}}], PolygonBox[CompressedData["
1:eJwtkr1OVGEQht+QmAgRYrELR9zVHI8nG2zASINmlfBjo2Bi42JDxKhglF0g
arDQLaCBQsFLIKKG9aexES9AsDIIIcIFaEOBJjYWPpP5iiezOTvvzDszXzxS
vjpeJ+kkHIChY1IJqrHUfUjaapFeJNIifICRRmknklZbpU/wkm/DfHtFvHJc
GoQKLDVIZeJsVpqBvQz6Jul8Kr0Pdd4lXsNqLZD7Ec0UuZmclIVT+GiDPryk
eKnh5T559+B5yH9GHKPOReqNEleoVYM35J5AcxbtGeiE7ci9Lifu0/z2hto9
xB/NzNbsuaYZKEh/DjMbtX4flfbhFtp+atwhfqXPOmzwu8y3TeIGuUXqPURf
hgq0M/Mys59OfR6bqxL+v06Pf/T4hq6E/hrcDfN8xu9E2OXNrPc3H38j7/c9
8V3YTtbw/QW6Yp/7HLGY+s4vpH5Tu+1Q6Fcq+F3sPr/Q/YQ5dv76oDRPnMyz
k3r6531Gm3U18tlvB5/md5DcKpqBnPdfCzu0XT6IfRePbLdob6Cthbdkb+pp
eGNPYu9vPh7jZxp2M76zjtTfgr2JlcRrvCVeDre5VPB809nd7f7teD6C9w7i
f+dUb2U=
          "]]}]}, 
      {RGBColor[0.94296875, 0.727421875, 0.42320312499999996`], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtk01IlFEYhV8q6MdFi9Lvy2lmukwfExEl0UIQpUhamPTHIBmt2khRjZUQ
qODKRbSIEmpti6ZMCdoUWcsWYRBW6pTTInftgshyEfS8nLu4zPude+55/86E
C9UzV9eZ2SnOek5WMFsmCPyupWbvN5ht22m2g+/f4B8Ts6mSWfcmsx7im8Fs
aSNvWsz2wmnAOZCZ1ZvNLoHvz5v1g6+Cd4JXimY1NO8TT7eKcxG9GucG8SxY
nbiC/jn0h9HZBd5bNjsfdT6DN+XM3oKXwbrQ2kM8DrezVfzD1PUBnTly/U11
55x+dPqI720xO00t71qkc4Ieb3O+E/8Aaw/Scb0Hmer0nibQfInmVzTbMnG8
xpNovQCvg8/E+pvRa6TiD3HfFWd1MKdvxyfRWI4c1x4KqrOHvPsKqs17XUzU
u89ygrcj4D/Je6WoHv+gsVASPsfbsyXNeRb8darYsTcx9j08zDTzFXQG4k5/
kWsh5vJ5+w68l+fcH+Ouibdrifbkb5+BHwryzBPwwSCffErkIccfE3cE9eLz
9nz+dp5d/NtulmMXIwX17L2Pwp0saZ5fUvnMa7sMNp9I3/NMJ/Kb+66WKJfX
0p3THm8x/+Gg2DH3qM//aNCOHR8L6tn1rxW1G+f0oVmJnnfvP425dsPvRXcM
/nF+B/H3kc1m1bzunDOVaAe+i+t57cnjxbI84fO8S66lVD16rzO8+cbbreS/
E3fqu61GX7m/2vLyof9vGvAegb9CYzUV3/3+H5A6mL0=
          "]], 
         PolygonBox[CompressedData["
1:eJwtks0rRGEUxk8ojIWFxZ0yH27TNMqEpZKJyGpSJGVrI5LxVQo1a1nIKNYs
DMOkbHwvrdj4HmYs/BGG2fmdzl3ces77POc8z3nf606kRmarRCTOV8P34Rc5
BwzUieQiIn/U99Sj1AXqoYDIXa3IV7VI3hHpdUVaqEvUx9RtIeNUEwf3REXK
1K3UCfAe3wXzFqn3wacRw3pWxOsxZrVmeKcej1nvDzMemT8ftmzKp8BjeLx7
/Cj4xTG/b85WyLYeMNyA/g+uI2pZNXMneAr/aXAW/ga/nGO8zkzQ30T/A1xf
vchcUKSx2fZLkyEJl3Ztvnq+0fvpt130vvLMPosY1rMS3E7UvNRzF/zkWHbd
cYlZV2gOPL4Tv37XsmimE7TPnl7PluHeuJ/VWnujMr0Vx3bVTBvku/abn97Z
JFmGubOMzzxK7LIQtH7dsYL213tvPXtFX/D+B32TLHUmbFrlt8FbYdtPezbB
h/gXvfvtIt8qb9Lss0yD+CVjxqkmi/bI0+v/0o2+PWi7a75LvNdcuxu931e0
sZBptScKnonYbrrjLfp/rLl0Vw==
          "]]}]}, 
      {RGBColor[0.95078125, 0.746953125, 0.44742187499999997`], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkD0vBFEYhU9o2CCRrJiClckYU9goUSxWpReWUtD5DAqfP0C7kl0tW1ir
QiJR+A9s2CH8BZWPbCPxbN5b3Dxvzpw577nXX9yYXm+SFHKaOWO+FLRJGfjg
SVPt0mogXXOWmG/hSZ90l5Dy8ADfBP4jOJOSEug5+NJt+iH6CMdnHoYfnuXc
kHOFpx89iz7u9lbQ7vF4rdJQLxm+eSZhjJ7rlJ4iadRllvHHZG2SWYNpdv/w
7yB8T0pfzAPMl3xbwFOGK4Hdaw2WuPhfh7TcJW2TmSFzC+64uUr+L3vn2Vtj
b8XlvKGlQ7vvLPmPkXWrwlfXp44nTFmHCBbxf7OrAOvkXrRIxz28VWT5MTx1
njn6nLtuZ3C/8Ub0eea/PTfvws+kdWh0+QfcJkQ+
          "]], 
         PolygonBox[CompressedData["
1:eJwtks1LVWEQxh+CwEyFILnHj4zX2/Fu0kWCudCrghF4d6IWpiDWzo9Eb1Bq
+1oH1VZd+LWyoF1/gxrpVcqNroVECzdCv2HexcPMmTkzzzMzbxh/2T99TdI9
cB3sZ6WZSukAO5yRnoE0kAcb+NkKqRO/sUEKYI1YIPaQWL6WHOi2/4l1YTuC
1+SxD+qkVjBrcWJFbB//F0Bb8D7twXtYr1H6j4CfcOTJvSFXwO8Dk+h7jM4J
bLFa+lYufbgr/cE/A0e3pb83pPvU34SzArwgflUlLafSMf5JhPm7OWnolrST
c42mdYjacvqe0msNnjH4NrLOX4i7sR19Ifac3Ba2RP1T+vxLpG2+d8ArdBXB
Uur8K6nrMV05OM7R+QuOQ3QcgJY7UkKsGbtM/RI4TJx/Pev7sr0tso8u9rKA
fUSvXvC+Xlotk95hv0ZdvxPnNx098TabGb+p3bYpakjjTe22P+I+Sonzm45a
4jWWy/j95oLPZ3NeJv5uSvhPmOGCOT+lPo/NNRh3ORB7WC+7k91rP+5sDzsV
7/qdfgPoHQRv45x7GX8P9i4sbvmPqXN9xr4O/k7mg+/CdvIfOkJoHw==
          "]]}]}, 
      {RGBColor[0.95859375, 0.766484375, 0.4716406249999999], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUksrhVEUXTGia6Dupe7l6vh8LklexcTrDozMlBShZCaUR65kwMhcysQE
A0pKiCQTxcQA5Z1HGUv8AmvZZ/C197fO2XuvtfZxQ+NdY1kA2vll83sNgLE8
4IaxqwRYzgVmGPsKgTpeuCf+4O9cM75ErS6SsH/hDylgjTXfOUAiCawTHyB+
S7zGAb/EA+KVzC85/LEAyMSAfPZ5ZL+GhOXNPJ9gn01yWGFs8rWlrF1kHiHe
y/yC9WfsU07sMDDO4n4aBypI7oDYVdz4PzEfCQzvpKa3wHCdVxcD55z7RC5f
UeMgLoNl9IP5Ee92e09GmT8Hxk0cQ86OR4C0M83SXsU88PhuCNxR/zv7/LB/
rTPO4j7nfegkh2mvd5+9+5Omcd6Zv//7Ia/pmPERrzbfp5W1q6FxE8eUn6v5
x97/DcbrlNV+xsxH+VmetH0or3d2pjvDjLPeZ3E58b7J123fU7vdCI2zuHeQ
JwMyrNsJzUPtttdrSROLe3+6Gfe8/3pfS0VWqx56E/JkwZlf8m2KscXrkt/S
LO2NzrzT/Qln+9Mee2L2jvUmPxgnnc3VfO1eWrYC80VaThn/AEeMcEQ=
          "]], 
         PolygonBox[CompressedData["
1:eJwtkE0rhGEUhu+MDQ2lzMZi9Hh75yXfFmxI8xeU7CzESkaRkCz4C1I2VmZB
SQmRZGNhi2J88wc05Re4jvMunrrOx33OuZ8wNT9WqpHUxqvlLbdKW/XSDTyT
k+Yij9sz0izcHUvlRqlaJ+3SO553tlwXtW1yZfrv0S+hf26WmuR10xaCdM3C
lqyUwMPB6xaPBJ9hvZb7QXvFzskG338J70fOljuAK4lUgr/of4Q3mHHL/Cw3
bMLF2JmzVGXeRM69macdagtpv3lYhKdzfrt52KO+HlxvPWvwe+S7bOcHPJj6
+UU/BL+Q68+4/hV+SPxWm3kHf0eutZ5P+DT1Y/ecwUex/4X5P4SLwWPbMQr3
8Gj/39cLDwRnq/fBJ5HvtvnHcCHvddO84b8zuFfz0wE/pffaTRV4JfhfmedV
+Dzy283DBfwHwqJQ8g==
          "]]}]}, 
      {RGBColor[0.96640625, 0.786015625, 0.495859375], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkMtKglEUhRc1EMRsoviDofxEXrGLb+CscY8g6dDQCMfmK6iTFEGoUQWB
5iUfRMvbG/QAgfT9nDPYfOts1l6bs93i3U3lQFKMOqRmp1L5SJrD3Blvv7QI
Sa9o37H0Drtx03+C3/iq+JdwTdXQK/jLzEdQKuD/5H1Lf+NIvYjJuU5KLebH
5HRg2pVOAlIWvuCJo6/QKSqK7tMbRIwnQ29D5j2ZO/gQNjltci5dM5uHF1QM
fQ6TNicBm1QBvSDv0eoGnJBVInMM947J36J3jrnJF3pk/zL0vOx9Zm+dvT17
E+9mP/Ymf8xNbebWMX/2/v6G5x+PSzgq
          "]], 
         PolygonBox[{{6518, 3565, 3429, 9145}, {8483, 4338, 3099, 8487}, {
          8086, 2743, 3565, 6518}, {5336, 2746, 3848, 5496}, {5496, 3848, 
          3847, 9644}, {9311, 3565, 2743, 5493}, {10058, 4338, 3847, 6045}, {
          9647, 3848, 2746, 8092}, {9646, 3847, 4338, 8483}, {9143, 3429, 
          3565, 9311}, {9645, 3847, 3848, 9647}, {6047, 3099, 4338, 10058}}], 
         PolygonBox[CompressedData["
1:eJwtkMsuQ1EUhv9ITATDatqmJzsbcRm4PIG+QjtjJhgSbcIYr8BITGjNJW6h
pkwYMGqJtu8hxLey9uDLv86/11m3sL5T3R6SlINhOM2khxHpDC2WpRIsBSkb
lRbRZxJf4DFKW2Pkou2C9FRw396nySuSP4N+8P4OA2iQ/5eXerBBfINXpU8N
+nibePd4F9CEX7w63neqYbWsj/W7jl7jFv0hb5f4k7hOrQasMfcqVKakq3Fp
BX3jv1foRs//QueYscSss2iH2bs539l2n09v5xPSJN8RltMtLvE6UCE+DN7L
erbwyngLwfPtv2baqZ1uNsj7jDbrCdxx7+N0B7vHPrTw9jKfx+Y6CN7rCO2n
W/ai72N7/QOBgUeg
          "]]}]}, 
      {RGBColor[0.97421875, 0.805546875, 0.520078125], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUbtKA1EUHF+IH2CySTbZhCQo2ugfCIKvUks7sdbCEBTsBL9ARPAtaid2
QhQbEawiYqFRwRjwC2wEXzjDpLjc2bNzZ+ack5uZn5xrBTDA08bTkgDu2oGx
ENiOA48sTvQA/VlgtQMYTwONPHBOzmIEDBWBT3KmM0DIUyPeZP0yCZQ6gQty
1/hdJX+B93u366PUOS3a64T3FP9ViF8D+oXW2aP/ftxYNeVQnl3WDpsZ6oF1
pf9N/BQDHqjfl2NPKeMS35YTzr9O7gczLKvODL3kXRPf8N1B00t9/FHrlpr3
9HnJm19Nuk/1WyO3QPxMfES8krOX/PVGb3+pMRK6riyzBeffiVtLmnVyK3ln
U8bh0DPRHhbTrmv2XSnnDOi5FZmj+X0F7v0q7SP8w1oj8Hy0q1jGvvI/jjuz
sp/lvQvtKpuxvnw2ImfTnDQX1QfZ31Jkvnb41tTXHsrN3WmH/56RZDI=
          "]], 
         PolygonBox[CompressedData["
1:eJwtkL1KA3EQxAc/sLXKHZLLeRyi2PkMgsbWR/ABTHNFAnaCTyAq+G1hZytE
W1vFygRFo49gJaiIv2Wu+MPMzuzOf7fY6Kxvjkma4U3w2vPS57Q0GJeOE6nK
pK0p6R7xO5XWav0RvtyUflNrO5NSF+9ebhy1XfAbeh9cMeO6pD+zfkPtA61i
xhPaF3kD8tpNzx7Cz+HDxFp4tgvpNPHf7uAL8LRlHLUGeKkwf4Zf4h2lzorM
Pvl5y1p4ZsGHubMi8wjcze2P//bAo9L7P1D7Y9ZPvW/UXtBuS3uj5x3tas6z
4kZxy9XMetzgFf0scV7ss8KuJ/U+4Y/b7ufOivkH4MXC3ui5wPsPVsZMeg==

          "]]}]}, 
      {RGBColor[0.98203125, 0.825078125, 0.5442968749999999], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkD1OQlEQhU+0QWvhvYL3gITE6C7k/1m6AkMCJRSioug6IJAQbHAL7ISK
gg2YkFAYQ+E3mVvczJkzM2fOnUp3+DA4k5Twznm/VennQopS6RHcAL9QLKTO
x8Qn8jr4SL1dlD5zDIK/IscduG/yW3rurZd8Ap9dS/OStL6U+nlpBt6Ap8Qm
PR/0pOj/xa4/YnaL5gJ+RH0fu2YG/xZ0xsRO4rzt3NFzA27b7JV7tj+NE//L
KfYdtquBZi1461Xdn+Fl5LnhO+qt4G0F/xp07DZldA7gUuq3MM/P1N+DN/ur
3cVukqHxD+FQMek=
          "]], PolygonBox[CompressedData["
1:eJwtULkNwlAUM4iCQ7QkkRIOQQVTQDhT0tMgami4FI4dWACBhBiETVgAUSMK
bF6KJ8Wxv5/9atPFeJ4G4HIynFkDeBeBVw4olQGnbN/6F3tAFABN4iUxiGPi
PvEhCwx8YJTwwwLQqhL7xh05NweYlIz7a6jdVoB73vyedWBDzxO5LmdD/hEY
Djkf1zz1XvyW3CowThq9XQfGSaNdbe7fZS2jsl6YYZ/kiXzroN3KEDPL2TG9
+uoWyiyt3vSoT3nmJU3om4d4dbw61kF+6vd07Wbykr5D7de1fMqrbsPkPvKU
9w/MXDNQ
          "]], 
         PolygonBox[{{5619, 5618, 7540, 2371, 7539}, {5478, 2726, 8057, 5604, 
          5605}, {7236, 2172, 7238, 6960, 6961}, {5494, 2744, 8088, 5618, 
          5619}, {6922, 6921, 7704, 2542, 5335}, {6961, 6960, 7284, 2203, 
          7283}, {5338, 2545, 7712, 6921, 6922}, {5605, 5604, 7495, 2345, 
          7494}}]}]}, 
      {RGBColor[0.98984375, 0.844609375, 0.568515625], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUc0rRHEUPfNhYYoshvHy3kyT35QpxMJCVuR7aW9h1LBiMRl6kyyl7GVN
wuxY+StGNqKUjWIj8hUWnNN9i9u9v/vOPffc8/Kl1bmVOIABRoKxHgDbTcwe
sOFZXXLAXzew2wIkWS8ynlkvMJ8x9mLAXY/NCL9GjknGFfke2oGQ9QvrUZ88
nUAjCTxyrlGw/jsxg11AG+txYk6dYYStcPae/TdijtgfagXqzN+MLda/zBOc
uaH4wwzwxPdFCtjPAVO+8Wt/mDNOUGNfnv1mIMgCcWd36b75DrulGhiXOGd8
wwnfT70V33RK73RgeM19kGeTer6c3aO9MdYp4uTvbdr8km/nzCfRLbpJHsmr
MvOnMw/l/UGkoZd6l9l/5WyZeYwadogJPbtT99YL9lY/kzW/5FuVebho2qRx
pGi+yb/rtGmTRv0/3XLszCN5NRvYPu29JP+PM/4avyecaZPGWrR3ib1/eyVf
zw==
          "]], PolygonBox[CompressedData["
1:eJwtULtKQ0EUnCRaKEQsDDb35gF7C0HtBB9VRFFT+gUS8VFpIRoQxFIEe8Ef
0GinlV8RsZF0ltqECKKijTPMFsvO7DkzZ/bUmvvre3kAVZ4BntkJ4JX3yQgw
R/wdjM8GgS/i8TJwTnzKtx/yz1iX5iAFyqz3h4BuAVhO6Mn6RdG8QDxPT82T
foH4MLW3POS1RM0o7CGvHN/6sEeeeIOnV7SmRe01+Qy1lzlglbyeuP+DPVus
7QTnFd8lfoh69d8Tv/F0+PHHYeCd+C766e022ENaeSzS+ykz14wO8Vrivykf
2DtZM1f+KeKj1LM0U9mvKp4l/+OKd6hdaCcvY5yfuf5M3ioBjdS9yqS/bpdc
U4+8EPerPCvM8hf9lPeXuBm8K83fJL4JziO/NvF05qzaeZfz/wHdhFP2
          "]]}]}, 
      {RGBColor[0.99765625, 0.864140625, 0.5927343749999999], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFUr9LlWEYPfnjgpm3vlDiEz58L30XFNI0wa7Z4OISTZKIgosNNUQO0TUh
wjGiGqTN21AQ+GOrVb2DZaOt/gc2WGBQaCKdw3mh4eX5+Z7nec7zlGbnxh82
ALjF18g3UwSmLwLDBWAtB67TXqccpbxNfwf9B7SrtP+mwOs24DH10yagqx0I
fK3M+Rj/fKJ822P/nQDsloH+88A3yvmi/z5h/gBjb1qALxnwk5ibCfC8GbjP
/4e071HWIo7wlCv/i2ZjVGMPq8wbor5COcacR9QfEP9ubtxZygHWf0W9WnAv
sqX/ZuwZ8/9QHvMtakbKk9S9/qA+RQ4+FM3PRuIZxYl6qSfuZysxrjDrUZd/
J7PvKPL264JnP0suXhLnUidQKVoXprA3Ig+fM/smg/cwFHO0n67IufCyc8YU
jnLkX2rx7MKRrxL/TgRztEDs49T/TqjvdAM3WeNrt29hKt6D8pR/mrmmasvW
PJprOTN/qrdMezd3zQXG67k5eJq6x5m49++5d7RPOcy9vmOtCuV2Zpyrwbcg
LoQ13wEUyOd62beiOxgM3pX0GjEbcu/3TG7ut5L/dyLeVbc3GF91rgXH1ePl
1HdUo3+EfbxnPzd6PJ8wFWvMjdNE2Rfcl2btLXm2KyVzJu5ki8tK3MVeu++n
r+y4eFDOP6qeeyA=
          "]], PolygonBox[CompressedData["
1:eJwtkj9IlmEUxU9mQpmvKYm+wpvvh6/gB2aaUEkOFbQ1hREODRmUg+QgmVFE
Y0Q1REt8LhVKpS61Vi5hY21O0VqQBf0xUtF+p9tw4Z577/Pc85zzlIbHTl6s
ktRHVBNvO6WBRqm2RpovpO4OaTqRhqhle6RP1MbBx7dLmy3SFvCdOqm3XvrZ
JK1n0iRnzzCzRO83cZ28Qu0X+UYWZ0fBK6n0ldrlJM6sgi+Av3PffWaugivM
T9DbgFx7Gju8q4d4B7c15m9wfoqZP+TNrdJt8CFiDjzLTE197HvQJg1T+8b9
97h/kvvOgl81RO0c+VHe/xLcxPwbdr/viF0L1M7Tf9ws/dgl3WV+K7i6iNz8
NtvZBz6YhH4zRXAyt0fod7gsvQAfSWKnd1sTa/OQfn85OJu7PViES1ceffPd
m4em1raf2sc0PPnnzU76JekL/UtJaLpO/wN3nGiMnc+L8Mz6m+MzcE8e/Kx3
L/kx5l83hOaLWWjk3fZwhfmuUuyyBtaiL4+zt7ZJ+8nXmJ9IgoO57Mvj/E36
3eSDRL5baiMq5fDE3vhPfbZWWWjpO5aL0NTYf6yqCA/shf/ICPnpPLyy5zvw
6gm1A0m82W+3B/bCtafkV9LgYo/t9bU0uPvNfvv8/3lznCoHR3O1Zqfy+JN+
r//cKrN/AeoifnY=
          "]]}]}, 
      {RGBColor[1., 0.8875, 0.6328125], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNUz1LXFEQHaMs6OoiiShX8shb9z55K2r8qCw3XXQrSdzYphMx1kJ+gE2q
ICir/8B0fpUaghLS+FGk0GAlgh+BFImJkeg5nlukeNy5887MnDkzN/96evTN
AzMbx1eLb9ebVXJml6nZ+3qzyaxZLwC/nNkX3P9FZgc4P+P7Afy10/074jzs
2zqzM9jHTpivsD/gG0LOHeScbTVrRL5V+EbgmwOmkDGbwjmTUXwV/nJW/mep
MG+RbyCWfzAW9rRB+DXkKiFmBWfrY/G9As9+4EaA78OZbzEbbRaPsZx6684o
9369OP1BTB6+Q9RqSszeAZfFuR80oTZd7WYnwFwDe+HF468TF9rUhPkmQ86P
wJQRu+ml5WpG/MiXGPJnnQn8+1kDbFH9x6h77pV394niTkLsEv4PZ8X/dyQ/
eS174dpgD+fk550z4CxuIvXDeuudZkdOGm959czeG/H/VVE1Colqk8Me7N5Y
dZ/i/OZUfw+x26nqsD41ptbsh/bYQ2m+Ema04cWL/FiPGtBPrda99OAecc7c
D/JjPPGsQV2oT0eimXCO1ORlrJpVcD9LlY+71pBI90qsfthXkohb7SNxYG7y
pH2RKh/36FOk/KVU8+Mcz2H3INdz6h9rf8qBZym8mRkn31zYgYJTn9VI+pHD
PGadTxTHObA+ebDXS6/3sBhJB/a7UKP9OgjvbrEoLN8Wc0/9t0vsjVr4RDPi
rFiXe887a93PCfaNU17uMrlXAmY7En++P2rKfC9iacZY1rkD5/uYFg==
          "]], 
         PolygonBox[CompressedData["
1:eJwlkTtLwmEUxk8XhNRcumEg+M/XUCijmhobS6eobG4LqYYmob2pKYJC+xhm
W3QzoiG0zxCBZtAgpUn1O53hwHPuz3mOt7m7stMrIpNYP/YZEUkRePGJfIGL
2PaASA6LhUWySZGTHpGzkMgG+If8I7kWsTy4iz3gP2Md6r+xvM9mNJ3ITFRk
OWAzbqhtk6+RO8Yq+PcJkQVml+ipgONx2zWF78BBzAP3DYnssX8Cv0A+RszT
WmLesM0ogsscdhgyfgejIhdwWMT/5dgyuMmObMhufgOvwm8rYDN01h2cTulN
E5slNzZu3HL4fvY16MnQH6S/njBOyk13DpK/csZNa67Bl1ganKF/LmoaqBZL
+NP4JWezlOM5uBAx7VUj1erdmbaqaVf/ETUuR8Ruqe1E7HeqURtchcOrX+SD
37ZG6Atb7Trzn5z9TLXRm9eYVXemjfY0wFVn2qtGNWc92qs/TFG/H7bf6U3/
tyVNL/1JBjwftVs1plr+AXD8YUA=
          "]]}]}, 
      {RGBColor[1., 0.95, 0.75], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNUj0vRFEUHPsSHwlLJF73in25Tyg2Ev4BpdUQ2VerFwWJXqPTaMW/2F2V
LGupFPwDyl1K8VGZydxCcXLm3jtnzjnzXm3vcPugAmCNkTBqBXBZBXLm4RLQ
nAdGzPdTwBsjHwc2+N4iTon7zOc8d4ifGI88n1LwaNn309R5Z31JnQ/mHjkP
5OyT85MBA+LfzNqDqK+eFxNAIN6ddG/d62696r51xmriXprlhOcV4m7iPAbP
UlbNfQnGz8G60hK3HntIa8S3Y3KGzHeMLeLb4HmFVacZ+3Ee7aTaetxbWfOI
L652FFfetCq+U0/df2fe6yuzlnjidIJ3bAdr53HPmcJ+ylfNnv7TUta+Jd9u
OFOTucFoE28yd4O/2bV2p84VcVFYQ97JL/VQ/1f4+2uHXuydx/nVJ40+q05e
yfezFNiZ4/uiteWF/oXPBdbP0vPCvkhL+n9wlFTW
          "]], 
         PolygonBox[CompressedData["
1:eJwlkT0vRGEQhU9Elg2WKG5CdsNyr9yVaPYn0NIQcWu10Ej8BZVGK36F3VXJ
+q4kS4tGuUvto/KcTDHJnJkz7zkzb333YHN/SFKVGCY6S9LWlNQuSWOZ1E+l
w4q0V5bSGWmR2hO9q2mpaEiDXNohT6l14T4TBfxH+O/we+CVUtRe3Ge+OSkd
UevNSQvgM3pd8Dz58qz0wewd8VOLmnstNNYb4cneTpiZIH9D46Ecb9TB37WY
3R6VkmpoWMs7DNB/hX9L/574hZsxc16Jnbybd/AuG9RuyFvEKvnpiHScxJt+
u8DPZx4193yDPvg6jVl7srdL8Bo44c0L8vEsvNuDvfhGvpU9pFlwzLVmm/yv
Fl59E9/mKw9t39S39Z/4b6zRAf8DIIJH9w==
          "]]}]}}, {{}, 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{5621, 9681, 8144, 9451, 9450, 6436, 9399, 9400, 9396, 9398, 
          9397, 5768, 10474, 10475, 9408, 9410, 9409, 6620, 9505, 9506, 9504, 
          10572, 10571}], 
         LineBox[{5767, 9911, 9483, 9485, 10611, 9484, 6619, 7673, 7674, 6698,
           7672, 7671, 7190, 10476, 10477, 9424, 9426, 9425, 6621, 9508, 9509,
           9507, 10584, 10583}]},
        "45"],
       Annotation[#, 45, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{6623, 9431, 7676, 6650, 9454, 6652, 9452, 6651, 9453, 7580, 
          6435, 7579, 6649, 7622, 10306, 6524, 9407, 8242, 8243, 7621, 8241, 
          8240}], LineBox[{6646, 7678, 7545, 8277, 10651, 8276, 10653, 10652, 
          9389, 10439, 10438, 9388, 6679, 9482, 8279, 7620, 10305, 6521, 9423,
           8238, 8239, 7619, 8237, 8236}]},
        "43.5`"],
       Annotation[#, 43.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{5337, 9518, 7709, 8493, 8492, 6051, 9219, 9220, 9215, 9218, 
          9217, 5620, 9679, 9680, 9318, 9320, 9319, 6523, 9466, 9467, 9465, 
          10555, 10554}], 
         LineBox[{5495, 9643, 8089, 9449, 9448, 6399, 9386, 9387, 9382, 9385, 
          9384, 10461, 9394, 9395, 9313, 9315, 9314, 6520, 9462, 9463, 9461, 
          10553, 10552}]},
        "42"],
       Annotation[#, 42, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{5338, 6922, 5335, 9464, 7703, 6522, 7234, 9317, 7233, 7546, 
          7239, 9216, 7241, 6052, 7237, 7710, 7236, 6961, 7283}], 
         LineBox[{5494, 5619, 7539, 9460, 7541, 6519, 7543, 9312, 7542, 5725, 
          7496, 9383, 7498, 6400, 8058, 8090, 5478, 5605, 7494}]},
        "40.5`"],
       Annotation[#, 40.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{6103, 7284, 6960, 7238, 6048, 7242, 6049, 7240, 6401, 7235, 
          10057, 6046, 9316, 7702, 7704, 6921, 7712, 7711}], 
         LineBox[{6365, 7495, 5604, 8057, 8056, 9185, 6369, 7497, 8235, 7544, 
          6396, 7618, 6394, 7540, 5618, 8088, 8087}]},
        "39"],
       Annotation[#, 39, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{6053, 7716, 6054, 8497, 5831, 8488, 6047, 10058, 6045, 
          10056, 9645, 9647, 8092, 8091, 7708, 6050, 8490, 5849, 8579, 6104, 
          7771, 9536}], 
         LineBox[{6397, 9170, 6398, 9183, 6861, 9179, 6395, 8051, 8084, 8086, 
          6518, 9145, 6367, 9124, 6368, 9147, 6845, 9142, 6366, 8019, 8054}]},
        
        "37.5`"],
       Annotation[#, 37.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{5359, 9537, 7770, 8578, 8577, 5848, 8489, 8491, 7707, 8093, 
          9517, 5336, 5496, 9644, 9646, 8483, 8487, 8486, 5830, 8496, 8498, 
          7715, 8495, 8494}], 
         LineBox[{5477, 8055, 8018, 9141, 9140, 6844, 9146, 9148, 9123, 9144, 
          9143, 9311, 5493, 8085, 8050, 9178, 9177, 6860, 9182, 9184, 9169, 
          9181, 9180}]},
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{5341, 6924, 5339, 7718, 7714, 8503, 8502, 6718, 8511, 8513, 
          8485, 8509, 8508, 6963, 5357, 9516, 7765, 7706, 8563, 8562, 6731, 
          8571, 8573, 7773, 8569, 8568, 6981, 7304}], 
         LineBox[{5492, 5617, 10197, 10199, 9168, 9175, 9174, 5979, 9137, 
          9139, 8053, 9635, 5476, 5603, 10192, 10194, 9122, 9129, 9128, 5963, 
          9067, 9069, 8021, 9624, 5463, 5593, 7469}]},
        "34.5`"],
       Annotation[#, 34.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{6136, 7305, 6980, 8570, 6100, 7772, 6101, 8572, 6730, 8564, 
          6098, 7705, 7764, 7766, 6962, 8510, 6058, 8484, 6059, 8512, 6717, 
          8504, 6056, 7713, 7717, 7719, 6923, 7724, 7723}], 
         LineBox[{6329, 7470, 5592, 9623, 9622, 8020, 6333, 9068, 5962, 9130, 
          6361, 9121, 6359, 10193, 5602, 9634, 9633, 8052, 6364, 9138, 5978, 
          9176, 6392, 9167, 6390, 10198, 5616, 8083, 8082}]},
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{5373, 7803, 6982, 6137, 7307, 5865, 8575, 6102, 7769, 9533, 
          9534, 5509, 10073, 6097, 8560, 6099, 8567, 5851, 8515, 6060, 7722, 
          9519, 9520, 5498, 10060, 6055, 8500, 6057, 8507, 5833, 7246, 6061, 
          6927, 7244, 7243}], 
         LineBox[{5462, 8017, 7132, 6330, 7472, 6828, 9065, 6332, 9048, 6331, 
          9063, 7155, 8049, 8047, 8015, 6360, 9127, 6843, 9135, 6363, 9107, 
          6362, 9133, 7189, 8081, 8079, 8045, 6391, 9173, 6859, 7538, 6393, 
          7187, 7536, 7535}]},
        "31.5`"],
       Annotation[#, 31.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{5344, 6929, 5342, 7726, 6926, 7247, 5834, 7245, 5832, 8505, 
          8506, 8499, 10061, 10059, 5497, 5340, 9521, 7721, 8516, 8514, 5850, 
          8565, 8566, 8559, 10074, 10072, 5508, 5358, 9535, 7768, 8576, 8574, 
          5864, 7306, 5866, 7303, 6984, 7300, 7299, 6993, 7318}], 
         LineBox[{5490, 5615, 7526, 7528, 7186, 7529, 5977, 7537, 6858, 9171, 
          9172, 8044, 8080, 5491, 7188, 9131, 9132, 9106, 9136, 9134, 6842, 
          9125, 9126, 8014, 8048, 5475, 7154, 9061, 9062, 9047, 9066, 9064, 
          6827, 7471, 5950, 7462, 7134, 7990, 5453, 5582, 7456}]},
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{6159, 7319, 6992, 7301, 6133, 6983, 6134, 7302, 6741, 8647, 
          6131, 7767, 7799, 5371, 6985, 8589, 8590, 8561, 8592, 8591, 6732, 
          8584, 8585, 7720, 7774, 5360, 6964, 8523, 8524, 8501, 6065, 8525, 
          6719, 7248, 6063, 6925, 7725, 7727, 6928, 7733, 7732}], 
         LineBox[{6297, 7457, 5581, 7989, 7988, 7133, 6301, 7461, 5949, 9052, 
          6326, 9046, 10179, 10178, 5591, 5461, 9621, 8016, 9060, 9058, 5961, 
          9111, 9112, 9105, 10191, 10190, 5601, 5474, 9632, 8046, 6358, 9120, 
          5976, 7530, 6387, 7185, 6385, 7527, 5614, 8078, 8077}]},
        "28.5`"],
       Annotation[#, 28.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{6067, 6933, 6068, 7251, 5836, 8522, 6064, 8518, 6062, 10063,
           5500, 9523, 9522, 7731, 6066, 8527, 5853, 8588, 6106, 8581, 6105, 
          10076, 5511, 9539, 9538, 7778, 6107, 8594, 5868, 8650, 6132, 8644, 
          6130, 10089, 5519, 9550, 9549, 7802, 6135, 8652, 5874, 7322, 6160, 
          6996, 7834}], 
         LineBox[{6388, 7182, 6389, 7533, 6857, 9166, 6386, 8040, 8074, 8076, 
          7184, 9116, 6356, 9092, 6357, 9118, 6841, 9110, 6355, 8008, 8042, 
          7153, 9113, 5960, 9059, 7152, 6327, 9036, 6328, 9056, 6826, 9051, 
          6325, 7983, 8011, 8013, 7131, 8990, 6299, 8976, 6300, 8992, 6815, 
          7460, 6298, 7122, 7986}]},
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{5347, 6935, 5345, 6930, 7249, 6932, 7252, 7250, 5835, 8520, 
          8521, 8517, 10064, 10062, 5499, 5343, 9524, 7730, 8528, 8526, 5852, 
          8586, 8587, 8580, 10077, 10075, 5510, 5361, 9540, 7777, 8595, 8593, 
          5867, 8648, 8649, 8643, 10090, 10088, 5518, 5372, 9551, 7801, 8653, 
          8651, 5873, 7320, 7321, 6995, 7835, 6994, 7313, 7012, 7333}], 
         LineBox[{5488, 5613, 7521, 7179, 7531, 7181, 7534, 7532, 6856, 9164, 
          9165, 8039, 8075, 5489, 7183, 9114, 9115, 9091, 9119, 9117, 6840, 
          9108, 9109, 8007, 8043, 5473, 7151, 9053, 9054, 9035, 9057, 9055, 
          6825, 9049, 9050, 7982, 8012, 5460, 7130, 8988, 8989, 8975, 8993, 
          8991, 6814, 7458, 7459, 7121, 7987, 7120, 5441, 5572, 7430}]},
        "25.5`"],
       Annotation[#, 25.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{6181, 7334, 7011, 7314, 6156, 6997, 6157, 7315, 6751, 8718, 
          8719, 7800, 7829, 5384, 6999, 8661, 8662, 8646, 8666, 8664, 6743, 
          8657, 8658, 7776, 7805, 5374, 6987, 8604, 8605, 8583, 8609, 8607, 
          6734, 8599, 8600, 7729, 7780, 5362, 6966, 8529, 8530, 8519, 8533, 
          8532, 6720, 7256, 6070, 6931, 7734, 7735, 6934, 7740, 7739}], 
         LineBox[{6273, 7431, 5571, 7960, 7959, 7123, 6277, 7437, 5941, 8979, 
          8980, 8974, 10163, 10161, 5580, 5452, 9607, 7985, 8987, 8985, 5948, 
          9038, 9039, 9034, 10177, 10175, 5590, 5459, 9620, 8010, 9045, 9043, 
          5959, 9095, 9096, 9090, 10189, 10187, 5600, 5472, 9631, 8041, 9104, 
          9103, 5975, 7525, 6383, 7180, 6381, 7522, 5612, 8073, 8072}]},
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{5398, 9566, 7859, 6182, 8780, 5882, 7316, 6158, 7015, 7831, 
          7832, 5529, 10098, 6154, 8716, 6155, 7000, 7830, 6998, 8663, 6140, 
          8645, 6141, 8665, 6742, 8659, 6138, 7775, 7804, 7806, 6986, 8606, 
          6109, 8582, 6110, 8608, 6733, 8601, 6108, 7728, 7779, 7781, 6965, 
          8531, 6967, 6072, 7738, 9525, 9526, 5502, 7254, 6069, 6937, 6071, 
          7258, 5837, 8538, 6073, 7743, 8537, 8536}], 
         LineBox[{5440, 7958, 7933, 6274, 8941, 6805, 7435, 6276, 7101, 6275, 
          7434, 7119, 7981, 7979, 7956, 6295, 6813, 10162, 5579, 9606, 9605, 
          7984, 6296, 8986, 5947, 9040, 6321, 9033, 6319, 10176, 5589, 9619, 
          9618, 8009, 6324, 9044, 5958, 9097, 6352, 9089, 6351, 10188, 5599, 
          9630, 6839, 6354, 9083, 6353, 9100, 7178, 8071, 8069, 7175, 6382, 
          7524, 6855, 9163, 6384, 9154, 9162, 9161}]},
        "22.5`"],
       Annotation[#, 22.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{5486, 5611, 10195, 10196, 9153, 9159, 9158, 5973, 7492, 
          5974, 7523, 7174, 8070, 5487, 7177, 9098, 9099, 9082, 9102, 9101, 
          6838, 9093, 9094, 8002, 8038, 5471, 7150, 9041, 6322, 9020, 6323, 
          9042, 6824, 9037, 6320, 7976, 8005, 8006, 7129, 8981, 8982, 8962, 
          8984, 8983, 6812, 8977, 8978, 7955, 7980, 5451, 7118, 7432, 7433, 
          7100, 7436, 5933, 7428, 5932, 8898, 8900, 7935, 9588, 5432, 5563, 
          7416}], LineBox[{6201, 7352, 7029, 8772, 8773, 7861, 8776, 8774, 
          6761, 7329, 5883, 7317, 7014, 7833, 5385, 5528, 10097, 10099, 8715, 
          8721, 8720, 5875, 8667, 8668, 7809, 9552, 5375, 5520, 10091, 10092, 
          8654, 6139, 8660, 5869, 8610, 6111, 7784, 9541, 5363, 5512, 10078, 
          10079, 8596, 8603, 8602, 5854, 8534, 8535, 7737, 9527, 5346, 5501, 
          7253, 7255, 6936, 7257, 5838, 7260, 6722, 8541, 8542, 7742, 7745, 
          5348, 6939, 7749, 7748}]},
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{6078, 6943, 6079, 7265, 5840, 8546, 6940, 7744, 7741, 6074, 
          8543, 6721, 7261, 6076, 6938, 6075, 7259, 6968, 5364, 7785, 7736, 
          8615, 8614, 6735, 8622, 8623, 8598, 8620, 8619, 6989, 5376, 7811, 
          7783, 8672, 8671, 6745, 8679, 8681, 8656, 8677, 8676, 7002, 5386, 
          7837, 7808, 8725, 8724, 6752, 8730, 8731, 8717, 8729, 8728, 7016, 
          7856, 7855, 7013, 6177, 7330, 6760, 8775, 6180, 7860, 6179, 7030, 
          8778, 5891, 7354, 6202, 7031, 7880}], 
         LineBox[{6379, 7172, 6380, 7520, 6853, 9157, 6854, 6377, 9152, 6378, 
          9160, 5972, 7493, 6350, 7176, 8036, 8037, 5598, 10185, 10186, 9081, 
          9088, 9087, 5957, 9031, 9032, 8004, 9617, 5458, 5588, 10172, 10174, 
          9019, 9024, 9023, 5946, 8971, 8973, 7978, 9604, 5450, 5578, 10158, 
          10160, 8961, 8966, 8965, 5940, 8939, 8940, 7957, 9596, 5439, 5570, 
          7425, 6268, 7099, 6270, 7429, 5931, 8899, 6255, 7934, 9587, 6799, 
          8896, 6798, 7418, 6254, 7084, 7932}]},
        "19.5`"],
       Annotation[#, 19.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzk0rBFAUxvGHfAEyyMs0MyUfwo4iUZiFlyRmFsqGlYXVlGZlb0VCVspG
JAt7O/kGM2TyJbz8LJ7+957zP/fccn2/uteVZFE6/UlpJPnE2WJSdK6PJm8D
yTa+/rOc1GRDqhPJsjQKyTR/SibNPA8mW/wW/4bXdr/GFtb4x/yZ8WRpOPlQ
O9F7x1tcMN/0zpHsyI96W32N+4UZ8g/8Ve/gOv+cdyYN6dWvcQ/sObVn1Z4V
udTr0xurJN/+de1/Ffdd8yW8cL/iF2STf8ef585Jt11P+j34iIdmHvBems4v
+AdFOzKF
          "]], LineBox[CompressedData["
1:eJwVz70vQ2EYhvFbGpuFRIjPINIYjSzSsEsYMDVYffwFPoJVGMpfQU0qkZQI
i2gnu1Uqarf5Ga7c57nf67znOWMbu0s7HUkWsdWbfGFlOFlFYShZk8t9SVm+
DCTPExLl0eQE2/xOXsl5o9/7g0lTzptv+fvcN/Mcdx2b+OYs6Nuy+u/qziaT
c7y7r15MrvSznGtZkjN26JKX5in+EfcYr/wbfkUf5xey6d4ipyE/x5MD3Yc8
lC1ZsVfBfnvmO043twf3nuvOH1DDEx5xyv/1jxN2aMsq72ckmfbtGlq6P2YH
Na4=
          "]]},
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVkLFLQlEcRr83R4vYe1IqvEL8C8SINkFnW2oQkRdkT1EJVMRdodHVSXDQ
mnRxTsTFNRoltE2hSZ1EPA6H7977nd/lvmc7pYeiIekRwhfST1BqXkkJnzTz
S+eW5F5LDc6inNXIW3JE93YpZeki7IfMTSHAHXWcHn0f8qw/yYMpdck96Wcm
CB38p5B0xkwbymGpCh46C0zY4K9saQ1N/CS+gduCAm4R5nR/sIR//AE5hDx+
An/rld7xM7gOdOk+oA+/+GnetSAr5B3vLTC3Y+ae9SuOCykY8y9yZIzvfsb9
Yh/AiePbZJbum3tcugndzemM9QscAQtxNwI=
          "]], LineBox[CompressedData["
1:eJwVzzkvBUAYheFjSSyNSog1ri1RSRQSW2JNlDQSW0QttAo6foGO0Kp0RGgk
dPwBzS1d21UrbuNRvDkzc95vMtOzvbe8W5VkBcPNSbkruWhP1luT747kqC05
LSTH8kd3pdvQlXWFluRWt2N/I88Gubh3zygq/Dv+L3eIW92ZnLjng/uFIkp4
wwtv0cxAd9KE2t6kBmf8BtmICq9e1uGVv8Sf5vZhytkkLvnzcgEjmMUMvvmb
/O1/F4fODnDNn/GuOe+bkJ+8cTmGIn8D5/3Jlpln/9w3s8xd1b/bV/tbST65
50H3KDd1H86iW7dewx9RoDZx
          "]]},
        "16.5`"],
       Annotation[#, 16.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{5630, 6864, 6653, 9489, 9490, 9486, 9488, 9487, 5769, 10574,
           10575, 10573, 10577, 10576, 6687, 6689, 10630, 6688}], 
         LineBox[{5718, 6876, 6667, 9497, 9498, 9494, 9496, 9495, 5771, 10579,
           10580, 10578, 10582, 10581, 6690, 6692, 10631, 6691}], 
         LineBox[CompressedData["
1:eJwNz78rBGAcx/Hv/QcWufwMXWIkYnBdWWxyRizWC+Ml07nRj0khg03qWM4i
F3ULZ2VVFAk7ceG8hnef53k+777P83QvLGeXEhExi6lkxF17RLk5YgAPnREH
bRHJloh358XWiL2eiH1sYxc7KHG+uV84ss6Z88Ff51f0G7KuO9Mt6j51/WY+
6lbs72VeHvZFVN2bxmoqoqkr4ln3hCH+j/xFHSfcY9S4kyjwU/yG7g+j/OHe
iBEMosI9xy13i7uJDL/k3jH9BH+8I+La/tU7r+Spd+d1ZZnR3Th70dVk2j7h
HznziubM4ZJ7gSp/Xj9tZoM/Y53FG3eNV8A/EEZB2w==
          "]], 
         LineBox[CompressedData["
1:eJwVzz0vQ2EYxvGbwdRYvAZp0kNVWEViECsSFcWiW6XSnDRsFgaL9AP4ABKJ
oaNIWrMEsYqVxdtGvHwAP8M/1/3c1/8855xcZbe00xERZWwMRjyORBwPR1zL
GzTM3QMRd+aMrCURKW6zEdV8RLYvoolz/bTnD/gz8sK5i1/i7ttN2qVySjZ1
6VDEim7C+cRdLbRR5+Ttx9Hz36OACj+RozjinSLjvWX+Vy7iG0/4xQ82+R/y
Eym3gU5+kd+2e/VtZ/JNXspV/p7venGe5dT5c7Kle+73r7or3bzdgm4Rh+5b
K0SsY4u3jSru+TX+g0z4S9z33ogxc9G8jD+Q8zcJ
          "]]},
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{5798, 6890, 5983, 7192, 9530, 9529, 6624, 10478, 6094, 9329,
           6532, 9328, 6531, 10316, 5629, 9331, 6534, 9330, 6535, 9332, 6095, 
          10071, 6096, 9531, 9532, 7194, 5984, 6704, 6703}], 
         LineBox[{5829, 6919, 6021, 7227, 6600, 10430, 6601, 10431, 6599, 
          9381, 6603, 9380, 6602, 10432, 5709, 9372, 6591, 9371, 6592, 9373, 
          6590, 10566, 6676, 10565, 6675, 7224, 6017, 6715, 6714}], 
         LineBox[CompressedData["
1:eJwNz78rBHAYx/HHH8Am4vy6I2WxyF0i5R/wIwx+DRYbCxJ1zAZyyiBWoSgD
IQPFwOy6RYmSK6skSV7Du8/3+fR+nvo2TM4MTJdExBR6KiNuEhFH5RGNWKuO
WEde94hsVURB9vNy+j65KysqIraSESPmTbnebBenbrTiozbikFe028D9lKtu
XXKvcIwLnOOMV1YXUYovewtuPutz/Fe5ZM7LRfkiH/gpbhK33hv6RE3ENr9O
bprv9TlZYy54d3E7UY99fVsqYo+fkYfmFnkg0/KdP+YPE9wOzOvmcMLvdq/H
fzLyjZeW7Xjij2KnKWLczp1bs3b6uH+8Fd23fNMP8q/dGpLD+NX/oNe76MYy
N4t/leZEag==
          "]], LineBox[CompressedData["
1:eJwV0LErxHEYx/HnSHbunBCRc/gjZEAMyt1NDBRn4pxN0S0msRkwGBR/gRgu
Rs4fgElRUlKK5TLyMrz7PN/neT/fft9f72I5v5aIiGXMt0d8d0WcdEY8yUN5
hBf1M1rSEXdygneg/9AdsdURsYntvogx/ZrePTKpiB3OFf8aFXWz/XN1k8zx
C6hyFzIRaf4pKtmIrHumzYbkjPxtU8uU8xl/lj+HY/4Gv1W/xzwp+2WdX++N
aHTe5ee5Bezzy/yE/qd5w/975Re/Kt99V5k/yZ3CHn+JX8S5+SUu8Moveseb
HPGudTs/yYhR9Yr5Koqoua8kx/yfcdw4D3Ju5Yr9R/ursoQB/Qw+3DMs8+7M
4Q8YsT4A
          "]]},
        "13.5`"],
       Annotation[#, 13.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwl1ndsl0Ucx/EDRFBAhqwyy94mYBmVoSAtDigbQYaAOAKhrJiAEzAuMEAJ
UAqEIaBxsKIiLZu2zLYCQhGCiQGkDFnKKtPXE/9453P3vc997p577ve0dUaO
65NcJIQQVzSEpU1CuK6dWT+EbGRhVuUQLseGcAUXcQl/R+2KIXRuFEIXxNYJ
oS7q4Cv+reZtw/nGIZzDiZgQFske2TCEYcZna5cwPp6WpMXRgOdRekFu31oh
NKsewjHeiTVCyKfj6L4qIbRQ30u7VQshEePVJ6CJeinzG9HR+tMqWVtWuwYh
dJe3x5xk+/tL1rvGz+t34T1H+8rpg83GL+r/SC/QDNqTp5ismTKSUah2G4P5
H9CHuIR7uIuh/GX4v+b9Ai3qhtAco/jjaBvUQSu0RDJ/Vf4M3pXor9YPY/gH
0kFIwisYgA/59/Ptwya0rxrCWPWJ/JNwQG0GT0f1rZ6zrOf42HiC/lT6uff1
GdZasyHm8cY7t/n0BP9xfCRnKv6M9qTez9yT6jGyrtFqdJX6Fe3LiPWOh3l/
CXK6Yaz3mkiTaQfn3cF7T9PO4znEexgbjK/HPOOPOLfiKIJiKIqOcp+2zzhU
0K+IJ7GUf6e8XThq/nK577jA+7QPYD9SeR7jfRyPoiRKoJPM1vLaoJJ+FVTG
Mv5MeTHaSzxbW+OLaS+1RGOzrFHV2Fb3/gP1LfR9Wosvhf7AtwZJ6u/xTlXb
pZ2Jcugqo6jzSqAbPfsv+Bnp2IRtzjdLVjbS3NdFGOjdxNvvW3S1/irUl10P
pyK/ednYiUzsQn/5Ja0zx5opmI3u9jKXbrS/vnSufgH9lJaM7gLdIPOIWinP
OE57kJwR/AuMNeVJpaWNbVZbaGwQ76vIq+3M7eusPT5rr+1441GNtwaqYzl/
lnnZyPduVsif733laOchF2k8g+UNwa8yc2QWyHxO5jPy2qOmrNqohRX8m83b
gnQcd68y6BD1JjKa4rQ5Z3AKufLy0KOmd4QbzijJM/XW3uaeb8dpZ3pX/Qzt
pd7TeBxtjUL1XPu6FX1b7Os+nVDPbw7JyDJnEl0nZz126Z/hyaTx5neW1dL4
N/rt5cy0ly9xSNYm+0tHE+Mt0Bxt+W/7rRZG3wr+qbzdePeggryK2Cu/Em0V
3UOaZt3qtKV+oLuNlza3ozk7sNIaq3FE5jHko3H0raM/4Zbf+kTrtOFNRxrv
m/a7xtjbdD2Nje6OdzJY/1v5F8yZbt1pmB99q9T/UDuPsbKekrOEL9+c4d77
DIxAun2lqB9SP4jycrPo8+bPUT9s/hSZk6OzVC9lfJp6lnoNmevMX4uzzup3
+yygN/VHy75Bx9Ca7kLx6L5q57gfuX4feVjnnqxFivGH7kmIvt30Ae6jovwV
+F7Odxiu9hqW8G+XtwNHzF8mt7p7vFt7L/ZgDs8d3ru4hULcRgl5qdHfBHmr
MUxtKBbzb5NX3h7Sor9tnmUhPePsyhibaY1y0X3nfUN9OR0VfVvUrtGd9Cqd
ol7AP5kekncQV5zdQ2smeeae6IHe6IVPnEdH2Z2i7zNK88Y45wRjieiKF9AN
03hfoi/jRUzXvyf3ojl36TF7PRo9k32kWj+H9o9+c3QAHUJP2s9Qut5aC3hu
4HXtO+bnmz/PWG3e+fSmsQz+2Z7nX+3ruIp/cC3638Pf9Ga8zVHG85fFE1jE
v8W8rfit/v//y/wHyMttBg==
          "]]},
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwl1XlM13Ucx/FPm2liuTQFDUlBjh9JyGZ4YWIzTTRXacvmgahtDVTw7hDS
vFHMjq2h/dExFZduVtY/mUeHokiWiqbi8AS12qrllZvV47v+ePL6fj7v1/v4
fT7f34/kqWVjSu8KIVz158OkELITQ2ifGkIWLe0WwpLOITzzUAhPY29yCHUJ
IdwnHusawr00g84Tm4tR2M2zC889GEKF/Jb4EF6lj6v3Cn0ZVWre6hTCyLQQ
5sj5Tc2v5fzBe5ve3SWEG7QVnZURwrv8a/mqUKROa/uF9A7PRFpjfxNWIV4s
OyWEafrn0i7WPWgC7UNn8u/kK6OPRPVpFt1qro36TDFTEXbxZNsfL+ce85XS
QdbT6VIzLcEn/N1Rz1upzm417uetp+X6L+ddgTcwUu4y+qzzGujcxtA8Otb+
Kec+hp6Ut0O9XvhIvSrxj+mn4tuxQs2V+F2/EWIFiOsRQr/0EAY4uzti2/kT
zdYNLWLrzBPznIk0ZCAdr/FfioXQjIu4jBZMNlcyTUH/qC4G8uaaLY/mRWv0
ywyhL4r4m83Wgg76z7ZXztfGGV403yhss/cUbWee4XLzxd/hP2+ORPm3e5qX
JvJ1wyq5lViN/XJqsQ/fo05+PQ7hIDrYG0s70h/oYfyIudbPd/cOqjeOlmMh
tqhZbq+Gbka65zTM0z9VziS5hag23zhzpttLw0TzT8BltJW3XGyOvHif+Trv
NcxXI9+5DYnOUY0ivMA3yNk12DuOY/gZJ/ATfyM9g5M4jVNYIecxZzMYgzAE
+dH3wF1eMcsvuIrxfK3d9wQas85AofkmocJnvSY2Ws56s21AzKy9zJ5BM2mx
9+wGTx+xvd6/v+g39B/3kWK2ejXq+A5G96D/HrFaegCzeMqQr36WvCH0QjSL
nPHqXvScLd4bqdgsN4duimaI1DqJtz8G4AR/F3XW2f/W81u0mndR1Fu9B8TW
Rv3F3qTx1jl6/utsF1jvsx+nTjvs4d9oxrflzxf7QqyN/bb40vNnvofF9rfQ
Evo5rYy+O/Ql68u+X9cxW+9ctWrkNOsz1X230Pet4/W+5LkzrZS3Gk1yvtJj
J2bIPWWGM2jEaaziWUNH67HScyP/GaxV77vot5bukLuUrvb5KhGn/uLojuTE
3GsmfuW5qX5n937d3J1oB3U7otk7sEZOT8+p6IEUJONP3rPer3NowgWcxxF3
XeCzjcQIdOVLM097dVv0aUaW/V54L3rH9Vjg3S4RP2zG4uh9tTcY583WyN/K
3jKxc9Zn0YQcuRP1m4QJWGe9Xs4GTMNWOVPpNvoiPa3OFLrFer9+NXS+Gart
zXQOMzBUncXqTPdchlIssi6mr9MSutAcf7vHBjMcQ678RzFZvVqxItrPui8q
5GTq8TAa9D+OW3ITnMdNesz6KGLiGUjnP2SGehxAHQ5Gv6XO8AlnPgxD8SSG
R++Auzmnz4XorNDb3V7hvaH2UbMdQVz0G4NDvAViI/BB0v//n/8DYXAtqg==

          "]]},
        "10.5`"],
       Annotation[#, 10.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwl1WtM11Ucx/EDKPiggQaIoHLT5JKFOENrWG2WWZoPspZQW0uz7LIK856z
OZ90UdSwrDbJBEO5KmpkkmmEubnWZQu5qdlF6wE8sNLpovX6rQdvPr9zzvf7
+X7P+Z3fn5xFLz30YkwI4bA/I3JDuJoTQjwdjifHhpCUGkJ9ZghPeL46OoRN
40K4QousT0Eh1uSFsBo7xSbisZtC2CdnhrXpCGkhNMqLoRV8mj034TXP2eK/
EduOZWIrsDwjhBV0JV7A3WNCWBXN44H0EG6byBcluN9a4/gQ5tDTPFv45aOL
3wKxMdnGk0K4Vc/X+b6vZmV+CFtQKb9VzBbaQnv5bBM7R06sPcRgv/nNYg9E
Ki7V8130EeNSeidmYituVn8ypqtTgjZ+7eq+xW8TOrNCOIl2/d2OT80dQRuO
4jMcE58o70hCCMW8dqlXxXs7CjznY7HaDxpn0CqxN8jbZ74ezfpvwQY++daq
ncsh76apQI9xIYynWcjEVOvzxZWLL8NM+aVI5rfDWjb/AXqCxjnPYWiyr169
D5q/Q39xznMY5hnPRQe/Lvln8CPqo7uApXJ6jHvRjX704Svxx6MaKOVdJq4P
R/VRbY8fYmF0zsbL9FHmOYdeFt9JR+qpWd5wGo9UpOAnc/fZYyptl/s5auSe
lLOL7sZHWKB+jP4fphP0k4tXxJRbK/OuynHBeqF6Nc7yGK2l/0wIYQinrZ+y
v69x2DnvtvYJbUO+9TyUuPd/ubt/I1P8erH32mMnRvE7zj8tOgOaQdOxQ99X
ou8x+hblZGG2+A4x3eZ68D360Iut4oe8j39xUMwI8a10WnTPsEM/76FObAPq
kaWvbfRt/O7MvpTTgZf1d4IO6n0AC+1phvP4TcxFfMD3B3Xmm58WfYPO65r4
NHcozzle08sk2metH/n88nBR3JC9rfUu1mCkuFne0SXzZ8WdxzkcinpHkvk/
1E+kU83PpkW0GFMw1r724iDvVtTxuszzDfon3atWHQ7opdF7bUIDfsUvGOk8
auke1KAOH2O/+G/lfYdiPs38ktWZaM/x9F3U6q8GCXr6WY/xdKP4s+bK7K0c
zzmP5/E0v0q5S+izxkvRwPMe3+NTnpdgkbUNYhbTZ6IcLOTxKPp5ruMdq8Zo
+y6iydFvEVJwPcV3LTfVb8YpcXt4bLePd1CF8zgX7csZbdT762qfNa7mu4Iu
R62cndEdp5fseRy/sbjGe668eRgV3QFndov6N3oujL4/OpkmRb9/tIf2ohsX
jNfzGHTP1hq/abyKrsFqzHKPBtQKap7RSxcKxKyT8yo263Wl+7YCX/i/NMBn
jLx0pEX3IPrttlaJCsS5x7F4nGdC7v//z/4DGBwLeA==
          "]]},
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwl1WtM11Ucx/GjgIX1oFaaXFSwFIilabW0tLZutlULSewCT0SguyigrRRp
xBIUL5WylQIF5kRcwaY9KIOyHmRby3RuYnFJSmuRiIBSGvX6rwdvPr/zPd/P
93vO+Z3fn+TcwszlY0IILf4kTgohfVoICXQ+LUoIoX1KCG3Yg1ni2eIvxYfw
MnKnh/Cl+K3iOeKxN4RQTO81LqT30IqUEJonhJCMAvnfy780NYS/kToxhO8S
Q0ijk2aEcFnskbgQNtwUwm5aRT+kqXJWqH2Hnrfjo8khfMJTlSQXB/k+RxsK
9bg2LYQ/+RrpcuPFns+pNVZuFKr5O62rC/03hjCAczglJ1p+DLr16UKU57P8
0Xyz9RwVm0NnWm+M2GN4FGvEetX9JbI2+bWpIRygdXSBua3i3fr1YESvOHN/
RfrS661zIiZgnX22qfcF2vEwbwrvQpqp5yLcpuYclMltpvvQIt6Kcnmz5b9B
v+E/jBg9o1EuP1mPaUjCkN5Z9ryCJsrL5n+cbzt/Bj0k/qnaX0XOT6wfFeIZ
chdhMqZEnsVi3JVu9OBr+Zni+9U7gAG+X/VZgicx1VyOeCZfjblk4yTc7KxX
8p6WM0yf8j53iP1grsLaj9BjOIpDvO28c72PeWjELnzG9y7/QfoeLaTx8hMi
74knneeSc5+OGYjX406U6pPhjh63/vPu7kZ39yytpoO0Ru0BusE4Sn4i2uXO
sq5j4iXi48ReVec1tKnV4MyLxI+YL6ZHaYr8Vr4841rjfLqPVqrfRJcZ9/pG
BjGE3XI3iW+OfHf2sJVuQZ+19/ouboncD2cZzGXY6wt6N3i3fZ6voS8an1Sn
A03Ge3FRrz10P2+z8zhAW/hb8TH61Cu0zj/oemfYqNabdBetpAvpkL1GmY9G
pRqJagyKncf9atyHIrHj5h7y/CAewPu8JfZUjCHruE7OBWscxm9qncFa51Zn
b/Wolb/SHdxJi+jV8tereRU9o9dppFjTXebL7Gm+HqvUKMHz8p/DMnupFa9H
HcbzblF72NwFDGEEF5Ert0D/Z5Ef+X0wLpebx7ODdydOqf0zlprrpj1YwpsV
6eV5nfVstp41tBRrsc6ao9RYLKfa3BN0E31d7TL0G3fyduGEs+jAWPm/O6Mx
9Ef73Ch/rv6X1fsH/2IUS80/Y+/ZeBrpPDk0jX6r72GU4qQaHTiBmWqt5q2K
fKt6V9LtPDXYhlXm6uW9ot9q7NWjTo0m2qdugb1Pse533Ku3Eevejncvr6Qf
yGvAqJo/2UcnxvHFqxlD89UvQB6iI9+A+mNowDbfTVbkNxtvqXuFerHiI3x3
03jjeTSOFlhHPhZM+/9/13+IlRMH
          "]]},
        "7.5`"],
       Annotation[#, 7.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwl1GtMlnUYx/HLIs2UN7UQRBBBKBV8IbamVp7aGtpmB8utNgwr8RW1Dpup
4IuWm0kbuk4v2nwgEU1AhbDEXFaWdgLb2nJrKYIu8QCItSiz+tzrxff5/Q+/
6/pf/+u+72fKquceqRoVERv8tGZErM6LaKGVdF5WRHNuxB7UYX5+xH2onBix
iC7GXCzEAkyfGpF1e8QXvJ9jpbVyVPE/Q59FBZ7GKpTy5/Of4D2CddZewcv8
NXQjnk/yZ0ZU0wfVc5LvJ3ShTZ2vqXMTOiZHHMAZOfv5euh52jUpYqn4mjsj
mszX02pswHTx15w1g2YVRVwXf5kOYgBl8q6bFrHNuI5/KyYgA4/LlUlX0AXO
uo3eT5+gC+liLMLowohfciJOodhZPfQ0nuT7kHagxHo7bcP25Bxx2zDVuAAV
vEvMM+lWnnvVU2i9CI3GO1DtDr/aq6FN5jvRYL8eP8s/m96V1G19BZbwdfKX
0eXmj6HEfjHKjN+0t9fdc5zZb3yQhp6PQkq+bs+thfctdb2NZXgYDyGX94KY
ixgxruc/wd/K/479d/Eo5plX2V9uPJle4u+kNzijQcxe+/vQpp52LPM8Rt8R
MQbfGWciC0vdIbIjfkQbfzv243DSY7rd858md4rmF6iHFtBXJ0R8L74bXfhM
nmzvwNf4Bl95dl9it/M2i/mA7sGQd3EQM8V30W6k8R/DWv573PVw8h0YH01y
2D+OYygS00h3Ytg9j4op1+dS/o9wiP8TvGe/HinkitlCa3FWzKdijuAg38dY
K75T7cf16BDtcJcD+N38N7yUxOtxi348YL3O2kn9aDav1Z9Wupluweuo1ccR
/S+UK4N3xFlVcrSKPcc7znnpGI/99vYh3fp5PR1PZybvP51BS1CMie7WlLwz
vM04x3sW4/iu6+k/+At/4xpu5U1hN+8u3MLXxz+WblJ7n3v34irvMP5Ud51v
fY2aX1TzC6i0tho/uMsQzxX0iDmDsXxv8F+1P2B9EKesn8ZG+dOcU6TuObSA
FibfI25S0wXei+jHZVzC3Xx59qcgJ3mfk+8Aafzvy7cDf/D8S2fTRnojncRT
SrPpLHpFPcMYQq95g55X6n2vHvThZnUPuM8YupLnKZQn/xm8FUkP6LdyzxU3
B+m88z2ncK+U+PXJf1re///1/wHgVfdP
          "]]},
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwl1FtM13UYx/FHzUMXgTkBgRQFxcpDEyeaNcWk1UXpxpVt6grNQypINzpt
AjaErZmbh7lp6VRAQJ3HCVseukrzMGeztXmnU8MjgifanPT6zYs3n9/3+T3P
53m+3+/vz4jS8pKyXhFR4k/76IjCzIg7dBL9ly54N6IU29IiKkdG7M2J2IOt
wyIOp0c0D49oQROWZESsVZMzJGINHUZ/fSdiKC3jsZ3nMroCyxPf7IjHWRH3
+N1FOz6W84uandil50DMHRVxSL+H3j9Aur7dYl/nRhTwnkcn0HV6Nshf6N0C
VFpXowqL5LxQ2y/fXOrXWv+A1djgfQ0Oqs3DVb2+NMcr+Vnys/HcnD+Zt9rc
61GFFjk/0ib6z9CITfIqrZutt79nb9YVzqSTduG4MzqGNv3PWbfSVfJOmrUV
J/Qeiywec3hk0q9oNh1MN+qRRrvynAF9QjvoUfG5tNP99OPfHz8n8yBD/DTv
MziLqfwLnO1EdHmXoX8nHUJT5ReZ6XOzfYYx+r6P6/a+j9YnexVvTvYpb6D8
Wue+39nV0ck8CzFLj8lyF/MtpEvoKbm/Id1saRiMpeKzzPyEltBlyTzic/if
lvud9dTke6FTkm+Gfkhn878g7yK+x1mzVNDf6cZk7zjv7gbYb7F9DTJ/C88D
aOfbyqeJTxttoPvRiJnqe+Smqk/BW1iU3AOvYj3PuP8LvpeL+BOXcQnP3cML
/OF5j7OocBahphd644i6fd59I76XltJ6+kzNU+zyvBuPfXedKNCrQc0NZ3kT
s83Qw2eU+fPx0oxjzbrBzLWowQE5dfQL3lfU3LNOsff7NJW2qW9FnT3V4rj6
N5NevCZitJp8rOKxGm+gWG0f+intSz+hvekH/Mbjb3X9eewWv+ZcZ/AtQpV3
05OZnUWHe623bkQDepLfDA214+hO63KeO+hKmipeJJ5rljxME7/vHh/gIRr1
edvsHZ4f4T89uvGXuoXqv8XK5HeHxfIuyy/3XIYVSJE3nG8OLnm3jf98sXnJ
vdvLVuv14tW47bxuIdcepoivM9dH9recT7XYFrEqujlR+X0zX/8P/R+xG9KL

          "]]},
        "4.5`"],
       Annotation[#, 4.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwl1Ndvz2EUx/HTGrW1NVtqxKyEtlYkYhWJmIl7IUJithWUmkVrE4lVI2pc
4MYIEpWI8R+IqHljr8QeQY3XNy7e/TznPJ/nnPM8+f7adWbx1KKUiOjtz/de
EcOyIr7Qb/iKeb0jqttEZGBabsTJzhFnOkW8p+/wEaXyH+hi3iPOr+4ZsQZr
cSsnYmHbiFXWK1HIOwrF2RG/+f/gJ+rwC2c7RhTxr+Mtx1K5JbjN35CmobF8
E3ThO61+Z9pInIYCtfNRyl+fNkAK6iEV19TfwrcZm3DMvKVqVnSPqMTcLhE7
+ObRObjUI+Iizrl/LtJ5M9ASk53NpOl0mzky6JtucvQtbaVOJr7p8x256IM8
8x5sZ07vW4A7cndRi13in/RX4kM+BvCv4K+z/oPf6C6+bq4buImhZhvoboV0
up4b23tvnuG8IzAyqS3OUX+4eoXiUQjxX3qKpqDc3gTx+GTfur9cIZ0knoh6
4lRk6ZGNZ95sN53lzv2SN+GZgsveowaz5fPkC5CP0ea74V2LUIyFuKp+Ce1h
vl48M50ZrcYYjEWde5W4zxF9j6IaZbyHeA/jOM8JLFfniZ5lyR3UG48H8g+R
w3+fXvFW92hHcZm5B1sP4f+sxww99qi9D3uxjGef+vsT+KqwjPeRHoesD+IA
Lpi3iqc1/3w9a3ge+408QV/3vShXYb85WqAZxjkzSP+GvtOByXdK76IWGc4d
t1+rz071l6i3ne5AClLRQS7PjNn0rzuF3HZ1Fok3WpfQClqJz/a/IFPujXiB
OT+JP+ID5opbqNUSzbFV3NV7POd9gWd4ivO8P9RoytMMjbGFtwlNT2rbf40V
vGVJH7m17l6OVViD1eiX9LL3ivcllifvivlyG3xPB9x9Pa2ild6gUdb//03/
AJVbsqs=
          "]]},
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwl1DlPlFEUxvGLGhk2N7YBZoZFQHFFFm31K1igjTGxAdwwImBjwWIhgpFh
STTg0liYmGhijHZ+AcUAKsZoRLCwxcSIuP3eWPx57jn3Oedu71B5ouPw2YwQ
whp/1paGUIaBuhBKaWdRCIO1IVzFZmxBtdw32lkcQiEtQD7OiOPbQihBEYbF
xbQuEcIOHInLiVvoJ/FuNbuwE8ntISSQr2aMjkfIT6Dbeu+TIXTRMfFohPk0
uvnTeo5iBMf1Xtb7AG8zXxPK+VIo471Bb+K2/B3cxYLet+gUJvG4JIR6Pfai
p8Ya6MKU/pO4qM8+vgY04pq4VH6/Nd+5sz0R0fmwioTaJMpQjhSyeZar3SNi
FSFkoVl9rbkmOm8+P+W+8dF+Vu3xGH1CB81f8D7T4nHjDTwTdElNiz6LdFSc
J5+m0877Ck/t9Rni5l+onUefPm9pSq6e97Q4yziGJC6LE3TI+WbVzmEGK/iB
LmevpltRhfPiK7yDaHWWNrTjUWEIl/TJRCJ6b6TwwHkqaUX0TtG3FH0DmObL
pjnYKL8pWsP+nrvPTHuKYT2yo/2ih7+BNiKHNxeV/Pf1r4ruSJyHLP1ieMkf
aAZ+2d9v/MFD/YMei+7kr7kleo73nv0POVu+cxWiACfFK2p+YhWnxF+t0ecN
+tGLAVzXL40RdNhLH09/9JtRU4gCZFhjDVp5inlqjGet3SueozP47ixD5l4b
z0Vv5H2nxF+Mj1rnMx0WZ8t/MJ7hn0WuOAcLcm/UHsQhtOkdj745+RLaLl5X
+v9/wD+UDIuD
          "]]},
        "1.5`"],
       Annotation[#, 1.5, "Tooltip"]& ], {}, {}}}], {{{}, {}, 
     {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJw1mHk01VvYxw0hQw7S4CYhhFNkiNzS3iR1K2NIpaQbuiRDhAgJIUWFJlJp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       "]]}}, {}, {}}},
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic},
  PlotRange->{{-4, 4}, {-4, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.687178790195877*^9, {3.687178937556449*^9, 3.687178953752338*^9}, 
   3.6871791155882072`*^9, {3.687188977334732*^9, 
   3.6871889859679117`*^9}},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", "y"}], "\[Equal]", 
     RowBox[{"l", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "x"}], ")"}]}]}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "y"}], "+", "x"}], "\[Equal]", "l"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"y", "-", 
      RowBox[{"x", "^", "2"}]}], "\[Equal]", 
     RowBox[{"-", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "l"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.687179601341906*^9, 3.687179664171835*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1.5203146809745363`"}]}], ",", 
     RowBox[{"y", "\[Rule]", "0.3113567291867051`"}], ",", 
     RowBox[{"l", "\[Rule]", 
      RowBox[{"-", "0.8976012226011261`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1.075972408704098`"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.8422833757075046`"}]}], ",", 
     RowBox[{"l", "\[Rule]", 
      RowBox[{"-", "0.6085943427109112`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.3056577277295606`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1.906573353479205`"}]}], ",", 
     RowBox[{"l", "\[Rule]", 
      RowBox[{"-", "4.118804434687971`"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.687179657251781*^9, 3.687179667782847*^9}, 
   3.687188986119204*^9}]
}, Open  ]]
},
WindowSize->{808, 871},
WindowMargins->{{Automatic, 458}, {-64, Automatic}},
FrontEndVersion->"11.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (July 28, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 152, 6, 68, "Text"],
Cell[CellGroupData[{
Cell[735, 30, 504, 16, 51, "Input"],
Cell[1242, 48, 138, 3, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1417, 56, 223, 5, 32, "Input"],
Cell[1643, 63, 189, 4, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1869, 72, 120, 2, 32, "Input"],
Cell[1992, 76, 109, 1, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2138, 82, 338, 9, 49, "Input"],
Cell[2479, 93, 217, 7, 52, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2733, 105, 345, 10, 32, "Input"],
Cell[3081, 117, 17672, 304, 243, 8693, 156, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20790, 426, 458, 12, 32, "Input"],
Cell[21251, 440, 7271, 133, 238, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28559, 578, 715, 18, 54, "Input"],
Cell[29277, 598, 368803, 6210, 376, 263991, 4490, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[398117, 6813, 205, 4, 32, "Input"],
Cell[398325, 6819, 383509, 6454, 376, 270407, 4598, "CachedBoxData", \
"BoxData", "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[781871, 13278, 629, 20, 32, "Input"],
Cell[782503, 13300, 953, 26, 112, "Output"]
}, Open  ]]
}
]
*)

