(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    553047,       9562]
NotebookOptionsPosition[    549311,       9466]
NotebookOutlinePosition[    549669,       9482]
CellTagsIndexPosition[    549626,       9479]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Problem 5", "Subsection",
 CellChangeTimes->{{3.687187380597857*^9, 3.6871873847704773`*^9}, {
  3.687187423713944*^9, 3.687187503193817*^9}, {3.735473002231147*^9, 
  3.735473003215126*^9}},ExpressionUUID->"2f8d886f-54d8-4788-a90c-\
135e1efbe8a4"],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{
   SubsuperscriptBox["\[Integral]", "0", "2"], 
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{
      RowBox[{"x", "^", "2"}], " ", "/", "2"}], 
     RowBox[{" ", "x"}]], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", 
       RowBox[{"3", 
        RowBox[{"y", "^", "2"}]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "y"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], TraditionalForm]], "Input",
 CellChangeTimes->{3.6871876459357853`*^9}],

Cell[BoxData[
 FractionBox["50", "21"]], "Output",
 CellChangeTimes->{3.68718751397657*^9, 3.687187651677956*^9, 
  3.687188985222074*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"8", "/", "3"}], "+", "2", "-", 
  RowBox[{"128", "/", "56"}]}]], "Input",
 CellChangeTimes->{{3.687187523091139*^9, 3.687187531440198*^9}, {
  3.687187575705583*^9, 3.687187599127611*^9}}],

Cell[BoxData[
 FractionBox["50", "21"]], "Output",
 CellChangeTimes->{
  3.687187532419187*^9, {3.6871875776694*^9, 3.6871875997306547`*^9}, 
   3.687187686511973*^9, 3.687188985271661*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.687187688496564*^9, 3.687187690648204*^9}}],

Cell[BoxData["2.380952380952381`"], "Output",
 CellChangeTimes->{3.687187691331839*^9, 3.687188985298867*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\[LineSeparator]\[LineSeparator]Problem 6", "Subsection",
 CellChangeTimes->{{3.735472976864049*^9, 
  3.735473007503522*^9}},ExpressionUUID->"a6654b17-9af2-4ae7-825d-\
c22e5790b674"],

Cell["Defining the functions...f(x,y) is our landscape", "Text",
 CellChangeTimes->{{3.735474314368039*^9, 
  3.7354743467830677`*^9}},ExpressionUUID->"f415c291-e8c0-4f26-8dc4-\
2d151218aeb2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"myf", "=", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"x", " ", "y"}], "+", 
    RowBox[{"y", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mycp", "=", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{"myf", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"Contours", "\[Rule]", "20"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.735474351463694*^9, 3.735474355735825*^9}, {
  3.735474886248733*^9, 
  3.735474905120579*^9}},ExpressionUUID->"633273d1-223f-4c58-b867-\
40c967f80fb3"],

Cell[TextData[{
 "\[LineSeparator]\[LineSeparator]\[LineSeparator]There could be a maximum or \
minimum at points where *both* the partial derivatives of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "8d904d62-6b5b-4e65-9116-079b9c4bf9b4"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "89dd16dd-1ff9-4f60-9e41-5c9ea908a5c9"],
 " are zero."
}], "Text",
 CellChangeTimes->{{3.735475166063724*^9, 3.7354752906952677`*^9}, {
  3.735475493184144*^9, 
  3.7354754938071413`*^9}},ExpressionUUID->"167fac2c-46ec-4955-ba42-\
0d4ac423220e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"{", " ", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"myf", ",", " ", "x"}], "]"}], ",", " ", 
   RowBox[{"D", "[", 
    RowBox[{"myf", ",", "y"}], "]"}]}], " ", "}"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"myf", ",", " ", "x"}], "]"}], "\[Equal]", "0"}], " ", "&&", 
    " ", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"myf", ",", " ", "y"}], "]"}], "\[Equal]", "0"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.735475345528529*^9, 3.7354753924471292`*^9}, {
  3.73547542332028*^9, 
  3.735475473631369*^9}},ExpressionUUID->"7a3b7079-e891-44d0-9cf3-\
fdd8b4db57c5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", "y"}], ",", 
   RowBox[{"x", "+", 
    RowBox[{"2", " ", "y"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.73547535594921*^9, 3.7354753949795513`*^9}, 
   3.735475474184527*^9},ExpressionUUID->"f2ac8f71-5de8-4005-b1ea-\
b886a625c903"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "0"}], ",", 
    RowBox[{"y", "\[Rule]", "0"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.73547535594921*^9, 3.7354753949795513`*^9}, 
   3.735475474190587*^9},ExpressionUUID->"40824556-8eea-4a23-8219-\
a6f2d02ba08d"]
}, Open  ]],

Cell[TextData[{
 "By looking at the contour plot (below) it appears that (0,0) must have a \
lower value than all the points around it, so it\[CloseCurlyQuote]s a ",
 StyleBox["global minimum",
  FontWeight->"Bold"],
 ".  I could also take the second derivatives:  At (0,0), ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["f", "xx"], "=", 
    RowBox[{"+", "2"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "4455e31d-15c0-4e92-a9fb-fda332f0db00"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["f", "yy"], "=", 
    RowBox[{"+", "2"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "11aa0b2a-0ec0-44e3-b604-2c4addc624f9"],
 ": In both directions, the functions are concave upwards, which also \
indicates a minimum.  We can tell it\[CloseCurlyQuote]s a ",
 StyleBox["global minimum",
  FontWeight->"Bold"],
 ", because there is only one critical point.\[LineSeparator]\[LineSeparator]\
\[LineSeparator]\[LineSeparator]\[LineSeparator]Now the path is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{
     SuperscriptBox["x", "2"], "-", "3"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "4a0b1204-fa8a-48b9-ac9f-e23e9a986481"],
 ".  Rearranging this in the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", "k"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "315d7c35-2fdf-4897-9b63-a692d71502f2"],
 " we have ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"y", "-", 
     SuperscriptBox["x", "2"]}], "=", 
    RowBox[{"-", "3"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "3025e7c4-bbee-45c9-a456-6452e62afe84"],
 ", so ",
 Cell[BoxData[
  FormBox[
   RowBox[{"g", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "1f5d8aca-0acd-4328-ab88-bfe3189906ae"],
 " is"
}], "Text",
 CellChangeTimes->{{3.73547437024793*^9, 3.735474405959141*^9}, {
   3.735474436607163*^9, 3.735474553527165*^9}, {3.735474910639845*^9, 
   3.735474911144004*^9}, {3.735475299767352*^9, 3.735475335639944*^9}, 
   3.7354755229835587`*^9, {3.735475557839232*^9, 3.735475630295368*^9}, {
   3.735476383633375*^9, 
   3.735476548119927*^9}},ExpressionUUID->"2d666c7a-750b-4f0d-947d-\
85b4f7ea2de1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"myg", "=", 
   RowBox[{"y", "-", 
    RowBox[{"x", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myquad", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "3"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.735474625312787*^9, 3.735474633279271*^9}, {
  3.735474919056449*^9, 
  3.735474933535952*^9}},ExpressionUUID->"042152f0-1725-4c02-808c-\
27327f2c6630"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  
  RowBox[{"Show", "[", 
   RowBox[{"mycp", ",", "myquad"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6871787737337914`*^9, 3.687178788739613*^9}, {
  3.687178935229148*^9, 3.687178936705537*^9}, {3.735474959280259*^9, 
  3.735474959615283*^9}},ExpressionUUID->"ef43f669-41d5-46d4-9c25-\
bd1173ca93e0"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJyMnQnc1cP3+J/n6dnX+9wn2ZcUkSUlxVfckaQkS7IWQpEoe7JE1rKGyBIS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    "], {{
      {RGBColor[0.148, 0.33, 0.54], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmntwVdUVxs89FxKEhOTm5vLIvbwJqO2MioCCVuRlgBYEQ0AQeQhTENsi
LxWwWsdWfIEPWlundPpPq2JHW1vACgg4UXFGCxZB+0er+BZRLGpFAki/H+vL
tDM5s9fdZ+291157Pb61T3pds+iKH6VJkrTLJon+klH6MSiTJE2it5WS5ETb
JHkynyQfVCTJh3pm6V2ajd+LRF8ueq54BmrcwCqN1fO+6KUdk2SZniXieawi
+h9V+1J5kowW/xvq35NLkmlqf1mruUoxzxKtddBrsc42jZuv/os055uiz1bf
+5Lt62KSTK5MkqNqj2djbdZljVGiO2neJ/IhP/u4SXwf6d1erdm9Tut1SJLt
pVjnI+9rp8YtEP/FmqdW767X/IVSzMn828SzRPO8rd8va563vNaFaegBHfQW
z3vq/4HmuUt9V2ej3af+v2lMD7W7qpPkPvFO1HNQe+mndpqew6KPSa4+4mkU
PVjtMeYTfanet4i+RvToqliX9cdko+2rd/PLQye72yTJiso4A/Q/Oxv0fRo7
TfRIybZb/d3Qi/i6q31HcxzwfCv0Pi1LknVp9LFf9NlV+rxZ/D1LIcMB929X
3/crY95hacg8V2vVp2En6PavFaEXdHGqRmcvGY9Ll9/omaaxJ9W2dIj9b0G2
dtEP352a5wI99er/XHwT1f+F2j/mQ849kudNzVmpMU8V4tx6iD6osUM0bmsm
zqWt+OboXZnaX2jsc5L316Kf1LlMkFyPqb1W7S7b3jka8472MUfPJZrnPP1+
N4k1X6oIXvZ6vs+Ic8AWOIumYszzK531Peobab+aoucT8d6mZ4HOqzEbNn1S
8o+XbP/WuDPEe0p8V2RCh80VYT/PVwSNPueLd7vkP9Am+niHrVWU4l1lKWxk
tH2Bsxptm2FfZ2Vjb9gM9sLvIdpXg95doOetqvC3jXpe8Pyse7XkmaFnJrao
57Mk7OoF2ddVmmOe+mbp/exM2PNU0VP0TM6EzV+O3YtuUDtc7Qfi+a7ocXpG
63cbtSfUjmT/oifxiL5J7ddqfyL+9qY/ToIfv/hQ9JvaxxbtZ5jlIsYg2+hi
yPaXXMSD1drnIY3LE6eQTTwL1V5nH+ysdpmeeaK7q71Rz5Ik1kSOJrWdzIOP
4muve61r1bdf9FrR48rCl9Z57lmev8X7ZI9zZa8PIZPscUUa581Zz/A8a8Rf
YznPt25f9/z40hXmX5qP+EkcPeH50clI2wj+fjQTe7ksE7bWYl/bp3jYU+f7
mtoN+A6+Kr7uFeGPxKIjmuMh7SerNfdrjWr9bqz5Hx88zHdcT89MjKN/i+kW
9/fxb2jOink4r+N6brANdFG7XM8I0dPTkP0Wzd/V/deL7pYGP3EGf9qTCZ9C
N5wlZzHLeqevq9aZng2+PmmcI7Z0kriQhi0hQ5n19o37R6m9TO1XttWmNHwA
+3/QZ8pZnKm9PiXdHcH/9Vxlnpk+S85xuvux5wX2o0+TaK82jd/MNL3fNPOX
LMPiJOLDSdt/mobcyHyDaXTSO409wD/G/Ogta/+in70e9dgbTWPn7cxDf1vP
w1qNjku3iu5g+mPrEJmIV416Mpa/HGCRxlrMV24a+0+t55Vp8DMn+8v+H3/W
PnLc/AMzEU+Y81AS8rbzPJPl4y/qDLbKx4fILg/rrM8rhP7R+y323w4+61OW
+WOfdXvTJzwnPvK1+4ldpzy2yfYzzfQcrdVXtnV1IeQq99jdXneS4/aLjs+L
5TsL5ZPL5a9tlKMGVUa87WJ7B9vgZ8SErHPDue6/yzGr3vpAj+hkgG2TPDXW
doLd4vvk5QOO772cz76TxhjoweSlNPxyuNpa65lcMFTPUvFcZPol9lUWv6GH
mp6SDXwHzgODXa89LpVvH66NODnY+ZHcCJYCR8E/0JiwQynkbF8KvSHvpWqf
yoXPjiyGPJ+3j3XRfT/rH/9eaB/vr3aqY//xNOL/Z7ZVzhL+nmnY6EHb9knr
inGHnJe/ZxvjHLto3XP07CI2tIl8iS4bioFpxhTDXrBF+Nd1FTaRnPtqQt4v
LPN48YxR+1ES+ednbSMHbclFfm0sBh4cYdmavS562FoVvP0zYS/Mi83c3jb0
DPZE948aj31ZCNz3d2GPB8BxbUMf5GZadPKJ9rKYWJEJDPyBMc+asoiVX4nv
lVzgwqWSrb488ivxrZvPlL2Q26gD5ui5MhPjiMebJXP/iuAnD5b0zE4D35B7
7tNZT89HLZDpJr+Tvkryh+2F2HcX7x0Z8QPmb6MxszU2q/a1XNQJK4rxnvnh
IceT619VO0zv/iCeS4qBtaDBW5lOUVNs0/oX690G9T8u/r1VsUfy0clS0Gfk
w7+Xlwd2fsxYcUgxzgG75Cw2C/9s6hi+ii+R38AVTZWBZcFY+Bs+SK4E15I7
+T3BtoHezj8j6hn8CF/7YbvwsZpS4NmafOBczo+z49w32O/wQ3g4B3A9OfsT
P0d83uRbdHG24wEyNNrermsXum+w/+P75PAezuPkrJnGJZzzHsv8eFXIjQzg
NfRE3CvrFv3f6qwYWBayISPYHOyNnGd3jvG14v2mFJi2Qz5iC7zIsFV63dIx
YsE/ShEbh1QH5nzRuBOMjx+A82/Tuy/VX94t9tnoGIqdMBY7RP+dy2P/y2uD
XlYbPt1at23IhT81V4efga9Y45mOsTb+RGxCrj85ViEnemH9hg6x/6c7hn1g
N/W1ca79aiM+UZuBVZr1/nk947NhR/wGp7O3WcbVr1aHX+Pf4PnW+u9Fy0Mt
/XJ16LqH5n+lTegFWxyhfQ5NowYBT4Il37X/Usfgw9Q0u1zXYN/I+2gu5EIe
atdmy4hsd6RR66Bz6nTiFLUzOthqec5znsHGiOucL369sjJwM/sBMy92DFnm
szhBfZ8G5gNXbLIOkSHJxX3AsEKcK+/IfeRlapLDxjbgBvAk+K3OWIL6j7y7
v03UH+87b4LLphuzNduXezj+U68g858dW6gnjhXDt1uK8R6+RUnYND6B3SLv
056HOmKKcwx63exYcao67g3eKgTWAIuAN56xzaPDNWnUJPjlG6WI5+fb/p8x
T5oLu75G8zxtWyR/zpB/DWW/6j/k3ESOyuTCV98tROyvdxzHZsgr2A05hzz1
nOjVtZED7lS7sxT3J9yjNDmffup6hHsPapKflqL2uTkfOWed73zAyMxzxPED
+cm5YMDZnmee8zb9/5F+J2nMl8W4J2Kvm3OB725qGzZI3oAH2VkbfMXeiFs9
HbvIz9gE9lBn/HNNErEbvc5zHUEc5uzWplGT8psamLy8yDi5u7HBctvnCOf3
Bo8tae83Sp5iKXAZdjbHePiEccK9xgzIkzVmwz7R9QWWh7xBnCJOr8qHPtHr
I7nwwd25yA8TnSPA+dTV4JkbnKeZv2isyPwl2xg8xCZiFPkGHaI/YgX5BfnJ
G+TVcb4L2ug7AXxmO/c/VYFJiLH0kzc3VcXdwUbHgwOOCejyXstD39vuB4ve
ncZZXGKamPGm52HOpbnAJr+tC7ywqyziJpgZ3VLXYI/jjDHQBTohf5DThjqv
7bYfUwuQB5Gb+XvWxpx7qgMDsAfskzszYhTx+ffW+QXFwH+7fS6bHKc5X/yF
80MnTY4lrPWw6LOcN5tdB1CzP+h8it2vNKaFZo/sD38pueZmX8845+AX5IRW
TPek7znfKUTtybrUmws6RK4Bf+arw2dek/20zwe2AeNcVgx5NuYCTxCHqTe5
u2X/yAF2QAbenVkduuMO4MfeF3GDnJE6j4DF53qehY7J6HBVGhid37/LRe4a
6Ps8Yg72V+Za5RzH5nOtW+7xqHvAVENNc0fdko15+tp3iOv4z+o07gzpx1a5
16bu6OQciH9xJ3ePcXXB+YLaZ5njLRh3kO2R/EUeG2B52CO2wT65m8k7p95t
m2YMd6G17h+dxl0hc4JHJhiTcK+L3bMucYQagDjTqzp0caH0s8P+wj6OOnZQ
p3fuFtgJDLWvEDXKweqI9dj85HzYPTTv8qXABmCETfbRRcbqm0zjN88be41w
7OMcnq2KHI/PvmV+fAeMv9ljwXU1HQPbHbD/o1tyfrPxPOM227+myZ/Xy0av
rIs4BM39+7mFyInkxt+UYs71ajflwu7HFsOOsWdqffyOtS5yu800voWPYYfo
b4flxxa2Wzb8mDiLL++wjreZ3ml+7rSIj8TGL3Tm6yvC7pAVHuIneajFdgjO
RRdgAd7t8JzI9ay/ZzySD/8s1AX+edjxYVVlxF/s6iz3g4sarBvm4/4ZfyMm
D/T62xwr1pl/lvdOPGHcs94L3x7AI0/kIl4SN8kr3NE+kAb2oNbh7gAcj6/d
ZX/j7pY7XOpT/Awcha9RWzOW+7Qb8pF/uedYRv7jO0QpYif2jF/zHYB+sAJ5
Ya3teYLpMc6na5xTWff+NGJp3vJwn9DZPNSha0uR5/cUIvbeb1wy0TKD0R4r
hMx7awKXsO8drvP22ibBO+yNWMKdHva9y2dBvCOugjuwA877rIrgg2enbYzz
uN21AjgK/hbbSH/zsxY2Tl9v+8Ve+xRxi/jV5DuT1Y5j5B70SP4f5dhFLJuf
Bh82gI1ubY2TZVHHEf/Bxqsce/ub5rzqva9F9uUuvusY6VxGnESeOy3nENPY
A7yMOe37FVErUk89W4p8BSZFn9Ts6PSOvHGg3s8oBEYDh4LHwOhgpdOYxbF3
VDHuIr5dHfgIHjAMc/Ad8Q1jmzrjB/AYmAA8QF/R/D3SwGn0E9O62oaJ5XVe
l3uzBtO0Y8xPbB7u+MxdEf1gJ3jGmh5kfc0z1mvw2OfcT5y5x3EH+pjzAfe0
893f5Lw2wrbdyTRzt3if7BG9dLbN892km2lyDLmGmo620JpT0piLOQvOR6x7
3Dlvru+7wLTUJvjkQmP4/bZ7bJ77sSnmWeT+OdZJD+93mdeaZ3nyXpc7xhrL
xjmWrLcB1XG38nopaqPujgPfmGex9cmZkoMavHfm5wxZl9qQu9kr07hDJn5M
8Dz1lgFfWGoZoLnbm+pY1xprwO3IwFjqgEbHHeyEeDPUeznhezvyy6WFiOXL
8nFOQ32O3GeB4a7Kh68Mse+8bTxMjjlmfNB6bsN8FuAG8MM7zrnEbtZA9j72
a3Ai++U+k1qZbzbv2bfBW9S/5GDu8rinIYdc6/MCw0GTE3+ej9zMvQvxY77l
J8dybwi+5NvEAtsCfnCJz5Ecsd3ffEd5LPFnpvmp4/im0WR6gPeFDW91HJls
f8eOqQvGmf7INjzca43xO/pbjJkG2l6wXeqpxDT2OdFnd4vtbaz9mlwx3vOA
ocbZTtjTpZbtPGM+1u1jGuyHnZ6+10ojHl9oXY3yHTa/DxTijohvceid2EWN
+14hfIrceNh5gNjP3IO91t3WLTL0dQ7AZupNs1aN+ZELn0Emvj+Mdhxo/ea+
wj7LPXkf2wPfbnraX7AN5AOfNLv259suWKGf+d8uhI1z14Jue9sfe3meW+2n
ve1H1B3UNNz7oafdpvmuyZ0b93arLA95B5/BrrmLpfbv5Tmx636muZNh3kn2
S/xzie1/pXkO2W9vS0KWxPLc5LWaHLeIX6z7mWMZ/BnPw75XeC301tc6ZD/g
CGyJeMCd1SpjfmIPsQ99kj/rPZY8v973cj29r0bHJ+JUk+NVo88C3AR+Qmb4
J7ufta/w3uGZYr2d/n7hvfO/GCt9h9aa19kf2J2zXeo4yZzEscHFkG1QMfbV
ZB8BI+Ez5HEwOjT9k33WjD2tQ/vXFt87YdsrLAM6+Wdd4KF/1cW+M977VMuG
/P8FkVJ2LA==
          "]], PolygonBox[CompressedData["
1:eJwllllsVWUQx4eudLn1nnvupfaeU24xYjD64AJGwYgPKvhQAy01liXUktjG
DWxpqOALMYIxESNqo7HGF1GKQRYXTJGqoUITscW2Pim1IC6oISzFBQr6+2ce
JpnvzMx/5ptvljOjeXXdk3lm9gJUAFWGZmdhOhNm1bHZe4HZA/lm9dDcyKwv
YxZPNbtUZvZh1ixdbbbjKrOfAVmJ7t/oLMG2pdjsWNqsaJrZY+gfLDKbzrke
+Vfl6E4xG0yabcTfIuRPQCXoZvC5BvtTxJCCvxl/p/E9G/yb4Gdjv5BzNxi3
wZdgP4buTPxtBr8ZnSZ0uwrNVsHPiVz3PJgx/i5xHkK/kfMV+DuSrttFfG/A
7+AOPehvh+bpvsSwuswxD8DvATNBrBuwvzp0Er8eyiEv49wHXgvncs71KbMk
/nqJrw6+A/mjyB+H2pAvxMen+FrBne6DXwf9yvkUNEIse8nxRfzXgncZ+2Go
AP8Pcy7EfoTznIR/205sQ1Avua3BfhTbW7nTK/h6mftthZ+PfB53aeHb3fDf
ozML3euhH+AD4stN9TdIg3+Acyu63cTQiPzHjL/FKr6Nwz+UddkCqBr8YWL+
rdzvoLuMZD2WHDQMf4V4q8FvAP9f5J+FHot8yFcePr8jX026E/xP+Fic5zk7
CX8QH9O433Hw2rBPhV4r/dwvRL8UegTbPqgu9ppSbQ0in0l9XIP9c2Bt5rwJ
/mLksQyC8Rd8Lu1YqknVZgkY4wWOWQb/OfR0odfEF/D5sccqTGE/BcY4sZ2A
jgRe46p15aQT2XowOwu9pkNkHXw7We41sAA+Q45awR7A5vcq7hh6rtupnzX4
uhGbKuJ5kRi3wB/L+tsdRn+U/OzG59J817kHvOfT3ht7iLEBrNv5VoSsFp1t
6N5QSY2UeA9X0std6DQhOwx+DbYrwLy2wN9gecZzptxNEtNOdNsjv6t68h3w
xohxbYVjCOso35bBH+LbBWSDgfvu5zzB+Qy0r8JnzAfI7gdvZb7b7A38DfWW
HdzhTNprTLU2gc1G+KGkx3ov8SzF3yj1db7U7By0lfydTnvunkUeoTsJfmWx
z4D/Up5j5Vo2f1R5jIq1kW9D+G9GZ6DYe2gT+Fnkf2K7TvMEfgz81mLv8VlJ
n3mafcrxjKTPHM0evbne/qXYe1k9ugU+ih1LM2VMsRPfIs5HsD8L/ybyL7FN
EdNbqr3IZ0Me+WknviG+5RV5TW4IvSZUG7J5LfSZo9mjGVmq2Y7+/gqvkX2B
zwTNBuX8Y87dsfvSDNAsmB77LtCddXfNLM2uX/i2Fn5Z6LlXjpSrWs49Cc9x
B7k4kfFa0cw5nvGdod2hmabZVsd9+st9J/QG3oPqRe2Qf+C/Jb62KV5Tqi3V
jGonx7dv0P868FmgnlPvaUdpV73PeX7kO0m7STP9Ts4T0OKE77BJ4r0c+S7Q
TNJsUo2oVvQG59Qrsc9azSTNpvbY766eVe9qR2hXaCb1BP5mejv5uBD5ztPu
0054VbMq6b06F3/L6b0a8J5J+B2PIvso8F1wCMwl2qWh62qHapeqB9QL6slb
0L8u7bNNM+NddPcHbqucKrefBF7LenO9/V2R50Y1q9otrvZe0gwogt8ZeG7V
k+rNROy7TDNQs/B1xY/9APQgWG9nvRb1rSHynlPvaSdpN2nmaPZox2jXaMdq
1+ofQ/8awhCWanhX6DtUu1Q5qQp9Z2h3qKZUW/8DcVs8UQ==
          "]]}]}, 
      {RGBColor[0.23620000000000002`, 0.379, 0.6226], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmUlNWVx7+2u4pu6e6q6q+ru+kqwCUCOVEUNIqoqBFZ3EG6QRTJoOio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          "]], PolygonBox[CompressedData["
1:eJwtmHl01cUVxyckwSQk4b28vETe+wUICHqqssvSagGBLGgXwr4dVATa4pFW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          "]]}]}, 
      {RGBColor[0.30008333333333337`, 0.4091666666666667, 0.6426666666666667],
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmnmYlNWxxr8ZZmCGmenpnp6e6elujCCC2yUK7hcEBjc0+qiJwpOISxT1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          "]], PolygonBox[CompressedData["
1:eJwtmHl81sURxhdISCDvC+/Bm7x53xfLIeHwRkVAuUGIeMQDsFZEQVurEmg9
oILVelUQFFFQLgkQg0I46oGitGAgKHhBgyiHtVaRCngj4tHa79PHP/bzm/nt
7Mzs7Owc23b0uIsqG4cQrmkUQh7f+aUhfNc8hErGxnQI00pCmNsshEuahDCn
OIRh4JeC38GoB18PzaI8r1nA2tnML2FuQX4IQ2IhvJcLYVyLEErgXw9+BfTv
IbAt9KOAW/HvYegfYdzN2pf5N5a53gUh1LQKIdY6hL4tQ7gB+eviIUxG5tLG
XnMX9O2SIfyE/PaFIXRE1g38e4b5ScxXAr+YCSE/EsJN0RBS0P4VHdNFIVQx
2iP7cCKEBPAg6PtA/wrzbcAbxI/5P6LPRuAD8LwN+H1kTGA/E9hPA/P3wr8O
+snIKEe/HPo2oO8WdLoD+lrGTOw6kj2tAC5Eh7bQvw7PGexlbIl1nc94EPgr
+G+A/0T4r4ffqrTX/gf5K4GHQHNeM/MQryehH4+tPsDei8GfgGcZskewphr6
VxlVyB8PviXtM9PZ9WScCq9Z7Hcrsg4zPxt4DfPd4dcVHs8Bb2DNqXk+kzrg
NdDEkf0i+sfZf5r9vs5++7BmKee1ifljmO/F2Au8kbEnz//qgWfBs5a93Ij8
a5G/jn8783wmfwP+mv3Usf8enPdW9r8k7b0cZcxlfhr2fgPZ/2iKjsgbBI9y
eDXlfCfB+zPom7P2CDSfA5/E/BnMT8M+d8k+2RDuZO1RaAZy9kvBE6xNMp4E
voLxFme5jbER+U3Y3yH0uQb6Kaw/gn5bwGPgbzPfL2ZbLkf/x4EfQb8G4B2M
WcATkL+C/XaDZiLwCdDsRrdtzD8IfBR+2+D3AWcwAX2a828vvFdBcx37+Tfz
M5m/ln8jkV8Nfgx4G8Yi8H7wPBvecdZXp7Axe86D9iDrNwOfyL/qAvu4fP21
tH1BNFvTvtO629LxMeBb4dcDfs+C/wF4UMK2kk/Lt8vinpvAv/HMlzGeAN/J
6Ah8BToNwdYHGO8ie3bGtpiKD57C3jpj3xnYdiZjMbyGsJ+V2L4X+g8G/pgx
jb31gf8QeL1S7LOUD/dn/VWs/ztrdzA2s34l/A/rLrB+EfI+Z31NC8eoEeiz
H/ovmH+S+Y+BZxf7bssH5YuXQr8xap2l+8Pwewv6m+H/W8Uj8Ajw3ayvg/8F
8NgAXsdYi/x9rJ+KvFrmP0K/y8A3w28i+g9n/eOsnwXvhfj4AuBNacdW3Snd
rdHQVKPLWPS9Grg9OgToW8hH8Pft8BsI/4Pw/zTmO6e7F+NMx+L//XK++10Y
5ayNMd8fFmuhqUDeF5zfS8j6HvqX0L8D+k9B9wXoOAf9h2ODhdAuQodhwM1Y
vwI8zVgL/eqUdb8c+auAp8DzPfb2DvT3AbeCXxW6rwFPApezh/PB22HDCPq8
UGxfVAzsCe+v0Gcd/H5En0+g74z+/Yq8507A+dBfB30dd7Q1+6uKW1Zj5C8E
XpB17tAe5wOfy5pn2Ms5zA/N+c7o7mhPTXSX+DcW+/VH52+QneFfRXBMH4b+
bWKOxfci7x7gi9B/OPrfBr+X2e+JJb67iiGKJd3hcQhej2HDhci/pcSx7At0
vA79xpT4LBUjFSv7QlML7QrGKuYvyzp23ML4FfC8Use2edhkKf5QAc3b8KqE
x83wWpr0XRoLv2XspTH7+w36Hs84i7nRjD7AlYzmzNUw/lnoHKBcsCDuWKqY
0gl550N/eqFtLFtPQuaHyDsNHSYDV2cNy0ZLgK9K25dEcyVwOutcVwWegPcD
/BsA/Y/o9yr2mwr/Quz9J86kPfreA95U8Rx8N2tP5kx3Y+tKzn8f8EPMt2D+
W9av5jzOSdqXW/JvrmJf0vDFzB/FVp3i9rXt6HClbMuaL4t8x5cD/5CybpLx
I/CmuGkV0xXbL4DfMvkL41PwVRnLHgJ+MGsfkC+kwJeDL4G+HfIfYn0X8OHg
z0V/9jn0G8BYHnWNdD/ndaHsi/6r+VfOXAV4LXAH1u9C1lNZ55rvOI8a4IuT
plUMPDvnO6O7U4d9hqN/nH/Nsf9+zjOm/JVzrFcOqAGuzVrXPOanp+2D8kXJ
HMT8JfhrPM86n6fYpJxT5Jw5UPpmHctUM3Vg7bHoeCPzvbFBR87nXGR2V/xk
ff+cY7xifTf+vSvfhX99nml2gQd8aiRrV0PzU8o1gGqBm9jP5/CrRv5i5uvh
90v4NUDTLd82k+0+Q5+hUfMU76Ep527tQXu5OWbZ7fg3IOkcqlyqmD0T3bMZ
3xXlsK7oegj5I7D177Um4xytXL0dfa5NuQZULbiV8WfgBGM28G3oODnmGk61
nGz2F9bfnTQv2ag9eE3KuasRNnwB/PmMYdVoqtU+Rf7EZtZBurzDfD30P8l+
wJPY7wHoH2D+cejX8C+AFypHwXtU1rXIWn5fgD5jss59z2PfznHbULZUDH2/
1D4sX24LzbfYa3OpeakGK0D37xL2/XLGIclmDI46h65AdgdoGmPbB/h3Erz3
QD+ftT3B90B7CLw/cF/Gh+D16NAQcU5Wbu7BmnlR18SqjV+D/p48r9nH/ED4
LwZexOids0/Jt66Bfihz+/GRcZxNb+xRBb43Ydm7mJ8Dv53g3cDz2dNT2GcX
ePeo78hK8DT8boxaZ+m+O+HYc4Z4KN8kvbdpjBOgbcR4kf1uh74xcxXKr8F7
Gg19Gf+mQjuF0SXnGlO1pnzkQvQpLHYtupzzKCj2GemstOY46APj5HzHiIHA
Z8JvftQ26qlaLulYWYS89fDbEneuUw2sWvhsfOLNFq5RVauqplBtoRpHtc6O
uHsF1aSqTeVD8iX1TOqdNsTdO6mnUG+xvtS2U82dh+zhuZ9zHfxHACfl38C/
YxTnXLOpdtO/EvVXKdf6qrGvB27W2ndJPYB6gRns4Rts0QU8Cj4R+1c2cY2r
WjeTdC2rHkq9lM5YZ60aSrXUkYRrP/WM6h33xVxbqSZUbbgp5l5SOV25vWPK
tZB6yrKU75Tu1hj0LWT+vqR7NdXwquWzyi/MD+NOVmCrgzHX3qqxVWs/w/wg
4AGMbeAFOfPSndTdfDXl3Cuflm+rRlGtIh96WLVbxrXIpcholLENZUv5ZKuk
fVC+KJ+V754K/mjENXTXrO+E7sYSxe+kfV6+v5sxF3gP/zogq4yxF3hw0rDu
zOsp6yzdVTM+zdxbiomqVRS/wd/OODa0Y+zMuGZW7Syei4ETGd9F5TzlvoUp
147Kscq1R9jvxAKfqc5WPbN6Z/UgfUscUxRbFMO/Z75R0ndLd0B3YQz/Oua5
x6xJO4YolvRT/k3YZ+Q7K7HHL/Dd6xPuRfXGoLeGR0rdqyoGKBZs4s4dLvSZ
6myPy7q30BtBCeunZxzb1TOqdyzXG0RT5yDlogMp17qqkT8BjhQ7toomWuwc
qFyoHvlAzD26enXF7FsVH3J+69AbRFvkt447FsyBZiq0pTm/PagGUi1UG/fc
Mtb3Yv0saBY3cw09s8Q5XLlcNdWDwL1yznWqmb9MuOdS76U3lkdL/GaitxPV
5EXodxxjBvRvsufpwMey/s6oazLVZoP5Ny/fZ/gNe2vg3/imrilVW/YC7xz8
b0fSOVC5UD3kCSnXYKrFVLOpdtsN3qPINZVqq4+x8ekR90BjwOvAW0SsQxvw
YTnHGvVco5KOwYrF0xmdwLuxx4NNXGOfhLyiYte2upO6m0+n3Bup5lXt++sS
18rqodRLKUYrVt/P6Kj4lnGtpZ5/BPAL2P/liHs49XJnsL85wf8q1P+n/NbS
lf2OAr6cf29EfEY6q0Vx14LqYdXLqoZXLS+akcD9svZd1fz9VT/G3Svojp8C
/hg2P6XANfppMfuAfEE2XB53j6BeQTXRRbr/rayL3gz0dnB8zntTjlaungv9
1Ih7OvV2w1KuHSVDsnqDryrwm5betv5b6tikHk292tKc3xJkc9k+GXcvKJ5l
Wb956O1jAjwOw+/rVobV03ZHn9vBjymwDMk6K+W3Mv3rlXLNp9pPNeHJevvI
uBZWDbQf/KGMfVU54/+5I+FeTW9an7C2T86xcBn0H8YcsxW71aNdCDwOfW+P
+M1Fby/q0dWr/8B92ZhyD69eXjXY9cC5pOd0B9rBu2XStbXuTCznHKxcrJ5/
A3BVyr2qahbVLp/F3IvLx/ern0/57bGl3ovAn824F1LOVu4+MWffVk2h2kI9
nno9xcCrE47BisXqybalvEfttTX/titWx11La4/ZrHsm9U7q0dWrf50wrWo4
1XJ6M9XbqWJiX+bPyjn2q6dUb3lmzr2/7rjuunSW7rqjuqsfZR2LVaOoVnmJ
f00jfkPVW+q/Yn5LUU7ZlvGbgN4GRLMOfF7GuUp3Snfrf4g5HYE=
          "]]}]}, 
      {RGBColor[
       0.37311666666666665`, 0.43483333333333335`, 0.5997333333333333], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmnm8lVW5x9/DOWfvc84+nLPHs4d3kxmKIKIUCKZGCt5uiQzOEwEONycM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          "]], PolygonBox[CompressedData["
1:eJwlmHeYlNUVxj/Zmd2FpcwwO7sz8w2iQpZmEKXYUGlJVFAXG0joqKAsxRgx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          "]]}]}, 
      {RGBColor[0.44615000000000005`, 0.4605, 0.5568], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1m3mg1lP+x7/V3ep57tNz733us1OMtSwZpWjG/pshTIU2LcJoIcvY15TJ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          "]], 
         PolygonBox[CompressedData["
1:eJwtmXncj2X2x2+e3bP47rtonSxPnqZEaSqmaSY0toRQNMWjiGlkqalkkj38
shQhmqLtV0Si0eL3m5kopKl5VBJCJGRf07w/8+mP6/U95z7XOdc5577us33P
vWNQp3trB0GwtVYQ5PO7JBsEPeoEwZPAi4FPpoNgRUEQdCkNgtPA61i/AK4u
D4KKXBBcGw2C5TCOqgiC7eAXgJ8EfwB8K/hMVgnwq8g4nDaPeK9Gxpfgk9n/
BrRbioPgaWgnY0GwHnwI+pwA/pp1NPCercALUuxFv3M541ngSnScXhYE37CG
AO/OBEEL4CtZe4B/5IyupbZBtrzOebHCIDinBBnQv+DMXuh3DJlPQx8QDoLj
OCSK/Kmc1wSZN+T5jEuAt7GuQf9ayFwE/+5IEBQBF7Jehv9b8MXw1gH/X/BB
oSC4EP3Hgl/H/u7wr0XWYGSuAt/Onkpoa9izDbiA8/tA74k/jsbxD3s+gj4N
mU8Af4m+d6LvCvgXgs9MW/cF7LkdfEQCHxcFwWXIq8vZtyCvHHwu60LkvcX+
GHsTrDx88Rg+vBr+GDbdiO7zpRO0b1gLgIdz3h5og/FfHXRvkgyCy/FdM1Yl
cCN8tA/aIlZD4NeQXwpvOWs/8rbIR9BaYs/XGftIvipm7YH+FM9qgGthz0y9
L3Tujv192H8KfcdwxlzwmZw3Drga+16BVheeA/AXYsMd6HcdNozHlqHo+y34
IM4sRt9rM/b9bHg6wtsD+YPxZQ0y74KezzpbYJ8XABfhrzuBb2f/Cc7PwH8t
/AvxZxp4BzZ25/6wNfgGeALP/gG9O/goZH8A/2PYsgUZg9j0e9Y7wHfwrA3w
zej3brllSna6Ht9UXX6hPw7vd+hYhq1NoTfGti3i4bwh4F8DL0nbt8uwYR/2
92V/Ie+2Bv67gF9Gh3+iSxSefPT7hvNGc19e4Hv6Gtr2rO9mCetVZO3R+2Dv
VdB3A7fOmAYYtAI+zRm3lPobOsPDHcgbg7y3OP869Bucta2NOf8cfR/QR0Jv
AX4N9LvxYSv0ew15/YFfZU8C+yPwd0H222nfxYngH4P/iM5T0eUY7+Qs8Die
dYTWARkPwn8sY1pv3s9x4DDy/lTmd5DFf1Wcf0mpv6mNil3Q52Df9cgYEfEd
1l2+G55S4DQ8f9T3yKoLPpuVh3470b8z96kZd643vAtZVwCvQeb5+j7An8Hf
A9m/Gd5R7O+fdcxT7BuHDTX4uzc6Nmbvk+jQB/h7nu2Cdgv4bcj7Dhtb4pse
4HuBS9FnIPIGsMqQ1zfruzoS+XcCV+CDifgC1YJ+yKpgTUOfB+F/AHhl1LK6
4p8f2HuQZ+W1LfNR+Iej864887RHn7/Lh9Ai+GQze/cpfnD/6rL2A69Dp7WB
fbAeeJq+lzLHNMW2l7KOHb3AHwN/H/w5zu/E/gn4ewDyf5PvdzAQ+G/Qzyu3
D8ZEnDOUO/4KvgX+f2P/3jLHcMXyzeyvrO1nXwFfwZ6qfMeMmcDz0XEztm5n
LQK+HZ/2Q/f+rHJknUo7d2Whr8Ifr6QdexSjFatX46/e6HYf9DD8fTmzObSn
eNYP+JWQY7P2FCjWoe+z6FuFD6/krGXKacj7CHwp8FrWhaXOkRXIbsOe9uhy
gWIi+CnFZGzpwnn70WcHZ7TF978C3wlcDf2rMscQxZIzPDtRYJ4fgbvqm0LW
Pawk+Cch50rJOA/9VoPngzcAz4JXImMl/nsIeUPQZQ/6T6/wnTjE3nUZ723K
+euBb4e+jvezgdU/6juhu9EI+j/QtybuWL4Kenfov0VmO+zLoE8B+MXIGKpc
x9qCL6p4ZzPKnEOVS0ug/0vfL/RS4NGKn7Vt872KTRnTLuKMJlHHOMU61Rhv
xZ0DlQsVQxRLHmL9Bdmd4H8YuD/2HkBeBXsex/489vdAXgPkvQd/Mfht4M+j
8yx0LwLvBX4r9MPQ92P/AvyzABmxsGsK1RYvsP8Z9t8N/mWZc4hySY4995U4
BikWNUDe4FLHVMXWZ5GXqLDNsv15bNoB3J7zYuB7oc+C3gYbvkTWRRnH+s7w
L1A8xv6j0HJ888P56OtBv1e5FRlNsK8tOnXg/I6sdsDvwZMtdU5UbvwCm67h
rCPoez77b0p6b0PVANBTGd8l5ehe8gf8s8il81hPcHZ9bBqNbZvQpy76FbK/
J/tXs792xjWCaoWWyLwc/i2cdz3nvcB52+BfjrxoqXPIAWSdRocdhc5Rp2KO
mYqd8uk9wMuijo3SuSGyM+THDeTH9ax32L8Z+a2hPY/8rREvwao5l0IbCf+4
Avt4as46SlfdgXzdTc7YyVm3sjaGXROoNjiM/umIazrVdqqxVGt1+JmumqMf
8GhWjHdxBJ0fA574c/20h/syATgffffDOwT6RHQ5wrOJdRz/Tuo+Y8O/C/2N
fh/zHdVdXYHMNui/Kmtexch3gLvj0x7oNon9n3Pfvke/a9D9IDbtBT7E+q3q
FfCDwlPOdZM48zjwQzHfnV+Bt8G+NQnTpdNR6EfgaQP/YdXnwM1Srh2LoF8B
fCDq3NUb/C74i3mfkTzfkRLgFxOOvaPhmc1ZN8Zti3LkB9C/gz+hfgD6RPQ/
GHMttQ2Zh4BHccaVyDqDzDHISvFOvip0zGiqWgF8M/il+HQl76NVxL4fybNh
8LZIWddP8X/zlN+h3qVqoj7IfwL/7Ua/cZw5SbEK/f4GrRFrCvR+nLGJs3Yi
rylnjY+5Nqlm/zjgBDLXIfsgMpPAd8K/rsj54Qi25ateh94LGXnIOpay71uz
ZwS0H/Dp9dBuw78HgPezWoEfAt8HPBB9r+C8luxfD2/zhGv7Gs7bjb6fx50b
irB/es4xQbHhj/DMB85w5n3Iuwwd0sAfxh3LEzzbhr/PzTpXKcefp3oUmfeA
z0H+VOC1nHeq2HdCd+MPCdc+OWzogj490a8DcHvWLPD14PuBq+C/GP6DPDtR
7DvxA/A0nt0PXMn3WsG38EjUsU4xsX7GMUuxaz6rMfCL8Jyt7Z7zpZRjjGLN
zfDsw5Zvk/ZFNc8+QtY6zh+bbx0mpx2jFKtUc5yFPhn918LbnvdXH/snRlyL
3Ih/y9g/hjPWFDtHPA78LjqsYu9cZJRD/x1njkdWuWpOeKck7SvlCOWKTsh/
Bv4PsbELvLcmnVv/yp6ngZfDH1c8QUZLbHkTPFbsHngG729GyvWKbJ4OvJEz
DtZxT6Xeak7SuUY9j3qfp5KW3U7xE/0mRayrvj/F6grOqOGsKtXkyD8/7G+r
O2cc4uwLwLcXuge5KWsZkqUcksOet3P+tk6r3s44pyu3v81qD+33rBXlrjlU
ewzGp4OQNw1/JpD/p6R72bewp3HYMV+xXzX4J2n3BOoNlEMaAL+ftm+Vo1YD
f5j2t6ma6SPgas7bxHmV7N+acU2r2lY1+aysY5xinfb0z/kb1Lc4DH98gj/3
gU8p9IxgPnhbeFaVuWZU7dgXnppy1/yq/dVjqddSjO2WdIxWrP4U+waq30Cn
jtAnQ38oaR/JV+pRfwI+Ar2DemnWzohnHJp16NlR4DqcsbvcPfSwnO+w7rLu
iO7KcfZ0Ym838IPgHXP2fTvifQfg8aw/693wbGLONZlqM/XcLwOvyPndq0ZU
rbgtan/Vx/7u2N8759yhmq4PcM+oazP1oJ3Bu0U9i9E71rsu5E6/DH9/9MlP
OKYrtisGzE65hlUtuxH6NNXL2NcAX9VSTkb/11OOZep5+uKPCTnrrhmJZiXL
2BNh7xP4c0rYMU2xTTORblnLkKz6yLgL+sisY6ti1iPAF6PPx+jXHJ734a0E
/xS8Bfj/gS9Gp2+LHfOXAJeE3evpG9S3WCvr3K+YnQft2YRzQRZ95wH/IuPa
Uz33UmytYs+uQvd4A7LOEcoVt6n/jLuGUi2lmqgg4xivWK871g99bsLmJUX2
0aPoenHEvfr9yjcp93Tq7ZSDqrO2WbYrJz6q2Jpy7FIP9QC890JvCn4O578b
90xBswXd8XbAl8cd++LsaQbcK2x4kWZCcd9p3W315MOhnc64dlaPdTLknla9
rXL27IR7XvW+S7FvGHtfDRneIXuQdZJnHeA/js0ngBuFHQuUA+6Dt2fY9VID
7OmRco+vXl8xb2raPbd6b+WwDHtz8gfwCO7HeeClSc/q1IOqF1WPpl5N70Tv
5oaYY6164rNh31ndXdWg1bybH9HxD8WuGftFPRPRbETPzkIbjfzpJf4G9S2q
p1ZvvRz9P2R/Mu5YVwB9V8Q9jnod1RA3xa2jdNWd092bnXRvoZ6kR9IzLM2y
VPOdQfaT3In8CteoUzQvxd648jf7zwe+ChnNgefhwys1z4m5lvhvjg65phA+
XDWP5hMhz2qv4tlCva+0Z0nq4ZsrPyQ8m+usmRnwT2Hb9hrvYFfSPah6UcU4
xboDcc9iVWMeDnmGoFmCajLVZnvjlqUYoVihHK1crZnYm1H3GOo1evHsWNzf
iL4V1fyXwP9Zyrqrx16JPr9MuXZTjX0Z8JCwbVGNpVrrXynHdu3fAHwy7tmP
7tyJkGd0mtWpp1Nvp5pYtXFjfLw45xmqZqmaKc9Ev/k8y0DLseaCLwA/E/jZ
c8CPJD37qsZ/I4HLwoY1U9BsQTzinYF+aWRX8axFiXP6goRnopqN6h3/T84z
CM0iHkTfBO83FTevYvrDyHo97VmiZqaLgZ+Le7amGke1zlchz0Y0U9NsbV7U
szXN9DTbWxvy7E49+LKMZ6KajWom8QbyzoZcG6rHVK9Zgz5N8jwD0Cxga8iz
Qc30NNtrFvF8SN9sN9W+IecizTBWaFYU9t3UDESzkHdR/oJyz4zHRn7+RoBb
sb8lvngRHfJLXTMFIc+gNYvWjLpr2DWiakXNKJqA/znp3KAZ/YPADyede6Vz
C+BhCc+zVaMOTbgHUS0kHd7T95P0t6QeXr28Yp5in+xRLFqf9n8H6pk3pP0N
6FuQji+lPcPSLGseeC/sbYg9m/J8ZhX+mJNyLaz/CJ4Bfirt3KH/EPRfwtNR
3/0bwD/JOacrt6vmP4Lsq5P2je7ce+B/h35hsWcE89j/aNKzB8WAUUnPLDS7
UI93jP0Top4tqsdUr3lzyrW6cr5yv2aW8k09nnXVfyUpw9Jf/wVopqjZomoS
1SYr0p5d6z+BlWn3iOoV1dPqv4FbU64ldCfaAmcUPwv8n8w76DMv7d5fM9q5
afdM6p2U81qj+0Ke1S71fyZbObth0r2DZp5D4W8b8exe541Wv5nw7FE1uWrz
pVnXd+qRBih3Zt0rHmD/JuBk1t+WZkiaJek/BP2XoBxST3cz5l5DM+UvOO//
c64VfuJZIfQ1Gc+2ZNMHwHXqObdp5pCt55mDZg//ndHXcwxSLBrK+RtTnilq
tqge72jIPbJ6ZcUDzSZX51yr6D8G/dfQM+VcKH9qFqscrlyumlW168cpy1aM
V+zXTEqzKfXox0PuOdR7qCf9He9vMqtHkWsq1Vb6z0P/ffRjfwlwcdiw7pju
WueEZ5Wq4W9O+D8y/Vem/0zuR9c3WU0rXFOptvp1yLN79Xj3ZHyndbc149Os
T/856b8nxcBLebfxlHtlzYhTEfcg6kXUg6gXkc/le/3HUpR1zaDaQWcuR3Zf
7stndWyTbFsV8+xf/4l0RJeeGX+b6uEmof/6rHth8WzIumdQ76AZj2Y9DTVT
LvZ/aOOBx6Y8q1GPOA54bNL/LWmGp1neiJRnC5q5/Triml61ve7wInQ7hY6f
VXimtSHiO6i7qGenobVOepanmuLxpGcqmq1UQl8GfQmrSYVnGpptLM2ZpppW
te2lKdeGijmNkP96zrlMPZ56vYtCrr3Vo44L+T9K/VcpG2clPGPRrOVz8Lng
cxKGVTPOiHnmoNmDdHgj5xmBZgWqQdZC+w/WnCh+
          "]]}]}, 
      {RGBColor[0.5191833333333334, 0.4861666666666667, 0.5138666666666667], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgeUllWShj+6ocPfTfefMyoGjDADKCbGuICZEfGsYxYFxYCLOYGgmCUp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          "]], 
         PolygonBox[CompressedData["
1:eJwtmHm8z1Uax7/uvdz9+t3f/d3frklRWVKDEBXyQsoytkm2SK4UGiIlTGQp
67VMtohqhqs0ZpKlJlPSItu0jKlptDJjspWSnXl/5nP/OK/vc77n2c5znvMs
p+Y9D3YbkREEwcQqQZDFt1soCDbmB8FL1YLgZeANkSBYz//yvCA4Gw+Cr1NB
cEjrIH8F/Fg4COaydjQnCLZEg6AR8yjzUsbt4I8Pm3Ym40fmLZlfC1yPMZz5
2ZIgKMg0jzPMF8aCYFVuEOwsCIJtxUFwAzw3s34CfZpE/U9rU8AZBW5z/s1F
9nzmy1jbyhgJ/pGqQXAK3aPwPMHaBejbs3YY/ELmlzOKoH+IMRU4F55bk0HQ
Gv1+iS6vwnM0uF2g+RgDVeHftfC6H54NsUcW8+uZD0kEwSfADQqDYC/26AP+
1xne40jWz4A/Lht7FAXBYvZaxL9drB9GZnXg55F5AHvexHwscCn/dmRa5xjw
gRLzk05jmRciYwHrx9B3EnBTdJyFrrMZzYB7s59+0IZY3w6/r5h/yPw083Oy
J/u7rPJ87oDfz3HbX+dzCngU+rYKjNOL+QB4vIB+38L/RfjXYn03tuwqmejW
jvU5rK9lfi/r+5GxHH4LtQf8503wB+IrSebTWVvKv+fgvxqaIdDuguYctHOQ
Nw7dRoJzif1eBs0z0JYljSv/eg3cL1hfAa+J7CfB/juxviDf5zWG9Z6sf55h
H+yI/o8zLwF/OfMCzmoh8hcG3tNAaMcjozPzhqw/IlvIJ5D9CnssBC5Cxghk
tcKGEXiF4bEV/GfALwGeFTZvzfOYdy0Ngr9y3g0Yv4P3nczfBp4Dv8PY6y74
5cDvIPetF/DokP1JNmyPPp2R2Q1Z3Rld5N/Qr4P+SsZU+G1C3nlkXWCsQt5V
YfvmJfDroP9keB6Hfx9GZrHPTGc3EJwycG8Ne6+6fyPAv4j8JZm2qWxbCv24
At/B+szfYl670Hv+Pbi7oHkI2jT/hsFrT8q+L52k20sRn+945p+D+2DYsGh2
M6/BHj/GFifYfxr4WmRMz7VMyS5nT9+D+w46T0f3usW+608wRmKPTvDL5Xyu
wh63YpuT2LQauo+D5lPdD/79AP/t+EAB8HXoc532xzwEr38U2zfXwO9Z+JWD
cwxe/Rh7wc1Ep2vA7c15ZAE34d9E8N/QHYQ2D5pRyB/Jek3W2zC/Ldc2/Jz1
fPjNgNdFdLiNeTbjXmgHsb9sxYdS+8YV8BjAXgalg6Ate+1NvBrGXlaGHG/X
wX940nvW3hWj6sEriT6vw3s+Nm8C/lTWQ/Bvz/q0mO+47noZOB+wPgGZR5hX
sL6S9fUl1n0288eYD4r67m5kPAy8GPqG2i/jG2Q1Q785il/o17zEMV2xIwP5
DdG/ecx345hiAPrmQl+GPkORmY/sDXHft3sVU4GHJb033Xnd/SUp81LMeZS9
F9cgplQnHiH/Q3iNQGafqrbRYHTJ4l//Avu4fH0foxH0M7HnXvQ5C/9Fmd7z
RNmbfzVYq88eliB/RNi+ojuxNuoYr9ixjTEFeArn829wuzKmIasq4x72MwB+
VeG3iBEU+s7q7h6pzCeb4LkC3hmsL8u0jpnKj9iwSpbvcAt4H2I/T3E2q7BB
/6RpRNuX9T3gPgHOwWzHTMXOGRH7entwfg3uu9B8B+00+F8B/878y8syz3L2
t4V/vyi0D8mXGmOzv7AWwYZNkd0i4VhcjM43AW9I+S7rzio257Dfwey3DP65
rH0HzSzob0f+Xchaz79EoW26KO4cqlzaHx0/jDgGy55J8BuDfzBmX9yAzAvw
Ppv2WTWGxzngpxizoX0M/SYoP7L/IeBvBP+izp9xBn1i0DwN/25R3y3Y4vjc
55R5KWYodowpdjwYzXwP+uXhT/n4007QJ8G7CTib81zfZMPvxhL7tmzUFF2G
h02reKVYd0PMuVlnrLPuG3ZuaozOy1jvm/T5ToG+H/Cb8NuS4RrkLeBi9GkJ
7f2MgfBaHvVeZNMVwM1KfDaywQ3Ifw8eJdg+wng/aRrRqsa5EfwfGPdkuUZ7
hPX5zP/G2qeMZcA1U/aNw6xXsL445lirmmAJcLOEz0o8nmUvO8E5Cu5qcD4A
3hT3XVUO3gh8NGpflM2aQjs/4rt0G/M7oV+BzpEi35FF7KUcGXUznMPmAS+o
1K8t+F3Av6B4mu0a4p+c3w8h1zKqGVQ7KOcp9x3l32/ZS52way3lt7ro8yij
UZ5rItVGbTjTVyrz433QL0i5tqrFec8HjoD/fa5rONVynRVzcvwvJn9G/2dY
uxl5f0q7plFtM5IRAvfP/PsD661YfwV4IvrdAu31/JsAnKeYx/ndjQ3zgb+O
2JeVcxYh7yX4NSjyni+ytgee53N835QrD0DTCN4NGd8Cf1bq2kD/DjKvg33G
glsP+qXQvsyeYvj7TuT1DDvmKvZOB/9K1npXxmfVQHcB5ydcm7yg+6Haln9V
82yPz9CtosS1cmt0Wsf++qUNd+NfGWunuDszcpxT26geY70C2jbIGwL8Jf+G
ZjsnbUXXYcXWVTWPap/P0Dkj1/FIvYTOUGcpHeqiz+S4c/1ReE4CPsl+OhbY
ZrLd1Khjs/KDatNO2PwY/niU0RF4R8K+/wDr7ydc06i2kY+0gX/biHsH7UF7
ORvy2fVExgVkbQZnX57vt3qDeYy9OY6pM4DLiq2bao5J8Aqw8dJM5yjlqu7s
8SfW67DfHsBzIoZVA6oWTNZwLlEMSgH/GHXsVT3VHV0aoG9G5XmpdpXPyfdU
I9WLuGdR76KaQrVFvmroDPcA6gVmgnO1cgc0teDXPeL+QT1GO3B7REy/lPVL
6DCIf4cyHLOUmxQjFCsUo27EnutCjpXqSdSbbE+7dimH59vAVVKuLWUD2WJb
2rlxtuId8IJS11I1mc+XbTiTl5HVBX4ngV8Hp1eB79RrwGeQ0YV5feanQ47J
is3KwcrF6kE1V06czHw3+Anw44xdwI+nHCuUc5V7LyCjB7LeQ+Z54IfTzmXz
WB8D/H3SvluMvJPw3qeatpprjOHqtSr7pX2MAN84AX67AteEP4P7EWNHNfd0
p9H1SNKxo4j1HxXLko4Vqsl+Yr4HHa7RXeWM74bfNv5thX4U9Eegz48596um
VG2pHlS9qHqEN4DPJqyr9nQO+Bz/uhe4xlGt8zD+81aOz3QMcHnIvYZy9B9T
7gnVG6pnXw3+f5DxToZ7xkPA42OuBS+HXzm+cUfMd0s670VerZRji3KEcsUj
add28sGxwGOjrh1VD6k3vljdsVcx9pakex7p01U9Evothiafu13IKGetDPoX
c0wzAPrzEdfCqrnfU69f6tykM98Dv1dD7s1Us6t235L2XVYM3wz8DjjLq7hG
Uq2kHli9sHqM0TH3qKp3deeu5jySKfeSX6g/kC9FfDZtkd8AuDhiX1aMuC9h
n5PvrcC+rdF/fdy9lWoO1R5/j7tXVU/9Sdw5SbnpFnCmxe1T8i3VODuhnx73
mu7jbHSriLq2qMt8jd4for67utO623rj0FvHPMZk9jMpZlg9qnrV51KOf+pp
VwGXJXy2eqPQW8W8uHOxYtYD8Nofc232MTwOxOyj8tUejJXgno67N1cPrV76
POOjXN8RvS1clXQvWoG+tZPuEf8f25hfLLGNZCv5fCrimle1r2oC1QaXZLNK
frp738asi2KWYpd6HPU6qolUG+mNSfZVDt0N3C7iWlE+3QJezYvd+0nHb2Lu
iZVvVLPXZm894o618oGewAsYHfQ2xb//Imtn5XuEctanujth76UbZ1KI/c6U
OlZ1Qp9TSb/p6G1HNZBqoefitp1q1lXA10Cfmef70CnqnKvcq3/XKReH3Wup
x5rFeS2P+66oxlwKPDfpXK8aYIbeLvQeUc3+EId2R9K1onz+XXT7FzQTKv1R
vbF6KuVOvZF0TrqGVy0v+6t27FRZD+kODo66x1CvoRpDtUZFwrW2zmgt8NXw
GJPvmqc+/DekHfs7oMOrwINLXDsopvZNu0ZUrdiOMR/dEiH7pmJWD3jdl3av
pxg7FHg8Mtew95uQvx94bcq1tR4nO8BrdcJvj8opaxLOecp9T4LzZMgyJEtn
2kt3rdixXzzFeyIyjhU6hp7RW2fauU05aBPwJnh2LHRPqd5yAPvZXuiYfwW+
NlfvlUWOYYpl58LONaI5Dv4XjJvV2+j+wOt41L6jGvpY1HdEd0U4X6b8Jqq3
t3mMCWG/8SheqAapHfKbiXoRnelvwq4RVStKJ+k2lP3VynYNrFq4Q6lrIf27
Xf6Qsi21Z+29S6l9XTXDr4CXcbj9c/1GsRT49cr3IvXsLZDfLe5eTvW23jb1
Jiff3A/O8+AeL3Xuk02WqBdIuNZUvLiEfrfG/DahNxK9lSimKrY2hOY8/E9U
7l8966PsryX7+yDTPt4KeELEZy+f0Vtd61KfdY5srn4iZF6qKS6p90+71tAb
xNNpn4HOQj67QW9FSb/tqIasCvxz0ndZNadqT70J6W1INX6zmN9M9HYiG/XR
+0rcZ6X4rrfrueiwKs8xQ7FjZdq9gHroZ9O2gWwhnOoJvxGqHteb2sywc55y
n/Y8MOKcqNyomvor5g1CtrVyqHL7Ztafz/AbzZYS5yzlLtXkSc7neIlzh85P
b50/JX031ZOdYv4/u4NSBg==
          "]]}]}, 
      {RGBColor[0.5922166666666666, 0.5118333333333334, 0.4709333333333333], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFWGtwlOUVfksgC5vL7n6Xzbe7tB2pNwbQYkUJUCtjG2YQQ0niWEG0Q4Qg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          "]], PolygonBox[CompressedData["
1:eJwtl3lsVVUQxg+08sorhbfc93pfW2PEXUGUTRZ3ERKVogUTZXGhrCIFFI2i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          "]]}]}, 
      {RGBColor[0.66525, 0.5375, 0.42800000000000005`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVmlsVFUYvdJJp5229M2b9968mWmi0AYNEAVjLMUNTZViAbE/MCI7KVCi
dMGgEJXaRqU2xpRFm4hQhaqJwSDaKntYJVEjVkBaodAI0RCiVBEkEuM5nvtj
8t2579uX891h82urlg4xxkRuMiYLdH7MmAX48c8HjjH7cHwUNOEZU4y7p1PG
ZMeN2YDzpSJjVgfGHMkxpgV0esSYzmxjPHy7kW/Mr7mQgfyZQPcfQs88X7ob
oCOK8wEYL8W5FrKNUWN+wOc3wdsPnbfgbjdkf8e5PzQmht9F6PRc6eb5a8gv
wv9MgTGfZYxJwvcB6O/D/WjwfwTZedDRA//7oLsNNqvSxuzF/Srce+D/HOdz
4F8Oe3OjirMD909EFP8x2PkqV76Oh6182OqArdHQlQf+GuhuRWzPg3ckaF0o
nQ3Q74bysSdhTLUn38ZARxbkjuDcg2/duK/E/3roizAH9n4S7Jfjf0GW/B0P
n37BfT38z4I/PwXK1WHw3AzePfh/GXx7QaeFysE52I2GylcCtN1XfKxnO3hf
wY8lKUwq/suQfRff7obOjaCncb8N/H+jRp948mcr6C7crcK5ELJbIXMeenZA
/zLWGefj+N6MXDTj/wX4EIH9yVH1yBuQXwK5chj+MSGZ2yD7fUI5CZCffyDb
jvNF9Nin4K+A3Crcbw/Vo3tAr8Cnb5gH+FgZKJ7JoKtxn4HsfejVhyCLa3MV
jm6B/AHIPoz7ikB5Ho67ta5qfRi8a+LKD/OU46h/51j77MPNRv7Rz2me+pqy
7PlYVHEz7xPB8y/OrbCzy/pM30tAR8TUbwtDne9xlW/2O2fj5bj0OSn1GmWm
4NMC1L0zD7pAN2WrP9gbrDnzvx48V2AvgZzEkZMSV/4MD9VXG2xvFfvqr1PI
97Ui1XIIeGf46qUnQefY/DBP7F32cD70TLD5/KtQfcx+PovvBz3lgbmc7cle
CfSMdTVjk0L5SP/p5zuOcnkvaE2ovp6LuLcEmv07HMV9u429IdR5AvTVIC9d
iN+FnW5Hcz0T9CrnGbFfA02m1GtrwH8/zjshW5bSfHJO13qqH+vou8ICztgS
2KkLFBfn9bCN6zTuQsg+ANl6T3jwXa5mpwWx/gZ/ttuZYN9yLs4mxXMdcVVn
C0eIIW9B6A/wvQ26OK2+Is4R/4irxMAFtlee5UyF6pefked1kBkE33pf808c
CBBXna+eYe+Mi8sO8TWeEpYNBX0sFD5OCYXZjJe5HWHnlrM4xfI8DnoyqTh7
QJtxtwK/KGwcTSiehY7wlPlnHcphYz94Nrvya19Mc8g+Y7+Ngs6ujOrO+q+M
q3+XQscyVzYugGeqrxoRUwtCYdSdiLXb1Z64XiSc3hPTrGa56mH28glP346D
znY1U+3QMRl5XoPeq0zLb/rfCl86PfXjTvCMLFCffGuENZz5bZ7kqWcW7ibC
t27ofwS0Nyo85BwSV3baeE+GylU39He40ns0o51AH9hDBzLaLdyxxFf6w5q9
ZO0S88bC1xfAPyat3UmsOZTR3mWfnEb+vgxVk+U4Hwvky1Lwv+cIIxp8fSNP
L3gHE8IY7mFiMzGKs5frq49jvnYp8Yp5edFRjwSOdgmxbZQvjPkiT7kaanvs
YEY52G9z+FRaNrgHOGfcxewD4j7xv9lTnVgvJ6nZ/b9v8K3K8nBXcD4qLNZx
BjgLtaF25nSLvbtDxcX4iCOMqQw6Xs3RbDLHTXHtoBtWljuJ8l12/3IPr0wr
rhVp7bE8i+nnIdOEuBpQnzZXcsQYzjGx6LmI7LyWIxzoT+p/GWxuDIXv3Ku1
FrtZn9mO8nTKE6awL6ba3qEtzonn660wE98bXdWXdWY+qIc56bFz+npGbwTm
nPHz/cGeawL1U+pN7saWjHCr2tF+JV714T5u3wl8L3DGOGtdsHkmlB3O6wDO
jbBR7wrPGy0mcA9zTrknuDfoM2vN/ccem4G4+2xsnI9USrVgTfjeZH5Yv0sJ
vWk2hcprca5yy/ipc26gNwrfKjvgwyy7a7hzhoF+HJW9hKs3aFtGdnrtnHZF
xZcfUV1ZX/Y033A8L/a0J4mHjGPA7nXy3BrqvMja6rZ6DkXlM99g3Ivcj3x3
XIur7/iGoh7iKmvM9yhnYT5orS8M4dtqUVx6my3mcfZZp1KL5yeg58GUcPV9
Vzo4V3yjDNo+ZF6eSWk++RYY5ysnpb7eMeR1oP/PQs3GXYFwlPzEUs4Me2de
XHuPc+3ZNwTzVewqfuahHrL/AdgfqN0=
          "]], PolygonBox[CompressedData["
1:eJwtlllsVVUUhncKoe2lhHtPzz09t/dBoQ0aISpqFKoIJAxiceLBoaaobZAh
0lJKFIgiAafqgwFBeSBQBKKJEnCgCAhERCRRo4IgVAZJNBpjHBHUEOP3978P
J/n3XsNea+21/n2GtLRPaysLIazh68/XkoZQnwmhalAIDVEInVm+ASGsLQ9h
aD6EN5MQvqsI4Te+PeCra0N4fGAIT7O+lvVq9FfjZzN7rcja+KbgeD0+2sEP
otMPX0f6hfAAeH8cwj7070HnQ/AM7Dmmz+dI9JegsxffB/meAzex9x+2y/F3
P7iOGL9incHnZcS+HB9zsK/C31Pgt9hrIZ8i+cxE9xh7jyKrw2ZlLoRXOOwP
bB9j7wiyiQVikj7yStYnE8e2mfNOgU9isxbZUmxOgFtqnatqsgV5L3trkD+J
/Dj4msS1WcPXCB5APD9WhnCxKoRq4snzHeznmsTEcqY6hLOsx5LDQmoxl68u
WOdLZOOJ6W0w7sI4cK/qib+Y7zx4BfovEusB/N2Lv47EtZHPeYl9yvdKYp5K
7M2cfyn5XY/OOmJrrLXsXQ7oRP8lzliI/iXorAKPpj67qM8V1LMb2ynYxKy/
pYmayPc4Op+h/wF7E9BtwcfrFc6hgrNHo/ML8XVxXiXxXUgcu3pAvVDPXn9k
h/FXBx4bW/8ZfPw5mB4pcm6mpA/O1tBT5b7TweCdkfF2bGZzfo696krHNJ3z
Z+FvIPqv4a+c9TLWQ1hv55vIecP5esusMwK8K3U/q4d2g2fhvzXjtXrre/Uc
uJz6nud+xuBvG3g/PkaRaw8xLkK+ER/bwQeK7qW7iXEFvlYU3Quqj+76RGpf
sukFr4ysO5V4CuTTwXppxv2mWVwX++4Uk2JTD6uXe/F3GHxd4topJsXWRk6D
wBOwaQdviY1P8C1gfbTGsX9MzY6BpybuXc3kNHSP1Fj2Bd+/5Dc08iyLI4YR
747YsfZH3kg+k5A3ZDzDmuXFyG/D15XszVf9qj3L0pHu3znHqjs/XeMZ06y1
k1MP8q2xa7lMNcB+T2m+Azbvg+dHlql+X6eeQc3ibs1Y5DtSfVXDs8iTgudH
854Hb826V3YwA4uZhUNF97r2JBMHigvVo83EMi5yLuLMVvzdgPyNcveUemtR
rX2pB/8i/0nIe0rymcQWxe5VcdDLyG7E37CSP3Hxoth8J5+j8p4xzZp0Hla9
s7b/HfmqvDlP3KczJrNenvos+ZiM75uyrt+v3McsYmsozbM4bxPyi6nvT5y9
NHJPqDe0p7vdm5j7+zie9enUvtRTp1LPlGZL/aC3452iuVf6ehvEIeKSj/DX
hO+HyOeHMsenXBeU3h/l2Am+L29dcdrP3N3tqfmrBp07wHelxprZO8Hn4Ihn
K9w/4o4q9j4pMwcPAnfgr1FcKz4Er0/tWxw4nXwn5Kz/E/eVUT/l/XbdgnwJ
8p2pZ0899B54W2yZaqrejCPbiuPF9dnUs611Djw8NbeJE0eAM3lzoThd3K4e
Ua/sIacNkXtYvSyO6WQ9P+deV7zd6I8puHd1hzcXbCNbceJR5N1Fv+WauSeo
/+Wp70ZvZj26V7F3usI10NvRnrr24v954H847/NKz7xmXzOv2Z+B/iHu49as
uVgz1EE/ZQuurTg6VzAH9HGBOJZ4uhK/5YpHXKAclIti2IQsyVomvphWa84R
9yiGM+Ly0vupO4rAGyO/Ncpfvfwq630Zx6O3cU5qX+qx2eLyvGdFb4T+BfTG
q36yGY99s97bSs+UZmtZ4lqo51LWjxT876A7mlvwGym53sCRnP180bVSzF1F
/xOp9z5l7xy1+6bGWPGr114oupbivAus/wdGiEyc
          "]]}]}, 
      {RGBColor[0.7382833333333333, 0.5631666666666666, 0.3850666666666667], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlW1olXUYxv+UbmfHxs55zsuec0aSc2YR6EaBsnmI0s0sKRCLKLIc29Ix
Z07yhVIyoqhvW21Cn6TMCGoNgxzaQtJetA8llPOlF1pZBEXRZKHM6HdxPR8e
7v/L/b/v6367ngWdW9f1XxdCGOO7nu+Zcgjj80JYnwmhtxTCrjkhHItC2FsV
wqJ0CH+htIu73ex/zIXwVTGEa6kQfkB+FIewGZ0J5FXuT9eEMIr+K9kQHqoO
4WQ+hDO86eNuCza+5L6ryjrn6q0/icyj9yHn4+g0Y/c97pcgX+fsHbC1gel8
vd9fQD6C/Qj7a/DbHRtnF/JIQwjza7GDrBDD39jZh53J2DYGOOsgxhPory4Z
+zA+lnL3B/JUjX3XgGeUfTs6Z+t9/i0yncS5Cv+LWV/jfCE2W8qOqxv8+UII
Q2ArcL4AnSvojIDncXAcIm9PIHdjv4TORuw8z/pR6rCMdxm+RtZ92DnCd5H1
Y8gK9kd4u4a3l7PO3+2s96eM51P2n2DnQWz+y/lefE+yHsBee8H25WcDtprA
kyWWzti1bYvsT35n68BMzIfIS4y8q+Q8KB/Kq+rRSq5ykX1Wqf58t6Lfi3wB
2V7tXDeh8x++bomNpYPvcLDtt/kKvF9JLFew+YCwg+E495+x/p4Y5vL2u6Lr
pzquiNxTOpfeRMo9oBimcu7XTfi6rdaYu8FQKtnXEG8vob8M/Zd4eyc+WIbL
xNvDuobNerA8XPD9IFg+SPm8mf2BvN8OoDNRdA7eRa7NOKZx7l8ruF6qm/pD
dblInv9Evlhtf3syxnmAftjIwXS13/wSO2/vY2d51m8qrFdzngP/Pcgd7GN0
diK3R86x+vot9hXOPwbPSuI9jv7dyJmc63UJnaOR51rz/TP7fehMxX6nteJZ
XnBPqjeH0p5x1aiVNz3cv4mNxbWun/Kv2VY9ruK3Le/5aWG9Bf3z6PQhXybO
mRvgA+SGovPZk8y6dIRpfsm+xCuaFc2Ucj6S8Wz+Qxz3k5MzkFZT7NntrDam
kDfGG7HxU+x4FffasvlKvHUz57PYbIzMQeKiQfA8FznO2dh9rH7OR+Yg4fsa
nVUl+zqHn8Ek/pOcd5eNTRg1c8q5+u1w3n3+LHiHGxzHQMazpLwtLHn+ZFOx
D2XdB2d5dyKZX82x5lzzPhdcF4q2/UbknlOttkWeE9XhJmxO17m/1Nc9sedC
HPlk7J5R7zSWnCvlTH2mfhvL27cwDFP/mcSXfG7nm0L/PmI9GDnf6oWDRc+C
ZuJUg+ftdINnTv8R6S1KeE/8tyTh82nwfJFyj4mP1BfiTN1tLpvnK0l9fq9x
Pb6pt87nOXOnciKeEmeIY7V+quhZ3Ybcip1R7PSX3VNaaz6VjyjtePqTmr4K
nl8TzvotmTP1jHTGiv4ndGFnRdLb6nHxgvhhKbI1MveIR8Vzilc9KoyzyXpn
NpnN2POsub5D/886c/e9RfO4+LwZXx2xcbbH5hRhf7pgztg/zzwoe5vSxqfe
Uo9VIdeVrVNkXciYH/do5mLnM4U8FvvtUeSc2Bg1W+Jv9Yns7ygkXI3/3sh+
lI+WyLlRX4ivVYMsuv8Dk1gmrg==
          "]], PolygonBox[CompressedData["
1:eJwtlluIVWUUxxc5Os6YeM6ZffbZZw5JjpplD85AMKZOUeal8qEkeylMxVFH
bNSR0vBWEYnSizNpEUE3U4ISMyhRRwST0l40qtEsrSmLIOniNKFo9PvzPw8b
1vrW+tblvy7fHrNo5dzOGyLiZb4avoeTiKvDIl4ZHnF9VMTfDRE74L+ojego
RIzLIk5z4UpdxHjo13MRryEfPTLik0rE+nzEDHRfqI/4BfnmNOLPIdgbETG3
MeIaZ93Iipw9j24b998bYRuy9RbffuLYy9lK9HvR70B/EsHth17MNx5+E/r9
xDYc/jdiWQF/Cn5WOeIY8iXoX0l9JlkPMRWLEQ3k9zH8APyrRduU7WXcOQSd
kOPxIcagHn5ial4+6uCbkF+D3gk+s5FNhf8DeQF7S5BvA4PBGyM+4OzLUsQF
/D+DrbeRN6O7lZznQf/AtwH/f1XxVY6Hub8qsa1e7BfB4hB31hHfIs46yW0t
8gz6fb7ZyFak9i9M2rm/IG/5bfAd8BvgZ8Kf4VuDv6eKxldnT0MfVQ41rkEH
eOeJeVydfQ4g68fGc9hqQ38ttt4pGFvFcx/xdBV8XzX/Gd2evGWqwUzknY2u
5XXyOYW9C+hMqbHNn6DPJNaXz/nk28r938FjC2e1xLePs73wt9NfJ8D2M/Ba
rH5E/yyxDkPeTD516M9PjYmwKfOtw/bNxHAU+W78jSnbpmxfwsZkfD2QutdV
Y9V6B/KFyM9pJqCbFf8Q+2yB/oc7L1bv35XYh3x9jo2XuN+es656YCvxXuXs
0VrHMC9nTIXtWeJ5kngu590ruvMV+bSkzl9nzakxE3aamWfVe8xkU7j/2ohn
Z8WzKAx2QM8G0wZ0+7k/Fbo9MTYfob8KW+dK7m3lNIDvBZztHm6bj6PbRc59
te4RzeKDjbalHp4DfWfR+KrH1GvdxLSn3viWyOcR7hwY4ZqpdqtT+1Z8S7F/
vGTfJ4n5DPTQzLlop9RAD+ZdH2EwLfEMCYsT6H9T8g7SLmrlewP5wqJ5zZBm
qa9k28pRu+zrku/KnnprRtmxqYd3YetAxbtLPaneTAveFdoZpxuMibDp5izB
V7Fg+gryhxLvGNlSzuvBpy9x/2i/9KK7MfUsa0Y1qxOL3gXC87x2U9m9oJ2k
3aQdIblqptppZ/VU/U3Pe2dqdwrzMnc/Jf4JI91fe3LuyUvV+RGWJyuenXZi
vFv1ydu2fCgW7TDhrx54Avr+zPtHNW8hloV597dqrtrfkdo+bFwe5ZqqttfB
eEJWxaS6b4Xl+Wr/qp/m5Fwz1e4iZ3uR/Zt6Hyq+QehWfDwW9jkZ+tfMb4l2
jHbVwcy7WvvoXWylOb8teg82QnflbV89od6YxNmW8Nmu1JgLe83IrMw9q94V
htuJ982KbaleU+A/TLwrNRObVJuCY1UP3cPdsdX7qkkTdF+De1lvxC3YH1sw
NprRJvh9iXel9vFmZKsL7j29fz8inyH8610DvQWaYdVCZzP1/jX6vVK/t0N/
W/Iu1ExptmRTthWzYtfOFy+fept7Cn57hPmxxG+QeO2obci3V9z72ocN6C7L
jIfe8Db4W+H/q3OOyjVfdL01Iznow+hcrvUMaBZuKhsb9cDosmdCs6F+T5Bf
zJy76rsG2bSCfWm/LM38Rg9U7XXnjaGwVAzj0D2SuheEYa/e6sS5KCfleq/2
f73z1du7PPPbKB/6NzmS+b4wXY7+d5wNrbMN2dJMabZ09n3qGVL9ZXM69KmK
c9FOP8j9/wHIQFQb
          "]]}]}, 
      {RGBColor[0.8113166666666668, 0.5888333333333333, 0.3421333333333333], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlU1sVVUUhY8FS9+r1fdu37297z2VVko0+FOdOJHWxMZSKpqoGCWoA1OC
UIIKaaspRhGDVh2QCI0DEydSMRrRkQa12NgGJFFaNBYaAlET8GcimGpUtH7L
dQcn59x99u/a6+zb8shj92yuCSHsYy1gzV0SwsFcCCXOx/MhzLJauXgDwQ0L
Q9gQhXAmDeFSZEPFEJYlIWyvC6GHvaUcwjvoN7O3oHcMnTXYba2EMFpLjEII
y/nej/x3bAdZdZy/T60n/WbsnuQ8z7mb8zdNIRwmn9/QvX+R/a8hjzZ8DtWT
E/tP2J8hh/2JbWQ7iI/NZef/MbIV6Jyg0FONxGOd5tyLbCSyv++wfQL9k+iP
Ra5J/oVDnLNcOCyL7Wd10TW9jfwB7B/Gfi82tdR4PfYF5J34nyP/CeyKyIYq
9vVn4nxH8T+C/3UVn3vZ6wm4Hn970U9yrlnfB/huawhhqhrCJuw/wP5p9skm
92uW/Wu+70D3AvWtIo9a5KeQfYrtU8hn8H0CvXHyP4ROxHkpOo3sU5n8Zura
Rcw+avucvCtl17cHHzvq3Avp3VXyfVdi7IThFvLfh94kta/E7hbqr+fcnZor
4sxW8DusWPg5V3Tu45nPf/F/jvWmMEfvCLIp8ryybJyvYP8ZXzs59xNnoOye
xORSQ85/42c6i6FY2/D/LfZbqKUZ2dLUOq3snUX7V5wPq475esG5j7Eux34H
OnfidzD2nXTa2buyuK9y/3LGy9ay7SZYX6F3UYNr7+B8oOS+qD+/Fv3GXqz6
viFvPj1esu7t5LY7MubCviZ1bWu5/6PR7+VHZB2pba9D92ij+7UAWXfZObwl
XhfN877UuO7OG5e1GV4Pkc/dJXN8hp5sqFjvM+Trsbka/eX4eTAxrp3spZK5
JE6p9+JAD7L3C657dcHvXG9jkhq/qFqu+2fy7p1wbM7mQy+2hdicK8buld6R
7jRrNHPOU9+7efsUzyZyfp/q33zqurajuyS1vXr+fJ35yuf/HJJuHfebWAeR
P0vujbFxE37/XGYchMetWS+PVK0rHFYFzw71SjNAb1Hz8WTwOxNP1LMX8q5T
fWpLnMN0kzEVtmeJvwe/83BghD0uuO/qv9683vohzttic3CYHm7Me17I59Em
+5Tvzqwvi7FbSe92MUO62XOp8dFs7sneaSGbSZob4sTisnMWx9ux2YntBTDY
GDneGD5Op67lI/LsyOb2HPr9Zdfex/5cZG6L42dz5pXm3UBkLH5JHWd2kfWm
E7/zY9kMU86qfyC2Tn/smaQ5Kd5cG/ktvVZ1PMUdZB+O/e70/t5LzBP9o2Yy
fn6C3fFsNmpGXpN3L1X7VWXzaQl7FDlfzemXisZc2P+Q1S4M9K9S7cLgxsTc
uikxh+TzXvBbmLr+i1P3VjxUb84Xzdcv8d+Z8Ur8Eu+EuWKvS42F5vpwlsNt
Zf8nhMMKzu2Ra3g09X9OfBhPzBVxZpT7VxL/+/T/vK/g/8dfyLqyOax5/B9c
LR06
          "]], PolygonBox[CompressedData["
1:eJwtlO1rlXUYx682mztnrc65z3bOfc6pdDkpsLLe9KLcCEe6lRmkUUL1ImbW
NKPVdgqLWEVPr4R09AfYKgqyetEo2Bgdy4TUSZAbUmFgT2/SiCKt9fnyvV/8
ONd9rqfv9b0eeh56/O7dLRHxNG8Z7+OuiAP8vpyP+DWNGKpGHEK+vDUij+5m
/uvg+6LOiDVJxMP8dwLdW+0RD5YjjtQjZtAfJcZXyE/hfwr5JP+NIa/sjhht
s08P/mN8Ly6PuJM3TaxuXi+6U9g/gf1oLWIbwKbweRJ5lhxnyfUfbx55czGi
Bd+fcuAH20f437HMMceJ3eh2bP33AvkuTm3bJMcQ/v/wynzvQN/E9zT6dnTP
k/9H5I1g6M4Z04aqMSpeG/9tKvBbcO2qaRT5LvSfY3sEUgfANpU49r34vAaW
GWKO5J2jgf7nLN8ZYvySOoZiLV0SsR/+PsN/MW/+Rsj/RtFY9N9uvq8H/4v4
vsS7oewalE/9eh3b78rGeh//HSu7h9LJpgO5r+B+i9NH4fdVcv5JblQxjO4W
BODEB/isQ25PXdsE9jnk6bq5UoxPkHurrlU9mwT7/sS5xdkKdK347Gwz/wm6
UiVidc7zskD8L7rsr57cQ/4inO1dbk7F7dGK8ajmY8iD2TwugGkj8rkSnCg3
NpP4D2fzKf0W+FhHzquxn8V/Aj4ulDwbl2JzHnm+4thz2B9Hvhb7zrxzaPb/
IMbhnG3EvXzkuw/9EvpFfGZz9l9Ankk8y5qhv8vGICyK2a9ZTM29YpxB3prp
hVm79WzROmHUbKdVc/se/j3Ik3XPyrz2Cf8vS84tjN+Q/4fU/XmFNw6WN+ve
3X74acDPA2Xvj/zvRx5kBvZ2RHwIpsf4vi21rerfgHwFOd/Nex81JG8Ts5n3
zt+K7kTZu3kguyVbC+6t6t9D7EN1+2om9iWeMc3aHnKuRb+m7NlqYn+u6JmV
rXJeqXmv2VY2sv22Yn9xfhL564p9NaPri65BtRTwvy5xzapHNQ4R66ai+ZrD
5zC+Z4uWFa/J90Ti3qpHuj1jiW+jOBW3vbzzOXOoW9TM+q8d+p3vC5dh3+GZ
30Xu31L3Qjv/F72aLvg+PkONXV3mUFzq5r6TuAbVovnfjH6ctyk8wztS3zDt
knL0UU+j6luhGzFe9U6Jf/VosOqd0G5MYb+95h6qH++jvwr9TmJ+3+L92IXc
QL/U6pzKvb7q+yGMA8iPYHNN3j6nS55x9Vo7ncDFisSzpZu2Ctvbs/6qZ//C
zXDNWHT/DqI7znys7TQn4mZV1dg085r9YuJ6xXcL8bbUjFX4KtivrHo3dEN0
S7Tj0gtjX+IdER71bDXyc9l8aCa68b+x7Fuq8dbtG8n4FKZPE2MUVt3wkcQ9
VW91owrcqoHUsyY+ttG7QuLeyaaEfi7zVw/6dZ8yvoVhO/L/zOkIFg==
          "]]}]}, 
      {RGBColor[0.88435, 0.6145, 0.2992], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlFmIlnUUxs+4zaLTfO/7Le/3zkeNkhc5OhZddCGj41K4kUJCIthNGkhW
4jrRAhXmghEKGpIIXojJVJR4ISqkZo5L6wzeROR0U4xakNOFk0bT7+mZi5dz
3vM/5znb8/9PeX7DM6+MiYjtfGP5VhYiLiCvlSJuViPebYoYRH6dRVxsjPgG
ebQhYj/fFPw+RzbUR9wg+J004if07nLES8S0E7seOZ7/qyTpSiJ+IL4XnD7k
b8iBRp892hqxZkLEWvKPEHME/X4xYjb6JHA6kb3INeCvG+da5P8xed8g9vTE
iGeJnZ66lln4H+b/ED4vkH+pcpOnhr4Y/1exd3PeV4lYAt455GcTjCP8H0vO
VcyMoTl0Yl9dcf/PIcucnVIMOLU84jg+M5HLiB3GPj9xr7fRP6GmXZwvBHP2
OPep+nfVIraltv1CzduIH8CvG9mBfYC4l8l1PHVdc7FPbvZ8VPeS3HNZOpq/
h69CTFtu/QBxc8g1RM0XwHmk2X7a8VzyPYDeVXVu1bA19Ww0c83xfgsYxC4k
tqXJZ6qpqeR5LSbPw8Teo8+21LyQrllfydz7E8zhT74e4r7CNq9qrPnIeYn3
L44syj1zzV68+LXRHJuRu6c67GOqtifkGsmcR7ttLpiL66mzo+K8s0rmnPCH
8X2s2ft6jT6TeveuXt5qsL/q+ytz7r3s5c2y824Ho4i+j5gCeadXzLuZreaN
9vA29rtFc+U2NQ5grwfnX+Stqvd+smT+qeanwZzE/4PgLMtdj+7LHf5XJL5T
azlvw/9D9IeQLxY8j3vsZDO5T8DVTcj3EuPswWdj7h7LxE4c3ZF29X7Nsf9j
UOshMCeXfU+05xmpd6MZ3El8/8WRaeDtxu8m/sfw6at5jv0181LzW9TquypO
/lM0f1XD68xlVeLeFpBnQ8n64+C1j/JV90acFrc/Av8Dvk+xT8U2XPGuvsBW
x/8B7JH7XLNVz3OqnpVmNtTiXU4jbgc5BrHv1Nyor4dZddH7dc5G8HmqYAzN
UH2Kdz83OZ92KH/dB81UebSrJyvmd13Vd1t3/NvM74juxUFmspX6boCzBXmZ
s/Pk6M1816Vrvhn+B8FfQV1DibkkTokf4kl/xVL9iltp5ro0D90BcVLcXJ67
B3HtTM3vwlnk36McFpc35+5rEzJN/eaOpf79qd+CS/h3trov9XeNmC/1Jmfu
T7rq+57/S+jfIX+v+i37A/kf9Nreqg==
          "]], PolygonBox[CompressedData["
1:eJwtlFmIlXUYxl8XnDMz2ZzznTnfOd8czBkUXBo1uugiRtPEckGDAi3UGxeQ
JhrSXGgBRY2JRAxmRBQhxGgYFe0qTIhUHMsFHQVvRAcvDM2CHIjMLPs9POfi
D+/7f/fnXdpWdb35/siIWMcbzdtcirhZF5GOitheiOjKIj5CcKshYgN0J+9j
+NvwG6FbeH3Qk8dG9CQRX2AzDtv7+PgcX628A9BXCXKjGFFqjvhuTMQQNpuw
XZ/Z92p0erB9GfkD5FtzEcNNEXMrEQVkQ/ichv9D+YivkLcS7/tqxLfwx+Hv
ofMZsda38NcYUVcfcSf1E32MGHuxfwK/jvxPovMJuv/V5KepfRm+BssRA/BH
iTcD2SX4s/BH4E9Br1U9xOvAx4f4m4tOD7ke5q2ATpB/SS4/U+8c6lmadyzl
qFxfLLmeh/ibhX03NaxG1g//B/o7CsZePdiCbrFsbNSDBPrrxLXKXyNYbYSf
iex1/n4Fq/ktxmoL8gXQx1PnupP67yO/VzGtGv6iH+3Y30Y/h/0sZM1l91c9
KpXdE8UfwGYhvXpUdm1DYPI3dPDX2+D4n6L7Lz4WjvbfCGRdqfN5Fn42svHE
e1xvzITdraJzbUI+B/lp/oZzzlm5y6d8dyP/reIZ0izJxwT4V8C0v9H1HIQ+
mxoP/b1L/dsS56OZeSr9inNRD7rAry/v3mtmNqDfgfyZBuek3Jaj04b8LvFG
IusuebY147vI7VzVsy8f8tVJ/BM5Y/o29JWi8dJMFLHtxMfUWvx3sN+aehb0
9x6yHxL3Wvh/kNmHfCmnmcint3gWNTMzoNtTz6p2Zhp0IXGu6s+f9GdExVgL
s6eapWb3WjmOJd9e9PsbvMPa5VNV75YwUy+fI+f9dbaR7eKCfWmn25CdzDvX
F7AZxHZz5t3WDOlWXEvdP/kbhB6Fz1/qjYmwebXi3mtGNCtPirVekd91+JcK
rk07eZX8J2beZeGvWzMp9e78iPw88rfAZF+jMRW2l/l7NMaYDaO/JLOtdv4N
6JWpd1c9Vq8fN5kWZh34WlPDSxi0gtWizLugG6Jb8hqvN+cYS9Cdl3fuqkG3
anrtPmqn26EfVDyrmtFN+NtTda8Uc3fVN1e66sl49KdktdmCnyo8q8ZaM6Lb
/HvFuyF/mv3Fzc5FOf3T5Jul2s8Q44J2t2xaOtIdKHqWdOMuIpuS+vYKU2G7
r+pd0Aw+T74LMt8e1d+XeMaUv3qaJL6Zmsdz8FeQPSzYl3r4k25r2b1STMX+
JrEv3Zj5+P4f8Eryrg==
          "]], 
         PolygonBox[{{5511, 2024, 4773, 5319, 5320}, {5210, 5209, 4640, 1946, 
          5407}, {5409, 1947, 4641, 5209, 5210}, {5496, 2011, 4738, 5306, 
          5307}, {5320, 5319, 4774, 2025, 5512}, {5703, 2197, 5702, 5194, 
          5195}, {5307, 5306, 5843, 2303, 5844}, {5195, 5194, 4624, 1937, 
          5394}}]}]}, 
      {RGBColor[0.9091666666666667, 0.6429166666666667, 0.3184166666666667], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlE1IlGEQx0ct19Vsd99293131wzpQyxN6GiZWUaQqNGhpGPRpaKF6hDR
FoSrEdIHRdqhixBRXbIupWSFYPZBUXQIwsOmp1SCCizN7DfNe1hmnv8z85//
PDPvVuxP7z6aLyJH+BXwOxAVqcWWx0T6ikS6S+z8yhV5FBQZxDYlDd+G/RMX
ccGbE9yR2xoQOUluM/5MocgO7s9wzoH3OCIf4xajsbNw5chdCt7oiXxCyNgy
keecJ4pFMnA2gUfwa8FmgqZJ4zZRO4uG2ZDIMJw/wKc9y/9/jz+C/wx/hDpf
iCkifxw7xHkAfyoiUu8ZZzv4zyXWI2nSFxZ5iN2ObYka9pK8ajT1o2c99ix5
T4hfzN2hpGlQLdfgXc1jHiPmtetrgOAEPbyl94O8xw3HeGoSVls1HMae4pwD
f8r9gyLrXfu5iY5b1GnAVsatdhV2MmK6u1IiK+DNg38ferd4lp8mZi5k+rWP
gZT1pf1dKbGYes6d5L7D9oNPw5mFpxBsFfkZYlbGbZ7qK5cTs7POeTNabxO/
AWyBfid4kzzq//bn+wsbcgwX8Az8IV22hM1E90E1vUfbGPZx2HZI8Y6IzUTn
pe9YGrZ91D3thLOX91kEzwXivxJ/F+x7yGZSR8xyf2/KqZsm7jPxH6jTHrB4
7fkbNYaIGXbN6ttqre6IxZ2Hey91Pe7+8g4b/d2rw87HDV/AroX/PvxV2Dx+
V/HnPdtlras7UQZXL5xljn1L2tsb12ams6vgvpS7OWZ6CZ274Bkl9w5YAX4P
fha/hnrn0FmNlaDtnu5HT8B49I1euNaL7ss6X1uvYzU0poX+RqPWYxdYm1+r
NWG6Vf9gynZI92SrZ996zu8lHbXdaQCvDNqdvmdjxHZDd+R00nD9n9BZKafO
XvVe9/38hPkdjt1rj7oPF1P2DpexU57F6u7E6GsNnFFsyrGek9Q67s9X57wz
YRr1W9T5aY/a6z3iJ/G7Y7brqndP2PLGi23/4q7fD/YfR3u46g==
          "]], 
         PolygonBox[CompressedData["
1:eJwtlE1IlWEQhce/Uiu89+q933e9ZUT/ixCCNpGYdSOwn4WLqG3RpkD72UUS
hCmUmwjSTZsggtrVJq3MCgoriqIgihZmq9SCClxI0XM4LgZm3pn3zHnPzPet
OtzT1V0ZEWWsGttdiJhbFNGIP98QMZpE3KuL+LM0Yjob0ZeLuFof8bs24gm1
vcWIb8RrqyIKTRFbsRrunie/iXwfd/YvjpjEevMRe5uMf4F4ltwP7CH456jf
QH2A1wDWFTAr8B/RbxI/oWae/K5MxN0w5vuCz5RbjxXg+rfR98Wxkvs7myMG
l0RcB/8QtSe53xo+K5M7CqfXYN3g7Bq5zcQ3iduIe+A6lDN39RshXk48jF+B
HSR+Rs/xSvN/jn+/ZO7iOIq/I424Q+4jNR2pOYjLHHxXgFWTtxbSpAMtLhFP
CxsbJH61oL96vEyskXqNcfaT/J6i3y/9O/EnEs9Od17gn+Dsc71n9Jh+A3lj
v6GmH3+iybF63iZ/IOOcMM+iT5JYW519onaK/rV1ft8D4n+p3zuM9XP/aWJu
4rsla5M/ytlY4p3R7gTxB/zV2qFav1+7MUL/L6TXkc8n1lhaD2El8Lel1lIa
tuE3553TTDXb2dT42oEZ/PaMZ6uzY7xnHIypemsibY5krJc4rIHLqaK1VP50
0TPX7PXmr+Rb8u4lTivx21Pvima8Hb+6aC3UX7vYknrW4tyFFt0F115m/zrh
M1DytyUO4iKNpfV38C/mfUd3s2CWU2su7YeIq+i1L2su2smSdinnnGai2dzK
GUsz1qw3LuyPvtFffN+tOWOLk7i9K/ntmsFb/JmsZ6d90r/g+ML+SoNlGX/z
0kvf6Bn4/Ac6f5wc
          "]], PolygonBox[CompressedData["
1:eJwtkDFOgkEUhAcSNCAI/EHh96exVJQDCIkWWmHA2NhbaqIn0I5Ko5R6BDu9
BcFDKAmdpRaKUfhe3haT2ezOezOz66eXxxdpSRWQATtrUn9JasP7q9IBqMdS
AprgJSc9RtJ2OG/BKYbTAXa+WpHGi9I1rJo0yUqzqtQpS4fgnZ1v4B/UePuD
F9D2mcnAu2j2wBM+Qzx6sett7j6RfvPSHXxWks7BK54jsIHuGX0j9nt7nxa9
T4s+s+B3UnK9zVk/65kKOYt4fpH1EwyCV4G7W3J9kO8GzjNXqHhGy/qNdszs
tOr9rGeC7gF93TjyXJvhH+0/lyOf+Qle5mk7bXc39t5H8BwtvDgK
          "]]}]}, 
      {RGBColor[0.9208333333333334, 0.6720833333333334, 0.35458333333333336`],
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlDtMVFEQhieAuywG2b0u9+5dwMRHFKIGLSzUxihaGIiKJqJ2aKMmCImN
ClY+EmNiYaGUxALRAkMliPIw0SBGCrWxItD5jAliFEG/39niZubM/PM4M/+5
q1vPNbcVmVk7XzHfxtjsWNJsMmt2o9LsFPoH9API/jKz4yVmZ9NmZxJmt6qI
id03DOZhgB3/BHpX3mxouVkL2NrQrI/kXzPkRp9C34O/gxxzKbM3nB8lHK/4
kPjHnLvIfbvUbB59DExVzuwH+DwymXRdueKc58khawK3qU47NfrJuY8eflV4
rt3Ya2O/ywbkJ3rqBT8Umb3H10j9ceR38J3g14R+1+mU93CenAPkbCLnH2Jm
sC8gX5X5rNT/z8jx80hLOmac2J5SP+u+5Vm/801mPAZuWJiCbMV+v9hnqtnO
0kOIr5PcC+j76WEaf1vou1HdCP8i59NgppGtWZ9RHfkbCvNq5q67Mj7PRKWf
ZV+Fv5u5nSC2mplsw/4RzHPV5DzD3S4hr4FpArOUc36IJ3+ptT50/HZsJ9Pe
/3W4MRf5zFYQ15H2feep25PwvSiXZqxY7UD3UC3d80vGZ9BIzsWVHlMS+1n2
tdS8l3b7Bc2QGl3EtYN5FnlO3aMIfC/6ZuzrQu9NPTYU+Ke+Dse+vyPIt/S9
tdzsHXKSbxP6a2Qzvgkwh2Lnh3hyhZpFsfegHjUPYbSDlqzvuRpMReD730vc
TOhvaBD/bMq5Jd/B2PkgXmgH2sVd4pahd5MzgaznG0DfgnxBT3X09hJZzT7m
yVWD3Jn3nHqj4opmORJ4PdW9E3gfqrkj73Gaw1SBT+JVPZjFyPtbipxPulNf
4O9Eu/rMbH9HziVxSnNS/8I1ZpznlvN/gd7Eg8B714z+86zSMcJqP3pTspcH
zhlxR/eTT31rBnoL4kxJ2t/SUfr6lvF/i/4x6uVJyvkRR/4PGQJbFfgutBNx
VzmuYrsYO0b/m8uVXkt8GY08zwjyKd8g+nDkvBC+s8Az8W00cE4Jo7n8A4ZC
xCc=
          "]], PolygonBox[CompressedData["
1:eJwllElsTXEUxg+v+rRNaa/23d73SsxDzEvEhkYiaaNKUsOusWFhSCwMZUNJ
hFiI0GVjQVlouqJqKEEMqQVi21RsDBEJFbPfl29xk3P+5/zP+b7vnP+d0bGn
bff4iGjlK+PrSyOu5CJuVUTcwy42RHzDzucjOuoi7qaOjZVHrMd/VYpYXh3R
yeUDWcTwlIhdxN6S84fcOYWIXuq952wudlAvqHWfs8lJxHTOLmPfJP82+e9T
x0bxf2NvJ/4iZwwl7jbiD+GP4H8nPhO/c6JrqFYDOV+J7aPfa7CMpc4VJmEr
rzd2cfxUGzGYuncHZw+JP0iNVZg/E98Mp6eV3IffOGKr6TGcc4+MXs/hvwj+
O4k3k/sYfwH+Nvw5+A3cOYJ9g5pZas3U/xyYf0yO+Fhr7Op5h/hp8PWVu981
9FlMjcv42/G78Scl5q8aP8lP+XbkrX9BvTL3Us8hct+Cd0PeeEaxpzV4ltJ0
KvF2znommpO43afGYIX10S4cBE8P9Zq5f4z8ssx+C/4J/H/c2Zo3/z/YG4k/
qfTZmVprJi4DVWAqRqyribhe5RqXsFv4+qvMsRd7S41zpUF/jTUU9uvUnI89
L7MtTl3Uf1ewNqqxn/qHiY9WWpPzxNcUrLU00+5oR6WVcjqx3xTMRZj2Fj1D
cRGHNuxyvu5K5yh3KvqNVVg/7ebf1LuundXu3k1cXzM4lBmDsGiHNmXWRNr0
4y/Fv5CYn/gfRevexP3FvzUzR3EVhgn4K+q8K9r5L+zPyqJ7a79XYc8qeHba
59nYS6k3kvPMm8C+oN62zpYQW1s0F72XJuz2Or9P7UQZ+ncl5i4MOfpfTTxP
cTpFrYEac9U/4CW7fzzxrmi+48lvTLxbqtlI/tmSsWoe1cSK9e6tnBL+ssza
aKaarXZAWuiNPSt5R6SV3tgj/IuJc6XpQu6eLJm73tSHWr9p+drpodT/BPXT
DBvR41fqf43wift/Kjq5KQ==
          "]]}]}, 
      {RGBColor[0.9325, 0.70125, 0.39075], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlM1LVWEQxkevmfcadLvaPfecY6WBplD2JUWLNkFBUYssUHQT/gHVokVm
BWG6c9GiVW3CVYtKROmDwjLKoIsGfRIVbTSQICIo+qTf8LyLl5kz78wzM8/M
e5r6jnUerTSzI5wMZyZnNst5hj5fNMtmzTbFZo9Ts2lsV/Nmr7FXYK/G/nW5
WRX2HfVmJxL5e1wrd9fBaUYOrTCLAF+H3sTdQI3Z7chsI9+rsY9w341exv9a
Qd9uP4jtFn5TFNiBbR9nDn1NyewneXG1veSdzCmX51gSS3pOt03kVPfLOsWW
iJ1Ff4L+HeytsXwuAfaoTrnuYn9PHxdqFDMP1rdlZsNw8CDU475zOfHltVbB
SyN5uqjnEJgt2C4S14/+EZ9h5BiY41nFx+C0opeQPzj95GqAm0ViJrFPYrtc
UG8dxA6iv1uK30qzhLs2fFLkWEF19MayxVnNLslqFt77vUicN4Lfjv8VcNrA
qS2ozy/cV0aKySBb8DuLfzOyj37aHQ/ezodevKfxSL18ot4zifJWYHsORx/w
v5MXF87Jb+y9YI2CuQqc44n2x/fIeXVefJaL+L1B/+d9RbJPI5+m6mk8r57K
gfNqgn4RP5Iq7m1Wc30V9nOhqLoWcprHn4DveeKS5ruzqON6F7In1Lk70e76
Ds2Av53vwVqzbYl8Xffe0pL8vb8N3J3Cvh65P9ZulFPN1ee7C3kzzMLfwblY
tT2kj6GwM5FzFjC9Ft8Fj/W+GsPbWYu8H/hxnrbE6tf77on1fm+A+TkSJzUF
YXhtzvPJMMcX1PY3Era/ic5Qs9fuXDvn3chMvd7U5lg77XUOoJ8OOI7nc3Bu
nZNRYiaQe/LaCZ/BYXwaSnpP/hb9P+K7eSCvN+x1TeH7H01zoQg=
          "]], 
         PolygonBox[CompressedData["
1:eJwtlDloVGEUha+JSWYmwUyGMS/vjXErYgR3g2KTQtRCUDAKhthNZ6MWNq4g
0XQW1tpIak0IiRtKNIIRDCpoIW5YaEQRRATFFb/jmeJnzv3ves793yypHuw7
UBcRWzhzOZNJRInf0XzEbfC+NOJRIWJhfcS8csQMZwr/OHfr8e1tjziXi1is
/GJEI3dzyE2IbwDf4O41vm7uUupd5xwjfpKm18DnS651mdNF/LLUubK7wZup
fyTnmX60Rryg/2PwQ/wD+O/imAWn1A/qna1E/GzxPPvpvbZWTzOtA/e0ufcY
9hjxizrghz0sDuCOmi1OKbhCzPK8e6r3ntS9uqi5G5wRsyqcXwGv4S6ft16r
wd/Iv19nDt/BNxP3lwa3pEXqWm/gcBy8NXMt1Wxg/k1l7+Ukd11o8b7Ns2s/
I+TPtpvbODE7if/L3bO8e/4BD6bWX/VPgzs7XF8cF4Avod9MwTO/pVZvm3Of
Y39KvHNxUUw/+UOpa2nmM+AZ9J4uWJ8H4KnEs4njncQ70C4GmyM2wm2Cu4na
fOrVQ42JgndUX/YOpa80z8AbMudqH73M97Ti/uL0BNxZex+q+ZF6H2r89QYa
4XYlsX7S+2pijuKaceq02/kRF5usd5X+Q9T82uL3VmX26Yrfot78vYrv5DvK
TCszv1n5xeECjlzJ2mkGzdJb+z5eYTfj25VaT2nWBx4p+S3L3oH9OXGs9rMd
PtuK3q12fChzjGL1TY6S21+09tLshPxFzyqOh7FXZJ5VGv3XCr4vm1xzmNil
7dZGGn1p9ZvS/qTBO/onZe9a39gpev9KvE/x+w2uT6yleuq/4R8VjpVY
          "]]}]}, 
      {RGBColor[0.9441666666666667, 0.7304166666666667, 0.4269166666666667], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtk09sTGEUxW+KqU4T6Xwz5ut7k0nZWLFA0YQ0sZA0EiISQlsLTSyaNqxY
zsS/7mrZDTaCiKBGaYmEhC5JbKy6pTooK0l39Tu53+Ll3Xfuufee++dtH7t0
8mKHmZ3g2cCzGs3WC2anK2aHq2bvAbsCPr4fgfdnZnM9Zi3szzWzLRW3R8Df
gr/B/greImZyo1mBfJvAp7vNjuRmdXI+IOdO7Nf4FrqI4X0cThF7Gf+V3Gs9
BusOrmEQfAc1zpHzNlgz97rSciZzW1oa2A04i3CKKVZ93Akeqxyf4A130hN1
2yXXcw/7buK04Vv0PB/BIt/34SzDHaPeeWpN0eNi2e2XcIfJe4GcS+QehPcP
/BX4UMXtQ+Q4m3ndW/ivJf4M9t6ES5d8sveBDfDdJrZG7PeSa5glZ560SeMv
nnHtAi1HS767v9Hnpd73M6dv2BPwnwaPV54fcMd7PHaaXvLUo3q9Qe2Votn1
zOei+azAf552egy8Df4OfHPwPWlfza2uQzn/4N/Wa7bGTvt6vU/1O5r5bUln
Hf4CvHk487yvZn4/EX9HdM3Svkc3h57dmccp5xdqPwnOOQV+U5rgTPH+EHw+
ugXdl2b4EH4huGZpr0evpZtVnOxm2r1u4DJzO5B7L5rTz3Qnul/tWL3Uot+3
ZtKA21f1WtrbrtxvQ/fyO/oN6C4OVl1DmfeL6Pz+kvegXp6hcS7xh9I/p95H
8bWi59TdlVOezuD7kIZZ7P+ynoyQ
          "]], PolygonBox[CompressedData["
1:eJwtkrsvBGEUxW+sYEe1G7tjZjx7Em8FrUapYlGQKIRQkWh2Q9jOP+DRIQqv
tZ4NCVqJhv/AYz0riY7fdaeY5Nw595x7z/d99aPTfVNFItLEV8z3kBQZAuQd
kRZPpDQuchERGS8ReXNF9qkn4cdKRVLwtZUiP1GRX/jemMgRPSPgTTQF6ja+
AvUpPWdwad/0Of5lwHN4ZKhfmLcIzgam30D/iPYpZlj/5dA/h7V6HlJn0RQc
81CvKPtdRmyfD/hV6mG4FPu2ws/4Vm/Dz4Jv4NNhngX4Zs+yKx+pEOnwzU/z
d4KHPOv9z4B2j28i9B+Aa/Atu+7bCL4O/c+p5+FrON+tcP9a8G1gZ6EeO/Qe
s/N3eH6vZI245q18EThwbb56+uBP13bTHR303UnT6511gds902vmdfj7wHZR
/RV1m2dZlV+jfkLjRO0N6FtYDsxf/UrgX2K2m87IM/vctbvVTPX0l4XvRfl3
uN3wfDRjP7OCpGXXO/TBboXto3e4BF+dsLu7g6+Jm6d6nzDjFL8eznS53PgU
3Jdr/Zq/nP5MwvLo/itx69FefaN1vNUq196KzqwGD3q2m97nAf1/DT5yyA==

          "]]}]}, 
      {RGBColor[0.9558333333333333, 0.7595833333333334, 0.4630833333333333], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkk1L1VEQxgcTvFcRvWL/4/lf9dIiAqHNhRaSIH2FFoLQm0bb2vQiLRJr
YVCEtCtwIYpEhXC50iZoUUGLCBRpEQVBUBbR2zfo9/DcxTBznjMzzzNzzqH5
SycvdkXECewA1igirlcixvFveyPeYQ0uVsAW+iJq5Mxm41tDEV/x+9gRclY5
PyM+xv3IsLFl4l7wT9WI3ymiG6sTN/Db+MfYCwScz+YZoG4Kkjdgf8l5Su3R
fvjqEc1+831GQ7PmuvXkGtWepkeL/B1yThG/HHLN+7p7aJ5dau9k91nEz2Xj
M6qlVws932o+C7+APwx+mfmHC5viR2BPsGvEI2AP4frSQ8+DEdOc74NPluhP
1im9ZwfNv5fNLQ33svVqJ9rXZvLs2kGbuA3+nXifnn3ElWQ+8W4l7085epdx
NDxAwxga5gaN/RlwbquzZ72h3lIz3M7m7e7M96Fq7oWKa/QfNjoca8lvKw3a
9S/OH4mrcJaFa+r4u9lz6P2PF+aaKjyzZj+Hv5n9Z15Tu1Rap/RqZ+rZ4LwI
/hytN/BjcE2Aj+J/1Pxvtomvctcm50ppXYpfhbVK863S86mPuH8mz9gD75ns
Gu31XzK33k3/VLH28B8rMW03
          "]], PolygonBox[CompressedData["
1:eJwtk01I1FEUxS9jNDNK5Py1efxnkMGFCEIbQUhs0651UCD0HW1zkyUtlGxR
lIi0CFq0qYiYRBhG2ggtSmgRA7VoEQVBkCZiHzuX/Q5nFg/Ovfe8e8+9973h
yzOnrhUiYoJzgHM6j/jQG3H0UMRqFlGvRsyVInqIHRuMOJjwlSM+wmkRn61F
tPsi+vDtwG33R3yCu4Fvgdh8zVh3dPdXBQ64yXmK/edwBK6YgzMGd5LzkHoN
fPvEBsh5HXuFMwUuJdd6R3yaWvfR+x38Ez0PwCeqvv8NTm9mTeK/Jv4E+xn3
3xRc/zm4U3ev0iztjW5/si9g36mZK423wevE18vOsTngHhSXbwfSX+z3BWv4
B07Uv1nyDGvgc2hs9FjTefBaclz5VsHHq+5V9U4y7+WK+R30T8N/mTwP1XiR
vBPt5pZmxt2FIxE/ip5PE/1nc+9qFNIjct3NjdXjPfDV7r5V40rumqqtHbXJ
v9Hv+Y5hDyX3LK0t7Bb2cu7ZK+cS+GLu2Snnpdw71W6leSRZg7jbxBeJN5P1
awavwL+Td6f+OtSa7+YfZ0dv2d9m5rvyKfa57pg0SuuZQb+dr+TYI9cQ83hc
tE+xrYq1q552oxqq9QXfLvxiZiy9ensTud+O5qNdlDPn1n711jRjzVp/4Aa9
rmXelfrXX/oPkrR6cQ==
          "]]}]}, 
      {RGBColor[0.9675, 0.7887500000000001, 0.49924999999999997`], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkLtOAkEYhU+kASGBtdnsShYN2GhC72vYUejKqi0+A2rinZdA1ACuidJa
Gmqw95JYIYlIRelHZoo/38mZ/5yZzGp0uFVbkBQwCabjSnFKasNvR3pEP6DP
PWm0KL0uSTvoAXobRswQ/Yw/y0onaWnTl0pkymSL8MxmT+G6b/xfdkPb80S2
ant24Rf3dtm5I3u8LL3QeUTukrMfdi5g1zVvi+Ef846ewFvXZO/hDdNBN+GH
Y3rmfVO7n+HePjOm85rOSk7K4yc5v/KM34A9dt7Q++i6b3tgy/Z/0h2gN9Ar
cM8z+wcwzBm/gL9m/2T+B//9mzt+
          "]], 
         PolygonBox[{{4909, 2864, 2770, 6498}, {6496, 2770, 2864, 6611}, {
          6611, 2864, 2347, 4191}, {6049, 3313, 2475, 6052}, {7044, 3313, 
          3005, 4575}, {6788, 3006, 2350, 5924}, {5920, 2347, 2864, 4909}, {
          4576, 2475, 3313, 7044}, {6786, 3005, 3006, 6788}, {4079, 2350, 
          3006, 4193}, {4193, 3006, 3005, 6785}, {6787, 3005, 3313, 6049}}], 
         PolygonBox[CompressedData["
1:eJwtkM0qBFAUx//JhBmFabhzJZKslAUbyjTzDBZjhXxteQQWCvl4CTFqxii8
AtbMXokiLPAEfrdzFr/Ouef8zz0fo6tb85ttkgYgA/04BbgIUqNLeumTdqK0
DSfwnZUe8tIdfOLvE2tHm4FYkIqwFy13gL1G94i/hP/Ovx8whnaSv8eD9Uo9
F8hXYQNa6G+pu4En/BXPJU1EW4QmtVf88cZ8Fd5lmB2UdnPSDPbS8w3sFJpp
OPb5j6LNmeYtEZ+DH3TP6P98l7TTCEwQG8au+1xr2B7qeqE7bzW/wfpXfL+0
ZyexIXId2Ht0X9Qe+h3TPWt+3/Ng/Us+Y5r1lFid3FmwPqnfYrQ7LmNf0TTJ
14PdIt3kH9uwPBE=
          "]]}]}, 
      {RGBColor[0.9791666666666667, 0.8179166666666667, 0.5354166666666667], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUj0vREEUvdj1dtmEfcx7GUJ8JRoqjUai8Qc0Es0mokUhUdtdjQK1j2IF
UWlQqTT4A6JFbKGwIoLoOCdnisnMnbn3nHPPncGFldnlZjObwWrBqkRmG1iH
CMrYPwpm1YzZvTf7QbzvzKLUbAl3r4nZeatZX95sGfFbpJhvj0WzGjA2erF6
hFHBnk+VP4S9gPgbNXvArCP/CPkemFXc/UaqYT1xnvDenpWGddxvQs8VuHy3
2YLX23iXNE+0q+a5qD4cMFuccI+9uKlhvtPsBOdX4Ewgd86rj4vYrNnJiySR
RnKR9xP5XzhPIb/k1W8nNKzmhFMLfOQdRu42cBqoryM3mwrjBvj94ZwN/Gs5
9U+eMWgrZ6SXHhBr10kHPaPv9PgcOAdOnnA+pbzO9MKcvHjw4ucde6uHeMdp
ztUw65E0+A38u1j8617zJw77ohf0pAm17x3quaNHflQCDr3nfS3Mkj29FOUX
805TaSLmH3wbzakvetFokzbq5CypeQD5k+C4Bs50Iq/p+aLXzOjdWSqt1Hwb
K4/5hVj/qBx83ImkgW/0idzk5V8gN3nJTx/Jzd7YS5zo39CrjNOf45y2cHcZ
q45/5x9nTHZy
          "]], PolygonBox[CompressedData["
1:eJwlkTsvw2EUxh9t0WqTXvTVlBANiUUMDD6C3WipNFY1SMy0FkN1dkuIiMlS
ncRgEfEZDC4xGFQaQWz8Ts5w0vP+z3PrOaXK2mI1IqlExaiJgnQSleo8Julr
w953U/yOSBd8e+uTTsG8ZqUn6jjq386YNYrSFf0WnLucdE91BqTRhJRg/pCR
yvSdfmk3SC3mq2BbcMpwc0PSelyaS0qzg9JfHi2wv9QR+FvwmzH32Cn6N5vV
qSj9StG1qmDaYMfxTPY6Z4x+H8w32Ck8ZtBPgbkh/xecT+aXOecap4JWO+N6
73AawTnG/eF9GDyjZbWM4t1NSxtx38c82Rfyrt1knma+jN50wvNf07+wv21m
NSrC/CC4tu3IdrWU8d1ZBstiN7Bb2M4fs+5hXrazD7zPC+5nN3zOuod52X/e
QzsWfFfmad7N4LewG9mteoJnMQ3L/g851FLt
          "]]}]}, 
      {RGBColor[0.9908333333333333, 0.8470833333333334, 0.5715833333333333], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUjtPm0EQHBtHivnw8+N4WKbIDwAFyxZtJEKo0lBSgaHGNBS0kRJoeFUI
HJqIREqRLiV/IC1SFEU0kZFNh6w06XBmNFecdm9vd3Zm9160O2s7WQCveMZ4
fheANwlwngFGdfsPs8Bd2bFuAPYZ+8e8vefAFe9D1o0mgW954O8E8IlAv1jT
Yl4rBTZpp4vAH+b9ZLzB+yLj7cRvE8+Az4yPxoFeFfg6bawP7N9n/DVzOqm5
LEZuso1Yu5w4R3H1R2IOY5GbOG4xNkMO0iqc04Ix7qvO/8I+S5N+H5aAm7L5
btB+57mlv07bqxg7R8xV5jOEDP0m+fWJgzngYzCvhdRH/iVjh3XP7T1tnhrf
5YAfVc9ReoUrjDPmNKMm7UO6thNrKBKrFNxX/bUL1et+FMxTfIfU85Zvx+w/
n7evfru8r9Af8P0m8ZtqHkvWrhlcBGvXDLLBvKT7adw70ky7cX/FmjWJv3gc
B/PVf5EO/YFmnHcj7g/BOhqpZy9c9RD2IDH+y7hv/UHNSNxPgv+Eeh3UPatm
zFddP/rStxz1XqWeXaXmfupbnXJdK85TO1PtNXP+A2w9afU=
          "]], 
         PolygonBox[CompressedData["
1:eJwtkrlOW2EQhQ+bBFxjwBebGGigBcQS8wQQujQp0wWoWQoKuigSgoqlQmwN
sZEoeAMegBqxKB2KY9JFiCYd8B3NLUaamTNz5sz8//DCypflZkljWCs2lUrT
ibTXhT8kbWL/8TfIjQ5IeWwBP9cmTVC7BX7ZETXb+N3gi+Dm/NctvfVJz/gV
cvdl6SM9eXpniB+I14h/0TtH3CCeSQPbJzc9FDM8y5ruwLvg/5aEhmOwpqLU
A/96u1QqkSM+aEI7+C31vdQvJTHTs4f7pXH0XpH7DrY5KL3kYocLsFb6z1qk
106pWg6OqWzfE7Bd7AeHmiX3pxxm3zN3wM6JlQSnua3J2szZDH5diP7P1DxT
e1QMbu+UQ0+hFFp9Q9+yijXwn7DaQGiyNt+0hd6VNG5nDXWwkWw/z+jA30lj
lnPe3W9Qye4h3y57L9/olNoT7EM+csa+ctwbRb+5f2bzvWOdXY6o78+Hfr9N
LnufR0oOi6HZ2t/oqZXjTf223qlC7+9CYOY09xP2KQn9vtVf4vkk/oj/iv+k
/6Zzk2ns7N3ds0r8Dqb5XA8=
          "]]}]}, 
      {RGBColor[1., 0.878, 0.615], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlMtLVVEUxpfl7QGee8ybyDnuibMi6B2RoX9Ec0EaltcHQaUlWRE1atxz
ZAk3peiPiCyqWRjWoJcaNrgaRI9R38+1oMFm77POWt9e37e+c3pOjpwY3mRm
o1qbtYZys9XMrFExmyrNprX3dJl97TCbbTVbL8zWtH5tNZtXrLfNzz9bzA7X
zHLlH0xmC9p3bTO7pfjD0vEeaJ/Su7268MNOs7eF5+xTXbfuPS6sMeUd0vNu
xXeUjs0dAxWvoXap0+yScNbU52Xt7yqef7vFe4dDm/Kmhf9IPX9Wn3PKmdVa
F8dGl5+vdau3wnujx0lhfVf9uPYx9TCo+Irev9Rzf9XsTfJ+0AS+f5T7O3Os
DfxWv4/cPq2zoR35N4X3Q1h9282OKvZedYuZ11wNLnDqVd0xrTOqWSicF3rs
18oUO6CcieT81trNmpnXchfc6Z/aeu53kIe+6FwVx49VrwGLPuhnpnQM4uhL
LRrSHzOG83Lh+GAz48XQuRG8eYZ7Pfkzfhmt+dy+qPZT1evz4LDBRe/Ha977
FcXO1xz/os5P8cQWs2+adbPis9jA6vB7mO1Kp/vlnHL3iMMEM1Xt/Zp7or10
T+Ef5oVe6HE6+eyZ20zh9eA8Vvxuzb2bla7lamiIlvXQBH/D44hylwrvDb+M
h38uJMfGG/iNHa9MhE/QHI2I/Y34s5j9i+R84c4smD9+wNtowzkPTdFjRPee
St7fsPYbyTGvJ+ePDveU8zzwuedV+Blfv06uP3NYjO8efZvhKebEGd/As8y9
v4GYCWf6RC90uxNew/98++z9cQaP5yz4UTsWmHz/nOeT88QLzXhHnDmSwyzB
4I4s9ECjPPocjH6eJK9ZVV/LnX4fnhoKrdAM/9bjXwF2Gfhg9obmzGou/ht4
AR83Kv+/ebSihlo0+QdRmMUh
          "]], PolygonBox[CompressedData["
1:eJwlkUsrxGEUxh/yd6mZwWjSf7yKHRtRbIgPYa9kixlSFoNyyWVlTbJyqTHF
J7B1yWWnUTYuzYxYuJTEht/bWZx6nvOc91yet3UkPZgql9RCVBAnTtosk3pj
0il4P5RygXSA+BSXlsll4L9RaQ2cIu7AOfRx8Cwxhf5Kbg484wxHGJLx/ZJS
f430wazjOqlE/2Hq75n3h15ISB3UNlVKRfCos7d+xhj4gthgvwHqL8GLxDTv
39GXwKvOdvshVsAx5rVVS3lqthos5zV/U7ZRqkdvR7+Fb6MvOOvld5gHr5Pb
QfuuIs+uh+Qm4X0R6QjchR4NbMYNeg+8NrCeeXgaPhTYjQX4c8Ju8z1K4HNn
XnvPzsDXzm7zN12Bi6HN9j0m6PURmtfew8/QPPPe+R060R/j9ldZ+B66mqWH
mO3Ujf6StN2/8PAN/3eTVutrfO0/PXNTYA==
          "]]}]}, 
      {RGBColor[1., 0.95, 0.75], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1Ur1KA2EQ3DMYDyQSkBSGbezERrBV0DpqirzBCdqYRDiEgD+g5xv4EBYW
+gS2/uBPZ6eFhUZE0eQJnGHW4mN39mZ3Z4ebXt9udUfMbB6vhNcBOEGSIM9H
zRqpWRu14ZRZc9xsgPheM1tB/Q2x7WbPFbMtxMlUnDP0PZVVz5BvjonPeYwb
kXfQ8wJO11VbjXoTcYh6D3lSFi4oEvlaKo036FmcMLuNvdw5h/oD8DLqj4jH
rjmF66YsOBfAs+Ccu+5j/otv18ALyK8QD/C+0bvv2sl8B5x74CVw7ly6qJHa
viq6mRw+7qPOQUX398JL7qGfvJu6qenQxTtyYdapk3s5i3Muq2Z9eHtal0+N
8IoekEdvZkqa/QrYr4n3gfhT1d7Pujh5aKAm4iJy6vzHjJyz67ptLzykLv4b
5ObRz7uzuJne05ckvOA31v8Am69R0g==
          "]], PolygonBox[CompressedData["
1:eJwlkM0ug2EUhIdofUnziSiR8m5s3YAFCWvUwh2QsGirNpKqn/i7FwsL4iLE
T7CzY4dKQ0KvwDM5i0nmnPOeOfPO1Pr2arNf0iQYAN0J6bcgTQ9JV0l6Bgvw
vqL0AD8Bf7nU4s0RfB98U+9Qt+HvI1I5k97obVHfgzn2xf4N/GtMWma+Aa7L
3BqWXoqhscd8l141i5076jb1ShYenqgvU3hbpNdido7fTkm64P7MuFRn/pqH
prVPqXt5aFjLHu31h95hCg1r2VMHbx9gCb45iM5oeLRX9z6Z1dhZK8SNhrOo
oF2KP/vvzshZzePxMYUne/ObXiUyc3b2dAZvpsjKmtb2Td92xscpMnN2s+jd
wg9SeHdGzuof/VFFJA==
          "]]}]}}, {{}, 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4285, 6822, 5943, 6642, 6641, 4836, 7277, 7278, 7274, 7276, 
          7275, 4336, 7290, 7291, 7289, 7293, 7292, 4984, 7368, 7369, 7365, 
          7367, 7366}], 
         LineBox[{4335, 6890, 7343, 7342, 4983, 5607, 5608, 5041, 5606, 5605, 
          5340, 7296, 7297, 7295, 7299, 7298, 4985, 7373, 7374, 7370, 7372, 
          7371}]},
        "70.`"],
       Annotation[#, 70., "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{5018, 6669, 5019, 6670, 4911, 6613, 4913, 7217, 4912, 7423, 
          6631, 4977, 6629, 4975, 6627, 4976, 6630, 4808, 6640, 5006, 5921, 
          6784}], LineBox[{5020, 6672, 5021, 6673, 4915, 6615, 4917, 7218, 
          4916, 7424, 6820, 6821, 6565, 4834, 6563, 4835, 6566, 7045, 6057, 
          7302, 7303, 7304, 7301, 6699}]},
        "66.5`"],
       Annotation[#, 66.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4080, 5175, 4078, 6671, 5650, 4914, 5376, 6614, 5375, 5533, 
          5379, 6564, 5380, 4578, 5378, 5654, 5377, 5191, 5391}], 
         LineBox[{4192, 4284, 5529, 6668, 5530, 4910, 5532, 6612, 5531, 4315, 
          5518, 6628, 5519, 4809, 5897, 5922, 4186, 4276, 5517}]},
        "63.`"],
       Annotation[#, 63., "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4579, 5657, 4580, 6061, 4403, 6053, 4576, 7044, 4575, 7043, 
          6786, 6788, 5924, 5923, 5653, 4577, 6055, 4413, 6130, 4620, 5696, 
          6712}], LineBox[{4806, 6528, 4807, 6541, 5145, 6537, 4805, 5893, 
          5918, 5920, 4909, 6498, 4787, 6487, 4788, 6500, 5136, 6495, 4786, 
          5864, 5895}]},
        "59.5`"],
       Annotation[#, 59.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4088, 6713, 5695, 6129, 6128, 4412, 6054, 6056, 5652, 5925, 
          6698, 4079, 4193, 6785, 6787, 6049, 6052, 6051, 4402, 6060, 6062, 
          5656, 6059, 6058}], 
         LineBox[{4185, 5896, 5863, 6494, 6493, 5135, 6499, 6501, 6486, 6497, 
          6496, 6611, 4191, 5919, 5892, 6536, 6535, 5144, 6540, 6542, 6527, 
          6539, 6538}]},
        "56.`"],
       Annotation[#, 56., "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4638, 5405, 5206, 6125, 4617, 5697, 4618, 6126, 5069, 6123, 
          4615, 5651, 5691, 5692, 5192, 6067, 4584, 6050, 4585, 6068, 5060, 
          6065, 4582, 5655, 5658, 5659, 5176, 5663, 5662}], 
         LineBox[{4762, 5503, 4266, 6774, 6773, 5865, 4765, 6453, 4494, 6489, 
          4782, 6485, 4780, 7117, 4275, 6783, 6782, 5894, 4785, 6492, 4502, 
          6530, 4804, 6526, 4802, 7125, 4283, 5917, 5916}]},
        "52.5`"],
       Annotation[#, 52.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4101, 6725, 5722, 6176, 6175, 4426, 6127, 4619, 5694, 6710, 
          6711, 4201, 7053, 4614, 6121, 4616, 6124, 4414, 6069, 4586, 5661, 
          6700, 6701, 4194, 7046, 4581, 6063, 4583, 6066, 4404, 6072, 6073, 
          5665, 6071, 6070}], 
         LineBox[{4174, 5862, 5846, 6450, 6449, 5123, 6452, 4764, 6438, 4763, 
          6451, 5324, 5891, 5890, 5860, 4781, 6488, 5134, 6491, 4784, 6477, 
          4783, 6490, 5339, 5915, 5914, 5888, 4803, 6529, 5143, 6533, 6534, 
          6521, 6532, 6531}]},
        "49.`"],
       Annotation[#, 49., "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4654, 5417, 5218, 6170, 6171, 5723, 6173, 6172, 5077, 6168, 
          6169, 5693, 5719, 4100, 5207, 6139, 6140, 6122, 6142, 6141, 5070, 
          6134, 6135, 5660, 5698, 4089, 5193, 6079, 6080, 6064, 6082, 6081, 
          5061, 6076, 6077, 5664, 5666, 4081, 5177, 5670, 5669}], 
         LineBox[{4739, 5497, 4259, 4166, 6768, 5847, 6406, 6405, 4485, 6439, 
          6440, 6437, 7111, 7110, 4265, 4173, 6772, 5861, 6448, 6447, 4493, 
          6481, 6482, 6476, 7116, 7115, 4274, 4184, 6781, 5889, 6484, 6483, 
          4501, 6523, 6524, 6520, 7124, 7123, 4282, 5913, 5912}]},
        "45.5`"],
       Annotation[#, 45.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4590, 5672, 4591, 6083, 4405, 6078, 4588, 6074, 4587, 7047, 
          4195, 5668, 5667, 5196, 4589, 5382, 4416, 6138, 4622, 6132, 4621, 
          7055, 4203, 6715, 6714, 5701, 4623, 6144, 4428, 5404, 4636, 5208, 
          4635, 5402, 4209, 6724, 6723, 5721, 4637, 6174, 4434, 6212, 4655, 
          5742, 6730}], 
         LineBox[{4800, 6512, 4801, 6525, 5142, 6522, 4799, 5883, 5910, 5911, 
          5338, 5514, 4778, 5321, 4779, 5516, 5133, 6480, 4777, 5856, 5885, 
          5887, 5323, 6443, 4760, 6428, 4761, 6445, 5122, 5502, 4759, 5305, 
          5858, 5859, 5308, 6403, 4741, 6398, 4742, 6404, 5117, 6402, 4740, 
          5826, 5845}]},
        "42.`"],
       Annotation[#, 42., "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4670, 5426, 5231, 6207, 6208, 5743, 6210, 6209, 5085, 6204, 
          6205, 5720, 5739, 4109, 5219, 5406, 5407, 5210, 5409, 4429, 5403, 
          4427, 6143, 6145, 5700, 6716, 4090, 4202, 7054, 7056, 6131, 6137, 
          6136, 4415, 5381, 4417, 5394, 5195, 5703, 4091, 5197, 6089, 6090, 
          6075, 6092, 6091, 5062, 6086, 6087, 5671, 5673, 4082, 5178, 5677, 
          5676}], LineBox[{4724, 5477, 4253, 4159, 6762, 5827, 6381, 6380, 
          4477, 6400, 6401, 6397, 7099, 7098, 4258, 4165, 5844, 5307, 5496, 
          4484, 5501, 5121, 6444, 6446, 6427, 6442, 6441, 5322, 4183, 5886, 
          5855, 6479, 6478, 5132, 5515, 4492, 5512, 5320, 5511, 5510, 4273, 
          4182, 6780, 5884, 6475, 6474, 4500, 6514, 6515, 6511, 7122, 7121, 
          4281, 5909, 5908}]},
        "38.5`"],
       Annotation[#, 38.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4119, 6739, 5760, 6252, 6251, 4441, 6211, 4653, 5741, 6728, 
          6729, 4215, 7064, 4651, 6202, 4652, 6206, 4435, 5220, 4640, 5209, 
          4641, 5408, 5078, 6179, 4639, 5699, 5724, 5725, 5211, 6146, 4625, 
          6133, 4626, 6147, 5071, 5395, 4624, 5194, 5702, 5198, 4418, 6093, 
          4594, 5675, 6702, 6703, 4196, 7048, 4592, 6084, 4593, 6088, 4406, 
          6096, 6097, 5679, 6095, 6094}], 
         LineBox[{4158, 5825, 5807, 6377, 6376, 5111, 6379, 4726, 6368, 4725, 
          6378, 5299, 5842, 5841, 5823, 4737, 6399, 5115, 5116, 5843, 5306, 
          4738, 5495, 4483, 6431, 4757, 6426, 4756, 7109, 4264, 6771, 6770, 
          5857, 4758, 6436, 4491, 5513, 4774, 5319, 4773, 5131, 5130, 6473, 
          4776, 6464, 4775, 6472, 5337, 5907, 5906, 5880, 4798, 6513, 5141, 
          6518, 6519, 6507, 6517, 6516}]},
        "35.`"],
       Annotation[#, 35., "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4597, 5182, 4598, 5180, 5179, 5681, 5680, 5678, 4595, 6100, 
          5063, 6105, 6106, 6085, 6104, 6103, 5201, 4093, 5706, 5674, 6153, 
          6152, 5072, 5397, 4419, 5199, 5393, 5392, 4204, 4092, 6717, 5705, 
          6149, 6148, 4430, 6180, 6181, 6177, 7062, 7061, 4210, 4102, 5726, 
          5222, 4436, 5418, 5086, 6215, 6216, 6203, 6214, 6213, 5232, 4117, 
          5757, 5740, 6245, 6244, 5090, 6248, 4669, 5761, 4668, 6247, 5238, 
          5239, 4680, 5240, 5772}], 
         LineBox[{4796, 5335, 4797, 5140, 4280, 7120, 4794, 6506, 4795, 6510, 
          4499, 6470, 6471, 5881, 6779, 4180, 4272, 7113, 7114, 6463, 6467, 
          6466, 4489, 5500, 4490, 5316, 5882, 4181, 5318, 6432, 6433, 6424, 
          6435, 6434, 5120, 6429, 6430, 5839, 5854, 4172, 5304, 5493, 5494, 
          5298, 4476, 5491, 4475, 6374, 6375, 5824, 6761, 4157, 4252, 7095, 
          7096, 6367, 6371, 6370, 4471, 6334, 4714, 5808, 6756, 6757, 4246, 
          5106, 4713, 5279, 5806}]},
        "31.5`"],
       Annotation[#, 31.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4084, 5183, 4083, 5684, 5181, 4408, 5383, 4407, 6101, 6102, 
          6098, 7050, 7049, 4197, 6705, 6704, 5683, 4596, 6107, 4420, 6154, 
          4628, 6150, 4627, 7057, 4205, 5073, 4630, 5200, 4629, 5396, 5212, 
          5728, 5727, 5704, 4642, 6182, 5079, 6184, 4644, 6178, 4643, 6183, 
          5223, 5745, 5744, 5221, 4656, 5087, 4216, 6732, 6731, 5747, 4657, 
          6217, 4442, 6246, 4667, 6242, 4666, 7072, 4221, 4118, 6738, 5759, 
          6250, 6249, 4448, 5433, 4449, 5241, 5432, 5431, 5250, 5445}], 
         LineBox[{4189, 4279, 5524, 5525, 5334, 4498, 5528, 5139, 6508, 6509, 
          5876, 5905, 4190, 5336, 6468, 4771, 6458, 4772, 6469, 5129, 6465, 
          4770, 5850, 5878, 5879, 5314, 5315, 4755, 5317, 5852, 5853, 4263, 
          7108, 4753, 6423, 4754, 6425, 4482, 6396, 4736, 5840, 6766, 6767, 
          4257, 5490, 4734, 5297, 4735, 5296, 5295, 6372, 4722, 6359, 4723, 
          6373, 5110, 6369, 4721, 5804, 5821, 5822, 5285, 6330, 6331, 6322, 
          6333, 6332, 5105, 5473, 4466, 5280, 5796, 4143, 4241, 5464}]},
        "28.`"],
       Annotation[#, 28., "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwNz7svg1EcBuCfqSVEb2iYXLZ2stlKpB3c6lskBFGJy6K0JoPBZyCN/8vM
YhAk4k9wnTzDk/ec3/eec/JNttrJSV9EbPA1HLFQiviUNTnPwEhEP3P5iJex
iB/5LL9lbyLiIBdxX4z4s380/5WvMnF2eTRiiVmGyhGDPOgWZJEMeXLs6mfd
1dLdo2pW4Ul/2vsz7OhsM2Xd1c1wZH9M1azCm37TuXVWWGOVM52y/pW7O5ya
tXnX78pz9qkVfJcX+rd6N1xSN//QTd2xNR6xSc+8YZ7qH/rvuvcbXDubsmh9
JxP5D0TYLSM=
          "]], LineBox[CompressedData["
1:eJwNzr0ug2EUB/DjBnjban1NXd2BBBdAYrAIoUMNamk1EYluNolJfCaiWGwl
In1pYmIx+0oQrsBgsfsNv5znOc//PectlmvT1a6ImGE+iUjZzkc89UY8c+C8
T9Z5eSCik434LUT09EUkvOi/cqb/p78+GNHg0pzHoYhT/RHfjTPGZiYirxb4
lK/LTsiecy//QLe3DAkb8iv210ntaTMpe6Ou6rXUC2rOVRryX/0R39yZXzF/
VP6Ittkpb94+eGdN/lbt0JIvyy+yJ38tu+T/r7xV1KY9xzTdF9wP1ZJ6ov7k
Imbtn2NXZodhM7aY0vsHzl83/g==
          "]], 
         LineBox[{4347, 7402, 4570, 4568, 4611, 7415, 4610}], 
         LineBox[{4358, 7404, 4572, 4569, 4790, 7417, 4789}]},
        "24.5`"],
       Annotation[#, 24.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4368, 5167, 4503, 5345, 6707, 6706, 4989, 7305, 4609, 7221, 
          4920, 7219, 4919, 7220, 4287, 7223, 4921, 7222, 4922, 7224, 4612, 
          7052, 4613, 6708, 6709, 5346, 4504, 5049, 5048}], 
         LineBox[{4401, 5174, 4551, 5372, 4971, 7266, 4972, 7267, 4970, 7269, 
          4974, 7268, 4973, 4310, 7260, 4965, 7259, 4966, 7261, 4964, 7341, 
          5033, 7340, 5032, 5367, 4542, 5057, 5056}], LineBox[CompressedData["

1:eJwVz7srhXEcx/GvTbk77iZlNqtjsSs6BsoipSxum8JCoijHOYOUMjBJKI5L
FmYdl434B2RxyYCB1xnefX7fz/N+vs/zaxkaT40VRcQwuqojOmsjliojWrFc
E7GCHl03XhIR2YaIfl5G9hXS89GqiA3zgHldHjZHHCBtRxu26yI2eZO8QXve
7DnhneIIORxjh5PkX/B3MWbfg/6L/ywnzHk5Lp/kHv+Gl8c5pvXf+h/+r5w1
f8oZ+VP4Bv+R94BrrOorGiP++DUybS6RCVTjit/rfz65H+jQJVGsX3CPRfe5
dJ53nsM+N4Wppoh3/pZ97fw13j2vvD7iVX+mH9FX6TLey+LO+RZp55wdZdxS
/AOaeUND
          "]], LineBox[CompressedData["
1:eJwV0EsrxHEUh/Fjp1zGfVxWFkMWLNwWo1gwo8TIzFgpyWUlpFBSNrKxwJgk
S94N70HJJd6BhevH4un7O+c859T/37m8ld+siIg1LDVELDRHXDZFzMlTeYai
dwHr9RGl1ohZXrklYrE94r0x4g3n+jn9E/0SUnURx3bT9kZw4L1if9h7We7y
93DELbrTxj/ETUfELTbMxtzblgv8vBxU7/Jn+Dns86+5/fpT5gNyWs7z+2S3
epWf5U5ih3/FT+n3mHfJ3v/v4TfJpDrHH+X+JCI2+Rf8MqrME6hFhl/pO7Ky
4Ltm7fzyi97PyYgXPODb/FXe+T/3+FQ/qr/kk0zLandqMGF3HB/uZOSwm0P4
A/N4NPI=
          "]]},
        "21.`"],
       Annotation[#, 21., "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwl1muQD1QYx/HDYtlFhGUXL0jl2uWFay8KM5WkJpNCmqix0rhMwlJL1qw1
yWWZzf2yNMaly6iw0SBC5DY1RXLdiSLWhl17wepzphdfv/M85/c85znnv///
aPXm2P5jqoUQEqr75/4QCpuGcK9hCH/RjakhbEBoEEL/lBAGNA7hWXvJTUJ4
hqY0C6EpmqCZ2rzmIYzlfSothCfxkppU+WHqhiJdPBz90Fb+UXUnG4XwOG0v
bk/b0cfoO/wZfBPxVjxb7mUU8g+ig9EXnfkH0nH8M/iyMR495TPkL/BPpr3F
Y2gvOolm8k/Bc+JscR+60fzZ5n/d7EMwR5+Z9nLwtvv2du+RNCfWWffBAe9z
EMt5l2EBBun1j3Nn67VSvAIL1YxRu0tNkb3Veq5BPt7gP6rHMfT17s+jH1L4
apqjFqqjBhLwvR639L5hfR0jW5gP560nusPPzmnY0udmXQ0J4um0Bk2g1TEN
H+JF57yA+chFoh439S/TvySusUXvzWjrDrvpHtRQWzOiZyn/IrOulF9MK/jK
8YsereNnL/enPhdwESf5P+EdqH4QdsjtxHvO76Dfu7Q9HUf30Dxa3306Wjfh
70THy+1VM5guwWIUe78Wci3R0bkd0MDbz3F+G+s/zHOXVuFzuVK+WyhDhZnK
7VdYl6PAfFvRifcHuhe1nJ0YcX45f22+pc5dhteQjyn2p6LS3u3YV8+pak/L
nUEmjqu/ZO8yJtibiNrydVDb3j69V8nlow5PMpLincz8MN1M8931LP85PCj3
ENbIrUZB/HuSP4YR4nTM03eLvrk005wfYJM+rWJv62QccdejWKn+qnfrLNcF
GTyf4gt3ydIjyWfRHGnYyZ9Kc/TNtpco7uK8rijS4xqKsUu+ntwcvRPpXFrl
/LV67jbnx+Ik+dm0Lp0W39h3433xYfWjnD8a+fzb+CfL37BfhluYzP8r/Q3b
+dN5R8TPh38z/6jYx97o+DZ0Av8mmi7+jH8o7zDk8Reba7j8avn12BC/2+Zf
xj9EfildgeW4wvuqe4/Sbz7PUt52eszCPP3mxndz/gB1X9JX6Cy+j9BLXT9x
VvxtVL9WPJxm6TsdM/XK9RYn1P2O2/4eKnFMzXFxgb3imBffsb6LCtxGJXbo
V2qOf81QHN9DbTpSnXGfujTaICpScVZcxX+F51T8vfPZ90IOZqBMz+t6lvBc
068I3/B+jRT+7fQ7VMnfw12+Sv479BF3LMJV7BE3pz293WG+IziKQ7yF9n6K
a7Qx0wPYaN3D+df0buyc+nJZ4unxuyfu4Z26Y5i4obiIr7v1BnWteFtjv/U+
nNZ/v3MOWh/Aj+hijjTz7LR3jp5HrtxifebRJbRYzU37V/mv4Cu5TajvvG/p
NtyJd0ZlfJ/4G+29pphjKrphFU7wX+a9wXPG+nr8TpmvHpLFdWkSzeCZhKSY
j78Nclv1XCi3CDf1LkUJLvr819N1OM9biPXmOMW3jnbzNl1xyfl/47A7Fej1
hJ5Px9/D+KbiEWY51Oj//wf8BwSxQwg=
          "]]},
        "17.5`"],
       Annotation[#, 17.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwl1XtM11UYx/FjqasNMS9xV6ysiXmhBKtVdt1q3gknmijaLMArW66ZbcLa
nHLJS1pqmSTUStAKkPKShfZHQllCWxYGgTkz1EpntWq1Xt/1x5vPOc/5PM9z
zvmd348bnlj+2LJeIYRaf/oNCCEvPoQYOp+WoBi9rgvhgaQQHsTexBBOJ4fQ
MzCEd4x/pHvoT7SWnqPlKSFUoAyrB4WQcH0IidhpvEusGlX4NIqhSf179Lkb
Z+XHi8WhSHxGXAjZuCshhCRr+/RoRAN+MS+wlo/pGMdzO9r1uYPeiQyMRyaW
DA6hv5rP8i42znHOm/WZSWdaz0E2XnW+V7CKNxbTnHulnFxrc5DLP07eXPq0
OpnGGVhtnMq/gXc9SnnX4az9lNMKrMEk+y6jfcWbnOMojiBLvFWd6fRRWqrW
LdiiVj/eie7ngL0cF6u1vjfyuscsTMNsnpNiX+N7vk7MlZNA45FjfSrfLHpK
v1jj45Gat9DP8Rk68IK89WjQux51uNF5U9zLEGxVbxu22st4TBKbjImYiikY
zn/ZXm6iGe7mMi5ht76JcpMwwzgbufbQqe8IsTbz7ea/R7n87XSBeZq1RjrP
vi7ouUp8rbv6UK+PcBhH9Krg6T3EndMSnpO8XWoON8+Wu0+sS953NF/sH/ov
eutVy9th/Jfx39FnizFq/iE2lubrUYCFeApPYo6cRXQxCrEUS5DOP8C9HdXj
E/RRaw/vPHvpjr5HaEW6+Ujrbcbd9tWpV0F0Brl95Zw3v4D+5rFIExuJmqim
c9bSQuSpswDz8Y0+DXK+pbOdeRZu5emRnyV2WP5z0RvT7xQtozv1r0QGb5W7
3oWB6q+z9rHzNOFa69eg2Nl+9YYv4Vj0feJ9SN1KFKq3CDV6rORbavyn3ld4
f0Mzfwsejt4xzwmxVnyJr9CGK/wL5a2QX83zFn8m/2bU2Uc93uarwW4U8b1E
X0YVb7oz3Ia86I3a73a0u5dt9HHn2cJXyfc6Nqo/Wa8p6KPvI/Ia5bXoVSPW
TM9Fv3EYJp6KYr7B9E06iL5BN6lfQjfSzXgRo9UahVY9N8k/QQ/Rq/n204M4
gKF6PI9ytcoQ496To/fjnCl0nRqlWIvXsAMrrI3GGIyK3hvGIiH6bOz7oB6H
cN75ehCj/jNIkzsCX9jLBr2P02r+CWL385+x7y6+luh3hP5gXim+Q90JtNu8
Q7zZeic9bX6f+L3y94tdVK9e3Z/pu7QO7+GqqJZ9nMEH/O/jYvSu1U2172EY
iiIsxzHxAjnLjNdEv2E0Lvn//1P/Aa23/U4=
          "]]},
        "14.`"],
       Annotation[#, 14., "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwl1F1MlmUcx/GrbEPUFvIgoOaBETyQUpoHLYW22DpwtaFNNF8ABStDhSM6
QNO2nKbLuSmwQYmlbuVA3WzzpQRqvCkepAYVykZLxWnw0HJr9rLV514HX7/3
fV2///96uR+cW1HzevUjIYRa/9yZHcJYagi3+Fe+zUtiISx+MoQXsXtWCEun
h5BpPJX/nhHCP1iYFsIC3EFySggXjH2F+7iH3/T6mvv5CLfp04q7+oxiv965
xn9Re9X4dyiyboHxZdapzQjhTbyFCmxEJc7ODGG6mq3WrUZcjxy8oaYsM4Ry
lOKwNT7BNtkULNO/Lj2EDebWo0x+G29HHY7LHsNO2Vkokd8tv8Pce9goX2Cd
Qrxv3Z14yXOf/cTlG2UbsMke38a7qFLzSnQe5xrS70Z0ftnr6kb5R+8/YbJM
Es56bjOXPsece+vVO0ltF/egG8OYiO5efYe5YM1/1cy11mz7r+F6fRrQiIVy
GXrHZNM5jTP5pv435Ye5Sa4ZH+OF6K6Mn9enmC/wcs7mLc5Uja04gLroftHi
OcWeL8qs8t7O3+B363TygJ4D/If3Qd6BT621RnYtSrEODfocxCGkeY8hV3Y9
d0ffl7u4nIv1nKdfjvM8w3Gez9n8HOdxfvQb42ejbyBfoa5H/Qbu5UrO42nu
8HF0yi6VO47Vakbc9c/Ii/ogy/xV7yPu7Iw7r/A+Rd1UfBnNyZzhazyuRysn
+K6zjqLS3BpjK51vglfxCpSgR49FPGT8ZTUt2GSNZPeaic998xn8BW8xvhkP
9Uv4bU6gV30fitSdkLlk7DL6cAX9eCDfE2VxTvY8FssflW8zdhKtOI1TSMiX
WacczTJNyJc/gIPOcwjv2PNmTLW3Kh53P2N4yly9s+zSI8vz04irv6823XNC
pgGNqMcP7vSEdQa50/tj6i5yB9qRpW4P9qv9CM/rNdmaiyI7RxLm+Jb77KGN
C33bVn5C5ob6Yv3Gjf2p/xj/xQl+yEPmXzNfZL+vckxNqjWORb8tmc/0yeOj
PI8zeLv1PrDWQPQ3ZV+7ojvgveo+xB4sj37nOIJvzV3mB/L93IK4Xoc5l6eY
r9JzEq/kEsTM5Zhr5mxu4iXqC+1rAN/jUbkCvuTurqT+///5fxNN3Ec=
          "]]},
        "10.5`"],
       Annotation[#, 10.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwl1Edsz2Ecx/GnROJAVKnZ0hrtQRAjuKClqma0KBckCBEJLmImhEjsmdir
tP/aJbGChA7iUEKE1IrYxcl2ELyeOLz7eb7z+f6eftvM6fOL5iWFEAb58aF9
CF9SQqinn+nAtBCGtghhYXIIdW1DyG4dQhbmtAohtXkIveX1QS8cZR+iA9Qd
pP1pz9QQ+tFyfUr0KaUJlOGuWCly9cvBYHyT24OvO5a7MwWF7UJY5r5h4nm4
xXeOb2WbENLS+dWscM6jZe5dKT5JvBgJ9nEcQzny1Z/nvy1ns5ot2IRTYiex
hj8DW93X2LwF8i/Jvxx7makcw81egHyMlzOCFtIHYvVq37OL2BXeI0fPIchF
BjuFdqRNzb1Vz23YpKYbktU1U9eMJtPmtM43ndH3MX2s9gl9EucUbyueSq/o
cRXXUCH3LJ7L288+gIMYoP/Xlt4X69Q0dP9aOkvuA7EXerVjZ4pPofXsT/yz
xRfp9Yu9mP4Q/47hYp340mINTafVcqtQ6b4buI4O/J3F19MuNINW8VejRm5H
djZ/J9qVZtKs+L767/T2u7Ag7pw3m0+z6RK6FL3RXp8T8svVvXR+hTp9p7In
80+jE+kkFOOhvpXiRWoLMS72kFPj950jlvBtlfahCjdQg2rst/sHcN15rnc4
L/8CLqJETYJ/Rtw/OjPuO90nfy+OOpeiTG4Cfd2zW81EcxSjSdwhc/yR+xdJ
viGgVt4oM4/GyDi/vDF0gv6j1K1iN/B7XE17qu+BxViEDt5pl7t2Yw828m3A
UPV5CEhS99cuNaBJ0Ud/0x003XyN1I11vueuR+Z5iJ/u/qSmwvls3F/xX2be
TvfGOWkOHUFz6RF6jNbr9yHujvpn7Brfdk3fm/Q5+wd/mniB/Hfst/x3xN/Q
t+zD/O/F36E2/g2yn+Fp3GVz5tMj/CU4Y67T+GjOr/red36tz2B9hskbFN+A
HpZbm/L/f94/50u9aA==
          "]]},
        "7.`"],
       Annotation[#, 7., "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwl1ElsTlEUwPFbQ6VForRKR5UQwcJMEZWYFzY1xFARtVedzJsmolaV1BzE
xlASYw2JObGwKG31qyFBjRsk0tKa2/q9WPz7v+fec8899733NaewKH9DXAgh
wZ/apBAa0ZERQgMfTA7hGreJr/MlzEkP4SLP5bEDQqjC/kEhHJFzDEeRJE7m
FAyMEA/iOrnZalaIEwaHMMJ4JE6JU9JC+DQ0hM/Yi+aBIVRzjGtSQmji3mrE
owd6oSeGq7kL59S4JT7P7+S/RdBnHs9Gmfk4Z97i21jpvBXItLcCfTLVxpjU
EFJ5NCfzWjVmuutZnsFn+L78EuM642J+yKV8gifxFExGhrxt0d05prdcdxiv
l3HoNvea36BUTpH1Et7IXzyTdOtf1fiGNnSgHX/VuGNPrd4vo1Pcan6PfVXR
e7PWbD6GJixWs1y9MvyV1y3/D3ehM7L4F//Gd/zED7ySn6OHacYn3Wsqn+J6
tDvnET+Inju3Rs+da5Ar7zRP5zzMQotao+Q+kbfEeflI1FenOIErre/GMuMX
en6JV2h2l4/2FXgXT4yXWo/3DrPk7jPusr8v9+P+Ua0oRiLy0Spvgv1Pjdc5
c40aBYjT33v+gE32F1sv5xIuQ2kU63sBFmI+rtizlG9yPt/gJVyv/hZuEm/m
GG/lUj7uDsuMD8lZzhec0aD2dt7JO/gu30OW3Dt8O/q+7S3U23pUynkefTtq
HEaqODPKRxoykI4W97skf4j1bPFQHsaN9rSbf8wt4gPRvOfSIF4V/SZ846u5
0P5d/EzORGvVuKqPRfq+zPPS//9/+AeU1Z9s
          "]]},
        "3.5`"],
       Annotation[#, 3.5, "Tooltip"]& ], {}, {}}}], {{{}, {}, 
     TagBox[
      {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
       LineBox[CompressedData["
1:eJw12Hk01U38B3Bc936R3Ju0eEiocJFUIhXzVahHjyWVpYUspYcUsj7WZJeS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        "]]},
      Annotation[#, "Charting`Private`Tag$16401#1"]& ]}, {}, {}}},
  AspectRatio->1,
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic, "GridLinesInFront" -> True},
  PlotRange->{{-5, 5}, {-5, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.687178790195877*^9, {3.687178937556449*^9, 3.687178953752338*^9}, 
   3.6871791155882072`*^9, {3.687188977334732*^9, 3.6871889859679117`*^9}, 
   3.735403907378541*^9, 3.735403957892668*^9, 3.735473069672241*^9, 
   3.7354740879108458`*^9, {3.735474954760056*^9, 
   3.735474960204767*^9}},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],ExpressionUUID->"7b0310c4-51ed-4361-b915-fce95b5d23c9"]
}, Open  ]],

Cell["\[LineSeparator]\[LineSeparator]Now, we calculate the gradient of f and \
the gradient of g", "Text",
 CellChangeTimes->{{3.735474276271946*^9, 3.7354742870151*^9}, {
  3.7354749730238132`*^9, 
  3.735474973191791*^9}},ExpressionUUID->"cc77cd86-75ea-4c6b-9fb5-\
d582e3f132a0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mygradf", " ", "=", " ", 
  RowBox[{"Grad", "[", 
   RowBox[{"myf", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.735474990047689*^9, 
  3.735475008359223*^9}},ExpressionUUID->"bf1bba69-ca98-41e8-b757-\
c264f230b33b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", "y"}], ",", 
   RowBox[{"x", "+", 
    RowBox[{"2", " ", "y"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.735475008992988*^9},ExpressionUUID->"36d6f25d-9061-4fa2-899a-\
ce1a36450575"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mygradg", "=", " ", 
  RowBox[{"Grad", "[", 
   RowBox[{"myg", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.735475018658*^9, 
  3.735475034607336*^9}},ExpressionUUID->"99e3451c-9d58-44d8-b69d-\
de88ac9376e5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", "x"}], ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{
  3.735475035351324*^9},ExpressionUUID->"5f39cacd-21a8-4e8a-b5b6-\
bef0e0b5d20f"]
}, Open  ]],

Cell["\<\



The 3 equations we need to solve are: (The last one is the \
\[OpenCurlyDoubleQuote]constraint\[CloseCurlyDoubleQuote], or the equation of \
your path).\
\>", "Text",
 CellChangeTimes->{{3.735475060559998*^9, 3.735475075775148*^9}, {
  3.7354756735599937`*^9, 3.735475677679213*^9}, {3.735476069775179*^9, 
  3.735476090119091*^9}},ExpressionUUID->"84431b4c-de26-4579-a64e-\
12e16479c9fb"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[GridBox[{
     {GridBox[{
        {
         RowBox[{
          SubscriptBox[
           RowBox[{"(", 
            RowBox[{
             OverscriptBox["\[Del]", "\[RightVector]"], "f"}], ")"}], "x"], 
          "=", 
          SubscriptBox[
           RowBox[{"\[Lambda]", "(", 
            RowBox[{
             OverscriptBox["\[Del]", "\[RightVector]"], "g"}], ")"}], "x"]}]}
       },
       GridBoxAlignment->{"Columns" -> {{"Center"}}}]}
    },
    GridBoxItemSize->{"Columns" -> {{
         Scaled[0.96]}}}], TraditionalForm]],ExpressionUUID->
  "10371c7e-ba90-4e48-ab4e-ca389808106d"],
 Cell[BoxData[
  FormBox[GridBox[{
     {GridBox[{
        {
         RowBox[{
          SubscriptBox[
           RowBox[{"(", 
            RowBox[{
             OverscriptBox["\[Del]", "\[RightVector]"], "f"}], ")"}], "y"], 
          "=", 
          SubscriptBox[
           RowBox[{"\[Lambda]", "(", 
            RowBox[{
             OverscriptBox["\[Del]", "\[RightVector]"], "g"}], ")"}], "x"]}]}
       },
       GridBoxAlignment->{"Columns" -> {{"Center"}}}]}
    },
    GridBoxItemSize->{"Columns" -> {{
         Scaled[0.96]}}}], TraditionalForm]],ExpressionUUID->
  "33e65d45-208b-46c6-8cda-f56c2986be56"],
 Cell[BoxData[
  FormBox[GridBox[{
     {GridBox[{
        {
         RowBox[{
          RowBox[{"g", "(", 
           RowBox[{"x", ",", "y"}], ")"}], "=", 
          RowBox[{"-", "3", "   "}]}]}
       },
       GridBoxAlignment->{"Columns" -> {{"Center"}}}]}
    },
    GridBoxItemSize->{"Columns" -> {{
         Scaled[0.96]}}}], TraditionalForm]],ExpressionUUID->
  "5914c81d-8bdf-4e79-8905-e329dd98870e"]
}], "Text",
 CellChangeTimes->{{3.735475710300729*^9, 3.7354758495155687`*^9}, {
  3.735476009867504*^9, 
  3.735476054007588*^9}},ExpressionUUID->"74fc3f8a-16b8-450b-81b6-\
d76da534b231"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"zp", "=", 
  RowBox[{"NSolve", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", "x"}], "+", "y"}], "\[Equal]", 
      RowBox[{"l", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], " ", "x"}], ")"}]}]}], " ", "&&", " ", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "y"}], "+", "x"}], "\[Equal]", "l"}], " ", "&&", " ", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"y", "-", 
       RowBox[{"x", "^", "2"}]}], "\[Equal]", 
      RowBox[{"-", "3"}]}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "l"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.687179601341906*^9, 3.687179664171835*^9}, {
  3.735473504400332*^9, 3.735473506223353*^9}, {3.735473771272236*^9, 
  3.735473775335454*^9}, {3.7354739079369707`*^9, 3.7354739082401943`*^9}, {
  3.735474098904439*^9, 
  3.735474111575569*^9}},ExpressionUUID->"a8389c86-e18f-4eaf-a823-\
06580e278647"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1.8716312288886912`"}]}], ",", 
     RowBox[{"y", "\[Rule]", "0.5030034569513949`"}], ",", 
     RowBox[{"l", "\[Rule]", 
      RowBox[{"-", "0.8656243149859013`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1.4065307663245241`"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1.0216712033825466`"}]}], ",", 
     RowBox[{"l", "\[Rule]", 
      RowBox[{"-", "0.6368116404405691`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.28489953743583196`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "2.9188322535688496`"}]}], ",", 
     RowBox[{"l", "\[Rule]", 
      RowBox[{"-", "6.122564044573531`"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.687179657251781*^9, 3.687179667782847*^9}, 
   3.687188986119204*^9, 3.7354735088386497`*^9, 3.7354737769019547`*^9, 
   3.735473909229216*^9, 3.735474120043095*^9},
 Background->RGBColor[
  1, 0.9, 0.8],ExpressionUUID->"8dc22ebf-9025-4936-94d4-80e554a830f4"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"mypoints", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Yellow", ",", " ", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], "/.", 
          RowBox[{"zp", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], "/.", 
          RowBox[{"zp", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], "/.", 
          RowBox[{"zp", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}]}], "}"}], "]"}]}], "}"}], "]"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.735473094561906*^9, 3.735473214151033*^9}, {
   3.735473256679933*^9, 3.7354732713523684`*^9}, {3.735473318200717*^9, 
   3.735473377239355*^9}, {3.735473410624671*^9, 3.735473411271346*^9}, 
   3.735473528416502*^9, {3.735473889792473*^9, 3.7354739787595863`*^9}, {
   3.735474020777073*^9, 
   3.735474029624736*^9}},ExpressionUUID->"7810bef2-6e75-4080-b994-\
8723ead2b165"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"mycp", ",", "myquad", ",", "mypoints"}], "]"}]], "Input",
 CellChangeTimes->{{3.7354733999680443`*^9, 
  3.735473460647203*^9}},ExpressionUUID->"67528214-80bc-4dd5-98a7-\
0e3d8ddff800"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJyMnQnc1cP3+J/n6dnX+9wn2ZcUkSUlxVfckaQkS7IWQpEoe7JE1rKGyBIS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    "], {{
      {RGBColor[0.148, 0.33, 0.54], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmntwVdUVxs89FxKEhOTm5vLIvbwJqO2MioCCVuRlgBYEQ0AQeQhTENsi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          "]], PolygonBox[CompressedData["
1:eJwllllsVWUQx4eudLn1nnvupfaeU24xYjD64AJGwYgPKvhQAy01liXUktjG
DWxpqOALMYIxESNqo7HGF1GKQRYXTJGqoUITscW2Pim1IC6oISzFBQr6+2ce
JpnvzMx/5ptvljOjeXXdk3lm9gJUAFWGZmdhOhNm1bHZe4HZA/lm9dDcyKwv
YxZPNbtUZvZh1ixdbbbjKrOfAVmJ7t/oLMG2pdjsWNqsaJrZY+gfLDKbzrke
+Vfl6E4xG0yabcTfIuRPQCXoZvC5BvtTxJCCvxl/p/E9G/yb4Gdjv5BzNxi3
wZdgP4buTPxtBr8ZnSZ0uwrNVsHPiVz3PJgx/i5xHkK/kfMV+DuSrttFfG/A
7+AOPehvh+bpvsSwuswxD8DvATNBrBuwvzp0Er8eyiEv49wHXgvncs71KbMk
/nqJrw6+A/mjyB+H2pAvxMen+FrBne6DXwf9yvkUNEIse8nxRfzXgncZ+2Go
AP8Pcy7EfoTznIR/205sQ1Avua3BfhTbW7nTK/h6mftthZ+PfB53aeHb3fDf
ozML3euhH+AD4stN9TdIg3+Acyu63cTQiPzHjL/FKr6Nwz+UddkCqBr8YWL+
rdzvoLuMZD2WHDQMf4V4q8FvAP9f5J+FHot8yFcePr8jX026E/xP+Fic5zk7
CX8QH9O433Hw2rBPhV4r/dwvRL8UegTbPqgu9ppSbQ0in0l9XIP9c2Bt5rwJ
/mLksQyC8Rd8Lu1YqknVZgkY4wWOWQb/OfR0odfEF/D5sccqTGE/BcY4sZ2A
jgRe46p15aQT2XowOwu9pkNkHXw7We41sAA+Q45awR7A5vcq7hh6rtupnzX4
uhGbKuJ5kRi3wB/L+tsdRn+U/OzG59J817kHvOfT3ht7iLEBrNv5VoSsFp1t
6N5QSY2UeA9X0std6DQhOwx+DbYrwLy2wN9gecZzptxNEtNOdNsjv6t68h3w
xohxbYVjCOso35bBH+LbBWSDgfvu5zzB+Qy0r8JnzAfI7gdvZb7b7A38DfWW
HdzhTNprTLU2gc1G+KGkx3ov8SzF3yj1db7U7By0lfydTnvunkUeoTsJfmWx
z4D/Up5j5Vo2f1R5jIq1kW9D+G9GZ6DYe2gT+Fnkf2K7TvMEfgz81mLv8VlJ
n3mafcrxjKTPHM0evbne/qXYe1k9ugU+ih1LM2VMsRPfIs5HsD8L/ybyL7FN
EdNbqr3IZ0Me+WknviG+5RV5TW4IvSZUG7J5LfSZo9mjGVmq2Y7+/gqvkX2B
zwTNBuX8Y87dsfvSDNAsmB77LtCddXfNLM2uX/i2Fn5Z6LlXjpSrWs49Cc9x
B7k4kfFa0cw5nvGdod2hmabZVsd9+st9J/QG3oPqRe2Qf+C/Jb62KV5Tqi3V
jGonx7dv0P868FmgnlPvaUdpV73PeX7kO0m7STP9Ts4T0OKE77BJ4r0c+S7Q
TNJsUo2oVvQG59Qrsc9azSTNpvbY766eVe9qR2hXaCb1BP5mejv5uBD5ztPu
0054VbMq6b06F3/L6b0a8J5J+B2PIvso8F1wCMwl2qWh62qHapeqB9QL6slb
0L8u7bNNM+NddPcHbqucKrefBF7LenO9/V2R50Y1q9otrvZe0gwogt8ZeG7V
k+rNROy7TDNQs/B1xY/9APQgWG9nvRb1rSHynlPvaSdpN2nmaPZox2jXaMdq
1+ofQ/8awhCWanhX6DtUu1Q5qQp9Z2h3qKZUW/8DcVs8UQ==
          "]]}]}, 
      {RGBColor[0.23620000000000002`, 0.379, 0.6226], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmUlNWVx7+2u4pu6e6q6q+ru+kqwCUCOVEUNIqoqBFZ3EG6QRTJoOio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          "]], PolygonBox[CompressedData["
1:eJwtmHl01cUVxyckwSQk4b28vETe+wUICHqqssvSagGBLGgXwr4dVATa4pFW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          "]]}]}, 
      {RGBColor[0.30008333333333337`, 0.4091666666666667, 0.6426666666666667],
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmnmYlNWxxr8ZZmCGmenpnp6e6elujCCC2yUK7hcEBjc0+qiJwpOISxT1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          "]], PolygonBox[CompressedData["
1:eJwtmHl81sURxhdISCDvC+/Bm7x53xfLIeHwRkVAuUGIeMQDsFZEQVurEmg9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          "]]}]}, 
      {RGBColor[
       0.37311666666666665`, 0.43483333333333335`, 0.5997333333333333], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmnm8lVW5x9/DOWfvc84+nLPHs4d3kxmKIKIUCKZGCt5uiQzOEwEONycM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          "]], PolygonBox[CompressedData["
1:eJwlmHeYlNUVxj/Zmd2FpcwwO7sz8w2iQpZmEKXYUGlJVFAXG0joqKAsxRgx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          "]]}]}, 
      {RGBColor[0.44615000000000005`, 0.4605, 0.5568], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1m3mg1lP+x7/V3ep57tNz733us1OMtSwZpWjG/pshTIU2LcJoIcvY15TJ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          "]], 
         PolygonBox[CompressedData["
1:eJwtmXncj2X2x2+e3bP47rtonSxPnqZEaSqmaSY0toRQNMWjiGlkqalkkj38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          "]]}]}, 
      {RGBColor[0.5191833333333334, 0.4861666666666667, 0.5138666666666667], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgeUllWShj+6ocPfTfefMyoGjDADKCbGuICZEfGsYxYFxYCLOYGgmCUp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          "]], 
         PolygonBox[CompressedData["
1:eJwtmHm8z1Uax7/uvdz9+t3f/d3frklRWVKDEBXyQsoytkm2SK4UGiIlTGQp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          "]]}]}, 
      {RGBColor[0.5922166666666666, 0.5118333333333334, 0.4709333333333333], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFWGtwlOUVfksgC5vL7n6Xzbe7tB2pNwbQYkUJUCtjG2YQQ0niWEG0Q4Qg
Kbcayq0EhLaGpiORhCypgFV0pjpFZUyQVOtg7TQUlHIJkVi1rZehnSrQMg5X
a5+nz8n4Y+e83/nOe97znstzzrdXzFlctWiQc67pS84VgLYFzo2JOdcKujdy
ri7uXDdoa9q5osHO3Zt1bg+e54H/Eugbpc4dxG8LNreWOJeAsvPQ85rv3H2F
zu0DPYb3+YRzR0HbE1qvhVwnzhkRk17K9JaKvwnvH8HvQKkon5cM+mJ/C2zt
hO4rhjm3DHtLy5xrAP1XWnvyZkcJ+F+FTDHovZ5z1bD58Uj2bjL93eAlITMC
9o8YpvUbsP809L8I3uvQ8y72NELuvUg20tZ2vBuD5yGwf3rKue9inYHMDNDP
8C4H/j3Q8yCerwe/AfQI7DqJvYdBl+H56+D/yOyhH5fY3Q/amvbegd95rLdD
XwNs6oPuKAm/DnVuPe47BfeaCJkN0PMmnivgh27QbdDxGH612HsCzzXgHwR9
Ige/4PwnQeuwdzT4uyP5jP64CJuvxvqpQu3pT+mu74B6kDsN//igJ1KK+dtG
aTN9TnrA1rfDzt3Q91KgmB+z+M7DuhdnjBok3eRznQfdarlEu2n/JsT6Suh5
AHqaoeeqpPz600C+KIZfxuJ5diA6InRu13DnRmLvM8i9FTjrWqxnDBEdaeu1
uN9o+O0/BfKlH9O6Gfy38Bzi7vvAuxa/COsw49zTkE9nlOftdkfaS7vHDhIv
b/xfwbe12Fee0T222R1Jt1v+bDc+70p/PDbgh4TynPnOWNFW2laNu3vw/1nE
MQu7no0p1y4iBrvpR+T5455yejzOfQ/PhyB/nvkJv7zKXA11p06ru1rE8iz2
3op9PSU6k/XFmBw1eyj/mvnhXDHyDDphgtvv61ye3ztMfNZLM2TPwOYuvJsI
m0/Bny9jQzfkZ4K/F7QxLdsrcG4T5C8VStfXQuX6laHidQ1+f8BZNaFsqA51
ziE7K1FmdQs6MVTdrQ6Upwuhc3/BF7G5AD3DQu0rh82XC3U2z03AD59gTyno
aMjsBH8Ucwl2jsG95wD3huIuz+Auc9LS/THke7C3JNK6GDSF3ynaY9jANW3g
/T4x+VWF0v8B1g2hamQXbI4llcPzA2EDY8zYvAld5bBhMesVa4d3owxXmBuU
oY8nQX78YOEQz/gQ/DbQAzHVOWuD+h/EOdd4qp/708IV6jyO5+eBCz/DY0tS
fqQ/a+GrMk/3qIR8F2S+jFzZk1Mf4Bn00cxQvYM9ZDPWZ9hHQG/0ZMuytOos
iuv5AHTsL1E9El9vi+meSyLV5uJI9tHOCvj/LJ6n4P2Poa8ONp1CHCug/yT2
7YIN9w9WPjGvPvKl73hMmMi6Zv4HWE+PZEMl6BLs7wN/KejiUPKLjDc1pvO+
D51/xHoW+DsKpY8xqw6UQ9PTwoYayNyJd/Wo3eO4192411HI3Af+sUA+6yhU
jKZk5fcG+HltkXMLIFNqsWGMmAvTcO5u8CeHqpt6rL+Cd9M91S578l2esGoz
9K+DnlcKhOHEoXbDpc8TqtcayByFDWugpxfPPciZb8flx/Wh+t5zSfWcqrjy
gOtK60HHA/n4CZzZEYk/C+viUDVfQv9E2jsb/O8N2Abe7Wnl/g2kKdlwGfpa
ItlQ6SlPx1muVscUV57HXtw0VP14vvWsHdhbmVWer4TNC33NMH1J+YZzBe+V
T8m3f4f8TwLxNwTqxYctRqybuXHlMLH9twXCCvYY9poJuFdXJJlO0IdTsm9f
oP7DOmbMiHkbhwr3zsHnKHf3Hch0Bsqlftz9JvyaITMurd60PCGM+02gfD2U
1ty0Mibcm4te1gebFvmqH9bNHbj3uUAyr8KW9wPlxlasmwxX/4+vhssfARtX
ZDXb/Jszki9fXsL7+RnNUqlA/liQkE8+LBPOvgvaiLxaUyS/MA5nbDa6wdPd
p0aaC+n3f/jK/Xrr8b2mk318a4nmDOboLMjvgM6ZWeUh1/Q148IcZX6ynl6J
q48eCTTjcdbzYfNO8L2M5qkjJr8ZePQZ+lMr6JakcOlFrE/HdEfuJ970GObQ
rnq772XrP6wT8haY/bfAvodh23/x/PO0bH00rZzqL1TNMh+Zt6wX5gRzYwNy
Zlsg/lLOSIwX3s8AvwW/fqy7ksIG2kfb2FvYM4jDO9PaSx3toeZTL1DM6Pu/
wQ/zYduvYdsk00MdlKsBvwP8TFJ9ivYTu3kfzl6sE9YlsZp1zbmBd7+QUj/h
XvYUYhX1l5vf6hLyHXXUmZ6BZ84JzyeFw/vh8zXIg0t4txH5+7mveTLIKKaM
HXHy1kC1PRm0KxCmcmbkHERbmTOcd7iHOcAzaQfPfTYtHF2EHLwYqb5YZy2e
dBdllIe9Jv+pr/u8A9lVgXrrRuj4Ab9PIFMLO6sC9elp4F/lKQ4jIf/nQPFi
3A7aLL3JU5yJT8TNY4bz+VDzLu/C3l5hcwZ7Bb8TGN8AOi/66iWX2IM8+Zh9
/iH4+0Kx1UhK/bIK/NsC4Qlx5ZaM6uKboL/PaV5/PSf/zLMYEaNp26ewN5lS
rl4PHXemhFnXmc+ejOs+zPfD5nP644hhI/dTz8qsvivY+1Z7wi2ew1mRMX/Z
6vQvkXCMeDYWZ53Eu5uwXuOpl7KHM4Z/srjUpzRfPsrZKSN7kqBNNvNz9r9n
uOTnwmf5SD3pBdz3/TJh0QTomJSRDRMz6i08l5jA71fiO7H9Fzn5dognLHwr
rnp5IKN1N/j/9DUrtEaagVjT1yWFccS6b3jqo8SJD3D+qqzuz9yfFsm39PHN
sLkDNpf76vHs9fmc6pb1ezklPKQMv5cHvnXZuznX52y2vxn7t0DmxuH6LmHN
snY/9lW7d4fyK3OJOffLEull/szzNWPNHq4eyV7ZkROec+YgdnFGYM9jv6Of
VsdVV6zdRsN8Yn+jyfPbJm82D7zj3rYS6SF/HM5rx3q8L3679dRERjhAPOCc
wbqpSqrGWGtXe9LRZvILI333fAv8cyl9ezTn5I82O2tKqJ7O3r7H03cVv1m3
2TcWcelCJP+w5s5YL+D/Bvy+6bHvUPbP9UWarziv0MecrYghfVYL/M4m/nOu
YJ8htnKm+V1MOcPZknXBvs7+Qt3Lbc17v1AkbGK/X27/Y7AfsC88Euj8h8yG
yYaNcbz/YSS8Im6diIRjxDP+30HM3ws7Czx9N/O7PG/f0IzVX8uEacS2pZHw
hLjCc9bZWcwVxpS5x2+uFTaTvB0pH/oj/UfAPsf5K285Rv8vzepeUxHHCb7y
bzziX5tV/2UfXmf34jn/A/tbnPQ=
          "]], PolygonBox[CompressedData["
1:eJwtl3lsVVUQxg+08sorhbfc93pfW2PEXUGUTRZ3ERKVogUTZXGhrCIFFI2i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          "]]}]}, 
      {RGBColor[0.66525, 0.5375, 0.42800000000000005`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVmlsVFUYvdJJp5229M2b9968mWmi0AYNEAVjLMUNTZViAbE/MCI7KVCi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          "]], PolygonBox[CompressedData["
1:eJwtlllsVVUUhncKoe2lhHtPzz09t/dBoQ0aISpqFKoIJAxiceLBoaaobZAh
0lJKFIgiAafqgwFBeSBQBKKJEnCgCAhERCRRo4IgVAZJNBpjHBHUEOP3978P
J/n3XsNea+21/n2GtLRPaysLIazh68/XkoZQnwmhalAIDVEInVm+ASGsLQ9h
aD6EN5MQvqsI4Te+PeCra0N4fGAIT7O+lvVq9FfjZzN7rcja+KbgeD0+2sEP
otMPX0f6hfAAeH8cwj7070HnQ/AM7Dmmz+dI9JegsxffB/meAzex9x+2y/F3
P7iOGL9incHnZcS+HB9zsK/C31Pgt9hrIZ8i+cxE9xh7jyKrw2ZlLoRXOOwP
bB9j7wiyiQVikj7yStYnE8e2mfNOgU9isxbZUmxOgFtqnatqsgV5L3trkD+J
/Dj4msS1WcPXCB5APD9WhnCxKoRq4snzHeznmsTEcqY6hLOsx5LDQmoxl68u
WOdLZOOJ6W0w7sI4cK/qib+Y7zx4BfovEusB/N2Lv47EtZHPeYl9yvdKYp5K
7M2cfyn5XY/OOmJrrLXsXQ7oRP8lzliI/iXorAKPpj67qM8V1LMb2ynYxKy/
pYmayPc4Op+h/wF7E9BtwcfrFc6hgrNHo/ML8XVxXiXxXUgcu3pAvVDPXn9k
h/FXBx4bW/8ZfPw5mB4pcm6mpA/O1tBT5b7TweCdkfF2bGZzfo696krHNJ3z
Z+FvIPqv4a+c9TLWQ1hv55vIecP5esusMwK8K3U/q4d2g2fhvzXjtXrre/Uc
uJz6nud+xuBvG3g/PkaRaw8xLkK+ER/bwQeK7qW7iXEFvlYU3Quqj+76RGpf
sukFr4ysO5V4CuTTwXppxv2mWVwX++4Uk2JTD6uXe/F3GHxd4topJsXWRk6D
wBOwaQdviY1P8C1gfbTGsX9MzY6BpybuXc3kNHSP1Fj2Bd+/5Dc08iyLI4YR
747YsfZH3kg+k5A3ZDzDmuXFyG/D15XszVf9qj3L0pHu3znHqjs/XeMZ06y1
k1MP8q2xa7lMNcB+T2m+Azbvg+dHlql+X6eeQc3ibs1Y5DtSfVXDs8iTgudH
854Hb826V3YwA4uZhUNF97r2JBMHigvVo83EMi5yLuLMVvzdgPyNcveUemtR
rX2pB/8i/0nIe0rymcQWxe5VcdDLyG7E37CSP3Hxoth8J5+j8p4xzZp0Hla9
s7b/HfmqvDlP3KczJrNenvos+ZiM75uyrt+v3McsYmsozbM4bxPyi6nvT5y9
NHJPqDe0p7vdm5j7+zie9enUvtRTp1LPlGZL/aC3452iuVf6ehvEIeKSj/DX
hO+HyOeHMsenXBeU3h/l2Am+L29dcdrP3N3tqfmrBp07wHelxprZO8Hn4Ihn
K9w/4o4q9j4pMwcPAnfgr1FcKz4Er0/tWxw4nXwn5Kz/E/eVUT/l/XbdgnwJ
8p2pZ0899B54W2yZaqrejCPbiuPF9dnUs611Djw8NbeJE0eAM3lzoThd3K4e
Ua/sIacNkXtYvSyO6WQ9P+deV7zd6I8puHd1hzcXbCNbceJR5N1Fv+WauSeo
/+Wp70ZvZj26V7F3usI10NvRnrr24v954H847/NKz7xmXzOv2Z+B/iHu49as
uVgz1EE/ZQuurTg6VzAH9HGBOJZ4uhK/5YpHXKAclIti2IQsyVomvphWa84R
9yiGM+Ly0vupO4rAGyO/Ncpfvfwq630Zx6O3cU5qX+qx2eLyvGdFb4T+BfTG
q36yGY99s97bSs+UZmtZ4lqo51LWjxT876A7mlvwGym53sCRnP180bVSzF1F
/xOp9z5l7xy1+6bGWPGr114oupbivAus/wdGiEyc
          "]]}]}, 
      {RGBColor[0.7382833333333333, 0.5631666666666666, 0.3850666666666667], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlW1olXUYxv+UbmfHxs55zsuec0aSc2YR6EaBsnmI0s0sKRCLKLIc29Ix
Z07yhVIyoqhvW21Cn6TMCGoNgxzaQtJetA8llPOlF1pZBEXRZKHM6HdxPR8e
7v/L/b/v6367ngWdW9f1XxdCGOO7nu+Zcgjj80JYnwmhtxTCrjkhHItC2FsV
wqJ0CH+htIu73ex/zIXwVTGEa6kQfkB+FIewGZ0J5FXuT9eEMIr+K9kQHqoO
4WQ+hDO86eNuCza+5L6ryjrn6q0/icyj9yHn4+g0Y/c97pcgX+fsHbC1gel8
vd9fQD6C/Qj7a/DbHRtnF/JIQwjza7GDrBDD39jZh53J2DYGOOsgxhPory4Z
+zA+lnL3B/JUjX3XgGeUfTs6Z+t9/i0yncS5Cv+LWV/jfCE2W8qOqxv8+UII
Q2ArcL4AnSvojIDncXAcIm9PIHdjv4TORuw8z/pR6rCMdxm+RtZ92DnCd5H1
Y8gK9kd4u4a3l7PO3+2s96eM51P2n2DnQWz+y/lefE+yHsBee8H25WcDtprA
kyWWzti1bYvsT35n68BMzIfIS4y8q+Q8KB/Kq+rRSq5ykX1Wqf58t6Lfi3wB
2V7tXDeh8x++bomNpYPvcLDtt/kKvF9JLFew+YCwg+E495+x/p4Y5vL2u6Lr
pzquiNxTOpfeRMo9oBimcu7XTfi6rdaYu8FQKtnXEG8vob8M/Zd4eyc+WIbL
xNvDuobNerA8XPD9IFg+SPm8mf2BvN8OoDNRdA7eRa7NOKZx7l8ruF6qm/pD
dblInv9Evlhtf3syxnmAftjIwXS13/wSO2/vY2d51m8qrFdzngP/Pcgd7GN0
diK3R86x+vot9hXOPwbPSuI9jv7dyJmc63UJnaOR51rz/TP7fehMxX6nteJZ
XnBPqjeH0p5x1aiVNz3cv4mNxbWun/Kv2VY9ruK3Le/5aWG9Bf3z6PQhXybO
mRvgA+SGovPZk8y6dIRpfsm+xCuaFc2Ucj6S8Wz+Qxz3k5MzkFZT7NntrDam
kDfGG7HxU+x4FffasvlKvHUz57PYbIzMQeKiQfA8FznO2dh9rH7OR+Yg4fsa
nVUl+zqHn8Ek/pOcd5eNTRg1c8q5+u1w3n3+LHiHGxzHQMazpLwtLHn+ZFOx
D2XdB2d5dyKZX82x5lzzPhdcF4q2/UbknlOttkWeE9XhJmxO17m/1Nc9sedC
HPlk7J5R7zSWnCvlTH2mfhvL27cwDFP/mcSXfG7nm0L/PmI9GDnf6oWDRc+C
ZuJUg+ftdINnTv8R6S1KeE/8tyTh82nwfJFyj4mP1BfiTN1tLpvnK0l9fq9x
Pb6pt87nOXOnciKeEmeIY7V+quhZ3Ybcip1R7PSX3VNaaz6VjyjtePqTmr4K
nl8TzvotmTP1jHTGiv4ndGFnRdLb6nHxgvhhKbI1MveIR8Vzilc9KoyzyXpn
NpnN2POsub5D/886c/e9RfO4+LwZXx2xcbbH5hRhf7pgztg/zzwoe5vSxqfe
Uo9VIdeVrVNkXciYH/do5mLnM4U8FvvtUeSc2Bg1W+Jv9Yns7ygkXI3/3sh+
lI+WyLlRX4ivVYMsuv8Dk1gmrg==
          "]], PolygonBox[CompressedData["
1:eJwtlluIVWUUxxc5Os6YeM6ZffbZZw5JjpplD85AMKZOUeal8qEkeylMxVFH
bNSR0vBWEYnSizNpEUE3U4ISMyhRRwST0l40qtEsrSmLIOniNKFo9PvzPw8b
1vrW+tblvy7fHrNo5dzOGyLiZb4avoeTiKvDIl4ZHnF9VMTfDRE74L+ojego
RIzLIk5z4UpdxHjo13MRryEfPTLik0rE+nzEDHRfqI/4BfnmNOLPIdgbETG3
MeIaZ93Iipw9j24b998bYRuy9RbffuLYy9lK9HvR70B/EsHth17MNx5+E/r9
xDYc/jdiWQF/Cn5WOeIY8iXoX0l9JlkPMRWLEQ3k9zH8APyrRduU7WXcOQSd
kOPxIcagHn5ial4+6uCbkF+D3gk+s5FNhf8DeQF7S5BvA4PBGyM+4OzLUsQF
/D+DrbeRN6O7lZznQf/AtwH/f1XxVY6Hub8qsa1e7BfB4hB31hHfIs46yW0t
8gz6fb7ZyFak9i9M2rm/IG/5bfAd8BvgZ8Kf4VuDv6eKxldnT0MfVQ41rkEH
eOeJeVydfQ4g68fGc9hqQ38ttt4pGFvFcx/xdBV8XzX/Gd2evGWqwUzknY2u
5XXyOYW9C+hMqbHNn6DPJNaXz/nk28r938FjC2e1xLePs73wt9NfJ8D2M/Ba
rH5E/yyxDkPeTD516M9PjYmwKfOtw/bNxHAU+W78jSnbpmxfwsZkfD2QutdV
Y9V6B/KFyM9pJqCbFf8Q+2yB/oc7L1bv35XYh3x9jo2XuN+es656YCvxXuXs
0VrHMC9nTIXtWeJ5kngu590ruvMV+bSkzl9nzakxE3aamWfVe8xkU7j/2ohn
Z8WzKAx2QM8G0wZ0+7k/Fbo9MTYfob8KW+dK7m3lNIDvBZztHm6bj6PbRc59
te4RzeKDjbalHp4DfWfR+KrH1GvdxLSn3viWyOcR7hwY4ZqpdqtT+1Z8S7F/
vGTfJ4n5DPTQzLlop9RAD+ZdH2EwLfEMCYsT6H9T8g7SLmrlewP5wqJ5zZBm
qa9k28pRu+zrku/KnnprRtmxqYd3YetAxbtLPaneTAveFdoZpxuMibDp5izB
V7Fg+gryhxLvGNlSzuvBpy9x/2i/9KK7MfUsa0Y1qxOL3gXC87x2U9m9oJ2k
3aQdIblqptppZ/VU/U3Pe2dqdwrzMnc/Jf4JI91fe3LuyUvV+RGWJyuenXZi
vFv1ydu2fCgW7TDhrx54Avr+zPtHNW8hloV597dqrtrfkdo+bFwe5ZqqttfB
eEJWxaS6b4Xl+Wr/qp/m5Fwz1e4iZ3uR/Zt6Hyq+QehWfDwW9jkZ+tfMb4l2
jHbVwcy7WvvoXWylOb8teg82QnflbV89od6YxNmW8Nmu1JgLe83IrMw9q94V
htuJ982KbaleU+A/TLwrNRObVJuCY1UP3cPdsdX7qkkTdF+De1lvxC3YH1sw
NprRJvh9iXel9vFmZKsL7j29fz8inyH8610DvQWaYdVCZzP1/jX6vVK/t0N/
W/Iu1ExptmRTthWzYtfOFy+fept7Cn57hPmxxG+QeO2obci3V9z72ocN6C7L
jIfe8Db4W+H/q3OOyjVfdL01Iznow+hcrvUMaBZuKhsb9cDosmdCs6F+T5Bf
zJy76rsG2bSCfWm/LM38Rg9U7XXnjaGwVAzj0D2SuheEYa/e6sS5KCfleq/2
f73z1du7PPPbKB/6NzmS+b4wXY7+d5wNrbMN2dJMabZ09n3qGVL9ZXM69KmK
c9FOP8j9/wHIQFQb
          "]]}]}, 
      {RGBColor[0.8113166666666668, 0.5888333333333333, 0.3421333333333333], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlU1sVVUUhY8FS9+r1fdu37297z2VVko0+FOdOJHWxMZSKpqoGCWoA1OC
UIIKaaspRhGDVh2QCI0DEydSMRrRkQa12NgGJFFaNBYaAlET8GcimGpUtH7L
dQcn59x99u/a6+zb8shj92yuCSHsYy1gzV0SwsFcCCXOx/MhzLJauXgDwQ0L
Q9gQhXAmDeFSZEPFEJYlIWyvC6GHvaUcwjvoN7O3oHcMnTXYba2EMFpLjEII
y/nej/x3bAdZdZy/T60n/WbsnuQ8z7mb8zdNIRwmn9/QvX+R/a8hjzZ8DtWT
E/tP2J8hh/2JbWQ7iI/NZef/MbIV6Jyg0FONxGOd5tyLbCSyv++wfQL9k+iP
Ra5J/oVDnLNcOCyL7Wd10TW9jfwB7B/Gfi82tdR4PfYF5J34nyP/CeyKyIYq
9vVn4nxH8T+C/3UVn3vZ6wm4Hn970U9yrlnfB/huawhhqhrCJuw/wP5p9skm
92uW/Wu+70D3AvWtIo9a5KeQfYrtU8hn8H0CvXHyP4ROxHkpOo3sU5n8Zura
Rcw+avucvCtl17cHHzvq3Avp3VXyfVdi7IThFvLfh94kta/E7hbqr+fcnZor
4sxW8DusWPg5V3Tu45nPf/F/jvWmMEfvCLIp8ryybJyvYP8ZXzs59xNnoOye
xORSQ85/42c6i6FY2/D/LfZbqKUZ2dLUOq3snUX7V5wPq475esG5j7Eux34H
OnfidzD2nXTa2buyuK9y/3LGy9ay7SZYX6F3UYNr7+B8oOS+qD+/Fv3GXqz6
viFvPj1esu7t5LY7MubCviZ1bWu5/6PR7+VHZB2pba9D92ij+7UAWXfZObwl
XhfN877UuO7OG5e1GV4Pkc/dJXN8hp5sqFjvM+Trsbka/eX4eTAxrp3spZK5
JE6p9+JAD7L3C657dcHvXG9jkhq/qFqu+2fy7p1wbM7mQy+2hdicK8buld6R
7jRrNHPOU9+7efsUzyZyfp/q33zqurajuyS1vXr+fJ35yuf/HJJuHfebWAeR
P0vujbFxE37/XGYchMetWS+PVK0rHFYFzw71SjNAb1Hz8WTwOxNP1LMX8q5T
fWpLnMN0kzEVtmeJvwe/83BghD0uuO/qv9683vohzttic3CYHm7Me17I59Em
+5Tvzqwvi7FbSe92MUO62XOp8dFs7sneaSGbSZob4sTisnMWx9ux2YntBTDY
GDneGD5Op67lI/LsyOb2HPr9Zdfex/5cZG6L42dz5pXm3UBkLH5JHWd2kfWm
E7/zY9kMU86qfyC2Tn/smaQ5Kd5cG/ktvVZ1PMUdZB+O/e70/t5LzBP9o2Yy
fn6C3fFsNmpGXpN3L1X7VWXzaQl7FDlfzemXisZc2P+Q1S4M9K9S7cLgxsTc
uikxh+TzXvBbmLr+i1P3VjxUb84Xzdcv8d+Z8Ur8Eu+EuWKvS42F5vpwlsNt
Zf8nhMMKzu2Ra3g09X9OfBhPzBVxZpT7VxL/+/T/vK/g/8dfyLqyOax5/B9c
LR06
          "]], PolygonBox[CompressedData["
1:eJwtlO1rlXUYx682mztnrc65z3bOfc6pdDkpsLLe9KLcCEe6lRmkUUL1ImbW
NKPVdgqLWEVPr4R09AfYKgqyetEo2Bgdy4TUSZAbUmFgT2/SiCKt9fnyvV/8
ONd9rqfv9b0eeh56/O7dLRHxNG8Z7+OuiAP8vpyP+DWNGKpGHEK+vDUij+5m
/uvg+6LOiDVJxMP8dwLdW+0RD5YjjtQjZtAfJcZXyE/hfwr5JP+NIa/sjhht
s08P/mN8Ly6PuJM3TaxuXi+6U9g/gf1oLWIbwKbweRJ5lhxnyfUfbx55czGi
Bd+fcuAH20f437HMMceJ3eh2bP33AvkuTm3bJMcQ/v/wynzvQN/E9zT6dnTP
k/9H5I1g6M4Z04aqMSpeG/9tKvBbcO2qaRT5LvSfY3sEUgfANpU49r34vAaW
GWKO5J2jgf7nLN8ZYvySOoZiLV0SsR/+PsN/MW/+Rsj/RtFY9N9uvq8H/4v4
vsS7oewalE/9eh3b78rGeh//HSu7h9LJpgO5r+B+i9NH4fdVcv5JblQxjO4W
BODEB/isQ25PXdsE9jnk6bq5UoxPkHurrlU9mwT7/sS5xdkKdK347Gwz/wm6
UiVidc7zskD8L7rsr57cQ/4inO1dbk7F7dGK8ajmY8iD2TwugGkj8rkSnCg3
NpP4D2fzKf0W+FhHzquxn8V/Aj4ulDwbl2JzHnm+4thz2B9Hvhb7zrxzaPb/
IMbhnG3EvXzkuw/9EvpFfGZz9l9Ankk8y5qhv8vGICyK2a9ZTM29YpxB3prp
hVm79WzROmHUbKdVc/se/j3Ik3XPyrz2Cf8vS84tjN+Q/4fU/XmFNw6WN+ve
3X74acDPA2Xvj/zvRx5kBvZ2RHwIpsf4vi21rerfgHwFOd/Nex81JG8Ts5n3
zt+K7kTZu3kguyVbC+6t6t9D7EN1+2om9iWeMc3aHnKuRb+m7NlqYn+u6JmV
rXJeqXmv2VY2sv22Yn9xfhL564p9NaPri65BtRTwvy5xzapHNQ4R66ai+ZrD
5zC+Z4uWFa/J90Ti3qpHuj1jiW+jOBW3vbzzOXOoW9TM+q8d+p3vC5dh3+GZ
30Xu31L3Qjv/F72aLvg+PkONXV3mUFzq5r6TuAbVovnfjH6ctyk8wztS3zDt
knL0UU+j6luhGzFe9U6Jf/VosOqd0G5MYb+95h6qH++jvwr9TmJ+3+L92IXc
QL/U6pzKvb7q+yGMA8iPYHNN3j6nS55x9Vo7ncDFisSzpZu2Ctvbs/6qZ//C
zXDNWHT/DqI7znys7TQn4mZV1dg085r9YuJ6xXcL8bbUjFX4KtivrHo3dEN0
S7Tj0gtjX+IdER71bDXyc9l8aCa68b+x7Fuq8dbtG8n4FKZPE2MUVt3wkcQ9
VW91owrcqoHUsyY+ttG7QuLeyaaEfi7zVw/6dZ8yvoVhO/L/zOkIFg==
          "]]}]}, 
      {RGBColor[0.88435, 0.6145, 0.2992], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlFmIlnUUxs+4zaLTfO/7Le/3zkeNkhc5OhZddCGj41K4kUJCIthNGkhW
4jrRAhXmghEKGpIIXojJVJR4ISqkZo5L6wzeROR0U4xakNOFk0bT7+mZi5dz
3vM/5znb8/9PeX7DM6+MiYjtfGP5VhYiLiCvlSJuViPebYoYRH6dRVxsjPgG
ebQhYj/fFPw+RzbUR9wg+J004if07nLES8S0E7seOZ7/qyTpSiJ+IL4XnD7k
b8iBRp892hqxZkLEWvKPEHME/X4xYjb6JHA6kb3INeCvG+da5P8xed8g9vTE
iGeJnZ66lln4H+b/ED4vkH+pcpOnhr4Y/1exd3PeV4lYAt455GcTjCP8H0vO
VcyMoTl0Yl9dcf/PIcucnVIMOLU84jg+M5HLiB3GPj9xr7fRP6GmXZwvBHP2
OPep+nfVIraltv1CzduIH8CvG9mBfYC4l8l1PHVdc7FPbvZ8VPeS3HNZOpq/
h69CTFtu/QBxc8g1RM0XwHmk2X7a8VzyPYDeVXVu1bA19Ww0c83xfgsYxC4k
tqXJZ6qpqeR5LSbPw8Teo8+21LyQrllfydz7E8zhT74e4r7CNq9qrPnIeYn3
L44syj1zzV68+LXRHJuRu6c67GOqtifkGsmcR7ttLpiL66mzo+K8s0rmnPCH
8X2s2ft6jT6TeveuXt5qsL/q+ytz7r3s5c2y824Ho4i+j5gCeadXzLuZreaN
9vA29rtFc+U2NQ5grwfnX+Stqvd+smT+qeanwZzE/4PgLMtdj+7LHf5XJL5T
azlvw/9D9IeQLxY8j3vsZDO5T8DVTcj3EuPswWdj7h7LxE4c3ZF29X7Nsf9j
UOshMCeXfU+05xmpd6MZ3El8/8WRaeDtxu8m/sfw6at5jv0181LzW9TquypO
/lM0f1XD68xlVeLeFpBnQ8n64+C1j/JV90acFrc/Av8Dvk+xT8U2XPGuvsBW
x/8B7JH7XLNVz3OqnpVmNtTiXU4jbgc5BrHv1Nyor4dZddH7dc5G8HmqYAzN
UH2Kdz83OZ92KH/dB81UebSrJyvmd13Vd1t3/NvM74juxUFmspX6boCzBXmZ
s/Pk6M1816Vrvhn+B8FfQV1DibkkTokf4kl/xVL9iltp5ro0D90BcVLcXJ67
B3HtTM3vwlnk36McFpc35+5rEzJN/eaOpf79qd+CS/h3trov9XeNmC/1Jmfu
T7rq+57/S+jfIX+v+i37A/kf9Nreqg==
          "]], PolygonBox[CompressedData["
1:eJwtlFmIlXUYxl8XnDMz2ZzznTnfOd8czBkUXBo1uugiRtPEckGDAi3UGxeQ
JhrSXGgBRY2JRAxmRBQhxGgYFe0qTIhUHMsFHQVvRAcvDM2CHIjMLPs9POfi
D+/7f/fnXdpWdb35/siIWMcbzdtcirhZF5GOitheiOjKIj5CcKshYgN0J+9j
+NvwG6FbeH3Qk8dG9CQRX2AzDtv7+PgcX628A9BXCXKjGFFqjvhuTMQQNpuw
XZ/Z92p0erB9GfkD5FtzEcNNEXMrEQVkQ/ichv9D+YivkLcS7/tqxLfwx+Hv
ofMZsda38NcYUVcfcSf1E32MGHuxfwK/jvxPovMJuv/V5KepfRm+BssRA/BH
iTcD2SX4s/BH4E9Br1U9xOvAx4f4m4tOD7ke5q2ATpB/SS4/U+8c6lmadyzl
qFxfLLmeh/ibhX03NaxG1g//B/o7CsZePdiCbrFsbNSDBPrrxLXKXyNYbYSf
iex1/n4Fq/ktxmoL8gXQx1PnupP67yO/VzGtGv6iH+3Y30Y/h/0sZM1l91c9
KpXdE8UfwGYhvXpUdm1DYPI3dPDX2+D4n6L7Lz4WjvbfCGRdqfN5Fn42svHE
e1xvzITdraJzbUI+B/lp/oZzzlm5y6d8dyP/reIZ0izJxwT4V8C0v9H1HIQ+
mxoP/b1L/dsS56OZeSr9inNRD7rAry/v3mtmNqDfgfyZBuek3Jaj04b8LvFG
IusuebY147vI7VzVsy8f8tVJ/BM5Y/o29JWi8dJMFLHtxMfUWvx3sN+aehb0
9x6yHxL3Wvh/kNmHfCmnmcint3gWNTMzoNtTz6p2Zhp0IXGu6s+f9GdExVgL
s6eapWb3WjmOJd9e9PsbvMPa5VNV75YwUy+fI+f9dbaR7eKCfWmn25CdzDvX
F7AZxHZz5t3WDOlWXEvdP/kbhB6Fz1/qjYmwebXi3mtGNCtPirVekd91+JcK
rk07eZX8J2beZeGvWzMp9e78iPw88rfAZF+jMRW2l/l7NMaYDaO/JLOtdv4N
6JWpd1c9Vq8fN5kWZh34WlPDSxi0gtWizLugG6Jb8hqvN+cYS9Cdl3fuqkG3
anrtPmqn26EfVDyrmtFN+NtTda8Uc3fVN1e66sl49KdktdmCnyo8q8ZaM6Lb
/HvFuyF/mv3Fzc5FOf3T5Jul2s8Q44J2t2xaOtIdKHqWdOMuIpuS+vYKU2G7
r+pd0Aw+T74LMt8e1d+XeMaUv3qaJL6Zmsdz8FeQPSzYl3r4k25r2b1STMX+
JrEv3Zj5+P4f8Eryrg==
          "]], 
         PolygonBox[{{5511, 2024, 4773, 5319, 5320}, {5210, 5209, 4640, 1946, 
          5407}, {5409, 1947, 4641, 5209, 5210}, {5496, 2011, 4738, 5306, 
          5307}, {5320, 5319, 4774, 2025, 5512}, {5703, 2197, 5702, 5194, 
          5195}, {5307, 5306, 5843, 2303, 5844}, {5195, 5194, 4624, 1937, 
          5394}}]}]}, 
      {RGBColor[0.9091666666666667, 0.6429166666666667, 0.3184166666666667], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlE1IlGEQx0ct19Vsd99293131wzpQyxN6GiZWUaQqNGhpGPRpaKF6hDR
FoSrEdIHRdqhixBRXbIupWSFYPZBUXQIwsOmp1SCCizN7DfNe1hmnv8z85//
PDPvVuxP7z6aLyJH+BXwOxAVqcWWx0T6ikS6S+z8yhV5FBQZxDYlDd+G/RMX
ccGbE9yR2xoQOUluM/5MocgO7s9wzoH3OCIf4xajsbNw5chdCt7oiXxCyNgy
keecJ4pFMnA2gUfwa8FmgqZJ4zZRO4uG2ZDIMJw/wKc9y/9/jz+C/wx/hDpf
iCkifxw7xHkAfyoiUu8ZZzv4zyXWI2nSFxZ5iN2ObYka9pK8ajT1o2c99ix5
T4hfzN2hpGlQLdfgXc1jHiPmtetrgOAEPbyl94O8xw3HeGoSVls1HMae4pwD
f8r9gyLrXfu5iY5b1GnAVsatdhV2MmK6u1IiK+DNg38ferd4lp8mZi5k+rWP
gZT1pf1dKbGYes6d5L7D9oNPw5mFpxBsFfkZYlbGbZ7qK5cTs7POeTNabxO/
AWyBfid4kzzq//bn+wsbcgwX8Az8IV22hM1E90E1vUfbGPZx2HZI8Y6IzUTn
pe9YGrZ91D3thLOX91kEzwXivxJ/F+x7yGZSR8xyf2/KqZsm7jPxH6jTHrB4
7fkbNYaIGXbN6ttqre6IxZ2Hey91Pe7+8g4b/d2rw87HDV/AroX/PvxV2Dx+
V/HnPdtlras7UQZXL5xljn1L2tsb12ams6vgvpS7OWZ6CZ274Bkl9w5YAX4P
fha/hnrn0FmNlaDtnu5HT8B49I1euNaL7ss6X1uvYzU0poX+RqPWYxdYm1+r
NWG6Vf9gynZI92SrZ996zu8lHbXdaQCvDNqdvmdjxHZDd+R00nD9n9BZKafO
XvVe9/38hPkdjt1rj7oPF1P2DpexU57F6u7E6GsNnFFsyrGek9Q67s9X57wz
YRr1W9T5aY/a6z3iJ/G7Y7brqndP2PLGi23/4q7fD/YfR3u46g==
          "]], 
         PolygonBox[CompressedData["
1:eJwtlE1IlWEQhce/Uiu89+q933e9ZUT/ixCCNpGYdSOwn4WLqG3RpkD72UUS
hCmUmwjSTZsggtrVJq3MCgoriqIgihZmq9SCClxI0XM4LgZm3pn3zHnPzPet
OtzT1V0ZEWWsGttdiJhbFNGIP98QMZpE3KuL+LM0Yjob0ZeLuFof8bs24gm1
vcWIb8RrqyIKTRFbsRrunie/iXwfd/YvjpjEevMRe5uMf4F4ltwP7CH456jf
QH2A1wDWFTAr8B/RbxI/oWae/K5MxN0w5vuCz5RbjxXg+rfR98Wxkvs7myMG
l0RcB/8QtSe53xo+K5M7CqfXYN3g7Bq5zcQ3iduIe+A6lDN39RshXk48jF+B
HSR+Rs/xSvN/jn+/ZO7iOIq/I424Q+4jNR2pOYjLHHxXgFWTtxbSpAMtLhFP
CxsbJH61oL96vEyskXqNcfaT/J6i3y/9O/EnEs9Od17gn+Dsc71n9Jh+A3lj
v6GmH3+iybF63iZ/IOOcMM+iT5JYW519onaK/rV1ft8D4n+p3zuM9XP/aWJu
4rsla5M/ytlY4p3R7gTxB/zV2qFav1+7MUL/L6TXkc8n1lhaD2El8Lel1lIa
tuE3553TTDXb2dT42oEZ/PaMZ6uzY7xnHIypemsibY5krJc4rIHLqaK1VP50
0TPX7PXmr+Rb8u4lTivx21Pvima8Hb+6aC3UX7vYknrW4tyFFt0F115m/zrh
M1DytyUO4iKNpfV38C/mfUd3s2CWU2su7YeIq+i1L2su2smSdinnnGai2dzK
GUsz1qw3LuyPvtFffN+tOWOLk7i9K/ntmsFb/JmsZ6d90r/g+ML+SoNlGX/z
0kvf6Bn4/Ac6f5wc
          "]], PolygonBox[CompressedData["
1:eJwtkDFOgkEUhAcSNCAI/EHh96exVJQDCIkWWmHA2NhbaqIn0I5Ko5R6BDu9
BcFDKAmdpRaKUfhe3haT2ezOezOz66eXxxdpSRWQATtrUn9JasP7q9IBqMdS
AprgJSc9RtJ2OG/BKYbTAXa+WpHGi9I1rJo0yUqzqtQpS4fgnZ1v4B/UePuD
F9D2mcnAu2j2wBM+Qzx6sett7j6RfvPSHXxWks7BK54jsIHuGX0j9nt7nxa9
T4s+s+B3UnK9zVk/65kKOYt4fpH1EwyCV4G7W3J9kO8GzjNXqHhGy/qNdszs
tOr9rGeC7gF93TjyXJvhH+0/lyOf+Qle5mk7bXc39t5H8BwtvDgK
          "]]}]}, 
      {RGBColor[0.9208333333333334, 0.6720833333333334, 0.35458333333333336`],
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlDtMVFEQhieAuywG2b0u9+5dwMRHFKIGLSzUxihaGIiKJqJ2aKMmCImN
ClY+EmNiYaGUxALRAkMliPIw0SBGCrWxItD5jAliFEG/39niZubM/PM4M/+5
q1vPNbcVmVk7XzHfxtjsWNJsMmt2o9LsFPoH9API/jKz4yVmZ9NmZxJmt6qI
id03DOZhgB3/BHpX3mxouVkL2NrQrI/kXzPkRp9C34O/gxxzKbM3nB8lHK/4
kPjHnLvIfbvUbB59DExVzuwH+DwymXRdueKc58khawK3qU47NfrJuY8eflV4
rt3Ya2O/ywbkJ3rqBT8Umb3H10j9ceR38J3g14R+1+mU93CenAPkbCLnH2Jm
sC8gX5X5rNT/z8jx80hLOmac2J5SP+u+5Vm/801mPAZuWJiCbMV+v9hnqtnO
0kOIr5PcC+j76WEaf1vou1HdCP8i59NgppGtWZ9RHfkbCvNq5q67Mj7PRKWf
ZV+Fv5u5nSC2mplsw/4RzHPV5DzD3S4hr4FpArOUc36IJ3+ptT50/HZsJ9Pe
/3W4MRf5zFYQ15H2feep25PwvSiXZqxY7UD3UC3d80vGZ9BIzsWVHlMS+1n2
tdS8l3b7Bc2QGl3EtYN5FnlO3aMIfC/6ZuzrQu9NPTYU+Ke+Dse+vyPIt/S9
tdzsHXKSbxP6a2Qzvgkwh2Lnh3hyhZpFsfegHjUPYbSDlqzvuRpMReD730vc
TOhvaBD/bMq5Jd/B2PkgXmgH2sVd4pahd5MzgaznG0DfgnxBT3X09hJZzT7m
yVWD3Jn3nHqj4opmORJ4PdW9E3gfqrkj73Gaw1SBT+JVPZjFyPtbipxPulNf
4O9Eu/rMbH9HziVxSnNS/8I1ZpznlvN/gd7Eg8B714z+86zSMcJqP3pTspcH
zhlxR/eTT31rBnoL4kxJ2t/SUfr6lvF/i/4x6uVJyvkRR/4PGQJbFfgutBNx
VzmuYrsYO0b/m8uVXkt8GY08zwjyKd8g+nDkvBC+s8Az8W00cE4Jo7n8A4ZC
xCc=
          "]], PolygonBox[CompressedData["
1:eJwllElsTXEUxg+v+rRNaa/23d73SsxDzEvEhkYiaaNKUsOusWFhSCwMZUNJ
hFiI0GVjQVlouqJqKEEMqQVi21RsDBEJFbPfl29xk3P+5/zP+b7vnP+d0bGn
bff4iGjlK+PrSyOu5CJuVUTcwy42RHzDzucjOuoi7qaOjZVHrMd/VYpYXh3R
yeUDWcTwlIhdxN6S84fcOYWIXuq952wudlAvqHWfs8lJxHTOLmPfJP82+e9T
x0bxf2NvJ/4iZwwl7jbiD+GP4H8nPhO/c6JrqFYDOV+J7aPfa7CMpc4VJmEr
rzd2cfxUGzGYuncHZw+JP0iNVZg/E98Mp6eV3IffOGKr6TGcc4+MXs/hvwj+
O4k3k/sYfwH+Nvw5+A3cOYJ9g5pZas3U/xyYf0yO+Fhr7Op5h/hp8PWVu981
9FlMjcv42/G78Scl5q8aP8lP+XbkrX9BvTL3Us8hct+Cd0PeeEaxpzV4ltJ0
KvF2znommpO43afGYIX10S4cBE8P9Zq5f4z8ssx+C/4J/H/c2Zo3/z/YG4k/
qfTZmVprJi4DVWAqRqyribhe5RqXsFv4+qvMsRd7S41zpUF/jTUU9uvUnI89
L7MtTl3Uf1ewNqqxn/qHiY9WWpPzxNcUrLU00+5oR6WVcjqx3xTMRZj2Fj1D
cRGHNuxyvu5K5yh3KvqNVVg/7ebf1LuundXu3k1cXzM4lBmDsGiHNmXWRNr0
4y/Fv5CYn/gfRevexP3FvzUzR3EVhgn4K+q8K9r5L+zPyqJ7a79XYc8qeHba
59nYS6k3kvPMm8C+oN62zpYQW1s0F72XJuz2Or9P7UQZ+ncl5i4MOfpfTTxP
cTpFrYEac9U/4CW7fzzxrmi+48lvTLxbqtlI/tmSsWoe1cSK9e6tnBL+ssza
aKaarXZAWuiNPSt5R6SV3tgj/IuJc6XpQu6eLJm73tSHWr9p+drpodT/BPXT
DBvR41fqf43wift/Kjq5KQ==
          "]]}]}, 
      {RGBColor[0.9325, 0.70125, 0.39075], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlM1LVWEQxkevmfcadLvaPfecY6WBplD2JUWLNkFBUYssUHQT/gHVokVm
BWG6c9GiVW3CVYtKROmDwjLKoIsGfRIVbTSQICIo+qTf8LyLl5kz78wzM8/M
e5r6jnUerTSzI5wMZyZnNst5hj5fNMtmzTbFZo9Ts2lsV/Nmr7FXYK/G/nW5
WRX2HfVmJxL5e1wrd9fBaUYOrTCLAF+H3sTdQI3Z7chsI9+rsY9w341exv9a
Qd9uP4jtFn5TFNiBbR9nDn1NyewneXG1veSdzCmX51gSS3pOt03kVPfLOsWW
iJ1Ff4L+HeytsXwuAfaoTrnuYn9PHxdqFDMP1rdlZsNw8CDU475zOfHltVbB
SyN5uqjnEJgt2C4S14/+EZ9h5BiY41nFx+C0opeQPzj95GqAm0ViJrFPYrtc
UG8dxA6iv1uK30qzhLs2fFLkWEF19MayxVnNLslqFt77vUicN4Lfjv8VcNrA
qS2ozy/cV0aKySBb8DuLfzOyj37aHQ/ezodevKfxSL18ot4zifJWYHsORx/w
v5MXF87Jb+y9YI2CuQqc44n2x/fIeXVefJaL+L1B/+d9RbJPI5+m6mk8r57K
gfNqgn4RP5Iq7m1Wc30V9nOhqLoWcprHn4DveeKS5ruzqON6F7In1Lk70e76
Ds2Av53vwVqzbYl8Xffe0pL8vb8N3J3Cvh65P9ZulFPN1ee7C3kzzMLfwblY
tT2kj6GwM5FzFjC9Ft8Fj/W+GsPbWYu8H/hxnrbE6tf77on1fm+A+TkSJzUF
YXhtzvPJMMcX1PY3Era/ic5Qs9fuXDvn3chMvd7U5lg77XUOoJ8OOI7nc3Bu
nZNRYiaQe/LaCZ/BYXwaSnpP/hb9P+K7eSCvN+x1TeH7H01zoQg=
          "]], 
         PolygonBox[CompressedData["
1:eJwtlDloVGEUha+JSWYmwUyGMS/vjXErYgR3g2KTQtRCUDAKhthNZ6MWNq4g
0XQW1tpIak0IiRtKNIIRDCpoIW5YaEQRRATFFb/jmeJnzv3ves793yypHuw7
UBcRWzhzOZNJRInf0XzEbfC+NOJRIWJhfcS8csQMZwr/OHfr8e1tjziXi1is
/GJEI3dzyE2IbwDf4O41vm7uUupd5xwjfpKm18DnS651mdNF/LLUubK7wZup
fyTnmX60Rryg/2PwQ/wD+O/imAWn1A/qna1E/GzxPPvpvbZWTzOtA/e0ufcY
9hjxizrghz0sDuCOmi1OKbhCzPK8e6r3ntS9uqi5G5wRsyqcXwGv4S6ft16r
wd/Iv19nDt/BNxP3lwa3pEXqWm/gcBy8NXMt1Wxg/k1l7+Ukd11o8b7Ns2s/
I+TPtpvbODE7if/L3bO8e/4BD6bWX/VPgzs7XF8cF4Avod9MwTO/pVZvm3Of
Y39KvHNxUUw/+UOpa2nmM+AZ9J4uWJ8H4KnEs4njncQ70C4GmyM2wm2Cu4na
fOrVQ42JgndUX/YOpa80z8AbMudqH73M97Ti/uL0BNxZex+q+ZF6H2r89QYa
4XYlsX7S+2pijuKaceq02/kRF5usd5X+Q9T82uL3VmX26Yrfot78vYrv5DvK
TCszv1n5xeECjlzJ2mkGzdJb+z5eYTfj25VaT2nWBx4p+S3L3oH9OXGs9rMd
PtuK3q12fChzjGL1TY6S21+09tLshPxFzyqOh7FXZJ5VGv3XCr4vm1xzmNil
7dZGGn1p9ZvS/qTBO/onZe9a39gpev9KvE/x+w2uT6yleuq/4R8VjpVY
          "]]}]}, 
      {RGBColor[0.9441666666666667, 0.7304166666666667, 0.4269166666666667], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtk09sTGEUxW+KqU4T6Xwz5ut7k0nZWLFA0YQ0sZA0EiISQlsLTSyaNqxY
zsS/7mrZDTaCiKBGaYmEhC5JbKy6pTooK0l39Tu53+Ll3Xfuufee++dtH7t0
8mKHmZ3g2cCzGs3WC2anK2aHq2bvAbsCPr4fgfdnZnM9Zi3szzWzLRW3R8Df
gr/B/greImZyo1mBfJvAp7vNjuRmdXI+IOdO7Nf4FrqI4X0cThF7Gf+V3Gs9
BusOrmEQfAc1zpHzNlgz97rSciZzW1oa2A04i3CKKVZ93Akeqxyf4A130hN1
2yXXcw/7buK04Vv0PB/BIt/34SzDHaPeeWpN0eNi2e2XcIfJe4GcS+QehPcP
/BX4UMXtQ+Q4m3ndW/ivJf4M9t6ES5d8sveBDfDdJrZG7PeSa5glZ560SeMv
nnHtAi1HS767v9Hnpd73M6dv2BPwnwaPV54fcMd7PHaaXvLUo3q9Qe2Votn1
zOei+azAf552egy8Df4OfHPwPWlfza2uQzn/4N/Wa7bGTvt6vU/1O5r5bUln
Hf4CvHk487yvZn4/EX9HdM3Svkc3h57dmccp5xdqPwnOOQV+U5rgTPH+EHw+
ugXdl2b4EH4huGZpr0evpZtVnOxm2r1u4DJzO5B7L5rTz3Qnul/tWL3Uot+3
ZtKA21f1WtrbrtxvQ/fyO/oN6C4OVl1DmfeL6Pz+kvegXp6hcS7xh9I/p95H
8bWi59TdlVOezuD7kIZZ7P+ynoyQ
          "]], PolygonBox[CompressedData["
1:eJwtkrsvBGEUxW+sYEe1G7tjZjx7Em8FrUapYlGQKIRQkWh2Q9jOP+DRIQqv
tZ4NCVqJhv/AYz0riY7fdaeY5Nw595x7z/d99aPTfVNFItLEV8z3kBQZAuQd
kRZPpDQuchERGS8ReXNF9qkn4cdKRVLwtZUiP1GRX/jemMgRPSPgTTQF6ja+
AvUpPWdwad/0Of5lwHN4ZKhfmLcIzgam30D/iPYpZlj/5dA/h7V6HlJn0RQc
81CvKPtdRmyfD/hV6mG4FPu2ws/4Vm/Dz4Jv4NNhngX4Zs+yKx+pEOnwzU/z
d4KHPOv9z4B2j28i9B+Aa/Atu+7bCL4O/c+p5+FrON+tcP9a8G1gZ6EeO/Qe
s/N3eH6vZI245q18EThwbb56+uBP13bTHR303UnT6511gds902vmdfj7wHZR
/RV1m2dZlV+jfkLjRO0N6FtYDsxf/UrgX2K2m87IM/vctbvVTPX0l4XvRfl3
uN3wfDRjP7OCpGXXO/TBboXto3e4BF+dsLu7g6+Jm6d6nzDjFL8eznS53PgU
3Jdr/Zq/nP5MwvLo/itx69FefaN1vNUq196KzqwGD3q2m97nAf1/DT5yyA==

          "]]}]}, 
      {RGBColor[0.9558333333333333, 0.7595833333333334, 0.4630833333333333], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkk1L1VEQxgcTvFcRvWL/4/lf9dIiAqHNhRaSIH2FFoLQm0bb2vQiLRJr
YVCEtCtwIYpEhXC50iZoUUGLCBRpEQVBUBbR2zfo9/DcxTBznjMzzzNzzqH5
SycvdkXECewA1igirlcixvFveyPeYQ0uVsAW+iJq5Mxm41tDEV/x+9gRclY5
PyM+xv3IsLFl4l7wT9WI3ymiG6sTN/Db+MfYCwScz+YZoG4Kkjdgf8l5Su3R
fvjqEc1+831GQ7PmuvXkGtWepkeL/B1yThG/HHLN+7p7aJ5dau9k91nEz2Xj
M6qlVws932o+C7+APwx+mfmHC5viR2BPsGvEI2AP4frSQ8+DEdOc74NPluhP
1im9ZwfNv5fNLQ33svVqJ9rXZvLs2kGbuA3+nXifnn3ElWQ+8W4l7085epdx
NDxAwxga5gaN/RlwbquzZ72h3lIz3M7m7e7M96Fq7oWKa/QfNjoca8lvKw3a
9S/OH4mrcJaFa+r4u9lz6P2PF+aaKjyzZj+Hv5n9Z15Tu1Rap/RqZ+rZ4LwI
/hytN/BjcE2Aj+J/1Pxvtomvctcm50ppXYpfhbVK863S86mPuH8mz9gD75ns
Gu31XzK33k3/VLH28B8rMW03
          "]], PolygonBox[CompressedData["
1:eJwtk01I1FEUxS9jNDNK5Py1efxnkMGFCEIbQUhs0651UCD0HW1zkyUtlGxR
lIi0CFq0qYiYRBhG2ggtSmgRA7VoEQVBkCZiHzuX/Q5nFg/Ovfe8e8+9973h
yzOnrhUiYoJzgHM6j/jQG3H0UMRqFlGvRsyVInqIHRuMOJjwlSM+wmkRn61F
tPsi+vDtwG33R3yCu4Fvgdh8zVh3dPdXBQ64yXmK/edwBK6YgzMGd5LzkHoN
fPvEBsh5HXuFMwUuJdd6R3yaWvfR+x38Ez0PwCeqvv8NTm9mTeK/Jv4E+xn3
3xRc/zm4U3ev0iztjW5/si9g36mZK423wevE18vOsTngHhSXbwfSX+z3BWv4
B07Uv1nyDGvgc2hs9FjTefBaclz5VsHHq+5V9U4y7+WK+R30T8N/mTwP1XiR
vBPt5pZmxt2FIxE/ip5PE/1nc+9qFNIjct3NjdXjPfDV7r5V40rumqqtHbXJ
v9Hv+Y5hDyX3LK0t7Bb2cu7ZK+cS+GLu2Snnpdw71W6leSRZg7jbxBeJN5P1
awavwL+Td6f+OtSa7+YfZ0dv2d9m5rvyKfa57pg0SuuZQb+dr+TYI9cQ83hc
tE+xrYq1q552oxqq9QXfLvxiZiy9ensTud+O5qNdlDPn1n711jRjzVp/4Aa9
rmXelfrXX/oPkrR6cQ==
          "]]}]}, 
      {RGBColor[0.9675, 0.7887500000000001, 0.49924999999999997`], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkLtOAkEYhU+kASGBtdnsShYN2GhC72vYUejKqi0+A2rinZdA1ACuidJa
Gmqw95JYIYlIRelHZoo/38mZ/5yZzGp0uFVbkBQwCabjSnFKasNvR3pEP6DP
PWm0KL0uSTvoAXobRswQ/Yw/y0onaWnTl0pkymSL8MxmT+G6b/xfdkPb80S2
ant24Rf3dtm5I3u8LL3QeUTukrMfdi5g1zVvi+Ef846ewFvXZO/hDdNBN+GH
Y3rmfVO7n+HePjOm85rOSk7K4yc5v/KM34A9dt7Q++i6b3tgy/Z/0h2gN9Ar
cM8z+wcwzBm/gL9m/2T+B//9mzt+
          "]], 
         PolygonBox[{{4909, 2864, 2770, 6498}, {6496, 2770, 2864, 6611}, {
          6611, 2864, 2347, 4191}, {6049, 3313, 2475, 6052}, {7044, 3313, 
          3005, 4575}, {6788, 3006, 2350, 5924}, {5920, 2347, 2864, 4909}, {
          4576, 2475, 3313, 7044}, {6786, 3005, 3006, 6788}, {4079, 2350, 
          3006, 4193}, {4193, 3006, 3005, 6785}, {6787, 3005, 3313, 6049}}], 
         PolygonBox[CompressedData["
1:eJwtkM0qBFAUx//JhBmFabhzJZKslAUbyjTzDBZjhXxteQQWCvl4CTFqxii8
AtbMXokiLPAEfrdzFr/Ouef8zz0fo6tb85ttkgYgA/04BbgIUqNLeumTdqK0
DSfwnZUe8tIdfOLvE2tHm4FYkIqwFy13gL1G94i/hP/Ovx8whnaSv8eD9Uo9
F8hXYQNa6G+pu4En/BXPJU1EW4QmtVf88cZ8Fd5lmB2UdnPSDPbS8w3sFJpp
OPb5j6LNmeYtEZ+DH3TP6P98l7TTCEwQG8au+1xr2B7qeqE7bzW/wfpXfL+0
ZyexIXId2Ht0X9Qe+h3TPWt+3/Ng/Us+Y5r1lFid3FmwPqnfYrQ7LmNf0TTJ
14PdIt3kH9uwPBE=
          "]]}]}, 
      {RGBColor[0.9791666666666667, 0.8179166666666667, 0.5354166666666667], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUj0vREEUvdj1dtmEfcx7GUJ8JRoqjUai8Qc0Es0mokUhUdtdjQK1j2IF
UWlQqTT4A6JFbKGwIoLoOCdnisnMnbn3nHPPncGFldnlZjObwWrBqkRmG1iH
CMrYPwpm1YzZvTf7QbzvzKLUbAl3r4nZeatZX95sGfFbpJhvj0WzGjA2erF6
hFHBnk+VP4S9gPgbNXvArCP/CPkemFXc/UaqYT1xnvDenpWGddxvQs8VuHy3
2YLX23iXNE+0q+a5qD4cMFuccI+9uKlhvtPsBOdX4Ewgd86rj4vYrNnJiySR
RnKR9xP5XzhPIb/k1W8nNKzmhFMLfOQdRu42cBqoryM3mwrjBvj94ZwN/Gs5
9U+eMWgrZ6SXHhBr10kHPaPv9PgcOAdOnnA+pbzO9MKcvHjw4ucde6uHeMdp
ztUw65E0+A38u1j8617zJw77ohf0pAm17x3quaNHflQCDr3nfS3Mkj29FOUX
805TaSLmH3wbzakvetFokzbq5CypeQD5k+C4Bs50Iq/p+aLXzOjdWSqt1Hwb
K4/5hVj/qBx83ImkgW/0idzk5V8gN3nJTx/Jzd7YS5zo39CrjNOf45y2cHcZ
q45/5x9nTHZy
          "]], PolygonBox[CompressedData["
1:eJwlkTsvw2EUxh9t0WqTXvTVlBANiUUMDD6C3WipNFY1SMy0FkN1dkuIiMlS
ncRgEfEZDC4xGFQaQWz8Ts5w0vP+z3PrOaXK2mI1IqlExaiJgnQSleo8Julr
w953U/yOSBd8e+uTTsG8ZqUn6jjq386YNYrSFf0WnLucdE91BqTRhJRg/pCR
yvSdfmk3SC3mq2BbcMpwc0PSelyaS0qzg9JfHi2wv9QR+FvwmzH32Cn6N5vV
qSj9StG1qmDaYMfxTPY6Z4x+H8w32Ck8ZtBPgbkh/xecT+aXOecap4JWO+N6
73AawTnG/eF9GDyjZbWM4t1NSxtx38c82Rfyrt1knma+jN50wvNf07+wv21m
NSrC/CC4tu3IdrWU8d1ZBstiN7Bb2M4fs+5hXrazD7zPC+5nN3zOuod52X/e
QzsWfFfmad7N4LewG9mteoJnMQ3L/g851FLt
          "]]}]}, 
      {RGBColor[0.9908333333333333, 0.8470833333333334, 0.5715833333333333], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUjtPm0EQHBtHivnw8+N4WKbIDwAFyxZtJEKo0lBSgaHGNBS0kRJoeFUI
HJqIREqRLiV/IC1SFEU0kZFNh6w06XBmNFecdm9vd3Zm9160O2s7WQCveMZ4
fheANwlwngFGdfsPs8Bd2bFuAPYZ+8e8vefAFe9D1o0mgW954O8E8IlAv1jT
Yl4rBTZpp4vAH+b9ZLzB+yLj7cRvE8+Az4yPxoFeFfg6bawP7N9n/DVzOqm5
LEZuso1Yu5w4R3H1R2IOY5GbOG4xNkMO0iqc04Ix7qvO/8I+S5N+H5aAm7L5
btB+57mlv07bqxg7R8xV5jOEDP0m+fWJgzngYzCvhdRH/iVjh3XP7T1tnhrf
5YAfVc9ReoUrjDPmNKMm7UO6thNrKBKrFNxX/bUL1et+FMxTfIfU85Zvx+w/
n7evfru8r9Af8P0m8ZtqHkvWrhlcBGvXDLLBvKT7adw70ky7cX/FmjWJv3gc
B/PVf5EO/YFmnHcj7g/BOhqpZy9c9RD2IDH+y7hv/UHNSNxPgv+Eeh3UPatm
zFddP/rStxz1XqWeXaXmfupbnXJdK85TO1PtNXP+A2w9afU=
          "]], 
         PolygonBox[CompressedData["
1:eJwtkrlOW2EQhQ+bBFxjwBebGGigBcQS8wQQujQp0wWoWQoKuigSgoqlQmwN
sZEoeAMegBqxKB2KY9JFiCYd8B3NLUaamTNz5sz8//DCypflZkljWCs2lUrT
ibTXhT8kbWL/8TfIjQ5IeWwBP9cmTVC7BX7ZETXb+N3gi+Dm/NctvfVJz/gV
cvdl6SM9eXpniB+I14h/0TtH3CCeSQPbJzc9FDM8y5ruwLvg/5aEhmOwpqLU
A/96u1QqkSM+aEI7+C31vdQvJTHTs4f7pXH0XpH7DrY5KL3kYocLsFb6z1qk
106pWg6OqWzfE7Bd7AeHmiX3pxxm3zN3wM6JlQSnua3J2szZDH5diP7P1DxT
e1QMbu+UQ0+hFFp9Q9+yijXwn7DaQGiyNt+0hd6VNG5nDXWwkWw/z+jA30lj
lnPe3W9Qye4h3y57L9/olNoT7EM+csa+ctwbRb+5f2bzvWOdXY6o78+Hfr9N
LnufR0oOi6HZ2t/oqZXjTf223qlC7+9CYOY09xP2KQn9vtVf4vkk/oj/iv+k
/6Zzk2ns7N3ds0r8Dqb5XA8=
          "]]}]}, 
      {RGBColor[1., 0.878, 0.615], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlMtLVVEUxpfl7QGee8ybyDnuibMi6B2RoX9Ec0EaltcHQaUlWRE1atxz
ZAk3peiPiCyqWRjWoJcaNrgaRI9R38+1oMFm77POWt9e37e+c3pOjpwY3mRm
o1qbtYZys9XMrFExmyrNprX3dJl97TCbbTVbL8zWtH5tNZtXrLfNzz9bzA7X
zHLlH0xmC9p3bTO7pfjD0vEeaJ/Su7268MNOs7eF5+xTXbfuPS6sMeUd0vNu
xXeUjs0dAxWvoXap0+yScNbU52Xt7yqef7vFe4dDm/Kmhf9IPX9Wn3PKmdVa
F8dGl5+vdau3wnujx0lhfVf9uPYx9TCo+Irev9Rzf9XsTfJ+0AS+f5T7O3Os
DfxWv4/cPq2zoR35N4X3Q1h9282OKvZedYuZ11wNLnDqVd0xrTOqWSicF3rs
18oUO6CcieT81trNmpnXchfc6Z/aeu53kIe+6FwVx49VrwGLPuhnpnQM4uhL
LRrSHzOG83Lh+GAz48XQuRG8eYZ7Pfkzfhmt+dy+qPZT1evz4LDBRe/Ha977
FcXO1xz/os5P8cQWs2+adbPis9jA6vB7mO1Kp/vlnHL3iMMEM1Xt/Zp7or10
T+Ef5oVe6HE6+eyZ20zh9eA8Vvxuzb2bla7lamiIlvXQBH/D44hylwrvDb+M
h38uJMfGG/iNHa9MhE/QHI2I/Y34s5j9i+R84c4smD9+wNtowzkPTdFjRPee
St7fsPYbyTGvJ+ePDveU8zzwuedV+Blfv06uP3NYjO8efZvhKebEGd/As8y9
v4GYCWf6RC90uxNew/98++z9cQaP5yz4UTsWmHz/nOeT88QLzXhHnDmSwyzB
4I4s9ECjPPocjH6eJK9ZVV/LnX4fnhoKrdAM/9bjXwF2Gfhg9obmzGou/ht4
AR83Kv+/ebSihlo0+QdRmMUh
          "]], PolygonBox[CompressedData["
1:eJwlkUsrxGEUxh/yd6mZwWjSf7yKHRtRbIgPYa9kixlSFoNyyWVlTbJyqTHF
J7B1yWWnUTYuzYxYuJTEht/bWZx6nvOc91yet3UkPZgql9RCVBAnTtosk3pj
0il4P5RygXSA+BSXlsll4L9RaQ2cIu7AOfRx8Cwxhf5Kbg484wxHGJLx/ZJS
f430wazjOqlE/2Hq75n3h15ISB3UNlVKRfCos7d+xhj4gthgvwHqL8GLxDTv
39GXwKvOdvshVsAx5rVVS3lqthos5zV/U7ZRqkdvR7+Fb6MvOOvld5gHr5Pb
QfuuIs+uh+Qm4X0R6QjchR4NbMYNeg+8NrCeeXgaPhTYjQX4c8Ju8z1K4HNn
XnvPzsDXzm7zN12Bi6HN9j0m6PURmtfew8/QPPPe+R060R/j9ldZ+B66mqWH
mO3Ujf6StN2/8PAN/3eTVutrfO0/PXNTYA==
          "]]}]}, 
      {RGBColor[1., 0.95, 0.75], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1Ur1KA2EQ3DMYDyQSkBSGbezERrBV0DpqirzBCdqYRDiEgD+g5xv4EBYW
+gS2/uBPZ6eFhUZE0eQJnGHW4mN39mZ3Z4ebXt9udUfMbB6vhNcBOEGSIM9H
zRqpWRu14ZRZc9xsgPheM1tB/Q2x7WbPFbMtxMlUnDP0PZVVz5BvjonPeYwb
kXfQ8wJO11VbjXoTcYh6D3lSFi4oEvlaKo036FmcMLuNvdw5h/oD8DLqj4jH
rjmF66YsOBfAs+Ccu+5j/otv18ALyK8QD/C+0bvv2sl8B5x74CVw7ly6qJHa
viq6mRw+7qPOQUX398JL7qGfvJu6qenQxTtyYdapk3s5i3Muq2Z9eHtal0+N
8IoekEdvZkqa/QrYr4n3gfhT1d7Pujh5aKAm4iJy6vzHjJyz67ptLzykLv4b
5ObRz7uzuJne05ckvOA31v8Am69R0g==
          "]], PolygonBox[CompressedData["
1:eJwlkM0ug2EUhIdofUnziSiR8m5s3YAFCWvUwh2QsGirNpKqn/i7FwsL4iLE
T7CzY4dKQ0KvwDM5i0nmnPOeOfPO1Pr2arNf0iQYAN0J6bcgTQ9JV0l6Bgvw
vqL0AD8Bf7nU4s0RfB98U+9Qt+HvI1I5k97obVHfgzn2xf4N/GtMWma+Aa7L
3BqWXoqhscd8l141i5076jb1ShYenqgvU3hbpNdido7fTkm64P7MuFRn/pqH
prVPqXt5aFjLHu31h95hCg1r2VMHbx9gCb45iM5oeLRX9z6Z1dhZK8SNhrOo
oF2KP/vvzshZzePxMYUne/ObXiUyc3b2dAZvpsjKmtb2Td92xscpMnN2s+jd
wg9SeHdGzuof/VFFJA==
          "]]}]}}, {{}, 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4285, 6822, 5943, 6642, 6641, 4836, 7277, 7278, 7274, 7276, 
          7275, 4336, 7290, 7291, 7289, 7293, 7292, 4984, 7368, 7369, 7365, 
          7367, 7366}], 
         LineBox[{4335, 6890, 7343, 7342, 4983, 5607, 5608, 5041, 5606, 5605, 
          5340, 7296, 7297, 7295, 7299, 7298, 4985, 7373, 7374, 7370, 7372, 
          7371}]},
        "70.`"],
       Annotation[#, 70., "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{5018, 6669, 5019, 6670, 4911, 6613, 4913, 7217, 4912, 7423, 
          6631, 4977, 6629, 4975, 6627, 4976, 6630, 4808, 6640, 5006, 5921, 
          6784}], LineBox[{5020, 6672, 5021, 6673, 4915, 6615, 4917, 7218, 
          4916, 7424, 6820, 6821, 6565, 4834, 6563, 4835, 6566, 7045, 6057, 
          7302, 7303, 7304, 7301, 6699}]},
        "66.5`"],
       Annotation[#, 66.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4080, 5175, 4078, 6671, 5650, 4914, 5376, 6614, 5375, 5533, 
          5379, 6564, 5380, 4578, 5378, 5654, 5377, 5191, 5391}], 
         LineBox[{4192, 4284, 5529, 6668, 5530, 4910, 5532, 6612, 5531, 4315, 
          5518, 6628, 5519, 4809, 5897, 5922, 4186, 4276, 5517}]},
        "63.`"],
       Annotation[#, 63., "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4579, 5657, 4580, 6061, 4403, 6053, 4576, 7044, 4575, 7043, 
          6786, 6788, 5924, 5923, 5653, 4577, 6055, 4413, 6130, 4620, 5696, 
          6712}], LineBox[{4806, 6528, 4807, 6541, 5145, 6537, 4805, 5893, 
          5918, 5920, 4909, 6498, 4787, 6487, 4788, 6500, 5136, 6495, 4786, 
          5864, 5895}]},
        "59.5`"],
       Annotation[#, 59.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4088, 6713, 5695, 6129, 6128, 4412, 6054, 6056, 5652, 5925, 
          6698, 4079, 4193, 6785, 6787, 6049, 6052, 6051, 4402, 6060, 6062, 
          5656, 6059, 6058}], 
         LineBox[{4185, 5896, 5863, 6494, 6493, 5135, 6499, 6501, 6486, 6497, 
          6496, 6611, 4191, 5919, 5892, 6536, 6535, 5144, 6540, 6542, 6527, 
          6539, 6538}]},
        "56.`"],
       Annotation[#, 56., "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4638, 5405, 5206, 6125, 4617, 5697, 4618, 6126, 5069, 6123, 
          4615, 5651, 5691, 5692, 5192, 6067, 4584, 6050, 4585, 6068, 5060, 
          6065, 4582, 5655, 5658, 5659, 5176, 5663, 5662}], 
         LineBox[{4762, 5503, 4266, 6774, 6773, 5865, 4765, 6453, 4494, 6489, 
          4782, 6485, 4780, 7117, 4275, 6783, 6782, 5894, 4785, 6492, 4502, 
          6530, 4804, 6526, 4802, 7125, 4283, 5917, 5916}]},
        "52.5`"],
       Annotation[#, 52.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4101, 6725, 5722, 6176, 6175, 4426, 6127, 4619, 5694, 6710, 
          6711, 4201, 7053, 4614, 6121, 4616, 6124, 4414, 6069, 4586, 5661, 
          6700, 6701, 4194, 7046, 4581, 6063, 4583, 6066, 4404, 6072, 6073, 
          5665, 6071, 6070}], 
         LineBox[{4174, 5862, 5846, 6450, 6449, 5123, 6452, 4764, 6438, 4763, 
          6451, 5324, 5891, 5890, 5860, 4781, 6488, 5134, 6491, 4784, 6477, 
          4783, 6490, 5339, 5915, 5914, 5888, 4803, 6529, 5143, 6533, 6534, 
          6521, 6532, 6531}]},
        "49.`"],
       Annotation[#, 49., "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4654, 5417, 5218, 6170, 6171, 5723, 6173, 6172, 5077, 6168, 
          6169, 5693, 5719, 4100, 5207, 6139, 6140, 6122, 6142, 6141, 5070, 
          6134, 6135, 5660, 5698, 4089, 5193, 6079, 6080, 6064, 6082, 6081, 
          5061, 6076, 6077, 5664, 5666, 4081, 5177, 5670, 5669}], 
         LineBox[{4739, 5497, 4259, 4166, 6768, 5847, 6406, 6405, 4485, 6439, 
          6440, 6437, 7111, 7110, 4265, 4173, 6772, 5861, 6448, 6447, 4493, 
          6481, 6482, 6476, 7116, 7115, 4274, 4184, 6781, 5889, 6484, 6483, 
          4501, 6523, 6524, 6520, 7124, 7123, 4282, 5913, 5912}]},
        "45.5`"],
       Annotation[#, 45.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4590, 5672, 4591, 6083, 4405, 6078, 4588, 6074, 4587, 7047, 
          4195, 5668, 5667, 5196, 4589, 5382, 4416, 6138, 4622, 6132, 4621, 
          7055, 4203, 6715, 6714, 5701, 4623, 6144, 4428, 5404, 4636, 5208, 
          4635, 5402, 4209, 6724, 6723, 5721, 4637, 6174, 4434, 6212, 4655, 
          5742, 6730}], 
         LineBox[{4800, 6512, 4801, 6525, 5142, 6522, 4799, 5883, 5910, 5911, 
          5338, 5514, 4778, 5321, 4779, 5516, 5133, 6480, 4777, 5856, 5885, 
          5887, 5323, 6443, 4760, 6428, 4761, 6445, 5122, 5502, 4759, 5305, 
          5858, 5859, 5308, 6403, 4741, 6398, 4742, 6404, 5117, 6402, 4740, 
          5826, 5845}]},
        "42.`"],
       Annotation[#, 42., "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4670, 5426, 5231, 6207, 6208, 5743, 6210, 6209, 5085, 6204, 
          6205, 5720, 5739, 4109, 5219, 5406, 5407, 5210, 5409, 4429, 5403, 
          4427, 6143, 6145, 5700, 6716, 4090, 4202, 7054, 7056, 6131, 6137, 
          6136, 4415, 5381, 4417, 5394, 5195, 5703, 4091, 5197, 6089, 6090, 
          6075, 6092, 6091, 5062, 6086, 6087, 5671, 5673, 4082, 5178, 5677, 
          5676}], LineBox[{4724, 5477, 4253, 4159, 6762, 5827, 6381, 6380, 
          4477, 6400, 6401, 6397, 7099, 7098, 4258, 4165, 5844, 5307, 5496, 
          4484, 5501, 5121, 6444, 6446, 6427, 6442, 6441, 5322, 4183, 5886, 
          5855, 6479, 6478, 5132, 5515, 4492, 5512, 5320, 5511, 5510, 4273, 
          4182, 6780, 5884, 6475, 6474, 4500, 6514, 6515, 6511, 7122, 7121, 
          4281, 5909, 5908}]},
        "38.5`"],
       Annotation[#, 38.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4119, 6739, 5760, 6252, 6251, 4441, 6211, 4653, 5741, 6728, 
          6729, 4215, 7064, 4651, 6202, 4652, 6206, 4435, 5220, 4640, 5209, 
          4641, 5408, 5078, 6179, 4639, 5699, 5724, 5725, 5211, 6146, 4625, 
          6133, 4626, 6147, 5071, 5395, 4624, 5194, 5702, 5198, 4418, 6093, 
          4594, 5675, 6702, 6703, 4196, 7048, 4592, 6084, 4593, 6088, 4406, 
          6096, 6097, 5679, 6095, 6094}], 
         LineBox[{4158, 5825, 5807, 6377, 6376, 5111, 6379, 4726, 6368, 4725, 
          6378, 5299, 5842, 5841, 5823, 4737, 6399, 5115, 5116, 5843, 5306, 
          4738, 5495, 4483, 6431, 4757, 6426, 4756, 7109, 4264, 6771, 6770, 
          5857, 4758, 6436, 4491, 5513, 4774, 5319, 4773, 5131, 5130, 6473, 
          4776, 6464, 4775, 6472, 5337, 5907, 5906, 5880, 4798, 6513, 5141, 
          6518, 6519, 6507, 6517, 6516}]},
        "35.`"],
       Annotation[#, 35., "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4597, 5182, 4598, 5180, 5179, 5681, 5680, 5678, 4595, 6100, 
          5063, 6105, 6106, 6085, 6104, 6103, 5201, 4093, 5706, 5674, 6153, 
          6152, 5072, 5397, 4419, 5199, 5393, 5392, 4204, 4092, 6717, 5705, 
          6149, 6148, 4430, 6180, 6181, 6177, 7062, 7061, 4210, 4102, 5726, 
          5222, 4436, 5418, 5086, 6215, 6216, 6203, 6214, 6213, 5232, 4117, 
          5757, 5740, 6245, 6244, 5090, 6248, 4669, 5761, 4668, 6247, 5238, 
          5239, 4680, 5240, 5772}], 
         LineBox[{4796, 5335, 4797, 5140, 4280, 7120, 4794, 6506, 4795, 6510, 
          4499, 6470, 6471, 5881, 6779, 4180, 4272, 7113, 7114, 6463, 6467, 
          6466, 4489, 5500, 4490, 5316, 5882, 4181, 5318, 6432, 6433, 6424, 
          6435, 6434, 5120, 6429, 6430, 5839, 5854, 4172, 5304, 5493, 5494, 
          5298, 4476, 5491, 4475, 6374, 6375, 5824, 6761, 4157, 4252, 7095, 
          7096, 6367, 6371, 6370, 4471, 6334, 4714, 5808, 6756, 6757, 4246, 
          5106, 4713, 5279, 5806}]},
        "31.5`"],
       Annotation[#, 31.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4084, 5183, 4083, 5684, 5181, 4408, 5383, 4407, 6101, 6102, 
          6098, 7050, 7049, 4197, 6705, 6704, 5683, 4596, 6107, 4420, 6154, 
          4628, 6150, 4627, 7057, 4205, 5073, 4630, 5200, 4629, 5396, 5212, 
          5728, 5727, 5704, 4642, 6182, 5079, 6184, 4644, 6178, 4643, 6183, 
          5223, 5745, 5744, 5221, 4656, 5087, 4216, 6732, 6731, 5747, 4657, 
          6217, 4442, 6246, 4667, 6242, 4666, 7072, 4221, 4118, 6738, 5759, 
          6250, 6249, 4448, 5433, 4449, 5241, 5432, 5431, 5250, 5445}], 
         LineBox[{4189, 4279, 5524, 5525, 5334, 4498, 5528, 5139, 6508, 6509, 
          5876, 5905, 4190, 5336, 6468, 4771, 6458, 4772, 6469, 5129, 6465, 
          4770, 5850, 5878, 5879, 5314, 5315, 4755, 5317, 5852, 5853, 4263, 
          7108, 4753, 6423, 4754, 6425, 4482, 6396, 4736, 5840, 6766, 6767, 
          4257, 5490, 4734, 5297, 4735, 5296, 5295, 6372, 4722, 6359, 4723, 
          6373, 5110, 6369, 4721, 5804, 5821, 5822, 5285, 6330, 6331, 6322, 
          6333, 6332, 5105, 5473, 4466, 5280, 5796, 4143, 4241, 5464}]},
        "28.`"],
       Annotation[#, 28., "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwNz7svg1EcBuCfqSVEb2iYXLZ2stlKpB3c6lskBFGJy6K0JoPBZyCN/8vM
YhAk4k9wnTzDk/ec3/eec/JNttrJSV9EbPA1HLFQiviUNTnPwEhEP3P5iJex
iB/5LL9lbyLiIBdxX4z4s380/5WvMnF2eTRiiVmGyhGDPOgWZJEMeXLs6mfd
1dLdo2pW4Ul/2vsz7OhsM2Xd1c1wZH9M1azCm37TuXVWWGOVM52y/pW7O5ya
tXnX78pz9qkVfJcX+rd6N1xSN//QTd2xNR6xSc+8YZ7qH/rvuvcbXDubsmh9
JxP5D0TYLSM=
          "]], LineBox[CompressedData["
1:eJwNzr0ug2EUB/DjBnjban1NXd2BBBdAYrAIoUMNamk1EYluNolJfCaiWGwl
In1pYmIx+0oQrsBgsfsNv5znOc//PectlmvT1a6ImGE+iUjZzkc89UY8c+C8
T9Z5eSCik434LUT09EUkvOi/cqb/p78+GNHg0pzHoYhT/RHfjTPGZiYirxb4
lK/LTsiecy//QLe3DAkb8iv210ntaTMpe6Ou6rXUC2rOVRryX/0R39yZXzF/
VP6Ittkpb94+eGdN/lbt0JIvyy+yJ38tu+T/r7xV1KY9xzTdF9wP1ZJ6ov7k
Imbtn2NXZodhM7aY0vsHzl83/g==
          "]], 
         LineBox[{4347, 7402, 4570, 4568, 4611, 7415, 4610}], 
         LineBox[{4358, 7404, 4572, 4569, 4790, 7417, 4789}]},
        "24.5`"],
       Annotation[#, 24.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{4368, 5167, 4503, 5345, 6707, 6706, 4989, 7305, 4609, 7221, 
          4920, 7219, 4919, 7220, 4287, 7223, 4921, 7222, 4922, 7224, 4612, 
          7052, 4613, 6708, 6709, 5346, 4504, 5049, 5048}], 
         LineBox[{4401, 5174, 4551, 5372, 4971, 7266, 4972, 7267, 4970, 7269, 
          4974, 7268, 4973, 4310, 7260, 4965, 7259, 4966, 7261, 4964, 7341, 
          5033, 7340, 5032, 5367, 4542, 5057, 5056}], LineBox[CompressedData["

1:eJwVz7srhXEcx/GvTbk77iZlNqtjsSs6BsoipSxum8JCoijHOYOUMjBJKI5L
FmYdl434B2RxyYCB1xnefX7fz/N+vs/zaxkaT40VRcQwuqojOmsjliojWrFc
E7GCHl03XhIR2YaIfl5G9hXS89GqiA3zgHldHjZHHCBtRxu26yI2eZO8QXve
7DnhneIIORxjh5PkX/B3MWbfg/6L/ywnzHk5Lp/kHv+Gl8c5pvXf+h/+r5w1
f8oZ+VP4Bv+R94BrrOorGiP++DUybS6RCVTjit/rfz65H+jQJVGsX3CPRfe5
dJ53nsM+N4Wppoh3/pZ97fw13j2vvD7iVX+mH9FX6TLey+LO+RZp55wdZdxS
/AOaeUND
          "]], LineBox[CompressedData["
1:eJwV0EsrxHEUh/Fjp1zGfVxWFkMWLNwWo1gwo8TIzFgpyWUlpFBSNrKxwJgk
S94N70HJJd6BhevH4un7O+c859T/37m8ld+siIg1LDVELDRHXDZFzMlTeYai
dwHr9RGl1ohZXrklYrE94r0x4g3n+jn9E/0SUnURx3bT9kZw4L1if9h7We7y
93DELbrTxj/ETUfELTbMxtzblgv8vBxU7/Jn+Dns86+5/fpT5gNyWs7z+2S3
epWf5U5ih3/FT+n3mHfJ3v/v4TfJpDrHH+X+JCI2+Rf8MqrME6hFhl/pO7Ky
4Ltm7fzyi97PyYgXPODb/FXe+T/3+FQ/qr/kk0zLandqMGF3HB/uZOSwm0P4
A/N4NPI=
          "]]},
        "21.`"],
       Annotation[#, 21., "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwl1muQD1QYx/HDYtlFhGUXL0jl2uWFay8KM5WkJpNCmqix0rhMwlJL1qw1
yWWZzf2yNMaly6iw0SBC5DY1RXLdiSLWhl17wepzphdfv/M85/c85znnv///
aPXm2P5jqoUQEqr75/4QCpuGcK9hCH/RjakhbEBoEEL/lBAGNA7hWXvJTUJ4
hqY0C6EpmqCZ2rzmIYzlfSothCfxkppU+WHqhiJdPBz90Fb+UXUnG4XwOG0v
bk/b0cfoO/wZfBPxVjxb7mUU8g+ig9EXnfkH0nH8M/iyMR495TPkL/BPpr3F
Y2gvOolm8k/Bc+JscR+60fzZ5n/d7EMwR5+Z9nLwtvv2du+RNCfWWffBAe9z
EMt5l2EBBun1j3Nn67VSvAIL1YxRu0tNkb3Veq5BPt7gP6rHMfT17s+jH1L4
apqjFqqjBhLwvR639L5hfR0jW5gP560nusPPzmnY0udmXQ0J4um0Bk2g1TEN
H+JF57yA+chFoh439S/TvySusUXvzWjrDrvpHtRQWzOiZyn/IrOulF9MK/jK
8YsereNnL/enPhdwESf5P+EdqH4QdsjtxHvO76Dfu7Q9HUf30Dxa3306Wjfh
70THy+1VM5guwWIUe78Wci3R0bkd0MDbz3F+G+s/zHOXVuFzuVK+WyhDhZnK
7VdYl6PAfFvRifcHuhe1nJ0YcX45f22+pc5dhteQjyn2p6LS3u3YV8+pak/L
nUEmjqu/ZO8yJtibiNrydVDb3j69V8nlow5PMpLincz8MN1M8931LP85PCj3
ENbIrUZB/HuSP4YR4nTM03eLvrk005wfYJM+rWJv62QccdejWKn+qnfrLNcF
GTyf4gt3ydIjyWfRHGnYyZ9Kc/TNtpco7uK8rijS4xqKsUu+ntwcvRPpXFrl
/LV67jbnx+Ik+dm0Lp0W39h3433xYfWjnD8a+fzb+CfL37BfhluYzP8r/Q3b
+dN5R8TPh38z/6jYx97o+DZ0Av8mmi7+jH8o7zDk8Reba7j8avn12BC/2+Zf
xj9EfildgeW4wvuqe4/Sbz7PUt52eszCPP3mxndz/gB1X9JX6Cy+j9BLXT9x
VvxtVL9WPJxm6TsdM/XK9RYn1P2O2/4eKnFMzXFxgb3imBffsb6LCtxGJXbo
V2qOf81QHN9DbTpSnXGfujTaICpScVZcxX+F51T8vfPZ90IOZqBMz+t6lvBc
068I3/B+jRT+7fQ7VMnfw12+Sv479BF3LMJV7BE3pz293WG+IziKQ7yF9n6K
a7Qx0wPYaN3D+df0buyc+nJZ4unxuyfu4Z26Y5i4obiIr7v1BnWteFtjv/U+
nNZ/v3MOWh/Aj+hijjTz7LR3jp5HrtxifebRJbRYzU37V/mv4Cu5TajvvG/p
NtyJd0ZlfJ/4G+29pphjKrphFU7wX+a9wXPG+nr8TpmvHpLFdWkSzeCZhKSY
j78Nclv1XCi3CDf1LkUJLvr819N1OM9biPXmOMW3jnbzNl1xyfl/47A7Fej1
hJ5Px9/D+KbiEWY51Oj//wf8BwSxQwg=
          "]]},
        "17.5`"],
       Annotation[#, 17.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwl1XtM11UYx/FjqasNMS9xV6ysiXmhBKtVdt1q3gknmijaLMArW66ZbcLa
nHLJS1pqmSTUStAKkPKShfZHQllCWxYGgTkz1EpntWq1Xt/1x5vPOc/5PM9z
zvmd348bnlj+2LJeIYRaf/oNCCEvPoQYOp+WoBi9rgvhgaQQHsTexBBOJ4fQ
MzCEd4x/pHvoT7SWnqPlKSFUoAyrB4WQcH0IidhpvEusGlX4NIqhSf179Lkb
Z+XHi8WhSHxGXAjZuCshhCRr+/RoRAN+MS+wlo/pGMdzO9r1uYPeiQyMRyaW
DA6hv5rP8i42znHOm/WZSWdaz0E2XnW+V7CKNxbTnHulnFxrc5DLP07eXPq0
OpnGGVhtnMq/gXc9SnnX4az9lNMKrMEk+y6jfcWbnOMojiBLvFWd6fRRWqrW
LdiiVj/eie7ngL0cF6u1vjfyuscsTMNsnpNiX+N7vk7MlZNA45FjfSrfLHpK
v1jj45Gat9DP8Rk68IK89WjQux51uNF5U9zLEGxVbxu22st4TBKbjImYiikY
zn/ZXm6iGe7mMi5ht76JcpMwwzgbufbQqe8IsTbz7ea/R7n87XSBeZq1RjrP
vi7ouUp8rbv6UK+PcBhH9Krg6T3EndMSnpO8XWoON8+Wu0+sS953NF/sH/ov
eutVy9th/Jfx39FnizFq/iE2lubrUYCFeApPYo6cRXQxCrEUS5DOP8C9HdXj
E/RRaw/vPHvpjr5HaEW6+Ujrbcbd9tWpV0F0Brl95Zw3v4D+5rFIExuJmqim
c9bSQuSpswDz8Y0+DXK+pbOdeRZu5emRnyV2WP5z0RvT7xQtozv1r0QGb5W7
3oWB6q+z9rHzNOFa69eg2Nl+9YYv4Vj0feJ9SN1KFKq3CDV6rORbavyn3ld4
f0Mzfwsejt4xzwmxVnyJr9CGK/wL5a2QX83zFn8m/2bU2Uc93uarwW4U8b1E
X0YVb7oz3Ia86I3a73a0u5dt9HHn2cJXyfc6Nqo/Wa8p6KPvI/Ia5bXoVSPW
TM9Fv3EYJp6KYr7B9E06iL5BN6lfQjfSzXgRo9UahVY9N8k/QQ/Rq/n204M4
gKF6PI9ytcoQ496To/fjnCl0nRqlWIvXsAMrrI3GGIyK3hvGIiH6bOz7oB6H
cN75ehCj/jNIkzsCX9jLBr2P02r+CWL385+x7y6+luh3hP5gXim+Q90JtNu8
Q7zZeic9bX6f+L3y94tdVK9e3Z/pu7QO7+GqqJZ9nMEH/O/jYvSu1U2172EY
iiIsxzHxAjnLjNdEv2E0Lvn//1P/Aa23/U4=
          "]]},
        "14.`"],
       Annotation[#, 14., "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwl1F1MlmUcx/GrbEPUFvIgoOaBETyQUpoHLYW22DpwtaFNNF8ABStDhSM6
QNO2nKbLuSmwQYmlbuVA3WzzpQRqvCkepAYVykZLxWnw0HJr9rLV514HX7/3
fV2///96uR+cW1HzevUjIYRa/9yZHcJYagi3+Fe+zUtiISx+MoQXsXtWCEun
h5BpPJX/nhHCP1iYFsIC3EFySggXjH2F+7iH3/T6mvv5CLfp04q7+oxiv965
xn9Re9X4dyiyboHxZdapzQjhTbyFCmxEJc7ODGG6mq3WrUZcjxy8oaYsM4Ry
lOKwNT7BNtkULNO/Lj2EDebWo0x+G29HHY7LHsNO2Vkokd8tv8Pce9goX2Cd
Qrxv3Z14yXOf/cTlG2UbsMke38a7qFLzSnQe5xrS70Z0ftnr6kb5R+8/YbJM
Es56bjOXPsece+vVO0ltF/egG8OYiO5efYe5YM1/1cy11mz7r+F6fRrQiIVy
GXrHZNM5jTP5pv435Ye5Sa4ZH+OF6K6Mn9enmC/wcs7mLc5Uja04gLroftHi
OcWeL8qs8t7O3+B363TygJ4D/If3Qd6BT621RnYtSrEODfocxCGkeY8hV3Y9
d0ffl7u4nIv1nKdfjvM8w3Gez9n8HOdxfvQb42ejbyBfoa5H/Qbu5UrO42nu
8HF0yi6VO47Vakbc9c/Ii/ogy/xV7yPu7Iw7r/A+Rd1UfBnNyZzhazyuRysn
+K6zjqLS3BpjK51vglfxCpSgR49FPGT8ZTUt2GSNZPeaic998xn8BW8xvhkP
9Uv4bU6gV30fitSdkLlk7DL6cAX9eCDfE2VxTvY8FssflW8zdhKtOI1TSMiX
WacczTJNyJc/gIPOcwjv2PNmTLW3Kh53P2N4yly9s+zSI8vz04irv6823XNC
pgGNqMcP7vSEdQa50/tj6i5yB9qRpW4P9qv9CM/rNdmaiyI7RxLm+Jb77KGN
C33bVn5C5ob6Yv3Gjf2p/xj/xQl+yEPmXzNfZL+vckxNqjWORb8tmc/0yeOj
PI8zeLv1PrDWQPQ3ZV+7ojvgveo+xB4sj37nOIJvzV3mB/L93IK4Xoc5l6eY
r9JzEq/kEsTM5Zhr5mxu4iXqC+1rAN/jUbkCvuTurqT+///5fxNN3Ec=
          "]]},
        "10.5`"],
       Annotation[#, 10.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwl1Edsz2Ecx/GnROJAVKnZ0hrtQRAjuKClqma0KBckCBEJLmImhEjsmdir
tP/aJbGChA7iUEKE1IrYxcl2ELyeOLz7eb7z+f6eftvM6fOL5iWFEAb58aF9
CF9SQqinn+nAtBCGtghhYXIIdW1DyG4dQhbmtAohtXkIveX1QS8cZR+iA9Qd
pP1pz9QQ+tFyfUr0KaUJlOGuWCly9cvBYHyT24OvO5a7MwWF7UJY5r5h4nm4
xXeOb2WbENLS+dWscM6jZe5dKT5JvBgJ9nEcQzny1Z/nvy1ns5ot2IRTYiex
hj8DW93X2LwF8i/Jvxx7makcw81egHyMlzOCFtIHYvVq37OL2BXeI0fPIchF
BjuFdqRNzb1Vz23YpKYbktU1U9eMJtPmtM43ndH3MX2s9gl9EucUbyueSq/o
cRXXUCH3LJ7L288+gIMYoP/Xlt4X69Q0dP9aOkvuA7EXerVjZ4pPofXsT/yz
xRfp9Yu9mP4Q/47hYp340mINTafVcqtQ6b4buI4O/J3F19MuNINW8VejRm5H
djZ/J9qVZtKs+L767/T2u7Ag7pw3m0+z6RK6FL3RXp8T8svVvXR+hTp9p7In
80+jE+kkFOOhvpXiRWoLMS72kFPj950jlvBtlfahCjdQg2rst/sHcN15rnc4
L/8CLqJETYJ/Rtw/OjPuO90nfy+OOpeiTG4Cfd2zW81EcxSjSdwhc/yR+xdJ
viGgVt4oM4/GyDi/vDF0gv6j1K1iN/B7XE17qu+BxViEDt5pl7t2Yw828m3A
UPV5CEhS99cuNaBJ0Ud/0x003XyN1I11vueuR+Z5iJ/u/qSmwvls3F/xX2be
TvfGOWkOHUFz6RF6jNbr9yHujvpn7Brfdk3fm/Q5+wd/mniB/Hfst/x3xN/Q
t+zD/O/F36E2/g2yn+Fp3GVz5tMj/CU4Y67T+GjOr/red36tz2B9hskbFN+A
HpZbm/L/f94/50u9aA==
          "]]},
        "7.`"],
       Annotation[#, 7., "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwl1ElsTlEUwPFbQ6VForRKR5UQwcJMEZWYFzY1xFARtVedzJsmolaV1BzE
xlASYw2JObGwKG31qyFBjRsk0tKa2/q9WPz7v+fec8899733NaewKH9DXAgh
wZ/apBAa0ZERQgMfTA7hGreJr/MlzEkP4SLP5bEDQqjC/kEhHJFzDEeRJE7m
FAyMEA/iOrnZalaIEwaHMMJ4JE6JU9JC+DQ0hM/Yi+aBIVRzjGtSQmji3mrE
owd6oSeGq7kL59S4JT7P7+S/RdBnHs9Gmfk4Z97i21jpvBXItLcCfTLVxpjU
EFJ5NCfzWjVmuutZnsFn+L78EuM642J+yKV8gifxFExGhrxt0d05prdcdxiv
l3HoNvea36BUTpH1Et7IXzyTdOtf1fiGNnSgHX/VuGNPrd4vo1Pcan6PfVXR
e7PWbD6GJixWs1y9MvyV1y3/D3ehM7L4F//Gd/zED7ySn6OHacYn3Wsqn+J6
tDvnET+Inju3Rs+da5Ar7zRP5zzMQotao+Q+kbfEeflI1FenOIErre/GMuMX
en6JV2h2l4/2FXgXT4yXWo/3DrPk7jPusr8v9+P+Ua0oRiLy0Spvgv1Pjdc5
c40aBYjT33v+gE32F1sv5xIuQ2kU63sBFmI+rtizlG9yPt/gJVyv/hZuEm/m
GG/lUj7uDsuMD8lZzhec0aD2dt7JO/gu30OW3Dt8O/q+7S3U23pUynkefTtq
HEaqODPKRxoykI4W97skf4j1bPFQHsaN9rSbf8wt4gPRvOfSIF4V/SZ846u5
0P5d/EzORGvVuKqPRfq+zPPS//9/+AeU1Z9s
          "]]},
        "3.5`"],
       Annotation[#, 3.5, "Tooltip"]& ], {}, {}}}], {{{}, {}, 
     TagBox[
      {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
       LineBox[CompressedData["
1:eJw12Hk01U38B3Bc936R3Ju0eEiocJFUIhXzVahHjyWVpYUspYcUsj7WZJeS
RJakVJbKnp0ZW/aIG9llj2vLLq7f93fO7/fX97zOmTNn5jvvz8ycETO/p3+T
g42NjZ+dje1/v3Jg58TmJhXZeMkyNjfp+L3VfUGra1R0KU+na36RjmfmHJaY
X6Qipyw7x1+TdPyIlLb56CQVmc/lWHZ20HGlbX5djR1UNBGtdKwxg47jQ3P1
MRlU9Mb7aNSGKR3XD2z6cNSUikoKNwyflEvhLs1+tlZlfOjlj+6uu8GSOIOx
ZaLcbCsyvmclfGVtP74H3RNQEuZFNPEAdbcscfyzTRWZ2suDvEdGfA6FieI3
Hh2e7fTlRtJh2Yd2fRLGVyLcgyDgQqKXi6JOod14El+f4IufFIQLJvI3Fwjg
8VqHHdqCyWhNM+P8XRYN971j5kr/mxP5cD+7d8duC+5OSnNxmOJAlhw7IE8t
J27m07y/PYUdWaqg1N9LG+B56ciLeGs2VEKv1WKZzoOifinej+IsqLewNTHR
7yfYR8NPX0r4A9lGx5KUfkbCbOkg68GhFVh1NnWnwZNB2F+dJaqouARn9Umu
R6Xn4Ijs8yMwbx4ayxx53fp5GW7zSlWUY5+DQw9DP3tObcCAPKla2vIs7KC6
GS9zsODadLLxPHMWQv5bRy13s+Cg6XuPgh+z0MxTNXjXGRbMVkuqOJ05CxdG
xkuGo1lQn/xSx9B0Fupy7lcXBJtQUlCsic19BjKLBP9dVGNDsoozsu/mmVA8
6upS9H12dEvO27uwlwk9NF5VeXmyo1cS1NamGiZsOvOdZhLIjvh3HXJZimNC
vYO791Hi2NHy8t3ys+pM+DNnVW69nB1VFE5fnoichNJPZIa9+TiQkcq01yHF
CXjNS6tq5DUHijjm9e2M6AR05/2h15PGgRoO8u034pmAT38ZXm3I4UCqInJ1
Pn2/YEK43ERENQfat2m7vTXgF1SPUJqpGedA02gq2bFjHBZYFETVHSShh+pT
LYWuY1AVOF2VySahinNMXQWLMXh8u6YebxEJsWlPfk3XHoPXyy24RstJyOPy
r8Yk8TEo9dG/4uE3EnK+NVIb1jgKS4otTG7PktDtoF5kJjoKRyuCFNplOdE/
jU2Z3LXDUNne+Yp6IicKaWk85Jc9DINDBgtUkjlRLaMhnRU/DElecV2H0jmR
Rm/dx3n7Yeg6P2/FKuZEqtPVKb1Cw9B8N0hT7+BE8rSyxKx7Q1BRS7XJiZeM
dlxKDzfeNQj7tAceWduTUbZEaJEGaRBai4voCLiQkd6q1fDhmZ+Q689MRb4H
GYUkiB3nqfkJPQp0ayYDyYg1Htlf5PwT4pabJ7gSyGjU011OuH0AHvXe+5W/
jozu6j59UUrvhw0V5kl3/6KglAUt5nP2fpgoKNahs5eCBmM48budfTDQ8X6Z
1H4KMhh2GRMJ7oOPFBnJdQcpCLiZKPqM90L7Sf8RiFMQLUmGcTq5B6bsTuP1
uklB2UvV1Nr9XbDWZ5FbLY2CHqe9qVBd7YQ5QjbBGekUZGPi7fS5qRMK0V1e
78yhoP1fjne/ce6EFnH6cV+LKSjq+Yf3nrU/4PfenXkjjRT0n8JTlaN3OuCp
LkZg5hQxnnHb2VS8A27EZ4WnzFHQ0XitJNEdHfBk6/4jMYsUxCRxcvOVtUP5
yK+qlhsUZNLmzBintsN1p0Per3kxdNrhmk1CDgPuyJKIL6BjSERCWWRHEAN+
irOWO3EQQ386d3wLvcaAFSvqxrnyGMpVa1Z0IzOgJU+pa4QShiS2nea4ZNgG
g0OL+hbVMcSTKRnD/ecbNCBPahqbYOhd90jYL7+vcL1dLCgiFENdHjtfvTz6
Fd7m/hb5JwxDfCJnMy8MNsFn+koHTcIx5HwjpbUQNMH9dDo77TmGNEesd4Ws
NcCjY6+PSSRgaHx6JlHarg5SksdahDMwJBwumt0nUgevaHDFiGRhSO/whcqI
plpos9bPFMzBUMH97JE16VpYn5KrtJGHoeAVR+mGkS/Qaee8sXMZhqQ51nJs
rlZB72NVLUcaMWSSJF29l6cKFgGDS01NGIpQv9reVlAJs2+8sjBrxtBaQMnK
yZ2VsH/U4IBzK4Yatnir8H4rhwc4rx7T/4Ehtk8ZOsi7HF6serezsBNDCjoD
po5y5RDEJT8U7MZQfLiab08oghfDWthqejH0Q5rrsXFYGbTyzQ9kDGIIt/03
s3yiFAatFH3BhjGUklHfSj9XCm/7Oz1VGMGQm0LYrjWOEmg+RK3/bwxDf6ny
v451LYQamZ01hZMY8vW5X8nRXgCNe55bFjIxNFnBGLE+WgBl93KHZU9hqORs
tPTJ6TzI90vgwdMZDF2/IJzbbZELy8LKF9nnMcScX1R2qsqBbq6fWHWEPaKa
Id+BHCi2K6ItdIEYf7dvg9poFlS00/i5voghWa9rF7o1s2CStMBfH5cwVCyq
2OGYnAnXX3SLXF4m8tLQWq37LR06Pb30KHIFQwxawDffiE8wUoiyKL2KofnL
yr2fL36Er4wz6cWEjwy8WhBqT4Xuc9NLtWsYunDgIptudAo8f/7hE80/GLKz
pvD6GiVDLmPaQinhjIU7+8a73sJz4QJisesY+qosekgoPgnWF4b+YhGe9mo7
oXP9DVSO/uN5fQNDW6sCNB+IvIaRUpZ9nwkb8Tu+vQ1fwR7bah4uFoai47uK
v6q9hDSrvaRLhNsl1NoUqmLhYQGHmhjCAlnJE7GaL6CqU6lhJ+GLJ/k42Oue
Q6UQ9lz+TSIv1Y6CVuefwT0XVXs0CLfodss3NYXD2eb7LQ6ERXIfht9KfAQz
2N6ExxCOq9WDR94FwisjtcJFhHf37plmpfrC357jjgzCMkPflaOuu0PneraY
ccISvHbRclb2cLR+W/ASYR+GFEOo8jo84y2kwSIsS+21Jh9UB2Fje5o2CbfP
+b6irdwGlSRBsT+EZ3Ulf99zcAYjbbxqs4Tdn2nW2yj4gAXDVdl+wiwvt7hX
h/zBzJO+4Zr/7d/645026RDQ4V5yO40wyaBfBZN4Aj4IPSsIIFwpGhz4khYB
bO6ZM64R9osSt1N6HAl2u0iXyBLW5C0x+rYlGmQfmby3RPwvzPeymk1wDDj+
5u1MIeHa5Wk6GYsHadUGJ10Ih9gG8b/ySwDcL9kvyhF+PxfuKfwgEVySeqfY
T6yXlZX0rTzWG5B5pd1MjvA5cZcrD1XeAsRumdpIrLdUb6WOnsc7UHptosSS
8IT+daWJ1WTgKffzrC+Rl/qtaTL5x1MBeHcBYoQ/1C7t9XNJA9PNRRyBRN7u
qIZziSx+BDQ1lykHIo/aqz3rE0fTgX9gfWQ/kV+5XPpcvkMGGHmwk0uT8Erk
T6bUSiawiXihz0bkvZDH/XuFUw54LK7hIk3US+LBHW0Z4rlgvCzB6xJRTwF6
GS3xzbkg0Iik7PIbQ5eihhqc6Xng+cOpL+9nifUR+6dCurcAzBRonE0n6rdD
fRTuCikEDmB59CVR32VWPqWcSkXgRGWOcsAEhkI/5Rb0hReD2ArtFXycyIfy
nowI9TIQnUjuMhnCEO+1/I/ec2XgzDYqvwCxv8x7XUi7kwCBgve+jfIBDN0Y
rNDf54HAqL4tE+sj5ie1rL3xvRwEdPodOkXsZ3U5pupZwVWg2KLyrGYDhk5V
y1ZKDlSBwhSPzIA6DGW2r6olKFaD9Qm8EdZgKGr1GQgdqgYXrCaEhaswZAlq
T9xUqQHHQbm4ZwmGNuvlDwvO1YE/Nl5o4AOGHHo2Mp6crQda/mPGH1MxNDpV
L0dJqAf9cVff2yVjqJF2U3ZeqwF0IEujoTcYijWIkWx62wjIE2ui9jEYOjbI
LvLAqBlcLlRUl/Mnxl9kOCef2gyWoj3qs32J/xHxqWpgtRkE4DKL8j4Y2vL6
47FE7RZgP1Oh9Jc7htb1jHo2p1vAf1Xd9ol2GOrNzKDDw61A/3xOofsV4ryK
v7J915VWMFDrHxBrSNRTEHnjrm8ruEYrX86+ROw3N662iLS1ArEN+5oWHWJ9
aJiLl2Mb6NUuFUKnMfTKzqRKJZ8BhBpXo22J8zX+Gnf6834GiBo3+iAhgaEX
53Kjp7DvYPOrqEWnOIbCRXlsXhp9By9XJ6CMMFF/LZ+3bax+B7xfbsv58WHI
TH6racmpDpB1kqef9JuC9s0Wr56o6AT8scOPVXMpyKPpjN/CVCdYlqwIZGRQ
UHtaA1+6YBfIza7isvhAQSE3u/eJ2XeBvLLjSf++oaDZrjVtTLQbDGT2KO8J
p6CyauU3bZ49oHxj+/Qeawq6EpevdUe5H5Qp4w7+uyko1xV8P3CzH3wyL70n
u52C+AxqTPvD+8H9INPFhq0UVE7rcNQf7wch9fwxCxwUJHDGXTf+/ADoljp2
mskkI/eCWDfftQGwRedfISdIRn8ndTbpGA2C5BNPfjFNyGjWP/1Wte0g+Bxb
bFhhREYvbj/cPPlwENAmlJ6F65PR+MGDh+npgyDdQNRhlyYZBRX4RJI4h0CI
VWbzV1kyqm2SvFqQMQSgVRP38AonOrviNC6GjQCRwTW3lFDi/qnNT1r8PEbM
f59WTBwJPTbjnlutGwPMp96uMpEk9MOJrZ/VOwYe/P3FIv8RCVknTBdxUcZB
/U0B+xJPov1MvYOwwTjo1M+55W5KtH/6cPDM0jgYZv0pbRQj2rcvlEcoToDc
hALhUuI+/8S0w0c+nwmUN/piGY/ZUQDzFBhtZIK52Cb17f7syMvtzUbcIBMM
SN9/quXOju4+s/0P45sCZmJD/ElW7EinhuTYZzkF5m8b5P0B7IjvkLzVI/5p
YGQe4n1+hg09ZgVpj9vOAHGWpNDNc2yoRmfPVj3+OeCac3+arW4DTont8GqN
nQcCgeWL9mvL0MlRxuzJziWA2bqOfH8wBzt6aPq3aldAT4czP0t5CN5wOzWG
/fMH+GC5gag/D1bKKIVUklnAjysvR/XDAJDgLhl/e44Nf+FOf6qj9RvsKbHR
IAex4/K6oQqq7euAbY0j1WGQA1+Y1GjaGsmJL18oNak+wIkb6VrKhZXy4N0K
pkIH/Mj43fj7jftnaLidIW2beA8FtyviMTqSKoALRg4bce7hwtUl7dPUDHfj
6VcTk+dduXFz1oHy0DBh3FDF+1wt0U/Yp0dsDUaieJaJrfiJ9S24npWo3C03
cXyF5wyp8PJWvNJ/ZUV9eD+u/+2k4p4XfLjVFp1ublwS5zm5pbzkJR+e/8nR
oUFLEi9/23X+WhIffmwqiPTksiQu7+pmFpfOh9ec+W+7sI0kzrc3/5FgNR9+
RNdnQjtKEq+7c2Rox28+XKJf0Ik2JYnjXPRwvn+o+NMh33VavBS+Yr/yV/oF
Kr4kc/3btmQpPKO75p22IRUP2XYgUSBbChfJuFX8yJyKn831lBGtlcLXL78d
5XGj4lxG+qs6C1J4ftJeFew9FU/ZHWy/RZuO3906U/P+AxXfqaAyImNExyVc
yvQ1s6h4PrNPX8eCjkdqXb/tX0LFA49NCsW40XGHudhnpDYqfv+A5E3N93Rc
+qq1SNIPKv6v9LkU5yw6/rNKOfV0HxUPazQYSSmh43ovfpQ9+EXFrcdPaW9v
o+NcHCl/i81QcXFzAdfzfXQc2rgw0AIV53brjPf/Rcedv2ua3lij4mIHHxWX
L9Dx/3sPwf//PeR/ABFurg4=
        "]]},
      Annotation[#, "Charting`Private`Tag$5248#1"]& ]}, {}, {}}, 
   {RGBColor[1, 1, 0], PointSize[Large], 
    PointBox[{{-1.8716312288886912`, 0.5030034569513949}, {
     1.4065307663245241`, -1.0216712033825466`}, {-0.28489953743583196`, \
-2.9188322535688496`}}]}},
  AspectRatio->1,
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic, "GridLinesInFront" -> True},
  PlotRange->{{-5, 5}, {-5, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.7354734355908737`*^9, 3.73547346211516*^9}, 
   3.7354739853539963`*^9, 
   3.73547403423083*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],ExpressionUUID->"0a4a5308-2d15-4467-9422-8a9594815e27"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 871},
WindowMargins->{{Automatic, 198}, {-116, Automatic}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 27, \
2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 254, 4, 44, "Subsection", "ExpressionUUID" -> \
"2f8d886f-54d8-4788-a90c-135e1efbe8a4"],
Cell[CellGroupData[{
Cell[859, 30, 504, 16, 51, "Input", "ExpressionUUID" -> \
"c94aa1aa-99d1-449c-a349-cd2708c31c3f"],
Cell[1366, 48, 138, 3, 48, "Output", "ExpressionUUID" -> \
"331003d4-9c89-4b5d-9433-51aca57a024c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1541, 56, 223, 5, 32, "Input", "ExpressionUUID" -> \
"cec36bb9-9641-4db5-83ae-4337bec6f902"],
Cell[1767, 63, 189, 4, 48, "Output", "ExpressionUUID" -> \
"6ae83914-a35e-40e5-a068-1126eb71fdac"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1993, 72, 120, 2, 32, "Input", "ExpressionUUID" -> \
"67c9164c-fd7d-4f6f-a374-c8c4c87c5660"],
Cell[2116, 76, 109, 1, 32, "Output", "ExpressionUUID" -> \
"4eed715b-37ff-4ff1-a0be-83bbaad389a1"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2274, 83, 189, 3, 94, "Subsection", "ExpressionUUID" -> \
"a6654b17-9af2-4ae7-825d-c22e5790b674"],
Cell[2466, 88, 192, 3, 30, "Text", "ExpressionUUID" -> \
"f415c291-e8c0-4f26-8dc4-2d151218aeb2"],
Cell[2661, 93, 724, 21, 54, "Input", "ExpressionUUID" -> \
"633273d1-223f-4c58-b867-40c967f80fb3"],
Cell[3388, 116, 653, 17, 89, "Text", "ExpressionUUID" -> \
"167fac2c-46ec-4955-ba42-0d4ac423220e"],
Cell[CellGroupData[{
Cell[4066, 137, 757, 22, 54, "Input", "ExpressionUUID" -> \
"7a3b7079-e891-44d0-9cf3-fdd8b4db57c5"],
Cell[4826, 161, 321, 9, 32, "Output", "ExpressionUUID" -> \
"f2ac8f71-5de8-4005-b1ea-b886a625c903"],
Cell[5150, 172, 309, 8, 32, "Output", "ExpressionUUID" -> \
"40824556-8eea-4a23-8219-a6f2d02ba08d"]
}, Open  ]],
Cell[5474, 183, 2392, 66, 189, "Text", "ExpressionUUID" -> \
"2d666c7a-750b-4f0d-947d-85b4f7ea2de1"],
Cell[7869, 251, 616, 18, 54, "Input", "ExpressionUUID" -> \
"042152f0-1725-4c02-808c-27327f2c6630"],
Cell[CellGroupData[{
Cell[8510, 273, 397, 8, 96, "Input", "ExpressionUUID" -> \
"ef43f669-41d5-46d4-9c25-bd1173ca93e0"],
Cell[8910, 283, 266443, 4470, 376, 187725, 3179, "CachedBoxData", "BoxData", \
"Output", "ExpressionUUID" -> "7b0310c4-51ed-4361-b915-fce95b5d23c9"]
}, Open  ]],
Cell[275368, 4756, 282, 5, 68, "Text", "ExpressionUUID" -> \
"cc77cd86-75ea-4c6b-9fb5-d582e3f132a0"],
Cell[CellGroupData[{
Cell[275675, 4765, 299, 8, 32, "Input", "ExpressionUUID" -> \
"bf1bba69-ca98-41e8-b757-c264f230b33b"],
Cell[275977, 4775, 273, 9, 32, "Output", "ExpressionUUID" -> \
"36d6f25d-9061-4fa2-899a-ce1a36450575"]
}, Open  ]],
Cell[CellGroupData[{
Cell[276287, 4789, 291, 8, 32, "Input", "ExpressionUUID" -> \
"99e3451c-9d58-44d8-b69d-de88ac9376e5"],
Cell[276581, 4799, 219, 7, 32, "Output", "ExpressionUUID" -> \
"5f39cacd-21a8-4e8a-b5b6-bef0e0b5d20f"]
}, Open  ]],
Cell[276815, 4809, 402, 11, 87, "Text", "ExpressionUUID" -> \
"84431b4c-de26-4579-a64e-12e16479c9fb"],
Cell[277220, 4822, 1850, 59, 93, "Text", "ExpressionUUID" -> \
"74fc3f8a-16b8-450b-81b6-d76da534b231"],
Cell[CellGroupData[{
Cell[279095, 4885, 1032, 28, 117, "Input", "ExpressionUUID" -> \
"a8389c86-e18f-4eaf-a823-06580e278647"],
Cell[280130, 4915, 1146, 29, 70, "Output", "ExpressionUUID" -> \
"8dc22ebf-9025-4936-94d4-80e554a830f4"]
}, Open  ]],
Cell[281291, 4947, 1219, 32, 75, "Input", "ExpressionUUID" -> \
"7810bef2-6e75-4080-b994-8723ead2b165"],
Cell[CellGroupData[{
Cell[282535, 4983, 233, 5, 32, "Input", "ExpressionUUID" -> \
"67528214-80bc-4dd5-98a7-0e3d8ddff800"],
Cell[282771, 4990, 266512, 4472, 376, 187928, 3183, "CachedBoxData", \
"BoxData", "Output", "ExpressionUUID" -> \
"0a4a5308-2d15-4467-9422-8a9594815e27"]
}, Open  ]]
}, Open  ]]
}
]
*)

