(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     56197,       1422]
NotebookOptionsPosition[     52534,       1286]
NotebookOutlinePosition[     52888,       1302]
CellTagsIndexPosition[     52845,       1299]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Test 3", "Title",
 CellChangeTimes->{{3.609609331809988*^9, 3.60960933303161*^9}}],

Cell[CellGroupData[{

Cell["\[LineSeparator]\[LineSeparator]#2 Triple integral", "Subsubsection",
 CellChangeTimes->{{3.60960935248374*^9, 3.609609359468142*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"10", " ", "x"}], " ", "+", 
      RowBox[{"15", " ", "y"}], "+", 
      RowBox[{"6", " ", "z"}]}], "\[Equal]", "30"}], ",", "z"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.609609432686062*^9, 3.609609451059668*^9}, {
  3.609670325032995*^9, 3.6096703254959955`*^9}, {3.6096707733879957`*^9, 
  3.609670778994995*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"z", "\[Rule]", 
    RowBox[{"5", "-", 
     FractionBox[
      RowBox[{"5", " ", "x"}], "3"], "-", 
     FractionBox[
      RowBox[{"5", " ", "y"}], "2"]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.6096703260159955`*^9, 3.6096707800159955`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"5", "-", 
      FractionBox[
       RowBox[{"5", " ", "x"}], "3"], "-", 
      FractionBox[
       RowBox[{"5", " ", "y"}], "2"]}], "\[Equal]", "0"}], ",", "y"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6096704745839953`*^9, 3.609670490758995*^9}, {
  3.6096706858189955`*^9, 3.6096707342629957`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"2", "-", 
     FractionBox[
      RowBox[{"2", " ", "x"}], "3"]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.6096704939929953`*^9, {3.6096706985269957`*^9, 3.6096707346099954`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myy", "=", 
  RowBox[{
   SubsuperscriptBox["\[Integral]", "0", 
    RowBox[{"2", "-", 
     RowBox[{"2", " ", 
      RowBox[{"x", "/", "3"}]}]}]], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"5", "-", 
      FractionBox[
       RowBox[{"5", " ", "x"}], "3"], "-", 
      FractionBox[
       RowBox[{"5", " ", "y"}], "2"]}], ")"}], 
    RowBox[{"\[DifferentialD]", "y"}]}]}]}]], "Input",
 CellChangeTimes->{{3.609670801442995*^9, 3.6096708329049954`*^9}, {
  3.6096709942609954`*^9, 3.6096709969259953`*^9}}],

Cell[BoxData[
 RowBox[{"5", "-", 
  FractionBox[
   RowBox[{"10", " ", "x"}], "3"], "+", 
  FractionBox[
   RowBox[{"5", " ", 
    SuperscriptBox["x", "2"]}], "9"]}]], "Output",
 CellChangeTimes->{3.609670835251995*^9, 3.6096709984209957`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"myy", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.6096710129509954`*^9, 3.6096710653679953`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"5", " ", "x"}], "-", 
  FractionBox[
   RowBox[{"5", " ", 
    SuperscriptBox["x", "2"]}], "3"], "+", 
  FractionBox[
   RowBox[{"5", " ", 
    SuperscriptBox["x", "3"]}], "27"]}]], "Output",
 CellChangeTimes->{{3.6096710280649953`*^9, 3.6096710669939957`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"x", "\[Rule]", "3"}]}]], "Input",
 CellChangeTimes->{{3.6096711021619954`*^9, 3.6096711109179955`*^9}}],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{3.6096711117929955`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\[LineSeparator]\[LineSeparator]#3", "Subsubsection",
 CellChangeTimes->{{3.6096715348329954`*^9, 3.609671537440995*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", 
   RowBox[{"\[Pi]", "/", "4"}], 
   RowBox[{"7", 
    RowBox[{"\[Pi]", "/", "4"}]}]], 
  RowBox[{
   RowBox[{"Cos", "[", "\[Theta]", "]"}], 
   RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}]], "Input",
 CellChangeTimes->{{3.609671551947995*^9, 3.6096716016019955`*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  SqrtBox["2"]}]], "Output",
 CellChangeTimes->{3.6096716096889954`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "/", "3"}], "]"}]], "Input",
 CellChangeTimes->{{3.609684938451729*^9, 3.6096849502751837`*^9}, {
  3.609685038865571*^9, 3.60968504224094*^9}}],

Cell[BoxData["0.4714045207910317`"], "Output",
 CellChangeTimes->{3.609684953278294*^9, 3.6096850435575323`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\[LineSeparator]\[LineSeparator]#5 sketch vectors", "Subsubsection",
 CellChangeTimes->{{3.609669500468026*^9, 3.6096695113652053`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"2", "y"}], ",", "1"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.6096695177484818`*^9, 3.60966954485725*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"VectorPlot", "::", "argtu"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"\[NoBreak]\\!\\(VectorPlot\\)\[NoBreak] called with 1 \
argument; \[NoBreak]\\!\\(2\\)\[NoBreak] or \[NoBreak]\\!\\(3\\)\[NoBreak] \
arguments are expected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/argtu\\\", ButtonNote -> \
\\\"VectorPlot::argtu\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.609669546194384*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", "y"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.609669569280692*^9, 3.6096695844832125`*^9}, {
  3.609669656238387*^9, 3.609669666123376*^9}, {3.6096697049842615`*^9, 
  3.6096697084896116`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    {Arrowheads[{{0.045873685240266276`, 1.}}], 
     ArrowBox[{{-1.80400161697999, -2.0489995957550025`}, {-2.19599838302001, \
-1.9510004042449973`}}]}, 
    {Arrowheads[{{0.039735724723099934`, 1.}}], 
     ArrowBox[{{-1.8320013859828486`, -1.7632853100407169`}, \
{-2.167998614017151, -1.6652861185307117`}}]}, 
    {Arrowheads[{{0.03367939645188961, 1.}}], 
     ArrowBox[{{-1.860001154985707, -1.4775710243264313`}, \
{-2.139998845014293, -1.3795718328164261`}}]}, 
    {Arrowheads[{{0.027758183942825775`, 1.}}], 
     ArrowBox[{{-1.8880009239885656`, -1.1918567386121457`}, \
{-2.1119990760114344`, -1.0938575471021406`}}]}, 
    {Arrowheads[{{0.0220810532038345, 1.}}], 
     ArrowBox[{{-1.9160006929914242`, -0.9061424528978601}, \
{-2.083999307008576, -0.8081432613878551}}]}, 
    {Arrowheads[{{0.016895861911249522`, 1.}}], 
     ArrowBox[{{-1.9440004619942828`, -0.6204281671835744}, \
{-2.055999538005717, -0.5224289756735694}}]}, 
    {Arrowheads[{{0.01281438618132284, 1.}}], 
     ArrowBox[{{-1.9720002309971414`, -0.33471388146928865`}, \
{-2.0279997690028586`, -0.23671468995928363`}}]}, 
    {Arrowheads[{{0.011126002922467992`, 1.}}], 
     ArrowBox[{{-2., -0.04899959575500297}, {-2., 0.04899959575500208}}]}, 
    {Arrowheads[{{0.012814386181322827`, 1.}}], 
     ArrowBox[{{-2.0279997690028586`, 
      0.23671468995928274`}, {-1.9720002309971416`, 
      0.33471388146928777`}}]}, 
    {Arrowheads[{{0.0168958619112495, 1.}}], 
     ArrowBox[{{-2.055999538005717, 0.5224289756735684}, {-1.944000461994283, 
      0.6204281671835734}}]}, 
    {Arrowheads[{{0.0220810532038345, 1.}}], 
     ArrowBox[{{-2.083999307008576, 
      0.8081432613878541}, {-1.9160006929914242`, 0.9061424528978591}}]}, 
    {Arrowheads[{{0.027758183942825775`, 1.}}], 
     ArrowBox[{{-2.1119990760114344`, 
      1.09385754710214}, {-1.8880009239885656`, 1.191856738612145}}]}, 
    {Arrowheads[{{0.03367939645188959, 1.}}], 
     ArrowBox[{{-2.139998845014293, 
      1.3795718328164255`}, {-1.8600011549857072`, 1.4775710243264306`}}]}, 
    {Arrowheads[{{0.03973572472309998, 1.}}], 
     ArrowBox[{{-2.1679986140171517`, 
      1.665286118530711}, {-1.8320013859828486`, 1.7632853100407162`}}]}, 
    {Arrowheads[{{0.04587368524026627, 1.}}], 
     ArrowBox[{{-2.19599838302001, 1.9510004042449967`}, {-1.80400161697999, 
      2.0489995957550016`}}]}, 
    {Arrowheads[{{0.045873685240266304`, 1.}}], 
     ArrowBox[{{-1.5182873312657044`, -2.0489995957550025`}, \
{-1.9102840973057245`, -1.9510004042449973`}}]}, 
    {Arrowheads[{{0.039735724723099955`, 1.}}], 
     ArrowBox[{{-1.546287100268563, -1.7632853100407169`}, \
{-1.8822843283028659`, -1.6652861185307117`}}]}, 
    {Arrowheads[{{0.03367939645188959, 1.}}], 
     ArrowBox[{{-1.5742868692714214`, -1.4775710243264313`}, \
{-1.8542845593000072`, -1.3795718328164261`}}]}, 
    {Arrowheads[{{0.027758183942825775`, 1.}}], 
     ArrowBox[{{-1.60228663827428, -1.1918567386121457`}, \
{-1.8262847902971489`, -1.0938575471021406`}}]}, 
    {Arrowheads[{{0.0220810532038345, 1.}}], 
     ArrowBox[{{-1.6302864072771386`, -0.9061424528978601}, \
{-1.7982850212942902`, -0.8081432613878551}}]}, 
    {Arrowheads[{{0.016895861911249522`, 1.}}], 
     ArrowBox[{{-1.6582861762799972`, -0.6204281671835744}, \
{-1.7702852522914316`, -0.5224289756735694}}]}, 
    {Arrowheads[{{0.01281438618132284, 1.}}], 
     ArrowBox[{{-1.6862859452828558`, -0.33471388146928865`}, \
{-1.742285483288573, -0.23671468995928363`}}]}, 
    {Arrowheads[{{0.011126002922467992`, 1.}}], 
     ArrowBox[{{-1.7142857142857144`, -0.04899959575500297}, \
{-1.7142857142857144`, 0.04899959575500208}}]}, 
    {Arrowheads[{{0.012814386181322827`, 1.}}], 
     ArrowBox[{{-1.742285483288573, 
      0.23671468995928274`}, {-1.686285945282856, 0.33471388146928777`}}]}, 
    {Arrowheads[{{0.0168958619112495, 1.}}], 
     ArrowBox[{{-1.7702852522914316`, 
      0.5224289756735684}, {-1.6582861762799974`, 0.6204281671835734}}]}, 
    {Arrowheads[{{0.0220810532038345, 1.}}], 
     ArrowBox[{{-1.7982850212942902`, 
      0.8081432613878541}, {-1.6302864072771386`, 0.9061424528978591}}]}, 
    {Arrowheads[{{0.027758183942825754`, 1.}}], 
     ArrowBox[{{-1.8262847902971486`, 1.09385754710214}, {-1.60228663827428, 
      1.191856738612145}}]}, 
    {Arrowheads[{{0.03367939645188956, 1.}}], 
     ArrowBox[{{-1.8542845593000072`, 
      1.3795718328164255`}, {-1.5742868692714216`, 1.4775710243264306`}}]}, 
    {Arrowheads[{{0.039735724723099955`, 1.}}], 
     ArrowBox[{{-1.8822843283028659`, 1.665286118530711}, {-1.546287100268563,
       1.7632853100407162`}}]}, 
    {Arrowheads[{{0.0458736852402663, 1.}}], 
     ArrowBox[{{-1.9102840973057245`, 
      1.9510004042449967`}, {-1.5182873312657044`, 2.0489995957550016`}}]}, 
    {Arrowheads[{{0.045873685240266304`, 1.}}], 
     ArrowBox[{{-1.2325730455514188`, -2.0489995957550025`}, \
{-1.6245698115914389`, -1.9510004042449973`}}]}, 
    {Arrowheads[{{0.03973572472309998, 1.}}], 
     ArrowBox[{{-1.2605728145542774`, -1.7632853100407169`}, \
{-1.5965700425885805`, -1.6652861185307117`}}]}, 
    {Arrowheads[{{0.03367939645188959, 1.}}], 
     ArrowBox[{{-1.2885725835571358`, -1.4775710243264313`}, \
{-1.5685702735857217`, -1.3795718328164261`}}]}, 
    {Arrowheads[{{0.027758183942825775`, 1.}}], 
     ArrowBox[{{-1.3165723525599944`, -1.1918567386121457`}, \
{-1.5405705045828633`, -1.0938575471021406`}}]}, 
    {Arrowheads[{{0.0220810532038345, 1.}}], 
     ArrowBox[{{-1.344572121562853, -0.9061424528978601}, \
{-1.5125707355800047`, -0.8081432613878551}}]}, 
    {Arrowheads[{{0.016895861911249522`, 1.}}], 
     ArrowBox[{{-1.3725718905657116`, -0.6204281671835744}, \
{-1.484570966577146, -0.5224289756735694}}]}, 
    {Arrowheads[{{0.01281438618132284, 1.}}], 
     ArrowBox[{{-1.4005716595685702`, -0.33471388146928865`}, \
{-1.4565711975742874`, -0.23671468995928363`}}]}, 
    {Arrowheads[{{0.011126002922467992`, 1.}}], 
     ArrowBox[{{-1.4285714285714288`, -0.04899959575500297}, \
{-1.4285714285714288`, 0.04899959575500208}}]}, 
    {Arrowheads[{{0.012814386181322827`, 1.}}], 
     ArrowBox[{{-1.4565711975742874`, 
      0.23671468995928274`}, {-1.4005716595685704`, 
      0.33471388146928777`}}]}, 
    {Arrowheads[{{0.0168958619112495, 1.}}], 
     ArrowBox[{{-1.484570966577146, 
      0.5224289756735684}, {-1.3725718905657118`, 0.6204281671835734}}]}, 
    {Arrowheads[{{0.0220810532038345, 1.}}], 
     ArrowBox[{{-1.5125707355800047`, 
      0.8081432613878541}, {-1.344572121562853, 0.9061424528978591}}]}, 
    {Arrowheads[{{0.027758183942825754`, 1.}}], 
     ArrowBox[{{-1.540570504582863, 1.09385754710214}, {-1.3165723525599944`, 
      1.191856738612145}}]}, 
    {Arrowheads[{{0.03367939645188956, 1.}}], 
     ArrowBox[{{-1.5685702735857217`, 
      1.3795718328164255`}, {-1.288572583557136, 1.4775710243264306`}}]}, 
    {Arrowheads[{{0.039735724723099955`, 1.}}], 
     ArrowBox[{{-1.5965700425885803`, 
      1.665286118530711}, {-1.2605728145542774`, 1.7632853100407162`}}]}, 
    {Arrowheads[{{0.0458736852402663, 1.}}], 
     ArrowBox[{{-1.6245698115914389`, 
      1.9510004042449967`}, {-1.2325730455514188`, 2.0489995957550016`}}]}, 
    {Arrowheads[{{0.045873685240266304`, 1.}}], 
     ArrowBox[{{-0.9468587598371332, -2.0489995957550025`}, \
{-1.3388555258771533`, -1.9510004042449973`}}]}, 
    {Arrowheads[{{0.0397357247231, 1.}}], 
     ArrowBox[{{-0.9748585288399917, -1.7632853100407169`}, \
{-1.310855756874295, -1.6652861185307117`}}]}, 
    {Arrowheads[{{0.03367939645188959, 1.}}], 
     ArrowBox[{{-1.0028582978428502`, -1.4775710243264313`}, \
{-1.282855987871436, -1.3795718328164261`}}]}, 
    {Arrowheads[{{0.027758183942825775`, 1.}}], 
     ArrowBox[{{-1.0308580668457088`, -1.1918567386121457`}, \
{-1.2548562188685777`, -1.0938575471021406`}}]}, 
    {Arrowheads[{{0.0220810532038345, 1.}}], 
     ArrowBox[{{-1.0588578358485674`, -0.9061424528978601}, \
{-1.226856449865719, -0.8081432613878551}}]}, 
    {Arrowheads[{{0.016895861911249522`, 1.}}], 
     ArrowBox[{{-1.086857604851426, -0.6204281671835744}, \
{-1.1988566808628605`, -0.5224289756735694}}]}, 
    {Arrowheads[{{0.01281438618132284, 1.}}], 
     ArrowBox[{{-1.1148573738542846`, -0.33471388146928865`}, \
{-1.1708569118600018`, -0.23671468995928363`}}]}, 
    {Arrowheads[{{0.011126002922467992`, 1.}}], 
     ArrowBox[{{-1.1428571428571432`, -0.04899959575500297}, \
{-1.1428571428571432`, 0.04899959575500208}}]}, 
    {Arrowheads[{{0.012814386181322827`, 1.}}], 
     ArrowBox[{{-1.1708569118600018`, 
      0.23671468995928274`}, {-1.1148573738542848`, 
      0.33471388146928777`}}]}, 
    {Arrowheads[{{0.0168958619112495, 1.}}], 
     ArrowBox[{{-1.1988566808628605`, 
      0.5224289756735684}, {-1.0868576048514262`, 0.6204281671835734}}]}, 
    {Arrowheads[{{0.0220810532038345, 1.}}], 
     ArrowBox[{{-1.226856449865719, 
      0.8081432613878541}, {-1.0588578358485674`, 0.9061424528978591}}]}, 
    {Arrowheads[{{0.027758183942825754`, 1.}}], 
     ArrowBox[{{-1.2548562188685775`, 
      1.09385754710214}, {-1.0308580668457088`, 1.191856738612145}}]}, 
    {Arrowheads[{{0.03367939645188956, 1.}}], 
     ArrowBox[{{-1.282855987871436, 
      1.3795718328164255`}, {-1.0028582978428504`, 1.4775710243264306`}}]}, 
    {Arrowheads[{{0.039735724723099955`, 1.}}], 
     ArrowBox[{{-1.3108557568742947`, 
      1.665286118530711}, {-0.9748585288399918, 1.7632853100407162`}}]}, 
    {Arrowheads[{{0.0458736852402663, 1.}}], 
     ArrowBox[{{-1.3388555258771533`, 
      1.9510004042449967`}, {-0.9468587598371332, 2.0489995957550016`}}]}, 
    {Arrowheads[{{0.045873685240266325`, 1.}}], 
     ArrowBox[{{-0.6611444741228474, -2.0489995957550025`}, \
{-1.0531412401628677`, -1.9510004042449973`}}]}, 
    {Arrowheads[{{0.03973572472309998, 1.}}], 
     ArrowBox[{{-0.689144243125706, -1.7632853100407169`}, \
{-1.025141471160009, -1.6652861185307117`}}]}, 
    {Arrowheads[{{0.0336793964518896, 1.}}], 
     ArrowBox[{{-0.7171440121285646, -1.4775710243264313`}, \
{-0.9971417021571506, -1.3795718328164261`}}]}, 
    {Arrowheads[{{0.027758183942825768`, 1.}}], 
     ArrowBox[{{-0.7451437811314231, -1.1918567386121457`}, \
{-0.9691419331542919, -1.0938575471021406`}}]}, 
    {Arrowheads[{{0.02208105320383449, 1.}}], 
     ArrowBox[{{-0.7731435501342817, -0.9061424528978601}, \
{-0.9411421641514333, -0.8081432613878551}}]}, 
    {Arrowheads[{{0.016895861911249522`, 1.}}], 
     ArrowBox[{{-0.8011433191371403, -0.6204281671835744}, \
{-0.9131423951485748, -0.5224289756735694}}]}, 
    {Arrowheads[{{0.01281438618132284, 1.}}], 
     ArrowBox[{{-0.8291430881399989, -0.33471388146928865`}, \
{-0.8851426261457161, -0.23671468995928363`}}]}, 
    {Arrowheads[{{0.011126002922467992`, 1.}}], 
     ArrowBox[{{-0.8571428571428575, -0.04899959575500297}, \
{-0.8571428571428577, 0.04899959575500208}}]}, 
    {Arrowheads[{{0.012814386181322834`, 1.}}], 
     ArrowBox[{{-0.885142626145716, 
      0.23671468995928274`}, {-0.8291430881399989, 0.33471388146928777`}}]}, 
    {Arrowheads[{{0.016895861911249508`, 1.}}], 
     ArrowBox[{{-0.9131423951485746, 
      0.5224289756735684}, {-0.8011433191371403, 0.6204281671835734}}]}, 
    {Arrowheads[{{0.02208105320383448, 1.}}], 
     ArrowBox[{{-0.9411421641514333, 
      0.8081432613878541}, {-0.7731435501342818, 0.9061424528978591}}]}, 
    {Arrowheads[{{0.02775818394282574, 1.}}], 
     ArrowBox[{{-0.9691419331542919, 1.09385754710214}, {-0.7451437811314233, 
      1.191856738612145}}]}, 
    {Arrowheads[{{0.033679396451889575`, 1.}}], 
     ArrowBox[{{-0.9971417021571504, 
      1.3795718328164255`}, {-0.7171440121285646, 1.4775710243264306`}}]}, 
    {Arrowheads[{{0.03973572472309994, 1.}}], 
     ArrowBox[{{-1.0251414711600089`, 
      1.665286118530711}, {-0.6891442431257061, 1.7632853100407162`}}]}, 
    {Arrowheads[{{0.04587368524026628, 1.}}], 
     ArrowBox[{{-1.0531412401628675`, 
      1.9510004042449967`}, {-0.6611444741228475, 2.0489995957550016`}}]}, 
    {Arrowheads[{{0.04587368524026631, 1.}}], 
     ArrowBox[{{-0.37543018840856174`, -2.0489995957550025`}, \
{-0.7674269544485819, -1.9510004042449973`}}]}, 
    {Arrowheads[{{0.03973572472309998, 1.}}], 
     ArrowBox[{{-0.4034299574114203, -1.7632853100407169`}, \
{-0.7394271854457234, -1.6652861185307117`}}]}, 
    {Arrowheads[{{0.03367939645188959, 1.}}], 
     ArrowBox[{{-0.4314297264142789, -1.4775710243264313`}, \
{-0.7114274164428648, -1.3795718328164261`}}]}, 
    {Arrowheads[{{0.02775818394282576, 1.}}], 
     ArrowBox[{{-0.45942949541713746`, -1.1918567386121457`}, \
{-0.6834276474400062, -1.0938575471021406`}}]}, 
    {Arrowheads[{{0.0220810532038345, 1.}}], 
     ArrowBox[{{-0.487429264419996, -0.9061424528978601}, \
{-0.6554278784371477, -0.8081432613878551}}]}, 
    {Arrowheads[{{0.016895861911249522`, 1.}}], 
     ArrowBox[{{-0.5154290334228546, -0.6204281671835744}, \
{-0.6274281094342891, -0.5224289756735694}}]}, 
    {Arrowheads[{{0.01281438618132284, 1.}}], 
     ArrowBox[{{-0.5434288024257132, -0.33471388146928865`}, \
{-0.5994283404314305, -0.23671468995928363`}}]}, 
    {Arrowheads[{{0.011126002922467992`, 1.}}], 
     ArrowBox[{{-0.5714285714285718, -0.04899959575500297}, \
{-0.571428571428572, 0.04899959575500208}}]}, 
    {Arrowheads[{{0.012814386181322834`, 1.}}], 
     ArrowBox[{{-0.5994283404314303, 
      0.23671468995928274`}, {-0.5434288024257132, 0.33471388146928777`}}]}, 
    {Arrowheads[{{0.0168958619112495, 1.}}], 
     ArrowBox[{{-0.627428109434289, 0.5224289756735684}, {-0.5154290334228547,
       0.6204281671835734}}]}, 
    {Arrowheads[{{0.02208105320383448, 1.}}], 
     ArrowBox[{{-0.6554278784371476, 
      0.8081432613878541}, {-0.4874292644199961, 0.9061424528978591}}]}, 
    {Arrowheads[{{0.027758183942825754`, 1.}}], 
     ArrowBox[{{-0.6834276474400062, 1.09385754710214}, {-0.4594294954171375, 
      1.191856738612145}}]}, 
    {Arrowheads[{{0.03367939645188956, 1.}}], 
     ArrowBox[{{-0.7114274164428647, 
      1.3795718328164255`}, {-0.431429726414279, 1.4775710243264306`}}]}, 
    {Arrowheads[{{0.039735724723099955`, 1.}}], 
     ArrowBox[{{-0.7394271854457233, 1.665286118530711}, {-0.4034299574114204,
       1.7632853100407162`}}]}, 
    {Arrowheads[{{0.0458736852402663, 1.}}], 
     ArrowBox[{{-0.7674269544485819, 
      1.9510004042449967`}, {-0.3754301884085618, 2.0489995957550016`}}]}, 
    {Arrowheads[{{0.04587368524026631, 1.}}], 
     ArrowBox[{{-0.08971590269427604, -2.0489995957550025`}, \
{-0.48171266873429625`, -1.9510004042449973`}}]}, 
    {Arrowheads[{{0.03973572472309997, 1.}}], 
     ArrowBox[{{-0.11771567169713462`, -1.7632853100407169`}, \
{-0.4537128997314376, -1.6652861185307117`}}]}, 
    {Arrowheads[{{0.0336793964518896, 1.}}], 
     ArrowBox[{{-0.14571544069999318`, -1.4775710243264313`}, \
{-0.4257131307285792, -1.3795718328164261`}}]}, 
    {Arrowheads[{{0.027758183942825768`, 1.}}], 
     ArrowBox[{{-0.17371520970285176`, -1.1918567386121457`}, \
{-0.3977133617257205, -1.0938575471021406`}}]}, 
    {Arrowheads[{{0.022081053203834498`, 1.}}], 
     ArrowBox[{{-0.20171497870571034`, -0.9061424528978601}, \
{-0.369713592722862, -0.8081432613878551}}]}, 
    {Arrowheads[{{0.016895861911249522`, 1.}}], 
     ArrowBox[{{-0.22971474770856892`, -0.6204281671835744}, \
{-0.34171382372000336`, -0.5224289756735694}}]}, 
    {Arrowheads[{{0.01281438618132284, 1.}}], 
     ArrowBox[{{-0.25771451671142753`, -0.33471388146928865`}, \
{-0.31371405471714475`, -0.23671468995928363`}}]}, 
    {Arrowheads[{{0.011126002922467992`, 1.}}], 
     ArrowBox[{{-0.2857142857142861, -0.04899959575500297}, \
{-0.2857142857142862, 0.04899959575500208}}]}, 
    {Arrowheads[{{0.012814386181322834`, 1.}}], 
     ArrowBox[{{-0.3137140547171447, 
      0.23671468995928274`}, {-0.2577145167114276, 0.33471388146928777`}}]}, 
    {Arrowheads[{{0.0168958619112495, 1.}}], 
     ArrowBox[{{-0.34171382372000325`, 
      0.5224289756735684}, {-0.229714747708569, 0.6204281671835734}}]}, 
    {Arrowheads[{{0.02208105320383448, 1.}}], 
     ArrowBox[{{-0.36971359272286186`, 
      0.8081432613878541}, {-0.20171497870571042`, 0.9061424528978591}}]}, 
    {Arrowheads[{{0.02775818394282575, 1.}}], 
     ArrowBox[{{-0.39771336172572047`, 
      1.09385754710214}, {-0.17371520970285184`, 1.191856738612145}}]}, 
    {Arrowheads[{{0.03367939645188956, 1.}}], 
     ArrowBox[{{-0.42571313072857897`, 
      1.3795718328164255`}, {-0.1457154406999933, 1.4775710243264306`}}]}, 
    {Arrowheads[{{0.039735724723099955`, 1.}}], 
     ArrowBox[{{-0.4537128997314376, 1.665286118530711}, {-0.1177156716971347,
       1.7632853100407162`}}]}, 
    {Arrowheads[{{0.0458736852402663, 1.}}], 
     ArrowBox[{{-0.4817126687342962, 
      1.9510004042449967`}, {-0.08971590269427612, 2.0489995957550016`}}]}, 
    {Arrowheads[{{0.04587368524026631, 1.}}], 
     ArrowBox[{{
      0.19599838302000966`, -2.0489995957550025`}, {-0.19599838302001055`, \
-1.9510004042449973`}}]}, 
    {Arrowheads[{{0.039735724723099976`, 1.}}], 
     ArrowBox[{{
      0.16799861401715108`, -1.7632853100407169`}, {-0.16799861401715196`, \
-1.6652861185307117`}}]}, 
    {Arrowheads[{{0.033679396451889596`, 1.}}], 
     ArrowBox[{{
      0.13999884501429252`, -1.4775710243264313`}, {-0.1399988450142934, \
-1.3795718328164261`}}]}, 
    {Arrowheads[{{0.02775818394282577, 1.}}], 
     ArrowBox[{{
      0.11199907601143395`, -1.1918567386121457`}, {-0.11199907601143484`, \
-1.0938575471021406`}}]}, 
    {Arrowheads[{{0.022081053203834494`, 1.}}], 
     ArrowBox[{{
      0.08399930700857536, -0.9061424528978601}, {-0.08399930700857625, \
-0.8081432613878551}}]}, 
    {Arrowheads[{{0.01689586191124952, 1.}}], 
     ArrowBox[{{
      0.05599953800571677, -0.6204281671835744}, {-0.05599953800571766, \
-0.5224289756735694}}]}, 
    {Arrowheads[{{0.012814386181322841`, 1.}}], 
     ArrowBox[{{
      0.02799976900285818, -0.33471388146928865`}, {-0.027999769002859068`, \
-0.23671468995928363`}}]}, 
    {Arrowheads[{{0.011126002922467992`, 1.}}], 
     ArrowBox[{{-4.005688263264395*^-16, -0.04899959575500297}, \
{-4.876095933736857*^-16, 0.04899959575500208}}]}, 
    {Arrowheads[{{0.012814386181322832`, 1.}}], 
     ArrowBox[{{-0.027999769002858985`, 0.23671468995928274`}, {
      0.027999769002858096`, 0.33471388146928777`}}]}, 
    {Arrowheads[{{0.016895861911249505`, 1.}}], 
     ArrowBox[{{-0.05599953800571758, 0.5224289756735684}, {
      0.05599953800571669, 0.6204281671835734}}]}, 
    {Arrowheads[{{0.02208105320383448, 1.}}], 
     ArrowBox[{{-0.08399930700857616, 0.8081432613878541}, {
      0.08399930700857527, 0.9061424528978591}}]}, 
    {Arrowheads[{{0.027758183942825747`, 1.}}], 
     ArrowBox[{{-0.11199907601143475`, 1.09385754710214}, {
      0.11199907601143386`, 1.191856738612145}}]}, 
    {Arrowheads[{{0.03367939645188957, 1.}}], 
     ArrowBox[{{-0.1399988450142933, 1.3795718328164255`}, {
      0.1399988450142924, 1.4775710243264306`}}]}, 
    {Arrowheads[{{0.039735724723099955`, 1.}}], 
     ArrowBox[{{-0.16799861401715188`, 1.665286118530711}, {0.167998614017151,
       1.7632853100407162`}}]}, 
    {Arrowheads[{{0.04587368524026629, 1.}}], 
     ArrowBox[{{-0.19599838302001046`, 1.9510004042449967`}, {
      0.19599838302000958`, 2.0489995957550016`}}]}, 
    {Arrowheads[{{0.04587368524026631, 1.}}], 
     ArrowBox[{{0.48171266873429536`, -2.0489995957550025`}, {
      0.08971590269427515, -1.9510004042449973`}}]}, 
    {Arrowheads[{{0.03973572472309998, 1.}}], 
     ArrowBox[{{0.4537128997314368, -1.7632853100407169`}, {
      0.11771567169713373`, -1.6652861185307117`}}]}, 
    {Arrowheads[{{0.03367939645188959, 1.}}], 
     ArrowBox[{{0.4257131307285782, -1.4775710243264313`}, {
      0.1457154406999923, -1.3795718328164261`}}]}, 
    {Arrowheads[{{0.027758183942825768`, 1.}}], 
     ArrowBox[{{0.39771336172571964`, -1.1918567386121457`}, {
      0.17371520970285087`, -1.0938575471021406`}}]}, 
    {Arrowheads[{{0.022081053203834498`, 1.}}], 
     ArrowBox[{{0.3697135927228611, -0.9061424528978601}, {
      0.20171497870570945`, -0.8081432613878551}}]}, 
    {Arrowheads[{{0.016895861911249522`, 1.}}], 
     ArrowBox[{{0.3417138237200025, -0.6204281671835744}, {
      0.22971474770856803`, -0.5224289756735694}}]}, 
    {Arrowheads[{{0.01281438618132284, 1.}}], 
     ArrowBox[{{0.31371405471714386`, -0.33471388146928865`}, {
      0.25771451671142664`, -0.23671468995928363`}}]}, 
    {Arrowheads[{{0.011126002922467992`, 1.}}], 
     ArrowBox[{{0.2857142857142853, -0.04899959575500297}, {
      0.2857142857142852, 0.04899959575500208}}]}, 
    {Arrowheads[{{0.012814386181322834`, 1.}}], 
     ArrowBox[{{0.2577145167114267, 0.23671468995928274`}, {
      0.3137140547171438, 0.33471388146928777`}}]}, 
    {Arrowheads[{{0.0168958619112495, 1.}}], 
     ArrowBox[{{0.22971474770856812`, 0.5224289756735684}, {
      0.34171382372000236`, 0.6204281671835734}}]}, 
    {Arrowheads[{{0.02208105320383448, 1.}}], 
     ArrowBox[{{0.20171497870570954`, 0.8081432613878541}, {0.369713592722861,
       0.9061424528978591}}]}, 
    {Arrowheads[{{0.02775818394282574, 1.}}], 
     ArrowBox[{{0.17371520970285095`, 1.09385754710214}, {
      0.39771336172571947`, 1.191856738612145}}]}, 
    {Arrowheads[{{0.033679396451889575`, 1.}}], 
     ArrowBox[{{0.1457154406999924, 1.3795718328164255`}, {0.4257131307285782,
       1.4775710243264306`}}]}, 
    {Arrowheads[{{0.039735724723099955`, 1.}}], 
     ArrowBox[{{0.11771567169713382`, 1.665286118530711}, {0.4537128997314367,
       1.7632853100407162`}}]}, 
    {Arrowheads[{{0.04587368524026628, 1.}}], 
     ArrowBox[{{0.08971590269427523, 1.9510004042449967`}, {
      0.4817126687342952, 2.0489995957550016`}}]}, 
    {Arrowheads[{{0.04587368524026631, 1.}}], 
     ArrowBox[{{0.767426954448581, -2.0489995957550025`}, {
      0.37543018840856085`, -1.9510004042449973`}}]}, 
    {Arrowheads[{{0.03973572472309998, 1.}}], 
     ArrowBox[{{0.7394271854457225, -1.7632853100407169`}, {
      0.4034299574114194, -1.6652861185307117`}}]}, 
    {Arrowheads[{{0.03367939645188959, 1.}}], 
     ArrowBox[{{0.7114274164428639, -1.4775710243264313`}, {
      0.431429726414278, -1.3795718328164261`}}]}, 
    {Arrowheads[{{0.02775818394282577, 1.}}], 
     ArrowBox[{{0.6834276474400054, -1.1918567386121457`}, {
      0.45942949541713657`, -1.0938575471021406`}}]}, 
    {Arrowheads[{{0.0220810532038345, 1.}}], 
     ArrowBox[{{0.6554278784371468, -0.9061424528978601}, {
      0.4874292644199951, -0.8081432613878551}}]}, 
    {Arrowheads[{{0.016895861911249522`, 1.}}], 
     ArrowBox[{{0.6274281094342882, -0.6204281671835744}, {
      0.5154290334228537, -0.5224289756735694}}]}, 
    {Arrowheads[{{0.01281438618132284, 1.}}], 
     ArrowBox[{{0.5994283404314296, -0.33471388146928865`}, {
      0.5434288024257123, -0.23671468995928363`}}]}, 
    {Arrowheads[{{0.011126002922467992`, 1.}}], 
     ArrowBox[{{0.571428571428571, -0.04899959575500297}, {0.5714285714285708,
       0.04899959575500208}}]}, 
    {Arrowheads[{{0.012814386181322834`, 1.}}], 
     ArrowBox[{{0.5434288024257125, 0.23671468995928274`}, {
      0.5994283404314296, 0.33471388146928777`}}]}, 
    {Arrowheads[{{0.0168958619112495, 1.}}], 
     ArrowBox[{{0.5154290334228538, 0.5224289756735684}, {0.6274281094342881, 
      0.6204281671835734}}]}, 
    {Arrowheads[{{0.02208105320383448, 1.}}], 
     ArrowBox[{{0.48742926441999523`, 0.8081432613878541}, {
      0.6554278784371467, 0.9061424528978591}}]}, 
    {Arrowheads[{{0.027758183942825754`, 1.}}], 
     ArrowBox[{{0.4594294954171366, 1.09385754710214}, {0.6834276474400053, 
      1.191856738612145}}]}, 
    {Arrowheads[{{0.03367939645188956, 1.}}], 
     ArrowBox[{{0.4314297264142781, 1.3795718328164255`}, {0.7114274164428638,
       1.4775710243264306`}}]}, 
    {Arrowheads[{{0.039735724723099955`, 1.}}], 
     ArrowBox[{{0.4034299574114195, 1.665286118530711}, {0.7394271854457224, 
      1.7632853100407162`}}]}, 
    {Arrowheads[{{0.0458736852402663, 1.}}], 
     ArrowBox[{{0.3754301884085609, 1.9510004042449967`}, {0.767426954448581, 
      2.0489995957550016`}}]}, 
    {Arrowheads[{{0.045873685240266325`, 1.}}], 
     ArrowBox[{{1.0531412401628668`, -2.0489995957550025`}, {
      0.6611444741228465, -1.9510004042449973`}}]}, 
    {Arrowheads[{{0.03973572472309997, 1.}}], 
     ArrowBox[{{1.0251414711600082`, -1.7632853100407169`}, {
      0.6891442431257052, -1.6652861185307117`}}]}, 
    {Arrowheads[{{0.0336793964518896, 1.}}], 
     ArrowBox[{{0.9971417021571496, -1.4775710243264313`}, {
      0.7171440121285636, -1.3795718328164261`}}]}, 
    {Arrowheads[{{0.027758183942825768`, 1.}}], 
     ArrowBox[{{0.9691419331542911, -1.1918567386121457`}, {
      0.7451437811314223, -1.0938575471021406`}}]}, 
    {Arrowheads[{{0.02208105320383449, 1.}}], 
     ArrowBox[{{0.9411421641514325, -0.9061424528978601}, {
      0.7731435501342809, -0.8081432613878551}}]}, 
    {Arrowheads[{{0.016895861911249522`, 1.}}], 
     ArrowBox[{{0.9131423951485739, -0.6204281671835744}, {
      0.8011433191371394, -0.5224289756735694}}]}, 
    {Arrowheads[{{0.01281438618132284, 1.}}], 
     ArrowBox[{{0.8851426261457153, -0.33471388146928865`}, {
      0.829143088139998, -0.23671468995928363`}}]}, 
    {Arrowheads[{{0.011126002922467992`, 1.}}], 
     ArrowBox[{{0.8571428571428567, -0.04899959575500297}, {
      0.8571428571428565, 0.04899959575500208}}]}, 
    {Arrowheads[{{0.012814386181322834`, 1.}}], 
     ArrowBox[{{0.8291430881399982, 0.23671468995928274`}, {
      0.8851426261457153, 0.33471388146928777`}}]}, 
    {Arrowheads[{{0.016895861911249508`, 1.}}], 
     ArrowBox[{{0.8011433191371395, 0.5224289756735684}, {0.9131423951485739, 
      0.6204281671835734}}]}, 
    {Arrowheads[{{0.022081053203834466`, 1.}}], 
     ArrowBox[{{0.7731435501342809, 0.8081432613878541}, {0.9411421641514323, 
      0.9061424528978591}}]}, 
    {Arrowheads[{{0.02775818394282574, 1.}}], 
     ArrowBox[{{0.7451437811314223, 1.09385754710214}, {0.9691419331542909, 
      1.191856738612145}}]}, 
    {Arrowheads[{{0.033679396451889575`, 1.}}], 
     ArrowBox[{{0.7171440121285638, 1.3795718328164255`}, {0.9971417021571496,
       1.4775710243264306`}}]}, 
    {Arrowheads[{{0.03973572472309997, 1.}}], 
     ArrowBox[{{0.6891442431257052, 1.665286118530711}, {1.0251414711600082`, 
      1.7632853100407162`}}]}, 
    {Arrowheads[{{0.04587368524026628, 1.}}], 
     ArrowBox[{{0.6611444741228466, 1.9510004042449967`}, {
      1.0531412401628666`, 2.0489995957550016`}}]}, 
    {Arrowheads[{{0.045873685240266304`, 1.}}], 
     ArrowBox[{{1.3388555258771524`, -2.0489995957550025`}, {
      0.9468587598371323, -1.9510004042449973`}}]}, 
    {Arrowheads[{{0.03973572472309997, 1.}}], 
     ArrowBox[{{1.3108557568742938`, -1.7632853100407169`}, {
      0.9748585288399908, -1.6652861185307117`}}]}, 
    {Arrowheads[{{0.03367939645188959, 1.}}], 
     ArrowBox[{{1.2828559878714354`, -1.4775710243264313`}, {
      1.0028582978428495`, -1.3795718328164261`}}]}, 
    {Arrowheads[{{0.027758183942825775`, 1.}}], 
     ArrowBox[{{1.2548562188685768`, -1.1918567386121457`}, {
      1.030858066845708, -1.0938575471021406`}}]}, 
    {Arrowheads[{{0.0220810532038345, 1.}}], 
     ArrowBox[{{1.2268564498657182`, -0.9061424528978601}, {
      1.0588578358485665`, -0.8081432613878551}}]}, 
    {Arrowheads[{{0.016895861911249522`, 1.}}], 
     ArrowBox[{{1.1988566808628596`, -0.6204281671835744}, {
      1.0868576048514251`, -0.5224289756735694}}]}, 
    {Arrowheads[{{0.01281438618132284, 1.}}], 
     ArrowBox[{{1.170856911860001, -0.33471388146928865`}, {
      1.1148573738542837`, -0.23671468995928363`}}]}, 
    {Arrowheads[{{0.011126002922467992`, 1.}}], 
     ArrowBox[{{1.1428571428571423`, -0.04899959575500297}, {
      1.1428571428571423`, 0.04899959575500208}}]}, 
    {Arrowheads[{{0.012814386181322827`, 1.}}], 
     ArrowBox[{{1.1148573738542837`, 0.23671468995928274`}, {
      1.1708569118600007`, 0.33471388146928777`}}]}, 
    {Arrowheads[{{0.0168958619112495, 1.}}], 
     ArrowBox[{{1.0868576048514251`, 0.5224289756735684}, {
      1.1988566808628593`, 0.6204281671835734}}]}, 
    {Arrowheads[{{0.0220810532038345, 1.}}], 
     ArrowBox[{{1.0588578358485665`, 0.8081432613878541}, {
      1.2268564498657182`, 0.9061424528978591}}]}, 
    {Arrowheads[{{0.027758183942825754`, 1.}}], 
     ArrowBox[{{1.0308580668457081`, 1.09385754710214}, {1.2548562188685768`, 
      1.191856738612145}}]}, 
    {Arrowheads[{{0.03367939645188956, 1.}}], 
     ArrowBox[{{1.0028582978428495`, 1.3795718328164255`}, {
      1.2828559878714352`, 1.4775710243264306`}}]}, 
    {Arrowheads[{{0.039735724723099955`, 1.}}], 
     ArrowBox[{{0.9748585288399909, 1.665286118530711}, {1.3108557568742938`, 
      1.7632853100407162`}}]}, 
    {Arrowheads[{{0.0458736852402663, 1.}}], 
     ArrowBox[{{0.9468587598371323, 1.9510004042449967`}, {
      1.3388555258771524`, 2.0489995957550016`}}]}, 
    {Arrowheads[{{0.045873685240266304`, 1.}}], 
     ArrowBox[{{1.624569811591438, -2.0489995957550025`}, {
      1.232573045551418, -1.9510004042449973`}}]}, 
    {Arrowheads[{{0.03973572472309998, 1.}}], 
     ArrowBox[{{1.5965700425885794`, -1.7632853100407169`}, {
      1.2605728145542763`, -1.6652861185307117`}}]}, 
    {Arrowheads[{{0.03367939645188959, 1.}}], 
     ArrowBox[{{1.568570273585721, -1.4775710243264313`}, {
      1.288572583557135, -1.3795718328164261`}}]}, 
    {Arrowheads[{{0.027758183942825775`, 1.}}], 
     ArrowBox[{{1.5405705045828624`, -1.1918567386121457`}, {
      1.3165723525599935`, -1.0938575471021406`}}]}, 
    {Arrowheads[{{0.0220810532038345, 1.}}], 
     ArrowBox[{{1.5125707355800038`, -0.9061424528978601}, {
      1.344572121562852, -0.8081432613878551}}]}, 
    {Arrowheads[{{0.016895861911249522`, 1.}}], 
     ArrowBox[{{1.4845709665771452`, -0.6204281671835744}, {
      1.3725718905657107`, -0.5224289756735694}}]}, 
    {Arrowheads[{{0.01281438618132284, 1.}}], 
     ArrowBox[{{1.4565711975742865`, -0.33471388146928865`}, {
      1.4005716595685693`, -0.23671468995928363`}}]}, 
    {Arrowheads[{{0.011126002922467992`, 1.}}], 
     ArrowBox[{{1.428571428571428, -0.04899959575500297}, {1.428571428571428, 
      0.04899959575500208}}]}, 
    {Arrowheads[{{0.012814386181322827`, 1.}}], 
     ArrowBox[{{1.4005716595685693`, 0.23671468995928274`}, {
      1.4565711975742863`, 0.33471388146928777`}}]}, 
    {Arrowheads[{{0.0168958619112495, 1.}}], 
     ArrowBox[{{1.3725718905657107`, 0.5224289756735684}, {1.484570966577145, 
      0.6204281671835734}}]}, 
    {Arrowheads[{{0.0220810532038345, 1.}}], 
     ArrowBox[{{1.344572121562852, 0.8081432613878541}, {1.5125707355800038`, 
      0.9061424528978591}}]}, 
    {Arrowheads[{{0.027758183942825754`, 1.}}], 
     ArrowBox[{{1.3165723525599937`, 1.09385754710214}, {1.5405705045828624`, 
      1.191856738612145}}]}, 
    {Arrowheads[{{0.03367939645188956, 1.}}], 
     ArrowBox[{{1.288572583557135, 1.3795718328164255`}, {1.5685702735857208`,
       1.4775710243264306`}}]}, 
    {Arrowheads[{{0.039735724723099955`, 1.}}], 
     ArrowBox[{{1.2605728145542765`, 1.665286118530711}, {1.5965700425885794`,
       1.7632853100407162`}}]}, 
    {Arrowheads[{{0.0458736852402663, 1.}}], 
     ArrowBox[{{1.232573045551418, 1.9510004042449967`}, {1.624569811591438, 
      2.0489995957550016`}}]}, 
    {Arrowheads[{{0.045873685240266304`, 1.}}], 
     ArrowBox[{{1.9102840973057236`, -2.0489995957550025`}, {
      1.5182873312657035`, -1.9510004042449973`}}]}, 
    {Arrowheads[{{0.03973572472309998, 1.}}], 
     ArrowBox[{{1.882284328302865, -1.7632853100407169`}, {
      1.5462871002685619`, -1.6652861185307117`}}]}, 
    {Arrowheads[{{0.03367939645188959, 1.}}], 
     ArrowBox[{{1.8542845593000066`, -1.4775710243264313`}, {
      1.5742868692714207`, -1.3795718328164261`}}]}, 
    {Arrowheads[{{0.027758183942825775`, 1.}}], 
     ArrowBox[{{1.826284790297148, -1.1918567386121457`}, {
      1.602286638274279, -1.0938575471021406`}}]}, 
    {Arrowheads[{{0.0220810532038345, 1.}}], 
     ArrowBox[{{1.7982850212942894`, -0.9061424528978601}, {
      1.6302864072771377`, -0.8081432613878551}}]}, 
    {Arrowheads[{{0.016895861911249522`, 1.}}], 
     ArrowBox[{{1.7702852522914307`, -0.6204281671835744}, {
      1.6582861762799963`, -0.5224289756735694}}]}, 
    {Arrowheads[{{0.01281438618132284, 1.}}], 
     ArrowBox[{{1.7422854832885721`, -0.33471388146928865`}, {
      1.686285945282855, -0.23671468995928363`}}]}, 
    {Arrowheads[{{0.011126002922467992`, 1.}}], 
     ArrowBox[{{1.7142857142857135`, -0.04899959575500297}, {
      1.7142857142857135`, 0.04899959575500208}}]}, 
    {Arrowheads[{{0.012814386181322827`, 1.}}], 
     ArrowBox[{{1.686285945282855, 0.23671468995928274`}, {1.742285483288572, 
      0.33471388146928777`}}]}, 
    {Arrowheads[{{0.0168958619112495, 1.}}], 
     ArrowBox[{{1.6582861762799963`, 0.5224289756735684}, {
      1.7702852522914305`, 0.6204281671835734}}]}, 
    {Arrowheads[{{0.0220810532038345, 1.}}], 
     ArrowBox[{{1.6302864072771377`, 0.8081432613878541}, {
      1.7982850212942894`, 0.9061424528978591}}]}, 
    {Arrowheads[{{0.027758183942825754`, 1.}}], 
     ArrowBox[{{1.6022866382742793`, 1.09385754710214}, {1.826284790297148, 
      1.191856738612145}}]}, 
    {Arrowheads[{{0.03367939645188956, 1.}}], 
     ArrowBox[{{1.5742868692714207`, 1.3795718328164255`}, {
      1.8542845593000064`, 1.4775710243264306`}}]}, 
    {Arrowheads[{{0.039735724723099955`, 1.}}], 
     ArrowBox[{{1.546287100268562, 1.665286118530711}, {1.882284328302865, 
      1.7632853100407162`}}]}, 
    {Arrowheads[{{0.0458736852402663, 1.}}], 
     ArrowBox[{{1.5182873312657035`, 1.9510004042449967`}, {
      1.9102840973057236`, 2.0489995957550016`}}]}, 
    {Arrowheads[{{0.045873685240266325`, 1.}}], 
     ArrowBox[{{2.1959983830200094`, -2.0489995957550025`}, {
      1.804001616979989, -1.9510004042449973`}}]}, 
    {Arrowheads[{{0.03973572472310001, 1.}}], 
     ArrowBox[{{2.1679986140171508`, -1.7632853100407169`}, {
      1.8320013859828475`, -1.6652861185307117`}}]}, 
    {Arrowheads[{{0.03367939645188959, 1.}}], 
     ArrowBox[{{2.139998845014292, -1.4775710243264313`}, {
      1.8600011549857063`, -1.3795718328164261`}}]}, 
    {Arrowheads[{{0.027758183942825775`, 1.}}], 
     ArrowBox[{{2.1119990760114336`, -1.1918567386121457`}, {
      1.8880009239885647`, -1.0938575471021406`}}]}, 
    {Arrowheads[{{0.0220810532038345, 1.}}], 
     ArrowBox[{{2.083999307008575, -0.9061424528978601}, {
      1.9160006929914233`, -0.8081432613878551}}]}, 
    {Arrowheads[{{0.016895861911249522`, 1.}}], 
     ArrowBox[{{2.0559995380057163`, -0.6204281671835744}, {
      1.944000461994282, -0.5224289756735694}}]}, 
    {Arrowheads[{{0.01281438618132284, 1.}}], 
     ArrowBox[{{2.0279997690028577`, -0.33471388146928865`}, {
      1.9720002309971405`, -0.23671468995928363`}}]}, 
    {Arrowheads[{{0.011126002922467992`, 1.}}], 
     ArrowBox[{{1.9999999999999991`, -0.04899959575500297}, {
      1.9999999999999991`, 0.04899959575500208}}]}, 
    {Arrowheads[{{0.01281438618132284, 1.}}], 
     ArrowBox[{{1.9720002309971405`, 0.23671468995928274`}, {
      2.0279997690028577`, 0.33471388146928777`}}]}, 
    {Arrowheads[{{0.016895861911249522`, 1.}}], 
     ArrowBox[{{1.944000461994282, 0.5224289756735684}, {2.0559995380057163`, 
      0.6204281671835734}}]}, 
    {Arrowheads[{{0.0220810532038345, 1.}}], 
     ArrowBox[{{1.9160006929914233`, 0.8081432613878541}, {2.083999307008575, 
      0.9061424528978591}}]}, 
    {Arrowheads[{{0.02775818394282571, 1.}}], 
     ArrowBox[{{1.888000923988565, 1.09385754710214}, {2.111999076011433, 
      1.191856738612145}}]}, 
    {Arrowheads[{{0.03367939645188954, 1.}}], 
     ArrowBox[{{1.8600011549857063`, 1.3795718328164255`}, {
      2.1399988450142917`, 1.4775710243264306`}}]}, 
    {Arrowheads[{{0.03973572472309998, 1.}}], 
     ArrowBox[{{1.8320013859828477`, 1.665286118530711}, {2.1679986140171508`,
       1.7632853100407162`}}]}, 
    {Arrowheads[{{0.04587368524026632, 1.}}], 
     ArrowBox[{{1.804001616979989, 1.9510004042449967`}, {2.1959983830200094`,
       2.0489995957550016`}}]}}},
  AspectRatio->1,
  Frame->True,
  GridLines->Automatic,
  Method->{"TransparentPolygonMesh" -> True},
  PlotRange->{{-2.2020305089104424`, 
   2.2020305089104424`}, {-2.2020305089104424`, 2.2020305089104424`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.6096696481115746`*^9, 3.609669666505414*^9}, 
   3.6096697097867413`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\[LineSeparator]\[LineSeparator]#6", "Subsubsection",
 CellChangeTimes->{{3.609669764832246*^9, 3.6096697673124933`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"myf", "=", 
   RowBox[{
    RowBox[{"x", "^", "2"}], " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"y", " ", "z"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"D", "[", 
  RowBox[{"myf", ",", "x"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{"myf", ",", "y"}], "]"}], "   "}], "\[IndentingNewLine]", 
 RowBox[{"D", "[", 
  RowBox[{"myf", ",", "z"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6096697732090836`*^9, 3.609669885630324*^9}}],

Cell[BoxData[
 RowBox[{"2", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"y", " ", "z"}]], " ", "x"}]], "Output",
 CellChangeTimes->{{3.6096698428060417`*^9, 3.6096698859403553`*^9}}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"y", " ", "z"}]], " ", 
  SuperscriptBox["x", "2"], " ", "z"}]], "Output",
 CellChangeTimes->{{3.6096698428060417`*^9, 3.609669885941355*^9}}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"y", " ", "z"}]], " ", 
  SuperscriptBox["x", "2"], " ", "y"}]], "Output",
 CellChangeTimes->{{3.6096698428060417`*^9, 3.609669885942355*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\[LineSeparator]\[LineSeparator]#7", "Subsubsection",
 CellChangeTimes->{{3.6096699579189954`*^9, 3.6096699616139956`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"myF", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", " ", "y"}], ",", 
     RowBox[{
      RowBox[{"y", "^", "2"}], "-", 
      RowBox[{"2", " ", "z"}]}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"y", " ", "z"}], "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Div", "[", 
  RowBox[{"myF", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6096699680879955`*^9, 3.6096700400909953`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", "y"}], "+", 
  RowBox[{"y", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"y", " ", "z"}], "]"}]}]}]], "Output",
 CellChangeTimes->{{3.6096700189989953`*^9, 3.6096700405629954`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Curl", "[", 
  RowBox[{"myF", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6096700607509956`*^9, 3.609670070072995*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "+", 
    RowBox[{"z", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"y", " ", "z"}], "]"}]}]}], ",", "0", ",", 
   RowBox[{"-", "x"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6096700706019955`*^9}]
}, Open  ]],

Cell["", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\[LineSeparator]\[LineSeparator]#9", "Subsubsection",
 CellChangeTimes->{{3.609687211662755*^9, 3.609687215718226*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myr", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "2"}], "}"}], "+", 
   RowBox[{"t", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", 
      RowBox[{"-", "1"}]}], "}"}]}]}]}]], "Input",
 CellChangeTimes->{{3.609687225878221*^9, 3.609687259052877*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "t"}]}], ",", 
   RowBox[{"4", " ", "t"}], ",", 
   RowBox[{"2", "-", "t"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6096872619494467`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myrp", "=", 
  RowBox[{"D", "[", 
   RowBox[{"myr", ",", "t"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.609687271201435*^9, 3.609687282768649*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "4", ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 CellChangeTimes->{3.609687286617385*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myF", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"2", "x"}], ",", 
    RowBox[{
     RowBox[{"y", "^", "2"}], "+", "z"}], ",", 
    RowBox[{"x", "+", "y"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.609687301682103*^9, 3.6096873312256107`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", "x"}], ",", 
   RowBox[{
    SuperscriptBox["y", "2"], "+", "z"}], ",", 
   RowBox[{"x", "+", "y"}]}], "}"}]], "Output",
 CellChangeTimes->{3.609687332766602*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myFoft", "=", 
  RowBox[{"myF", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "t"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"4", " ", "t"}]}], ",", 
     RowBox[{"z", "\[Rule]", " ", 
      RowBox[{"2", "-", "t"}]}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.6096873344651337`*^9, 3.609687442600525*^9}, {
  3.609687498368573*^9, 3.609687504111433*^9}, {3.6096878944527597`*^9, 
  3.609687897141724*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "t"}]}], ")"}]}], ",", 
   RowBox[{"2", "-", "t", "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["t", "2"]}]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"6", " ", "t"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6096874085220346`*^9, 3.609687443555662*^9, 3.609687504669498*^9, {
   3.6096878991502237`*^9, 3.609687914373693*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.6096879023654413`*^9, 3.6096879119316807`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "+", 
    RowBox[{"4", " ", "t"}]}], ",", 
   RowBox[{"2", "-", "t", "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["t", "2"]}]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"6", " ", "t"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.609687907071025*^9, 3.609687916859583*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myIntegrand", " ", "=", " ", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"myFoft", ".", "myrp"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.609687475485929*^9, 3.609687534342455*^9}}],

Cell[BoxData[
 RowBox[{"11", "-", 
  RowBox[{"2", " ", "t"}], "+", 
  RowBox[{"64", " ", 
   SuperscriptBox["t", "2"]}]}]], "Output",
 CellChangeTimes->{{3.609687489693828*^9, 3.609687534766597*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "1"], 
  RowBox[{"myIntegrand", 
   RowBox[{"\[DifferentialD]", "t"}]}]}]], "Input",
 CellChangeTimes->{{3.609687742423633*^9, 3.609687760104858*^9}}],

Cell[BoxData[
 FractionBox["94", "3"]], "Output",
 CellChangeTimes->{3.609687760946566*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\[LineSeparator]\[LineSeparator]#13", "Subsubsection",
 CellChangeTimes->{{3.6097642943062773`*^9, 3.609764296417221*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", "x", " ", "y"}], ")"}], 
   RowBox[{"\[DifferentialD]", "y"}]}]}]], "Input",
 CellChangeTimes->{{3.6097645277366123`*^9, 3.6097645315522423`*^9}, {
  3.6097654520047407`*^9, 3.609765461793778*^9}}],

Cell[BoxData[
 RowBox[{"x", " ", 
  SuperscriptBox["y", "2"]}]], "Output",
 CellChangeTimes->{3.609764533258442*^9, 3.609764596265482*^9, 
  3.6097654627828703`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"%", "/.", 
     RowBox[{"y", "\[Rule]", "2"}]}], ")"}], " ", "-", 
   RowBox[{"(", 
    RowBox[{"%", "/.", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"x", "/", "2"}]}]}], ")"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.609764563748518*^9, 3.609764622583246*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"4", " ", "x"}], "-", 
  FractionBox[
   SuperscriptBox["x", "3"], "4"]}]], "Output",
 CellChangeTimes->{3.6097645920308847`*^9, 3.609764623664085*^9, 
  3.609765468585383*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myyint", "=", 
  RowBox[{
   SubsuperscriptBox["\[Integral]", 
    RowBox[{"x", "/", "2"}], "2"], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "x", " ", "y"}], ")"}], 
    RowBox[{"\[DifferentialD]", "y"}]}]}]}]], "Input",
 CellChangeTimes->{{3.609764418759235*^9, 3.6097644798958197`*^9}, {
  3.609765494067072*^9, 3.609765504753072*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"4", " ", "x"}], "-", 
  FractionBox[
   SuperscriptBox["x", "3"], "4"]}]], "Output",
 CellChangeTimes->{
  3.609764481507784*^9, {3.609765473873188*^9, 3.6097655055347643`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"myyint", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.6097646820530863`*^9, 3.60976468838479*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  FractionBox[
   SuperscriptBox["x", "4"], "16"]}]], "Output",
 CellChangeTimes->{3.609764689381325*^9, 3.609765516324992*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"(", 
   RowBox[{"%", "/.", 
    RowBox[{"x", "\[Rule]", "4"}]}], ")"}], "]"}]], "Input",
 CellChangeTimes->{{3.6097646946473227`*^9, 3.609764725688883*^9}}],

Cell[BoxData["16"], "Output",
 CellChangeTimes->{3.609764727614883*^9, 3.609765519676326*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{740, 867},
WindowMargins->{{4, Automatic}, {Automatic, 4}},
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, \
2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 88, 1, 92, "Title"],
Cell[CellGroupData[{
Cell[692, 27, 140, 1, 83, "Subsubsection"],
Cell[CellGroupData[{
Cell[857, 32, 443, 12, 28, "Input"],
Cell[1303, 46, 308, 9, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1648, 60, 413, 12, 48, "Input"],
Cell[2064, 74, 276, 8, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2377, 87, 532, 16, 48, "Input"],
Cell[2912, 105, 243, 7, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3192, 117, 178, 4, 47, "Input"],
Cell[3373, 123, 296, 9, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3706, 137, 149, 3, 28, "Input"],
Cell[3858, 142, 72, 1, 28, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3979, 149, 127, 1, 83, "Subsubsection"],
Cell[CellGroupData[{
Cell[4131, 154, 327, 9, 48, "Input"],
Cell[4461, 165, 101, 3, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4599, 173, 225, 5, 28, "Input"],
Cell[4827, 180, 112, 1, 28, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4988, 187, 142, 1, 83, "Subsubsection"],
Cell[CellGroupData[{
Cell[5155, 192, 197, 5, 28, "Input"],
Cell[5355, 199, 545, 11, 24, "Message"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5937, 215, 557, 15, 28, "Input"],
Cell[6497, 232, 36611, 698, 374, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43157, 936, 127, 1, 83, "Subsubsection"],
Cell[CellGroupData[{
Cell[43309, 941, 530, 14, 97, "Input"],
Cell[43842, 957, 192, 4, 31, "Output"],
Cell[44037, 963, 214, 5, 32, "Output"],
Cell[44254, 970, 214, 5, 32, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[44517, 981, 129, 1, 83, "Subsubsection"],
Cell[CellGroupData[{
Cell[44671, 986, 507, 15, 46, "Input"],
Cell[45181, 1003, 222, 6, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45440, 1014, 209, 5, 28, "Input"],
Cell[45652, 1021, 255, 8, 28, "Output"]
}, Open  ]],
Cell[45922, 1032, 16, 0, 30, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45975, 1037, 125, 1, 83, "Subsubsection"],
Cell[CellGroupData[{
Cell[46125, 1042, 301, 9, 28, "Input"],
Cell[46429, 1053, 224, 7, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46690, 1065, 172, 4, 28, "Input"],
Cell[46865, 1071, 144, 4, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47046, 1080, 272, 8, 28, "Input"],
Cell[47321, 1090, 223, 7, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47581, 1102, 517, 14, 28, "Input"],
Cell[48101, 1118, 464, 14, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48602, 1137, 131, 2, 28, "Input"],
Cell[48736, 1141, 334, 10, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49107, 1156, 206, 4, 28, "Input"],
Cell[49316, 1162, 199, 5, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49552, 1172, 214, 5, 47, "Input"],
Cell[49769, 1179, 91, 2, 48, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49909, 1187, 128, 1, 83, "Subsubsection"],
Cell[CellGroupData[{
Cell[50062, 1192, 281, 7, 47, "Input"],
Cell[50346, 1201, 165, 4, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50548, 1210, 346, 10, 28, "Input"],
Cell[50897, 1222, 210, 6, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51144, 1233, 367, 10, 48, "Input"],
Cell[51514, 1245, 212, 6, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51763, 1256, 178, 4, 47, "Input"],
Cell[51944, 1262, 209, 6, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52190, 1273, 208, 5, 28, "Input"],
Cell[52401, 1280, 93, 1, 62, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
