<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
3-D coordinate systems [9.1] 
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>


<h1>3-dimensional coordinate systems [9.1]</h1>
<p class="show">Locating objects in 3-dimensions.<br>
<img src="0g/9.1.balloons.jpg" class="big"><br>
<ul class="else"><li><i>Right-handed</i> Cartesian coordinates
<li>Points in 3-D space
<li>Equations of planes
<li>Distance formula in 3 dimensions
<li>Equations of spheres
</ul>

<h3>Rectangular coordinates</h3>
<p class='show center'><img src="0g/9.1.rectanglesystem.jpg">
<p class="show">Also known as <b><a href="http://mathworld.wolfram.com/CartesianCoordinates.html">Cartesian</a></b> coordinates, after Renes Descartes
</p>

<h3>Right-handed coordinate system</h3>
<p class='show center'><img src="0g/9.1.rh.jpg">
<ol>
<li>Take your <b>right</b> hand...
<li>Point your <b>straight fingers</b> in the $\hat x$ direction.
<li>Rotate your hand so that you can <b>curl your fingers</b>* 
to point in the $\hat y$ direction.
<li>Your <b>thumb</b> now points in the $\hat z$ direction.
</ol> 
<p class="show">* You need to be able to curl your fingers through an angle less than $180^o$.

<p class="justme">Try x and y, then x and z and y and z, and figure out which way the other axis points.</p>

<!--
<h3>To Do</h3>
<ul class="todo">
<li>Create a set of coordinate axes [pipecleaners]
<li>Do the <i>Visualizing the xyz coordinate system</i> worksheet (See <a
href="https://people.goshen.edu/~paulmr/physix/213/handouts/09.1.VisualizingXYZ.php">the "handouts" folder</a>):<br>
<b>Write down</b> which color is your $x$-axis, your $y$-axis, and your $z$-axis. 
</ul>
-->

<h3>Coordinate planes</h3>
<p class='show center'><img src="0g/9.1.planes.jpg">

<h3>Coordinates</h3>
<p class='show center'><img src="0g/9.1.coordinates.jpg">

<h3>Projections</h3>
<p class='show center'><img src="0g/9.1.projections.jpg">
<p class='show'>$S$ is the projection of $P$ onto the $xz$ plane.
<p>$(0,b,0)$ is the projection of $P$ onto the $y$-axis.




<h3>The space $\mathbb{R}^3$</h3>
<p class='show'>$\mathbb{R}\equiv$ the real numbers.

<ul>

<li>Cartesian Product:<br>
$\mathbb{R}^3\equiv \mathbb{R}\times\mathbb{R}\times\mathbb{R}=\{(x,y,z) | x,y,z\in \mathbb{R}\}$.
<li>Set of all <i>ordered</i> triples.
</ul>

<!--
<h3>To Do</h3>
<ul class="todo">
<li>
<i>Points in the xyz coordinate system</i> worksheet
</ul>
-->

<h3>Surfaces in $\mathbb{R}^3$</h3>
<p class='show center'><img src="0g/9.1.surf1.jpg"><br>
All points with coordinates $(a,b,c)$ where $c=3$ <br>
[and $a$ and $b$ can be anything]

<p class='show center incremental'><img src="0g/9.1.surf2.jpg"><br>

<p class='show center incremental'><img src="0g/9.1.surf3.jpg"><br>
All points with coordinates $(x,y,z)$ where $y=x$.
<p>Notice that $y=x$ is the definition of a <i>line</i> in 2-d with a slope of 1.  But here??
<p>Anything a bit deceptive about the picture above?</p>
<p class="justme">Should continue to values with x and y less than 0...</p>




<h3  class="justme">To Do</h3>
<ul  class="justme">
<li>Section 9.1 Group Work: Fun with Visualization [missing]
<li>Working with surfaces in 3D space  [missing]
</ul>




<h3>Distance</h3>
<p class="show">What is the distance $|P_1P_2|$ between two points $P_1(x_1,y_1,z_1)$ and $P_2(x_2,y_2,z_2)$ in three dimensional space?

<p>With $\Delta x=x_2-x_1$, etc, you can imagine applying Pythagoras' theorem twice [<a href="https://www.geogebra.org/3d/pukzw5yn">at GeoGebra</a>, <a href="0g/9.1.distance.nb">9.1.distance.nb</a>]:
<br>
<img src="0g/9.1.distance.png"><br>


<ul class="else">
<li>The <span style="color:blue">blue line</span> is the hypotenuse of the triangle with legs $\Delta x$ and $\Delta y$:  It's length is $\sqrt{(\Delta x)^2+(\Delta y)^2}$.
<li>The <span style="color:green">green line</span> is our <b>distance</b>, and is the hypotenuse of the right triangle with legs of $\Delta z$ and the <span style="color:blue">blue line</span>.
</ul>
<p>So, our distance formula is:
$$|P_1P_2|=\sqrt{(x_2-x_1)^2+(y_2-y_1)^2+(z_2-z_1)^2}.$$


<h4>Equation of a sphere</h4>
<p>All the points on a <b>sphere</b> are the same distance, $r$, away from its center, $C(h,k,l)$. Using the distance formula:

$$(x-h)^2+(y-k)^2+(z-l)^2 = r^2.$$


<div class="todo">
<p>These equations describe <i>sets of points</i>,$\{(x,y,z)\}$ that fulfill the equation equation.  For each equation, make a guess at the <b>surface</b> corresponding to the equation, then check it by typing the equation into <i>GeoGebra</i>:  [Hint, think about what the distance formula implies.]
<ol>
<li>$$ 9=x^2+y^2+z^2.$$
<li>$$z=\sqrt{ 9-x^2-y^2}.$$

<li>$$9=x^2+y^2.$$
</ol>


<h3>Problem 9.1.038</h3>
<p>Consider a 2-d variation of this problem...<i>Find all the points, $P$, (they form a circle) that are twice as far from $A$ as they are from $B$.</i>
<br>
<img src="0g/9.1.038.jpg"><br>
Well... It ought to be possible to find *some* of the points $P$.  Consider these (leading) questions:

<ol><li>How would you find the coordinates of a point which is <i>halfway</i> between $A$ and $B$?
<li>One of the points in the set $\{P\}$ should be on the line segment between $A$ and $B$.  <i>What fraction of the distance</i> from $A$ to $B$ is that point?
<li>What are the coordinates of that point?
<li>There is one other point in $\{P\}$ along the red line, but not between $A$ and $B$.  What fractional distance would it be?  That is... if the distance from $A$ to $B$ were 1, what would the distance from $A$ to this second point be?

<li>Now we have a segment of the red line that connects two points on a circle.  <i>Either</i> the line segment is a diameter line, or it is not.
Can you make an argument for why the center of the circle could, or could not be away from the line segment?
<li>So, where is the center of the circle? And what is its radius?
</ul>
</div>

<h4>Image credits</h4>
<p class="handout"><a href="http://www.flickr.com/photos/71651012@N00/3758383978">Mortimer</a>
<?php include "../../classes/3.h" ?>
