(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    384380,       6452]
NotebookOptionsPosition[    383048,       6406]
NotebookOutlinePosition[    383402,       6422]
CellTagsIndexPosition[    383359,       6419]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", " ", 
       RowBox[{"t", "^", "2"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Red", ",", 
        RowBox[{"Thickness", "[", "0.05", "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", " ", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "-", "t"}], ")"}], ",", " ", "4"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Green", ",", 
        RowBox[{"Thickness", "[", "0.05", "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3", "=", " ", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", " ", 
       RowBox[{"4", "-", "t"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Orange", ",", 
        RowBox[{"Thickness", "[", "0.05", "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}], "]"}], 
  " "}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5883829089944773`*^9, 3.588383057943446*^9}, {
   3.588461100822338*^9, 3.5884611138295393`*^9}, 3.588461156748122*^9, {
   3.588462074889436*^9, 3.5884622323725357`*^9}, {3.588462269757886*^9, 
   3.588462305162922*^9}, 3.5884626063861923`*^9, {3.588462646176485*^9, 
   3.588462718401167*^9}, {3.5884627545286407`*^9, 3.588462762262672*^9}, {
   3.588462808429019*^9, 3.588462868995009*^9}, {3.588462917105647*^9, 
   3.588462972647081*^9}, {3.58846316559306*^9, 3.58846322494445*^9}, {
   3.588463258302782*^9, 3.588463441699823*^9}, {3.5884634819706993`*^9, 
   3.5884634975589943`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[1, 0, 0], Thickness[0.05], LineBox[CompressedData["
1:eJxd1mk0VW0fBnCSHKlzDKVCgyEZGpTKk+LaiVRmaTJlqCRvkqJCQknJY4jI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      "]]}}, {{}, {}, 
    {RGBColor[0, 1, 0], Thickness[0.05], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQDQUOEErAQWjJ7Qcz1/+3h/FVPbYfNI5H8C+f+vX/
wYZ/cH7FAZ2p0nwIvovY9d72vL9w/qxlvMy5B//A+c9WGp2/L4/g73n+WPxM
wW84f0cr75GXR37B+WumqR6fooLgazw66baz7CecP2dBjGz2lR9wvtn+9HA/
UwQ/SuI/7+qO73B+yZMW6anPv8H54q+nLf1hgeA/ClSc3Nv7Fc5frD3r+vq3
X+D8d/bzZ3g7IPj6xydtKJn3Gc7/1SHkKv7+E5z/ZhWX7WsnBP+K/cdun0Uf
4Xw3/pRw9S8f4Px1gUcr+wMR/KoXtv8DU94jwmMRJ0sF1zs4/5TTpm07jr+B
8/+EFye9yXwN59foql5tEnoF5794sfmr8aUXcH6GZDT/jbLnCPfp3782zegZ
nD+BLSR1x5cncH5c0MM3Z2Y/hvOlWryV/kQ+QpivdS5A7u8DRHrIj47alncf
zo/g/LPg6/s7CPN7z96Usr4F5y+5G5FXuuU6nH9HXPTr1u9X4PwNlzZx7nG/
BOcf2CTy5V33eYR/pqjuNJQ5Beef4F1lep/jKJyf0PHxrDj/AYT960ynWgRt
hfMbvt/7pVu3DI0/Dc5nQAECDgAx1enP
      "]]}}, {{}, {}, 
    {RGBColor[1, 0.5, 0], Thickness[0.05], LineBox[CompressedData["
1:eJxTTMoPSmViYGDwBWIQjQoEHGAsxbts52v+8sP5jrt45/38heA3lUjbfP6K
4LO+NKt49hrB57yU++HMdQRfaMntBzPXI/iqHtsPGscj+JdP/fr/YAMfnF9x
QGeqNB+C7yJ2vbc9jxfOn7WMlzn3IA+c/2yl0fn78gj+nuePxc8UcMP5O1p5
j7w8wgXnr5mmenyKCoKv8eik284yTjh/zoIY2ewrHHC+2f70cD9TBD9K4j/v
6g52OL/kSYv01OdscL7462lLf1gg+I8CFSf39rLC+Yu1Z11f/5YFzn9nP3+G
twOCr3980oaSecxw/q8OIVfx90xw/ptVXLavnRD8K/Yfu30WMcL5bvwp4epf
GOD8dYFHK/sDEfyqF7b/A1P+28PDYxEnSwXXPzj/lNOmbTuO/4Hz/4QXJ73J
/A3n1+iqXm0S+gXnv3ix+avxpR9wfoZkNP+Nsu9w/hX9+9emGX2D8yewhaTu
+PIFzo8LevjmzOzPcL5Ui7fSn8hPCPO1zgXI/f0A57vkR0dty3sP50dw/lnw
9f0bhPm9Z29KWb+C85fcjcgr3fIczr8jLvp16/cncP6GS5s497g/gvMPbBL5
8q77PsI/U1R3GsrcgvNP8K4yvc9xFc5P6Ph4Vpz/AsL+daZTLYKOwvkN3+/9
0q3bBucvqP7sZKqC4B/4z95tc2ornM/AYSjtLYbgN0g0W2es24zQb6les+je
BjTzl6GZtxTNvKVo5i1G8MHmLUAzbxqa/qkIviRI/2QE3wqkfwKC/wOkvw1N
fTOa+gY09WVo8gVo8mlo/DAEHwoAIhAaXw==
      "]]}}},
  AspectRatio->1.052224097225267,
  Axes->True,
  AxesOrigin->{0, 0},
  ImageSize->{293.8693080357143, 177.44921875},
  Method->{},
  PlotRange->{{0., 2.}, {0., 4.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.588463288491736*^9, {3.588463345161765*^9, 3.588463375235092*^9}, {
   3.588463426615312*^9, 3.588463442547348*^9}, 3.588463498074543*^9}]
}, Open  ]],

Cell[TextData[{
 "\[LineSeparator]\[LineSeparator]\[LineSeparator]",
 StyleBox["Plotting ", "Subtitle"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"<", "t"}], ",", 
    SuperscriptBox["t", "2"], ",", 
    RowBox[{
     SuperscriptBox["t", "3"], ">"}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "\n\nWe see that y(t)=t^2=x^2, and z(t)=t^3=x^3.  Let\[CloseCurlyQuote]s \
plot the two resulting surfaces and look at intersections...\[LineSeparator]\
\[LineSeparator]\[LineSeparator]\[LineSeparator]\[LineSeparator]",
 StyleBox["y=x^2",
  FontWeight->"Bold"],
 " for any z\[LineSeparator]To accomplish the \[OpenCurlyDoubleQuote]any z\
\[CloseCurlyDoubleQuote] part we use an independent second parameter \
\[OpenCurlyQuote]s\[CloseCurlyQuote] to vary z independently of \
\[OpenCurlyQuote]t\[CloseCurlyQuote]:"
}], "Text",
 CellChangeTimes->{{3.5885405618925943`*^9, 3.588540605712425*^9}, {
  3.588541997074733*^9, 3.588542022087508*^9}, {3.588542177496361*^9, 
  3.5885422396801023`*^9}, {3.5885424479551373`*^9, 3.5885425223979692`*^9}, {
  3.588542559053442*^9, 3.5885426288601723`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p1", "=", 
  RowBox[{"ParametricPlot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"t", ",", 
      RowBox[{"t", "^", "2"}], ",", "s"}], "}"}], ",", "\[IndentingNewLine]", 
    
    RowBox[{"{", 
     RowBox[{"t", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", 
      RowBox[{"-", "7"}], ",", "7"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Axes", "\[Rule]", "True"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.588540095528891*^9, 3.588540117161758*^9}, {
  3.588540197686862*^9, 3.5885402040320873`*^9}, {3.588540428990322*^9, 
  3.588540473054099*^9}, {3.5885406174497538`*^9, 3.588540663319901*^9}, {
  3.588540891920306*^9, 3.588540950354453*^9}, {3.588541188724175*^9, 
  3.588541237477099*^9}, {3.588541344571697*^9, 3.588541349697345*^9}, {
  3.588541404042207*^9, 3.588541436254136*^9}, {3.588541530388783*^9, 
  3.588541533972105*^9}, {3.588541879353758*^9, 3.5885418844067802`*^9}, {
  3.588542069944466*^9, 3.588542084682124*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyFnXvUV1WZx1HueEt8VcQb1JuappmKYL7Tfh26iFxkSWUtJ5pAXS5XaDGV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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxFmwf8V9P/xz/33nPvJQ0hlYY0VIo0jKwUMrKJSkJpaMgopKGioaGflb0q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         "]], Polygon3DBox[CompressedData["
1:eJwtm3ngF1MbxWfmzr1fKZEkJVpVdmWnCC2E9pCyVBKiIi2WSlHZhayJ7Pu+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         "]], Polygon3DBox[CompressedData["
1:eJwt13mgTeUWAPDTde+WlKJShgxNKIRGsyhC5qFMSaFShgrhmmeZQmQeKzKk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         "]], 
        Polygon3DBox[{{1702, 1242, 1241, 1701, 941, 942}, {1247, 1389, 819, 
         945, 1705, 1246}}]}]}, {}, {}, {}, {}}, {{}, {}, {}, {
      Line3DBox[{518, 723, 1712, 519, 735, 1722, 543, 1799, 748, 557, 1801, 
       761, 571, 1805, 774, 585, 1811, 787, 599, 1819, 800, 613, 1830, 813, 
       1754, 627, 826, 1766, 641, 1844, 839, 655, 1846, 852, 669, 1850, 865, 
       683, 1856, 878, 697, 1863, 891, 711}], 
      Line3DBox[{520, 724, 1713, 521, 736, 1723, 544, 749, 1732, 558, 1802, 
       762, 572, 1806, 775, 586, 1812, 788, 600, 1820, 801, 614, 1831, 814, 
       1755, 628, 827, 1767, 642, 840, 1777, 656, 1847, 853, 670, 1851, 866, 
       684, 1857, 879, 698, 1864, 892, 712}], 
      Line3DBox[{522, 725, 1714, 523, 737, 1724, 545, 750, 1733, 559, 763, 
       1740, 573, 1807, 776, 587, 1813, 789, 601, 1821, 802, 615, 1832, 815, 
       1756, 629, 828, 1768, 643, 841, 1778, 657, 854, 1785, 671, 1852, 867, 
       685, 1858, 880, 699, 1865, 893, 713}], 
      Line3DBox[{524, 726, 1715, 525, 738, 1725, 546, 751, 1734, 560, 764, 
       1741, 574, 777, 1746, 588, 1814, 790, 602, 1822, 803, 616, 1833, 816, 
       1757, 630, 829, 1769, 644, 842, 1779, 658, 855, 1786, 672, 868, 1791, 
       686, 1859, 881, 700, 1866, 894, 714}], 
      Line3DBox[{526, 903, 904, 1716, 527, 911, 912, 547, 916, 1875, 917, 561,
        921, 1878, 922, 575, 926, 1881, 927, 589, 931, 1884, 932, 603, 1823, 
       936, 937, 617, 1834, 941, 942, 1758, 631, 946, 947, 1770, 645, 951, 
       1887, 952, 659, 956, 1890, 957, 673, 961, 1893, 962, 687, 966, 1896, 
       967, 701, 1867, 972, 973, 974}], Line3DBox[CompressedData["
1:eJwNyqtLgwEUhvGjm7cgaDAsLCwYDAaDwbB/wmDwvuk2L9++eZlGu7dgsVgs
FsuKxWKxGE2CIAwGgiAIgiAIwn7h4T3PwymUG7NpT0TMYaQ3IpuN6MNLJuIY
w+4FLOKVJwMRF3aUL2EZb7yuX9oxvoJVtHmqX9kcL6GMea2jXSPP13Cirdt3
7QYFdwWnetV+aLcYdx9pNbuBT62Fdn/EBN/EFr60pr87O8m3keCbH+j3dorX
keKHH+oPdpo3sIOq9qs9Yobv4kzbs3/aE4rufZzrTfuvDdlBPLu7XXQtIA==

       "]], 
      Line3DBox[{532, 730, 1718, 533, 742, 1727, 551, 755, 1735, 565, 1803, 
       768, 579, 1808, 781, 593, 1815, 794, 607, 1825, 807, 621, 1837, 820, 
       1761, 635, 833, 1772, 649, 846, 1780, 663, 1848, 859, 677, 1853, 872, 
       691, 1860, 885, 705, 1869, 898, 718}], 
      Line3DBox[{534, 731, 1719, 535, 743, 1728, 552, 756, 1736, 566, 769, 
       1742, 580, 1809, 782, 594, 1816, 795, 608, 1826, 808, 622, 1838, 821, 
       1762, 636, 834, 1773, 650, 847, 1781, 664, 860, 1787, 678, 1854, 873, 
       692, 1861, 886, 706, 1870, 899, 719}], 
      Line3DBox[{536, 732, 1720, 537, 744, 1729, 553, 757, 1737, 567, 770, 
       1743, 581, 783, 1747, 595, 1817, 796, 609, 1827, 809, 623, 1839, 822, 
       1763, 637, 835, 1774, 651, 848, 1782, 665, 861, 1788, 679, 874, 1792, 
       693, 1862, 887, 707, 1871, 900, 720}], 
      Line3DBox[{538, 733, 1721, 539, 745, 1730, 554, 758, 1738, 568, 771, 
       1744, 582, 784, 1748, 596, 797, 1750, 610, 1828, 810, 624, 1840, 823, 
       1764, 638, 836, 1775, 652, 849, 1783, 666, 862, 1789, 680, 875, 1793, 
       694, 888, 1795, 708, 1872, 901, 721}], 
      Line3DBox[{540, 909, 1873, 910, 541, 746, 1731, 555, 759, 1739, 569, 
       772, 1745, 583, 785, 1749, 597, 798, 1751, 611, 811, 1752, 625, 1841, 
       824, 1765, 639, 837, 1776, 653, 850, 1784, 667, 863, 1790, 681, 876, 
       1794, 695, 889, 1796, 709, 978, 1899, 979, 980}], 
      Line3DBox[{710, 890, 1898, 971, 696, 877, 1855, 682, 864, 1849, 668, 
       851, 1845, 654, 838, 1843, 640, 825, 1842, 626, 1753, 812, 1829, 612, 
       799, 1818, 598, 786, 1810, 584, 773, 1804, 570, 760, 1800, 556, 747, 
       1798, 542, 734, 1797, 517, 722, 902, 981}], Line3DBox[CompressedData["
1:eJwV0Nsq5WEcxvF3oRRibJolJjOMEJPNEBMy9nsLa8Y2R8qJgxEnOJD9Ms5d
wVyBK3ADLkAppZRSiqaUEvmsg2/f5/e8z8G/f+niSvxPJISwg/OUELZTQ8hM
CyEFb/JP7sRueggdfGazpp+X5/Ait/Gm93ZuxanNkn5WnsGz3MLrNj+4Gf9s
ZvXT8rF+ip/cjdyE7zixGdH9lv/a/OL/7jquRy0SNh26I+9x9yQe3DX8DdXY
sGnQJWwm3OO4d1dyFbb1FbxsV66PyWO4k79yObZsynjBJqoflUdwK3/mVe9f
uAQxmwz9sDyEG7mYV2w+cVHyn9q8YlA+1A/wtV2UC/Ex+Q+8P6JfPrDp4yub
fC5AXvLbvN9g33uvuweXNjn8AdnI9X6BPZtudxcubCKchYBUvAPCEDLa
       "]], 
      Line3DBox[{716, 896, 1034, 1023, 1915, 975, 703, 883, 1020, 1914, 969, 
       689, 870, 1017, 1912, 964, 675, 857, 1891, 1014, 959, 661, 844, 1888, 
       1011, 954, 647, 831, 1886, 1008, 949, 633, 1920, 818, 1005, 944, 1835, 
       619, 805, 1002, 1907, 939, 605, 792, 999, 1906, 934, 591, 779, 996, 
       1904, 929, 577, 766, 1879, 993, 924, 563, 753, 1876, 990, 919, 549, 
       740, 1874, 987, 914, 530, 1916, 728, 984, 1031, 1030, 906}], 
      Line3DBox[{717, 897, 977, 1868, 704, 884, 1897, 970, 690, 871, 1895, 
       965, 676, 858, 1892, 960, 662, 845, 1889, 955, 648, 1771, 832, 950, 
       634, 1760, 819, 945, 1836, 620, 806, 940, 1824, 606, 793, 1885, 935, 
       592, 780, 1883, 930, 578, 767, 1880, 925, 564, 754, 1877, 920, 550, 
       1726, 741, 915, 531, 1717, 729, 907, 908}]}, {
      Line3DBox[{1142, 1428, 722, 1141, 1712, 1336, 1143, 1713, 1337, 1144, 
       1714, 1338, 1145, 1715, 1339, 1146, 1698, 1716, 1340, 1498, 905, 1518, 
       1568, 1615, 1922, 1571, 1569, 1570, 1519, 1916, 1341, 1499, 1429, 1717,
        1342, 1147, 1718, 1343, 1148, 1719, 1344, 1149, 1720, 1345, 1150, 
       1721, 1346, 1151, 1873, 1430, 1347, 1431}], 
      Line3DBox[{1153, 1616, 1797, 1152, 1722, 1348, 1154, 1723, 1349, 1155, 
       1724, 1350, 1156, 1725, 1351, 1157, 912, 1352, 1500, 1900, 1432, 1520, 
       1572, 1617, 1923, 1575, 1573, 1574, 1521, 1618, 1874, 1501, 1433, 1726,
        1353, 1158, 1727, 1354, 1159, 1728, 1355, 1160, 1729, 1356, 1161, 
       1730, 1357, 1162, 1731, 1358, 1163}], 
      Line3DBox[{1165, 1619, 1798, 1164, 1620, 1799, 1166, 1732, 1359, 1167, 
       1733, 1360, 1168, 1734, 1361, 1169, 1875, 1434, 1362, 1502, 1901, 1435,
        1522, 1576, 1596, 1577, 1924, 1503, 1578, 1436, 1523, 1621, 1876, 
       1504, 1437, 1622, 1877, 1170, 1735, 1363, 1171, 1736, 1364, 1172, 1737,
        1365, 1173, 1738, 1366, 1174, 1739, 1367, 1175}], 
      Line3DBox[{1177, 1623, 1800, 1176, 1624, 1801, 1178, 1625, 1802, 1179, 
       1740, 1368, 1180, 1741, 1369, 1181, 1878, 1438, 1370, 1505, 1902, 1439,
        1524, 1579, 1597, 1580, 1925, 1506, 1581, 1440, 1525, 1626, 1879, 
       1507, 1441, 1627, 1880, 1182, 1628, 1803, 1183, 1742, 1371, 1184, 1743,
        1372, 1185, 1744, 1373, 1186, 1745, 1374, 1187}], 
      Line3DBox[{1189, 1629, 1804, 1188, 1630, 1805, 1190, 1631, 1806, 1191, 
       1632, 1807, 1192, 1746, 1375, 1193, 1881, 1442, 1443, 1194, 1709, 1882,
        1444, 1604, 1445, 1598, 1528, 1903, 1529, 1527, 1446, 1526, 1447, 
       1904, 1195, 1448, 1449, 1883, 1196, 1633, 1808, 1197, 1634, 1809, 1198,
        1747, 1376, 1199, 1748, 1377, 1200, 1749, 1378, 1201}], 
      Line3DBox[{1203, 1635, 1810, 1202, 1636, 1811, 1204, 1637, 1812, 1205, 
       1638, 1813, 1206, 1639, 1814, 1207, 1884, 1450, 1451, 1208, 1930, 1605,
        1452, 1606, 1453, 1599, 1532, 1905, 1533, 1531, 1454, 1530, 1455, 
       1906, 1209, 1456, 1457, 1885, 1210, 1640, 1815, 1211, 1641, 1816, 1212,
        1642, 1817, 1213, 1750, 1379, 1214, 1751, 1380, 1215}], 
      Line3DBox[{1217, 1643, 1818, 1216, 1644, 1819, 1218, 1645, 1820, 1219, 
       1646, 1821, 1220, 1647, 1822, 1221, 1699, 1823, 1458, 1222, 1931, 1607,
        1608, 1534, 1539, 1538, 1917, 1223, 1536, 1537, 1535, 1459, 1907, 
       1224, 1460, 1824, 1700, 1225, 1648, 1825, 1226, 1649, 1826, 1227, 1650,
        1827, 1228, 1651, 1828, 1229, 1752, 1381, 1230}], 
      Line3DBox[{1234, 1753, 1382, 1232, 1754, 1383, 1236, 1755, 1384, 1238, 
       1756, 1385, 1240, 1757, 1386, 1242, 1702, 1758, 1387, 1508, 1703, 1759,
        1546, 1582, 1657, 1926, 1585, 1583, 1584, 1547, 1920, 1388, 1509, 
       1463, 1760, 1389, 1247, 1761, 1390, 1249, 1762, 1391, 1251, 1763, 1392,
        1253, 1764, 1393, 1255, 1765, 1394, 1257}], 
      Line3DBox[{1256, 1841, 1662, 1254, 1840, 1661, 1252, 1839, 1660, 1250, 
       1838, 1659, 1248, 1837, 1658, 1246, 1705, 1836, 1462, 1245, 1704, 1835,
        1541, 1543, 1542, 1244, 1919, 1544, 1545, 1540, 1609, 1918, 1710, 
       1243, 1461, 1834, 1701, 1241, 1833, 1656, 1239, 1832, 1655, 1237, 1831,
        1654, 1235, 1830, 1653, 1231, 1829, 1652, 1233}], 
      Line3DBox[{1259, 1663, 1842, 1258, 1766, 1395, 1260, 1767, 1396, 1261, 
       1768, 1397, 1262, 1769, 1398, 1263, 1706, 1770, 1399, 1510, 1908, 1464,
        1548, 1586, 1664, 1927, 1589, 1587, 1588, 1549, 1665, 1886, 1511, 
       1465, 1771, 1400, 1264, 1772, 1401, 1265, 1773, 1402, 1266, 1774, 1403,
        1267, 1775, 1404, 1268, 1776, 1405, 1269}], 
      Line3DBox[{1271, 1666, 1843, 1270, 1667, 1844, 1272, 1777, 1406, 1273, 
       1778, 1407, 1274, 1779, 1408, 1275, 1887, 1466, 1409, 1512, 1909, 1467,
        1550, 1590, 1600, 1591, 1928, 1513, 1592, 1468, 1551, 1668, 1888, 
       1514, 1469, 1669, 1889, 1276, 1780, 1410, 1277, 1781, 1411, 1278, 1782,
        1412, 1279, 1783, 1413, 1280, 1784, 1414, 1281}], 
      Line3DBox[{1283, 1670, 1845, 1282, 1671, 1846, 1284, 1672, 1847, 1285, 
       1785, 1415, 1286, 1786, 1416, 1287, 1890, 1470, 1417, 1515, 1910, 1471,
        1552, 1593, 1601, 1594, 1929, 1516, 1595, 1472, 1553, 1673, 1891, 
       1517, 1473, 1674, 1892, 1288, 1675, 1848, 1289, 1787, 1418, 1290, 1788,
        1419, 1291, 1789, 1420, 1292, 1790, 1421, 1293}], 
      Line3DBox[{1295, 1676, 1849, 1294, 1677, 1850, 1296, 1678, 1851, 1297, 
       1679, 1852, 1298, 1791, 1422, 1299, 1893, 1474, 1475, 1300, 1711, 1894,
        1476, 1610, 1477, 1602, 1556, 1911, 1557, 1555, 1478, 1554, 1479, 
       1912, 1301, 1480, 1481, 1895, 1302, 1680, 1853, 1303, 1681, 1854, 1304,
        1792, 1423, 1305, 1793, 1424, 1306, 1794, 1425, 1307}], 
      Line3DBox[{1309, 1682, 1855, 1308, 1683, 1856, 1310, 1684, 1857, 1311, 
       1685, 1858, 1312, 1686, 1859, 1313, 1896, 1482, 1483, 1314, 1932, 1611,
        1484, 1612, 1485, 1603, 1560, 1913, 1561, 1559, 1486, 1558, 1487, 
       1914, 1315, 1488, 1489, 1897, 1316, 1687, 1860, 1317, 1688, 1861, 1318,
        1689, 1862, 1319, 1795, 1426, 1320, 1796, 1427, 1321}], 
      Line3DBox[{1335, 1497, 1496, 1899, 1334, 1872, 1697, 1333, 1871, 1696, 
       1332, 1870, 1695, 1331, 1869, 1694, 1330, 1708, 1868, 1495, 1329, 1915,
        1494, 1563, 1565, 1564, 1328, 1921, 1566, 1567, 1562, 1614, 1613, 
       1933, 1327, 1493, 1867, 1707, 1326, 1866, 1693, 1325, 1865, 1692, 1324,
        1864, 1691, 1323, 1863, 1690, 1322, 1898, 1491, 1490, 1492}]}}},
   VertexNormals->CompressedData["
1:eJztXWlQVUcWRsGlogGNYRk0oAlGjTNaKgST0XTEDQR1ABkShJST0ZK4xCWK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    "]],
  Axes->True,
  AxesLabel->{
    FormBox["x", TraditionalForm], 
    FormBox["y", TraditionalForm], 
    FormBox["z", TraditionalForm]},
  Method->{},
  PlotRange->{{-1.9999997142857142`, 1.9999997142857142`}, {0., 
   3.9999988571429386`}, {-6.999999, 6.999999}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.588540929516199*^9, 3.588540951032041*^9}, {
   3.588541192512514*^9, 3.588541213954341*^9}, {3.5885412923072157`*^9, 
   3.588541304692287*^9}, 3.588541350973783*^9, {3.588541409971081*^9, 
   3.5885414372979527`*^9}, 3.588541534635592*^9, 3.588541886807377*^9, {
   3.588542073927802*^9, 
   3.588542085399218*^9}},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "\[LineSeparator]\[LineSeparator]\[LineSeparator]\[LineSeparator]\
\[LineSeparator]",
 StyleBox["z=x^3",
  FontWeight->"Bold"],
 " for any y:"
}], "Text",
 CellChangeTimes->{{3.588542646363649*^9, 3.588542676746078*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p2", "=", 
  RowBox[{"ParametricPlot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"t", ",", "s", ",", 
      RowBox[{"t", "^", "3"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"t", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", 
      RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Axes", "\[Rule]", "True"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5885414493753033`*^9, 3.5885414842761993`*^9}, {
  3.588541539292767*^9, 3.588541540738337*^9}, {3.588542109129684*^9, 
  3.588542124462471*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyFXWm0XVWRDoTkEaZIBAIEMmhENHQLCATbR++DjZioIA1Ks9QGRQJIk0U3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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmgXUF9UWxefGjIFiC4j6AFvC7kRRJCyehZiEiSjYiIAiSNiopCAmZSFY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         "]], 
        Polygon3DBox[CompressedData["
1:eJxFmwn8F9P3xmfunftRlqSQvUX2KDuJSGWtlF1lKWRroRAttEi2lH2vCIlU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         "]], 
        Polygon3DBox[CompressedData["
1:eJwt13ncTdUex/HznOc5T5kSigo3QxOVmWtoMqTbgMwNyFDmuOTSLQmlgaLh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         "]], Polygon3DBox[CompressedData["
1:eJwl0L8rRXEYx/HHvVjVnUxK3cmPSRElNiyIgXO3e6+I/CgLBpPFYsPIHUwU
fwOjQcSortEgCpMir293eHc+n/f5nufbczorGzPruYhoQytGWyJGUM1H/DZF
/GFBXuNWcSrP+WAeNbnSHPGGR31T/3GmrG97buGcW/RuCRdyO1fDvn5j9jX6
+AJ3gl3+irtEke/gznDIP3D3GOYHuH5k8jv3gZKccU/4dn4C4zjgZ7k7vOpD
GMQe38v1YEqum/GCafmLK9kjw6e8zK2kfdN+OMo3Zqc7juVJ7hbPeje6sMMX
0z9IO+cas9MdY/w/bfQw2A==
         "]]}]}, {}, {}, {}, {}}, {{}, {}, {}, {
      Line3DBox[{419, 634, 1539, 420, 645, 444, 1621, 657, 459, 1623, 669, 
       474, 1626, 681, 489, 1631, 693, 504, 1639, 705, 519, 1650, 717, 1578, 
       534, 729, 1591, 549, 1665, 741, 564, 1667, 753, 579, 1670, 765, 594, 
       1675, 777, 609, 1682, 789, 624}], 
      Line3DBox[{421, 635, 1540, 422, 646, 1550, 445, 658, 1559, 460, 1624, 
       670, 475, 1627, 682, 490, 1632, 694, 505, 1640, 706, 520, 1651, 718, 
       1579, 535, 730, 1592, 550, 742, 1601, 565, 1668, 754, 580, 1671, 766, 
       595, 1676, 778, 610, 1683, 790, 625}], 
      Line3DBox[{423, 636, 1541, 424, 647, 1551, 446, 659, 1560, 461, 671, 
       1566, 476, 1628, 683, 491, 1633, 695, 506, 1641, 707, 521, 1652, 719, 
       1580, 536, 731, 1593, 551, 743, 1602, 566, 755, 1609, 581, 1672, 767, 
       596, 1677, 779, 611, 1684, 791, 626}], 
      Line3DBox[{425, 799, 800, 1542, 426, 813, 814, 1552, 447, 823, 1696, 
       824, 462, 833, 1700, 834, 477, 843, 1705, 844, 492, 1634, 853, 854, 
       507, 1642, 863, 864, 522, 1653, 873, 874, 1581, 537, 883, 884, 1594, 
       552, 893, 894, 1603, 567, 903, 1721, 904, 582, 913, 1726, 914, 597, 
       1678, 923, 924, 612, 1685, 934, 935, 937}], 
      Line3DBox[{427, 1006, 1007, 949, 801, 1543, 428, 815, 954, 816, 448, 
       825, 958, 1740, 826, 463, 835, 962, 1742, 836, 478, 845, 1706, 966, 
       846, 493, 855, 1709, 970, 856, 508, 1643, 865, 974, 866, 523, 1654, 
       875, 978, 876, 1582, 538, 885, 982, 886, 553, 895, 986, 1750, 896, 568,
        905, 990, 1752, 906, 583, 915, 1727, 994, 916, 598, 925, 1731, 998, 
       926, 613, 1686, 936, 1002, 1013, 1012, 1015}], 
      Line3DBox[{429, 802, 950, 1738, 804, 430, 817, 955, 1739, 819, 449, 827,
        959, 1741, 829, 464, 837, 963, 1743, 839, 479, 847, 1708, 967, 849, 
       494, 857, 1711, 971, 859, 509, 867, 1713, 975, 869, 524, 1655, 877, 
       979, 879, 1583, 539, 887, 983, 1749, 889, 554, 897, 987, 1751, 899, 
       569, 907, 991, 1753, 909, 584, 917, 1729, 995, 919, 599, 927, 1733, 
       999, 929, 614, 938, 1736, 1003, 940, 941}], 
      Line3DBox[{435, 641, 1547, 436, 652, 1555, 454, 664, 1562, 469, 676, 
       1567, 484, 1629, 688, 499, 1636, 700, 514, 1646, 712, 529, 1659, 724, 
       1587, 544, 736, 1597, 559, 748, 1605, 574, 760, 1610, 589, 1673, 772, 
       604, 1680, 784, 619, 1689, 795, 630}], 
      Line3DBox[{437, 642, 1548, 438, 653, 1556, 455, 665, 1563, 470, 677, 
       1568, 485, 689, 1571, 500, 1637, 701, 515, 1647, 713, 530, 1660, 725, 
       1588, 545, 737, 1598, 560, 749, 1606, 575, 761, 1611, 590, 773, 1614, 
       605, 1681, 785, 620, 1690, 796, 631}], 
      Line3DBox[{439, 643, 1549, 440, 654, 1557, 456, 666, 1564, 471, 678, 
       1569, 486, 690, 1572, 501, 702, 1574, 516, 1648, 714, 531, 1661, 726, 
       1589, 546, 738, 1599, 561, 750, 1607, 576, 762, 1612, 591, 774, 1615, 
       606, 786, 1617, 621, 1691, 797, 632}], 
      Line3DBox[{441, 811, 1693, 812, 442, 655, 1558, 457, 667, 1565, 472, 
       679, 1570, 487, 691, 1573, 502, 703, 1575, 517, 715, 1576, 532, 1662, 
       727, 1590, 547, 739, 1600, 562, 751, 1608, 577, 763, 1613, 592, 775, 
       1616, 607, 787, 1618, 622, 945, 1737, 946, 947}], 
      Line3DBox[{623, 788, 1734, 933, 608, 776, 1674, 593, 764, 1669, 578, 
       752, 1666, 563, 740, 1664, 548, 728, 1663, 533, 1577, 716, 1649, 518, 
       704, 1638, 503, 692, 1630, 488, 680, 1625, 473, 668, 1622, 458, 656, 
       1620, 443, 644, 1619, 418, 633, 798, 948}], 
      Line3DBox[{627, 792, 1735, 939, 615, 780, 1732, 928, 600, 768, 1728, 
       918, 585, 756, 1722, 908, 570, 744, 1718, 898, 555, 732, 1716, 888, 
       540, 720, 1715, 1714, 878, 525, 708, 1712, 868, 510, 696, 1710, 858, 
       495, 684, 1707, 848, 480, 672, 1701, 838, 465, 660, 1697, 828, 450, 
       648, 1694, 818, 431, 637, 1692, 803, 805}], 
      Line3DBox[{628, 793, 1004, 942, 616, 781, 1000, 1756, 930, 601, 769, 
       996, 1754, 920, 586, 757, 1723, 992, 910, 571, 745, 1719, 988, 900, 
       556, 733, 1717, 984, 890, 541, 1584, 721, 980, 880, 1656, 526, 709, 
       976, 1748, 870, 511, 697, 972, 1746, 860, 496, 685, 968, 1744, 850, 
       481, 673, 1702, 964, 840, 466, 661, 1698, 960, 830, 451, 649, 1695, 
       956, 820, 432, 1544, 638, 952, 806, 951}], 
      Line3DBox[{629, 794, 944, 1688, 618, 783, 932, 1679, 603, 771, 1730, 
       922, 588, 759, 1725, 912, 573, 1604, 747, 902, 558, 1596, 735, 892, 
       543, 1586, 723, 882, 1658, 528, 711, 872, 1645, 513, 699, 862, 1635, 
       498, 687, 852, 483, 675, 1704, 842, 468, 1561, 663, 832, 453, 1554, 
       651, 822, 434, 1546, 640, 809, 810}], 
      Line3DBox[{808, 1010, 1011, 807, 953, 639, 1545, 433, 821, 957, 650, 
       1553, 452, 831, 961, 1699, 662, 467, 841, 965, 1703, 674, 482, 851, 
       1745, 969, 686, 497, 861, 1747, 973, 698, 512, 1644, 871, 977, 710, 
       527, 1657, 881, 981, 722, 1585, 542, 891, 985, 734, 1595, 557, 901, 
       989, 1720, 746, 572, 911, 993, 1724, 758, 587, 921, 1755, 997, 770, 
       602, 931, 1001, 782, 617, 1687, 943, 1005, 1008, 1016, 1009, 1014}]}, {
      Line3DBox[{1018, 1297, 633, 1017, 1539, 1208, 1019, 1540, 1209, 1020, 
       1541, 1210, 1021, 1513, 1542, 1211, 1406, 1514, 1543, 1212, 1407, 1738,
        1298, 1438, 1692, 1022, 1299, 1544, 1213, 1408, 1300, 1545, 1214, 
       1409, 1301, 1546, 1215, 1023, 1547, 1216, 1024, 1548, 1217, 1025, 1549,
        1218, 1026, 1693, 1302, 1219, 1303}], 
      Line3DBox[{1028, 1439, 1619, 1027, 645, 1029, 1550, 1220, 1030, 1551, 
       1221, 1031, 1515, 1552, 1222, 1410, 816, 1223, 1411, 1739, 1304, 1440, 
       1694, 1032, 1305, 1441, 1695, 1412, 1306, 1553, 1224, 1413, 1307, 1554,
        1225, 1033, 1555, 1226, 1034, 1556, 1227, 1035, 1557, 1228, 1036, 
       1558, 1229, 1037}], 
      Line3DBox[{1039, 1442, 1620, 1038, 1443, 1621, 1040, 1559, 1230, 1041, 
       1560, 1231, 1042, 1696, 1308, 1232, 1414, 1740, 1309, 1233, 1415, 1741,
        1310, 1444, 1697, 1043, 1311, 1445, 1698, 1416, 1312, 1446, 1699, 
       1417, 1313, 1561, 1234, 1044, 1562, 1235, 1045, 1563, 1236, 1046, 1564,
        1237, 1047, 1565, 1238, 1048}], 
      Line3DBox[{1050, 1447, 1622, 1049, 1448, 1623, 1051, 1449, 1624, 1052, 
       1566, 1239, 1053, 1700, 1314, 1240, 1418, 1742, 1315, 1241, 1419, 1743,
        1316, 1450, 1701, 1054, 1317, 1451, 1702, 1420, 1318, 1452, 1703, 
       1421, 1319, 1453, 1704, 1055, 1567, 1242, 1056, 1568, 1243, 1057, 1569,
        1244, 1058, 1570, 1245, 1059}], 
      Line3DBox[{1061, 1454, 1625, 1060, 1455, 1626, 1062, 1456, 1627, 1063, 
       1457, 1628, 1064, 1705, 1320, 1321, 1065, 1706, 1322, 1323, 1066, 1708,
        1324, 1325, 1707, 1067, 1326, 1327, 1744, 1068, 1328, 1329, 1745, 
       1069, 1330, 852, 1070, 1458, 1629, 1071, 1571, 1246, 1072, 1572, 1247, 
       1073, 1573, 1248, 1074}], 
      Line3DBox[{1076, 1459, 1630, 1075, 1460, 1631, 1077, 1461, 1632, 1078, 
       1462, 1633, 1079, 1516, 1634, 1331, 1080, 1709, 1332, 1333, 1081, 1711,
        1334, 1335, 1710, 1082, 1336, 1337, 1746, 1083, 1338, 1339, 1747, 
       1084, 1340, 1635, 1517, 1085, 1463, 1636, 1086, 1464, 1637, 1087, 1574,
        1249, 1088, 1575, 1250, 1089}], 
      Line3DBox[{1091, 1465, 1638, 1090, 1466, 1639, 1092, 1467, 1640, 1093, 
       1468, 1641, 1094, 1518, 1642, 1341, 1095, 1519, 1643, 1342, 1096, 1713,
        1343, 1344, 1712, 1097, 1345, 1346, 1748, 1098, 1347, 1644, 1520, 
       1099, 1348, 1645, 1521, 1100, 1469, 1646, 1101, 1470, 1647, 1102, 1471,
        1648, 1103, 1576, 1251, 1104}], 
      Line3DBox[{1108, 1577, 1252, 1106, 1578, 1253, 1110, 1579, 1254, 1112, 
       1580, 1255, 1114, 1523, 1581, 1256, 1422, 1525, 1582, 1257, 1423, 1527,
        1583, 1476, 1715, 1118, 1353, 1584, 1258, 1424, 1355, 1585, 1259, 
       1425, 1357, 1586, 1260, 1122, 1587, 1261, 1124, 1588, 1262, 1126, 1589,
        1263, 1128, 1590, 1264, 1130}], 
      Line3DBox[{1129, 1662, 1480, 1127, 1661, 1479, 1125, 1660, 1478, 1123, 
       1659, 1477, 1121, 1530, 1658, 1356, 1120, 1529, 1657, 1354, 1119, 1528,
        1656, 1352, 1117, 1714, 1351, 1655, 1526, 1116, 1350, 1654, 1524, 
       1115, 1349, 1653, 1522, 1113, 1652, 1475, 1111, 1651, 1474, 1109, 1650,
        1473, 1105, 1649, 1472, 1107}], 
      Line3DBox[{1132, 1481, 1663, 1131, 1591, 1265, 1133, 1592, 1266, 1134, 
       1593, 1267, 1135, 1531, 1594, 1268, 1426, 886, 1269, 1427, 1749, 1358, 
       1482, 1716, 1136, 1359, 1483, 1717, 1428, 1360, 1595, 1270, 1429, 1361,
        1596, 1271, 1137, 1597, 1272, 1138, 1598, 1273, 1139, 1599, 1274, 
       1140, 1600, 1275, 1141}], 
      Line3DBox[{1143, 1484, 1664, 1142, 1485, 1665, 1144, 1601, 1276, 1145, 
       1602, 1277, 1146, 1532, 1603, 1278, 1430, 1750, 1362, 1279, 1431, 1751,
        1363, 1486, 1718, 1147, 1364, 1487, 1719, 1432, 1365, 1488, 1720, 
       1433, 1366, 1604, 1280, 1148, 1605, 1281, 1149, 1606, 1282, 1150, 1607,
        1283, 1151, 1608, 1284, 1152}], 
      Line3DBox[{1154, 1489, 1666, 1153, 1490, 1667, 1155, 1491, 1668, 1156, 
       1609, 1285, 1157, 1721, 1367, 1286, 1434, 1752, 1368, 1287, 1435, 1753,
        1369, 1492, 1722, 1158, 1370, 1493, 1723, 1436, 1371, 1494, 1724, 
       1437, 1372, 1495, 1725, 1159, 1610, 1288, 1160, 1611, 1289, 1161, 1612,
        1290, 1162, 1613, 1291, 1163}], 
      Line3DBox[{1165, 1496, 1669, 1164, 1497, 1670, 1166, 1498, 1671, 1167, 
       1499, 1672, 1168, 1726, 1373, 1374, 1169, 1727, 1375, 1376, 1170, 1729,
        1377, 1378, 1728, 1171, 1379, 1380, 1754, 1172, 1381, 1382, 1755, 
       1173, 1383, 1384, 1730, 1174, 1500, 1673, 1175, 1614, 1292, 1176, 1615,
        1293, 1177, 1616, 1294, 1178}], 
      Line3DBox[{1180, 1501, 1674, 1179, 1502, 1675, 1181, 1503, 1676, 1182, 
       1504, 1677, 1183, 1533, 1678, 1385, 1184, 1731, 1386, 1387, 1185, 1733,
        1388, 1389, 1732, 1186, 1390, 1391, 1756, 1187, 1392, 931, 1188, 1393,
        1679, 1534, 1189, 1505, 1680, 1190, 1506, 1681, 1191, 1617, 1295, 
       1192, 1618, 1296, 1193}], 
      Line3DBox[{1207, 1405, 1404, 1737, 1206, 1691, 1512, 1205, 1690, 1511, 
       1204, 1689, 1510, 1203, 1538, 1688, 1403, 1202, 1537, 1687, 1402, 1201,
        942, 1401, 1200, 1735, 1400, 1399, 1736, 1199, 1398, 1686, 1536, 1198,
        1397, 1685, 1535, 1197, 1684, 1509, 1196, 1683, 1508, 1195, 1682, 
       1507, 1194, 1734, 1395, 1394, 1396}]}}},
   VertexNormals->CompressedData["
1:eJztXXtYzlkefxnDGrOjmmKGkpBqilqXsTusw5i1LuVSQ4zriGUNa4aSqVnb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    "]],
  Axes->True,
  AxesLabel->{
    FormBox["x", TraditionalForm], 
    FormBox["y", TraditionalForm], 
    FormBox["z", TraditionalForm]},
  Method->{},
  PlotRange->{{-1.9999997142857142`, 
   1.9999997142857142`}, {-3.1415922047908427`, 
   3.1415922047908427`}, {-7.999996571429061, 7.999996571429061}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.588541467453702*^9, 3.588541485312354*^9}, 
   3.588541541585429*^9, 3.5885420948442287`*^9, 3.588542130347617*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"p1", ",", "p2"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.588541555173058*^9, 3.588541562973567*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJyFnXvUV1WZx1HueEt8VcQb1JuappmKYL7Tfh26iFxkSWUtJ5pAXS5XaDGV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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxFmwf8V9P/xz/33nPvJQ0hlYY0VIo0jKwUMrKJSkJpaMgopKGioaGflb0q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          "]], Polygon3DBox[CompressedData["
1:eJwtm3ngF1MbxWfmzr1fKZEkJVpVdmWnCC2E9pCyVBKiIi2WSlHZhayJ7Pu+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          "]], Polygon3DBox[CompressedData["
1:eJwt13mgTeUWAPDTde+WlKJShgxNKIRGsyhC5qFMSaFShgrhmmeZQmQeKzKk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          "]], 
         Polygon3DBox[{{1702, 1242, 1241, 1701, 941, 942}, {1247, 1389, 819, 
          945, 1705, 1246}}]}]}, {}, {}, {}, {}}, {{}, {}, {}, {
       Line3DBox[{518, 723, 1712, 519, 735, 1722, 543, 1799, 748, 557, 1801, 
        761, 571, 1805, 774, 585, 1811, 787, 599, 1819, 800, 613, 1830, 813, 
        1754, 627, 826, 1766, 641, 1844, 839, 655, 1846, 852, 669, 1850, 865, 
        683, 1856, 878, 697, 1863, 891, 711}], 
       Line3DBox[{520, 724, 1713, 521, 736, 1723, 544, 749, 1732, 558, 1802, 
        762, 572, 1806, 775, 586, 1812, 788, 600, 1820, 801, 614, 1831, 814, 
        1755, 628, 827, 1767, 642, 840, 1777, 656, 1847, 853, 670, 1851, 866, 
        684, 1857, 879, 698, 1864, 892, 712}], 
       Line3DBox[{522, 725, 1714, 523, 737, 1724, 545, 750, 1733, 559, 763, 
        1740, 573, 1807, 776, 587, 1813, 789, 601, 1821, 802, 615, 1832, 815, 
        1756, 629, 828, 1768, 643, 841, 1778, 657, 854, 1785, 671, 1852, 867, 
        685, 1858, 880, 699, 1865, 893, 713}], 
       Line3DBox[{524, 726, 1715, 525, 738, 1725, 546, 751, 1734, 560, 764, 
        1741, 574, 777, 1746, 588, 1814, 790, 602, 1822, 803, 616, 1833, 816, 
        1757, 630, 829, 1769, 644, 842, 1779, 658, 855, 1786, 672, 868, 1791, 
        686, 1859, 881, 700, 1866, 894, 714}], 
       Line3DBox[{526, 903, 904, 1716, 527, 911, 912, 547, 916, 1875, 917, 
        561, 921, 1878, 922, 575, 926, 1881, 927, 589, 931, 1884, 932, 603, 
        1823, 936, 937, 617, 1834, 941, 942, 1758, 631, 946, 947, 1770, 645, 
        951, 1887, 952, 659, 956, 1890, 957, 673, 961, 1893, 962, 687, 966, 
        1896, 967, 701, 1867, 972, 973, 974}], Line3DBox[CompressedData["
1:eJwNyqtLgwEUhvGjm7cgaDAsLCwYDAaDwbB/wmDwvuk2L9++eZlGu7dgsVgs
FsuKxWKxGE2CIAwGgiAIgiAIwn7h4T3PwymUG7NpT0TMYaQ3IpuN6MNLJuIY
w+4FLOKVJwMRF3aUL2EZb7yuX9oxvoJVtHmqX9kcL6GMea2jXSPP13Cirdt3
7QYFdwWnetV+aLcYdx9pNbuBT62Fdn/EBN/EFr60pr87O8m3keCbH+j3dorX
keKHH+oPdpo3sIOq9qs9Yobv4kzbs3/aE4rufZzrTfuvDdlBPLu7XXQtIA==

        "]], 
       Line3DBox[{532, 730, 1718, 533, 742, 1727, 551, 755, 1735, 565, 1803, 
        768, 579, 1808, 781, 593, 1815, 794, 607, 1825, 807, 621, 1837, 820, 
        1761, 635, 833, 1772, 649, 846, 1780, 663, 1848, 859, 677, 1853, 872, 
        691, 1860, 885, 705, 1869, 898, 718}], 
       Line3DBox[{534, 731, 1719, 535, 743, 1728, 552, 756, 1736, 566, 769, 
        1742, 580, 1809, 782, 594, 1816, 795, 608, 1826, 808, 622, 1838, 821, 
        1762, 636, 834, 1773, 650, 847, 1781, 664, 860, 1787, 678, 1854, 873, 
        692, 1861, 886, 706, 1870, 899, 719}], 
       Line3DBox[{536, 732, 1720, 537, 744, 1729, 553, 757, 1737, 567, 770, 
        1743, 581, 783, 1747, 595, 1817, 796, 609, 1827, 809, 623, 1839, 822, 
        1763, 637, 835, 1774, 651, 848, 1782, 665, 861, 1788, 679, 874, 1792, 
        693, 1862, 887, 707, 1871, 900, 720}], 
       Line3DBox[{538, 733, 1721, 539, 745, 1730, 554, 758, 1738, 568, 771, 
        1744, 582, 784, 1748, 596, 797, 1750, 610, 1828, 810, 624, 1840, 823, 
        1764, 638, 836, 1775, 652, 849, 1783, 666, 862, 1789, 680, 875, 1793, 
        694, 888, 1795, 708, 1872, 901, 721}], 
       Line3DBox[{540, 909, 1873, 910, 541, 746, 1731, 555, 759, 1739, 569, 
        772, 1745, 583, 785, 1749, 597, 798, 1751, 611, 811, 1752, 625, 1841, 
        824, 1765, 639, 837, 1776, 653, 850, 1784, 667, 863, 1790, 681, 876, 
        1794, 695, 889, 1796, 709, 978, 1899, 979, 980}], 
       Line3DBox[{710, 890, 1898, 971, 696, 877, 1855, 682, 864, 1849, 668, 
        851, 1845, 654, 838, 1843, 640, 825, 1842, 626, 1753, 812, 1829, 612, 
        799, 1818, 598, 786, 1810, 584, 773, 1804, 570, 760, 1800, 556, 747, 
        1798, 542, 734, 1797, 517, 722, 902, 981}], Line3DBox[CompressedData["

1:eJwV0Nsq5WEcxvF3oRRibJolJjOMEJPNEBMy9nsLa8Y2R8qJgxEnOJD9Ms5d
wVyBK3ADLkAppZRSiqaUEvmsg2/f5/e8z8G/f+niSvxPJISwg/OUELZTQ8hM
CyEFb/JP7sRueggdfGazpp+X5/Ait/Gm93ZuxanNkn5WnsGz3MLrNj+4Gf9s
ZvXT8rF+ip/cjdyE7zixGdH9lv/a/OL/7jquRy0SNh26I+9x9yQe3DX8DdXY
sGnQJWwm3OO4d1dyFbb1FbxsV66PyWO4k79yObZsynjBJqoflUdwK3/mVe9f
uAQxmwz9sDyEG7mYV2w+cVHyn9q8YlA+1A/wtV2UC/Ex+Q+8P6JfPrDp4yub
fC5AXvLbvN9g33uvuweXNjn8AdnI9X6BPZtudxcubCKchYBUvAPCEDLa
        "]], 
       Line3DBox[{716, 896, 1034, 1023, 1915, 975, 703, 883, 1020, 1914, 969, 
        689, 870, 1017, 1912, 964, 675, 857, 1891, 1014, 959, 661, 844, 1888, 
        1011, 954, 647, 831, 1886, 1008, 949, 633, 1920, 818, 1005, 944, 1835,
         619, 805, 1002, 1907, 939, 605, 792, 999, 1906, 934, 591, 779, 996, 
        1904, 929, 577, 766, 1879, 993, 924, 563, 753, 1876, 990, 919, 549, 
        740, 1874, 987, 914, 530, 1916, 728, 984, 1031, 1030, 906}], 
       Line3DBox[{717, 897, 977, 1868, 704, 884, 1897, 970, 690, 871, 1895, 
        965, 676, 858, 1892, 960, 662, 845, 1889, 955, 648, 1771, 832, 950, 
        634, 1760, 819, 945, 1836, 620, 806, 940, 1824, 606, 793, 1885, 935, 
        592, 780, 1883, 930, 578, 767, 1880, 925, 564, 754, 1877, 920, 550, 
        1726, 741, 915, 531, 1717, 729, 907, 908}]}, {
       Line3DBox[{1142, 1428, 722, 1141, 1712, 1336, 1143, 1713, 1337, 1144, 
        1714, 1338, 1145, 1715, 1339, 1146, 1698, 1716, 1340, 1498, 905, 1518,
         1568, 1615, 1922, 1571, 1569, 1570, 1519, 1916, 1341, 1499, 1429, 
        1717, 1342, 1147, 1718, 1343, 1148, 1719, 1344, 1149, 1720, 1345, 
        1150, 1721, 1346, 1151, 1873, 1430, 1347, 1431}], 
       Line3DBox[{1153, 1616, 1797, 1152, 1722, 1348, 1154, 1723, 1349, 1155, 
        1724, 1350, 1156, 1725, 1351, 1157, 912, 1352, 1500, 1900, 1432, 1520,
         1572, 1617, 1923, 1575, 1573, 1574, 1521, 1618, 1874, 1501, 1433, 
        1726, 1353, 1158, 1727, 1354, 1159, 1728, 1355, 1160, 1729, 1356, 
        1161, 1730, 1357, 1162, 1731, 1358, 1163}], 
       Line3DBox[{1165, 1619, 1798, 1164, 1620, 1799, 1166, 1732, 1359, 1167, 
        1733, 1360, 1168, 1734, 1361, 1169, 1875, 1434, 1362, 1502, 1901, 
        1435, 1522, 1576, 1596, 1577, 1924, 1503, 1578, 1436, 1523, 1621, 
        1876, 1504, 1437, 1622, 1877, 1170, 1735, 1363, 1171, 1736, 1364, 
        1172, 1737, 1365, 1173, 1738, 1366, 1174, 1739, 1367, 1175}], 
       Line3DBox[{1177, 1623, 1800, 1176, 1624, 1801, 1178, 1625, 1802, 1179, 
        1740, 1368, 1180, 1741, 1369, 1181, 1878, 1438, 1370, 1505, 1902, 
        1439, 1524, 1579, 1597, 1580, 1925, 1506, 1581, 1440, 1525, 1626, 
        1879, 1507, 1441, 1627, 1880, 1182, 1628, 1803, 1183, 1742, 1371, 
        1184, 1743, 1372, 1185, 1744, 1373, 1186, 1745, 1374, 1187}], 
       Line3DBox[{1189, 1629, 1804, 1188, 1630, 1805, 1190, 1631, 1806, 1191, 
        1632, 1807, 1192, 1746, 1375, 1193, 1881, 1442, 1443, 1194, 1709, 
        1882, 1444, 1604, 1445, 1598, 1528, 1903, 1529, 1527, 1446, 1526, 
        1447, 1904, 1195, 1448, 1449, 1883, 1196, 1633, 1808, 1197, 1634, 
        1809, 1198, 1747, 1376, 1199, 1748, 1377, 1200, 1749, 1378, 1201}], 
       Line3DBox[{1203, 1635, 1810, 1202, 1636, 1811, 1204, 1637, 1812, 1205, 
        1638, 1813, 1206, 1639, 1814, 1207, 1884, 1450, 1451, 1208, 1930, 
        1605, 1452, 1606, 1453, 1599, 1532, 1905, 1533, 1531, 1454, 1530, 
        1455, 1906, 1209, 1456, 1457, 1885, 1210, 1640, 1815, 1211, 1641, 
        1816, 1212, 1642, 1817, 1213, 1750, 1379, 1214, 1751, 1380, 1215}], 
       Line3DBox[{1217, 1643, 1818, 1216, 1644, 1819, 1218, 1645, 1820, 1219, 
        1646, 1821, 1220, 1647, 1822, 1221, 1699, 1823, 1458, 1222, 1931, 
        1607, 1608, 1534, 1539, 1538, 1917, 1223, 1536, 1537, 1535, 1459, 
        1907, 1224, 1460, 1824, 1700, 1225, 1648, 1825, 1226, 1649, 1826, 
        1227, 1650, 1827, 1228, 1651, 1828, 1229, 1752, 1381, 1230}], 
       Line3DBox[{1234, 1753, 1382, 1232, 1754, 1383, 1236, 1755, 1384, 1238, 
        1756, 1385, 1240, 1757, 1386, 1242, 1702, 1758, 1387, 1508, 1703, 
        1759, 1546, 1582, 1657, 1926, 1585, 1583, 1584, 1547, 1920, 1388, 
        1509, 1463, 1760, 1389, 1247, 1761, 1390, 1249, 1762, 1391, 1251, 
        1763, 1392, 1253, 1764, 1393, 1255, 1765, 1394, 1257}], 
       Line3DBox[{1256, 1841, 1662, 1254, 1840, 1661, 1252, 1839, 1660, 1250, 
        1838, 1659, 1248, 1837, 1658, 1246, 1705, 1836, 1462, 1245, 1704, 
        1835, 1541, 1543, 1542, 1244, 1919, 1544, 1545, 1540, 1609, 1918, 
        1710, 1243, 1461, 1834, 1701, 1241, 1833, 1656, 1239, 1832, 1655, 
        1237, 1831, 1654, 1235, 1830, 1653, 1231, 1829, 1652, 1233}], 
       Line3DBox[{1259, 1663, 1842, 1258, 1766, 1395, 1260, 1767, 1396, 1261, 
        1768, 1397, 1262, 1769, 1398, 1263, 1706, 1770, 1399, 1510, 1908, 
        1464, 1548, 1586, 1664, 1927, 1589, 1587, 1588, 1549, 1665, 1886, 
        1511, 1465, 1771, 1400, 1264, 1772, 1401, 1265, 1773, 1402, 1266, 
        1774, 1403, 1267, 1775, 1404, 1268, 1776, 1405, 1269}], 
       Line3DBox[{1271, 1666, 1843, 1270, 1667, 1844, 1272, 1777, 1406, 1273, 
        1778, 1407, 1274, 1779, 1408, 1275, 1887, 1466, 1409, 1512, 1909, 
        1467, 1550, 1590, 1600, 1591, 1928, 1513, 1592, 1468, 1551, 1668, 
        1888, 1514, 1469, 1669, 1889, 1276, 1780, 1410, 1277, 1781, 1411, 
        1278, 1782, 1412, 1279, 1783, 1413, 1280, 1784, 1414, 1281}], 
       Line3DBox[{1283, 1670, 1845, 1282, 1671, 1846, 1284, 1672, 1847, 1285, 
        1785, 1415, 1286, 1786, 1416, 1287, 1890, 1470, 1417, 1515, 1910, 
        1471, 1552, 1593, 1601, 1594, 1929, 1516, 1595, 1472, 1553, 1673, 
        1891, 1517, 1473, 1674, 1892, 1288, 1675, 1848, 1289, 1787, 1418, 
        1290, 1788, 1419, 1291, 1789, 1420, 1292, 1790, 1421, 1293}], 
       Line3DBox[{1295, 1676, 1849, 1294, 1677, 1850, 1296, 1678, 1851, 1297, 
        1679, 1852, 1298, 1791, 1422, 1299, 1893, 1474, 1475, 1300, 1711, 
        1894, 1476, 1610, 1477, 1602, 1556, 1911, 1557, 1555, 1478, 1554, 
        1479, 1912, 1301, 1480, 1481, 1895, 1302, 1680, 1853, 1303, 1681, 
        1854, 1304, 1792, 1423, 1305, 1793, 1424, 1306, 1794, 1425, 1307}], 
       Line3DBox[{1309, 1682, 1855, 1308, 1683, 1856, 1310, 1684, 1857, 1311, 
        1685, 1858, 1312, 1686, 1859, 1313, 1896, 1482, 1483, 1314, 1932, 
        1611, 1484, 1612, 1485, 1603, 1560, 1913, 1561, 1559, 1486, 1558, 
        1487, 1914, 1315, 1488, 1489, 1897, 1316, 1687, 1860, 1317, 1688, 
        1861, 1318, 1689, 1862, 1319, 1795, 1426, 1320, 1796, 1427, 1321}], 
       Line3DBox[{1335, 1497, 1496, 1899, 1334, 1872, 1697, 1333, 1871, 1696, 
        1332, 1870, 1695, 1331, 1869, 1694, 1330, 1708, 1868, 1495, 1329, 
        1915, 1494, 1563, 1565, 1564, 1328, 1921, 1566, 1567, 1562, 1614, 
        1613, 1933, 1327, 1493, 1867, 1707, 1326, 1866, 1693, 1325, 1865, 
        1692, 1324, 1864, 1691, 1323, 1863, 1690, 1322, 1898, 1491, 1490, 
        1492}]}}},
    VertexNormals->CompressedData["
1:eJztXWlQVUcWRsGlogGNYRk0oAlGjTNaKgST0XTEDQR1ABkShJST0ZK4xCWK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     "]], GraphicsComplex3DBox[CompressedData["
1:eJyFXWm0XVWRDoTkEaZIBAIEMmhENHQLCATbR++DjZioIA1Ks9QGRQJIk0U3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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmgXUF9UWxefGjIFiC4j6AFvC7kRRJCyehZiEiSjYiIAiSNiopCAmZSFY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          "]], 
         Polygon3DBox[CompressedData["
1:eJxFmwn8F9P3xmfunftRlqSQvUX2KDuJSGWtlF1lKWRroRAttEi2lH2vCIlU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          "]], 
         Polygon3DBox[CompressedData["
1:eJwt13ncTdUex/HznOc5T5kSigo3QxOVmWtoMqTbgMwNyFDmuOTSLQmlgaLh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          "]], Polygon3DBox[CompressedData["
1:eJwl0L8rRXEYx/HHvVjVnUxK3cmPSRElNiyIgXO3e6+I/CgLBpPFYsPIHUwU
fwOjQcSortEgCpMir293eHc+n/f5nufbczorGzPruYhoQytGWyJGUM1H/DZF
/GFBXuNWcSrP+WAeNbnSHPGGR31T/3GmrG97buGcW/RuCRdyO1fDvn5j9jX6
+AJ3gl3+irtEke/gznDIP3D3GOYHuH5k8jv3gZKccU/4dn4C4zjgZ7k7vOpD
GMQe38v1YEqum/GCafmLK9kjw6e8zK2kfdN+OMo3Zqc7juVJ7hbPeje6sMMX
0z9IO+cas9MdY/w/bfQw2A==
          "]]}]}, {}, {}, {}, {}}, {{}, {}, {}, {
       Line3DBox[{419, 634, 1539, 420, 645, 444, 1621, 657, 459, 1623, 669, 
        474, 1626, 681, 489, 1631, 693, 504, 1639, 705, 519, 1650, 717, 1578, 
        534, 729, 1591, 549, 1665, 741, 564, 1667, 753, 579, 1670, 765, 594, 
        1675, 777, 609, 1682, 789, 624}], 
       Line3DBox[{421, 635, 1540, 422, 646, 1550, 445, 658, 1559, 460, 1624, 
        670, 475, 1627, 682, 490, 1632, 694, 505, 1640, 706, 520, 1651, 718, 
        1579, 535, 730, 1592, 550, 742, 1601, 565, 1668, 754, 580, 1671, 766, 
        595, 1676, 778, 610, 1683, 790, 625}], 
       Line3DBox[{423, 636, 1541, 424, 647, 1551, 446, 659, 1560, 461, 671, 
        1566, 476, 1628, 683, 491, 1633, 695, 506, 1641, 707, 521, 1652, 719, 
        1580, 536, 731, 1593, 551, 743, 1602, 566, 755, 1609, 581, 1672, 767, 
        596, 1677, 779, 611, 1684, 791, 626}], 
       Line3DBox[{425, 799, 800, 1542, 426, 813, 814, 1552, 447, 823, 1696, 
        824, 462, 833, 1700, 834, 477, 843, 1705, 844, 492, 1634, 853, 854, 
        507, 1642, 863, 864, 522, 1653, 873, 874, 1581, 537, 883, 884, 1594, 
        552, 893, 894, 1603, 567, 903, 1721, 904, 582, 913, 1726, 914, 597, 
        1678, 923, 924, 612, 1685, 934, 935, 937}], 
       Line3DBox[{427, 1006, 1007, 949, 801, 1543, 428, 815, 954, 816, 448, 
        825, 958, 1740, 826, 463, 835, 962, 1742, 836, 478, 845, 1706, 966, 
        846, 493, 855, 1709, 970, 856, 508, 1643, 865, 974, 866, 523, 1654, 
        875, 978, 876, 1582, 538, 885, 982, 886, 553, 895, 986, 1750, 896, 
        568, 905, 990, 1752, 906, 583, 915, 1727, 994, 916, 598, 925, 1731, 
        998, 926, 613, 1686, 936, 1002, 1013, 1012, 1015}], 
       Line3DBox[{429, 802, 950, 1738, 804, 430, 817, 955, 1739, 819, 449, 
        827, 959, 1741, 829, 464, 837, 963, 1743, 839, 479, 847, 1708, 967, 
        849, 494, 857, 1711, 971, 859, 509, 867, 1713, 975, 869, 524, 1655, 
        877, 979, 879, 1583, 539, 887, 983, 1749, 889, 554, 897, 987, 1751, 
        899, 569, 907, 991, 1753, 909, 584, 917, 1729, 995, 919, 599, 927, 
        1733, 999, 929, 614, 938, 1736, 1003, 940, 941}], 
       Line3DBox[{435, 641, 1547, 436, 652, 1555, 454, 664, 1562, 469, 676, 
        1567, 484, 1629, 688, 499, 1636, 700, 514, 1646, 712, 529, 1659, 724, 
        1587, 544, 736, 1597, 559, 748, 1605, 574, 760, 1610, 589, 1673, 772, 
        604, 1680, 784, 619, 1689, 795, 630}], 
       Line3DBox[{437, 642, 1548, 438, 653, 1556, 455, 665, 1563, 470, 677, 
        1568, 485, 689, 1571, 500, 1637, 701, 515, 1647, 713, 530, 1660, 725, 
        1588, 545, 737, 1598, 560, 749, 1606, 575, 761, 1611, 590, 773, 1614, 
        605, 1681, 785, 620, 1690, 796, 631}], 
       Line3DBox[{439, 643, 1549, 440, 654, 1557, 456, 666, 1564, 471, 678, 
        1569, 486, 690, 1572, 501, 702, 1574, 516, 1648, 714, 531, 1661, 726, 
        1589, 546, 738, 1599, 561, 750, 1607, 576, 762, 1612, 591, 774, 1615, 
        606, 786, 1617, 621, 1691, 797, 632}], 
       Line3DBox[{441, 811, 1693, 812, 442, 655, 1558, 457, 667, 1565, 472, 
        679, 1570, 487, 691, 1573, 502, 703, 1575, 517, 715, 1576, 532, 1662, 
        727, 1590, 547, 739, 1600, 562, 751, 1608, 577, 763, 1613, 592, 775, 
        1616, 607, 787, 1618, 622, 945, 1737, 946, 947}], 
       Line3DBox[{623, 788, 1734, 933, 608, 776, 1674, 593, 764, 1669, 578, 
        752, 1666, 563, 740, 1664, 548, 728, 1663, 533, 1577, 716, 1649, 518, 
        704, 1638, 503, 692, 1630, 488, 680, 1625, 473, 668, 1622, 458, 656, 
        1620, 443, 644, 1619, 418, 633, 798, 948}], 
       Line3DBox[{627, 792, 1735, 939, 615, 780, 1732, 928, 600, 768, 1728, 
        918, 585, 756, 1722, 908, 570, 744, 1718, 898, 555, 732, 1716, 888, 
        540, 720, 1715, 1714, 878, 525, 708, 1712, 868, 510, 696, 1710, 858, 
        495, 684, 1707, 848, 480, 672, 1701, 838, 465, 660, 1697, 828, 450, 
        648, 1694, 818, 431, 637, 1692, 803, 805}], 
       Line3DBox[{628, 793, 1004, 942, 616, 781, 1000, 1756, 930, 601, 769, 
        996, 1754, 920, 586, 757, 1723, 992, 910, 571, 745, 1719, 988, 900, 
        556, 733, 1717, 984, 890, 541, 1584, 721, 980, 880, 1656, 526, 709, 
        976, 1748, 870, 511, 697, 972, 1746, 860, 496, 685, 968, 1744, 850, 
        481, 673, 1702, 964, 840, 466, 661, 1698, 960, 830, 451, 649, 1695, 
        956, 820, 432, 1544, 638, 952, 806, 951}], 
       Line3DBox[{629, 794, 944, 1688, 618, 783, 932, 1679, 603, 771, 1730, 
        922, 588, 759, 1725, 912, 573, 1604, 747, 902, 558, 1596, 735, 892, 
        543, 1586, 723, 882, 1658, 528, 711, 872, 1645, 513, 699, 862, 1635, 
        498, 687, 852, 483, 675, 1704, 842, 468, 1561, 663, 832, 453, 1554, 
        651, 822, 434, 1546, 640, 809, 810}], 
       Line3DBox[{808, 1010, 1011, 807, 953, 639, 1545, 433, 821, 957, 650, 
        1553, 452, 831, 961, 1699, 662, 467, 841, 965, 1703, 674, 482, 851, 
        1745, 969, 686, 497, 861, 1747, 973, 698, 512, 1644, 871, 977, 710, 
        527, 1657, 881, 981, 722, 1585, 542, 891, 985, 734, 1595, 557, 901, 
        989, 1720, 746, 572, 911, 993, 1724, 758, 587, 921, 1755, 997, 770, 
        602, 931, 1001, 782, 617, 1687, 943, 1005, 1008, 1016, 1009, 
        1014}]}, {
       Line3DBox[{1018, 1297, 633, 1017, 1539, 1208, 1019, 1540, 1209, 1020, 
        1541, 1210, 1021, 1513, 1542, 1211, 1406, 1514, 1543, 1212, 1407, 
        1738, 1298, 1438, 1692, 1022, 1299, 1544, 1213, 1408, 1300, 1545, 
        1214, 1409, 1301, 1546, 1215, 1023, 1547, 1216, 1024, 1548, 1217, 
        1025, 1549, 1218, 1026, 1693, 1302, 1219, 1303}], 
       Line3DBox[{1028, 1439, 1619, 1027, 645, 1029, 1550, 1220, 1030, 1551, 
        1221, 1031, 1515, 1552, 1222, 1410, 816, 1223, 1411, 1739, 1304, 1440,
         1694, 1032, 1305, 1441, 1695, 1412, 1306, 1553, 1224, 1413, 1307, 
        1554, 1225, 1033, 1555, 1226, 1034, 1556, 1227, 1035, 1557, 1228, 
        1036, 1558, 1229, 1037}], 
       Line3DBox[{1039, 1442, 1620, 1038, 1443, 1621, 1040, 1559, 1230, 1041, 
        1560, 1231, 1042, 1696, 1308, 1232, 1414, 1740, 1309, 1233, 1415, 
        1741, 1310, 1444, 1697, 1043, 1311, 1445, 1698, 1416, 1312, 1446, 
        1699, 1417, 1313, 1561, 1234, 1044, 1562, 1235, 1045, 1563, 1236, 
        1046, 1564, 1237, 1047, 1565, 1238, 1048}], 
       Line3DBox[{1050, 1447, 1622, 1049, 1448, 1623, 1051, 1449, 1624, 1052, 
        1566, 1239, 1053, 1700, 1314, 1240, 1418, 1742, 1315, 1241, 1419, 
        1743, 1316, 1450, 1701, 1054, 1317, 1451, 1702, 1420, 1318, 1452, 
        1703, 1421, 1319, 1453, 1704, 1055, 1567, 1242, 1056, 1568, 1243, 
        1057, 1569, 1244, 1058, 1570, 1245, 1059}], 
       Line3DBox[{1061, 1454, 1625, 1060, 1455, 1626, 1062, 1456, 1627, 1063, 
        1457, 1628, 1064, 1705, 1320, 1321, 1065, 1706, 1322, 1323, 1066, 
        1708, 1324, 1325, 1707, 1067, 1326, 1327, 1744, 1068, 1328, 1329, 
        1745, 1069, 1330, 852, 1070, 1458, 1629, 1071, 1571, 1246, 1072, 1572,
         1247, 1073, 1573, 1248, 1074}], 
       Line3DBox[{1076, 1459, 1630, 1075, 1460, 1631, 1077, 1461, 1632, 1078, 
        1462, 1633, 1079, 1516, 1634, 1331, 1080, 1709, 1332, 1333, 1081, 
        1711, 1334, 1335, 1710, 1082, 1336, 1337, 1746, 1083, 1338, 1339, 
        1747, 1084, 1340, 1635, 1517, 1085, 1463, 1636, 1086, 1464, 1637, 
        1087, 1574, 1249, 1088, 1575, 1250, 1089}], 
       Line3DBox[{1091, 1465, 1638, 1090, 1466, 1639, 1092, 1467, 1640, 1093, 
        1468, 1641, 1094, 1518, 1642, 1341, 1095, 1519, 1643, 1342, 1096, 
        1713, 1343, 1344, 1712, 1097, 1345, 1346, 1748, 1098, 1347, 1644, 
        1520, 1099, 1348, 1645, 1521, 1100, 1469, 1646, 1101, 1470, 1647, 
        1102, 1471, 1648, 1103, 1576, 1251, 1104}], 
       Line3DBox[{1108, 1577, 1252, 1106, 1578, 1253, 1110, 1579, 1254, 1112, 
        1580, 1255, 1114, 1523, 1581, 1256, 1422, 1525, 1582, 1257, 1423, 
        1527, 1583, 1476, 1715, 1118, 1353, 1584, 1258, 1424, 1355, 1585, 
        1259, 1425, 1357, 1586, 1260, 1122, 1587, 1261, 1124, 1588, 1262, 
        1126, 1589, 1263, 1128, 1590, 1264, 1130}], 
       Line3DBox[{1129, 1662, 1480, 1127, 1661, 1479, 1125, 1660, 1478, 1123, 
        1659, 1477, 1121, 1530, 1658, 1356, 1120, 1529, 1657, 1354, 1119, 
        1528, 1656, 1352, 1117, 1714, 1351, 1655, 1526, 1116, 1350, 1654, 
        1524, 1115, 1349, 1653, 1522, 1113, 1652, 1475, 1111, 1651, 1474, 
        1109, 1650, 1473, 1105, 1649, 1472, 1107}], 
       Line3DBox[{1132, 1481, 1663, 1131, 1591, 1265, 1133, 1592, 1266, 1134, 
        1593, 1267, 1135, 1531, 1594, 1268, 1426, 886, 1269, 1427, 1749, 1358,
         1482, 1716, 1136, 1359, 1483, 1717, 1428, 1360, 1595, 1270, 1429, 
        1361, 1596, 1271, 1137, 1597, 1272, 1138, 1598, 1273, 1139, 1599, 
        1274, 1140, 1600, 1275, 1141}], 
       Line3DBox[{1143, 1484, 1664, 1142, 1485, 1665, 1144, 1601, 1276, 1145, 
        1602, 1277, 1146, 1532, 1603, 1278, 1430, 1750, 1362, 1279, 1431, 
        1751, 1363, 1486, 1718, 1147, 1364, 1487, 1719, 1432, 1365, 1488, 
        1720, 1433, 1366, 1604, 1280, 1148, 1605, 1281, 1149, 1606, 1282, 
        1150, 1607, 1283, 1151, 1608, 1284, 1152}], 
       Line3DBox[{1154, 1489, 1666, 1153, 1490, 1667, 1155, 1491, 1668, 1156, 
        1609, 1285, 1157, 1721, 1367, 1286, 1434, 1752, 1368, 1287, 1435, 
        1753, 1369, 1492, 1722, 1158, 1370, 1493, 1723, 1436, 1371, 1494, 
        1724, 1437, 1372, 1495, 1725, 1159, 1610, 1288, 1160, 1611, 1289, 
        1161, 1612, 1290, 1162, 1613, 1291, 1163}], 
       Line3DBox[{1165, 1496, 1669, 1164, 1497, 1670, 1166, 1498, 1671, 1167, 
        1499, 1672, 1168, 1726, 1373, 1374, 1169, 1727, 1375, 1376, 1170, 
        1729, 1377, 1378, 1728, 1171, 1379, 1380, 1754, 1172, 1381, 1382, 
        1755, 1173, 1383, 1384, 1730, 1174, 1500, 1673, 1175, 1614, 1292, 
        1176, 1615, 1293, 1177, 1616, 1294, 1178}], 
       Line3DBox[{1180, 1501, 1674, 1179, 1502, 1675, 1181, 1503, 1676, 1182, 
        1504, 1677, 1183, 1533, 1678, 1385, 1184, 1731, 1386, 1387, 1185, 
        1733, 1388, 1389, 1732, 1186, 1390, 1391, 1756, 1187, 1392, 931, 1188,
         1393, 1679, 1534, 1189, 1505, 1680, 1190, 1506, 1681, 1191, 1617, 
        1295, 1192, 1618, 1296, 1193}], 
       Line3DBox[{1207, 1405, 1404, 1737, 1206, 1691, 1512, 1205, 1690, 1511, 
        1204, 1689, 1510, 1203, 1538, 1688, 1403, 1202, 1537, 1687, 1402, 
        1201, 942, 1401, 1200, 1735, 1400, 1399, 1736, 1199, 1398, 1686, 1536,
         1198, 1397, 1685, 1535, 1197, 1684, 1509, 1196, 1683, 1508, 1195, 
        1682, 1507, 1194, 1734, 1395, 1394, 1396}]}}},
    VertexNormals->CompressedData["
1:eJztXXtYzlkefxnDGrOjmmKGkpBqilqXsTusw5i1LuVSQ4zriGUNa4aSqVnb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     "]]},
  AutomaticImageSize->True,
  Axes->True,
  AxesLabel->{
    FormBox["x", TraditionalForm], 
    FormBox["y", TraditionalForm], 
    FormBox["z", TraditionalForm]},
  ImageSize->{298.78338451344746`, 470.61842958923046`},
  Method->{},
  PlotRange->{{-1.9999997142857142`, 1.9999997142857142`}, {0., 
   3.9999988571429386`}, {-6.999999, 6.999999}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewPoint->{0.8680559915115842, -2.4853447419370265`, 2.1259210496457333`},
  ViewVertical->{-0.2298766635439543, -0.11549529362088537`, 
   0.9916926893600297}]], "Output",
 CellChangeTimes->{3.5885415635781927`*^9, 3.588541904622438*^9, 
  3.58854194193449*^9, 3.588542135312831*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p3", "=", 
  RowBox[{"ParametricPlot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"t", ",", 
      RowBox[{"t", "^", "2"}], ",", 
      RowBox[{"t", "^", "3"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Blue", ",", 
       RowBox[{"Thickness", "[", "0.05", "]"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.588541627032097*^9, 3.5885416667815247`*^9}, {
  3.588541731807044*^9, 3.588541768356072*^9}}],

Cell[BoxData[
 Graphics3DBox[{{}, {}, 
   {RGBColor[0, 0, 1], Thickness[0.05], Line3DBox[CompressedData["
1:eJxdmFcg1f//gEX2OIiGcIzISgilcl4fQigzhbIL36JIkhMyk2SFjKhsqWw6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     "]]}},
  Axes->True,
  Method->{},
  PlotRange->{{-1.999999918367347, 1.999999918367347}, {0., 
   3.9999996734693943`}, {-7.999999020408203, 7.999999020408203}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.588541768909177*^9, 3.5885421440721416`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.58854177894523*^9, 3.5885417908506203`*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJyFnXvUV1WZx1HueEt8VcQb1JuappmKYL7Tfh26iFxkSWUtJ5pAXS5XaDGV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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxFmwf8V9P/xz/33nPvJQ0hlYY0VIo0jKwUMrKJSkJpaMgopKGioaGflb0q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          "]], Polygon3DBox[CompressedData["
1:eJwtm3ngF1MbxWfmzr1fKZEkJVpVdmWnCC2E9pCyVBKiIi2WSlHZhayJ7Pu+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          "]], Polygon3DBox[CompressedData["
1:eJwt13mgTeUWAPDTde+WlKJShgxNKIRGsyhC5qFMSaFShgrhmmeZQmQeKzKk
orn0UioUjTKkUFSv0dSgXt5vvf3+WPfu9dvr+84+++zzfeuUvqN3y15ZmUxm
t8gRI7MzmRscfAXzikKssPyRJJO5O08ms45tYBew6awne4m9zWaxeqJEnGdT
nHtW/oxozZqz5WyU17iR7ZPnE2c7V1w+w3y9nH+ZbWIV5QNFZTaAzTglkyko
nyDasWVsGasiHy5qsbFsNnvdfGNYEzaLLTJf08jFg16/plij7g11Z7Gljq9m
G9S/wkaIBcbMMPYlliUfp6614wXxPpw7lU1kHdgTbC0rwR5lvWMe9g7LZuNZ
G7aQrWB52FjWis1nT7I32cOsPXucPc1Gu6b6fL88vziHnaFmhKitbhyb49ov
VvMY68feZB+oK8lmsj7sVfYuO1M+WtzMZrKFxpZSN4vdz15j78V7k+cTU5zv
wS51Hcvl36i9nv2gdq0oKJ/K73S8Ju6VsSvlv6gf6vi5eGZENXa9+NbY4/I2
zteW/218SceH2AHnyrOaYp/jfaxBfCZqJojV5lviNV7nN6pZzf5hB+Vd1c2T
HxGDjD1XPovPlv8q+sWzw6bF5ydva/wRc10lrjHHJueWsRXOPyV6s8msFftB
TXlRkdWTny+qO/eXuu/Nu1Z+zv+vrzfvI/aIp/ld/t+dnd6zNfKVjuup6+L/
HeJxttn/B9ml5lstarE/zFeMfy3fb+xB+X2iivwnUY9Ncr612h9dWwVxhTkW
qTkmhjlfJO6J2nJqaoiv2N64d3y1vIq6L4wZwT4Sv/IBrI7jF8RI5xbK2+ek
11zba8zlK4zdm51eQ1zLM/H8yzvxHMc3qbtZ/VnGTWF3xPtiL7K6ca/Eter/
4N+Z40x1k9jt8pXqnldXgE1mXdgq9kJcpzHN2ZfyEqIkm8NuifslryZqsrnG
thRXOa7MZprjWjV1xCGvd0TeyriFomMSX0bvRV39eL6M68BOyuuKG9l5bBq7
R9169ka8hrHt2Al5DVGbzWa3sj/l1UUt1lj+vvFFve4J4x9Q85R8RU46d7zG
Ul5RvipqHX8gdjo3TG1dvldNUVGAPcSuY5/Ik6z/XXpmaDxf8VnKzxdnxBoR
9090VjCPPcE2qLuTXcBas3ZsJ7uHXcHK5s1kPpfviGeWVWRl2Gfy3aIHqxTP
E9slPz0+N3Ebm2u+x833Kb+LVWCXqvtEviDuFftbTSVxZdznuPcsKz6b+OzY
/Lh/7K94lkUVdlqsiaJjfJfjXrH8se6KTmxO7AFsmbG3sWxWNT4TtjSeSZaH
XRefCVvMOrBT2DWsKktibY81gU1j81jeWLPFLWw6m8/2G9srnitWwXvbJ58R
awQ7qqaMKBfrUawB7Bp1V6j7Rv6R/EPxeqyJ6rY4dzy+Wz7zf+TXi+GekaOs
DTsc90nksm3Gd+OXG3Mnu8ccX7Pe7Op4drzGAfk6+cm4X8Z0UrfKuTd419iT
Y81l7Y39DxvJmrIJbDr7kHVn5dkl5tsu/0eMYs3Yw7H/qjvJRrPmbCJ7NJM2
DmNECzYpvm/olNjf4nvIJrNZbKaxbdjxuE/i8ugZWFv2m/yyWGfZY/GdZr9H
TaxtbLu8cKzP3tuzbLN5t7It4p3Yi9ir6r419n52LavkfRySHxYDY99iuepG
qTvKcmNdY0PYGFYsvuexzsYewNazY+oGsxvYUDaWFY1+SNwbayFbx86OtU50
ZYvj3rOy0SOJAbGeso2sXPQ5YiB7kb3FdsRa7709Hf0I2+7cu6xQkvY30ee8
zd5iG8WbedJ9MPabIrH/ih5sOXuOHXfNQ2J9YcPYOLaW3c7OjPWfNWRH2CBW
lw1mo9n37AF2Havs/n0n/zH2J1aNPRjPpLqfWF9WnfVlg9mfseezm2LvYBPZ
X2w4a8RGs8nsZ9aP1WD92BB2gg1jDaM/ZJPYKvlKsYw1YS3jfchPxPPmvjSL
vinedzw/Oen3J75HS6I3lC8VC/Ok+1bsX2O8RgN2INZIcS57hnVhZ6mrzxqx
Z2NvZgWj/2CNM2k/05/VZP2z0t7mKdaZ5Ys9O/YL9on845y0H46+eKtzh+N7
EL2T/BLR33VmyfNEL+u4I7vQXBtFT1bamO7sPnO8FWsOu5DdxXqyq823hI2J
fZt9xa5ki9gotp3tZVexxdHvsQ/Zl+xf5ruPlWLd2L3sVXUF2ALXUtn5l6OH
9P9eVjJ6K3U9Mmmf0oeVYT2z0p5lS3zfWFkWPyT6svfjeWGXsT7xftku+cex
DsZzk6TrTImYP0n78A2xXzq3NZ4/Vi56MNbP2LdjrWMXsbtZLzaAVXXdn8pP
FdLMQH+qsc/kp2Wlv2eix1lo7Ehjt2Wl/c7D6prw7+XFxAVsImvK/p2V/naJ
3zBTWTP2k7xUfEZsAruZfScvIoqzcawROxTPVOzVbDxrzL6Vnxevw4awOmyP
vLA4nQ2OPpjtlp8j8rNBrDrbETWxz7MK8gUOhnofW9jnrDybz4awzWwH252k
a3ms3/2SdB++XN08x4Mdv6fus+g12Rz2UKwrseawy9hclhvrD/uUXcJms/5s
I9vGXotegBVnXVh39kr0DKwo68y6xv6bpO8lrn8cHy/2JmnPEX3GgCTtJw4m
6boda/XQJF17foj1wHFVx8PNN94cpeTNxOfygqKP5+b32MtYfXVT2GPxnLrm
93LS30/xO2qTc18kaV8TvcxDSdrv7I+eWP5lrINJuq9/k6T7d+zZQ5J0H3kk
+k7z/Wyu0uIi805jLdgv8VyIi9lvsV8a08CYqWw2O5CkfUP0CrlJul/fFDWi
Gyudna4Bj0Yvb75jxpWNvTD2+CTd52NvH5yk/cTF/rcIj9fMSn/X7DJuZ6w7
zm9iHxuba0wttivWYX4aWxPrmrEF5C1527g/0TexhDVkTdiTsa6xvKwRa8qW
x/7BTmWNWTO2OtZOdgZrwdrEWhL9JCvGbmfd2AvRE7LCrD3rzJ6PfoOdy9qx
29j66HPi9wG7lXViY1lD7+Ng9B+8SKyr8tOT9Hd+BefX8z2xNsd9ULcz+jPn
noveR93Z8lt4R2PXRQ/MCrG2rAPbk6R9a/Sq/ZO07/0vU6chkA==
          "]], 
         Polygon3DBox[{{1702, 1242, 1241, 1701, 941, 942}, {1247, 1389, 819, 
          945, 1705, 1246}}]}]}, {}, {}, {}, {}}, {{}, {}, {}, {
       Line3DBox[{518, 723, 1712, 519, 735, 1722, 543, 1799, 748, 557, 1801, 
        761, 571, 1805, 774, 585, 1811, 787, 599, 1819, 800, 613, 1830, 813, 
        1754, 627, 826, 1766, 641, 1844, 839, 655, 1846, 852, 669, 1850, 865, 
        683, 1856, 878, 697, 1863, 891, 711}], 
       Line3DBox[{520, 724, 1713, 521, 736, 1723, 544, 749, 1732, 558, 1802, 
        762, 572, 1806, 775, 586, 1812, 788, 600, 1820, 801, 614, 1831, 814, 
        1755, 628, 827, 1767, 642, 840, 1777, 656, 1847, 853, 670, 1851, 866, 
        684, 1857, 879, 698, 1864, 892, 712}], 
       Line3DBox[{522, 725, 1714, 523, 737, 1724, 545, 750, 1733, 559, 763, 
        1740, 573, 1807, 776, 587, 1813, 789, 601, 1821, 802, 615, 1832, 815, 
        1756, 629, 828, 1768, 643, 841, 1778, 657, 854, 1785, 671, 1852, 867, 
        685, 1858, 880, 699, 1865, 893, 713}], 
       Line3DBox[{524, 726, 1715, 525, 738, 1725, 546, 751, 1734, 560, 764, 
        1741, 574, 777, 1746, 588, 1814, 790, 602, 1822, 803, 616, 1833, 816, 
        1757, 630, 829, 1769, 644, 842, 1779, 658, 855, 1786, 672, 868, 1791, 
        686, 1859, 881, 700, 1866, 894, 714}], 
       Line3DBox[{526, 903, 904, 1716, 527, 911, 912, 547, 916, 1875, 917, 
        561, 921, 1878, 922, 575, 926, 1881, 927, 589, 931, 1884, 932, 603, 
        1823, 936, 937, 617, 1834, 941, 942, 1758, 631, 946, 947, 1770, 645, 
        951, 1887, 952, 659, 956, 1890, 957, 673, 961, 1893, 962, 687, 966, 
        1896, 967, 701, 1867, 972, 973, 974}], Line3DBox[CompressedData["
1:eJwNyqtLgwEUhvGjm7cgaDAsLCwYDAaDwbB/wmDwvuk2L9++eZlGu7dgsVgs
FsuKxWKxGE2CIAwGgiAIgiAIwn7h4T3PwymUG7NpT0TMYaQ3IpuN6MNLJuIY
w+4FLOKVJwMRF3aUL2EZb7yuX9oxvoJVtHmqX9kcL6GMea2jXSPP13Cirdt3
7QYFdwWnetV+aLcYdx9pNbuBT62Fdn/EBN/EFr60pr87O8m3keCbH+j3dorX
keKHH+oPdpo3sIOq9qs9Yobv4kzbs3/aE4rufZzrTfuvDdlBPLu7XXQtIA==

        "]], 
       Line3DBox[{532, 730, 1718, 533, 742, 1727, 551, 755, 1735, 565, 1803, 
        768, 579, 1808, 781, 593, 1815, 794, 607, 1825, 807, 621, 1837, 820, 
        1761, 635, 833, 1772, 649, 846, 1780, 663, 1848, 859, 677, 1853, 872, 
        691, 1860, 885, 705, 1869, 898, 718}], 
       Line3DBox[{534, 731, 1719, 535, 743, 1728, 552, 756, 1736, 566, 769, 
        1742, 580, 1809, 782, 594, 1816, 795, 608, 1826, 808, 622, 1838, 821, 
        1762, 636, 834, 1773, 650, 847, 1781, 664, 860, 1787, 678, 1854, 873, 
        692, 1861, 886, 706, 1870, 899, 719}], 
       Line3DBox[{536, 732, 1720, 537, 744, 1729, 553, 757, 1737, 567, 770, 
        1743, 581, 783, 1747, 595, 1817, 796, 609, 1827, 809, 623, 1839, 822, 
        1763, 637, 835, 1774, 651, 848, 1782, 665, 861, 1788, 679, 874, 1792, 
        693, 1862, 887, 707, 1871, 900, 720}], 
       Line3DBox[{538, 733, 1721, 539, 745, 1730, 554, 758, 1738, 568, 771, 
        1744, 582, 784, 1748, 596, 797, 1750, 610, 1828, 810, 624, 1840, 823, 
        1764, 638, 836, 1775, 652, 849, 1783, 666, 862, 1789, 680, 875, 1793, 
        694, 888, 1795, 708, 1872, 901, 721}], 
       Line3DBox[{540, 909, 1873, 910, 541, 746, 1731, 555, 759, 1739, 569, 
        772, 1745, 583, 785, 1749, 597, 798, 1751, 611, 811, 1752, 625, 1841, 
        824, 1765, 639, 837, 1776, 653, 850, 1784, 667, 863, 1790, 681, 876, 
        1794, 695, 889, 1796, 709, 978, 1899, 979, 980}], 
       Line3DBox[{710, 890, 1898, 971, 696, 877, 1855, 682, 864, 1849, 668, 
        851, 1845, 654, 838, 1843, 640, 825, 1842, 626, 1753, 812, 1829, 612, 
        799, 1818, 598, 786, 1810, 584, 773, 1804, 570, 760, 1800, 556, 747, 
        1798, 542, 734, 1797, 517, 722, 902, 981}], Line3DBox[CompressedData["

1:eJwV0Nsq5WEcxvF3oRRibJolJjOMEJPNEBMy9nsLa8Y2R8qJgxEnOJD9Ms5d
wVyBK3ADLkAppZRSiqaUEvmsg2/f5/e8z8G/f+niSvxPJISwg/OUELZTQ8hM
CyEFb/JP7sRueggdfGazpp+X5/Ait/Gm93ZuxanNkn5WnsGz3MLrNj+4Gf9s
ZvXT8rF+ip/cjdyE7zixGdH9lv/a/OL/7jquRy0SNh26I+9x9yQe3DX8DdXY
sGnQJWwm3OO4d1dyFbb1FbxsV66PyWO4k79yObZsynjBJqoflUdwK3/mVe9f
uAQxmwz9sDyEG7mYV2w+cVHyn9q8YlA+1A/wtV2UC/Ex+Q+8P6JfPrDp4yub
fC5AXvLbvN9g33uvuweXNjn8AdnI9X6BPZtudxcubCKchYBUvAPCEDLa
        "]], 
       Line3DBox[{716, 896, 1034, 1023, 1915, 975, 703, 883, 1020, 1914, 969, 
        689, 870, 1017, 1912, 964, 675, 857, 1891, 1014, 959, 661, 844, 1888, 
        1011, 954, 647, 831, 1886, 1008, 949, 633, 1920, 818, 1005, 944, 1835,
         619, 805, 1002, 1907, 939, 605, 792, 999, 1906, 934, 591, 779, 996, 
        1904, 929, 577, 766, 1879, 993, 924, 563, 753, 1876, 990, 919, 549, 
        740, 1874, 987, 914, 530, 1916, 728, 984, 1031, 1030, 906}], 
       Line3DBox[{717, 897, 977, 1868, 704, 884, 1897, 970, 690, 871, 1895, 
        965, 676, 858, 1892, 960, 662, 845, 1889, 955, 648, 1771, 832, 950, 
        634, 1760, 819, 945, 1836, 620, 806, 940, 1824, 606, 793, 1885, 935, 
        592, 780, 1883, 930, 578, 767, 1880, 925, 564, 754, 1877, 920, 550, 
        1726, 741, 915, 531, 1717, 729, 907, 908}]}, {
       Line3DBox[{1142, 1428, 722, 1141, 1712, 1336, 1143, 1713, 1337, 1144, 
        1714, 1338, 1145, 1715, 1339, 1146, 1698, 1716, 1340, 1498, 905, 1518,
         1568, 1615, 1922, 1571, 1569, 1570, 1519, 1916, 1341, 1499, 1429, 
        1717, 1342, 1147, 1718, 1343, 1148, 1719, 1344, 1149, 1720, 1345, 
        1150, 1721, 1346, 1151, 1873, 1430, 1347, 1431}], 
       Line3DBox[{1153, 1616, 1797, 1152, 1722, 1348, 1154, 1723, 1349, 1155, 
        1724, 1350, 1156, 1725, 1351, 1157, 912, 1352, 1500, 1900, 1432, 1520,
         1572, 1617, 1923, 1575, 1573, 1574, 1521, 1618, 1874, 1501, 1433, 
        1726, 1353, 1158, 1727, 1354, 1159, 1728, 1355, 1160, 1729, 1356, 
        1161, 1730, 1357, 1162, 1731, 1358, 1163}], 
       Line3DBox[{1165, 1619, 1798, 1164, 1620, 1799, 1166, 1732, 1359, 1167, 
        1733, 1360, 1168, 1734, 1361, 1169, 1875, 1434, 1362, 1502, 1901, 
        1435, 1522, 1576, 1596, 1577, 1924, 1503, 1578, 1436, 1523, 1621, 
        1876, 1504, 1437, 1622, 1877, 1170, 1735, 1363, 1171, 1736, 1364, 
        1172, 1737, 1365, 1173, 1738, 1366, 1174, 1739, 1367, 1175}], 
       Line3DBox[{1177, 1623, 1800, 1176, 1624, 1801, 1178, 1625, 1802, 1179, 
        1740, 1368, 1180, 1741, 1369, 1181, 1878, 1438, 1370, 1505, 1902, 
        1439, 1524, 1579, 1597, 1580, 1925, 1506, 1581, 1440, 1525, 1626, 
        1879, 1507, 1441, 1627, 1880, 1182, 1628, 1803, 1183, 1742, 1371, 
        1184, 1743, 1372, 1185, 1744, 1373, 1186, 1745, 1374, 1187}], 
       Line3DBox[{1189, 1629, 1804, 1188, 1630, 1805, 1190, 1631, 1806, 1191, 
        1632, 1807, 1192, 1746, 1375, 1193, 1881, 1442, 1443, 1194, 1709, 
        1882, 1444, 1604, 1445, 1598, 1528, 1903, 1529, 1527, 1446, 1526, 
        1447, 1904, 1195, 1448, 1449, 1883, 1196, 1633, 1808, 1197, 1634, 
        1809, 1198, 1747, 1376, 1199, 1748, 1377, 1200, 1749, 1378, 1201}], 
       Line3DBox[{1203, 1635, 1810, 1202, 1636, 1811, 1204, 1637, 1812, 1205, 
        1638, 1813, 1206, 1639, 1814, 1207, 1884, 1450, 1451, 1208, 1930, 
        1605, 1452, 1606, 1453, 1599, 1532, 1905, 1533, 1531, 1454, 1530, 
        1455, 1906, 1209, 1456, 1457, 1885, 1210, 1640, 1815, 1211, 1641, 
        1816, 1212, 1642, 1817, 1213, 1750, 1379, 1214, 1751, 1380, 1215}], 
       Line3DBox[{1217, 1643, 1818, 1216, 1644, 1819, 1218, 1645, 1820, 1219, 
        1646, 1821, 1220, 1647, 1822, 1221, 1699, 1823, 1458, 1222, 1931, 
        1607, 1608, 1534, 1539, 1538, 1917, 1223, 1536, 1537, 1535, 1459, 
        1907, 1224, 1460, 1824, 1700, 1225, 1648, 1825, 1226, 1649, 1826, 
        1227, 1650, 1827, 1228, 1651, 1828, 1229, 1752, 1381, 1230}], 
       Line3DBox[{1234, 1753, 1382, 1232, 1754, 1383, 1236, 1755, 1384, 1238, 
        1756, 1385, 1240, 1757, 1386, 1242, 1702, 1758, 1387, 1508, 1703, 
        1759, 1546, 1582, 1657, 1926, 1585, 1583, 1584, 1547, 1920, 1388, 
        1509, 1463, 1760, 1389, 1247, 1761, 1390, 1249, 1762, 1391, 1251, 
        1763, 1392, 1253, 1764, 1393, 1255, 1765, 1394, 1257}], 
       Line3DBox[{1256, 1841, 1662, 1254, 1840, 1661, 1252, 1839, 1660, 1250, 
        1838, 1659, 1248, 1837, 1658, 1246, 1705, 1836, 1462, 1245, 1704, 
        1835, 1541, 1543, 1542, 1244, 1919, 1544, 1545, 1540, 1609, 1918, 
        1710, 1243, 1461, 1834, 1701, 1241, 1833, 1656, 1239, 1832, 1655, 
        1237, 1831, 1654, 1235, 1830, 1653, 1231, 1829, 1652, 1233}], 
       Line3DBox[{1259, 1663, 1842, 1258, 1766, 1395, 1260, 1767, 1396, 1261, 
        1768, 1397, 1262, 1769, 1398, 1263, 1706, 1770, 1399, 1510, 1908, 
        1464, 1548, 1586, 1664, 1927, 1589, 1587, 1588, 1549, 1665, 1886, 
        1511, 1465, 1771, 1400, 1264, 1772, 1401, 1265, 1773, 1402, 1266, 
        1774, 1403, 1267, 1775, 1404, 1268, 1776, 1405, 1269}], 
       Line3DBox[{1271, 1666, 1843, 1270, 1667, 1844, 1272, 1777, 1406, 1273, 
        1778, 1407, 1274, 1779, 1408, 1275, 1887, 1466, 1409, 1512, 1909, 
        1467, 1550, 1590, 1600, 1591, 1928, 1513, 1592, 1468, 1551, 1668, 
        1888, 1514, 1469, 1669, 1889, 1276, 1780, 1410, 1277, 1781, 1411, 
        1278, 1782, 1412, 1279, 1783, 1413, 1280, 1784, 1414, 1281}], 
       Line3DBox[{1283, 1670, 1845, 1282, 1671, 1846, 1284, 1672, 1847, 1285, 
        1785, 1415, 1286, 1786, 1416, 1287, 1890, 1470, 1417, 1515, 1910, 
        1471, 1552, 1593, 1601, 1594, 1929, 1516, 1595, 1472, 1553, 1673, 
        1891, 1517, 1473, 1674, 1892, 1288, 1675, 1848, 1289, 1787, 1418, 
        1290, 1788, 1419, 1291, 1789, 1420, 1292, 1790, 1421, 1293}], 
       Line3DBox[{1295, 1676, 1849, 1294, 1677, 1850, 1296, 1678, 1851, 1297, 
        1679, 1852, 1298, 1791, 1422, 1299, 1893, 1474, 1475, 1300, 1711, 
        1894, 1476, 1610, 1477, 1602, 1556, 1911, 1557, 1555, 1478, 1554, 
        1479, 1912, 1301, 1480, 1481, 1895, 1302, 1680, 1853, 1303, 1681, 
        1854, 1304, 1792, 1423, 1305, 1793, 1424, 1306, 1794, 1425, 1307}], 
       Line3DBox[{1309, 1682, 1855, 1308, 1683, 1856, 1310, 1684, 1857, 1311, 
        1685, 1858, 1312, 1686, 1859, 1313, 1896, 1482, 1483, 1314, 1932, 
        1611, 1484, 1612, 1485, 1603, 1560, 1913, 1561, 1559, 1486, 1558, 
        1487, 1914, 1315, 1488, 1489, 1897, 1316, 1687, 1860, 1317, 1688, 
        1861, 1318, 1689, 1862, 1319, 1795, 1426, 1320, 1796, 1427, 1321}], 
       Line3DBox[{1335, 1497, 1496, 1899, 1334, 1872, 1697, 1333, 1871, 1696, 
        1332, 1870, 1695, 1331, 1869, 1694, 1330, 1708, 1868, 1495, 1329, 
        1915, 1494, 1563, 1565, 1564, 1328, 1921, 1566, 1567, 1562, 1614, 
        1613, 1933, 1327, 1493, 1867, 1707, 1326, 1866, 1693, 1325, 1865, 
        1692, 1324, 1864, 1691, 1323, 1863, 1690, 1322, 1898, 1491, 1490, 
        1492}]}}},
    VertexNormals->CompressedData["
1:eJztXWlQVUcWRsGlogGNYRk0oAlGjTNaKgST0XTEDQR1ABkShJST0ZK4xCWK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     "]], GraphicsComplex3DBox[CompressedData["
1:eJyFXWm0XVWRDoTkEaZIBAIEMmhENHQLCATbR++DjZioIA1Ks9QGRQJIk0U3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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmgXUF9UWxefGjIFiC4j6AFvC7kRRJCyehZiEiSjYiIAiSNiopCAmZSFY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          "]], 
         Polygon3DBox[CompressedData["
1:eJxFmwn8F9P3xmfunftRlqSQvUX2KDuJSGWtlF1lKWRroRAttEi2lH2vCIlU
ZBcpIftOZcm+ZN/3fs+75/5f/9erec08987Mdz4z557znOecmvbq361fKIri
8FgUlfbXp6J4uFYU7wsPLIuinvZfaTtPxy9pfi3Nr6z5+4TXFV5fuIHwAuHN
hSfrJguEv9A1wzS2mvZfahuu4xc1P0TnX6f5mRrbW2NB+8+0DdHxE5ofoeMl
2k4XHidc6vhTbecKzxG+Qvd/Std/orFzNHau7net8AzhvYSvE35I+D3hM4TX
E15D+Gkdb6brJ+n6+cKfa36oxvjRqwo/qOP1Bd/Ufn/NldrvLPy1rl9J8/cI
ryV8s/Djwh/pnLM1dp72i7UN0PFlmn9G96uv+W009oPw2dq/o60v5wrfpOsf
0/xSjZ2lsauEHxB+V7ifcE3Xry78hI6b6fyVhdcUflZ4S+Ezdd7b2k4THi78
j46T5qcKNxT+QfgPbZNLv4/lOl5F87N5F5pPul894TnCTYV/0vzP2sYLLxOe
oPknNf+xxgZr7Cs9X014mo7X1HzU/AUymMeFmwhfpPM+0DZI+CbhNXT+OZq/
Vbi+8IM6fyH2onOWCv+pfRSeovk1hP/G7oTvEG4gvKaurys8S3gd4WXJ7/NJ
4Y2F19X532gbJbxEuKHm62BPwo2EL9Hch9rOFL5Z+AQ9yy3C2ws/jz3peVbT
+Q8LbyA8Q/g54WU6Z6TGHtD+e20X6vgzzZ+u+1/O82psZ43N0P1+0v5Qza2k
/eOV7aNp9PkLNF9P2+m8C83/rOu31vy6GhumsX46f1fhzYQvET5VeGfhTYQv
Eu4rvIvwpsIXY0/ar67tDB030P2e1v1aar6//t7awr8KbyO8XrA9/J7n1w+2
t2e1r69tIO9K5/+t+daa31xjl2I/wnsL7yx8o/Bo/f39hDsI3yV8nvC+wnsJ
TxEeLryP8J7CtwkfpuvbC+8uPEm4i+Y3F15T+GzhocIdhPcQniw8TLijcFts
RHg/Xd9KeEPh84U7CW8n3Fh4pPABwtsKbyQ8Qrhl9FpcW8c/artO9+ui+aM1
/xT+S/gg4WOE5wlfK9xZuKfwXPyP8IPCI3Wfy4U3E+4uvET33LOwPzoq2Ne0
0lgU7h7sm7YVvlLnz9X512h8usaO1/MtrtlHtdT8NM0/I3y78ALNXyM8T/gG
4ZnCtwo/LTxJ+HHh5sJHCi/StXsId9X92uA/9DcnCJ8ovKRmH8nzzNT5zwrf
LfyC5vtr/r2afeyO+GDN98D/sf41v6nwUcKLhdtmf3pk8N/meU/X/O6ab6mx
KzS2s/BxrAfNHST8KMFBW2/tVsVHav5wzb+g41Ya21v3e0XHO+j4X217Cb8s
vD22pe0RXbtcuJeOV2HN6fojdP2LOt5WY031/OvW7Hfxt80034z4gR/GHwiv
J/yW8C7Cj+l+pbbjdbwaMUjzh2n+eR235BmF1xZeKNyC3yi8sfAvwofzTYWb
C/8qfATfVHgT4d+EjxS+V/f+UceH6LiGTWh+M80njZ+ksbbCmwpXwn2Ep2v/
g847GN+KXWp+A82/o+PWGqsvfGjN/rJpxo3y7+f97SR8rPDXwl2Et9f76CX8
jXBX4cGa30t4R/2d64UHCrcV3lb4KuFzhNsJ7yR8Q/69PbFHXb+v8BnCewi3
0vyVwoOE9xTeTvjqwt9jo2wv2P+OwscIfyXcmecRPhr7Eu5E/BdeX/ht4V3x
ccLrCL+Uv+eu+v5zdbwJvkjbQfo9u2l+a/298cKNdP6GxDuds5twPeFDhB/L
8aSpcFPis/B+wo2FG+ffsw/2GR0Lmuv4N9af7nuTxrbT2ELhMTr/UZ1/qcZu
ER4rfIBwZ503S7idnudN4Vej/fN+mp8pfHy0jeK/mTuxtM/FvudpOyLb9C46
fzr2prFjecfCs4RfET5BuIP281ljeU1cpr93J/wIP6KxS4XvgI/gZ3gHwm/w
/qLXF+vlRZ6l9Jr7Lsej/eEGrA8dP6jtAOGVhAfo78/WxOBo/8l65V69S6+R
1pq/V/NHRdso8eQ1HfcpHRN21fwM1rPGjuOb6nler/kZWK+sh4U6PibHvC10
/jTNP6OxHtnf3CV8YLS/aKPzL9fxlpqbWJgX7in8d2F+uJvmxwlvUfr74OfG
CG9S2t9hJxcINy9tL2/wjSKOSzbO+q/MR5rAC4Vb6PzROt64tD9/nW8ivBxb
Lsz72gr/VZj/zcfPCv+Jb9R2KH5PuIXGH83r+Tnho7MP2FJ/7x74l8Z6aqyn
8H3C/aJjPDx4Jx3/WpgPw0N2gFMV5iPExfHCW5WOj/CaHYV/KcxvDmMdC2+t
8ceEL9T959R8zeQc7x7l3Zbmny31fV6t+RnxN/Drk4JjAf4fvn5yMNfeCQ6l
819gfWn8J42trv0pwVwePrMl3wJOJfwtrl5//2ad30JjGwo/pP2m2r7S8YGs
a961ti+EvyzMBw+ume/B5xro7z1fs41yTnPhV2peE/8JX6TzDxTuome4j/OF
JwnvwhrOv39/4U7B8XJDXf8ifDjan2wk/BJ8EJ4rvLHwyzWvUeLPhrp+inC7
6Ph3sXAn4YN0v/uxr2guy7uEn6fMZ6dk/tlQeLLObxNtH6N1/4n4b+FuOuci
4duEnxI+vLS/49kOyT5pt+hnOzT7wLE6/1adP1djh+Ejo79F18xhttLfu5vn
01h74TrCt+Cfo+3nP+1vqvmd1xGuq/mGrD9dvwUxVXgt7EF4K+E7hbsK98WP
CU8V7oa9su6FZ+s+G2n7WMf78jx6vtdqXuPEu7u0v1Nbax230baRrr9d8x2j
19P90Vy+I/64tH+eWnPORHyeDj/TtjvrDp+u+SbwlxyPvtXf610zhz5MeH/y
BeHTdc06rDnsQGMdNfdJ6Vh2X7LvJwbAbWYlxypiFtxtZjK3gcMRq+4XPrBw
zCJen5DjP/Ge2DY7OZYR44i9DyTHOmIw3OfB5FgMB8LfTi9t69jzzsn+9GG9
z5U1/nBeH3U116m0nbD+WdvYy6i8/raPtodmyfYJT4IfbZ38/e/R/Sp8ZXI8
ehreDl9KXh/EPeLd2snrcyvh74TnRPsTfM/BZeYOyb4YDgH3m5HMLeGAcKU7
yRkKcyZi763CjQvHYLjKbcmxGM5C7KybvFaJoccLP5T87X4ubVv1iRmFbYxv
yTcldpK3nCj8iHB3+EDpb98mOZZgA3DJqcncDU6J7a6ebKvYMFzxrmSuBGeC
66+WzO3h/HD9esLzC3N+uP6qybkAnB9fs3Ly2sfn4KsmJuem+Cy4973Cuxfm
4PiKVYRnF/YZ5xLbkmMleRTv/RGeo/T7vzD7o92j4z353HnCa3Ft4Xx9vZyL
ra9r+ibz/1U5H/+s/cDgtcKaGZicP6zJegJH547kdusJn5ScT5CXkI8MTs4H
1slr7nDhR4QvxC6Fz9LznC/cPOeXw6JzP7SKJsRCnX+q5v/B9vGJwqdBNDLH
3l34FOG/WSvCJ+h+Q4UbaP4s4T7Cw4Qb5nwPvjqi5nyW/BV9ZItgLaep7nGy
5ofXnB8OZj7Hi+bR/rBXcn5VCG9TmjcR/8kN4E/wlO7RzwpfQQ8YpHu1Y+2U
9rPEd2I9/nZMjh+to/lbY+3vglOU5g/wuCOifxt8bj0dn6n7dSitT/0m/KO2
i3V8U2l95Vtto0uP7VaZL/WI5gttKvO5ntE2Dk/qHM3l4UvwPvgJXAb+d3GO
X+011k5jl+R4uY/w3oXjDPwF7kS8aVE5/nfTWAf8R2X/fXC0z4SndCVWFeYr
HTV/sub/0vExfB8d75vMXdApzhb+TXiA8KrBuXqZnJuTs6MFJOFphTUBcv+Y
rAWgAaANVMK3F9YIyNWXVc7dydnJ9UOyVkDOT675R+VchJyTXOavyrkIOc1O
wj8IX0hsD9YWimQuBJci1/m3slZBzkMu8bZwm8I5BbnXW5VzC3Iwcpt3KnMB
4gVaw9eVtQQ0B7SGb4RHFdYcyI3+Fr6mcI5E7vVP5dyKHAyt5L/KWheaCbnQ
m5VzPXIitJwfK9s+a2B74W+FR7PegrVVNNZJxJtgrRLNEq78VbA2gUYBN/4y
eC1fkH8vaxrtEA3xXuFf4crC75JTCLcLzn3IgdAmfgnW8tD07ha+klgh/L3w
GGIR3Fn4jeTckt93Fly28npl3e6g+e/gSKzf4Fzyz8q5JzklWtVPlbUsNCu0
pV8q+xf8DFrG75W1Bbj+KOHX0YCFdwjODX+r/p/7o439XFmbQiM7i/vp/P7C
qwRziSWVc0M4BdrB65W5BxoCvuq7ZFvHZ+Hbvk9e3/g41sLjwkcXXhN9hB8V
7iH8B/5V+DHhnsJ/Cp8h/BQ+Ungl/f2+rNVk34gOMVB4Hj5TuI7w6cJz8ZnC
NeFBwvOF+wrXDY4NC+E8hWPEmbw/4X7CKwsPEV4gPEh4jWDf+myyr8XH4ltf
Svbl2Be++BnhMwv7ZLjOw8laB5wHX/tcsm/G5xILXhQeWzgmoK28UTmXR2PB
9++dnHsSA/oJzxE+ARjsO/AhA+CncFAdf1o51vF70Dq/rByviFtbCX9OzBBu
JNxC+IvKWug6wlsKfyY8RHjt4Fx/cWWuCN9DC3ivshaEJjBA+Mlk7QUNBq3x
k8qxhN+HtvNhZS0Hjae/8BM6/0RCiuZHCr8mfK3w9sG5Rp1kbYCcA23no8pa
D/dH+/kYH1pYA0Kbeh9NobBGhbb0QWVuyftGS1oqfFRhTalT5XfIu+MZ2lXm
RHAhbK5DZZvD1rBJtH9qAGj5FwZr/9QAqE1cFsz9yQHQ8i8Nrm1Q4yCfvDi4
FkNNhnz0kmDtf0UNQHhEsFaOZk4+Nzy4lkNNh/zv/GC94W49y/WlNXC08hWa
ueZHBdcOyJnIlcYE14nI11m/1IuoY5wb7V+pZ1CHIT8nl6cec43+1tu6x/nR
PvRa4XeER0Xr9dRiVtRktBuJ/yOWaxunazuX1vbQ+MhNL9f8Is0NiY43/UvX
MzbXNrH0NT/n678uXOMgX0Dzhd9PC+Z/aLDkA1OD+TKaKfnAXZkvkuM2ER4d
zJfRrOCr44PzETQQ+PbdwfkKGhzrb2Ywn0bzg79OEP5dz/IL70vPMinzXzRV
8pebM99Fk9tT+BbhX3l2bbuVvobaCDUSfs95wbUe+En70jUfaivUWDRVnBtc
W6HGon/FkGD+j2ZKPnATNlk5JhAL8PHUkqgpabgYGuxP4YD14A8av1LHb2ns
nOgYcYPwu8IXR8cY/AmaLbnpdcHxGE2U3PSGHC/REKllXZ/jN5ogWu2N/P7K
PgLfgM9AW0RjbEb8Co7f1AzwPa/xeyr7GHwLPqRX5ZhLrCWmN8rvv6mOrwjm
A7xftMqJeT03y3zhzmB/0zTH8zuyP2qc48uUHH+aZH95e/B63zb7p/uD4xGa
NnrXtcH+oWX2Z7Oyf2qV49d9wjfq3EUau4y8uTB/ouZBLvy65rtV9pH4Rnws
dUf0NfgD9UfqrJOja1vUW2+rXA+4NbqGsSzn44sK17fIK/oTB0rnF9RRr43W
nqinUpdEn4OPUJ/8Ndvru/iP0nyJGs26On4juE6IfoV2Rr2Quir1NrRY6quH
VI4RxAZiHv50z+yfn8z+tm32n09kf94l+98XhI+vzEHgHnCoqyrXW66L5kBX
V66PXC88o7AWgiZCbW9ccPwnx1md/CY6/sOJibfzg+N/+8rx+yn4hs69pua6
Ie90tuauFz5V+JXC9cwba85NyVEfgBsKnxast0yE+wgfgu8iZtZc70Zze1n4
HrivcC/hZ4XP1N+7umYdm3c2HW4l3Fv4OThGzfVtND00u1vgRsIHwyXxGXAv
4W5wSXwi3JnfFFy/u7QyR4Qb3lm4XrtLsK/drDSnhMfii8kXT9bzjKtZF+Wb
Ug+EI8IN4cDj4I5wBOGprFm4rnBXuKvwf8n1UmpmT+IT4X7Cxwk/I/xn1nvQ
BsipyT/2Sa5l9tWz/JH5BbkJGkLvypwILgTH6Vw5phPL4QAdkzki3JAchm/J
N4XLweF+TOZscDU4DPrYhJq1ATSCv5JzfHJ7OBe2B8cg9mODdwiPF+4RXD8c
VZnDwl3hzCMqcwq4BJz28MqcEC4I5zuyMgeE+2FzHZI5H1wPTtu1MmeEK8Ix
D63MOeGa2CT1y4tq5iZwlPHCY2vOxcjJXtY76xV9r+OzfkUND/77UHD+Mjjn
I58H50/nZL7+RXB+RQ0X/X1ZcL5GjZb87NtgvWePytzl8eD8b3jm/98F54tD
M7//JjgfpGZMPvd9sB5FTasO2lK0/kaNiW/zQDD3gQPxruYFcyM4Eu9ibvC3
4JvAX58P5lJwKmzhuWBbwCbgxwuD9TxqanCpB4P1QGpYcK3ZwfwYf4PtzAnO
Pwfm/Obj4Pzt1MxnFwXnN30zP10crIdRU7oVWw7mj2jW5Kd/BOtR1KDRm1aK
1quoUaOf1aL1Kb4p3zJF601o1FOE/w65jhRty9ST9q9crzoxmpOjZ6Ghk0//
FayXYdPYcoNoPQ7Nd55ww+h8ql/m30uC81tqgGOEP+H9V865ybUZe6JmG8O2
JkTne9QQ8b0fBedr1PQ20rN9EJzPU0Mm1i4N1gvwGfiKn4PzP2rajXX+h8G9
M/TQ4Kt/C+5d+KqyPoZOhvZDjZ36NKSFWDiefKrMMbFmzYX6GDUq1n8P+Lnw
Wtl/0eND7KEmCF99OvMHel7g1wsq95LQY0OsJGbSn0QNHf75VI4f9ASxXrsT
j4idpbnQPpXXGpyI2EMMon+JGj3cCI5Evw99P+TTVyT369C3Q+ycQD5ZOoYS
m6gh8q2JUWhHaEjU76jj8e2xAeqR1CXh4/My/6WHBX4/t3J+QI8PvTL0IDUv
XCclvtxbOXa3zvzxicp6MbWo23TPKZX7u+jzGqbzH2I9lNb44ZMPV+b71Ejo
daHnBa2OPgz45SOV8xV6eIif9NTANeCs9+qesyr369C3Q/4xp7I+Tq2M/OaF
zA/pcWqlc56trJVTRybfeT7zRWoe5DvPVdbDqO2R7yyszDepNR6drHfARajp
kd88WTlfolZ3anKPGlyJnqAeyfYIl6JGd2xyjxlciJoc3AyORj8RfUUjsj/F
938WnE+jseL7Pw3O7/Ef5OfvBvt6bAjbOTk6VhIzF2i+TrRvxx8QW6roWIZN
Y8unRsceYhDco3507GK9wzXWiK7FbqnzY2mtEf1wUeVaGDVo9EHqKfQqUcOl
Fn1PKlbUU9FWqd1uLhxK13CpR22TXFukXgy3gGMQu+tG10JbJNcq0Bqp/UxP
7pejBkT+8GjlXjF60uBCcCK4zCrR3II1ytq8Mdo3XJ2cu+EjyA3JEemno6+O
3JAckX5A+gLxPfTMkVvig7on62FwVWrOcEM4Iv2C9OTMyf6ZWuLvwbEO/Y1c
lZh3aLL+Rm5KzfmYyvULfA0+Z2z2h3C55cGxHw4A9/kxmBvh7+BaPwVzATgB
XOuHYC4GJ4Or/RfM3eBwcL+Vo7kZHA3u9E8wt4JjweX+Da51U/OmXkndcsfk
mj3ad93SsZWeBLRrYiy9dkOT1y51uvsq91yiZaNZo7WjudM/QI2W2E6Mp5ZD
znpEzufo6YMfoj2iQY6NjglH5nyFtbB56Vz0/OTaFzkpa52eTHoPWfP0K52T
rM0vLlwLoyZG/ZM6KOt9ZHJ9mzo3WsSI5FwfTWIQ3yY5V9k15zcDkmvb+Oxu
WU/AVqgv0Mt3dnItZFn2bfTwUevGx22R3MOAFo/NH5z1B2yrmXDnnN/iuzco
rQkPjbbNkYW1MTSyPtH9eGjc6A/Y4ojCtSL45BnR/r195p8nRfffEeuIeadF
r3G0MjSzU6J9BNoyGvPw6PoMWiqa6qDo+g+aNfrKhqX7PailUVM7OrofCl55
bHRs+j/NFH5IbIFTfFu6HoG/oEaAJkr9A1s6LvNLOAA9Edj8N9kv8K6oYaCp
HhZta8cWrg1PS67tUyPeLLnnhVoNPoFaBj4JX0QPAGvzhOReNtYovbinJPti
ckdif+/k3jQ4AL53pWRbxAfT6/J88reh54Xe2ReS3wfaE3pELTmXoSeV2Nwn
uVZGjKZ3+Ljk2hK5L/r4Mcm+nlyWWgo+E1+5MPuPd5JjAz0ZvJueybGFdwSf
eTvZ95Cbo8+/ldzfsjTrJejpK2p/pfX5N5PXDj1KRyXr9ej9XLNVcs8JtRu+
0bGVbQpbgjN0Se754dvzm9H6Lkiu/aL5Ueui5kU/An0J1CapUdKPQF8CWiE9
DdSm0Qw3Te5JohZFTKC2RI2J/hd6TKhNUaOi/4keC7QNeiCoRaFxNEnucaDW
Ro8N/Y39kntR6EnBdy+vvDbx4dQ/Xk32tWiH+HpsHlvH5x+SXP+gl4eeHuoh
LyevzZGZS7EmWAtwKnrNT0uupaKFUE95JflatMdNknsY6F2gJwjfho1gG/g4
fmur5N4HfjO9UPhX1saR0b1e+Fdsnx55av/0VPUq3AOA/XP/9sKTgmv79KDQ
y0KNn16vu5P/NrU/+hu2qVw/p5eYeMr33lu4Sz6f79FBeHJw7wc9IPSCDAuO
9/ivdsKdonsB6NmpV7g2TS8BMZzYTU8B8Z712JFvExyv0bPop7gt5PhfuT52
QHR8+jA5/qAx0ItCT8qmwmODe1/4/tRjrxFupOP5lWvh3xd+3luSeyXoWeH6
Scm9R/S0rJt8P34PPVL02kxJ7uWh5wZtmt9LrwsaNbECPkivLzGDWAG/pXdn
RU+Urn+xsn5IDwy9Ntgj9dWrg+/fMH//q4J7ebB/6sMXBfdWNMj5AD0W6IUv
V9YH6TdAb34JH124pxQ98pX8fel5hB99kBy/0WDgO0uT4z0aEPzuvWT+QQ5P
7Z81wtqgB4DaPTGS2EgNn/iNxoS2NCs6nsGn0aKmRfeG0LNI/ZYeEfwn+Q5a
zc3R6wF+i543MbqXgJ7kNwtrf/QO0JOMNkMPAf50QF5v7+l+9xNLsn95NVir
+jSZ/6FZ4W/hX+j57wf3PpK/EDt6R/tX+DNa5tXR9+Ke9MzRO4e29Vky/0Hj
Qhv6JJkPoxHBbz9O5sNoNPCvJcn8qkPmR4uS+RUaFFoT8Z3+7O6Zby1O5mdo
YPDt94UfKKxRwT//TY5taFzkP/AJtNKjsn1MTrZNennQ+r5M5ttofmhx8Bv6
69Dk4OcfJb9PNCK0vOXJfBdND+0P/oV2hwZIPgQf4vvTt4fWSGMn2h+aI1rj
58laIZoj2uIXyfwfjRFf/lrlXjh8Olo//9+Cnq5Q2P5vT+5vpBeCXBKOADcg
p7wx29dS4gf5dWWOAjfpk/3fTsm9TfRajEvmKHATcmDW/x3Jvp7eBJ4XjfQD
4fWjnxdN9EPhDYQvT+Y8K3Lz0rksHAruRE6LL90ludcUnzo8me9+WrjnFVvf
K7lXF5sntr1auReKGId9oqm+Lbx2tD22Te6dQktBK2id3FuLZoC9oUm+pfPX
io5t71buxSLGNU72F/g73iH2iib7jo4bRf//lr+0/6RwDx3xYYdk/kQvCd+f
nJtc+47o70tOTC48NZp7kz9/VpiD/w8pOln/
          "]], 
         Polygon3DBox[CompressedData["
1:eJwt13ncTdUex/HznOc5T5kSigo3QxOVmWtoMqTbgMwNyFDmuOTSLQmlgaLh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          "]], Polygon3DBox[CompressedData["
1:eJwl0L8rRXEYx/HHvVjVnUxK3cmPSRElNiyIgXO3e6+I/CgLBpPFYsPIHUwU
fwOjQcSortEgCpMir293eHc+n/f5nufbczorGzPruYhoQytGWyJGUM1H/DZF
/GFBXuNWcSrP+WAeNbnSHPGGR31T/3GmrG97buGcW/RuCRdyO1fDvn5j9jX6
+AJ3gl3+irtEke/gznDIP3D3GOYHuH5k8jv3gZKccU/4dn4C4zjgZ7k7vOpD
GMQe38v1YEqum/GCafmLK9kjw6e8zK2kfdN+OMo3Zqc7juVJ7hbPeje6sMMX
0z9IO+cas9MdY/w/bfQw2A==
          "]]}]}, {}, {}, {}, {}}, {{}, {}, {}, {
       Line3DBox[{419, 634, 1539, 420, 645, 444, 1621, 657, 459, 1623, 669, 
        474, 1626, 681, 489, 1631, 693, 504, 1639, 705, 519, 1650, 717, 1578, 
        534, 729, 1591, 549, 1665, 741, 564, 1667, 753, 579, 1670, 765, 594, 
        1675, 777, 609, 1682, 789, 624}], 
       Line3DBox[{421, 635, 1540, 422, 646, 1550, 445, 658, 1559, 460, 1624, 
        670, 475, 1627, 682, 490, 1632, 694, 505, 1640, 706, 520, 1651, 718, 
        1579, 535, 730, 1592, 550, 742, 1601, 565, 1668, 754, 580, 1671, 766, 
        595, 1676, 778, 610, 1683, 790, 625}], 
       Line3DBox[{423, 636, 1541, 424, 647, 1551, 446, 659, 1560, 461, 671, 
        1566, 476, 1628, 683, 491, 1633, 695, 506, 1641, 707, 521, 1652, 719, 
        1580, 536, 731, 1593, 551, 743, 1602, 566, 755, 1609, 581, 1672, 767, 
        596, 1677, 779, 611, 1684, 791, 626}], 
       Line3DBox[{425, 799, 800, 1542, 426, 813, 814, 1552, 447, 823, 1696, 
        824, 462, 833, 1700, 834, 477, 843, 1705, 844, 492, 1634, 853, 854, 
        507, 1642, 863, 864, 522, 1653, 873, 874, 1581, 537, 883, 884, 1594, 
        552, 893, 894, 1603, 567, 903, 1721, 904, 582, 913, 1726, 914, 597, 
        1678, 923, 924, 612, 1685, 934, 935, 937}], 
       Line3DBox[{427, 1006, 1007, 949, 801, 1543, 428, 815, 954, 816, 448, 
        825, 958, 1740, 826, 463, 835, 962, 1742, 836, 478, 845, 1706, 966, 
        846, 493, 855, 1709, 970, 856, 508, 1643, 865, 974, 866, 523, 1654, 
        875, 978, 876, 1582, 538, 885, 982, 886, 553, 895, 986, 1750, 896, 
        568, 905, 990, 1752, 906, 583, 915, 1727, 994, 916, 598, 925, 1731, 
        998, 926, 613, 1686, 936, 1002, 1013, 1012, 1015}], 
       Line3DBox[{429, 802, 950, 1738, 804, 430, 817, 955, 1739, 819, 449, 
        827, 959, 1741, 829, 464, 837, 963, 1743, 839, 479, 847, 1708, 967, 
        849, 494, 857, 1711, 971, 859, 509, 867, 1713, 975, 869, 524, 1655, 
        877, 979, 879, 1583, 539, 887, 983, 1749, 889, 554, 897, 987, 1751, 
        899, 569, 907, 991, 1753, 909, 584, 917, 1729, 995, 919, 599, 927, 
        1733, 999, 929, 614, 938, 1736, 1003, 940, 941}], 
       Line3DBox[{435, 641, 1547, 436, 652, 1555, 454, 664, 1562, 469, 676, 
        1567, 484, 1629, 688, 499, 1636, 700, 514, 1646, 712, 529, 1659, 724, 
        1587, 544, 736, 1597, 559, 748, 1605, 574, 760, 1610, 589, 1673, 772, 
        604, 1680, 784, 619, 1689, 795, 630}], 
       Line3DBox[{437, 642, 1548, 438, 653, 1556, 455, 665, 1563, 470, 677, 
        1568, 485, 689, 1571, 500, 1637, 701, 515, 1647, 713, 530, 1660, 725, 
        1588, 545, 737, 1598, 560, 749, 1606, 575, 761, 1611, 590, 773, 1614, 
        605, 1681, 785, 620, 1690, 796, 631}], 
       Line3DBox[{439, 643, 1549, 440, 654, 1557, 456, 666, 1564, 471, 678, 
        1569, 486, 690, 1572, 501, 702, 1574, 516, 1648, 714, 531, 1661, 726, 
        1589, 546, 738, 1599, 561, 750, 1607, 576, 762, 1612, 591, 774, 1615, 
        606, 786, 1617, 621, 1691, 797, 632}], 
       Line3DBox[{441, 811, 1693, 812, 442, 655, 1558, 457, 667, 1565, 472, 
        679, 1570, 487, 691, 1573, 502, 703, 1575, 517, 715, 1576, 532, 1662, 
        727, 1590, 547, 739, 1600, 562, 751, 1608, 577, 763, 1613, 592, 775, 
        1616, 607, 787, 1618, 622, 945, 1737, 946, 947}], 
       Line3DBox[{623, 788, 1734, 933, 608, 776, 1674, 593, 764, 1669, 578, 
        752, 1666, 563, 740, 1664, 548, 728, 1663, 533, 1577, 716, 1649, 518, 
        704, 1638, 503, 692, 1630, 488, 680, 1625, 473, 668, 1622, 458, 656, 
        1620, 443, 644, 1619, 418, 633, 798, 948}], 
       Line3DBox[{627, 792, 1735, 939, 615, 780, 1732, 928, 600, 768, 1728, 
        918, 585, 756, 1722, 908, 570, 744, 1718, 898, 555, 732, 1716, 888, 
        540, 720, 1715, 1714, 878, 525, 708, 1712, 868, 510, 696, 1710, 858, 
        495, 684, 1707, 848, 480, 672, 1701, 838, 465, 660, 1697, 828, 450, 
        648, 1694, 818, 431, 637, 1692, 803, 805}], 
       Line3DBox[{628, 793, 1004, 942, 616, 781, 1000, 1756, 930, 601, 769, 
        996, 1754, 920, 586, 757, 1723, 992, 910, 571, 745, 1719, 988, 900, 
        556, 733, 1717, 984, 890, 541, 1584, 721, 980, 880, 1656, 526, 709, 
        976, 1748, 870, 511, 697, 972, 1746, 860, 496, 685, 968, 1744, 850, 
        481, 673, 1702, 964, 840, 466, 661, 1698, 960, 830, 451, 649, 1695, 
        956, 820, 432, 1544, 638, 952, 806, 951}], 
       Line3DBox[{629, 794, 944, 1688, 618, 783, 932, 1679, 603, 771, 1730, 
        922, 588, 759, 1725, 912, 573, 1604, 747, 902, 558, 1596, 735, 892, 
        543, 1586, 723, 882, 1658, 528, 711, 872, 1645, 513, 699, 862, 1635, 
        498, 687, 852, 483, 675, 1704, 842, 468, 1561, 663, 832, 453, 1554, 
        651, 822, 434, 1546, 640, 809, 810}], 
       Line3DBox[{808, 1010, 1011, 807, 953, 639, 1545, 433, 821, 957, 650, 
        1553, 452, 831, 961, 1699, 662, 467, 841, 965, 1703, 674, 482, 851, 
        1745, 969, 686, 497, 861, 1747, 973, 698, 512, 1644, 871, 977, 710, 
        527, 1657, 881, 981, 722, 1585, 542, 891, 985, 734, 1595, 557, 901, 
        989, 1720, 746, 572, 911, 993, 1724, 758, 587, 921, 1755, 997, 770, 
        602, 931, 1001, 782, 617, 1687, 943, 1005, 1008, 1016, 1009, 
        1014}]}, {
       Line3DBox[{1018, 1297, 633, 1017, 1539, 1208, 1019, 1540, 1209, 1020, 
        1541, 1210, 1021, 1513, 1542, 1211, 1406, 1514, 1543, 1212, 1407, 
        1738, 1298, 1438, 1692, 1022, 1299, 1544, 1213, 1408, 1300, 1545, 
        1214, 1409, 1301, 1546, 1215, 1023, 1547, 1216, 1024, 1548, 1217, 
        1025, 1549, 1218, 1026, 1693, 1302, 1219, 1303}], 
       Line3DBox[{1028, 1439, 1619, 1027, 645, 1029, 1550, 1220, 1030, 1551, 
        1221, 1031, 1515, 1552, 1222, 1410, 816, 1223, 1411, 1739, 1304, 1440,
         1694, 1032, 1305, 1441, 1695, 1412, 1306, 1553, 1224, 1413, 1307, 
        1554, 1225, 1033, 1555, 1226, 1034, 1556, 1227, 1035, 1557, 1228, 
        1036, 1558, 1229, 1037}], 
       Line3DBox[{1039, 1442, 1620, 1038, 1443, 1621, 1040, 1559, 1230, 1041, 
        1560, 1231, 1042, 1696, 1308, 1232, 1414, 1740, 1309, 1233, 1415, 
        1741, 1310, 1444, 1697, 1043, 1311, 1445, 1698, 1416, 1312, 1446, 
        1699, 1417, 1313, 1561, 1234, 1044, 1562, 1235, 1045, 1563, 1236, 
        1046, 1564, 1237, 1047, 1565, 1238, 1048}], 
       Line3DBox[{1050, 1447, 1622, 1049, 1448, 1623, 1051, 1449, 1624, 1052, 
        1566, 1239, 1053, 1700, 1314, 1240, 1418, 1742, 1315, 1241, 1419, 
        1743, 1316, 1450, 1701, 1054, 1317, 1451, 1702, 1420, 1318, 1452, 
        1703, 1421, 1319, 1453, 1704, 1055, 1567, 1242, 1056, 1568, 1243, 
        1057, 1569, 1244, 1058, 1570, 1245, 1059}], 
       Line3DBox[{1061, 1454, 1625, 1060, 1455, 1626, 1062, 1456, 1627, 1063, 
        1457, 1628, 1064, 1705, 1320, 1321, 1065, 1706, 1322, 1323, 1066, 
        1708, 1324, 1325, 1707, 1067, 1326, 1327, 1744, 1068, 1328, 1329, 
        1745, 1069, 1330, 852, 1070, 1458, 1629, 1071, 1571, 1246, 1072, 1572,
         1247, 1073, 1573, 1248, 1074}], 
       Line3DBox[{1076, 1459, 1630, 1075, 1460, 1631, 1077, 1461, 1632, 1078, 
        1462, 1633, 1079, 1516, 1634, 1331, 1080, 1709, 1332, 1333, 1081, 
        1711, 1334, 1335, 1710, 1082, 1336, 1337, 1746, 1083, 1338, 1339, 
        1747, 1084, 1340, 1635, 1517, 1085, 1463, 1636, 1086, 1464, 1637, 
        1087, 1574, 1249, 1088, 1575, 1250, 1089}], 
       Line3DBox[{1091, 1465, 1638, 1090, 1466, 1639, 1092, 1467, 1640, 1093, 
        1468, 1641, 1094, 1518, 1642, 1341, 1095, 1519, 1643, 1342, 1096, 
        1713, 1343, 1344, 1712, 1097, 1345, 1346, 1748, 1098, 1347, 1644, 
        1520, 1099, 1348, 1645, 1521, 1100, 1469, 1646, 1101, 1470, 1647, 
        1102, 1471, 1648, 1103, 1576, 1251, 1104}], 
       Line3DBox[{1108, 1577, 1252, 1106, 1578, 1253, 1110, 1579, 1254, 1112, 
        1580, 1255, 1114, 1523, 1581, 1256, 1422, 1525, 1582, 1257, 1423, 
        1527, 1583, 1476, 1715, 1118, 1353, 1584, 1258, 1424, 1355, 1585, 
        1259, 1425, 1357, 1586, 1260, 1122, 1587, 1261, 1124, 1588, 1262, 
        1126, 1589, 1263, 1128, 1590, 1264, 1130}], 
       Line3DBox[{1129, 1662, 1480, 1127, 1661, 1479, 1125, 1660, 1478, 1123, 
        1659, 1477, 1121, 1530, 1658, 1356, 1120, 1529, 1657, 1354, 1119, 
        1528, 1656, 1352, 1117, 1714, 1351, 1655, 1526, 1116, 1350, 1654, 
        1524, 1115, 1349, 1653, 1522, 1113, 1652, 1475, 1111, 1651, 1474, 
        1109, 1650, 1473, 1105, 1649, 1472, 1107}], 
       Line3DBox[{1132, 1481, 1663, 1131, 1591, 1265, 1133, 1592, 1266, 1134, 
        1593, 1267, 1135, 1531, 1594, 1268, 1426, 886, 1269, 1427, 1749, 1358,
         1482, 1716, 1136, 1359, 1483, 1717, 1428, 1360, 1595, 1270, 1429, 
        1361, 1596, 1271, 1137, 1597, 1272, 1138, 1598, 1273, 1139, 1599, 
        1274, 1140, 1600, 1275, 1141}], 
       Line3DBox[{1143, 1484, 1664, 1142, 1485, 1665, 1144, 1601, 1276, 1145, 
        1602, 1277, 1146, 1532, 1603, 1278, 1430, 1750, 1362, 1279, 1431, 
        1751, 1363, 1486, 1718, 1147, 1364, 1487, 1719, 1432, 1365, 1488, 
        1720, 1433, 1366, 1604, 1280, 1148, 1605, 1281, 1149, 1606, 1282, 
        1150, 1607, 1283, 1151, 1608, 1284, 1152}], 
       Line3DBox[{1154, 1489, 1666, 1153, 1490, 1667, 1155, 1491, 1668, 1156, 
        1609, 1285, 1157, 1721, 1367, 1286, 1434, 1752, 1368, 1287, 1435, 
        1753, 1369, 1492, 1722, 1158, 1370, 1493, 1723, 1436, 1371, 1494, 
        1724, 1437, 1372, 1495, 1725, 1159, 1610, 1288, 1160, 1611, 1289, 
        1161, 1612, 1290, 1162, 1613, 1291, 1163}], 
       Line3DBox[{1165, 1496, 1669, 1164, 1497, 1670, 1166, 1498, 1671, 1167, 
        1499, 1672, 1168, 1726, 1373, 1374, 1169, 1727, 1375, 1376, 1170, 
        1729, 1377, 1378, 1728, 1171, 1379, 1380, 1754, 1172, 1381, 1382, 
        1755, 1173, 1383, 1384, 1730, 1174, 1500, 1673, 1175, 1614, 1292, 
        1176, 1615, 1293, 1177, 1616, 1294, 1178}], 
       Line3DBox[{1180, 1501, 1674, 1179, 1502, 1675, 1181, 1503, 1676, 1182, 
        1504, 1677, 1183, 1533, 1678, 1385, 1184, 1731, 1386, 1387, 1185, 
        1733, 1388, 1389, 1732, 1186, 1390, 1391, 1756, 1187, 1392, 931, 1188,
         1393, 1679, 1534, 1189, 1505, 1680, 1190, 1506, 1681, 1191, 1617, 
        1295, 1192, 1618, 1296, 1193}], 
       Line3DBox[{1207, 1405, 1404, 1737, 1206, 1691, 1512, 1205, 1690, 1511, 
        1204, 1689, 1510, 1203, 1538, 1688, 1403, 1202, 1537, 1687, 1402, 
        1201, 942, 1401, 1200, 1735, 1400, 1399, 1736, 1199, 1398, 1686, 1536,
         1198, 1397, 1685, 1535, 1197, 1684, 1509, 1196, 1683, 1508, 1195, 
        1682, 1507, 1194, 1734, 1395, 1394, 1396}]}}},
    VertexNormals->CompressedData["
1:eJztXXtYzlkefxnDGrOjmmKGkpBqilqXsTusw5i1LuVSQ4zriGUNa4aSqVnb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     "]], {{}, {}, 
    {RGBColor[0, 0, 1], Thickness[0.05], Line3DBox[CompressedData["
1:eJxdmFcg1f//gEX2OIiGcIzISgilcl4fQigzhbIL36JIkhMyk2SFjKhsqWw6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      "]]}}},
  Axes->True,
  AxesLabel->{
    FormBox["x", TraditionalForm], 
    FormBox["y", TraditionalForm], 
    FormBox["z", TraditionalForm]},
  Method->{},
  PlotRange->{{-1.9999997142857142`, 1.9999997142857142`}, {0., 
   3.9999988571429386`}, {-6.999999, 6.999999}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5885421511106987`*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.588541928102738*^9, 3.588541928152231*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"r0", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";", 
  RowBox[{"p", "=", 
   RowBox[{"Point", "[", 
    RowBox[{"{", "r0", "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ptest", "=", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"t", "^", "2"}], ",", 
        RowBox[{"t", "^", "3"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"-", "1.3"}], ",", "2"}], "\[IndentingNewLine]", "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Blue", ",", 
         RowBox[{"Thickness", "[", "0.02", "]"}]}], "]"}]}]}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.588548167835803*^9, 3.5885482699916897`*^9}, {
  3.5885483180168123`*^9, 3.5885483457721148`*^9}, {3.588548470952203*^9, 
  3.588548491375152*^9}, {3.5885487821109657`*^9, 3.58854887135455*^9}, {
  3.588549303419938*^9, 3.5885493043553658`*^9}, {3.588549372882867*^9, 
  3.5885493746828747`*^9}, {3.588549414665967*^9, 3.588549424647643*^9}, {
  3.5885505242579947`*^9, 3.588550544431409*^9}, {3.588550584598352*^9, 
  3.588550595517703*^9}, {3.5885515191650877`*^9, 3.588551536235917*^9}, {
  3.588553219212254*^9, 3.58855322174332*^9}}],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Green", ",", " ", 
        RowBox[{"PointSize", "[", "0.08", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1", ",", 
             RowBox[{"-", "1"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "h"}], ")"}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "h"}], ")"}], "^", "2"}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "h"}], ")"}], "^", "3"}]}], "}"}]}], 
          "}"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "\[IndentingNewLine]", 
        RowBox[{"Thickness", "[", "0.015", "]"}], ",", "\[IndentingNewLine]", 
        
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1", ",", 
             RowBox[{"-", "1"}]}], "}"}], ",", 
           RowBox[{"r0", "+", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "/", "h"}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "h"}], ")"}], ",", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "h"}], ")"}], "^", "2"}], ",", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "h"}], ")"}], "^", "3"}]}], 
                "}"}], "-", "r0"}], ")"}]}]}]}], "}"}], "\[IndentingNewLine]",
          "]"}]}], "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"Purple", ",", 
        RowBox[{"Thickness", "[", "0.001", "]"}], ",", "\[IndentingNewLine]", 
        
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1", ",", 
             RowBox[{"-", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "h"}], ")"}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "h"}], ")"}], "^", "2"}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "h"}], ")"}], "^", "3"}]}], "}"}]}], 
          "}"}], "\[IndentingNewLine]", "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"ptest", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "\[IndentingNewLine]", "}"}], "]"}], 
   ",", "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"h", ",", "3", ",", "0.03"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.588548496267815*^9, 3.588548642611884*^9}, {
   3.58854887541193*^9, 3.588548955887018*^9}, {3.588549223774169*^9, 
   3.588549241268779*^9}, 3.5885493231306477`*^9, {3.5885494413819*^9, 
   3.5885494526628227`*^9}, {3.588549487500271*^9, 3.588549488438936*^9}, {
   3.5885495420776033`*^9, 3.588549547661934*^9}, {3.5885496110962887`*^9, 
   3.588549652127329*^9}, {3.588549702261742*^9, 3.588549715509034*^9}, {
   3.588549752956815*^9, 3.588549826713584*^9}, {3.588550192932988*^9, 
   3.5885501936762247`*^9}, {3.58855024441057*^9, 3.588550263690257*^9}, {
   3.588550309514832*^9, 3.588550312424343*^9}, {3.588550727739406*^9, 
   3.5885507291531553`*^9}, {3.588550783251061*^9, 3.58855097021819*^9}, {
   3.588551017226762*^9, 3.588551030151578*^9}, {3.588551491106798*^9, 
   3.588551503190783*^9}, {3.58855156897507*^9, 3.5885516504830217`*^9}, {
   3.5885516978030577`*^9, 3.588551726143794*^9}, {3.588551768912361*^9, 
   3.5885518493071547`*^9}, 3.588551945241271*^9, 3.5885520147115088`*^9, {
   3.588552245693883*^9, 3.588552253428439*^9}, {3.588552329786824*^9, 
   3.588552335697864*^9}, {3.588552442430088*^9, 3.588552612401535*^9}, {
   3.588552645386854*^9, 3.5885526790475473`*^9}, {3.588552713823874*^9, 
   3.588552747731099*^9}, {3.588552793508101*^9, 3.5885528145872803`*^9}, {
   3.588553081388438*^9, 3.588553095887128*^9}, {3.58855324198346*^9, 
   3.588553279617804*^9}}],

Cell[BoxData[
 RowBox[{
  TagBox[
   StyleBox[
    DynamicModuleBox[{$CellContext`h$$ = 2.255, Typeset`show$$ = True, 
     Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
     Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
     "\"untitled\"", Typeset`specs$$ = {{
       Hold[$CellContext`h$$], 3, 0.03}}, Typeset`size$$ = {
     404., {215., 219.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
     Typeset`skipInitDone$$ = True, $CellContext`h$40535$$ = 0}, 
     DynamicBox[Manipulate`ManipulateBoxes[
      1, StandardForm, "Variables" :> {$CellContext`h$$ = 3}, 
       "ControllerVariables" :> {
         Hold[$CellContext`h$$, $CellContext`h$40535$$, 0]}, 
       "OtherVariables" :> {
        Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
         Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
         Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
         Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
       Graphics3D[{{Green, 
           PointSize[0.08], 
           
           Point[{{-1, 
             1, -1}, {-1 + $CellContext`h$$, (-1 + $CellContext`h$$)^2, (-1 + \
$CellContext`h$$)^3}}]}, {Red, 
           Thickness[0.015], 
           
           Arrow[{{-1, 
             1, -1}, $CellContext`r0 + (
               1/$CellContext`h$$) ({-1 + $CellContext`h$$, (-1 + \
$CellContext`h$$)^2, (-1 + $CellContext`h$$)^3} - $CellContext`r0)}]}, {
          Purple, 
           Thickness[0.001], 
           
           Arrow[{{-1, 
             1, -1}, {-1 + $CellContext`h$$, (-1 + $CellContext`h$$)^2, (-1 + \
$CellContext`h$$)^3}}]}, 
          Part[$CellContext`ptest, 1]}], 
       "Specifications" :> {{$CellContext`h$$, 3, 0.03}}, "Options" :> {}, 
       "DefaultOptions" :> {}],
      ImageSizeCache->{449., {259., 264.}},
      SingleEvaluation->True],
     Deinitialization:>None,
     DynamicModuleValues:>{},
     SynchronousInitialization->True,
     UnsavedVariables:>{Typeset`initDone$$},
     UntrackedVariables:>{Typeset`size$$}], "Manipulate",
    Deployed->True,
    StripOnInput->False],
   Manipulate`InterpretManipulate[1]], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.588562394648884*^9, 3.588562405000856*^9}}],

Cell[TextData[{
 "In ",
 StyleBox["purple",
  FontColor->RGBColor[0.5, 0, 0.5]],
 ": ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox[
     SubscriptBox["r", "h"], "\[RightVector]"], "-", 
    SubscriptBox[
     OverscriptBox["r", "\[RightVector]"], "0"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", as ",
 Cell[BoxData[
  FormBox[Cell[TextData[Cell[BoxData[
    FormBox["h", TraditionalForm]],
    FormatType->"TraditionalForm"]]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " runs from 3 to 0.03.\[LineSeparator]In ",
 StyleBox["red",
  FontColor->RGBColor[1, 0, 0]],
 ": ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["r", "\[RightVector]"], "h"], "-", 
      SubscriptBox[
       OverscriptBox["r", "\[RightVector]"], "0"]}], ")"}], "/", "h"}], 
   TraditionalForm]],
  FormatType->"TraditionalForm"]
}], "Text",
 CellChangeTimes->{{3.588562420077675*^9, 3.588562526359371*^9}, {
  3.588562559702964*^9, 3.588562610505766*^9}, {3.588562649674601*^9, 
  3.588562676257305*^9}, {3.5885627264113073`*^9, 3.58856281896376*^9}}]
},
WindowSize->{848, 721},
WindowMargins->{{4, Automatic}, {Automatic, 4}},
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, \
2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 2197, 57, 97, "Input"],
Cell[2779, 81, 5219, 95, 192, "Output"]
}, Open  ]],
Cell[8013, 179, 1110, 24, 252, "Text"],
Cell[CellGroupData[{
Cell[9148, 207, 1144, 25, 63, "Input"],
Cell[10295, 234, 72997, 1186, 447, 50941, 823, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[83307, 1423, 237, 7, 125, "Text"],
Cell[CellGroupData[{
Cell[83569, 1434, 767, 20, 63, "Input"],
Cell[84339, 1456, 48314, 782, 447, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[132690, 2243, 172, 4, 28, "Input"],
Cell[132865, 2249, 99373, 1599, 486, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[232275, 3853, 644, 17, 63, "Input"],
Cell[232922, 3872, 6260, 108, 447, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[239219, 3985, 184, 4, 28, "Input"],
Cell[239406, 3991, 133694, 2163, 447, 104933, 1690, "CachedBoxData", \
"BoxData", "Output"]
}, Open  ]],
Cell[373115, 6157, 92, 1, 28, InheritFromParent],
Cell[373210, 6160, 1467, 35, 114, "Input"],
Cell[374680, 6197, 4987, 115, 403, "Input"],
Cell[379670, 6314, 2241, 51, 569, InheritFromParent],
Cell[381914, 6367, 1130, 37, 57, "Text"]
}
]
*)

(* End of internal cache information *)
