(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    209858,       3802]
NotebookOptionsPosition[    205128,       3683]
NotebookOutlinePosition[    205483,       3699]
CellTagsIndexPosition[    205440,       3696]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Catapult Problem", "Title",
 CellChangeTimes->{{3.5770432430825787`*^9, 
  3.57704324680157*^9}},ExpressionUUID->"c529f58b-248d-42b4-b766-\
0cb807be5ef8"],

Cell[TextData[{
 "A medieval city has the shape of a square and is protected by walls with \
length ",
 StyleBox["500",
  FontWeight->"Bold"],
 " =10*",
 StyleBox["50",
  FontColor->RGBColor[1, 0, 0]],
 " meters and height ",
 StyleBox["15",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]],
 " meters.You are the commander of an attacking army and the closest you can \
get to the wall is 100 meters.Your plan is to set fire to the city by \
catapulting heated rocks over the wall with an initial speed of 80 meters per \
second.At what range of angles should you tell your men to set the \
catapult?Assume that you will be firing from exactly 100 meters from the wall \
and that you will be firing perpendicular to the wall.We also assume that the \
walls of the city are impervious to heated rocks."
}], "Text",
 CellChangeTimes->{
  3.577043269224084*^9, {3.7348659873039618`*^9, 
   3.73486599159195*^9}},ExpressionUUID->"e3a13556-f46f-4ae3-b094-\
c57a65eeafa7"],

Cell[CellGroupData[{

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzs3QdcU9cCBnD31qqtu1at1lqtWGvVWtsqtvbV0dLaYW3pblHrrF1iFdnL
gQgiihoXOBAVFXDhQBEUA4oDByKigIAECCNAIH0XTjyEIYbk3pwkfP+fv/cq
JPd+gZh8Offec/r8NG+KRaMGDRr80YL7nyk//mO6YMGPlp+15/7yxdw/Zk6f
++svE+b++ev0Xxe8+VNj7ovvc7edxf1H2X//BwAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABg
XIqLi3Nzc1mnqEFqco6r9cnvPtlhMc1/19ZLRUVy1okAAAAAoIynp+cPP/zA
OkVVAX6xvds4dGqwlP4ZNcDjyqVU1rkAAAAA4L8VK1Z89dVXrFNUsnHNedXq
SP/0aed4+0YG63QAAAAA9Z2+FcgjB290avi4NDZc+q2Zn+lra2mH5P4bx7IB
AABAT8lOjOvWoVufMt06tHjl54DyrybMGtqtW7c+HVp0+DkghXFCnuhVgczL
KxrScwXpit2b2R4+cIP7YmlpqeWcINohbf4+yjomAAAAQI1k4Rt/btGgTItR
/yY8/ur1gFncVzqMs0uo7b6GRK8KpLPVCVoUd2+7RL8ul5f8b+R68vXOjaxj
o42kvQMAAIDxCZr1SnmDHBf9+Cvh/w5t0KCbbxbLVPzSnwL5KCOvd1vlhTOf
j99S5bt3bj/q1dqefHfqhG1MEgIAAAA8XVZAeYNsMMqOVMjrE1twf1nOOBWv
9KdA2vx9lJ76WOMF167WJ+n4pPj8fd0nBAAAAFBHwM99yCDkda5OBv3M/ees
E0Y0/qg3BTIvr6hfBydSDn+ZurvG2+RKC/s/60xuM/v7vTpOCAAAAKCuFN9u
5YOQU3yjPcdxTXKK0Zz9SOhJgdzkdYGOLtZyiqPtP8pRyp4t7bKzCnSZEAAA
AEB9vlNIhVQ9lm089KRAvvPqGtIMJ7+zsZabJcRn0kl+Nq45r7N4AAAAAHWT
4NlB2R9fCTCqw9dl9KFAng+/R4cfA3dfrf3Gn5iKyC0/GLFeN/EAAAAANOA5
sWwQssPE2gbHDJQ+FMjZ3+8lnfCVzq7FxSW133jnlhjaNm/FpesmIQAAAEBd
pWycyBXIf8NlrIPwj3mBlMtL6Ow9tv88fZLwvLwiuky2s9UJHSQEAAAAqDuZ
3dAGDTr8bJSzVzMvkBFhiRWXz8So9TOe/vUecvu3B3kKHQ8AAACgLmQJ16+n
yP7LCv+3QYMG45ZfZ51HEMwLpMO/x0kbHNjFVaFQqHOXgwHXaOe8fSND6IQA
AAAAagr/d1SDCuOM7errx5gXyHGve5MqONM8QM275OcXvdBKuSqNu/MZQeMB
AAAAqO8EWcewTDe7cKO7+voxtgXy3l0JHUsM8ItV/47ffbKD3OvTcZuFiwcA
AABQN7IE3+V2dst9rxtteSzDtkB6rQgnPbBHc1tpTh2uUdq45jy9Y0FBsXAJ
AQAAAKAKtgVywigf0gOnTdpepzvG38ygQ5cnj8YLFA8AAAAAqmNYICWZ+Z0b
WZMS6Ceq80mmr72wktzX5u+nT/4DAAAAAHxhWCBVL6Z+mCqt693n/riP3Pe9
Yd5CxAMAAACAGjEskP/MOkQa4OiBmkzn6L/9Mrl750bWWZIC3uMBAAAAQI0Y
FshRAzxIA7ScE6TB3VOTc+gA5qG9xjlLJwAAAIAeYlUg09Nyaf0L2qdh/aMV
dOFsTSooAAAAAGiAVYEMCYyjBfJRRp5mG6EHwbGmIQAAAIDOsCqQ9ouUKxgO
77tK440c2FNxGU56Wi6P8QAAAADgSVgVyE/HbSbFb8Y3ezTeyKOMvE4NlQVy
/64rPMYDAAAAgCdhUiBLS0t7t3Ugxc/HI1KbTY0x8SLb+XPGQb7iAQAAAEAt
mBTIa7EP6aHnmKgH2mxq0bxgsp13Xl3DVzwAAAAAqAWTArnN5yJpfc+3sCsu
LtFmU/t2XqGzQeZKC/lKCAAAAABPwqRAzv8lkLS+iW9t0HJTSYlZdDDzzIkE
XuIBAAAAQC2YFMh3Xl1DKt/i30O039rALq5ka26OYdpvDQAAAABqp/sCmSst
7NzImsdLp80/9iNb+9bMT/utAQAAAEDtdF8gw0/dpQed792VaL9BN4fTZGsm
z6/QfmsAAAAAUDvdF0ivFeGk7/V/1pmXDR4LukkbqSQzn5dtAgAAAMCT6L5A
Tv96Dyl7X3ywlZcNpibn4DoaAAAAAJ3RfYF88+XVpOzZWx7ja5svP+dCtunt
do6vbQIAAADoPWlsWKCvSCTy9RcnSqt/Wy6JD/Xnvu8bKk6s6e7yeHFo2bf9
Q2u69xPpuEDmSgvp4oMH9lzja7NT3lMujDj7+718bRMAAABAr8niLE0aqLIM
jFP9fnqkd/mXTczNym5nahlYuSQme5uXf9vMvHwzpv5x6pZIHRdI1StokhKz
+NrskgWHyTZNX1vL1zYBAAAA9Jgs0IJrfWaikMiwQG9TZYW0iJM9/n56aPkX
LWLLW2Gku1nZrb3F9P5htmXftxDFlv1FElb27QZm4moV8tSpU926detaWdu2
bVu0aNG1Gj8/QabE4f0KGmLX1ktks92b2Wq5tA0AAACAAZBGmjYwi6Tz2SQG
lo8imkUqG6A8pHx00tw79vHtxeaqN0gOKb+9eezjwikuH440cxf/V1lxcXF0
dLS4st9///2DDz4QV1NQUCDEY+X9Chri6uVUOrDJ/TePWwYAAADQT3LVv0jD
SCEUk0Ioiy2viw28Y+mQolRUPsho4Vt2mDtOROqkiH5bFuutHMOstN2a6fgQ
thBX0PxX1o1LujezJVveuSWGxy0DAAAA6D95+QikuUg5fiiNFTWoekha5m9R
fqaje2RZmST9UeWItizet0GlMcza6LJAll1B04D/K2gI06FryZaXLDjM75YB
AAAA9Jk0MbS8G5rEPh48lCqHEyu1wdjHrVH6eDSy0gHrx4OW7uKnr/OiywK5
a0uMEFfQEHN+2Ee2/Om4zfxuGQAAAEBPVbkQ28SSXEgtEbs3qHyKIyeWXHRt
yhVIiXd5gTQXxapsSqyfBXLh7CDS8bo0suZ9495u54S4PAcAAABAj8nSkxNj
w/znP74M27R8UFEqLh+BNLFVnfyxeoG0DElW2ZKejkAumhtMOt6ol1fzvvGz
JxPo8Gby/Wzetw8AAACgxyTkADW5LqamQ9jyEEvTxzeQkgJpqnIIW668Llv1
upsn0mWB/GridlLwZn3H/3Tf2VkFtEAeOXiD9+0DAAAA6DNZnC8ZYJSU/beo
WoFUlsby8x6lvuZVz4FUDlrWNBVkdboskCNecicFb4XdKSG2P7TXSkG3DwAA
AKC/pJFlDdHct/y0x/j5ZDixog4qCyQ5Qp0YOP/xBTWPv00GLcv751PprEDK
5SVdm9iQgrd/1xUhdvGtmR/Z/o+f7RRi+wAAAAD6QyqRyFTmbEwOseQKoEtY
OvmruLwvmtqGkb/K4/3JWZHKsx6lYnIQO0zZF+X+FmVHsC1DVc6KfDKdFcg7
tx7RQ8yx0SlC7MLZ6gTZ/oh+7kJsHwAAAEBPPD7L0cTFNzQ+OTHS37b8IuzA
iquu5YmW5TfwjZP+J4t3URl+JBLLC2cDC3/pf//Fh7iQAUl1hh//02GBDAmM
UxbIhktzcwuF2MWhvdfpLvLzi4TYBQAAAIA+kCvXLqyYwcc9JK7qjSTi+RU3
MvUOS6zyfbHv/Ipvzxclyqpu4El0ViBX2p8m7e713m4C7eLm9XQ6yHn9ykOB
9gIAAACgF+TS5OTEMsnpT65+svRabyCTlH0/XaJ2dyynswL561f+pNp9PdlX
oF3IZMWdGioLZPD+aiUcAAAAAPigswL59iBPIVbBrsLk+RVkL14rwoXbCwAA
AEB9ppsCWVQkp5dgB/jFPv0Omvp4zCayl79/OyTcXgAAAADqM90UyKuXU3Vz
duLcn/aTvXzxwVbh9gIAAABQn+mmQO7xvUx6XbemNsXFJcLtyM1BeanO8L6r
hNsL6I/chw/vnDgZs217xGrPUGvbQ3Pn+3/7w66vvlH9s/enX0P++OukvWPk
mrWX/XbcCz8ny8ZilwAAAJrTTYF0XBxKet3bgzwF3VHg7qtkR10aWxcWyp9+
BzAopSUlKTEx59euC5zxm887Yx2e7bK4QVPN/rj27LNlwuTDf/1zecdOyd27
rB8ZAACAIdFNgfz5y92k133/6Q5BdxR3NY0eK78Wi5l8jIG8sPD20WPHFltt
HDfetk17jRtj7X+cOnff/vGnpxyc7p2L4Goq6wcNAACg13RTIMcO8SKlzm6h
gJdg/1f5ap19OwVZMBF0Iz0uLnzV6i0TJlu3bPvU+mfT+hnXnn08hwzbaPq+
35Qvdk0zV/2z7aNP1r89ZvWgIS7dX7Bu0eapW7Pv0Gnn1K/Fos3S1FTWPwYA
AAB9pIMCqVAoXmhlT0qdnyha0H1xRg3wIPtyWhIq9L6AdznJyaedXNz6D6yt
LrZqxxXCwBm/RXisuRN6IvdhHYaauWdjVmLijUNBp51d/c2/9xg8dEmjZk/c
V8Om3I6iN28pys8X7iEDAAAYHB0UyAdJ2fSw8oVzSYLui/PDlJ1kXz9+tlPo
fQFfSoqLrwbs3Trp4yWNmz/plMVd08y5xvjgorhEzufZrYW5uXdOnORa63az
KY7Pda1x73btOnJ99UHURR73CwAAYLh0UCBPHYunBTLzkeAjOfSCnbde8RB6
X6A9WU5OmMsy5249q9c265ZtN384KdzNPe36dd2EKS0tvX8h6oSN3bpRb9dY
ZdeOGBW7azdOkgQAgHpOBwVyg+d50uj6P+ss6I6IAL9Y3UwZBFqSpqYe+cfS
7plnq5Q0q6YtfT/57HrggWJZ3dbl5Fd+ZmbUeh/vkW9Vr5HLe/fjam1hbi7D
eAAAAAzpoED+Oz+ENLoJo3wE3RFx5VLFpOW3b2ToYI9QV9lJSYEzflvavHWV
YuY+0OTM8pW5aWmsA1aSGhsbNO/36lMG2bd/7viSpZhSEgAA6iEdFEjzj/1I
nZvxzR5Bd0Tk5RXRAnn00E0d7BHUp6yOzVpVKWObP5yUcPIU63S1kRcWXtyw
kau41S/ZPuXoXJSXxzogAACA7uigQL7z6hodXxY9qNsyssd1qyJ0s0d4quz7
96tXxyWNm++aZp5y6RLrdOpSKBQ3g0M2jhtffRrJcDd3rmSyDggAAKALOiiQ
vVrrbg4fYvI7G8keF84O0s0eoRYlcnmY63Kb1s9UOdFx368zJAkJrNNpKDk6
evvHn1apkSv6vnw98ADraAAAAIITukCmPcylB5TPnb4r3I5Uzf1xH9njl//b
qps9wpPcDTuzetCQGqqjUaweeP/8BdH4D6sejv/fxPS4ONbRAAAABCR0gbxw
LokWyJQHOcLtSJWbw2myx+F9V+lmj1BdXnr6nu9/qnTAulGzvT9bGEd1VJVw
6vS6UW9XKcnBv/9RKJWyjgYAACAIoQvk7m2XSJfr0dxWoVAItyNV+3ddITvt
2sRGLsdMPgzE7tpdZVJurzdGGvdE3Jd8/Vx69FJ9yMt69Y0/dpx1LgAAAP4J
XSCX2ZwkXW7UAN1N631ZnEyHPe/cfqSz/cJ/5QOPOz6fWmW6m8g1a0tLS1lH
E1xRXt7RRYurTE+0f/pMDEUCAICREbpAzvpuLyly0yZtF24vVUhzZLRAhh6+
rbP9QvWBx93ffKdv8zoKLfPOnS0TJmMoEgAAjJjQBXLS6A2kyFnODRZuL9W9
/JwL2e/GNed1ud96S5aTs+urb1Rbk3O3nnEHDrLOxYxYtNm+/XOqP5DgBX+W
FBezzgUAAMADoQvkoK7KKRnXu+t0Ssb/jVxP9rtkwWFd7rd+un8hasWL/VXL
kr/59wUSCetcjOU8eLB14keqP5Z1b72Tff8+61wAAADaErRAMlwUZvrXe8h+
vzXz0+V+6xuFQnFm2Qqrpi0x8PgkYtFm1fW+HZ/revvIUdahAAAAtCJogbwW
+5AWyFtx6QLtpUZOS0LJft95dY0u91uv5KWnb/5wkuoI29aJH+VlYP3xqjLj
4z1fe0N1OqPQpTb14aoiAAAwVoIWyKB910mL69zIurBQLtBearRjcwzZ9Qut
7HW53/oj7dq15b370VK0tFmrsytX6WymJoNTLJPt+3WGatneMmFyQVYW61wA
AACaELRArlkeTlrckJ4rBNrFk0ScSaSDnw9TMIkKz+6EnlC9QmRlvwEPLopZ
hzIAMVu32bRqp/pze3j1KutQAAAAdSZogfxzxkFS4czGigTaxZNwpZEWSK5M
6njvxk28SaR60qPfZ19inkP1cY3Rrf9A+tOzbdP+6p4A1qEAAADqRtAC+fn4
LaTCzf8lUKBdPIlCoXi+hR3Zu//2yzreu7HifqrHFlupHoc9/Nc/OGxdV7Ls
7K2TPlb9MR5dtBinRAIAgAERtEAO6+NGKpy78xmBdlGLES+5k727OZzW/d6N
j7yoaPc331Us99ykxYV1PqxDGSquLh5fsnRxw4oOuXPq19xPmHUuAAAAtQhX
IIuLS7o0tiYVLtCfwYlen72vHP/8Y/oB3e/dyMhycjaOG19x4LVth1uHj7AO
ZfCu7dvP/STpT1U0/sPC3FzWoQAAAJ5OuAIZfzODnoUYG5MixC5qN+/n/WTv
Uz/cpvu9G5OcBw88Bg+lPcf1+d6psbGsQxmJtGvXlr3wIv3Zrh3+JuZBAgAA
/SdcgTwefIsWyNzcQiF2UbvltqfI3t96xUP3ezcaD69c4RojbThck8RaKvzi
+vnqQUPoT3jVy4Oy7t1jHQoAAKA2whXI9asjSX8b2MVViO0/FZ0KsldrTAWp
obthZ1RXUdk4brwsO5t1KCNUIJGsG/W26hhvxk2drtwEAABQJ8IVSMu5waS/
TRq9QYjtP9XZkwl0CDTzUT6TDAYt/thx1UkLd3/zHa7yEE5Rfr7qwtnO3Xqm
x8WxDgUAAFAz4QrkVxO3k/I267u9Qmz/qe7eyaQF8rI4mUkGw3UjKNi6RRva
Z478Y4npeoRWIpf7m39Pf+ZOXXpgmnEAANBPwhXI0QM9SXlztT4pxPafqri4
pHMj5WXgh/ZeZ5LBQF3bu091qvAwl2WsE9UXpaWle3+2oD95x07dcL0SAADo
IeEKZK/W9qS87dgcI8T21WHy/AqSYe3Kc6wyGJzLO3ZaNWmh7DANm55zxyVI
OqVQKPZPn0k7pMOzXVJimP0LAgAAqJFABfJRRh49fHz2ZALv21fT5Lc3kgyW
c4NZZTAsl3z9ljRqRtsjpgpnguuQB36bXdEhO3ZOjo5mHQoAAKCCQAUyJuoB
LZD37kp4376aZpoHkAzfmvmxymBAru3bT8celzRuHr1lK+tE9VrQvN/RIQEA
QD8JVCAP7LlGmluXxtZyeQnv21eT4+JQEmPsEC9WGQzF7SNHlzZrRdtj7M5d
rBPBf8EL/kSHBAAAPSRQgVyzPJw0t9deWMn7xtW3zeciifHiM44MY+i/u2Fn
Kmbsadg0evMW1olAKeSPv9AhAQBA3whUIBfODiLN7aN3N/G+cfWdOhZPj6Tn
ZMsYJtFn9y9E2bXrSFvKeS9v1omgEnRIAADQNwIVyK8n+7KdBJK4c+sRLZBX
LqUyTKK3Hl65wnWSihl7XJezTgQ1qNIh065jWioAAGBJoAI5xsSL1DanJaG8
b1x9hYXyTg2VBTJ4P9b1qEqSkODcrSdtJsetrFkngidS7ZDLe/fLffiQdSIA
AKi/BCqQL3V0JrVt6/qLvG+8Tgb3WE6SeLthKshKuAayou/LtJME//4H60Tw
FKrXZa8d/mZRPhboBAAANoQokAUFxfTA8fHgW/xuvK4mjd5Akiyah6kgK8iy
sz2HDKNtJODHX7BSof7jfkc7Pp9Kf2u+n3xWWlrKOhQAANRHQhRI1TMPr8Uy
PtBGp4I0/xhTQSoVFxT4vDOW9pDtZlNKS5hNtQR1UiyTrRv1Nv3dBc1fwDoR
AADUR0IUyDMnEmiBlGQyPspGp4IcY4KpIMuUyOXbJpvRBrJh7HtcJ2EdCuog
Lz19xYv96W8wYrUn60QAAFDvCFEgd229RDrbC63s+d2yBnw3ikmY3m0dWGfR
CwfnzKPdY83rIwqlUtaJoM4ybt6k184vadz8ZnAI60QAAFC/CFEgVzmFkc42
4iV3fresAdXh0MxH9f2iA7FoM22Pbv0H5qWns04EGrobdmZp89bkV2nXrmPa
tWusEwEAQD0iRIH8Z9YhUtg+MRXxu2UNJCZIaIG8dDGZdRyW7p+/QCuHQ8fO
mXfusE4EWonZuo1+HFjxYv/8R49YJwIAgPpCiAL5rZkfKWy/fRvA75Y1IJeX
dGlsTfIE+l9lHYcZaWqqS49e9KDn7aPHWCcCHhxZuKjidNYx40qKi1knAgCA
ekGIAjnudW9S2Owt9aKlDO21kuRZszycdRY25EVF6956hzaNM8tZLlAOPFIo
FNvNptDf7L5fprNOBAAA9YIQBXJAJxdS2DZ5XeB3y5qhU0EuWXCYdRY29lvM
pB1j9zffsY4DfCrKy/MweZ3+fsPd2J94DAAARo/3Alm2euDjcw6PHLzB45Y1
9uNnO0kei2n+rLMwcMF7vepl18UFBawTAc+y7t1z6tKDnp8Qf+w460QAAGDk
eC+QCfGZtEBeuZTK45Y1tnB2kP5c1KNj98LPLW3WilQLx07duKbBOhEI4t65
iIorpJ7tIrl7l3UiAAAwZrwXyLMn9W7anJX2p0met17xYJ1Fp6QpKc7depJS
YdWkRcKp06wTgYDEm0R0qNlzyDCslA0AAMLhvUDq1SziBJ1LvG97J9ZZdKfs
whmVNe/Oudev8lw/HZg1h/7Gd00zZx0HAACMFu8F0s1BOdw3sv9qHjerjWNB
N+mgqExWX+Y5Ub1wZs93P7KOA7pQUlysuso5LrcHAACB8F4g/5xxkFS1Ke9t
5nGz2oiNTqEF8t5dCes4unBhnQ9tEV7DRmK16/oj9+FD1+d744IaAAAQFO8F
ctqk7aSqzflhH4+b1cbDFCktkFERSazjCK5sxRmVC2eyk4z/IYMq1SWHHJ/r
mvPgAetEAABgbHgvkGNMvEhVc1oSyuNmtVFSUtq5kXIxmkN7r7OOI6z8zMxl
vfriwpl6TvWCGp93TUtLSlgnAgAAgUjEoYG+IpGvb2BkfHpNN5AmxqtKrnxU
Uh4vDi27u39oorQOe+W9QL7U0ZlUta3rL/K4WS0N6rqMpPLxiGSdRUAKhWLr
xI9oczi7chXrRMDMvl9n0GfCcStr1nEAAIB/ssRQ8waVmNmGVDlrLd7XovJN
TMUVRTHZu/z+JmbmJuXf8o9Tt0TyWyALCorpweLjwbf42qz2PhixnqSy/usI
6ywCOuXoTDuD76efs44DLBUXFKx+9TXlyZCNmiWcPMU6EQAA8EvqbVpW+8wt
3UXetqaPC+J8//iKm8jjqtZHlzD6zbDyO1mIYsv+IgkzK2+g4moV8syZMy++
+GKfyjp27Ni6des+1ezatUuDR3Ln1iNaIK9e1otZxImfPt9FUv0ydTfrLELh
GsKSxs1JYVjR92VZdjbrRMBY2rVrNq3akaeES/cX8jIyWCcCAAD+JIdwha9i
zFAaO1/ZEb3pBcPx/lx/tIgrH5SUl1O9e/moo3ns4yFLcflwpJm7uMp+CgsL
w8PDz1Y2e/bs995772w1UmldDoQ/pjqLuCRTj+YxXrLgMEk1YZQP6yyCkKam
Ond9nlQF6xZtUmJiWCcCvXBxw0Y6KL1lwmSFQsE6EQAA8EOeGGjpXunEvPQw
l0oFUh5fXilN3P1D4yXyKnePE5UfvTYT0cIni/UuL6AWcVVvWwN+D2Hv3qac
RbxnSzu+tsmLdasiSDCT51ewzsK/0pKSDWPfoz0har1xlmTQzK6vvqmYGXKZ
ET7/AQCAkMWJyscUfcmYYlzlsx8tvENVBgelyv7oXTHeKIv3JedRRqoxiMhv
gVzlFEZ62oiX3PnaJi8OBlwjwTo3spbLje2K1NPOrpgzHJ5ElpOzou/Lygvz
m7Z8EKVHV7cBAACP4kRljdFCeQ6kLEzkYmlpYWqiUiLN6dFtqYic8qh6wFoW
Sy7JcRc/fdJsfgvkwtlBpKeZjRXxtU1exEQ9oMfWkxKzWMfhU2psLJ31cfWg
IVgBGarjSiN9kqzsN6AwN5d1IgAA4JvygLVtcrXvSBIj6TU2Fr5x5Gve5QXS
nFxBQ8jErArkd5/sICVtpnkAX9vkRXpaLi2QEWGJrOPwpqS42PO1N+jgEk59
hCc5s3xlxTD19z+xjgMAADwjl8CIYp90+DndWzlVj3f5LZQF0jJEpW+yG4F8
/411pKTZLTzG1zb58nwLO5LNf/tl1ll4c2yxFW0FJ+0cWMcB/aVQKEQfTKDP
lst+O1gnAgAA3kgi3asOJ1YnjSwfhpwfX3aNjJQUSFOVQ9hy5XXZDbyf2EIr
8FsgB3XT3/m6R/RzJ9ncHMOefmtDcP9CFJ23Z+3wN0vkalw0BfVY7sOHTp27
kyeMXbuOkoQE1okAAIAH8sRAk7IJHkOf1gPKRx1N3MuXq5H6mlc9B1IqJldh
1zAVZHU8FkjVFQMPBlzjZZs8+nTcZpLt798Osc7Cg+KCglUDXqXz9qTHxbFO
BAbgZnDI4obKQUjvN0fjQwcAgMGTRJYNJc4PVFmARiaRymq8qbtpxbw9iYHz
yWXYtC1KyTQ+KtNI1oLHAvkwVUrPM7xwLomXbfJopnkAyfbdJ8Zw8C5o/gJ6
ODLcTb+ueQd9pvrMObbYinUcAADQAmmPpu7JMrlcxpFK0ssvxbaNLJuVRxwm
VlkdOz7QstJJklIxOYgd9njWSH+LsiPYlqHVr8KpAY8FMjYmhRbIxAR12qtO
2f5zlGQbP3wd6yzaSjh5io4jbRgzDrNDg/rkhYUVF141aZEsrrriAAAAGITq
C2FTojipck7IBg3MLL3DIsNEtmblqxZWes1PDLEsvzDbn+uU8SEuZEBSzQLH
Y4E8HnKLFsiCgmJetsmj9asjSbbBPZazzqKVQql0ee9+pADYtu0guXuXdSIw
MOlxcdYt2pCnkOeQYTiQDQBgiAKVKxeaVK2PJi5lY4jyxIrlscu+aOEfWcPQ
oth3Pr2J6XxRYo2HvmvCY4H0E0WThtannSMvG+TXgT3KucS7NLYuKSllHUdz
+36ZXrHojM8G1nHAIIW5Lsf1+wAAxk4uSU5OTExOl9R2VYxMkp6YmJguUbs7
luOxQNJlaEb2X83LBvkVFZFEB0hTk3NYx9HQjaBg+r6/deJHrOOAoSotKfF6
YyR5Ii1t3jrtmt5d9QYAAPqMxwK5aF4wqWcfj9nEywb59SApmxbImKgHrONo
Ij8z07lbT/Km79CxszQlhXUiMGCpsbFWTVvSK7JLSw14WB4AAHSMxwL585e7
ST37ZepuXjbIr+Likk4NlQUyeL9BTnqza5o5JoIGHh23ssa1/AAAoAEeC+RH
724i9WzRvGBeNsi7gV1cScKNa86zzlJnV3b70/f6HV/wNvc71GfyoqLVg4Y8
viK75YOoi6wTAQCAYeCxQI7sv5rUs1VOerrUi+nQtSShw7/HWWepm/zMTMfn
upI3eqcuPfIfPWKdCIzE/fMXFjdsRp5aLt1fYB0HAAAMA48FsndbB1LPdmyO
4WWDvPt6si9JOOeHfayz1M3eny3o8GPcgYOs44BR2TD2PfrsurhRH09gBgAA
fcNXgczNLaSXqJw4clv7DQphgcUBkvDL/21lnaUOEs+G02nDd079mnUcMDay
nByHjl3IE8y+/XPS1FTWiQAAQN/xVSDv3HpEC+T1Kw+136AQXK1PkoTvDl7D
Oou6SuRyj8FDyZu7XbuOuPIahHAn9AQdhPSb8gXrOAAAoO/4KpDhp+7SApn5
KF/7DQphy7ookrD/s86ss6hLdcLnCA+D6b1gcFRPk7gasJd1HAAA0Gt8Fci9
O2JJN+vR3Fb7rQnkyMEbypbbcGlRkQEs35Z1755N62fIe7rXGyMxUx8IpyAr
i84yyv0H91fWiQAAQH/xVSC9VoSTbja010rttyaQSxeT6TBpUqIBvD9u//hT
8oa+pFGzBxfFT78DgBauBuylg5B7f7ZgHQcAAPQXXwVy6Z9HSDGbMMpH+60J
5GGKlBbIqIgk1nGe4vr+QPpufnDOPNZxoF7wm/IFfdbdCT3BOg4AAOgpvgrk
9K/3kGL242c7td+aQEpKSrs0tiY5Dwbo9eK/hbm5rj370OOJshxDXbwbDIs0
JcW+/XPkiefWf6C8sJB1IgAA0Ed8FchPTEWkmC2cHaT91oQzqNsyknODp14v
RhP8+x90ICh2lz4uDQnG6uKGjfS5d8LWnnUcAADQR3wVyDdfVi5D4+aop8vQ
EO8N8yY57Rfp72I0KTExSxo3J+/gmz+cxDoO1C8KhWL96HfJ08+6RZvMO3dY
JwIAAL3DV4Gky9D4iaK135pw9H8xmtLS0rUjRinfvlu2lSQksE4E9U5qbKxV
kxbkSbhlwmTWcQAAQO/wUiANYhka4vdfA0nOqR9uY52lZpGeXvQA4mknF9Zx
oJ4K+eOvimkh9wSwjgMAAPqFlwJ5+0YGLZBxV9N4CSYQx8WhJKfp0LWss9RA
mpJi164jeddePWhISXEx60RQT5VdxvV8b/JU5P6D+yvrRAAAoEd4KZBnTiTQ
ApmdVcBLMIH4eESSnIN7LGedpQY7vvhKOezTsGni2XDWcaBeU50WMnjBn6zj
AACAHuGlQO7edom0sp4t7XhJJZz9u66QqN2a2rDOUtXN4BD6fr3v1xms4wD8
t2XCZPKEtGrSIvXyZdZxAABAX/BSIFe7nCGtbEQ/d15SCUd1ze4siR4NlsoL
C1e82J+8WTt17l4gkbBOBPBf5p071i3akKelz7umrOMAAIC+4KVAWs4NJpXs
o3c38ZJKODevp9MCeSsunXWcCiftHOjwY8y27azjACidsLWnz8wru/1ZxwEA
AL3AS4H86fNdpJJZTNP39xdJZj4tkOdO32UdRyk7KcmmVTvlOM87Y1nHAahQ
LJMt792PPDmX9epbXKBH4/YAAMAKLwVywigfUsms/jjMSyrhKBSKbk1tSNrA
3VdZx1Ha+eU08ga9pHHzlEuXWMcBqOTqngCsTQMAAKp4KZBDe60klWztynO8
pBLUq92Xk7Q+HpGss5RJOHWavjsHzpzFOg5ADTaMfY88RW1atcu+f591HAAA
YEz7AqlQKLo3syWVbN/OK3wFE47p0LUkrdOSUNZZ/istKfEYPJS8NTs82yU/
M5N1IqjXSktLi2UyWU5OXkZGTnJydlJS/qNH8sLC1MuX6fKau7/+lnVMAABg
TPsCmZGeR88qjDiTyFcw4Xz5v60k7QKLA6yz/BfhsYYOP55fu451HDBCJXI5
VwWTxeIbQcEXN2465eAUNH9BwI+/+H76+ab3PvAaNnJlvwFOnbtbt2xLK2L1
P1ZNWy5t1pr+de2IUTu++GrfL9ND/vjrhK39OXeP6C1bbx0+wvXM3LQ0roWy
ftAAACAs7QvklUuptEDevWMAA2izvttL0n5r5sc2SV5Ghn2HTuQd2fO1N/C2
C1riytu98HNclzu22GrXV994vTHSsVO3xQ1r7oTC/eGKqHO3nmuGDt868aOD
c+Zx9ZLrrhk3b2JlJQAAo6F9gQw9fJsWyPz8Ir6CCcfm76Mk7Ydv+rBNsn/6
TPqem3jmLNswYHBK5PLU2FjxJtGBWXO83xxt27aDjouiBsVyeZ+XRB9MCP79
Dy72g6iLRfn5rH+KAACgCe0L5M4tMaSP9W7jwFcqQXmtCCeBX+/txjBGelwc
TiqDOlEoFGnXr4tFm0ljtG7Ztq4Vzr79c6sGvLphzLjtZlP2fPfjwTnzji22
OrNsRdR6n8s7dl7bu+/GoaDbR48lnDp971zEg4vilJiYxLPht0IOX/Hfw+03
3M3dsVN3sinrlu22fDjJ552xHiavL+vV17ZNe00qZaNmK/sN8P3ks+NW1jeC
gguyslj/jAEAQC3aF0gDWoaG2ON7mQR+vgXLhRe5d/DHb8RtcVkrPElOcvK1
ffuPLFy0cdx4u3Yd1Wll3DNq9auvca0s5M+/z69dd31/YFLk+azERHlhofZ5
VBfcDF1aaT3Qovz8zDt3uMJ5dU9ApKcXV00Dfvh5/eh3nbs+r26lbNjUY/DQ
wJmzLvn6ZSclaZ8WAAAEon2BXPx7COljk9/eyFcqQYWF3qHH3HOyZUwy3As/
R980uW7AJAPoLa40xmzbHvDjL8t69X1q6VravPXa4W8GzvjtwjqfhFOncx48
UCgUgsYTfTCB7NqmVTsuqjp3KczNTYmJueK/57STy57vf/IaNlKd4dNlL7zo
b/59lM+GjFu3BH1EAABQV9oXSItp/qSM/fT5Lr5SCerGtTRaIG/fyGCSYf3o
d8lbpEPHzrLsbCYZQK/kZ2Ze3RNw4LfZqwa8+pTG2KyV1xsjucbINavk6Gjd
X5mSGhtLz74I+OFnzTZSWlqacfPm1YC9oda2Oz6furzPS7U/apfuL+yaZn7B
e336jRv8PhwAANCA9gXy03GbSRlbODuIr1SCynzEeDXDa/v207fFsytYnocJ
zHFl7LSTy/q3x9Qyhc7ihk3d+g/0N/8+YrVnUuR5Xo5Ea2nfrzPoSYxcieVl
mznJybG7dh+cM8/ztTe4zdY+Mhk4c9aNQ0FYVxEAgBXtC+TogZ6kjK2wO8VX
KkGprma4f5euZz4vLSmhQ0zLevXVhzIAOsbVHq78cBWIK0K1XF3i9cbIw38v
vBVyuEAiYR25KmlqKr1qZqPp+7xvX5aTc+vwkaOLFq8f/e7SZq1qOdtz68SP
znt5Z927x3sGAACohfYF8qWOzqSMbfO5yFcqoZk8v4JkXu8eoeNdR633oW9/
Mdu263jvwFBhbu7lHTt3fD7VplW7JzWi1YOGHJwz79q+/fp/PfJJe0ca+3qg
gHPyc337TuiJ41bWPu+aLm3e+kk/Oq9hI8+ucFPznEwAANCSlgWyqEhODwcf
OWgw5ya9/8Y6ktne8pgu91uUn+/crSd5v/McMkzoix1AH3BVMGbrtu0ff2rd
ok2Nzce2TXvfTz+/uGGjNCWFddg64Hqda88+5CGsenlQiVyui53KZPHHjgfN
X+D20itPGrndOG4898PU/wYOAGDQtCyQD5KyaYGMiXrAYzBBTZu0nWSe+9N+
Xe5XddDm1uEjutw16Ji8sDB2566tEz+yatqyxqqzst+AoHm/3z56TF5kANPv
1yhm23b6cCI9vXS894ybN8+uXMXVxRp/wkubt+Zq+dWAvYb74wUA0GdaFsjo
Cw9ogeTKJI/BBDXv5/0k81cTdXcQOS89nc7jt+m9D3S2X9Cx++cvBM6cZd/+
uRp745qhw7nPEelxcaxj8kChUHi9MZI8Lueuz7NaVkaWk3PJ12/rpI9rbJKO
z3U9NHc+X1f6AAAAoWWBPHroJi2QRUW6OIbFC4d/j5PMpkPX6mynB+fMoxfV
JovFOtsv6IY0NTXMdbn7QJMaL6P2HvkW993MO3dYx+RZ/PFQ+jBPOTqzDZOX
kXHey3v922NqXP7bc8iwcDd37nMc25AAAMZBywLpJ4omTezFZxx5TCW0DZ7n
SexB3ZbpZo+Z8fF0eAQLFxqZpIjInVO/tmrSosbScnblKuNeVGXTex+QB2vf
/jk9OfMwKzHxtJNLjWWe+2fo99mXd06cZJ0RAMCwaVkgPVzPGtY6hsTBgGsk
dpfG1qWlpTrY484vpylPzWrWSnL3rg72CEIrKS6+5Ou3dsSoJx02TYmJYZ1R
F+6fv0AfuL4tq6Q8naBDp+q/I/dXBkd4rJHl5LDOCABgkLQskNZ/HSFNbMIo
Hx5TCe3CuSR65P1hqlTo3am+wwb//ofQuwOh5aWnn7RzoBfUV4xuNWmx7aNP
rgbs1f3qMGz5fvo5+QnYtGonTU1lHacqckHT5g8nVZ+f3LZN+8AZvz28ouv5
YAEADJ2WBXLOD/tIDTP/2I/HVEJLTJDQAhkbI/jcKRvGjKPH+PIzM4XeHQgn
49at/dNnVp+Qx7FTt2OLrertJIRp167Rbnbgt9ms4zxRzoMHJ2ztXXr0qj4g
uXHc+NtHdTqpFwCAQdOyQNL5cOb9rNP5cLQkkxXTAnk8+Jag+4o7eIi+SZ12
dhV0XyCcpMjzflO+qD6E5TlkmHiTqFgmYx2QsT3f/0RPMpQkJLCOU5sSufxq
wF6uMVavkV7DRl7x36Ob01oAAAyalgXygxHrSQ2zW2hgH977tnciyX03CnhB
dGlJCT2T37VnH9QMg6NQKOIOHPR5Z2yVpsE1Sd9PP084dZp1QH0huXuXrjno
b/496zhqSbt+/eCceXRyLfrHrf/Aixs2YgJJAIBaaFkgh/VxIzXMa0U4j6l0
YNQAD5J8pb2AHYB7G6LvStGbtwi3I+AdV/5jtm13f2VwlXZh3bLtgd9mG9+E
PNqjE1Vx7frh1aus46irMDc33M3d9fneVX7RLj16nV25itXklgAAek7LAtmr
tT2pYbu3XeIxlQ58YioiyRfODhJoFyXFxct69SVvRh4mr+O4mKGQFxVFrfdZ
8WL/6tdWhy61ycvIYB1QT+U+fGjT+hnys/L77EvWceqG+9cq3iRaNeDVKr90
p87dzyxbUZSXxzogAIB+0aZAFhRUnEkYevg2v8GENv3rPST5j5/tFGgX59eu
o29DcQcPCbQX4FFxQcE5d4/qg1FcmYz09OK+yzqgvjtq+e9iOlu+AS7+wn3K
uxqwd+3wN6tfJHXa2bUwN5d1QAAAfaFNgbx/L4sWyMtiA7v+dMmCwyT5xLc2
CLF9eWEh7SHc+5EQuwAeFeXncw3BqXP3Ks3BY/DQyzt2lpaUsA5oGPIzM+kp
hdsmm7GOo7n446F08gT6x+HZLqccnAqlgk/8BQCg/7QpkDFRBrkQNuG5TDkF
+hsvrhJi+xGrPen7zq2Qw0LsAnhRWlp6ceOm6lO7cLX/euABhULBOqCBCV1q
Q3+GSZHnWcfRyt3TYXSdHdUzGcLd3HGJDQDUc9oUyGNBFQthy2QGNnPy7m2X
SPJere1533ixTEZnmV731ju8bx/4cuNQ0OpXX6vSEHzeNcWUgBqT5eTQlV9E
4z9kHYcHiWfDRR9MqPIkWd7npUu+fvh8AQD1ljYFki6E3aedIS2ETRwPuSVc
+z27chV9o4k/HsrvxoEXD6Iubhj7XvXZpBPPnGUdzeCdcnSmP9K7YWdYx+FH
UkTk5g8nVXnCrBk6HJ81AKB+0qZArnY5Y4gLYROXLiYLdPy9KD/fqUsPOpbF
45aBF5K7d3d99c3ihlXPdbwZHMI6mpEoystz7NSN/GA3jBnHOg6fuD7s/ebo
KjVy0/v/M8QrhgAAtKFNgbT6Q9jrUASVlFhxBVBsNJ+rGYa5LqfvLJhoWq8U
SqVHFi5a2rx1len+xJtEmGSJX2eWrzTiQfirAXtXvTxI9Vm0pFGzvT9b5D58
yDoaAICOaFMgf/s2gBSw7z7ZwW8qHcjPL6IF8sQR3uYgKszNdXyuKz0eytdm
QUulJSUX1vlUucjarl3HU47OmJxHCNxPteI04FFvs47DvxK5/IL3evoY6TOK
+/yI62sAoD7QpkB++b+tpID9Mf0Av6l0o2dLO5J/j+9lvrZ5ysGJvpsknjWw
1XmM1e2jxzwGD1V9o7dq0uLgnHmYElxQER5rjH4igqL8/JN2DrZt2qs+u1b2
G3A90CBfEgEA1KdNgTQdupYUMKclBnmI6rUXVpL8690jeNlgoVTq0LEzeRPZ
/L+JvGwTtPHgQtSynn2qnLG2bbJZ+o0brKMZv7KpUB//8L1HvsU6joCkKSl7
vv+pylm1ovEfpl27xjoaAIBQtCmQr3ZfTgqYj0ckv6l0Y9zr3iS/42J+CvBJ
OwejmQHP0JXI5WEuy5Y0blHpShmT1+OPHWcdrR457+Vt9IOQ1P0LUetGvV1p
oLtpyyMLF+EcCQAwStoUyG5NbUgB27/rCr+pdOOLD5SH4P+ccVD7ralOf7dl
wmTtNwgaexB10fO1N1Tfym3bdIha74MrZXRMXlRUTwYhCYVCcWm7b5WlMJf3
ecnoyzMA1EMaF8gsSQG9COXsyQTeg+nAjG/4XA77hI0dfcu4f/6C9hsEDRTl
5QX//seSxs0r3sEbNtsw9r0CiYR1tHqqXg1CEkX5+ceXLK1ysf/OqV9LU1NZ
RwMA4I3GBfL2jQxaIG9cS+M9mA4smhdM8n88ZpOWm5JlZ9u3f468U2yd9DEv
8aCubgaHLOvVt9I8z6+PSBaLWeeq1+rbICSVcevWxnHjK12j/cyzXJ3GMDgA
GAeNC2REWCItkJmP8nkPpgMr7U+T/KMHemq5KdX1fx9EXeQlHqgvLyNj99ff
qr5Z27Rqd2b5ytKSEtbRoD4OQlIxW7fROdXppEbpcXGscwEAaEvjAhnof5W0
r65NbAx0QdjN3lHkIbzS2VWb7RRkZdk986zyCt+PPuErHqjpkq8fnXuTXgIv
STDI0yqMUr0dhCTyMzP3/myheo320uatTzu74tMNAPBEIg4N9BWJfH0DI+PT
q39bLokP9S/7fqg4saa7y+PFoWXf9g9NlNZhrxoXyE1eF0j7GtR1mQZ31weH
9l4nD6FLY2ttjisdX7KUvjXggKkuZd+/v3XSx6rV0bFTt0vbfVnngqrq8yAk
cTfsjPsrg1Wfq2uHv/nw6lXWuQDAsMkSQ80bVGJmGyJTuUF6pHf5l03MzUy4
/zO1DKxcEpO9y+9vYmZe9u0Gpv5xNZTI8PDwV199dWBlXbp0adeu3cBqAgIC
as+8zOYkaV/vDl6j/U+AiYgzFUfhH2XkabaRAonErl1H8o6w3WwKvwnhSRQK
BddJbNt2UH1H3v3Nd5gbXD/V80FIgvshcB82rZq0UB2KPOXgVCKXs44GAAZK
6m1aVvvMLd1F3ramjzvkfP945ffTQ8u/aBFb3goj3c3KGqZ3xUhXWPmdLESx
ZX+RhJmVN1BxtQpZUFBw/PjxY5VNnz597Nixx6rJysqqPfQ/sw6R6jXlvc18
/SB0TPU6oJvXaxj1VcdxK+vHV/s2TYmJ4Tch1CgzPt7nnbGq1ZErJzeCglnn
gtqoDkLePnKUdRxmkqOjPYcMU332eg0bmRobyzoXABig5BCu8FWMGUpj55MG
aepdPvOIPMSybFjR3PvxK4xUXD7caBYpVd69fNTRPPbxkKW4fDjSzF2tY6ka
H8L++cvdpHr9+pW/BnfXB6ozEYWfuqvBFgqlUjr3o++nn/MdEGpwceOmSivH
NWx64LfZ3C+CdS54irJByMcTJPq8a8o6DkslxcWh1rZWTVtWDEU2a3XK0Rln
RQJAncgTAy3dK63kkh7mUlEgZbHk6LZ3LH2LlIrKBxktfMsu5YsTkTopot+W
xZLj3RZxahwY0bhAfmIqItXLck6QBnfXBwqFomsT5Vzogf6anIx02tm14uLr
izj7UVj5jx75TflCdehm1cuD7oadYZ0L1HXO3YP+7rBSfMqlS2uGDld9Pnu/
OTrj5k3WuQDAgMniROVjir6ysvFIUYOqh6Rl/hblBbOsdkqV/VHliLYs3reB
6hBlrTQukG8P8iTVa4XdKQ3uricGdV1GHsUmrzpP/V1cUODUpQe97FeIeEDd
PnrMpfsLqgOPIX/+XSyTPf2eoDfK/sl07r4YqzU9ViKXn7RzUB2KtGnVLmK1
p4HOawEAzMWJygqiRfk5kFLlcGKlNhj7uDVKH49GVjpg/XjQ0l389NU3NC6Q
r3R2JdVrs3eUBnfXE2NMvMijcLU+Wdf7RnisoS/7GAcTjrywMGj+AtVZUFyf
730n9ATrXKCJ004uFVMWREezjqMXUi5d8jB5XXUocuO48Vn37rHOBQCGRh5f
fg6kbXL53yRi9waVT3HkxJKLrk25AinxLi+Q5iKVc7BlYqELZGlpaZfG1qR6
Hdp7va531x9T3ttMHsU/sw7V6Y4lxcX0qlKfd8YKFA8eXrniMXhopSXhvpyG
dQkNV9mS8Y/XbPL77EvWcfSFvKjoyMJFqktw2rXrKBYZ6vWJAMAEuQRG9PiM
R6m4fATSxFZ18sfqBdIyJLni28KPQD7KyKOXn0ScqXFeSsPw61f+5FH8/OXu
Ot3x4sZNFfPaHT4iULx67vzaddYt2qi+pUZv2co6FGjr2GIr8gtd0qhZ2nUD
/vjJu6SISLeXXqk0M9XX3xbm5rLOBQAGQBLpXmU4saZD2PIQS9PHF85ISYE0
VTmELVdel6163c0TaVYgb1xLowUy/qYBz7xnOVe5HLbZWJH69yotLaWv817D
RgqWrv4qkEiqXC+zfvS7WFzGOORlZNi0fob8Wvd89yPrOPqlKD//4Oy5qids
rHp5ECb5AYDayRMDueJn6hKqevG08oKaSgVSWRrLz3uU+ppXPQdSOWhZ01SQ
1WlWIMNP3aUFMktSUNe7648VdqfIo3h7UB2Ww768Yyd9eb8asFe4ePVT4pmz
y154kf6ElzRufsLGDjOcGJPg3/8gv1yrJi0kd++yjqN34o+Hql4yZt2y7cUN
G1mHAgB9JYksa4XzA1VOdZRJpNzfyCmRDbwr6qCyQJIj1ImB8x9fUPP422TQ
UjmN5FNoViADdysXwu7W1FAXwiY0WA6be7z0rDz3gSYG/fD1TWlp6Qlbe9Uz
wVx79uH6JOtcwLOc5OSlzVuTX3HgjN9Yx9FHuWlpovEfqg7C+3/7Q1Gehgtm
AYDRIu3R1D1ZJpfLOFJJevml2LZl80OKy/uiqW0Yua083p+cFak861EqJgex
w5R9Ue5vUXYE2zI0ucZdVaFZgTSChbCJgwHX6rocdtzBQ/QlPWbbdqET1h9c
qdgwZpzqO6bvp5/jehljtX/6TLqcnzQ1lXUcfVT985T7K4OxfDYAUNUXwqZE
ZHkaeaJleWX05f4qi3dRGX4kEkPKv2/hz906PsSFDEiq+b6rWYHU7MivHooI
q1gOO/NRvjp38XnXlLyYr3ixP46r8uXOiZN0hsCyY3Yt2pz38mYdCgSUeecO
rUZHFi5iHUd/cf80nLs+rzpRJD63AgARqFy50KRqfTRxqRhDlIjnV3zf1Dus
6oXPYt/5Fd+eL0pUe35lzQrkv/NDSOn6eMymut5Xr9yKS6cFkvvvp97+/oUo
+koe6emlg4T1QZjLskrDLANNHl65wjoUCG7XNHPl9fXPPCvLyWEdR3/lPny4
cdx41cH5A7/NlhcVsc4FAIZClp6YmJic/qRuKJOUfT9dUre1OTQrkL99G0BK
1w9Tdtb1vnol81F+xXxE1Wp5dTu/nEZewB06di7KV2vEEmrB1QbfTz5TfWfc
+9OvxQUGfFkWqC8lJob+3rkPEazj6LXS0tLQpTZLGjWrWPdw5FvZSUmscwFA
/aVZgZw6YRspXb//GihEKp2p04zokrt36UDZscVWukloxB5euaI6693S5q2j
fDawDgU6tfl/E8lv37lbTwypPdWtw0ccnu1C/8k4Ptc1/thx1qEAoJ7SrEB+
MGI9KV12C48JkUqXBnRyIY9ly7qnrMl4aO58WnVyHz7UTTxjdWm7r02rdvSt
cHnvfg8uip9+NzAud06cpM8BfHxQR1ZiotcbIysmuWrU7JSDE+aCAADd06xA
Du+7ipQuz2UGP8XK6IGe5LGstD9dy80KJBLbNu3Ji/a+X6brLJ7xKS0poVWc
/NkyYXJ+ZibrXMDG2uFvkqeBW/+Bas6EUM/JCwv3W8xU/Re07aNPcBIpAOiY
ZgWyb3snUrr8RNFCpNKlj97dRB7Lv/NDarnZKUdn5ct1w6ZYf01jXA/f9P7/
VMdPQq1tMX5Sn13dE4Bp+TUgFm22btmW/uhWDxqCKdkBQJc0KJAlJaWdGiov
PDl84IZAwXTmx892kscy45s9T7qNvKjIuVtP5Yf9yWa6jGdMuOK9st8A+pbn
0LHzrZDDrEMBY2ULg/YfSJ4Sa0eMYh3HkKTExKx4sX/FKZGdut0LP8c6FADU
FxoUyPS0XHrl8vnwewIF05k/Zxwkj+WLD7Y+6TbiTSL6Kp1wqrYj3fAkN4KC
7dp1VJ2rJzM+nnUo0AtRPhsq/n2dPMU6jiEpyMpSHdJf2rw1ZokEAN3QoEDe
vF4xd+LtGxkCBdMZx8Wh5LGMe73mmasVCsXqQUPI67PXGyN1HM84lM30qDID
ybbJZoVSNVZqh/pBXlhIR/g3fziJdRwDUyKXB874TfWUyGOLrXBaCAAITYMC
GXGmYvWWRxkGvzbrevcI8liG9FxR4w1uhRymr8yxO3fpOJ6hK5bJ/M2/V313
O7JwEa6VgCq4jxj0GZIaG8s6juEJX7VadTb+HV98hflUAUBQGhTI4P1xygLZ
cKkRNIE9vpfJw+nZ0q7GG9AjRMt69cXahXWSl56+btTbqgsUXvL1Yx0K9JEs
J4ee4bDn+59YxzFIN4KCbdt2oP/c1g5/U5qSwjoUABgtDQrk9g1i0rhe6ugs
UCpdOnk0ng6o5uVVnco49fJl+oJ8duUqJgkNVHpcnOoZ/i7dX7h/4SkzbUJ9
FvLHX8oT+Zq1QvPRTGpsLPc5l/6jc32+d3K0wU+UAQD6SYMCucopjNStN19e
LVAqXbpyKZUWyMQESZXv7vn+J/JSbNeuI07bU9+dEyftO3TCYAioLzspyapJ
C3qeA+s4hio3Lc37zdH0n55Nq3bX9u5jHQoAjJAGBXLpn0dI3Zo02hhWjniY
IqUF8mLkfdVvcZ1nabNW5HU45I+/WCU0ONGbt1g1bUnfwnw//RzrhoM6dn/9
LXnOcJ8+ivIM/vxqVoplMvqTJFPXnnI0hqNFAKBXNCiQs7/fS+rWt2bGcD5b
cXHJk6a1PLpoMXkFtmrSIuuewU9YpAMKheLYYivVS2aCF/xpBCfKgm4ki8X0
mROx2pN1HMN20s6Bq4705+lv/r28sJB1KAAwHhoUyGmTtpO6Ne/n/QKl0rF+
HZQL6/hurFiOuSg/36FjZ/Lau+urbxjGMxTc29OuaeYVq8w0bn5+7TrWocDA
bDR9nzx/lvd5CdesaemK/x7VFefXvfVObloa61AAYCQ0KJD/G7me1C3bf44K
lErH3nx5NXlEq5zC6Bcj16ylL7wPoi4yjGcQZNnZG8aMoz8x27YdsMoMaODG
oSD6LOL6D+s4Bu/BRbFLj170R7qsV1+sxAoAvNCgQA7vu4rULc9lZwVKpWOT
39lIHtHi35XLYZeWltJF93zeNWUbT/9JU1I8TF6vuPazZ5/Uy5dZhwKDpFAo
3F8ZTJ5I3iPfYh3HGOQkJ3u9MVJ1CdF75yJYhwIAg6dBgXzxGUdSt/xERjJB
xA9TlMthzzQPIF+5vj+Qvt5y/802np7LuHlzee9+9Mfl+dobuOAatKG6smHi
2XDWcYxBcUHBjs+nql6afeNQEOtQAGDY6logyy45eXzN8pGDN55+B0NQfTls
n3fGkldat5dewTUgtbh/IcqxUzf6xrTR9H1ZTg7rUGDYimUyp87dlZfwf/IZ
6zhGQqFQBM1fQP+pWjVpEb15C+tQAGDA6logH6Y+cdIbw+VsdYI8ItPX1nJ/
fRB1kb7MnveqeYFs4Nw+ctS2TXvV1dNwmSfw4oStvfJSrEbNJHfvso5jPE47
u6pOkhDmsox1IgAwVHUtkNevPKQFMiE+U7hguuTjEUke0eAey7m/0rWbHTp2
xgSGT3LJ1091sscDs+ZgqBb4kpeRsbR5a/LUOvz3QtZxjIpYtJlO2M79CZq/
QKFQsA4FAIanrgXyzIkEWiBzsmXCBdOl/buukEfUvZmtNDWVTh6O5TCeJNzN
XXWKuRO29qwTgbGhi0A5PNulWGYkLzV64sahINXpfXZ//W1JcTHrUABgYOpa
IAN3XyVdq1tTG+FS6djZkxWtOPDvpfQcoeykJNbR9BGdX51M9hi13od1IjBC
9y9E0aeZWLSZdRxjc+9cBJ3nlvuzdeJHxQUFrEMBgCGpa4Hc5HWBFK1BXY3n
5Jm4q2m0QP7dUTl7z84vp7HOpXdKS0v3/TqDvulYt2hzbZ+RTCYPemjtiFHk
meY1bCTrLEYo7fp115596D/nDWPGFUqlrEMBgMGoa4FcZnOSFK13B68RLpWO
pafl0gL5S4Pe5OX0Xvg51rn0i7yw0O+zL+nbjd0zz949Hfb0uwFoKnrLVvp8
S4o8zzqOEcq+f3/VgFfpD9nrjZH5jx6xDgUAhqGuBXLh7CBStD4dZzwHlYqK
5LRAftdgAHkhZR1KvxRKpRvHjadvNE5deqTExLAOBUaO+8xCJ4nyN/+edRzj
lJeevmbocPpPe/WgIZjHFQDUUdcC+cvU3cqRuqm7hUule71a25PHNbXBa9yr
6KXtvqwT6RHuLcZrWMVKFite7J8ZH886FNQLRy3/Jc+6pc1bc89D1nGMkyw7
e/3od1X/gUsSEliHAgB9V9cC+em4zaRoLZxtVAsZDO6xnDyuTxq86dytJ65J
pLISE936D6RvLh4mr0tTU1mHgvoi6969JY2bk+feKQcn1nGMVlF+vuiDCfSf
uUuPXlgyGwBqV9cC+e7gNaRoLbM5KVgoBt7q70Ye14QGYzEpDZUZH7/shRfp
28r6t8cUZGWxDgX1i+8nn9E11ktLSljHMVryoiK/KV/Qf+yOz3VNjjaSxWoB
QAh1LZCDui4jRWuT1wXhUune6B6LyeN6v/FEHCkjMm7edOnRi76hbJtshok+
QPfijx2nT8Jre/exjmPMuH5Op9/k/th36HT/QhTrUACgp+pUIBUKRdcmNsr5
Ev2vChpMl4ry8kY0+Y48LrOX/mQdRy+kXbvm3PX5SlMNy+WsQ0E9Ra8U3mj6
PussRo57kT84e67qZAv3zkWwDgUA+qhOBTJLUkCvVg4/dVfIXDp1YZ3PWw2m
kMf11bh1rOOwlxob69S5O30T2fP9T1imEBiK8FhDn40Pr1xhHcf4Hf7rH/oD
t23b4W7YGdaJAEDv1KlAxt/MoAXyxrU0QYPpkofJ66YNJiovojEVsY7DWHJ0
tMOzXejbx75fpqM9AluFUqldu47kCbnfYibrOPXCsX+X0BcBm9bP3DlxknUi
ANAvdSqQkWfv0QKZkZ4naDCdSTwbzr1C/q/BOPK4TIeuZZ2IpfsXouw7dKJv
HIEzZykUCtahAP4Lmve7ssy0alcgkbCOUy+csLGrWHaqZdvbR4+xTgQAeqRO
BfLQ3uukZXVuZG00o1K7v/6We3n8uMFb5KG93tuNdSJmkiIi7Z55lr5lcG/Z
rBMBKGXcurW4ofKZGea6nHWc+uK0kwt9QVjavPWNoGDWiQBAX9SpQG5ZF0Va
1oBOLoKm0pnctLSlzVpxr41fNHidPLS+7evpXHNJkefpUULuz+G//mGdCKCS
rRM/Ik/OZb36Yj4fnTm7wq2iQzZrFXfwEOtEAKAX6lQgV9qfJi1r9EBPQVPp
zCkHJ/LCaN7oVeXR+YZLjWZwVX33L0Spjj0e+3cJ60QAVd06fATz+TARsdqT
Dv8ubd6a+0WwTgQA7NWpQC6aF0xa1sdjNgmaSjdKS0roLNk2b39LT+/MktSv
2Q4fXBTbt3+OvjUfX7KUdSKAGigUilUvDyLP0g1j32Mdp345v3Yd7ZDWLdrE
Hw9lnQgAGKtTgZzxzR5SsX78bKegqXTjeuCBiiO26/bTApkQn8k6mu4kR0er
XjVzdNFi1okAnijS04s+V1NjY1nHqV8i16ytuC67VbuEU6dZJwIAlupUIKd+
uI1UrAUWBwRNpRt07Ve3/gNTk3NogbwYeZ91NB1JuXTJoWNn+qZw5B9L1okA
alOYm0vPtdj3y3TWceqdcDf3ivkh27RPPBvOOhEAMFOnAjl++DpSsewtDX4+
h0e3b9MjMtyrYnFxCS2QRw7eYJ1OF1IvX1ad7zHkz79ZJwJ4uqD5C+jEMvmZ
9ehggZ4Ic11esU5Nu45JkedZJwIANupUIIf3XUUq1prlBv/BM3jBnxXTymVl
cV/p296JPDo/UTTrdIJ7eOWK43Nd6RsB99NgnQhALZnx8fSj32lnV9Zx6qOT
9o4V62W3f+7BRTHrRADAQJ0KpNFUrOKCAnri396fLcgXR/RzJ4/Ow/Us23hC
y7h1y6lLD8z3CAZq22Qz8tRd3rsfJrpn4riVNX0BcejYOfXyZdaJAEDX1C+Q
JSWlnRoqD/IePmDYB3nFos301S85WlmGP3zThzw6m7+Pso0nqKx791x79qEP
/+DsuawTAdSN6nw+t48Y879WfXZk4SL6W+A+kGbcvMk6EQDolPoFMiM9j54l
eD78ntDBBLV2xCjyuuc98i36xW8+8iWPbu6PRjvFXO7Dh24vvUJf9rGsMBii
0tLSZb36kufwjs+nso5Tf9ETgbg/3MdS7sMp60QAoDvqF8hbcem0QN6+kSF0
MOEkR0fTFz2xaDP9OtcbyaPjmiTDeMIpkEg8TF6nj33XNPN6OGU6GIcTtvbk
aWzVtGVuWhrrOPXX/ukz6UsK9+FUmprKOhEA6Ij6BTLy7D1aIDPS84QOJpx9
v85Qnv7doVNxQcWc4TZ/HyWP7sM3fRjGE0hhbq73yLfoS/22jz4pkctZhwLQ
UM6DB0saN8fS2MxxH0J3f/0tfWHxGDwUl8YD1BPqF8iQwDi62F9JiaGOXMly
cmxaP6O8eGT+AtVvebieJQ9wRD93VvEEUiyTbTR9n77Ibxw3Xl5YyDoUgFbo
pTRu/QeyzlKvcR9Ft5tNoS8va0eMKpRKWYcCAMGpXyB9N0WTftW3vZPQqYSj
uphCelyc6rf8RMbwAKsrKS6mb7Vlp32+Obooz4AHkAEI1ZWksCoKW9wH0k3v
fUB/HRvGvsd9aGUdCgCEpX6BXLM8nPSr4X1XCZ1KOB6DhypH4Uzfr/KtIwdv
0GP0xcUlTOLxTqFQ7PrqG/rC7jlkGJn0EsDQlZaUuHR/gTyxd3/zHes49R33
sXTdqLfpS83WSR9zH11ZhwIAAalfIO0tj5Fy9cGI9UKnEkji2XD6+ha7a3eV
70ZFJNEC+TDVSA7BHJo7nz7kVS8PwuUGYEyO/btEuSpNizYFEgnrOPUd9+HU
87U3VC/TwyydAEZM/QK5wOIAKVdTJ2wTOpVAdn/zHZ21rPqn44T4TFogr8U+
ZJKQX6ccnemL+bIXXsxOSmKdCIBPkoQEuirNOXcP1nHgP+4jKvdBlb7scB9g
WScCAKGoXyB//GwnKVczzQOETiWEvIyMpc1bk5e1o4sWV79BTraMFsgzJxJ0
n5Bf4k2iiqUinu1S5YRPAOMgGv8heZKvfvU11lmgTPb9+6pLFZy0c2CdCAAE
oX6B/HTcZlKuLOcECZ1KCGGuy8kL2pJGzbISE2u8TdcmNuQxBvpf1XE8fsUd
PGTVpAVd7Dsp8jzrRACCuLLbn3aVpIhI1nGgDPdxlfvQSn8vF9YZ4cRoAKB+
gTQdupaUK2erE0Kn4p1CoVjZbwA9u/tJN3ulsyt5jJu9o3QZj1/3zkVwpVE5
zXKTFjeCglknAhCKvKjIsVM38mzf+9OvrOOA0v3zF+iEadxn9qsBe1knAgCe
qV8gX+/tRsqVt9s5oVPxLuHkKfpxOO7goSfd7K1XPMhjdHMM02U8HqVdv+7Q
sbPywTZsGr1lK+tEAMIK+fNvOtguy85mHQeUbh85atW0JfnVLG3e+s6Jk6wT
AQCf1C+QLz7jSMrVjs0xQqfinb/59+R1zKVHr9KSJ07RM2n0BvIYrf44rMt4
fKly9lGYyzLWiQAEl3HrFr2UJnLNWtZxoMLlHTvpr8auXcfk6GjWiQCAN2oW
yJKS0k4NlReYhAQa2OUYsuxs65ZtyYvYsX+X1HJL84/9yGOc++M+ncXjS0FW
1upBQ2h7DP79D9aJAHSELrTkYfI66yxQSYTHGvqi5NS5+6Pbt1knAgB+qFkg
JZn59ArliLCar0DRW+e9vOkh3cz4+FpuOeeHfeQxck1SZ/F4IS8s3DBmHH2h
3v31t5iBDeqP2J27Ki6lwSVjeub4kqX0t7Oy34C8jAzWiQCAB2oWSNU5Eq9f
MbA5Er2GjXzS6jNVWP1xmDzGyW9v1E02XnBdcefUr+lLtGj8h1gDAuqVsktp
nutKnv8BP/7COg5UtX/6TNXVVIsLClgnAgBtqVkgoy88oAUy5UGODoLxJfXy
ZfrCFbNte+03dnM4TR7jW68Y0qTEIX/8pbpYYaHUSJbRAVDf4b/+waU0equ0
pGT7x5/SlynfTz8vLS1lHQoAtKJmgTxx5DYtkAUFhjS6dXDOPOUp3M88+9SP
vZu9o8hjHNjFVTfxtHfO3UN1uZmc5GTWiQAYwKU0eq4oP3/tiFH0xSpo3u+s
EwEYF3l6qK9vWLKspu9JE+NVVbmRPF4c6isS+fqHJtZl/EnNArlv5xXSrHo0
t63D1lmTFxbSOW0CZ8566u0Dd18lD7NbUxsdxNPe1T0BSxo1Iw/QvkOntOvX
WScCYAaX0ui53LS0FS/2px3y7MpVrBMBGAVZeqjI1qRBGRexpPr3430tGlRi
Kq4oisne5mVfMjEzL9+CqX+cuiVSzQIpWnuBNKtBXQ1pZhjVU+sfXBQ/9fZh
oXfoQGuutFAHCbWReOasdYs2dJq1u2FnWCcCYAmX0ui/jJs36SI1ZROM7zHI
hXEB9InU19zExNSUVEP36gVSHle1PrpUzHQdZlt2RwtRbNlfJGFmZd83E1er
kKGhoa1atWpZWZMmTRo3btyymi1btqje180xzBBPDqTr5HoOGabO7WNjUmiB
TErMEjqeNqpMGH5ltz/rRACMYVUag5B4Npx+8uX+41644a1MAaB/pN6mNRfI
eH+uP1rElR+0lper+F5ySPmoo3ns40Pa4vLhSDP3qgNuCoXizp078ZVZWlpO
mjQpvppKu/jvP+u/jpBaNfGtDTw/aMFkJSbSc6IiVnuqc5f797Jogbws1t+T
CXPT0pb16ksHW8Ld3FknAtALWJXGIFzx30NfnB2e7ZJx6xbrRACGTioyq6lA
yuPnlx+gdvcPjZfIq9wnTlR+9NpMREccZbHe5YOUFnFVb1sDNQ9hz/8lkNSq
aZOeciGz/jhuZU0P7+ZnZqpzl7y8IlogTx2rbcZIhoplMu+Rb1VMGL7gT9aJ
APQFLqUxFGdXuKlODpn/6BHrRAAGreYCGVf57EcL71Cp6l1If/SuGG+UxfuW
39AsUo0TIdUskD9M2Ulq1UxzwzhlpbS0dNkLL5JXp11ffaP+Hbs3syWPdN/O
K8LF01jZlI9fTqMvvDs+n4oJwwFU0Utp1gwdzjoL1IZOkcH9WT/6XXmhvp92
DqDHaiyQsjCRi6WlhamJSok095ZUvkulA9ayWPMnnUtZjZoF0mysiNSqRfOC
6/aYGLl1+Ah9aYo/dlz9Ow7quow8UtHaC8LF09ixxVb0ca0dMQrz8QJUcdlv
B/03gsWX9Rn3MV91cshd08zxcRhAU084hP2YJDHS1vTxOKQvWZBa4l1+F3Ny
BQ0hE/NeIMeYeJFa5Wp9Uq2HwtqOL74iL0rLe/er04vSqAEe5JG6OYY9/da6
FbN1m+qUj9LUVNaJAPROsUxm36ET+WdyYNYc1nGgNkV5eXSlMO7PsX+XsE4E
YKCeUiDLpXsrp+rxLj9ArSyQliEqV3wIMAJp8vwKUqvWr458+uNgLf/Ro6XN
WpFXpBO29nW674RRPuSR2vx9VKB4mrkbdoY+KNu2HVJjY59+H4B66eDsucrJ
Udv/n72zjosqa+O4rt3drWvH2l1Ya+eq69rdtWuh0iEhDVIiCAIKCgICgnR3
l9Ld3czA+x6442EchmHy3hk438/8oczcc587c89zf+ec5zzPSKAniTYHwYiK
nByFSdOghgw1NCLaIgRCEGFGQIJPBbRMQ95Lat4jU4EJSCGqJWwSZV92N52o
joMgmRSQk/tLY7LK8l1kx9dBNL4qajDPWFlGBkvH/r37HXal9y/b8Mg8NihO
SmpNntajz3cHR6ItQiD4l5zwcChIIkzNiDYH0QFgOAwGxdjvJdqrX7KbO9EW
IRACB3MCEpt1XKRW0HKI6SnaGMiKUGwXNp1UkG1hRkDW15Pg3mQXBwHIt6C+
YDHmi4x27mH12Kv/fMSu9OLRD7ywjQ1qSkpUZ8+HD0R/DS2iLUIg+B2tpSux
/mKwZTvRtiA65sdXJ9GefeG8MSqqhUCwCLMCUk2oNW9Pms09bBs2VIsVWBof
IZ2OF7CZE5B5uRVQQIYEZDLRKpFkBgZBrRVt+ZHVwx/f/IJd6ZFtbzv+NO8h
k0jgCQivyO7WHaItQiAEgAAtbZhmvzg5mWhzEB0TpKMHHd3LaTMr8/OJtgiB
ECAoAvLXpefapFCv0KQC+P8kG2HwGUP4mYpQbBHbi6IXSZZXmlewhV2ZyoPN
jIBMiM2HAjL5B79n6/p85TrmgmRHjiXV17N6uMwzF+xKty3X5YV5rPLlzj3o
VN/u2ttIJhNtEQIhANSUlsJyJ9+eixJtDoIpYB54LLEPuaGBaIsQCAGhNl64
JXhR2Cae6m+G2LbrA8I6XgFehpIHWqoW/lJlJs1RuGVjtiXQlEmO8tiEJDPT
j/9jTkD6e6dBAVlcVM3ydeFIfXW11ODhlAzb9/9jowWtl77Yla6Yocp181gl
1NAIulP1BYvrKpgtcY5AICxOnsH6jsLEqWjkJRA0NTWZHT4Knd7nq9eJtgiB
EADSWuYVqVM9UiIYSWkwdU9LOZorlgF0phZDTe/BjwjdM0xjet8hMwLS0Sae
IiC7i5HJjSxdF86EGb2FzicvJoaNFkwNQrGLnTVCjuvmsURmYJBYnwGUal/D
R6NlOASCJZLd3KE3SLAXjAS2iIaaGq0lK+APF6SrT7RFCIRAQyrJzk5Lyy4o
YTQBVVtSkJaWVlDCWs4KZgSkmWEYpqlmDH3BUuP4o79hM+Z2dFatZa8Fu0+x
2MWO6SFOYFbbitxc+fGT4bbrROdvRFmCQAgooP8qzZiNdSKzw0eJNgfBLKXp
6bKjxlEK0fbun+bjS7RFCASCDswIyFdKlFXd5dOJX9VlQOH373DcGqzH5rjV
2y0FrtdXlBOTQY5UX6+7Zj28Fh8lFULMQCAEHXdpWZgcpqqgoOMDEPxBiocn
3JQtN3ZieVYW0RYhEAhamBGQ/LavpD2+PnqCORyJAUPYDheMCsuBAjIzvZS7
FjKJ9aWrUD1anjpLiA0IRCcACA+RHn3QQEwQ8dfQoi7biiplIxD8BjMC8uF1
O0xQHd1hjI9VbEAmkcBAFfM2n85dZLud9NQSKCCjIwioFdiafqRbr1fLVqE6
GggEJxjv3of1Jo1FS4m2BcEan85fgs6QE6+OQCB4ATMC8tJxC0xQXf7bEh+r
2CDe7gt0NWnePmy3U1ZaAwWkr0cq9wxkilRPL9Fe/bCreDF6PKtldBAIBA3R
FpbQM+SEhxNtDoIFSHV12ivXwJ/PT02DaIsQCEQrzAjII9veYoLq0Y0v+FjF
BqaH/sKcjMrMuZy009TUNPo3cex67a1xrYYA5CIQjTBkK9XLG8+zIxCdEiBC
pIeO5CS1F4JAyrOy4NKSaM++Ke4eRFuEQCAoMCMghZZoY4LqhYgrPlaxSlVB
AZy485DlNP3O78NeYNdr+iaMK+YxQ0Nt7atlq+BYO/CVDm6nRiA6N7C4wIsx
E8gkEtHmIFgj3ddPrHd/SnmIUePQugwCwScwIyCXTFHGBJWuqj8+VrGKj7Iq
zHjD+X69FTNUsevVeolf+oiPZ85D9Wh9+Rpu50UgOj1AgbQmhPxiT7Q5CJYJ
1tNvjQxfjiLDEQi+gBkBOXWgDCaoLEwi8LGKVTQWLoHF/jhvbdtyXex6ZZ65
cN4aM/iqqkP3qLN6HRsVGBEIBAOUf5+D9a/3x04QbQuCHeA0cvOGmvOXiDYH
gUB0LCDr60lwU4mLww/cDGOerOAQ6FiiLT9y3uDRHcbY9T68bsd5ax2S4u7R
mvFs3KSKnBwcTopAsAGZ3FhVVV9UWJWdWZacWBQTmRvkl+HxLcnhc/xH08i3
usE6Kn5KUh5yom5tX/JibsrSnhoKPrqq/gZagcZ6IeZG4Z/Mouyt47xck8OD
s5K+F+blVlRX82T05CYpjXUx8b4Da0qJSc+F4AQwrAaDa+jqA7S0ibYIgejq
dCgg83IqoIAMCcjEzTDmsbl+k1Lvb8QYrszd4bnrnKbmQrofnwYJIDoxJBIZ
dPOo8Bw3p0QLkwggAmWfuz64Znfhrw8HNhtuXKg1f5zi1EEy43pJQFfA09fY
nhIzh8utnKm2a43+yX2mt89Ziz1wUpPzfvc61NEmPtg/Iy2lBOhYlq6xJDX1
eXdUHU+wKc/OfjFmAtxmiCrUIBDE0qGAjIvOg449ObEIN8OYpKG2Fm6x/HLn
HlfaxC3vZXPV16UrOa+eg0AwBkjErIyyIL8MG8sYoA9F//sKBkdAHK6dqzFr
hNyo7njIQq6/JveXXjpV5c9VekBk/nfVVknKw8wwzONb0o/4gsoKOkmnX2/a
gnU0vXUb8f8JEFwhzdsH7peUGzsRrdcgEATSoYD080yFHru0pAY3w5gk0syc
60nepJ9SKu9sX8HbyjuWp85C4z9fvc7TcyG6CJWVdVHhOTYWMSoynrfPWe9Z
93rB+JcwMxWvXt3FpgyQnjtaYfl01Y0LtbYu02n72rJUZ8MCrdWz1ZdNU1k0
UQl8eMbQF+AoHtk2bbDs+vmaQFs+veugp+bv/OW7vZQa7G7FSUlE/1AINqGu
UKO7Zj2KGEcgiKJDAfnFKg5zyMDPNzU14WYYkxhu34l5Eq0lK7jVptZLSu3v
FTN4WPsb7hxvdoNrNyA3iGAVEomc/KPIyS4B3LH3L9vs2/hm/lhFDnUXUHRL
pigDvXd0h/HVfz4K33FQlHA30Aq0MImw/RgLZJiXa3Kgb3pkaPb3uIL01JLC
gqrq6npOPAM4trKiLierHDQYEpDp7pwETmRqEKou7y3xyPnOhc+n9pvtXvt6
1Sz1mcM5miwd3+3Jk26UySvh5SfBRXm7peTnVXLxF0Hgw8ezF6DztLl2g2hz
EIguSocC0kQ/BHO/s0fK42YVk5Smp4v81htzI/7qmtxqFjy8sEsGDyxutUlD
qpc33DgjP35yRS4BNRMRggWQi/Ex+Z/MoqSefDt9wGzNHA02ghLH9pT4Y5LS
rjX6F/76AMShsrQn6OCONvFAuaWllPBoAwsXwcI1oyNygc4EmvaVkq/kY+fb
56yPbHu7dq7G1EEyjC//725/YJ3uTreRo7qJwm6+Z93rf6/Y6msE+HqklhRX
E32ViA5oqK2lDv4JfWNItEUIRFekQwGpJueNudlVs9Rxs4pJ3CSkKNtP+gyo
Li7mVrP21ryddK3MywOiEVqeERDI9VMgOgFAybh+TdRQ8Ll+6tOmRa/G95Zk
XiiO6SG+Yobq8Z0mwrft9dT87T7FhgZm5maXNzY2En1ZvKWivDYhNt/NKREM
A+VE3cBXt3vtazgxu6Tbaag6FnU73963t3DCy+O7TCQeOVu+iwStdfovTRBp
3n44cixlZ32/QbmRkURbhEB0OToUkOIPnTCnumsN323xUJk5F3Mg5kc7SGXJ
Er4eqfBRUlbK5bDPRjLZYMv21ooz2rwNs0QIECQSOTI020Ar8MbpT2C8xvxy
LRA8h7YYPbxup6Pi5/zle9L3woYGMtFXw19UV9fHx+Q7WMWIDhqDdb0TvVcx
+fVOHSizf9MbsQdOnz9Ep6WUEH0pCApJLq5wBUpl1ry6igqiLUIguhYdCsi7
Fz9jXvSfvaa4WcUMmUHBPKouERvVuvE8NZlrE5sYzk+fQ7MtTp7hbuMIgaO4
qNrRJh4M0/auN5jUT4qZNej18zUv/20pL+b2ySwKCM7KSjo7jhHt4fjgEdb7
pAYPz0ot8HZLea0Z+OjGl30b38Aapoxfs0bIHd9poiDu7uaUWF6GSqIQibuU
DHSnKEU8AoEzHQrIMwfNMbd566wVblYxg8P9/2D6R3JDAxdbzs4sgw+LiJBs
LracYO8Ak9GpzVtUX1XFxcYRgkJyYpG5Ufi9SzZr5mh0KFcWjH957E9joDA/
GEdER+TW16NSzhyRGxUFJUfU+w8074K+7+LwQ03O+9rJjxsXanUcZdpdbN08
TTDKfvc6NCE2nw+3GXZuwBdu9Ofu1uzimq+ItgiB6EJ0KCD3bjDAXKXIv19x
s6pDGhsb5cZN4tEuvOrqeviAcHfmWrqP0rQ0meGjMZslBw7Nj4vjVssI/ud7
XIGhdtDFYxYdbpSeMkB6/6Y3ko+d7a3j8nLQqhz30Vy8HOuGxrv3Mf5kXR0p
LCjLQCvw9jnr9fM1O8w4NGuE3NlD5npq/jGRuUhM4kNVYaHCxKmwFkNWcAjR
FiEQXYUOBSQYX2O+UVnaEzerOiTJxRWOOlO9vLnePtyw8PlDNFcaJNXXa69Y
DW2ONDPnSrMIfgaIxjevmkXjvDEKjIXHyplqQKK81Q2Ojsglk9GWDd4CM2iJ
9uxbmZfH/IGVlXV+nqlaL30vHv2waKISEpN8QrqvH0xq8XLq76hUJQKBDx0K
SDhhYqgdhJtVHWJ14TLmLhQmTeOFc+b6VdvevA3VI/g3V9pE8CFFhVWfzKJu
nbWaP47RTOO4XhI7VuqJ/PvV7lNsQT5KRYgrFbm5Ij36YJ3RV0WN7XayM8ts
LGPAj7hrjf6EPoz2yAN/cvOM1UfTyMICFLXCE7xfKkMH+27/IaLNQSC6BB0K
yMn9pTEfCB6LuFnFGFJdHSxf+PXRE16cYu1cSnCaiqwX561Rl8vRXrEa5Qzv
ZJBIZH/vNNnnrtuW6zJY5ZzYV+rAZkMFcXcf9xT+z7jYuXm7ay93CxDU15MC
fdOBuzi6w3jKAGkGMZNbl+lIP3Xx80xFO+W5y7sDh6Gb9VZUItocBKLzw1hA
gicjdH3OX77jaRgDYq0/t5YvjIjgxSl2r32NXbX4QycOmypISJAcOJSy32f4
6NK0NK5YiCCc/LxKM8OwC399mDZYtkPR6OuRWleH9r/wC9RjuryYGO42DpRh
kF9Gh2Jy+hDZi0c/mBuFoylorlBTWvpy2kwYnJDm40u0RQhEJ4exgCwprobu
zt+bX5SP+dG/KRuZ5y7k0SlO7HmHXfW9SzactNNQU6OxcAnlUdW9V4K9A7cs
RBBCU1NTeHAWEITbV+i2m6exu9iWpTrSwt983FOQaORPQMeUGjycp6sYlBM1
kP08U6WfumxdpsPghtmxUk9Rwj0iJBtFS3JCVnCIWO/+lOimiVOrCguJtgiB
6MwwFpBpKSXQy8VE8kW5vbqKCvF+gzAX4S4ty6OzXD/1Cbvq80fec9KO1cUr
cKLDWfgZt8xD4ExNTcNX24Q7Fz4z2EM9b4wCuG0sTCLQhJJAAOOo5SdMwafW
TGFB1UfTyJtnrBjcRfPHKT68bgeGHqj8DXsEaGlDl/t2114kyBEI3sFYQEZH
5ELPlpHGF1vbwt4aQ/9QnJzMo7MI37bHrvrQFiO2Gwk3NoGm6m/Y3EhGIU8C
Rklx9fu34WcPmcNIYJrX6N/Ed63RV5b2jArLQY8qwSLF3QN2z6RvLnieGtwq
4IYBtw24edoLmgXjEaAkvd2QkmSZ98dOwF/WQ1aOaHMQiE4LYwHp75UGHVpp
CZeL+rEHTBurs2ot784iJ+qGXbXQEm32WsiPi5MYMAQzVXbUuPJsbiYkR/CU
73H5N05/+nOV3pge9B/uvw97cflvSwuTiKJCtKlWUAEqTnHKDKyHWp4+R5QZ
4Bb6YBxx6bjFjKH06+BAJYnyOzFJbXm58u9zsF9WpEcfXuR5QyAQ/+tIQDrZ
JUA/xg/uqzI/H+bf8FPT4N2JdFT8sKteOlWFjcPrq6vV5/8BQx8TnZy5biGC
6xQXVRtqB+3b+Ka95cXVs9UlHjmDURU/9AUE58C6omCsR3hZKBKpOVry6V2H
hRNe0r395oySv3/Zxs0pEW3f7pCc8HDxvgNhiEJVQQHRFiEQnRDGAvKjaSTm
u6YMkMbTqvbwV9eE40qWMgCzirlRONwpycbhn85dhGso356JcN08BBeprKj7
YBxxfJfJ2J706tZ1F9u5Wl/1hdePePQM6mwUJCTAfhpu8o5ocyg0NTUF+qYz
UJK/D3tx+5w1GN2jLVoMCNTWhT+u0Z+7UYQJAsF1GAvIN6+CYGg3nla1h86q
tZhDMNyxi6cncrSJh/qB1emmMKO30HG93rQFhT7yJ/X1JIfP8RePfpjUT4ru
Y/qPSUqG2kGomGDnBtaHMtl7gGhbaAGaJ8CnWUm2V/Vm2mDZW2etPL4loThJ
unz4+yR0xbzbcYlAdFkYC0g1OW/MU62Zw8P1YiYpSkyE3iDsrTFPz+Xv3Rr8
WVxUzfyB+bGxEv0HY0a+GD2+IieHd0Yi2AB7KD+4ZjdzuBzdTTEHhQyN9UJK
iln40RGCi4+SCiVzYK9+NSUlRJtDH3DTBvtniP73delUlfb2bov8+zUqDHmb
X6irqFCZNQ8uWqV48FE1XgSiE8BYQEoLf8Mc1I6VenhaRRdXcUnMFYj3GwQ8
A0/PFR+TD51zcmIRk0c11NSozVtE8Ve/9cZ5ayeCMT/iC2SeuSybRv8RDO5w
HRW/3Oxyos1E4EpZRsbz7pRhaYjBG6LN6ZiIkGzgllfOVKN7G6+bp6ki68Un
GTP4gZyICBgMKTduUmV+PtEWIRCdB8YC8vHNL5hf+mv7WzytoovKzLmYH/jw
90lenwsICeiTw4KymDzK+vI1OEfqIirOUwsRTFJZUfdWNxjoQ7oP3DVzNJSk
PFKSiok2E0EYeus24hMYw11io/KAklwyRZlu4C7w2Nbvo1GQJCBIVx+6ZfAT
o2BIBIJbMBaQN05zJ58252QGBkEnEG/3hdenq6lpgN7YzSmRmUOiLT+2hj5u
3oqikggnwCf99jlrurXk5o9VfHbPMSIE5VZC/M9fQwvWvxO47bpADvl5pv57
xfb3YXSyAM0aIff0rkNcNA/3GwoEFv+chs7ZU06BaHMQiE4CYwF5ar8Z5oju
nLfG06q2fLlzj5JTceRYckMDDmec0EcSu3YwkO/ww6Xp6dJDR1IKXo8YU57F
7KQlgusU5FdqKvqsmaPR9nk6daDM9VOfXL8mojw8CEhFbq7Ib72xzhuorUu0
OWxSX0/6YhV37vB76LhoIjSM9UIqK+uINpMY6ior4QIWGCZk+AcQbREC0Rlg
LCD3b6LkxHt2zxFPq2hoJJNfjJmAdX/bG7fwOSksN2aoHdSheXAVDLzibGzx
sRBBg59n6uW/Lcf1opONZ+8Gg/dvw6ur64m2EcGPGAhtg2sHRNvCKaUlNXrq
AZv/eEV317bwHYek712xQnR2WJhYnwHYr/xy6u81pShMFIHgFMYCUmixNuZ5
5MXc8LSKhh+OX6E8S/f1w+eka+dSprBUZL0Yf9JFVByaZ3frDj7mISCVFXUG
WoEbFmi1fWLOG6Mg8ci5az4xEcwDw+REfuvdaTInhAdn/XfVFojGthGSx/40
drJL6GphNn5qGtBRm/91nGhzEAiBh7GAXDyZEqGtq+qPp1U0WJ46Sxk5TpuJ
20n3rHuNXbvYAycGH0v19ILrXxqLljbU1uJmISI2Ku/BNbupA2VoHpFjeoj/
s9fU3jqOREJJOBEdU1VYKNqzLw4lrvCnurre3Ch87waDtsOr5dNVtV768kmN
Wnx4t/8Q1JCCG66AQPAJjAXk1EGUR/MH4wg8raKmvroaFpX+9lwUt/Oe3GdK
if+88Lm9z1QXFytMnAqTC+XHxuJmXleGTG60/RhL95k4f5yinKhbdmYZ0TYi
BAyjP3djHVl37QaibeEJcdF5/121ndyfdk8Z+Mv9yzYxkblEG4gHv3jsvgNz
o6KItgiBEGAYCMiGBjJ0Ms5fvuNsGCTC1AyOGQvi43E7762zVti1nzlo3t5n
TA8egbYF6erjZluXpbSkRkPBB06MU78ObDa0sYhBU44I9gg1NILF60vT04k2
h1eUldZoK/utmKFKN07484foTt+DUr28RXr0wX5rtXmL6qtRyQAEgk0YCMiC
/EroW4L8MnA2DGK8ex/W2V8tW4XneZ/fd8Sufd9G+umFA1/poIga3PgeV/Dg
ml3b+ZPpQ2SFb9uDd4k2ECHY1JSWivXuj3Vnb0Ulos3hLY2Njd/svx/faTKq
O62MXDD+5UtJj/y8SqJt5CFuktLQdVtdvEK0OQiEoMJAQP6IL4BeJTGBmG0I
VQUFMDbJR1kVz1MrSXlg175hgVbbd/NjY2GBA8XJ09GePh7R1NTk4vjjr+1v
206YrJ2rYagdVFWFNlYjuIPJvoOUsepyXMeqBJL8o+jpXQcwCqPpXON7S944
/amzrmsD/fx681aoISPNCc5yjEAIKAwEZKBvOvQnhQVVOBuGAXP8ivTog/Pu
SAOtQDgkp3mLVF+v+ccyaFiajy+ehnURamsbTPRD1s3TbLuH9O/d79ycElFF
CQR3iXhnCkVFUSJT5QM6B2AUBsZidPMYHPvT2NMlmWgDuU95drbsyLHYby01
ZERpWhrRFiEQggcDAelklwDdCFGBMXrrN1FKUG3fifOpP5lFYdc+qZ8UzVsO
/z6ADxpXMQmcDev0FORXyou5zRklT/MsmzpQ5skte5STB8Ej6ioqxPsNwvq1
m6Q00eYQgI97yvkj78f0EKfpekJLtD+aRnay8MgEewfoxvU3bO5qSY0QCM5h
ICDfvw2H6WdxtgqjLDPzeXdKBw8xoB+IyDtcvyZC/1lT01r7JsnFFVqls3pd
I7lTOVVi+R5XcPfi54l9pWieX0umKGsr+5WXoRRJCN7y/tgJrGurzllAtC2E
kZ1ZJv7QqW0CycWTlXVU/DpT0Ijd7btQQ3rIvCDaHARCwGAgIIGvwPzG0qkq
OFuF4aOsSik+1atfdXExzmcPC8qCnjM3uxz7IzBDfsIUzCrJQcOKkzvh4g4h
REfkXvjrQ9uQ/p2r9W0sYlDlQQQ+xH22gYoiOyyMaHOIpKK8VlPRZ9FEJZou
OWuE3EtJj7LSzpA9sqG2Vn3+H/ApkxUcQrRFCIQgwUBAvhBxhesXOFuFobN6
Hda1jXfvw//sKUnF0GfGRedhfzQ7cgw+X0INjfC3qvMRHpx1+oAZjXQc00P8
/JH3BO79R3RNSPX1sKj914ePiTaHeBoayO/fhm9cSBseOXWQjORj506wWTsn
IgKWOFSZNa++iphofwRCEGEgIB/f/IL5isNbCVBKpWlpUKqFvTUmwICSGugt
/TxTwV9C3xiivD1cBOjD47tMaB5MUwZIP73rkJZSQrR1iC6K1cUrWB9XmDQN
bdSCuH5NPLTFiKa3TuwrBR4TGWmCnYPCR0kFOnbry9eINgeBEBgYCMir/3zE
vMTFox9wtgrgpfAS69FgeFhbRkBhkcbGxtG/UYLJ7a3jipOSJAcOxUySnzCl
pgQpHPbx90oDoxKah9G0wbLST12Ki1BeXwSRJLu6QTmR6ulFtDn8RUhA5qn9
tOsF43pJ3LnwOT1VUF0iGCa82fYn/NHjPtsQbRECIRgwEJDNaWZb/MN/V21x
tgrwatkqrDu/238I/7NjzBwuh30DJnrBOqvWwkIV4BFDlEmCDpCObecxfh/2
QkHcvXNEVSEEHTBylB8/Gevsn69eJ9ocfiQ2Ku/KCUuazdpARoInhYBWES3P
zpYZPhr70WVHjsU5ZRwCIaAwEJA7VuphnkFa+BvOVhUnJcHxYISpGc5nh6z8
XQ37Bu5tE4P2OD54RJQ9Ag1d6Th7pLyKjGdFOdpejeAjHO7/h3V2mRFjyA0N
HR/QJUlOLLp3yWZ8b0nqHj2hj6Twbfu8nAqirWOZmE9W0Mkb7tiFohcQiA5h
ICChfNJU9MHZKg9ZOVjvvq6SsDjt7St0sW9gR/cdmD2ai5eT6jtPFgt8oCsd
545WAPdVZ0oJwv+QSaTqoqLi5OSc8PB0P/9kV7eEL/bRlh/DjU2CdPV9VdW9
5BXdpWRcRMWdnjx1+PeB3a07n69ct758jeYF/mh78zZQWU6PhV1ExMAh4EBf
FbVAbd0wo7dRHyzibe2Svrmk+fhmh4UVJSZWFRQIVq/JDAqGWgJ8RUSbw9dk
Z5Y9uvGFRkZO6icl8u9XospPsI3VhcvwdwfdgWhzEAh+h4GAhAu4pgahOFsF
67yYHTmG86mpOfanMfYNbOzWXI9bvN+g/Lg4Au0ROEICMtvGOmLSsbpakBQF
nwPkWWl6OpA9CfYOoYZG3opKXx89+XTuovGe/Tqr1qrOWSA3bpJE/8Hw4UjI
CwwGX4yZoDJrnvaK1Ybbd5r/ddzq4hUgU90kpMDDGpgNpFpWSGh5VhY/TPqp
zJyLmW3xz2mibREAMtNL712yGdtTgmZDnNSTbyXFAhPVXFdZqfz7HHi7FsTH
E20RAsHXtCcgm5qaqLeQ4GlSQUICfOhEfbDA89Q0XDlhiX0Dq7odBcb4q2sS
aIxgEROZ2xxsj6QjlwD9sSI3NzMwKNryo4+yKtBdH06cMhDapjZ3ofSwUcQq
Q+6/ujfHoakvWPxm258fz5x3Fn4WoPkq1vpzVnBIRU4OPhVDXETFMWMkBgxB
qV2YJDW5+NZZK5rYyGmDZeVE3QSlCkBGQKBIjz7YT6+9cg2qE4FAMKA9AQn6
O/QAPu4peJrkJind6rqriRy9Xtr1ipJKvdsp8CxDUTHMkPyjqFl4d0fSkU3A
PZ8bGRnz8ZPnC3mrC5dfb96qNH2WWO/+PFJroGWpISPkxk58OW2m6uz5GguX
vFq2SnfN+tebthhu32m8Zz/dF3gLfEB37YZXy1dpLFqqOmcBOFxu3CTpoSNh
Vj0evUR79lWcMgN8LZ/OXwK+IuKdabqvHxCW3O2e1MPYSDNzLrbc6UlMKAQe
AM4/YK8ZQ18oSXlUVtQRbV3HfHsuCn96d2liqrAhEAJBewIyI60U9v2ocFy3
pMHSAO+P/4PneWmoLi7eNeAw9g0s6nGlLDOTQGMEgqyMsrbLWL8Pe6Em542k
I10qcnPT/fwjTM3cpWQwrdhc56g7R/pKavBw5d/nAAX4bv8hq4tXnB4LAyEa
+EoHnCXhi32at09uVFRpenpVYWF9VRWPZvNAs0AGVxcVlWVk5MXEAIH33cEx
0vx9kI6el7yi89PntjdvW546a7LvoP5GIc0/lr2c+jtM3832S3LgUO2Va4Cq
9FZUAqcD18ihpNRauhJr2WTvAW59M12H+Jj880fe0wwkZ42QU5fnd29AbmiA
MVSivfrlREQQbRECwae0JyCjI3Jhr8czwRd43MAnQqyVNW7nbcv7Yyd2dduM
fQMrJ8kQaAn/U1JcLfrf1wl9fgmknzpQRva5q6AsXfEaoKkKf/yI+fjJVUzC
7PBRtbkLxfsNYkMmifToozBpmt66jeZ/Hbe7dcddWjbktQGMHhSsvSo0UCI5
A4PibGyDdPXdJKRsrt0AMvjVslVyYyeK/NabDUn5avkqi5NngD6PtrDMjYxs
qGEhVZT3S2WoIvAvpdo5iArPaRvKMn+corFeCD/XJwW3Cpzz11i0VKC7FQLB
O9oTkL4eqbC/46kBXEQoCXMkBw1rqCVMe0SYmgEbDnRbO4rQauD8T21tg7q8
94yhL2jqUzy/7yhwezC5S2V+ftI3Fx9l1U/nLwEZw6pcBELx5bSZhjt22d64
5SWvGGlmnubjW5aR0WWDssgNDeDy0/38oy0/eisq2Vy/+XbXXtXZ88X7DmTh
i+3eS3HKDHDg10dPwk3eAZ3AQBsAQQ5ng4FKx/NiOxlhQVkwqzB8rZun6WSX
QLRp7QIzgYCX89PnRJuDQPAj7QlIe+s4Sk/vLoZP1DqGyqx5WJ+1OHkGt5PS
UJaZiS2o/dVtGfYlzBwuR5QxfAu4K8wMw/6YpET9UBjbU+LfK4KaTJgTgK7L
iYgIMXhjf+/fN1t3vBg9nnlVI9ZnALjtjf7cDUSRj5JKvK1dQXw8mvRgkqam
pvLs7DRvn2A9ffu7999s+xOmAWfmJdqzr/r8Pz78fRKo9BR3D5qkYXrrN2Ef
A0qeqAvsNAT6prdN53Vgs2F4cBbRptEB9GhYPAKM5jICAom2CIHgO9oTkEAb
wOBn3IzJCQ+Hjh08RnE7LzXUZa3+6bYQFlkgxBi+xcXhx8aFWjTPggt/fUj+
UUS0afhRVVAA7lLnp88NhLbBMpcdzCv+1lv59zlmh4+6iIqHG5sA2VOelYU2
Z3GdmtLSNB9fICkd/3tosvcA+M7h1toOfyCgJ60uXA7S0csOC/NVUYM6s7qo
C93bvMPNKXHTole/uI7uYldOWPJhJcSChAS4cKA6ez5L8Q8IRFegPQGpo+KH
/+qts/AzrLdKDRlB1AyMv7omfJrI7rkLvVxtLfG56fiBmMjcttMI+za+CQno
/JuMSHV1GQGBfmoaFifPwHxxjF+yo8YZbNluf+/fEIM3mUHBxGYV6MoAf5If
Fxdr/dnzhTz4+TQWLmFmYzt14IGPsirRF9FJwBYvFk38ZfFiQh9JiUfO/FaU
yldVHd4AoBcTbQ4CwV+0JyDlxdywfi20WBs/Y2bMxrrqp3MXcTspNYXfv8NH
BlAIfm4/oH8ryCesIA6fUFRY9eCaHU2St/Xz+TqQiXOKEhPDjN7a3rj1avkq
0V79OtQb4GOfzl8CYiPpm0tlXh7R5iPahdzQkBcdHWlmDsatxrv3AanfoZ4E
Dsry9LlAbV1wIJo35pCamgYVWa9pg2Wp/cm8MQom+iF4Bk0xBvzKrzdvff4z
gDbFw5NoixCI9iEVuJqaemXTGYWRSpJcLU0NDU1dQ9PoHpkU6tr8tqVrGitl
SNsTkE/vOsAYFRaa44Cs4BDoqL87OOJzUmqag15Wr4NBL+l+/vEx+dCzJSd2
3QUsEomsq+pPs1Nm4YSX716H8vNWSrYpy8wMe2v88ewFhUnTOhYV02dZnDwT
oPkqKySUTCIRbTuCfUpSU6M+WDj+91Bv/aYOC/dIDxtlvGe/p5xCmo8vqU4A
0hvyJ2BYKnzbflyvX3J/CS3Wxjn5MAPAXSE5aBj2o7+cNpPA0roIRLvUFrga
Si7q1ox8KG00SEGATss7i04daP6IkLDNryIxW+dUy9sHTrW0IGQZz6yIbE9A
3jprhfXls4dwSqLr+OAR1kllho8mpJaZ5wt5+HTAtt1lZZS1JsMMwzUZJv/g
+jVx7VwNavc+ub+0ooR7TU2nWtOvzMsD4sHm2g24jau9l9Tg4W+27nAWfhZn
Y1tVUEC04Qie0LwrKjw8UFvX7MjxDgcRYn0G6G/Y/O2ZSKLzN1S2hg2Svhf+
s9eUJjDm3OH3qcl8kT0pWE8f/tY2128SbQ4CQUOF6alFi4SEWlRiNzUaAVng
2vLGlagWVRigdgD854BOa31qL8nm968YRjX/p8Sr+e1uB0LbSEh3d/cRI0YM
/5V+/fr17t17eBs2L1XAevGd8zglY1ScMgProdaXruJzRmryoqNhBQ2NhUuw
CMyy0hrozXw9UvG3iliSE4vaevUrJyw7zSbr8uzsSDPzz1evq85ZwEAeiPbq
92r5Ktsbt8KM3ubHxaG1y67G601bKBNQU38H/2ackUm0Z1+dVWu/Pnyc8MW+
tqyT9BR8cHdO2rDgl615E/pISj52rqwkfoLX6M/dcCE72dWNaHMQiLZU6Ai1
FZAkR+HmacVTOlE/PxXaMt14IACTiNmOLbOOp6J+rnuHtkxHHlAL/d+vkMnk
mJiY6F958ODBzp07o9uwd/1rrAs/v4/HanKGfwD0wEnfXHA4IzVkEglWnWgu
PRAeTvk7uRG6ss4d6UdDbW2DnKgbTWLwbct1A33TiTaNU0h1dd8dHJtnGmfO
ZSADRHr00V65xunJ00Tnb2j3ZRcnQEsb3hVVBQXkhgbgr7wVld7tPyQzYgxj
MWmwZbuvqnpJCr8syPI5wOW+eRU0e6Q8TbTMJ7Oojg/mJWWZmVJDRsBxBFrI
RvAfFYYH2gjI2qgWudhNJ6qC5mNXTOPBf+INMTlpWNF6BLbefSWeiYCs9paw
YaYFRQl3Ti6JSezv/fv8565V/FMlu4pJQJ/vJilN/daUAdLY9/DRNBJnq4gC
SOVl01RoIttN34QJ9MxbVWFhmNFbs8NHGeXb6d48+Wx/936cjS2aO0JAKvPy
YB2cIB096rdAp8iPiwvS1bc4eYZxxCy4tb49E8kMDBLofoQPZaU1z+870gRG
7t/0JjaKyF1poW8M4a/5+ep1Ai1BIOhBR0BWRBl2o12SrrW80hLpqBbQfAim
H6lWtGuTTLtRT1EypD0BuXiyMtZt9dT8ObomJgAetbkEMBZhcu0Gr09HQ3Zo
qGjPvtjZXy1bRbMPYv5YRex7MNQOwtkw/ElPLaGpOwZ8uNgDp8oK4peQ2AM8
3L0VlfQ3bG4vDSAQBpqLlwPRGGv9GSX6Q7QH3IprsGU7g4+VpKSAccqn85dg
Qom2L7lxk6wuXom1skazWIxJ+l54fNcv9WvG9BAXvuNAYHXUt7v2ErhShkAw
hK6A1GmrBqN+qsaKn4f8smD9c9KSNpaSHu0JyKmDZLA++8GY56Xk07x9YK9M
cffg9emoIdXXqy9YDCPh82NjaT6wapY69j1oKPjgaRjO1NWRlKQ8JvWToikS
kRCbT7RpLEOqq/vx1cnu9l2l6bPae4iD57v9vX/jbe1qSkuJthchAAS+0oGr
2JX5THWKsowMcJTRzj0wuJrmJda7v+H2nb6q6kWJiby2X3Bx+BxPsyAydzRh
CyLlWVlYkTLwUpw8va6ClYwnCARvoSMgS0LVuv0a4giIwjZdCwEBWaLTcsgp
Q6oQkdpQDgVkc+xfd0pv/WrL89g/u1t3KGPzsRNxzgDm9OQp9OdeCi/bfmDr
Mh3se5B97oqnYXji6ZK8cqYatYueP1ZR4JbsK3Jzg/X03x04LDFgSHsr1Dqr
13nIyuXFxBBtLELAAKIRTmIHauuydGxdZWXMx0+Wp88xCJhUnT3/68PHYCjN
PykQ+Yfa2gZFCXea4e2uNfrREbn4GxNqaAR/NevL1/A3AIFoB3ozkKEtM5CL
JKmTP7YVkMKO2a1vczwDWVJcDfupvxfdtJNcAzhMoBux/giUJE/PRUOGfwB8
KOiu3UDXdcOqK8K37fG0DR/y8yqvnfxIs0j09K4Dv9WDYABQgx4yL5qr1nan
/2iW6D/YZN/BYP3XKK03ghMMhLZRVrGFtrHXQiOZnOrpBYSi2rxF7SlJ2ZFj
P527GGtljdIB0ZCRVnr2kDk/OCvjPfvh75Xo5Izz2RGIdmByCZvkKCz0c+NM
BSYghaiWsEmUfdnU+27aha6ATE0uhp2U13HLyW7usDOCAThPz0VNQ00NzPgH
NEbhjx90P3b+yHvse7h+6hNutuFAU1OTkU4wTW7wPetex0QSMKhnFSD1Uzw8
7e/9y2CR+uXU321v3v7h+LWhVmDEMIKfCdTWZXUVmwElqan+GlpGO/eI9x1I
9wYGfzfZeyDsrXFteTlX7O8cuDklrp6t/styyThFK3Nc92iXZ2fDhWyFSdPQ
D4TgD+gIyNp4wzYCkiIaW+IeK0xP0cZAUiYt6aWCbAtdARkZmg27Z1YGb7ej
2ly/SemJE6fiGdYC85aDl7+6Znsfu3fJBvseTux5h5ttvAaoxJ2r9amd8Mzh
cu9eh/L5/lBgXqqXN5CFcMqadkdMjz76G4W85BXbxrIiEBxCvYpNsxebE+qr
q+NsbK0uXnkxZgL9UMk+A0wPHok0f4/mJDHq60nK0p40K9qHtxolJhTiZgMQ
9q0L2UQkLkYg2kAvjc//ku5h04mtcpAiILGPpdnc+7mh5ufb2KSlkE7HC9jt
CEgv12TYMXm6A7exsRG6TTxL1WcGBsFnwevNWxkIJ/GHTtj3sHvta9zM4x1V
VfViD5zG9vwlP8ats1ZFhfz7bAK/Trqvn/3d+/LjJ9N9wkoOHGp25Bhw6Wgb
NYKnwL3Yhtt3cr1xcJ9n+Ac4Cz9rb4Fbov/g98dOxFpZo8qJ/2tJGXFy3y9l
Dsb3lpR55lJXh1M5UZN9B+FPg3ZkI/gAioCkWXoObdGLQpJe2H9JSZZYVCQl
6rEiFFvE9qLoRZLlleYVbGHX7P8xAV0B+cUqDgaZ8HRWKsXdo3X92seXdyei
hnrnNfDJxUlJDD6sIuuFfRVr52rgYx7v+GqbALMzYa81czT4ucJOTnj414eP
20uvB/SkzbUb3x0c0fMUgQ/+GlrYvSfas29NCTMDdDYBTslHSaU5spfenS81
ZITVhctJLq5ox42jTfySKbQ+LcgvA4dTV+TkSA8bBQNm0PwwgmBq41tqznQT
ton/5e+kNOEWyWgaX/G/2iT5NrOUaY4t71+xBLozyVEem5Bk0rvRFZCmb8Kw
zvj7sBccXhNjbG/cooiBCVNwWz91ERWHrthHWZXxhw21g+DGZHzM4wXZmWU0
8ecT+0opSXnU1+M0WmeJkpQUd2nZ9uZh5MZNsrt9N83bh88X3BGdj/KsLLhX
K9TQCIczlqSmesopaC1Z0V5fcLj/X1ZwCA6W8C3V1fXSwt/G924tmzX6N/Fn
9xzB33l9auod2cAp8fp0CER7pNm0iMBWTv0SwVgSem8RfEtIp83O6FDTe61v
3zNMY3rfAF0Bqa3sh/XEZdNU2L6iDqHef/3lzj3enYia3MhI0V79sJPqrF7X
4RDe+n30qJ9VWfGxkLuQyY26qv4wqyf2OvancUpSMdGm0VJdXByg+Up3zXq6
z8oXYyaA4UaKhyeadUEQCLw/TfYewPO8hd+/u0lKtzeqEu878POV6+3tBOwK
/Igv2LvegNrLrZih6uPO8wqSsEa2yG+9cVtEQyBYp7YgLS0tu6A9bVhb0vx+
QQlre07pCkg5UTesDwot0WbLVKZI9fRqXb/GZf91I5n8atkqGJqeHxfX4SFu
TonQI9XUNOBgJBeJCMneslSHJsEjzjsWO6SpqSnJxfXDiVN08y1LDx1pdfFK
sqsb/gUuEYi2eL9Uhg6EkDzSYAj89dETxcnT6SpJ7RWrfVXUKnJy8DeMcIAn
0VMPgMVnm1/dxR5cs+NpGH9pejqsjqo6ez7K+YDoUtAVkMJ3HLAOeFDIkHen
bs0fPm4SPtNKnnIK0NO6S8syc0hYUBZ0R7nZApOuoaqqHvyIo38Tp17WAb60
rLSGaNNaKcvMdJeSeTltJt0ZFfO/jqP9Agh+oyQlBd6lkebviTIDy0jw+ep1
yYHD2nYfkd96v9n2Z+gbwy5YLTE9teTwViPqUfMfk5RcHHk4NxugpQ2/eafH
wrw7EQLBb9AVkLfOWmFd7+whcx6dt3n9etwkSvQILvnDCxISYMo1zcXLaWpe
t0dyYhF0RPExglHXz98rbcUMVWoXumnRq2B/PALLmYHc0BDzyertrr3gMUf7
7Ove683WHaGGRii1GoJv0Vq6ErtdwRiHaFuae5PnC3m9dRvF+w1qqyQlBgz5
dP4Snvl1+QQT/ZDpQ2SpfeDNM1YlxdW8OBcQ8/obhZ7/zCSWFRLa8TEIRKeA
roA8fcAM63R3zlvz6Lxg+Ay9XKqnF4/OAgF6FfhYuIMyOyyMyQOLi6iK8njz
tigP59TUNDy/70g98ThlgLSmog+JxBfrvwXx8Y4PHr0YPb7tk05h0jQXUfGS
1FSibUQgOsBD5gWUZw01/DKlX1dZGW7yDozLgH9r279UZs0DOrNLLW3nZJWf
2POOWkPOG6Ng+5EnGWILf/yAAl5j0VKg6nlxFgSC36ArIPdveoP1uGf3HHl0
3i937lHWr3Gpf+2vrgl9qfPT58wf2FwW/Kf/waEsOCcE+2fQ1Gj4a/vbjLRS
ou36X31VVegbQyjgqV+ivfqZ/3X8h+NXtDUGISgUJCTAGzjWildDbLapKiho
bzOaSI8+JnsPxNt96TrdzcIkYtYIOWqveP7I+/w87q/seysqwe/ZTUKK6+0j
EHwIXQG5+Y9XWF9TEHfnxUmbmprkJ0zB+prtzdu8OAU1JampEgOGYKdTm7uQ
1bC6aYMpSyEfjCN4ZCGH1NWRJB87j+nROvE4daCMoXYQ0Xb9Lz8uDvy+koPo
hGmpzVvko6QCHnZE24hAsAzcDW1x8gzRtrQLELpfHz2hW7ZJccoMD5kXnBdk
FAgK8isvHrOgKbz1/m04d8/SSCZrr1xD2WDVu39edDR320cg+BC6AhKmZtVV
9efFSdN8fKErS/Hw5MUpqHm7ay+MLc/wD2D1cJh8W0+NJ98Gh0SEZK+fr0nt
Hg9sNkxL4WGW4w4BvjTW+vObrTvaPrkkBw61ungl3Y8fv0kEgklcRMSw+1lq
yAhSPc/zDXICmUSKt7UzPXik7dI20Dkf/j6Z6uVNtI14YG8dN3+cIrWfPL7T
JCeLm7HWQDSCr5SyHX7lmq4zzYvostAVkDD82NyIy8M0DPu795//TO7H614W
af4eOkxwXjZa4PV8LNuQSGRFCXfquoST+0vrqQcQmGG7qrDQ84U83RwjumvW
h7w26ILbQhGdj5yICHhjJ9g7EG0OU1Tm5XkrKin/Pqdt31Sf/0eQrn6nT0FT
Vlpz57w1tYacMfQFd6ci3SSk4Lfqr67JxZYRCD6krYAE8gPuwnD4HN/egWwD
2leYOBXrYjbXb3K9fWpqSkthrW2FSdPYUy8HNhti38bTu3z0pEhMKNy+Qpfa
Ge5Z9zo5kbBi0Dnh4Z/OX2qby1Fy4FDwK+fFxBBlGALBC5RmzMbucKsLl4m2
hQWA+010cjY9eESkRx+ario7cqyLqDjQmUTbyFvcnBJpqh+ePmDGrahIckMD
rJMrOWhYWWYmV5pFIPiTtgKyvKwW9ixeZPJP9/OHLivZzZ3r7VNjffkaPFec
jS17jcAigDfPWHHXPPbA8uVO6icFf6YJfSQ1FX0IWTFpJJOjLT/qb9jcdlpD
dfZ8PzUNlJAH0Sn5+ugJdp/LjBjDZE4wvgJoGxcRMZhLrXVdu88AIIk7dwhf
ZWXdg2t21Bpy9kh5GwvuDHKbH3A/610Coc6VNhEI/qStgMxIK4XdKiqc+2kf
oOOVHTWOp+VF0rx9YEc2O3KM7XbuXPiMfRsn95ly0Tz2yM4sO7LtLbXrE1qi
TUiCyuqiIk85BYVJ02h3ev7W+93+Q4nO31CtakQnJjMwCN7zSS6uRJvDJuSG
hqgPFnS3bBvu2PXjqxPRBvIQN6fERROVqH3p5b8ti4u4kCvS5vpN+DXy4T59
BIJbtBWQMZG5sEPxYi+Gyqx5OCz9kOrr1eYupAS6Dx5enp3NdlOi/33Fvo29
6w24aCEbWJhEzBj6Av46Y3qIyzxzaWjAO8djXkyM9eVrbRMXSw8d6fjfw5IU
ntefRSAIpzkU5+foyfbGLaLN4ZQM/wDzo3+3XddWX7A4xOBNZy0IVV5WC6tm
jPpZ7NX5y3cOm60tK4NTu/ITphBS8hKBwIG2AtLfOw32Jq4Mx6gpiI+Hrine
1o67jVPjJikNTxSgxVFF75eSHti3sXGhFrfMY5WiwqrzR95TO7qVM9VwLi4D
npjxdl/ebPuz7WSF2rxFgdq69VVVeNqDQBAL3AwI1ELnmG8vSU11uP9f27xb
L8ZMAB61qrCQaAN5wlfbBKAbqb3roxtfamo4SgYe8/ET/PbwKbWGQOBPWwH5
zf477Edcn92C1agl+g/mXRGHwu/f4W4OndXrOAwO1FMPwL6NxZOVuWUhSzja
xM8bo0Dt3x5et6uuxi95SF1lpb+6Ztv9myK/9TbZeyDpmwtuliAQ/EOqpxfs
C+m+fkSbwzVqy8u9Xyq3zaUg3m/Q56vXCxL4up4CexQXVV86/kuuyDVzNKLC
OIrgMtl3EPrJjIBAbpmKQPAPbQWklXkU1oMm9eN+On0YbMPT6GIDoW3YWUR7
9cuNiuKwtfdvw7EvZNpgWa6YxzwV5bW3z/2Sd2LhhJeuXxPxMyA31+mxsNTg
4bR7qwcNs797vzgpCTdLEAh+A4xMYV1Oh38fEG0OlyGTSFHvP2ivWE274tC9
Fxg28nr/IyGAZx91jNC4XhJqct5szz+UpqdLDhyKfWnN9Q0FcKcVAsGYtgLS
SCd41M/Kodw9F1AjcFdLmNFb7jYOCX1jCH2ds/Azzht0tImnuJTuYnjudPZ2
S4E5zLHX1X8+lpbgVHu3ODnZ5toN8b4DaR4fSjNm+6qqo73VCATg85XrWL94
OfV3om3hFWnePs1pf37rTeMKtJasCDd518nqPmdllMG8bbAuA/gje635qqjB
r8tTjsvPUwSCcNoKSA0FHxhlx91zBevpU6b0e/SpLuJJxsKqggKZ4aOh1OHK
KrmvRyp0JmWleOi3mpoG4TsOQK/C884aIWdjiVMqxdzIyA8nTrUNpzfYsj3O
xhaVV0AgIIlOzrCDZIeGEm0ODylKTLS9eRvWhIUv+QlTgDTqTCNK4OLU5b3H
95akzjduZc7OSlYjmfxq2SoYAABG5Vy3FoEgkLYCUva5K9Zrti3X5e65jHfv
w7rS601buNsy5NP5S9CzcSs2LzqidVt6RlopV9pkQHxM/rp5v5QmPLnPlFt5
bhmT5uMLf6PWQMcefYCezIng0zrgCASBkBsapIeNoqx3PH1OtDk8p6akxPOF
vPz4yW0zMLiIioN3iTaQa0SF5aydq0Hth+9e/MxG5DkYVsDBuNGfu3lhKgJB
FG0FZPPcV0t/ObTFiIsnqqushBtbfJRVudgypLnE9s8lcouTZ7jVbHpqCfQh
QExyq1m6mBqETu4vDU83dZAM+AtPz4gBxPbrzVtpY+b7DrS5dgONmhEIBnw8
cx7rL6pzFhBtC04A2RxubKK5eHnb0GinJ0+rCgqINpA71NQ0PL75hVpDrp+v
mRDLctJdh38fwK8o6oMFL0xFIAihrYCEebHOHDTn4omo0xrwQpM0kskai5Zi
7UsNGcHFglylJTXQgfh5pnKrWRoqK+uunfxI7az2b3qDx4SnrZ3OqrU0DwKp
wcOdHgt3+qJmCATnxNnYwo6THxtLtDm4kuzq9nbXXhrvIdF/MJBMFbm8HWvj
xjf773NGyUO3DAb4pm/CWGqhvqoKbmmXHz8ZpYVEdBraCkgeVe6zPHWWsh9t
4RIuNgvxVVWHHoy7VewbGxthOKKjDfeLg/+vZZV81Sx16KNG/yYuL+bG02hD
0DgYC2v+sYzG+cuOGuchK1dbxmbQOALR1WiorYWbbd2lZIg2hwCyQ0NNDx6B
qz9w/cLu9t3yrCyireMCudnlYDhPPbq/cfpTVRULy9mx1p/hN2N/9z7vTEUg
8KStgDy81QjrI8K37bl1FjKJBCOFvj0X5VazkIqcHJhqRnPxcq5XSJw6SAb7
Tj4Ycz8U0FA7aGLf1sLW88cpervxtphLrJW1+oLFbYPhfVXU6qu5nDoegej0
vD92Ajofom0hjNyoKPA90GzWFuszwPbGrbIMXEse8AIyufGFiCsY2kNHvXq2
ekwkC7OsJnsPwKjynPBw3pmKQOBGWwG5fYUu1kFknnEtQXSymzt0KVnBIdxq
FmLxz+nnP3OUpfv5c739PyZRSqbqawRwsdmK8tqLx37JXvvX9rcF+TzcL/Pj
q9Or5atopOPLaTODdPQ6a7UyBILXRL3/wNP4HAGiID7e8tRZmhwOYr37f756
vTQtjWjrOMXTJZm6Zg0Y+BvpBDN5bElqqkT/wdgXorNqbecoXYTo4rQVkHAt
VV3em1tn+XLnHtZxFCZO5VabEGp1anXxCtfbB2xYoIV9J0pSHtxqMywoa/l0
VeiLxvQQV5Hx5J1XSfHw1Fu/iUY6qs6eH/bWGGW4RSA4oa6yEmZM9VZUItoc
4ilKTPx0/pJoz77U3ka0Vz/rS1eBjiLaOo7Iz6s8su0t9aj/4jGL8rJaZo71
kJWD3wYYs/PaVASC17QVkHCEZagdxK2zKE6ZgfUa2xu3uNUmBrmhQW3uQqxx
meGjeZRecu96A+w7EXvgxJUGtZX9xvWSoK4v4+/Fq+F5RkCg4fadNNJRafos
IB25vtaPQHRNYN063TXribaFXyhJSQGKEehGmtnIL3fuVeazvJeZf2hsbFSS
8gBDfujAl09XDQvqONqT+mklPWxUp9mujuiytBWQMI3MJzNOiwBiZIeFQe+R
6PyNK21CYHHt5jGdrj53G4ec2PMO+07uXbLhsKnioup/9ppSD2BB4+CPXLGT
hsyg4LZ7JOUnTAGD305WPwKBIJYwo7cwiqY8O5toc/iI0rS0z1evA91I7YUk
Bw51ERET6PTjfp6pYOBPXffwlZJvh0tIKe4e8Ev4eOY8PqYiEDyCRkCSSGTY
I5y/fOfKKVxExWF2He7qlrKMDFgZQXvlGt6t/179h5Jg5+LRD5y04++Vtmii
ErXP0XrZsc9hg+zQUBizDV8vRo/3VVFrqGVqtQWBQDBPdXExXLENfKVDtDl8
B/DVNtdv0sxGyowY4/1SWXA9Ehj4w7kF5mcDLE+fg99AqqcXPqYiELyARkCW
FFfDvsCtRVWYnvHDiVNcaRBidvgoZV/bb715Wkfs0Y0vcJMLey20XfVYNk2F
mVUPVsmJiHh34DCNdJQZPtpDVq6+qorrp0MgEBgGW7Zj3c1w+06ibeFTipOT
m7fY/LpTW2Hi1GD91wIaTgOG/6+UfGnikRinC67Mz4c5SdTmLUKLQQjBhUZA
pqW0Vl1hKUdBe5SkpEBHwd0k/N8dHGHLtjdvc7HltkgLf8O+kx0r2Yl8BmNS
2rjrox+YjLtmnpLU1A9/n6TJxgY8lbuUDEpdi0DwGn8NLbhbpKaU5yUABJfc
qKi26yMqs+ZFW1gK6N7ktjsi1eQYbUEN1NaFF+75Qh43OxEI7kIjIKPCc2Av
yEzngg/0UVZ9/jMhGBdlTENtrdKM2XBlltfuGngD7DtZM0eD1WOjI3KXTlVh
L/MDk4DLd3zwCFaKhAEDruKSKCU4AoEPZZmZsPdFvDMl2hx+J93XT3/DZhoZ
+WrZqkQnZ6JNY4fyMtqcbGcOmleU058laGxs1F655vnPwj2dIE8momtCIyB9
PVLh/c+VKTL9jUJYN3m7ay/nrUFcxSSgzwk3NuFiy3R58yoI+04WjH/J0oGf
zKKoa1sD/Rkbxc36gKT6el8VNZnho3+RjoOHu4iIoTkQBAJntFesxvqg2ZFj
RNsiGHx3cGxbU/v15q0Z/tzMuIsbRjrB1FUhVs5Ui4um7/Czw8Jgtkx0tyAE
FBoB6WgTT7n5u4txXkqvqrAQ9hEubpEuTkqCWdeAQOVWswywfBeJfS1TBzJb
qoxMbhR74EQ9ID17yLyygpvJuqMtLJWmz6J2vKK9+tndvgu+di6eBYFAMAlM
9CcxYIjg7g3Bmaampkjz98q/z6GRkUBWAVdPtHUsExmaTb3kNLm/9EfTSLqf
tL15m3f5SRAIHKARkB+MI7DbftpgWc4bDzU0gptcKnK5EFGJAVPTiPbsmxcd
za1mGfDVNoElXU0T9Dj6N/GXkh5cDO/JCAjUXbOe1t8ePlr44we3ToFAIFil
ID4e9sc4G1uizREkyCRSkI6e/PjJ1D5NrHd/xwePBC4Op6S4+vguE+rZgye3
7BsaaHcJ1ZSUyI4a9/xnTQdSPQvFtREIfoBGQOprBGA3/B+TuFBPAW4H5mJy
3ZhPVtC9AN/CrWYZ4+OewvzKfnRE7rJprSPQ6UNkuZUQCVCant5ct/HXnTI6
q9el+fhy6xQIBIJtgBLAeuWncxeJtkXwaKip8ZJXhJuUsZfsyLEBWtqCVTCr
sbFRQdydunb2rjX6OVm0eS9DDN607qaRUyDEVASCbWgEpLK0J3a3b1igxWHL
9dXV4v0GYV0D+AQOW6O0WVWlMGna858JsesqeVg2mprI0GzoB7IyGA2HLd9F
Ugc9rpunmfyDO8VxwMV+eyYCv9LnPwvKcHdvOwKB4ASnJ0+f/0xyKKCpaQin
prTU4f5/NEkj1eYu/O7gSLRprOHi+GPmcDn4OJg3RsHf+5fkeE1NTWD4D8Me
yjIziTIVgWADGgEp/pAStrdn3WsOW461/gz7fuF37kzBOT0Whm1GW1hypU1m
SE4sgk4gPoZ+Ea6GBrLwbXteBD2CwWzIawO5sRNpNll7KyqhVQ8Egq/IDAyC
nTTF3YNocwSYosRE04NHaAJ1DHfswidsiVukp5ZsWapDXTyCpkZwdmgoTIxp
fvTv9tpBIPgQGgH57xVb7D7/e/c7Dlv+ePYCHDly2BRGflwcHJMCN8KVNpmk
IL8SeoBgfzopF3Kzy3evfU0d9KgkxZ2gR/AM0vxj2S87ZXr2tb1xC+2UQSD4
ENDr5SdMwbrqlzv3iDZH4AEOUGvJCmoHKNKjj821GwJUTbu2tuHOhc/Ucwv3
L9vU17euyNtcvwmvLsnFlUBTEQiWoBGQl45TMlldOcHR/F4jmSwzYgzWI5yF
n3FsZjMGQtue/0wpifNuEeABYN93c0qkedfPM3XeGAX4gZnD5VwcuWBecVKS
6aG/aAbgb3ftzY+N5bxxBALBI+DuWsXJ04m2pTPQ2NgYamhEs79GavBwL3lF
Uh0381rwlNeagdQFa3at0c/LoSRGbt5NM3IsZTfNnAWoNg1CUKARkMd3UvaO
Pbhmx0mz1CXjMwODOj6gIyJMzWCDLiJinDfIKrDv21jGUP9dW9lvbM9WtyC0
RDstpYTDc9WWlTUnBu/dn9phqs//48dXJw5bRiAQvCbpmwvstlkhPCyx2qWo
r6oCnp8mCPzltJl4xjJxiJ9n6tzRrVMNC8a/hOtZwfqv4UV5KbCWbRiBIAoa
AQmGRdi9LfmYo3IANtduwq0unK/k1paXwwhA4DEaamo4bJANZo2gxEKbGlCe
CFVV9XDCFnvdPmddW8vR4LGRTA7S0YO5HeAmxMBXOiggH4EQCMgkEtxH/O2Z
CNHmdCrKMjMtT52lSUOhv2FzblQU0aYxRVZG2dZlrSGRE/pIvnvd/EABT0lY
m0Zy4NDyrCyiLUUgOoZGQK6bp4nd2CqyXpw0K9abUlbvIzdyWTjc/w/6ini7
L5w3yAYwM4+Oit//WoqGb1igBf3A+N6SNKHRbJDu60cb7tirn8O/D1BNGQRC
sLA8fQ4uHBBtSyckMyhYb/0mmshw+7v3a8tp8+TwIbW1DTdOf6KeeXh88wuJ
RM4KDoG7ad4f/4doMxGIjqERkAsnvMRuaQOtQLbbzAmPgP06QJPTdEB5MTHA
OWCtvdt/iMPW2GbTolfYN6Mo4e7vnTZ7pDzs/osmKoUEcJR+oTI/v3nP0a/D
anCxKDE4AiGIUKerLUlNJdqczkm05ceX02ZS+0y5sRPDTTjd/okP2sp+Y3q0
Zok8sNmwqLDq89Xr8FqS3dyJthGB6AAaATl1oAx2P1u+o199iRncJKR+TqD1
5zweGO6dEe87sCQlhcPW2GbvegPsmzn6p/H43pKw4x8UMiwsqGK72UYy2V9d
U3roSGo3qLFoabKrGxeNRyAQeFJXWQljmP01OB1EI9qDVFcHHjc0gZGCsqLt
6ZIMI6PAa8kU5WCPOLj5VH3+H4KVOx3RBaEWkGRyI7yZnewS2G5Ta+lKrAt8
+Pskh+ZFfbBo3TsjKs5ha5zw9+531IsO2OvhdTsSif3QxOY168XLf9laOGSE
n5oGCndEIAQdw+07sU5t9Oduom3p5JSkpr7bf4h2Rfvev/y/op2WUgLXtka1
FM7WuyQGr8JHWZVoAxEIRlALyNKSGngn+3ulMT6wPcoyM+H9H2lmzolt9dXV
sO6M4pQZhOydgZw/8p5aOo7pIa6vEcB2a1WFhZ/OXfxlzbp7r49nzlfm5XHR
ZgQCQRRgJPj8Z9qx+ir2FykQTJJg76A0Y7bArWhXVdX/+nARFRk7F6YqQk8E
BD9DLSDTU0vgbRwTmctegwFa2nADSG0Zo6p/HeL89Dl0BbFW1pw0xSHgm5k5
7AX8cmYMfeHunMReU01NTUG6+jLDR1M7Os0/lqFi1ghEZ6I4ORl28LjPNkSb
0yVoXtGWlBa4FW3wUHgp6TGqO+X5Mr/bpWc/jf945jzR1iEQ7UItIKPCc6BG
ykhjc+ev4Y5d2J3/ZtufnBhWlJgIRu5YU4bbd3LSFIf4e/2yZWZiX6nEBDar
wOSEh8PKp3DN2l9dE61ZIxCdD9U5C7Bubn3pKtG2dCEEdEXb0SZ+6iDKHoS/
uv1Mx9G9V7qvH9GmIRD0oRaQPu4pUCaVl9Wy0RroodwKHTfevQ/OZBbEx3PS
FCeY6IdQlw8Ar3XzNNlop66iwv7ufZEefajdmsXJM2iFAoHorDg+eIT1dPnx
k7lS2BTBPHRXtCNMzYi2ixHf4wpWzlQDT5lJ3R487DYQM1tryYrGxkaiTUMg
6EAtIO2t42ApZ/bcXdT7D7C3lqans21VvK0dbOfrw8dst8MJZHLj07sObTfO
LJ6szGpTUR8saOpwqc5ZgLI0IBCdmxQPT9jls0NRSRq8obtH22jnntI0NiP8
caCstOboDuPmombddkObA1/pEG0XAkEHagFpZhgGY/zYa83in9OUoL7Fy9k2
CfR6pemz4Mi9rrKS7abYBvZi7DW2p8T1U5TUr9OHyDLfTklKyttde6ndF/Bm
HrJypPp63hmPQCD4geaSND8zdAElQ7Q5XZS2K9oSA4b4qqjx7bQemdz45Jb9
6G4i17uNp9jcd1hlQQHRdiEQtFALSB0VP0wjLZ2qwkZT1N7SVUyCbZPcpWRg
TydkxSHpe+GqWepQPc4cLufpkszq9Cy5ocFTToFm8Guy7yDKKoxAdB3eH/8H
6/vaK1YTbUuXJuGLveLk6dTeWHvlGn7eXPPmVdDiHhegtXcmba2sqCPaKATi
F6gFpIK4O6aRhBZrs9FUkotr63pNWBh79pSmp0v0Hwx3z7HXCCe4OSXOGNq6
4XrtXI3kxCLwd2+31gDRDjtyuq+f+oLF1M5KYdI0tBMTgehqhJu8g7shUMAz
sdRVVn65cw+WC8QC7J2fPm+oZSfgHwc8XZJP91qKmfqsW69dMx6np5YQbRQC
0Qq1gHx2zxETSPs3vWGjKbvbd6FYYtue98dOYI2I9OiTG8l+NRz20FPzpy4v
dXyXSUU5xbdEhGTDv2dntpueqKa0tLkcFVWCR3AhDvf/I2QhHoFAEEt1URFU
LKFvDIk2B/G/jIBAjYVLqEf3KrPmpXp5E20XfaK8op90p2QjudxtypyRckF+
GUQbhUBQoBaQt89ZYwLp9AF2Fo4Vp8zA7nPbm7fZMwb0Ytip2W6EPRobG4Xv
/LJlRvS/r9RBMsmJRfCt+Jh8uo3E232RGzeJ2jW9Wr6K7clYBALRCdBduwHz
BmaHjxJtC6IZckODu5QMTBOHzQ/bXL9ZV1FBtGl0cBZ/Ae1c2+3wxL5Sth9j
iTYKgWiGWkCeOWiOCSSgJFltJyciAt7kic7f2LAEqDWtJSuwFmSGj64uLmaj
Efaorq4Hmhnqw/G9Jc0MaVVfYUEV/ECgL+0G85rS0o9nL1BLR8lBw5oTPPJr
nDYCgcAHD1k56BPQ7jn+oSAhQX/DZppAo4Qv9kTbRQuQu8ozKbVp7ncbNq6b
8KjuYlovUeEJBPFQC8gDmw0xgfT0rgOr7bhJSD3/WX0J3PBsWBKspw87Moc5
JFmiIL9y+wpdKA5njZAL8KGTgKi+ngQ/4+Lwg/qt7w6O8hOmUDsis8NHy7Oy
8LoCBALBv+RGRUHPkPTNhWhzEK00NTUFauuCZxa197b453RVIZulInhEvN0X
aN6ubpuxx9Djm1/IZDRBgSASagEptFgbuzPlxdxYbUdr6Urs9n5//B82zKgt
K5MdNQ5rQX3+H7hVZvkRX7BsmgpUhitmqCb/KGrvwxP7SmEfs34fTTG7vNzq
wmVq5yMzYkzU+w/4GI9AIAQCuP/3y517RNuCoKUsM9N4z35qNy47cmykmTnR
dv0CLPH2pFvfad3uYU+ik/tMq6rQnDaCMKgF5NKpFCmlo8Ja7aTyrCzY9djr
dw7/PsB/kO7rkfo7VYXrXWv0iwqrGHx+7mgF7JNvdYPBfxOdnBUmTaN2O6aH
/kIbLREIBA22N25hLuLltJlE24KgD3hyAd1I68/z6Ye7409+bKxoz76YYWd7
L4GPra3LdPJy+TF0E9EVoBaQMH1N2whAxsDVZ3CH15SyXES7ICFBtFc/rIV3
Bw6zejh7WL6LHN9bEnbD80fe19Z2sPKOFZkCLxVJV+vL136ZeBw+ms+LZCEQ
CKL44fgV+gqgBIg2B0GfqsJCWAsDTkXyz4qS3a070LAdE+/Bh9eSKcoJsfwi
dBFdCiggm5qaRv9GyWBjbx3HUiMwz//rTVvYsAGWvRbrM6A4KYmNFlhFRcaT
ZsM1M7nBty2nhEruG3yY2smAy6/IzcXBbAQCIYiQ6uokBgzB3IWnnALR5iAY
kfDFniam3fyv41V8UAimurhYZvhoSqDXouV71urBR9iMoS/8PFOJNhDR5YAC
srysFt6NPu4pzLdA7Ru9FF6yasB3B0fYT50eC7N6OKuQyY0Pr9vBKx3TQ/y1
ZiCTxx7cZEBJtP6zSqn0sFHhxiY8NRiBQHQCTA/9hTkNvXUbibYF0QFts2rI
jhoXbfmRaLv+56+u2brVVEf/4jEL+Cyb0EfSxiKGaAMRXQsoIDPSSuGtGBWe
w3wLv6zOxLE2dUluaFCdPR87Vm7sRF6n4aqpaaBO1zNlgPRX2wQmj012c1/b
/wKlPE235hlI4z37y7OzeWowAoHoHIQYvHn+s7JAdVG7O/UQ/EPbvL7vj/+D
Z365tpBJJLW5C+ETs7a8XPyhU+tqWneW9y8gEJwABWRMZC68D1mqlwQDM9iI
D/dRVoV9M9TQiNXDWaK4qHrXGn14jXNGyYcFMZVpp766uvkau/da1+0Qduyq
nqd5bS0CgehMVOblwQJVaNlCUKgpKbE8dZZaQwJJSWyuyB9fnWjW7PTUA2D4
GfMRWYguRkVaEjXZv9bvJCWFupoaGppauqaxMo0HBaSfZyq8A0tLaphvAehG
7Ga2u32XhRP/739VBQVSQ0Zgx2qvWM3Tex5I4tWz1X9J15PI1CRAZmCQyqx5
mJFC3XZhh+9ZrcM7UxEIRKdEZ9VaSkzd0b+JtgXBAnGfbV6MmUAtI60uXiGw
bA1MOtS8ayA5GfzF9mMszDIHXpf/tqyvJxFlHoIPSTK90u0XhEJb799snVPN
f1p04NSilrcs45m9t6GAdLSJh9PgzNdPyY+NhX0KjIxYuiKbazee/ywjle7n
z9KxLBEVljN/rCLsXNtX6BYWMErXg0EmkVxExUV69IEXuKc3RUBuWYoEJAKB
YA13KZnnnFVbQBBFdVHR+2MnqDWk4pQZKe4ehBhDnbfE9NBf2B/9vdOos9Id
FDIsL6tl3A6iq0CKp5WP8l7wTS9JIfCXK4ZRzf8p8TrQ/P6B0DYS0tPTc9Kk
SRN+ZfDgwf369QP/GDts008BKQz+a27OVDpHL3lF7DaWGDCEVFfH/AUB5Qm1
mcXJM8wfyCpuTolTB8rAbnVizztmMq/mx8W9WraK2l0YbNn+8tkXOIHJO4MR
CESnhLreKypJI4hEmr+H+6CxqQ/7u/cbalhYsOMWDvf/g2akelLEQEJs/uLJ
yvBht3GhVk5WOf62IfiNJEugH6/Et4wnSC20vpft2DLreCrq52gjtGU68oBa
KE0jDQ0NwcHBQb9y9+7d7du3g3+IPbLE7rrZI2XBf6uqOp6jA+hvFGIvf6PR
zj3YgeL9BpVlZLB0LPN8NI0c10sCdqi7Fz+TSB3UuGlqavJVVRfvOxB2T/Bv
XxU18HcT/ZCfX5E8jwxGIBCdGFh6AAgPom1BsENFTg5N2RrVOQuyw1jLnMw5
NaWlMO35q2WrYABYbnb55j9ewUce0JPf44hPQIQgElLSvZYFajVL16QS2sCG
eMOW1esDhnDGsTZKp2WS8ko8E0EQcAlbQ8GHskNkljqTdtWUlMDc+MH6r5m+
nuYaLrD3fXsuyvyBLKGr6j+qe2uyR2bqM5ZnZb3ZuoPaOYC+CbeW21jEYE2N
7y3JI5sRCEQnBpakUZo+i2hbEOwT8tpActAw+JgQ693fR1kV560r/hpa0IBw
k3fw7xXltYe3GsEH38zhckF+vJqiQfA/8b9GP17RcaVana6g6Eed1vnG2iTT
lg8eCGAiEBIKSDlRN1YD/CLN38MbmPmENo1ksvqCxa2peyormTyQJaSfulAn
ezTRD+nwkGgLS+lho+AVifTo4yIiRh2q5Po1EbbZYdkaBAKBoAGVpOk0lKSm
vt68lXq2wWjnHjxLH5JJJJgET2HSNOqV9Pp60pUTlvBpNbm/tJMdswnrEJ2L
Wi9DeWHhK0KLqETkKZ2feXYqDLGQR+oF69qoFlHZTS2042w8UECK/PuVUmZl
4xsmLbM4eQa7e7WWrmT+eoJ09GCPA+M45g9kEjK58f5lG9h3JvaV6rCwTl1F
BU3aWJVZ8zICaBOMB/tnwGYL8nmiexEIRCcGlaTpTDQ2NoIfEe5nAa8XYyaw
upmUE+JsbOGp3aVlqd9qamp6ds8RPrDG9pQwNaCNakN0KUrSAlq2y7TMQ5rG
Y3/TaRGQp7AdNBi1oWwISCi6/t79rsOj/tcykSgzYgx267qIiDF5CUCqvRg9
HjtKY9FS5rd7M9t+HensIXPYa6YPkfX1SGV8SLqvH8xEhL0+X71eX13d9pMJ
sfmw5eQfKBUwAoFgGdODRzA/o7d+E9G2ILhAZmCQ0ozZ1DtrHP97SKrveKsm
V4CzoJKDhlXm5dG8qy7vTR3HpSLjiY9VCH6lQIeSqkenZYGaIiCFHalWkNma
gYQz3peOWzBjR5qPL+wyoAcxab3Tk6et+xBdXJk8ikkqymv3b3oDO8v8sYqM
S+o0J+oREaNO1CM7aly8rV17n8/JKoeNR4SgGjQIBIJlUEmazkddRQVNvnGt
pSsLv3/H4dTZoaEwQf3nK9fbfuD92/CxPVt3kj65Zc/1eRuEIFER0DINeS+p
eY9MBSYghaiWsEmUfdnddKI6DoKEAvLkPlO4VZkZK5yFn1Em7UePZzJ4uDQt
De5uNtl7gJlDmCc/r1JosTZ1qvDUZEY1p/7f3nmANZF1YXh07brq/vbeV10V
e1ldXbF37JW1i12xiwWkKFUEREFQQQEBERRQEZAiiCIYQKSplCBFQQ0aSoDg
7n+TCZchCSFACuW8zzy7kpnM3Mkt57vtHEZyMvbrSx63FywW7MFRyWUW4vsH
+1chXDgAAAAJhKSpr0Ta2VN31mi2boc6CzJ47r2NW3CX5HOMkHDYTx+/79Na
BxuvbavvgpvxBgx31FHBlLs5n+mgzL8Gkkkjd2ELcQUpCBaQSxVtyNJ16uBj
cRJxecRostC6bt4mZrqd124gv6LepEV2fLyY3xKHtNScCQNNcQVBShLpSRHX
Rzs5a7f9X5mjnpa/hppfrfQpSCfjiFGVrqsEAAAQisWEP8mWx2n1OnmnBZAk
35KScOaeKY06VJCTI9WHfk9L02zVFm/kEXoN7VXa4I762ESumWdXUAD7QBsm
DFPFMr89dHdVchs2VotM0o2PoqU4Aa2xgJw9/hpZtM6frtzDbU5qKq4gb13u
iZPojy9D8Vc89x0Q5ytikvjuy8heF3HVWPL3TeaPCj3wF+Xnu21TKTfXMHo8
dtRTKf3bXSCf4nQrUkLJBwCgYeGvpUM2PjrtO/4sqcQzLVC3KGGzvU+eOtu4
GTYxhr3704OfS/WhT89q4Md98PYReg0ylGP6XsKGctHUGyIMJVBfYCXSgmiJ
Zb5AE93VkDy0wdPTTBo5iR3E04tsFxXODLaan1iL9LCA/HPIZbJcmeoFV/qt
0CsWvLHEpi3FDAlqOWkKbjMluPLnbdSnoZ0NcKX4R+lOYWGFg/OZUVEmQ4ZT
1eMj1cNVWu2MlaqVWagkkg8AQIMj/TUNN0EpQZW3t0CdI8k/QL9HH6pTOD8N
Tel1Fgpzc/W69uTtTh0xuqJVjp8yfkweehmby1njrn37KmS7KFBvYMXbkNuu
ldQsg0KDbLSUuFELy+3Hp3upcTdmuyAll+ilTw5IijP8+B9FQCr05Emj6+b8
7msEub1gMVlWb86cI85Top2ccVUKNjIWL2mVE/7yIzX6564N90QEmnl5+YpG
89Zl+2U6dk14+KiqT5w6/Ar5LGMd2M4GAEB1+Pfff3W79CAbIu+Tp+SdHEAq
5H/9aq+0nDpeYTVlWk5qqpQeF259HT9IRFyPr1/yZoyxxEbzr2HmnzPFGgIC
6iRsOnbdww1Ho+ISKmRokeagWhYmW9WGLvbINBaQA9rzlJijbSWTs0X5+Xgv
TMgl08rfoKgI+8m5OGCwpPwbBPklUYNcH9npUVG3qyAnh68i35gxm5kpaoN2
RSyYfJ183LljsnP2BQBAPcN18zayLTIfOVbeaQGkyKurluda/opNj85vnWLu
uUrjQcj84Y0JoiN0/PjOWvTXDeqG09QUMQecgLoIm5GRQadnZDNE9RRYjGw6
nZ7NqNqqBiwg8U5/j3uVxEeI9/DE1eHL+/eVPuL5xUtVXTBZKU88Enq20MZV
QIScy6DRqG4e1Zu0CDyvW20/Bmvm22G9Wt20AwDQ0Il2vosbJfHDeAF1kazY
WCztyMN91x5q4BhJQY0RLNo5c35+0ao5t7EBVeh58X08hMwGqgwpIFmsYlyW
/J58EP2VBzt3nykN11Lp/QsYjPP/60xef+3PvySSZtc70VTHVhe1Ayu6MszS
ijptbdR3YOqLlzV59PY1d8mH7ljrUpP7AADQkCnIycEeaKURkAuoVRSzWB57
91M1pNmwkUJd7tQQ23kLeU6EWrX9kZ4u4sqionJBN4Z00hftNhkABCEF5Ncv
ebggvQqpZJGGQc++ZBF9fOhIpff3OnIMV5nUkBc1T7CtZTj2pdOpkYaVqXBB
WJSfz+fZ1W7x0pq7Uzis4lGleD0AAABCsZ46nWya7ixfJe+0ALIg7oE7Hk4h
3ceFWVpJ9hGf377FHRPXLdtFX1xS8nPPP67Y9A9or1up9QcAKqSATE1h4FIU
8+aTiOszo6Jw+U/y8xd9c0ZKCh4AvLNidc1Ta6oXjNPZ5ZdzDjcjhF6WHR+P
+nfUHXDP9AzE9HYuGo2j3uTTF06pcJUyAABApQRe0CMbKO22/yspBqd8DYLv
aWnW0xSpIxvIMrK+f5fgI+7v2MUzfI2bIXst+mJkFo/veYitap/WOoG+iRJM
DFC/IQVk3NvPuAiJDuASoHNB/EavzHN405ZfP1QyM14pWid8cCK7N9NydxE+
/v/G0UmrTXtcPfW69Up5FlTDR2OMtALJBEwbcUVS9wT4KMrP/5GenhUb+zH0
VeJTv9j7DyJv272yuPbc2CTwvK7vGXWvo8cfqR6mHg8PqLrv3otaTtTpdlHe
dHfDRupxb9NWt20qD3bu9ti7/9HBQ9QvPj581EfttL+mdpCB0Usz83Dr69FO
zgmPHqcEBWdGRn5LSipgMCDyFyANqJ3x5IAK1+EA9YyfJSV+57SoIXSNBw6p
VOmJD/PTJ83W7cg728yeJ85XtE/6Ytvao7nW4weSDPMB1GNIARn24iMuP9lZ
omK4YHeOjivXiL5zWlg4jtiF7HtNEoks+JGdHjiFvVvpCF2oyS4q4ltnckNx
lujohFXFyvQlmYbRfSTmjKh+g/Iu78sXpAaRiXzrco920wbpNKQDvU+eQpl1
b+MWh2Urb86aazlxssmQ4Xpde2o0a0XNwVpxNOI4LzXqN+jK6PHW0xRvL1yC
ekZIrCLx6aehGWxkHHbN+s0dRyQ708Nf59DpSADL+1cH6gb63XuTZezJsRPy
TgsgU1AX1aBXv7Lp7BZtJLgUFvWI8Z3fPfYS5yuXLgRhC9u1ieY9hzeSSgxQ
jyEFJNJjuPCwWBWOK+ZlZ2MH+xG2t0TfGQ/Ua7frgCREtVNYXFyyY61Lpes0
kOG2GD+JavR91E5L3HHrHZsInAzJ3rnugnT7t8TEJP8AVCQCtM977j/otGb9
jRmzL48YrdulB7Wj3XAOzdbtjPoOtJjwp90iJbetO5BaRrI57oF7RkSEBL3o
A3UdHBXLbNhIeacFkDX5375hj8rk4bp5m0R2Z6M+LO6boKIlph20vhzaqRHP
znZufM7WMrzmKQHqN6SAvO/0Fg9fi7g44tZtskwiGZmblSXiyjh3D1wpnukZ
VDt5BQXFaxfYY/U4tLPB2yghSzQTHj2mLk5G/66Gk3BxeHQ/DtcviSyqrCuU
FBfnpKZ+fBka4+oWYmLmdeSY46q1lhMn63XrhceZpXSgwqbd9n/oQRf7/44a
w6vjJlpPnX59+kzqcXPmHNu5C5Bac1i6wnHlGqfV6/CB0nln+Sr7JctuzV9k
M3veDcVZ5b779wz0FuYjx5oMHmbYu/+FTt2wj1MpystWbS8OGGw5aQpKFZIQ
SF6GXrF4/8T764cPsBauQYFqEy4V3z9+lHdyAFmDjEjgeV1qLxv1u8Vxjlcp
r2/cxPcMt7IW81uOtpFdfjmHDa65oXQjMAJ1HVJA3roWjhWaiIuRLSYLJLK5
Ii4rYbNxxEBklItZ1Qy4yfzBWjztJi7Mo3obJ73nH71BfSvf02epGsZi/KQc
Or16T6yUYP9knJ76GkiU9eNHRkTEG0cnPw1NpzXrzUeNu9Cxq0RUonqTFjq/
dUJFAulAJJ9uzprrsGzlvY1bPPbuRyLqma7+K4tr0U7OH3x808Nfo1aU+elT
UV6e7H8BVIALGAxUij5FR6c8C4p74E6zsX1ubPJU/dzjQ0fub9/pvHbD7YVL
rKcpXhk93njgEN0uPZAmlIxa/qW5Ud+BSNm6/LMZFeywa9bvvZ58efdOUu73
gVoFqmvqTVuSWS/xDblAXSHJPwBHJkKH1q+/1dxhMsevuMIY8oai/Yrz4XEv
tnszLWzm9NQr2SoLNGRIAXnZ4DlZWiYMqjCyDLKq2u06kAUyQPu8iHu+umqJ
60KkXTXd3SB5NmeCFS7GkwabZaTxb1XL/fz5huIsqv312LNPqqb2DS0DJyn9
oyS3zsme4oKCDBoNSRSrv6ajpsZqyjSkhfDq6+oMrLVuZzp0BMoRp9XrPPcd
8NfURoIw5p4rPfg5kkA196FUy2EXFn5PS0Pa+4O3Dyr2zy9e8j6h5rplO5Ka
qFNTw6Has42bGfYZcHPmnAcqu4ONjOM9PNFPiqqkvF8aqCmos0Bmsb3Scnmn
BZAbzMxMvt3ZXkeP13AJFuqJ47uJ9ivOx1Ov971alsXp0FHzrUkygHoMKSDP
n36Ko6tXdCXqJeHSiKxkRZcVMpm6nbuTl10ZM6F687xIPc6bZI0L8Iwxll+y
+UeiUkNe4GUenF5bm/Zv7jhW41lVIjnxG05V3FtJbs+RNkhspwQFh1tff3Ls
BDJVlwYNxctZq6pk0M9uOWkKUomoiStb2vdN1OZ94D9ysWhSUnJAYORtu2DD
iygjXDdvQ/Ly6riJnDHeao3oXvr9D4elK3xOnYlyuJMZFVXt0X5AXgTpG+IW
DMaZGzKoP/jk+ElqNxN1xvOyaxQgppxf8aoEPHoZRO/X9gJoSEA0pIA8ue8R
WU6Wz7St6MrHh4+SRVG/Rx8RN0Q9HVz+K3UUKZRcZiEOOY0O9G/ByeLQKxZ4
6gcdpn8oZMfLwvPAt6/5OGGhz2uvz1XU7CT6Pg0xMXugsttqyjSd3zpVWZw0
bWkyZDiSmt4n1MIsreI9PNPDX6MmSOL7kgAScuVAzD3XIAMjj7377ZcsMx81
jrqyVyx5/0tzjqRcttL3jHq0k/Pnt29Bk9RyUB7h7EN1Vt7JAeRMnLsHnulD
h0Gvfmlh1d/MwvErXjpQUKlfcT5or9L6twMNCYiCFJDYHf2WFU4VXYmXNSJN
UtE1VA9UtxcsrkZ6cnMLqXHe502y5lOPxSzWvU1bqUbz7oaNMlspx2aX4LT5
PHwnm4eKQ25W1gcf38ALeneWrzLs3V98yaHRrPX5Dl2NBw312L03SN8w8rYd
smIwPVp7KMzNzYyKinF1Q8ISVb0bM2ajHlyVRilNh464s2L1U/Vzb++6MJKT
5f1CAD/YnYs4sb2Aes+X9++pgTA0mrcOt65+3Ir723fiyaNP0dFV+m5EWDpo
SEAEpIBUXnKHLCEHtj4QelkOnY7Lc9wD94ru5r57b7XLKiIvr4i6a2bOBKsf
38upR0ZKypXR46mjZC/NzKv6lBrSu5UOmTw5espiFxV9fBkaan4V/eDW0xTF
nwDVatP+ypgJzuuU/c5pxdxzzU5IgBHFugjqMWVGRkY7OaN8dFy1Fpkb6oC8
6ON8hy628xY+PauBKjKqUPJ+FeC/Bzt3k1mDOunyTgtQK0AV3Gn1Omq1vb9j
F7uwsBq3YmZm1mRUBzQkIAJSQGLZduaQcKej4VbWWLMVMplCr/n64YN6kxbk
Zfc2bqlqSvLzi5Sm2+CCOmvcte855TxiffD2QbYPVyi9rj3pwXJwMjCsmyGZ
wptXw2T53JzUVCT5vI4cuzZ5Kg4QKfq40Knb9b9neOzZF3rFIjkgsEprYIC6
RUlxcVZs7Nu7Ln4amo4r1yApgiuj6EO7XQfrqdM99x14ff0GEqXgR0j2UJ2e
wRAxgAk2MqZ6+LGY8Of3tLRq3Ie6riw58FlVvw4aEqgIUkBOH3mVLBsG5wKE
XnZnxWqy+FlPU6zoVrjHhORNVR3pFBQUL5thS901k8MoU48cZ1kX9KibPpCI
Qh2rKj1CUkweeplMpImuxCIkCgXpvVi3+76nz9rOW4ikoDhiQK9bL7vFS/01
tRMePZZsCB6gzsEuLPwUHf3G0cn3jPqd5atMBg8TZ9uURrNWV8dOfKCyG/UZ
P799C2EcZUBRXh4OwBRqflXeyQFqEUn+AdTGX7dLj5Sg4KrepJDJxDdBKrQa
yQANCQiFFJBj+l4iC4blpReC1/wsKdFp35EsfoHnhUdgSX9Nw9vHHh8+WqU0
IPW4fGaZelQcZcH4VhYMroDBsFukRLVxHnv3y3GcBG8P1zrhI9k7FxcU0IOf
BxtedFy5xqBnX3HGjqz++vvBzt0vTC8nPvVjfhLiYh0AMIW5uSnPgoKNjJ3W
rL/Y/3dx3Appt/2fzex5fhqaH7x9Kpp6AGrOzVlzqz3JCNRvvqelIdWHq6R6
05bV6GW8NDPHd6iek0k+DSlx8wfURUgBOfA3XbJU3LER4p8nNeQFLntIKAq9
z82Zc7CqqVKwtvz8IurY4/SRV799LVOP6HFG/Qbhp59r+WvErdtVfUfJsnru
bTKpR3d51vxu35KSouwdPPcduDp2YuVzjo2amg4d4bZ1R7j19azY2AYVCgeQ
OKwfP1CHBRmj+zt2IQuFKpfo4nf2l+ZXRo9HZTXayVle4//1lefGJriJA19M
AB/swkIc9ZI8XLdsr9KSyJLiYk6fkfvdS4OGVm+PJJ+GPHv4STVuAtQnSAGJ
oxc9dIsTvAavoLjQqZtQ0fLB2wcX7IqGKIWSl1du3eO0EVe+finbTx1maUVd
7IfKf2ZkZDXeUbJsX3OXTK3KOpdqfB3V3PTw1yEmZo4r1+h17VmpYkSV3Xnt
hmAj4+SAQGTxJf46AECCSuan6OgI21ue+w9emzy10pCOqC/jsXd/jKsbuACt
OdkJCfiHffdY+EJ0oIHD57zOYvykKi2JfOPohL/76qpl9dKANOSA9rrYZKvt
l0rIYKCugATkyhXrcHkI8ksSvAaPn9/dsFHwLJKUeGe0XrdeRfn5gtcIhW/P
9d8KV7F6RDdx+Wcz1VrZKy2vJaFMDqt4kAleu0DcIDs/f/7MoNGCDS/emr9I
q0170Xb5fIcutxcs9tfUfv/Eu5a8MtAAKSkuTnsVhno6TqvXiV5QcbZxM9M/
FFy3bH9lcS0jIgIcQFUPPEDkue+AvNMC1FLowc+pQQ+rtCQSWeqrYyfiL1bb
913U64xB/9PDhvvoLk+YC2uwIAG5dIkyLgyobPBdkP/tG157H3nbTvAOb+44
4vIcdk3coO0cf49Ty/w9Ko6ywDPXqDNuNnwUdeIsSN+w9hTRc8e8sYdzEZeh
BH968+aF6WWHZStFu4MmZwbdd+9FP++X9+9l9iIAID45qalRDndQKb2sMEb0
ZpxzLX+1mTP/pZn5t8REeae6LoF0I2+qZcBgeacFqL38SE+3nDgZV7cqLYlM
fOqHv+ivqV3tNLyN+jS4oz423we3PYDddg0TJCAXzd+IS0LSB/7li9FOzng6
VXCbRrmVFb//IebgQy6zcOGUslgziqPLds3Eez7U+vU3XMj1uvZMeSbdzc5V
xVjnGZnsv4YJcUGZHR+PTOed5auoHocED/SOyMj6a+kk+fnLzAs6AEiEAgYj
1u0+EjymfyiIHk43GTL88eGj7x57wQacSkG/Ev7dvryrRUEKgNpGTZZEIruD
bVBN4iTGvf08tLMBNuJ7N7qBhmyAIAE5b+ZmXAyoSxBJUMkky5v5qHGCX6fu
7Yq55yrOE5k/WPP/LItzPXNsmceeZ3oG1MGN69Nn1sKdxdfNX5EpV+h5kfwE
JTLSzv7epq2iQ4Rot/2f3SKl58YmmZGRUNeA+gEq/G/vungdOWY9dbpmq7Yi
htktxk96cuwER0zm5so71bWR4oICvI8p5JKpvJMD1HZeXbWsxpJIZH2w+4Ua
LpZ4F5eNvSKTmwJKSsCuNSyQgJw1bRsuA8XF/HFJsCjyPqHGd6oa3qV+fGfN
nWiFHzd7PM9beDGLdXfDRqrFQY+rnUFS7tpFcROvPq7VLt8z6pxVJRW7Q9Fs
3c5m9rzAC3ofQ1/VztcBAEmBSnhmVBTqVNrOXSDC1z2yekht+mtqp754CQsm
qdyav4j8iVCjIe+0AHWA6i2JxKYW1cQarjNJev91RA8jbNC3rXJms8HMNSCQ
gJz+5w4y93u15F8U8fntW1w4k/wD+M76aWjis8kBgZU+K5dZSFWP6N9kpEJm
ZibVzxXqhr9xrDAkt3zJzcq6fchwLTHyKFHhYAtnDRgSjed1U0NeQFwPoGFS
lJcX5+7xQGU31Q2X0GH5OytWv75+A8IkIV5evkL+LEh+w8oWQByqsSSSkZKC
Hdc7rVlfwwQkJ34b1duYOg4J82sNByQg/xq7i8z6Yd0M+c4GGxnjkTR2URH1
VF52Nt5QjDrOlT6ooKCYuud6/p/WzB8c9ZgWFq7fvTcu//o9+qSHv5bgC9ac
EjYbdfR8T58VMdh4tnGzq+Mmep88leTnX72IpQBQX8lJTY24ddt1y3bRYtJ8
1DifU2dSX7xssAboW1IS/jXiPSTgZhZoCHCWRG7dwb8ksry95uOR6uEzpVsb
MmjCfTuLT2oKY2y/S9Q9NbVn0ysgVZCAnKSwh8z3SYPN+M7azJ5HFjO7RUp8
px4dPIRLYGZUlOinFBayV825jQvYvEnWuUyOyvI9o67epGwVB+pJ1R4HxYzk
5FcW1xyWrtBu+7+KTJ7Ob11clDe9ueNYJd/pANBgYaSkhFtZO61ed6Fj14qq
1YVO3Vw3b4txdWuAqyVNBg8jfwT3XXvknRagLsG3JNLqr7/zvnyp6GJksLBd
s523sOZP/0jPoY5Dgn/IBgISkOP/2IdXJFJPcRZ1lzoTfnn5CvVUDp2O1zjd
Xf+P6Eew2SX/KN2h7rn+nlOAeihu23dSrQZSYrVh7C79Nc339FlR20sbNVMh
es8jFIcR22Pf1Ba5CwB1C9QCZNBoged1kaU7+0tzoXUNNTJ2i5dG3LrdcByi
Pj50hHx3w9795Z0WoI7BtyTy4oDB2fHxFV3sr6mNr6xGfG1Bkj58pe6p0T4J
8bLrP0hAjh50gMzx5TNtqafeez3BBYzPP+G9TVvxigvRq3B//vy5Y60LLlRT
/jD/+iWvmMVyWrOeaimC9Plnz2UJSmTKs6CHB1RRo12RbtTt3N3ln81RDndS
4+j4dcJefJRjsgGgflDAYEQ7Od/buAVvyuM7UDtjO29huPX1WuiWQbJ88PHF
b/05JkbeyQHqGD/S03FcD84cWfuOib5PhV5ZmJuLqxvqxEnk6QmxWVT/kBe1
K98ZAdRpkIAc0VeVzO5Nyxypp/AyCaN+g6ifo2YNO9vx2LNPxM3//fffA1sf
4OI0YaDp50xm7ufP1EW/Z39p8UzPQCrvVhk/S0qS/Pzdd++l9trKDYA0a3VD
cdYzXf2MiAi8qKOgoBi/UYAPuEoGAImBunKpIS981E5TQwmUH//nuCvx19JB
VVLeiZUK7MJCzdbteN1qAyN5JweoexTl5dkrLS/rfDVpUVGADxyBHR0Jjx5L
5OnREZnUWIdXL4ZI5LZA7QQJyD96HCbzet8mN+qpilbj4MKp2aqt6AGBk/se
4YI0uo9xWmrO57dvDfsMwIXWsHf/T2/eSOXFKqa4oCDew9Nt646KVmHp/NbJ
5Z/NsfcfVLQREocO93SNlXHiAaCBwEhODjYytpw0paKdawY9+6KmCRm+YhZL
3omVJPZLlpEveGPGbHmnBaiToI6Y19Hj1Mry+PBRwb1pqOLgKKVXRo+X1M6X
8Jcf+7Y5j02/rWW4RG4L1EKQgPy9y1Eyo5Hew58zUlJw2Ytz98Cff3wZij/3
OXVGxJ01j/vgIjSsm2Fy4rd3j72oUWYsJvwpywmpAgYjwvaWw7KVFbk71u/e
22PPvkTfp5X6psM9LEfbSNkkHgAaLN/T0kJMzKynTq9oqSSq0Uh00W7aoDou
78RKgFdXLfEMSAPcRgRIinDr69RtNXaLlwoWJ3QNviDa+a6kHv08ILlXS22e
AGik4XQLDGX9BAnI/v87Tma0zqmyxRKvLK7h1UfUUnd9+kw8TCdiZbu+hj9W
j0M66b+Ly35pZk5t/x1XrS0uKJDuu3FBNgVZllvzF1GrUrlxjF79Hqkepj8P
Eb//pdDzIvlq1pdDpZp4AAAw+d++Rdk7OK1Zr92uQ0VLJW8vXBJ5247144e8
E1t9Kuq8A0BVSfLzR5YaFyfzUeP4otWUsNmXBg0lz176/Q8JRrt46vW+ezMt
0lB2+eWcuwss6K2HIAHZ59eTZC6b6pVtxcLz1DcUZ+EPqdtqRKzPMdENwupx
QHvdN6/TPfcfpLbzvqfPSttPVDGL9cbRSYRuNBk87Mnxkx9DX1UjJZOHXibf
Dr2pNBIPAIAISoqLkWVE/T7jgUOEr15u3tph2crY+w9Ee8OrtYAzH0BSZCck
UKuJXrde6a/LOX5EhhKffX39hgQf/dAtrmsTTdJWdmuq6e2ZIMGbA7UBJCB7
tDhNZvHNq2Hkh6h9xnPNeH80Elp4e5d+jz4VjR9aXnqB1WPfX8+/DHhvt0ip
rGFv1irytp1U3ygtLNx9916d9h2FWJZGTS0nTXmmZyDCuYE4zJlgJThmCwCA
7EF1GXVmraZME7pU8nyHLh5796N+oryTWTXKNjD2HSjvtAB1nvyvX62nKVKX
fMS63cdnkWU3HzkWz8dJ1pnePYc3nRvztgz0aK4V6AvbTusVSEB2bXKWzF8X
e95+luSAQFzY8CaXaCdn/GFFu7psLMKweuzTWuep22uqSwHUmNODn0vpRT7H
xPid0xLuv7FR02uTp4ZcMhUn1rw4LJ9pC+5SAaBWgWr3c2MTqocH6nFp0NCn
ZzWyYuvGrrf3T7xxyrMTYNwGqCnsoiLsfI+0iVTXeQkPH+FTISb88URqiP11
WqdGPFXQu5XOy2C6ZO8PyBEjQ6NOhDqZuV7uvHE57xNqeLib/KSEzcbD4Jd+
/0PoNhOHmxG4nPRsoX3fyhfv8CIb8K8fPkg8/ZlRUb5n1E2GDBdqNZB8laBu
xGC/6Ps336/8agAAZAgjJSXwgp7p0BFC24TLI0ajs+gaeSdTFMUs1rmWv/IM
+iVTeScHqCcEntelDtS7bVMpKS4mT12bPJX8ULdzd4lv3bIyC8UjS/3aXogI
S5fs/QF5cV7HCOfs84Bk8kM8oO26ZTv5SZilFS51QvdqUUequzfTstW8gyNl
o8N66vT8b98kmGykCZ/pGZgNGynURpzv0OXhAdXMSGnt/Nqt7Eq+6daVzlJ6
BAAANSQ9/LXn/oPCvXU1anr97xmvb9ystdttbs1fRCbVdu4CeacFqD+8veuC
+yZnuHscSN8FyYHP8IcB2ucl/lxTvWCsNAb9Ty/mTT2PCNBA0DhbFnvoDS0D
fcLMzOTTiuzCwjJvUWMmCO468bgXi10jdm2iaaJiTN1wfXfDRkktZS/Kz4+w
vYXKPPZkTj20fv3Nee2GWLf70l45f2y3J/myq+felt5T0MvmZmV9//jxW2Ji
VmxsWlh4kn9AnLtHlL3DK4trQQZGfhqaPmqnvY4c89x3wG3rDsdVa23nLbw+
fabgYTlpitnwUYZ9BqDe5YVO3dCB/mHUb9BlhTGo4yn0K7cXLHZas/7+9p3I
BHsdPe5z6oy/ls5zY5NwK+s3dxzjPR8mBwSmv6Zlx8d/S0pCej7vyxfZbKsH
gCpRUlyMiitqhahdWnwgY4oajfdPvAW95MmXF6aXeSls0QZqFiBB0l6F6XXt
iauA6dAR5IA86qqQn2i36yDZAR8S3bN+WGwM7WzwIaHCUN1AXUHtmAHO06QP
X9EnNBtbshQhEUj2TUJMzHBhe+/1hO8OTzwSujXl7bTq0vic5qKT1PYZiRyJ
pPNTdLTH3v1C3XegD13+2Rz3wF1m/oSxi8sFk6+LuCyKC/UTZMuQIERS8IOP
b8LDRzGubpG37YL0DR+pHnZave7GjNnmI8cirY6UsFCFXPsPVGZQdiClijoa
NrPnkRL08aEjT9XPoVIUaWePyk8GjfYjI6NSZ5sAIFmQDHvrcu/O8lUazVsL
Fl2DXv2entVAvSF5J5PHl/fvcdrePfaSd3KAekVOaurlEaNxAdPt0iM9/HX6
axqe4H5y/CS+OD8///nz55mZmTV/7tnDT7DeGNHDiJ5cHxy3NmQOHyiLXJmd
xVn5gKNUX/vzr/+442A40p/VlGl8X38ekNyzBc9faOdGGocn7sRlUiIbrovy
8mg3bTjRKAQafHR/h6UrYu65SnbXmDgYaQWSrzxtxBXq50gU5WZlZcXFJT8L
2jjxz5FEo/lE40MdutxasPjquImcwKMVxNRogAdSyOgHQZ1fq7/+Rvnoue9A
sJExys3UFy+/vHuH+r+1bUQIqDcU5OSEXbPmbNwWLJmNOJN6UfYOtSG6zcX+
v5Op8tx/UN5pAeobhUwmHnI8w92aHefucWfFavwnGeYjLi6uZ8+eBEE0b97c
zk4CHlSO7vLEkmNcf5PPmcya3xOQF/tUygQki1WMrPb5/3Umi5C/pja64Jme
AS5jSf4B1O9Gvc7o+2tZxCKVQevwlTq/dUoOfFaThKWGvHDbukPorJPlxMmv
rlpKY4xdTK4Y8hxdDu+o5Xv67N0NG5Ex0u/RRxb6sFFT9Jvodet1adDQK6PH
I2ltPU3x5qy59kuWoWS479rz+NARwcP7hFqAzoUXppfDra/zDivrkEum/lo6
T46dELz+kerhByq7ndcp2y1SujlzjvXU6RYT/rysMAZZNN3O3SsK5SPZQ71p
S6N+g65Pn3lv01afU2deXr6C5OXH0Fe5nz/LK9+Besa3xEQ/DU2jvgMFi59O
+46oUyO9ddTi4LF3P5kYVNnlmAygvlLCZt/fXjbmgzr1PqfP4skvVP7RNYsW
LSJKadOmDavGHat///1370Y3LBv+GmbO+JYvibcB5MCOjXp47eJ/5SMVpr0K
Q52U8x26kH/yBWZ9H589uGOZ+NzQZRn+omHv/tV2l4HkQZC+IfajSz2023VA
LaosY2cX5eejF0l49BjpVaTBnNduQIINibeVxDjyrXsRx2qikc7+0hypwYsD
BiOF5rR6HaqwyJy9NDOPtLOPvf8g0fcpyo6MiIjPMTFfP3z4kZGBskPaDtjF
5GdJCev79+9paV/ev0fJy6DRkOD/4O0T4+oWces2kqa+Z9Tdd+8lJej1v2cg
rYtKhWbrdhLRluda/moyZDjqPiOVG3heN9r5bmZUFMosef8qQJ0E1anEp353
1/9zrkUbwcJ2dezEsGvWqOrJPmHxng9xMpDWlX0CgIYA39Zs7ApPo1mrHDp9
6NChBIXU1NSaP7Gk5Ofm5U5YPMyZYJWbK+tpREAibFytizdGoT+RgCELz4WO
XX/+/OmvqY3LVeqLl/hbaak5I3tdxAVgSZsyV+Hmo8Yxq75YAgmShIePHJat
VG/SQrANv/bnX7SbNlJVCMUsFlJBEba3nhw/6bhqrcX4SZwZ5woEzDpCgbfm
kzhd0TWniSZHuMdRool6v4FIfyIVGufukRYWjnRXcUFBw5yiRb8zapQ+hr5C
ChnZ5cALel5Hjrn8s9l6miJSmBUFOxbraMSJZn5t8lSkBHxOnUE3R4I2OyEB
+6kAANEU5OSgSooUo2DpQh29+zt28YXwkDZFeXl4uWao+VVZPhpoUETZOyC5
SGlLeYOQrlu2DxkyhCog6XTJeHEsKmKvnH0LS4ilijYsFjTUdY+1ShfIHBzT
9xL6E7vhdV6nXMBg4E0rtxcsxl/5kp038XcznPUzmy7FBc9mzvyqdtWRnHh6
VoMz/yvQaOt26eF19HhWXJxkX7mEzc6KjY12ckbPdVHeZD11umGfAVWSLhuJ
Ifj1TRXG2Sstf3TwUMglUySKyCV8midOUivd+fOS94pQL+EsIv38GeVOSlAw
yqAgfUOPPfvsFikhm47EYfXkpXrTlmbDRjqtXuevpYMy6FtiYi0ZxQVqLZmR
kR579wuNZnVlzIQwSyuZDUjenDWXfC6qBbJ5ItAwSQ58Ro2aTR6oyR3Xr580
BCQiL69oweTrZZOYix3YbIlF4gZkw/K5PAH5t8LV/K9f8fqHiFu3fdRKh9ca
Nc2g8brezB+sGWMscaZPbrTydGlhc928TfzRnp8lJXEP3G/NXyS43RgVWrvF
S9FZiWzULczNTQsLp9nYep9Qc1i6wvQPhXJdLfGOC526XR038c6K1Y8PH31p
Zu54wQH/AkLXb2hpaYGAlDg/f/78/vEj0paRdvYB2ufvb9+JzKvxwCFCR61F
HJqt2pqPGockJepBvHF0+hwTA6OUgCDFBQWopKEOppAi1Lqd2zaVtFdh0k5D
sJExLrSy3y0INCiy4uIE1wNv+rW9lAQk4ntOwfSRV7Ex3bn+XsOcmKu7LJzO
2wWzcMr1N3ccsWL8/DYGr1i7s3wVeTGLVbx42k2c3WOJ9acInvxDtljMJzI/
ffLT0NTv3luwWb44YHDgBb1qzIBjUPFDtQC9CFK/qM9u2GdAlTa2aDRvjaSF
46q1T46dCL1ikfDocVZsbFFeHt9T3kZ9wj/CR3qOYDJAQMoSJP+yExLi3D1C
TMweqR5G3QSUiYK9aVH53qyV2fBRTmvW+2vpxLi6MZKT5f1OQC0CNSmPDx3B
uwuph/nIsWGWVoJNhMQeHRuLn5Xo+1RKTwEAktzPn6+MmUAt4aeJpl2kJiAR
2Vm51AnNY7s9JXt/QKrMmqRDZtya+Xb3Nm7B0zSoweSNBzZu9vntW3Qlm12y
flHZyJsCseUk0ZIzRdikRbi1KHeImLSw8LsbNgoOACLZ5rxOOck/oBpzi4W5
uR9DX6EEeO4/aD11utBd20KPs780Nxky3F5pOfoi6UAGmYmfJWINoackfcO/
Q2y0kE3BICBrA4VMZmZUVJTDHZ9TZ+yXLDPqN0j83gRSCzdnzfU6ejzi1u2M
iAgY/AGKWawoewfraYqCpUW7XYeHB1Sz4+Ol8VzD3v3Jp6DSKI37AwAVZFJt
5synFu/NxC/SE5D/CWyp0FHzlfgjACkxbRTPi+P2NXexd3rP/ap4QyKSdv9x
Nyru2nAPZ/EQYudxojU5lZPw6LHoR7CLipARF+rL0WTwsOcXL+V//Sp+gtHF
7594P9PVd1q97tKgoWJKAvQ6nFnLNeufntVAViAzMrImkuDrlzz8U7wKKduV
lsMoeBeXHR+TdXCvZhOiZ1OiT2OiPQjI2gPZ3aDdtPE+ecph2UrTPxTEnP5G
l5kNH+Xyz+bnxibJgc/ksicXqCVkJyR4HTkmNELizZlzUFdUsk7y3bap8EY7
R42T4G0BoCJKiotRW0ct2FOIRqSAfMsdTZI4ie++DO1cFtPE8tILaTwFkDiT
hmrxlh8ss8GlxV5pOR6m+/L+Pbrs5L5HOHMHEvuOEJzZbY77epHbEnNSU31O
ndHt3F3QHDuuWiumo0ikPz++DEWG23HlGs6UtJjmfthI57UbAs/rxrl7fP3w
QfyVFejK/PwiVJ7fRn3yffTO4QbN+nKoiW4Q+gWO7fY8rOKxZr7dwr9u4F9j
eDdD7Epd8OhIqDcjhoCArLWg0pUZFRVpZ++jdtp+ybKLAwaLFQOoEafv46K8
6dVVS9QZEXPgGqhPoJLzxtFJ6ApJvW69nqqf+56WJpEHoafgUpf3BaK/ATLi
Ueks5BmuU5HxRGPpCUhEdGRm/3a8HRmdGmncc5Cdvz6g2ozuzxOQW6fqkEVF
s1U79aYtyX+7btmOrtFT98eKqC9x6CDRgRw8FLFULPGpH1Khgttmz3fogiy1
6Kb133///RwTE2593X3XnqvjJgqNO8Z3aLZuZzHhz/vbdyKDnvYqTOjoIrpt
dlZuZvqPd3HZSBlamYXqnvXTOuFzaIf7ilm3Fv11Y/wAk14tK5SC1T7aEItA
QNYhCnNzU4KCQy6ZIn1oPnKsmMXP6q+/Hx08FHnbDhVd0JMNik/R0Q927hZc
PINaP4elK5L8/Gt4/9ysLDzPEu18VyJpBgBxwENJ5DGMaCSNKWzMi2cpeDSm
W1NNvycfpPcsQCIM684LY72u31aykBj24i25QTKSkZJiZfoSa6FexLG9BGfi
5trkqULnnYsLCsKtrM2GjxI0suajxr2+fqOiAGEFOTmopQ3SN7RbvFToYnW+
Q797b7tFSr5n1GNc3aiOWQoKimOjP/s8fOd6J9rpVuRF7cC9G91Wzbk95Q/z
Hs21JC4OKz06EEebEN1BQNZdOE6fuNuynhw7cXPWXOxXX8RxrkUbi/GTPPbs
e3vXBVl/eb8BIAtYP368NDPHTpipB2oPUauI2sZq3/yywhjyVvd37JJgmgFA
NKjQHm9cNgo0l2gsVQGJeHQ/rssv50jr2ae1Du2VZIbxASkxqAMvs5R+4UWG
xVN47rv3Ig3WqRFPC3UnTu4kep3hbsoW1IHfP370PnlKUPtpNGt1d8NGqhNy
TA6dHmF7y3XzNuOBQyo1yjrtO9rOW+h3Tivh4aOctPTsrNzI8PR7Dm9M9YLP
HPJat9AeSUROZJxGElaAA3/THdXbeMJA02UzbNfMs1sz327fJrezh58MKB1s
37DI4a5d1BOPBHQE+iYmvvuSnPjtiKpmI6JlI6IZbKKpf6ByG3PPFZX263/P
ECeqo+nQEfe376TdtJHSJgugVpEc+Mx57QbBrYKobfQ+ofYjPb0a93x8+Ch5
E6N+gySeYAAQwYLOZWt9+0lnEw0fdtavsf39vYPe+/hsaT8RqDa9W/ME5Api
XDnh17z1g5uBXZvwxie7Eqe3Epz1hw8PqPKtJ0zyD0CSUnC22qBn38Dzunwj
MFlxcWHXrF2UN1W6mvFcizaWk6Y82LXv8YXLT2x9XeyjDDUDtq1yRloO91Bq
cvzRxWDmWMt5k6xXz719WMXj3DHvS+efIUXq7Zng9+RDfExWagpDRHwl7L0K
pUrwLOzCbiCUsNnpr2mvLK4hiXhl9Hi89qOiQ7dzd8dVa0OvWHyOiQF/5vUY
1O4F6FwQjI+ASojLP5szo6KqdLd3j73wHcDHFCBLhvz++06iCSp4qkSTpjIR
kAhki7GlHtXbODP9hwweClSDrr/wsmktUW7yxXr5VrwaoTNxVpn4A30YoF0m
hIoLCpDdNBs2UtBKXps8Ndr5Lt6KiETjq6uWTqvX6XbpUckwY4duRmNnXlTa
r73p8ual9mP7XercuJpasXcrnX5tL0wYZLpmvt2x3Z566v537aJCn6dGvc74
kPCF+aOmEeEXTeXto1E/8kTwLAjIhgm7qCgjIuL1jZsee/dfHjFatIuA8//r
bL9kWbDhxbSwcFg2WS9BbWC0kzNqDwVz/+asuUgWitmJKMrLw32TcCtraScb
ADCDBw9uThCDiUatpebGRyhqBx5ja/7XMPMcRvVXgABSori4BOfRRmJwWTe5
eZshrU+WnlJfTXBMYegVC/JbhUzmMz0Dwb3VGs1auShvSg9//Z/4orFxC40e
w1UHL1vRf8/QlserqhK7NdVEEnHB5Ou7lV31NfxvXQt/4pEQH5NVWChJNxpC
WbvAnkzDYRUPwbOamppUAamjoyPt9AC1kLwvX2Jc3R4fOmI5aYro+Efabf93
e8HiIAMjEJP1EtQq3t2wUXCA2nToiDBLK3GWR2L/k6hRlUGCAYAECUjpRaIR
Aepb7Vjrgm09svIFBRAvrHbx7Ws+zqBtRD/crK1uOR1/rkRMVm/SIsrhDrq+
gMHwO6clGONDv0cfv3PaiX5+Ly9fcVy1VrRoPN245b5WgxcQf48hlLsTJ8XU
it2baU383WzDYgfds37ud2NehaSmJH0rKZFb2CNcttE/BM+uWbOGWunWr18v
+xQCtQp2YWFKULC/ls6NGbPPtfy1EjG5cMlzY5NPb97ANHd94nta2pNjJ7Tb
deAfi+7QxefUGdERuPw1tcmLL3TsCqUCkBnyEpCIoiL2ytm3sAZQXnJHjhYf
ECQ1hYFzZzfBU30nG7XuRRwlP5xLzEDGjrNvJTX18eGjWr/+xtf0WU6c7LFn
n8PSFYKtIvVQI1psIQaiuykQW7oQp0UIxc6Nzw3rZvi3wtVNyxwNzgV4usbG
Rn/OYRTUtjbz0A533tT/AnvBs/PmzaNWugULFsg+hUCthV1UlBry4pmeARKK
oivOhU7dyDWTWbGx8k41IBkKmcyQS6aCQYc1mrd237WHkZIi9FuowOArMyMj
ZZtkoOEiRwGJyM0tnD3+GpYHR3YKme8D5EXMm7KYzgeIjmTrtJCYSn7yN7EI
Wbewa9bOazcIBuwwHjjEbJiCCK/LJ8UTjUM66aOeheZxHzvr169D0+rKMLX6
kSdk+hdNvSF4VlVVlVrpjhw5IsFHGxgYODs7S/CGgLQ5ceLE06fCAxn//Pkz
g0YLNjK2W7xUtJjU79Hnwc7d8Z4Pa+IQBhCTHTt2RERESO/+P0tKYu65Wk2Z
xpfLqKV13bzty7t3fNeXsNm4/x5seFF6Cau7bN++PRKktaSRqoBcsWJFamqq
6Gu+ZOdNGGiKBYORVqAEEwDUhNDnqThfjhIchyTHidY9iWPoz/HEWu12Ha+M
Hi9oyERMwJ0gWm0mBlUkGrs11VToeXHrSucLZ/weOL9Nev9FxDbnWo7BuQDy
paaPvCp4VqqbaLZs2QKLKusWCxYssLaufO8DEpPprzli8tb8RSKiuqMKiNRm
uJX1j4wMGSS+YTJ27Fh3d3cZPCgtLNx5nTJfDx11zJ1Wr8sor2BRppNnbefC
jIYQxowZ4+npKe9U1DekKiB79OgRFhZW6WUpSd+ogQ4dboiKfwfIjKeP3+NM
USM4fnjmE9M7EeqziVnqzSoPwMFb00g03U70nU3M/oPY0Zk4S1WMI3tdVJpu
o7b/kdOtSCRWi4vrz+4AC+MX5DuO628ieBYEJEBFTAFJpaS4mB78vJI1k42a
oi6ez6kz6ErYeiNZZCYgSRjJyQ9UdgvutLKZPQ/HsgkxMSM/1GzVll1UJLO0
1RVAQEqD2iAgEVGvM/q2OU/a3K5NNH0f8Q/RA7LngfNbMke6EKdRu3SMaPUX
sWQfUXkgGHKwcT0xfAqxDC+Y7NRIY9qIKwe3PTDUDHjxLCUj7bu830+KYGen
gzvqC54FAQlQqYaApILUQpJ/wOPDRy8NGlpRfdRu1+HO8lVhllYVLaIDqoSM
BSTJj/T0RwcPCfYXLMZPinW7/+ntW/xJcuAzGaet9gMCUhrUEgGJeOr1Hjum
7tNaJyKsOj75AQmCVVAfQpUrIEVtDj3D3Quzjei3kJg2ivinC3GmR3OtqcOv
qG53t7EIexlE//G9ps4V6xBYe6MfQfAsCEiASg0FJJXshIRgw4vW0xQFXffj
w2zYSO+Tp1JDXvD5/AfERy4CkiQ3K8vn1Bmd9h35stV85Fj8oe8ZdbmkrTYD
AlIa9O3bt5YISISjbSR190TSByHxlIFqwU6k+TnY2Di4+NGZ4n7HVOdpD+LE
HGIWuQCyomM/0WkJMXkksakLcXpYV8Ntq+/evBqWEJvVkM0T6g3hklxUxO92
EgQkQEWCAhJTwGC8cXS6t3GLCK9Zel17uu/em/jUDya4q4ocBSRJIZOJegr6
3XsLzVmLiZPlmLbaCQhIadC6dWuqLUtISJDgzasqIP8rH6Rm/ACT7KxcCaan
oZJhqczJXAUlZQXO/xVd4oWLSDabXUxhdZeVRyseddxN9JhLzBzdRnXl7FtG
WgF+T97Fx3wqBriEBCbhYvz503e+sxoaGtRKh/SkBB+9adMmTU1NCd4QkDbz
5s2zsLCQ0s2Liorooa/8tc9bT5uh3kR4LEWz4aNyv32TUgLqJUiNuLq6yjsV
xay8vFeWVhf7/y6Yp7lfv8o7dbWL0aNH379/X96pqG+0aNGCasuQ3pPgzZGA
DAkJqeq3jqi4Y+O7as5tGYut+keQliLKWRWbaM4fjCAlTj4r0QQkpK+vL1Ge
f4ghfI3SKaLpFqL/dGJaT2JeS2LSL0RnAhAG+mVwGW5MtJd3cgCAQ1Nu0LHF
xC+HuOFrqUd/opG8UwdUE5RzCkSjPeXztIu8UwUAcqJRW2INaXx7tdKQueCq
X2R4cUcdlaNLVyDSuMORSqZCtrp//fr1C4WDAxeeIFqdJpruIzrv7zBGfcmJ
e7be0dGxCQkJ2dnZX4CKoadk9G6lTa7mRf/mO+vu7k4t7p6enhJ89Lp169TU
1CR4Q0DazJo1y9jYWJZPzM7KivJ8eG/nHr3ufZDYMOgzID0pSZYJqOuMHDnS
zs5O3qkoR9anT8/MzElvkHo9+qI/5Z2i2oWCgoK9vb28U1Hf2LhxIzZkvXr1
ysrKkuDNu3Xr5u3tXY0vpqd92rTcXqGHocNNcOlTI+JtuLPXSjZ4xJEVbcnN
bZV4MSJCH1uxc8XAv6WYvvpL2IuPGke90X+FnjUxMfmNi5mZmWSfC2sg6xzS
WAMpJv/++y8jORm8vlQVua+BFIHooIcNFlgDKQ1ycnKWL1/etGlTpM8l7lq/
GmsgAYnC5OlHyzIdzkp04ApIpVAxdtMYGRmtXbtWigkEJA0IyDqHHAUkUD1q
s4AEhAICss4BAlLeMG3IJY/UCWtWNFdUEqY0RqXfBwFZ5wABWecAAVnnAAFZ
5wABWecAASlvGJZcAalM7qAhYdFAQNZjQEDWOUBA1jlAQNY5QEDWOUBAyhue
gFTzokTFhRHIeg0IyDoHCMg6BwjIOgcIyDoHCEh5wyQFpCJlCpvN25dNWEZX
vgjS1tZ237590kwhIGGOHj1qaWkp71QAVWDjxo1ubm7yTgVQBebPnx8cHCzv
VABVYO7cuSEhIfJOBVAFUDft3TuIai1HmA7K/GsgmTRyF7YQV5AAAAAAAAAA
QHdXJbdhY7XIJN34KFpWPoENAAAAAAAANECYNHISO4inF9kuKpwZbDW/DNHf
AwAAAAAAABosdC81ruNwF+Z//yV66ZMDkjD8CAAAAAAAAIiA5qCK4w0pqtrQ
WZV/BQAAAAAAAGjgsBjZdDo9mwHaEQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAqhM1I9HNxsLFx8KPR5Z0WQFyy4/1sXEKFbZ1i0Pzc
Odnp4B6amC30u8xseiKFDNiBJWUYdJq7AydP3P1o2WyhlzDLZUliRvksYSfS
/Djfd/GjQ5wpmcDKiHbntIo2Ln6Cob34MouEzmCLuCYD6pgMEN2yibZ0YAfl
CYsRTwtCP7+pqQN2JlPjZhOQOtmhZABEBWUljh9yRTV3MFC1HCQdtZS5Yc8V
TPncfrLofspEOZS0vPjrFDtepfw11IjqgKRh+Zny54l7In8lS3TgzxOKasmw
5N5AQYnMdUWXeKij0iXRXa18bmglUmpRhlf5s8LqkcgMBaSDyJZNtKUDOyg/
WKEOWmR+KavpO7gHcbVizZtNQPpk+ylyfnaVaO7PHmrKCW6jZAlyovbCirdB
rZyiAlldLMtXF6alIlkNTW0stRRLK5WqSyL1okQXvkqnFCR8nBKQALwAowrK
pjY2WipleZJI7VALGj79IHwyiJuTKjbRnD8YQdz4UxDvXoqw6S6cn1jNJpQW
ZKnKyzJlm/jS8wxLJV42KZRC/qkfWlqRRGYoICVEtWyiLR3YQbnB6x0TyqZU
eVjzZhOQPmwvNU7Tp2wZzfuASeNmplIomKfaDYtmKkRAZnihz8qGp5jRPC/z
1PDo3Eqn4sCxhmwSGSa74cH2U+XFiiKJLvX8b0oryxOu4VOJ545x8edJhhdX
nShHl46A0bgNrhIMGksNmr4iZeSK5aKqQP3BWYkOyLC5RGdQMonFVS68HPxP
dIYCUkJUyyba0oEdlBcMG556tCk/lVbjZhOQAaxoMvcso3FGMW24nWuyGgK1
Fl4HrbyAZNPd1UxDqZdlB+nzCchEF25NVDH1oyVCfZM+LC8ttaByjWO2vkL5
lpCdyM0SBVMXv0QGf57Eky2skg3OaBaZ9ajlhPyTEuUtUai+Inc8iqcuWIle
DqHlh+yZoZxWU82r9OuiMhSQEqJaNtGWDuygnOBlGaFM419lVdNmE5ABzGgb
cpyfMh1GdqUJxfI6BKhtCBWQgnDnu1EFdWCV/l1uzF9B1U9gVQkgZVikbXIo
Ha6KL7+MR8XSjzqTw9OPlNk07ggYDI/IDHJ4SkXEmoFsP84KLtNQnmkTmaGA
dBDZsom2dGAH5QMjlFwJouae+B+bmZGRITKaXpWaTUAW8ERIeUsUXWqxIDtq
M2IKyHgb7tRa6RpIFt1PX01NRVmJWvUsaQyR9wAkCm+4Ay/mYQXZcPKEt6iV
RBmPGPNGQspNWJcOmJhCxkkdZpClCneYI7ria0rnr8XKUEAqiG7ZRFu6TLCD
8qB0+LEcSmouwmtK1ZpNQBYwyHV0lOVViGhySWtlygSQL2IJSN4gv1aG4CkW
I9QB7yRViQbfB7KCbDbVvITkCYMeijc+lc6d8fZrKNtQBAyLBgJSBvBtxFZ1
qWA2k0lDWaSg5id4RliGAlJGWMsm2tJ9BDsoD6JLt6IpabnE0+lBNjw9qaAl
pCpVsdkEZAGTRm500qI6vYKKUycQR0CSuy1soiu8pNRzBZIikNsygVycT1nQ
KEC2Jc9VD5mzPAFZruWEEUiZwOK4FIx2McUzZcJ3vvPNXwueL5+hgCzga9lE
W7pMsINyQMjcip8aOZ4osCSyys0mIAuEDeyzvdS4al5UZgHyp1IByQg15R+5
EkaovhIh4OcHkA7ZXO8gypWodWYotwaSkzVMUkBS3dmxefuyqWv+ASnCoPHU
iLAfnG/+WhjlMhSQEdSWTbSlEzaFDXZQ2vBaNqqALF3dXbbQkUs1mk1AFvB2
WJSrOEKyFaiFiBaQbLq7Ascpll+llYnsm+uDI0ipQ+7FUPTLqDRPuKOOCqbc
LGE6KPPXR95wCriClB0scsG+kCHfiuevKVAzFJAR1JZNtKUDOygPeHUKOzfg
fla6Hb6saateswnIBnKNHDW/eBUHZsdqOaIEJLm7TdWd0otjMZjClzmSA5Uw
liVtuK6JFdwp4UzYjIr2HDJMFcuGPujuqmQ7W1ZFS7MeqqjMID1Llx8Y4cCb
v66ktSyXoYBsKN+yibZ0YAflAG8NpIpLWaXiCcgyJV/tZhOQDTRuJipq8fy3
sxNdyNUgQtaqArUJnjNAwU2CpHpUNM1gsdksBJORzd2KrcXxR8HOTgwKomXj
GshOVINpGulD1jLT0Iz/yCxhMuKDOOGEgji/OyuRFkSjhCwn926UrVzljnGh
HC31isZ2UeHMYKv5QR2VGmxmeTNF52SJgr7A4IbQ+evKMhSQApW2bKItHdhB
2cMif2RC0Q/XlQx3BUqu1ajZBGQDm9s2EgoO8UyUJ/rQ7aoj8LaIKqhRB0UE
A2FjbDjhaVgOpfveLN2Dgrx4vnJhJlSaCEZ0LYXrnLN0+oxQUrMMCg2y0eLk
iYpNuYkzOhl5mRuXIdFLn8xAqKJSgxcPVEFZ3y86kR5PRpIsNwxSeiF3/rr8
plFxMhSQNGK0bKItHdhBeUAO7BPKlpwJahad+5eCO50lkWYTkBEMmmqZMyVF
yyB65V8B5AjqXCuUq1Jq7rwscy91hMBf6RT0ya403UurXF3Ud8kABz7ShE13
5+WAQJ5okUOIbHpZzHLOdSouoUKGPWgOZT7TFFVt6JBrUqR0A0VZnphGC5MS
GV6qhKAHA/EyFJAsYrVsoi0d2EE5gIQi1R+4shfX/bukmk1AVrCy6XR6RjbY
pXoPm8nIQFmdkc2E3Wq1BTYjg5Mn2QxRY8EsBqeOigzWAEgMZjbKEQ7ZFSwe
5l5Dj08U2gMTK0MBySJeyyba0oEdlANssrJV+WeHWgYAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACBh/g9qyGIC
    "], {{0, 580}, {875, 0}}, {0,
     255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJyVlwdQU9kax8+9N73QApFO6B0pAgGkhB5AQTrYCEkIoYSQEJpdEVdgLYiI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      "], "RGB", "XYZ"], Interleaving -> True],
   Selectable->False],
  BaseStyle->"ImageGraphics",
  ImageSizeRaw->{875, 580},
  PlotRange->{{0, 875}, {0, 580}}]], "Input",ExpressionUUID->"8c513410-0220-\
40bb-8a65-29dc6acf9865"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzs3QdcU9cCBnD31qqtu1at1lqtWGvVWtsqtvbV0dLaYW3pblHrrF1iFdnL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    "], {{0, 580}, {875, 0}}, {0,
     255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJyVlwdQU9kax8+9N73QApFO6B0pAgGkhB5AQTrYCEkIoYSQEJpdEVdgLYiI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      "], "RGB", "XYZ"], Interleaving -> True],
   Selectable->False],
  BaseStyle->"ImageGraphics",
  ImageSizeRaw->{875, 580},
  PlotRange->{{0, 875}, {0, 580}}]], "Output",
 CellChangeTimes->{3.651520854160612*^9, 
  3.651521937168105*^9},ExpressionUUID->"2a467e4e-f2f1-4699-902f-\
330a4ceda846"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.577043260079913*^9, 
  3.577043264425056*^9}},ExpressionUUID->"5dc22647-9bfc-4d0a-a19b-\
d63bb8430c0f"],

Cell["\<\
The projectile sometimes hits the front wall - and therefore doesn\
\[CloseCurlyQuote]t get into the city. The projectile sometiimes goes past \
the back wall and doesn\[CloseCurlyQuote]t get into the city. \
\>", "Text",
 CellChangeTimes->{{3.5770440648868837`*^9, 
  3.577044120293538*^9}},ExpressionUUID->"0fc66281-4dad-4edc-a037-\
0c25ee607b22"],

Cell[TextData[{
 "There is a range of angles that we are looking for\nFrom (0,",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "1"], TraditionalForm]],ExpressionUUID->
  "c20a4581-7e1f-4666-bf4b-a3560c4f1ce1"],
 ") the projectile hits the front wall.\nFrom (",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "1"], TraditionalForm]],ExpressionUUID->
  "25618bcc-fbb1-45dc-872a-bd393bf1391e"],
 ",",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "2"], TraditionalForm]],ExpressionUUID->
  "78bb2982-7584-49ec-b3a9-5ca471de83bd"],
 ") the projectile makes it into the city.\nFrom (",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "2"], TraditionalForm]],ExpressionUUID->
  "72da0ed4-e2e7-40e6-a2ff-c675193ea6f2"],
 ",",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "3"], TraditionalForm]],ExpressionUUID->
  "2c8ca62e-8bef-4276-b61c-503c854743cc"],
 ") the projectile misses the city and flies past the back wall.\nFrom (",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "3"], TraditionalForm]],ExpressionUUID->
  "dc7d84b4-1d47-4320-9241-132b25c6fbf9"],
 ",",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "4"], TraditionalForm]],ExpressionUUID->
  "56baecd2-e1cb-448d-b68b-3b4ef8e24498"],
 ") the projectile again hits the interior of the city.\nFrom (",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "4"], TraditionalForm]],ExpressionUUID->
  "8fd81d82-cbf8-483c-8763-4fad9a4d4406"],
 ",90) the projectile does not make to to the front wall."
}], "Text",
 CellChangeTimes->{{3.577044468202783*^9, 
  3.57704472222932*^9}},ExpressionUUID->"1100c2f1-afd7-48b5-b9f8-\
0150a3ba1710"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.577044459512603*^9, 
  3.577044460363768*^9}},ExpressionUUID->"83dd9b8d-49f5-4293-842e-\
1880911822d8"],

Cell[CellGroupData[{

Cell["The Model", "Section",
 CellChangeTimes->{{3.577044453915156*^9, 
  3.57704445550483*^9}},ExpressionUUID->"50567b47-2720-42d6-9716-\
4d3a77ffd4c3"],

Cell[TextData[{
 "Parametric Equations for the Path of the Projectile\n\n",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    RowBox[{"80", "*", "t", "*", "cos", 
     RowBox[{"\[LeftAngleBracket]", "\[Theta]", "\[RightAngleBracket]"}]}]}], 
   TraditionalForm]],ExpressionUUID->"0e928f6b-6b11-446b-a53c-cfc5036ae71a"],
 "\n",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"80", "*", "t", "*", "sin", 
     RowBox[{"{", "\[Theta]", "}"}]}]}], TraditionalForm]],ExpressionUUID->
  "131ddeb0-e251-46e5-987a-1dbd3e10520b"],
 " - 4.9",
 Cell[BoxData[
  FormBox[
   RowBox[{"*", 
    SuperscriptBox["t", "2"]}], TraditionalForm]],ExpressionUUID->
  "48964af7-f621-47a1-a4e9-b73b3a47de5c"]
}], "Text",
 CellChangeTimes->{{3.577043498528852*^9, 3.577043685506493*^9}, {
  3.5771765692642*^9, 
  3.5771765720566*^9}},ExpressionUUID->"8f96358f-ef2b-4807-a077-9995608c3aad"],

Cell["", "Text",ExpressionUUID->"3c59b348-94ea-449f-869a-f5c5519ac65c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v0", "=", "80"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"v0", " ", "t", "*", 
          RowBox[{"Cos", "[", "theta", "]"}]}], ",", 
         RowBox[{
          RowBox[{"v0", " ", "t", "*", 
           RowBox[{"Sin", "[", "theta", "]"}]}], "-", 
          RowBox[{"4.9", "\[IndentingNewLine]", 
           RowBox[{"t", "^", "2"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"100", "+", 
          RowBox[{"10", "t"}]}], ",", 
         StyleBox["15",
          FontColor->RGBColor[1, 0, 0]]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       StyleBox["50",
        FontColor->RGBColor[1, 0, 0]]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "700"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "300"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", 
      RowBox[{"3", "/", "2"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"theta", ",", "0", ",", 
     RowBox[{"Pi", "/", "2"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.57703590678804*^9, 3.57703604896598*^9}, {
   3.577042096342194*^9, 3.577042096700368*^9}, {3.577042245908386*^9, 
   3.577042271841467*^9}, {3.577042302971974*^9, 3.577042337315282*^9}, {
   3.5770423687058573`*^9, 3.577042391384057*^9}, {3.577042529488461*^9, 
   3.577042535534046*^9}, {3.577043426283783*^9, 3.577043426393469*^9}, 
   3.577176470561*^9, {3.651520905706141*^9, 3.651520974556711*^9}, {
   3.6515210202423887`*^9, 3.651521102711273*^9}, {3.6515211569607153`*^9, 
   3.651521157457657*^9}, {3.651521203935006*^9, 3.6515212731807413`*^9}, {
   3.6515213034432573`*^9, 3.651521340054535*^9}, {3.651521635309868*^9, 
   3.6515216637597513`*^9}, {3.651521964648554*^9, 
   3.651521968746468*^9}},ExpressionUUID->"b891c9f0-1513-4c9d-8f0c-\
9c6ea8f3edca"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`theta$$ = 0.2261946710584653, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`theta$$], 0, Rational[1, 2] Pi}}, Typeset`size$$ = {
    302., {214., 218.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`theta$635217$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`theta$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`theta$$, $CellContext`theta$635217$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      ParametricPlot[{{($CellContext`v0 $CellContext`t) 
          Cos[$CellContext`theta$$], ($CellContext`v0 $CellContext`t) 
           Sin[$CellContext`theta$$] - 4.9 $CellContext`t^2}, {
         100 + 10 $CellContext`t, 15}}, {$CellContext`t, 0, 50}, 
        PlotRange -> {{0, 700}, {0, 300}}, AspectRatio -> 3/2], 
      "Specifications" :> {{$CellContext`theta$$, 0, Rational[1, 2] Pi}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{347., {259., 265.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.651521665952524*^9, 3.651521938114253*^9, 
  3.651521969619432*^9},ExpressionUUID->"f2530342-e096-4696-ada6-\
7b42ecab7707"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Front Wall", "Section",
 CellChangeTimes->{{3.57704399910394*^9, 
  3.5770440011671267`*^9}},ExpressionUUID->"2b3c6848-f58e-4386-a470-\
a8c6d744b0e7"],

Cell[TextData[{
 "When will the projectile clear the front wall?\n\nThe projectile will hit \
the top of the front wall when ",
 StyleBox["x",
  FontSlant->"Italic"],
 " = 100 and when ",
 StyleBox["y",
  FontSlant->"Italic"],
 " = 15.\n\n"
}], "Text",
 CellChangeTimes->{{3.577043473656802*^9, 3.577043488966304*^9}, {
   3.577043699510313*^9, 3.577043737202834*^9}, {3.577043795412178*^9, 
   3.5770438228102407`*^9}, 3.57704416218396*^9, {3.577044205412635*^9, 
   3.5770442094365597`*^9}, {3.577044260468281*^9, 
   3.577044261691495*^9}},ExpressionUUID->"f62f92bb-5ec5-43f8-9a18-\
4ac3cfc9b18e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"80.", "*", "t", "*", 
       RowBox[{"Cos", "[", "theta", "]"}]}], "==", "100"}], " ", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"80", "t", "*", 
        RowBox[{"Sin", "[", "theta", "]"}]}], "-", 
       RowBox[{"4.9", 
        RowBox[{"t", "^", "2"}]}]}], "\[Equal]", "15"}]}], "}"}], ",", "t"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.577043745565235*^9, 3.577043777133658*^9}, {
  3.651522000329465*^9, 
  3.6515220753444967`*^9}},ExpressionUUID->"58f23cd5-5973-4cb5-9fa8-\
a3dfde06929f"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{{3.57704376674619*^9, 3.577043777911663*^9}, 
   3.5771765284058*^9, 3.651520856841202*^9, 3.651521938749186*^9, 
   3.6515220012197533`*^9, {3.6515220486463346`*^9, 
   3.651522077093299*^9}},ExpressionUUID->"5603dcc2-0574-40be-9653-\
bda1de40b45f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"80", "*", "t", "*", 
       RowBox[{"Cos", "[", "theta", "]"}]}], "==", "100"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"80", "t", "*", 
        RowBox[{"Sin", "[", "theta", "]"}]}], "-", 
       RowBox[{"4.9", "\[IndentingNewLine]", 
        RowBox[{"t", "^", "2"}]}]}], "\[Equal]", "15"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "theta"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.577043842236166*^9, 3.57704390104712*^9}, {
  3.577044280838449*^9, 
  3.577044281366375*^9}},ExpressionUUID->"7e4840a1-1792-4442-9cef-\
d4915a683644"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NSolve", "::", "ifun"}], "MessageName"], ":", 
  " ", "\<\"Inverse functions are being used by \[NoBreak]\\!\\(NSolve\\)\
\[NoBreak], so some solutions may not be found; use Reduce for complete \
solution information. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/NSolve\\\", ButtonNote -> \\\"NSolve::ifun\\\"]\\)\
\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.577043879859068*^9, 3.577043901490953*^9}, 
   3.577044282419467*^9, 3.5771765793417997`*^9, 3.6515208581613493`*^9, 
   3.651521938987977*^9},ExpressionUUID->"d7cd15fb-c482-4e66-b7c5-\
41d5c496c819"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", 
      RowBox[{"-", "16.08687475952258`"}]}], ",", 
     RowBox[{"theta", "\[Rule]", 
      RowBox[{"-", "1.648577829896174`"}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "theta", "]"}], "\[Rule]", 
      RowBox[{"-", "0.996976543665251`"}]}], ",", 
     RowBox[{
      RowBox[{"Cos", "[", "theta", "]"}], "\[Rule]", 
      RowBox[{"-", "0.0777030976299524`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", 
      RowBox[{"-", "16.08687475952258`"}]}], ",", 
     RowBox[{"theta", "\[Rule]", "1.648577829896174`"}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "theta", "]"}], "\[Rule]", 
      RowBox[{"-", "0.996976543665251`"}]}], ",", 
     RowBox[{
      RowBox[{"Cos", "[", "theta", "]"}], "\[Rule]", 
      RowBox[{"-", "0.0777030976299524`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", 
      RowBox[{"-", "1.282814610305484`"}]}], ",", 
     RowBox[{"theta", "\[Rule]", 
      RowBox[{"-", "2.9149212028790186`"}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "theta", "]"}], "\[Rule]", 
      RowBox[{"-", "0.22473537002486751`"}]}], ",", 
     RowBox[{
      RowBox[{"Cos", "[", "theta", "]"}], "\[Rule]", 
      RowBox[{"-", "0.9744198342910442`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", 
      RowBox[{"-", "1.282814610305484`"}]}], ",", 
     RowBox[{"theta", "\[Rule]", "2.9149212028790186`"}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "theta", "]"}], "\[Rule]", 
      RowBox[{"-", "0.22473537002486751`"}]}], ",", 
     RowBox[{
      RowBox[{"Cos", "[", "theta", "]"}], "\[Rule]", 
      RowBox[{"-", "0.9744198342910442`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", "1.282814610305484`"}], ",", 
     RowBox[{"theta", "\[Rule]", 
      RowBox[{"-", "0.22667145071077463`"}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "theta", "]"}], "\[Rule]", "0.22473537002486751`"}],
      ",", 
     RowBox[{
      RowBox[{"Cos", "[", "theta", "]"}], "\[Rule]", 
      "0.9744198342910442`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", "1.282814610305484`"}], ",", 
     RowBox[{"theta", "\[Rule]", "0.22667145071077463`"}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "theta", "]"}], "\[Rule]", "0.22473537002486751`"}],
      ",", 
     RowBox[{
      RowBox[{"Cos", "[", "theta", "]"}], "\[Rule]", 
      "0.9744198342910442`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", "16.08687475952258`"}], ",", 
     RowBox[{"theta", "\[Rule]", 
      RowBox[{"-", "1.4930148236936192`"}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "theta", "]"}], "\[Rule]", "0.996976543665251`"}], 
     ",", 
     RowBox[{
      RowBox[{"Cos", "[", "theta", "]"}], "\[Rule]", 
      "0.0777030976299524`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", "16.08687475952258`"}], ",", 
     RowBox[{"theta", "\[Rule]", "1.4930148236936192`"}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "theta", "]"}], "\[Rule]", "0.996976543665251`"}], 
     ",", 
     RowBox[{
      RowBox[{"Cos", "[", "theta", "]"}], "\[Rule]", 
      "0.0777030976299524`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.577043879859997*^9, 3.577043901492482*^9}, 
   3.5770442824219933`*^9, 3.5771765793574*^9, 3.651520858170277*^9, 
   3.6515219390004387`*^9},ExpressionUUID->"7653a4a4-149c-44a0-96cd-\
b666e7a49756"]
}, Open  ]],

Cell[TextData[{
 "The two solutions for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", " ", "<", " ", "theta", " ", "<", 
    RowBox[{"\[Pi]", "/", "2"}]}], TraditionalForm]],ExpressionUUID->
  "54f20f57-3167-4257-a606-7b14ce8969c0"],
 " are theta=",
 StyleBox["0.2267",
  FontColor->RGBColor[1, 0, 0]],
 " and ",
 StyleBox["1.4930",
  FontColor->RGBColor[1, 0, 0]],
 ".  In degrees:"
}], "Text",
 CellChangeTimes->{{3.651522154029902*^9, 
  3.651522258490157*^9}},ExpressionUUID->"34c5141a-8db9-4201-81b3-\
0e0d3fb4abcb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t1deg", "=", 
  RowBox[{
   RowBox[{"0.226671", "/", "Pi"}], "*", "180"}]}]], "Input",
 CellChangeTimes->{{3.577043939708416*^9, 3.577043964139162*^9}, 
   3.577044290383047*^9},ExpressionUUID->"9ab9623e-c61c-4935-b6bd-\
533e97471a1d"],

Cell[BoxData["12.987291638009886`"], "Output",
 CellChangeTimes->{3.577043965090088*^9, 3.577044291788028*^9, 
  3.651520858681178*^9, 
  3.6515219390860453`*^9},ExpressionUUID->"0e429eb0-fb9f-4fdd-9f56-\
3390526ec1b9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t2deg", "=", 
  RowBox[{
   RowBox[{"1.49301", "/", "Pi"}], "*", "180"}]}]], "Input",
 CellChangeTimes->{{3.577043967044531*^9, 3.577043977824946*^9}, 
   3.5770443053439903`*^9},ExpressionUUID->"eb44a7da-6fc5-49dc-82fc-\
f8af0f1fcf03"],

Cell[BoxData["85.54317177082704`"], "Output",
 CellChangeTimes->{3.5770439788172407`*^9, 3.577044306502891*^9, 
  3.651520858752942*^9, 
  3.651521939153516*^9},ExpressionUUID->"b04a5868-21be-41fe-8723-\
c41215060696"]
}, Open  ]],

Cell[TextData[{
 "So we need our angles to be larger than 12.99 degrees and less than 85.54 \
degrees.\n\nThese two angles are ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "1"], TraditionalForm]],ExpressionUUID->
  "7f7bff94-cb22-47f5-857f-1946f966d610"],
 "and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "4"], TraditionalForm]],ExpressionUUID->
  "34a7f8e2-4a96-476b-a996-01c8b7c3cdba"],
 "."
}], "Text",
 CellChangeTimes->{{3.577044219623129*^9, 3.577044249412202*^9}, {
  3.5770442974857883`*^9, 3.577044313227323*^9}, {3.577044736325201*^9, 
  3.577044781476297*^9}},ExpressionUUID->"3f717302-e813-406a-928d-\
e5c3a165b0a0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Back Wall", "Section",
 CellChangeTimes->{{3.57704399910394*^9, 
  3.5770440126471148`*^9}},ExpressionUUID->"605fb6b2-e371-42a3-8709-\
6352e0149c50"],

Cell[TextData[{
 "When will the projectile go past the back wall?\n\nThe projectile will hit \
the top of the back wall when ",
 StyleBox["x",
  FontSlant->"Italic"],
 " = 600 and when ",
 StyleBox["y",
  FontSlant->"Italic"],
 " = 15\n\n"
}], "Text",
 CellChangeTimes->{{3.577043473656802*^9, 3.577043488966304*^9}, {
  3.577043699510313*^9, 3.577043737202834*^9}, {3.577043795412178*^9, 
  3.5770438228102407`*^9}, {3.5770440305034113`*^9, 3.577044032782607*^9}, {
  3.577044177423098*^9, 3.5770442011885443`*^9}, {3.577044254843997*^9, 
  3.57704425881177*^9}},ExpressionUUID->"fc64a173-9dcf-47d2-b9d3-\
97e3f52d349c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"80", "*", "t", "*", 
       RowBox[{"Cos", "[", "theta", "]"}]}], "\[Equal]", "600"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"80", "t", "*", 
        RowBox[{"Sin", "[", "theta", "]"}]}], "-", 
       RowBox[{"4.9", "\[IndentingNewLine]", 
        RowBox[{"t", "^", "2"}]}]}], "\[Equal]", "15"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "theta"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.577043842236166*^9, 3.57704390104712*^9}, {
  3.577044274495667*^9, 3.577044274789934*^9}, {3.57704431785366*^9, 
  3.5770443180449867`*^9}},ExpressionUUID->"562de2f4-1163-473d-9288-\
1e4eb896f5c1"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NSolve", "::", "ifun"}], "MessageName"], ":", 
  " ", "\<\"Inverse functions are being used by \[NoBreak]\\!\\(NSolve\\)\
\[NoBreak], so some solutions may not be found; use Reduce for complete \
solution information. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/NSolve\\\", ButtonNote -> \\\"NSolve::ifun\\\"]\\)\
\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.577043879859068*^9, 3.577043901490953*^9}, 
   3.577044318839102*^9, 3.577176712617*^9, 3.651520859003256*^9, 
   3.6515219393480263`*^9},ExpressionUUID->"5c20f1a7-7596-452e-805a-\
b9ceba738f05"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", 
      RowBox[{"-", "13.206512522017062`"}]}], ",", 
     RowBox[{"theta", "\[Rule]", 
      RowBox[{"-", "2.174750573233465`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", 
      RowBox[{"-", "9.274760366650153`"}]}], ",", 
     RowBox[{"theta", "\[Rule]", 
      RowBox[{"-", "2.5126436135323047`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", "9.274760366650153`"}], ",", 
     RowBox[{"theta", "\[Rule]", "0.6289490400574884`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", "13.206512522017062`"}], ",", 
     RowBox[{"theta", "\[Rule]", "0.9668420803563283`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.577043879859997*^9, 3.577043901492482*^9}, 
   3.577044318841535*^9, 3.577176712617*^9, 3.6515208590068073`*^9, 
   3.6515219393520527`*^9},ExpressionUUID->"a0399b81-10a2-4bea-997b-\
b61b83d590cc"]
}, Open  ]],

Cell[TextData[{
 "Again, we\[CloseCurlyQuote]re looking for solutions where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", " ", "<", " ", "theta", " ", "<", 
    RowBox[{"\[Pi]", "/", "2"}]}], TraditionalForm]],ExpressionUUID->
  "cf98da4d-e91e-4f93-9220-bb8055c69899"]
}], "Text",
 CellChangeTimes->{{3.651522294393217*^9, 
  3.651522315293376*^9}},ExpressionUUID->"af79f0aa-0461-49a4-8860-\
3b305dde5022"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t1deg", "=", 
  RowBox[{
   RowBox[{"0.628949", "/", "Pi"}], "*", "180"}]}]], "Input",
 CellChangeTimes->{{3.577043939708416*^9, 3.577043964139162*^9}, {
  3.577044328384617*^9, 
  3.577044349797514*^9}},ExpressionUUID->"76e59907-d5ed-4163-8e0e-\
b219ef5f6c65"],

Cell[BoxData["36.036123228973615`"], "Output",
 CellChangeTimes->{
  3.577043965090088*^9, {3.577044336457951*^9, 3.577044350634899*^9}, 
   3.651520859085229*^9, 
   3.6515219395297117`*^9},ExpressionUUID->"6c5e7f39-fa91-4d0e-a16c-\
2109e7b22f23"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t2deg", "=", 
  RowBox[{
   RowBox[{"0.966842", "/", "Pi"}], "*", "180"}]}]], "Input",
 CellChangeTimes->{{3.577043967044531*^9, 3.577043977824946*^9}, {
  3.5770443555249443`*^9, 
  3.57704435725312*^9}},ExpressionUUID->"b522e952-f675-45b2-bac7-\
cc068dca2036"],

Cell[BoxData["55.39596605598754`"], "Output",
 CellChangeTimes->{3.5770439788172407`*^9, 3.577044358151308*^9, 
  3.6515208591600246`*^9, 
  3.6515219396096067`*^9},ExpressionUUID->"9fa3de9c-87ef-4c7e-b06a-\
77854b57324f"]
}, Open  ]],

Cell[TextData[{
 "We have just computed ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "2"], TraditionalForm]],ExpressionUUID->
  "361e29df-ff13-4b06-968d-877445508116"],
 "and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "3"], TraditionalForm]],ExpressionUUID->
  "b0cba11b-208e-47a7-a19e-465a463339d0"],
 "."
}], "Text",
 CellChangeTimes->{
  3.577044379621958*^9, {3.5770448031162567`*^9, 
   3.5770448256777687`*^9}},ExpressionUUID->"ce8074fe-1347-492f-957f-\
d3cde50aed06"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Conclusion", "Section",
 CellChangeTimes->{{3.57704399910394*^9, 3.5770440126471148`*^9}, {
   3.577044837277952*^9, 3.577044839083811*^9}, 
   3.577045088301484*^9},ExpressionUUID->"e073b537-bd15-4f91-aaab-\
8cefe96bc2b8"],

Cell["\<\
Therefore

For angles between (0, 12.99\[Degree]) the projectile strikes the front wall \
and misses the city.

For angles between (12.99\[Degree], 36.04\[Degree]) the projectile makes it \
into the city.

For angles between (36.04\[Degree], 55.40\[Degree]) the projectiles clears \
the city and strikes the ground past the back wall.\[LineSeparator]\
\[LineSeparator]For angles between (55.40\[Degree], 85.54\[Degree]) the \
projectile again strikes the city.

For angles between (85.54\[Degree], 90\[Degree]) the projectile hits the \
ground in front of the front wall.
\
\>", "Text",
 CellChangeTimes->{{3.577043473656802*^9, 3.577043488966304*^9}, {
  3.577043699510313*^9, 3.577043737202834*^9}, {3.577043795412178*^9, 
  3.5770438228102407`*^9}, {3.5770440305034113`*^9, 3.577044032782607*^9}, {
  3.577044177423098*^9, 3.5770442011885443`*^9}, {3.577044254843997*^9, 
  3.57704425881177*^9}, {3.577044865605749*^9, 
  3.57704508830179*^9}},ExpressionUUID->"c545342a-4ce4-4175-a561-\
03a1fede77cf"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1264, 1038},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 27, \
2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 160, 3, 92, "Title", "ExpressionUUID" -> \
"c529f58b-248d-42b4-b766-0cb807be5ef8"],
Cell[742, 27, 972, 23, 87, "Text", "ExpressionUUID" -> \
"e3a13556-f46f-4ae3-b094-c57a65eeafa7"],
Cell[CellGroupData[{
Cell[1739, 54, 90060, 1482, 595, "Input", "ExpressionUUID" -> \
"8c513410-0220-40bb-8a65-29dc6acf9865"],
Cell[91802, 1538, 90128, 1484, 595, "Output", "ExpressionUUID" -> \
"2a467e4e-f2f1-4699-902f-330a4ceda846"]
}, Open  ]],
Cell[181945, 3025, 152, 3, 32, "Input", "ExpressionUUID" -> \
"5dc22647-9bfc-4d0a-a19b-d63bb8430c0f"],
Cell[182100, 3030, 359, 7, 30, "Text", "ExpressionUUID" -> \
"0fc66281-4dad-4edc-a037-0c25ee607b22"],
Cell[182462, 3039, 1642, 45, 135, "Text", "ExpressionUUID" -> \
"1100c2f1-afd7-48b5-b9f8-0150a3ba1710"],
Cell[184107, 3086, 152, 3, 32, "Input", "ExpressionUUID" -> \
"83dd9b8d-49f5-4293-842e-1880911822d8"],
Cell[CellGroupData[{
Cell[184284, 3093, 153, 3, 64, "Section", "ExpressionUUID" -> \
"50567b47-2720-42d6-9716-4d3a77ffd4c3"],
Cell[184440, 3098, 880, 24, 88, "Text", "ExpressionUUID" -> \
"8f96358f-ef2b-4807-a077-9995608c3aad"],
Cell[185323, 3124, 71, 0, 30, "Text", "ExpressionUUID" -> \
"3c59b348-94ea-449f-869a-f5c5519ac65c"],
Cell[CellGroupData[{
Cell[185419, 3128, 2099, 51, 75, "Input", "ExpressionUUID" -> \
"b891c9f0-1513-4c9d-8f0c-9c6ea8f3edca"],
Cell[187521, 3181, 2031, 39, 541, "Output", "ExpressionUUID" -> \
"f2530342-e096-4696-ada6-7b42ecab7707"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[189601, 3226, 156, 3, 64, "Section", "ExpressionUUID" -> \
"2b3c6848-f58e-4386-a470-a8c6d744b0e7"],
Cell[189760, 3231, 600, 15, 106, "Text", "ExpressionUUID" -> \
"f62f92bb-5ec5-43f8-9a18-4ac3cfc9b18e"],
Cell[CellGroupData[{
Cell[190385, 3250, 611, 18, 32, "Input", "ExpressionUUID" -> \
"58f23cd5-5973-4cb5-9fa8-a3dfde06929f"],
Cell[190999, 3270, 315, 6, 32, "Output", "ExpressionUUID" -> \
"5603dcc2-0574-40be-9653-bda1de40b45f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[191351, 3281, 676, 19, 54, "Input", "ExpressionUUID" -> \
"7e4840a1-1792-4442-9cef-d4915a683644"],
Cell[192030, 3302, 690, 13, 24, "Message", "ExpressionUUID" -> \
"d7cd15fb-c482-4e66-b7c5-41d5c496c819"],
Cell[192723, 3317, 3542, 94, 180, "Output", "ExpressionUUID" -> \
"7653a4a4-149c-44a0-96cd-b666e7a49756"]
}, Open  ]],
Cell[196280, 3414, 526, 17, 31, "Text", "ExpressionUUID" -> \
"34c5141a-8db9-4201-81b3-0e0d3fb4abcb"],
Cell[CellGroupData[{
Cell[196831, 3435, 259, 6, 32, "Input", "ExpressionUUID" -> \
"9ab9623e-c61c-4935-b6bd-533e97471a1d"],
Cell[197093, 3443, 219, 4, 32, "Output", "ExpressionUUID" -> \
"0e429eb0-fb9f-4fdd-9f56-3390526ec1b9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[197349, 3452, 260, 6, 32, "Input", "ExpressionUUID" -> \
"eb44a7da-6fc5-49dc-82fc-f8af0f1fcf03"],
Cell[197612, 3460, 218, 4, 32, "Output", "ExpressionUUID" -> \
"b04a5868-21be-41fe-8723-c41215060696"]
}, Open  ]],
Cell[197845, 3467, 654, 17, 70, "Text", "ExpressionUUID" -> \
"3f717302-e813-406a-928d-e5c3a165b0a0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[198536, 3489, 155, 3, 64, "Section", "ExpressionUUID" -> \
"605fb6b2-e371-42a3-8709-6352e0149c50"],
Cell[198694, 3494, 621, 15, 106, "Text", "ExpressionUUID" -> \
"fc64a173-9dcf-47d2-b9d3-97e3f52d349c"],
Cell[CellGroupData[{
Cell[199340, 3513, 729, 19, 54, "Input", "ExpressionUUID" -> \
"562de2f4-1163-473d-9288-1e4eb896f5c1"],
Cell[200072, 3534, 685, 13, 24, "Message", "ExpressionUUID" -> \
"5c20f1a7-7596-452e-805a-b9ceba738f05"],
Cell[200760, 3549, 1013, 27, 32, "Output", "ExpressionUUID" -> \
"a0399b81-10a2-4bea-997b-b61b83d590cc"]
}, Open  ]],
Cell[201788, 3579, 405, 10, 31, "Text", "ExpressionUUID" -> \
"af79f0aa-0461-49a4-8860-3b305dde5022"],
Cell[CellGroupData[{
Cell[202218, 3593, 285, 7, 32, "Input", "ExpressionUUID" -> \
"76e59907-d5ed-4163-8e0e-b219ef5f6c65"],
Cell[202506, 3602, 248, 5, 32, "Output", "ExpressionUUID" -> \
"6c5e7f39-fa91-4d0e-a16c-2109e7b22f23"]
}, Open  ]],
Cell[CellGroupData[{
Cell[202791, 3612, 286, 7, 32, "Input", "ExpressionUUID" -> \
"b522e952-f675-45b2-bac7-cc068dca2036"],
Cell[203080, 3621, 222, 4, 32, "Output", "ExpressionUUID" -> \
"9fa3de9c-87ef-4c7e-b06a-77854b57324f"]
}, Open  ]],
Cell[203317, 3628, 500, 16, 32, "Text", "ExpressionUUID" -> \
"ce8074fe-1347-492f-957f-d3cde50aed06"]
}, Open  ]],
Cell[CellGroupData[{
Cell[203854, 3649, 229, 4, 64, "Section", "ExpressionUUID" -> \
"e073b537-bd15-4f91-aaab-8cefe96bc2b8"],
Cell[204086, 3655, 1014, 24, 239, "Text", "ExpressionUUID" -> \
"c545342a-4ce4-4175-a561-03a1fede77cf"]
}, Open  ]]
}, Open  ]]
}
]
*)

