<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Parametric surfaces [10.5]
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
Parametric surfaces [10.5]
</h1>
<p class="show"><img src="0g/10.5.Gehry.jpg">
<br>
<i>Walt Disney concert hall, Los Angeles, architect: Frank Gehry</i>
<ul class="else"><li>Alternate ways to describe a surface,
<li>In high symmetry situations, a different parameterization may be simpler (than Cartesian coordinates!)
<li>Eventually we'd like to answer questions like "how much aluminum will we need for that concert hall roof?".
</ul>


<h3></h3>

<p class="show">A vector function $\myv r(t)=\myc{f(t),g(t),h(t)}$ of a <i>single</i> parameter described a curve in space.  


<ul>
<li>Suppose that $$\nonumber \myv r(u,v)=\langle x(u,v), y(u,v), z(u,v) \rangle$$
is a vector-valued function,
<li>Defined on a region $D$ of the $u$- $v$-plane.
<li>As $(u,v)$ varies throughout $D$, then $\myv r$ traces out a <b>surface</b> $S$ in 3 dimensions.
</ul>
<p class="show"><img src="0g/10.5.uv2r.jpg" class="big">

<h3>Example: cylinder</h3>
<p class="show">$$\myv r(u,v)=\langle 2\cos u, v, 2\sin u  \rangle$$
<p class="show center"><img src="0g/10.5.cylinder.jpg">

<h3>Example: plane</h3>
<p class="show">$$\myv r(u,v)=\myv r_0 + u\myv a+v\myv b$$
<p class="show center"><img src="0g/10.5.plane.jpg">


<h3> $x$ and $y$ as 'parameters'</h3>
<p class="show">Plot the surface defined by
$$z=\frac{x^2+2y^2}3.$$

<p>For our two parameters, we could just use $u=x$, $v=y$, and then 
$z=\frac{u^2+2v^2}3.$

<p>Turning this into a vector function of $u$ and $v$:
$$\myv r=\langle u, v, (u^2+2v^2)/3 \rangle$$
<p class="center"><img src="0g/10.5.GeoParametric.jpg">


<h3>Choosing parameters based on symmetries/forms</h3>
<!--<p class="show">See <a href="10.5.nb">10.5.nb</a>.-->
<p class="show">Consider the points that fulfill:
$$\frac{x^2}{4}+y^2+\frac{z^2}{4} = 1$$
<p>You could solve for $z$:
$$z=\pm\sqrt{4\left( 1-\frac{x^2}{4}-y^2 \right)} $$
and plot $\myc{x, y, z(x,y)}$.

<p>Or, we re-arrange the equation into 
$$x^2+z^2 = 4(1-y^2).$$
We recognize the left side as the equation for a circle with a 
radius $\sqrt{4(1-y^2)}$ that depends on $y$.  

<p>This suggests that we write the *radius* as one of the parameters, 
$u=2\sqrt{1-y^2}$ (and inverting: $y=\sqrt{1-\frac14 u^2}$), and then we could write $x$ and $y$ in terms of a
"polar angle" parameter $v$ sweeping around a circle of radius $u$ like this:
$$\myv r(u,v)=\myc{u\cos v,\sqrt{1-\frac14u^2},u\sin v}$$

<h3>Todo</h3>
<ul class="todo">
<li>Bagels, bagels, bagels</ul>

<h4 class="handout">Image credits</h4>
<p class="handout"><a href="https://www.flickr.com/photos/jimmyyeh1982/13025903825">Jimmy Yeh</a>

<?php include "../../classes/3.h" ?>