<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Functions of several variables [11.1]
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
Functions of several variables [11.1]
</h1>


<p><img src="0g/11.1.terraces.jpg" class="big">

<h3>Tabular data</h3>
<p class="show">Things that depend on more than one variable.
<p class="show">$T_w(T,v)$: A  table of <span style="color: #0ce;">wind chill temperature, $T_w$
</span> (in $^o$C)  which depends on the air temperature, $T$, and the speed of the wind, $v$.<br>
<img src="0g/11.1.windchill.jpg" class="big"><br>

<h3>Domain and range</h3>
<p class="show">Consider the function
$$g(x,y)=\sqrt{9-(x^2+y^2)}.$$

<p>In order that the function evaluate to something non-imaginary, the greatest possible <b>domain</b> is $\{x,y: x^2+y^2\leq 9\}$.<br>
<img src="0g/11.1.domainrange.jpg" class="big">
<p>The function can be plotted as a surface, with $z=g(x,y)$, and we see that the corresponding <b>range</b> is $0 \leq z \leq 3$.


<h3>Level curves / contours</h3>
<p class="show">One way of visualizing the 3-d surface in 2-d is to plot <b>level curves</b>: <b>Cross-sections</b> of the surface at a discrete set of <b>height values</b> $\{ k\}$.
<p>You consider a particular $z$-height, setting $k=g(x,y)$, and then sketch the resulting curve in the $x$-, $y$-plane.<br>
<img src="0g/11.1.contours.jpg" class="big">



<p><img src="0g/11.1.levelc.jpg" class="rightalign">
For a function of 2 variables, $g(x,y)$ we plot level curves $k=g$.
<br style='clear:both'>

<h3>To do</h3>
<ul class="todo"><li>Drawing contours
</ul>




<h3>Visualizations</h3>
<p class="show">A couple different ways to visualize surfaces in 3-d...
<p>Consider two functions:
$$f(x,y)=12-x-y;\ \ \ g(x,y)=\frac{-9y}{x^2+y^2+1}.$$

<h4>Surface plots</h4>
<p><img src="0g/11.1.fplotg.jpg" class="big">

<h4>Contour plots</h4>
<p><img src="0g/11.1.terraces2.jpg" class="big">
<p><img src="0g/11.1.fcontou.jpg" class="big">

<ul>
<li>Sagemath and Mathematica color the <b>lower</b> heights <b>darker</b> by default.
<li><i>How can you tell</i> from the contour plot, where the height is changing most rapidly?  When the surface is flat?
<li><i>How can you tell</i> from the contour plot how to move away from point A in such a way that the height will not change?
<li><i>How can you estimate</i> the value of the function at point B?
</ul>

<h3>Todo</h3>
<ul class="todo"><li>Using contour plots
</ul>

<div class="justme">
<h4>Surface plot with contours</h4>
<p>You can <b>display  contours</b> on the surface plot (rather than a rectangular mesh) with this command:
<p><img src="0g/11.1.fsurfcontour.jpg" class="big">
<ul><li><tt>#3</tt> refers to the 3-rd coordinate, $z$
<li><tt>Mesh -> 10</tt> tells <i>Mathematica</i> to display 10 constant-$z$ lines, equally spaced in $z$.
</ul>
</div>

<h3>Level surfaces of 3 variables</h3>
<p>For a function, $h(x,y,z)$ of 3 variables, the mathematical entities $k=h$ are <b>level surfaces</b>.<br>
<img src="0g/11.1.levels.jpg" class="big">

<!--
<h3>To Do</h3>
<ul class="else">
<li>Level Surfaces
</ul>
-->


<div class="justme">
<h3>More glitz...</h3>

<p class='show'>It's possible to combine surface plots and corresponding contour plots all in the same figure (click it to see the underlying notebook)...<br>
<a href="0g/11.1.contoursurface.nb"><img src="0g/11.1.contoursurface.jpg" class="big"></a>
</div>


<h4 class="handout">Image credits</h4>
<p class='handout'><a href="http://www.flickr.com/photos/gonger/390975497">The Gonger</a>, <a href="http://www.flickr.com/photos/luoyics/248627143">luoyics</a>

<?php include "../../classes/3.h" ?>