(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    352640,       6036]
NotebookOptionsPosition[    351596,       5996]
NotebookOutlinePosition[    351954,       6012]
CellTagsIndexPosition[    351911,       6009]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Remove", "::", "rmnsm"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"There are no symbols matching \
\\\"\[NoBreak]\\!\\(\\\"Global`*\\\"\\)\[NoBreak]\\\". \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Remove/rmnsm\\\", \
ButtonNote -> \\\"Remove::rmnsm\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.5914880640390863`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myf", "=", 
  RowBox[{"12", "-", "x", "-", "y"}]}]], "Input",
 CellChangeTimes->{{3.591489102642796*^9, 3.5914891142382593`*^9}}],

Cell[BoxData[
 RowBox[{"12", "-", "x", "-", "y"}]], "Output",
 CellChangeTimes->{3.591489115400118*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{"myf", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "5"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "2"}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"x", ",", "Large", ",", "Bold"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"y", ",", "Large", ",", "Bold"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"z", ",", "Large", ",", "Bold"}], "]"}]}], "}"}]}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.591488085106564*^9, 3.591488094719746*^9}, {
   3.591488138478614*^9, 3.59148816640482*^9}, {3.5914882097499237`*^9, 
   3.591488219090788*^9}, {3.591488267787445*^9, 3.5914882721463547`*^9}, {
   3.591488323027038*^9, 3.5914883255846233`*^9}, {3.591488356079853*^9, 
   3.591488378174918*^9}, 3.591488513005013*^9, {3.591489126864025*^9, 
   3.591489127438151*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1nXuYlVW9x9+ZYbjJyDADc2GAYWAjJ5NrRfWgzWsCw049FmqaI3ijzHKj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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw1mXngTVX3xu89e59QCiHzTIY0GKIUMqUyhaIXjYQyJ2k0ZMicprdoLg2S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         "]], 
        Polygon3DBox[CompressedData["
1:eJw1mnfgz1UfxT/33o+RJMloyMompfGkTVMKpaVCGS0aGkakjJKUStEwCiEq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         "]], 
        Polygon3DBox[CompressedData["
1:eJwt13ncjWUaAODvO+dIliRLRpFBGEKTtawjW9nK3tgauylLZclkKWPf96US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         "]]}]}, {}, {}, {}, {}}, {
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0rsvpFEYwOGPcRsMK6Jd0RAFpSgoN4pViSjoiGK3WIlsQakQOh1/AS0R
+k3o3MfMuM2ystkIu2Tjfg3PSRS/eU7mO5nznsxX0zvQ8S0niqJR3SqsL/Vb
87lR9IE/WM0NNvKQrTxnO5/Zw9JYFCX01bqew2zmONs4xS7OsJ+L/M5l/ucJ
77Wta/3TioFSXGWaa8xwnTthJu5yk3vcYlL74Xd4wBSzTPMnMzzkDo+4y1+c
dY9TPuhYN+GOmjBbkiNc4iAX2MdpdnKSnzjGJg6xjrX6Yh1nNx+d8Zl/2cIs
G8K9+JEX9v3hncp1FfaqyoxlrGSCFSwNe1jCBItZwng4j0UsYL4KrWMsCP9x
+I6vytNLeKYnGSOa83H2/j68Acy/Svc=
       "]]}, {
      Line3DBox[{690, 1004, 473, 689, 1113, 912, 691, 1114, 913, 692, 1115, 
       914, 693, 1116, 915, 694, 1117, 916, 695, 1118, 1010, 1217, 696, 1119, 
       917, 697, 1120, 918, 698, 1121, 919, 699, 1122, 920, 700, 1123, 921, 
       701, 1124, 922, 702, 1322, 1005, 923, 1006}], 
      Line3DBox[{704, 1011, 1218, 703, 488, 705, 1125, 924, 706, 1126, 925, 
       707, 1127, 926, 708, 1128, 927, 709, 1129, 1012, 1219, 710, 1013, 1220,
        711, 1130, 928, 712, 1131, 929, 713, 1132, 930, 714, 1133, 931, 715, 
       1134, 932, 716, 1135, 933, 717}], 
      Line3DBox[{719, 1014, 1221, 718, 1015, 1222, 720, 504, 721, 1136, 934, 
       722, 1137, 935, 723, 1138, 936, 724, 1139, 1016, 1223, 725, 1017, 1224,
        726, 1018, 1225, 727, 1140, 937, 728, 1141, 938, 729, 1142, 939, 730, 
       1143, 940, 731, 1144, 941, 732}], 
      Line3DBox[{734, 1019, 1226, 733, 1020, 1227, 735, 1021, 1228, 736, 520, 
       737, 1145, 942, 738, 1146, 943, 739, 1147, 1022, 1229, 740, 1023, 1230,
        741, 1024, 1231, 742, 1025, 1232, 743, 1148, 944, 744, 1149, 945, 745,
        1150, 946, 746, 1151, 947, 747}], 
      Line3DBox[{749, 1026, 1233, 748, 1027, 1234, 750, 1028, 1235, 751, 1029,
        1236, 752, 536, 753, 1152, 948, 754, 1153, 1030, 1237, 755, 1031, 
       1238, 756, 1032, 1239, 757, 1033, 1240, 758, 1034, 1241, 759, 1154, 
       949, 760, 1155, 950, 761, 1156, 951, 762}], 
      Line3DBox[{764, 1035, 1242, 763, 1036, 1243, 765, 1037, 1244, 766, 1038,
        1245, 767, 1039, 1246, 768, 552, 769, 1157, 1040, 1247, 770, 1041, 
       1248, 771, 1042, 1249, 772, 1043, 1250, 773, 1044, 1251, 774, 1045, 
       1252, 775, 1158, 952, 776, 1159, 953, 777}], 
      Line3DBox[{781, 1160, 954, 779, 1161, 955, 783, 1162, 956, 785, 1163, 
       957, 787, 1164, 958, 789, 1165, 959, 791, 1166, 569, 793, 1167, 960, 
       795, 1168, 961, 797, 1169, 962, 799, 1170, 963, 801, 1171, 964, 803, 
       1172, 965, 805, 1174, 967, 807}], 
      Line3DBox[{806, 966, 1173, 804, 1265, 1057, 802, 1264, 1056, 800, 1263, 
       1055, 798, 1262, 1054, 796, 1261, 1053, 794, 1260, 1052, 792, 1259, 
       568, 790, 1258, 1051, 788, 1257, 1050, 786, 1256, 1049, 784, 1255, 
       1048, 782, 1254, 1047, 778, 1253, 1046, 780}], 
      Line3DBox[{809, 1058, 1266, 808, 1175, 968, 810, 1176, 969, 811, 1177, 
       970, 812, 1178, 971, 813, 1179, 972, 814, 1180, 1059, 1267, 815, 585, 
       816, 1181, 973, 817, 1182, 974, 818, 1183, 975, 819, 1184, 976, 820, 
       1185, 977, 821, 1186, 978, 822}], 
      Line3DBox[{824, 1060, 1268, 823, 1061, 1269, 825, 1187, 979, 826, 1188, 
       980, 827, 1189, 981, 828, 1190, 982, 829, 1191, 1062, 1270, 830, 1063, 
       1271, 831, 601, 832, 1192, 983, 833, 1193, 984, 834, 1194, 985, 835, 
       1195, 986, 836, 1196, 987, 837}], 
      Line3DBox[{839, 1064, 1272, 838, 1065, 1273, 840, 1066, 1274, 841, 1197,
        988, 842, 1198, 989, 843, 1199, 990, 844, 1200, 1067, 1275, 845, 1068,
        1276, 846, 1069, 1277, 847, 617, 848, 1201, 991, 849, 1202, 992, 850, 
       1203, 993, 851, 1204, 994, 852}], 
      Line3DBox[{854, 1070, 1278, 853, 1071, 1279, 855, 1072, 1280, 856, 1073,
        1281, 857, 1205, 995, 858, 1206, 996, 859, 1207, 1074, 1282, 860, 
       1075, 1283, 861, 1076, 1284, 862, 1077, 1285, 863, 633, 864, 1208, 997,
        865, 1209, 998, 866, 1210, 999, 867}], 
      Line3DBox[{869, 1078, 1286, 868, 1079, 1287, 870, 1080, 1288, 871, 1081,
        1289, 872, 1082, 1290, 873, 1211, 1000, 874, 1212, 1083, 1291, 875, 
       1084, 1292, 876, 1085, 1293, 877, 1086, 1294, 878, 1087, 1295, 879, 
       649, 880, 1213, 1001, 881, 1214, 1002, 882}], 
      Line3DBox[{884, 1088, 1296, 883, 1089, 1297, 885, 1090, 1298, 886, 1091,
        1299, 887, 1092, 1300, 888, 1093, 1301, 889, 1215, 1094, 1302, 890, 
       1095, 1303, 891, 1096, 1304, 892, 1097, 1305, 893, 1098, 1306, 894, 
       1099, 1307, 895, 665, 896, 1216, 1003, 897}], 
      Line3DBox[{911, 1009, 685, 910, 1321, 1111, 909, 1320, 1110, 908, 1319, 
       1109, 907, 1318, 1108, 906, 1317, 1107, 905, 1316, 1106, 904, 1315, 
       1314, 1105, 903, 1313, 1104, 902, 1312, 1103, 901, 1311, 1102, 900, 
       1310, 1101, 899, 1309, 1100, 898, 1112, 1308, 1007, 1008}]}, {
      Line3DBox[{251, 474, 1113, 252, 488, 280, 1222, 503, 295, 1227, 518, 
       310, 1234, 533, 325, 1243, 548, 340, 1254, 563, 1161, 355, 578, 1175, 
       370, 1269, 593, 385, 1273, 608, 400, 1279, 623, 415, 1287, 638, 430, 
       1297, 653, 445, 1309, 668, 460}], 
      Line3DBox[{253, 475, 1114, 254, 489, 1125, 281, 504, 296, 1228, 519, 
       311, 1235, 534, 326, 1244, 549, 341, 1255, 564, 1162, 356, 579, 1176, 
       371, 594, 1187, 386, 1274, 609, 401, 1280, 624, 416, 1288, 639, 431, 
       1298, 654, 446, 1310, 669, 461}], 
      Line3DBox[{255, 476, 1115, 256, 490, 1126, 282, 505, 1136, 297, 520, 
       312, 1236, 535, 327, 1245, 550, 342, 1256, 565, 1163, 357, 580, 1177, 
       372, 595, 1188, 387, 610, 1197, 402, 1281, 625, 417, 1289, 640, 432, 
       1299, 655, 447, 1311, 670, 462}], 
      Line3DBox[{257, 477, 1116, 258, 491, 1127, 283, 506, 1137, 298, 521, 
       1145, 313, 536, 328, 1246, 551, 343, 1257, 566, 1164, 358, 581, 1178, 
       373, 596, 1189, 388, 611, 1198, 403, 626, 1205, 418, 1290, 641, 433, 
       1300, 656, 448, 1312, 671, 463}], 
      Line3DBox[{259, 478, 1117, 260, 492, 1128, 284, 507, 1138, 299, 522, 
       1146, 314, 537, 1152, 329, 552, 344, 1258, 567, 1165, 359, 582, 1179, 
       374, 597, 1190, 389, 612, 1199, 404, 627, 1206, 419, 642, 1211, 434, 
       1301, 657, 449, 1313, 672, 464}], 
      Line3DBox[{261, 479, 1118, 263, 493, 1129, 285, 508, 1139, 300, 523, 
       1147, 315, 538, 1153, 330, 553, 1157, 345, 568, 1166, 360, 583, 1180, 
       375, 598, 1191, 390, 613, 1200, 405, 628, 1207, 420, 643, 1212, 435, 
       658, 1215, 450, 1314, 673, 465}], 
      Line3DBox[{265, 481, 1119, 266, 1220, 495, 287, 1224, 510, 302, 1230, 
       525, 317, 1238, 540, 332, 1248, 555, 347, 1260, 570, 1167, 362, 585, 
       377, 1271, 600, 392, 1276, 615, 407, 1283, 630, 422, 1292, 645, 437, 
       1303, 660, 452, 1316, 675, 467}], 
      Line3DBox[{267, 482, 1120, 268, 496, 1130, 288, 1225, 511, 303, 1231, 
       526, 318, 1239, 541, 333, 1249, 556, 348, 1261, 571, 1168, 363, 586, 
       1181, 378, 601, 393, 1277, 616, 408, 1284, 631, 423, 1293, 646, 438, 
       1304, 661, 453, 1317, 676, 468}], 
      Line3DBox[{269, 483, 1121, 270, 497, 1131, 289, 512, 1140, 304, 1232, 
       527, 319, 1240, 542, 334, 1250, 557, 349, 1262, 572, 1169, 364, 587, 
       1182, 379, 602, 1192, 394, 617, 409, 1285, 632, 424, 1294, 647, 439, 
       1305, 662, 454, 1318, 677, 469}], 
      Line3DBox[{271, 484, 1122, 272, 498, 1132, 290, 513, 1141, 305, 528, 
       1148, 320, 1241, 543, 335, 1251, 558, 350, 1263, 573, 1170, 365, 588, 
       1183, 380, 603, 1193, 395, 618, 1201, 410, 633, 425, 1295, 648, 440, 
       1306, 663, 455, 1319, 678, 470}], 
      Line3DBox[{273, 485, 1123, 274, 499, 1133, 291, 514, 1142, 306, 529, 
       1149, 321, 544, 1154, 336, 1252, 559, 351, 1264, 574, 1171, 366, 589, 
       1184, 381, 604, 1194, 396, 619, 1202, 411, 634, 1208, 426, 649, 441, 
       1307, 664, 456, 1320, 679, 471}], 
      Line3DBox[{275, 486, 1124, 276, 500, 1134, 292, 515, 1143, 307, 530, 
       1150, 322, 545, 1155, 337, 560, 1158, 352, 1265, 575, 1172, 367, 590, 
       1185, 382, 605, 1195, 397, 620, 1203, 412, 635, 1209, 427, 650, 1213, 
       442, 665, 457, 1321, 680, 472}], 
      Line3DBox[{277, 682, 1322, 683, 278, 501, 1135, 293, 516, 1144, 308, 
       531, 1151, 323, 546, 1156, 338, 561, 1159, 353, 576, 1173, 1174, 368, 
       591, 1186, 383, 606, 1196, 398, 621, 1204, 413, 636, 1210, 428, 651, 
       1214, 443, 666, 1216, 458, 685, 686, 687}], 
      Line3DBox[{459, 667, 684, 1308, 444, 652, 1296, 429, 637, 1286, 414, 
       622, 1278, 399, 607, 1272, 384, 592, 1268, 369, 577, 1266, 354, 1160, 
       562, 1253, 339, 547, 1242, 324, 532, 1233, 309, 517, 1226, 294, 502, 
       1221, 279, 487, 1218, 250, 473, 681, 688}], 
      Line3DBox[{466, 674, 1315, 451, 659, 1302, 436, 644, 1291, 421, 629, 
       1282, 406, 614, 1275, 391, 599, 1270, 376, 584, 1267, 361, 569, 1259, 
       346, 554, 1247, 331, 539, 1237, 316, 524, 1229, 301, 509, 1223, 286, 
       494, 1219, 264, 480, 1217, 262}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJztxTENgDAABMAPBBkdWFkRwISBSiBhZq4LXOALJeCjd8vNx1XPIckyJeN/
We/9ae9m27Zt27Zt27Zt27Zt27Zt27Zt27Zt27Zt27Zt27Zt27Zt27Zt27Zt
27Zt27Zt9/gH8v6rHg==
    "]],
  Axes->True,
  AxesLabel->{
    FormBox[
     StyleBox["x", Large, Bold, StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox["y", Large, Bold, StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox["z", Large, Bold, StripOnInput -> False], TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  ImageSize->{241.94592568735317`, 200.},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{0, 5}, {0, 5}, {2.000000714285715, 11.999999285714285`}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewPoint->{4, 2, 2},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{
  3.5914881687983437`*^9, 3.591488221061352*^9, 3.5914882746529713`*^9, 
   3.591488327025483*^9, {3.591488366389489*^9, 3.5914883795103827`*^9}, 
   3.591488516283318*^9, 3.5914891307148657`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", "\[IndentingNewLine]", 
  RowBox[{"myf", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "5"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"PlotLegends", "\[Rule]", "Automatic"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.591488539049457*^9, 3.5914885651697903`*^9}, {
  3.5914885958872643`*^9, 3.5914886051855993`*^9}, {3.591488760779561*^9, 
  3.591488788065366*^9}, {3.591488916197494*^9, 3.591488923227338*^9}, {
  3.591489009995964*^9, 3.591489018099722*^9}, {3.591489149096129*^9, 
  3.591489151742097*^9}}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[
    GraphicsComplexBox[CompressedData["
1:eJx9nE1sXFcVx8fj8aR2/TEz9gIJCak0iViw7grpPSEBdviQ+Nig7pAQEuA0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     "], {{{
        RGBColor[0.293416, 0.0574044, 0.529412], 
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJxNUDGKAkEQ7F23jdXMM7pMTAQxMPAVPsEHeGgg+K0LxNwX6AfUyBVZcAPB
zayia9GgqJnqmu7q+Z3/zRapmfWBBtBzsyoxK8AF7iWQE9DGMO5xrqRfgDW0
ErUNMMzMHuCtx3v2+QEf1eMATOF/QT+px+2rtkzCS/2p/uxH/aDzKo371SOT
e2i5fC9lqftXmsEsnE2de1yT2IV+7lC/IZ/BHY+97uJJGhmY9ay8T80oBNaY
f5BF/3+8HWUxY+eRL9fcpZh+1ujpevwd92x5zHxod+Yqk0+Gm3LU+drgpv6E
f7ORlx7mYJ4M/AYfS1h3
           "]], 
          
          PolygonBox[{{1332, 564, 488, 1286}, {1297, 497, 630, 1366}, {1336, 
           572, 505, 1307}, {1305, 504, 572, 1336}, {1296, 496, 568, 1334}, {
           1284, 487, 564, 1332}, {1334, 568, 497, 1298}, {1366, 630, 504, 
           1074}, {1285, 488, 626, 1364}, {1364, 626, 496, 1071}}]}]}, {
        RGBColor[
        0.4150981865873199, 0.26897686037537194`, 0.7004510335088123], 
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJxNVD1rVFEQve+9O3Z+Fn4gCFqIgviZrILdRkjSilqmEIxYaBSU5Jf4C1YL
IQtqnpLYZO1dbUy1u6ghW0jMdol2nuM5YIrHzLv3zrlnzszck3fnbj4qU0pP
8VX42pFSv0hpJ6f0EBsD+LP4VpNsB3YIe6XUGvcvwn8D/xpiF/B/DPYS4rfh
v4c/DuD78N/izMYuPMbMeP0BMNYK/XfxPwf7GfZsVsxr4DwpdTf3JoD52Hx2
YK9jrwf/UGi9EYpfroQ3FuKQzXGl0j5xmvg+wp+Cna60fw94XdjbhTB4foAz
fWPS/+r9VtL+B6+vZ8X2QpiT+L5gfZSV47cQb66v2k6ZT98aUJuxStoQf4/5
M48qpMMQ9k9WDdbh78c3gv8zpMV8Ib5HQxpthvK9Ye1q2HfmRr5nkPPz9H+P
HHk/9SGfZ6XwiUvOtWOJN7FLwwXXrg1/0bU/V0ov5nLcNWC/UD/ezXt5/yf7
1I7rP6wZ41vm0nHvTFozajhtDclnyz3CuvPuRetI3Ym1laXxmvk03DMHQnrU
1qdp/syLtm3/fNYddSieObxwb3NmZt3j5NhxHUbmw7nZcP8znjh7Q72zYu1Y
93FzpuX/EvwTWfq8xPk7oVwPhu7mmX+5OHbJvcS5mnFPkMO+ELeB+bGX2SPk
xh7i+m/r03L9ic07iHm1FGeeJw/y+Z6l99B5Dd2fJeyrUN1/ZenE2hLrQpaW
t6wBZ5sYp7LOM67pvup41jiTxLiclTs14NvTdy7Mj/y6rlfTGp7OOsO3je8I
9S9Cdel6pvlO8b067Peq4b7lu8J1ztOm5+hIiCtzZf9teyZ6zod5hfE4M/N+
b5bdr7XfBOb1F6dYz7g=
           "]], 
          PolygonBox[CompressedData["
1:eJwlkTsvxEEUxWf+/xmdZyEelS0EkcXK2kKrUYggvoBEROFVSHwqhchGotMT
DZ1NEBSyu52l8zs5xU3OuefOfZyZ2jvZPi5CCBUiEfUcQoNEN4YwCB4nLsDr
ZQg34IFs7ZyaXfArj+7hM/AqvJ/oRPdQr2+iydtTciPgX+pb4CP0LfiyAvxJ
rgRH4iM6J00zNOuH3BJvJ+At9rylZxu8SMyjP6N30ZvwNbQ7ahbgw/DH4B20
yxWxAr4mN4e+Ad/n/RPvK/Ad+FnhG6rwBnwV3oOPgYvsXVWj2k7y7EP4JjwR
B9EzNOsN/SF6hmbpZt2uG2eTPZW32rGW3EO9XtCn4TXdWNizv2SP5bV6vsN7
ybWqUW07+RZ5Im++iMvSO/WBc7Y3ykkbzfZWN+pWeSpv9eeT4KHsv5On8vYf
D/hEhQ==
           "]]}]}, {
        RGBColor[0.4962196443121998, 0.4100251672922865, 0.8144770558480205], 
        
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJxFlktsVVUUhs/t2RsTnym2RpMWxURbIFJaYowDoNWUGK1PMHEgGk2JIVgY
IXfk7NZBqQ68ZVIwuS0T0ISWkpRohJE6sBLwhjS1iY925nPiE4z6/64vYbDv
2mftddZe61//Wueuf/XgcwdaiqJY1Cq1xvRzROuRSlHsykVxQboWyTbprsrw
LT1f1L7Gs+2uSY5KvyTdFq2PsbH+sPY3aL9G6wnZbpRs1ZqW/ukc8udUFE3p
3uXsWelnpf9T+v1aw3rvX8mRSvhfKMKXfdaLkL6jpn235Aat00X48n1T2l8i
BtsMSvZofaH9OslOrRfl723F+47WPuk/1H1V7V9QLHfrPGtN4GeM52mtDvz7
nk1ae+RnhFhv0rs7pNuudagSd57UOi/7+9N1DKw7VUae/6TAb0jy1xR5PC55
o+w+1/4p7TekwMc42eccudybIsYnpe+S7v0y6neKe+3XNfmbuuythM2M9jPS
rRo3yQnyc02Ndy/vzktuA3/n3ce7jsmxPZDCz2xL5Puynh+W/FRyK/aO+yXF
96Zs9kg+qHVANrfkOLed49pE7YzR6znqst98aYk62e8K2H5VBBfbiLm9jL25
attx7G3n+JfB4Sq8reWIuT0HBjPEvwYczLGHdPaGdHfkODdOS9IfLQOvIZ29
kqIfvpS8pwzeuB6ZfZ04q0XEtmw8wPQ1vbNL7/4g+VGKPKu66wr8bBRRt2v0
nP35jt2VOF+HzVrJ291LRXC6kxotg5XrZG70w8MB9ubJONia/+6hbjjp1Y39
Inrz0tzpwn8/e/vpZQ64B2zf4GyOvjvPrDjJ874Usf4meZwZYKych/MxLq7f
ONgZk0l6zzntIK8+dLPE49zMLXOhnRq593eWUUvLQXqnyV3G7fsUWD5GTdbS
4z3YL9Bjru2KbC6nmCuPSj6fw9+tOWrlOeiae2a4bubbZ/DEfPkkRS8OSK6m
iHFzjl47B1c3Mlccw18p9n2y+Zb4zB1zaB57z2bfa78/gq0xbjDnXC/nP08u
bWDj2DyDPVuN/805+uBgilotMQeM+TK8dR+s0IOD4Gqfk9RtihmyRK3tvwnO
zRR3Dafog2XquI2+WGC2X6IPx9jXiMH3HqIXdhNzK3fUqYdt70oRQw8+ja/z
/S5FjV3r9ZKjZWB3mD71vlpcv3uU/mqFD2fhtDm2NcfcquR4z77M2ffK4LTj
2w5mxuoc9TJeW3Kc/5Sit7rokSPcW+Mb4J67L8WMWgH7nSmw7JT8JYUf+zM/
zJM/pDtRxrfKzx+U0beOdQDutaeYEx308hDfoO4U96yC853MQM/CYWr3TQoM
ztJHHfSm8XHezn9a+ynmwGnmT4O7XOczzIoO4nT/GtM5cOhN4du9Vae+ztk+
puC0c5vm3v+/1WX0p+s8Qe0c1zF42UpdHJsxOw5n7OMEMfi9o/i5je+Uv1ez
xGsuHSNfc8gYXgHHthzfh2dSzKW99F0NXlThUhM+nYHz5v/v/Ofxf59++GUc
ihz3jtCPw+hLuGcOurau8QV6uU4/m1eLcOtrOGPuTBJzAzwXqdHmFD78H/A/
P6U8Gg==
           "]], 
          PolygonBox[CompressedData["
1:eJwlkz1Il2EUxZ///70vQp+D9uGgZFAUUSBNDhE1tNgg1dBQCqFDWTqVTk5Z
i9TQxxRCWUHSh/8wCiKa1EEaTASjUFMKNKulL0Gy3+kMB+6593nvc+95zltz
qv1IWzGltA8EmMhTupSl1EE8RGIQvh9+vpDSGsXkTlO7ykdn4QXQQm0vZ0rE
n8HDzLmMeIXzzcT95D7B34PrxNfoMUWtCH+d/I2+PQOu0LsPvKQ+B79L7SQ9
luAb4ReID5F7TrwWtMEPwJ8RPwDVxCfILXK+Nfes6qne38j1cV8vZ2bgw/C6
gnfW7tPgFvFtzixQuwcvhx/lzAy8H74FfoP6VvgH+E34Yepz8PvwDfDL1Kvh
u8FosobSUhpIi1fk/lKbhPfAu+Fj8NXwc/R6Sm6e+A4oI64nN059AT6Yeef1
xL/D2uwi9xi+CF5k1mhz7h216zH4d85uA0+4aye5R5oVlNBmAFwUD7/9MrwX
XhmeTTNolgb4O3gX9cbcPdRLb/yLWlX4baWZtKsJa6k30dt8Dc8iDaVle9hb
mqE79w7aRW+0ndofUEr2gLwwAGoza5SIZ6VR5p1+hHfQLpqxgngdeJOsmbTb
JA8mayStjoPOoj0tb3fm9p480QT/GfaS7tBdX8JekEfkFXlO3pOH94T/gf//
gjQOe1Re1Qy1YU2l7UF6jMCnw2+rf0L/xsewl+QheWk27DV5TF7bEfaONJAW
b8O95CF5SZ6Rd+S5VcT/ACCiiQE=
           "]]}]}, {
        RGBColor[0.5737613661287864, 0.5435370519035629, 0.9097253540741593], 
        
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJxdV0tsllUQ/f77zRfxBRghEZAogYKJVBoWSgoKJSGENkZlI4WgPAxU2gCJ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           "]], 
          PolygonBox[CompressedData["
1:eJwllF1oj2EYxt93//vNfBXZihDLx5SPlQNKOyAllhaOUCNrDW1sZbEj5euE
E3GgVjRysIPNZAfYzjZfoTFblM2QlWEOMEo+f1fXwVXXdd/38zz3c7338xZV
1m07mJckSTkI8DBLkvpckpTBmwlMBdvh7ym6QG4m+rhqqbmMHgZN8EuqIZcf
XjtE/XlyPejVaZKcpGYAXYzuJL8C3Y4eQm8ifw79Ej0/vNdsdAv6K3on+Wb0
W/QoemvqM3W2elAv2uNpeI3Was0HdIBS9jtDP/vJTUdXo7+gmzLvqb1bFdPd
0IdY20b+ROae1XsD+W7yBWH+k/xFclfBtJx7ehX2SF6VoNvRxzLv9Zw1M+D5
oIbcddaMqn9q5qb2XN5fQxejG9G9mWtU+4D1E+CtYDG6kppv1D4Ba+Gnib3I
fCfdTZ7fJlcIuuDziK2DLwzfVXtor+/oQfL75A98ERhCl6DL4FVgD7yHWD98
OfgMX0WsPOyBvFAPd1QLKvJ85n14ERiALyW2EX5P3x+9A70b/gn0o6vQe+EH
QD18hFjC3oVgHN5A7FTmGtU+JvYmfGfdXTPZi+5Al+b8DSfCGzOf1YHuIj8Z
PZb6DJ31D7xD16JrwhCXBz/Cnsgb3WEM/gx0p76j7voaPErtkbyqC/cqj6Zk
nmnN9ln6GyS3JHy3ldRshh/JPJuagcPwEdCS8xv5pdkI37WYmg1hD+WlPPsI
nxX+NguIrQ+/Kb0tzdif8BvUW9RMXUH/Ds+OztBZc8K9aYY1y+pJvcmTv+Fv
rG8tzyaR34Jek+dvUoCu0Aylju2C94GjOb+xm/p36D2Su0FNZ7hH9SoP+8Iz
qdnUTNyV/5m/ldbUZp5BzaJmdDzsgbyQ58PhN6K3on9UG3pZ+K1oBjQLt8Jv
UT2pt/9+wKmq
           "]]}]}, {
        RGBColor[0.6334044084039064, 0.6393668249866483, 0.911085031734951], 
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJxNl29ol1UUx5/n2X3I2FaUg6INqagFaUYvFGaRb4pmIlkwXSGk05EauZaQ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           "]], 
          PolygonBox[CompressedData["
1:eJwlk0tIlVEUhf//uCUdGPSAQiQsoiAjchCUcEMEiRCJhKjIyhRKre4dRDoS
U6GRIEJBs27NCrLHJO+s1yQHvWb2gGyS1siaZZHfYg3W5Vv7nHv+sx9na2+p
q5iyLCugQC38rCdwO8+yMnwQ1eMf4Z/Cm9FzeBuxNvhqNXvhaXQZLhDbBN9j
zwP4KLqGH0M9rBfxV+CfrNfiN+Ir8BZirXAj+oDfhT8EX0Il+Buxf3A72oF/
jf8Ed+lM/BK+KXyGzprFv4CHWS/jb+H7q32mzn6P/w4Poov4j/jf4ZyU2zP8
G7gfXUi+0xK8F43gD6AjcAOay30n3W1n+K7N+A74MNoDzxNbhs+jvuT/fIFH
0XW4nViB+/Xhe5Jr/A5ehx7n7oF6UWFPR1WW3cSX4L/EFnLnoFz2o7XwMDrO
+vZwbrqD7lJD7Efumqq2p9QjuEzsLjzO+kxyj9Srk6gzuYZDrP0K56KaqDZv
w7XqVn/hl+Han8CfCUusHCrwTHg29E19u4Ezn8Dj6Jx6iW4k56hce9FE8h7t
Df4zmZyjcv0cngXVTLXrRPuSc1zD/jr8/dwzqdkcUw65c5yATxM7lrznYTgH
5aKZfBWeGc2OvjkA7w7Prr6hby2GZ0k9VW/VQ/Vyith/cpgMs96I3opmQrOh
nq3AZ4mNJr8RvRXNlGZLd9zA2p3wW1QP1Is/6Gvumdfs14R7pzertzsbfqvK
SbmtAmJReB8=
           "]]}]}, {
        RGBColor[0.6930474506790265, 0.7351965980697337, 0.912444709395743], 
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJxNV11MlmUYft/ne95aFv3gqsWnaww4IOSsxscBrYPAtTVX0kbSAQJbtTZF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           "]], 
          PolygonBox[CompressedData["
1:eJwtk09IlVEUxO/3vfMlmIIRKhVqmkVFIm1DKMkISUIiCGoRPMigRX+wVagF
tbGsVYlRvValqdTGbJe1UIOK2pTWulq3rUX1G6bFwMyc9+537plzW8vnjpzN
U0pdIMDmIqVqjFtZSjcwvoOP8AG8w9QGwFV0BX0RXqZ+Fz4BzqOHwCr1afQI
/C31l+hW9C50M1gDv4Y3Qu0UuI9+g/4KP0j9GHoevR49Bqrhy3hj1IYLn30G
9Bf2VGui97+llNrR69AV/vOQ/34Ci/B2vA5qbaAWPo43Tq0LNKAn0bPw7dQ3
oJ+h59HvwAL8JN4hapvCvW5F98C34dXDH+PNoD+DJXgZr4/abtABnwGX4Z1g
R+6Z/tD30T3om+g/JZ+ps5fRq/DfeEPofWAPv30e7k0z0qxOg9HcmSibK4W/
pQyUxXS4t6N4BwpnoCx0p/fUXoEX8BN4vdR2gqbc3uvwzDQ73WkFXQOmMs9M
s7sTnmUfurv4vyPwFbwt4YyU1SVwHP4E71HmmWl2lXBW/ej96G/oD5lnpFld
APdy74h25YGQOWNlfVs9ZM5U2X4Jz047qd1cCO+S7qS7zaGfZs5YWV8P73ov
em/hjJW1dmZj+E66m75ZFc5U2arHlnAmykYZ/Cr5DJ2lnkrUf4ZnoR3QLoyG
s9Yb01tTJspGPdVRGw6/De2EdkMz0Ww0s7XhjJSV3lQjerDwW9Sb0tv6B3wg
bnE=
           "]]}]}, {
        RGBColor[0.7526904929541467, 0.8310263711528192, 0.9138043870565348], 
        
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJxFVktsVkUYvff+M/YBiUVJ+SE+eJhCWomhaBOFhGhrVLBKa9IqMaJFxQXF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           "]], 
          PolygonBox[CompressedData["
1:eJwtlEtIlFEUx+833/l6mJBW9JDCbIgKl0GboqKGCKQCA+lFhBS1mqCihY5m
LWrSKFITzekBhlbWItNW2oMkshSKynDRzlpGq6CF0e/PaXGY+zv/+9177nlM
Re3J6mwqhLAbM+x1EkJtHMKcKIQWHCvghA3n4Rw8juXYl2fPJNpO7AD6MPpi
tNXwIvgefB9+A59gbyncAW+Fq9C74VnwfvgwPAp/htfBy+Eh+Dm8A66BB+EF
8CTWzP1XOXMKbQ22FP0x+lO0F/A+tAA3wt+xTrAT3ze0bdge9vegF6FVwMVw
O9wGl8Nz4Stw3vwbfbsL/gGfTvzsPHvOsM5ge1k/wjcfvdf8bOVAuVCOlKtN
+CbQHmLVHHEW3wTaMWwLe5vQj7LuM8+dztTZfXpf7G8uRzue+N3F8B/8d+GI
3yy8BP02lmGdxTeGdgPeELwGqkUzvDZ4jVXrAvab847gW4jWAo/CZfBf9nTj
K0SeM+XuAbwKnoY74DF4JPIa1sEvzWO5wLef4FvwMvQp9Fa43bwXPsLX4CHz
u3Ps/wD3Y+nYa5ZGu2zei4pJsTUpBtY1+M6xHjCvvXpEvdJgHrt6QL0wYt5L
6lH1qu7U3cpBbP4GvUU5m2ces2Jfzzev1E/ma+VIuRqEK+GfcBe8WTPAug1f
Cu2JeS+oJ9WbqrFqrZz1m9dEtVFO7pjnRLlRjWbDG+Hteiv6DPtazXtTM6PZ
qcdWpjzn78xnQLOQgb/Cl8x7VzEptoN6T+Q9doj1sPksacY0a2/NZ1dnViZe
A9VCb3yGdtE8Fs2EZuO6+Vs1M5qdm+azXAKn4R6sKPb/iDK0L+axySetzrzX
9Z9yCv5lXkvVXLVvwHqD17iR9Xvz2Yn+93q9+X+RcqRcqQaqhWaqBG3afFY1
M5odxaTY1MMFtH/aX5Tv
           "]]}]}, {
        RGBColor[0.80726725, 0.861883, 0.894034], 
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJxFlktsVVUUhs/dZ58KDmhiYjsiSKRR4qhIIEKi1BjjRIxU8NVaY9GklGCK
r7Q10cQWHfkc+B5ZqEMfCTro7cU0beqtMrgUHRVhdquzMnGgxP/L+k0H++51
1t57Pf+11t353ItHTqWiKH7XKrXe0M+bWqOix7VPaA2KfjwXxbZaUbynfUy8
01o79N2v7391/qr2e6ui6BH9tujdtXh/WN8tKXhJ9COiH9V+pIw3aylkcYfz
l30H/rj13laLs0Oiz6d43yV6RPsJaJ03xR8V3Sf+ddEbKd4ie1nrYdEr4v2i
1St6sYxv6Fdk663a9+awc8S6DsqXbu2T4vfWIi4D+u6uha49oo/qrNL3VA7e
Sdsw5tjgF75iMzrmLWu3ZHdoH7Iv89qPam0RfXMOGffrzop46yn0tlPYQF4O
6O2Mvk+IntbeEH8qBe8ssRN/ULwFrdtFn5asL8WfkOxh8Y6XkUvezFsvO3Ju
FGHLvGliO2x/50Q/L/ruImTA77WuZ8qIBfug9eLfs2VgopFCbrfzOGQ+vGPm
I5+3u4rQ84J1ddbiGz646XfckAl9k3mPmQYX5PE+7qeIF7ECF+CDHIAbMECu
684Rdv2aYse2lGMH11/lwNFB7V/nwGWP+FdT0MjB/x+S7bRP4Kgjhx+HRF/W
+W8pcIRe7oMN9h9Nn9X9O3U+kOM+ceH9xzl8ukd7ndyliDNxuJAiJu/myMn+
HHou+y1YqPv+gnOEXOJzwzH6yXL+zwVvyTs8zsAsdMN3tlg3MQdPdd//3vV/
h/z9MwVNLTSNZ3zbcB7ANjV6JUV8m6YHis187HJP2DB/yfltmbfmem/bH3JN
XsBun+VTk9xbNG45eytHPPbliAFvR92j6q5Z7EXu08ZS23fw6y/7di2Fvj7X
y1XjCjsvpcgZ/QCaOPCO9/Q6/LuYAuMX7W+P7b9mbBGPPxyflt8etg0tyyGm
67YTLNWNZ3Su2gbys+C8v56jvrdXUTf97skj7qnY33AfmHLf5bzLNmMvecGu
K87pqmSOi36yir5Ez0HHRznu76yir6/Zfmof/IAjsI/d1ND7OWx4IsecGXMP
r7sW9rjnVLZhyL5i2zs5cLpDul5zf6ZPXzB+u9wrGr7/QBXxm9Wd46LP0OOq
6Ddzxh59mN7bdn+dcb0wr5hN5IhexZtO52vNWGV+4jM4aUrHrPiTVcxYZFID
bWOW3NEv8afD/alpLF1yronbsPs3cRg1lqGZb7zp8sxs+e2qcQAGpz3HmefM
K97Ti455BpGvcc90Zjs9hrhvcz8iz99o/zSHvKdyLOiZHPEj91uNn2ljAP1L
5eaMXXJ/pocSv3PUYhW2fOa+120f97lO/ymj9/GuytGLwcXWHH4vlpvzatGz
iVzQU7Cb3J1LMR9nncsDzteycUlOVjzrJ6q4/3OO2loxBjpzYAbsrFs+9+l3
5PnbHFg+b/wwy+kNn4t/VxU6l0UPiJ6kZquoDbDzgfi35OhnD4r3UBX9pi7e
FzliQpyYJfT1D6mVHHe4u9f/Z/4u4z1yvstRD2DqTI66AiOf5MjPlPO137Oj
luM/CticE/0fizM0Ug==
           "]], 
          PolygonBox[CompressedData["
1:eJwtk0tIVVEUhrfbdQwbKAh5R2IRQeIoGhWENBVEEAmiB1HqQKNA7HHvdRCU
9oDMXmRZNCirodWkgV4wikylIKJpNG7YpEFK38/vYHHXt/6971ln/evsOHm2
70xOKR0ggnhapLRBYYS8lcJzor0updH6lFbR7sB70Ybgj/AM3Io+DH+Cp4nv
2XceonXDZc6/oFYhv0q8Iy/QL6DvgxvRq9SOSqe2Cz7B/72HK/ATtAniFHwl
fPc4+lLhmrRJYoD8Dfox7lfQv8LXiRpaE3cm0GaJg+in0ZfRXsK98Bi8Bv/l
d1tyj+r1c7j3OaIMt2k+yT2Nkt8glshL1Na5uxie3SXyb2gX4S1wvzT4HvGT
87vpZw7tsOaTPSPNSj2r9w70t+Ge1Nt2+BV8G/6R7UGDegtrv6jdL+yBvOhC
fxD2TN71wM/gxnCuHtTLAtG3+c7nwjPVbHfCl8PvoHfZwzNq8Ad4QIw+Bdfg
Q/WeyTg8WNgLeSpv5aG8bOD+tfAMNIt19HJ4h7RLzeh34X+bz5Zn8k4eyasS
+mP0qjxD2w93kt8k1rJ3cDrskbzSmRV4MvxseSSv5sOzP8IzmshnqP3O3oFm
eAr+kr2DOTxTzVY7s1XzD/eqMzpbF56FelAv1fAuaCaazaNw7/JM3hVhb/SN
6FtZDr+Lvjl9e6/D3qsn9TZL/Mne6Ra08+HZyTN5txD2Rmd09lZ41+WRvPoP
rwl9IA==
           "]]}]}, {
        RGBColor[0.8608307500000001, 0.879745, 0.8700376], 
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJxNlDtPVFEUhS/nniEaXwkjLQF+AJIYS6ewISEwY4ihgcof4Cs+C8RnyEyC
AjFR7By1sjEBCwELDYkQ/wYU8gc0GQrXx15Ein33uufuu8/ea69zBq5en7iW
iqKYlZWyy3o0ZB3hhVwUS11FMV8pihMp8CnZGeG38r2y4SL8OfmarE/4ovxg
EbED8k+U56TwpPymcm+neL+n94fyc8p/Q7hHsefln8taWm9q/bXwsvBP4afC
TeHvwss5algQfiG8KLwp/FG4LfxK+L3wO+FflaiReGpk/13VsZXif9Yrih1z
31XZaIp96a9bti9T6AEX8NCVI+dO6d4VP9MVsfUU+7LXSIraDvlYck7ynXXO
Ozn+3dDL7Rw1TMg/kM1q/ZvWcwqu+I9Y3sFr8j9Uw9cUtfR6X/ii/jc5+mQm
Q+YXnv8odqqMf/vNyaZ7gYeNMuJWU+CVFHsRw+wmhD/JjxWRZ1pWmnf4P55D
C23HMBt4eJmDBzhAG/BUTRFLr/DY7f7h4ab8lRy5H+eogV6pEx2gh2fWCLqk
/ws5euqUkZf96R8dsN8Hfc+eCbOmLvRNXeQ7luI7fF9KMSe43TU/W+a65jkS
RwznhvOj9Ae8TpX/a8UPm2f+H/IaMQOuj/WaOf+Sgn+0Wfc6M2A21DxeBu5x
HnKQv+M6qu6tXkZte/K/y3i/ZT7hldmuei/WVp2LOa+5djjJ7pEaqj7fM9Yj
81q3PtDGtHvv9/4Va52eyF/6XiDXoGtrHOGNPP3W9rrxou8e4peP3D1ta3HM
Wuqz/pnVjs/4pO+feZ/xcZ9zallxv8y85T4b5ok+N8zzinXAd9bJt+05ot+2
9+Z7y3Vyf4H3rZ1t84mmmuaTMw+Pd3NwdsgN/42YH+6MUeun7jnC6ekcZ/Cz
/CNrHu3zfc98cndwru7n6GvPvXHnotu/wv8AwBSkKw==
           "]], 
          PolygonBox[CompressedData["
1:eJwtkbtKQ2EQhPd4NqAYEPQFzAukEkUECxtBiEhElJDKB/CWRLHwbkQDUZNG
Y+etsrGxMY1vFSEWfsOmmMPM7p5/d3Zzm9vFrSEzywEHc3wmCDwnZq/wGTCK
bqFv4dcZsy46iz5Hr4NFdANdh8+CMXQH/QDvUr+SmvV5u4ruwyct3tBbP6A8
iJ2SnwJO7oj/a/AeuXFyX8SuqN0gtgRvk7+HT4Nh9A36Av7o0Vs1qn3z8LKM
LsFHwEsSHuW14uFbM2rWxONteZb3T/CBLqLL8F0PLwXqv6n/S8O7ZtAsihUG
M++gz0CahEd5bXrsLm+x8DWwwL/HxA48ZtSsT+gOfBXMo0/Qhx4zaBZ5eIfv
e+xKNarVjrQr9dxDX3rsRj3U687jlrqZbvebRm/tXLvPePTWDXXLf1AQOZE=

           "]]}]}, {
        RGBColor[0.9143942500000001, 0.897607, 0.8460411999999999], 
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJxNUDtuAkEUm3k7q7RwApSKU1DQ5AA5AgcIIUkFKYACaCJxHmhylt0uBQUF
SJsmNjZSiqf3GT/bbx4n0+eXSCkNERViXVLaZUSNBvUe9Rdyi/aEaBA95z7i
4nl2/vHbQ4gnsuZnYxpjqLnNwhHToV9kcW5q1ddKeRyaE0fOAepP5FHI88k+
yEvfxPziYY5chbiPtXbecctHUc0ZOW64JJ2tPdz1eOt3rfkKe0+hP6GH16Ld
A97firzS+9z3kPPgflbEEeZv//1ld9dDLI2jZuMZ33gTtanLmxbWOPv+1nqd
d8Ieyf8H7qo40Q==
           "]], 
          
          PolygonBox[{{1110, 582, 392, 1154}, {1153, 391, 577, 1108}, {1075, 
           515, 378, 1136}, {1106, 573, 380, 1140}, {1137, 378, 573, 1106}, {
           1165, 400, 582, 1110}, {1019, 392, 519, 1077}, {1108, 577, 379, 
           1138}, {1015, 379, 515, 1075}, {1077, 519, 391, 1152}}]}]}}, {{}, 
       TagBox[
        TooltipBox[{
          GrayLevel[0], 
          Opacity[0.4], 
          
          LineBox[{1024, 1165, 1110, 1154, 1416, 1019, 1077, 1152, 1472, 1153,
            1108, 1138, 1414, 1015, 1075, 1136, 1466, 1137, 1106, 1140, 1467, 
           1139}]}, "11"], Annotation[#, 11, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          GrayLevel[0], 
          Opacity[0.4], 
          
          LineBox[{1038, 1200, 1116, 1189, 1428, 1033, 1083, 1187, 1483, 1188,
            1114, 1177, 1424, 1029, 1081, 1175, 1479, 1176, 1112, 1168, 1421, 
           1025, 1079, 1166, 1476, 1167, 1111, 1157, 1417, 1020, 1078, 1155, 
           1473, 1156, 1109, 1143, 1415, 1016, 1076, 1141, 1468, 1142, 1107, 
           1145, 1469, 1144}]}, "10"], Annotation[#, 10, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          GrayLevel[0], 
          Opacity[0.4], 
          
          LineBox[{1236, 1369, 1354, 1402, 1225, 1401, 1226, 1403, 1323, 1224,
            1439, 1046, 1352, 1213, 1490, 1214, 1321, 1212, 1435, 1042, 1350, 
           1202, 1487, 1203, 1319, 1201, 1432, 1039, 1348, 1191, 1484, 1192, 
           1317, 1190, 1429, 1034, 1346, 1179, 1480, 1180, 1315, 1178, 1425, 
           1030, 1344, 1170, 1477, 1171, 1313, 1169, 1422, 1026, 1342, 1159, 
           1474, 1160, 1311, 1158, 1418, 1021, 1339, 1147, 1470, 1148, 1309, 
           1394, 1146, 1379, 1380, 1381, 1337, 1372, 1371}]}, "9"], 
        Annotation[#, 9, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          GrayLevel[0], 
          Opacity[0.4], 
          LineBox[CompressedData["
1:eJwV0D0oBAAYx+FXRzdYlEEZfJ0kkaxSkiS5JKNFGdgYGH2t3HAlrpSvMohb
sR4pJa6U3HWDDbOVQZ4bfj299U7/9vnlmaWaiJjTbyJisC7ih4tc0KpW1KKN
2ogC1znEP38ZbrvbmOE9dzjMBLPcYwdzfOA+R5jkLo/YyRM+8pijrGeOF+xi
nkVecowNPOAVu3nDF15znI08ZIE9vOMrbznBJp7yib0sssRnTrKZZ3xjH8us
sMQ0W3nOD/bzi+/85BRTzPObA9zUltaqW1Z31LRm9Q/f3DQG
           "]]}, "8"], 
        Annotation[#, 8, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          GrayLevel[0], 
          Opacity[0.4], 
          
          LineBox[{15, 239, 228, 858, 1151, 1341, 1023, 1420, 1164, 1397, 
           1389, 43, 275, 57, 283, 71, 1012, 293, 674, 1196, 1084, 1036, 662, 
           1390, 1465, 1391, 99, 309, 113, 318, 127, 1392, 1122, 1241, 912, 
           1240, 1092, 1051, 781, 1242, 1125, 1393, 155, 344, 169, 352, 934, 
           1274, 1362, 1067, 825, 360, 197, 1378, 1308, 1377, 230, 1000, 1375,
            1105, 1376, 506, 211}]}, "7"], Annotation[#, 7, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          GrayLevel[0], 
          Opacity[0.4], 
          LineBox[CompressedData["
1:eJwV0L8rxHEcx/GPOh2DQQwGA6UsBqMUSUmXLmWR5BKlo+tsdzP+hBuulLqT
weDHYDhWTDf4UUpxrpTixmPkyuM7PHq+X9/l2/c7uLa9kG0LIaQYjYUwT097
CDvssUvWs069YMSdJO7+ooOM3eLcPaxz/PJh/+kWP5zYQ5qgybv9rWkaHNsD
Ossn9egdusEbR3a/zvDKi13TdR4o2306zR3P9r2ucsuB3atTXPNk32iKK/bt
bp2kwqN9qSvRt1G0u3SC0+gd9pkuc0gh+h86TomqXdYlcu48aTaJeTbGovsf
KAw0zg==
           "]]}, "6"], Annotation[#, 6, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          GrayLevel[0], 
          Opacity[0.4], 
          
          LineBox[{1210, 1368, 1087, 1388, 1387, 1386, 1211, 1400, 1119, 1222,
            1493, 1221, 1089, 1045, 1438, 1223, 1121, 1234, 1496, 1233, 1091, 
           1049, 1442, 1235, 1124, 1247, 1499, 1246, 1094, 1053, 1445, 1248, 
           1127, 1259, 1503, 1258, 1096, 1057, 1449, 1260, 1129, 1269, 1506, 
           1268, 1098, 1061, 1453, 1270, 1131, 1279, 1509, 1278, 1100, 1064, 
           1456, 1280, 1133, 1291, 1513, 1290, 1102, 1069, 1460, 1292, 1135, 
           1413, 1301, 1412, 1300, 1104, 1374, 1373}]}, "5"], 
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          GrayLevel[0], 
          Opacity[0.4], 
          
          LineBox[{1054, 1446, 1249, 1326, 1251, 1500, 1250, 1357, 1058, 1450,
            1261, 1328, 1263, 1504, 1262, 1359, 1062, 1454, 1271, 1330, 1273, 
           1507, 1272, 1361, 1065, 1457, 1281, 1331, 1283, 1510, 1282, 1363, 
           1070, 1461, 1293, 1333, 1295, 1514, 1294, 1365, 1073, 1463, 1302, 
           1335, 1304, 1516, 1303}]}, "4"], Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          GrayLevel[0], 
          Opacity[0.4], 
          
          LineBox[{1066, 1458, 1284, 1332, 1286, 1511, 1285, 1364, 1071, 1462,
            1296, 1334, 1298, 1515, 1297, 1366, 1074, 1464, 1305, 1336, 1307, 
           1517, 1306}]}, "3"], Annotation[#, 3, "Tooltip"]& ], {}, {}}}], 
    AspectRatio -> 1, Frame -> True, FrameLabel -> {
      FormBox["x", TraditionalForm], 
      FormBox["y", TraditionalForm]}, ImageSize -> {235.046875, Automatic}, 
    Method -> {}, PlotRange -> {{0, 5}, {0, 5}}, PlotRangeClipping -> True, 
    PlotRangePadding -> {
      Scaled[0.02], 
      Scaled[0.02]}],TemplateBox[{
     StyleBox[
      StyleBox[
       PaneBox[
        GraphicsBox[{
          RasterBox[
           NCache[{{0}, {
              Rational[1, 9]}, {
              Rational[2, 9]}, {
              Rational[1, 3]}, {
              Rational[4, 9]}, {
              Rational[5, 9]}, {
              Rational[2, 3]}, {
              Rational[7, 9]}, {
              Rational[8, 9]}, {1}}, {{0}, {0.1111111111111111}, {
             0.2222222222222222}, {0.3333333333333333}, {
             0.4444444444444444}, {0.5555555555555556}, {
             0.6666666666666666}, {0.7777777777777778}, {
             0.8888888888888888}, {1}}], {{
             Rational[-15, 2], 
             Rational[-225, 2]}, {
             Rational[15, 2], 
             Rational[225, 2]}}, ColorFunction -> (Blend[{
              RGBColor[0.293416, 0.0574044, 0.529412], 
              RGBColor[
              0.4150981865873199, 0.26897686037537194`, 0.7004510335088123], 
              RGBColor[
              0.4962196443121998, 0.4100251672922865, 0.8144770558480205], 
              RGBColor[
              0.5737613661287864, 0.5435370519035629, 0.9097253540741592], 
              RGBColor[
              0.6334044084039064, 0.6393668249866483, 0.911085031734951], 
              RGBColor[
              0.6930474506790265, 0.7351965980697338, 0.912444709395743], 
              RGBColor[
              0.7526904929541467, 0.8310263711528193, 0.9138043870565348], 
              RGBColor[0.80726725, 0.8618830000000001, 0.894034], 
              RGBColor[0.8608307500000001, 0.879745, 0.8700376], 
              RGBColor[
              0.9143942500000001, 0.897607, 0.8460411999999999]}, #]& )], 
          StyleBox[{}, Antialiasing -> False], {
           GrayLevel[0], 
           AbsoluteThickness[0.1], 
           Opacity[0.3], 
           StyleBox[
            LineBox[
             NCache[{{
                Rational[15, 2], 
                Rational[-225, 2]}, {
                Rational[-15, 2], 
                Rational[-225, 2]}, {
                Rational[-15, 2], 
                Rational[225, 2]}, {
                Rational[15, 2], 
                Rational[225, 2]}}, {{7.5, -112.5}, {-7.5, -112.5}, {-7.5, 
              112.5}, {7.5, 112.5}}]], Antialiasing -> False]}, 
          StyleBox[
           StyleBox[{{
              GrayLevel[0], 
              AbsoluteThickness[0.2], 
              Opacity[0.3], 
              LineBox[{{7.5, -112.5}, {7.5, 112.5}}]}, {{
               GrayLevel[0.4], 
               AbsoluteThickness[0.2], 
               LineBox[{{{7.5, -90.}, 
                  Offset[{4., 0}, {7.5, -90.}]}, {{7.5, -45.}, 
                  Offset[{4., 0}, {7.5, -45.}]}, {{7.5, 0.}, 
                  Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 45.}, 
                  Offset[{4., 0}, {7.5, 45.}]}, {{7.5, 90.}, 
                  Offset[{4., 0}, {7.5, 90.}]}}]}, {
               GrayLevel[0.3], 
               DynamicBox[
                Directive[
                 CurrentValue[{GraphicsBoxOptions, LabelStyle}]], 
                ImageSizeCache -> {{
                 4.503599627370496*^15, -4.503599627370496*^15}, {
                 4.503599627370496*^15, -4.503599627370496*^15}}], {
                GrayLevel[0.3], 
                InsetBox["3", 
                 Offset[{7., 0.}, {7.5, -90.}], {-1, 0.}, Automatic, {1, 0}], 
                
                InsetBox["5", 
                 Offset[{7., 0.}, {7.5, -45.}], {-1, 0.}, Automatic, {1, 0}], 
                
                InsetBox["7", 
                 Offset[{7., 0.}, {7.5, 0.}], {-1, 0.}, Automatic, {1, 0}], 
                InsetBox["9", 
                 Offset[{7., 0.}, {7.5, 45.}], {-1, 0.}, Automatic, {1, 0}], 
                InsetBox["11", 
                 Offset[{7., 0.}, {7.5, 90.}], {-1, 0.}, Automatic, {1, 
                 0}]}, {}}}}, Antialiasing -> False], "GraphicsAxes", 
           StripOnInput -> False]}, Frame -> True, FrameStyle -> Opacity[0], 
         FrameTicks -> {{False, False}, {True, False}}, FrameTicksStyle -> 
         Opacity[0], ImagePadding -> {{1, All}, {All, All}}, 
         ImageSize -> {Automatic, 225}, PlotRange -> All, PlotRangePadding -> 
         Scaled[0.02]], Alignment -> Left, AppearanceElements -> None, 
        ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> "ResizeToFit"], 
       StripOnInput -> False, LineIndent -> 0], StripOnInput -> False, 
      FontFamily -> "Times", Background -> Automatic]}, "BarLegend", 
    DisplayFunction -> (#& ), 
    InterpretationFunction :> (RowBox[{"BarLegend", "[", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               RowBox[{"Blend", "[", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    
                    RowBox[{
                    "0.293416`", ",", "0.0574044`", ",", "0.529412`"}], "]"}],
                     ",", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{
                    "0.563820859082933`", ",", "0.527565423056382`", ",", 
                    "0.909498741130694`"}], "]"}], ",", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.762631`", ",", "0.846998`", ",", "0.914031`"}],
                     "]"}], ",", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.941176`", ",", "0.906538`", ",", "0.834043`"}],
                     "]"}]}], "}"}], ",", "#1"}], "]"}], "&"}], ",", 
             RowBox[{"{", 
               RowBox[{"2.`", ",", "12.`"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           
           RowBox[{"3.`", ",", "4.`", ",", "5.`", ",", "6.`", ",", "7.`", ",",
              "8.`", ",", "9.`", ",", "10.`", ",", "11.`", ",", "12.`"}], 
           "}"}], ",", 
         RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
         RowBox[{"Method", "\[Rule]", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Frame", "\[Rule]", "True"}], ",", 
               RowBox[{"FrameTicks", "\[Rule]", "Automatic"}], ",", 
               RowBox[{"PlotRangePadding", "\[Rule]", "Automatic"}]}], 
             "}"}]}], ",", 
         RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
         RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.591488566180146*^9, 3.5914886076792727`*^9, {3.591488762928327*^9, 
   3.59148878934478*^9}, 3.591488924761607*^9, 3.5914890195141983`*^9, {
   3.5914891382607403`*^9, 3.591489153546871*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"myg", "=", 
   RowBox[{
    RowBox[{"-", "9"}], 
    RowBox[{"y", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}], "+", "1"}], ")"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.591489785588464*^9, 3.5914898029044313`*^9}, {
  3.591489934190727*^9, 3.591489934892745*^9}, {3.5914900488114862`*^9, 
  3.591490062952408*^9}, {3.591490142352359*^9, 3.5914901426621637`*^9}, {
  3.5914906155673237`*^9, 3.591490616375325*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", "\[IndentingNewLine]", 
  RowBox[{"myg", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "1"}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"x", ",", "Large", ",", "Bold"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"y", ",", "Large", ",", "Bold"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"z", ",", "Large", ",", "Bold"}], "]"}]}], "}"}]}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.591489808335693*^9, 3.591489848833045*^9}, {
  3.59148989268904*^9, 3.591489901117601*^9}, {3.591489947878631*^9, 
  3.5914899792033653`*^9}, {3.591490010900614*^9, 3.591490013494988*^9}, {
  3.591490114307518*^9, 3.591490114599985*^9}, {3.591490146177753*^9, 
  3.5914901464388027`*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1vXmcj9X//z8MxgwzjChFluyylF1NXlfImoSyk0QiUraSyJbsWZI9CoXI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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw1nAf8V9Mfxr93X5R29igtlVFU0iDJJiUjNGVWSomQkVlZkZE9UihCkSQa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         "]], Polygon3DBox[CompressedData["
1:eJw1nAf8V9P/x+/njnM/kZGVUVRGGhQiKVtlp+wdbaOspFJGA5GUpMwQZSsZ
WdllRKFQJJWGWUb4Wf/Xs9f5Px6/++u87jn3fu733nPe4/V+HfXP7dOpd5ok
yaA8SfS/ZFyZJKfpRCe1j1J7XpEkw9W+M9O5apJ01bk/K0lyr84tC0myQP13
qH2P+meov5uw/pccK7yd8FyBYcJ3CHcUPk/XJ7p/C/1znq7von51JUfr/7ZR
/+vqv54hwlcIn6/+DYVPFK4vfLcecrh+/zod96jdU/06nXRS//ZqlDpXU33X
84xqH6rzh+iYreMdHYdp/P/U94SumSJ8tPB/wjvx96rdTOfeVnugzs1Q+zyd
20D4BLXrcX898+vCrwmfIfyO+q8Wvln4aeG99PzP6NoX9dsnCN8ifLT+3nt1
rr3ad2j8oRr/P/V/rv5FwrcJP6DrTxK+XWP20tjP1P+YcB/111P/Keo/S7iX
cA3h44V3EF4oPFb4fuEThd/Q9TcIZ8L9hfcQnsbfovsdL9xE4w/T8+ypc7N4
l/p7ErXH8S7Uf5XGN1H/thr3kfBg4cbCx2vMfI29Qufr6JLOGt+Y76P+TP0t
eQfq66+jrtrnqL+J+jdW/yhdO0m/1Uj4TOE1Fb+DF3W/hhp/iK4/TLiPrvld
eJraz6h9msb/Ify08LPCp4N1n1Tj2+ncxTrXUscctTfUPV9We43ueQnzQ+Ne
1Ph9dO599V+qa15Se7Du10C4m9pN1b+3/n1PeAjfTO2Ger6H1X5a1x+u/vc0
/nL1j1HfkcJ3qP9s3etEvoHardV/rvA5uuZrXdO18Do6RuO31fj9hDurf3/1
L+J96+in9ks6XlV7O417UuOrwg+rPVTnLudZdMxUe1ede0X9GwhPU/tG/eb+
ul8ufIP+1sbCj6n9rMYeq98bot9rwtrS2N2Fhwo3FT5fuJnwlsI76/qzdc27
uuZTnV+R+Jt8J/yK7nee8EqN6afx72t8P+FbNe4o4Y3Uf7PGPsCzCdcSHiM8
WXg34d2EnxR+TriD8DasT91rpO6xtdq7q/8p9T+v/uPUv0rnHlDfo7r/KcIr
he8XfkT4ZOFdhA9M/U1H6JoLdX2I3/8u9a3WMUntxzT+VMbr35eEr9b4qWr/
oGt+VfsinTs59/M01PWpzv0nvJOO+mqP5f2rPZDf4Pn5Rmov1fi7WCJq34mh
0b8Fz898U/sUfYNxfJ9oH3/R+JcT//ZM7BnvtOJnekrn9tH4o9Sep2fYg/kn
fKTwXOHm2Atd30q4vq6bIrxW+DHh0dxHuKnG7yb8Uur1NUr9+wrvoP7Jwm/p
39cqntMv6PeeZ76oPVvju6p/hvABwu8IdxOeX3r9sI5GC9fW/TfDD6h/a+GP
S9+LdTJK+BPd/xPd/zh+Q+2WGn+q+hdiU9T/mcbPFd5P48cKfyr8oXAr4VuF
Fwh/ILyv8BjuV3p9sk5vYb4JzxRuJDxceHMdt+m3HtFvLVZ7K76x8K7CX6t9
j/7+wzW+qfAj2Dv9u7v6W+nYT+1ndL/d1f8ya1T9zwo3E35F+Fzh54SbC88U
7iL8uPCmwmNT29sPdI/3dK8h2DS1P9TxvvA+OmYzP3iv/D3C1+qZFwufKbyb
8FXCH+l+7wjvqfZI3W+4cCuNyfBRencv4B/U/5HO9VT/S8KnC38h3Jv5pjEv
6p/b9Vuvxu/dXvgS3W+88Isaf4zwxxrfS/hl4TOEvxTuI3y08MKK7X0dta9m
/at/G93vAdar7r+n8Kup7eFV6t+R59H9bxOeo2teFW4sfJ1wR42/jvUQ7cFx
wfFBEu1jvWD/8Jju10C4frA/eEJ4R+F9hU8TXiS8F/axtK2boXN/qe8sHQ+q
vUX0h/uUXouP6Nw69e2gYzvsQ+p4oK7wNsIPpfaH2wtvi29P7a976+/ZGPuq
v/du4XPUP531Eu3F2cH+pm60N3tGf3mnzq1mbQq/K3yyjs+FTw721zViPNMi
+nts1q/q+1S/dxP2V7/3rPo/F75V+DLh54U3qdoeYnsWqd052L9tH+3fmcH2
bPPoz1lv7zCX+MZq99D9CKGOU39d9dfR+K2FJ6WOf+aqc5Zwc3yF8Nbq31x4
fOr4ahvhLYjHUvunbYW3xJamjtf4ez/V743WuQNYqzreUnt33e8G9X9YOj4i
ThohPE94tvAewjdVvT7e1vVddO4anfu68Lv8T+07ov+Zrf7BfGO1Lyv8+4fr
3yXMBz3PBcKr9Dx7M190/xkV28A/+fY6tlL7HvXXUf9OwfN1uvDOwq2Ez4/+
q4Vw69K+9gWd+5uxwf7/afXvpP6+he+3gZ77XuGWpW37ozr3u8aOKLw+5uv5
xxE/BfvTF1PHPy2E2wjPSu1fm+n6qbp+gs6tUN+The3j4br/NPWfIDwE24OP
Ih7RmF/UvkHt/dX/hPpPEW6n8VOFH2LN8i50z/58Cx23E+9o/AD1j9b4/Yhv
MvuPWep/SHhL4SuFG+g+9XTteN4hPkX9I7ANwsPUvlK//7PGX6/xbTT+FN3v
RvXfo3P3EnMJjxR+XHiy8MP4f+G7dP1Itc9S/+jUMUpD9e/E71ccE3+se78t
PF7tmuobyPfVcbCe4wCNGa5zr2nMgcRrardmPep+Y1L7JOK1ZzT2UfUPEu6p
9knkE+ofhU0kR9D9txP+Fpuoe90s3E74bl0zUO2qxtfC9kQfcif+Te2ziPWw
98F936rvYeENNX4L5kb0MRcI19S9T8psz7oX601y0iHz/Bul3ziC96XxJ2Lr
iW/UX0f9V2MPdY8d1Hc7c0rtS/EvfE+NmagbnVOsT4eSozL720sKr9fTM8/n
fhq/beqc4Fi1Ly7sn0/LPH8vFN6I2Cazfb1cY7bR+NU6d5HuP1n4OuJVXf+p
8GzhyerbSuMHafy72C/hesLXEO8KP0v8IXyt8LXCe+j6W3Ruqa7fmet1r2uE
hwofr9+/ivxA+Ar+htJz7QjhZ9Q/Rv2tsX+Z452JheOdKzPb/6ml85tpukdn
4TQ4HiAWf0343sL3Gpg5vqhd+l3i85/W2L30Tpthr8np1N5FRwO179DxuNqb
lH7X3XX9/br+KeEdhKcSA2OPSsd+B+OzdL+9dU1zYgcdc9XeK/j5304dT1+r
52ksXFt99wlvquv3Ee6h+0+qOp/sp7HLde43jWlL/FPxPbdTu1dwvP27+m7X
+M1i/EzMNwXbLHxrxWv6EeFdhKcQWwgPI//S8SNtYkmeR/h34ZuEDxU+VL9/
kX5/os5tmvn3eTcdhQ8rnf9erP5Lde5nPcMbwj3VN0JjD2ZtCveOMc3X+neJ
8MP4V/W/oP5dY345Vni68Av6/T10r4017lHhLXR0E16rez+ndtD4N4mHNP56
/E3pb3Oczj2vazsL/yb8o8a3V38N4V3Ud4bG3yO8ovB6Ije6i/dVdf7Os3+p
djv1X5I6h9pWYzbQ9Q3VPlPtieo/QP291H+xrlmua+5S/wC1V6v9svprCo9k
reMD9TxDdPyh9ki4gqr5hdrCHYXPrNpP4q+W6pirc0fAMej6Xth79f2uc5dh
L7Ax6quT+3lGCz+Ue74xP3fm3RPv4rcqtlHkv5OD7UW9GM8/HGy/G8R84EHm
CL+nsQ8Rn+q6XYVXJs6HWR+NhRtr/Jvqn67xTYR3i/Fxw9y/l6fmIObo34YV
27yLiClyv4s6Orc98a7Oj1N7VeKYkzyefH7ritcAc5q53QK/r/t30b8DmLs6
Nz13Hk0+fUrF8TPfn/i8udpvEd/o/hOEm+rop/tvnDueu4mYSu2Ncsc3Nwrf
lzvvJP/cSsfm3C/3fLlF+MHc33Nztc/WvV7Hnuf+fiN0bqLaT+r3bmC+VhwT
Tsd/xL/1Qfwv9jmOZf79qn//rdjHnam58IXu2033O0jnDiMn0/tdK7ycPJ74
TmPOEW6t/k3VXqzz3YUPFm6r8a9r/CFqPxX9O3EM8Uff1DHQ+cQwufOJenqW
g4R/0D3WsX517cs61jD/dO4J5reO1Wr/qnOHqO9CYs7UMcTl+Fbh79T/m/Ch
xIL6jfr4Qx0H6HeO0W8sIp8pzDe9pDE/aewSXfO48Fc8C3mexuygsT/p/IXq
P1r4eL4v/inObezfk8K14rdi/U3DH8Vvg/3Ff/zN99J9Zgn/mDneO0pjOmnM
OuFLhU8QPkN4M/gvPeu1OtoIz9T1HZhPufm2d/TvrIpt1kEae5rwJbq+k86d
zhoIXp9TY/zVSsc3mb/ZAcG8CfzJWRXH7E1Lx/oTNOYdjf0vNX/ZU+cuUf/H
heOZuzLzk/MLx3p3Z+bb/kwdq1Q0/h9sRm7fi8+cr3bn3PfHpi9Q+/vU3MRf
On7V+KuCv+Uq7Ai2LnWsfGbF8c9Zer5fKrbNlxDfCd8vvAQbV/U3/0Hjv8w8
F74ljyR21rFG534W7qv2vzr+EO6r8d+rvYjvoPHj9Pccy9zJzA9sVXr9Ywd6
CN9fOL8clDlf3ab0+mUdn4c/zG2fsKkvpM4DyQdrC2+ZO28jf9sSm5d7jk8k
Nkk9939Jzbf9p+N/xIyF8/VzM/vrQYXz9S6Z44VnUnO3yxLnrN9hR7lWx8/C
ReZ87AL9xhXMlcL26cbM/Bb2G/83Kc6RVM9zrdpvxnz7ntL+9JDC/qw9OZjG
PxDXMO+d9w8nQL4zDTtSMUdCvsbfxd/XSMeAzLwY/FgPHRcxP+Hb1L48N3+O
v/8Hf6Gxs1l/uv6+itcs+cK+eo6zUnOQrdTevnAs1oX1qfaruv7UaHvxz68J
nybcDS5E+CZ97yCcFuazftH5vyv2oW11bkQwvwXPRb52dbDt+Ja5InxNsC36
Xvhy4ZUat5q5Ccep6/9Qf3/hm3X+JfXfkDv3GhTPddUxkPg2PtM/Gn+V2q/l
5rf+Jm/B/+tcd507NfJfVwifpvbp+nu+U/vAwv57UmG+ZXBm/oOc4kc9yw+p
c412xEzEYnzDqvkQchdqHNQ6iAfOU/t77I3ax5XOHc7QufGl+fjT1f6i4vj7
KN2vT2pO8ezS8Qtrl3N3q92ldOzFnGHu7BLMt1zOPBHuVDpXOBO/p/YDOvqr
XZJDFY4PryAhSF0rYb7hL5ij36S+X9//9xmF7TPzgPkAN31uaW64q/Cdag8t
zXWS85H7LSNnLhwP/QR/zHounNOR23UunMeRzz0qvFTjl+aR3w7OB5hr5BTk
Fpfq3HeJc1RyVTg58ibyp6fU95Xwwtz5wcO694MaM4jnT52vwWHcF/8euA3i
ycGp+WhqBXAC+EX+5vuE7y3N5ZMjkCuA4VsvY52V5lzOz805wMXgY1mnrFdy
6wPVPlpHO+EXC68J5iHz8YvgNcPaIX4h1h2V2Y/gTz4J9iHYCewFuf1C5mzu
d3CZ+u/T+D7CY4Q/gzvOXbNags0L9ln4rosT147Ice7I/Tfw9xBDdyr8DngX
zOen8MvM9+ij8dXMSeYmMXm/3DU4YnU4pr65+Si4J2ogzfVvh9S1keWFa3c1
8TtwCxp7Te4Ym1j7Ef5m9XXS8UuwTcI23Zi41genPTZ3/Qyum2c7KDefwTOy
5lnnrPc1hW3oeluKTQle46z1lyvmtlnDrGXWIGtxX+FlmWOc/TU+C+YDbk09
H58UPiV1Dn0ZcwEblJlDGRTsQ7C5Jwn/o/7uwrvnji+fDfaZX8f8Zllpn4kN
h6/6D1uPzc2cY/ULruFRy7uP71N1DjAxdc2R3ACfiG9sL/x76ZoGtQ04v6zq
mtuM+H3yqmsiz8X5wU2oS1Kf/Fxw42Afii/tgA/T/Y4R/jdzPHF8cI5ErkRM
8EPpGhUx9hDhH+EihP/K7D87aHw7bHxmf3hksA0kz2sbbBvbqr02c3xwhHBL
3k/mGLBNcE2H2g41hl9L15iImfCpFfyVjnmZ86Gdg2t85AjkyL+VrhERszdi
vpA7lrY91LCoZV1XmgtvIzwi4v3UPlbH6NL8zCZqb4y94NpgrgdOBG6kL/F+
6hgWvmMjfZOWuTkhuKE7hdtqfN3U/NnVOnZLXeP8SOOvLG3bqHFS66TGAE8E
J/SE+ieQ/6XmGGYI1y5cN6N+9pXwSaVrIY2I+6I9rBtzsqnM1dK10+Y6d43a
Q3S0oD91PZUcllyWfJz1BkcPV0+NFn6tLt84dQwMn/W9xtytv6dlav5ux8K1
e2oKw6O9p+8i3eMHuGrigdRrZizcgo6OardOXT/EJmAbjtMxRn3b4+PUXlox
n8U5+vC5a1kPpW05nBfcF9+Ib7Vv6npGO+ETEte8qX2PLVyf6Ju5/jS8cP3p
gsz1mBuEDxLunbn+sn9pvnu7wvXnTeAZhH8nJ4ODIO6v+JmbFa4fXCl8E7ms
xt+au17ycowpHinMRy9Wex5zlRhc/W/p3Ee5+eHBao9S+wPiaX5DuC/2Xe0J
Ov9uYvuFHWtDXqn2UB2vsy6D623U3ebyLQvX+6j7fShcW2OeFT6/Yg4Ffpn6
7zD1v191PrCg4hrTnNw1eb7/vPh8PC/tNqyZ3PzUXJ5Fx9s8P3Mx8Tn4qn9T
24IFMb9YomN5xTHpX+pbJrxS7S5qh8z1FerNQ3T+PWxn7rUERwA3Qe73dcU5
FrkWNS9qX0viOx2Xu741U/gNtTP9/Rum5uxfyR1nEm9yLld7Xe7YhhjnGOEa
hbUAP2nMBmqvyj3X+MYbZ65PH4KtSc2ZoTeg/o8O4LOYb+8QY+QnieVL6zng
3j6t+h7cC5sCn12vMJe5jpha7W8Kx7/EwfPJ9wvn++T9C8hvdM1fFXNm6EWo
kROb4J87amzTwlqZtTq3W+GYkNiQuvMnVfMz7RLXrP/RuaKwLcOmBbWv0/yp
oXalcD2I90ftYYP4vhDT1IjreXDufHJ+xTWp99XetTC3h41qFN/nZqm/H1wP
vgJ+jZo/9ZaahWMvOB+4nzdTazfQcPyZmwfH9nEPvgf19iJ1jEOsA+dM7aR+
Yi76n9TcJM9EfgsHTa2PnA9ueisduwgP1XGi2hfktpXMSfQS8Ibwh4fG50d3
gm0eruPkwhwFXMXiivUT8PnUg9GMoB25MLdtbZY6/+H77q12d2Jq/FjuWJhz
9WO+xFhqFH/r36015oDUGgPqG1fl9kWsEfjCBoVtG3MI27Mgdez+lXB/OOzC
/DI2du84H9qmrkHsXtimE0vtWdjW71EYY9OwbfiYk4VbFPY93+fm7rkH84nv
y7shPidO5/dOjv7w9dQxNfoSdCbE2vNT5y5fVszHs/6vTqxRQavC+j4scfxI
HIkNwBasqLiewjvj3a0SHq92b43vwXqrmNMlxyPX41ybwvaEWgwcK1wrOQL1
Geo05A58Q75lU+ZEXN/Uloj3iPuOLJwbwZmjv4LjgethTcOfwVehnaFmRu2M
nGIA/qpwrkEOQ72KuhW5TYfC/cSHb8Q5x9xD84H+5PPctZT1NYvCNRw4ODhd
ajvURKmNUoNBy0NNldpq7RjvkY/elHrO7FxYnwKfTI2MWhk1HLQTtRLXdo7M
rCVAUzCO+K1wLEtMS61rQGnfDs/1RdW6JbQu/Ab5LjVZOGdqtmjrqHFT64YT
RQtGTZfaLjUhtHTUvKl9w6GiXaNmBQcD50Iti5o5HAw1crR1aBzGxudFa3Zq
5uffLK5vauTUyqlRo7UhvoQTG4rNjvHnn5n5JLRTxJNwYOTw35WuYVPLfiCx
Vo14FE4Ljuz70vHsb5lzaHJp6u/obwbgd9XXqrQ/xi8PqZqT/yM1hwBX/3fh
evTzsV5F7I2+qFfFNfeKrr9G7dvUHspvF65nP5e53kXN5PfUnBC1FGqga1Jz
iNRGid/75+aP0NIRU2GLscnXxXyvVuacf3mwBggtEBoBtJNoJNBKDE+spUIj
gVZiWGJt2ZuFazDE5MTm8LlwdNQQVpSuCa9NzYkOjnwuHBkc3qrS18BtoNHi
XvDFv6bm0L7Fdgfrb17JrKchxyDXmJVZj7KR8GfCb2eu328uvFh4TmZ9zmbE
qDx7Zn3QFuT0wh9k1vP0EP6GeCNzfZzctzuxs45qZr+B/4Czaskcz207ic+J
06/XuQPxFZn1OOTI5MofZtYPYX+oJz1esb1h/WLbqHHuk5vjwL5j5ydofN3C
toZ4mLi4lu73Be86s75oU+FFwu9m1jOFYL3SzMz6lk2EFybWit7MtxSeL/xG
Zv1DTeFPiR8z6ys2FF7Au8+sh0ATgjYETSba1690TFH7wcz17+8K11cfz1yf
J//bS0eL+HtfFq7PTspc39+7dPxIHDlYeF1hPc7TmevLPwg/J/xE5nou+SKc
J/n6mtKazpxnS6z1JD+9NDefjRYPDnVa9Odwq10z+/cGibWSxOxox4jZieWJ
2dFSwckSy8PJUkutl5ir5RuirYKj5dsS06Ot2iNxrI99mRbHY2/Id5vl1kvB
JZPTY7ux4dj6HXNrk9BgPBqcA+L78IH4Tjg/tE9w1nCB8HfECuRMdSPfRqxK
TkNug6a0iZ7htcRaUzS8rYXnJdb2ogFCCzQ1sRYRTQ7aHDRCaBWnZ9ZC8Q34
FmiU0CpNSqzlfTWz9o05xdyCH2iUm/+FS4czR+tFTgSXjqa1aWZNMVpXOHe0
eawJuPg9ictTx8Dkn/AZ76bOmf4srSH+K3f8ibYYvuLi3PwyWmQ0IWgLqaGP
jt93Zvw+fG80hGgJ0bSg3UUD9mr8Xnx/6iXUKODUl5bmVOFWqVn8W1qz8VNq
PgstB/zGubnrfbtFvqBX7voFWlU0M2hn0KiiJV5CDbjiGJF8mvoLtgMNEnqr
JqXXPhqETyMfsUXu+h/aU/gHagA76n6fl9ZMTI/zFy0FfAY1EGpWi0vXzFen
rjlRS0dTgHaRehlaAzQ8aHmo+aOdpeZP7Z96PNpaNAxoN9EwoG1Ao4RWCc3R
tMKaI7RHaGinF+ZDtspd/0ALjeYB7RuaILQQaFBmpK4Ro02B/6KGQc1mSeRP
NstdL0F7S85D7rMSfx5cD0K/A4c8qXTOQu5SQ+NvVf/pwXMBPgo+EP6TPGl9
TUHjXw3m7qhhUEuixkGcR7wHfw0/AldBTEdsd0hp7oMc/VC1Twq2JcOivTsj
2PeOjf4ezhXulZoUtamDSs8FNGAHsx6Da29o4vpE/pY6HOcWB/ejv+0t/G3k
U4hN4VDgUtCooVWjBnFa6XoStdOPdRwR+SK4ezhnuGdyslNz6+nI1Q4vPZb8
9tHC/AbcR+cYW8PvEBvDGcEd3VQ4V12ReP/Cz8G1AzhTuNOPq46becZTS3PE
cMVw+G8Er1HWKjkP+nf4f7hHanp8P+oLPBs5G/UE9HNoH4mJ0COuDOYS8Cn4
lj2D5yaakc1LawrQMaNpQWvwYowpqZ/UIv8I1pqMietnWnB+Oi7aJ/Qy1NKp
6aJPQt+CdoEa+X3B7wvt+8T4fqkZfoY9TlxLfC7YFk+I9rxx8FofFec/mgR0
UGh40CqcGhxbwSfC18Oxw7VTI0ZftCC4FkxNDP0LfDc8Cu9gVXD9Fd9GDQ29
Hfw3cR9z8JtgTh9unz0O+L85wbXmP2L8+DoxWcU1LmpdrxHjVlyDpRYLv0YO
COcG97Yid979bpxvH6ivf+Ka28JgTh9b2LFi/duJwbaQePlD/Gdp7oGYhv0z
2G90GOgxLlBfn+A2nCbc5uTCXBUaIvQ7cFzsC0AzC/e1nkOvuOaGPpI5zFyG
s2F/AnzazcRrcb2y/uZUXPPGHrcprc2fE9cj65ux2GRsM5wY+xTQUMKVwcmR
o3NP7g2n9mVuzg+uDX6UnJ97cu//BccnxPDE8g8V5q7QgKD/+a8wdwQHhz5z
WNV7HtCA/1y6HkXORM2H+g4xPto07knsT0zbKPpjYt3zg20jGvGRhWP+HTNz
guQC5BA35t7fw/NQk4DbI0egH85uTG69I1wenN743Pp9uL53yOEqrjcQj2+l
442K9yRVS3N67AtAQwrXRw2JWhI12EWsjeC5gCaGfAnOKc2dP8BFjQmurfyj
/h7Rnue59U1wU/8FPxucVHf1NwveSwWn1qt0/RHbTQxOPkI9EO4UzhfuFw5n
YWY+Cm4HjuwTYtDE3Fnv0rVIfAr5z42FuTdi/J7B/uezzHwRXBx870cVc6x8
fzQiaEU41z6ub2pxaKrJn6inwbvAv6AVZX3gm56M8QKaC/IGYgBiAWrgcJro
JaiNoxmBc0JPgZYEDRE6PzRlaIvIocml0d9MKVzfon6DRhutNvYTvQYa3ebC
vwXbUmLsvaM/w3eRQxIf4z/vT3w98RQ5KfUc/h5yVXJItJPE9OSWaKDQIaK5
QxuFBgkdBHoItEnU0rBV2CzicjSV8JH4DHxHk9z6LewpdpV6OXOH/JQ8FX0V
tgabsy61feNet2WuZZ4QXFviHfIuR+bmx2cn1oQvKn1vNELoQzbQ8Xxim4Jt
6ZG79k7+jn6lqLp2NSPm49TzsTWsJ9YVeij0I911LEutd8LX99CxnJihNN8O
d40+Cs0NsSMxJbHl4cG/RU5Pbk/Nj1iTGIhYCL0De+eor5I/Lixd2+Pd4Hu+
FD4r8V4P9Eqtg2M9YjxiPWp46APYl0FtD30RvoX8njyfGhexFjEiseJXpfl0
eHX0Veid8BUXxHtuWPVeBWwitrFm1foG3gW2hhojsTsxOrH6X6VrecxR5ir5
L1pu7CX8Ibo89HmnxG/yd2ltJHOIuXRg8LMSYxNrH5pbe9Yt8X4T9E74movj
GOY8fHStyCedkFurxTtB/3OS8LEVv2P0RicKH1PxO0AvA5+PLaTmwZ4V9GZo
YfmGA4L1Yeyt4R31V7tadXyCzcP23ZLbllMTYE8ANWD47Otz14Z/DOZP8Kcj
g/N1tOj4E/jB74JjPWK+G9Uuq9afsheL+gT6VGIlbAx6L/R31EbO0ZiBap+d
W3sJf4K+idr2ZRXnc2iy/yhdqyUGIRZBf4Z+lvidOJ4aKNwUHBZcFjVTaq1w
VnBXcJpwm8SEJ5e2x+w1o+aDv6A+zt4vzrFR47ZgLQU+Dd82NtiWs+/vqqr1
82gXiNfRF6J/RJ8OvwfP1yk4l8dWkMujF0AbzX7ForT+FV9RVqzfQS+J/g6+
Et6yYbCec32OUbW+hlhoYFxzeel7UcPCv6GfRWvJM5CP/FR4vlMjYv/NssKx
JDUdvt+GpbWaaC7Rz2JPqZ3hn+Em8P/42rejvyZeptYJZ4rehhybb8M3Yv8M
+l+0mvwNdwTXi6lVwvHC9aInpvY2jL9Z7X8L2zZsHPuHmG9oD6ixsX+DGji5
CZwl3OUxwfUxfAq+hZo6sSecCdzJytK2DNuF3gnNJFwanBvcGzwXvpB8fH1e
HszFwdnB3X1Tem1iC9HvHRw8F+Hw4PJWl7aNaHnQT7UP/hbYdrjIrsIfJeYk
4CbQfMLtwenB7R0UzAWut11Vax66Jt6Hhhbi3GAuAY4DrqML8UlijgGugRr9
TolzZnJn9jsQK7VNrP9FX7x9xTWhu9VeV5prIKcgt9gk97eGX4Zn3jW4to+P
w9c1Cq79o9ElX20erB14K7VeGX00sfyl8Z0cHVw/wqfj2x/AJlSsqSffQD9N
LrKL8PMac3/ws/XMrNdFr0xu0jDOcdYUaws9y9rSNgPbwR4yap3wN3UjnwP/
gz9CC4oeaHaw/0F70lZ4VrB/QAtxGHM4mHOrE/kh+B/eP7EgMeHMwhzkmtwx
F9wk8wvtBntYGpWeL+QW5BjvBe85Yu8RmuMJwXvU0CWjT749+H2S+8Pf9yPu
Dl7raODR75zLmq94zzv1BTTyaOXZTzw6zn+0IMxh+OYGwffeRMf44PwRLTc5
GvwGexrQdXPunuB8Ea6Fb7p+70Mwl0F9D/6GeBbunzXwbmF7idYEHzM32J6i
LcHHfBisb6LmR72yNr608Lv9KfqTFwq/+zXR36DR4tusjfad/BKuEJ8O33dh
nA/M2YeC988enlhDPyXmA8wl5tSk4DnIXGQ8c/2W4HdFDZj4+6nCWn40w28F
60mombI+0JKwZ5K9k2ia7w3Wk+I78CHUD7AX5JLklO8TqxfWfhMjkR+jl0LT
xf6nmcH+mliVPZr89xaIkYiV8Gn4NmIQYhF8ML6YGIdYBx+MLyZfwHegH0OP
hX9hr/j6GnZh/8PeeOpNaKnYc3Js4fo7WkP2eH6cmV9l7yccNFw0e37hwsmH
0DKg0fw3mOPHBh6ceG8c663I/Zv8NntSP8+85tmrSr5F7YYYs0bVHDZcNj49
VL0n5M7cNh3bTr6FlgINbhb5lG9yaw6JldErNok5Mbkx+RO1e9bEqOB8htr/
ct2/ezB/yh4hYqrxhfWERxS2gew9hA+iVo+mfF5wDZVaKhxyh5jfonOAQ+5Y
Ov9H8wonCTcJpwq3yh4N9uvg40Pud867R/OO9h1OBW6F9Znl1pOht2OPAXsN
8Hn4PtZ/jdx7Ztm7Sv2Q/6aFPtf6eiKaXLS5xFxfR3uAlo//Jke30ppeNBfo
B9i7jqaAvaZoQKlXLY19aHyJr5jP2+XOIa+O9otaChzFxlVr+NHyExMQG2Bz
2SvB/hBsMZp/tP9wRHBF2I+tc3NM2AvsW83cGlj0quxpYW9L+zg/2HNXFtZD
oPVijwoxMTkKe7vh/9mjjw+ifsAeGPbCsMZZ6zwDz4LmHH9FDZhaMHqP60vX
aMh7iBGo3VBT2i/y/VvG+cq+llW872Cfj+/HR8MHUQNjrzo1NGpjzN9rc8c4
5IvUdNjbSE4JH4feE9+ND4cPYH2hS18m3C24PtAk8v3UG4gRiBWIOeCb8OH4
cmKI5aXXK7oXcvAtq9Yvrsicn8P94s+XJq5fM5+pybWK9QdqdexJyGL9B66M
GhF7/6bE+IyaHnv/2ZNPrY+aE3tL2eNALYqaGXvz2Y9JLY09D/y3WdgDxl4I
YhhimZ6JteHoM9H+otFAb8b3RVMCZ7pp1XwjtRBqgvz3G+DcyX3IgdgvSP6E
VhMOkfoHNTf2HhM/UovbPfhdovGBr2CPO3vd8QfPFF7jrHX2WLGfj5omeQj5
CLVObBa2i//mA/UkckJyQ3LIL0rvuWfvPXscpkb/wtxAc8R/34Q5ydwkR2f/
ITU89tpOTlzbo4bYONaXqP9QY+S/nYBemdoj9o69cG/xPFXXYMmzyLeoza7X
ZOp4Cy6hcE2RvdazEtca4XuwbTvH9coehpWx/oAvQs96SO49tfD5/wdLXQ3B

         "]], Polygon3DBox[CompressedData["
1:eJwt13nczlUax/Gb57nv21pPtqSRDJlMtiaazJStQtmltJAQUpZKpVBelUp6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         "]], 
        Polygon3DBox[{{1794, 1175, 804, 805, 1176, 1795}, {1966, 860, 695, 
         694, 1036, 1689}, {1595, 901, 991, 2012, 1463, 1464}, {1464, 1463, 
         2013, 992, 993, 2014}}]}]}, {}, {}, {}, {}}, {
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0rkuB1EUB+Br35dKSTwAT2DfhcpW0OksQYloBbXwJ2KLICJCghewRUNh
35dWvIBofBPJnHznN8nMmXvvFHYPtgzEhRDGVXt8CFGfxSxNd1IIufIQCzjG
Yk6wlDNs5hq7uM8D1as/5wgvOckbxvjGDX7zkL88YUqKbzCzz+xruZVHckmC
Z+VS3rKMdyznPSv4wEo+sorV6klfw2fW8oV1fGU939jAdzbyg0uJ1mZmv9mf
chuP5bzkEK7kVB7zJ1onv7jOF87yihO84DDPeKp69Hvs5CqbOM2SaN9ZxFHm
c86MHDM7zM6J1sUpeZfZ8k50NtxmJreYwU2mc51p0ZkwlStcVrY3LNLrwwKN
C/O05BBjQnSedIVlNyfj/v+HPxG2Q2U=
       "]]}, {
      Line3DBox[{1378, 1686, 842, 1377, 2072, 1559, 1379, 2073, 1560, 1380, 
       2074, 1561, 1381, 2075, 1562, 1382, 2076, 1563, 1383, 2077, 1964, 2141,
        1384, 2078, 1564, 1385, 2079, 1565, 1386, 2080, 1566, 1387, 2081, 
       1567, 1388, 2082, 1568, 1389, 2083, 1569, 1390, 2205, 1687, 1570, 
       1688}], Line3DBox[{1392, 1965, 2142, 1391, 857, 1393, 2084, 1571, 1394,
        2085, 1572, 1395, 2009, 2086, 1573, 1396, 2272, 1953, 1954, 1574, 
       1397, 2207, 1689, 1966, 2206, 1801, 1690, 1967, 2208, 1802, 1691, 2087,
        1575, 1803, 1692, 1804, 2242, 1576, 1398, 2035, 2088, 1805, 1577, 
       1399, 2037, 2089, 1806, 1578, 1400, 2090, 1579, 1401, 2091, 1580, 
       1402}], Line3DBox[{1404, 1968, 2143, 1403, 1969, 2144, 1405, 868, 1406,
        2092, 1581, 1407, 2197, 1637, 1582, 1896, 2263, 1638, 1897, 1583, 
       1408, 2211, 1695, 1905, 1970, 2210, 1807, 1696, 1907, 1971, 2212, 1808,
        1697, 1699, 1972, 2213, 1698, 1693, 1701, 2214, 1584, 1409, 2036, 
       2093, 1809, 1585, 1410, 2209, 1694, 1811, 1586, 1411, 2094, 1587, 1412,
        2095, 1588, 1413}], 
      Line3DBox[{1415, 1973, 2145, 1414, 1974, 2146, 1416, 1975, 2147, 1417, 
       1059, 1707, 1418, 2198, 1639, 1640, 1419, 2069, 2199, 1641, 1898, 1642,
        1420, 2064, 2217, 1709, 1906, 1710, 2270, 2067, 1941, 1940, 1711, 
       1908, 1712, 2273, 2070, 1421, 1643, 1700, 1644, 2264, 1899, 1422, 1645,
        1702, 1646, 2200, 1423, 2215, 1703, 1810, 1704, 1424, 2216, 1705, 
       1812, 1706, 1425, 2096, 1589, 1426, 2097, 1590, 1427}], 
      Line3DBox[{1429, 1976, 2148, 1428, 1977, 2149, 1430, 1718, 2150, 2041, 
       1431, 2038, 2243, 1813, 1708, 1432, 1074, 1721, 1433, 2071, 2219, 1722,
        1885, 1723, 1434, 2265, 1900, 1647, 1909, 1648, 1910, 1869, 2220, 
       1943, 1870, 1911, 1649, 1957, 1650, 1912, 1293, 1435, 1913, 1958, 1651,
        1713, 1652, 2266, 1901, 1436, 1714, 1814, 2151, 2039, 1437, 2040, 
       2244, 1815, 1715, 1438, 2218, 1716, 1816, 1717, 1439, 2098, 1591, 1440,
        2099, 1592, 1441}], Line3DBox[CompressedData["
1:eJwVz7kyA1AUBuBjxpJXQBCt50BkYiYR8gKqLJZKCp7BUhmU1iS20DB0IXot
ZrxHxIxP8c35/3PvLe7k8nphrS8i8pwMRDwNRZQSEcfys1yWT+WHwYhhvaJ3
zTO7H7Ojj5iPzs/tevKb3ag5wzQX9lM05G2SzLNPlrqzL2825R22GCPPATm+
nTfcW5J3KTJOgUMWeHen6c6svEeaif+3/RFH5iKXzufMDCmq3vyaV/Yf5oq+
4S/X+qe+qtf0G/1Obssv3Or3+qvcoaX/AZQxLxg=
       "]], 
      Line3DBox[{1460, 2100, 1593, 1458, 2101, 1594, 1462, 1656, 2102, 1595, 
       1464, 2014, 2103, 1596, 1734, 2016, 2104, 1597, 1735, 2018, 2105, 1598,
        1736, 2046, 2106, 902, 1469, 1729, 2107, 1599, 1902, 1660, 2108, 1600,
        1737, 1662, 2109, 1601, 1738, 2022, 2110, 1602, 1739, 2024, 2111, 
       1603, 1740, 2026, 2112, 1604, 1476, 2114, 1606, 1478}], 
      Line3DBox[{1477, 1605, 2113, 1475, 1665, 2166, 2025, 1474, 1664, 2165, 
       2023, 1473, 1663, 2164, 2021, 1472, 2020, 2163, 1661, 1471, 2019, 2162,
        1886, 1956, 1955, 1470, 2047, 2161, 1826, 1728, 1468, 2224, 1727, 
       1825, 1087, 1467, 1659, 1726, 2223, 2017, 1466, 1658, 1725, 2222, 2015,
        1465, 1657, 1724, 2221, 2013, 1463, 2012, 2160, 1655, 1461, 2159, 
       1981, 1457, 2158, 1980, 1459}], 
      Line3DBox[{1480, 1982, 2167, 1479, 1666, 2115, 1607, 1741, 1667, 2116, 
       1608, 1742, 2027, 2117, 1609, 1743, 2028, 2118, 1610, 1744, 2029, 2119,
        1888, 1949, 1611, 1887, 2260, 1745, 1827, 1983, 2227, 1481, 1747, 
       1828, 911, 1748, 1668, 1829, 2247, 1612, 1750, 1669, 1830, 2248, 1613, 
       1752, 2030, 2120, 1831, 1614, 1482, 2031, 2121, 1615, 1483, 2122, 1616,
        1484, 2123, 1617, 1485}], Line3DBox[CompressedData["
1:eJwVzjlOQmEYheGPqMgOrO1EhRWAE53BgesAWroA3YATkLAVNwC9ljYOEEIQ
jEpB7RJ4KN6c95z75eZfvbpJrlMRUcbbUsRXOuJ5OaKdiViTI/1FdvQxb6HM
E/mNf98O9BOe5Sl+iHW+g10UsOLfP25+saeXUETX7cM87Y/yHHeoYuLbn/2W
36PPm7KGOi7QczOxN/gTBnxDThcjLuUW9jG0b8pX96d8mwc/Qo6f2d69cUE/
Rn7+FtuHraJX+SdPeI13+Qw8/SlT
       "]], 
      Line3DBox[{1492, 1986, 2168, 1491, 1987, 2169, 1493, 1766, 1839, 1988, 
       2233, 1494, 2052, 2131, 1841, 1625, 1495, 2230, 1758, 1770, 1626, 1903,
        2063, 2267, 1671, 1773, 1924, 1960, 1925, 1772, 1315, 1926, 1672, 
       1937, 1927, 1930, 1928, 2275, 1775, 1929, 1931, 1673, 1939, 1890, 1947,
        2201, 2062, 1889, 1763, 1892, 2068, 2231, 1950, 1891, 1764, 929, 1496,
        2050, 2132, 1843, 1627, 1497, 2232, 1765, 1628, 1498, 2133, 1629, 
       1499, 2134, 1630, 1500}], 
      Line3DBox[{1502, 1989, 2170, 1501, 1990, 2171, 1503, 1767, 1840, 1768, 
       2234, 1504, 2053, 2250, 1842, 1769, 1505, 2202, 1674, 1771, 1675, 1506,
        2203, 1676, 1774, 1677, 1507, 2065, 2235, 1776, 1938, 1777, 1883, 
       2237, 1948, 1884, 1778, 1962, 1779, 2269, 2066, 1508, 1904, 1678, 1893,
        1679, 2261, 1509, 1680, 1681, 2204, 1510, 1152, 1844, 1780, 1511, 
       2135, 1631, 1512, 2136, 1632, 1513, 2137, 1633, 1514}], 
      Line3DBox[{1516, 1991, 2172, 1515, 1992, 2173, 1517, 1781, 1845, 2174, 
       2054, 1518, 2055, 2251, 1846, 1782, 1519, 2056, 2252, 1847, 1783, 1520,
        2236, 1784, 1848, 1785, 1521, 2238, 1789, 1932, 1790, 2255, 1522, 
       1791, 1894, 1792, 2239, 1523, 1682, 1895, 1683, 2262, 1524, 1684, 2175,
        2033, 1525, 1993, 2176, 1526, 948, 1527, 2138, 1634, 1528, 2139, 1635,
        1529}], 
      Line3DBox[{1531, 1994, 2177, 1530, 1995, 2178, 1532, 1786, 1849, 2179, 
       2057, 1533, 2058, 2253, 1850, 1787, 1534, 2059, 2254, 1851, 1788, 1535,
        2060, 2180, 1793, 1536, 2240, 1794, 1795, 2256, 1537, 1796, 1797, 
       2241, 1538, 1951, 1952, 1376, 1963, 1539, 1685, 2181, 2034, 1540, 1996,
        2182, 1541, 1997, 2183, 1542, 960, 1543, 2140, 1636, 1544}], 
      Line3DBox[{1558, 1800, 1180, 1557, 2196, 2008, 1556, 2195, 2007, 1555, 
       2194, 2006, 1554, 2193, 2005, 1553, 2192, 2004, 1552, 2191, 2003, 1551,
        2190, 968, 1550, 2189, 2002, 1549, 2188, 2001, 1548, 2187, 2000, 1547,
        2186, 1999, 1546, 2185, 1998, 1545, 2061, 2184, 1798, 1799}]}, {
      Line3DBox[{661, 843, 2072, 662, 857, 690, 2144, 867, 702, 2146, 877, 
       713, 2149, 886, 723, 2153, 894, 733, 2159, 900, 2101, 744, 1006, 1106, 
       908, 2115, 759, 1124, 1125, 2229, 917, 771, 2169, 925, 780, 2171, 933, 
       790, 2173, 942, 801, 2178, 952, 814, 2185, 963, 829}], 
      Line3DBox[{663, 844, 2073, 664, 858, 2084, 691, 868, 703, 2147, 878, 
       714, 2150, 1070, 887, 724, 2154, 1071, 895, 734, 2160, 991, 901, 2102, 
       745, 1007, 1107, 909, 2116, 760, 1020, 1126, 918, 2124, 772, 1142, 
       2233, 926, 781, 1143, 2234, 934, 791, 2174, 1154, 943, 802, 2179, 1163,
        953, 815, 2186, 964, 830}], 
      Line3DBox[{665, 845, 2074, 666, 859, 2085, 692, 869, 2092, 704, 1059, 
       1060, 1193, 2243, 1061, 1062, 1197, 2245, 1072, 1073, 1082, 2221, 992, 
       993, 2103, 746, 1008, 1108, 1009, 2117, 761, 1021, 1127, 1022, 2125, 
       773, 1144, 1145, 2131, 1209, 2250, 1146, 1147, 1212, 2251, 1155, 1156, 
       1215, 2253, 1164, 1165, 816, 2187, 965, 831}], 
      Line3DBox[{667, 846, 2075, 668, 976, 977, 2086, 693, 978, 2197, 979, 
       705, 981, 2198, 982, 715, 1074, 1075, 1198, 2246, 1076, 1222, 1077, 
       1232, 1083, 2222, 994, 1098, 995, 2104, 747, 1010, 1109, 1011, 2118, 
       762, 1128, 1205, 1129, 2126, 1206, 1130, 2230, 1131, 1148, 1023, 2202, 
       1024, 1213, 2252, 1157, 1158, 1216, 2254, 1167, 1168, 817, 2188, 966, 
       832}], Line3DBox[CompressedData["
1:eJwVzi1PQgEUBuBzATcSSUA3C6P40WwEg0n5dLJpIvkD9B+YCBq0qcHpHzDw
BxjFwEbDsRksBk06k0iUh/DsvOe95+7e0slZ+zSJiAYPqYiDdMRaNuJR3l+K
eJerZo06DaaZiFf9xO2f3NS1uNPNFs/0X+ahrs2TPmdusE6HTbYYunthzA49
tx/er8ufZsX+7V9+5WPd1NzT/cjL3s8zkotmgSNWWOVf/+Y2kYNze8K9LmXP
kGagu6CvvzYvKftO134jP3PLtu5KNzR3mQPfKidh
       "]], 
      Line3DBox[{671, 848, 2077, 673, 1034, 2207, 1036, 694, 1049, 2211, 1051,
        1285, 1286, 1287, 2217, 1258, 1290, 1289, 1063, 1274, 2265, 1275, 
       1260, 1325, 1324, 1326, 1297, 2268, 1298, 1084, 1296, 1295, 1199, 1087,
        1100, 1089, 2106, 749, 1111, 1261, 2260, 1113, 1202, 1235, 1236, 1227,
        1307, 2258, 1306, 1367, 1308, 1309, 1149, 1315, 1314, 1210, 1327, 
       1328, 2235, 1159, 1370, 1369, 1317, 1169, 2238, 1217, 1171, 804, 1175, 
       2240, 1220, 1177, 819, 968, 834}], Line3DBox[CompressedData["
1:eJwVzzFIAlAYReE/KxJKnIUwXaTVIBzawjFIHI2Wlia1xkanRpeGajKScG0T
GiJcIoiQoCkjh2ajWaTP4fDuPffx4OWPmtXGQkTs4TYRUV2MyCYjunJqKeIG
Hf2Q73Pr+h263DE34PaXIyoYc5u2VfnE9mpbk1Mo8Z844z/4kTx0/8v5jDe0
bN+2U35Xn+Gc29EnfE0/QJub6lnvbqDO/eDdvUvbCnJ8HhP+iv+d/4NPo8hv
YcT/8WW5x2dwoT/y93IB1/qT/iBvoy2/OMv4BysJKjc=
       "]], 
      Line3DBox[CompressedData["
1:eJwVzL1KAgAUhuGTGThFs1DS5B2kgYIZ2uRSqz/R1KToVTh6DYLdggiOQUTS
ZohLtNhaJFGQ0OPwcr7v5ZxzfNO5bO9ERA2jRMTVbkQmFXEn7ycjhmhyWW7C
HepHGOm3/D33qy/kBfcjd+VnfiMv5SX/J+f2IvI4xauexyNK+hne3PTsrtzU
+L5Z0D/4b7nODcwHbsPN9QZmWOEdRX8KaMufGNst6+c4cJvg5tyXWeGqSPNJ
/YVfb39yTWT5a/MCLUz1EwzsPZkV/AP49iwn
       "]], 
      Line3DBox[{679, 852, 2080, 680, 1039, 863, 2242, 698, 1040, 873, 2214, 
       709, 985, 2200, 882, 719, 2151, 1065, 890, 727, 2155, 1081, 1091, 898, 
       738, 2163, 999, 1102, 905, 2109, 753, 1015, 1118, 913, 2248, 766, 1238,
        1120, 1229, 921, 2249, 776, 1135, 929, 785, 1027, 2204, 937, 795, 
       2175, 1029, 946, 808, 2181, 1030, 957, 823, 2193, 972, 838}], 
      Line3DBox[{681, 853, 2081, 682, 1041, 1042, 2088, 1187, 1043, 1044, 
       2093, 1191, 1055, 2215, 1056, 1195, 2244, 1066, 1067, 728, 2156, 987, 
       1092, 988, 739, 2164, 1000, 1103, 1001, 2110, 754, 1016, 1119, 1017, 
       2120, 1203, 1121, 1230, 1122, 2127, 1207, 1136, 1137, 2132, 1211, 1152,
        1153, 796, 2176, 947, 809, 2182, 958, 824, 2194, 973, 839}], 
      Line3DBox[{683, 854, 2082, 684, 1045, 1046, 2089, 1188, 1047, 2209, 
       1048, 1192, 1057, 2216, 1058, 1196, 1068, 2218, 1069, 729, 2157, 989, 
       1093, 990, 740, 2165, 1002, 1104, 1003, 2111, 755, 1018, 1019, 2121, 
       767, 1138, 1139, 2128, 1208, 1140, 2232, 1141, 786, 938, 2135, 797, 
       948, 810, 2183, 959, 825, 2195, 974, 840}], 
      Line3DBox[{685, 855, 2083, 686, 864, 2090, 699, 874, 2094, 710, 883, 
       2096, 720, 891, 2098, 730, 1094, 2225, 1200, 1095, 741, 2166, 1004, 
       1105, 1005, 2112, 756, 914, 2122, 768, 922, 2129, 777, 930, 2133, 787, 
       939, 2136, 798, 949, 2138, 811, 960, 826, 2196, 975, 841}], 
      Line3DBox[{687, 1032, 2205, 1033, 688, 865, 2091, 700, 875, 2095, 711, 
       884, 2097, 721, 892, 2099, 731, 1096, 2226, 1201, 1097, 742, 906, 2113,
        2114, 757, 915, 2123, 769, 923, 2130, 778, 931, 2134, 788, 940, 2137, 
       799, 950, 2139, 812, 961, 2140, 827, 1180, 1181, 1182}], 
      Line3DBox[{828, 962, 1179, 2184, 813, 951, 2177, 800, 941, 2172, 789, 
       932, 2170, 779, 924, 2168, 770, 916, 2228, 1204, 1123, 758, 907, 2167, 
       743, 2100, 899, 2158, 732, 893, 2152, 722, 885, 2148, 712, 876, 2145, 
       701, 866, 2143, 689, 856, 2142, 660, 842, 1031, 1183}], 
      Line3DBox[CompressedData["
1:eJwV0L8rxHEcx/E3h66uLBbZlHN/AG44dZS/ANd14haDSW61Md1gMFiY0NWl
ZFAGpSxXBqVY5Fc5dwws/gGLx3d49n6/nu/X8Okzulpb2OiJiCXMpSJusZuO
mDSvcNMX8SAfmFn5HC37PbdnDssnWO6PGMcO94Nr9xn52z7ofoSK/MmPmVv8
F4qJMwfc91GWuzpdbh0dTHMf5l+vt+lcuFfkX7mevEmeldvytlzSH0KRe0PB
3tZ5tT/qbOosci9yHs84c89zT/Y7nZpOTk7jlHtP/sQ+hQm0dNZ0GnzTfQSX
3Ap3yB3LGTS4ea6aOPs/Twsy9Q==
       "]]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJx0fXVUlV3zNoitiNJgYWCBCIh9dOx8TERF7A5UbEXsxBYDUVFCJVRCVASP
bKQRQbrzJBzKIuyP33Nf51nL+3v1H9eatdfsmdmzr7lmn31veqzaNm9tMxUV
FXFrFRW1pv/nNta/N7PMZ/PEY2+pT3Mlh6kHApqZV1PI5UxN84hC9iKr+lJ8
wH3mdHtkXtmlKjr1eXb/7XOL2eFHoZFJmpHM6UJFyzhJJelN0z360KiYtdud
ajDyYTJrt+CFdvMxTfLxldEPpxYwH7P1Jz13ZLPm6Wt/XApQ0CpBqve2zlns
xYPaEvu0ImY1pspo9GQF3dsuF5WOiWfexdX1Fv5lLHDyYItXbRXkExA+aM/p
YMHzAsm3e09F7PAz6ze6jRUUwI0nD974dZx+egz9Q6HfkLOH3GFPC9gD++nX
Ls5+ddgPf2k//D0IfxEfuo34HEJ8EE/ix1Nn/NBUV49CFvhlgdab3mG0s6jv
xP07qqjEZO98h6Gl7M6aF11OunuTr1pAv6RLlTT01pqhj16UsV8/pQ9ajvFn
U8aEdjjqpqCAEdO/x0wXsTe6yY4tzeNYvV1h+Ae/Cjp1pMDIfFwZO1Dbri7U
L5M53DhU1ygup9819buGxRewyF+m2VuExSxn3fJeWmvKKUm+XHXVxfes2G3u
FvOtYlYxp+U/wSbl1G1exfAEnZcCh9GtDDNaSlnATLuJU7qXk4gbT8rx5Rjf
vPZf/RTG03+Gs4e2wZ4dsOcJZz+Fwf4G2A9/6QPP3yIuPhSH+PgjPogn8eMZ
d/9Xg1l9ESvbtC4q2CqR9rfV7JR6uZJo3JsuPZ3LmOpoxZPNI6KpxbKv3Y1s
FHR6rv6J31IxSzj066yDTTAtuqLocaOhnLw+TjUZfEDKTpU+eKp9IYDlDr4V
MOC+nEYa7Su9sUTKGvXqBp/pmMJ2vrC8qXZHRt9WNNf5OV7EPs6o6m+1oZC1
GxTdNrizjNTn/hMZVZPFqnv4fiZbCZvj/yOi3EhGoxeuNmvd943g0dnknP4q
cibILgjeRzIy4MaTgjf+J6ef5NDfFvpHcfaQnGePN2c/LYL9ebAf/tJ7+GsL
fxEf4scH8SR+PPu8uOzSuLqIhRpW6k8cmEnmKWE/1l9V0Fqdk8bHI8vY7Ivp
y1ump1OefEqnBnk5JS5ZFGxfIWE3wk74hlmlUMeHTgGv1OQ0sKOJWV9/OTMU
mZpXGEbSoi5XOxr1l9LlnUL3awYVbGRNSc3FVv6sq36HV3MTxKTvYL948Gk5
mzBr1IInUzJYlla+n2yLmGx/nIrqFVzC3spSny+qFrH3VZWPWi+VkNemc6su
bX0r+JbcO7K7Qs60Hn5uaTVBSpu58RSN8SkY34XTT0N5+i9x9lBNNWePEewx
4ewnY9hvC/vjOX+J7+9qLj40B/EpRHwQT+LH09RklVVBz3z26rhp3tUphWQ7
+9BjulRBBgv77swcVspcPVo+OjeqiAaPnhFttlZO4Z+bfR4XLma7eg269Xtw
IbVscWEqlUlo3LIREuFkOTstPhC5tVcu6a+ZdWvFIhE1tt5o3XeWgjUWtjU/
nPGe2nb6uebKmlJq1irxhkFgJcvxtNSKX+9BuvEPVZc2L6Ub8//ZFuPapOfq
5qLv+plMFOD9YHRvMUUtD/VJFuQJvLafOBBwTMKy6wIWt7hcTne48bQD44sw
HvpJ14vTrwP99Zw91LzoT3vGcPbTedhvCPvhL+2Av23grz4XH7qJ+FghPogn
8eN51SXsd2xyBhuZtUKUll1GHxuDXCUPy0lgsq/v6k557H5wZKd+F8WkFuhT
kNdMRgOvvW2xYmAJM7hXtu/qHQkJq38PHlciougB+t7txSI2Wpzb7byrhETi
NQ77LUroTP3vLlu7y1j/jKx5U8eJabVm0HZbtzxavyC2aOTLcjbz+SK3F+ml
1G6k07QvSdl0Pq/w5DD/cjbnudHllcbFFP4kq+OpXQVkHprk0qAtEXQ3873X
TCImUbMuquadKugiN57mYXwQxq/m9JM1T/9pzh4ygT3rYQ/j7KcxsF8K+wdw
/pLS39fwdyQXH1LGpznig3gSP55WckeruG2xzNTyguHC3RJqnrmsV6VaU93Z
nhMbuyOJrVzXu+qZkZxuacUssmoppbIVcRveTUhj2kO6tqzeVEEP137sO3lz
GV10bxOa2y2LXTz0+wX7oaBbg/qnjO1dQG5dg3QuROey9qYHVz+IqKT+cSey
9+hlUo6D4YDEh/ns5C71gMweVdRxVTc9D/9k6jNm9+P2flnMT8WEth6oJi3z
JwecDyfQPIv44EyPGEHqyqjV37fWUodi+4/zv8WTOTeefDFeF+OzOf10Avp1
of8WZw8p7TGDPec5++kC7HeH/SWcv6QJf33hrz4XH1qO+NxGfBBP4sczpcuI
1G4dggS2uder+m2QUsb08R4dE+XkZBPh38frmWDW654+wq3ldDJ6ypxp/hLS
M233elzbcIGb9eZRM80q6XvjdZN/xKWkuyiid6qUCQonq42LnVNNAVW7k9/5
5pFq1qZ5X1yjBJK8PtEhwTVUfq7DXl/9dOoZbB8+d0O04EphnPanzbU0de/J
cQEjEkg13mxmYahQ8Czh6voO4bVUWrWjKCMoklqMXt2lINc37PqqDhOkybXk
ufDD5dGThNSJGy8MwXgJxkO/UKl/tlI/Z49QDHuqYY8mZ78wH/aHwH5Nzl+h
K/z9CX8dufgI/0F8TiM+iKeQH8/xiP8AxL8F4j8I67WCl89VWN+OvHx2Rz6c
5eWDP/KnNfJnIPKnAvl2FPmmj3wbgfx8gPzsgfzcwOWzMAX5bIR8Ho/89+aN
h352GPq7Qr8f9pfSHnPYcxv78Rzs94D9CuxfDfjrB38HYL8r89kd8UE8GT+e
bsCT4cCTT8CTicAfLx7+DAVe6fDwOR74NhT4JgG+XQQe9gAebgAe2gM/JwI/
OwE/XYC3JsDbeODtGA6fhSrA5+/A52vA8wEY/xrjNwL/J0O/JvSfQ73oDXs2
w5441JdhsL8C9luiHunB3wj4Ow71y5MXH8ST8eNphvr4glcfO6OeXkE9HYJ6
+hr1dyPqb2vU3/Go106o151Rr7+ivr8H32iP+q4CPmAIvmEAPnAJ/OEej28E
c3xD+AR8Ixl8wxX85ALGl2C8KvjMfujXh/4G8J9S2KMOe8aCLx2B/V1g/yvw
q83wty38NQQfu8SLD+LJ+PHsB773DHzP4k/+TNPBD/P/5M90AnyyE/ikKfhn
Wx7/vAC+egH8uQf4qg747WTw2zzw2/ngw4ngw+ngw7c4/izk8+e14NtxPL6t
B35O0J8D/bCHmfDsGQD+rwv77f7kz+wc/NWEv6vQX8zg8WfEk/HjGYv+Jf9/
94P0VcD1O63+7AfJn9cfeaKfCuX1U8PQf7XR/7P/akC/Vod+rT36tVbo72p4
/d1Irh8UKvvBMegHddE/VmD8PIz/jn6zHPrVoX84+tNa9IO7YY8H+tntsL8A
9p9E/yvk+Tsa/fJvXnwQT8aPpxb68Qe8flzZv1/i9e/Kft/qF9fvT0W//wjn
A+945wMncZ5wgHee8J0736Bo3vlDAs4rSnnnG/rc+YaQf75RiPOQAoxXYLwK
d77BXkB/HvQrz1v28eyB/Swc9n+F/UNwnvPp55/+Ij6MHx/Ek/Hj+bfzJeV5
1F/O6+gv53X0l/M6+st5Hf3lvI7+cl4n/Mt5HfvLeR37y3kd+8t5HfvLeR37
y3kd+8t53f93/tnQ6n7tGhURm+v7WV91Ri77ulQ8qeCIvAl3O0XE3JWxAa/s
E3MGp7GGrGNuSbUS0jXLq+sbXsZmT64pfeRUyjYnrd8yqlpCJ5/vKvR1VbBB
qovinqrdZhY/738Jji8jhebcsuKPclb9w1WrbXwmC7HRXjv2uIhqODkVQ/4U
cughHRVOjyX0dHe2dz3rKWH9ChaEBi2IYi6FLdr3bdVUxzk51eRz8lOQ73db
U2QlqqSLPnU3Oh2IJeekXh/ijhZRve/4d18Pl9JBjdLF7SaV01ijIMtdx/Oo
x5wHMzeeKKButa2eRErktMSHXVeMLqW7u7uOyw6IZvM0nFSS0ytp+Oxzbera
FtOGo5W5EXfjmeemraoOW6vpqNW3Hq6m2TRurqLA59hbZmdpd/XzghqatfNI
qU5pCmUlZztOq05gVaV7xp+qrqG9+Ut+31gfS7mcnCohPwD5WE4PLYYeG+hZ
z81LHpj3NOZ15+ykObBzNOzs06WN9lsPRlpuoxo3OlbQUzehtdYXES3iyYMh
D4Oe2Tx/z2Lee5j3OOZdBzttYedc2NkIvyp4fv1CHBSQH4UcephSjy30OCPO
ynmdMW841kVpJ8HOQVhHQ6yjHdbxF9Z9H2/d9yFPhiNPbiBP9JFXZ3j51h95
OAJyZ8iPI2+jkf9DkLdS5LnKTy7PnyHPlfuinLcvoIfth57B0KOPfTcT+24T
9p1ynxpjnzZin9ZjX0/Fvv6Jfa36+VyXRcZFzOZH3KTydncpxH21/tj9VXTw
q/f5r0cKmJP2pn2DnZ6QbcuOWbKsKvr16d/xdPF/jyf++N8WQ3o+nhPNHngc
dFe/JGUTXWrFU/rIydDyXzndh3wC5ONntpxxtW0+/b4Wd8D9XRlb2LaVSe0g
OX3l7KfJsP8b7Nfi/CUj+FsHfzc6HNo+okxMV+31Hr+pSWTfNRpEPUeU0943
S06V2jXxQOOfjaPmNfGZvJ1j2r2Vkon/fo0eLmJKjB8r2JL2mGW0e9hZOraC
UuMvVjhnSKn9tctJ+vtD6eLr4W/XD5PT3Z7N1hlqv2MW28Kr3Z7J2Erpzejw
LVKK4+RkDvkKyLtw60X/YL02YL0W9ujRUpgpIf8BhoddmuUxtfWiRVMzJLT2
q9V486cSOjhwxuOODwuZ9pyHLixKTLc/b2xcn1tOw1wfB6mtjWWL8jM1S7eL
6f3ZhROfjq6ghPj6ea+2xVG3vh0+WOeLqF+ByZvFC2R0JnJnzuROGdRn8xMb
/WwJpXHjWQjGd8X4TUfM1dsulzP75vZvtl0pJu0XCRsCx5aQ1Xdvdu5aNmu5
dfSdU8ZSVh3dIiTQUkpzODmp8OTq43t++3W7mPmKHXupF5UyY4NBvoYHZHSl
YX6V70oxjW0bLWypVcq23Cq8vYWJyZIbT7cxvifGG7+Mbns4T0F1xkb13v0Y
83+w16WmoZQsbtoa+GxR0PN5pOHdIofMRvZVeZRYQOs4+2k77NeD/QYH7lQ3
zxLTDkuVsed7ldF4G+nFAXYi6sLJ2XbIx0Lel8MN1hW4sRi4gXrBlPViFHAD
9rBg2DMQ9nhFe3UeLhexlpOH9MxKlpO5Z7T3J5VMZT1iW4AzF4EzBRUGGaa3
xGznkgnRy0ObeLZWty6Dr6fRh+WaE321JYKuNq1GLmZp7Pb9TYLwiBoKvNp2
kIppLktYsN8vIrKSllz+7OL+JpNeJ5ltvvZSQa0eqHZa6+FB9y2tbddeLaNE
bjzFYPwCjC/k5iUH3rywn5T2D4b9GWaFNxxa5rCfndKKRbsqqXXrcv3s3Tm0
fc75Ry5d8lnF5MzE+KpKirnlOzHBNI3eTQkpjsgqY09UTs5zrS2n4S8muyUs
TKcOc+sOxt7JYzon1L19r1bRxG4LTU8sfEtrxwe3rTuUKbiV8DJ1RE01tV/b
+Gz8/WxaWDfGsWpIKGs4dqj8rmstZRW96tLqdSTt4eRUD3kO5AdzZ5/c/raM
lizUd/lpWE5+cfZ6fk7ZpNreJ3jopGJqM/N38dUh5ZTvoTNYVV5IpqefhVSN
zqaWfqts75yVUfsW1aNFyWKKr3I66NEUDzXHDjZOByUUv33b0eZfZDS0ncvh
ZdaJjEbbOvz4Uk0uLq9eP3ZLJx/PhQ4uvm+Zb9FM3ZPeNVT8SzAz4XIi+bwb
mPZkUAx7UzyrZ/j4WjIOfzZ45Z4o5XjywXgpxg/j9JNSvyv0uzRzvLA2MJZO
3+7i8DisirL1+o4b3CafBvQpffDl2RtqWPpO5+grBcntWo4vbVFGkyGvh1wK
+TPoOQU96dBjh3nHYN5rmDcFdt6HnWWw04kX/0LEPxr5Fol824J8u4N1VI4v
wvh0xCcS8TFDfAqR50Lo2QA97xFnpT3lsEeGfbQe+UzIZ1uslwB+3YRfj7BP
f07i8nw48vw79ruSJ0zEfs9APjTj5cPwv+SPym5jv2XpuTQm6ObKGms57dSc
a/qwvYg0kIctkYeFyEN/7LvfsGcI7BkM3PMAzlgBZ6TYvxt4/p6Q9DDcalNB
9LM2IsiyhDzS9Ef5XskhR25/Ca9jf/XG/vJOOtB+zDMxtf/YsodbcClNOtlf
Y7tURAXYvx7Yv+Owf4O58awVxo/EeEfg2zgevsF+5sWzfwPqzmrgdlfgthlw
2AA4vAw4rMTtLcDticDtbsB5ex7Om6IO7ubVwc2oFyswrwHmTUU9vYv62B31
8YPWx6Wr51XS6lyrADfPaLrX0qldUnYJvQDePvXm8DYQeNsd9cu1D1e/AlG/
xByeC6cAz68Bzwegnqqjnlahnk5G/W0FeQXkKajjfrDTCHamgbdIr3K85RJ4
y27wn3vgP/ngPx3Ao8zAo76CRx1HvZ6Jer0d9VoTfGYu+Iw9+EznxPVDTQ+n
CZ8UZ64cOV/OVp59t2S8XEoDwK9aJ/zJr9aDpz3i8bS54EVh4EUtwIs+gwfO
5fHY6+BdVjzeJQRPGwz5csitwDObXf+TZ37n+Cp5g5dOAi/V4/gq84R8CuQ/
wYdHgg8/Ax92+gsfxni2gDfe4UXRnnPnC1hNZ7W4GzP2s7WmWgNai6poJ+RT
u3LyNZBjPPHHPzS9R8FXhIL5Gbsv+OjK2P43rmuX95WTo9euuUFn0mlkxph7
uh0kbOP9pIUrm+x/2ffbx8DSEvpVGeV017iYjTRP//5rhpy+JK4o/DpJQkfM
BTEO17KY3QTTzn5TZWRzak1h9TMpZcx60vxm9yj2M9Jh7STNJh7e3K9Bt2k/
eVof9KRrJ2i3pmtG6dRyepKZldfye4zAKVW4L8JfzuZ1Csn1c5ZSp+iR7lKr
fDqjZht30UDCWqQHPZ9tKiX3q1W+Jz3KaV+lfOGqXB9ycv7EqlZIaGCMOHrW
Khl1fawxdU+XBBoUKtkzSkNG91dR8SV5ObPNGr5TcC+TbF45POpNZdSby0OB
P/JwHfKwFvv3HvavG/avJ6eHVkHPAuiZpNq128ZTUnIc7es9524+Gb/a5Xzm
uphOsbN9DEaUsUjTAfbqURLq5T0hTzqsqS9bnH4j11nCAvaYXdHTk5DGrAjz
q2aF9O2DU8CeS3JWtH+bc6mRiLTv/grNC8yhgxw+s8XA5+vA51vAVWPg6jDg
qh/wuSvkZpBDDy2DnmvQ08jNSyWYVxfzumvnbJhn+ZZVvDHLdG/CndHr9Ws8
6uIpgpOTjCf/sourX+N49WtkyDCvsrQMavYjc2SXa004YmHQ7OxOKYVBjxx6
ZkFPHuaVQD4T8j7ggRrggdbggUfBJ8Xgk4ngk2Xgn1/BPzuCf06EPSo8e06B
By4AD/QHD/yN+GQhPp0RH9RNNg7xdEc8f2IdleO7YHxnrLsf1t0A634WeRKO
POmDPJmBvLLn5ZUP8nAG8nAh8vDnOK4/CkN/1A39UR/0WfchN4JcuS/mQY8t
9JhjH/149Oc+Uu67SgW37w5i391Ev+nA6zeXoD+9iv5UB/2pEgdmzvsTB+YB
NxQ83KgFzlwAziwFznyP4vDhAvChFfDBh8MToSPwxBp48gg41qqKwzEBcGwz
cG8UcG8TcM+Dw0nhHODkAeAk8Jb4eOv0l/OQQ1xeMWV/8QB5NSjgtZfdfTFb
5D/n5/ILcnK92+uCzuR0es/xKHoEHjUEPArjSTn+FsYPh3w25Hchz4SeBzw+
NgzzzsH4exh/EnbawM4A2Lkw281y+MBc8pamPVvuU0XlwqGJnn1TyCom0+t4
o5R6tPG/pBIrIWvNZV6RDZk01fyC1ip7GbXubb5m9zAJrVsXuN5gaBaZcuOZ
CcbPwPiUCcdXdbMtYZl5n5Yd0lOQ5ZDCo6GRGSQpSp3Z92wp+0B1s8vGKujX
88WjXKa/J4J+HehfCP0msEepfxb0L4f992D/b9hfDf1y6O/wgtNfDHtSYM8I
2GMJ+3tDvw306zOFmoFnAbvSZmH12Y23aHq3E50m51cp5cSXw36mDfvtYP+r
5xqDim5kss3yDmsfxRez1671bmsNFPSRk9NiyMMgHzpwdXWUtID12Hf4lqRt
HJ0+c8H37MQqisyd3dYoIJ0ZbguY+67J/vjms+Ne/iqhXsOzC5N0KmhK9qYW
lk08KObNm5o+N0QkDTfWMrwppoOzSn1Pf5PSGRuVulMaeWRkr3fUJUhGilFW
kwaaSMj+ZoclhqMz6ROnn7Sgn0H/pCffWtt3aOK9tnYD7j9LJ6Obl7w3uhXS
3cM2H3w2RNPiFUv6O9yroQDfcbOXPX5PWZyc2fLl0N8W+muhH/7Sob2cv5fg
72fOfrYR9rvD/r6c/awU9u+C/XsQt53QcxR6hs4PfL08OYliFrqkvLonZbF+
zawONPVnxzg5i4I8CvK/re/f8uEsx5PZZB5P7snxfzYQ/P8J+H8Y1y+wI/e5
fsEf/cJYLs7sIuKsgzhrcPWRtFEfp6A+xnP9Min7ZRP0y90xviPGz8T4cMyr
g3n9MO/qnS+6HUyUMXc2+ovfoDSWN7p7t55N9arc70bc0EOVzDRuxUXvy2mU
+aRnmOr9AuoFv7bBr0fw6zwvDlsRh+X/hNd1O5DGRhVqDss4IWPjShdt/fFD
QldKP/70aa1gqvYL1WYWx7Bz5k6hewvLaBVXX9hp3vmnNdcXsED0BS3RFyjl
obxz1OXQcxF6NKHnKub9vZmb1xnzXufkVAj5Wchjjt6r/Zoip8uLdObG9M1k
k8btf7KrQETLEbebiFsJ4ibn4kbjEbdkxO33pp2BP+orKXD3+EHRn5+T26kw
w733iikY66g8F+qHdVRAT0/oyYaeX9DTGXo8oOcy7O/Ci2cE7A+C/RNhv+uc
s43bZHLWvdu3Dh8UmWzC4paRitMiepmwlEYU57Ork/P3vR98n6an2G/q2rya
ZmAdx2Idx2IdBZ81G8caFrIsk2beDt0lbIbDQUevMxJaw42n0bzxk7DvorHv
4rDvdg+aOeuevIx5zdr3a+KrUtbCecBBg2sSujv7zqPzv8rY3ITWk1fvyGVX
pt15q75PTke58XQT49Uw/hr2+yvoj4f+Tdx60S6sVz4vz4fz1msXcMkcOLwH
eGK78qeTxpA89q0hKuRLQzI76+s/eM/2KnLl5JQO+WHIk6NzL3eLKKdZ3QO9
H/v6MZ+hW1u/GimhccDVa9jvHbDfd5h83hLcrJI0zhle09sTzOZ9OL63ZYsy
8nIf69H5ZzFL3No58+4vBbUofH9bNyyZpnJ1kPnw6ngx8PMw8PMy8NMZ+LwU
+OwCfH4DPLeD/ArksgGeMuP6t2zYwrTkWZOqKexhc5fVmtlkafKvnKwgfwk5
6i+Vo/62Rv3th7pTBNzeCdz2fnRi9vdCBR1pbbE/93AOpQxcNK+ddx6p5XH1
riXqhRT1Qg3zWmDedMw7nZOzgZCnQF6FOrgVcXigrIOom6FZXN3MQN20Gv+w
heubEjo8OvmodZmcfjkfT9JdV0jLxdoXEx9JyeX98roXixJoR7d2aR4RMrJH
/O8g/j8Q/63nUxamLShhzpEhjzoOaKrro4zJamUGTQNPaAWesAo8IRzr+wbr
q431fR22Rn9dXC57V+h/MsNfRF+mDkpYntfUj3N2sj2wsx529uX8YqnwKwl+
TUR92Yt800e+bUG+RSDfFiDfbLFfnmK/lGK/RCKfDXtw+RyCfA4En7kOPvMM
fEYC/nMO8seQz8R+sWjk9osz9ss57K/ekDtBPhV4MgZ4MhF40v/p4qrv22Po
aMigvnfnydmvW7WWQ2dJaQ0nZ4ch/wH5glEW22aL88nl3V1j+aRjNKRs4vPb
baqp5p+ab1vCMwWD1Xzr+6+SsZCNE6ZuKG7qj7j8ZJ7Iz1jkJ3gUq+DxqG6I
vwX4WAriv3/vUFN1Yzl7s2ff5qMNxfQ2c8yTQ2dKaBmXV0wrlcurTcirrljf
i1hfCdY3gMsHqkA+lCIf7JGfBtBjBz3DkM9noCcHerqFTP2VSRU0O2tL2MVl
xRS49dlo1phLvTg5s4A8FHJXDodpN3D4AnB4K3DYBzjcBji87FCNTUOPfFqt
4mxn7SJmQy5cLp8YKCVf4Pk66DkBPY7A/3s8/P/bev2tTmE8+8t44o8fjDxx
Qp6o3ebyZAvyyhFyVcj3DH15wNskRZD6vZORMFbOzEZeuFKwWUpdEbd/ELdg
xM08xdvxfUCJIG5KbIhHk1/RzPfX28mVtBv7uhrrWIV1PMLlCUUiT4TIE+Qh
eSMPY5CH4qMSmzHdK+jO1gcekaaldM3N+mJZRTZFSPxbXe9VJFh9OVI4xbKS
wp8NGSouLCVjrPsA2BkBOzubtc+5ZpAsPHrJYH7rHzVk+sq7xPHnezqDfFPi
j9o0zs54DgdYHeraI+DAVuSzG3ByNfLwLPL/MvxKhV+e2F8X4Nc7+FXO+cUu
w6/b8EsrcOz2k19lQnXR6NW/1sRSePJ0/ajztVTG7V/hcOzfQOzfv6373/JE
yYv6gBeNAy9C30q1qGvNUNccJln0N3NPozCXHbe7TKqhgY80DUwaY5V8j00B
T7sHnjYNfCkdfGkq+NIbjqcxTx5PG82dVzPlvYhFOK82NJOMM1tczHxfZPUc
c6yMsf2fRCaaMhqB8fzzbV2Mf4zxrzFevLCmu2s3EfslEf9Y4l3MntgW/riz
T/qfPd483rsG/obD3/7w15rzi97Dr+nwayOHA2wJcGAocMAZ+LAQcgvIg4Az
k4APp4AP4L3sGOJ5G/HU5vJBIEE+PEU+TF7hlzHjViX92tF91r6IcDre00F3
eEAJHQt+IDnfWswC/aJ7VPUup6RUT5UbkWk0HfX6Buq1Cer1j4H/7gvBceyL
9tgXCuy7C8hPd+RnCbfvhDbYd2nYd8ewr68j/4uQ/5dhjyfsyYI9Hikapqea
iZjpby+fCya5tCPKptz6tJzeXuv4ZmcnOWumGXm0UJFNdTfmT2r+s6m+w9/l
8Pc6/DXk8EeYB/x5AfyxxHrl8/JwG4dvwvfAt0HANwn24234ex3+Hsb6LuLh
fFuDm3aKYDl7FG/9NDfTl0Rta2ds3iklKfKtHvkWiHx7xp3jMVXeOZ73zJLf
AUtLmEHmdY2zE0qZ5qGJgVP8ZLRlQEyr4voS9vPSar3bu32o7bw7F80CK2m7
SZnJzU9FrGNIosbS0HDm3P9kH2OdKppvJzxLdmXMszS20uyGO/uQMWjAuGIF
ff4WOvTc6GIWfaU04qJrAhueU1BkcaqSet3u+v5bZxGL/2eD5yu7SPZwzJoO
yzoq6HVFx1kZ0YWsZFPzqWGP01myfVt2tnklzaB3KwIzyljKU3vP4fnv2Z6J
PbR2Lq6gDz9sg5Ja57HtH7VMdkzJYzPLdk2/46Yg+UXtiuMapWxV5y3D7M7l
sq1lRl0qU8qpR87XxLDEdPaqde7n6VNL2NRVFxO+TFM09X/GVz5Lc9nED7b5
Z/aUss9jYitNdpXTHMc7M4UrYtiPtvtKWdP8Ez43rsnWVpCqyv/98/jvPuoR
3EedE7zhrMnzJJb5kQ1mT8Xs0fqdXXyb2Pq/w1V8hdt494Qnc/rpO/RPhP4J
nB7Khh5/6OnM2U9hsH867E/l7KfJPPuruPiQA+IzC/GRcvGh1YjPNsTnFRd/
KubFfzoXf0pH/Pci/h+59aW4/72+lIb1fYD1deDyh3SRP2f+zB+KRf7UIn+u
6HZvLdpRSJrDRfe1Z3mwAxpxR888qCJ7Lj+pzeU/83MTmfx4N6KM3SyyrPD+
Hk1FW3tPnnNEQYYxHmZzbcSsT+nIu9vvv6CxHiF3nBdW0L2tA+dqfpCwQa2/
yhZtO8N6XJ9vN9GynNIyaze+PSplPvW6x0yqo1iJx/nV4cPkTX3YhxU3rSVM
UdzqzS3TTPa8KKyv7mUZndmT+tJvXgZbcKVXtmO6hOU9G2/8aIYMeRL03z38
0biH78SNp0UYX4DxWW362V+/WkozivfnvokoYe3qTkaxf2TUwtY/c/MVCW0R
2mQ3b8hgGnr2ccmrZdSF84sM4BfBr81cHOgq4lCAOCztNONS0Moy9na4SWaI
SgbZXd/VLaxHBf1Ybnd3dF8JU1dd8juwQyp57Dk61eyUnOT1ZYecgmUsTdM+
feHOWKp44+5mqmjCn2Wjxmw6WM6OuLHmr6Z4k+GjO4b5lyR0q/UEr2Eh5czk
g7HGvUdRzNb37YG5yWJq9m8chMKv+O5DG999zHs+4mOnWYWUlrTta5ePYnZn
xIzVDd4Skr9KGupq0cSvTzw4fkI9lw2hCa45/mKK6OjctfxDObmHzFrQ4ekb
1u6Gz/PKC2L6ydlPbWH/PdgPfykR/i6Bv98VjTOcHpewYZc+Nq/vWUQHkha2
pkA5xS64/bKlSMRezF4uP32sya57p58mnpPSqIwb7VVUZUzNduS4bq/yKHDj
VaecRWJ6XmmUavVNwWzip+/3vBBLWt+urzu3qJTU/vU3RuiJ74ly8D3R3IK0
Fn3ipNQm8eCkjgk5bE25TbrRUAnFfvdquXZxJZlf+5a9uJUPm3KicOHxc6W0
Ks/8amv9SrJ7X6UZHBJH9Ta7lvqpl1ICZyeF8Oz8xflFw+HXfvg1rPOEJq6X
y85OOisIsROTSTfpjGNLZLTuesSCU8+K2BOvnrVPVv3fuVLlnDPBYuqVOvB5
5oMy9tV/T/uO4RLq/WznAkpX+pUuNOJ9L7y4xxQjtyo5jRw1qjjxWjF1/eg4
xetEEVHv5sdjhshJNsliWOomEa3rc3+Yl2kuGY9pkdT3ooQW5oVJ6xvFNHjs
Z5t/9hbSbF8tsUdwGdHqKW4nH0rI8dJ0k5KiUtrA2UlKO1fDzpGcX3QOfg2A
X7IXAwYahL1lGuQXr5omo2KnzzrTm+ps4/Z2tfYbU5lezp20fEk57e5mJxhq
JyJDv5KduS8z2At9k5V2exT01S/M+IFBMXD7qfA977vdjUbt9o+4mEFC86QE
8/xqqnu+U8txQwLNmBd9OaxnPoVk7zsca1dFJ2euCdNp9o6O+Pbr+fxQHr3M
r9KzVVTSvZGDHop6ptOA4BGJNT+yKWrtZr/gzZXU44d68w9+OdSFs4eU9nyB
PV85+0kf9u+C/XLOX+oIf4vg77jRldrZ2s8EMb8nqPbSLqdfC4ftvKYlpR7X
r3eUCl8K1GKGTlQ5ryC1XR/MLYrLqGZow6Kc2NeC+aN8eu2/XkVfKTMuNLaQ
ro2YPX3wrDeC84Nj8vZ1rKEl9nHnsiuzaH6Ry3TbyijBO7fE8/1Uaqk0e7Rs
0uv35JNWsDu2T5QgcW72w/7HainARq3ZCts4GtQs07xFjzDBl8PXJ4YKa2lp
+5n1vZdHAicvj7iB73Yf4Lvd7tx4IX/8fU6/UKn/MfTDHqHSnnzYc4OzX3gB
9tvC/g+cv0Klv3XwtycXH6EyPs0QnwlcPIWxiOdPxLMB8e+A+Jcg/mo7uPXS
xXrtwXr1w/o+xfp+x/oOQz5EIB/6IR8uIX9CkD/3kT9c3J4KlPnZA/m5n8tP
Fob8bPaCy88VXH6yAOTnJeRniavzVWl8Hus6b+nxL6JKaoy3eXO+PI36Y188
g50NsLM55xfj+9Xwl31H2KdnsE9NsU+3Yl/7YV+vxb62Bg6MBA4cBA4MAG7M
AW6MBG4AlwTK72S/AZdWcbjENIBLZsClSRwusSLg0hbgkgPw8BEPZ8YDP8/w
8FOJtxbAWyfgrRKfHwOfM4DPl893SPD52tSfqa96tEAtn0Ktv/RtMU2srBeC
x6gXKagX07l6wXrw6kU0Vy9YI+rFNNSLUNSjrqhHuqhHY1C/6hZx9SsI9SsR
9U5pZzrsbFbJ1Udz+OUIv5T1NJZXT8EfqAXqryfq786zDvnPQmW0rcry8+bu
cbQsrYW8WZ5UyQcEfD4wg+MDLB18wB18QMzxATYWfGAo+IAr+MY/4BtLwDda
g58Ygp90AT9R8hkhj8+AP7DmPP6j5Et8fzeCX13m8UwD8LF24GPjwMfyFs8e
NbKZlFw2XhGU0yE24XHuyR89yykbfG8qj+8dBz9cCH6YD37I1aMggT/vu879
4J/K8UUYL79X2DM6qpSFPdzYGPC2hLku3zvdwFhGIeCxn8FjQ8Fj34P3hoH3
loL33gVPHtDmT56s5NVtebxaycP58dkI3l7L6yvngf/Xg/9/BP83Qh+RzusT
p/L6kX3oR/7W16SjP5qE/ugT+qOZ6LOyeH0W+jUBv18bjf4ui9ffJaN/VOqv
g34x+tANPHtgPyvk2Q9/WRrPX2v01xJef40+iGXz4umCvkkbfZMT+ib078Tv
39GnE79PRz9O/H4cfTfx+27018Tvr9FH01/6aAG/j0ZfzPh9Mfpfxu9/0ecy
fp+Lfpbx+1n0rYzft6I/Zfz+NJqtbOfvXsLyB00dZ77fi/R2rFtz9F1TfY6p
/xwnK2Uy1ZIV6mJfVlOTdOCVUSUpZntZufcpY1tWju6qVRvN9t0aZ7nggoJk
h1wHz7YsZTti32bIE9LYvg23l603auIXAsNmU84WMEvbRIHVvTzmlN5uxzNx
BWX+6Cocl5XBHu+KaN5Xt5Qd2+MT/S29guq25V33XBPDxo3QvFnaQ8SkR3fM
uVJcgbw9ItyKvA1E3ra5Ux/j1ZTnxnsm10/bIGZGu+TNVhwop1jtyNnbZTl0
oebI9YL2pexyS63pbxrL6YarrY5qaBEZ6TlbNJ/WlLdbnWyLb1dQ7ws6z4Zq
ldKbya92rBSlsqtacdVutgp6ceFoULOepXT8/OWPH3VjWeEzI0liUxye37tV
YFxdTELNHXN7hz5nkw9G9bJu4hceU0Ys7d8UH0W7zC7fNkRRy+Y9Xg25pyCr
+pk5l9XEbHLWrY8f6gNofmPPI+v9K4jV6YbrdpewcTefKVqqPWH7PHKGVaeW
k6TOYkZUmZhFhvXJz7R8y8IGbFHtZlWOvLov5OPkCstr3ZvXppOObk7vceES
1mLKouk79spoicannGHbS0jl45Y2M3VKWfqR+5a7omU049yRA3NlInqhWhT7
qF0227T72LaWi+V061b+VS9hGWWvuhuguXomO7giwHOPl4IcXh2PaqFTSuem
+u2b+f4J9VZ3+TX8ViWt3ham5buljEXdm/3YoFM6RRwtmH58UpNfh447HGry
y2vJsEljnZMoTFd3t6hcTtXGVfd8bWTs4vuHQ8Th4dS40LpFzSMZjZvkole1
TM7+uTvQdvzqx6xD5QyjVYnKeur737sKynr6eOOtmOTjBbT8c5T7oHYS9mbZ
0ucVKRI6PH93WkG2hD4Fmx/puTafacu0Ci438R1f64j9U5bISXpj8h43lyQ2
S9Ru2j9vmnjZMpe4V3vENKvlrpfNfjIaPbrTLGudChJU9xWEDy2j7p72rkvK
Y+lZbddxtRsVNHTxtq82HUpZ33+2Pt3Rp5Du2q//FpIlp6yaF+crZ4nZ4OsL
1pjV5dGBXp9KfBulVNX1tMuS4zJWXry3i01RJum4P9ytNkQCvyKED8GLMsCL
rs6vMw/7LKEc3/KOirYFTK3X+CWN6hJyd1myacFMBQXOv17irR3Niu6kjJ/t
WkZPBlcbDA9VUE+LDe3r8x+Q/oBC3deXmvqd+/YOz4vFtLd73aHdUemk0Wpz
hzMT5PS8+eUP/YeU0fLETqN+t88kk443vYe2r6AFZzbb9x+fxz5GLFj5tlJE
u4Slr9YdlZFw4Kzvlr4l7PTK3XknhorJ+IW54dXOEjqj9bmm1lPM3kxavtyi
jYhyWl2qaxtSRu3+9StP2Ap8tQ589XtypKJ9nwqSDxkl/mSTTfIiv+wQm6b9
Fn5k3HfnJj47IO2wv14BqbhLR7TdXkDmt7fvbt9JRPdG6A6PHVBC7fcvLja1
ltKlz0XJaz4W08ODw55ZdC8m/yHN5g+4Kydh5prhsnbJLNey1XLV0zI6FDXZ
uLezlFSSS+8vWJjBYlV/3nzXuZxmfw8uHxEkolNmlcu3f89j1ikaL1eGl5Pd
i9tBj0eUYH8lCPl9h151Q4RFTTZtKZHsmapTTfnPjG+NWphEBcnnOl1YWkYr
DSZI21SVU3Hzh4HtembS2BpfudmR66xuV6u1ItVyuuNY3sPTWEofr+97N9zn
EZsfyR7LlyhornXKoEkdRDTNxK2m4fZrVqnXxq3VlCoqje+b8qxVEex5JVT2
j77oHy2vvfM7MdKVrGUdL78MrSWtxTLNQaGRNOdYtf7C9mH0u80AGxfrWnqi
via0Q3UcXRv0fptjQzTV3Au7dPJiDVkfeaLqZpJKC/y9H+zUS6DL7k9V3n6X
UctC50MHt0nJBvJLkLeCvP+x8fr9KJEm+ITsbnuqgjYE7/E+MVpEg3/3H22+
PpF29X+onhRSSdU5SwNMNyrtf/xfPA0Qz2V1g1Rq3qexVf8cDG2waupbn7tl
FD6Lo2f7mg3653kGu1oUNbD2TTX9ntK+5sCrRDp3+NUDw8GprM6n48UrqdVU
2ubizruPUkmBeC5APGcjnjaIfwMv/mO/GLZuMyqHmhjg4zlpYpIudPuxYoqM
rPbanRS8zafTCv+xI+5LSVyqt37/WjE9t+qXf3BQMZ1OqlOVGjf1Pws3zi5p
qgfNwVc1keeVyPMDpkUbPZvwzXuVZJXzUxG1SzqjPu1IPnVaf/bc/HgxC+v/
S7SHyehRivS1r2MWqfLycxby8zXyOQ/57IR8Pov8v4/8f4T8H4j94oX9oo79
srysY9voaAnVllw4Nym/Kb+Flp1fNPWFXF+WI7gP/MkE/rwM0Z16xkrO7N47
r97jk86yghxen6sX06vVU48d3q5ghyvMy/SnZpFuE6HZoltEEcCHs8CHXsCH
xcCTz8CTHcCTZ8CflcAfU+BPFfDKkYdX98lc4iSUUc6BWy2ClqTS74sXlzz/
JkFexQn4dUHDNe6apqKI7dL3HDvWWcy2ed6KytgtoWnJ2esWCxSs16JvQz8/
8GCTPG5XJU4XUTXwWQF81gI+5/Dw3BF4PpyH/+7A/5GoF/1RL16gXijrywpe
fcmKe3Lbram+OSzq6hTv+YgOb705xmO5HDwnQsA/V4+xy50b/juD7Z6a+DL8
m4QtNdsXOOm3lFq3ji3uMVfGZr4xVun+KJWZOejt9loqpQmop1aop+qopzWo
v9dQfxtQfyNRr71Rr1+iXivrewyvviv5wC0eH3ADf1C3+5M/HKjvoLpziphe
JOdsCa55zl4ZvaMba5S87plgO3jdE/C6PsFvUz6fececZ/a9ueGnmJkt2pcZ
/klO3jNkr8Nr81lywICpHm6lrNB49MN2qXIK2r7bR7WJTw8K2/8lb20OqzQc
+6WosKneg0e9AY96CR4VCd5lCd61F7xrCHjaGPA0a/A0T/C6avC6FuB1M274
1a4oKKTThq1MGk66ssadMj3XC1UUCn7oy+OHL8EnHcEnC8An+4F/MvBPF/DP
e+Cr3cFX7cFX34PfXgS/vQB+qwU+3Bd8uBv4MM57/+tHDqEfqQTfngC+LQbf
zgA/f8Lj5y14fP4A+Hz5X/h/Ja9f2It+oT/6i3z0F1XoL5TraMFbx7kcX2WP
wFc3gK+24OW/BfL/Ccf3WCj43kzwvdMcP2SF4Ida4IdTgQ/9gA9TgA/gV6wB
/EoH/OoBx8eYHfhYLvhYLO7NuvDuP8zg9NOFhZz+idCvspm7l1uG+wmuuJ/w
G++N7MV3xOPwHfFHyI9DPgLycNSpU6hT8ahTuzieQ4vBc+aD5+hy9ZrtRr2u
QL3ez3uX5hTeS5kPuRfkJyG/jrr8CXVZhrq8kOMb7AP4hg34RhTq+2XU95ZT
ufqeffRf3sJU23K8JQC8xYsbTzcwvhF8YD83LzVg3mLMe5H3vo3SzkmQe0N+
DPIJ4C07EQcF4vB1wL98jGrAx4rBxyx4/Gc9+M/4J+9NN4UG0jYL66UW6xUU
abXo+tHGMtIL4ORbII+G/ATH90gB/SLo3/OX93luQ34X8jOQO/F43QLE2Rfx
+YD4lCM+PcEPVRDnIMQ5E3G+gDirY11uc+PZrzZ/rks41reKxyfX8fJH+c5P
EOTuPL+swHurEIcSxGEF8nM71qUS63IZ+TwH+bwU+fwV+8KRt19U/Dj5bsgn
Qf4YfdMNXt80Cft0J3BgOvapF/qvU9jv+djvt4EDyZAXQw79zNGc028I/Y7A
n6/AHz3gzwPgVS3wai7wagpwLxS4twW49w9Xd9ghXt2ZhnoUA/lXyGO4cx5q
bc6d8+jinMcCdfYM6qw56izqspBflx24cwamjXMGNZwzmHJ66Dz0mEKPD1ev
KQX1ugD1+hmH82QGnK8Azrfj8JymAc9NgOfreN99/8R335shd4P8K+TK79YT
8d16Ab5bd4R8LOTZkO8HP0nj8RP3BwULF2pIyPetXoHXxCfM6JbhuyVF5ZQJ
/mYM/nYE/O1W5sE+STNlVFujmHX1SRjZzh3y7uRLGSWDv+0Af1sO/qaKc4DH
vPfto7nzDWaH8w2G840ETg/xeeCKfjf27WomIomiynJtaDH7ZHwkwbCpXwjq
vWZd2QJxE681mWqiU8SOyRtvNn6Q/PdewT3+OwCQZ0NuCLmSh2fweHivp11N
3N1k9FIkqZ+4JJNO6w/z0x79n34WwHsPAe8Osbd/eUdoHe9dBbzPw/bw3hey
xe9HPxO434+W4/ejo76JnyYcK6N3UeqTOx0qY5+fdrR9O1VCYVz/Qi7oXzTQ
vyjfc1gG/Z2hfy3khyDvCPlK9FNyXj91gjsPoUSch2TgPGQpN541YvyvV9z4
J1y9Zud49Ro4xg7wcOwT5EchH6Os++jLDsIvQ/gVxp2rsBM4V/l+hztXUfah
oehDg9CH9swY1nvVvDI23Gfszcpf5fT+aPxkN0UG+twMoQHenbiDdyd0+v8T
n55YQbOjpq55aXiMfep8Te/pRxEZ4nuNz7jfvh7321tz89IbzPsA86bju+xf
+C67Pb7LTsLvtj14v9tqh+x2aIguZapqfgt/X6mgmlEi69ml6TQTv/8+xe+/
Z/D7L/pEoRvvXaANOH9YjvOHJTh/4HDv8X/vmbfEecWoq/+etzDleYsGzltm
cnpoLfTMgp7EHW4zp3iK6I7au5vhIjktTTrtPMEzkxp57wcKsI4v9gU7qQ//
v3uVtV1F3+XUXb7M1/FWCQ3HucQpnEuIcC5hcSB3vu3/vfP81WxDdZtyehBk
ZLXIV0QTeOcbEpxvfO4y0jFzUzJFr7SxPnJYRmtOHHxQc0ZKToFb3h8f/paN
HxI7ct3YGjpk7B5zcFQq9eu0Y1iLd4lsYPXL+vTEGvrpY1Y18GA8WZQP3u7S
PorN7+/d8oJdLfV2eqno0jaK+nDjyQzjv2H8YU4/TYB+J+jfDD7jxeMJ75OP
bFxpEUPTHmz+UaBRRb5aRg1f1YvoZN7IMS6xkRTuZPTPvu4KqteYdERHpSm+
kIdC3gh5OfRMhp7H0OPMe4dQyUM8YedY2HkEds6CXybwS9WX86s97/ytE/IB
53UC/nmdI/JkKfJkE/Kk5fU/80obeiYjztaIcz/EeSbWxRT2/EKc6/D9shj3
zA1wz9wb6zuWF//z4GNKnnkCcRgOHOgDHMgDDijfMTuEvB2NvG3O8Su2g8ev
9Lpy+RaBfFuHfJuCvLVE3voib8d9FLXXP59DvQvV9Lt9lpHt2sx8hw8iisC+
yMa+MMa++Ml7j3EC5s3CeexanMeW4jxWH/gTCPx5Dvx5hfPnXcBJVZw/47yL
NgNXewBXledO/HeQOgOXvjXjcOkXcOkBvlNwwHcKOfhOIRr4PAfztsC861Hv
HFB3dFF3tkA+B/IekB/FOfYC8OFF4MMJqC+HUV8SUV+U5/bRqFNZqFNrUKeK
UKfUUNfOo669wvg8jO+Dun8Hdf8C6j7eZaLNsNMQdtpDbgd5d8iV7xC+4PEQ
pfwm5D0gX4l7g2Nwb/Ab7g0q69HRWK4efUQ9wn0ScuPdJ0FdE0xAXbuOuqZ8
5/Alj58o+cxhyHtC7gq+Fwy+txR8bw945izeu0m7IPeAvAhyP/w+FQX+Pxv8
Xw18eB74sCX48Akez/kAnnMCv3+VoL/QQX+xGPxQBn7YCH7I/Q4VJVC+v7Qa
797cBO+tBu81Bu9VvpN5h/f+kpKf+0L+A/JA8M8O4J8nwT9n4vfHx+hrNqOv
eYy+QHmOV4O+4DV+71vM+70Pvw/+f+fAceDJu8CTl4EnPwSvXsXTswG/k/74
wP1OmorfST3Qv7xD/1KE/mUz7/dWZR/E8Yf7Aj/weQKfH4j+SNlnDUJ/tBT9
lBb0tIKeCPRr7/C7vD76NfRxLHfQn33cVPSDaby+D/fMGf+eOe5RMP49CtzD
EVrz3oM659T3bQvbVOq95YFd6T4J6xvycOIsSznNP9TlaNfmRWSZ75tRs7eU
Pfz4THFjmvy/d5+kvPdbCnBfqAvuC43HfSFu3hfCA7x3n2JsWiwyHp9DqkFR
sxOyJOxTSGq25zwp3cP7M4N47z4p72Udxr2sJbiX5Y33bZbw3mvi8DxK6Md7
9wnv4RB//EXcc3PBPbfnuOemx3vHSRPv+YzBfTzlPeGNyvt4uMcYjnuMn3HP
diTqYD/UwQWog/pBkZ61EzNIcDHD6N0cKSVpB/TVyJbScdzXDYUeNdyHlIJX
f+Px6m7QMwx6kqEnBXz1OvjqGvDVibjnXAL7HWB/V/jrC3914O8A3K/+jPvV
vXC/+iHiOQvxXIR4zsO9cQPcA1yGPg7j2QzeeOW7Q52w7oex7q9xfz4Q9+fV
cX9eivv2VrhfNwz366yRnyLk52/kpxq+R7DH9wid8D1CIvLwd+CfecjlzwuB
8n2h+chba+wLc+wLH+yLK9hHPbCP+mMf4XsKgfJ9ISfsu3huXZg71mUF1uWY
7lMHu3titszvW+YBryY8WnLQOaw6jcxSM3cM21NKGpMDxWdeV5Cb9rwayxYZ
yvGkHG+P8echt4F8J+RjoKcZ9HhBzznMqxy/HePTYOdV2LkSdv7kvYepfDd7
7sSxutqdi6nDVUn3eXUKajV5u0DyPpUiPWynnYktZDppReVm7Sup/Plv7bsH
06kQ/PYL+O03vP9TCbkC8rbgvdr4vX4rfq9Pw+/1lzFvgws3by/MK4OeGuhp
AT1hsEcP9ohhD8cfcoRu+P20GL+fcr+rRgoJvOIGeIXyXoRoPif3ghy/IwsH
43fkdPyOzOnJ/e+9TWPwTM2Y+JSlrRR0aLDdWhPLSMpqvn6awKRpX3K/O9ML
/O789S33u7NMsP/7kRgRhXicbK1zSk5dz/Ufuj46S/keDinfw9mNPp2rpwkC
5d8/Goz+V3mf7Sbs0YE9sFNwGfLRkKtz/grKB3J+aahxfinl6oiPO+LwhbOT
PYCdg2Cn8nv5cti5FXaaQZ4N+cE/7I8QBGNd3v6xLimCR8D5NcD5cxyPYnHg
UR/Bo+JwD/n9VY43TgZvDHk2bcuvXRVswSiLVSNCT7Pnm0pbha8S0yyuXyNl
vzYA/dpyfDehvJd+BecSnTi+ypR8tR58Neyk4OqDbhUsqeRus8N+Eez2/KdP
aKeYXM5qDrN8VclOnYnZvN72HWm0PuM/8m4hOcH+dNj/CfYvH/l+QmvdCtbN
w2qakc17dupkfI5oXBPf4vgY0+PxsaeQt4X8OOQK3E+2AH5aAT/XQv+He5z+
Y9C/mpOTCuY9AbnyPZkH+F1sKn4XU943WIX7Bmm4b5CIOIwo5uJwGXG4xMWB
3iAOrREH5fs2VvgdzRu/o/XDuthgXXphXS5Dzw1ePJV6fuzi9NxX/h4H+SXe
d8Qr4a/WX/wNhL+T4a/yXaBbkE9QvguE++HJvO/FtHCfYQfuMzjgPkPa5DCv
ue9L2aqkFR16DRaxyncnHheMVd6LSBH6IM83Is8fcPfK2GPcK/vdk7tX5nt9
0e/LD0Wso3PUyZwNpcxBrnM3t2k/PeLk1B7y7ZBHcOtFI7BemViv19x60Ujk
7c0/14vFI84tEeffVf/iM9sJfI4APjtx+Mx+AZ8NgM8nca/GFfjWEfdq8oEb
McCN5sANjk96CO8Al36s4XBJju/xq3k4j/MTUp6f6EAOnCElzjgCZ3pCLoN8
G+T38N6CG/r9BPT7OAegnZBnQn4RuH0SfhnBLylwOxR+acEv5T2677hHV4J7
dDqoC7ctubpQgrpgwtVBtgFxViDOGxDnFqi/Woizasq/+tkL6K+BftQd1gt1
pwD6Q5APTsiHdORDLPLBC/v3KvIB9VGwEfh/Cfi/GN9LvkP+30P+c3geLgjg
vQ+MOiW05L27cgvnLeGIcyTi7AH5Nd57EX1QR0S894Vwjs0+Qb4B8nou/mzg
UC4+uX/Gn31G/PMRn6X4TmcYvtPRxXc67rjn+Rr7UQX3PD2x73Sx73Zg353H
/lXw7oXex/7txBuvPPfm98XcvggXKt+5XYt4KvugVN73+1ycU4WxvHdIvJDP
pxHP94jnbchfQP6G996I8h2AG3gHoDnwiv/eiCryhP+uyF2sowdvf1Xw3v24
C/0tcM6jzXv3Q8lzhvHe/agCDij5ZHvgAPgn1UHeAP6pfK9jH+rCHdQF5bsT
71BH/CB/DdzeCdyuAm5H8d7NUL7j8QryF5BPUb7DhvcNuuF9A228b/AA96OS
eOcVW7jzDfadd75Rje9oQvAdzQ18R6N83+Mr3lsIwHsLFZB/hPwx5JG8d0iU
9S4e8gs8v/S4ukbbeff0orj40DZefJTxXM17F0UZ/zrIb0Cu/N2qEusejHVH
Xgn573Igf+gS710O5KeA/y7HOnwXrPz+ri/2NYdvqQLluxmh2C/t4O8uXh1P
gr8b4K/ijzoeJVC+p2GO/Yh9xNx572lIsC4/eOtVDLmKlJMHQT6L60/ZYF5/
6om86oK86oS8iv9kdEb4vYTJXl9fSabu9M3xZaeSkEq6ax1t0n1xITvn1bb9
qPMvqHLI4t5x56tIK8vHbsSGMvZhS3ef8y0C2fgTNpU/4hU09k2Dk6O8jJ07
dW3kz17xbPr6t+VjRRXUt7+xxtG0UnbtbkLMc3kms1nTX9C/VwU1rFkZPaoh
n3mbqcdNf1DMNNzy4pY8aOojT5hUNnNOYdpq9kcuDxczE4edm0dsLqc9PcbI
kieHCvSfrlmcEiFhOx2kCfOWlpMNN560ML4/xv/i9NMdnv7+nD10GvYsgD3E
2U/HYP8M2A9/ScTzN5qLGw2O4OL2HXHrc7iya93IMqZptne8tw0j//4JZ/Of
KMhmXv86F98iNmdKqH5FpziK9+xrfia1ko6fMb/de42YWZ7bU/HY0Zt+Jh5p
NN5SQdfLMo7sE0rYcB31j0duv2BrXw12HDmknOZd9Z+qv0bCsjtXjxQ4pTLV
Ce79l42Rk5roh+GJIU3rYrPIMq5DEfvRq4XZwVcyMr9koJ6yOZOFZ9oVWxtL
WJcWXQ1nPZKRNaeHknl6MC/14s0LO4l4dhpz/pIe/H30p7/E91dt2fv1uaFN
/cwh15Zd0lIotGOg+bxjFSR6uLfCoik+6Y/LxGrL0ki3aERPj18K+nFo17Y7
dyTM7rnerjbD4ihJvbc8P7upjywd1DawQcaiHjgM96p7TOniqq/Lh8joxsr5
fbbky5mqJG7MIFEEq3Y43eD1TULBw9Ne9jIqZDNSLjusPSVmOu5mQzfoS+k6
N57yxdz4Gow34/RTFfRnQD/soaWw5x3sUeX8os/wK+xPv4jvV32HAmFX9TI2
IXyGzZtuuWS6Sf7Bf0w5fRxnu60is4Dpzg3qGTwtlwTdXye+6aGgIfbqRn22
S1jrdPuPZxOyaFX4kTGztGVUac8eOgfI2Z4TopZnR6eS8PaKG5NrxFR/ob5H
QBsFU5UduNjrYRjdPz3EMmue6L93VjvY//mu6Sm81zqF927tRfzdh/G8d1zx
bipVbv7zfdE6bl7qgXkfYN4Kzk46ADsjYOdgzi9qxfPrCxcfmoT4DPwzPsSP
T/KYoOBh74tYgMcV7+lN/byrZXDi8O8yGtf5Y6VBZg6bvapMbWLvEjrV+4nz
3OkVZJhwJMlotoh9Mb2qZ+hfSgEjmpWsnNzUL//y8XAsk7K1jrsj54iK6V5A
wK2c42WkH2Qftcqygp091Hdv75xcuhDa/uCuh8Uk7NjRKulZJfumY7bynHMS
1TYsn726opCaNa5J6jpRwW79crs1UOsx+9ypzdE7FiJqxcmpDeQ1kEMPqev+
qUeXm5cuYd6LmDeQs5M2wk4vpZ2cX/QZfgXBryQuPqSMz80/40P8+AwS5Drv
ts5mEvlh29ozTXXa2N16XIGULN1Whb2/msZWDl0z0vVsUx/ZELdx5MVyWrrY
6D2JC5h1P9UE03opGZrXzjjuJSK7Z0J36fdSti1P+HrCFhntHb3zzoIjxbTb
X/2yeicJe6q5fErAOyl9Oz87ttQ0l3r18pueu1rGVrm+256wQkJPXp8tuxme
SX57SlIig6Rs8MzVbjM3S0g7ZvmqJ8tzqAjv2i1AHU9FHX/MjSdLjO+A8Uac
floD/QHQv5Ozh0Jgzy/Ys/nwOa12mmUUN/t8XzdHGSUe6XWga99ictYc0eG9
RiH5XtrZMaq5jMY3ZpzdfURE69LUzFz2Z9P2uK/NN9yU0JEp/1iVRf0XN+LH
zeJ86fYL2gks8JzlJoPFcortHdA/ubWSt/sKlX+n/hT+Dnv3IWMMtiZGMdGA
jF0aTTgUVXhKPqdl+X/vOyn/Pnsm/j67VHRjaOuFKWzxgD2amREVdMT85ZZS
+7L/vt9R/r37H/j772OXP6G6m+lsXp+9I5x2VpLAPWnXGaOC/94FKsTfkQ/C
35Ff9GrwAu/0LBanXf9i2oYqWtAq1e5KUgadiR/z9t7WHLah548di6VVtPfM
Bt3u8e/oTtD4UZ+y0tm0Hx3KnrSuoWvHDK7M0Ywnx9x/Do3rECWIHRs34vjB
Wuptmmk/402cMg7/vbPxBPcu7nN6aCr0uEKPMzcvKec9iHlhJ8XCzsWw87nA
/1jbW+l0ZdOv2SaHK+m8x7nu0z/kU52D8X3RihR6/EZaUPG2glwnlAsktmU0
kFsvCsB6xf+5XoJ/sF5n/lwv+st6Cfjr1Qv6g3j5oMPTEwM9+7i4CZVx64e4
DcU6WmMdx2Md03n5cAL50A15yPdLh5dvynnNkM+rePlsg/2+Hft9P/b7PODD
AuBDZ+BDX+CMjIcz0M/4+hOBY8E8nB8NHLPm4ZgB8LAeePgYeBgE/NzKw3k9
4O1V4O1Z4K028P8W5Ochf4J64cDXg/rSwKsvCahTQTwchv2Mb38d6uA01EET
Xh005NVBK9TT9qinK/7kCXQI9fcV6m8D6rUe6rU36vU11PcG3rvoeN+eJvF4
wlXwhzE8noB31FkRT4+Sn4zn8RPwBHYcdr6GnZbgPxo8nvAZPGraX3gUPz7g
n/T9f/NPygFP0wFP+wm+twJ87y34njn4YTn4YSr4oSv4ZIP4T/55ZZbdsX5n
pfSofFm3o+45bFKnQyHzjklo5K2gD71uFdD9+z1afUoXM1Gbe6csfkroU+4l
u+8L44RWzkkz/cPlLGZmeLtuTf1dLHjsRPBYLfDYq5x+5sXTD3tYNM8eJX/u
8fBP/qzk2xt5fFsFvP034vaSx9v5cUMfRF14fdAC9AU2vL7gJPoLE/QXP9Bf
3EA/Mgz9yGr0I8r+JQf9y+/xXP+yZrZm5YuuZaQhPvA8Z2YR22dn8WFYmIyG
dpsyceKYTOoyMVZ1yFAJu6/p3/fgwyZ8Srtx4ch2JhwSOyLX5byMWZQcGH/z
mYzGoG8K5fVN6zn9rDn074X++ejL3sEelT/7Kab1v/sptuh/91OsD6+fQtwY
P25x6EM7RfzZv2ujb1XZ+j/7dLqEPnca+lxlX3wFffF89MXf0Ef7oI9WRx89
EX23Hvrufui7d3N9utAQffp29OmL0Ncr+/QBGP8b5wC3eH36AJwbXODZgz6d
OfHOGeAvi+b16YgP0+fF5x7ON27wzjfkW8a0E8wu+399fXk81c0bNkr7QmnT
8nha0V7S5ummtO+LqKR6tO+LIqUoLdosFe1JGyJJtKlBkSIhO4dzOOdw7O2l
7fV7vtfX+zHP+7znz+sznznznbnnnuue+5oZpvrU1W6qZwA7qnnwiEpSSgWD
51mcLpUx11WqsJ5bYtnxxuU6jl9UlFK5a9iC31J25PY95YMPb5nzz2Gb84ep
yO5LjwIVy2XNzI9sSHksYd4ZTdb1Di+hPu2ObLHemczOVZ1vuElRyIL3Gd4p
3llCnbn7Lv7A+b6CsY2mueZkU8+gZSNObCpg9g0npFWFllBl44a3fzlIyTwy
7/VleTrbrn59xbs+KjK+9uXAxRgZ/eoUfnl215dMo+TawmH5Kup/ukR9xjoZ
TdnwvSzr411WdMR3V+cnpWS7uFfsT10prUmcoWFi4kXPOz/Xm3u9jMocYmfr
xuaRyl3hdu/pPWoQvWmznX05Kb6pTa05JWeph0YZNHULZnczVhoW1PKdbwE2
A9L85GxO/LaMwN6JbEerqEjj9cVk1uvA99G9Ctml5ZKwKJscNqD8dPWjVCVp
7nzf2kMzi53etHuJum4Rq060SEu9o6Q10Gv9xH5mCvYzdzYa6JAYU0SGY/a1
8GZv2WLfbRvyehfT/rQlb4OeyKnMwGOeR3oUq3ZzfHhUrYQeXFT7syy2iFRb
dQ7u2WJPYZHdb7/QV9FLh2FhGddlZJDnkNHy8kOaUmZvMNq5lJb1SNnjfzOf
RgSWb6rq95yijK4uHetXRi6Hb37al1LMst2DJaXJt9i346OdfacpqJ9xE72u
uUrWucxrvdujFPboe260haecRjeIOvN4vIwdj5+bGtdFxioaPlF+eS2nQOgA
M7h7KtQKOl3V3l9MrXqeSZh05QhrcXf+4oowBfWo6p058ZqCtp2KWq9nG0Wz
Pg5zPmlcTG1WWDvvvl1IR42sL+wof0U7F0SFfe+gosUDLBptvFlAn4LP7DSc
mExbZfcb9T1TSjPHNvVdEFlI73dIzA8uyKBhFxPy56ypHZenBT6XfuWT6wqb
1iwok54GNp/cfomKXmw68FhtqIwe+58y0JsmJe8ID7saFwUtbfpotHpBLn2v
cJ+lllFAd8Y//mu0hqjv8owUee8h8F4BPxfpg/jiF+ILMe7IRRxxD3GEGuKL
ouzez8JCK6niaCt7/47ifXEPIj3z4nTer6ui2fYHzG6PjBfPU0eGxZ9c1epR
FSnLt0re3okCvrsOl9fD75mI9UyrV88DE/F/S+v9b4SJGO+Eop3qqIePm0Sd
Dx+vzcN9C57cfQti+UXg/2/B/zeHpr9pqXpN7h3cJ89xUtHxcIltfKaMdman
KW0XptLgo7pLvCaV0Zyr1uO0P+USyxzzIPFiOn2Pm5vYZnI5OYZ/U2sZlkZN
O2ukpq7OpC+H9LZmJpfTQzfdOaM7J1Ge7QFnsxtvyfJJ+LMWigqa0frsdU96
QeOzDGetG5nJ/NuEf26vVkHPp607fiMqgdLlxkMXfE1nAcGbs4/tL6ddfw5a
pKn+lspvPFZVZ6eyB28Gd+4VUkaF1XOcPtVkU/5GvzbRRUls713LQ3/rlFJe
v/UhGblS+nDns3Zkp3imlZmZfPJJMcU5x1wu8pHTO4OhpRuSYtjEdz9yShsq
6J7tlyNHAmvtc3v/pYNWSOnkB9tdX6yUdEDnfOahHwUUJ7tUPXtrEW3QSjrz
v3vQ1poWnjWOzCbZfEvd6vNytiPZL+Ccn4IeFKhVDinJoMy5N0cER8mYrvvk
PgdclOS/fHLAs615ZL8lX2vcegnrdivo1YKZylpe/sCs3zkZHdN7O8N7bCYz
ypu80cxQQa0shipu/ZLTypwHr0IWp7KNj5vOjDYtItfIZZpu/+N58YP6+dfy
Tb8vOp1dW+dSpo25d3pKAVmPH/SirHEZDfj8fPT5rykUadzulIGBhFpLptuH
/l3MFFYGmuoaEtozxcCul4WU8q9a3vROL2L5s853MFwlpUKdXjbXGxTRkTib
QL32UvbU/brRsO9SSmpxNXl2hoICApo0GJOXzc4VLN7pbCqli01vnF1gVUIh
6u3sI0YqWWLOkQdPn7ylOZMMTronyinb8ekur4xCJsn07xZzNZMGFJacmaFR
TIU+By3+aFbADl1OLZMkZVHMmCb5ue1UlB2l+1IWUcTiH7gunTLgFd1am7xv
hWUJOepFlF6PkbJRX9zaWrsl04kuGl0ffVPR17NrLCqjpcy6+uW6Tj7RtK7X
qN4Hi0vF+3lYMef3Atf1j29vUcQsNL0WnY+RsO6Dv05fGi4n13C7PH+fUjZe
3SruboPzbOjPax9DX8jq8O4a9fHSNrNl+e+KWfkPn7bNXqSxexY6K0z3F5Ic
+E/gEcBLBJwqgYcDrwQuAR4GHP9LGmiPUf32UF+1+vj+qQbZ714pWHBXd6dG
21+xKbdKtzJHJT3xGHM0K7WAlciSFDXH05hxtxCF1ysVFQs4JQHvD9xDqIc2
oJ6xqKddfLiNdkAZ9co1aPzqbgBtDhz1zVNDSsXaMy8q35fRhNxhTj3GRFHq
mHOnVnfIpwzB/qkj7D8U9r9DsH/Shf2/hv2XYv7uxvyVYP7Cf0aeg9/7Br+X
KPgfVgP/sxX+p73gf9gn+J8Q+J9eKvvd01a9ZREDWv0KLqmgnXNGPMqKE3Vo
T01Ev10Gv416SKwnHPWIftsD/twS/vyD4JcoHH6pHH5JJXwXid8lxXfldTGI
jzgVTz29pz6fFV1MYzKUP3YekVMWcEPgI4BLUY8z6slGPQb4rnB81158VzP0
w2e0n6H9juh/0f/Eof/FceyJcczEONrBHu7AHhbCHkZ6CnZ1DvbzB+xHtE99
zj4PAF8Pex4CvAL2L4P934X9K4Cr/aw/j8owv1TcvPsA/BVXz0HM3x7438H1
28Mkvy3rzetR4FEe4FFl4FEP4DeGw2/owW8MAB/TBR97CD42FvzzAvjnQPDP
coHfMgXHbxn0+eo4T90JOnzkQ4nPh7o1mZpWFfOGua2p3LmjlYIpO65eoh2l
pF9nq/Z6Lg2j9nsMQ94tULLK0JKDJ2KVpCXwXvLieK+50E46xbVzkPBdpM19
l3g+JR/nU2xwPqV8/UfLdVdTWZp5wZT4dwo2arBm61FWCvL3O9Fnpn4s+Xe3
dznWtZi5atfoPtytoLFCP5Mb18/ifkUAt59QMWG17vk9hSRZfMbrelUB6zc0
qyQpQE7lsBMlZw+DNz6Oy6rlrQZm2jcbGL1hw9x/FsvP1Pl5OqNW35+L55dD
uPPFeN+cYrjzRIZ4z30v3nPvg/fc+wB3Ba4PXDwHdA71dEM9P4V1nJ3AOp6B
dZzw3rom3luvwHvresBbAK8CPhrvtovlK4EvAv57Q/16+i4Y6GeSV0b5QbYP
7lx9QDq9FvpoSvNpCfiDDvhDNPhDC4E/UBH4gwv4w1KcXy7lzi/nCbyCcsEr
lOAVIt8QcTlw+CXWCX4pEX7ptcC72GrwrhXgXUuFdrLWXDvhx1hf+LEM+LFR
uTPH7dlfxg7L3PdWyvypYUJTPx3zWn442G7AvclpzEvx57bkZuXU69hM0wbD
M0k+/Jj1td+1/W9mY+95s5y0F/5KcU1OplG+XR0fbchgZq0dbj6aVkEnJnUe
MnfkS9IfcaXtTBMf9udE3+hElypyPN/KX3dwHI0Z+Q9Oehz+X+c6h3H3honn
c+/t7OqxKCyTti62jk5or6C2ya4vwt/X+qXcU9ouNun09+EdLjdby2nhqpfL
dx2sjXOP1mwY+SCVwkxvzMscVEQ6ljO6P0v/v/cwiHGH6j/inan14pS7dXFN
IdZHlK+La+agvBiniPVX1av/rokYf4XXi2uCTPh4rRR5kNvIg5xGHuQ28iYn
kTdxQ95kOvIs8Vw+aDfyMuuQl7FDXsYC52dtcX7WCudn8/BO3x7uvVeTUcL4
iuO4E+Mo5pWmIB90Gvkgbbwb2BzvBibg3UAn5KfWoj270J5xeI9Pi3u3dxry
XC/wXVb4rr7ce8fi+8hNMe73Me5aGPcI2I897Kcl7Ocg8om3kE8k5BPXIv/4
EvnHWOQfI3GOdTd3bxuvXxV19dJ3I768e66k8S75K3PKiki+5nqntjlplIj3
iRYjfxqL/OkN5FtHI3/aGPlTU8zfkUXC/P38Spi/iHfYEC7eWYTzp1+486dS
+CUJ/I8U/scAfns/588HAHcC3h14KtaFIPjzzvDns5xLt8+PLaVOHna6v5Pe
0umnioKSirw6/hPKrTsNkJeP+Snk5d8jLy/65yL453bwz6VcHCHGC3rW6lM0
9Qoj7a1tUgwzs1nHFcqSUxMqaA78vwbWhXL4f23grYBXAx+A9aUpt45sBP4D
64gK+Gusa8nc+tgd+0iu2EeaiX2kHlXdHCe9KabGFm2MtpsHsy2DfO36Ta9d
j8A3enD7WmEC76IxXLw2FPzhJPhDpcjTsP82yq7+/ltH8/G6oX5yeqT39ER8
w0TW09bkaMHGWt4N/nOT2ydsueEfPkNvwGdGgs+MBp+5zfGZlQLOgoDvB95N
qIe9Rj3GqKfGQeBj58HHKsHHggVeR4fA6xTgdQ7gdR3A6yrA6+4LOOP53ivw
Q1eOH6qwv1rD8U/sSxO/L43y7AdXfruQvzDh8xemyHd05PIdK5EfaczlRx5b
7tIcr19Evc1vVSd/ymCrtEomZZYq6cqOlASfZDlpWFzMatgyjrUJP9Cl5lat
Hyu4PsljhJx8r4zdcDrUh42nVSqrVyVUKeStTIYhb/UMeavxyHP5Ic8lQ57L
Y6/P9jXhxfR7gdW1/a99WU7hClcre0XdOfHHnD0Pc5rVv+FPBXXNNzgnufOE
Xv/W8V75QUn68A/7OL/xqChb/UVKMZM37ixx1c+jKcuqBpq2ldb5B234hzPw
DxFCeSpD+Wkof8t1a7ONU+Rkb+p6784wKa0wmPe0891CGn9ty9rt2gVsUlJ8
extbJc2aXFqUHyelGY8Pp10+W8hW+v81VTpBSYHPlrdq/iWHmra7OzZmmYLt
y+0eMqVr7XzbmDWq4nc6KQT/zMbAP5fAPw/Fu5/O3PuzM/CO5y7g74Ar4ef/
4uppIvwv7cf/9sP/RvRzs7x6Oo5ZbVrdZrN6FQ35Xb5p56A4ShdwsgRuBDwE
+ALgg4EncvUMAj4EPG0seJoneFoWeF1j8Lq24HXF4IEnwQMNwQOXQ1djB13N
HuhqNkO3EwHdzhfodjTxvYfxvX3wvTL0s7gOFqF/GmJcDqG8IcpPwjiuwTgG
YRxNMO5TMO6zMe5BsBNH2Mky2Elf2Kcz7LMn7PMB7K0K9jYZ9ibGQY+4+wrC
Yc8fUH4qyov3L8VxcdNwzJfumC+vMF88Me++Yt5lYd4NQrw2GPGaEeK1UsR9
MsR9/RH33YcfiIIfMIcf8IPfaAG/oQW/8RB+pj/nZ7pBl7UGuix/6LKuQMc1
BjykBXhIF+jE1qJ8AMpvhK5MtIfvsIcBAk8jA/C0OeBpAzl8BnAzgQeSyANt
wAPHANcBvhT4UPDAHqhnFuoZDLw397/jUU8z1LMK9UwE3hz44vr1Uw+OZw4C
LtZvAbwf/tcQ+Mz6/8uaov519f+Xie1ZBvzHnFmfXjaOZWu6DAr1js9i/l9b
Ob5vXEEH5v6D01Lg14CfyRL4dhvw7W/g25+z6vPwPODvufe43cHzi4FvBe4P
vBf4rXiuZyv4bYJQP4n1v0f9+gL/p4bA04AXobwW8AzgQcA7AM8HLsf76TvR
Hm+0pxr4Fq79/PlW8RzZP3GWc2bdeVXxnI5wvqDiX+d3wD+ZL/inLvjnaMGv
kin8qhf86kno4qYiDjqJOKg/ypuj/HGUhx6VzQHvLQfvdcY+9jbsN87GfuNj
6F0NoVMtg061P9pZg3a2QDursB+Ywe0HPgp4rJQkvWadg5/3WBioZO7Wsat6
zFVQteBnWBb8TF/4mePQt0Rw+1HFKK9E+QEoj31+9onb54f+mX5Bj3QMeqQI
nEv1xTnHSzjXljzl9M8TtfzfJe1XyBuDF9Rh863da8ZL6uJoMR4vRjyO/iEd
9E85+ucc9FHDoY9aB33Uca4fvNAPg8Hzm3D8/75QnjqhvCfKT+fiC7H81oTL
EXoORaz1peZ9o94ls4lVNpPl1cW0XHfGzFadM9mPuUNNZe0z2WjH4OMBrmV0
ScCpFPhQ4Dqu+jtcy4qprbpV8duDz5mt2hZJsK+cTIrmfrirLKUXC89pf57t
xaqG/L7VfI6Myrl5cRbzQgp8O/BQ4NnwD9qYd6mYd68wH9sCzwb+BeVbAU8C
XgK/sZ2bpz3Bl9zAlyrBl8rQHjuU90J5gj9sC39oDX84nuNjStTTAXkZCfIy
65GXGYb+CV8k9M839E8r9Kc2+nMt+rOlsJ9P97Cfr4/9/OGCH6aF8Lf34G+j
4J/nAb8NfAPGMQfjaIpxvIlxTwVuDNwLdtWFsyvcJ8AKuPsE0M9M9M9X0G8a
8LeaGJcijMtEbr0T1xd7wT7p80XBPifBPo1gz024fddDsOcclCeUF45/yUx4
/6n3cpVxv70p//K3E7l1cAXa00GI301OIn7XRvyeAntrge8qx3dVwt42cXbe
h1unxPOnHYRxZ1lq9edRL6GdkXw7A37pT/UKTKeMSM9E+Z4KCr85+GDT4fH0
RvBLLBJ+SRt+SdTVeCOerUI8O0tuu+rG8DzW40br5EeBMqaeYx4w6bqSluH8
IP+OjDnK9+HKK6AfmA/9wFzoB6LQzhS08zna6YrxrcF4/YXxaj63stnQtWW0
MCLB2eeqF1n0sbseuUdKYzEu2tz+WzOUf4Hyligv2qeM6+fZ8J8NYD9lsJ87
OAfXjns/ukW3pifSFvmwx+feL0v1l7OOektbDtxQQl+Q116IvPZ65LUZ4v12
3D6AH/YNDiPelyPeF/Pmw5E390DePBN59ljk2YOQZ9+NfYxA7GMcxD7GbyG/
Q6ncfsgd7M9M5/JiEuT39yG//xz5/SzoAXKgBxgEPcBt6AfioR+wgH7gJvQG
3tAbXIHeQNQnPII+IQX6BFEvsQZ6iUPQS5yAvmIQ9BXa0Fd8hw7EHDqQCOhA
GoQKupGW0I3EQzcymXvHpCl0NX24fX5xf/gO9udtsT+/CPvz/bDP74Z9fjn2
+a2gd/oBvVMY9E4x0Ec9hT7KB/oo3AdLn7j8y2jorA5DZ8Wgs5oGXdY36LKM
ocuyhI7rB3Rc26DjEnVf56D7coDuax/0aTHQp32FPm0p9Gxm0LNFQ88WD/2b
Gad/E/V7szj9nhJ6v2fQ+4VC7yfqBo9xusGB0BmOg86wEDrD4ZwuUQ26xGro
GCdBx7gNOkY5dI/60D1uh+5xEObpE8zT9pinfaGrPAtdZRB0lTugw2zM6TDf
crrNvdBtijrPfZzOswS60HzoQt2gC7UXdIlsKHSJ1tAlJkKnJObL1iBfNh66
Jk/omlygazog6LvYEOi7JkHf9RE6K1HPUAI9A/RpkRLkcW4hj1MAvdYN6LX2
Qq8FvUSkHPkgBfJB86D7ugHdVwJ0X2J+SswrjUdeCeXpGsqnoDz+l67jf/fj
fxOgT/sGfcgO6EOg9zMpRHveoz37OZ3bNPSDBvJTOfjeR/jefZxe7ij0ckL9
N0xOI5+l9k3IZ1VCHyLq1qTozwy0X9S5OaD95vjeAHwvw/c+ge5F1N3twXc5
YBzF9lug/VnQ4Yg6ND/ocIKgj7rB3Q+5G3bVBXZlA7vqhP1zb+yf98b++Z/Y
z782T9jP34b9/HVrJ/599YicfCXB3o3Cg2vjnZHSRfYlpAUdmgR5ZGfkkcX7
tF24e6droHM7jfx4NvLj4v2i4r3Zv3EP9mTBzpkH7Hwv7Bz9wEQ9UhD6oRD6
vW3Q7z2Bfg+6PhLxKODQeZrcQ/wlRfy1FflE8f7npcgnPkP+ehPm48b6ukES
dYPhqP8j9AA38b25+F5TfJeoS3TDd7VBXl6K/tyN/hR1C7HcPvZ56DeecffJ
i3rgA93r64FF/fAjzk7WY3zfY3yPYnxFXbQSuugq6KIdoaPuzemoN0F3zd8j
EQs9TDr3jmQC4uXluAfmGBcv+4OXtgUvdUH8OwPx7zbEv3txnmgmhx9G+UnA
NwOXRkRPu9TI+V/7JKLewAh6g7fQG3jg/FH39fXjfdRPYv2bUH8KePUGtL8T
2p8zrOnKJX/KmFfFrz5OmVdZ1YIoz9ZqZTTqr3k79BNkzHCgW03i8Wimb5ej
sW10KTl53OvZaIOMzdaa6HltRTIrTfz8adUJFc0ud2h3a0QBG3SzpW12bBZL
tU7c5NdURbuuT51jrZ3FinLuJRWslrKLksAQs7sltCjzfpRu8Cs2Sv1L81+7
ilj/+VuPtt9TQs2494DE9zEnfFkc8mBlFm14nRTQfKyUmSxyOPkrooRCC5ym
HphbQFOqXFyCdmSxOe+THoXpqMjFs4nZ7BUy0vs+Tq9Vv2RmuvbZjuQLKrKi
dBfthzLqse74PqNZ0UztUmqiyZRS8ms0KSu+hYx2L1nhefHkVSYfuOP9+JZl
1MhpyA2XlXJ2yj0kzuHv62ya/dTP+pdqeULmV32zCDmb5vnNpfBUHEtuv6R3
q8fFte3Rq6ypHd+LY/Y0bb8xnSmvzs+t6VhMS7l3LUX9vy/2k9tiP1kb+8mf
b7ZWHftbTuVHnZc0j7/GhkR9yPpwpYSetPhrysm3hbQnc8CY2La3STbwqk9k
kooc/j7ayrFMSmYfnLKnrI+iDQlfpTOzS0n9lMRaLbiYuafoqms4+TKdFlOM
JM6Kun3ySQvr75Nf2OubKMspIpfqBU5/d4knx/tl5VbWJbRC6+XlOCsZfTPX
7Dar3xtyVH9p6hipIo82OldPnS2iwfet1jm1zaBVxo75u2KUNKLz5xsjb0nJ
6FhRTHyDLDpObkd+Hi6hTPcRHSq9ZGTb7qOx+3op7d13sUGCroIeX/jc6Xdf
CW38uG3ivflSsrerdDk0T9STnIp8jnfef+GddwH3rXsXvgHehRf19uI78t/w
jjx0I5HH8O78Yrw7L/KHBLxTL8M79QJ+v+5d+xC8ay/q8D/uPW1+P7KKlrSY
/rnnkjp9vsn/G79vItYTjHpEfUsi/jcP/yvqW46jnQvrtfOOifhdn/BdAh5g
IvaDBvrh/6/P9zeJ5frTtLjHXL8Wr+n9EYd9Z0eoSHdifLebMwpptaXXw4Or
UyiuxbU039JS+mPtqjFb/3cvzLix/b3HptExf/db7xuU05FTm2zH2mSS4y9N
I5/tGaTXyN613Lechpjmrna4m0Kr22zcqPUpg26beU+dp1tBwz+2916hekVl
yIudQl6sN/Jia4X/ZS/wv53xv09sumTP9klkll8Gd1cZq8iraZKts3UhRUu2
GrhZvmC/55u6pzctpvSEpGYhGxSUHd9h5pYvtev5FbM/BixQ0ue93tlLV0kp
zNpI786FQrIf+LtV6gglHTrjH1PQJZe8FV+XN/stp887Mw31lymof0ZaUZ5d
Bk3l8mUByJetveB05XNlAZvjd+LHxCVKaqtcPWmQrZQGJy8c/cwmh7U1uOFx
+WFtOz6eCF1Yy5sXpEyfuyg4nW1yGhGSZiGnic4Bfn8aKevys++4fO595MUq
ODynk9mHextl7Gj2k/bpSdLa9e1bQ7Oy2ni29YhFysYSZnh5//PDe6SkcdJu
QuS4YpreafePY2eVrGZZs7uNZam0Y2Ouw9gz8tp5/nbCnzeK2I/5Q9emPMyg
2XEvjVxOKMmuMnT0yCAp6zPyzwk/p2XREvuQwHE7SihkosvELQ3lzK6d5Fmg
JJ4KPdq20xxQQnMCUvrHrZSxbe3ttaaefEO5Lh299W+pSBU62Df0l5QFH1wb
NftKFA0z7h7dLaGUbkfnPPfXOBjJ33tTgvKBKG+M8mL967n6b6M9m9CeIrRn
G9rfA+1fivY743u/4nvn4nunoX8+oX8c0D9if/ZBfzZEf4r9fxj9/xP9j/dW
WBkXLz8B/7Tj+Kc17GE97GEy7MEY9qMF+8mF/ayHvc2CvbWDvV2A3VbBbgfC
bh/Czrdxdi7DvLDl5sUbzKNf3DxKxLybz827zZinvH9YDL4qvpdqA766FX4g
CH7AGH7gAPxGN/iNwfAbzvAzR+BnDsLPbOP8Uhf872zOj3WCH5vM+cMm8IcR
WHc2Yd1xwLqThnVqJdYpZ6xTw7GujeDWtRNYB4dz6+ByrJua4+uvm+exzh7j
1tmz4M9y8Gdr8GfwZJbMnTfRwPruhvW9DdZ3e/CByRwfiAR/OAP+UAj+8Al8
IxJ8Yyj4xjru3KLIn0PAc3zBc4rBc5aDF80GL3oDXiTyqGPgUVPAo6LBw6u5
e+OvgI9t4fjYAvC3bhx/2w++9wfH9yI4fjgb/HA6xydHgU/eeHK/Tbv9ASad
4Je2wi/NBF/9C3y1L/jqjv/gtzPBh4dyfHg3+PM88Ocy8OfR4Nv9OL6d9x/8
HO8vsAQubkro4LR0+N5S5nF+SPWsLDtaf7vJ8+pqGS3H/bfq3L2vKE/+5+qX
j0Yc9BxxkA/iILG8y6X65VfiXtl3uF93P+pPRHtmoT1rUT4G467kxn1vbpcs
S/XAf51bj/9goHIxTGWfbAMDwy/K2cHUsKiih0paVxr42qltKukbP97/7Lqc
mRkNnGZ4X1k3jxj3zoXWh5omWs5h/7p/4PwbJztpy2y2aoOO1/zlcuZhW/mp
1RgFWT0b69ouNIuaO3QJX3Baztyvbk5UGdTy57RroRc6ySlbc+Ss6qhcZj7T
W+IdJK97F0PCveMp6l4COR3LrMlvlk6+XduuV2/sOi1JJcvp+7pkXJKTG+5J
jufueV7G6eE1sL6c+avlgj2lZcz98J2aivBnZPTo0LxFoRIKPbzXrvOI+EgP
5H3aIO/zjtOl64N3dehTGWl1M4MFG9tsbnSxnLzo3soux1Jou+C3mei3R8Nv
S581KHKOvlJ3v0138Z6W/9CZ95vT8au0PJ1Kat49jpwnJ631w3Yc6KWk/UI9
dfe99EE9fVBehfLaKD+A298W63+AdfYQt86K/XMB/TMU/WOD9foDt88DnD4C
V0M/z8R4tcd4WWC8juF9kxfc+ybesJNXsJMJsBOBtyf9K6+3BvbWiLO3k7DP
dbDPE7DP7bD/PrB/U9h/DObLZ26+xHu1qJ5gX0TBP5Xxn63T2fTcb/ENmxfT
Q/DMYk4fCJyUHD4dfHgFpx87J/AQVg0eMgg8ZBXsR+T/RrCflrC3ENjbCdjb
WdTzAfX0RT2ifjKam0diPJvB6b7E/aWnnJ8UdVyaXNwt9s919M8M9M/P9//4
DRPRb8TCb6wV/JWJEfzVEPgrG3XnNHV/ee36c/zi9+EKuukee8zRLKsOfwDc
D/gCAWeRwK8CX8LxqMXgUaI//w5/ewD+9qRgbyydszcRT+Fw8T5wLd/69cTA
/zeGbuQU/D/mER3CPDLGPPIBHsjNr+X4rjtcP+A9IPaauwf+n2nhHPmvfbD0
3//7vY7k70PDOzjsB3evwl7MxyTuXcVBmHf8uYC1gp80seP07f8H224MJA==

    "]],
  Axes->True,
  AxesLabel->{
    FormBox[
     StyleBox["x", Large, Bold, StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox["y", Large, Bold, StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox["z", Large, Bold, StripOnInput -> False], TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{-3, 3}, {-3, 3}, {-4.497025753249276, 4.497025753249275}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewPoint->{4, 2, 1}]], "Output",
 CellChangeTimes->{
  3.591489849699973*^9, 3.591489902686071*^9, {3.591489941118585*^9, 
   3.591489980432152*^9}, 3.591490015571301*^9, {3.59149005305425*^9, 
   3.591490069379301*^9}, 3.591490116181608*^9, 3.591490147234517*^9, 
   3.5914906345479116`*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", "\[IndentingNewLine]", 
  RowBox[{"myg", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"ContourLabels", "\[Rule]", "True"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.591490192318818*^9, 3.591490207964587*^9}, {
  3.591490474110407*^9, 3.591490482290357*^9}, {3.59149051619521*^9, 
  3.591490521714525*^9}, {3.591490600578347*^9, 3.59149061059973*^9}}],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFvXmcz9X7/z+lBdmytFiSJQmFFhR1yFpSkj17EUJIylYiWbIULbIlRcmS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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGuMlVcVhr9z5nbm3OY7A3IZWjsopA0l3Mqd/iiolIEYyxTsMEUrl0nF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         "]], PolygonBox[CompressedData["
1:eJwllF1oznEUx3/bs+3ZHv//f/9nufBuXhZR5oKYK+alkJqNuBizMWxlSqFJ
bN4JJW/FDYvtmZVNifaaG9TMS8NIeRjikmKKmny+nYtT5/zO97yf85tUsbO4
JtU5txVKg3o954Z5+BJz7miOc78D51ZlOFeV4txu+O2+czPS7G0I+WTo3Leo
c2/QtyHvQb8my7liqD/u3F/eisAm0JfjOwG+APuV6J+ifwttgF/BWy22VdBi
5ELoIbox2C/HdlnEubHw9cKAvZXp3C/85YG5Cj8X/V58N4WGVQzF2uRZ7A4w
C8CmYd8JXwkmA74Pn3nk9wD6CfYumHzFpqYd2Ed8s22HCtCl+2Y7DXrvWQ7K
pRmahT43G5t05+7Tw4voRvO2AOx06ANyTWi+q8lpD7H74taLXKgJvhv/PeTe
j4/D6A8wg+6Y9fAf8hswpWCXg7mNr834nA7fCH5tYDPSrNTDR2BTwCwkXiH0
wbeeqrdLoGrkXvBTM6wHT+DXE2888YqRy6nlO/5XRiwn5XYEf5/xdQP758iX
0KcSewT4e9gXYD8v02qeD38H/MhMm3Eb/E2oAl9L0d+Af00+JehayPkVfFm2
xfbp30b41fjwY7YDazzbEe2KdqAL+0+8HSP+FeQGdEnPZqOclJtmptlp5pp9
hWexVKNqPRJYr7Wz2l3tgHZBPR6I2w3oFtSDFuIVIceQ24nXAf4M+GvkOpO3
UnTjoI/0Z472Fb4Qm0TEbmoR/HHoa9Ru5gT8H3wUoWsg3hjwL33zXYO/XcjP
fNO9B38AfAnxlqZYDspFb9IloYPa19Bm3YWPTmzrQtMNYNNKrV2+6dRT9VY3
qlvVDHajOwcmmW4z20es6771NsHbusBqVK2qqc63ndfut0BDnmGE1R+xBXkS
mNsRm5FmNRn8FbATideo+4bOI1+ABj0j8WXgY9rn0Hopmylx2zHtmm7ssrCe
3Zp27gXYbcivqLWHHA+Sa5L4i6J2A7qFZuTZ8KfwkZ9tN6hb1NsP5E/E2JZl
O6pdHQ7Ml25Qt6gb062pplx8nc62XVWM1NBmptkph370E3Lsb9LMJ8JnBVab
brYSfatnuegGdYujA7sNzXhUYDeuW49TXyt8rWe8ZqRZVSL3gH2H//3oj0Jf
onajulX9Kfpb9EdOjVvP1XvVOKi/Lm6z0w6fxdf4HLtt7aR2U3+6/nb5PIa/
db7F0h+pv/IQb4NR2/n60HZMu6a3w8iP4/bXKEfl+h9JrNu6
         "]]}]}, 
     {RGBColor[0.3835509530276444, 0.21412474101879406`, 0.6561075803768981], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnuU1mW1x38z72WGd97L732zIk1AYAZmQM1SgbCLacsizMNN+qPUoJxJ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         "]], PolygonBox[CompressedData["
1:eJwllmdsVmUUxx/a96Vvy33ve29BKaBSEAptGa4ABVQgKkMIMgrxgyAFZIiM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         "]]}]}, 
     {RGBColor[0.47368590605528865`, 0.370845082037588, 0.782803160753796], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXucVVUVx8/cmbkzd+6599xzLQXMBz5AeUXlMAYBI1hYFqIWmigPS0oo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         "]], PolygonBox[CompressedData["
1:eJwll2dslWUUx5/uwb33ve9FQLZQKW0BBS1QCwqipgwZApYagkzLElpWIpii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         "]]}]}, 
     {RGBColor[0.563820859082933, 0.527565423056382, 0.909498741130694], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXuU1VUVx38zcO/M3Pnd+7t3eNgiXzA8otWqJHyklksQU4iWCwYfiGHI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         "]], PolygonBox[CompressedData["
1:eJwllnuQzmUUx59dvZddv/f9vb91SY3buq5qiNyppkGRy7iMFVHa7CLaRU0z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         "]]}]}, 
     {RGBColor[0.6300909060552886, 0.6340429487042547, 0.9110094940871294], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw9V1tsVFUUPe3MnZmWO/fMHQFRA4hPIhg0ErEEIT5iQBoCfAkIRjABP2i/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         "]], PolygonBox[CompressedData["
1:eJwtlllsVlUUhY+U/i30/vf8t3RAKiDOUfAJZRLqHBQ16IsCghE0SgzwTnEA
BdoiIMgggwUjiKLiGJlVEBkcUCFxSGSoGgURUEDQSMFvsfqwk73OHs6556y9
9+02ctw9Y9uEEJYgbZFj+RBuLw4hKQlhQwzhBPgOcBV4J3huGkIz+CSyHNtY
8Eb0/TniwJVJCIPAvyILsVUljj+ANIGP523PyPcp+e5MvPFO1p7E3gF8G3q+
XQizshCm4dNM7jX4P1zARvzpohC6YF+G/Rvs1di6I69iOwruodx81BH0ScgP
xPdB9pL/dXxeY7/ZxEf2Ksc+GtsQ1jL0C1ibT/5xpSGcZb8a8DzwYnxuwl4O
noFvEfGT2T8DTwf/h38duI/uCN8j7H8N+i723IJ+ENmNnrA2CvvdxJShL0p9
V6eQVzjbktR39Q+yArwi8bcMxr8Dtj6s/ch5BmIvYPudHFfyvXOxH0CvQsaQ
fxi4Ev0M/seIf4GYs7o75DB4NrgFvYUzTyDXTPzngzsSM474EeCB7NcTPCvn
mE16y9S+k3m2Qeg3R9/Nn9ivRw+Z7+4v8Gnubz1rZZzvPmJWo1/HHs1F5kwj
vovJ8Rv6GqQ7tjX4tC8xByvY70JyPAqeR+qLwZfgPx5bN/asBjfivy9njgwi
fhWykr3+xWcl+jz8f0L/ALkKPAC5NWdOTCS2P3gHtjLec0ZmDoqL55HjLvL3
w74dHLBPwn459jpwud447zOcOwtn/Jp89+Ozj+9vRjrlzTlx7xApahNzTFzL
4/8R+gOZffVGeivlVG5946XEvowcQt+AXI1tKfgg+jqkR941qFrUN85PzRFx
5UFytCf/xMS6vv+R1JwSt5TjpdR3pLtSTbyRNwfFRb3Ji9h7g7cVm3N90cek
Pos40pg4p3KL05MS9wD1Ar2J3mZV9HmK+d63ozkgLuiN16L3Q46Kn/j3Fz+i
9VHYzyffRYm5toS1LgVzTFxbBL4RfSv2pTnXwEHwe0hJK3/Uy26I9n2ItU6q
pcS5mpBbsF2LzEEfib1j4ppUbSrH++hvRZ9dPUm9STWsWt5LTEP0m+g+KvH5
IvpN9DYF8CexldPFroF10Xtqb51ZZxcndX857O9gew4+/MJdp/BtDvpjqfOp
puvx75l4b/VA9cJe4F3g3Uidaoc7mlnkmi1D/zZ1L5LP+OieJKxv7hUdo1j1
gCvwfT7z3qoJ1caEzL1tDznHow9O3WuawDXYh2TuLXvwGYb+PedpQK9HOoAf
R06XmkPiUmfsdcE+FdiGZo7VDNAsGA6uD66hEei15dRqO8coVpwQN9Rje3P2
Z/DZz/5t8alH/4y1ipLWmZV4Jmg2qIaWcfY/omtRM+Jw9Dfp23TGJ1T/ql/1
SvBE9Kcy6+rx6vW1xCzImbPi7tboWTYUewX6V9Gzcji4Gn1j9CwV5wvoX0Zz
RfYd6B9Hx0bWNqNvieaO1mSrynyXmiGVmXuqeutY1s6gj07NL82wKZyvpWCb
ZpZm13HwAfxHsvY3+omC9e+Qe8n3bjT3VKOq1Q+je5NmtGb1puizCWu2z8zc
K38m/zT0pzP3Rt2Z7m525tktDovLUzLPSr2R3mp55tmtGdCAviDvXqs31ltr
5mj2iMOVee+hvdpjn555Zmt2j+L8J/mWZzPbNJM1m6dm5oJ6tnp33+hZJ85v
xt7EWmM7z5SuBXNYXNZam3L/Y+hfQzPiSOqeod6hNx9ArqngzqWuSdWmeoZ6
h2bCZalnrmZvOWvb0bdF6+Kj/qX05np7cfTzaE6IGzXkXM3eDeTrWuqeol57
quBv1RvqLSta+aIzrAVPThx7jgOpOaf8yrG+4H8E/StoJr6Z90xVb9Q/3Bz8
/weJ5VWT
         "]]}]}, 
     {RGBColor[0.6963609530276443, 0.7405204743521274, 0.9125202470435647], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mH2QlWUZxp/dPbvnLJ7zvucFP1ghlLKPmcj+MGWFMDFimokZW5wAYTd3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         "]], PolygonBox[CompressedData["
1:eJwtlVls1VUQxg+97e0t9p7//bdugBaKoj6Y+KChUi0GRX2wGoSIhAR3qGEp
gnLbIppaFKnBBVppgoqUkghxQVCjZdEoShQ0QUGCFHAFH2mMSiKK/r58Pkzy
zZn1zJmZU3vf/MnNJSGExVApNDkN4UAuhI5MCOcVQtiacF4ewufwW8C3cdYL
vw66FTwyhlAsC6EmG8JZlSG8Ct+Ho4X4Wgselw9hLnjK0BCaqkJYgf9m+IqK
EJ4FP58a/4T/58B16B8G78ZnG3wfPvbCb8DnBnA5OcwgViP8zfCr0X8S+0Oc
tSPbQQ7HudAybGqiYyr2AHw9uv34vBL9TvKvJ/+D2AwHz8HfN4l9yncn+tXo
3w01Bdtsw7YVeQO5bSJGC/hD4v0KXo7+aPh/8NmC/jxqeAZcgs9p5DaEGEPA
OfSnI78T/lzkXanvXon/bvDvnM1Gfi/2f4B/g+7KOcZH2F6V913roCPEq69y
rtK5BtyAzi/BOQ4g3w7/QtZvertqTQ73wGeInwN/nbi2D2OzD3yq4Nhz4P8E
r8PHnozftBfchb8rkNdi/wP6I6CF+LuMs1WKBdXmXNNvkSXk24b9Uu73N/FL
OZuOfgnyDHgYtCBrG9mG1LVrBf5L/Brkj2QdU7GXIS+pcA89Bf4UeSx3jrvA
t0Cvob+CfCP6h+CL4AvROQxeis0ZfB1Dv0P1oGYr8fcu9ZrJ/b5LrPse/Kzo
nlBvDOPsAPgYNAr8PvIHkR9XP5LLRZydAP+cGF9ODvuQN+O/aahn4E1qsZOc
TvCWZyPfiXyw4F7cxdlJ8FHsF5c6xvfgedjPxH4jZ29g30rOp3KekSL4x8Rv
IRvZbo3uzVnk9w74JWg9sgXEXwOeq54o8xu0kMvF0W9/PmdjwO2qf3CNngBP
gvbnPFOareuI0YNtEZ3xiWdes9+D/U3Yn0a/g3o2Iu8i33MK7nX5qIJ/OnXt
9YbLwYN510I7ZBT2tdGzpBqpVqqxaq2ebYdPou9WDb8DPCF6V6nH1GtHyKmm
3G+utx9R8C44SPypqXtUvSqdAeSPpd4Nf3H2OPiO1LrqCfWGYijWIDGfwf84
bLrgF3G/q8FLUtuqZo+Cj0bPpmZwPLFuhO8sdY9MBI9VPwf7qAPvSbwrq8ln
L3iRdkDOO027TT2sXtabtyDbjk4Ful+Q87bEO0W7RTMyEvxV8r8v5F+Cr02c
q96sATwGymY8I43gjxP3hmboE/BEaE3WO+wG8AMFz8ZpbO4H91W6V+VDvvQH
6C9QzmPJd0Li3pCP67Vr8rbVDtUuXR39l/Rypx5wd967QT2j3nkxWvYQ+t3g
jdDJMvesend3dK+ppp9F7zDtMu2gC8D7E89qPzqzkbdF/yX6s/R3aaY12/pD
lnCXl6NrqRl5JdpGttrZReQfJM5FNe8Hr0q9q+dztjL1jGvWtWO1a1/Pe3dq
ZjW72nHaddpxw8Fv5T3L2gnaDeop9ZbuuAlfmxP71p/7NvjS6NlUz1wC/g/5
9AGf
         "]]}]}, 
     {RGBColor[0.762631, 0.846998, 0.914031], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXmQVdURxi/MvHnvzdx377svUZKA4kbcYkRBRVZNFIKyGldQUUBKkcSy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         "]], 
        PolygonBox[CompressedData["
1:eJwtl3mwjnUUx39x730v3vd53uetUC63okWmKWtFtsgSIRVFcYmKtM1YrkEo
0rjKlqZp79KmPxQmqVxtlIokO4UspayVtZr6fOfrjzNzzu+sv/Oc3znnuXDg
Qz0frBRCWAfkCdIhVC8IYVZ+CG2iEF6OQ2iFwB+cvQL+JWfF4KXwLwIvR34M
dOvCEDZmQyjLIAtvRJUQDiYh/IpMW/hNUiGsgPcnNhqDNwVWQo+GXgv/1Woh
TMuFUAt6Af76c1YEfh7wOvQd0OeDZ7F3jEALoReBL8JnDXzv52wh+CfAJdCP
4H8S9kcQQxm8LZVDaAZ9AzrPEt/F+J8D3QZ+fWw9BL8adAX8c6GHIvMyd1sC
nYbeBj1Kd8N+f+ynoY+ClyKzGv7aqiFMJP5S7B2Hfw+5HAX+FDrj8T9N8SL7
EfYS8M3oPwxvOTbqIf8Gd3wD3sLIdzsKfz74vdy5O7FVcDYE/E3g17NCOA39
FvgR9O9Efw/6zcHrcLYIvDf8YvDrieEO+FcST1vw+2Lbasf9S4l3D/STxFcP
eh94UeRcbMfG+8Rbjk4RuRxCPC9BH09saxxnJ8A7cYfa4O+jPxD/GWAy9iZw
dhp+a/gx+FZ8Po79SfqGwWdzlB9iKOfbzyR/DeF14Oxr4m2BTAbdhHi6gx9C
viOyTwPzkS8jxkHI70HmY3h10VmG4VTWvM85uxrZq6GfILYy6LnI9oU+Wdl3
mouv34DRxDsc+gD4YGx2g98VOJq2jnQXcP9+xBKhf1PKd9RdTyW+ax/8f4D8
A+j3QvdW4BT074lt9+P+j0I3gv9aNd9Zd2+LzdnY7ovNmtjriXwf8N3k/2bw
czi7DXo89s7O2oZs7UBnFrodcs6N7qi7NodeoVypPon9ZNqxTAWG4XtK7G/x
JzKdcwbh5eT/CXjHEn/b8cB06SfGh6FfBXoQPpbgqwE1OBj/LbHfTLWNv0HQ
7aFbQbcEdkN/i3wTcjMSG9PQPwK00lsClsGfmfPb3wnMzvlN6W3pDi3UD6BL
8DcAKAK/Hvt/Uw8n4XeFn5d1LasGVAuHEvcefVN928OJfeub/Mz99mdcGw2J
aRW6OyLbOgF0wd6FkWNTj1OvGx25d2wGmqLbFXvfoTsKuhP4kbRrRTWp2myA
zZHEU4cY/+Vsf+JepJrahP+79caxvx0oxd5kztYU+E3obdQDxqpWgHnYzsPm
FeCfUg+Vc+6x6rUN8PEa/JXYqw2/H/odwH/IWrYlMhvA3+FsMXRT6DXQq7PG
9U30bXKRe5169C/gVWL33lJ0JmB/fda2KoDruEsP5Rf5idwnR/xbkB+BbBHx
bAV/KfasmAu9CtkD6N9e6B60JO0ZoFmgGaBZcBCftZCvTz0dAM+L3esHYnMU
8pVi97L+0COh56H/Sp5zWEA+duk9FjqHC9O2IVuLVTPwmgGTUv5mXYjnGugp
Kef0e2SnA4OCz66F1wYbh6HLobtDn5V2L+qL/qGs37jeuu6kuy1Nm/e4ZlrW
NaRauhT7O/U9YsdeE/568NWcXVbgmbMG/H7lqNA1c3nWb1xvfR1n3RPnXLnX
jNGs6ZaYp5mp2Skf8iUbw+AtTTwL6pKjDxPXiGplBjGliG1v7F6vGdg+cg2r
ltegf2PimajZWITNL+B/SjyXFnqmarZqRmlW6eyzrGeEZsU30B3R75zY1nDs
10Z2ObAWuhs246xnhGaFesjd4DH84Xme6ZrtKeJ7Lt81NRbbUca2NRM0GxST
YlPNrwCfEXk26xvqW74VuXZk823N0pzvrprJ1zxQTyv0jB6JvZ9i13ox8eyI
/cb11iUzGv7u2L1YM1KzUt9Y31o1pdpSj1Wv3QnMjtwD1QuvIb5WxF8c+W2q
510QOSfKjXp6Cv7YnHuvak61p51Lu9cU/M3G9p7IvVQ5VC5Pc3ZrvncI7RJf
Ja7VQ9DPE99UzkqCZcrAvyHGRoXuAeoFd0G/m+8ZeCd4Y3zeAj0HaAe/MfG0
x94J/O/F12M57zbLsT8BvEfWb1s9WL24tXp4vmdiJeiKtHfD94AB8F6MHZt2
lhdizxDNEu1ELeHPRX5cgXueep96pnrnU9BpfM0H/ivwDvq2Zgn6myp7p5uA
/OK0ZfWm9La6xN69ZLMreEnGb0E7inYV7WDaxdQz1Du0Y2nXWqGZFLnnqvdq
pzoMf7h2uqruUd/B3xj7LWsn3RB7J9JupJ1Ru+MzmTPfjrN/Eu8k2k2041WA
/xV7912FzBcZz2TNZuU8H/5hzjqnPFO36XtF3j00UzVbh8b+FtoJtRvuy/hb
aeduknPOlXvtqMuRz0/77ekb6VuVZN0btbPXjT0DNQtVI1+D/xi5dpXj7Xo/
6N+eco2oVsbkvKv1JselsXdY7bKqqRLtzlnPBulU134cObe6k+52VeRdXTV6
pXbryLnQjlct8g6kXUg7UA3wWTnvBtqZtDvdlnj30E7QK/EOpF1I/wDj1Iti
zyL9Q2yL/Sb1NtVTzs545mr2aqfXbq+dQruFZlod6F2xe4F26J3gBekzd63q
WvgfC37GPw==
         "]]}]}, 
     {RGBColor[0.822146, 0.8668446666666667, 0.8873683333333333], EdgeForm[
      None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmg2UVdV1x9/Mm3nz3sy79937SHCl4moxa7UgyKeapigoCojf1WgbkxiJ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         "]], PolygonBox[CompressedData["
1:eJwll3mwVnMYx3/3vu973/d233Pecw7DJGbImLi0ZxtLKhUtopjRdkmhukmW
yJKJdKMiWSPKYCS7mKG0uLdUmBhjG4MyWtzKUrKWMT7f+f7xzDy/37Oe5/ds
55grrh06uTqE8A2QBy5LQnizGMLMUggN4C8CbcBLdSG8XAmhSwytwH1tCF9G
IRwH7IF+IzId4J3EuTOK+kH/IA3hQc5NnPfBUw/+JDr21oTQF/oT4B8hsx99
B+H5EPwa7tZBb4++H8C3czcE2UPwbRt4jI4bcyHcgEx/9F8Jz7vwt4P/K/Az
sxA2ofto+P/D5xT+6fA/DP9g+A+UQ7gk52/syvkpoB7ew5FZrHPFvu9H5xLw
Mt87Btkqzuv1rfDcRMBugOcn8F34NAz/2qOjFbyC/cegBfib4e8PHMDebHTs
wPYzQAvy7bg7Fv2NQHONv/kfaOvQUY++ZnT8iOxnnM/kfDbwNPQ3OR9Wsg/T
OXeAZxW6fuHuWvz5l29uh/kM+cdSx1yx3wtM4Xw7/v2KrW+BJmzfA30rujq2
CWE0tC3oHwDvQOAN9M+umHcnNmaCn5zZN8VQsewV2VYKPIr+HcQrhtYFfQ3w
DkZmFfrL3F0A/ic8d8D7APE4G96buesDb29gLPxTsL+Jt+kGTwO6twH7yY0i
PnSFPhdYwjfO1xnZXejoDf4S8BX+HB85FjPQ0R1dT3K3utrf2B7+yxPHvi/8
Y8DXAj/jy+/YWAP+B/7NzNvHv8A3cdcJfcuRfwtbb6Hva/BGfSP6VnDewnmq
3gDe7vi3FtkxvEEZ2hLgPehXonMe+M+xbd+iNwcfDiwruIZUSz2x2QK+Hqjj
PBQbL8KboL8F3q7oWJNzDUTQu2BvZa1j1Al8Az50LNnnjfo24Dp4v8OHt5Ht
Bs+aWvu4A/nToC9G9jt8OB18KzbOwN4+YBC8jfizIue7SeCjoWdVISxCpgF8
OzqXQ3sDGFnxN+nb6oFPwCdC31N0zS+Cfh02Pij6jfXWe6GvhLYCGAv9GWys
xdfXoD8Lfh70Y6tsYxT0jplz4Tfs/4D/LcCGvGN0EfQ5egPOu5GfCz6hbPx5
9QRkR1Tsq3JGuXMZcAz6T0bmcvCFyPwN/yri14hskXO/on0cV/Gb6+0HcFcW
LXMsxqsfgXdDZii0T+CfBu9meKbn3eM+Bv8n9VsMgucA+IWJY62eqd6pHFGu
bIb/DvwZgo5lNe6hubJzQLmgnG6OXVOqLfFcqPjCU1dyz16G7gORv+0U4CB4
I9Ap7x4wJHHNqHa+gH8Y/gxSDVU5hkXp5+57bF2Mv0PA1yNzYsk9Sr1qluoN
X6fAPxt8N3ddg3viHvAdiXujevhO8D7ofwVdryAzEv1jVQ/IjsHGFarl2L1a
OaJcuZ9z/7x5bkZ/Tdm5pRgr1icmfgvlaH3iHqleOY/3zvEewzVfcrY5Qv0g
da9vC5yLvpGJc+11YBT458C4avfcL8B7oa815xq9NHZPVG+cwF1JvTPxbFLP
/B68Z+Re+Q0+PpJ6BmgWKEfXRZ6RmpVTgeNVexXPGr2Z3m4Y57bIN3HOUs9g
zWLl5OPgaWraLCABLyDTU/MLHRXorfj4IbZSdPwIvgD60mq/0VLOv1c8y8Sz
AX+qyu5d6inqLc9D76FcgecF8FkVf4t6tHq1akK1sRo4A/tt0LGu5J6l3rUr
8ixXzZxK/M/l7hDyaSP0vuDnC/B3M+cB4H8rp2s8AzULj4w926VTupv5psl5
9+gWfX/sWpsBnBS7J6s3Kyffh35o4lyVjSK685lzQT3u09g5plybz10NtBJw
f61nchG8Nz69X3LPVO9cwN3WOtfAPPBzUvdmzYCP0dUn9bcp58v4Gyeubb1J
NfZPSPzWmsmazZpJmk13Aj3A70Pmy2rvLNpdnovsm3wqcM5iv6V64mL0lbnb
mPeOkYB3j71bqGZVu53ReWvRO00XzjWcr9bsgP8U+CcS49XqzbznDM7jOc8E
v0vvm3lH0K6gNztBtZ1615mmNwBfkrp2tHNo97gtc6/TTNZsfiD2LFHNqnYv
Tt1bZsHfVr2V8/yCZ+x85CN8HBvsw7TMO6Z2zSLQxPnBzLNeb/AQeD7xrJ4B
/02cY+DRWsdEsXkn9e6gHWRn7BmsWXw7/FOhP556V1kJfSH49ti1o5m2DXxQ
6tzUTB8I3ho5dpqpmq3aebX7agdbnnimaLaM45vGYyvj7q6Cd840cUwVW8V8
At92TWrbeqPJ4LXINBQt0wn7e4DBOfeA3bG/Ud+qGClWiqFiKZkjwK+qeBZK
5reyc0q5dTd3C/B1dOLephmnWXcvd9fnvZO0gb8pcu/WnWiKkWKlmiyon6bW
pR7aF/pCZK4uuCeeE/mb9e3aQTpr906922vGaNYUsNkz5xmuWb4r9a6umr47
8o6oXVE74qKyd3bt7sqRs2LvhNoNVSPLy94ZtTuqRnul7kHqRQfROQn6TnS+
V+sdR7vO3Mi5q7seeovMua8ef2fmHqJeoh2/DvzX1P8emtnzkF2UWLe+4Qnw
pRX3Ru002m1GIfNqwTkYZZ5pmm26E007tXZr9WD14jncfV3wP1Tn2D1cvVw1
elTFM1+zX/8M/SLPbM1uycyNvSNpV9I/zz70/Q+kG9SC
         "]]}]}, 
     {RGBColor[0.8816609999999999, 0.8866913333333333, 0.8607056666666666], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmguUVtV1x+/MMPPN497vu3dkDNKKghi0qzwG0tZX6gPUGEFAUGF4xKQr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         "]], PolygonBox[CompressedData["
1:eJwllleMVVUUhrfT7gXvufecKw+KYgIRhAQHZhBNVHoLKIEBRmEGELEkSAvg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         "]]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGtwVdUVx09uEpJz7z0392ZUBkkgURIU44yg7UxbmPKGIUinjg4g6LR+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         "]], PolygonBox[CompressedData["
1:eJwllF1MznEUx3/1PL08ef5P/57hJplCbrT1cuMlF9gwTSYvvbvoDlOoLUoy
LrhQIjKxYTMJvZlxyVx7KStUV2RxZYWJZPP5OhdnO+d33s/ve056VU1Rdaxz
rgoKQotSnOtIdC474NwR37lBz7mukHNTCc6dR/6BvgH5JMZT8HXotyOPxTnX
EnFulLe9yKnQLfhtUYImOdeP/SNsC8LOZcbYm3Txyc5VxDs3TL44+FZsGvGd
D3XiX4mcju8h5C/InfjXY7+aGoeopxUqCFrOMfSfoRr4l+TIop7TnvlWQ5Po
pqFj8N3QUvLnIQ8Qq5j8N4n1CXk/ujb8K8j1kRj55PtLyY3wzcQ7gH4fNIHt
dXzmmE0/MQ5iv8Gz2u/wthPdJc0MfpZ4AxF7k64L2gVfjv3ioOX4gP6VZhay
mWq25yI220lsaol/Df2CkM1Is8qDRqi9l/w/0fch38f2BT7H8Z1lpmvIlQ+N
eDYDzUIzOoW827da5uivAftc5FrijQOKHPimiMVSz+r9Mm8/sb+LPIS8iniP
yf0EivFsJpqNZngCuYT8jliF9FcKX0KNadQ3TMwzxC5HXoI8gnwWeQJ5JflD
0Bv4TVAGs1uHHET/kJg9QXvbjK7FN50wICy85i0uYDEUawSaF7CeItS2Ept6
6j8KZfmGaWF7GmqDjyfH+oBhdGvYalSt+qNS5D1gZmGSYfIZtSxDfkCvvdB7
zzAkLCnGDd96Um/PsS/DP8czrOvPmpnHHmy6E+xPN6KbS7a/Uo8DyBd8q+03
9fQQa4gYzXE2wzLPMCFsbCHeV/h3mk/IalJt2fTck2gzmQnbH+uvbxOziNiV
YcO6elJvxbzdS7CaVJswL+zrrQR5h2++2sH0ZJuhZqmb8D3FdlK7qRlfDVvN
/2tHv5z4o9TXJ1v0F327Ibol2slv8GGoCX+HzzD+tb7dIt2g9KjtrHZXN6NR
s9A9iLWYK9Alp9gs9Odvw3aDdIt001LhB6F2YhcKv/Djnt2mw/RfGzUMC8va
oX7PalAtpcw8QC+xnmFTmBf2f0UM24q5N2w9qTftfDt8bMR8hfEKz3Iol3Zi
TLJntWjntfsZUdutHHLU+XZTdFt0o3LRZ0YNa+pZveum6LbMkO+KbzdAt0B/
rr/v8E2nndXuDpNvbYLdBN0G3UjdSr39QU5Lsdy6aYvhn3qGXWFO2PsH3tLX
yQ==
         "]]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwl0slLVWEcxvGfVtLCIds2wG2wTUJeC1q0SigoWjjldaTcW+B1ldWFWnQX
anORZsMfEGkDtKu/IO8ttbRVGlkE0URGtehzaPHl+/7e9znPOYdzUr3Hm46V
RMQT5CoiTlVGnMR96wmUYHd1RCm/LI/oXRvxghcxhaPmAi9jh9xPrpdNI1cV
UceruAyDzjbLf5X7hi/4ge+oXROxHTdkijzKKdc0WjfhhGdq5RY0Y6/eUdeN
8Bg38GH7bchgUH4Bb9HprF3fOesMd5iL/JRbPE+HdT7Jcau5y36peQWm7ZXr
P7064nHyjrrrkEaYK53NcAXPchX3c6eez5zFkJ5hDOh97jzLU1xEAUe8Z4/c
L5lltJszyGNeNqvrDT/EIxwyH5TfJXuAy/gT3/JMt3EH9XrT6LN/0zyOjeYN
GLDepKOo66r1NVzHpJ4rfBmXMOd8m1xORw2/Nm/hV7yV78lflLuA8yjYT9nP
WvdjvXutw13MYT75XvaHMYSPelfq2Mc7eT8/0DGJv959hn/zNP/hWpklHWfM
7/ksf+BufpZ8f/fu1rFHrovfJd/N/mL1/3/7H8d9aUc=
       "]]}, 
     {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwV0rtP02EUxvFjjOKlQNtNExM1UcBogaAuBqIC3iJewEEqYmKMkYgU/gE3
BS+DOGgRFDdnEwfjJNTb7OKmCBShbI7GRD+/4ZvnnOc873nf/tIdVwvdQ2si
ooRiKuJwdcSpbMQR9cWaiF7s4tWlI+rRgL+bI55mZPhP6ASK2K2/RYeQk2tE
kz3/5J/zXmAKHXLTtI4WaD1tkd2PcfUjvOR30l5eHu32XPKWPlR7Xw1SSKMW
M7IljKhn6fnaiG7Mys/gPabs2Ml7R8dkLsuOq1+Z3dGPYpB3l97DJrM2/TR9
iNtyx/gDvOO0zGvhnaZVtMC7760PMMDbLneDNtIm5LAg00zn6D46T/fSn/S6
t/2WX7Wrgh591nfIII1t+vV2H5Rflv+k/owveCP/kX5ACb/MD8j9sa/Z2ZP0
Cr8fEyjiJu+Q2SCd1D9DRb3OrhO0z32LyXeneazwv+l7nLmALfJbsZGXM8uq
M0gn6v6u5N30qNkIbzi5X/+Wv8Qro98bJ53/atbljjM4h7NYy281f+zMHgw7
10DzznWadST/EbQjxa/YsZr8dqxgGW1mZbqEeSxiAa38H3QO3/Havg12XHNf
Ff0Psg5knw==
       "]]}, 
     {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwV01dsjlEcgPFTWkWXlksuxB0S1E5KS0TRBnFrVUuM1kqMihGzEkWpuDGK
VmpelSgRe8QqEdSlVaO0RayqEL/34vmec/7rnPf73q9n/uIpi2JCCLE+Ilen
hHAcx7AgMYT9fAD7cCc1hMKkECZ1CSFLbk1aCCXi43krb0Km/F51m623YCUK
5GvUv9J3hneoyRD7lxDCiOQQOtm36injH/wLPzFSbhSPRrPeWr1NfJ5/i7Uh
yT4Z7cQy1cdxiv0V6wa8wRix6TwDVc4YKj/W+dlIFeuLBCTipvx3d77N3/gW
fxB/jzRUmHWZD3Kl86sw1bxpmI6ZcnlYou8it/EflFpvQz/0R71YTfR9YK1Z
5WLr+JN5TfiIlui5Uap2kLu+43R+ywM5Uf1yjjOjyF1b7Qv5Ny/k1/isf7v6
B2rq8BCnnHWf7+EuGqPvxJx469l6dlp/MaPA+ivP4edojH5XtVfVXcN1VJt1
hS/jEhrkY3mFGUl6i3le9B7wfJ4bvVdYb78RG1CsLsPsp/qe4QkOi7WXi8Vj
ZwwTG44y613YiZXOquViLuB8dFB/1D6OO0bPhCNm1eut5F7OzrOehSb1zbiB
R1imtoOa9Oje6lbbl2KA9Q5O53Leg93YjlViE919Erqa2Q3x+nuYN15sAsYh
FzkYIj8YF9S0cAwPQJI7j5VP5mw+J9bdjM72mfYJnMUPxepwVr6/sxPN+Ot/
1Id7o1BNEV6qyXG/F5zLo9VPjt4Tc+7KH9R7CBVYKndC7iRO25eop/Afp++T
Ew==
       "]]}, 
     {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwN0N8vlXEcB/APnQ2rHDRK7EjjL1DZmKYlbGGx5ZZEa9bqKoetC9ddmYN/
oC6qy1yJww25bVHLr2Lo1tFtLrwuXnt/n8+P7/PsqR161fcyLyJmSVyKaC2O
yFyO+F8aMSPPZFLeU79WEnGVPrVeFs1/Uz9MRhzxl2Pa1B4wa29VrvGVdi7a
qZE3yOlnZVatVq5zk2XPT+SK/Od9pzSXRTRxaiejd0V2yALve2PumfOW8za/
2GWHab0qWU0hRUyqPTf/2/kPexywT0YvJWvII58xtVHzG86bfOcnP5jSq5TX
uUCCtNoL8x/4yFvfuiSTlDDPZz6RZpwTMzuyxe6wvCv35C639CbdOydf++93
ZLd/0sOE/m3PE+qNckyOk6bYHQ/tdVHPO8918r08sZujiQWzXxiwP0gnQ+pP
GWbEO4r8+8dm+qlSqyalvuSuR2pldsrVKihUa+C+/jnmL08v
       "]]}, 
     {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwN0TkzXmEYBuBXn+D7EEGazFgKorNvsfwCjV6jQo+EEGHGzocZIhgSxk6D
pEE0ghn5IxpLGkuu4pr7Oc9zzynOedvYWt8SF0Lo5M2LEJ4TDZEQHuQTj2TY
1yaEUMd7aqgm3b5SVlFGBeWk2RfLEgooopDX9tnxIeRw/TKELJlJqv2V+19W
7Zftlsg3X9hdcsY5f3il/819nhWdRbnAO/Nv91OOOOGYFP0Z91l+6MzJr+SZ
f7r/Yp9DDkjWj7lP8l1nWk6Ra95132OLHbZJ0h/zzcYZJcYEFfrDcoQBhhgk
qt8rv/CZfvoo0++WPXTyiS4i+u2ygzY+8oFi/VKaor61TNTblC2et+QaGzR7
XpcJ7vf+5z9uuOOWBu/6D5OMSA4=
       "]]}, 
     {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwV0M1LVGEYhvG3lpPZfOcHmdUmcNHCgSAkV8ZMMw41O60MgsgIZ/a2qBG0
xtbRuKhVo3+AgYhWFJSuFArClduyD4NqqdXvLC6u97mf+7xnzpy4UatUD4QQ
HuN0WwiX20M4xb3xEI7j2eEQDiZD6OZLdk/5y5EQvmIH73WH+B1f4B7PnHQu
6pbQ1P8sf8L7Ce+Q3TWf1cm7d9L5k+yt+ZxzR9TDHu7L38hz8n4ccncMabuC
XYbz3GE3qzfh3OAVnaOyTWzgj94aryODLB7q3dF/wMvRndG3RN+B3/qv+DUS
SGJG77b+NC/px2UvsYpf+ov8IvqNaMOU3i39OsfMKecF5ybP867sJ77hB76j
Zjdot81T5jrOu3vc/7Qru+m9j2RF2Sxf5Kr8TDT7bwe4wS08R8Gcc19D96Pe
B6yjJcvYZ5HCljnNx3jQu+Y8V0LZuSy755lhHtW5ghF02v/DX1w3d/FVHsM1
9Hmmgv8nTE+o
       "]]}, 
     {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwV00lQznEcx/Hf42CZUVnromiTjHEwUyQOpho0w1Cm4iLhqRgtZhykDmQ3
yL4ess20uSnpZMaBhAtmZHemI5Nlyus5vOfz/X2+n+/395unf6lV9SV1kRDC
CF7j2IwQ7idgWgg92Dc1hFvOt9GO59ND2BMXQr1euV6p/EV+Cb1EL6BCv1eu
Wd2CYryUncR7QSfSuTK7aIY9kXgXI4VXYM9CmU3qGv1aTMAgL0Kf0e10B1LN
piGDl4c5Zir5VdiGp7zV7l6L/fauoU00k59uLst5Aeajk5dNn9Akb+mgj+hP
Oz/Y9REPzPSiDw16jWjW76cH6G67f9BfSDE/bua6eoxG9AKaYr+Ne/oQh+O8
Vtlrdhym8byTvAT6hpfvrhz+LHWOPbmo0/vHa5OrV/fLVKpnqn+r/+AvRrEC
KzHb/FKzY+Ya5cbpXjqgl6732HmyegreOuc6J9JlyMN3786ny3FKr5gm8irs
TKJf6Fd8QovzZzpPblQ9Evtbe986OmBuPT1ET/AO0hp3ViOKTnMdOO1tw85d
drTKJatrMWi23Hkrv8fsDeebWMVL5S3hZdFuOzbwu+hGepR/BGV65+w+jzNo
w1mU6iXL7ZSvRhRDsgXuLEQRsmPfpdwiWui+dvk0lPHSaZSXQV/pv+MN4z0u
21+kt5ifac9mmT77H+Kq3ha9K7H/FRqVaZGpkxnSv8O/h7to0Oui3bHvFd98
Uv8BEap9/A==
       "]]}, 
     {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwV0UtsjGEUh/EjIalWS+tSVtXN6My0LomFIDQW7gzD1EpECQnSaae1QGJl
Y2VtJbrVjiIuCerWBMW69LJlSeseqn7f4slzzv897+XL19hezHfMiohhrJoX
sXtBxC7sRFVtRCVa5BuxQ7Ydc2UVyMo2YJtsK+bIZqMH3VhdHXFxfkRJ3ZXk
NREF8z9kP/Edv/ELw2ZrrFejTX8ILeg338xlXslX8dBZ7ebPufM8LttzVF9X
F/GKa/klr5E3J+9P3ooMNpkfclaTOo0UPulX8H6usKdk7wyHu4qynLoX//Qz
mMaEmXDWfX6AfebOykPdw92YsmdcXki+V36Qx/Sf5V8wiWl9pzyX3OPd98zd
RVY9zk2cQRp7ze9Bh9led19Hl5mMLI0G3/DR2mHnNaqXY1Rfzx94Lf/hdWhA
qzNH7HuNjD3vnTeCr/oj1s6os/Ir6j7zo/obfEm/Wd2K9foUtsiueUsOp+Sn
kZeXnNWNJdbrsRhvzSzlN1y2dsHsX14kW4hj8kfeepwfc55v8gHu4zL6sczs
E36KQTzHMxTM3eY7GECb/ha/4yE+wS/4JFc6owqdKGJQNuWbJ/Et+X/eNoEB
3zLGKfwH/+ZtHA==
       "]]}, 
     {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwl0ttrz3Ecx/H3/BDCcLX95rA53HLH5o6/wBwaJWz8cihT4seWdjCnlUPK
uHbYRspvyhTmwgVqhrU53dhspbQmaqZG5PHNxbPX+/B6vz+fz7dvSdWB9dV5
EfEE2/Mjfs+OqKSb50VUzYT4zdyIt+jH4VkRfTRLT/A24bH4G+8h3J4TcdJs
tzjFt0a+Fp/FDXxb9c7ptZo7T1eoj9Pl9Adt5LlAu8zUiD+od4jvolb9orka
mpPfwXv9dxhT69F7gW7kkt3ufsuO7zSrVs2/H/f4K9SPiTN8z+X75E/pXvos
eSf/T4xjj9ouvgrxVfE1DMtLaMZ7iukmvZ1qW+QZ+XT5DAyppe1rmRbxSVwg
HqSF9Ast5S/Da3fpxSW1TnMttNi9R+y6Ir6vdpkO4COmqE/FZJTZlaKr6Q69
rLlK+svMBP6izhl/aD3drdfHf1DcTx/gIdbJN+it5CtAIUbl193rBlox7Iwh
tGExliTfSj2LIvPz0Sg+jibk7Gig9ajDK+ekeSboguTdyX+U/DM4hQ7+ZnoG
p7GIZyGOio9gmfOWoh09eImb6u1ow1f3LbIjjVXYKC833+WcR0jxDNI8OkAn
0bO+17b8////Pyq8cug=
       "]]}, {}, {}}, {InsetBox[
      RowBox[{"-", "4"}], 4756], InsetBox[
      RowBox[{"-", "3"}], 4757], InsetBox[
      RowBox[{"-", "2"}], 4758], InsetBox[
      RowBox[{"-", "1"}], 4759], InsetBox["0", 4760], InsetBox["1", 4761], 
     InsetBox["2", 4762], InsetBox["3", 4763], InsetBox["4", 4764]}}],
  AspectRatio->1,
  Frame->True,
  FrameLabel->{
    FormBox["x", TraditionalForm], 
    FormBox["y", TraditionalForm]},
  Method->{},
  PlotRange->{{-2, 2}, {-2, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5914902099885607`*^9, 3.591490482993991*^9, 3.591490522951376*^9, {
   3.591490602769198*^9, 
   3.5914906219491367`*^9}},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
},
WindowSize->{426, 652},
WindowMargins->{{256, Automatic}, {-23, Automatic}},
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, \
2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 74, 1, 28, "Input"],
Cell[656, 25, 468, 10, 41, "Message"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1161, 40, 153, 3, 28, "Input"],
Cell[1317, 45, 103, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1457, 52, 1134, 25, 114, "Input"],
Cell[2594, 79, 37566, 615, 215, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40197, 699, 784, 16, 97, "Input"],
Cell[40984, 717, 42630, 812, 258, "Output"]
}, Open  ]],
Cell[83629, 1532, 519, 13, 28, "Input"],
Cell[CellGroupData[{
Cell[84173, 1549, 1126, 26, 131, "Input"],
Cell[85302, 1577, 133509, 2186, 235, 104425, 1708, "CachedBoxData", \
"BoxData", "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[218848, 3768, 717, 16, 97, "Input"],
Cell[219568, 3786, 132012, 2207, 296, 109190, 1831, "CachedBoxData", \
"BoxData", "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

