<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Area between curves
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
Area between curves
</h1>
<img src="0g/12.0.window.jpg">

<h3></h3>

<p class="show"><img
src="0g/12.1.parabola1.jpg" class="rightalign">How to calculate the 
area in <span color="red">red</span> above the function $f(x)=\sqrt x$?  
<p><b>Many ways!</b>...<br clear="both">

<h4><img src="0g/12.1.parabola-1.jpg" class="rightalign">A single integral over $x$</h4>
<p>The area of the box is $1 \times 1=1$.  Calculate the area below $f(x)$ with an integral, and subtract from 1:
<p>$$\begineq \int_{x=0}^1 \sqrt x\,dx&=\int_0^1 x^{\frac 12}\,dx\\
&=\left. \frac{x^{\frac 32}}{3/2}\right|_0^1 = \frac 23 (1-0)=\frac 23.
\endeq
$$
So our desired area is $$A=1-2/3=1/3</b>.$$

<h4><img src="0g/12.1.parabola-2.jpg" class="rightalign">A single integral over $y$</h4>
<p class="show">If $f(x)=y=\sqrt x$, then with a little algebra we can invert the function:
$$\begineq y&=\sqrt x\\
y^2&=(\sqrt x)^2\\
y^2&=x \\
\endeq$$
<p>Express the red curve as the function $x=h(y)=y^2$ and integrate over $y$:
<p>$$ \int_{y=0}^1 y^2\,dy=\left. y^3/3\right|_0^1=1/3-0=1/3.$$
Ah, the same answer.

<h4><img src="0g/12.1.parabola-3.jpg" class="rightalign">Area between curves
</h4>
<p>An integral over $x$ is the Rieman sum of rectangles of a height which varies with $x$.  That rectangle "height" could instead be given by the difference between the two functions shown
<p>$$\begineq 
\int_{x=0}^1 (g(x)-f(x))\,dx&=\int_{x=0}^1(1-\sqrt{x})=\int_0^1 dx -\int_0^1\sqrt x\,dx\\
&=\left. x\right|_0^1-2/3=1-2/3=1/3.
\endeq
$$
<img src="0g/12.1.integralfuncsyeah.jpg"><br>


<h3>To Do - Area Between Curves</h3>
<ol class='todo'><li>In <tt>Lab 06</tt>, Exercise 1, You'll plot the curves $f(x)=\ln[x]$ and $g(x)=(x-1)^2$ and find the area between the points of intersection of the functions.

<li>In Exercise 2, you'll use parametric plotting to plot $x=y^2$ and $x=1-y$.  <img src="0g/12.0.prob.jpg" class="rightalign">Find the area of the region shown, between the two curves and <b>above the $x$-axis</b>.  Do this, by using  $y$ as your integration
variable (instead of $x$).
</ol>

<p class="justme>Solution:<br>
<img src="0g/12.0.solution.jpg"><br>



<h3>Integral of 1 as width of interval</h3>
<p>This integral:
$$\int_a^b 1 \,dx=  \int_a^b \color{gray}{1 \,}dx=  \int_a^b \color{lightgray}{1 \,}dx=  
\left. x\right|_a^b=b-a$$
<img src="0g/12.1.intof1.jpg" class="rightalign">is a very contorted way of writing the <b>width of the interval</b> from $a$ to $b$. 
<br clear="both">
<p><img src="0g/12.1.intvert.jpg" class="rightalign">Or, turning the picture by 90 degrees, the vertical distance from $a$ to $b$ is
$$\int_a^b \color{lightgray}{1\,}dy=b-a.$$<br clear="both">

<p>In the picture of the area between two curves, we could write the height $h(x)=g(x)-f(x)$ of the rectangle at $x$ as 
$$h(x)=\int_{y=f(x)}^{g(x)}dy.$$
<img src="0g/12.1.integralfuncsyeah.jpg"><br>


<p>Then, the area, $A$, between the curves is 
$$\begineq A&=\int_{x_0}^{x_1}h(x)\,dx=\int_{x_0}^{x_1}\left(\int_{y=f(x)}^{g(x)}dy\right)\,dx\\
&=\int_{x_0}^{x_1}\int_{f(x)}^{g(x)}dy\,dx\equiv \iint_A dA
\endeq$$
where $dA=dx\,dy$ is a small chunk of <i>area</i>, integrated over the region, $A$, shown.

<h4>Original problem as a double integral</h4>
<p><img src="0g/12.1.parabola1.jpg" class="rightalign">
So, back to our original problem, which can be written in a new way.  We evaluate the integrals from the inside out...
$$\begineq A
&= \iint_A dA=\int_{x=0}^{1} \int_{y=\sqrt x}^1 dy\,dx \\
&=\int_{x=0}^{x=1} \left(\int_{y=\sqrt x}^1 1\,dy\right)\,dx
  =\int_{x=0}^{x=1} \left(\left. y\right|_{y=\sqrt x}^1\right)\,dx\\
&=\int_{x=0}^{x=1}  \left(1-\sqrt x\right)\,dx = 1/3.
\endeq
$$

<h3>To do</h3>
<p class="todo">Do Exercise 3 in <tt>Lab 06</tt>, in which you'll convert the integral of Exercise 1 to a double integral over $dA=dy\,dx$.
<p>Then...
<ul class="todo">
<li><b>Double Integrals and Areas</b>: Write out each area as a double 
integral.  You do not need to evaluate the integrals.  For each area, you should be able to write the area as <b>one</b> double integral. (Hint: You may need to think about integrating $x(y)\,dy$ instead of $y(x)\,dx$.)
</ul>


<h4 class="handout">Image credits</h4>
<p class="handout"><a href="https://www.flickr.com/photos/fragiletender/564941677">Kirsty Hall</a>
<?php include "../../classes/3.h" ?>