<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Double Integrals [12.1-3]
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
Double Integrals
</h1>
Approximating volumes with stacks of blocks...<br>
<img src="0g/12.1.frog.jpg">


<h3>Finding volumes using double integrals</h3>
<p class="show">Consider the volume, $V$, of the solid which is...<br>
<img src="0g/12.1.underneath.jpg" class="big">
<br>
<img src="0g/12.1.stack.jpg" class="rightalign">
<ul><li>bounded below by the rectangle, $R=[a,b]\times[c,d]$,
<li>Goes straight up from $R$,
<li>Is bounded above by the surface, $f(x,y)$.
<li>Split up $[a,b]$ into $m$ sub-intervals, split up $[c,d]$ into $n$ sub-intervals.
</ul>
<p>Approximate volume is 
$$V\approx\sum_{i=1}^m\sum_{j=1}^n f(x_{ij}^*,y_{ij}^*)\Delta A.$$
where...$\Delta A$ is the area of a rectangle with sides $\Delta x=(b-a)/m$ and $\Delta y=(d-c)/n$.




<p>In the limit $\Delta A \to dA \to 0$ this sum becomes exact:
$$V=\iint_R f(x,y)dA.$$

<h3>To do</h3>
<ul class="else"><li>Double Integrals from Data
<li>Back to the Park:  The average height is formally:
  $$\langle h\rangle = \frac{\iint_A h(x,y)\,dA}{\iint_A dA}=\frac{\iint_A h(x,y)\,dA}{A}$$
</ul>
<h2>Iterated Integrals (partial integration)</h2>
<p class="show">How to evaluate a double integral like
$$\iint_A f(x,y)\,dA?$$
<p>We define <b>partial integration</b> of a function $f(x,y)$ with respect to $y$ with this notation:
$$\int_{y=c}^d f(x,y)\,dy=A(x).$$
A(x) is the result of 
<ul><li>Treating $x$ as a constant,
<li>carrying out the integration with respect to $y$.
</ul>
<p>We write it as $A(x)$ because it is the <b>area</b> resulting from the partial integration w.r.t. $y$
<p>The double integral is the result, next, of  carrying out the integration of $A(x)$ with respect to $x$:
$$\begineq
\iint f(x,y) dA&=\int_{x=a}^b A(x)\,dx\\
&=\int_{x=a}^b \left(\int_{y=c}^d f(x,y)\,dy
\right)\,dx\\
&=\int_{x=a}^b \int_{y=c}^d f(x,y)\,dy
\,dx\\
\endeq
$$

<p>This rather sloppy way of writing the double integral leaves it unclear whether you should evaluate the partial integral of $y$ first, and then integrate over $x$, or vice versa. Perhaps it doesn't matter?

<h4>Fubini's Theorem</h4>
<p>...says that for a rectangular area $A$ and some pretty general assumptions, <b>the order of partial integration does not matter</b>.


<h3>Example 1</h3>
<p class="show">Find the volume underneath $f(x,y)=2-x-y$ and above the rectangle defined by points in the $x$-$y$-plane: $0\lt x \lt 1$, and $0\lt y\lt 1$.  (Alternately, $R=[0,1]\times[0,1]$.)<br>
<img src="0g/12.1.int1.jpg"><br>
$$ \begineq V= \iint (2-x-y)\,dA &= \int_{x=0}^1\int_{y=0}^1(2-x-y) dy dx

\\&= \int_{x=0}^1\left(\int_{y=0}^1 (2-x-y)\,dy\right) dx
\endeq$$
<p>The $y$-integration happens for a particular $x$ value, so, we treat $x$ as constant...
$$\begineq
\left(...\right)&=\int_{y=0}^1 (2-x-y)\,dy\\
&=\int_{y=0}^1 (2-x)\,dy -\int_{y=0}^1 y\,dy=(2-x) \int_{y=0}^1 dy -
\left. \frac{y^2}{2}\right|_0^1\\
&=2-x-\frac 12 = \frac 32 -x.
\endeq
$$

<p>Substituting this back into the expression for $V$,
$$
V=\int_{x=0}^1(\frac 32 - x)\,dx = \frac 32 - \frac 12=1.
$$

<h3>Example</h3>
<p class="show"><img src="0g/12.1.int2.jpg" class="rightalign">
Estimate the volume under this surface, then integrate.  The function is
$f(x,y)=4-x-y$.

<h3>To Do</h3>

<ul><li>
Double Integrals Practice: #1-4
</li>
</ul>

<h2>Double integrals of general areas</h2>


<p class="show">
Our problem is now how to carry out a double integral over some non-rectangular region:<br><br><img src="0g/12.1.order1.jpg" class="rightalign">
$\iint_A f(x,y)\,dA=?$
<p>We already now how to integrate just $dA$ over some arbitrary area.  We can think of this as the volume integral of $f(x,y)=1$ over $A$, and so the volume=$1*A=A$.  We'll use the same idea to integrate $f(x,y)$ over some arbitrary area $A$. 
<p>We shall find that the order of integration matters when writing down the limits of a double integral over an arbitrary area.  However, the order of integration does not affect the final answer we get. 
<h3>Order matters.</h3>
<p class="show"><img src="0g/12.1.order2.jpg" class="rightalign">
$\iint_A f(x,y)\,dA$
<ol class="else">
<li style="color:blue">Integrate first with respect to y, ($\Rightarrow x$-dependent height)
<li style="color:red">Integrate second with respect to x
</ol>
<p class="show">Written...
$$\int_{x=0}^1\int_{y=1-x}^{\sqrt{1-x^2}} f(x,y)\,dy\,dx$$


<h3>Order matters..</h3>
<p class="show"><img src="0g/12.1.order3.jpg" class="rightalign">
$\iint_A f(x,y)\,dA$
<ol class="else">
<li style="color:red">Integrate first with respect to x, ($\Rightarrow y$-dependent width)
<li style="color:blue">Integrate second with respect to y
</ol>
<p class="show">Written...
$$\int_{y=0}^1\int_{x=1-y}^{\sqrt{1-y^2}} f(x,y)\,dx\,dy$$


<h3>Example</h3>
<p class="show"><img src="0g/12.1.4x2.jpg" class="rightalign">
$\iint_A (4x+2)\,dA$

<h3>Regions</h3>
<p class="show">
You should be able to sketch the region of integration in $x$ and $y$ given a double integral. For example:
$$\int_0^1\int_y^\sqrt{y} x^2y^2\,dx\,dy$$
<p>...means
$$\int_{y=0}^1\left(\int_{x=y}^\sqrt{y} x^2y^2\,dx\right)\,dy$$
<p>$\Rightarrow$<br>
<img src="0g/12.1.region1.jpg">

<h3>Changing the order of integration</h3>
<p>$$\int_{x=-1}^0\int_{y=0}^{x+1}e^{x+y}dy\,dx+\int_{x=0}^1\int_{y=0}^{1-x} e^{x+y}dy\,dx$$

<p>$\Rightarrow$<br>
<img src="0g/12.1.region2.jpg">


<p>We could get the same result in one integral, integrating first over $x$ then $y$ like this...<br>
<img src="0g/12.1.region2b.jpg"><br>

<p>The line $y=x+1$ can be re-arranged to $x=y-1$.<br>
The line $y=1-x$ can be re-arranged to $x=1-y$:

$$\int_{y=0}^1\int_{x=y-1}^{1-y} e^{x+y}dx\,dy$$

<h3>To do</h3>
<ul class="else">
<li>Double Integrals Practice: #5-7
<li>Limits on Double Integrals
<li>Double Integrals: Problems
</ul>

<h4 class="handout">Image credits</h4>
<p class="handout"><a href="http://www.seankenney.com/portfolio/">Sean Kenney</a>




<?php include "../../classes/3.h" ?>