(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    597963,       9960]
NotebookOptionsPosition[    596192,       9896]
NotebookOutlinePosition[    596564,       9913]
CellTagsIndexPosition[    596521,       9910]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"4", "-", "x", "-", "y"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.653945091264051*^9, 3.653945163539666*^9}, {
  3.654808423153276*^9, 3.654808500815638*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "x"}], "+", 
  FractionBox[
   SuperscriptBox["x", "2"], "2"], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "x", " ", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}]]}], "+", 
  FractionBox[
   RowBox[{"ArcSin", "[", "x", "]"}], "2"]}]], "Output",
 CellChangeTimes->{3.653945167341407*^9, 3.65480847089495*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["7", "2"], "-", "x"}]], "Output",
 CellChangeTimes->{3.653945167341407*^9, 3.654808471013608*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"4", "-", "x", "-", "y"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "\[IndentingNewLine]", "]"}],
   "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.653945182052813*^9, 3.653945219455244*^9}, {
  3.653945303404685*^9, 3.65394531227597*^9}}],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{3.653945316199432*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "-", 
      RowBox[{"x", "^", "2"}]}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{"1", "-", "x"}], ")"}]}], ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.6548085073354588`*^9, 3.6548085301357613`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "x"}], "+", 
  FractionBox[
   SuperscriptBox["x", "2"], "2"], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "x", " ", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}]]}], "+", 
  FractionBox[
   RowBox[{"ArcSin", "[", "x", "]"}], "2"]}]], "Output",
 CellChangeTimes->{{3.65480850847192*^9, 3.6548085330756893`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myArea", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "-", 
       RowBox[{"x", "^", "2"}]}], "]"}], "-", 
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.654808537483419*^9, 3.654808568192174*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "\[Pi]"}], ")"}]}]], "Output",
 CellChangeTimes->{{3.654808562831944*^9, 3.654808569280057*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p1", "=", 
  RowBox[{"ParametricPlot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"1", "-", "x"}], ",", "z"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"Opacity", "[", "0.5", "]"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.653951655489396*^9, 3.6539516562825603`*^9}, {
  3.6539517808084497`*^9, 3.653951842681367*^9}, {3.6539519249620123`*^9, 
  3.653951957359189*^9}, {3.653952205510673*^9, 3.653952230134151*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1nH+QVeV5gK+IqJEmtNCWFbQ2vdUmsRRd1ljHeHXjrFy01GSmHRTWRbSt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   "], {{
     {RGBColor[1, 0, 0], Opacity[0.5], EdgeForm[None], 
      StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmXfgV9Mbx++553zsEJKQJGRVUtJPGaGhkC0lKQ0kSWRklKZRSZlFhbJn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          "]], Polygon3DBox[CompressedData["
1:eJxNmnncVVMbhvdeayWKDM1zUVSGzGROISoSkVAkUiikkilUKpW5kJAGY4NI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          "]], 
         Polygon3DBox[CompressedData["
1:eJwt13f8luMaAPD3977vL5qi1KGt4TSdNNA8DQkNDeW0HC2rgYaOljSEEi0h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          "]]}],
       Lighting->Automatic]}, {}, {}, {}, {}}, {{}, {}, {}, 
     {GrayLevel[0.2], 
      Line3DBox[{251, 474, 1113, 252, 488, 280, 1222, 503, 295, 1227, 518, 
       310, 1234, 533, 325, 1243, 548, 340, 1254, 563, 1161, 355, 578, 1175, 
       370, 1269, 593, 385, 1273, 608, 400, 1279, 623, 415, 1287, 638, 430, 
       1297, 653, 445, 1309, 668, 460}], 
      Line3DBox[{253, 475, 1114, 254, 489, 1125, 281, 504, 296, 1228, 519, 
       311, 1235, 534, 326, 1244, 549, 341, 1255, 564, 1162, 356, 579, 1176, 
       371, 594, 1187, 386, 1274, 609, 401, 1280, 624, 416, 1288, 639, 431, 
       1298, 654, 446, 1310, 669, 461}], 
      Line3DBox[{255, 476, 1115, 256, 490, 1126, 282, 505, 1136, 297, 520, 
       312, 1236, 535, 327, 1245, 550, 342, 1256, 565, 1163, 357, 580, 1177, 
       372, 595, 1188, 387, 610, 1197, 402, 1281, 625, 417, 1289, 640, 432, 
       1299, 655, 447, 1311, 670, 462}], 
      Line3DBox[{257, 477, 1116, 258, 491, 1127, 283, 506, 1137, 298, 521, 
       1145, 313, 536, 328, 1246, 551, 343, 1257, 566, 1164, 358, 581, 1178, 
       373, 596, 1189, 388, 611, 1198, 403, 626, 1205, 418, 1290, 641, 433, 
       1300, 656, 448, 1312, 671, 463}], 
      Line3DBox[{259, 478, 1117, 260, 492, 1128, 284, 507, 1138, 299, 522, 
       1146, 314, 537, 1152, 329, 552, 344, 1258, 567, 1165, 359, 582, 1179, 
       374, 597, 1190, 389, 612, 1199, 404, 627, 1206, 419, 642, 1211, 434, 
       1301, 657, 449, 1313, 672, 464}], 
      Line3DBox[{261, 479, 1118, 263, 493, 1129, 285, 508, 1139, 300, 523, 
       1147, 315, 538, 1153, 330, 553, 1157, 345, 568, 1166, 360, 583, 1180, 
       375, 598, 1191, 390, 613, 1200, 405, 628, 1207, 420, 643, 1212, 435, 
       658, 1215, 450, 1314, 673, 465}], 
      Line3DBox[{265, 481, 1119, 266, 1220, 495, 287, 1224, 510, 302, 1230, 
       525, 317, 1238, 540, 332, 1248, 555, 347, 1260, 570, 1167, 362, 585, 
       377, 1271, 600, 392, 1276, 615, 407, 1283, 630, 422, 1292, 645, 437, 
       1303, 660, 452, 1316, 675, 467}], 
      Line3DBox[{267, 482, 1120, 268, 496, 1130, 288, 1225, 511, 303, 1231, 
       526, 318, 1239, 541, 333, 1249, 556, 348, 1261, 571, 1168, 363, 586, 
       1181, 378, 601, 393, 1277, 616, 408, 1284, 631, 423, 1293, 646, 438, 
       1304, 661, 453, 1317, 676, 468}], 
      Line3DBox[{269, 483, 1121, 270, 497, 1131, 289, 512, 1140, 304, 1232, 
       527, 319, 1240, 542, 334, 1250, 557, 349, 1262, 572, 1169, 364, 587, 
       1182, 379, 602, 1192, 394, 617, 409, 1285, 632, 424, 1294, 647, 439, 
       1305, 662, 454, 1318, 677, 469}], 
      Line3DBox[{271, 484, 1122, 272, 498, 1132, 290, 513, 1141, 305, 528, 
       1148, 320, 1241, 543, 335, 1251, 558, 350, 1263, 573, 1170, 365, 588, 
       1183, 380, 603, 1193, 395, 618, 1201, 410, 633, 425, 1295, 648, 440, 
       1306, 663, 455, 1319, 678, 470}], 
      Line3DBox[{273, 485, 1123, 274, 499, 1133, 291, 514, 1142, 306, 529, 
       1149, 321, 544, 1154, 336, 1252, 559, 351, 1264, 574, 1171, 366, 589, 
       1184, 381, 604, 1194, 396, 619, 1202, 411, 634, 1208, 426, 649, 441, 
       1307, 664, 456, 1320, 679, 471}], 
      Line3DBox[{275, 486, 1124, 276, 500, 1134, 292, 515, 1143, 307, 530, 
       1150, 322, 545, 1155, 337, 560, 1158, 352, 1265, 575, 1172, 367, 590, 
       1185, 382, 605, 1195, 397, 620, 1203, 412, 635, 1209, 427, 650, 1213, 
       442, 665, 457, 1321, 680, 472}], 
      Line3DBox[{277, 682, 1322, 683, 278, 501, 1135, 293, 516, 1144, 308, 
       531, 1151, 323, 546, 1156, 338, 561, 1159, 353, 576, 1173, 1174, 368, 
       591, 1186, 383, 606, 1196, 398, 621, 1204, 413, 636, 1210, 428, 651, 
       1214, 443, 666, 1216, 458, 685, 686, 687}], 
      Line3DBox[{459, 667, 684, 1308, 444, 652, 1296, 429, 637, 1286, 414, 
       622, 1278, 399, 607, 1272, 384, 592, 1268, 369, 577, 1266, 354, 1160, 
       562, 1253, 339, 547, 1242, 324, 532, 1233, 309, 517, 1226, 294, 502, 
       1221, 279, 487, 1218, 250, 473, 681, 688}], 
      Line3DBox[{466, 674, 1315, 451, 659, 1302, 436, 644, 1291, 421, 629, 
       1282, 406, 614, 1275, 391, 599, 1270, 376, 584, 1267, 361, 569, 1259, 
       346, 554, 1247, 331, 539, 1237, 316, 524, 1229, 301, 509, 1223, 286, 
       494, 1219, 264, 480, 1217, 262}]}, 
     {GrayLevel[0.2], 
      Line3DBox[{690, 1004, 473, 689, 1113, 912, 691, 1114, 913, 692, 1115, 
       914, 693, 1116, 915, 694, 1117, 916, 695, 1118, 1010, 1217, 696, 1119, 
       917, 697, 1120, 918, 698, 1121, 919, 699, 1122, 920, 700, 1123, 921, 
       701, 1124, 922, 702, 1322, 1005, 923, 1006}], 
      Line3DBox[{704, 1011, 1218, 703, 488, 705, 1125, 924, 706, 1126, 925, 
       707, 1127, 926, 708, 1128, 927, 709, 1129, 1012, 1219, 710, 1013, 1220,
        711, 1130, 928, 712, 1131, 929, 713, 1132, 930, 714, 1133, 931, 715, 
       1134, 932, 716, 1135, 933, 717}], 
      Line3DBox[{719, 1014, 1221, 718, 1015, 1222, 720, 504, 721, 1136, 934, 
       722, 1137, 935, 723, 1138, 936, 724, 1139, 1016, 1223, 725, 1017, 1224,
        726, 1018, 1225, 727, 1140, 937, 728, 1141, 938, 729, 1142, 939, 730, 
       1143, 940, 731, 1144, 941, 732}], 
      Line3DBox[{734, 1019, 1226, 733, 1020, 1227, 735, 1021, 1228, 736, 520, 
       737, 1145, 942, 738, 1146, 943, 739, 1147, 1022, 1229, 740, 1023, 1230,
        741, 1024, 1231, 742, 1025, 1232, 743, 1148, 944, 744, 1149, 945, 745,
        1150, 946, 746, 1151, 947, 747}], 
      Line3DBox[{749, 1026, 1233, 748, 1027, 1234, 750, 1028, 1235, 751, 1029,
        1236, 752, 536, 753, 1152, 948, 754, 1153, 1030, 1237, 755, 1031, 
       1238, 756, 1032, 1239, 757, 1033, 1240, 758, 1034, 1241, 759, 1154, 
       949, 760, 1155, 950, 761, 1156, 951, 762}], 
      Line3DBox[{764, 1035, 1242, 763, 1036, 1243, 765, 1037, 1244, 766, 1038,
        1245, 767, 1039, 1246, 768, 552, 769, 1157, 1040, 1247, 770, 1041, 
       1248, 771, 1042, 1249, 772, 1043, 1250, 773, 1044, 1251, 774, 1045, 
       1252, 775, 1158, 952, 776, 1159, 953, 777}], 
      Line3DBox[{781, 1160, 954, 779, 1161, 955, 783, 1162, 956, 785, 1163, 
       957, 787, 1164, 958, 789, 1165, 959, 791, 1166, 569, 793, 1167, 960, 
       795, 1168, 961, 797, 1169, 962, 799, 1170, 963, 801, 1171, 964, 803, 
       1172, 965, 805, 1174, 967, 807}], 
      Line3DBox[{806, 966, 1173, 804, 1265, 1057, 802, 1264, 1056, 800, 1263, 
       1055, 798, 1262, 1054, 796, 1261, 1053, 794, 1260, 1052, 792, 1259, 
       568, 790, 1258, 1051, 788, 1257, 1050, 786, 1256, 1049, 784, 1255, 
       1048, 782, 1254, 1047, 778, 1253, 1046, 780}], 
      Line3DBox[{809, 1058, 1266, 808, 1175, 968, 810, 1176, 969, 811, 1177, 
       970, 812, 1178, 971, 813, 1179, 972, 814, 1180, 1059, 1267, 815, 585, 
       816, 1181, 973, 817, 1182, 974, 818, 1183, 975, 819, 1184, 976, 820, 
       1185, 977, 821, 1186, 978, 822}], 
      Line3DBox[{824, 1060, 1268, 823, 1061, 1269, 825, 1187, 979, 826, 1188, 
       980, 827, 1189, 981, 828, 1190, 982, 829, 1191, 1062, 1270, 830, 1063, 
       1271, 831, 601, 832, 1192, 983, 833, 1193, 984, 834, 1194, 985, 835, 
       1195, 986, 836, 1196, 987, 837}], 
      Line3DBox[{839, 1064, 1272, 838, 1065, 1273, 840, 1066, 1274, 841, 1197,
        988, 842, 1198, 989, 843, 1199, 990, 844, 1200, 1067, 1275, 845, 1068,
        1276, 846, 1069, 1277, 847, 617, 848, 1201, 991, 849, 1202, 992, 850, 
       1203, 993, 851, 1204, 994, 852}], 
      Line3DBox[{854, 1070, 1278, 853, 1071, 1279, 855, 1072, 1280, 856, 1073,
        1281, 857, 1205, 995, 858, 1206, 996, 859, 1207, 1074, 1282, 860, 
       1075, 1283, 861, 1076, 1284, 862, 1077, 1285, 863, 633, 864, 1208, 997,
        865, 1209, 998, 866, 1210, 999, 867}], 
      Line3DBox[{869, 1078, 1286, 868, 1079, 1287, 870, 1080, 1288, 871, 1081,
        1289, 872, 1082, 1290, 873, 1211, 1000, 874, 1212, 1083, 1291, 875, 
       1084, 1292, 876, 1085, 1293, 877, 1086, 1294, 878, 1087, 1295, 879, 
       649, 880, 1213, 1001, 881, 1214, 1002, 882}], 
      Line3DBox[{884, 1088, 1296, 883, 1089, 1297, 885, 1090, 1298, 886, 1091,
        1299, 887, 1092, 1300, 888, 1093, 1301, 889, 1215, 1094, 1302, 890, 
       1095, 1303, 891, 1096, 1304, 892, 1097, 1305, 893, 1098, 1306, 894, 
       1099, 1307, 895, 665, 896, 1216, 1003, 897}], 
      Line3DBox[{911, 1009, 685, 910, 1321, 1111, 909, 1320, 1110, 908, 1319, 
       1109, 907, 1318, 1108, 906, 1317, 1107, 905, 1316, 1106, 904, 1315, 
       1314, 1105, 903, 1313, 1104, 902, 1312, 1103, 901, 1311, 1102, 900, 
       1310, 1101, 899, 1309, 1100, 898, 1112, 1308, 1007, 1008}]}}},
   VertexNormals->CompressedData["
1:eJztyDENgEAURMEfCEJosYALJJAcLRJwQnCCAc7G6YDiqHBAZpuXnX5ep9RE
xNBFtE+vcVv2o5xvo45zzjnnnHPOOeecc84551/P9WfOOeecc84555xzzjnn
nHPOOeecc84555xzzjnnnHPOOeecc84555xzzjnnnHPOOeecc84555xzzjnn
nHPO+W/8BsS3tws=
    "]],
  Axes->True,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  Method->{},
  PlotRange->{{0., 0.9999999285714286}, {0., 0.9999999285714286}, {0., 
   0.9999999285714286}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.653951848866147*^9, 3.653951942251958*^9, {3.6539522073119373`*^9, 
   3.653952230964045*^9}, 3.65395284006618*^9, 
   3.6548088195732117`*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy1fQm0ZUV57vHO3SAiiKKgICrOIF6M4gSI4gAieFUEo4AoM63ABWQIacRg
EKEDuQgIGImNTZRJyE1IgqJBZAx5IeS9xDCHECCGYS2GBfo4b9eu+qu++uv7
a+/T8Hqt7j5n731qV/3zVH99fK/5/b588F7z+++918YfPnSvr+63/96Hbbz9
Vw5tLo2/YDAY27D5u+vGA/d5OBjIP+nPq9w/eKV6Yb/28/jwySefHD7++OPt
t8vh/ufD/RUrVgwvuOCC9ttY++/S4XnnnTc8+uij47hujDPOOGO43377DQ8+
+ODhqaeeOnzooYd+0mu4NYa33HLL8KqrrorDrVq1arh8+fLhI488MnzmmWeG
55xzzvDb3/728Nlnnx1c1jHmZLj21FNPtVO58cYbw3vG2/H23Xff4b/927/1
Hufee+8d7rPPPu63zTd/7Zhjjhlec8017bdLe45z6623tuM064njnHjiicNL
L710pHFuuummdg0OFjKOg83KlSuLcXYPv/zd734XYRvGHEyF395+++3tvJ54
4ok43gknnDC87LLLzPGuu+664WmnnTZ84IEHivEcjN14999/fxxvfn5+ePXV
V5vjPfroo8OTTz55uGzZsuERRxyRjdesc3j44YcPr7zyyojHe+65p33Hgw8+
mOHxc+3nifY3F198cftMM9Z0e3lqeP311w8PPfTQ4W233Ta8++6722U2y2BU
euaZZ0bIT4dZXnHFFcPjjjuunaW731DYgP3Wvf23v/1t+20JXAt/st+0f0bj
2+4Lh7h/xoaXX35582YHA0cf7vYqeOgrYW3NU+0z7n/3t+EN+Z49f3BYCTwf
8et+497RXM9+cwCbiPs2ERAlPwwv/yH8dr/wiJqfkIC7JAAdD4/KtfDoBTDa
l+GFMOJknOCEGsP9aT7jGHvDjNykw8RnwhzcVzf8MAq2fJbta1bCeHuRFTYD
LPVzaj75dU1lc3J/wpt+AGN9QUPaDeZuvzi8BGYXH8UBfp+D+yXW4toB/hwG
2J3Qx8vIr4VmEDTfh3F2tVayvjVY+/D5MMSn+Vo2iA8ntOObP2m9+eVhvN/c
dReioX1UxBQu53sw6M4wF6D0DcPl677/fT5k++nPYKCdyKIaMLwyvN/NbbFR
mTmCpsnszoNBd9BLFkmxUfihm58xbPsJl/rR9vNUIVHcn+b7xv5HzWiNLEVQ
BiEwmImj4hS3D+tWnDsRJigvcN9eGR79daNq3KTd3+ZFwowibNw3YVoEzDnw
1g8iYARv7vbr3L/jlVUsib88F8b7AMFe8/f17eXJiD2Y9YBNW9QJ8sB34TVb
a3zKtN8YXiT4lL8NqChHJlwgVN4HqwBifnMYAFYxEET/2qv9+MepiDXi4Dj3
9xAQNWt8axgcZl4dfE2ymrPgNe+yQLQZWcV414vagc6G4X+PI3oLsora4C+M
g+PcZ8Pgihe2dJen2tGmtEQRUhGwIDWdCUNvgWBBgt+SgGUivGuVH0i/K00e
37A5h8w7CWRk/NnZWTb+WgTFZ8Cb3qJRLAt+l7mWxkbdbbfhiUcd1T6RJN1a
8dN34AVvaj+bkm4rc0nj7ZJKgfqi+AnX8YYwDqrUifikAI4tZqFxfOa23z58
k1+sTeD2p/C+12m4CQ28v7Ig9xr3OvKq9tMCvOA1nAS2MVcygStxf9MbXkwW
czq8a+PwLsUr24WfgY6I74KlxHcplknrQsC9CgGHzNOqkSmClJoeXCeOhusR
i0HBbvswybPPPjuigaGm9sJ1CSj/BF79cosuPgI/1C8XQu/18nbw0+CVL+Or
/RhQSlidf+GY498J8hr3xwnUl8TX4MrWC+Mhh308XHPEnr1DLaomvsVsRtJZ
Ae9NKFYQ/XhYt7CCk0rN33FCQhOV968Xx8e3rs2BKiaqcLd6J1JR7Z0vJVR0
Cry91QrNb5EhxR8Mprcgcowsd7Lr1e1yT4UXrgHLBX+N+WafCNdQKmQzKYHg
ZxcGicYaGmYJCQiGJQQJzS+CXG8+7RyGyg2eZi6e4gQogymYWlDEdBoMLyfD
hJK7oWhxV0WL4S/ORfhjCvgjGCD2XNp3+fkOfhEewiBksKAfe+yxLTnBeldz
pjBmhVzC/1NptqZZJE4lAudbfmotmTW/NGKbVij0vvvuGx5//PFtjM795Nhj
jx3eeeedbwsvQknz++FaaTcnvReYcUrRYbMc0Lbrx08n49yX1gKp7WRD4DUY
Is3KnPT8zW+GDz/88PD8888fHnjgge77oLCohEYk5lVa54l7G6IIBFJR50nH
BPD/LIzcFccVR9DFIl2c8C5wndxv3RIuuuiiwZs4Le1BcIDS1lF04jZuI7TT
fgWhpD/Ol9IVShbv7pRTThkuLHjDaVML8nsRyOuJO9actKwPNfX200n5hLti
1kFoNdQkEH/66adbbK1cudK7yqW3+CV3eUrNNEl4YrakmW4QXoMy5Zv5nLvi
4/7aTEsbBxxwwPCss85qacch59xzz21/e8cddzBTtXnjlwm5oLkla+GGuGFU
JvgrgumKzXvanxoeeeSRw5NOOqmVNe75Qw45ZHjDDTe82qKdfTtoR7iWYaQW
+9gwvlAhpSsp4BcyOTz99NOHF154YTuoSwo4JIohr2yG/TswESiLYoIZirIG
CaghH/9RvpqulISkai655JI2reG+bRRQpdyRdvzm8wEmRnKZ2ayIWfedC2qR
cqJfxtVhKkY6RCKajcBtWXlxcdFNpf3X6QUBysuQutDpYYErobgCW2hNCPMI
KaK1XbPtk/sVEPXzQE4sYyPLczzv+KX523zz/zooyPLWU2QXpNdXCKJkbk5X
iy0iltGopuxGhPxO8Kv6eyA/uWWy+FfDw39z0UVqnlNaCctcma0rU3XD0Km2
7/6Gn+B9ADIQ+IeFqbjoSgBRmMoSrU6z79rQLSI0CkyvIte+7md2L0FmQ56H
+xVE15H76DgnbfC67wE21OBNpBmQeJeFsCOAQ4LRV3HkkyGCxi4sAAO7OKGE
tACaOzidHwV0LtNhXug4MnFJOcRiVRPamGDNh8cGvw5TUzLzmHDZ8JFLZeVJ
x11HSw65oJmcObcWWMf7Gf0rYg9l3rFhTsqHZtyPAUcx0ph1KXNqX7cJmd0f
+jn9b47A44Ceeru0AidkfS0tctdjk/gpIO2fLQL39/MUhLC4zKmQ+GOJticL
YZHP5DXxUwDMP4UX6iitk10t8Y+TFWqh42aUCy3LqGtf/VpCzX/gp/OP4RZ6
gMwa9LNfkmWxYGaZGELjXjwV02hTsxxLVDK42UJaypT6afVzusOMAjXFGRXR
M7b8NLcAtxs5fYuzFEQ5cGHdoQ5znVSXw//JJpmsTlBd8y8eXMcF1snhF5aT
bPmYOKce5pAYfMllDNO61pJaJxN44du0eckYhSmFycrsXk845Gg/z2s4pk8l
4NOeLr5ViwnnBTDlwGbp/jj58PoIMq9tvEnJOGRFBYZdHqFYGIDZQgC579rC
QNglbAco/oxD8XQCxUDtzetN31vNro/9g7Nj2P6an+dVwMAiD9vslzZl0BMt
swoT8VoPS6iY2liydQZ/Y6H4jA4UZ64mmJNpauEpHcWzjLQ3kOke6Sf51xy7
Z5k8YvqPZS5jPEYcHQFOq+eqk23BFhD7l+1/pasbJMBZFjTHWsrKA8s1A0q4
K9Ij+pLBt6JG+RvjjANQLwegQqZAVit+uvv2nXBt9222UdAbya9Kxs20IpUw
eQbpNxGyONyv4DJYAcD7PID1tptuCuAbzfViYrNuF745fvKOzeBii7v+DEhX
5siUSh93DJWWpQ7yeabIdoDkjzmDna+otpnp6rhnYmA7QjUjs0Zd2FvCFNDw
mPeT/gugVJGlEu4UOxJnzMQoWEEoq8QAxhmzBbMZvzV+CvP8oUUEF/gbfqhA
BfI3c9BrnlyYphnxS1iXWh/kpEP9FFdy/K8KlzEZdszcXJfTaTl4aqqFaGCG
Z4Kmj6gMzreg6ckht9WdwDqneQbYe1JNNHGNJkojBW3ayJvFmQWo/hlAFUJD
ntmWFPVvONnM1zH9QbeGqD6YxGLT3JyQgQ+chSrJQqBeTCCLE1bsXnqPpZYI
35mmk4UyO/ptEcSH+Bl/V1ODrPISJbqQa2XemVeUzOrE9FOFHFXzRoCzebs/
zrKWSjiEuQ+qhjK90mEfDkP1tKyEOVJuJQ1DJsEwFtwTiMpSc0L0CnNupmFx
N998c5hJuYDNI+wD+ZwRyIfXmwshTcLc3/2Wt4BLzx1Tw0BnkQG03gIa6MwT
GQUk/CmSETqLfxl+jTUS47CAXIIUGtAMHpYW6nSU+gYNzZKF+P0Jg9MI3zZ/
/5pQjjZ6E5PWPV0WOEMtWTOcccap5HKZn/upmoMF9FcSDsY3f33HHbPZM1PO
TKqMKZB3289vJ9cO8kv4NoAf5PzfVcAvsqZZRC8ZOYb1ECF0AlKnlyUtK0Bl
EFbwLUJAzWNXWSgQMRNwAIzZKTIRFejgdlnalic2G+knrOWbFkH9zMRHbk01
i6qZjBXPW6SBFbuNa2in9w7CHj4lGnKvBUP/3GSJ3MhqVpBSFD3c8rodtGia
uu+Inw708/56mLfSANeEebuKrRzyOZ7D3Cnb4rXcUzPCnP0t9t+LnwL4lyvw
h2X8MizDKcXcLy/NMreMmh8vPMzs5PC/GXk3liG10UhPfkPZwEe8eVbgWiCq
PG6XR8H0qiyNoOOhTFHzOuqOpbWffAXE4BiLyVkeXsjPjZyl2yE1NCnry/RH
Xxdb1jWSv8Dw5UsG4q2iQlBdk70RCq83KjmRSkKWZCiVpe611VbZMrRFnJZt
xntGckESOgN9elE4ctmh8TgrO/wHoAEBiR1wmYhgUVIew2/a5lsEz910bBg4
0u6cfREco1UyNhZYbQe5Wcz4D4GE0BttVsjwqWGTidtCCpuxfzMhawJI9pYg
p/iitLhTp2/FZNdzRsXk/wqX0QVuoMTQjFTlgjpzJMmlQFQAmZU+T8O4Nbcs
UdM+OYi6KjHHez63aYCFUvJtDly0OkufIEHoEJEyTkz7i9Vh9/VXhYrQevxS
DqKu2s/xns+lfK7yJ1sgDWaKPLcyKlEAOx85SlO2fmXqySNlTCVdc1stmXe2
VZy3Yq9+Babdz23C2ast5zAMVQzYBUXVSwcXxiMr2NGxfgsw746AURTTVa06
3vO5jZBiUD7/n/BwGchitrBfSZ71KArQkwBOSX/gyyRs8l82M2CgeQ+59sUc
SF2VsOM9n5O9zop6fh0eZREyFsmXRbnkQB8lzixdFGLTZAzDB39PRPPeOYi6
ymsnej63YbiGts8YAonV/DMfUBaDGRSuypWeqjnEfZ3690YwBUoSA7Favmve
TrXmzFtob0hrhSI4MJbkcc4ODWB66e/cy8vLzToDBQwuyjjyeyIGfg82L/+t
NXNZn/PUXYRc7CLsnPYbyHRWTTLtVHqPzDafKkqIA4TeH5EZQCI7n7F2mPWm
kapnZdDca5GEYn8WPg1gGDAzul49KjfKwidujCtgtOvfOswcRfIeHia7A7oh
699WMTMnh8U3ZHFdhZ7BGShiw1jb0je4sXX8tKdfyGcJ3TYI/M+w9DJgXzgo
tXw7ZmMtrxjtVxXMt/eQ8NVtEz8FNH3aklj/ZRJl4V0kOpMHZFUkdKnjyYhv
qJ8pUc0XtC2hQL9tbjDHBc6D4RdYu89ihDUzTyf4cB9hlkTVrIp7Zph0M5fY
fvqCX9guYQWoen8TrpnGKC6p5k3KktK+QlZGWUbfw/eR4hEMeX7b5mAniy5l
oV1RRL1WIhibpQ7yDCaiRtfXMgVhAGG6uuB2VYFGd+Q0+ggwX06H3MZWltEI
mc9aaSKuToaesZb2gbi0gMGPJgxOZLHguL4UC8oEJbeRFQmreoXaRidG5fly
m9/OhDUHvz7+cYHrDxIy9eot9miAbNwgJV4eDssUGVrhkcyaK6K6wJfpWp6L
M/auMZA2j87Ao7VQRsKq7/43+DAsODwIZez/4z9VmcO0SlD0O6ptVguWiozK
wspCxxPuwWkFXcvT3i7OevdyacFqifvZoLnb4KH235kskElYxa6p8st2CHVp
Dgkx6IVZhdVF7EWEV98Qw3awJuHe3RAEk/FxecQFLB8Ly8bIJAmLsA04Wvao
5Ccjd3YNy/tGiBukbmNhlb6ry5Tujyg0/WgAgi6bmmu30nhRjEpDb4NCDhUA
qRUzaVsrBMcaMhYEgJWjF/chAg3fdyIWZ3Ulfnwrt2lsXCmqOBZLPUIoA6kD
42vg5dZTssxeV8HL6TjgNBlwseLefiiShLfuffXf85YXSh38JJqCvIYWjNCQ
tlLQ+irL3HgW2K6WLCz2aTL0qCGC7eMid0UYPq/JpCnyXgbS/w7XWGDOsuXy
Crx6Cpo5njjuNBmXOT0dgQXs+CT86tttDqQ8+flKPzHIys56hGyr7NBIzGS6
WQWYqWxMeINcYKNmlVLAySNHJj4SP30mB+DzlZwSYCGu0FoQAD4QrhVxAhrv
yyqXyxx6rXRAwJh42TT2mWxlQPwoWeOncnA+X4ksxtWpTWYLRLZdQkcFw8pq
EReEodazggKEoRp61IhLcoMUJz9fmS4GudQm9f5wt9aBJ22G71+aaZQvoGLJ
oo3G0KOGez4WPyk6fL7SY6kDZOqjKqE+HrJn4s9wnu24S1HroIP4SaPwLZij
BpV2IKz9yRykz1cyTQgUVU0C7n+YBFpIRWsnWPhuRnoCxKV+XRs/9d1Cpscp
gTDd+yzwYWr+PJeD9flKwE0SsKauuZJTKCshi20y40HZaLJi/NonNB2GtSNL
JUi74mY7kLX6KGi03FcvYccajKcGu3eHu2UdZvJFFBANYsm0Dat609qmstuK
lb50hud2INcCBP12rdETegx2qaPvXUCA2cwxVCfsl2xGzfoZs7HaDLKZyo6D
cS/bBNqOcTUBVFLw15XoY5Z0am57Z7jbKzDJytmNrgvoMGogFePaTU8LP3sG
gF8LFu5IrvnenzGEigB5cQTI7eGu0wG50dEr3K1LJeZIcUADjyIMhUPa209M
51kuDUEXFuBo17czAKG9kNry/nv4odMieulKIJthcGpv5YUVo5aQ4hji5M6o
ca344sfj4hTyUXonCIhXLwaA0uaFRq4FyctctllKwTS9NiwUXxWOar/4404W
jDhkUi/lfw2QEbuzYudkkClpmO1CLUop+m6CEzJN4bcZMqARkkx5vZ1yECB0
Um9f334pj7WTuZixdmi/Ua+bYAqW6e5pAiQr2YsMgjD4BFmyl500Np9aAf5L
gAZp8oSTtEPwrO0HL7moBROVbmbBr2ljaCuY+Im4xo/bgEiNeKW6VYfoERhQ
HVFG5ru7WLICjdwKLvRvYogBTyuPEArcJa4VKaO9kIrMbm1vTVnNrMa0GZ5H
kXv1vhylTmWO1HNiZQQdmkeePklY5GM5ZSD5JJC0bcn0+kL4BrWEBgUSKuxK
YJ66Km5hIQ/Dmh81/pbOTNqBr92lm9PBS9IDjSUWEEeaLZINVcowK/4j01Zb
3O2aTGKn10JpDBxzBPMfzbjDZevzpmWJMm4Jv671CWMmFUKHRV5qOQLcNo+a
Q4OmsM5HjYvNxU+BSz5A5Gdql3kzoZSaQ6Akfi28yhwsVo+iqSJlvMwAz6gx
rk/FTx+1gbJRfOgmQiBlpB7kCYKCCTYlU6YAChYBIBQ0sVWAL3vmjFjUp4k0
/TCApF1+anZ7Qwd19IkZ10KdSirawffuSk675QRrq1QHUMobJUpBUZMAdL1F
KdSuqMeCS+GXjyFiI1TEpNWgOxikcCVLZjKVGfxIMPmwDZPUoPRX4a4LEOTK
NcdizyAuqWO07Sp3TSqGxBhncsjW6qbvVwePurZ9Dihkt9Q/VbZBY8PmIjAm
8sGDY9qSBVyX5oFZD0uhEF1QxWiFS1gVFFrivkyQlSa6qYAj7Vv7pQWO5pVh
R5pAxGb2wpTVlbhF7ZEIBCMSbcdEim1jfaNjnyHXvPMb62CRljYl3CbnuWAX
a3RWoW1eZpow5aRUOrNEakVMEDQzK/2Q/kTszSjADo3g2WcigXzIhtHrCYyk
dUXZWrtuvvWIr7LkR62UyW7uwaeCnoSIrL5Bt3Swq6Ip1vkSr0lDU9Xvu8Zr
KvVRC7+iOGLhhqx2qdxaCm8poOMFY8n9RuDpswRoH7BB9UZy7acBVEYbciZI
LfvFqozMIjilUpqHnivMdmAqhPmnI9QQfjYS1nY2tN5ErklXoqJF+oBH71FK
2FWgRoaslEEBVKZ3VtQK55Hd/tG83QhhbZuDCm+9mQzxtyCzGKhEGLCeLlrx
J5Xds81gnyottlfMjor3D/vtFokrsKIcVll0ZlQ/bLsJGw3OJhWUGERmjfN3
zFxQn+YttfpkEh/RYpWFPD4XP21rA2gzAiDfkm3KipBmNiNKBrPzspE3s/28
eqVVraJZwYpZLwxWcuAbctvWALX2obcRWP1V+++02Xy/MUNpzr4aRu2/01tX
AC1AXNGsbtbsz/xsE0hpK2AiKAQIA5I0KOwbXCzlUa8gq7nbe1JBKYxlVzIT
xh414Pj5+GlrG1hbkGtXUIFe6hpbLBWbe9Qmy1oy2I0mDWEEPkVmzODnWuDR
BJGSR+/PgYX8yJob/oRQlh2MtJrCs/hjAN0gsylLm4Lp/3GURtb5hGa1iRgl
RrjpCxF8AVRbEyhKwwYEn9Qy1kKUudHZGbkuje7SBRxH7zLvBs8QxPl5NeKW
exAQvLcbYnhNqpC7TqAs3I48AlN3hBZ5unFORf2lJmdK/TwMbRbMmUZJH/C1
ZPY+AFrqRKhAJf1/WQtaiZwkg30iayM9W2/kZawUE9SsYGdKI0X7DIXWq/dE
s0G1Z4RMRl8TKKjc/+8gcLsoXMMqQSNVzioLMm40NLkKObHW4lrpuSQ+i4Vq
EJa6sB4LZSE/xqfvzkjObRPz90XqM0j+2IIkkza1SEotuI5+prbcE1MVdUPJ
DxIoGaWetXJ3M2iaWPU9uXzDre/vIiD7UbhWlFmWXNdHkikGRUdzSl1DWCEO
BFYDFvgyA661Jp5Lwj22N/uLBJhblSDMb+UgvDBcK6sP66mtmqBTjFrCLNcS
tQqlpJlYmwNtoSiBswTmWgtOJ/kX+Pb9BFDvIddWhWtl/eJMRhUEkGwjnR2G
ZgEiXrrEwq618l8NOpR2wC5W5HWvCLqtbNCxfkrtqRxW4eOSghYYZyAIWaWX
FWZUGGDhIHVMSC4ZzBJhJPRa6Brtf8bC78xBiY+/j4BSdkLRSsmZgkoUGFQv
CQpP89y4UgqUsMukgZlAwpGKjvH6lIECgC0FvssGG6PKH/gf2qJOmzGulqVn
TVlYTZ99ZaXFw8vudKHAnMoniSk0o+C8aEe39ybXfs8G4tYEiP7sorzTJuFV
vVgXVNIJMoQj0CfCkcjUAbO8GRy1Jkcqn1HXciKshd2+RGCiQIiczQKYrUmu
AnCKRzOTnxWy5SGVWiunztoDFvtQR9Do2uc8hDMDc0A5kLfl/3L8FMDFJBsr
Wfpe+289tsvaR2ZbtmFu1JTWMDNkaK1iQNUGstLpWug32w/EKG8fQl5b2qBM
FbTfI/SGNGdVG3XIOGZc9PHqwj2sD9NFg4jGQjcwCz1HbQV+cEKEh1pKuref
zg2Q7BX3pZVyKACzvgCapDJwFmlmBI8UEeqaygXIQdUKEUtJySG0b/yk6Io3
Ezkn3B0l7JsFoKpyq9xcyJQBCwLqVAJPS3UkKPrHhPcjfPl2G36pkcjZhNa6
IsF5VGqSHm5me75c5ulCcSw/wD5cOiycUarp6q5GwHi/CKLZHI5FRWf7kHle
6ViyXI3YlBn8qXm9yjQO1DQbDj4a5C29eApUrEqV4ViNoPH+BDQ+R0O9sNSf
4Uz3ie1pqDaZ6HfUp2HVocRm2SvpEdaZ0SpE/urGjPeP4Hi7DbPUhUEO7z37
7LMLcYHc2See0pc7aw14EA5G17HaLtAJ8smOJo8jEGlYJfEtUmDa1tN+WoAf
as5iPMoC4iNwZy34XgaUi+q/2k5SO/Liy0ucVaO4xIwpMzbePCdJVCIJnHIU
t1MiuQI1OJgH1Gp1gYqL2TazJAMlCI/0pisEC9JXYrAo+JZZmgHlxMdvs4GW
duqeBhpDA42GkactJyrJJjO+l4Va0OYWUCFtaVAVFJ5JOsRWkdKThZlAO4DA
aLMcfMXG3hZ8/pj6op9pLbTSFZtaXF40eGZ13aI1DKO7ZyFh6Z2YdoARaF4a
ZsFi9AdFOAUGZoHkneNDpwZg0q6pnVFlI/NWxviwWovF3/M9FWaBYS34wvBu
WOC1QD2S44ERTJvZsEybR6WRVkevUkaoWgygGl3gZ98xu5lF6vOh+5UjZtqr
vjcbbbcl6hVWEPogwt9vsSGcdmaeHCCM4T+yVkOh16Ja6DFOepEF9a4Ge9pZ
+I4+fMXUdGQ1Sk4Qs1VotuB5K8KwSKcnMLYHg1bVdPXcL538QHE5YuGw8ndK
0eiJT46yE77umUXyMmyxf3D/4AgiJEfMqAu5JmD+MeF6pEtFKxbx5Q5Xztar
VWJsgHqCgFV4WpeFIE8LkiNMjZh/C5NlhIvfnDM45trTLqb2mFcSLESzph5t
1cw7YskxkddFNaTi2aLW3yzg7gzvfyV+ItAS0ku7df4o3LWa21ohsMXly4tr
uFAVDKx1B6pxLtNCHZWlOEOE7+LyfNdOSfAcoF8l8PO7TULNTE6jaf/FN8Jd
q8mtBiO6I3bELK/ty2LuzMWrFTArsY2sK+Wo9TTTIC+941GPDsi2n95kwzNt
Ofg6IVUdu0DYYW7bsDIRzBIkNGmys9RZiWstCrXJI14UE4Wzaft5yRYcmofE
T0idalfC8YQmbYt4hLBanbW5E6jcvFo5JtK8zktBxHye91+r1c7pfi6B9g4l
XP/6nEpR6ycIt0dEM5PQZunCZa8xtKK9zlJpDBvVilsRfTES3BkTxzd2xMQP
jSB6gw3HtN3huHC3PPYnX1OtcrMWeatytpBkZ511EUKCkV1tE9u4B7xdSsp6
g4EeYD6MQHXTHODF2UstwP8g3GUBNGUkP4fwnCkJSkpijYp41wkZNNXQmv6W
3aCTY6NkqTrkW1AGQcGKF/eIDx0D6kw0qAZs5tvU4lL18jMqLEqayuWVVl/z
saNxUWsrMK/6C92UbTcC6Y7cJ+myqQ38VDV5dLiLJ78brQmYKaqBrxeOQ2Sy
ZMB29pBchd09wyzeLe3Zboq2fGp0T1jgVbTj5eEYLPftdQD3FsZSJ4iS6Egg
+gDfgujD9ZEJe8BKTknexGwzEfNzvLDX3O/R41qZnsK70xackzM3SGdyhap8
hPeAV2jitSOA4jXkleW5OlTthnAGGjPkkI9RpBvpeKtWWLuhufg2iTi5zYO8
QYGZVkjRsEEKMlzenpcrNyrAZyWK8+2/E1mARwCdefQKE7Xg+ICXqaN+1Nfm
jICRuZNQiBWqEit2Sr2xCPMYMxQgwPa3UDBpoQAR+CUy4mEBBbTkuJx5mCHt
cR2erW3HRqVpxGvN7eyjVCpnY01mSVuRg0G4NLeWWtCWwrzL06FagxbGMxra
bEvLPmTEoI5LYSqz0gnAWdXWM5cR3J0rM0JG1Xe9hTSTJViVBIRc5HVFDJpB
u9rBfaXUmEQUSF9Ef/iCAvprbXzsS4b3QSy7L28Q3WzPVS1sj/UHdtS5pIB0
jzu5tSQdokbmmAkYxOe0mugCJEXkOSspsmcFJS8iUuc1gJKWZ/Yng7YavWfp
tIh3S/EFapSsM0Ss63XnpYQv3SUlWFiVXgb0wpxR71miMBqB3kLqCxVQr9MB
aqY5BiQnMyhPCFxoaw3njPpq0pEkpQcYr2tzKktccbe4lv4zPFiRdKzCXbkX
S+KclxA5mKVb/JmaU9KlVmNhPQLVChJYYcZBhPIFFDqbxVRqgYxBHgI0G1GV
hcwGsdf2vkwpqIc3M/miE7ERE0rY/frqqxP8d1Xwd7B30AvwT620leBHrjiw
golaObiWL1ZiYg4ilspJ7kiUmZtvbWOSlwyIOYA19zNqmlrtiuU7Q8YNeABR
9KkgKwgiBhv2wcJBBAsilGqF5pqu9bVSJxsNWiqheEAJJ3PDVsViaqnln4nC
ZYb/SOCtTesc3rtU4L2Rhvc7AxzR3FlG4N3WcTI3VKvAWdIuKfxf2/vfJ+NW
0wxKlCvHotyshBzIDm+QgH3GckZmY6cKwDch8H2NDfqvEPIXb4DF7cuMHG9c
pYx4FoETTNjFyFbFumIlVrCA0iMU4BRt+aJrZZAIq3Aeq2MmHUEWYCpo2ZTA
eRNAS5anZq5ZOQmW2mONf0cvAUdJL2KbCSZIg6ChW8uaChu4+tLM48J5sKJU
WVMyWTuyKB/RqJD4wxs7UFHWTAmTIF4kQFHG/kkZvt3lpn+naqNvhBZ98/nW
LeRXFqrWzbwiXso3sZ/bknKkxGLaz6VwJSf4oWbI2aZsc8KwJRE97NlRK/h/
PmLZha4w9jIiqgTZKcodDujz9AOlhKWxrMVhSTwcT/icSJGuXM02FsI270DY
IK/5OpTgai/grNzJKtQKC0/lamX0EHhuR/FQFhp8mi2S5sjdyAZ3Ite0JT0r
m187goe8PKALV++zcPX2eCMYCKxF1Ty5tme4hh1IVqfw3qiZUAyJKl/nJ1DF
IN1b9Uy5BgEv08m9WnaIMU4XMzEp3r6cZSzebWHpHX2wdDi59oWgzGizk95F
/UqG9Qika/pkNIvMYpSvMGbRO1NwaIaV5DFJ4t+QBmaa9J0WWljYdhNAUPub
I8lDnw9oMRqnkBBTCf96eHdOBd2F9njTlYwtSr2X5JKQM9S0U7LviBd0VBpk
mEAtsqWFCbZZADEx4PlrfDzULJVElWX2UC41gqgrxpsnj3KlwZQL2yU5ax+l
F5UGAXVIItUsMaMqjJneQmdmqm8LCzVbE456tY2arxHU+KjmtNnrBX15JZSC
hTSbtnQxFKC6sLOtnC8MHyWZZogBKdez+3fwALPZfMLEh3SnLpKB7FwQhQ+8
dRTBx24BH7XsR22XgzgaadW8bBo1RLWXFueMWp8tQzDhNh/ZE1HILe4cqwRt
aBSDfwJ6vD/DsyQfIpgMyGGdG48h13YNw9tZkumMWGV5Oim4OsF7lr6NUrLC
J9Ro6qhaLZGUia/CT8i2/6CBIEF9hS6owea4SsGFTWwMHUuufYawD2KB6XPN
Fta1ua7gfn5kDePWkViFiyvUV3rHltF7SMdIHZ6WwjXX6mAo3g1UCHLc7EBx
kyqS209yllTfpIq1s4OF/bPScBb6qdUj1tKJhslUa4bEsJFJLTXnJWS9ZrYd
gGymHXei2FBiLuHlU+GulWbJcAC9VXrlA3RcJuDE2n6deULdZwrlDGDszTH3
jwkxLUB5gyAGkSCj5imYjRQSVO5xFyKJXm2j4w/juHIobLFhpwC9Fl6oGmpJ
gSyrawh9Vta7mEVL6tvMlLjRmEApBKl2nv7FOWTp3w2DSGJJGXYQ2cY5/PHW
8jjoLnDXElMa6lnkuVQFtaQAK/8XZV1LGNi+iblFDWcqPODykjI0a9HJUsK1
tLyi+PUrGGJHClUwdHzE0M7hLsvPYM6P7ek3Nv7N9qlYHzVzY+bSqofA6III
NAx1SsfpuY48sqYTPKQIMbVeBVNy5gwKrIApdhrBCRFTO4Es0xkbDKdolMzj
mWO1WLOpQZ5DOmdxeZZmQ8rnDTFDeWmGMSmj0XlnhR1tXljYWSeCdJAnOfeI
N15tI+Qb8aGPg67Ps2IFAXXEZmqJ5XoGQJDeM2WjsmvIInavTX9NEJN8RZZ7
zizlrBbASJ2trZEhsZcvUmS0F06Mn3ZQ+p1VRlSJuEw/GT2MaiVBXekXMet0
U8VKk04sd59SMwpItE5Oq6f+u/Mta1gY+TLFiBJlCTcfA/aoK2Fji6RZSdcd
1g//s0MJdCxtHjo1Im3UeETeHvdXsqmmPA2zwFXfuB54mbHwIs0zUUptbGPo
m3Ecf3I13xNS4RRZIEWSpZWM5DFLvEwRcNkJs0pn0jAtkVy1Nn7snaMVB3Qj
cNJCIOsktFGOQLz1x3Ecf8x2Ho1RcqvEUqaqJDMPffaK2uMFkhiYq+VoBvY5
Mxp3hmuDdmDc3cmL3crEc1deM5Sql4BN8RmFIFZlFhA0S5jvW3GctlGtIbPM
vcfZDZx4cDhJQoAJtgh66ClYPaC4NK6zvBmqJDvmxpOajF0Yq+FzkGqejJAP
GEkpAanAQAlXQc3JETUfDLyDiRlhj8wWYJhgHlItQ4DrMhM3LMCrQw8KbYWI
tjJqoWi8b21GrbaG4a1QnGJ3Fymcwzvw1T50SvzUdmCfUJBNhgCrDM9L4Vm7
W7WRQllpWhWkYEDN+qufjcjgjW2h+/JOrSeA4SaEsNDlbAPvkRHOG+csg9hJ
yJDDiYug81iK0bOjFewMWS0VoGl8NqsyUsrMrP7vs8eLQZ1hp5DFBnYKZVOr
BW2eX9FA59jm/v6thdwAmm3PO4LjajIr9nR/XA7h2/FhOTyDBaTR6NL8pIGq
JRpKLxa9Y03ldWeuRUzu9N8hqfcR8PINvX8ycwnMUAfzBOBV04ir9vOfB5zm
SQVWpKG0Emi0gZSBAhrBiJAzUfrmehBdOpU9TxrxdWUcaimgedWjmYXLGT4L
gWj2vJow8JlpwhKf4bbH51IdDGgfIaiUqbN86tcU4ty3V3mcbhBuPfnkk8PH
H3+8/bbE//Cxxx5bEhjVYdf9GJN9K+Lw0p+/K3NkYpQ17NASqZLNMJJLLDkn
iK4zpz15s7U32+uZRZTKuMxM4Es0kJblSI0/HRGrL2//m2qxesYZZwz322+/
4cHNK0499dThQw895IX00uF55503PProo+Ow99133/D4448f7rvvvu1Pjj32
2OGdd945TUTC6XEaUgTmUsVZcdoYsKF3ugC/CAjaJ2CxZ87E7ACR862Z4dKD
8O10iHV5/RRBuVhWOtySIltTrdx1+N2pubdN0GPNtaXPBdVLh6tWrRoub970
yCOPDJ955pnhOeec0yLr2WefbZ+/5ZZbhldddVVwFBtCcMUqv/nN8OGHHx6e
f/75wwMPPNB9b+YnL12In6T31YlHHRVR3LUTRoe9BKqrn32ppchqmWJWKmGW
8JtNCsQLdVTgYBDWwYL9HgwzEdGOoZ20XuHvi9ZbChB0G76GmR8vKEdDKqB8
/XDrqaeearn6xhtvjFEbh37Hvk5CS6DggQceGB5++OHDuxpFPwa/dSi/6KKL
PMrVqxLypUcIFp8iq2RJzwnErYr61tI4DLdlGKj2VK0Uo8B2FlG190GlRbs5
hg3hMcw4yRBMrdGlAK4M00qoJqdmoxzT9957b8v7DXYH4p8ec8wxw2uuuSZp
7ObaKaecMlxYWAhau8TqGfEFsiXESZuwSCsDVEOnGVytJYbGuqihVlmglT0a
x2YrRxYIQRQ7ET4vXY2Crji+ua6Qq3OB7psu0bFSdyZub7311ha3jdCOPzzx
xBOHl17qj3Of8D9s5LiQzNNPP93y/cqVKyPvomb4TnyVlJY6y0xjWRlRHXk+
LVq7s089FLhhz2lnC02sPv0k54x97ZJ2cmx7fJDDwra1Qjh5VxW16poS1Tfd
dFMrlhssDrBdSoPC8G3Y5kmcWD7ggAOGZ511Viu2HeOfe+657W/vuOMOhu0z
I7a3DPQi3lbAuJHv7ptVLPhcONGkmO6EoxkVxBDmFEEryz6yDcdB4q9otbFw
sDO2mh8thXeJzFqiFxl2Gdtiuo7v22+/vUXSE088EfF9wgknDC+77LLE1M0K
jzzyyOFJJ53UWtru+UMOOWR4ww03TJE3nB3x7P3wF0Z/CzQzY7MSm4ZoLcL6
qVF2rhgWefQjY9/cOMDIZG5R8Sa7SFMa51GIefxORodpRXAvFozONFN6ffIG
1kS6AS5LtBxJrr0yx70zwdzt+++/P+J+fn5+eHUgKUkMnH766cMLL2wPZB8+
+uijrWxgrtZ3I+L9uVprZVlP9D4cJJXVjAg2JH9HqsCs5ZTLioUlvIYoLnKk
qXhGfWoe/spWW4niHbQoNmRGrYjDKqxpsDpYTbQ6R8pZ0VdeeWWUCvfcc0/7
kwcffDDaW5dccsnw5JP9SSlil6ENdg655vfu5tlQ1aKoyzpTwMmQWnpFneeL
RKbNij4wX4q4FWNoiowiaHIa10lg5/YGFEcXmmkKViSSR1R4CLsrl30kgX9A
tYRNrr/++uGhhx46vO2224Z33313K7lPO+00kcqNv9XaX4uLi05btP86N1re
wPqhnUuu+eNiypNLVJskA2Os5QFr7ldLUKAaReOWWVY6J47vYPXsoIK9iN4m
GNViiDIE57phxFj3CPhvxWnQ2a8I8viKK64YHnfcccNly5YNzzzzTGeLRfPa
2WJORzd/m2/+X0cZNZSfR669JTC6Tt1iSya2h0vnLhZUhsrKRi2o7HrmFTEC
yE4yRQvJVJ5jwX5GLaxF8l5bbZV+b+ea6m1oBzyaPDK+NwSBLg+xPnnfI/hr
j4URIGNDp3GFDAg7EJNIo0o5q3N5sXaGSDPVPpGKgVIURIRu1KVWgK3BUGQ6
I1LK6MisD1P4DTMsAVpg523hIbSAvk9+KL1kSEZ3Lu2PYLxRzItdK3Lsueis
VoMtLsckKQ9VhJjyTh43bdw/jc7lXoOiRAFJv7OCCrNPQqoYM5GhYP9KGy3n
kyHeEK5Z5/ZkM6RbWRZIzRa7hnoM9Y5RW2/mA81QMPgYUy2SZoOEK3A5lVne
gC+zW0JK8Be9tTJ8qWuTFuZYgmBDwFzLYT8gP5TuWC57o98cDrEuZqMztEwp
WddyS6XXxuI8dDDZTkuJpnBvuogMbxNc/yj/OvJ7ds2K7CE3E/dmId9I1Uer
g1z1OEPz62AIbTA5lMh55bWkO/ruxr5/o5iZxfmMDcr5C8x0K7g3kzEb/rmU
TKvmnxkirJI+3ToAxyubDTCTRmvTMILEHFi67yiCwQrCV5JrrwH1mFc++Flm
CB8LLKnys7WYAHM3jdBCdcebWf7QkbYdCwy/Iih4LGrJ38A0I88Uo7TubBlh
CpIOK+o54h1lwAXkcWlCWdvZE/xLfVllZlX0neVrhFlrHai6M7r1U0mzHL67
4UwlqX0JLmXHNmIxuFjiGA0uq/WE6bVMVdZW629wVPwUrCvp3YbW1SqC3VeH
a4vLVTE8TMzt7BhhI53GIRPGtT3XPTfglWp1rQLtgh9Jq0rM/vicryeMNxqW
uH8j+EZ4DEQWb2BGIAskyo+eM4ovJCjeKFyTCEHMmqr4e7OKjpTdDJt0iZvR
0JpJgw7hnWMY3R2phvhzsBPg57WeGYZTJYVSgtzsMqd4vSczMInU4bBjIllb
ng0Bv+1DPyJYfRWIZY1VBABgNde6hnsyAsOOIqzZPbTWpEwteET1RG6tGXmh
ZjQe1WVlWOp2DW6eawTSNPoEy+FlqEg3yFkUEfcj8rjH+LTefEawU9BjRzLV
PB9UWc61DKu/twa7l0lX0J+D2qb0jq7mmLGVTKxbtMQN9ZngjvIxsS5O4v8f
tJWMyrecaTQo8qtveOo2h9VlBUrPPWvqy0XtGGJylu9Mn1JvyNgnd+EQWWJL
6NMXsAoCKykEWa4gcPWQhbd+TJD1CsJjiDAs+hNkxWu1fU8IrVrHFAVBkX4S
UN0mBO2i9LMPHeQpUQEx8g2mSbEzhwRcNC+5b0vVuvCa+x5QNBgngGc1hgFP
mxGcXEyu+ZTZZNFVyys4cI1RJtRSV0UhZa04HIEI4bqJGFMNN3U0fXE55qFr
RSWY8cTnQhAKTolZqkZB3hGEuQoiln5uEQG9bCj4LyHXXhausQ0WZbwmZ/Zx
hC7Y4QLJ2bRZE+GGxtls4oIUYvNPIDRZ3RxLN7I0T1fFj+66wfQM0pQu6rIq
AgyUTETwh81oDCsvNZhiQQpThNix7U5CR207JoJQkOqgH+QSFkzwilYkaJYF
nCYo19fSc0VQQTcPioWzbXSJtXIyCm1YR1Ilm6Df2eAy8njby6aWSkBY9N03
yn6LUmdFUBBzMXgA8gezgyzDpxlgFjqaU5WeTIwAf/10kMVMc4whRtBCfG4Y
EUXyE/L4uuEaZhu6gvHC4DWkCXLTcxOZfNrf1WyvyGtZ5V1d/QFEhBqJPy3H
EGXK/GPVLgFt1lnnLPyQWdtZbIqlwhElYgkgVl+RYxBvXU4wKInyIl6eyTU3
XZ0wKTLjSsiA/h6XUs3WOdFFLXO1xJ99QHenYxNAXoSCco81x4Wgr4wTFmm7
7mqWggNYMmhEHF5BcLg2GA06iojWi+YuVyNgJ4NyqSWIFJG4rLXQDFtjkLuR
1bpSo1EU94WNDtK6SqL8SYmrgGn20zBq3OCFbyNoRtLsRDNeC2h+K0HpIrkm
x2yWqQDWrTBdc2iu5vf8o8sQ0zU/mFUUG/kic6OOIDmcQlHeq58eZkbwJwyU
BWyregvDFCgDAnaxVaZ1TMS3ducGNrr/ilx7IXC1UCTOWriL1ZE2KPePLtUY
LJKrIeHWHYHq1YcsZ/laF0Uz1lzb5mvlYPGnGXqxdwKrCOhrJdbIoPjtRET5
0RT57YUrCcrXBA7P0CuZcQKy5gEH1LVYtisar5+DbKqSnSyfJ5gqopsyqc4k
oMmgkmjQDFoImFpyvxywu1yK9TqxE8pWPYhZ2AMZKZ5A4qSghMWV8SF/zLVx
5Iyx92et7LLQg6YBgrPaztrO3X+rkyvsKAPo7mVil3l0dFq3+j2gUcq2RGvv
gk2GCYcuIdJJMgMWR6XE8zfxh0vb7zMx50gkdOLs1mOUcEr72cUedmq8NCxk
7JOBYsLezH71SkjWOrH0kCEavaRMJNMaNYQzwmBao0s21QgDn6sRhhxYgY7B
y3PCwFt/G38YOoGUkIc3C1WIrpDc4LLkAyrsmlkuajCMtKOU3RPpw8rNtP2B
5WZyj5WPZPc6rUugBfy1VApV/YXVKiCrIFzOdUQhcVX8od9/tm6WdlFuWHvN
IXuv5vNOieVjPyFRJjlOzGSYcucYLfTKeJLgVuc+crMnQM05tE9+LDE9h5Ef
UwJZmA63Z8JtfbJNQKEgG2V7Bdk/jcieCjaDOlBIjqsRRnbW/17JX8wYWXCt
/MPSm7eP4JaFNkZWR/ko4j4mJ3jRgdkJoJQyHfEeLcnnQ/ti1vmAdc6HKKuZ
3D4mouQVgLf2wtXx00RQ0siauJN9G2+vYVXv3PbYAT+FUzVaMp6oXNPoE+hm
nlhRUFirK7C38xeCYcrCq2g+wRPKR1bwb5wBvnR1cKTYLmHLp1unh3/Z3MU8
viQlUW5hZBSvyd6iIKogH8fi1wxpbnkS0641jJzbvtyqjQTE9vdNW/jT+EAp
lmWBFEE8Hwj4efvvVGze6f7fN0QwVuQGW5YGHeT1DRozGs46AyfjJf1RzzHg
c3JtPu6H5TkhpBI7IWd3wQhiujhnyF3TRQRzsY5qHNExYPvrWE2cUj/4+C8A
aw47PiW+SBIIGsjumsQPWcyFmQFmzMV4DgmjLBBAEinPgEBi0dcW4GwhvGZX
QnUDnlXZ+M3qfpuiwsnfK3aJgFc0zTIBiBZ9ACmCzN46F4Fc5ENzMW53spf5
mac9FAcICbGwk7XsqqbuHaXPA+DZPhu2nUo/h0fwynNMCeA19hwqBp3sZPyA
ggjnjJyhqzOQqNAyksQgO2tLV2wktExHfoBG2vH8E2YDI0pavXGNhQixeKHE
KFoMmZMhD6KJvwguUnIzeXtnfM7eu5j/1tQJrDCKHRsxbT2sudAlfmraQa6l
MpqJ4flHHTU85bDDpBbD7AHM8lmKZ/CW8IywmEOVsV8Fgs7lOef4bIM0HaxF
fDGfpXyuelBHGRWgqocfalMzhdXzujgNEYfz0OU24efibgruHJCPPugg6ezK
mkylaqiX90eaK63SER9EWmkCsqehg5VyAIvsokivjn5FymGcsIbRQUB0XMol
9Sl2V2+e1m8W0airQcLz2nAObw4LaFA5mIzIdIh1U3BImCFaycQoot1jdBox
mrGVB7ab/5r6esaKeF3hVHlhHaFA+nS9uZwaqSPFTKJIrA+6/IghXSbAyn2E
W7t7F5GJ+Cm2mA1s2yK9vbo0opOVaa3fheL1CxST1fb+jFGwsArZkkSCqOVj
9R6hhLAG4xqrORVU2oIGiZsa5se4oZlrYAShka7vRaSPJWtCYTwPDzoM79bA
UbAsyhq9giUR6axzQ0D6m8gtbwlNZkiXyRgx+urlyQzlAl+GcwKz55AxHCfY
LUlC7yOtHXjRcdSvORN+Go2/hsfPdAwjqvn4BjE7NuCUpusH77nncM+5OREN
6KGsQTTxEYTRX9ZFDlpx91fT6rLqXFbbcNZnM5qdJuSItHPCtQbh/c/ZsCsI
zFQOP/TGoo6eqWuv8T3WnKRw39jaxUeD9EGsHEECOZxcQ6JpBc0v2wsTmeSI
irheV5auTfAWZ/03l8u91ag0qokAU2TUD4Bg1zpPaWHXinOqsiyWLBL0/0Bo
gM0J3yDaAwWHFIyhJGBnHCnBUVr8kzjEcFXzv0Z/Fs6wvO2yB5rZ7FBdZoZ6
TCfVKKeeKMZkcHavs4lML/7t8VuTMIzxwGjwpNFVXJ/Rx4sjlx8eP2VGxER2
Yk/z/y8I/kOLGcB1yl+IfCs7p3W2ksnUcK96YdOgxwhNwC/cqJ8FQetExqM3
lvP/JEGf3psvTrjz2Rzo3OdtttmmFrhmNago3NPBtPMWHtVpWr8IlwWPN998
M65OJLgmP33NoVWnVdzkJdJYS0sV6SsWDzH4v362Vq9jHrIbhsIv4b40ayYh
wlkMN3HDGxRXlPg8P8JT4IcSOx3/fJhGrLTDg91p0axDAa/DVRql+hpDvaBP
e81ZZivLAmA0sdZAbyJyTedpDcUN21+T6guHK1CeLZ7As2ICFa/VmrQh+8km
J7SjDiGoeBnH3BAMcrzGIG3vf+Ld25Cqa2kwpASUllbucm57njeeikjtzN4r
E07eAKIxGjvlz83Smdpp0uhJv4QAXM7nRDy+FHAG9jDHlFg+mp+YiJR+XCqD
VuTShBc1Z+E1pBCWPc5wUVC4ndJfU0dC289MgblrRisTK0Ayp/bBZ9haP8K7
CynKQGWMxLYrsWuIRqs/HtNq823pfYlu1gSWqZtachTfYSf8ZyIDBxGn1ZF2
w7K8Ao90yj3NaO70wJdH9BxCcNCFHn/CZ1t5yFg4w095rdiBzNxOs5EAU30M
n2UtAGJRY8d9Y5lRuQZGghdqcgNdICPYb2zY3SBC8qvxk1IwyDIm4FGFzs7y
1lMQppdZGC3llCUuNiOWFBSmQQ1NTN8ULFEUZWQazyuRiSiqdvQVSksAA+KZ
YIJaiG4pAX/DAhsS4l6mESG9cVEY/RIRgaV9+AJEhLrO8NNIXo0f9J+7Dk63
3Kosz0VqxmodUBBxeO6hPKuUSO68ojpIJ0Ustd6pqzBd7viVBPSj4sfYXJOa
zrJwE0Nb1Iz1CJUMG+BuZjs1rjEraOWreQpaYXU6rM99b1zSNgitFElhHbpv
yEsiVFOflDXgTavw9JwWyssIDl4K6GkfupYhZQ5DiUupqUKgLe44aQpYPMZK
fqsRSDP2YB55pXBo9N6aTIJsPGKkwU5xLsasdN9QVmataZC75vx/B/ONCryg
ElkvZxuUfcA29o7UXLTVor8TGX5E7NWPJ+vYjEiqtLuzyWZ2mOfFEEVB13hW
0TVsiCc0NxF3ouOEfwLvtODeOIL74OeIJ6HrWrGNHZcVLOHTjGs0+mpbCWt7
umqbeQiCJ4JAE4vF/UgybbmTOYEDxpdOkQnNhiYdskw5HzRXVkpFCV4xbPBq
gp4DyTWFTUS0JGfk8dDgwXZ4zA3+Zku1RYiu1dHbsVevuqlPkRUjAEmk7tnA
e96HvEUMOsVk0gDzP0XYsIqNkNgepPJ1EZQYP3gNwcYBzw15TgYrTSIWVM0L
LfqsmQVSJkprdkmGNoQhQZu6jdtHMQwXcpeEhTnme0X7cgQLEvm5UdGryqOt
ryWmyAFRXgaj5PXkoWsVJt2Rr8BbGJ6phVRJr7YyMjMWyZJpr2CBlSyc68I6
A461psVk1GLub66e6/Yow52mnDkIApPpBPyxY8gy9KE8fV1E1QhI4+Xx5ers
kKt+Dv3bLB1RhiS538wC3uNBixgsoFypBn21ffKrc62eFbdKaQIamRqV4ViF
y+sj/vYniFsPcNo+9CsLk8XJQFlgYMATIBi/0b9NcQyep6x5a2KDBM93rMXV
eIyeRtKudTNgWOp6rpY+xt/WKl/mYUdkx8ldgk/kTGaI7tuBWfU449aaVpTs
ol6Zbi7HqAJdWzODacpmjDc5ltzR71AsWDuPi5kSOfxuAdsWMFunhmZEX9kC
BxHOig6lDgRtl33JtZesHvYwAKFlKMYN3Xcpl2Z5ansr0gI0BgPprJHlONEZ
k60zN0/SkjlNmPZIz8JBQjjzvM1I36oiGRlFKduf1AN5eOtadU1vzYAQoq4V
SAET3lQO3dxaE9RylR6T4MfR6pdZ2fKa8szMGOwwMDsk3mQFZV0CVn6L0jLt
BRdEISsFRMkxXojXX1UQJRMx3HoMOQJfRVzVejIjs6aAvhiaOlsY3LXaZli0
oAwPnDluYuJOGejKsJlvv6j1dWHXkMM2i+jaJ35arwtJPXZY9MRcWIb2nLOY
cPdecS8Hp3S0V4Zi+S4z0WzFmms7ZWq19RxVpfnJUYWclY7s+DJFVXvhOgNB
RWDBiBmxunlAEFj7uVJn0sJ7YuPoiRXylHGOxo++hqg3Ttooel7kCJtApMRH
+1ZfbEHUzN4W96D089wzWSAnRpURMwDOsQSmQmY0i+guOU4By5wOkvngBFsw
H0ZKa/bJLy+Q/tthHtNRveEWI+z152BjJfNd4f+WRErtTa69pAst1n4CwQlz
/wJONPcDTvBWHoVICtuJKgd7tAXKEP2o+U3FZCyWpJvVz0tTGOb0TxEEyYpq
1RbviJzxJcI36+ZowVseLbx2X5CitKTE7JjxKnMW8eyxsCQbQoxo9H6Ob4MS
tsLWKbJMdxWCyUw9sxIcjR/3TVcKRJyFd8FOFqm9QKw0QHxnRMjeNkLkBM5S
+dfL59H6GUeUMPOT9ltDrRGkEsUVY7w5FW3OTJIWI+NBKgJ1DAzrY0oNFCVR
1rkBFRTiAdpM4V5needWEQlfJBJpRCRkNexAQ/pa7qimeYYVohkllVgAZSbS
cmbqE+IxQr8ykJFZnlJjzcb+1bk6Yk0acIOqtJNaqlDinI13E0TsGdH0EkAJ
WFoTGSLmY1H+XN4cJsfGRJvGc9dxy6Rfuxb7UYPbmqSyr6x38tHwKgvXhbVW
qh3DhDSPfBB8kAh0JHEO9EGxneNa8lvzeHHZxuMmozsJuIf3nJsrRDlauUZ1
Um3zb5+coZn4Q/jDb+o53VKtYF2fRA9Z6cR7Iswtkm8gHKSy24kxjCnA7rLv
iSTWp4sN/25iWecwRVxVnBC6HS3tR/fH8K1UAnl3T4YThpjAXIBMyZ1sKtUP
LqcmoH5vBPAeBIBK9CO8f2XCewKFjF9NKuUIorwaNEYZVcMCkl2DNQavuh4u
LRINe21DzkrzmSK/IDSuO/DN521HBP8RH9sUCEADaJ0SAXKrhgD38sKIt48R
UQHtuTyymv1iAtSKlVvr2iDKi4hKEa3dxYIBWA6AHeLTAFvEDMYwtiY69vM2
ElhO2+vdqUzvglCXzFQw3YuV5nDLW1WZu9hwh0PpGXWUOlZ2bXbuzCxCERk2
S8xxOmCn9TQIYlUE2xJk/D5BWieClmZNDVHqq1BEVtxR0KfoNGhhlRmbeYaE
B9ZIiNeIWJluQ32XZXdX9hJTpl6aKt6H+zHZ7vhtCRJ64KxIcUlhHXYq61Ps
yBCq3KkGfTVVwzApkjNJ+PrGvPB/x1bJ+uEajOMMrwavcSO6RB7LT24XIf/7
8dO6NqKkaZUw1z7tJqy+9fh1PKLPBd3H0P9lSor3SdSpSxklvKRjc2SlfbmB
I6bZGI7Yc84Hlr2H7Ro+HFHxuT5I+RmoJECMdCgbT8zVWZSvcZeca17nx3Ya
GTUeLEXZZ1/eXNoxUaq4zvbjVWuvf68JPNeEpR23J2jZjchFJQNRzf0doglk
YGwyVy3hNw4tIZXeYD05DBpbljS9IvehQsPIiMYqitUMg8gEtT7jNXPcQBTT
qYg8loT8CMHGZ23kvYbcSqeDgNPkvi3FGw5zuX9iai9ct1Twhz4IYSlMzjIr
bDa18kOVCLF7hk+ErU6GodGtpi9ogxiA4kertHaygizktI8Q6AunIQJfbCPr
ryxk+R4vk1lFuDbYoWCjwGGWZZ7EpcSfCCINMyDD2JgniPn8YCRxe1IoX2+e
XARDDX+hcZaxmhkimiKIEWCgJfGxCNUudLQP+aMWJ7TSau+tHe6p4m6Wj8fA
v8iHcQL/3Ngo9XsyUqYL3HCbvKiKyXKSaVvlWAyQWezSUZydg17kOgqwHSNU
RWyhHlKcgLcureicdRUS3Cm0ylBl7qIQm/CGam/GPPwcNyX8IeQF8C/5rk8u
ck5tnBedpYulIyKNRMF0BTUorj4eIbxr/LSOjZCLLNH0MvWwS22a3UnGUOir
5mHVLXiVnUUqogNWRKwZMNKNCiO1rCLa9Qz6QilyDznc/XWp812I9Pm0BXt8
6C8s2L9Cwd4qdtcbt5E1cK+6Jt8MMxXWyCpkWKClY7ukQg47u3xGIQyvIXdL
xn1+t/wEH0eWggBUuQUCNiEP/bCiEl5p4aA4A34xi3Pke9R16TrDBjIErUlC
iJtbRYyNjmZSV5nLSyIbSxYdId0sfi4C9NMEki+2gfyD9t/kLCqpvzGBc61U
vKD/Ah9Cwh1Ub8bwsxwiE08SuWdimiVumbDR/cCR7gXyTrh8ugA7SpC1Aezt
Q+drkSJxLe3GWzXdJUhxmzjTxTaJ5zDODCiVh7JDwjyLW03WFoEATe/u2xIF
aydHPhOB96kOWCslep4lyHWBNuuTn+lDm+Zlz3GtB1RB/RjByM92rvRpZh5T
V4H8JLMmi77qCh+oBxAfCwcd1MJtVwLqT5JrFcx8N1zD8GGLKL1NglVfK8wU
bDLId4Pb5e+EYeyQPK98qGFG6Ql5RnY26OTuHIbHauZOrjWWwrV/vvbaDEMo
7z8ZmUEpBWSm7xClABFEf+zlEsQOriyjWcZP8UTCov1Qkm9TgBrNSCzurqii
tgW2tjmLXUMimKgQgS7YRbSgZ/zZiIJeyPhTS2lsodDAms9rNFSYx11ySWlz
l5aS0TozsgAxViVSmEoWCNWyFQh53CGhvBsjGWbuOWLbJHePUN5FI0V6CyAb
nWbpFF8AXCmqbt5O+AQ/G12JWCFErVMaC6Kz3/Jwxqg1QqOxDyMEtg055Tt2
JkhY28bPqZZmeafiMFZdzcuo58o2/gEzWpgpQKGYrsXH0QCtpRO7dsv1bLLd
Q7IJahjDSJ0E6vNPEPH1ohxJ+Pi3lJpRiSpfjFeruOal1VwFTRbdZv29haIA
V0NH5xhmZ3VbO10GV9HhuY3cYR3031SMnm47m70IKnYaDT3fTDKuiAa+N4g5
LHs58aijkrCtlsTnOVYRi4gfAjIjmWHuD2EgtFuvckuro+NCDUtd/CZTQctg
DyLJdiKYqSDtG5Zi2iZwE2IMEntoU5kVRAxTREwaFaodaSfBSXJN2DVzPxyz
evptDy6lYC7p9oog7YEL5K3jLSW0HcHFqm9/W++ZXzhYNR8paSp1jcpUVD/B
aBSzMn1UywOifmO1XbNhi6kZS6ghAq2BL0ZEpDB6sAEkToWcc1xdvWxPkNCg
ndWlmu1IAP5h8hb8GXmygjyRPEbVRJnlQ42koY8sYprJNSGGbCD7pZD4d+iD
h3T2cKlHPkqeZ61+aw1FHAZqIM3tACbRKofclxFKM8enhu489hnnpgOTcc37
EbnyMQK0FwH8Rfy7P1KtfYSlFz5OBjPL5ge8XjvsY0kCq6O0SzFHvVWLXZZF
YTuX2qagAOvYgsv1NermfQicuhFRblM4zEIE83D6FMQzRCSWMSKZtUPiGCwq
Z8DZdVgkzZrwk22z1faV88pS46kdCA+slcsbESnu2yEg2HXeaI4AWQMqTIbt
DbcZo/pzCe5C+IlbxnZNr1Gmwbc+4c8zwi/cBAJ7F2s/MML+Y92wx1vLlM5V
4j7F8P2xmvGlqCIRgLVeGQhZZsayGGC0eOsR9qoQyq1LM4+KNMJONJcaEJxH
I3AOjiAS3YgKN4B+I0LGB2nBInHC3S2gExGtJTRxdHTfoFIlG50zaqFz0xG2
7UV+IOwgz7OwTuaMS75CaDmV3b7Ihvr+ljj/vAV1AgQdVzIkkOsgw6J7dsTW
8MFMh7berY7ZLMw1YV0Yso38aNQfTIDKIZ+18Sl8qrRRcGCUNecHXBPiZx17
mDFq7xMwI981YVMAu1pv3p0SEmWFSTsXm3GAS+cbmNSN4uaLRJyDC7U3g3lG
SjOM3GsCx/3fwN3cLGMYGqgFJwnMc2kzUqKuNhwrq0SwyybLQyKgpDIcyX0t
GwF7WEJ9X7zBCokV4zNHZ1EFQaHRSRZYlJWVWyvQLu2QONrezMxRxgRTqOAR
6u3LW/NRQI12+qEFqFGmvzAHdbGvjEly34q4VgZslG3bAidQ+XhcCRPhZXyZ
ChczG1ADrSH/zZxQC2k5GBcJ9IM2kF9FSH13S3x7NVB032blK+MdkgWBOyiq
QlkajfmANcmiUZmsTaucPSlRHpOcTxuEUTnOExAKxBELFYh/pi7Cv6rg7sp6
53mvs6pk4T2sBnlZqOGS1iLAImESSmrxsu7kiA7/1rao5vGvFEH5YPy0lg33
VJGnJPe8wh+W7pZBR+OcaN6ZSu/JNUo/eWgXLZxq+rFSbErLThlgkciPjJDa
zgIs0vrOlpw+sgLYoiZacTbGF2UzfI8qOLVyQ4Tgy7WETUnhSp7Q2D7PDCFU
hUdFSH2gD2AlEljI5qPVw30KnrXQwHrVLIlr9uWZgF8SFcVIGK3fzrRe5253
tjQUCMcQGG5DJIESzqgpP6qEs0pR/EEF8CgY7U0YCfDz2JWU19dWCvtzMcvT
EgpkOl+3AHGrjmBXd/fJYwkwtyHX1rRhv32SI0VaYjkBfG0DMhMvwYME48Bb
33QLklnVrAGvtIHOB1kJIyt6xSkfqVxoECm6Aml2VljSl0pif0ONUy17Bv5G
qpgvOvbwKrdqE57MYq6VAthpnywHV8tZMIAjaR8XoSVgRgFTAfO2Fpi/ScBs
1DnXpEsZcqp3YEVqq2UWmGNtJngUFaR+R0wEsTzO8gilrTvA2z70/vYCTyZ8
qwJXRoKG8HDfswY8jPrtZjudodNSvloNaufKox8T4MuUkcvSfIMA8X0Rei/M
qRUf8tVdZqbgFAVbX6fnJ0/3qrGmA3Y/nSxgbTfL6QyUMtgq1GvjZA4SNRg7
t6DszNg/IgL3vX2gnLprKi/ktEDXqk6V8W6tJQBriKMleKTrWqObwvwbKRVT
S4ah2GK9oZqVn0ik6XvJNSV8ERtbWsJ3ob3dvyAYiEye00wbTLraXhNkXx2Y
Q/wZItkOPxeig20RZGBuyDgVFFaAuyG5tUVFCJ9JBUXU9Z3V1szNlp0IA1bd
ziveMcrU2NU1H3g1UloYBteN/ZzWOamALNLmGjZkN6tL4bMD8aoaKSgWyOGL
y820UHmyFu7JQYexVr6OUUAWltfWRiHQmexgMXyEcYCkr1ZuYfyeDhi3D6WT
J5TkPY/ANCudLXmsT1GZwNQsGGR1I2xj5uqmT/TkMvVnnMTtW1EKDLU95b5t
RZSaome89QYNdRHD3wcRostfa02hlbQYCCr0VnPmMmgjJIUlcle9mjlZjVwV
iVGxCv6TiTxIjaDXtIEszSiLQNEPCJBVXasope4ysRLGjCL1JnsNY6H+an7W
JF4cXZs3uPM2wXhFBKAJSiTvVxP5CwGgHxIUMS3UUetld54h6p82MvFQKo2s
nhtSigh8R9wdHbZTIxzfRaARZMEG5NZGlgT+UQdUcx/AqOyq9ZPhldoqEcX2
btl51douEg5ftOEEvjI+ioE/iWB652jw3VDDV2TtxRX4ovaxN1UbfWL4opRX
zLZdsYqUWjap1ituvIAmRm9OI/Ly9wjjLwW4tjCUriKFUL0Mwez+5IjuX6BI
O7/UDo+ue2q4nQ1fp+O+8/k+Dfa6pIWFTJBATyfkVAHp2uHWk08+OXz88cfb
b20FVkMFgJVM5DafQ5MMMxZ/RRUNXXWKuZ3P+r/UeiB1eMF65ydKDxZ9mK68
UKHiO3HVAnEk7ADxiXBrxYoVwwsuuKD9NhaunXfeecOjjz4ark21mDnjjDOG
++233/DgZl6nnnrq8KGHHpr270ol0yKv106gLyL10LxtEtEi9DUQzIC1lEFV
F3WV/WE6A06W1JXdafV8SR7/yV+2wEsyZAKoJs+IgEhH3KzRjZ9bbrlleNVV
V8G16eGqVauGy5sZPPLII8NnnnlmeM4557Qgf/bZZwdTwHhScP0iSxH8bbrR
r9xXSbNUcKQFcvajuptd2m48i6JgbHQ0NLsWKqF1Zlx6igxV0CFgfeqpp1qW
uPHGGyOKHBr23XffVkgh+OVVa1rg/ymCH9vxEpVnVluPAxi1K4n+eJ9Kx9JM
qZxjl4WjmXnPUICq+Cwisd4+CjLuvffeFp4NArzMb/495phjhtdcc037TX6L
imlJuMNCVT+38EEcG20lq+old1kO0LC7K9WdeIYN9ry5mUO5sSzj7v66ANW5
hG63IOCraBTByq233toO00imiJUTTzxxeOmll5pYyRrmKg1yDd6jhcOVLIAq
KLNQkpjG3BXLTM3adj3kvRl1LWGjcLNSM6RZgpIl3eC/6aabWmnklIGA30Fz
5cqVCfztC9InJZfkzASs9StIf4pJkggZHYhyjUuY22/kKZnJFTQ2ZQ9zR7RW
5Kg5EPLNEr8XwfF2G/IezMPf/e53ckeQMB1+dPvtt7c/fOKJJyL8TzjhhOFl
l12WkT9KvfatchRF0Nrtjevbf/PS1lxoTzGRUKBBrjs01HrFlKED0pG6r7aQ
ibLGhXpDpssKfD8iYAsCoxwB11133fC0004bPvDAAxoBTh07BNx///0RAfPz
88OrvTEmDODM2EkkexFIg5sI0HPZzGsszX6PDdRrjWDKYEJh0dpxmsphsvam
sgR3l7w8n0B7804MPProo8OTTz55uGzZsuERRxyBGGhEz/Dwww8fXnnlldFI
uueee1pgP/jgg94RCJQu3p08h1rhxoAvmUTWV5gXXpodIKVBDwOK7mqVG5Ux
2WQe28EcSc09s6pzpGQt/pzImnTKclC3YwEQDrAXX3xx+3AD75kgp6+//vrh
oYceOrztttuGd999dytuGuaYDr8SkAbB0g58kwKtC/OreKA2DnNvap4fOKKN
+lnVU0cGsDNG5pEbfdJy4ZUsmi6ALrJrCGgRzmeeeWZUrDNBHFxxxRXD4447
riV4d79xBaI1KZZkAOdNinuchcWsQJQmEqmEfLJqiMP0G0uD6hQGBilZdKe2
z0nbikjGaMv/IEJyMwJnZbY4Mv7tb3/bflsK12SwpTBEENCDPiBNEy/SWZIM
1T2GlJxlSKplhFQ0gWWEBJLaRMWwJ9LpBQUkUTR4YqTbqm9Qj2sIZbbSII8T
TgTwfGSjjTTbFWpotEpqc39H4R2atoUMjvT2wwilt9pQkp4vwp1Oz1xPoKSZ
KNcJDfWCvx3BwQ8I5t0rmA+t00SonUup2HPjBFNsgzwOdSGB15ttGOqexMk/
IDAciyE1ONKUnwE9arOPyTg+20bcufHB4AFkvL8ggksAg2ZQAIy0BEbiupYA
JnNNanyI0ksglgU0zSyoHUnjBZqlJOufvWIVsT+KzPjm+CmIfH0msSOfX1pQ
UnZDVzMHODPZApAyHWppzvC/PljAgpFmY8aKSF3ppIA3aRhJm2OhJPft7xWM
YnmlXQvJu5BIIApDgAzXtlNnFkyWkss8UIBBByno4giTNxIuDBz3BrglbsMv
LDhZWQGzdUJJZRzhfpglli+QAXVKCS0jz1DGORxL/ITIntfb0HkTPC4mgT9p
rCwPWxQTflCvAp9VnRXzbh5GcXoJGuahZs1fmbYXfMSafWVuNeu4nEDjDYog
3DfvCA3WC7cw8biUXJNIGkr2n4Y7BJJuVlahKH5XJQW6TYc8mmBeT/2WAsA8
fRsfZaBsODFlTysAXDcAwcgPjgeIQkqx/WM8LmBG1eDzXEXPN7NeVFOXssHd
IrFJBNKUYcLbzlDhZZZF+TKWk0KLEaLCtMjIGUTrGT3v/K+BmcD2T+03EolB
Ev5bIgxWNf8nxq+3ZWMyXKwLBuTEzIUPYJcpco+zVqIvQ7tIVko2bxo/BfG4
ToBIVwJvsudzM4p63bW/IRDex9fIZBCWngm5LWwWz4D5XISqWI6v26jWcEUj
EeEa/IbBXxMKfq0F4b5Zua7nlvgXfNvVJyZYi0j6iZIUKjaoNJO4/ySfEOkS
Dp1FOcGiKbWt6SOlJ9DalJVdSQRwOodNAbtvsq3rOQy5CDkL2SPWf6Ke8wRP
bRtuUSajI8AcPW3eILhM0tU71ffNS7A41pUR0Oys6ukc+L1SbT2eW0PJDckA
uXzQFSbAeTM1ZfSOwaNp33yOr6wAjKXn6h0d+uYkWLArFaCwI1ancnD3zax1
PffCcA0r+czqMdwtrJ1QVXpSg7UKR9Z0pRJdVlRcIRilSovJn8UVscPTFGh7
5cx6PLeWolYHz5R0qIDWsmQz+T2NoEUgJNli59mM7u8jpRtYE4efEinJGn8r
iPfNkXU992JFzO6bWZHKdv5Vi6hLiGO0quyuwYKPaLTxeIBhEbKeDlcTWk49
dZWfUs2LmbfXBRqWMMOlFkSR5wNU6cIxxGz0L9HylBm+C1C/2yP3wDozXA3L
E4IpIPiS9j+e86rlw8TFxiDExV2wm4XasVrMD0lxFluUFFvHdIYdJQxL8aow
kI6rIQH+Iq6mANpLgWXlcZbekufQOYODRCey0rNF0oAsRy9vIQIuc/2oPbSu
+uYf2jdcG6e8ESGpIO7ep265Bf5YSUfnuen9A4iV7Dy9ed21I1uoGWka1CPh
CwdXzrtWDPTLYt0ojLzcHmxNcPwXZN1mB22290JmWJRA27vC63EiEvPOVR3v
KaBzaO4b23MdYKF77jgauDAQiS4xU1ZNrm1KPKoCZPv0knpAh8BBhJQFB4e8
69XCEA6o+gMcPqBown37oQGHzAgxT2lhsr48cLKz2UWCbl1U1AL+iz5qfWNk
jgogtgO4iYa9IDxgV7rNaChYRVLua37eY7Vzby1QYglBTN7jGDfH5afNV0ES
fgjgIarxB2TRWgAUBtcguc+oMd1z2artLS/1Bv+MqGQSbN2OE/4hrnYDvW7p
8omS0NfidBZ2LUJwPeuaJ68OO6aY0d8n1zViCF1Ktm4hlP1yIgoCtX+YiD8W
0fquAkqIHGqgBLzbrQQJUPq488lq6Ciqwh3h/0CWXQGFtFMDWmjHCY/qInSs
YEGprwwc5ArduQDtSMPBnsghae5NYc7fP0Zqf4Wa+zB6zeEUihTecf9LrWlt
yUWlWGbqoPmvVy2MwFadW1YG39eKSdAa/qe4/pfb698R+EXKufqsO7IlE3sy
Q9jkW0i3zNEnplT9XBNj+WgK3hqXvz6RCWH5+gAXJwDP6Vi+TMQMHNeWr3Sd
GWtiVmPfYpnbyHpfGqER2H0ntXKH+O+SlZvt48ZDBB6VPtC7aTybPUpqoqKr
yuVfCIWvp5csh8SgtjursuRSZbHOeuXZiLOxO5HdnzELumRdA1gqD8Xa/47L
KnC6C8Epa/Gjdeysaqim61TyImKDL1lR05TCdbpWllW4if06rmg9tRTgWTmG
Bk31hfCAyk2bNRPZvkh1Clxth6pST9r4TiGgcn3OFPv3Yn1IsD5oO/gULF0s
8D/l62Mm41zeqVi7G+rItdpilWeikbm4vAzYBETeQSTQuvaKPwOPi/l9Wn3F
am62SZEfceafm64VCA2y9gRCzdZiG6zeSRa2DgFAWKwcLI5SqG0jMUItkG1L
5OeJ1bZqJQGtJXKq6knSyMnFuwhPrhMpOnDnZ4kMavu6dBXoWFXHlI7HW3dK
e0JF5LpcI8YzcY1Bfw7ujuspVqbb7zvEnWJRadV2MzdGl+k9XimXXAE4Ccz/
PGjFwT1x+i/WC/kcQZG4AriQ3CXjjqlS7hhKz/dz8u3nZn4hY0J08P4jrmZt
tQzgMTlfGVVEakHmn1LOfL2+hik6tx62ZzVj0ko7xnne0f0/iDh5EbnmE06D
LwAUsv1a7VL/CBcdPHlYRK2FVHdRkVl9YW62k3vyS7Rr7iPorKx7z0CwmJMX
rsxW7f7IKqoZzLICBR9rFozrFZ1QrpcVCrHOLPfHScoq812n7Sr3CvJF7WHq
vcBMy5d6YM44wIYJ1CKYLWJ0vFgmkvN/xamuZS/zi0QidayRVVjkGNT83CyQ
7evIfI8i6pRl/xB9D8bpvTB+CtJHDntFRXFCn9Xkdne+Gh35hHOe0IyfsvSm
Ws3/EGSsoRfyZYUWt5Cv90VLRYehZpTiuVqHJMR0Qhdr5PLfRIisQa4FugsH
QTVX5bhpzP9om4FxxixsesflGH1/mcNQhjuQzv4nwruyjv3ULYeoPyQr0s0E
5+FkMLSMaitiXsEYfIJ1oBx4uFgHCvUX+HXsT+TAcZV14JxrGw5hHVqKsSxC
Vl6ID0vN5WNxMUvtxRxIxMCxZDHGrsiuvQ/0/JoBSRHUyvdQQjxORMIMuRaW
dxDBlT7VI2ZRO8rUyrRG/41phsqbUit0U3mCIGs6ojLw0jKFNvftqMq6UDAr
K2guP/Wn2DRWT3yShawK83kiTnpGT/8rgBaxB7/WXluthG4Rl4WSBhVCMN03
hAyuRg74ezKuoUDGIQB4iQwcEVYDITt8xUjp6QE7aoSnHokyHjA79qm4Br2J
ApjnUCIbxuGaDOaxOZmtVbtlSICGKYNyP+/P1rktD8HYguy3RCS08ccXuFm+
wH9qF3kYkRBSJocsyBaZO2ed6WWMeOUboepZRhZZQK31DJnuBF3s4eEeps+a
R+Q8bRkgNKtm8remldxy82MuahvguL+KVoUgsQivvsB9fYG7HtZ1hHrSFeQK
V8KiimQ+MfWUYT1nHH5QPVdFLwqR9bvIeal7UljF1xS/JbJjeR7j3DgeypFr
8/nBAmiUs3gsC+0/G6c9rhcgGgjF+jJzAaRJCE1HkzmL7SO1NZrxXJi+fVua
4pieLJoBIrUPDDSmImX98qlI6mHOtCTMmrTT1+0bJ5SocX8k3RsmLyYaiuYD
+k0eiNuoe9OTx/Cypr0A7fZlk2HeOAH3x3FjmLc+a8pJ2/275136h4PuZK7O
ZEVjWU1fuDO1kAsiU4TnILopCO59+bQrrSD6JWEzwVMzhx0ntW+dgYmLYBwM
litQu4v7VOaMrRdKz9xMF2dHM6H51w6+xEOynVoLznZqwT1vZvBlPqHaNuIy
ojJd69VfZkrEosMJtqqknaCjSB8IUbDDTb3hT4i298p4CXAHLIpSrqDQubKC
VWGrWlyB57rU1fjy/JCPQMHfUCu6XNrpKiOpY0VKcbI0uWh+syW92Vl76HEx
TKEbKfhwkg+TA3KcD7NM0QraPQ2Wt6cl5lat3MlsBJ9FFFFL/g7gHbAyGIt9
Qgd54VYodPsm/KZmipqr0uE3MEuKWM4gtQuf11XfLJT4dPvvZFxQgZpwRtVJ
gYDQxGz+h7O3J+KcK+ZXRyVO0V07mzcSVfJCQxxeNQcN+1/i0SRiu7h1ZQeG
y6R1ME3PWFll9ZJrZvY+Ngrp+IT1QBJLaMzsrmefB87Kw2aYrc7qo9vfP9pF
D76ebSDHvCGr7oYzKxM+9WNwspkNSLlyFt1DnnyoixT8IaL+PArFh58NZI0F
pwupzShz32ppOZZ6VCbVA6OQgW/nFVL0ObCxbiELGrP9LqOlEgs76j5EbEER
vo1BPEABwftpa5ITdmoyv4b9YeWacwPuHgWMvndMKGTJHbE5a4bUJCljAUgh
zVz1VN3gtyuWAk3uAfg2P70FJaoclj/ZMb1a1kZzmJpeKNcd/GsVuVv6uX2H
CKKde4AOtS3Jj0V0Y5WXiHs0if55FHT7Ew9i9RlyzScqc0Z/SCePAjONV6aL
2ukfu6So3/4UDdKi88zY8LHHHmONUHYiC7AzK2aDDVwAy2Wl/QqGTN3WL8Cn
rkbu/HLfffcNjz/++Hbzu/vJscceO7zzzjtZgx1mKX1YXeuTlgkhB1pX2ELg
xlFIbDtcfp82LRO6TcuYg1Ezw9/85jfDhx9+eHj++ecPDzzwQPc9GI55Ybj7
4zzuj6q1F63kWFixqJIY8O6sfDsbkwu+dj16o327p7i2zG7X8l1tEiP91q38
oosu8oZv+zq2zj5tE8sUHEslWns3gdpFVLvp75SvtqtDiSTmTjnllOHCgpfr
2BdGpPtHKmus2UZF7MRYI6LzqlHIe+d8vV1NQiY9/BpqF5w+/fTTLT2sXLmy
aCHiXuc5uMyjVLJCulgBVQvm6xZDxeDfVel313yF/Tp2zLS0esABBwzPOuus
lpYdJZx77rntb++44441w09RgH3IWGqPlBFLgOFSGxr+awBuJ1p3yxfd1Q9D
QhBHHnnk8KSTTmqltHv+kEMOGd5www2sp8MHKUX3sPXyzFi+TGlDVrOh9syX
1tWPQmKap59++vDCC9tNp23jcod/1jlhW3i/xE8cImehR65lGqpAhKzMWbFZ
Q4aCRr+Ur6mr44Noz0suuaRtwO6+vYRInW3IWuQc0wkifRZVsRZ4cIX0cZr4
x/DOTpL0octoR1Q7M4w79dKKlcXFRffq9l+nPGU0KctEMxUPgpflzucNQfpk
wdz3g/fYox1slaLGAnPe8PcB0QHviCBLclLEMVbzt/nm/3UrlyVpanQYfB9Z
UgytF0Zrbf8masHUqtuw+XzqLcYcsXUB6wb83n6zrKS5mGn9vVGoy2eBI0Ui
DN9dmx1vdF/kERUAz6lysz9KzTd0GPBoIEZst+Tz0w6mVhd6fgi6dLSVYeb4
cqfBJYFsQQBGsL2jG2zM+tKZEfQ1xC3vhVEvDAeXwjSETJvP6QQ1L/XjRgZz
L5dZ+/YnOFSBTB/TzVqxirzZUs9By0qeQmI2Gx702wkZH6EdSO9TpPVZa0qa
cmCPUpKEsj3hpEAWptTzYaqiM5l77du7ZlDYADgD2VcAZblcQnlT27fYVDB4
W/pteaQdU9UyASRVTL51IsTHTHzvSQCHm8zmuBA9mS5d68Dk9LUb9rgunPhD
y6V9XXNZDg9AWVNUTGnl51559tn+UPmju5Dgj40JTS/zdbdnq0MxmCy9kjFg
murwUdDgeymELqc5Vb5ZTYc22SDTmUdqLkDuTymODhcS4RsDuvCFfbQM0uDB
CuWA9gFbv1c4sR1ZoXfG3KXXkollJRGGHEesHEAmlgFGTcw7GaHvVK5twiRD
L/0Unnc0OF85KkLJz32qePKu0+Dn4R2iSsI8pO8gj6+z9eNGgk6q9Nzh27mP
9XzfXgrAxYr8UgbXEMoTAw1DZqachQQZZ3HfqT827EeaenXXixBku8IAnSD7
lX/pr8jqNlIvjdVI8lKkirkuMPrmFfE0C1zdq6wXKbm8SxcE/8m/4wa1GPdN
HzeP73AULzHxHWF+ncDzAfQBBjnFH9yg8j6E20fSmgg3/dq/4GYgY7GIdAsI
3OeO1CDBg14L8lmV2GgEqeFl7bXcRm3eybwJ9IWpzPI74mJrFy491yEvhHIX
lN7vqwLxv/zb/leYFSwqikTjXUwgbTUKPB/0r/4nNXyYQsdbEaTvUCAtFulT
zDGlI/fdNzzKG14jZiiY1pyrfAYlNqFA02PtytDN9DeHn3TC6kn/mn9Rr3EP
vghWj69xNP+WLsj8Xz/u/yE0nTZ6BQNatoO8oQsmQ/9AO/K/khmnU4g3HQUG
7b+hbufXasLu29I47CZVkm/HCWf6/jtMQKQTJsHk3e0PXwk3+s02lLJggwAR
UdJ3Kd/sebm0r6kIiPZZH2YbyG58RByrX2p/mFqEmGDxzWOKve8YMiiGxZ3J
/cASKjruCYBAodP+LEFL/AXsS00JuR3XWwKDe9XsvZ1aDpr2X9QI2Z8bFDbs
8hDFOLywHwRCBcN/tv/NZEEFkIFyLa3Q+1J+m2mwUoVG5B3+yNjBMP551f/H
Cw+GlWM6ub3vz02NlI/HA494OEd7721dw412KEX7wOb2mH3PWO87Tlf6rh1n
s+5xutJifcfpSj7hOF7UTrKDhmNIuSuvw8Yj5+bG8bqSKWw8cgpsHK8rkYF4
9Cph1BNO2xEUlfY9upP9tutgSvxNRIvJpoMX/D+tXq9g\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"ParametricPlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "-", 
         RowBox[{"x", "^", "2"}]}], "]"}], ",", "z"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Orange", ",", 
        RowBox[{"Opacity", "[", "0.5", "]"}]}], "}"}]}]}], "]"}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.653951971994235*^9, 3.6539520093565483`*^9}, {
   3.653952336498474*^9, 3.653952347576619*^9}, {3.653952404383307*^9, 
   3.653952410012413*^9}, {3.653952453726593*^9, 3.653952538576901*^9}, 
   3.6539526356996403`*^9, {3.6539528297999287`*^9, 3.653952833805332*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1nHfUFdX1QD8QUcQa8RcxSkx8QmIIgmJJorzYkIeiMcUSDCJCsD3wJ4mi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   "], {{
     {RGBColor[1, 0.5, 0], Opacity[0.5], EdgeForm[None], 
      StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxFmgkYFlPYhme+M+eLhFRaaY9Kpc2WqCjJWkmhBe2FUHaJ7KUi2ZKQSpZE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          "]], Polygon3DBox[CompressedData["
1:eJwtmgn8T0Ubxe+dO9dOCCmUJUna0PJqX0mLZKm0iYp2lbTvu0KltG9IZanQ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          "]], 
         Polygon3DBox[CompressedData["
1:eJwt13ncDfUaAPDznvc93FDKlhQiWxHKlrJUShEq2lAp5N5ky5Z9exFZKyKE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          "]], Polygon3DBox[{{1357, 981, 980, 1356, 773, 774}}]}],
       Lighting->Automatic]}, {}, {}, {}, {}}, {{}, {}, {}, 
     {GrayLevel[0.2], 
      Line3DBox[{368, 578, 1364, 369, 591, 396, 1451, 604, 410, 1456, 617, 
       424, 1463, 630, 438, 1472, 643, 452, 1483, 656, 1402, 466, 669, 1414, 
       480, 1498, 682, 494, 1502, 695, 508, 1508, 708, 522, 1516, 721, 536, 
       1526, 734, 550, 1538, 747, 564}], 
      Line3DBox[{370, 579, 1365, 371, 592, 1376, 397, 605, 411, 1457, 618, 
       425, 1464, 631, 439, 1473, 644, 453, 1484, 657, 1403, 467, 670, 1415, 
       481, 683, 1425, 495, 1503, 696, 509, 1509, 709, 523, 1517, 722, 537, 
       1527, 735, 551, 1539, 748, 565}], 
      Line3DBox[{372, 580, 1366, 373, 593, 1377, 398, 606, 1385, 412, 619, 
       426, 1465, 632, 440, 1474, 645, 454, 1485, 658, 1404, 468, 671, 1416, 
       482, 684, 1426, 496, 697, 1433, 510, 1510, 710, 524, 1518, 723, 538, 
       1528, 736, 552, 1540, 749, 566}], 
      Line3DBox[{374, 581, 1367, 375, 594, 1378, 399, 607, 1386, 413, 620, 
       1392, 427, 633, 441, 1475, 646, 455, 1486, 659, 1405, 469, 672, 1417, 
       483, 685, 1427, 497, 698, 1434, 511, 711, 1439, 525, 1519, 724, 539, 
       1529, 737, 553, 1541, 750, 567}], 
      Line3DBox[{376, 582, 1368, 377, 595, 1379, 400, 608, 1387, 414, 621, 
       1393, 428, 634, 1397, 442, 647, 456, 1487, 660, 1406, 470, 673, 1418, 
       484, 686, 1428, 498, 699, 1435, 512, 712, 1440, 526, 725, 1443, 540, 
       1530, 738, 554, 1542, 751, 568}], 
      Line3DBox[{378, 583, 1369, 380, 596, 1380, 401, 609, 1388, 415, 622, 
       1394, 429, 635, 1398, 443, 648, 1400, 457, 661, 1407, 471, 674, 1419, 
       485, 687, 1429, 499, 700, 1436, 513, 713, 1441, 527, 726, 1444, 541, 
       739, 1445, 555, 1543, 752, 569}], 
      Line3DBox[{382, 585, 1370, 383, 1449, 598, 403, 1453, 611, 417, 1459, 
       624, 431, 1467, 637, 445, 1477, 650, 459, 1489, 663, 1408, 473, 676, 
       487, 1500, 689, 501, 1505, 702, 515, 1512, 715, 529, 1521, 728, 543, 
       1532, 741, 557, 1545, 754, 571}], 
      Line3DBox[{384, 586, 1371, 385, 599, 1381, 404, 1454, 612, 418, 1460, 
       625, 432, 1468, 638, 446, 1478, 651, 460, 1490, 664, 1409, 474, 677, 
       1420, 488, 690, 502, 1506, 703, 516, 1513, 716, 530, 1522, 729, 544, 
       1533, 742, 558, 1546, 755, 572}], 
      Line3DBox[{386, 587, 1372, 387, 600, 1382, 405, 613, 1389, 419, 1461, 
       626, 433, 1469, 639, 447, 1479, 652, 461, 1491, 665, 1410, 475, 678, 
       1421, 489, 691, 1430, 503, 704, 517, 1514, 717, 531, 1523, 730, 545, 
       1534, 743, 559, 1547, 756, 573}], 
      Line3DBox[{388, 588, 1373, 389, 601, 1383, 406, 614, 1390, 420, 627, 
       1395, 434, 1470, 640, 448, 1480, 653, 462, 1492, 666, 1411, 476, 679, 
       1422, 490, 692, 1431, 504, 705, 1437, 518, 718, 532, 1524, 731, 546, 
       1535, 744, 560, 1548, 757, 574}], 
      Line3DBox[{390, 589, 1374, 391, 602, 1384, 407, 615, 1391, 421, 628, 
       1396, 435, 641, 1399, 449, 1481, 654, 463, 1493, 667, 1412, 477, 680, 
       1423, 491, 693, 1432, 505, 706, 1438, 519, 719, 1442, 533, 732, 547, 
       1536, 745, 561, 1549, 758, 575}], 
      Line3DBox[{392, 760, 761, 1375, 393, 763, 1551, 764, 408, 765, 1552, 
       766, 422, 767, 1553, 768, 436, 769, 1555, 770, 450, 771, 1556, 772, 
       464, 1494, 773, 774, 1413, 478, 775, 776, 1424, 492, 777, 1557, 778, 
       506, 779, 1558, 780, 520, 781, 1559, 782, 534, 783, 1561, 784, 548, 
       785, 786, 562, 1550, 788, 789, 576}], Line3DBox[CompressedData["
1:eJwVzNc2Q1EUBdAdxvABHtQgEb2L3nuJLohORPDGf/hkT+Z5mGPdsdY9O1/7
KX9nIqLKr4+/hoj2xog5OpoiZuUg8yykjiU6bYtyiGVWUscaWduqHGadDZp1
WbnFJiNs06PfkV3sscso++RsB7KbEoeMcUTedpzec8oJvbpxecZ5es9luq2/
kBOUuUrvuUm3bddykgq36Q733DHFA4+0+bcgn3limhcK+lfZxxtVitRSZ3uX
/XxQZ4ZPvhighVb+AewFGkg=
       "]], 
      Line3DBox[{563, 746, 787, 1537, 549, 733, 1525, 535, 720, 1515, 521, 
       707, 1507, 507, 694, 1501, 493, 681, 1497, 479, 668, 1495, 465, 1401, 
       655, 1482, 451, 642, 1471, 437, 629, 1462, 423, 616, 1455, 409, 603, 
       1450, 395, 590, 1447, 367, 577, 759, 792}], 
      Line3DBox[{570, 753, 1544, 556, 740, 1531, 542, 727, 1520, 528, 714, 
       1511, 514, 701, 1504, 500, 688, 1499, 486, 675, 1496, 472, 662, 1488, 
       458, 649, 1476, 444, 636, 1466, 430, 623, 1458, 416, 610, 1452, 402, 
       597, 1448, 381, 584, 1446, 379}]}, 
     {GrayLevel[0.2], 
      Line3DBox[{873, 1158, 577, 872, 1364, 1082, 874, 1365, 1083, 875, 1366, 
       1084, 876, 1367, 1085, 877, 1368, 1086, 878, 1369, 1255, 1446, 879, 
       1370, 1087, 880, 1371, 1088, 881, 1372, 1089, 882, 1373, 1090, 883, 
       1374, 1091, 884, 1355, 1375, 1092, 1190, 1562, 1213, 1214, 1197, 1212, 
       1093, 1159}], 
      Line3DBox[{886, 1256, 1447, 885, 591, 887, 1376, 1094, 888, 1377, 1095, 
       889, 1378, 1096, 890, 1379, 1097, 891, 1380, 1257, 1448, 892, 1258, 
       1449, 893, 1381, 1098, 894, 1382, 1099, 895, 1383, 1100, 896, 1384, 
       1101, 897, 1551, 1160, 1102, 1191, 1563, 294, 1198, 324, 1231}], 
      Line3DBox[{899, 1259, 1450, 898, 1260, 1451, 900, 605, 901, 1385, 1103, 
       902, 1386, 1104, 903, 1387, 1105, 904, 1388, 1261, 1452, 905, 1262, 
       1453, 906, 1263, 1454, 907, 1389, 1106, 908, 1390, 1107, 909, 1391, 
       1108, 910, 1552, 1161, 1109, 1192, 1564, 1215, 1162, 1199, 1233, 1234, 
       1232}], Line3DBox[{912, 1264, 1455, 911, 1265, 1456, 913, 1266, 1457, 
       914, 619, 915, 1392, 1110, 916, 1393, 1111, 917, 1394, 1267, 1458, 918,
        1268, 1459, 919, 1269, 1460, 920, 1270, 1461, 921, 1395, 1112, 922, 
       1396, 1113, 923, 1553, 1163, 1164, 924, 1361, 1554, 1165, 1200, 1166, 
       1245, 925}], 
      Line3DBox[{927, 1271, 1462, 926, 1272, 1463, 928, 1273, 1464, 929, 1274,
        1465, 930, 633, 931, 1397, 1114, 932, 1398, 1275, 1466, 933, 1276, 
       1467, 934, 1277, 1468, 935, 1278, 1469, 936, 1279, 1470, 937, 1399, 
       1115, 938, 1555, 1167, 1168, 939, 1567, 1216, 1169, 1201, 1170, 1246, 
       940}], Line3DBox[{942, 1280, 1471, 941, 1281, 1472, 943, 1282, 1473, 
       944, 1283, 1474, 945, 1284, 1475, 946, 647, 947, 1400, 1285, 1476, 948,
        1286, 1477, 949, 1287, 1478, 950, 1288, 1479, 951, 1289, 1480, 952, 
       1290, 1481, 953, 1556, 1171, 1172, 954, 1568, 1217, 1218, 1202, 1248, 
       1247, 955}], 
      Line3DBox[{959, 1401, 1116, 957, 1402, 1117, 961, 1403, 1118, 963, 1404,
        1119, 965, 1405, 1120, 967, 1406, 1121, 969, 1407, 662, 971, 1408, 
       1122, 973, 1409, 1123, 975, 1410, 1124, 977, 1411, 1125, 979, 1412, 
       1126, 981, 1357, 1413, 1127, 1193, 1362, 1570, 1221, 1204, 1236, 1128, 
       1235}], Line3DBox[{983, 1249, 1250, 1203, 1220, 1219, 1569, 982, 1173, 
       1494, 1356, 980, 1493, 1301, 978, 1492, 1300, 976, 1491, 1299, 974, 
       1490, 1298, 972, 1489, 1297, 970, 1488, 661, 968, 1487, 1296, 966, 
       1486, 1295, 964, 1485, 1294, 962, 1484, 1293, 960, 1483, 1292, 956, 
       1482, 1291, 958}], 
      Line3DBox[{985, 1302, 1495, 984, 1414, 1129, 986, 1415, 1130, 987, 1416,
        1131, 988, 1417, 1132, 989, 1418, 1133, 990, 1419, 1303, 1496, 991, 
       676, 992, 1420, 1134, 993, 1421, 1135, 994, 1422, 1136, 995, 1423, 
       1137, 996, 1358, 1424, 1138, 1194, 1565, 1222, 1223, 1205, 1238, 1139, 
       1237}], Line3DBox[{998, 1304, 1497, 997, 1305, 1498, 999, 1425, 1140, 
       1000, 1426, 1141, 1001, 1427, 1142, 1002, 1428, 1143, 1003, 1429, 1306,
        1499, 1004, 1307, 1500, 1005, 690, 1006, 1430, 1144, 1007, 1431, 1145,
        1008, 1432, 1146, 1009, 1557, 1174, 1147, 1195, 1566, 1224, 1175, 
       1206, 1240, 1241, 1239}], 
      Line3DBox[{1011, 1308, 1501, 1010, 1309, 1502, 1012, 1310, 1503, 1013, 
       1433, 1148, 1014, 1434, 1149, 1015, 1435, 1150, 1016, 1436, 1311, 1504,
        1017, 1312, 1505, 1018, 1313, 1506, 1019, 704, 1020, 1437, 1151, 1021,
        1438, 1152, 1022, 1558, 1176, 1153, 1196, 857, 1177, 1207, 1243, 1244,
        1242}], 
      Line3DBox[{1024, 1314, 1507, 1023, 1315, 1508, 1025, 1316, 1509, 1026, 
       1317, 1510, 1027, 1439, 1154, 1028, 1440, 1155, 1029, 1441, 1318, 1511,
        1030, 1319, 1512, 1031, 1320, 1513, 1032, 1321, 1514, 1033, 718, 1034,
        1442, 1156, 1035, 1559, 1178, 1179, 1036, 1363, 1560, 1180, 1208, 
       1181, 1251, 1037}], 
      Line3DBox[{1039, 1322, 1515, 1038, 1323, 1516, 1040, 1324, 1517, 1041, 
       1325, 1518, 1042, 1326, 1519, 1043, 1443, 1157, 1044, 1444, 1327, 1520,
        1045, 1328, 1521, 1046, 1329, 1522, 1047, 1330, 1523, 1048, 1331, 
       1524, 1049, 732, 1050, 1561, 1182, 1183, 1051, 1571, 1225, 1184, 1209, 
       1185, 1252, 1052}], 
      Line3DBox[{1054, 1332, 1525, 1053, 1333, 1526, 1055, 1334, 1527, 1056, 
       1335, 1528, 1057, 1336, 1529, 1058, 1337, 1530, 1059, 1445, 1338, 1531,
        1060, 1339, 1532, 1061, 1340, 1533, 1062, 1341, 1534, 1063, 1342, 
       1535, 1064, 1343, 1536, 1065, 785, 1186, 1066, 1572, 1226, 1227, 1210, 
       1254, 1253, 1067}], 
      Line3DBox[{1081, 1229, 1230, 1211, 1228, 870, 1080, 1189, 1550, 1360, 
       1079, 1549, 1354, 1078, 1548, 1353, 1077, 1547, 1352, 1076, 1546, 1351,
        1075, 1545, 1350, 1074, 1544, 1543, 1349, 1073, 1542, 1348, 1072, 
       1541, 1347, 1071, 1540, 1346, 1070, 1539, 1345, 1069, 1538, 1344, 1068,
        1359, 1537, 1187, 1188}]}}},
   VertexNormals->CompressedData["
1:eJztnHdUVEcbh+loFNHY9YMkCEpRjAE1YosQ1IXFLpYoGAVjQ+oRaUZBiohE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    "]],
  Axes->True,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  Method->{},
  PlotRange->{{0., 0.9999999285714286}, {0., 0.9999999999999974}, {0., 
   0.9999999285714286}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.653952012985424*^9, 3.653952212950274*^9, 
  3.653952410942231*^9, 3.653952540996653*^9, 3.653952638603405*^9, 
  3.653952834968174*^9, 
  3.6548088233967667`*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p3", "=", 
  RowBox[{"ParametricPlot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Blue", ",", 
       RowBox[{"Opacity", "[", "0.5", "]"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.654808726608485*^9, 3.654808766433983*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyF3HuwVWUZgPEtIt4oLamQ0G47zEsEgpcclUgHWVA2OlOjUoho5W0DiXEb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   "], {{
     {RGBColor[0, 0, 1], Opacity[0.5], EdgeForm[None], 
      StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmXfgV9Mbx++553zsEJKQJGRVUtJPGaGhkC0lKQ0kSWRklKZRSZlFhbJn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          "]], Polygon3DBox[CompressedData["
1:eJxNmnncVVMbhvdeayWKDM1zUVSGzGROISoSkVAkUiikkilUKpW5kJAGY4NI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          "]], 
         Polygon3DBox[CompressedData["
1:eJwt13f8luMaAPD3977vL5qi1KGt4TSdNNA8DQkNDeW0HC2rgYaOljSEEi0h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          "]]}],
       Lighting->Automatic]}, {}, {}, {}, {}}, {{}, {}, {}, 
     {GrayLevel[0.2], 
      Line3DBox[{251, 474, 1113, 252, 488, 280, 1222, 503, 295, 1227, 518, 
       310, 1234, 533, 325, 1243, 548, 340, 1254, 563, 1161, 355, 578, 1175, 
       370, 1269, 593, 385, 1273, 608, 400, 1279, 623, 415, 1287, 638, 430, 
       1297, 653, 445, 1309, 668, 460}], 
      Line3DBox[{253, 475, 1114, 254, 489, 1125, 281, 504, 296, 1228, 519, 
       311, 1235, 534, 326, 1244, 549, 341, 1255, 564, 1162, 356, 579, 1176, 
       371, 594, 1187, 386, 1274, 609, 401, 1280, 624, 416, 1288, 639, 431, 
       1298, 654, 446, 1310, 669, 461}], 
      Line3DBox[{255, 476, 1115, 256, 490, 1126, 282, 505, 1136, 297, 520, 
       312, 1236, 535, 327, 1245, 550, 342, 1256, 565, 1163, 357, 580, 1177, 
       372, 595, 1188, 387, 610, 1197, 402, 1281, 625, 417, 1289, 640, 432, 
       1299, 655, 447, 1311, 670, 462}], 
      Line3DBox[{257, 477, 1116, 258, 491, 1127, 283, 506, 1137, 298, 521, 
       1145, 313, 536, 328, 1246, 551, 343, 1257, 566, 1164, 358, 581, 1178, 
       373, 596, 1189, 388, 611, 1198, 403, 626, 1205, 418, 1290, 641, 433, 
       1300, 656, 448, 1312, 671, 463}], 
      Line3DBox[{259, 478, 1117, 260, 492, 1128, 284, 507, 1138, 299, 522, 
       1146, 314, 537, 1152, 329, 552, 344, 1258, 567, 1165, 359, 582, 1179, 
       374, 597, 1190, 389, 612, 1199, 404, 627, 1206, 419, 642, 1211, 434, 
       1301, 657, 449, 1313, 672, 464}], 
      Line3DBox[{261, 479, 1118, 263, 493, 1129, 285, 508, 1139, 300, 523, 
       1147, 315, 538, 1153, 330, 553, 1157, 345, 568, 1166, 360, 583, 1180, 
       375, 598, 1191, 390, 613, 1200, 405, 628, 1207, 420, 643, 1212, 435, 
       658, 1215, 450, 1314, 673, 465}], 
      Line3DBox[{265, 481, 1119, 266, 1220, 495, 287, 1224, 510, 302, 1230, 
       525, 317, 1238, 540, 332, 1248, 555, 347, 1260, 570, 1167, 362, 585, 
       377, 1271, 600, 392, 1276, 615, 407, 1283, 630, 422, 1292, 645, 437, 
       1303, 660, 452, 1316, 675, 467}], 
      Line3DBox[{267, 482, 1120, 268, 496, 1130, 288, 1225, 511, 303, 1231, 
       526, 318, 1239, 541, 333, 1249, 556, 348, 1261, 571, 1168, 363, 586, 
       1181, 378, 601, 393, 1277, 616, 408, 1284, 631, 423, 1293, 646, 438, 
       1304, 661, 453, 1317, 676, 468}], 
      Line3DBox[{269, 483, 1121, 270, 497, 1131, 289, 512, 1140, 304, 1232, 
       527, 319, 1240, 542, 334, 1250, 557, 349, 1262, 572, 1169, 364, 587, 
       1182, 379, 602, 1192, 394, 617, 409, 1285, 632, 424, 1294, 647, 439, 
       1305, 662, 454, 1318, 677, 469}], 
      Line3DBox[{271, 484, 1122, 272, 498, 1132, 290, 513, 1141, 305, 528, 
       1148, 320, 1241, 543, 335, 1251, 558, 350, 1263, 573, 1170, 365, 588, 
       1183, 380, 603, 1193, 395, 618, 1201, 410, 633, 425, 1295, 648, 440, 
       1306, 663, 455, 1319, 678, 470}], 
      Line3DBox[{273, 485, 1123, 274, 499, 1133, 291, 514, 1142, 306, 529, 
       1149, 321, 544, 1154, 336, 1252, 559, 351, 1264, 574, 1171, 366, 589, 
       1184, 381, 604, 1194, 396, 619, 1202, 411, 634, 1208, 426, 649, 441, 
       1307, 664, 456, 1320, 679, 471}], 
      Line3DBox[{275, 486, 1124, 276, 500, 1134, 292, 515, 1143, 307, 530, 
       1150, 322, 545, 1155, 337, 560, 1158, 352, 1265, 575, 1172, 367, 590, 
       1185, 382, 605, 1195, 397, 620, 1203, 412, 635, 1209, 427, 650, 1213, 
       442, 665, 457, 1321, 680, 472}], 
      Line3DBox[{277, 682, 1322, 683, 278, 501, 1135, 293, 516, 1144, 308, 
       531, 1151, 323, 546, 1156, 338, 561, 1159, 353, 576, 1173, 1174, 368, 
       591, 1186, 383, 606, 1196, 398, 621, 1204, 413, 636, 1210, 428, 651, 
       1214, 443, 666, 1216, 458, 685, 686, 687}], 
      Line3DBox[{459, 667, 684, 1308, 444, 652, 1296, 429, 637, 1286, 414, 
       622, 1278, 399, 607, 1272, 384, 592, 1268, 369, 577, 1266, 354, 1160, 
       562, 1253, 339, 547, 1242, 324, 532, 1233, 309, 517, 1226, 294, 502, 
       1221, 279, 487, 1218, 250, 473, 681, 688}], 
      Line3DBox[{466, 674, 1315, 451, 659, 1302, 436, 644, 1291, 421, 629, 
       1282, 406, 614, 1275, 391, 599, 1270, 376, 584, 1267, 361, 569, 1259, 
       346, 554, 1247, 331, 539, 1237, 316, 524, 1229, 301, 509, 1223, 286, 
       494, 1219, 264, 480, 1217, 262}]}, 
     {GrayLevel[0.2], 
      Line3DBox[{690, 1004, 473, 689, 1113, 912, 691, 1114, 913, 692, 1115, 
       914, 693, 1116, 915, 694, 1117, 916, 695, 1118, 1010, 1217, 696, 1119, 
       917, 697, 1120, 918, 698, 1121, 919, 699, 1122, 920, 700, 1123, 921, 
       701, 1124, 922, 702, 1322, 1005, 923, 1006}], 
      Line3DBox[{704, 1011, 1218, 703, 488, 705, 1125, 924, 706, 1126, 925, 
       707, 1127, 926, 708, 1128, 927, 709, 1129, 1012, 1219, 710, 1013, 1220,
        711, 1130, 928, 712, 1131, 929, 713, 1132, 930, 714, 1133, 931, 715, 
       1134, 932, 716, 1135, 933, 717}], 
      Line3DBox[{719, 1014, 1221, 718, 1015, 1222, 720, 504, 721, 1136, 934, 
       722, 1137, 935, 723, 1138, 936, 724, 1139, 1016, 1223, 725, 1017, 1224,
        726, 1018, 1225, 727, 1140, 937, 728, 1141, 938, 729, 1142, 939, 730, 
       1143, 940, 731, 1144, 941, 732}], 
      Line3DBox[{734, 1019, 1226, 733, 1020, 1227, 735, 1021, 1228, 736, 520, 
       737, 1145, 942, 738, 1146, 943, 739, 1147, 1022, 1229, 740, 1023, 1230,
        741, 1024, 1231, 742, 1025, 1232, 743, 1148, 944, 744, 1149, 945, 745,
        1150, 946, 746, 1151, 947, 747}], 
      Line3DBox[{749, 1026, 1233, 748, 1027, 1234, 750, 1028, 1235, 751, 1029,
        1236, 752, 536, 753, 1152, 948, 754, 1153, 1030, 1237, 755, 1031, 
       1238, 756, 1032, 1239, 757, 1033, 1240, 758, 1034, 1241, 759, 1154, 
       949, 760, 1155, 950, 761, 1156, 951, 762}], 
      Line3DBox[{764, 1035, 1242, 763, 1036, 1243, 765, 1037, 1244, 766, 1038,
        1245, 767, 1039, 1246, 768, 552, 769, 1157, 1040, 1247, 770, 1041, 
       1248, 771, 1042, 1249, 772, 1043, 1250, 773, 1044, 1251, 774, 1045, 
       1252, 775, 1158, 952, 776, 1159, 953, 777}], 
      Line3DBox[{781, 1160, 954, 779, 1161, 955, 783, 1162, 956, 785, 1163, 
       957, 787, 1164, 958, 789, 1165, 959, 791, 1166, 569, 793, 1167, 960, 
       795, 1168, 961, 797, 1169, 962, 799, 1170, 963, 801, 1171, 964, 803, 
       1172, 965, 805, 1174, 967, 807}], 
      Line3DBox[{806, 966, 1173, 804, 1265, 1057, 802, 1264, 1056, 800, 1263, 
       1055, 798, 1262, 1054, 796, 1261, 1053, 794, 1260, 1052, 792, 1259, 
       568, 790, 1258, 1051, 788, 1257, 1050, 786, 1256, 1049, 784, 1255, 
       1048, 782, 1254, 1047, 778, 1253, 1046, 780}], 
      Line3DBox[{809, 1058, 1266, 808, 1175, 968, 810, 1176, 969, 811, 1177, 
       970, 812, 1178, 971, 813, 1179, 972, 814, 1180, 1059, 1267, 815, 585, 
       816, 1181, 973, 817, 1182, 974, 818, 1183, 975, 819, 1184, 976, 820, 
       1185, 977, 821, 1186, 978, 822}], 
      Line3DBox[{824, 1060, 1268, 823, 1061, 1269, 825, 1187, 979, 826, 1188, 
       980, 827, 1189, 981, 828, 1190, 982, 829, 1191, 1062, 1270, 830, 1063, 
       1271, 831, 601, 832, 1192, 983, 833, 1193, 984, 834, 1194, 985, 835, 
       1195, 986, 836, 1196, 987, 837}], 
      Line3DBox[{839, 1064, 1272, 838, 1065, 1273, 840, 1066, 1274, 841, 1197,
        988, 842, 1198, 989, 843, 1199, 990, 844, 1200, 1067, 1275, 845, 1068,
        1276, 846, 1069, 1277, 847, 617, 848, 1201, 991, 849, 1202, 992, 850, 
       1203, 993, 851, 1204, 994, 852}], 
      Line3DBox[{854, 1070, 1278, 853, 1071, 1279, 855, 1072, 1280, 856, 1073,
        1281, 857, 1205, 995, 858, 1206, 996, 859, 1207, 1074, 1282, 860, 
       1075, 1283, 861, 1076, 1284, 862, 1077, 1285, 863, 633, 864, 1208, 997,
        865, 1209, 998, 866, 1210, 999, 867}], 
      Line3DBox[{869, 1078, 1286, 868, 1079, 1287, 870, 1080, 1288, 871, 1081,
        1289, 872, 1082, 1290, 873, 1211, 1000, 874, 1212, 1083, 1291, 875, 
       1084, 1292, 876, 1085, 1293, 877, 1086, 1294, 878, 1087, 1295, 879, 
       649, 880, 1213, 1001, 881, 1214, 1002, 882}], 
      Line3DBox[{884, 1088, 1296, 883, 1089, 1297, 885, 1090, 1298, 886, 1091,
        1299, 887, 1092, 1300, 888, 1093, 1301, 889, 1215, 1094, 1302, 890, 
       1095, 1303, 891, 1096, 1304, 892, 1097, 1305, 893, 1098, 1306, 894, 
       1099, 1307, 895, 665, 896, 1216, 1003, 897}], 
      Line3DBox[{911, 1009, 685, 910, 1321, 1111, 909, 1320, 1110, 908, 1319, 
       1109, 907, 1318, 1108, 906, 1317, 1107, 905, 1316, 1106, 904, 1315, 
       1314, 1105, 903, 1313, 1104, 902, 1312, 1103, 901, 1311, 1102, 900, 
       1310, 1101, 899, 1309, 1100, 898, 1112, 1308, 1007, 1008}]}}},
   VertexNormals->CompressedData["
1:eJztyEENwCAABLALC0L4zsQ8IIGEN9aRMAUooH22jdVnSfLW5MnJ/rz33nvv
vffee++9995777333nvvvffee++9995777333nvvvffee++9995777333nvv
vffee++9995777333nvvvffee++99957772/4X+Ksx7u
    "]],
  Axes->True,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  Method->{},
  PlotRange->{{0., 0.9999999285714286}, {0., 0.9999999285714286}, {0., 2.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.65480877137784*^9, 
  3.654808827352091*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p4", "=", 
  RowBox[{"ParametricPlot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "x"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Blue", ",", 
       RowBox[{"Opacity", "[", "0.5", "]"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.653952818145361*^9, 3.653952823621965*^9}, {
  3.653952891125031*^9, 3.65395289299389*^9}, {3.654808734088011*^9, 
  3.6548087359684753`*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyV3H3QXGV9xvFNCFGEKlVsgQKtuoIvmAaISBkkUp2YDVZHZ+qAUQiBtops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   "], {{
     {RGBColor[0, 0, 1], Opacity[0.5], EdgeForm[None], 
      StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmXfgV9Mbx++553zsEJKQJGRVUtJPGaGhkC0lKQ0kSWRklKZRSZlFhbJn
VnZSIoqWtqTS3pH9e7297x/P97zu8z33fu695znPupXbdb3whjzLsuH8iYxf
8+c45C64XsiyA9GfCe+csmwucjDHuzD+gFSES4yzkfLwbozzkUrwyZxbgfEM
zt0V3TzkEI7/h/4Axgboz5WulGVPcTyT33yG4+bw9/AY+Dy4N/MvYLyf+b3g
8+H74PP0O5z7NMfn6F7gkXCCZyH763kYZyLl4Jzxe2Q/3RPXqcx4NtfZHd0C
pArHF6KvyXg5+v3RrUBO4Lg840qkFnwsc3ZjrMWcWvA+ela4NrwvXA+uCe8N
14UzzpuB7MnxvzzXdLgM/B08Gj4XPo75uzPWZnpA9x2yF8cnoC+rd4a+AXwo
3AQ+gP//gtTmeDbXeQ6+CJ4OPw03gyfCD8H14M/gIfDJ8IfwfcWzfAAPLJ5x
Ajwg+fk/h4fC9eFp8JNwQ/gr+HH4THgS/DB8CvwFPAw+FZ4MD4dPg6fAj8Cn
w924/waMd3D/U9E/hv6M3Pb2BHwW/BF8f/Fcn8APwnXgj+EH4BPhBfDLcGu4
OeOhrPsoeA76sRxfDM+Cn4UvhGfAo+Bz4IXwK/CV8Dz4RbgVPB9+Cb4C/gF+
AW4JfwoPgk+Cv4FHwI3gb+Gn4Kbw7TzX2bJTnmsg3AJ+CJ7LnHHMuUT2iv5y
xqHoK6BbVTzLBeiPZ2yB/iB0a4rf+pNzv4ZLskXm1GVsy5yK8F/IEZrP+AdS
Bd6PcRtyMPwX507j3J04Zx90W5GD0B/OGGW/cBU4h4+B94Q3a6/ChzEG9EfD
leEMPorhD675Fdf8F93v8FT4H90HkmS/zNkb3iJ/AR/M+CdyuPYR43akIlyX
83Zhve6RTcO7wr3gkfy/J+OzzHkWvhd+GT6ZObsxpzfHJ8E7w3fDdfR88F3w
U8y/k/E55h+CfkNht79xn1Pg3/j/r/Bk+Fd4D2STfBDzD9TzIIfBnzE+JBvX
/TN3XbFfKqDfIX+BfjvX+QL9Ro53RX5CdpEPYVwmHXw241FaW3gf5v6EHMdx
WcalyLF675qr/c2co3UNuCbcFD5afgjei7lLkKryv7pHxqbo90C3EDmc4wMZ
Vxd7pBzjcqQG/Df3+Y3eF7wf489IdXhPxsXIkXAZxkXIEfC+jMuQavAQfqsN
4+P81kZkBbJcdoWskj9i/BNZEP4zj2xnxvXI/vJdjIsRliYrMf6I7AxHxiXI
TvDfyMLgWPMvsij85yKzMow/y7fq2RmXyyfC/yCr5WflSxnXyM+CW7nA5/KD
OkZWImVksoxrkf3gsowrtOZyw4zrkHLwCMY7uPln4Ifgq+An9Hxc88Nk+2tR
rKP23cXB77s1fEXweraHWwWv59XwRcEx5Ar4suB1uwp+j2v2TV6/S4PffRv0
jYNj5vnwq8y5LXkvnRS8bqejrxO8j0+DawTvv5PghsEx7Tz4kuA1vBJ+l+v0
SY5tb8O9kmNwkyLmyiaHob8ieZ2Gw62T1+YRuE2yTQ+FWyav02Nw2+S1eRhu
lbxmL8A3Je/z6sH+oA7Xbx1sRx3gRsFxuDl8TnDucDF8YrBvO1VxPDgvuBR+
h2vemxznmgfnEZcpTwjONS6BH2XOVcn77RX41mS/9iJ8c7LPUrzYF7khcxwp
h3TN7MOrI/fAx2Ck6xVLmP8qshlelTkGlUW6wLdrDeE3M8eC8siNmWNfZeSW
zDYSou1E8XR3pHPm+FsR6Z45/h6k95U5tlbSvWaOxXsh18NPcJ1e8PfyP9xb
C57lFcUO5Eb0E9G/znhHcv7xGnx7sh+pW/iQBsx5GX2PZP/+ku4x2ae/Bd+d
nK+M1ztIzlfeVK6XnGe8Ad+ZnLso7lfTOUX+th1dI/is4Bzq3Mz5wLE6Bz41
OMfRnNOC85fG8CnB+U5D7TXmXp7sO95Ct47jvdEPiX7/M+HH+d81/G80vBTd
W8zvzPGPWgf4OngR/CrcTusevE5aoyfga+Ex8ErmTEiOK4+h78Q4Cv1i9K+h
v5rjceh76F2ifxpWIvw8vIw5bzOnC8c/wePh6+El8Otwe/gF5t+md8b8CcHr
pDVazZyPmXM/x2vgT+AH4F/gD5Jj1Qr4/WQf9HpwPHyfc98MjnUfwG8Ex8YJ
8g/Bse5d+LXgGPie9gvcT/auvQ/3hz+RDcMPwpPhj+FB8BT4efhW/Sb8PjwQ
/kx7BB4Mfyl/BQ+AP5XNw0PgqfAouKueW/GA+3+X++/O8c/wO/BNisHac8m5
yFjtueTYf2Rw7K3BuVWDY/Lx2jtFbFXse4L5Vyf760sZj2IPPK/9Dx8NvyDf
odgFj1WMVAyEn5Vfk3+FxyiH0N5NznvOly9EPxr9RYp18HPyI4qr8DjFOea3
S443Q5G26J7Uu0LfLTnHekZ7NDm/uTI4lnZkTpvgeNtJ75M5/ZPzudHob5Rt
oh8Dd9NehCsF5w5VZW/M75Qcq0bB1yTHp6fgjslxbox8SXJ+Nhq+Ljl3GSc/
lJy7jIQ7JMfI8sHx8FCu/yT69slx8YDg2F1Z+mK/aI+cqByzZDuuKT9R8r0q
z5nCWJ452+Brk2O88oGtis/IBmSLQ3L2O7IZ+Qk5BMUGrXnmdRmgXBauhu5v
5MTM+dgMrl8ps/9Vjqj8cBOyA/mluJ6uu7rQb0NmFXH/s9x+Qzne9NzPOyvY
FhbCs4PXeRE8J9heFsNT4cfh7+C1ug739yTHXwX7X/neb4LryDnF7+peViKT
FSPRfwtPgR+Fp8NfKkbCM+Bvg2vZufDcYPtaAn8XbIPzi+faXryrecF2vRSe
EVzHzIOnB9e1P8A/BO+DH4t3vkb+qeBfi+NdmLM0eL0Ul2fnriW1H7/JnZ9r
X0zLnf/Lnr/Onf/L9ibnrim0Z7+FqxX2+UXuHF57YVbumld2vovsNXO83pG7
fvkSrqo8JnN9dwzSM3Ptspb3/L/cNeausqfMNjwzdw4sm5+Uu5bZAX+ZbCuy
vUnJ9qS4tiB3ra24Nj93XayY+HPuHoXyqEVwfdkmfGVyDqo8YWHu2lxxc1nu
voTi4Fq4WeY4uDp3T0D77qvcdZD23dTcdZDs/7fMObHyjXm5a3zFzVW5a3PF
2TW5c/V/9D65hz04/oPj+cH585Zi/X4uZEOxpqr9V+bO8XRuz+S+QP3ga5yV
uY+xHj4lc623OLdfVRK9IncOpvpxCVw9c89hee59pzw/RedRR6jWjK7HD4fr
Kp+Aq8Ajkcaccxu/24SxV+Y6ohSdp6muidG5nGqNH3P7c/Vb1uXO69SH2ZA7
d23GdQ6SD4Z3Qt87ua+kPtK2IjdQf2lr8YzqI/1a5A+qPefm9pl7o++XXCOp
nsqjr9mS6x+Drl3mftTG3Pmz6p1/cuefVeFTo59Ftc/fufNn9X/+gs/JXHP9
mzsnV531Z+4850j4eeRSjgfwW5cxDslcc+0UnaO+prha7OUR6DYghxSsPFM1
VDnOfYk5e8p+lDvkrqG2Fra1trD/7sl1/rrCB8n/rC98x6pi38tmQuFLNhf/
38i5m7RvM/tLnatr7Ch4VvEb+q3lhS2L5c9VL2zJXXtO48Ij4Nnw18H5sXyj
+mC7Rdc46mPsHV13qB+1Z3R9pD7GftG1j+rTfaLrHfXT9oBbwdcG+4NumWvt
A6LX7jCtreJc5j7DnNxxRHX9wdE1l551dfEeKqE/JLrWqKwcIDoWV5R9Rddl
h6qeiI7Xsr05ybaoWun33L0+1Wh/wC2La25M7mtpj2xP7j+2De5jye9dHdy7
6lzc85bk3pZ+a1NyH6xDcE+rS3Fvm5N7Yp2Ce0iqR7oG9zh7wNcF95G6Fftx
W3Kv88bgnuit6K8J3peqQToG9+RU47QP7smpjuge3PeS7705uC94Z/FO1if3
A49W7pBc994T3A/rX+yR35J7WLcG27tqpfuLvFr9qweCc/CH4eNkp8m5dTXt
qeTc/ZbgPpx6yP2C8+VB8A3B/U7VTX2Dc/AH4WOUZyXnXv3Rd2AcjL5PcI7/
ANwluIenuun64B6naqvOwX041Vanyg5Lzl+byK5KjtlnwxVKjtlNZRslx+xm
soWSc4L6ss+S8+nq8hvJ9UAt+bqS64Ta8p8l59DHp+y/RofyvBryG8n58QdF
LqFa4Dm4D/wK/Ah8M/wUPDw4dx4JDwvOnUfAPYL7haq5GnO98iX35T8MzlM+
R38m+n1LzsvP0P4qOXcfHFyvPMKcQcH1ynD4weD6aRh8uvZsybVBA7hsybXB
K8E1ynjmnIK+TMm1xHj0D+v30TdEXw79UI7vja5PVV+cpf1ecu/speA6SLXY
aej3KrnGeDm4Hnorc6+4SrTNH8WcHcn9pjuDe7F9Crs6N9rHHgu/kWwTsttG
0f1/ndsYHpg5d20RnbfLDs+L7sHKrppEfzvQGl0S3dfS+l4KP5a51ngwOn9T
rTEoOj9UrTo+d99JufQnuXNUPdcN0XWfbOCy6N7Ro9x/R+Y8DY+Fb4FfzdzD
vCY6/5ctXRE95wT4vWSbUB5+ZXTNq3z+89w9ScW7H5Njm2yvdXQNq/5nB3hc
5r5o++i6Vf3VjtE12tvcQ1/O+wiuh/6jZFtUHXSf8sLMNt85+j61d7pE14ay
geuj62L1aTtF1zKqv+6PzoFVQz0QnQOrX/R27r6cvsv0ja4lte/ujK5JtR97
Rteqsu07ou9NNnxLdD2rfn6/6HpT+/Su6DpU34n6RNew+tYj+5Pt9Qzu098L
3x38TaBfZtvuHl0v3xXc1+8r2wveT3p27f27o+vficF2rTrljuBefe9iv9zM
nHeKfdcjuk5X3+y93D1P1a0f5+69q5b8KHe/XX22d3P3G9U3eyd3T1L9tA9z
98nVy/ogd+9d/bcJufvSyl0nJuf02ne3RfcEtNduje4JqLbtH92vbgR/mrxX
Z6peZVyQuUYeyJxp8CT0w3KzvtEcER1TFNsHR8d39VWaRvsi9ZOW5q7Nlbe+
mTt31bePmtHvXP3S66L9g76z1Ip+z/qG0iA6RiimHR/9PhVDzo+uPWX/ecn7
RDXC/tE9NPXT1BxWr1J9krbRfkPfB+sgAzLnqFuTc1Pd50+5e1/q1VwU/S1A
Nr97yXtAv9s8On4p7xic/JvyLX8m71t9Vzor2n+q13RBdH9YPagLo79N6JvR
GdG+VN/aToj2V+qBtIz+ZqFvSWdG+171i86J9vl6DzWi47u+b54YHXPVj2oW
HQv0TbB2tA3rW1VD5NHMvaOrtccy93E3Fc+rOr5N8T7ld7tG+17V+hNz1/ua
vzn3+1Q/UXmd8kl9Izs5OrbK3k8r1ki2tH/JtqL+1U3IpMx9mu+Ka+r6nxb2
oDq6d3TvTjmtbGVZ5j5Yt+iYpdxYdqacTb2jVtExUX22i5GxhY2pH6hzFT/v
iY6h+t3vCztUT69ddJzSPZ9erKny81+T83J9dzslOn/Qt9F60TmG1r1C8f71
rbB+dE7yf4Yx2Bs=
          "]], Polygon3DBox[CompressedData["
1:eJxNmnncVVMbhvdeayWKDM1zUVSGzGROISoSkVAkUiikkilUKpW5kJAGY4NI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          "]], 
         Polygon3DBox[CompressedData["
1:eJwt13f8luMaAPD3977vL5qi1KGt4TSdNNA8DQkNDeW0HC2rgYaOljSEEi0h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          "]]}],
       Lighting->Automatic]}, {}, {}, {}, {}}, {{}, {}, {}, 
     {GrayLevel[0.2], 
      Line3DBox[{251, 474, 1113, 252, 488, 280, 1222, 503, 295, 1227, 518, 
       310, 1234, 533, 325, 1243, 548, 340, 1254, 563, 1161, 355, 578, 1175, 
       370, 1269, 593, 385, 1273, 608, 400, 1279, 623, 415, 1287, 638, 430, 
       1297, 653, 445, 1309, 668, 460}], 
      Line3DBox[{253, 475, 1114, 254, 489, 1125, 281, 504, 296, 1228, 519, 
       311, 1235, 534, 326, 1244, 549, 341, 1255, 564, 1162, 356, 579, 1176, 
       371, 594, 1187, 386, 1274, 609, 401, 1280, 624, 416, 1288, 639, 431, 
       1298, 654, 446, 1310, 669, 461}], 
      Line3DBox[{255, 476, 1115, 256, 490, 1126, 282, 505, 1136, 297, 520, 
       312, 1236, 535, 327, 1245, 550, 342, 1256, 565, 1163, 357, 580, 1177, 
       372, 595, 1188, 387, 610, 1197, 402, 1281, 625, 417, 1289, 640, 432, 
       1299, 655, 447, 1311, 670, 462}], 
      Line3DBox[{257, 477, 1116, 258, 491, 1127, 283, 506, 1137, 298, 521, 
       1145, 313, 536, 328, 1246, 551, 343, 1257, 566, 1164, 358, 581, 1178, 
       373, 596, 1189, 388, 611, 1198, 403, 626, 1205, 418, 1290, 641, 433, 
       1300, 656, 448, 1312, 671, 463}], 
      Line3DBox[{259, 478, 1117, 260, 492, 1128, 284, 507, 1138, 299, 522, 
       1146, 314, 537, 1152, 329, 552, 344, 1258, 567, 1165, 359, 582, 1179, 
       374, 597, 1190, 389, 612, 1199, 404, 627, 1206, 419, 642, 1211, 434, 
       1301, 657, 449, 1313, 672, 464}], 
      Line3DBox[{261, 479, 1118, 263, 493, 1129, 285, 508, 1139, 300, 523, 
       1147, 315, 538, 1153, 330, 553, 1157, 345, 568, 1166, 360, 583, 1180, 
       375, 598, 1191, 390, 613, 1200, 405, 628, 1207, 420, 643, 1212, 435, 
       658, 1215, 450, 1314, 673, 465}], 
      Line3DBox[{265, 481, 1119, 266, 1220, 495, 287, 1224, 510, 302, 1230, 
       525, 317, 1238, 540, 332, 1248, 555, 347, 1260, 570, 1167, 362, 585, 
       377, 1271, 600, 392, 1276, 615, 407, 1283, 630, 422, 1292, 645, 437, 
       1303, 660, 452, 1316, 675, 467}], 
      Line3DBox[{267, 482, 1120, 268, 496, 1130, 288, 1225, 511, 303, 1231, 
       526, 318, 1239, 541, 333, 1249, 556, 348, 1261, 571, 1168, 363, 586, 
       1181, 378, 601, 393, 1277, 616, 408, 1284, 631, 423, 1293, 646, 438, 
       1304, 661, 453, 1317, 676, 468}], 
      Line3DBox[{269, 483, 1121, 270, 497, 1131, 289, 512, 1140, 304, 1232, 
       527, 319, 1240, 542, 334, 1250, 557, 349, 1262, 572, 1169, 364, 587, 
       1182, 379, 602, 1192, 394, 617, 409, 1285, 632, 424, 1294, 647, 439, 
       1305, 662, 454, 1318, 677, 469}], 
      Line3DBox[{271, 484, 1122, 272, 498, 1132, 290, 513, 1141, 305, 528, 
       1148, 320, 1241, 543, 335, 1251, 558, 350, 1263, 573, 1170, 365, 588, 
       1183, 380, 603, 1193, 395, 618, 1201, 410, 633, 425, 1295, 648, 440, 
       1306, 663, 455, 1319, 678, 470}], 
      Line3DBox[{273, 485, 1123, 274, 499, 1133, 291, 514, 1142, 306, 529, 
       1149, 321, 544, 1154, 336, 1252, 559, 351, 1264, 574, 1171, 366, 589, 
       1184, 381, 604, 1194, 396, 619, 1202, 411, 634, 1208, 426, 649, 441, 
       1307, 664, 456, 1320, 679, 471}], 
      Line3DBox[{275, 486, 1124, 276, 500, 1134, 292, 515, 1143, 307, 530, 
       1150, 322, 545, 1155, 337, 560, 1158, 352, 1265, 575, 1172, 367, 590, 
       1185, 382, 605, 1195, 397, 620, 1203, 412, 635, 1209, 427, 650, 1213, 
       442, 665, 457, 1321, 680, 472}], 
      Line3DBox[{277, 682, 1322, 683, 278, 501, 1135, 293, 516, 1144, 308, 
       531, 1151, 323, 546, 1156, 338, 561, 1159, 353, 576, 1173, 1174, 368, 
       591, 1186, 383, 606, 1196, 398, 621, 1204, 413, 636, 1210, 428, 651, 
       1214, 443, 666, 1216, 458, 685, 686, 687}], 
      Line3DBox[{459, 667, 684, 1308, 444, 652, 1296, 429, 637, 1286, 414, 
       622, 1278, 399, 607, 1272, 384, 592, 1268, 369, 577, 1266, 354, 1160, 
       562, 1253, 339, 547, 1242, 324, 532, 1233, 309, 517, 1226, 294, 502, 
       1221, 279, 487, 1218, 250, 473, 681, 688}], 
      Line3DBox[{466, 674, 1315, 451, 659, 1302, 436, 644, 1291, 421, 629, 
       1282, 406, 614, 1275, 391, 599, 1270, 376, 584, 1267, 361, 569, 1259, 
       346, 554, 1247, 331, 539, 1237, 316, 524, 1229, 301, 509, 1223, 286, 
       494, 1219, 264, 480, 1217, 262}]}, 
     {GrayLevel[0.2], 
      Line3DBox[{690, 1004, 473, 689, 1113, 912, 691, 1114, 913, 692, 1115, 
       914, 693, 1116, 915, 694, 1117, 916, 695, 1118, 1010, 1217, 696, 1119, 
       917, 697, 1120, 918, 698, 1121, 919, 699, 1122, 920, 700, 1123, 921, 
       701, 1124, 922, 702, 1322, 1005, 923, 1006}], 
      Line3DBox[{704, 1011, 1218, 703, 488, 705, 1125, 924, 706, 1126, 925, 
       707, 1127, 926, 708, 1128, 927, 709, 1129, 1012, 1219, 710, 1013, 1220,
        711, 1130, 928, 712, 1131, 929, 713, 1132, 930, 714, 1133, 931, 715, 
       1134, 932, 716, 1135, 933, 717}], 
      Line3DBox[{719, 1014, 1221, 718, 1015, 1222, 720, 504, 721, 1136, 934, 
       722, 1137, 935, 723, 1138, 936, 724, 1139, 1016, 1223, 725, 1017, 1224,
        726, 1018, 1225, 727, 1140, 937, 728, 1141, 938, 729, 1142, 939, 730, 
       1143, 940, 731, 1144, 941, 732}], 
      Line3DBox[{734, 1019, 1226, 733, 1020, 1227, 735, 1021, 1228, 736, 520, 
       737, 1145, 942, 738, 1146, 943, 739, 1147, 1022, 1229, 740, 1023, 1230,
        741, 1024, 1231, 742, 1025, 1232, 743, 1148, 944, 744, 1149, 945, 745,
        1150, 946, 746, 1151, 947, 747}], 
      Line3DBox[{749, 1026, 1233, 748, 1027, 1234, 750, 1028, 1235, 751, 1029,
        1236, 752, 536, 753, 1152, 948, 754, 1153, 1030, 1237, 755, 1031, 
       1238, 756, 1032, 1239, 757, 1033, 1240, 758, 1034, 1241, 759, 1154, 
       949, 760, 1155, 950, 761, 1156, 951, 762}], 
      Line3DBox[{764, 1035, 1242, 763, 1036, 1243, 765, 1037, 1244, 766, 1038,
        1245, 767, 1039, 1246, 768, 552, 769, 1157, 1040, 1247, 770, 1041, 
       1248, 771, 1042, 1249, 772, 1043, 1250, 773, 1044, 1251, 774, 1045, 
       1252, 775, 1158, 952, 776, 1159, 953, 777}], 
      Line3DBox[{781, 1160, 954, 779, 1161, 955, 783, 1162, 956, 785, 1163, 
       957, 787, 1164, 958, 789, 1165, 959, 791, 1166, 569, 793, 1167, 960, 
       795, 1168, 961, 797, 1169, 962, 799, 1170, 963, 801, 1171, 964, 803, 
       1172, 965, 805, 1174, 967, 807}], 
      Line3DBox[{806, 966, 1173, 804, 1265, 1057, 802, 1264, 1056, 800, 1263, 
       1055, 798, 1262, 1054, 796, 1261, 1053, 794, 1260, 1052, 792, 1259, 
       568, 790, 1258, 1051, 788, 1257, 1050, 786, 1256, 1049, 784, 1255, 
       1048, 782, 1254, 1047, 778, 1253, 1046, 780}], 
      Line3DBox[{809, 1058, 1266, 808, 1175, 968, 810, 1176, 969, 811, 1177, 
       970, 812, 1178, 971, 813, 1179, 972, 814, 1180, 1059, 1267, 815, 585, 
       816, 1181, 973, 817, 1182, 974, 818, 1183, 975, 819, 1184, 976, 820, 
       1185, 977, 821, 1186, 978, 822}], 
      Line3DBox[{824, 1060, 1268, 823, 1061, 1269, 825, 1187, 979, 826, 1188, 
       980, 827, 1189, 981, 828, 1190, 982, 829, 1191, 1062, 1270, 830, 1063, 
       1271, 831, 601, 832, 1192, 983, 833, 1193, 984, 834, 1194, 985, 835, 
       1195, 986, 836, 1196, 987, 837}], 
      Line3DBox[{839, 1064, 1272, 838, 1065, 1273, 840, 1066, 1274, 841, 1197,
        988, 842, 1198, 989, 843, 1199, 990, 844, 1200, 1067, 1275, 845, 1068,
        1276, 846, 1069, 1277, 847, 617, 848, 1201, 991, 849, 1202, 992, 850, 
       1203, 993, 851, 1204, 994, 852}], 
      Line3DBox[{854, 1070, 1278, 853, 1071, 1279, 855, 1072, 1280, 856, 1073,
        1281, 857, 1205, 995, 858, 1206, 996, 859, 1207, 1074, 1282, 860, 
       1075, 1283, 861, 1076, 1284, 862, 1077, 1285, 863, 633, 864, 1208, 997,
        865, 1209, 998, 866, 1210, 999, 867}], 
      Line3DBox[{869, 1078, 1286, 868, 1079, 1287, 870, 1080, 1288, 871, 1081,
        1289, 872, 1082, 1290, 873, 1211, 1000, 874, 1212, 1083, 1291, 875, 
       1084, 1292, 876, 1085, 1293, 877, 1086, 1294, 878, 1087, 1295, 879, 
       649, 880, 1213, 1001, 881, 1214, 1002, 882}], 
      Line3DBox[{884, 1088, 1296, 883, 1089, 1297, 885, 1090, 1298, 886, 1091,
        1299, 887, 1092, 1300, 888, 1093, 1301, 889, 1215, 1094, 1302, 890, 
       1095, 1303, 891, 1096, 1304, 892, 1097, 1305, 893, 1098, 1306, 894, 
       1099, 1307, 895, 665, 896, 1216, 1003, 897}], 
      Line3DBox[{911, 1009, 685, 910, 1321, 1111, 909, 1320, 1110, 908, 1319, 
       1109, 907, 1318, 1108, 906, 1317, 1107, 905, 1316, 1106, 904, 1315, 
       1314, 1105, 903, 1313, 1104, 902, 1312, 1103, 901, 1311, 1102, 900, 
       1310, 1101, 899, 1309, 1100, 898, 1112, 1308, 1007, 1008}]}}},
   VertexNormals->CompressedData["
1:eJztyLENQFAYhdE/xCBaKyjsYAQJrRFsIm8TC3hrmIPiVUwgObf5ck87reNc
RUTXRNRPz35b9nQdUVb+wDnnnHPOOeecc84555zzr+eXZ84555xzzjnnnHPO
Oeecc84555xzzjnnnHPOOeecc84555xzzjnnnHPOOeecc84555xzzjnnnHPO
Oeecc8757/0Gn+Qh7Q==
    "]],
  Axes->True,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  Method->{},
  PlotRange->{{0., 0.9999999285714286}, {0., 0.9999999285714286}, {0., 
   0.9999999285714286}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.653952644610341*^9, 3.653952845886984*^9, 
  3.653952893853819*^9, 3.6548087909933233`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"Show", "[", 
   RowBox[{"p1", ",", "p2", ",", "p3", ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.653952023576455*^9, 3.6539520397542543`*^9}, {
  3.653952192663759*^9, 3.653952195421126*^9}, {3.6539522397578583`*^9, 
  3.653952242404285*^9}, {3.653952433077607*^9, 3.653952443490797*^9}, {
  3.6539525599131727`*^9, 3.6539525609581423`*^9}, {3.653952670682459*^9, 
  3.653952680428521*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx1nH+QVeV5gK+IqJEmtNCWFbQ2vdUmsRRd1ljHeHXjrFy01GSmHRTWRbSt
MV6WghWWMQ6tbWSQKF4zK45EiFkZEk3iJMxdcFncGE10ReTXssBFgyKBkBV1
2ia22twmzfscO883h3+Y8+y3977nOee85/vxfvvH8zo//3ejCoXCJ08pFE7+
9f9fn/VE7/LzF132wIn1+xuNt0sc3zrlsof/tPy9UvMl+66p197K+JPH9jeK
5WdLQ/92+kCt8vOMF5+e0Nxbeam0eOclzdXizzK+/fnzvl8s7yo1nXXb+kr9
pxlfMeX5bZX63lLfLV9rKlffzHjbQ/N+WqvUS+0bt68slt/I+EmF3/w7VPpV
4zf/fpLxjmjXGr8H74/P/XJ8D3xSxDEYccG7Iu7JcR7w4TjPnjhveEt4mRWe
7LFQWPZ/x3D/HL/2zLE9w+0Zbs9we4bbM9ye4fYMt2e4PcPtGW7PcHuG2/Ot
OdfhSX0enuH2zLE9w+0Zbs9we4bbM9ye4fYMt2e4PcPtGW7PcHt+Us8BPy/q
euK5qO/HM9yeObZnuD3D7Rluz3B7htsz3J7h9gy3Z7g9w+25qDzEz7frecLz
dl1/PG9XvHiG2zPH9gy3Z7g9w+0Zbs9we4bbM9ye4fYMt+fteg/w8xXKZ3he
oecPzyt0v+B5hc4Pz3B75tie4fYMt2e4PcPtGW7PcHuG2zPcnlfoPczP2/Q+
wXOb8h+e2/S84rlN9xee2+QDz3B75tie4fYMt2e4PcPtGW7PcHuG23Ob+kH8
nPOxZ7g9w+0Zbs9we4bbM9yeObZnuD3D7Rluz3B7htsz3J7h9tyh/hSeO/T+
x3OH3ld47lB+xXOH8gGeO3T/4rlDvvHcoZ+36v62Z7g9w+0Zbs9we4bbc4fG
Afy8X/1ZPPer/4XnfvUX8Nyv9xue+5WP8dyv/NEuX/bcr+vTqnxhzxzbM9ye
4fYMt2e4PcPteZLGE3iepP4vniepv4bnSepf4HmS3od9On97nqR8g+dJej5a
lX/teZK+f1D9D3uG2zPcnuH2DLfnLo3n8Nyl8Qeeu9RfxnOX+ndNOh977tL7
s13Psz13KT+16n1mz126/oPqz9kzx/YMt2e4PcPteVjjaTwPa/yH52GNVxYr
PnseVn+wT8+nPQ/rfYvnYb0fWtU/sOdhPX+D6h/b87DOr0fjQ3uG2zPcnls0
n4HnFo2/h/R99tyi8U2Tnjd7blH/sV3vG3tu0fu5Vf0te25R/hvUeMOeW3R/
9Wi8bc8c2zPcnj2f1Kzft2eP1xfr+bFnj4f69P6wZ/c38ez+Uav6r/bs98+g
xm/27Oe7R/MX9mx/eOb4yOYx284tP1aa99XSg5X6iezY/uE3RbsdcQz35x/R
z/l8ft+ff5N+vkPfZ54XP5/r9nC3z/PD7x/Y8dAFnyhXS11XLKrVKm9nx0vj
eCCOD+h/2i/V/wP6fXvI+3za+fPz4l+qeLtyvo/2B/Q9/Dwvfn4+dmnn2JMK
T5W2jlv4WqPxYR6cOe2MRYXCQGnkws8cbjQ+zJvmtO9+4rWOQuGF0pl/c9qx
RuPD95k57Tt/97pzC4UdpemLd480Gkez9ua0H//ys5MLhT2lOx5+9N1G40jW
3pz2v/7h+EJhX6mn7wu/aDQOZ+3NaT/7yu7TC4WDpV2vTnu/0Xg9a9+IvFDQ
OMrt+Ry3h9NuTvwen2NOe+LbFPHS3pz2nP+E8EF7c9rjd0H4pr057bl+q+N6
0t6c9twf18b9Qntz2nP/jYv7kfbmtPd9y/vD9yfc9yHc9xvc9xXc9w/c9wPc
9wPc1x3u6wv3dYT7esF9XeD2D7dnuD3zPrZnuD3D7Rluz3B7htsz3J7h9gy3
Z7g9w+0Zbs9we4bbM9ye6d/YM9ye4fYMt2e4PcPtGW7PcHuG2zPcnuH2DLdn
uD3D7Rluz/QX7Rluz3B7htsz3J7h9gy3Z7g9w+0Zbs9we4bbM9ye4fYMt2f6
3/YMt2e4PcPtGW7PcHuG2zPcnuH2DLdnuD3D7Rluz3B7htsz4xl7htsz3J7h
9gy3Z7g9w+0Zbs9we4bbM9ye4fYMt2e4PcPtmfGhPcPtGW7PcHuG2zPcnuH2
DLdnuD3D7Rluz3B7htsz3J7h9sx4257h9gy3Z7g9w+0Zbs9we4bbM9ye4fYM
t2e4PcPtGW7PcHtm/sKe4fYMt2e4PcPtGW7PcHuG2zPcnuH2DLdnuD3D7Rlu
z3B7Zj7InuH2DLdnuD3D7Rluz3B7htsz3J7h9gy3Z7g9w+0Zbs9we2Z+zZ7h
9gy3Z7g9w+0Zbs9we4bbczY/KM9we4bbM9ye4fYMt2e4PTNfac9we4bbM9ye
4fYMt2e4PcPtGW7PcHuG2zPcnuH2DLdnuD0zX2fPcHuG2zPcnuH2DLdnuD3D
7Rluz3B7htsz3J7h9pw3z8mxfV5/7xWNTZUnEp+PfLznSGd9feLzYMxH2+cl
j+26ua/ySOLz6Zh/tc9/+tXmD/68/C+Jzxty5g9HRfz2eWXEb593R/z2+VzE
b58fifiTcV/Eb5933bdwc7X4g8Qnx/Z56carrjtY6098vtpYsq230pf4/NLV
3yo9WNyc+Dz7ofr35tdric+tb4w9d0Z1Y+Jzfc7825KI3z6nR/z2OTXit8+d
Eb99/mPEb5+/F/E7D2yM+O35Pzu+PVIsDyaef3RK2/pq8cXEM8f2/PefW9w0
v/6jxPNFv/zY7nrt+cTzmK9tWFmuPpd43tt6RVtv5YeJ57Nz5t/eifjteSDi
t+dVEb89z4347XlqxG/PhYjfnndG/PbcO/E/7q/Xdiae135x4LZqcWfi+Z6t
K8vl6o7EM8f2/J0XZoyZX9+eeL5r/uFn6rWXE88zJ9zZVa5uSzy/lDP/tjHi
t+c1Eb89/2vEb8+3xf/2vCHit+clEb89lyN+e170zw98s1hO599m72n/cr02
lHj+7HmfvKlaHEo8f2rpL0rl6p7EM8f2/P4f3f9ftcruxPPhhbP3VurpPOc9
OfNvCyJ+e54V8dvz5RG/Pf9ZxG/P4+L37Pm9iN+eD0X89vwXx6f8sFI/kHj+
w8+8v7ZYPpB4btz/4zvrtf2J56NvPHhdtbg/8fxKy9yLytV9iWeO7Xlt/b23
a5XhxPNnc+bfzo/47XlCxG/PH0T89vxmxG/P2yJ+e94Y32PPayJ+e/7557cd
rFV+knje/fjqzZX6a4nnvvdu7i6WX0s8f+PqCxbVa68mnu999H/+ulp8NfG8
6N0Xzy9XDyaeObZnju35WMRvzzsifnveFPHb87qI356XR/z2vCDit+dZEZc9
7yYvyvNVpz7yhXrt9dTz1JP21SqvJ56nXv8PbdXi64nnnrtf3lipp/OcE7/d
/CflajrPuXLvww8Uy+k85w05828cJ/PJEb89Px3x2/OUiN+eH4v47fkPIv5k
3j7it+cLqicvL5bT+bfHI257bjryys312uHE830fvWh3rXI48Tzq4jVXVIuH
E8933DjqqUo9nec8vuKWs8vVdJ5zS87829SI356z75HniRG/Pa+M+O25EPHb
8+0Rvz0fi/jt+f62XRPK1XT+7eQFF99dLKfzb4sjbnseeXb03HrtSOJ57sit
22uVI4nnPb+/89Jq8UjieXrp009U6uk855k582/3Rfz2PCrit2eO7fl4xG/P
N0T89rwr4k/WRyJ+e37rv9d9vVI/lni+sXjquHL1WOJ56K8qdxXLxxLPM+J/
e9667i9n12tHE88XDq59sVY5mnhe/++nXFwtHk08L8mZfxuJ+O15bsRvz3si
fnvm2J63RPz2PDXit+eeiN+er/5u55RqMZ1/e2bf0JpK/XjiuXnUpWeUq8cT
zxs+9VhXsXw88Tw5fs+eV901/2/rtXSec/SGPc/VKuk8596c+bcZEb89b434
7fnCiN+e10f89syxPd8X8dvzqIjfnr9502V9tUo6/3bWV3o+US2m828P1D6y
ulIfSTyPObRgTLk6knheevrw7cXySOL5BP10eZ435xufq9fSec5pOfNvGyJ+
e54c8SfjwYjfnkdH/Pa8JOK3Z47teW7Eb89jJv7O9HotnX+jrs6eT9y6v1gt
pvNv1C0m88n9j59Urp5IPF999IwFxfKJxPMzEZc9r8qZfxsd8dvzkojfnt+K
+O35xojfnocifnueEfHb53Mx32X/5+bwc+J/f85A/O/2W3P4aeHBPG+eMO/v
DNDO9ZZw1zPDXc8Mdz0z3PXMcNczw13PDHc9M9z1zHDXM8Ndzwx3PTPc9cxw
++S5sk+4fcLtE26fcPuE2yfcPuH2CbdPuH3C7RNun3D7hLseGG7P5Cl7htsz
3J7h9gy3Z7g9w+0Zbs9we4bbM9ye4fYMt2e4PcPtmbxvz3B7htsz3J7h9gy3
Z7g9w+0Zbs9we4bbM9ye4fYMt2e4PfMetWe4PcPtGW7PcHuG2zPcnuH2DLdn
uD3D7Rluz3B7htsz3J7pl9gz3J7h9gy3Z7g9w+0Zbs9we4bbM9ye4fYMt2e4
PcPtGW7P9PPM6efZP+3Nae/rQntz2vt60d6c9r6OtDenva8v7c1p7+tOe3Pa
+36gvTntfZ/Q3pz2vn9ob05731e0N6e97zfam9Pe9yHtzWnv+5P25rT3fUt7
c9r7vvV+GtcH+D50Xf9izYP4vnLddJ/mAX2fuC6V+8F1lK1ah/D1dZ3aoNbh
fL1cB9SjdWj7d50Fnr3fqFn1K/bsfSpDqiuyZ+8DaFJdnT27zrpddaX27DrW
VtVV27PrBAe1r8CeXYfVo3019uw6Fzx7f1iz6oHs2fuEhlSnZc/eh9GkOkV7
dp17u+p07dl1xK2qU7dn12kOap+GPbsOrkf7lOzZdUZ49r69ZtVX2bP3aQ2p
7s2evQ+mSXWf9ux9Bu2qe7Zn13G3qu7fnl0nO6h9L/bsOsQe7fuyZ9d54dn7
KZtVr2bP3ic3pDpCe/Y+pCbV0dqz93m0q47cnl1H36p9FPbsOuVB7SOyZ9eB
9mgfnT27zg7P3ufarPo/e/Y+xSHVZdqz94E1qS7Znr3Ppl11+fbsfQyt2pdi
z64TH9S+LHt2HW6P9iXas+sc8ez9x82qp7RP719crHpi+/T+sD7V09un99/g
0/tFWrWfxz5djz+o/Wz26XrnHu3ntE/Xk+IT/qWog7tR8+DUnZ2sdQjqpLwO
tDDqYq7SOtyUqOP4mdZBWc+/Xuv9rD8/qnoL1kvfUL0L63vXqN6I9ag9qvdi
/WST6u2Y718W89Fw6uxYp2Gejbow1sng1DGxTgmn7oZ1Yvj66HdQdwIfHeuo
1P3AWbe8M+qu4KyzjY66NzjrQhOj7hDuvw8Ap66NdUHmu6jDYl0WTt0Q6+Lw
JfGep54JvjfWJ6kng0+L9TTq+eDVWP9ZEPWUcNZbLo+6VTh1YawrM49EHRPr
+nDWdal7g7MOSd0hnHWzHVH3CWed51DU18Kpk6LOgPkW1jOpd4Sz/ka9aTbP
E+stq6KuF866HHWrzDOwjnRt1AfDqS+epnkG6mT3an6Aus4lmgegDvFMjfep
m9uicT11Xjdo/M7xlRp38/vLNb7m+7ZpHE1852i8zPls0LiY85+r8S/rbKfF
88/4d1WWPwub/v/4tyvyJ+ugjNfejfzJOjScOk3qAODUFVKHAacOjjoYOHUu
6yJPwqnLeDPyJJw6gmsjT8JZ994XeRLOOu1A5MlsXT3yZKHx2zwJ/0HkSdbj
GU9Rf0o9BJx6SepR4Fl9X+RJOHUlH0Q+hFMHsSzyIZx1+9MiH8JZZz4n8mE2
rox8eCjyIfzuyIfUeTB+KUU+pM4GTh0idU5w6jKeirwHp47g4sh7cNa9l0Xe
g7NOOzfyHvy8yHvUA9H/Pxx5j3osOHUKt0R+g7OufijyG5x14Hciv8Ffivx2
ZuQ3+sOsw18eeSyrr4k89lTkMTjrxnMjX9HfY934lLjveC+zDlzQOrH7OXDW
mU/VerD753DWjQtanz4e9ZL3qn5uVsTNefA+pQ6UOjw4dYsLow4Svia87A1P
vNfYP4FXOPWk1P/Bt0T9IPWXWb1CXCfqX+EH9HeWeH8djPuA+wLOfgLuIzh1
rNQpwqm7pE4Uzn1JnS6c+5g6afin477n/c97kP0iPDdw9jfwnMGpx+e5hFNv
S/0lnPpQ6l/hPOc893DyAvXfcPII9ffwTfo7Uryvz4o8Rd6Csz+DPAdnPwF5
EU79O3kUTh0xdahw6l6pA4aTl8nTcPI4eR1O3uc9AOc9wT6QLJ543uiP8/5l
fw/vJTj7UXiPwdk/wXsPTr0/70k49em8V+HU+VInDed9zPsZzvub9zmc9z3v
fzj9A/bJwOlPsE8pa6/8x/v3aMRHvFldZ+SlayIv8V6bEfmG/iP8lbjeXP9s
vjfuj9vjfoHfE/lqX+Qr3kfTIl/Rn4VXI9/Q/4X3xnPFcwbnOVwZzyWc/vSO
yGPwH0ceuznyGO+p3ZHH6L9n9VmRx+jvw7+o8QF8beQv8hmcfNcTP4cz3jgW
+Q3O+OT8yG/wj0Z+eyfyG+/HRZHfGA/BL4j8xvgJvj7yG+Mt+Mci3zA+y/Yz
hV/eG3DeK1vi+sAZ7xVW/TbvwRkfXhl5D854cnnkPfhXIu/dGXmP9z775M6O
vJfNX0XeG4i8B18ceW9e5D34LyPvMZ6Gfz/yDeNveGfc39Pjfofz/t4Tzwec
8fzEyIdwxv9zIh/CmS9YF/kQzvzCC5EP4ewL/FbkPfoh7GO7JvIefEbkvROR
9+DsE1oVeQ/OvpYLI+/Br4t8s4f9lcyPRX4ZiXwDp859auTDbN4s8uHtkQ/h
zB9tinwIp+71vciHcOo0l0U+hE+OfLhF9X+u26Sf5rpNuOs24a7bzObBVLc5
VuNF8i/c9Zlw12fCXZ8Jd30m3PWZcNdn5nnAlz3A7WGm5hs4j2wezPsZg/t8
4T5fuM8X7vP19eZ84a7/zDvfbs3HEBfc5wv3+cJ9XnCfl68H5wX3ecF9Xnnx
c56OH+747WWB5sccZ9ZvV5xwx5kXD3E7Hri/F+7vzfrb+t68zycOfw7cn9Or
55WfMy/k+xGe7LsMbt9wX0e4vcF9XnDnH7ifR7jvW7jvh2xeTtcFbp9w+8z6
+eJ5Pv2c8f1596/vI87P1x8f3k/Jcd4+Pri9Zf1weYPbWzZf531Peg+P03vF
Hvx88/1+zrL9j9q/yzH/20Pefjq4zxfu8+1R/+tavSeS/Uc55+X93xxn44uc
fYA+r7x9aneov7xa+d3xZ/vDFH9enHyf44Qn+/Vy9nNl+wIVD9zx5H0vn+vv
zdvHBPfn531O3n4c50v2uYzVPJ/7eW4/U88NeW+m+kF8TndOP6Jb+YzP79bz
yud3674mP3SrX8b3dqpfk41DcvoFncq7xNOpvEI8nXr+iKdT9zXPb6f6lcQ5
Xv0y4hyvfg1xjtfncZ+N1/uE+McrXxL/eOUV4vfzQ/xwP7/j1Y/O/u6H+qGc
V6+uG+fVK39+fhxXr96rnG+v3hucr59Dzjebf9P5wn2+cOeHvH7LbD0f2d/l
0H3t59keZuu6Oc/6/PL+XoHzBX7g9gO3n2xeTn7g9gN3foPbm/tZxO/xXzbu
1TiJ73E/js9xf2SOzt+f7/EZn+9xDOftfiXf6/7RHPm1f4+PicfjSOLxeIt4
/Hd0OHa/mDjdv5uj6538fSf1FyYoXzh+j4+J339viWPnab+n/Vx4HJDtu1d/
do7uV5+Xr+cEjZd8/3v+g/P13/Hi2O9D9wOSv0ug94P7Sc4Dee999/fn6Pm0
B9/vEzQ+tAdfz9Uab9tP3vyS+xHuD9mP36vuL9qP87THA/bm/DRH46tkn7vy
xwSNn+3Nz8dqzUc4f+btz8Xv/wKjWLIe
    "], {{
      {RGBColor[1, 0, 0], Opacity[0.5], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmXfgV9Mbx++553zsEJKQJGRVUtJPGaGhkC0lKQ0kSWRklKZRSZlFhbJn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           "]], Polygon3DBox[CompressedData["
1:eJxNmnncVVMbhvdeayWKDM1zUVSGzGROISoSkVAkUiikkilUKpW5kJAGY4NI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           "]], 
          Polygon3DBox[CompressedData["
1:eJwt13f8luMaAPD3977vL5qi1KGt4TSdNNA8DQkNDeW0HC2rgYaOljSEEi0h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           "]]}],
        Lighting->Automatic]}, {}, {}, {}, {}}, {{}, {}, {}, 
      {GrayLevel[0.2], 
       Line3DBox[{251, 474, 1113, 252, 488, 280, 1222, 503, 295, 1227, 518, 
        310, 1234, 533, 325, 1243, 548, 340, 1254, 563, 1161, 355, 578, 1175, 
        370, 1269, 593, 385, 1273, 608, 400, 1279, 623, 415, 1287, 638, 430, 
        1297, 653, 445, 1309, 668, 460}], 
       Line3DBox[{253, 475, 1114, 254, 489, 1125, 281, 504, 296, 1228, 519, 
        311, 1235, 534, 326, 1244, 549, 341, 1255, 564, 1162, 356, 579, 1176, 
        371, 594, 1187, 386, 1274, 609, 401, 1280, 624, 416, 1288, 639, 431, 
        1298, 654, 446, 1310, 669, 461}], 
       Line3DBox[{255, 476, 1115, 256, 490, 1126, 282, 505, 1136, 297, 520, 
        312, 1236, 535, 327, 1245, 550, 342, 1256, 565, 1163, 357, 580, 1177, 
        372, 595, 1188, 387, 610, 1197, 402, 1281, 625, 417, 1289, 640, 432, 
        1299, 655, 447, 1311, 670, 462}], 
       Line3DBox[{257, 477, 1116, 258, 491, 1127, 283, 506, 1137, 298, 521, 
        1145, 313, 536, 328, 1246, 551, 343, 1257, 566, 1164, 358, 581, 1178, 
        373, 596, 1189, 388, 611, 1198, 403, 626, 1205, 418, 1290, 641, 433, 
        1300, 656, 448, 1312, 671, 463}], 
       Line3DBox[{259, 478, 1117, 260, 492, 1128, 284, 507, 1138, 299, 522, 
        1146, 314, 537, 1152, 329, 552, 344, 1258, 567, 1165, 359, 582, 1179, 
        374, 597, 1190, 389, 612, 1199, 404, 627, 1206, 419, 642, 1211, 434, 
        1301, 657, 449, 1313, 672, 464}], 
       Line3DBox[{261, 479, 1118, 263, 493, 1129, 285, 508, 1139, 300, 523, 
        1147, 315, 538, 1153, 330, 553, 1157, 345, 568, 1166, 360, 583, 1180, 
        375, 598, 1191, 390, 613, 1200, 405, 628, 1207, 420, 643, 1212, 435, 
        658, 1215, 450, 1314, 673, 465}], 
       Line3DBox[{265, 481, 1119, 266, 1220, 495, 287, 1224, 510, 302, 1230, 
        525, 317, 1238, 540, 332, 1248, 555, 347, 1260, 570, 1167, 362, 585, 
        377, 1271, 600, 392, 1276, 615, 407, 1283, 630, 422, 1292, 645, 437, 
        1303, 660, 452, 1316, 675, 467}], 
       Line3DBox[{267, 482, 1120, 268, 496, 1130, 288, 1225, 511, 303, 1231, 
        526, 318, 1239, 541, 333, 1249, 556, 348, 1261, 571, 1168, 363, 586, 
        1181, 378, 601, 393, 1277, 616, 408, 1284, 631, 423, 1293, 646, 438, 
        1304, 661, 453, 1317, 676, 468}], 
       Line3DBox[{269, 483, 1121, 270, 497, 1131, 289, 512, 1140, 304, 1232, 
        527, 319, 1240, 542, 334, 1250, 557, 349, 1262, 572, 1169, 364, 587, 
        1182, 379, 602, 1192, 394, 617, 409, 1285, 632, 424, 1294, 647, 439, 
        1305, 662, 454, 1318, 677, 469}], 
       Line3DBox[{271, 484, 1122, 272, 498, 1132, 290, 513, 1141, 305, 528, 
        1148, 320, 1241, 543, 335, 1251, 558, 350, 1263, 573, 1170, 365, 588, 
        1183, 380, 603, 1193, 395, 618, 1201, 410, 633, 425, 1295, 648, 440, 
        1306, 663, 455, 1319, 678, 470}], 
       Line3DBox[{273, 485, 1123, 274, 499, 1133, 291, 514, 1142, 306, 529, 
        1149, 321, 544, 1154, 336, 1252, 559, 351, 1264, 574, 1171, 366, 589, 
        1184, 381, 604, 1194, 396, 619, 1202, 411, 634, 1208, 426, 649, 441, 
        1307, 664, 456, 1320, 679, 471}], 
       Line3DBox[{275, 486, 1124, 276, 500, 1134, 292, 515, 1143, 307, 530, 
        1150, 322, 545, 1155, 337, 560, 1158, 352, 1265, 575, 1172, 367, 590, 
        1185, 382, 605, 1195, 397, 620, 1203, 412, 635, 1209, 427, 650, 1213, 
        442, 665, 457, 1321, 680, 472}], 
       Line3DBox[{277, 682, 1322, 683, 278, 501, 1135, 293, 516, 1144, 308, 
        531, 1151, 323, 546, 1156, 338, 561, 1159, 353, 576, 1173, 1174, 368, 
        591, 1186, 383, 606, 1196, 398, 621, 1204, 413, 636, 1210, 428, 651, 
        1214, 443, 666, 1216, 458, 685, 686, 687}], 
       Line3DBox[{459, 667, 684, 1308, 444, 652, 1296, 429, 637, 1286, 414, 
        622, 1278, 399, 607, 1272, 384, 592, 1268, 369, 577, 1266, 354, 1160, 
        562, 1253, 339, 547, 1242, 324, 532, 1233, 309, 517, 1226, 294, 502, 
        1221, 279, 487, 1218, 250, 473, 681, 688}], 
       Line3DBox[{466, 674, 1315, 451, 659, 1302, 436, 644, 1291, 421, 629, 
        1282, 406, 614, 1275, 391, 599, 1270, 376, 584, 1267, 361, 569, 1259, 
        346, 554, 1247, 331, 539, 1237, 316, 524, 1229, 301, 509, 1223, 286, 
        494, 1219, 264, 480, 1217, 262}]}, 
      {GrayLevel[0.2], 
       Line3DBox[{690, 1004, 473, 689, 1113, 912, 691, 1114, 913, 692, 1115, 
        914, 693, 1116, 915, 694, 1117, 916, 695, 1118, 1010, 1217, 696, 1119,
         917, 697, 1120, 918, 698, 1121, 919, 699, 1122, 920, 700, 1123, 921, 
        701, 1124, 922, 702, 1322, 1005, 923, 1006}], 
       Line3DBox[{704, 1011, 1218, 703, 488, 705, 1125, 924, 706, 1126, 925, 
        707, 1127, 926, 708, 1128, 927, 709, 1129, 1012, 1219, 710, 1013, 
        1220, 711, 1130, 928, 712, 1131, 929, 713, 1132, 930, 714, 1133, 931, 
        715, 1134, 932, 716, 1135, 933, 717}], 
       Line3DBox[{719, 1014, 1221, 718, 1015, 1222, 720, 504, 721, 1136, 934, 
        722, 1137, 935, 723, 1138, 936, 724, 1139, 1016, 1223, 725, 1017, 
        1224, 726, 1018, 1225, 727, 1140, 937, 728, 1141, 938, 729, 1142, 939,
         730, 1143, 940, 731, 1144, 941, 732}], 
       Line3DBox[{734, 1019, 1226, 733, 1020, 1227, 735, 1021, 1228, 736, 520,
         737, 1145, 942, 738, 1146, 943, 739, 1147, 1022, 1229, 740, 1023, 
        1230, 741, 1024, 1231, 742, 1025, 1232, 743, 1148, 944, 744, 1149, 
        945, 745, 1150, 946, 746, 1151, 947, 747}], 
       Line3DBox[{749, 1026, 1233, 748, 1027, 1234, 750, 1028, 1235, 751, 
        1029, 1236, 752, 536, 753, 1152, 948, 754, 1153, 1030, 1237, 755, 
        1031, 1238, 756, 1032, 1239, 757, 1033, 1240, 758, 1034, 1241, 759, 
        1154, 949, 760, 1155, 950, 761, 1156, 951, 762}], 
       Line3DBox[{764, 1035, 1242, 763, 1036, 1243, 765, 1037, 1244, 766, 
        1038, 1245, 767, 1039, 1246, 768, 552, 769, 1157, 1040, 1247, 770, 
        1041, 1248, 771, 1042, 1249, 772, 1043, 1250, 773, 1044, 1251, 774, 
        1045, 1252, 775, 1158, 952, 776, 1159, 953, 777}], 
       Line3DBox[{781, 1160, 954, 779, 1161, 955, 783, 1162, 956, 785, 1163, 
        957, 787, 1164, 958, 789, 1165, 959, 791, 1166, 569, 793, 1167, 960, 
        795, 1168, 961, 797, 1169, 962, 799, 1170, 963, 801, 1171, 964, 803, 
        1172, 965, 805, 1174, 967, 807}], 
       Line3DBox[{806, 966, 1173, 804, 1265, 1057, 802, 1264, 1056, 800, 1263,
         1055, 798, 1262, 1054, 796, 1261, 1053, 794, 1260, 1052, 792, 1259, 
        568, 790, 1258, 1051, 788, 1257, 1050, 786, 1256, 1049, 784, 1255, 
        1048, 782, 1254, 1047, 778, 1253, 1046, 780}], 
       Line3DBox[{809, 1058, 1266, 808, 1175, 968, 810, 1176, 969, 811, 1177, 
        970, 812, 1178, 971, 813, 1179, 972, 814, 1180, 1059, 1267, 815, 585, 
        816, 1181, 973, 817, 1182, 974, 818, 1183, 975, 819, 1184, 976, 820, 
        1185, 977, 821, 1186, 978, 822}], 
       Line3DBox[{824, 1060, 1268, 823, 1061, 1269, 825, 1187, 979, 826, 1188,
         980, 827, 1189, 981, 828, 1190, 982, 829, 1191, 1062, 1270, 830, 
        1063, 1271, 831, 601, 832, 1192, 983, 833, 1193, 984, 834, 1194, 985, 
        835, 1195, 986, 836, 1196, 987, 837}], 
       Line3DBox[{839, 1064, 1272, 838, 1065, 1273, 840, 1066, 1274, 841, 
        1197, 988, 842, 1198, 989, 843, 1199, 990, 844, 1200, 1067, 1275, 845,
         1068, 1276, 846, 1069, 1277, 847, 617, 848, 1201, 991, 849, 1202, 
        992, 850, 1203, 993, 851, 1204, 994, 852}], 
       Line3DBox[{854, 1070, 1278, 853, 1071, 1279, 855, 1072, 1280, 856, 
        1073, 1281, 857, 1205, 995, 858, 1206, 996, 859, 1207, 1074, 1282, 
        860, 1075, 1283, 861, 1076, 1284, 862, 1077, 1285, 863, 633, 864, 
        1208, 997, 865, 1209, 998, 866, 1210, 999, 867}], 
       Line3DBox[{869, 1078, 1286, 868, 1079, 1287, 870, 1080, 1288, 871, 
        1081, 1289, 872, 1082, 1290, 873, 1211, 1000, 874, 1212, 1083, 1291, 
        875, 1084, 1292, 876, 1085, 1293, 877, 1086, 1294, 878, 1087, 1295, 
        879, 649, 880, 1213, 1001, 881, 1214, 1002, 882}], 
       Line3DBox[{884, 1088, 1296, 883, 1089, 1297, 885, 1090, 1298, 886, 
        1091, 1299, 887, 1092, 1300, 888, 1093, 1301, 889, 1215, 1094, 1302, 
        890, 1095, 1303, 891, 1096, 1304, 892, 1097, 1305, 893, 1098, 1306, 
        894, 1099, 1307, 895, 665, 896, 1216, 1003, 897}], 
       Line3DBox[{911, 1009, 685, 910, 1321, 1111, 909, 1320, 1110, 908, 1319,
         1109, 907, 1318, 1108, 906, 1317, 1107, 905, 1316, 1106, 904, 1315, 
        1314, 1105, 903, 1313, 1104, 902, 1312, 1103, 901, 1311, 1102, 900, 
        1310, 1101, 899, 1309, 1100, 898, 1112, 1308, 1007, 1008}]}}},
    VertexNormals->CompressedData["
1:eJztyDENgEAURMEfCEJosYALJJAcLRJwQnCCAc7G6YDiqHBAZpuXnX5ep9RE
xNBFtE+vcVv2o5xvo45zzjnnnHPOOeecc84551/P9WfOOeecc84555xzzjnn
nHPOOeecc84555xzzjnnnHPOOeecc84555xzzjnnnHPOOeecc84555xzzjnn
nHPO+W/8BsS3tws=
     "]], GraphicsComplex3DBox[CompressedData["
1:eJx1nHfUFdX1QD8QUcQa8RcxSkx8QmIIgmJJorzYkIeiMcUSDCJCsD3wJ4mi
YkOjqNgeKBoRRBARY2zkIUVA7IqGLvioIlIF1ESNgF/a2TNZe9b4j2v2usx3
Zs99Z+bee+58p0ffn/dqWFdXV2hcV7fDv/4/6uwnJw5q3a/Duvp//7e5yPHF
bTo8eHDpueLt40aetPeGlP9p7eL6Qmlm8YPHWh3y1ZMpL0xudvjE8tvFZadf
XfrLcSl/99VWzxdKc4v7PnP8ypvGb0r47W1enVWuLSxu2/WRX01d9XHCOw7r
8VG1XCvePO0nvW5btzHhDer+/d+K4vhTz157dXVDws+b8O7gQumDYoM2Tw97
/fj1CX/xwoeblyofFodv79Dl7wPXJvxbB1w6tlz7qLhp779Pat/ro4RfNefH
h1cK64otnx/bf8DbqxL+3h+azKiWNxQnjZj18C3XrEj4ET9edGqt+nFxdYvd
Tt42472E37tp7OJ/e/zZvpfu2O7VoxNuz/i1Z47tGW7PcHtOzivPcHuG2zPc
nuH2DLdnuD3D7Rluz3B7htszHu0Zbs8c2zPcnuH2DLdnuD3D7Rluz3B7htsz
3J7h9gy3Z7g948ue4fYMt2eO7Rluz3B7htsz3J7h9gy3Z7g9w+0Zbs9we4bb
M17sGW7PcHuG2zPH9gy3Z7g9w+0Zbs9we4bbM9ye4fYMt2e4PXP99gy3Z7g9
w+0Zbs8c2zPcnuH2DLdnuD3D7Rluz3B7htsz3J65TnuG2zPcnuH2DLdnuD1z
bM9we4bbM9ye4fYMt2e4PcPtGW7PXI89w+0Zbs9we4bbM9ye4fbMsT3D7Rlu
z3B7htsz3J7h9gy3Z+K2Z7g9w+0Zbs9we4bbc+JRnuH2zLE9w+0Zbs9we4bb
M9ye4fZMfPYMt2e4PcPtGW7PcHuG2zPcnuH2zLE9w+0Zbs9we4bbM9yeicOe
4fYMt2e4PcPtGW7PcHuG2zPcnuH2zLE9w+0Zbs9we4bbM3/PnuH2DLdnuD3D
7Rluz3B7htsz3J7h9gy3Z47tGW7PcHuG2zPntWe4PcPtGW7PcHuG2zPcnuH2
DLdnuD3D7RluzxzbM9ye4fbMv7dnuD3D7Rluz3B7htsz3J7h9gy3Z7g9w+0Z
bs9we+bYnuH2TDt7htsz3J7h9gy3Z7g9w+0Zbs9we4bbM9ye4fYMt2e4PXO8
elLjWS1LjxZHH/Gz5q99lR7bP7zxissalyobi8t3e+Lc8+YuSfgFQ4tDyrVN
xSffvbnF7Z/NzuV584d5519Z33/WxPKUzHngbn/hGVc271N7LdMe7vaX7XVO
y7q62Zn2cLdvffXnxVJlfqY93O3XfjDknEphcaY93O3HnNKuX626NNMe7vZt
f927Y6WwMtMe7vZ37X7kvGp5VaY93O03zmzUvVZdnWkPd/vOV87bWF+/JtMe
7vbjfvDoVYXS+kx7uNtz7PZw92fauT/DfX64z8+x+21e+7zfV968Ou3M6efm
9Gdz+q05/dOcfmhOfzOnX5nTf8zpJ+b0B3Puu3ne/c3Le3n3heeHOc8Pc54f
5jw/zHl+mPP8MOf5Yc7zw5znhznPD3OeH+Y8P8zxePVx/arV8ubi4AtunLe8
2RvFc+84rv6F8pPFU9c0vaxQ2lQ8Y1t1r4fHz8/lLYfVnutTq2b4ae2b9qur
m5Hhuzw8bnCp8kqGv7Zjx7GVwpsZPrDPqum16jsZPvKSGZdWCnMyfPu37/5H
tTwvw7vO/80tteqCDJ80qPXedXWLMvybx24dWSi9n+G//+TN1qXKkgyf99gD
k8q1ZRm+71OHH1SqrMjwTjs9dFGtujLDrzi/4TPl2gcZPnbKRZ/X16/K8Pn7
zDmmUlid4Y0uO/qmQumjDD/srZFvVstrMrxHYac9S5W1GX7PdX3OrFXXZfiM
RQuGl2vrM3zTYceuqq/fkOEt7hzz/Urh4wzn2P0Q/v7sYe2+X6oU+3S56o/P
fr05OXZ7uNvTzu05dp4nD7s9/dntyc9uT392e/K229Of3Z587vb0Z7cnz7s9
/dntyf9uT392e54Lbk9/dnueF25Pf3Z7niNuT392e54vbk9/dnueO25Pf3Z7
nkduT3/2+0Ze/6SdOfnTnDxpTj40J++Zk9/MyWPm5Ctz8pI5+cecPGNOPjEn
b9g/7fy7pp153riDdr5fefmBf7/r1X13bVD3THHF3A+3bt2cjkvJBwcu2P+a
6dPTv2tO+/ufXHZeXd0bxfOOHfq9ap+0vTnt+0ae2HVT1z8t25q+15rTfu93
Zu5fV/evccngtusm9Urbm9N+YvSLPfd5a8Oh49N+bE77rife36Subkmx3zVL
n+r1WlrH8h+N9cszdSxuz3ncHj53afut9fUri/sPvX3Yt3+f1r2Y035M5I8G
s3d6c8VXaT2MOe2veHDEJ/X1q4s/ffWBb6w5Zk3S3pz2nSKvbJ10z/TrD1md
tDen/X6/2nltff264jcvGNp1xOPp/L457TdGf/9Fh47Nl29dlrQ3p/20PS9f
Vl//cfHBp9pP7nlSuu7o/sn7rfsh3P0N7n4Fd/+Bu5/Afd/hvu9w31+47yPc
9wvu+wK3f7g9w+2TcYF9wu0Tbp9w+4TbJ9w+4fYJt0+4fcLtE26fcPuE2yfc
PhlP2SfcPuH2CbdPuH3C7RNun3D7hNsn3D7h9gm3T7h9wu2Tcah9wu0Tbp9w
+4TbJ9w+4fYJt0+4fcLtE26fcPuE2yfcPhm/2yfcPuH2CbdPuH3C7RNun3D7
hNsn3D7h9gm3T7h9wu2TeQ/7hNsn3D7h9gm3T7h9wu0Tbp9w+4TbJ9w+4fYJ
t0+4fTJfZJ9w+4TbJ9w+4fYJt0+4fcLtE26fcPuE2yfcPuH2CbdP5tnsE26f
cPuE2yfcPuH2CbdPuH3C7RNun3D7hNsn3D7h9sn8pH3C7RNun3D7hNsn3D7h
9gm3T7h9wu0Tbp9w+4TbJ9w+mde1T7h9wu0Tbp9w+4TbJ9w+4fYJt0+4fcLt
E26fcPuE2yfz4fYJt0+4fcLtE26fcPuE2yfcPuH2CbdPuH3C7RNun3D7ZB3B
PuH2CbdPuH3C7RNun3D7hNsn3D7h9gm3T7h9wu0Tbp/MO9kn3D7h9gm3T7h9
wu0Tbp9w+4TbJ9w+4fYJt0+4febN13Fsn7+O9Sz7fOi7Y1b3rY3N+FwS65H2
+eNH5/acUn4o43NyzDfa5++/nrTth6WBGZ/dcubBGkb89nlixG+fN0X89vlK
xG+fu0T89nbdXZdPqhReynjj2N6OmXDyOUuqL2a8LY31FHu79pTxxSGFSRlv
LWI+3N6mfbBry86VCRlvY3PmkfpH/PbWKeK3t7YRv73Nifjt7f8jfnv7+3lP
bSyU3sp4Yz3I3ji2t9/GupK9HfnFHvNq1Vcz3hrHeoG9LTz+uI4Tyy9nvLXI
mS/aEvHb24yI397uifjtrXvEb29tI357m7jv3+6uVedkvLEuZm+3ThtcKlVm
Z7xxbG9/fqNz4z61dzPerov1FHs7rdmAq0qVWRlvb+fMC02I+O1teMRvbzdH
/PZ2acRvb+Mifnvrd+O9TxRK2fkf1gft7YRWh1xQKSzIePtBrDPaG8f2tjXW
m+xt1eVdF5Zr2fm0W3Pmfy6L+O3t7Ijf3n4a8dvb9yJ+e9sz4re3Q9e3eblc
ez/jjXVSe6u/+/UBterijLc1sd5qb389ovuRpcqijDeO7W1k7cvN1fJ7GW8n
5MzztI747a1ZxG9v2yJ+e/sw4re3WRG/vW34+awl1fLyjDfWi+1typc97y+U
lmW8jY51Z3u7Y8T20yuFpRlv/WK90t44tjeO7W1txG9vsyN+e3sh4re3RyJ+
exsU8dvbvIjD3k6OdfOMt7YNFlXLKzPeWH+3tzE3vTOhXMvOg7Gea2+DFz54
b6GUnQfrljNvw3FmXjHit7fJEb+9tYn47e3RiN/e2lV2GFQoZednHos47K35
6r/2rFVXZbxRh2BvDY8eflylsCrjjfVue1t/+4UtSpXsfNfUnPmZthG/vXFs
b/tG/PY2OOK3t7qI397u7ji3WamSnYfZIeoo7O3KiMPeqMewt+4bL363Wl6d
8UY9gL11Kh71ZLmWndfaL2ce5q6I394aRvz2xrG9rY/47a1bxG9vH3/1yKhy
bW3G2/lRT2JvC7qUryuU1ma8UZdib9Me+VHXWnVNxhv1EvY29rMdj64U1mS8
9c+Zb9kY8dtb94jf3uZH/PbGsb1Njfjt7ZSn+7apFLLzKtOjrsbeDm94TNNS
ZX3GG/U59rZ/xGFv1JPYW6Nx81+plrPzVAtz5lU6R/z2Ni3it7fDIn57Gxvx
2xvH9vbEBR2mVMvZ+ZMDor4oM96v7vJAubYx4406JXu7usl7vyuUNma8UW9j
bz3OHX1GrZqdj2qfM38yLuK3t/0j/sx4IeK3t0YRv731j/jtrfG+u3WqVbPz
JNTx2NumixcXKoXsPEmPqIvNzOO9+FiDUmVTxtspUZdob9OjPsPe7smZJ2kU
8dtb/4jf3j6O+O3t/Ijf3hZE/Pb2Ssw/eP7kjpivML855hlcf9Iy5zzfiPG7
+dlxn8zrYtxqPjvGm+b9Y7xmPibGWeZfxjjFvHuML8wnxP023z/eq80vi/dS
80XxPmn+f/E+Zt453qPMfxfvIebjot+Yz43nr3njeG6at43njnnPeF6Y3xX5
1nxm5Elzjs0PjPzg/jkj+lnGT/zuzAfE78X9c+f4fZnnzRNST+X27EMwp07Y
nHpgc+p+zanvNaeO15x6XXPGBea895rzXmfOe4s5z2Vznjvm7Dcwz6tno/7K
nDoic+phzKnrMKc+wZx1dnPWi81Z9zRn/c6cdShz1lPMWRcwPzD6q3n/mO81
nxDzpeYPxLyl+a0xX2p+SMyLms+JeUXzE2J+z7w+5hXN74zntHkp5t/Mp8Q8
mPnUmH8zHxjzbOYrYp7KfL94D8h4jnkq8w4xH2U+POZzzBfGvIp5+5jPMf8q
5m3Mz473D/NKzD+Yb4l5D/NqzG9kfkcxP2A+NsbpmeuK9xtz5gEy+S3G0eaN
Yjyb8RPjaHPGy5nfe4w3zXvEuC/jLcab5ryHZfJwjMvMZ8T4KOM/xmXmjL/M
G8b4xbxFvOeZnxbjF3PGKebd4z3ffEC8b2fyc7znm/M+b86x+fvxXur93TyP
XZ8P975vuPd9w73vG+5933Dv+4Z73zfc+77h3vcN975vuPd9w73vG25vjH/s
DW5vcHuD2xvc3uD2Brc3uL3B7Q1ub3B7g9sb3N4YH9ob3N7g9ga3N7i9we0N
bm/JOFbe4PYGtze4vcHtDW5vjJ/tDW5vcHuD2xvc3uD2Brc3uL3B7Q1ub3B7
g9sb3PuU4d6XBLdn5iPsGW7PcHuG2zPcnuH2DLdnuD3D7Rluz3B7htsz3J7h
9gy3Z+Z37Bluz3B7htsz3J7h9gy3Z7g9w+0Zbs9we4bbM9ye4fYMt2fmy8yZ
L7N/2pvT3veF9ua09/2ivTntfR9pb05731/am9Pe95325rR3f6C9Oe3dT2hv
Tnv3H9qb0979ivbmtHd/o7057d0PaW9Oe/dP2rt/5vVD5mfd3+DuV3D3H7j7
Cdz9Ae77Dvf9hfs+wn2/4L4vcPuH2zPc3pi/tje4vcHtDW5vcHuD21syny5v
cHuD2xvc3uD2Brc3uL0xrrQ3uL3B7Q1ub3B7g9sb3N7g9ga3N7i9we0Nbm9w
e2P9w97g9ga3N7i9we0Nbm9we4PbG9ze4PYGtze4vcGdD+HOh3B7Zj3JnuH2
DLdnuD3D7Rluz3B7htsz3J7h9gy3Z7g9w+0Zbs9we2Y9w57h9gy3Z7g9w+0Z
bs9we4bbM9ye4fYMt2e4PcMz35vK+V4E3J6Zh7JPuH3C7RNun3D7hNsn3D7h
9gm3T7h9wu0Tbp9w+4RfG+sDcz+9d+Jh1XSejXrnYXee9UDvM1JOPe9ZV186
/bPp6fzb5TGPPnPPMx7rUp/Ov7WJ+e+um+8qv9U05fO0bg6nLuxXX817deT0
dJ6Nuqdv7nrfE+v/nM6zUdfT6slhOzVple5bo27lq8UNrtjwaTrPRl3GhNYL
jl/33cUJp+5g0fkPnrLLXi8lnPruLb988M7e3dP5NOqXm+33VrvH56fzadTn
Npw/5eu990s59afN3j129Q9+mM6z8b2cuqgTgPNdnN0Hbdnv7c/T+THqlXbr
sGTLF9en9XPU4xy085bG63ul9YjUm/zlwybrDuub1sVSZ33CK1ueG7k2ndei
jviEhWOu3at9yqmTndr51Dee6ZLOd/WP5/mxUc8AXxjz3+d3HPrcxQvT/Zbt
Y966wVuX9H1vflofWYn55ttu6fmT1ePS/djUL88bvqxlpy7pPBL1udWF9Z90
LafzSKxz/iPqKOCsc+68+ajF24vpvlnqeV+/sXeLtoPTeRLqkvaJugt4t5xx
7tic8WmLnHHo2znjzVtzxpXUC/9B48duOeO+qTnjO+ryNmscR91ZK43XqKua
rHEZdUPrI8/AqYv5xWvT/pNnknGi8gzjjk+UZ+ATlGfglynPwKmbPjfyDJw6
zTMjn8CpQ2we+QROnd33Ip/AqSPbGvkETp3UpMgncOqAmvX4bz6Bv6R8wjiC
/QT7RD6BUy+/Q+QTeDPlEzh1lHtG3oBTJ7h75A04dXAHR96AU+c1KfIG/KbI
GydG3uB9vhh548TIG3Dq01+MvAFnfaxn5Ac461qNIj/AWY+qRH6At1J+4L13
VeSHiZEf4NTxNY08AH9beYD3Ouqqrt1/cu8//c+6lZ+ncOrvukQdC/mWer1B
W37S6A8fL03y26JYN+t+8I8uqK5Nv5Pi75qSr/I49W7PxXcg4T2DjxZ3POQ3
5+Fknjbi7B1xwjdH/dpDjfY8t1v5nYTbA/OHfF/tmehX8PHxO3o2fkfM52yJ
85xIPVj0w9Oibuik+N4gnHXO6+O66CesT54Z8cOpT1wbPukPOwdfKE5dXjV8
wnsFHy5OneNdEQ/9amh4Hhie4Qsjzj4RJ3xLeL49PMOptxoXPnlPbql+y/ue
xyPJ+3P4fzz8571P0s/N6efm9GfzvPk98mTme7Zxf825j/4OKnGaE6c5cZrz
ezGnn5vTn83pz+Z4MMdD5jvS4cE8zwP90Jz+k/kudPQfc/oD9bZPRT/EM/V9
d0U9ANz5La89/mcGHxgcz9Tnnh2/dzx3CX6KOHW7Q+I8+F8c8fw64oE7f3Jf
HA/3xb/T5D0h4ummvOTz4N/t8e/8Bnce475QFzk8xi/wjXG/Zsf9yhsP5n0H
lfvi+548pzRugvs8+PTzCO72+HTeg2e+dxqeqbOeGN97TJ4LwXuI+zz8juwN
bs/J+4nee8kbO0b7z6M9/fmaiOfKiCdZvws+SnynOM/kOA/9lvrxaREn/O6I
58zf7dX4f+cD/V5KP7Qf+pt9wtdH3dncLV88eMSKtH7m7Kgrf+bGk2455m/p
eJl9hGfeUHfeZzun9STsk2t8zZ0vnz42rRsZHvWPwxYtabXgi7Qeg/3o1/9x
1B6j3kg5+xHvm7LLDS+0Tesupkad2qjVZ1zRbWFaX7Ff1Jc1/+72U2a2T7+3
8r6+T859XBJ1wUPqrmm0aHbK2c/99KBdu/5yQMrZB7nviDf2vu2stJ6Bet5R
W8594Ywd03oG6nk31B30dJdy+p0X6nkvadP7/NNuXJPwo2J//6l/XjFoj+1p
PQD772/o/PzSnotSzv7ymStva3LCbSln//Rv//HlFb12Tzn7NR9+/uUGF12b
1gmwH7HDs31POvTwtE6A/Xaf9nrhzTvGpN+jYT9Zr0lvvbTHK+m+KfZLbXqi
8fKfD0j3ob2g777S/w+I/Qd9L2zTrNPylLM/vjL6saY33Zdy9n/fc+n4rkcc
mHL2N5dvOHTEhdem6/jsQ906ek2jcx9N1+vZZ/lJv173bjsvXa9nH+Hkg1r/
7eb30/1L7JOrn373J0fvmK7Xsw+syQvDrt3+drq/jn1OD736+pWfNk3X6/vp
/Y3fNd9LWPKz2fsMXJ1yvgfw+LpftN5nVMrZ735xu5eHnN4u5eznPviAJk3P
HJqug7NfeZdDttV+83q63s2+0o4fjp817Y50nZp9kye9fs1ex+2RrkezL/Dz
AaPfWHhiuu7Mvrf7Cud8en/zdH2ZfV03Tlrc6YfldB25ker5yf9rIv/Mi/wD
76T8Q57vHHnlO7GfCP7XyEtnRV5K1h+Vl+C3Ki+R/9tHXroh8hK8ov1K8ImR
r+6PfAWnrnZ05Cs49bDfinwFf135ijw/T/kK3kP5Cn5J5JXdYv8UfKTyGJz9
vo9GHoOzn3Vj5DE4+zXLkcfguyuP8TzqpzwGb6c8Bh8beax35DH4HpFXdor9
X/BbI7+NiPwGZ79yMfIbnP24n0V+g7Pf9LeR3+Dsp9wS+Q1+p/Ibz9NvKL8l
6zWR34ZEfoNfqfwG/0L5Df585JW9Yr8bvG/kve2R9+DsZ/o08h6cfUtTI+/B
2Z/UYMZ/8x6cfUhNI+/B2W80IvIenP0NSyO/8b46R/kN3ln5Dc4+gJaR3+DU
7zeN/AY/x9+lYT0o8t7Jkffg1LmfHHkvWSeKvPdF5D04deXDIu/BqQe/OfIe
/IKo416w8qJtz369PHm/Yh/ne8HJk4v4PpnmaXtG+znRPtmvqLzK36V+fHm0
hx8Z4+7lqns05+8eFfx9rVN7XyfX5X2dcO/rhHtfZ7I+pX2dcO/rhHv/Jtz7
N+Hevwn3/k2492/Cvd8tzwO+7AFuD3B7SNan/D2c4L5euK8X7uuF+3rz4uc6
HT/c8cMdP9xxwh1n8v6vOPPiIW7HA3c8cP9duP9u3vmJw+eH+zx57Tmv90Xy
O/XvEZ75Tk5w30e4vcF9XXDHCffvEe7+Cfd9h9t/sv4lb3D/HvP8EJ/9wO0H
bj9w+4HbT953WuD2kLwPywPcHpL1L+87zrle4vD1wjPfsQnu64X7evO+owL3
dcF9XXlxcl7Hmbyf+7sxwR1n3vdJ4I4n7+/y7/134ZnvruR8xyPvPLTzefI4
/YDfgfdJOZ/wO3F7uH/XcJ+HfubfXVKHoPPDfX64fy9w/136h/8u3P0f7njg
jgfueODu50l/VZz0G8cJd5xw93+444c7/mT+R/HDHT/cvwt45juB0V99XXBf
F9zXBffvC+7rhft64b7eZP5H1wv39cL9O817LifzNv7uX3B7gNsD3B7gzg95
31uD2w/cfuD2k8wLyQ/cfuB+HsHtjfgcP9ztk3VkeYb7PHB7gPv8XL/PD/d9
hPvvwv134fYPdzx54y+444G7X8EdJ9xxwjPfaw3ufgJ3/PQPxw93/HDHD/fv
Au7rgvu64L4uuK8L7v6f9/2oZB1Q1wv39SbzOf7OW3BfL9x5IO+5n8zz+Ltk
we0Bbg9we4A7D8Dth3kJ+4HbD9x+4JnvuQW3H3jmO8bB7Q1ub8m8kL9LFtze
4PYGt7dk/Vf5M4/j0RyP5nj0dwCSdSu1x685fjPffcr5DlKyPiuOF8cDd3t8
uT39LPMdhvBjjh9z7nfm+xLU3Ykn62Li+DFP1oP8PZbof5nvn+RcL17+Ccdg
FgI=
    "], {{
      {RGBColor[1, 0.5, 0], Opacity[0.5], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxFmgkYFlPYhme+M+eLhFRaaY9Kpc2WqCjJWkmhBe2FUHaJ7KUi2ZKQSpZE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           "]], Polygon3DBox[CompressedData["
1:eJwtmgn8T0Ubxe+dO9dOCCmUJUna0PJqX0mLZKm0iYp2lbTvu0KltG9IZanQ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           "]], 
          Polygon3DBox[CompressedData["
1:eJwt13ncDfUaAPDznvc93FDKlhQiWxHKlrJUShEq2lAp5N5ky5Z9exFZKyKE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           "]], Polygon3DBox[{{1357, 981, 980, 1356, 773, 774}}]}],
        Lighting->Automatic]}, {}, {}, {}, {}}, {{}, {}, {}, 
      {GrayLevel[0.2], 
       Line3DBox[{368, 578, 1364, 369, 591, 396, 1451, 604, 410, 1456, 617, 
        424, 1463, 630, 438, 1472, 643, 452, 1483, 656, 1402, 466, 669, 1414, 
        480, 1498, 682, 494, 1502, 695, 508, 1508, 708, 522, 1516, 721, 536, 
        1526, 734, 550, 1538, 747, 564}], 
       Line3DBox[{370, 579, 1365, 371, 592, 1376, 397, 605, 411, 1457, 618, 
        425, 1464, 631, 439, 1473, 644, 453, 1484, 657, 1403, 467, 670, 1415, 
        481, 683, 1425, 495, 1503, 696, 509, 1509, 709, 523, 1517, 722, 537, 
        1527, 735, 551, 1539, 748, 565}], 
       Line3DBox[{372, 580, 1366, 373, 593, 1377, 398, 606, 1385, 412, 619, 
        426, 1465, 632, 440, 1474, 645, 454, 1485, 658, 1404, 468, 671, 1416, 
        482, 684, 1426, 496, 697, 1433, 510, 1510, 710, 524, 1518, 723, 538, 
        1528, 736, 552, 1540, 749, 566}], 
       Line3DBox[{374, 581, 1367, 375, 594, 1378, 399, 607, 1386, 413, 620, 
        1392, 427, 633, 441, 1475, 646, 455, 1486, 659, 1405, 469, 672, 1417, 
        483, 685, 1427, 497, 698, 1434, 511, 711, 1439, 525, 1519, 724, 539, 
        1529, 737, 553, 1541, 750, 567}], 
       Line3DBox[{376, 582, 1368, 377, 595, 1379, 400, 608, 1387, 414, 621, 
        1393, 428, 634, 1397, 442, 647, 456, 1487, 660, 1406, 470, 673, 1418, 
        484, 686, 1428, 498, 699, 1435, 512, 712, 1440, 526, 725, 1443, 540, 
        1530, 738, 554, 1542, 751, 568}], 
       Line3DBox[{378, 583, 1369, 380, 596, 1380, 401, 609, 1388, 415, 622, 
        1394, 429, 635, 1398, 443, 648, 1400, 457, 661, 1407, 471, 674, 1419, 
        485, 687, 1429, 499, 700, 1436, 513, 713, 1441, 527, 726, 1444, 541, 
        739, 1445, 555, 1543, 752, 569}], 
       Line3DBox[{382, 585, 1370, 383, 1449, 598, 403, 1453, 611, 417, 1459, 
        624, 431, 1467, 637, 445, 1477, 650, 459, 1489, 663, 1408, 473, 676, 
        487, 1500, 689, 501, 1505, 702, 515, 1512, 715, 529, 1521, 728, 543, 
        1532, 741, 557, 1545, 754, 571}], 
       Line3DBox[{384, 586, 1371, 385, 599, 1381, 404, 1454, 612, 418, 1460, 
        625, 432, 1468, 638, 446, 1478, 651, 460, 1490, 664, 1409, 474, 677, 
        1420, 488, 690, 502, 1506, 703, 516, 1513, 716, 530, 1522, 729, 544, 
        1533, 742, 558, 1546, 755, 572}], 
       Line3DBox[{386, 587, 1372, 387, 600, 1382, 405, 613, 1389, 419, 1461, 
        626, 433, 1469, 639, 447, 1479, 652, 461, 1491, 665, 1410, 475, 678, 
        1421, 489, 691, 1430, 503, 704, 517, 1514, 717, 531, 1523, 730, 545, 
        1534, 743, 559, 1547, 756, 573}], 
       Line3DBox[{388, 588, 1373, 389, 601, 1383, 406, 614, 1390, 420, 627, 
        1395, 434, 1470, 640, 448, 1480, 653, 462, 1492, 666, 1411, 476, 679, 
        1422, 490, 692, 1431, 504, 705, 1437, 518, 718, 532, 1524, 731, 546, 
        1535, 744, 560, 1548, 757, 574}], 
       Line3DBox[{390, 589, 1374, 391, 602, 1384, 407, 615, 1391, 421, 628, 
        1396, 435, 641, 1399, 449, 1481, 654, 463, 1493, 667, 1412, 477, 680, 
        1423, 491, 693, 1432, 505, 706, 1438, 519, 719, 1442, 533, 732, 547, 
        1536, 745, 561, 1549, 758, 575}], 
       Line3DBox[{392, 760, 761, 1375, 393, 763, 1551, 764, 408, 765, 1552, 
        766, 422, 767, 1553, 768, 436, 769, 1555, 770, 450, 771, 1556, 772, 
        464, 1494, 773, 774, 1413, 478, 775, 776, 1424, 492, 777, 1557, 778, 
        506, 779, 1558, 780, 520, 781, 1559, 782, 534, 783, 1561, 784, 548, 
        785, 786, 562, 1550, 788, 789, 576}], Line3DBox[CompressedData["
1:eJwVzNc2Q1EUBdAdxvABHtQgEb2L3nuJLohORPDGf/hkT+Z5mGPdsdY9O1/7
KX9nIqLKr4+/hoj2xog5OpoiZuUg8yykjiU6bYtyiGVWUscaWduqHGadDZp1
WbnFJiNs06PfkV3sscso++RsB7KbEoeMcUTedpzec8oJvbpxecZ5es9luq2/
kBOUuUrvuUm3bddykgq36Q733DHFA4+0+bcgn3limhcK+lfZxxtVitRSZ3uX
/XxQZ4ZPvhighVb+AewFGkg=
        "]], 
       Line3DBox[{563, 746, 787, 1537, 549, 733, 1525, 535, 720, 1515, 521, 
        707, 1507, 507, 694, 1501, 493, 681, 1497, 479, 668, 1495, 465, 1401, 
        655, 1482, 451, 642, 1471, 437, 629, 1462, 423, 616, 1455, 409, 603, 
        1450, 395, 590, 1447, 367, 577, 759, 792}], 
       Line3DBox[{570, 753, 1544, 556, 740, 1531, 542, 727, 1520, 528, 714, 
        1511, 514, 701, 1504, 500, 688, 1499, 486, 675, 1496, 472, 662, 1488, 
        458, 649, 1476, 444, 636, 1466, 430, 623, 1458, 416, 610, 1452, 402, 
        597, 1448, 381, 584, 1446, 379}]}, 
      {GrayLevel[0.2], 
       Line3DBox[{873, 1158, 577, 872, 1364, 1082, 874, 1365, 1083, 875, 1366,
         1084, 876, 1367, 1085, 877, 1368, 1086, 878, 1369, 1255, 1446, 879, 
        1370, 1087, 880, 1371, 1088, 881, 1372, 1089, 882, 1373, 1090, 883, 
        1374, 1091, 884, 1355, 1375, 1092, 1190, 1562, 1213, 1214, 1197, 1212,
         1093, 1159}], 
       Line3DBox[{886, 1256, 1447, 885, 591, 887, 1376, 1094, 888, 1377, 1095,
         889, 1378, 1096, 890, 1379, 1097, 891, 1380, 1257, 1448, 892, 1258, 
        1449, 893, 1381, 1098, 894, 1382, 1099, 895, 1383, 1100, 896, 1384, 
        1101, 897, 1551, 1160, 1102, 1191, 1563, 294, 1198, 324, 1231}], 
       Line3DBox[{899, 1259, 1450, 898, 1260, 1451, 900, 605, 901, 1385, 1103,
         902, 1386, 1104, 903, 1387, 1105, 904, 1388, 1261, 1452, 905, 1262, 
        1453, 906, 1263, 1454, 907, 1389, 1106, 908, 1390, 1107, 909, 1391, 
        1108, 910, 1552, 1161, 1109, 1192, 1564, 1215, 1162, 1199, 1233, 1234,
         1232}], 
       Line3DBox[{912, 1264, 1455, 911, 1265, 1456, 913, 1266, 1457, 914, 619,
         915, 1392, 1110, 916, 1393, 1111, 917, 1394, 1267, 1458, 918, 1268, 
        1459, 919, 1269, 1460, 920, 1270, 1461, 921, 1395, 1112, 922, 1396, 
        1113, 923, 1553, 1163, 1164, 924, 1361, 1554, 1165, 1200, 1166, 1245, 
        925}], Line3DBox[{927, 1271, 1462, 926, 1272, 1463, 928, 1273, 1464, 
        929, 1274, 1465, 930, 633, 931, 1397, 1114, 932, 1398, 1275, 1466, 
        933, 1276, 1467, 934, 1277, 1468, 935, 1278, 1469, 936, 1279, 1470, 
        937, 1399, 1115, 938, 1555, 1167, 1168, 939, 1567, 1216, 1169, 1201, 
        1170, 1246, 940}], 
       Line3DBox[{942, 1280, 1471, 941, 1281, 1472, 943, 1282, 1473, 944, 
        1283, 1474, 945, 1284, 1475, 946, 647, 947, 1400, 1285, 1476, 948, 
        1286, 1477, 949, 1287, 1478, 950, 1288, 1479, 951, 1289, 1480, 952, 
        1290, 1481, 953, 1556, 1171, 1172, 954, 1568, 1217, 1218, 1202, 1248, 
        1247, 955}], 
       Line3DBox[{959, 1401, 1116, 957, 1402, 1117, 961, 1403, 1118, 963, 
        1404, 1119, 965, 1405, 1120, 967, 1406, 1121, 969, 1407, 662, 971, 
        1408, 1122, 973, 1409, 1123, 975, 1410, 1124, 977, 1411, 1125, 979, 
        1412, 1126, 981, 1357, 1413, 1127, 1193, 1362, 1570, 1221, 1204, 1236,
         1128, 1235}], 
       Line3DBox[{983, 1249, 1250, 1203, 1220, 1219, 1569, 982, 1173, 1494, 
        1356, 980, 1493, 1301, 978, 1492, 1300, 976, 1491, 1299, 974, 1490, 
        1298, 972, 1489, 1297, 970, 1488, 661, 968, 1487, 1296, 966, 1486, 
        1295, 964, 1485, 1294, 962, 1484, 1293, 960, 1483, 1292, 956, 1482, 
        1291, 958}], 
       Line3DBox[{985, 1302, 1495, 984, 1414, 1129, 986, 1415, 1130, 987, 
        1416, 1131, 988, 1417, 1132, 989, 1418, 1133, 990, 1419, 1303, 1496, 
        991, 676, 992, 1420, 1134, 993, 1421, 1135, 994, 1422, 1136, 995, 
        1423, 1137, 996, 1358, 1424, 1138, 1194, 1565, 1222, 1223, 1205, 1238,
         1139, 1237}], 
       Line3DBox[{998, 1304, 1497, 997, 1305, 1498, 999, 1425, 1140, 1000, 
        1426, 1141, 1001, 1427, 1142, 1002, 1428, 1143, 1003, 1429, 1306, 
        1499, 1004, 1307, 1500, 1005, 690, 1006, 1430, 1144, 1007, 1431, 1145,
         1008, 1432, 1146, 1009, 1557, 1174, 1147, 1195, 1566, 1224, 1175, 
        1206, 1240, 1241, 1239}], 
       Line3DBox[{1011, 1308, 1501, 1010, 1309, 1502, 1012, 1310, 1503, 1013, 
        1433, 1148, 1014, 1434, 1149, 1015, 1435, 1150, 1016, 1436, 1311, 
        1504, 1017, 1312, 1505, 1018, 1313, 1506, 1019, 704, 1020, 1437, 1151,
         1021, 1438, 1152, 1022, 1558, 1176, 1153, 1196, 857, 1177, 1207, 
        1243, 1244, 1242}], 
       Line3DBox[{1024, 1314, 1507, 1023, 1315, 1508, 1025, 1316, 1509, 1026, 
        1317, 1510, 1027, 1439, 1154, 1028, 1440, 1155, 1029, 1441, 1318, 
        1511, 1030, 1319, 1512, 1031, 1320, 1513, 1032, 1321, 1514, 1033, 718,
         1034, 1442, 1156, 1035, 1559, 1178, 1179, 1036, 1363, 1560, 1180, 
        1208, 1181, 1251, 1037}], 
       Line3DBox[{1039, 1322, 1515, 1038, 1323, 1516, 1040, 1324, 1517, 1041, 
        1325, 1518, 1042, 1326, 1519, 1043, 1443, 1157, 1044, 1444, 1327, 
        1520, 1045, 1328, 1521, 1046, 1329, 1522, 1047, 1330, 1523, 1048, 
        1331, 1524, 1049, 732, 1050, 1561, 1182, 1183, 1051, 1571, 1225, 1184,
         1209, 1185, 1252, 1052}], 
       Line3DBox[{1054, 1332, 1525, 1053, 1333, 1526, 1055, 1334, 1527, 1056, 
        1335, 1528, 1057, 1336, 1529, 1058, 1337, 1530, 1059, 1445, 1338, 
        1531, 1060, 1339, 1532, 1061, 1340, 1533, 1062, 1341, 1534, 1063, 
        1342, 1535, 1064, 1343, 1536, 1065, 785, 1186, 1066, 1572, 1226, 1227,
         1210, 1254, 1253, 1067}], 
       Line3DBox[{1081, 1229, 1230, 1211, 1228, 870, 1080, 1189, 1550, 1360, 
        1079, 1549, 1354, 1078, 1548, 1353, 1077, 1547, 1352, 1076, 1546, 
        1351, 1075, 1545, 1350, 1074, 1544, 1543, 1349, 1073, 1542, 1348, 
        1072, 1541, 1347, 1071, 1540, 1346, 1070, 1539, 1345, 1069, 1538, 
        1344, 1068, 1359, 1537, 1187, 1188}]}}},
    VertexNormals->CompressedData["
1:eJztnHdUVEcbh+loFNHY9YMkCEpRjAE1YosQ1IXFLpYoGAVjQ+oRaUZBiohE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     "]], 
   GraphicsComplex3DBox[CompressedData["
1:eJyF3HuwVWUZgPEtIt4oLamQ0G47zEsEgpcclUgHWVA2OlOjUoho5W0DiXEb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    "], {{
      {RGBColor[0, 0, 1], Opacity[0.5], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmXfgV9Mbx++553zsEJKQJGRVUtJPGaGhkC0lKQ0kSWRklKZRSZlFhbJn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           "]], Polygon3DBox[CompressedData["
1:eJxNmnncVVMbhvdeayWKDM1zUVSGzGROISoSkVAkUiikkilUKpW5kJAGY4NI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           "]], 
          Polygon3DBox[CompressedData["
1:eJwt13f8luMaAPD3977vL5qi1KGt4TSdNNA8DQkNDeW0HC2rgYaOljSEEi0h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           "]]}],
        Lighting->Automatic]}, {}, {}, {}, {}}, {{}, {}, {}, 
      {GrayLevel[0.2], 
       Line3DBox[{251, 474, 1113, 252, 488, 280, 1222, 503, 295, 1227, 518, 
        310, 1234, 533, 325, 1243, 548, 340, 1254, 563, 1161, 355, 578, 1175, 
        370, 1269, 593, 385, 1273, 608, 400, 1279, 623, 415, 1287, 638, 430, 
        1297, 653, 445, 1309, 668, 460}], 
       Line3DBox[{253, 475, 1114, 254, 489, 1125, 281, 504, 296, 1228, 519, 
        311, 1235, 534, 326, 1244, 549, 341, 1255, 564, 1162, 356, 579, 1176, 
        371, 594, 1187, 386, 1274, 609, 401, 1280, 624, 416, 1288, 639, 431, 
        1298, 654, 446, 1310, 669, 461}], 
       Line3DBox[{255, 476, 1115, 256, 490, 1126, 282, 505, 1136, 297, 520, 
        312, 1236, 535, 327, 1245, 550, 342, 1256, 565, 1163, 357, 580, 1177, 
        372, 595, 1188, 387, 610, 1197, 402, 1281, 625, 417, 1289, 640, 432, 
        1299, 655, 447, 1311, 670, 462}], 
       Line3DBox[{257, 477, 1116, 258, 491, 1127, 283, 506, 1137, 298, 521, 
        1145, 313, 536, 328, 1246, 551, 343, 1257, 566, 1164, 358, 581, 1178, 
        373, 596, 1189, 388, 611, 1198, 403, 626, 1205, 418, 1290, 641, 433, 
        1300, 656, 448, 1312, 671, 463}], 
       Line3DBox[{259, 478, 1117, 260, 492, 1128, 284, 507, 1138, 299, 522, 
        1146, 314, 537, 1152, 329, 552, 344, 1258, 567, 1165, 359, 582, 1179, 
        374, 597, 1190, 389, 612, 1199, 404, 627, 1206, 419, 642, 1211, 434, 
        1301, 657, 449, 1313, 672, 464}], 
       Line3DBox[{261, 479, 1118, 263, 493, 1129, 285, 508, 1139, 300, 523, 
        1147, 315, 538, 1153, 330, 553, 1157, 345, 568, 1166, 360, 583, 1180, 
        375, 598, 1191, 390, 613, 1200, 405, 628, 1207, 420, 643, 1212, 435, 
        658, 1215, 450, 1314, 673, 465}], 
       Line3DBox[{265, 481, 1119, 266, 1220, 495, 287, 1224, 510, 302, 1230, 
        525, 317, 1238, 540, 332, 1248, 555, 347, 1260, 570, 1167, 362, 585, 
        377, 1271, 600, 392, 1276, 615, 407, 1283, 630, 422, 1292, 645, 437, 
        1303, 660, 452, 1316, 675, 467}], 
       Line3DBox[{267, 482, 1120, 268, 496, 1130, 288, 1225, 511, 303, 1231, 
        526, 318, 1239, 541, 333, 1249, 556, 348, 1261, 571, 1168, 363, 586, 
        1181, 378, 601, 393, 1277, 616, 408, 1284, 631, 423, 1293, 646, 438, 
        1304, 661, 453, 1317, 676, 468}], 
       Line3DBox[{269, 483, 1121, 270, 497, 1131, 289, 512, 1140, 304, 1232, 
        527, 319, 1240, 542, 334, 1250, 557, 349, 1262, 572, 1169, 364, 587, 
        1182, 379, 602, 1192, 394, 617, 409, 1285, 632, 424, 1294, 647, 439, 
        1305, 662, 454, 1318, 677, 469}], 
       Line3DBox[{271, 484, 1122, 272, 498, 1132, 290, 513, 1141, 305, 528, 
        1148, 320, 1241, 543, 335, 1251, 558, 350, 1263, 573, 1170, 365, 588, 
        1183, 380, 603, 1193, 395, 618, 1201, 410, 633, 425, 1295, 648, 440, 
        1306, 663, 455, 1319, 678, 470}], 
       Line3DBox[{273, 485, 1123, 274, 499, 1133, 291, 514, 1142, 306, 529, 
        1149, 321, 544, 1154, 336, 1252, 559, 351, 1264, 574, 1171, 366, 589, 
        1184, 381, 604, 1194, 396, 619, 1202, 411, 634, 1208, 426, 649, 441, 
        1307, 664, 456, 1320, 679, 471}], 
       Line3DBox[{275, 486, 1124, 276, 500, 1134, 292, 515, 1143, 307, 530, 
        1150, 322, 545, 1155, 337, 560, 1158, 352, 1265, 575, 1172, 367, 590, 
        1185, 382, 605, 1195, 397, 620, 1203, 412, 635, 1209, 427, 650, 1213, 
        442, 665, 457, 1321, 680, 472}], 
       Line3DBox[{277, 682, 1322, 683, 278, 501, 1135, 293, 516, 1144, 308, 
        531, 1151, 323, 546, 1156, 338, 561, 1159, 353, 576, 1173, 1174, 368, 
        591, 1186, 383, 606, 1196, 398, 621, 1204, 413, 636, 1210, 428, 651, 
        1214, 443, 666, 1216, 458, 685, 686, 687}], 
       Line3DBox[{459, 667, 684, 1308, 444, 652, 1296, 429, 637, 1286, 414, 
        622, 1278, 399, 607, 1272, 384, 592, 1268, 369, 577, 1266, 354, 1160, 
        562, 1253, 339, 547, 1242, 324, 532, 1233, 309, 517, 1226, 294, 502, 
        1221, 279, 487, 1218, 250, 473, 681, 688}], 
       Line3DBox[{466, 674, 1315, 451, 659, 1302, 436, 644, 1291, 421, 629, 
        1282, 406, 614, 1275, 391, 599, 1270, 376, 584, 1267, 361, 569, 1259, 
        346, 554, 1247, 331, 539, 1237, 316, 524, 1229, 301, 509, 1223, 286, 
        494, 1219, 264, 480, 1217, 262}]}, 
      {GrayLevel[0.2], 
       Line3DBox[{690, 1004, 473, 689, 1113, 912, 691, 1114, 913, 692, 1115, 
        914, 693, 1116, 915, 694, 1117, 916, 695, 1118, 1010, 1217, 696, 1119,
         917, 697, 1120, 918, 698, 1121, 919, 699, 1122, 920, 700, 1123, 921, 
        701, 1124, 922, 702, 1322, 1005, 923, 1006}], 
       Line3DBox[{704, 1011, 1218, 703, 488, 705, 1125, 924, 706, 1126, 925, 
        707, 1127, 926, 708, 1128, 927, 709, 1129, 1012, 1219, 710, 1013, 
        1220, 711, 1130, 928, 712, 1131, 929, 713, 1132, 930, 714, 1133, 931, 
        715, 1134, 932, 716, 1135, 933, 717}], 
       Line3DBox[{719, 1014, 1221, 718, 1015, 1222, 720, 504, 721, 1136, 934, 
        722, 1137, 935, 723, 1138, 936, 724, 1139, 1016, 1223, 725, 1017, 
        1224, 726, 1018, 1225, 727, 1140, 937, 728, 1141, 938, 729, 1142, 939,
         730, 1143, 940, 731, 1144, 941, 732}], 
       Line3DBox[{734, 1019, 1226, 733, 1020, 1227, 735, 1021, 1228, 736, 520,
         737, 1145, 942, 738, 1146, 943, 739, 1147, 1022, 1229, 740, 1023, 
        1230, 741, 1024, 1231, 742, 1025, 1232, 743, 1148, 944, 744, 1149, 
        945, 745, 1150, 946, 746, 1151, 947, 747}], 
       Line3DBox[{749, 1026, 1233, 748, 1027, 1234, 750, 1028, 1235, 751, 
        1029, 1236, 752, 536, 753, 1152, 948, 754, 1153, 1030, 1237, 755, 
        1031, 1238, 756, 1032, 1239, 757, 1033, 1240, 758, 1034, 1241, 759, 
        1154, 949, 760, 1155, 950, 761, 1156, 951, 762}], 
       Line3DBox[{764, 1035, 1242, 763, 1036, 1243, 765, 1037, 1244, 766, 
        1038, 1245, 767, 1039, 1246, 768, 552, 769, 1157, 1040, 1247, 770, 
        1041, 1248, 771, 1042, 1249, 772, 1043, 1250, 773, 1044, 1251, 774, 
        1045, 1252, 775, 1158, 952, 776, 1159, 953, 777}], 
       Line3DBox[{781, 1160, 954, 779, 1161, 955, 783, 1162, 956, 785, 1163, 
        957, 787, 1164, 958, 789, 1165, 959, 791, 1166, 569, 793, 1167, 960, 
        795, 1168, 961, 797, 1169, 962, 799, 1170, 963, 801, 1171, 964, 803, 
        1172, 965, 805, 1174, 967, 807}], 
       Line3DBox[{806, 966, 1173, 804, 1265, 1057, 802, 1264, 1056, 800, 1263,
         1055, 798, 1262, 1054, 796, 1261, 1053, 794, 1260, 1052, 792, 1259, 
        568, 790, 1258, 1051, 788, 1257, 1050, 786, 1256, 1049, 784, 1255, 
        1048, 782, 1254, 1047, 778, 1253, 1046, 780}], 
       Line3DBox[{809, 1058, 1266, 808, 1175, 968, 810, 1176, 969, 811, 1177, 
        970, 812, 1178, 971, 813, 1179, 972, 814, 1180, 1059, 1267, 815, 585, 
        816, 1181, 973, 817, 1182, 974, 818, 1183, 975, 819, 1184, 976, 820, 
        1185, 977, 821, 1186, 978, 822}], 
       Line3DBox[{824, 1060, 1268, 823, 1061, 1269, 825, 1187, 979, 826, 1188,
         980, 827, 1189, 981, 828, 1190, 982, 829, 1191, 1062, 1270, 830, 
        1063, 1271, 831, 601, 832, 1192, 983, 833, 1193, 984, 834, 1194, 985, 
        835, 1195, 986, 836, 1196, 987, 837}], 
       Line3DBox[{839, 1064, 1272, 838, 1065, 1273, 840, 1066, 1274, 841, 
        1197, 988, 842, 1198, 989, 843, 1199, 990, 844, 1200, 1067, 1275, 845,
         1068, 1276, 846, 1069, 1277, 847, 617, 848, 1201, 991, 849, 1202, 
        992, 850, 1203, 993, 851, 1204, 994, 852}], 
       Line3DBox[{854, 1070, 1278, 853, 1071, 1279, 855, 1072, 1280, 856, 
        1073, 1281, 857, 1205, 995, 858, 1206, 996, 859, 1207, 1074, 1282, 
        860, 1075, 1283, 861, 1076, 1284, 862, 1077, 1285, 863, 633, 864, 
        1208, 997, 865, 1209, 998, 866, 1210, 999, 867}], 
       Line3DBox[{869, 1078, 1286, 868, 1079, 1287, 870, 1080, 1288, 871, 
        1081, 1289, 872, 1082, 1290, 873, 1211, 1000, 874, 1212, 1083, 1291, 
        875, 1084, 1292, 876, 1085, 1293, 877, 1086, 1294, 878, 1087, 1295, 
        879, 649, 880, 1213, 1001, 881, 1214, 1002, 882}], 
       Line3DBox[{884, 1088, 1296, 883, 1089, 1297, 885, 1090, 1298, 886, 
        1091, 1299, 887, 1092, 1300, 888, 1093, 1301, 889, 1215, 1094, 1302, 
        890, 1095, 1303, 891, 1096, 1304, 892, 1097, 1305, 893, 1098, 1306, 
        894, 1099, 1307, 895, 665, 896, 1216, 1003, 897}], 
       Line3DBox[{911, 1009, 685, 910, 1321, 1111, 909, 1320, 1110, 908, 1319,
         1109, 907, 1318, 1108, 906, 1317, 1107, 905, 1316, 1106, 904, 1315, 
        1314, 1105, 903, 1313, 1104, 902, 1312, 1103, 901, 1311, 1102, 900, 
        1310, 1101, 899, 1309, 1100, 898, 1112, 1308, 1007, 1008}]}}},
    VertexNormals->CompressedData["
1:eJztyEENwCAABLALC0L4zsQ8IIGEN9aRMAUooH22jdVnSfLW5MnJ/rz33nvv
vffee++9995777333nvvvffee++9995777333nvvvffee++9995777333nvv
vffee++9995777333nvvvffee++99957772/4X+Ksx7u
     "]]},
  Axes->True,
  AxesLabel->{
    FormBox["x", TraditionalForm], 
    FormBox["y", TraditionalForm], 
    FormBox["z", TraditionalForm]},
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->{370.9743564448827, 400.4009471558627},
  ImageSizeRaw->Automatic,
  Method->{},
  PlotRange->{{0., 0.9999999285714286}, {0., 0.9999999285714286}, {0., 
   0.9999999285714286}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{0.9239728510771709, -3.0380125501509463`, 1.1690825101752516`},
  ViewVertical->{0.07285855126452961, -0.2663053724613875, 
   0.9611311461532372}]], "Output",
 CellChangeTimes->{3.653952776335145*^9, 3.65395285015864*^9, 
  3.6539529002451553`*^9, 3.654808796489007*^9, 3.6548088315564833`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"p1", ",", "p2", ",", "p4", ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.654809548399534*^9, 3.65480954858363*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx1nH+QVeV5gK+IqJEmtNCWFbQ2vdUmsRRd1ljHeHXjrFy01GSmHRTWRbSt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    "], {{
      {RGBColor[1, 0, 0], Opacity[0.5], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmXfgV9Mbx++553zsEJKQJGRVUtJPGaGhkC0lKQ0kSWRklKZRSZlFhbJn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           "]], Polygon3DBox[CompressedData["
1:eJxNmnncVVMbhvdeayWKDM1zUVSGzGROISoSkVAkUiikkilUKpW5kJAGY4NI
E0VlKLPMEclUyTzP33199/p+v++P99372nufs8/Za63nuZ/7OY179u/cLxRF
ca7+JW3PiEUxRPsTy6KYIh4mrl+hKBaLnxdfJa4jXiB+Rny1+Bm98EXxG+Kh
4ro6v1C8NJ+/U++3SLxMfKF4tPhh8WPi/uKtdf1D4jniHuIK4jvF94m76r3r
iZ8SPyc+TeeDeIL4HvFvOn+kjt3Ba/W+F2l/iY49me+3OPme3Ov64M/KZ+Lc
RHEf7T+pY4/p+kU6dor4CfEU8cP58/F5F+bvy3tzj8e1P0bHj9b+TB27Recn
6lh78WzxbeJJ4m7ieeKp4kfy812Q/P3/93153nz/R8X/an+Nzh8l7iQudP4j
cTvx8cJS3Iz7ijuLjxHP0vlbxXeJ/9G5D3km4uPET4uXif/Q/rb6Wyper3N/
aX87/fXU6xfp/IzS3+lM8ULxI3l82opniG8QjxcfJ+4TPD6TxSeI5+r83eJp
4gvEW2l8HhDPFvcTVxE/mL/f0DwfVopfZ96Jt9D5+/Lz7i3eXDxZ/JB4ga5d
qvffTLy5+Bydr6jz94ofFHcXJ/Ed+fP0Em8mvkf8gPh0cRTfLr5XfL54S/H9
4lmFx79SBY8349NJPCd5/jP/jmfuiO/K66EzYy+eJJ4qPk9cWa+fLp6Z5zdz
blGe/7P1+WfxzLW/QX+PMtb6W6f9jfp7U9d+GzxWNbSdor9VrCXur/0Rer+G
ev+nxSt0zWHiU3T8MvG14ivFtXV+vvhp8cV6vzd1von2/9Sxi8SrxDuI/xBf
KH5DvL34d+aM9l/SdpP4C+a/zs/RMWLCah2/Wvy94HBxbW27iR8P/52WxQd8
BvGv4nbiRtoOF/+u7THi7bUdKH5P2+bMXW0Hi1druzNTW9tB4ve1bSEO2l4q
/kDbXcRJ26HijdoeKK6q7TDxb8x/cWNtTxXPzbHrQ+aQ9qtr+5X4M8ZfJ+bp
2Gba/0jHzxAvFG8hXic+k7ESVxJ/Kr6AWCauK/5RfL54pbiO+AfxeeIV4tri
78U9kucoc/MT8ffEg+B4uErHxrFeNT4r8ny/Qdy8guc/8fI0vf4JXa9DxRod
+1rnW1Tw9+DzX6XzG7R/AOtV2zE6v6POP69rX9Wx0eIm4mfFL4vHincSvyB+
jZgnbip+TvyKeLi4gXiJ+AXxJXr/d/W+zYg12l4pXq9tK+KFttfp+ka6/hld
vzLHx7KC4x3x5hDxL3rNpcwV3kL8sbi9+ATxoeJfxUPE14gvE9fQ6+eKnxK3
Ev+s8xeLLxdfKq6m83NyPB4srip+VLxQfIW4lnieeIn4cnFN8RPixeJB4u3E
s8ULxAPF24pnieeLB4i3Ec8UzxMPEVev4Pj/pHg/8U/EePFl4t3FR+s59BVf
LG4p/lHn+7C2xCPFjfX6peIXxaPEO4iXi19iDVQws65Zz5fpteu03UvnKmk7
RPyJtnuKt9C2o17/p46N1OtvLJxf/hBfKx5TONeR864Wjxa3E/8uvkZ8vbiL
+B/xjaVzYqccr68X38Lz07kvxftrfxttu7KQ9fluzvmL+P63rhktvll8rPgv
8SjxTeKTxf+KbxLfKf5b7/GB+AjxseJfxO+JDxUfRQwSrxa3FXcUN9Prb8/j
zfMdr/0mOnYusY21q/1xOtZb5/sTc8Q3Jj9/njdzlTm7u3g/8X3a31vXDOKz
Bo/n0zq2LI9HVfFY8Tnifqw/7bcKHr9zySk6P1LHziz9GSqKrxOfIe4tPkA8
TTwsP/8DxdPFw8VjxQeJ7xePEI8T1xXfJD4vz5ddxXeJB4mvKpxLyCm3kjuI
g+RDHbtE56/QsRZoGfGAvB7QIqw51trFwbmHHHQbuUy8rfbH6NjZxK7C34Xv
dIr299D5e8V7ii8Rdwi+F/fk2rbB9+Ke54vbBI8NY3Se+PDgeDUz57C1OjZZ
5/fSsYHa70he4bPoWP/SY9CY7ybuV/qaidrfJfrZH6Hr7xHvIR4gbi++O3mN
8ayOEVdGb+nYWaU/w1biUeKe4r6Fx4Yx6sra1PXfRuvDGcH5a2vx9bqmV+nv
VF98s/j80vecov19dGwwcz14bBgj5tqR4obav0XHLij9zJqKJ6AhS78GrYPm
QQtdEBzfyMej8/p4SOdb69gw7Z8aPFeYM1eKTwyeS8wpxvoE8dTkGMhYdw6e
S8wp5koXdLL4cPFwcoX4wWQNQO7vxpiQe1jPuv9hOvaIzrfR+RHkPpJ41otd
yX2FtSkalbnaS8e/01+tYH2J3vwt59jjSz9jtC0xiLnfMzg3k6P3Lp2T0QZo
hKOzPkULoAk6iU8urE3RqKyVs4K1JJryOnH3YK2AZuhces7yLKbmeEc8ey9r
iD1Kx6zVWUPsVTonMpeYU5dnPcRcZ85fUXoMmFvMscty/mEuMicHlh6Tljm+
D8n5i1hCTLmq9DNEu6Ph0fIDgucOc2ho6e/AWmBNXFl6jNDSaOppxNpgLY2m
RiteHpzLyemHl9Yw63JOOKC0xvok54RW4taFtREaac/SOXlj1kRtSmus9Tln
ty6twdCuxHxifd/gWoOaYwq5Nzj2kwMOy/E56txacQfxiYXnOnOemExsfk5/
r+o1LYntpbXjb9rWLq0hXxc/r2tqiRsXvpbX1BQ3En8jXiXeV3xoYa2L5t0v
z9e3xS+IG4h3FFfTfTeIT87zlfn5VvL85nlQy1DT8N5fkmPFHwe/92bavpy8
Jnjvivn7vp7zBfPnC/Fr4pY5f3wuflW8m3hfcQ3df2Pyejkz55uV4kalNdIL
4mfFlcS1xO+IV4gbincSv6j9NTp2CGmVZ6O/5cRkna9Z+F7c8whim7bb6H5f
6lgXne+uY1XEX4hPFJ+e1xfrs1WeH6yv9/P4Md4/i98VHyI+kjFP/ox8tu90
7Cftv6NjB5e+ZwW9/zrxseKTxD/q/NvEHHFbcdL5T8QdxV1yPvwsr2fiQQPx
N+LTxWeLG4m/FXcXnyOuJf6KNSPuKa4k/pyYKT6NMRJ/Kj4ux4ftxOvFJ4l7
iOuIN4lPFZ8lrif+WnyauFfh3PRDzgfkh+3F34l75HzNvP0+52/yObU9NR61
3bX6rm+INwVrkWp5LjAneHZVgmslaqYWpTUZ852aqbl4jzzfmf/N9Ld74Xr6
7OT1wPyndqKGor6m3n5Z3J81Vbqm2aTP8n7penybwrUUNdU/hetxajdquJ1L
a8SXxP3ETUrXTNQm1Cg7lK6ZqEWoSRr/3/zsm+cr85G1yWfms/5aeq4yZ5nr
/5ReS/gBtfJ6XS7urWvqlq4Zl4nPEdfJ651aiJpo+9I13bPic8X1StecrHXW
PFqwel4rfCY+y7elax1qnqD9aoXXCmtmx9IxhrXMmt4pP1/WHmuQtfpv6bXM
miZ2ba3tZ/p7hRyuc/vk+Ek+bJ7Hb1Me831Kr0lyIzlyXGkNtTbHjGZ5fMm1
5NyxpTUauZycPqZ0TF2s63uJq4nriZ8SnyXernTNSK1JzZnE1QvXptSohbgq
81HcU7xN6ZqSWpSadMscT6hFqUmrlK4xyfXkfPQ7epxas0eOP8QT5gZzhM/y
U+n5x/zCYyD9M/eYg/WJFaVrmyb6G1K4xmEtbZ+srVhT5J5Z0bGGmMNarJe8
llmT+E8jxKfk+EgtRA4ld7YL1uvoa2JArbx26yevZdbwDzp3jfiY0v4Vtcau
ydoJDUVt00x/owrXONSOOyW/PzmaWmSX5NqImoTakxoUPjm4FmqeXBtRE1FL
UVPhFZ4TXGs2Ta49qEGIXQ2TYxkxjNjWIDnWEOOIJY2TYwsxhVqSmhIvdFxw
rUnNSS19Q3DtSg1LrXxTcK1JzYl3OTa4VqVmpVa/LbhWo2bDq8KIpRalhqF2
uTm49qUGxvu5kXXEvbi//nYklurY5XqPA/XZ2hSOhY2SYzExEa02U9cdVFiz
oZ1mRGs3NBTa4pFoLbVnnh/UwDy/TsG5sG5yLu6a5wsxmOfXOj9PNBta7fjg
3F0nOZaTw4nttZNzGzGeWrCy/joUrgnxFo5L/n54DHhdxyY/TzwvvOcOyc8P
D5padffk2pOalee3m/5uL1zzomW2TfYe0DTUqi2Ta2FqVryPjsnjhwdC7UAN
8Wxhj5nxOSrZm8BTwItZou9VpbAnQy1Pjb+6cE1PfX988nhRc+IFdEoefzwB
vPD2yd4xHjLvxXs+ktck3t3RyV4GHh7e+jHJXt6C/P3x4N8WTwrOzdslazVy
NLm8anKuJqejJWolawc0Bdpg8+Tcj0ZAS1VI1kdoKrREpeR4iqaYr3t0F1fU
fo3Ctf2WyfmSGp/afovkfEmNj3ZAQ/C862atUTFZS6A58KK3Ss4HeNLk/mrJ
2gMNgLaonqwF0Bh4R3hIxJsWwVqoZrJ2QBOhJWro79TCmuItXTOAmKD9vQt7
51WS/VQ8dLzzrZNrm3Z5/PHA3hHfHewl4SnhjY0PHg88Vby1CTnWjo+OzcRc
/L0biWuFPV2eFc+sIrmrdOy/LfrZkQOI/bdE5zpyALn+5uhcQM4nF94anSvI
id9Fz0dq2S8Lxzs8GLzr3rrPN9q/K9ob/Lywt4jH+LH2Hwj2FqnZ14ofDPYC
8QQ/Et+fc82E6NxCzsE7xEP8QDw1a5eborUIGgavEc9xjfanB3uJeIofiqcF
65nHtP20sKfNesMjwpvvH+xdUT/iLZ0ZPF/RoMTbXYPnA5qQeLVb8Hyhh0G8
aBo8nvREiCc7Bq9vahbyyc7B40uNS3zaKa8PNCzxe5fg+YtHxXpoEhx/8KSY
Tztk7YyGZv3Uz/kDT434ckbOY/sH57tuOR9R85OvumYtjiZn/jYMXh94YMzv
BsH5DU9tcuEeG+sDTc76rRc8/9HY5JeWwePROdk7xNMl3hBjiC14imiNO6Pz
PZqD3gX6Fq/0muBeCj0VvNKrg71a/CN6KxcF91boseCNDg3uldAzwQu9Mjj+
0nN4V3xPcK+Fngve6VXB8RfPkN7MhcG9FHoqeK8jgnst9FzorQwKjmf0DPGi
bw+Oh/SA8MLvCO790WMjPo4K7hXRMyL+jQzuJdFTIj5eF5wv8KTfE98b3Cuk
h0Zv6dLgXhA9IXpPg7OWuj1aa1XJ8RnP9n3x5KyVJ0drZzQzempatFZHcxNb
iDFNWQ+lvYiHo2txPAm0+oPRsQfNTq1wf7T2RIOiv6aLdy1cA1BbPBCt7akx
8DIfiq5NqVHR9lOjtT4aH609JVrro7nR5vdEa200Otr73ujPhwZHq98drd3R
7GjNO6K1KZoT7ToxOvegYfuQW4Pj1dela4n7orU9NQW1zaRo7U+Nw7W8pn7p
e7K+WyTnfzwb4tFJyeNNz2M3vXaSeLD2hxb2eubrWLfCng/e5eJofxAPE7/z
01yv0ZOjFvgrujagJqgZ7eHi3V5Y2I9bp2PTC/cg8Z6eiK5VySd4v0ui/T08
YPycz8QzCvdkD0Z76dh12r+hsH/ycbRfQg8QrYvmRas2D/ZTPo/ujf63hy1e
G+3v0COcT24S3y2+JNj/+SK6t0pP9VFxh+h7nR3sxTwaXcuTf/GCZkdrOTwh
vKtXor0tPCy8rlejvS08L/zgT6L9JnqSeF+vRXtReGD4my9HP3s8aLyrVeKR
hT0svKvXo70uPCy0JJqS+Vw5eOwYQ571UcH+5VvRfh6eOF790/k8nj1e1Jxo
bwtPCu/+mWh/Fw8f7+pxcfvCHha1ADUB37dOsJc4Nz9vPEW8sseivS48M7y5
N6K9Nzw6/MyP8vOm5453/GS094uHjP+4Jtq/o0dO7bc62r+lBsTf/DDaX6en
hT/5gXhC4Z43teD70bUiNSH19K/RtTI1M94VHha159+lva9fdL5hYQ8Mv+ff
6PN4TNTfv0d7XXhG1Ld/RNfHxB96xxuif59ADxl/guYm9TqeFbXq39G1MTUr
fvE7eT7Rg6AWpiZuK94y2P9YH93boseFN/5UtP+PR45f+aV4buHfANA7GZKv
vyXYb18Q7aVQ/7BWDs7z6aRgr/bNaH+Y9U+t+m50rUzNSj9iobhP4R4LXv6i
aO+GepPa+r3oWpsam99nfBXdO6WHin/+drRfTc8FLw1Pjef3TenfY2zU+eWF
f/PxlLhvXt/Dgv2CMtk/IL6ij05Ozj/0YPltATU1tfTa0n7Fz9GM3sNv/DHa
q8GzwTt+Kdqfx0PGK58X7V3jmXNvPsPjpZ8h+fmA5Pw7JcdTPCP01YbS+XKv
5PqU3yhQ/x2RnM8ZL37rwm9e+G3BwOwd4CFUFn9W+rcH/AaBemV4zscHJV/P
bxyoTw9Pzt+zc/7A40GPflU6vx6cnK/5zQb1ZptkfUDPlXq2bbKemJP1B57H
luLPS8cyYtr40muQ/IJHspX2vyitr9sl6wN6tvR+6QGjb27NevKE5HqYHjV6
tUuy/qaHjf48MVmf0/MmthJjp5UeY/TNHsn6kvWLvtk/WX9OzvkRjwp9vam0
XtgnWY/xGxb0zX7J9Te/KUEP7UsOL/wbEvRUq2S9c1/Or3hi6PeNpf2A1sn6
iR4z+mPvZL3Ob1Lwtv7UZ96tsMeFv079fmnhnhL659Bk/cJvgPALDiOHFe5R
o4cOSdYz/IaG+g1PnHqmZrCXnpL9bzx1enHPRfeq6MnR+1oW3cuiB0Z/b0V0
vwn/A28ssKYLe2T4dzHZK8OzJ9eSc/HF0cH09p6N7vXR4+O78J3oFeBJ0Dtb
Ht37o4dGf3FldL+Lnia90aXRvTh6pPQjX4zuxdAD/Q+3+MCy
           "]], 
          Polygon3DBox[CompressedData["
1:eJwt13f8luMaAPD3977vL5qi1KGt4TSdNNA8DQkNDeW0HC2rgYaOljSEEi0h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           "]]}],
        Lighting->Automatic]}, {}, {}, {}, {}}, {{}, {}, {}, 
      {GrayLevel[0.2], 
       Line3DBox[{251, 474, 1113, 252, 488, 280, 1222, 503, 295, 1227, 518, 
        310, 1234, 533, 325, 1243, 548, 340, 1254, 563, 1161, 355, 578, 1175, 
        370, 1269, 593, 385, 1273, 608, 400, 1279, 623, 415, 1287, 638, 430, 
        1297, 653, 445, 1309, 668, 460}], 
       Line3DBox[{253, 475, 1114, 254, 489, 1125, 281, 504, 296, 1228, 519, 
        311, 1235, 534, 326, 1244, 549, 341, 1255, 564, 1162, 356, 579, 1176, 
        371, 594, 1187, 386, 1274, 609, 401, 1280, 624, 416, 1288, 639, 431, 
        1298, 654, 446, 1310, 669, 461}], 
       Line3DBox[{255, 476, 1115, 256, 490, 1126, 282, 505, 1136, 297, 520, 
        312, 1236, 535, 327, 1245, 550, 342, 1256, 565, 1163, 357, 580, 1177, 
        372, 595, 1188, 387, 610, 1197, 402, 1281, 625, 417, 1289, 640, 432, 
        1299, 655, 447, 1311, 670, 462}], 
       Line3DBox[{257, 477, 1116, 258, 491, 1127, 283, 506, 1137, 298, 521, 
        1145, 313, 536, 328, 1246, 551, 343, 1257, 566, 1164, 358, 581, 1178, 
        373, 596, 1189, 388, 611, 1198, 403, 626, 1205, 418, 1290, 641, 433, 
        1300, 656, 448, 1312, 671, 463}], 
       Line3DBox[{259, 478, 1117, 260, 492, 1128, 284, 507, 1138, 299, 522, 
        1146, 314, 537, 1152, 329, 552, 344, 1258, 567, 1165, 359, 582, 1179, 
        374, 597, 1190, 389, 612, 1199, 404, 627, 1206, 419, 642, 1211, 434, 
        1301, 657, 449, 1313, 672, 464}], 
       Line3DBox[{261, 479, 1118, 263, 493, 1129, 285, 508, 1139, 300, 523, 
        1147, 315, 538, 1153, 330, 553, 1157, 345, 568, 1166, 360, 583, 1180, 
        375, 598, 1191, 390, 613, 1200, 405, 628, 1207, 420, 643, 1212, 435, 
        658, 1215, 450, 1314, 673, 465}], 
       Line3DBox[{265, 481, 1119, 266, 1220, 495, 287, 1224, 510, 302, 1230, 
        525, 317, 1238, 540, 332, 1248, 555, 347, 1260, 570, 1167, 362, 585, 
        377, 1271, 600, 392, 1276, 615, 407, 1283, 630, 422, 1292, 645, 437, 
        1303, 660, 452, 1316, 675, 467}], 
       Line3DBox[{267, 482, 1120, 268, 496, 1130, 288, 1225, 511, 303, 1231, 
        526, 318, 1239, 541, 333, 1249, 556, 348, 1261, 571, 1168, 363, 586, 
        1181, 378, 601, 393, 1277, 616, 408, 1284, 631, 423, 1293, 646, 438, 
        1304, 661, 453, 1317, 676, 468}], 
       Line3DBox[{269, 483, 1121, 270, 497, 1131, 289, 512, 1140, 304, 1232, 
        527, 319, 1240, 542, 334, 1250, 557, 349, 1262, 572, 1169, 364, 587, 
        1182, 379, 602, 1192, 394, 617, 409, 1285, 632, 424, 1294, 647, 439, 
        1305, 662, 454, 1318, 677, 469}], 
       Line3DBox[{271, 484, 1122, 272, 498, 1132, 290, 513, 1141, 305, 528, 
        1148, 320, 1241, 543, 335, 1251, 558, 350, 1263, 573, 1170, 365, 588, 
        1183, 380, 603, 1193, 395, 618, 1201, 410, 633, 425, 1295, 648, 440, 
        1306, 663, 455, 1319, 678, 470}], 
       Line3DBox[{273, 485, 1123, 274, 499, 1133, 291, 514, 1142, 306, 529, 
        1149, 321, 544, 1154, 336, 1252, 559, 351, 1264, 574, 1171, 366, 589, 
        1184, 381, 604, 1194, 396, 619, 1202, 411, 634, 1208, 426, 649, 441, 
        1307, 664, 456, 1320, 679, 471}], 
       Line3DBox[{275, 486, 1124, 276, 500, 1134, 292, 515, 1143, 307, 530, 
        1150, 322, 545, 1155, 337, 560, 1158, 352, 1265, 575, 1172, 367, 590, 
        1185, 382, 605, 1195, 397, 620, 1203, 412, 635, 1209, 427, 650, 1213, 
        442, 665, 457, 1321, 680, 472}], 
       Line3DBox[{277, 682, 1322, 683, 278, 501, 1135, 293, 516, 1144, 308, 
        531, 1151, 323, 546, 1156, 338, 561, 1159, 353, 576, 1173, 1174, 368, 
        591, 1186, 383, 606, 1196, 398, 621, 1204, 413, 636, 1210, 428, 651, 
        1214, 443, 666, 1216, 458, 685, 686, 687}], 
       Line3DBox[{459, 667, 684, 1308, 444, 652, 1296, 429, 637, 1286, 414, 
        622, 1278, 399, 607, 1272, 384, 592, 1268, 369, 577, 1266, 354, 1160, 
        562, 1253, 339, 547, 1242, 324, 532, 1233, 309, 517, 1226, 294, 502, 
        1221, 279, 487, 1218, 250, 473, 681, 688}], 
       Line3DBox[{466, 674, 1315, 451, 659, 1302, 436, 644, 1291, 421, 629, 
        1282, 406, 614, 1275, 391, 599, 1270, 376, 584, 1267, 361, 569, 1259, 
        346, 554, 1247, 331, 539, 1237, 316, 524, 1229, 301, 509, 1223, 286, 
        494, 1219, 264, 480, 1217, 262}]}, 
      {GrayLevel[0.2], 
       Line3DBox[{690, 1004, 473, 689, 1113, 912, 691, 1114, 913, 692, 1115, 
        914, 693, 1116, 915, 694, 1117, 916, 695, 1118, 1010, 1217, 696, 1119,
         917, 697, 1120, 918, 698, 1121, 919, 699, 1122, 920, 700, 1123, 921, 
        701, 1124, 922, 702, 1322, 1005, 923, 1006}], 
       Line3DBox[{704, 1011, 1218, 703, 488, 705, 1125, 924, 706, 1126, 925, 
        707, 1127, 926, 708, 1128, 927, 709, 1129, 1012, 1219, 710, 1013, 
        1220, 711, 1130, 928, 712, 1131, 929, 713, 1132, 930, 714, 1133, 931, 
        715, 1134, 932, 716, 1135, 933, 717}], 
       Line3DBox[{719, 1014, 1221, 718, 1015, 1222, 720, 504, 721, 1136, 934, 
        722, 1137, 935, 723, 1138, 936, 724, 1139, 1016, 1223, 725, 1017, 
        1224, 726, 1018, 1225, 727, 1140, 937, 728, 1141, 938, 729, 1142, 939,
         730, 1143, 940, 731, 1144, 941, 732}], 
       Line3DBox[{734, 1019, 1226, 733, 1020, 1227, 735, 1021, 1228, 736, 520,
         737, 1145, 942, 738, 1146, 943, 739, 1147, 1022, 1229, 740, 1023, 
        1230, 741, 1024, 1231, 742, 1025, 1232, 743, 1148, 944, 744, 1149, 
        945, 745, 1150, 946, 746, 1151, 947, 747}], 
       Line3DBox[{749, 1026, 1233, 748, 1027, 1234, 750, 1028, 1235, 751, 
        1029, 1236, 752, 536, 753, 1152, 948, 754, 1153, 1030, 1237, 755, 
        1031, 1238, 756, 1032, 1239, 757, 1033, 1240, 758, 1034, 1241, 759, 
        1154, 949, 760, 1155, 950, 761, 1156, 951, 762}], 
       Line3DBox[{764, 1035, 1242, 763, 1036, 1243, 765, 1037, 1244, 766, 
        1038, 1245, 767, 1039, 1246, 768, 552, 769, 1157, 1040, 1247, 770, 
        1041, 1248, 771, 1042, 1249, 772, 1043, 1250, 773, 1044, 1251, 774, 
        1045, 1252, 775, 1158, 952, 776, 1159, 953, 777}], 
       Line3DBox[{781, 1160, 954, 779, 1161, 955, 783, 1162, 956, 785, 1163, 
        957, 787, 1164, 958, 789, 1165, 959, 791, 1166, 569, 793, 1167, 960, 
        795, 1168, 961, 797, 1169, 962, 799, 1170, 963, 801, 1171, 964, 803, 
        1172, 965, 805, 1174, 967, 807}], 
       Line3DBox[{806, 966, 1173, 804, 1265, 1057, 802, 1264, 1056, 800, 1263,
         1055, 798, 1262, 1054, 796, 1261, 1053, 794, 1260, 1052, 792, 1259, 
        568, 790, 1258, 1051, 788, 1257, 1050, 786, 1256, 1049, 784, 1255, 
        1048, 782, 1254, 1047, 778, 1253, 1046, 780}], 
       Line3DBox[{809, 1058, 1266, 808, 1175, 968, 810, 1176, 969, 811, 1177, 
        970, 812, 1178, 971, 813, 1179, 972, 814, 1180, 1059, 1267, 815, 585, 
        816, 1181, 973, 817, 1182, 974, 818, 1183, 975, 819, 1184, 976, 820, 
        1185, 977, 821, 1186, 978, 822}], 
       Line3DBox[{824, 1060, 1268, 823, 1061, 1269, 825, 1187, 979, 826, 1188,
         980, 827, 1189, 981, 828, 1190, 982, 829, 1191, 1062, 1270, 830, 
        1063, 1271, 831, 601, 832, 1192, 983, 833, 1193, 984, 834, 1194, 985, 
        835, 1195, 986, 836, 1196, 987, 837}], 
       Line3DBox[{839, 1064, 1272, 838, 1065, 1273, 840, 1066, 1274, 841, 
        1197, 988, 842, 1198, 989, 843, 1199, 990, 844, 1200, 1067, 1275, 845,
         1068, 1276, 846, 1069, 1277, 847, 617, 848, 1201, 991, 849, 1202, 
        992, 850, 1203, 993, 851, 1204, 994, 852}], 
       Line3DBox[{854, 1070, 1278, 853, 1071, 1279, 855, 1072, 1280, 856, 
        1073, 1281, 857, 1205, 995, 858, 1206, 996, 859, 1207, 1074, 1282, 
        860, 1075, 1283, 861, 1076, 1284, 862, 1077, 1285, 863, 633, 864, 
        1208, 997, 865, 1209, 998, 866, 1210, 999, 867}], 
       Line3DBox[{869, 1078, 1286, 868, 1079, 1287, 870, 1080, 1288, 871, 
        1081, 1289, 872, 1082, 1290, 873, 1211, 1000, 874, 1212, 1083, 1291, 
        875, 1084, 1292, 876, 1085, 1293, 877, 1086, 1294, 878, 1087, 1295, 
        879, 649, 880, 1213, 1001, 881, 1214, 1002, 882}], 
       Line3DBox[{884, 1088, 1296, 883, 1089, 1297, 885, 1090, 1298, 886, 
        1091, 1299, 887, 1092, 1300, 888, 1093, 1301, 889, 1215, 1094, 1302, 
        890, 1095, 1303, 891, 1096, 1304, 892, 1097, 1305, 893, 1098, 1306, 
        894, 1099, 1307, 895, 665, 896, 1216, 1003, 897}], 
       Line3DBox[{911, 1009, 685, 910, 1321, 1111, 909, 1320, 1110, 908, 1319,
         1109, 907, 1318, 1108, 906, 1317, 1107, 905, 1316, 1106, 904, 1315, 
        1314, 1105, 903, 1313, 1104, 902, 1312, 1103, 901, 1311, 1102, 900, 
        1310, 1101, 899, 1309, 1100, 898, 1112, 1308, 1007, 1008}]}}},
    VertexNormals->CompressedData["
1:eJztyDENgEAURMEfCEJosYALJJAcLRJwQnCCAc7G6YDiqHBAZpuXnX5ep9RE
xNBFtE+vcVv2o5xvo45zzjnnnHPOOeecc84551/P9WfOOeecc84555xzzjnn
nHPOOeecc84555xzzjnnnHPOOeecc84555xzzjnnnHPOOeecc84555xzzjnn
nHPO+W/8BsS3tws=
     "]], GraphicsComplex3DBox[CompressedData["
1:eJx1nHfUFdX1QD8QUcQa8RcxSkx8QmIIgmJJorzYkIeiMcUSDCJCsD3wJ4mi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    "], {{
      {RGBColor[1, 0.5, 0], Opacity[0.5], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxFmgkYFlPYhme+M+eLhFRaaY9Kpc2WqCjJWkmhBe2FUHaJ7KUi2ZKQSpZE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           "]], Polygon3DBox[CompressedData["
1:eJwtmgn8T0Ubxe+dO9dOCCmUJUna0PJqX0mLZKm0iYp2lbTvu0KltG9IZanQ
JipLC0VZKloUKaWokEJK7/k68/kY/zl35s5v7r0z53me80yT3v26XByyLPtV
/0X9XVFk2dAyy1bnWXaP8FLhQcIrhG8W/lv4O+E/he8THqabFgrPEz5XeIna
n9VYPwnfJLxMeIjafxG+VXiB8GfCnwj3Ef5OeLDwz8K3pPu/EP5C+FLhP4Uf
Fd4s/JhwJ9XvU1klfLvwX2p/TPg/4ceF1ws/LpxpDk/oz/fC9wqvVPttwpU1
30/UVkdlvPAXal+k9vlqv0B4nvCnwh8LnyP8mfDnwnOF+wqfpPqFusZPHKkx
Nqk+TX9LlWd0rYrGH6HGusIThBsJ/ym8jfDrwgOFa1bIsn+FfxEeofuvVv1N
jd9ZeKTwAPWfLHyC8Amq11b/hrpeRdd20v3/6lpj3fOO2lsIbxZuIjxVeGfh
/4SbCk8THq37rhSerntPEm6t9goabxe1fyTcVriy8G7Cc4S3E14cPP+JwhXV
VklljfBqlTbReFfVZ6t9T+FSuKXwh8L7CFcT3lN4rvAOwn/p9+sLvyH8leZz
p/B3ms+1wl8L3yW8TPg64X+EnxSuoP7DhZvp/r+FGwpPEf5X7U8JVxQeIbyj
2jcJby/8lnAh/LRwdeExwlH4GeEawmPT+Hyv9fq9oZm/3zK1/yV8v/Ao9a+h
+bdRn/nC36j9brX/oPYbhBcLDxT+Xvh64cbqv154W/WfJNxc+B/hHYTfFr5L
eCuNt0l4hXAT4Q1q345vLtxUeKNwA+HJ7C/9vVtj/6j6cpWf9Hv3q/13Xbtb
+Dfhh0rPn/l+IrxAeI7w2axJ4UYqv6u+q651VH17lTXCuwu3Uv2Iwm3bqUzT
7++g+R2ma62Ej9PfHVT+4NuyBlVvrPKncBvhXVU/qvBYDVRO0W/3E66k9o6a
e1vVz1Y5QG1NVfbW+FU1/h5q+0R9PhRuJnyG+rRTe2v9PU3lf6o3VtlX7dXV
3lr956n/6WprprIpc59H1d5DuKnKRuaovyer7KO2HVRWqf615vRj4p/TVL+U
vaP6MRrzfd3fVOMfW/j5rmW+6nO/6s3V5+bC3+sf9W0l3E54O5WfVd9JfVry
bCo7q15f5WTde5Gwbsna656LVe+ha9eprZ6u7SHcTWUv4e1VuqvtfGH9yw5X
/5159sJjb6PSTe3nFlvoKztM/w3VfCeobKu2M1VOV/tlaq+q9mPVvovqh6js
krvP3qpvW3jt7Cg8R/f2Kfxd+B5n6P7+qldT+3G6/xzVm6v8l/mbHVqYa37N
POap6n+JcGXho4PX41e6tjTtX74j35Bvx/dcrvqXal+i+jVqf0v4I+F3hU8T
niY8W/g9niWtd+ZbUbiG8JOa7/cq3XN/84/UNk/9PxLuLfyI2urpZVfV9Q3C
M/R3jtrf59mEu8I1FbxmaunaG/o7U9emqn6i2icJzxKelvjwd+GHhTckPpgj
PF94tvBZwm8Kf5j482Th1cKPCG8UfkD4RNUvKGw7j9CzzFJ9rq7NUnsv7Krw
xGB+wV7+Ivyg2tcKDxb+WfgB4TXCg4TfE/5Y+APhnsJ7aeAqep7dNcbH7EG1
n6myn9qb5OYDxl+R7OcphfcEe2Hf3L+/uLQ9xn5XFP5W9StVX6fSS3hHlX8z
j/mg6peq/zjVD+P5Cq9h1u7eKhtVX6r2darfq/YucAGcI9w2t7+A/f9S9cvU
/pDmX1fzr6zrfwmv1d9vdP+vah+Y+Tq2/I7M7euYn9p/S3z3gfAnwjNZ/8LD
Nd4PKiflnjP+wZLEj/grDwhfIjyWtSyc01/4H7hDuCUfivWhOU7PbMux6Veq
vU7mb8k3HSC8dea9yp7tL1w7815nz18tXFf4HNWv17X6+AYac4nGXxrNrafw
fkrzzW6F3/m5wjep3oBvpf7fqe+yaC49T9fOUvs1hcfuGrz32IM35/4N9i57
+M7cY8AFcMLt8Llw9bR/+giPEu7NXAs/WxdsjNp+VDk3957vpfarCj/rCWrv
I3wDHCJ8snDD9L77qv+runaH6ofqej/hmpm5FY69Nfc92AJswo3wWWYug9Mu
Fa4lfCbvuvC77Kxx+tK38Nx7CD+s8V+PXm9wJt+Sb9qGb6X20el9t2BtCjdI
9qQnY6r/LsI7Cp/FM+Ven13h9LTGOql+vEqNtAdY3yep1BQeJvyi7n8nmjvh
0DH6vVvYA6qfig8hfBt7DNuCjxnNN6cW3m9v8+0rmIcZ4xj176kyUPWGumeh
rjdR+zH6W13X9tPf/eFXbCs2P30f9va7wh/jr0Zz94LMvhw+3VHYqmBfEZ+R
vXqN8D7MQ6WS+jfCZib+78ua0rWxhe394dgQ4ct1/2Oqt1Pfy3V/f+FHsUms
NdYL3K7+HbAZubkBjmjLXlD7RcL3YA/ZC6wL4cHYI+G++DL6/ZejbSU2k9iC
GANfb1ww98GB+FIvCr9Lm659pr4XZfZ9sDnYmrFqHwc/RNvCYzJzKZyKb/ZS
MJfD6bcKvxrsa+JzXij8VLCvic/J2E8H+1JwKNz5SjC3w/HECq8J31E6RiA2
eBLOYC669mnuMd8WvkZ4Qe4+n3Kv8DfCA/h+wjczh8SHs4VvKs2PxDfzmavw
Yr4FvwE/6vl6Ch8gPJe5MWfh/sLv866EPxe+WHiq8NUpfjmfZ0h80ju3Dzcx
8VGv3D7gTN6V+i8U7pfZj2L9b+H2zL4tPi5jPxMcOxFD8SwvCJ8vfIdwM+Ge
wd+abz4q9xoaxL3Cz+ZeQ6wN1shI7BH8CnexN+AC3X+76ufp2hNqb515bH7j
ydx7nrEYs6XqfYK5Aw4ZjP3LPBZjPpV7TTIWYzbFNwn23fHhedbhwXv3dP19
PPcehhvhyHtzPxNcBCc9lPs34RI4ZQZcWjiWJablWz0fzJVw5rDcewDuhsPv
y/2McD2c/3DuPUEsjY1kLYwK5l44eEjuORMLExPzrZ8L5jpszIO5OW8A/KXr
g4QbC++huUXNcWd8D+Emie+wxeuFpyT+OEi4yM2lFwS/b97vUOEJpd8H7/9e
4ZfhgNycd7/weDgivS/i1kcSVxG/3q32F+HoNL+hafwxwocI19Bvr1R7ZV17
Pq2Hl9Lz8L5Gqr51dGz2ufoMVPs4XRuq9p0yx00DE5cRP/H94OBB6fu/KDxV
+DXh44THC08XfkP4ePaD8J3B8XQXvpnwW2ofL9xeuKZ+e5VwFfV5gTWu9reF
J6i9g/DDwq8IDxfeJ/PaYv0MTt8L24CNuCd9j4eEJwo/g7+UmavfEZ6Ym7Or
JP2hQopfawn/qvaq2LbM7+L30vEr76S+8B+8o6RXbCO8Vri28MuZ490fS+sj
6B9wOZz+Svq9G1nLwXrKotzc3j/Nh+fbTfcHrZ+d1OcD4d2FC+EWwjOFRwjX
Yr8G74HjdW+u9ubEUsLbqn1daT0FvWOi+r5bWs9Av6ig9p+Eg9qfEq4k/LNw
DNZLJqbvMyv5d7XV/pvaq6X4va7wauGawi8K1xNeI1xL+CXhILxc+N/c+hD6
zi+l9Zjhwv9p/O+FN6n9kcxcDqcTvxCfHAdflPaJr8gcV/ydfAHii4oab4Xa
C433tPAEtc8QnpRbr3lZeJrw68Kd2LPCU4RfFj4SG6T6I4XX2qVoIKyNwn2v
CI618QX2SHzNWmPNce8laASlNSJ+66rgWB5bvFvic/Yee5C1eVawTrOfSrtg
vYa9yx4+GG4M3tvs8YOEzw3ei+xJuPls4fqqr9ffZXw7fL7omHnPNL9J7IXC
e+tK9XtNbTOjtQE0AmJJfK/9k3/5fGnOYm90Yo2pb6MK1hW4B20Bf6x1un9w
tN51MJyfO/bGn2meOwZ/Ha4vvNcH8PvJX2EtXyY8RPePT/4GNrRBYf+qheor
1Wen5AsdmPhwG9XrFa6Xuf3X5zTmtbk1DZ6VZx6d+IxvwTeB3w4Vvk74BXzS
5O/ii6HnEX/gk6FVoVkRK85IfD46+cf48zwLz/R87m8ySniy8EvCR2R+tteS
/cSespZYUyOSPWUtsaZeyP2N4XI4mLmeH6yloXkR204P1lKJmYiV3kz2FHuC
f45PjlaGZoZ2Oiv42/EN8ffx3zfgQ+WO1X/IrMe8ER1vosGgvcFJcNHMYD6D
49HvJie+QF8k/pqWWbtFwyX2nRys3aLhEhtPCdZSt2iqwnODuR7OR0u4JTi+
IB5hzQZskv5rq1JHc8lyx37NSu99YsBFyZ9j7z8RzA1N2XOZOQItsEnpWJ2Y
nb3fojR3wQFwGZwGF30UHFs3KK01EWPDRTuWjjXhpDWF498q+vtgZq5uXpqr
4Gy09MalY2k0dWLZ7UvHvsS0cH3r0lwH58O1bUvbAjj3cY1bC/FJfztmjp0b
lY6tiaGxvbuoPJfZBsO9O5fmMjgYrmxZmovhzA8L2wxsxSWZY31ifp7/7WDb
iQ3tLnyD8AbVn8AmsNYyPw85AsZ/J1gLRRNFW14erOWi6aI9LwueLzE/7+sN
4ZWqD9O1P/T7QzLHHtOj+Q7emxHt08J9XPuWtaz+y1W/MfP7Y33zfidpvPei
fWK4C45FSxrGc+bWlNCG0IjOUfug4FwGOY21vI/C3xMbg21+P3h9oBnzvqZi
A/E9CmtFdwfzC3yyNHO8xfpDg8C3eC+tN2wSvtC7weuB/YKt+wB+xJYU1nLv
Ed5cWO+qpr8jM+cS9uI3M+cUWH9oPKzXCcFa+96lcw1o7tjKPUuvV2wm2lx9
lasza3T4R1eVfh+9Mj//saVzHeR0yNXUKf1+yNmQmyFHw3ofGZwbqVs6lzM3
7a96pWMRYhK0m61Ka1loOGhjNUvbemw+WleN0todmhe5l61LPz85mDH6ra31
/KGw/oZW/r/S2jma+bYVnLMgV7GV+tylciHrW/fulTnewv/ZoiEW1t73La3V
o8Gj3e9TOjeBhv+s+lwhPCX5i2iBtUprj2iCaO21S39vNPf3VH+1cPvAYL2w
juYUC79DfKFY2n7jE+Hb7V76e+PjoYU1VLkrsyaGdo2GDR+MD/Yt8tL2Dh8D
32i30usRHwnfCB+J3MeiYF9y19LrDZ8S37ZV6fWGjztMY1/GetBYh+vakML5
qM34DZm12qoqp2bWbNE+q5TWStFAWZ8VVbqxv3Ov/woqXeGH3L5RUdo/mJT2
V6XSfIEGSy6AnMA3wuuCtdjKpbVZNFm04Wql+R2NGK1529J8jc+G1lu9tHaM
5otv3Ka0L4yPjFZ+f3QuAz0creXd6L2PnzUpWrNBq8FmoU3MV2mf22fA98UH
XqjxVmm8BarPi47F6bMg9ceXODK374wP/bnwyuDvgw/L+vw0ODYjRluUOcf6
KdqbSifilbQesJHYxs+Cc2nk1L6Av4P1e2I4/BN8loZqfyFaLzpQz/O56v1V
OhPv5NaL2hET5o75Fkb7aPhW9GF9EHOw/hdo/M+ifTz4sVOyF8Rs8Mc8tQ/i
fRXOPa5iz+n3n4/Wl7bkRoSfi9bv0bywJ/jg2KePk73B5+f7zAmOJ4in0eY2
Z36W7tGxJM/E2J2iYz1+A73xPHz4zD4puUpyll+rvjb4t4+I9kWYA7lHcpDf
wpXBuSRySkuw58G5PXJ8QX3rFNbW0dgXq/0P7Knq1aJzB3/r2tPRGiPa4j+Z
c5/kRFsF50DRktGUyVX9HKznLir8bXsn/4EYAvs9Ozi/MSn5S2i05HLJ6aLt
/xicyyWnS67sp+BcLTnbL/EHgvXlKcQMuTUdcr3kfMm1rgjWD1up9Mit8d4X
rfmh9f2WpXx9Ye0RGwc/EAPDf/MTH5LTJPZbEsxtcNxbuff4Z2n9XqV6w9x8
Sk4T7WFpsC2EE+ACOAJ7RA6Y2PJb/IdojXW5cDP1Wcy3jNaeugqPU/3m6NgL
TRZ7Rw79feFvkj0jBiS3+kWwf0RMTC78y2CtnXiFuaG5wy/kfLBPgxPfkoPA
H3wdvlbfZ6JzV+SwiB2IQVomPmC+R6psr/71cq8dNFVse0j8Q4xO7v2r5J/h
404T/jrYN7sneu/go6EVwz/ktshRbSP8WPRaq1E4v8GcmAuaO1r4Fypdcmvi
vK+vorX9bsIPRmu0aLOrM/vivM9uid+ItcZE693EXF+yPlUeytKYah8brY93
L8y36K34n2OSv0BOD39yNPZRfUeq4FvnufWxj6LjPeK+2dE5BmI/rvHbl0Xn
mpgDv3VtdK6H37wzvV/Wwk+Zbf290Ws1JFv6QPSzYVNHq943eu2yhrH/T0Xv
zZqF7dWbyfYOCeY/+PHOzDmqL9P7RBs7Ibc/QQ6eswvfwb+qD8dnUX1c8oH4
XX6f8y34mvic+MYjUjy9WvfsnlkzQ5taFR3volERX/8erY2heaFtoXGhDfUO
jt9/i9a60NDQXy+M1rM5Y4B+eVG0b8sZBPLB6N8dc+f40Z5WwieZNShiy1+i
Y1FiTGJTYlTG7x6sjaGR4W/dlvz5f6P1BjQxtK/N0XoFGhixKDEpe/+6YG3j
n+jYFI0DPf2CaP2eMxzExn9Hx5/EyMSja6O1QzRGYmtibOZ3VHBsuSI6l0SM
iV6xJlp7RHNES0NT4/f6BcfiG6NjXWJytNdjorVaNFhy+eT0yb13C86dHRKd
myKHRm7q4OjYm/dDrp6cfUXhDik+aVfaHhOzol13iY69icHhevSw2kU6n6D2
w6JzceTgyIUdGp3PIidGru7w6NwPOTtyhwdFz48cIrnF/aPzb+QYyT0eEJ2v
IwdJbvLA6HwgOUq05OOizyagKaM1d4w+u4DmjHZ9bLTWjIaNHn58tNaL5ouW
fHS09sp6xFfGZ+b+XsHae+doLR0NHq29fUzadG6tukO0Vo5mjXZ+VLTWjYaO
Fn9CtO+NJo/2+V+0PoPmiL61Lnr9o6miZfwZrV+haXBehfMl7DU4jfMsnFfp
kdmGwSdwWufC+TxiJXxSfFF8TNYnGhy25/rg9Yymi395Y9I/rovWJ7acKRO+
Plrv2HKGTPiG6FgWQYHzEJyvODqzD4S/gg/GGZD9M/sr+ESc4UATxx/BJ9qr
sGZNfp18/YzMPgT5uRaFbQmaFucvOC/DWSN8IvKBnAnhLAiaFbE1MTax8FvB
53Q484Fvi497UOEzKdiqlolf4XTOnKBhYk85L8MZmWczn6fhvM0rmX0c8qHY
SewlGhxa0oZoLQpNCf3oxmj9ZcuZrNIcyfv5MDh/d0W0XsMZBvJxV0bPlzMO
xPLE9PDXy8H5vMuj9Sf0DbSh26PPdrHfnhWuE829C4O1r7+itS72H1rZeuED
M2tmo0rrCdz/fXB+cUC0nsQZRs4KYn9YK5wzID94dbQex5kP8luXRp8l5Iwg
et1N0bE2Z8zQs26J1uKJ19DHbk3zq5H0qdui48+6KV5DEyY+uTVYjySf1yH3
mRryjVdF63Gc4SIfdHF0/pEzHOR/+kXnLzkTSb7pkuh8JGcoyU9eE60lcQaF
/FjX6NwbOTdyzfjDrD3yJodoDnUL+ypL2UPRPge+BnMmd3l6dC6THCa5vG7R
seCo5F8eVNq/aZr80SNK20vOEBIrEzMTS14bnJ8+NTpWJ14kN3ladG4UPYB8
9SnRsTU5GXIJ+BPvZc4pkLvoEa1lkcNgLbAmGgV/Y2JXYlj4hYOrxF+HlPYP
yWGgZaBpMP5dwfnqk6Lnx5kW4rtDS/uj5Dg4X3BitFaLZku8dlhp/5ecGrmS
k6NzKfAXsTIxM/xLLoyzDftFa6doqJxF5EwiZyN/CNYm8FHwTabrWr3gd4+/
xx4kr0Ib/gscQfzSsbT/v2eKVzqXtjVtkj+J5sf3+S/FN0eX9v85M0d8whnN
rzLnAoiX2peeD2c8iXc6lNbjOFNELHNkaT2OmAa9bv/SegJnGMlV947OV5Kz
Zq+x5+jLPcQrB5b2v7ecQVWdw7HHZs7JEd8cUNpfb5z8j1A6/0GOjnj38NLx
A2dI0QeOKh0PcWaQXPsZ0fl6cu6czeOMHvZ0U4q/Di7tb6Mpo7WiubKfOVvE
WYKe0flszhSQm+8TneshR8/5gPOjzyNwJpXc0HnR5w3QG8i9nx2d7yUHjx45
Odmj9oXtGzk+9JGbgnP9Z0Xnb8n547++mbSrorC2isbKOTF0SPQSckroY7cH
71328MbgmHZGbj8Yf5jfJHffK9r/JIePvkQO7UzhO4LPwhCvsrY4m4f+sTDZ
06ML+87kuyoU9qHJtRDvwE0Nk9aG5sb+ywtrj2iQ8A25MdYgvg+xOzaLswhn
RufXOZMAt1RN/Fld/V7Nsy1xD/EPNpSzDudEnyfgzAN7Hw7Yusi2xBScTRmb
7C22Dls7NfrsCDYXLofTKxWOKbB1s6LPCmHzeDaekbM95PT+Dye548o=
           "]], 
          Polygon3DBox[CompressedData["
1:eJwt13ncDfUaAPDznvc93FDKlhQiWxHKlrJUShEq2lAp5N5ky5Z9exFZKyKE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           "]], Polygon3DBox[{{1357, 981, 980, 1356, 773, 774}}]}],
        Lighting->Automatic]}, {}, {}, {}, {}}, {{}, {}, {}, 
      {GrayLevel[0.2], 
       Line3DBox[{368, 578, 1364, 369, 591, 396, 1451, 604, 410, 1456, 617, 
        424, 1463, 630, 438, 1472, 643, 452, 1483, 656, 1402, 466, 669, 1414, 
        480, 1498, 682, 494, 1502, 695, 508, 1508, 708, 522, 1516, 721, 536, 
        1526, 734, 550, 1538, 747, 564}], 
       Line3DBox[{370, 579, 1365, 371, 592, 1376, 397, 605, 411, 1457, 618, 
        425, 1464, 631, 439, 1473, 644, 453, 1484, 657, 1403, 467, 670, 1415, 
        481, 683, 1425, 495, 1503, 696, 509, 1509, 709, 523, 1517, 722, 537, 
        1527, 735, 551, 1539, 748, 565}], 
       Line3DBox[{372, 580, 1366, 373, 593, 1377, 398, 606, 1385, 412, 619, 
        426, 1465, 632, 440, 1474, 645, 454, 1485, 658, 1404, 468, 671, 1416, 
        482, 684, 1426, 496, 697, 1433, 510, 1510, 710, 524, 1518, 723, 538, 
        1528, 736, 552, 1540, 749, 566}], 
       Line3DBox[{374, 581, 1367, 375, 594, 1378, 399, 607, 1386, 413, 620, 
        1392, 427, 633, 441, 1475, 646, 455, 1486, 659, 1405, 469, 672, 1417, 
        483, 685, 1427, 497, 698, 1434, 511, 711, 1439, 525, 1519, 724, 539, 
        1529, 737, 553, 1541, 750, 567}], 
       Line3DBox[{376, 582, 1368, 377, 595, 1379, 400, 608, 1387, 414, 621, 
        1393, 428, 634, 1397, 442, 647, 456, 1487, 660, 1406, 470, 673, 1418, 
        484, 686, 1428, 498, 699, 1435, 512, 712, 1440, 526, 725, 1443, 540, 
        1530, 738, 554, 1542, 751, 568}], 
       Line3DBox[{378, 583, 1369, 380, 596, 1380, 401, 609, 1388, 415, 622, 
        1394, 429, 635, 1398, 443, 648, 1400, 457, 661, 1407, 471, 674, 1419, 
        485, 687, 1429, 499, 700, 1436, 513, 713, 1441, 527, 726, 1444, 541, 
        739, 1445, 555, 1543, 752, 569}], 
       Line3DBox[{382, 585, 1370, 383, 1449, 598, 403, 1453, 611, 417, 1459, 
        624, 431, 1467, 637, 445, 1477, 650, 459, 1489, 663, 1408, 473, 676, 
        487, 1500, 689, 501, 1505, 702, 515, 1512, 715, 529, 1521, 728, 543, 
        1532, 741, 557, 1545, 754, 571}], 
       Line3DBox[{384, 586, 1371, 385, 599, 1381, 404, 1454, 612, 418, 1460, 
        625, 432, 1468, 638, 446, 1478, 651, 460, 1490, 664, 1409, 474, 677, 
        1420, 488, 690, 502, 1506, 703, 516, 1513, 716, 530, 1522, 729, 544, 
        1533, 742, 558, 1546, 755, 572}], 
       Line3DBox[{386, 587, 1372, 387, 600, 1382, 405, 613, 1389, 419, 1461, 
        626, 433, 1469, 639, 447, 1479, 652, 461, 1491, 665, 1410, 475, 678, 
        1421, 489, 691, 1430, 503, 704, 517, 1514, 717, 531, 1523, 730, 545, 
        1534, 743, 559, 1547, 756, 573}], 
       Line3DBox[{388, 588, 1373, 389, 601, 1383, 406, 614, 1390, 420, 627, 
        1395, 434, 1470, 640, 448, 1480, 653, 462, 1492, 666, 1411, 476, 679, 
        1422, 490, 692, 1431, 504, 705, 1437, 518, 718, 532, 1524, 731, 546, 
        1535, 744, 560, 1548, 757, 574}], 
       Line3DBox[{390, 589, 1374, 391, 602, 1384, 407, 615, 1391, 421, 628, 
        1396, 435, 641, 1399, 449, 1481, 654, 463, 1493, 667, 1412, 477, 680, 
        1423, 491, 693, 1432, 505, 706, 1438, 519, 719, 1442, 533, 732, 547, 
        1536, 745, 561, 1549, 758, 575}], 
       Line3DBox[{392, 760, 761, 1375, 393, 763, 1551, 764, 408, 765, 1552, 
        766, 422, 767, 1553, 768, 436, 769, 1555, 770, 450, 771, 1556, 772, 
        464, 1494, 773, 774, 1413, 478, 775, 776, 1424, 492, 777, 1557, 778, 
        506, 779, 1558, 780, 520, 781, 1559, 782, 534, 783, 1561, 784, 548, 
        785, 786, 562, 1550, 788, 789, 576}], Line3DBox[CompressedData["
1:eJwVzNc2Q1EUBdAdxvABHtQgEb2L3nuJLohORPDGf/hkT+Z5mGPdsdY9O1/7
KX9nIqLKr4+/hoj2xog5OpoiZuUg8yykjiU6bYtyiGVWUscaWduqHGadDZp1
WbnFJiNs06PfkV3sscso++RsB7KbEoeMcUTedpzec8oJvbpxecZ5es9luq2/
kBOUuUrvuUm3bddykgq36Q733DHFA4+0+bcgn3limhcK+lfZxxtVitRSZ3uX
/XxQZ4ZPvhighVb+AewFGkg=
        "]], 
       Line3DBox[{563, 746, 787, 1537, 549, 733, 1525, 535, 720, 1515, 521, 
        707, 1507, 507, 694, 1501, 493, 681, 1497, 479, 668, 1495, 465, 1401, 
        655, 1482, 451, 642, 1471, 437, 629, 1462, 423, 616, 1455, 409, 603, 
        1450, 395, 590, 1447, 367, 577, 759, 792}], 
       Line3DBox[{570, 753, 1544, 556, 740, 1531, 542, 727, 1520, 528, 714, 
        1511, 514, 701, 1504, 500, 688, 1499, 486, 675, 1496, 472, 662, 1488, 
        458, 649, 1476, 444, 636, 1466, 430, 623, 1458, 416, 610, 1452, 402, 
        597, 1448, 381, 584, 1446, 379}]}, 
      {GrayLevel[0.2], 
       Line3DBox[{873, 1158, 577, 872, 1364, 1082, 874, 1365, 1083, 875, 1366,
         1084, 876, 1367, 1085, 877, 1368, 1086, 878, 1369, 1255, 1446, 879, 
        1370, 1087, 880, 1371, 1088, 881, 1372, 1089, 882, 1373, 1090, 883, 
        1374, 1091, 884, 1355, 1375, 1092, 1190, 1562, 1213, 1214, 1197, 1212,
         1093, 1159}], 
       Line3DBox[{886, 1256, 1447, 885, 591, 887, 1376, 1094, 888, 1377, 1095,
         889, 1378, 1096, 890, 1379, 1097, 891, 1380, 1257, 1448, 892, 1258, 
        1449, 893, 1381, 1098, 894, 1382, 1099, 895, 1383, 1100, 896, 1384, 
        1101, 897, 1551, 1160, 1102, 1191, 1563, 294, 1198, 324, 1231}], 
       Line3DBox[{899, 1259, 1450, 898, 1260, 1451, 900, 605, 901, 1385, 1103,
         902, 1386, 1104, 903, 1387, 1105, 904, 1388, 1261, 1452, 905, 1262, 
        1453, 906, 1263, 1454, 907, 1389, 1106, 908, 1390, 1107, 909, 1391, 
        1108, 910, 1552, 1161, 1109, 1192, 1564, 1215, 1162, 1199, 1233, 1234,
         1232}], 
       Line3DBox[{912, 1264, 1455, 911, 1265, 1456, 913, 1266, 1457, 914, 619,
         915, 1392, 1110, 916, 1393, 1111, 917, 1394, 1267, 1458, 918, 1268, 
        1459, 919, 1269, 1460, 920, 1270, 1461, 921, 1395, 1112, 922, 1396, 
        1113, 923, 1553, 1163, 1164, 924, 1361, 1554, 1165, 1200, 1166, 1245, 
        925}], Line3DBox[{927, 1271, 1462, 926, 1272, 1463, 928, 1273, 1464, 
        929, 1274, 1465, 930, 633, 931, 1397, 1114, 932, 1398, 1275, 1466, 
        933, 1276, 1467, 934, 1277, 1468, 935, 1278, 1469, 936, 1279, 1470, 
        937, 1399, 1115, 938, 1555, 1167, 1168, 939, 1567, 1216, 1169, 1201, 
        1170, 1246, 940}], 
       Line3DBox[{942, 1280, 1471, 941, 1281, 1472, 943, 1282, 1473, 944, 
        1283, 1474, 945, 1284, 1475, 946, 647, 947, 1400, 1285, 1476, 948, 
        1286, 1477, 949, 1287, 1478, 950, 1288, 1479, 951, 1289, 1480, 952, 
        1290, 1481, 953, 1556, 1171, 1172, 954, 1568, 1217, 1218, 1202, 1248, 
        1247, 955}], 
       Line3DBox[{959, 1401, 1116, 957, 1402, 1117, 961, 1403, 1118, 963, 
        1404, 1119, 965, 1405, 1120, 967, 1406, 1121, 969, 1407, 662, 971, 
        1408, 1122, 973, 1409, 1123, 975, 1410, 1124, 977, 1411, 1125, 979, 
        1412, 1126, 981, 1357, 1413, 1127, 1193, 1362, 1570, 1221, 1204, 1236,
         1128, 1235}], 
       Line3DBox[{983, 1249, 1250, 1203, 1220, 1219, 1569, 982, 1173, 1494, 
        1356, 980, 1493, 1301, 978, 1492, 1300, 976, 1491, 1299, 974, 1490, 
        1298, 972, 1489, 1297, 970, 1488, 661, 968, 1487, 1296, 966, 1486, 
        1295, 964, 1485, 1294, 962, 1484, 1293, 960, 1483, 1292, 956, 1482, 
        1291, 958}], 
       Line3DBox[{985, 1302, 1495, 984, 1414, 1129, 986, 1415, 1130, 987, 
        1416, 1131, 988, 1417, 1132, 989, 1418, 1133, 990, 1419, 1303, 1496, 
        991, 676, 992, 1420, 1134, 993, 1421, 1135, 994, 1422, 1136, 995, 
        1423, 1137, 996, 1358, 1424, 1138, 1194, 1565, 1222, 1223, 1205, 1238,
         1139, 1237}], 
       Line3DBox[{998, 1304, 1497, 997, 1305, 1498, 999, 1425, 1140, 1000, 
        1426, 1141, 1001, 1427, 1142, 1002, 1428, 1143, 1003, 1429, 1306, 
        1499, 1004, 1307, 1500, 1005, 690, 1006, 1430, 1144, 1007, 1431, 1145,
         1008, 1432, 1146, 1009, 1557, 1174, 1147, 1195, 1566, 1224, 1175, 
        1206, 1240, 1241, 1239}], 
       Line3DBox[{1011, 1308, 1501, 1010, 1309, 1502, 1012, 1310, 1503, 1013, 
        1433, 1148, 1014, 1434, 1149, 1015, 1435, 1150, 1016, 1436, 1311, 
        1504, 1017, 1312, 1505, 1018, 1313, 1506, 1019, 704, 1020, 1437, 1151,
         1021, 1438, 1152, 1022, 1558, 1176, 1153, 1196, 857, 1177, 1207, 
        1243, 1244, 1242}], 
       Line3DBox[{1024, 1314, 1507, 1023, 1315, 1508, 1025, 1316, 1509, 1026, 
        1317, 1510, 1027, 1439, 1154, 1028, 1440, 1155, 1029, 1441, 1318, 
        1511, 1030, 1319, 1512, 1031, 1320, 1513, 1032, 1321, 1514, 1033, 718,
         1034, 1442, 1156, 1035, 1559, 1178, 1179, 1036, 1363, 1560, 1180, 
        1208, 1181, 1251, 1037}], 
       Line3DBox[{1039, 1322, 1515, 1038, 1323, 1516, 1040, 1324, 1517, 1041, 
        1325, 1518, 1042, 1326, 1519, 1043, 1443, 1157, 1044, 1444, 1327, 
        1520, 1045, 1328, 1521, 1046, 1329, 1522, 1047, 1330, 1523, 1048, 
        1331, 1524, 1049, 732, 1050, 1561, 1182, 1183, 1051, 1571, 1225, 1184,
         1209, 1185, 1252, 1052}], 
       Line3DBox[{1054, 1332, 1525, 1053, 1333, 1526, 1055, 1334, 1527, 1056, 
        1335, 1528, 1057, 1336, 1529, 1058, 1337, 1530, 1059, 1445, 1338, 
        1531, 1060, 1339, 1532, 1061, 1340, 1533, 1062, 1341, 1534, 1063, 
        1342, 1535, 1064, 1343, 1536, 1065, 785, 1186, 1066, 1572, 1226, 1227,
         1210, 1254, 1253, 1067}], 
       Line3DBox[{1081, 1229, 1230, 1211, 1228, 870, 1080, 1189, 1550, 1360, 
        1079, 1549, 1354, 1078, 1548, 1353, 1077, 1547, 1352, 1076, 1546, 
        1351, 1075, 1545, 1350, 1074, 1544, 1543, 1349, 1073, 1542, 1348, 
        1072, 1541, 1347, 1071, 1540, 1346, 1070, 1539, 1345, 1069, 1538, 
        1344, 1068, 1359, 1537, 1187, 1188}]}}},
    VertexNormals->CompressedData["
1:eJztnHdUVEcbh+loFNHY9YMkCEpRjAE1YosQ1IXFLpYoGAVjQ+oRaUZBiohE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     "]], 
   GraphicsComplex3DBox[CompressedData["
1:eJyV3H3QXGV9xvFNCFGEKlVsgQKtuoIvmAaISBkkUp2YDVZHZ+qAUQiBtops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    "], {{
      {RGBColor[0, 0, 1], Opacity[0.5], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmXfgV9Mbx++553zsEJKQJGRVUtJPGaGhkC0lKQ0kSWRklKZRSZlFhbJn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           "]], Polygon3DBox[CompressedData["
1:eJxNmnncVVMbhvdeayWKDM1zUVSGzGROISoSkVAkUiikkilUKpW5kJAGY4NI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           "]], 
          Polygon3DBox[CompressedData["
1:eJwt13f8luMaAPD3977vL5qi1KGt4TSdNNA8DQkNDeW0HC2rgYaOljSEEi0h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           "]]}],
        Lighting->Automatic]}, {}, {}, {}, {}}, {{}, {}, {}, 
      {GrayLevel[0.2], 
       Line3DBox[{251, 474, 1113, 252, 488, 280, 1222, 503, 295, 1227, 518, 
        310, 1234, 533, 325, 1243, 548, 340, 1254, 563, 1161, 355, 578, 1175, 
        370, 1269, 593, 385, 1273, 608, 400, 1279, 623, 415, 1287, 638, 430, 
        1297, 653, 445, 1309, 668, 460}], 
       Line3DBox[{253, 475, 1114, 254, 489, 1125, 281, 504, 296, 1228, 519, 
        311, 1235, 534, 326, 1244, 549, 341, 1255, 564, 1162, 356, 579, 1176, 
        371, 594, 1187, 386, 1274, 609, 401, 1280, 624, 416, 1288, 639, 431, 
        1298, 654, 446, 1310, 669, 461}], 
       Line3DBox[{255, 476, 1115, 256, 490, 1126, 282, 505, 1136, 297, 520, 
        312, 1236, 535, 327, 1245, 550, 342, 1256, 565, 1163, 357, 580, 1177, 
        372, 595, 1188, 387, 610, 1197, 402, 1281, 625, 417, 1289, 640, 432, 
        1299, 655, 447, 1311, 670, 462}], 
       Line3DBox[{257, 477, 1116, 258, 491, 1127, 283, 506, 1137, 298, 521, 
        1145, 313, 536, 328, 1246, 551, 343, 1257, 566, 1164, 358, 581, 1178, 
        373, 596, 1189, 388, 611, 1198, 403, 626, 1205, 418, 1290, 641, 433, 
        1300, 656, 448, 1312, 671, 463}], 
       Line3DBox[{259, 478, 1117, 260, 492, 1128, 284, 507, 1138, 299, 522, 
        1146, 314, 537, 1152, 329, 552, 344, 1258, 567, 1165, 359, 582, 1179, 
        374, 597, 1190, 389, 612, 1199, 404, 627, 1206, 419, 642, 1211, 434, 
        1301, 657, 449, 1313, 672, 464}], 
       Line3DBox[{261, 479, 1118, 263, 493, 1129, 285, 508, 1139, 300, 523, 
        1147, 315, 538, 1153, 330, 553, 1157, 345, 568, 1166, 360, 583, 1180, 
        375, 598, 1191, 390, 613, 1200, 405, 628, 1207, 420, 643, 1212, 435, 
        658, 1215, 450, 1314, 673, 465}], 
       Line3DBox[{265, 481, 1119, 266, 1220, 495, 287, 1224, 510, 302, 1230, 
        525, 317, 1238, 540, 332, 1248, 555, 347, 1260, 570, 1167, 362, 585, 
        377, 1271, 600, 392, 1276, 615, 407, 1283, 630, 422, 1292, 645, 437, 
        1303, 660, 452, 1316, 675, 467}], 
       Line3DBox[{267, 482, 1120, 268, 496, 1130, 288, 1225, 511, 303, 1231, 
        526, 318, 1239, 541, 333, 1249, 556, 348, 1261, 571, 1168, 363, 586, 
        1181, 378, 601, 393, 1277, 616, 408, 1284, 631, 423, 1293, 646, 438, 
        1304, 661, 453, 1317, 676, 468}], 
       Line3DBox[{269, 483, 1121, 270, 497, 1131, 289, 512, 1140, 304, 1232, 
        527, 319, 1240, 542, 334, 1250, 557, 349, 1262, 572, 1169, 364, 587, 
        1182, 379, 602, 1192, 394, 617, 409, 1285, 632, 424, 1294, 647, 439, 
        1305, 662, 454, 1318, 677, 469}], 
       Line3DBox[{271, 484, 1122, 272, 498, 1132, 290, 513, 1141, 305, 528, 
        1148, 320, 1241, 543, 335, 1251, 558, 350, 1263, 573, 1170, 365, 588, 
        1183, 380, 603, 1193, 395, 618, 1201, 410, 633, 425, 1295, 648, 440, 
        1306, 663, 455, 1319, 678, 470}], 
       Line3DBox[{273, 485, 1123, 274, 499, 1133, 291, 514, 1142, 306, 529, 
        1149, 321, 544, 1154, 336, 1252, 559, 351, 1264, 574, 1171, 366, 589, 
        1184, 381, 604, 1194, 396, 619, 1202, 411, 634, 1208, 426, 649, 441, 
        1307, 664, 456, 1320, 679, 471}], 
       Line3DBox[{275, 486, 1124, 276, 500, 1134, 292, 515, 1143, 307, 530, 
        1150, 322, 545, 1155, 337, 560, 1158, 352, 1265, 575, 1172, 367, 590, 
        1185, 382, 605, 1195, 397, 620, 1203, 412, 635, 1209, 427, 650, 1213, 
        442, 665, 457, 1321, 680, 472}], 
       Line3DBox[{277, 682, 1322, 683, 278, 501, 1135, 293, 516, 1144, 308, 
        531, 1151, 323, 546, 1156, 338, 561, 1159, 353, 576, 1173, 1174, 368, 
        591, 1186, 383, 606, 1196, 398, 621, 1204, 413, 636, 1210, 428, 651, 
        1214, 443, 666, 1216, 458, 685, 686, 687}], 
       Line3DBox[{459, 667, 684, 1308, 444, 652, 1296, 429, 637, 1286, 414, 
        622, 1278, 399, 607, 1272, 384, 592, 1268, 369, 577, 1266, 354, 1160, 
        562, 1253, 339, 547, 1242, 324, 532, 1233, 309, 517, 1226, 294, 502, 
        1221, 279, 487, 1218, 250, 473, 681, 688}], 
       Line3DBox[{466, 674, 1315, 451, 659, 1302, 436, 644, 1291, 421, 629, 
        1282, 406, 614, 1275, 391, 599, 1270, 376, 584, 1267, 361, 569, 1259, 
        346, 554, 1247, 331, 539, 1237, 316, 524, 1229, 301, 509, 1223, 286, 
        494, 1219, 264, 480, 1217, 262}]}, 
      {GrayLevel[0.2], 
       Line3DBox[{690, 1004, 473, 689, 1113, 912, 691, 1114, 913, 692, 1115, 
        914, 693, 1116, 915, 694, 1117, 916, 695, 1118, 1010, 1217, 696, 1119,
         917, 697, 1120, 918, 698, 1121, 919, 699, 1122, 920, 700, 1123, 921, 
        701, 1124, 922, 702, 1322, 1005, 923, 1006}], 
       Line3DBox[{704, 1011, 1218, 703, 488, 705, 1125, 924, 706, 1126, 925, 
        707, 1127, 926, 708, 1128, 927, 709, 1129, 1012, 1219, 710, 1013, 
        1220, 711, 1130, 928, 712, 1131, 929, 713, 1132, 930, 714, 1133, 931, 
        715, 1134, 932, 716, 1135, 933, 717}], 
       Line3DBox[{719, 1014, 1221, 718, 1015, 1222, 720, 504, 721, 1136, 934, 
        722, 1137, 935, 723, 1138, 936, 724, 1139, 1016, 1223, 725, 1017, 
        1224, 726, 1018, 1225, 727, 1140, 937, 728, 1141, 938, 729, 1142, 939,
         730, 1143, 940, 731, 1144, 941, 732}], 
       Line3DBox[{734, 1019, 1226, 733, 1020, 1227, 735, 1021, 1228, 736, 520,
         737, 1145, 942, 738, 1146, 943, 739, 1147, 1022, 1229, 740, 1023, 
        1230, 741, 1024, 1231, 742, 1025, 1232, 743, 1148, 944, 744, 1149, 
        945, 745, 1150, 946, 746, 1151, 947, 747}], 
       Line3DBox[{749, 1026, 1233, 748, 1027, 1234, 750, 1028, 1235, 751, 
        1029, 1236, 752, 536, 753, 1152, 948, 754, 1153, 1030, 1237, 755, 
        1031, 1238, 756, 1032, 1239, 757, 1033, 1240, 758, 1034, 1241, 759, 
        1154, 949, 760, 1155, 950, 761, 1156, 951, 762}], 
       Line3DBox[{764, 1035, 1242, 763, 1036, 1243, 765, 1037, 1244, 766, 
        1038, 1245, 767, 1039, 1246, 768, 552, 769, 1157, 1040, 1247, 770, 
        1041, 1248, 771, 1042, 1249, 772, 1043, 1250, 773, 1044, 1251, 774, 
        1045, 1252, 775, 1158, 952, 776, 1159, 953, 777}], 
       Line3DBox[{781, 1160, 954, 779, 1161, 955, 783, 1162, 956, 785, 1163, 
        957, 787, 1164, 958, 789, 1165, 959, 791, 1166, 569, 793, 1167, 960, 
        795, 1168, 961, 797, 1169, 962, 799, 1170, 963, 801, 1171, 964, 803, 
        1172, 965, 805, 1174, 967, 807}], 
       Line3DBox[{806, 966, 1173, 804, 1265, 1057, 802, 1264, 1056, 800, 1263,
         1055, 798, 1262, 1054, 796, 1261, 1053, 794, 1260, 1052, 792, 1259, 
        568, 790, 1258, 1051, 788, 1257, 1050, 786, 1256, 1049, 784, 1255, 
        1048, 782, 1254, 1047, 778, 1253, 1046, 780}], 
       Line3DBox[{809, 1058, 1266, 808, 1175, 968, 810, 1176, 969, 811, 1177, 
        970, 812, 1178, 971, 813, 1179, 972, 814, 1180, 1059, 1267, 815, 585, 
        816, 1181, 973, 817, 1182, 974, 818, 1183, 975, 819, 1184, 976, 820, 
        1185, 977, 821, 1186, 978, 822}], 
       Line3DBox[{824, 1060, 1268, 823, 1061, 1269, 825, 1187, 979, 826, 1188,
         980, 827, 1189, 981, 828, 1190, 982, 829, 1191, 1062, 1270, 830, 
        1063, 1271, 831, 601, 832, 1192, 983, 833, 1193, 984, 834, 1194, 985, 
        835, 1195, 986, 836, 1196, 987, 837}], 
       Line3DBox[{839, 1064, 1272, 838, 1065, 1273, 840, 1066, 1274, 841, 
        1197, 988, 842, 1198, 989, 843, 1199, 990, 844, 1200, 1067, 1275, 845,
         1068, 1276, 846, 1069, 1277, 847, 617, 848, 1201, 991, 849, 1202, 
        992, 850, 1203, 993, 851, 1204, 994, 852}], 
       Line3DBox[{854, 1070, 1278, 853, 1071, 1279, 855, 1072, 1280, 856, 
        1073, 1281, 857, 1205, 995, 858, 1206, 996, 859, 1207, 1074, 1282, 
        860, 1075, 1283, 861, 1076, 1284, 862, 1077, 1285, 863, 633, 864, 
        1208, 997, 865, 1209, 998, 866, 1210, 999, 867}], 
       Line3DBox[{869, 1078, 1286, 868, 1079, 1287, 870, 1080, 1288, 871, 
        1081, 1289, 872, 1082, 1290, 873, 1211, 1000, 874, 1212, 1083, 1291, 
        875, 1084, 1292, 876, 1085, 1293, 877, 1086, 1294, 878, 1087, 1295, 
        879, 649, 880, 1213, 1001, 881, 1214, 1002, 882}], 
       Line3DBox[{884, 1088, 1296, 883, 1089, 1297, 885, 1090, 1298, 886, 
        1091, 1299, 887, 1092, 1300, 888, 1093, 1301, 889, 1215, 1094, 1302, 
        890, 1095, 1303, 891, 1096, 1304, 892, 1097, 1305, 893, 1098, 1306, 
        894, 1099, 1307, 895, 665, 896, 1216, 1003, 897}], 
       Line3DBox[{911, 1009, 685, 910, 1321, 1111, 909, 1320, 1110, 908, 1319,
         1109, 907, 1318, 1108, 906, 1317, 1107, 905, 1316, 1106, 904, 1315, 
        1314, 1105, 903, 1313, 1104, 902, 1312, 1103, 901, 1311, 1102, 900, 
        1310, 1101, 899, 1309, 1100, 898, 1112, 1308, 1007, 1008}]}}},
    VertexNormals->CompressedData["
1:eJztyLENQFAYhdE/xCBaKyjsYAQJrRFsIm8TC3hrmIPiVUwgObf5ck87reNc
RUTXRNRPz35b9nQdUVb+wDnnnHPOOeecc84555zzr+eXZ84555xzzjnnnHPO
Oeecc84555xzzjnnnHPOOeecc84555xzzjnnnHPOOeecc84555xzzjnnnHPO
Oeecc8757/0Gn+Qh7Q==
     "]]},
  Axes->True,
  AxesLabel->{
    FormBox["x", TraditionalForm], 
    FormBox["y", TraditionalForm], 
    FormBox["z", TraditionalForm]},
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->{360.35449144030423`, 349.03310882090847`},
  ImageSizeRaw->Automatic,
  Method->{},
  PlotRange->{{0., 0.9999999285714286}, {0., 0.9999999285714286}, {0., 
   0.9999999285714286}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{1.8863026115538164`, -2.702492023889064, 0.7670719121837564},
  ViewVertical->{0.26297971960257277`, -0.29584582376102136`, 
   0.9183228820196713}]], "Output",
 CellChangeTimes->{
  3.654809549864819*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{"x", "-", "8"}], ")"}]}], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", "x"}], "-", "9"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{"x", "-", "5"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{"x", "-", "7"}], ")"}]}], "+", "30"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "3", ",", "8."}], "}"}]}], "]"}], "/", 
  "5"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", " ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", "36.25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "10"}], ",", "80"}], "}"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "8"}], "}"}], ",", 
      RowBox[{"{", "}"}]}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.653867160157799*^9, 3.653867444461918*^9}, {
  3.6538674790212507`*^9, 3.653867557516727*^9}, {3.653867743435781*^9, 
  3.653867823177671*^9}, {3.653868102115038*^9, 3.653868103292006*^9}}],

Cell[BoxData["36.25`"], "Output",
 CellChangeTimes->{
  3.6538677694252577`*^9, {3.6538678115717793`*^9, 3.653867824832552*^9}, 
   3.653868104245111*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
    1.], LineBox[CompressedData["
1:eJw9mnk4lF/cxiVZZ8ZkmRlhZiyZsWSnorjNIGSZ6aeIUkhJFCVpUVHJVlla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     "]]}, 
   {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
    1.], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQfenAS1Eg5cAAAgpODjwxR4LPLEDw3b7PmzjDkRHO
bzTSFLGbxwTni0c9e3HiMTOcf01h+7cPSqxwfsybGG61WjY433aJaZHDAXY4
/0nC4/vpcpxw/tY9S9p0yrjg/IcsM+uvbeOG8y8HJtX3CvHC+QrdcRc1w/ng
/OnJeTHJU/nh/KwFmt9DygXgfPNW05dZEoJwfvqb1XHsxxF8HeU1BUVFQnC+
3IWj2gFCwnB+8X/PrC37EfxvS54HdieKwPl3zrzf80JAFM4PP9J4RGQvgv/f
ULd0c6wYnM+t5LzyBrc4nO/SUdRWsA7BF9qnzXDdVwLOdy7z/3v4F4K/aEnP
YuU5knB+SqjJWU5vKTh/99XUyfu+Ifj2ZzYwPZsmDeeruaZ9newiA+dbm5hO
3PIMwX/6qffk4lZZOP+TcWCrpJEcIrxe675ivIzgn1IpvVTQKA/ne716Zagp
pADn/9J84MGYhODfXtW1cM4OBP/ys4N+hZyKcP7f5HW2nIkI/scT96s4tiP4
f17M5XFkV4LzLbwEH9jEIfjdaYIcResR/BVZYXV8/xH87+sDzPJCleH82A3X
ndiXIfgiC9bNY76M4J/pb/31/z+CDwBVvdAc
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{2., 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{{3, 8}, {}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None},
  PlotRange->{{2.000000163265306, 9.999999836734695}, {-10, 80}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.6538677694252577`*^9, {3.6538678115717793`*^9, 3.653867824832552*^9}, 
   3.6538681043069696`*^9}]
}, Open  ]]
},
WindowSize->{905, 669},
WindowMargins->{{48, Automatic}, {0, Automatic}},
Magnification->1.5,
FrontEndVersion->"10.2 for Mac OS X x86 (32-bit, 64-bit Kernel) (July 6, \
2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 293, 7, 43, "Input"],
Cell[876, 31, 372, 12, 69, "Output"],
Cell[1251, 45, 135, 3, 64, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1423, 53, 540, 14, 144, "Input"],
Cell[1966, 69, 70, 1, 43, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2073, 75, 316, 9, 43, "Input"],
Cell[2392, 86, 376, 12, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2805, 103, 408, 12, 43, "Input"],
Cell[3216, 117, 208, 6, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3461, 128, 698, 17, 69, "Input"],
Cell[4162, 147, 69748, 1142, 621, 32696, 533, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[73947, 1294, 917, 22, 119, "Input"],
Cell[74867, 1318, 98394, 1611, 621, 43472, 709, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[173298, 2934, 522, 14, 69, "Input"],
Cell[173823, 2950, 57207, 936, 670, 31208, 508, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[231067, 3891, 621, 16, 69, "Input"],
Cell[231691, 3909, 31699, 517, 621, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[263427, 4431, 558, 11, 69, "Input"],
Cell[263988, 4444, 107639, 1742, 623, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[371664, 6191, 267, 6, 43, "Input"],
Cell[371934, 6199, 210061, 3423, 546, 107866, 1746, "CachedBoxData", \
"BoxData", "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[582032, 9627, 1343, 41, 119, "Input"],
Cell[583378, 9670, 154, 3, 43, "Output"],
Cell[583535, 9675, 12641, 218, 358, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
