<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Parametric surfaces
[12.5] 
</title>
<meta name="week" content="">
<?php include "../../classes/2.h" ?>

<h1>
Parametric surfaces [12.5]
</h1>

<p class="show">Review <a href="/physix/213/gco/10.5.php">Parametric Surfaces [10.5]</a>...

<ul class="else">
<li>As parameters $u$ and $v$ are varied in some domain $D$,
<li>The vector
$\myv r(u,v)=\langle\,x(u,v),\,y(u,y),\,z(u,v)\rangle$
traces out a surface $S$ in 3D.


<h3>Tangent plane approximation</h3>
<p>Outline of the tangent plane approximation:<br>
<img src="0g/12.5.surfuv.jpg" class="big">
<ul><li>As $v$ varies in $D$, $\myv r$ traces the curve $C_1$.  A tangent vector to $C_1$ is
$$\myv r_v=\langle x_v, y_v, x_v \rangle=\langle \frac{\del x}{\del v},
\frac{\del y}{\del v},\frac{\del z}{\del v}
\rangle$$
<li>As $u$ varies in $D$, $\myv r$ traces the curve $C_2$.  A tangent vector to $C_2$ is
$$\myv r_u=\langle x_u, y_u, x_u \rangle$$

<li>Increasing $v$ to $v+\Delta v$ in $D$ leads to a change of $\myv r$ on the surface of <i>approximately</i> $\Delta v\, \myv r_v$.  
<li>Increasing $u$ to $u+\Delta u$ in $D$ leads to a change of $\myv r$ on the surface of <i>approximately</i> $\Delta u\, \myv r_u$.
<li><img src="0g/12.5.patch.jpg" class="rightalign">The area of the parallelogram shown is <br><br>
$|(\Delta v\,\myv r_v)\times(\Delta u\,\myv r_u)|$<br>
 &nbsp; =$|\myv r_v\times\myv r_u|\Delta A$<br>
<br>Where $\Delta u \Delta v=\Delta A$, an area in $D$.

<li>This cross product is <i>approximately</i> equal to $\Delta S$, the area of a "patch" of the surface.

</ul>
<p>In the limit $\Delta u\to du,\ \Delta v \to du$, the approximation gets more exact, and the surface area of $S$ is
$$A_S=\iint_D dS = \iint_D |\myv r_u\times \myv r_v|\,dA.$$

<h4>Surface area of a graph defined in terms of $(x,y)$</h3>
<p>For the special case of the surface $z=f(x,y)$, and $(x,y)$ in the domain $D$, we have
$$x=x;\ \ \ y=y;\  \ z=f(x,y)$$
and (see your text) the surface area can be written:
$$A_S=\iint_D\sqrt{1+\left(\frac{\del z}{\del x}\right)^2 + \left(\frac{\del z}{\del y}\right)^2
} \, dA
$$

<h3>Example</h3>
<p class="show"><img src="0g/12.5.1-x-y.jpg" class="rightalign">
Area of the surface shown of the plane:<br>
$z=1-x-y$

<p>$$\begineq
A_S&=\iint_D\sqrt{1+\left(\frac{\del z}{\del x}\right)^2 + \left(\frac{\del z}{\del y}\right)^2
} \, dA
\\
&=\iint_D\sqrt{1+\left(-1\right)^2 + \left(-1\right)^2
} \, dA
=\iint_D\sqrt{3} \, dA
\\
&=\sqrt 3 \iint_D dA=\sqrt 3 A_D=\sqrt 3 *(1*1)/2=\sqrt 3/2
\endeq
$$

<p>Check the result by using geometry to calculate the surface area...