<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Change of variables [12.9]
</title>
<meta name="nolink" content="">
<meta name="week" content="">

<?php include "../../classes/2.h" ?>

<h1>
Change of variables [12.9] - Transformations
</h1>
<p class="show"><img src="0g/12.9.mirror.jpg" class="big">

<h3>Change of variables: 1D</h3>
<p class="show">
Consider the difficult-looking integral...
$$\int_{x=0}^3 x \cos(x^2-3)\,dx.$$

<p>Do a change in variables to $u=x^2-3$.  What to do about  $dx$?:
$$\frac{du}{dx}=2x\ \ \Rightarrow \ \ du=2x\,dx.$$
<p>And now we can re-write the integral as
$$\begineq\int_{x=0}^3 x \cos(x^2-3)\,dx&=
\int_0^3 \frac 12 \cos(x^2-3)\,2x\,dx\\
&=\int_{u(0)=-3}^{u(3)=6} \frac 12 \cos(u)\,du=\frac 12\left(\sin(6)-\sin(3)\right).
\endeq$$
<p>That is, treating  $u= u(x)$ as a function of $x$...
$$\int_a^b f(u(x))u'(x)\,dx=\int_{u(a)}^{u(b)}f(u)\,du$$
<p>But we will be interested in  the situation where $x=x(u)$, so I will re-write this,  interchanging $x$ and $u$, as... 
$$
\int_{x(a)}^{x(b)}f(x)\,dx = \int_a^b f(x(u))\frac{dx}{du}\,du.$$

<p>This change of variables can be thought of as a <b>change of coordinate systems</b>.

<p>That derivative $\frac{dx}{du}$ is playing the role of a "conversion factor" for lengths when you switch between $u$- and $x$-coordinates.  

<h3>Example: Linear transformations in 2-d</h3>
<p>Let's assume that we can make a linear transformation between 2 2-d coordinate systems, $(x,y)$ and $(u,v)$:  
$$x(u)=au+bv+c$$
$$y(u)=du+ev+f$$

<p><img src="0g/12.9.example.jpg">


<p>We know how to convert an integral from Cartesian to a handful of other coordinate systems.
<br>
<img src="0g/12.7.sphericalpolardV.jpg"><br>   
for example, $\to$ spherical coordinates:
$$\iiint_E f(x,y,z)\,dx\,dy\,dz = \iiint_E f(\rho,\theta,\phi) \rho^2 \sin \phi \,d\rho\,d\theta\,d\phi.$$

<p>Our goal is to come up with a general way to convert double or triple integrals from one system $(x,y,z)$ to another system $(u,v,w)$ given only the coordinate transformation rules $x(u,v,w)$, $y(u,v,w)$, and $z(u,v,w)$.

<p>We shall see that something called the <b>Jacobian</b> plays the role of conversion factor.


<h3>General Transformations</h3>
<p class="show"><a href="12.9.ppt">Transformations</a> [Powerpoint format]

<ul class="incremental todo"><li>
<b>Transformations</b> handout.
<li><b>Change of variables</b> handout.
</ul>
<p>Putting all the derivations together, an integral in terms of $x$ and $y$  can be carried out in terms of coordinates $u$ and $v$ instead like this...
<br>
<img src="0g/12.9.Jacobian.jpg" class="big">
<h4 class="handout">Image credits</h4>
<p class="handout">
<a href="https://www.flickr.com/photos/gurana/4890691915">gurana</a>


<?php include "../../classes/3.h" ?>
