<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Line Integrals [13.2]
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
Line  Integrals
</h1>
<p class="show"><img src="0g/13.2.curvyfence.jpg" class="big">


<h3>Line integral</h3>
<p class="show">Area of the wandering, irregular fence...
<p class="show">Consider the smooth curve, $C$, in the $x$-,$y$-plane described by the vector function parameterized in terms of $t$
$$\myv r(t)=\langle x(t),y(t)\rangle.$$
<img src="0g/13.2.pathC.jpg" class="big"><br>
If the curve is chopped up into $n$ arcs...
<p class="show def incremental">The <b>line integral of $f$ along $C$</b> is:
$$\int_C f(x,y)\,ds=\lim_{n\to\infty} f(x_i^*,y_i^*)\Delta s_i.$$

<p>In  <a href="http://www.goshen.edu/physix/213/gco/10.3.php">section [10.3]--arclength</a>--we found that...
<ul><li>$\myv r'(t)=\langle x'(t),y'(t) \rangle$ is a vector tangent to the curve.  
<li>[If the parameter $t$ is time, then $\myv r'(t)$ is the <i>velocity</i> vector.]
<li>The arclength distance traversed when $t$ changes by $\Delta t$ is
$$\Delta s\approx |\myv r'|\Delta t=\sqrt{
\left(\frac{\del x}{\del t}\right)^2+\left(\frac{\del y}{\del t}\right)^2
}\Delta t$$
</ul>
<p class="show def incremental">
$$\int_Cf(x,y)\,ds = \int_{t=a}^b f(x(t),y(t)) 
\sqrt{
\left(\frac{\del x}{\del t}\right)^2+\left(\frac{\del y}{\del t}\right)^2
}
\,dt.$$

<h3>Example</h3>
<p class="show"><img src="0g/13.2.t32.jpg" class="rightalign">
$\int \frac yx\,ds$
 along the line $x=t^4$, $y=t^3$, $0\leq t \leq 1$.


<p>$$\begineq
\int_C \frac yx\,ds
&= \int_{t=0}^1 \frac {y(t)}{x(t)} 
\sqrt{
\left(\frac{\del x}{\del t}\right)^2+\left(\frac{\del y}{\del t}\right)^2
}
\,dt\\

&= \int_{t=0}^1 \frac {t^3}{t^4} 
\sqrt{
\left( 4t^3\right)^2+\left(3t^2\right)^2
}
\,dt\\

&= \int_{t=0}^1 \frac {1}{t} 
\sqrt{ 16t^6+9t^4
}
\,dt\\

&= \int_{t=0}^1 t 
\sqrt{ 16t^2+9
}
\,dt\\
\endeq
$$

<p>Substitution of variables: $u=16t^2+9$, so $du=32t\,dt$:

<p>$$\begineq
\int_C \frac yx\,ds
&= \frac{1}{32}\int_{u(0)}^{u(1)}  
\sqrt{ u
}
\,du\\

&= \frac{1}{32}\left[ \frac 23 u^{3/2}
\]_9^{25}   = \frac{1}{16*3}(125-27)=\frac{49}{24}

\endeq
$$

<h3>Example</h3>

<p class="show">$$\int_C(x+y^2)ds$$
where $C$ is the line from $(0,0)$ to $(3,0)$.
<ul>
<li>Along this line, $y=0$ so $x+y^2\to x$.
<li>$C$ is along the $x$-axis.  Let's use $x$ as our parameter.
<li>Along the $x$-axis $ds=dx$.
</ul>
<p>$$\int_C(x+y^2)ds = \int_{x=0}^3x\,dx = \frac 92.$$

<h3>Example</h3>

<p class="show"><img src="0g/13.2.halficecream.jpg" class="rightalign">
$\int (x+y)\,ds=?$
<p>This can be split into two integrals...
<p>Let's do the integral over $C_1$ in polar coordinates with the parameter $\theta$.
<ul>
<li>$x=r\cos\theta;\ \ y=r\sin\theta$
<li>Arclength 
$$\begineq ds&=\sqrt{
\left(\frac{\del\, r\cos\theta}{\del\theta}\right)^2 +
\left(\frac{\del\, r\sin\theta}{\del\theta}\right)^2 
}\,d\theta \\
&=\sqrt{
\left(-r\sin\theta \right)^2 +
\left(r\cos\theta\right)^2 
}\,d\theta \\
&=r\,d\theta
\endeq
$$
<li>$r=1$
</ul>

<p>Putting these pieces together,
$$\int_{C_1} (x+y)\,ds
=\int_{\theta=0}^{\pi/2}\left(
\cos\theta + \sin\theta 
\right)\,d\theta=2.$$

<p>Along $C_2$:  The equation of the line is $y(x)=x+1$.  Let's use $x$ as our parameter...
$$ds=\sqrt{
\left(\frac{\del x}{\del x}\right)^2+\left(\frac{\del(x+1)}{\del x}\right)^2
}dx=\sqrt 2\,dx$$
<p>$$\begineq 
\int_{C_1} (x+y)\,ds &= \int_0^1 (x+(1+x))\sqrt 2\,dx\\
&=\sqrt 2 \int_0^1 (1+2x)\,dx=\sqrt 2\left[  (x+x^2)\]_0^1=2\sqrt 2.

\endeq
$$
<h4>Which way?</h4>
<p>Does it matter which way you traverse the path?  Should it matter?
...
<p>An increment of arclength, $ds$, is always positive, so
$$\int_{-C}f(x,y)\,ds = \int_C f(x,y)\,ds$$

<h3>Line integrals - 3D</h3>
<p class="show def">
$$\begineq
\int_Cf(x,y,z)\,ds&=\int_{t=a}^bf(\myv r(t))\,dt\\
&=\int_a^bf(x(t),y(t),z(t))\sqrt{
\left(\frac{\del x}{\del t}\right)^2+\left(\frac{\del y}{\del t}\right)^2
+\left(\frac{\del z}{\del t}\right)^2
}\,dt
\endeq
$$

<h3>To Do</h3>
<ul class="else">
<li>Scalar line integrals
</ul>



<h2>Force fields and line integrals</h2>
<p class="show"><img src="0g/13.2.forcefield.jpg" class="rightalign">
Hollywood version of a force field...
<p>The more common version is the force of gravity (close to Earth's surface):
$$\myv F_g=-mg\uv k$$
or the electric force on a particle with charge $q$ in an electric field $\myv E$, which is
$$\myv F_e = q\myv E(x,y,z)$$
<p>The <b>work</b>, $\Delta W$, (units of energy)  done <b>by</b> a force, $\myv F$ <b>on</b> a particle is only non-zero if the particle moves a distance $\Delta \myv s$:
$$\Delta W = \myv F \cdot \Delta \myv s$$

<p>
In a force <i>field</i> the force acting on a particle, $\myv F=\myv F(x,y,z)$, depends on position.

<p><img src="0g/13.2.arcdiagram.jpg" class="rightalign">
A particle moves along the curve $C$ specified by $\myv r(t)$ shown.
<!-- such that $P_i=\myv r(t_i)$. When the particle moves a vector distance $P(t_i)-P(t_{i-1})=\Delta \myv s_i$,-->
The work done by the field is
$\Delta W_i=\myv F(x_i,y_i,z_i)\cdot\myv \Delta \myv s_i$, so...
$$W\approx\sum_{i=1}^n\myv F(x_i^*,y_i^*,z_i^*)
\cdot\uv T(x_i^*,y_i^*,z_i^*)\Delta s_i$$
where $\Delta s_i$ is the distance moved in interval $i$, and $\uv T$ is the unit tanget vector.
<p class="show incremental def">In the limit $n\to\infty$ the sum becomes an integral, the <b>line integral of $\myv F$ along $C$</b>:
$$W=\int_C\myv F\cdot\uv T\,ds=\int_C \myv F\cdot d\myv r = \int_{t=a}^b\myv F(t)\cdot \myv r'(t)\,dt.$$




<p class="show">Positive, zero, negative dot products<br>
<img src="0g/13.2.posneg.jpg" class="big">

<h4>Positive, negative, or zero?</h4>
<p class="show"><img src="0g/13.2.posneg2.jpg" class="rightalign">
$\int_{C_1}\myv F\cdot d\myv r\ \ $?

<p>$\int_{C_2}\myv F\cdot d\myv r\ \ $?


<h3>Example</h3>
<p class="show">Find the work done by the vector force field
$$\myv F = (y-x^2)\uv i + (z-y^2)\uv j +(x-z^2)\uv k$$

<p><img src="0g/13.2.t123.jpg" class="rightalign">
...over the oriented curve<br><br>
$\myv r(t)=t\uv i +t^2\uv j+t^3\uv k$
<br><br>
from $(0,0,0)$ to $(1,1,1)$.

<p>$$W=\int_{t=0}^1\myv F(t)\cdot \myv r'(t)\,dt.$$


<h3>Example</h3>
<p class="show">Find the work done by the vector force field
$$\myv F = x\uv i +z \uv j + y\uv k$$

<p><img src="0g/13.2.sincos.jpg" class="rightalign">
...over the oriented curve<br><br>
$\myv r(t)=\cos t \uv i +\sin t \uv +t\uv k$
<br><br>
for $0\leq t \leq \frac\pi 2$.

<p>$$W=\int_{t=0}^0\myv F(t)\cdot \myv r'(t)\,dt.$$

<h2>Line integral in differential form</h2>
<p class="show">$$\myv F(x,y,z)=P(x,y,z)\uv i +Q(x,y,z)\uv j +R(x,y,z)\uv k.$$
<p><img src="0g/13.2.lid1.jpg" class="big">
<p><img src="0g/13.2.lid2.jpg" class="big">



<h3>Example</h3>
<p class="show">$$\myv F(x,y)=x\uv i+x^2\uv j.$$

<p><img src="0g/13.2.3paths.jpg" class="rightalign">
Three paths from $(-1,0)$ to $(0,1)$.

<p><img src="0g/13.2.3paths1.jpg" class="big">
<p><img src="0g/13.2.3paths2.jpg" class="big">
<p id="corrected">Corrected 19 May:<br><img src="0g/13.2.3paths3c.jpg" class="big">
<p><img src="0g/13.2.3paths4.jpg" class="big">

<h3>To Do</h3>
<ul class="else"><li>Group work 2: Computing Vector Line Integrals
</ul>


<h4 class="handout">Image credits</h4>
<p class="handout"><a href="https://www.flickr.com/photos/85591545@N00/3906756290">Martin</a>

<?php include "../../classes/3.h" ?>


