<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Fundamental Theorem: Vector Line Integrals [13.3]
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
Fundamental Theorem: Vector Line Integrals
</h1>
<p class="show"><img src="0g/13.3.foundation.jpg" class="big"><br>
Fundament = Foundation




<h3>Path independence</h3>

<p class="show"><img src="0g/13.2.3paths.jpg" class="rightalign">
In general, the value of a line integral of a given vector function depends, not only on the endpoints, but also on <i>which</i>  path is taken.

<p>
A line integral is <b>independent of path</b> if it has the same value on ALL paths between $P_1$ and $P_2$.  For the integrals above, we found:
$$\color{blue}{\int_\text{blue}\myv F\cdot \myv r=0},$$
$$\color{red}{\int_\text{red}\myv F\cdot \myv r=-\frac 23 },$$
$$\color{green}{\int_\text{green}\myv F\cdot \myv r=0}.$$

<p>These line integrals are apparently not independent of the path.


<h3>Fundamental Theorem - single variable</h3>
<p class="show">The <b><a href="http://mathworld.wolfram.com/FundamentalTheoremsofCalculus.html">fundamental theorem of calculus</a></b> for a single variable:
$$\int_a^b \frac{df(x)}{dx}\,dx=\left.f(x)\right|^{x=b}_a=f(b)-f(a)$$
where $\frac{df(x)}{dx}$ is continuous on $[a,b]$.

<p>All the fundamental theorem<span style="font-size:150%"><b>s</b></span> that we shall see relate the <b>integral of</b> some kind of <b>derivative of a function</b> over some kind of interval to the <b>values of the function at the boundary</b> of the interval.  

<h3>Conservative fields - revisited</h3>
<p class="show">The gradient of a potential function, $\myv F(x,y,z)=\myv \grad f(x,y,z)=\langle
  \frac{\del f}{\del x}, \frac{\del f}{\del y}, \frac{\del f}{\del z}\rangle$ is a <i>conservative</i> vector field. 

<p>Integrate it??
$$\begineq \int_C\myv F\cdot d\myv r 

&= \int_C(\myv\grad f)\cdot d\myv r 
  = \int_{t=a}^b (\myv\grad f(\myv r(t))\cdot \myv r'(t)\,dt \\

&=\int_{t=a}^b \langle
  \frac{\del f}{\del x}, \frac{\del f}{\del y}, \frac{\del f}{\del z}\rangle
\cdot 
 \langle 
  \frac{dx}{dt}, \frac{dy}{dt}, \frac{dz}{dt}\rangle
  \rangle \,dt \\

&=\int_{t=a}^b \left(
  \frac{\del f}{\del x}\frac{dx}{dt}+\frac{\del f}{\del y}\frac{dy}{dt}+
   \frac{\del f}{\del z}\frac{dz}{dt}
\right)\,dt
\endeq
$$
<p>But we recognize $(...)$ as $df/dt$ expanded with the chain rule, so we 
conclude that:
$$\int_C\myv F\cdot d\myv r =\int_{t=a}^b \frac{d}{dt}f(t)\,dt=\left.f(t)\right|_a^b=f(\myv r(b))-f(\myv r(a)).$$ 


<p>This is $\Delta f$, the change in "height" of the potential function between $\myv r(b)$ and $\myv r(a)$.

<p>The integral only depends on the locations of the  points at the beginning and end of the path.
<p><i>At no point in what we just calculated did
any details of the path $C$ come into play</i>.  So apparently...
<p>The line integral of this conservative field, $\myv F$ is <b>path independent</b>.

<p>In physics, the potential function often corresponds to a <i>potential energy</i>: Gravitational, electric potentials.

<p>A potential function is like "landscape". When a body moves in a conservative field, after a <b>round trip</b>, the body will return to the same  position in the landscape, and thus it will have the same height (potential energy) as it started with.

<p>In terms of the vector function $\myv F$...<br>
<img src="0g/13.3.theorem3.jpg" class="big">
<p>A round trip--same starting and ending point--along a particular path is denoted as $\oint_C$.  So we could also write this as
$$\oint_C\myv F\cdot d\myv r = 0$$
for all round trips $C$.

<p>
<img src="0g/13.3.theorem4.jpg" class="big">


<h3 id="checkpath">Checking a few paths</h3>
<p class="show">Let our potential function be...
$$f(x,y)=xy$$
<p>Then $f_x=y$ and $f_y=x$. So the vector function
$$F=y\uv i +x\uv j$$
is conservative.
<p>So, the integral...
$$\int_C \myv F\cdot d\myv r=\int_{\myv r(a)}^{\myv r(b)}(y\,dx+x\,dy)$$
should be independent of the path $C$ taken.

<h3>&nbsp;</h3>
<p class="show">
<img src="0g/13.3.pi1.jpg" class="big">

<h3>&nbsp;</h3>
<p class="show">
<img src="0g/13.3.pi2.jpg" class="big">

<h3>&nbsp;</h3>
<p class="show">
<img src="0g/13.3.pi3.jpg" class="big">


<h3>Detecting a conservative field</h3>
<p class="show">For a continuous function, $f(x,y)$, recall that...
$$\begineq
f_{yx}&=f_{xy}\\
\frac{\partial}{\partial y}\frac{\partial f}{\partial x} 
   &=
\frac{\partial}{\partial x}\frac{\partial f}{\partial y} 
\endeq
$$

<p>Writing $\myv F=\frac{\partial f}{\partial x} \uv i + \frac{\partial f}{\partial y} \uv j=P\uv i+Q\uv j$, we see that this implies that...
$$ 
\frac{\partial}{\partial y}P
=
\frac{\partial}{\partial x}Q
$$
This is only true for conservative fields.
<!--
<p>So, the test for conservative fields should be written as

$$ 
\frac{\partial}{\partial y}P
   \stackrel{?}{=}
\frac{\partial}{\partial x}Q.
$$
-->

<h3 id="saved"><i>Saved</i> by a conservative field</h3>
<p class="show">Integrate the vector function
$$\myv F = 2xy\uv i +x^2\uv j$$
along this fearsome-looking path:<br>
<img src="0g/13.3.conex.jpg" class="big">

<p>Could this $\myv F$ be the gradient of some function $f$?  Applying our test$ 
\frac{\partial}{\partial y}P
   \stackrel{?}{=}
\frac{\partial}{\partial x}Q$...

$$
\frac{\partial}{\partial y}2xy=2x

\ \ \ 
\frac{\partial}{\partial x}x^2=2x;$$

<p>Yes -- it's conservative!
This opens up two simpler possibilities to evaluate the integral:

<ol class="incremental">
<li>Guess the potential--After a little thought
$f=x^2y$ should do the trick--and then just find the difference between the values of the potential at the end and beginning points:  

$$\int \myv F\cdot d\myv r=f(0,-1)-f(-1,0)=(0)^2(-1)-(-1)^2(0)=0.$$



<li>Even if you can't guess the potential, you could still choose some *more convenient* path connecting the beginning and end points to integrate along,
such as the straight line connecting
$(-1,0)\to (0,-1)$.

</ol>


<h3>Visually</h3>
<p class="show"><img src="0g/13.3.curly.jpg" class="rightalign">
Can you take advantage of path independence when integrating 
along one of these paths from $a$ to $b$?

<h3>To Do</h3>
<ul class="todo">
<li>Think before you compute
</ul>


<h3 id='conservative'>Summary: path independence</h3>
<p class="show">For the vector field $\myv F=P\uv i+ Q\uv j$, the following statements are all equivalent and imply each other...
<ul>
<li>Path independence 
$$\oint_{\text{all } C} \myv F=0$$

<li>The vector field is conservative.

<li>The vector field is irrotational.
$$\myv \grad \times \myv F = 0$$

<li>Cross derivatives equal
$$ 
\frac{\partial}{\partial y}P
   =
\frac{\partial}{\partial x}Q
$$

<li>The vector field is the gradient of some potential function $f$,
$$\myv F=\myv \grad f.$$
</ul>


<h3 id="recipe">Recipe to find the potential $f$ from a conservative $\myv F$</h3>
<h4 class="show">(Lab 09, #11)</h4>
<p class="show">How to find the potential, $f$, instead of just guessing?
<p>$\myv F=\myv \grad f$ implies that for any path connecting the origin with a point $(x,y)$ this integral will evaluate to
$$\int_{(0,0)}^{(x,y)} \myv F\cdot d\myv r=\int \myv \grad f\cdot d\myv r=
f(x,y)-f(0,0).$$
along *any* path. So, by integrating we'll find  $f(x,y)$ to within a constant.  But any constant can be added to $f$ and we'll still get the same $\myv F$ after taking the gradient.

<h4>Example</h4>
<p>Consider the function $\myv F(x,y)=

(\sin (x y)+x y \cos (x y))\uv i+ x^2 \cos (x y)\uv j$.  Is it conservative?
<p><img src="0g/13.3.test.jpg"><br>
Yes!

<p><img src="0g/13.3.path.jpg" class="rightalign">Integrate $\myv F$ along this path from the origin to $(x_0,y_0)$. <br><br> (We're using $x_0$ and $y_0$ instead of $x$ and $y$ so as not to mix up the arguments of the functions being integrated and the integration limits.  We'll go back and replace them at the end.)

<p><b>Along path I</b>: $y=0$ and d$\myv r = dx \uv i$ so
$$\myv F \cdot d\myv r =\left.F_x\right|^{y=0}\,dx=(\sin(x\cdot 0)+x\cdot 0 \cos(x\cdot y))dx = 0$$
So the integral is 
$$\int_I\myv F \cdot d\myv r =\int_0^{x_0}0\,dx = 0.$$

<p><b>Along path II</b>: $x=x_0$ and d$\myv r = dy \uv j$ so
$$\myv F\cdot d\myv r =\left.F_y\right|^{x=x_0}\,dy= x_0^2\cos(x_0 y) \,dy$$
So the integral is
$$\int_{II}\myv F\cdot d\myv r = \int_0^{y_0}x_0^2\cos(x_0 y) \,dy=
\left.x_0\sin(x_0y)\right|_0^{y=y_0}=x_0\sin(x_0y_0).$$
<p>Adding and substituting $x_0\to x$ and $y_0\to y$:
$$\int_I+\int_{II}=x\sin(xy)=f(x,y)-f(0,0).$$
And checking that the gradient of this function gives us our original vector function....<br>
<img src="0g/13.3.gradoff.jpg"><br>
YUP!




<h4 class="handout">Image credits</h4>
<p class="handout"><a href="https://www.flickr.com/photos/46355638@N00/4120337055">John Carrel`</a>

<?php include "../../classes/3.h" ?>

