<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Green's Theorem
[13.4]
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
Green's Theorem [13.4]
</h1>
<p class="show"><img src="0g/13.4.greenwindow.jpg" class="leftalign"><i>Window at Cambridge University honoring George Green</i><br><br>

Another <b>fundamental theorem</b> relates
<ul class="else"><li> a double integral of partial derivatives over an area to,
<li>a line integral around the border of the region.
</ul>




<h3>Line integrals and areas</h3>
<p class="show"><img src="0g/13.4.ellipse.jpg" class="leftalign"><br>
Let $A$ be the area inside the closed curve.  

<p>$$\begineq \int_C y\,dx&=\int_{x=a}^by_1(x)\,dx+\int_b^ay_2(x)\,dx\\
&=\int_{x=a}^by_1(x)\,dx\color{blue}{-}\int_a^b y_2(x)\,dx=-A\endeq
$$<br>
<img src="0g/13.green1.jpg"><br><br>


$$\begineq \int_Cx\,dy&=\int_{x=d}^cx_1(y)\,dx+\int_c^dx_2(y)\,dx\\
&=-\int_{x=c}^dx_1(y)\,dx+\int_c^dx_2(y)\,dx=A\endeq$$
<br>
<img src="0g/13.green2.jpg"><br><br>
<p>$\Rightarrow \oint_{\circlearrowleft C}  x\,dy-y\,dx =2A$
<p>No detailed knowledge of the exact path, $C$, was used in this derivation.

<p>Consider
$$\myv F=-y \uv i + x\uv j\equiv P\uv i + Q\uv j$$
We can write the integral above as
$$\oint_{\circlearrowleft C }
\myv F \cdot d\myv r = \oint_{\circlearrowleft C } P\,dx + Q\,dy=
\oint_{\circlearrowleft C }x\,dy-y\,dx =2A$$

<p>Now it just so happens that this double integral over the region $D$ bounded by $C$ gives the same result
$$\begineq 

\iint_D \left( \frac{\del Q}{\del x}-
\frac{\del P}{\del y}
\right) \,dx\,dy &=

\iint_D \left( \frac{\del x}{\del x}-
\frac{\del (-y)}{\del y}
\right) \,dx\,dy \\

&=\iint_D \left( 1+1
\right) \,dx\,dy = 2A
\endeq
$$
...also without detailed knowledge of $C$ (*).



<p>This is a special case of

<h3>Green's Theorem</h3>
<p class="show"><img src="0g/13.4.Green1.jpg" class="big">





<p><img src="0g/13.4.simpleconnected.jpg" class="big"><br>

<p><img src="0g/13.4.orientation.jpg" class="big"><br>
Positive oriention - $\circlearrowleft$ - interior points on the left as $C$ is traversed.
<p>[From this point on, I'll omit the $\circlearrowleft$.  You should assume, unless it's stated otherwise, that $\oint$ means $\oint_\circlearrowleft$.]

<h3>Application - Area</h3>

<p class="show">Apparently the area of any simple, connected region can be calculated from any of these line integrals:
$$A=
\oint x\,dy = -\oint y\,dx
=\frac 12\left(\oint x\,dy  -\oint y\,dx\right).$$


<h3>Example-Testing Green's theorem</h3>
<p class="show def">$$\oint_C(P\,dx +Q\,dy)
=\iint_D\left(\frac{\del Q}{\del x}-\frac{\del P}{\del y}\right)\,dA$$

<p>Let $P=xy$ and $Q=-y^2$. Calculate both ways:
$$\oint xy\,dx - y^2\,dy \equiv \oint P\,dx + Q\,dy.$$
<img src="0g/13.4.G1-1.jpg" class="rightalign"><br>on this path.
<h4>Calculating the line integral</h4>
<br clear="all"><ol type="I">

<li>$y=0$ and $dy=0$.
$$\int_I P\,dx= \int_{0}^1 x*0\,dx = 0$$

<li>$x=1$ and $dx=0$.
$$\int_{II} Q\,dy= \int_{0}^1 -(y^2)\,dy = -\frac 13$$


<li>$y=1$ and $dy=0$.
$$\int_{III} P\,dx= \int_{1}^0 (x*1)\,dx =-\frac 12$$

<li>$x=0$ and $dx=0$.
$$\int_{IV} Q\,dy= \int_{1}^0 -(y^2)\,dy =-\left.\frac{y^3}{3}\right|_1^0=+\frac 13 $$

</ol>

<p>$$I+II+III+IV=0-\frac 13 -\frac 12 +\frac 13=-\frac 12.$$

<h4><img src="0g/13.4.G1-2.jpg" class="rightalign">As a double integral
</h4>
<p>$\myv F=P\uv i+Q\uv j$
<p>$P=xy \Rightarrow \frac{\del P}{\del y}=x.$
<p>$Q=-y^2 \Rightarrow \frac{\del Q}{\del x}=0.$
<br clear="all">
<p>$$\begineq
\iint_D\left( \frac{\del Q}{\del x}
-\frac{\del P}{\del y}\right)dA
  &=\int_{y=0}^1\int_{x=0}^1 \left(0-x\right)\,dx\,dy\\
  
&=-\frac{1}{2}\int_{y=0}^1\,dy=-\frac 12.\\
\endeq
$$


<h3>Example</h3>
<p class="show"><img src="0g/13.4.quadshape.jpg" class="rightalign">
Compute the line integral around the boundary by converting to a double integral over the area.
<p>$P=y^3 \Rightarrow \frac{\del P}{\del y}=3y^2.$
<p>$Q=x^3+3xy^2 \Rightarrow \frac{\del Q}{\del x}=3x^2+3y^2.$
<br clear="all">
<p>Green's theorem says that the line integral around the boundary (positive sense) is equal to...
$$\begineq \oint_CP\,dx+Q\,dy &= 
\iint_D\left( \frac{\del Q}{\del x}
-\frac{\del P}{\del y}\right)dA
=\iint_D\left( 3x^2+3y^2-(3y^2)
\right)dA\\
&=\iint_D 3x^2 dA=\int_{x=0}^1\int_{y=x^2}^x 3x^2\,dy\,dx
\endeq
$$

<h3>To do</h3>

<ul class="todo">
<li>Green's Theorem problems
</ul>


<h2>Two Vector forms of Green's theorem</h2>
<p class="show">There are two implications of Green's theorem in terms of vector integrals. One involves the curl and one involves the divergence.


<h3 id="tangential">Tangential component of a vector field</h3>
<p><img src="0g/13.4.hotdog.jpg" class="rightalign">
We have already seen that the left hand side of Green's theorem is the integral of the <i>tangential</i> component of $\myv F$ around $C$, that is, with $\myv F=P\uv i + Q\uv j$,
$$\oint P\,dx+Q\,dy=\oint \myv F\cdot d\myv r = \oint \myv F\cdot \uv T\,ds$$
where 
$$\uv T=\frac{\myv r'(t)}{|\myv r'(t)|} 
= \frac{x'(t)}{|\myv r'(t)| }\uv i + \frac{y'(t)}{|\myv r'(t)| }\uv j.$$

<p>The right-hand side of the Green's theorem 
$$r.h.s. = \iint_D\left(\frac{\del Q}{\del x}-\frac{\del P}{\del y}\right)\,dA$$
can be expressed in terms of a curl:

<p>Treating $\myv F$ as a three-dimensionsal field with a $z$-component of zero...
$$\myv \grad \times \myv F=\text{det}
\begincv \uv i &\uv j&\uv k \\
\frac{\del}{\del x} & \frac{\del}{\del y} & \frac{\del}{\del z}\\
P & Q & 0
 \endcv
= \left(\frac{\del Q}{\del x}-\frac{\del P}{\del y}\right)\uv k.
$$
So, Green's theorem in terms of the curl of $\myv F$ is...

<p class="show incremental def">
$$\oint_C \myv F\cdot \uv T\,ds = \iint_D \myv \grad \times \myv F \cdot \uv k\,dA.
$$

<p>The integral of the tangential component along the boundary is called the <b>circulation</b>.

<p>In terms of fluid flow, this relates the integral of the curl of a vector field over a domain, $D$ to the circulation on the boundary.  

<p>[<b>Fundamental</b> theorem: relates a differential of a vector function to the value of the vector function on the boundary.]

<h4>Generalizing to 3-dimensions</h4>
<p class="show incremental def">
$$\oint_C \myv F\cdot \uv T\,ds = \iint_S \myv \grad \times \myv F \cdot d\myv S
$$

<ul><li>$d\myv S=\uv n\,dS$, 
<li>$\uv n$ is the local normal unit vector to a 3-dimensional surface, \
<li>$dS$ is the differential of surface <b>area</b>, and
<li>The path, $C$, is a curve in space which is the boundary of the surface $S$.
</ul>
<p>Go to <a href="13.7.php">13.7 - Stokes' theorem</a>.  
 

<h3 id="normal">Normal component of a vector field</h3>
<p class="show">The unit tangent vector was:
$$\uv T=\frac{\myv r'(t)}{|\myv r'(t)|} 
= \frac{x'(t)}{|\myv r'(t)| }\uv i + \frac{y'(t)}{|\myv r'(t)| }\uv j.$$

<p><img src="0g/13.4.hotdog.jpg" class="rightalign">
The <b>normal vector</b>, $\uv n$, will be at right angles to $\uv T$, and lies in the $x$-$y$-plane.  There are two choices.  The <i>outward</i> normal vector has components:
$$\uv n = = \frac{y'(t)}{|\myv r'(t)| }\uv i - \frac{x'(t)}{|\myv r'(t)| }\uv j.$$

<p><img src="0g/13.4.hotdog.derivation.jpg" class="big"><br>
The quantity on the right in $(...)$ is the <i>divergence</i> of $\myv F$, so...



<p class="show incremental def">
$$\oint_C \myv F\cdot \uv n\,ds = \iint_D \myv \grad \cdot \myv F \,dA.
$$

<p>The integral of the normal component over the boundary is called the <b>flux</b>

<p>In terms of an incompressible fluid, this says that the integral of the divergence (all the faucets minus the  drains) in $D$ is equal to the fluid flux (amount of fluid per second) flowing out of the region.

<h4>Generalizing to 3 dimensions</h4>
<p class="show incremental def">

$$\oiint_S\myv F\cdot d\myv S=\iiint_E \myv \grad \cdot \myv F\,dV
$$
<ul><li>The &#x222f; symbol means a surface integral over a <b>closed surface</b>.
<li>$d\myv S=\uv n\,dS$ is a vector differential which is everywhere normal to the surface $S$.
<li>$S$ is the boundary of a 3-d solid, $E$.

</ul>
<p>Go to <a href="13.8.php">13.8 - the divergence theorem</a>








<h4 class="handout">Image credits</h4>
<p class="handout"><a href="https://www.flickr.com/photos/arenamontanus/3213502484">Anders Sandberg</a>

<?php include "../../classes/3.h" ?>
