<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
The Divergence Theorem [13.8]
</title>
<meta name="week" content="">

<?php include "../../classes/2.h" ?>

<h1>
The Divergence Theorem 
</h1>

<p class="show">
<img src="0g/13.8.io.jpg"><br>
<span style="font-size: 0.6em">Io passing in front of Jupiter, <i><a href="http://apod.nasa.gov/apod/ap021207.html">NASA - Cassini mission</a></i>.</span>
<br><br>
Gravitational force on a mass $m$ at $\myv r$ due to mass $M$ at the origin:
$$\myv F_g=-G\frac{mM}{r^2}\uv r$$
Electrical force on a charge $q$ at $\myv r$ due to a charge $Q$ at the origin:
$$\myv F_e=q\myv E(\myv r)=-k\frac{qQ}{r^2}\uv r$$


These are both derivable from a potential function, $f$ that looks like:
$$f(\myv r)=C\frac 1r,$$
where $\myv F(\myv r)=-\myv \grad f(\myv r)$.
It turns out that
<p><b>Hideki Yukawa</b> generalized this potential to encompass nuclear forces as well, which pretty much have no effect beyond a range of order $10^{-15}$m
$$f(\myv r)=C\frac{e^{-r/r_0}}{r}$$
where $r_0$ is the "range" of the force and $r_0\propto 1/m_b$. Each field has a <i>boson</i> which is the particle that "mediates" the field.  
<ul><li>For electromagnetism, the particle is the photon, which is massless.
<li>For the gravitational field, the particle would be the graviton....
<li>For nuclear forces, Yukawa was proposing massive mesons.
</ul>


<p>It turns out that if you know the electric field, $\myv E$, you can find the charge density from:
$$\myv \grad\cdot\myv E=\rho(\myv r)/\epsilon_0.$$.





<h3>Green's Theorem: flux integral</h3>
<p class="show">Recapping <a href="13.4.php#normal">Green's Theorem in terms of the normal component</a> of a vector field $F$ in the $xy$ plane:<br>
<img src="0g/13.4.hotdog.jpg"><br>
We found that
<p class="show incremental def">
$$\oint_C \myv F\cdot \uv n\,ds = \iint_D \myv \grad \cdot \myv F \,dA.
$$
<ul><li>The l.h.s. is the flux of $\myv F$ through the boundary
<li>$\myv \grad\cdot \myv F \equiv \left( \frac{\del P}{\del x}+\frac{\del Q}{\del y}
\right)$ is the divergence of the vector function, $\myv F(x,y)$ in 2 dimensions.
</ul>
<h4>The Divergence Theorem</h4>
<p>...is a generalization of that 2-d result to 3 dimensions:<br><br>
<img src="0g/13.6.divergence.jpg" class="centeralign"><br>Or,
<p class="show incremental def">
$$\oiint_S\myv F\cdot d\myv S=\iiint_E \myv \grad \cdot \myv F\,dV
$$
<ul><li>The &#x222f; symbol means a surface integral over a <b>closed surface</b>.
<li>$d\myv S=\uv n\,dS$ is a vector differential which is everywhere normal to the surface.
<li>The divergence at a point is something like the local 'flux density'.
</ul>
<p>Paraphrase: The volume integral of the <i>flux density</i> over a solid region is equal to the total <i>flux</i> through the surface bounding that region.

<h3>Example</h3>
<p class="show"><img src="0g/13.6.triangle.jpg" class="rightalign">
Calculate the total flux, $\oiint_S \myv F\cdot \uv n \,dS$  through *all* the surfaces enclosing  the volume bounded by
 the triangle (which intersects each axis 9 units from the origin), and the planes $x=0$, $y=0$, $z=0$, where the vector field is:

$$\myv F(x,y,z)=(x+y^2)\uv i+(y+z^2)\uv j+(z+x^2)\uv k=P\uv i+Q\uv j+R\uv k.$$


<p>There are 4 surfaces.  
<p>Let's start with the toughest looking, triangular face.  We'd like calculate the flux through the surface<br><br>
$\iint_S \myv F\cdot \uv n \,dS$<br><br>
where $S$ is the surface with vertices $(9,0,0)$, $(0,9,0)$, $(0,0,9)$,


<p>I'll use this form of the surface integral:
$$\iint_S f(x,y,z)\,dS=
\iint_D f(x,y,g(x,y))\sqrt{1 +
\left(\frac{\del g}{\del x}\right)^2
+\left(\frac{\del g}{\del y}\right)^2
}\,dx\,dy.$$

<p>The equation of the plane containing the triangle is..
$$x+y+z=9 \Rightarrow z=g(x,y)=9-x-y$$
<ul><li>$g_x=g_y=-1$ so the square root factor is $\sqrt{3}$
<li> the limits of integration are
$$\iint_D=\int_{x=0}^9\int_{y=0}^{9-x}$$
</ul>

<p>The function $f(x,y,z)=f(x,y,g(x,y))$ in the integral is
$\myv F\cdot\uv n$.
<ul><li>The unit normal vector to the plane is $\uv n=\frac{1}{\sqrt 3}\langle 1,1,1\rangle$, 
<li>so 
$$\myv F\cdot \uv n = \frac{1}{\sqrt 3} \left(x+y^2+y+z^2+z+x^2\right)$$
<li>substituting in $z=9-x-y$ on the triangular surface, Mathematica expands this to...
$$\myv F\cdot\uv n = \frac{1}{\sqrt 3}(90 - 18 x + 2 x^2 - 18 y + 2 x y + 2 y^2)$$
</ul>
<p>Putting this all together...
$$\begineq \iint_D\myv F\cdot \uv n dS
&=
\frac{1}{\sqrt 3}\int_{x=0}^9\int_{y=0}^{9-x}(90 - 18 x + 2 x^2 - 18 y + 2 x y + 2 y^2)\,dy\,dx\\
&=\frac{8019}{4\sqrt 3}\endeq$$
$$

<p>Oh no, I've still got 3 more surfaces to integrate over!!
<h3>Example, v 2.0</h3>
<p class="show"><img src="0g/13.6.triangle.jpg" class="rightalign">
Calculate the total flux, $\oiint_S \myv F\cdot \uv n \,dS$  through *all* the surfaces enclosing  the volume bounded by
 the triangle (which intersects each axis 9 units from the origin), and the planes $x=0$, $y=0$, $z=0$, where the vector field is:

$$\myv F(x,y,z)=(x+y^2)\uv i+(y+z^2)\uv j+(z+x^2)\uv k=P\uv i+Q\uv j+R\uv k.$$
<p>Using the divergence theorem, we could write the desired integral as...
$$\oiint_S
\myv F \cdot \uv n\, dS = \iiint_E \myv \grad \cdot \myv F \,dV.$$
<p>The divergence is
$$\myv \grad \cdot \myv F =\frac{\del P}{\del x}+\frac{\del Q}{\del y}
+\frac{\del R}{\del z}= 1+1+1=3.$$
<p>So, 
$$\iiint_E \myv \grad \cdot \myv F\, dV=3\iiint_E\,dV=3*(9*9/2)(9)/3=729/2.$$

<!--
<h3>The mystical function $\uv r/r^2$</h3>

<p class="show">In that exercise on <a href="../handouts/13.6.php">the flux of a vector field [13.6]</a> we worked with that function:
$$\myv F(x,y,z)=\frac{1}{(x^2+y^2+z^2)^{3/2}}\left(x\uv i+y\uv j+z\uv k\right)
=\frac{\myv r}{r^3}=\frac{1}{r^2}\uv r.$$
<p>In classical field theory,  the electric field, $\myv E(r,\theta,\phi)$ due to a single charge $q$ at the origin is
$$\myv E=\frac{q}{4\pi\epsilon_0r^2}\uv r.$$
<p>You calculated the flux integral over the (closed) surface of a sphere...
$$\oiint_S\myv F \cdot \uv n \,dS=4\pi.$$


<p>According to the divergence theorem,
$$\oiint_S\myv F \cdot \uv n\, dS=4\pi=\iiint_V \myv \grad \cdot \myv F\,dV$$
<p>This was for a sphere of radius $R$, but the answer is independent of the radius.  How can we make the volume larger but not increase *or* decrease the volume integral?? What does that imply about the divergence of $\myv F$?

<p>Calculate the divergence of $\myv F$:
$$\myv \grad \cdot\myv F=
\left( \uv i\frac{\del}{\del x}+\uv j\frac{\del}{\del y}+\uv k\frac{\del}{\del z}
\right)\cdot \frac{1}{(x^2+y^2+z^2)^{3/2}}\left(x\uv i+y\uv j+z\uv k\right) 
$$

Calculate one piece...
$$\begineq
\frac{\del}{\del x}\frac{x}{(x^2+y^2+z^2)^{3/2}}
&= \frac{\del}{\del x}x(x^2+y^2+z^2)^{-3/2}\\
&=(x^2+y^2+z^2)^{-3/2}+x(-3/2)(x^2+y^2+z^2)^{-5/2}(2x)\\
&=(x^2+y^2+z^2)^1
(x^2+y^2+z^2)^{-5/2}-3x^2(x^2+y^2+z^2)^{-5/2}\\
&=\frac{-2x^2+y^2+z^2}{(x^2+y^2+z^2)^{-5/2}}
\endeq
$$

<p>When you calculate all three pieces...
$$\begineq \myv\grad\cdot \myv F&=
\frac{1}{R^5}\left[\right.&(-2x^2+y^2+z^2)+\\
&&&(x^2-2y^2+z^2)+\\
&&&(x^2+y^2-2z^2)\left.\right]=0.\endeq$$


<p>...Everywhere that the function is defined, at least.  

<p>So, why does the surface integral come out to $4\pi$ instead of 0???

<p>It is <b>"as if"</b> $\myv \grad \cdot \myv F(0,0,0)=4\pi$.  All the "flux" in the volume is "spewing out" from that infinitesimal point, precisely where the function itself is undefined!
-->


<p class="todo">
Check the divergence theorem for our function and box of 13.4.

<!--
<h3>Example</h3>
<p class="show"> &nbsp; &#x222f;${}_S \myv F \cdot \uv n dS = \iiint_E \myv \grad \cdot \myv F dV.$
<p class="show"><img src="0g/13.6.lilbox.jpg" class="rightalign">
For some function $\myv F=P\uv x+Q\uv y+R\uv j$...
<br><br>[Normal vectors?]
-->

<?php include "../../classes/3.h" ?>