<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
3-D coordinate systems [9.1] 
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>


<h1>3-dimensional coordinate systems [9.1]</h1>
<p class="show">Locating objects in 3-dimensions.<br>
<img src="0g/9.1.balloons.jpg" class="big">

<h3>Rectangular coordinates</h3>
<p class='show center'><img src="0g/9.1.rectanglesystem.jpg">
<p class="show">Also known as <b><a href="http://mathworld.wolfram.com/CartesianCoordinates.html">Cartesian</a></b> coordinates, after Renes Descartes
</p>

<h3>Right-handed coordinate system</h3>
<p class='show center'><img src="0g/9.1.rh.jpg">
<ol>
<li>Take your <b>right</b> hand...
<li>Point your <b>straight fingers</b> in the $\hat x$ direction.
<li>Rotate your hand so that you can <b>curl your fingers</b>* 
to point in the $\hat y$ direction.
<li>Your <b>thumb</b> now points in the $\hat z$ direction.
</ol> 
<p class="show">* You need to be able to curl your fingers through an angle less than $180^o$.

<p class="justme">Try x and y, then x and z and y and z, and figure out which way the other axis points.</p>


<h3>To Do</h3>
<ul>
<li>Create a set of coordinate axes [pipecleaners]
<li>Do the <i>Visualizing the xyz coordinate system</i> worksheet:<br>
<b>Write down</b> which color is your $x$-axis, your $y$-axis, and your $z$-axis. 
</ul>

<h3>Coordinate planes</h3>
<p class='show center'><img src="0g/9.1.planes.jpg">

<h3>Coordinates</h3>
<p class='show center'><img src="0g/9.1.coordinates.jpg">

<h3>Projections</h3>
<p class='show center'><img src="0g/9.1.projections.jpg">
<p class='show'>$S$ is the projection of $P$ onto the $xz$ plane.
<p>$(0,b,0)$ is the projection of $P$ onto the $y$-axis.




<h3>The space $\mathbb{R}^3$</h3>
<p class='show'>$\mathbb{R}\equiv$ the real numbers.

<ul>

<li>Cartesian Product:<br>
$\mathbb{R}^3\equiv \mathbb{R}\times\mathbb{R}\times\mathbb{R}=\{(x,y,z) | x,y,z\in \mathbb{R}\}$.
<li>Set of all <i>ordered</i> triples.
</ul>


<h3>To Do</h3>
<ul>
<li>
<i>Points in the xyz coordinate system</i> worksheet
</ul>

<h3>Surfaces in $\mathbb{R}^3$</h3>
<p class='show center'><img src="0g/9.1.surf1.jpg"><br>
All points with coordinates $(a,b,c)$ where $c=3$ <br>
[and $a$ and $b$ can be anything]

<p class='show center incremental'><img src="0g/9.1.surf2.jpg"><br>

<p class='show center incremental'><img src="0g/9.1.surf3.jpg"><br>
All points with coordinates $(a,b,c)$ where $a=b$.
<p>Anything a bit deceptive about this picture?</p>
<p class="justme">Should continue to values with x and y less than 0...</p>




<h3  class="justme">To Do</h3>
<ul  class="justme">
<li>Section 9.1 Group Work: Fun with Visualization [missing]
<li>Working with surfaces in 3D space  [missing]
</ul>




<h3>Distance</h3>
<p class="show">What is the distance $|P_1P_2|$ between two points $P_1(x_1,y_1,z_1)$ and $P_2(x_2,y_2,z_2)$ in three dimensional space?

<p>With $\Delta x=x_2-x_1$, etc, you can imagine applying Pythagoras' theorem twice:
<script type="text/javascript" src="http://www.wolfram.com/cdf-player/plugin/v2.1/cdfplugin.js"></script>
<script type="text/javascript">
var cdf = new cdfplugin();
cdf.setDefaultContent('<a href="http://www.wolfram.com/cdf-player/"><img  src="http://www.goshen.edu/physix/213/gco/9.1.distance.png"></a>');
cdf.embed('http://www.goshen.edu/physix/213/gco/9.1.distance.cdf', 632, 618);
</script>

<ul class="else">
<li>The <span style="color:blue">blue line</span> is the hypotenuse of the triangle with legs $\Delta x$ and $\Delta y$:  It's length is $\sqrt{(\Delta x)^2+(\Delta y)^2}$.
<li>The <span style="color:green">green line</span> is our <b>distance</b>, and is the hypotenuse of the right triangle with legs of $\Delta z$ and the <span style="color:blue">blue line</span>.
</ul>
<p>So, our distance formula is:
$$|P_1P_2|=\sqrt{(x_2-x_1)^2+(y_2-y_1)^2+(z_2-z_1)^2}.$$


<h4>Equation of a sphere</h4>
<p>All the points on a <b>sphere</b> are the same distance, $r$, away from its center, $C(h,k,l)$. Using the distance formula:

$$(x-h)^2+(y-k)^2+(z-l)^2 = r^2.$$

<h3>Vectors in 2 dimensions</h3>
<img src="0g/9.1.vector2d.jpg">
<ul>
<li>Initial point (tail)
<li>Terminal point (head)
<li>Components
</ul>

<h3>more vector terms</h3>

<ul>
<li><img src="0g/9.1.parallel.jpg" class="rightalign">Points
<li>Components
<li>Parallel
<li>Standard position
<li>Length / magnitude / "measure" / "norm"
</ul>

<h3>To Do</h3>
<ul><li><i>Vectors in the plane</i> worksheet
</ul>





<h4>Image credits</h4>
<p class="handout"><a href="http://www.flickr.com/photos/71651012@N00/3758383978">Mortimer</a>
<?php include "../../classes/3.h" ?>
