<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Cross product [9.4]
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<style type="text/css">
<!--
.style1 {color: #FF0000}
.style2 {color: #0000FF}
-->
</style>
<?php include "../../classes/2.h" ?>

<h2>Cross product [9.4]</h2>



<p class="show"><img src="0g/9.4.tighten.jpg" class="big">
<h3>Torque</h3>
<p class="show">The torque, $\tau$, necessary to tighten a bolt is related to:<br>
<img class="rightalign" src="0g/9.4.wrench.jpg">
<ul>
<li>The force, $F$, exerted on the wrench,
<li>the distance, $r$, from the axis of the bolt to the point where the force is applied, and
<li>the relative orientation of $\myv F$ and $\myv r$.
</ul>
<p><b>Meaning of the direction of $\myv \tau$?</b> $\myv \tau$ is parallel to the axis of the bolt.  $\myv \tau$ points in the direction that a standard, right-handed thread bolt would advance when tightened.

<p><img src="0g/9.4.wrenchdiagram.jpg" class="rightalign">Which component of the force--parallel or perpendicular to $\myv r$--is more effective at tightening bolts?

<p>We conclude that $$\tau = rF\sin\theta
\nonumber$$ to motivate the...  

<h4 class="show
incremental">Definition of the cross product</h4> <p class="show
incremental">If $\myv a$ and $\myv b$ are non-zero 3-d vectors, then
the cross product $\myv a \times \myv b$ is: $$\myv a \times \myv b
\equiv |\myv a| |\myv b| \sin \theta \uv n,$$ where $\theta$ is the
smaller angle between $\myv a$ and $\myv b$ ($0\leq\theta\leq \pi$)
and $\uv n$ is a unit vector perpendicular to $\myv a$ and $\myv b$
according to the right-hand rule: Curl r.h. fingers from $\myv a$
towards $\myv b$ and your thumb points in the same direction as $\uv
n$.  

<h3>Cross product: order</h3>

<p class="show"><img src="0g/9.4.rhr.jpg" class="rightalign">
With the right-hand rule, the <b>order</b> of the vectors in the cross product <b>matters</b>.

<h3>Properties</h3>

 <p
class="show"><img src="0g/9.4.properties.jpg" class="big"> 

<h3>Geometry</h3>
<p class="show"
align='center'><img src="0g/9.4.parallelogram.jpg"> 
<p class="show">The length of the cross product, $|\myv a \times \myv b|$, is the area of the parallelogram determined by $\myv a$ and $\myv b$.

<h3>Computing the cross product</h3>
<p class="show">Grinding out the cross product from its components...
<p class="show"
align='center'><img src="0g/9.4.compute.jpg" class="big"> 

<h3>Cross product: determinant method</h3>

<p class="show">I remember how to compute the cross product by using the determinant of this 3$\times$3 matrix:
$$\myv a \times \myv b = \text{det}\left| \begin{array}{ccc}
\uv i & \uv j & \uv k \\
a_1 & a_2 & a_3 \\
b_1 & b_2 & b_3 
\end{array}\right|.$$


<p>To compute the determinant,
<span class="style1">add the red products</span>,
  and <span class="style2">subtract
  the blue products</span><br>
<img src="0g/9.4.colordet.jpg" class="big"><br>
$$\myv a \times \myv b=(a_2b_3-a_3b_2)\uv i + (a_3b_1-a_1b_3)\uv j+(a_1b_2-a_2b_1)\uv k.\nonumber$$
</p>

<p>For example: $\myv a=\langle 1,-2,-4 \rangle$ and
$\myv b=\langle 2,4,8\rangle$
$$\begineq \myv a \times \myv b &= \det\left|
\begin{array}{ccc}
  \uv i&\uv j&\uv k \\
  1 & -2 & -4 \\
  2 & 4 & 8
\end{array}
\right|\\
&=\\
&=\\
&= (-2*8 -(-4*4))\uv i+
    (-4*2-(1*8))\uv j+
    (1*4-(-2*2))\uv k\\
&= -16\uv j +8\uv k=\langle 0, -16,8\rangle.\nonumber
\endeq
$$

<h3>Triple products</h3>
<p class="show">There are many ways to form triple products.  Of these, which  are vector or scalar quantities?
<ol>
<li>$\myv a \cdot (\myv b \cdot \myv c)$
<li>$\myv a \cdot (\myv b \times \myv c)$
<li>$\myv a \times (\myv b \cdot \myv c)$
<li>$\myv a \times (\myv b \times \myv c)$
</ol>



<h3>Scalar triple product</h3>
<p class="show"
align='center'><img src="0g/9.4.parallelipid.jpg"> 
<p class="show">The volume of the parallelipid determined by $\myv a$, $\myv b$, and $\myv c$ is:
$$V=|\myv a \cdot (\myv b \times \myv c)|.$$
<p>[Without proof] This may be calculated from:
$$\myv a \cdot (\myv b \times \myv c) = \text{det}\left|
\begin{array}{ccc}
a_1&a_2&a_3\\
b_1&b_2&b_3\\
c_1&c_2&c_3
\end{array}
\right|$$


<h3>Vector triple product</h3>

<p class="show">$$\myv a \times (\myv b \times \myv c)
=(\myv a \cdot \myv c)\myv b -(\myv a \cdot \myv b)\myv c.$$



<h3>To do</h3>
<ul>
<li>Play around with the <a href="http://www.goshen.edu/physix/213/handouts/Class02/CrossProductOfVectorsInTheYZPlane.nb">Cross product demo</a> [Right-click and download this <i>Mathematica</i> notebook.]
<li>Dot and Cross Product
</ul>


<?php include "../../classes/3.h" ?>