<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Cylindrical and Spherical Coordinates [9.7]
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>


<h1>Cylindrical and Spherical Coordinates [9.7]</h1>
<img src="0g/9.7.wholeworld.jpg">

<h3>Polar coordinates (2-d)</h3>
<p class="show"><img src="0g/9.7.polar.jpg">
<p>$(x,y)\to (r,\theta)$:
$$r^2=x^2+y^2;\ \ \ \tan \theta = \frac yx.$$
<p>$(r,\theta)\to(x,y)$:
$$x=r\cos\theta;\ \ \ y=r\sin\theta.$$


<h3>Cylindrical coordinates (3-d)</h3>
<p class="show"><img src="0g/9.7.cylindrical.jpg" class="rightalign">
Polar coordinates in the $x-y-$plane, plus $z$ which is the same in cylindrical and Cartesian coordinates.

<ul><a href="09.7.cylindrical.nb">Cylindrical Coordinates</a> (*.nb)<br>
<span style="size: 70%">"<a href="http://demonstrations.wolfram.com/CylindricalCoordinates">Cylindrical Coordinates</a>" from the Wolfram Demonstrations Project,Contributed by: Jeff Bryant</span>
</ul>


<h3>For example</h3>
<p class="show"><img src="0g/9.7.ex1.jpg" class="rightalign">
$(r,\theta,z)=(2,\frac{2\pi}{3},1)$:
<ul><li>$x=r\cos\theta = 2 (-\frac 12)=-1$
<li>$y=r\sin\theta=2 (\frac{\sqrt{3}}{2})=\sqrt 3$
<li>$z=z=1$
</ul>

<p>[If an angle measure doesn't explicitly have the degree mark, ${}^o$, it's in radians.]
<h3>Some surfaces</h3>
<p class="show">...specified in cylindrical coordinates
<p>$$r=c\nonumber$$<br>
<img src="0g/9.7.cylinder.jpg">

<p>$$r=z\nonumber$$
<img src="0g/9.7.cone.jpg">


<h3>Spherical coordinates (3-d)</h3>
<p class="show"><img src="0g/9.7.spherical.jpg">
<ul>
  <li>$\rho$ - "rho" - <tt>[esc] r [esc]</tt> - radial distance
  <li>$\theta$ - "theta" - <tt>[esc] q [esc]</tt> - azimuthal angle 
  <li>$\phi$ - "phi" - <tt>[esc] f [esc]</tt> - polar angle
</ul>

<p>This is the convention used by publishers of calculus textbooks, and Wolfram's own <i>MathWorld</i> website.]

<ul><li><a href="http://mathinsight.org/spherical_coordinates">Animation</a> at mathinsight.org
</ul>

<p>However, physicists, engineers, <i>Mathematica</i>, <i>MatLab</i>, and even applied mathematicians use a different convention, where $\theta$ is the polar angle and $\phi$ is the azimuthal angle.
<p> :-<



<ul>
<a href="09.7.spherical.nb">Spherical Coordinates</a> (*.nb)<br>
<span style="size: 70%">"<a href="http://demonstrations.wolfram.com/SphericalCoordinates">Spherical Coordinates</a>" from the Wolfram Demonstrations Project,Contributed by: Jeff Bryant</span>
</ul>

<h4>$(\rho,\theta,\phi)\to(x,y,z)$</h4>
<p class="show"><img src="0g/9.7.spcalculate.jpg"><br>
Use $r\equiv$ projection of $\rho$ into $x-y-$plane=$\rho\sin\phi$:
<ul>
  <li>$x=r\cos\theta = \rho \sin\phi \cos\theta.$
  <li>$y=r\sin\theta = \rho \sin\phi \sin\theta.$
  <li>$z=\rho \cos \phi.$
</ul>


<h4>$(x,y,z)\to(\rho,\theta,\phi)$</h4>

<ul>
  <li>$\rho^2 = x^2+y^2+z^2.$
  <li>$\tan\theta = \frac yx.$
  <li>$\cos\phi =\frac z\rho.$
</ul>
<p class="justme">Discuss limits of angles phi and theta.
<h4>Example</h4>
<p class="show"><img src="0g/9.7.spexample.jpg">
<br>
$(\rho,\theta,\phi)=(2,\pi/4,\pi/3) \to (x,y,z)$?

<ul>
<li>$z=\rho \cos \frac{\pi}{3} = 1$
<li>$r=\rho \sin \frac{\pi}{3} = \sqrt 3$
<li>$x=r \cos \frac{\pi}{4}=\sqrt{3/2}\approx 1.22$
<li>$y=r \sin \frac{\pi}{4}\approx 1.22$
</ul>
<h3>Surfaces in spherical coordinates</h3>

<p class="show">$$\rho=c$$
<img src="0g/9.7.globe.jpg">

<p>
$$\theta=c$$
<img src="0g/9.7.sptheta.jpg">

<p>
$$\phi=c$$
<img src="0g/9.7.spcone.jpg">


<h3>To do</h3>
<ul class="else">
<li><img src="0g/9.7.goblet.jpg" class="rightalign"><b>Describe me</b>:<br><br>
Come up with an expression (in cylindrical coordinates) to approximately describe the surface of a goblet. (Further detail about how to "hand in" this assignment in the "Space Curves and Surfaces" notebook file for today.)


<li>Mathematica: Coordinates - worksheet (See <a href="../handouts/Class04/">Class 4 Resources</a> for the notebook file.)


</ul>

<br clear="all">
<h4 class="handout">Image credits</h4>
<p class="handout"><a href="http://www.flickr.com/photos/beth19/4923647610">Bethan Phillips</a>
<?php include "../../classes/3.h" ?>