<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Gradient Fields [6.B]
</title>
<meta name="week" content="12">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
Gradient fields / Conservative fields
</h1>
<p class="show">See <a href="https://openstax.org/books/calculus-volume-3/pages/6-3-conservative-vector-fields">Strang, section 6.3</a>
<p class="show">*Some* vector fields, $\myv F$, represent the gradient of a function, $\myv F=\myv \grad f$.
<p class="show">In the next few class sessions we'll be trying to figure out:
<ul class='else'>
<li>How to tell if a vector field, $\myv F(x,y)$, is the gradient of a function,
<li>How to find a function $f$, such that $\myv \grad f=\myv F$.
<li>How this makes some line integrals *a lot* easier to evaluate.
<li><i><b style="color:green;">Line integrals?!?</b></i>  Oh yeah, we haven't talked about those yet!  We'll also find out what a <i>line integral</i> is, and how to calculate it.
</ul>



<h3>Gradients</h3>

<p class="show">
The gradient of a scalar field is a vector field.


$$
\myv \grad f(x,y)=f_x(x,y)\uv i+f_y(x,y)\uv j=\myv v(x,y)$$

<p class="show">$$\myv \grad f(x,y,z)=f_x(x,y,z)\uv i+f_y(x,y,z)\uv j+f_z(x,y,z)\uv k=\myv v(x,y,z)$$


<h2>Gradient Fields</h2>

<p class="show">Some (but not all) vector fields are <b>gradient fields</b>.


Consider $f(x,y)=x^2+xy+y^2$.  The gradient is
$$\myv \grad f=\langle f_x,f_y \rangle = (2x+y)\uv i+ (2y+x)\uv j.$$

<p>The contour plot of $f(x,y)$ is shown below.  Based on the contour plot what can you say about the vector field $\myv v(x,y) = \myv \grad f$ (which is *not* shown below)?
<ul class="todo"><li>The direction of the vectors?
<li>Where are the vectors longer or shorter?
</ul>
<img src="0g/LMish.jpg">




<!--
<h3>Velocity fields</h3>
<p class="show">A velocity field could represent fluid flow at points in space.
$$\myv v(x,y)=\langle v_x(x,y), v_y(x,y)\langle.$$
Follow the arrows to see where a small particle place in the flow would go:

<p>You can find the distance travelled:
$\Delta \myv r=\langle r_x,r_y\rangle=\langle\int_{t_0}^tv_x\,dt, \int_{t_0}^tv_y\,dt\rangle 
-->


<div class="justme">
<h3>Grad / Contour example</h3>
<p class="show"><img src="0g/13.1.f49.jpg">



<h3>Grad / Contour example</h3>
<p class="show"><img src="0g/13.1.gradcont2label.jpg">
<p><img src="0g/13.1.gradcont2.jpg">

<h3>Grad / Contour example</h3>
<p class="show"><img src="0g/13.1.cxy.jpg">
</div>

<!--
<h3>In Mathematica</h3>
<p class="show">Plotting contours and gradient vector fields together...
$$f(x,y)=\frac{x^2}{4}+\frac{y^2}{9}$$
Contours for $f=1,2,9$.<br>
<img src="0g/13.1.MticaConGrad.jpg">

<h4> You'll try a couple of these in the lab...</h4>
<ul class="else">
<li>$f(x,y)=xy-2x$
<li>$f(x,y)=\sin(x)+\sin(y)$
<li>$f(x,y)=\sin(x+y)$

</ul>




<h3>In Mathematica</h3>
<p class="show">
Here's how to plot the gradient field on top of a contour plot:
<br>
<img src="0g/13.1.grad.jpg">


<p class="justme todo">
Try the confounding one
$$ f(x,y)=\frac{y}{x+y} $$
with not too many contours.
-->

<h2>Conservative fields &amp; potential functions</h2>
<p class="show">Consider the vector field...
$$\myv F(x,y)=2x\uv i+y\uv j$$

<p class="todo">Can you guess a function $f(x,y)$ such that 
$$\myv F(x,y) = \myv \grad f(x,y)?$$

In other words, what single function, $f(x,y)$ has partial derivatives $f_x=2x$ and $f_y=y$?

<div class="show def incremental">
<p>If a function $f$ exists such that $\myv F(x,y)=\myv \grad f(x,y)$:
<ul>
<li>$\myv F(x,y)$ is a <b>conservative vector field</b>. 
<li>$f(x,y)$  is called a <b>potential function</b> for the vector field $\myv F$.
</ul>
</div>

<h4>Another one</h4>
<p class="show">Consider the vector field...
$$\myv F(x,y)=-y\uv i+2x\uv j$$

<p class="todo">Can you guess a function $f(x,y)$ such that 
$$\myv F(x,y) = \myv \grad f(x,y)?$$

In other words, what function, $f(x,y)$ has partial derivatives $f_x=-y$ and $f_y=2x$?

<h3>Conservative vector fields and Clairaut</h3>
<p>At this point, we typically  start writing the components of *any* 2-d vector field as
$$\myv F(x,y)=P(x,y)\uv i+Q(x,y)\uv j.$$

<p><b>If $\myv F$ is a conservative vector field</b> then there exists a (scalar) potential function $f$, such that:
$$\begineq \myv F=\myv \grad f&=f_x\uv i +f_y\uv j\\
&\equiv P\uv i+Q\uv j
\endeq$$

<p>According to Clairaut's theorem, for any continuous function on a closed domain, $f_{xy}=f_{yx}\Rightarrow P_y=Q_x$.  So in terms of $P$ and $Q$, we have this way of detecting conservative functions:
<p class="show def incremental">
<b>Cross-derivative test</b>
Consider a function $\myv F(x,y)=P(x,y)\uv i+Q(x,y)\uv j$.  The vector field $\myv F$ is conservative if
$$\frac{\del P(x,y)}{\del y} = \frac{\del Q(x,y)}{\del x}.$$

<div class="todo">
Apply the cross-derivative test to:
<ul>
<li>$\myv F=\myc{2x,-y}$,
<li>$\myv G=\myc{-y,2x}$
</ul>
</div>

<p>In Thermodynamics you'll use some implications of this idea to distinguish between functions (rather than vector fields) which are <i>potential</i> functions and those which are not.  We'll find that energy and entropy are "potential functions".  But work and heat are *not*.
<h3>Notes for homework</h3>
<ol><li>
The position vector of a point is defined to be $\myv r(x,y)=\myc{ x, y }$.  At any point in space it is pointing away from the origin--it is a <i>radial</i> vector.
<li>The unit radial vector--$\uv r$ or $\hat{e}_r$--is the same as the unit position vector:
$$\uv r=\frac{\myv r}{|\myv r|}=\frac{x\uv i}{\sqrt{x^2+y^2}}
+\frac{y\uv j}{\sqrt{x^2+y^2}}$$
</ol>



<?php include "../../classes/3.h" ?>