<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Fundamental Theorem: Conservative Vector Fields [6.F]
</title>
<meta name="week" content="13">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
Fundamental Theorem / Conservative Fields / Cosmic shortcut [6.F]
</h1>
<p class="show">See <a href="https://openstax.org/books/calculus-volume-3/pages/6-3-conservative-vector-fields">Strang, section 6.3</a>

<p class="show"><img src="0g/13.3.foundation.jpg" class="big"><br>
Fundament = Foundation


<ul class="else"><li>We'll tie together 3 characteristics of conservative vector fields
<li>and find an easy way to calculate a vector path integral <i><b>if</b></i> 
the vector field is conservative.
</ul>

<h3>Conservative vector field</h3>
<div class="show def incremental">
<p>If a function $f$ exists such that $\myv F(x,y)=\myv \grad f(x,y)$:
<ul>
<li>$\myv F(x,y)$ is a <b>conservative vector field</b>. 
<li>$f(x,y)$  is called a <b>potential function</b> for the vector field $\myv F$.
</ul>
</div>

<h3>Cross-derivative test</h3>
<p class="show def incremental">
Consider a function $\myv F(x,y)=P(x,y)\uv i+Q(x,y)\uv j$.  The vector field $\myv F$ is conservative if
$$\frac{\del P(x,y)}{\del y} = \frac{\del Q(x,y)}{\del x}.$$

<h3>Path independence</h3>

<p class="show"><img src="0g/13.2.3paths.jpg" class="rightalign">
In general, the value of a line integral of a given vector function depends, not only on the endpoints, but also on <i>which</i>  path is taken.

<p>For the integrals above, we found:
$$\color{blue}{\int_\text{blue}\myv F\cdot \myv r=0},$$
$$\color{red}{\int_\text{red}\myv F\cdot \myv r=-\frac 23 },$$
$$\color{green}{\int_\text{green}\myv F\cdot \myv r=0}.$$


<p>These line integrals--all sharing the same initial and final points--give different values depending on which path is taken.



<p>But there exists a class of vector fields for which the path taken when calculating vector integrals <i>does not matter</i>. The only things that <i>do</i> matter are the starting and ending point.

<p>This characteristic might remind you of the...


<h3>Fundamental Theorem - single variable calculus</h3>
<p class="show">The <b><a href="http://mathworld.wolfram.com/FundamentalTheoremsofCalculus.html">fundamental theorem of calculus</a></b> for a single variable:
$$\int_a^b \frac{df(x)}{dx}\,dx=\left.f(x)\right|^{x=b}_a=f(b)-f(a)$$
where $\frac{df(x)}{dx}$ is continuous on $[a,b]$.

<p>The integral of [the derivative of $f$] only depends on the values of $f$ at the  endpoints of the interval.

<!--
<p>All the fundamental theorem<span style="font-size:150%"><b>s</b></span> that we shall see relate the <b>integral of</b> some kind of <b>derivative of a function</b> over some kind of interval to the <b>values of the function at the boundary</b> of the interval.  
-->

<h3>Vector integral of a conservative field</h3>
<p class="show">$\myv F$ is a conservative vector field, if a potential function, $f$, exists such that $\myv F$ is the gradient of $f$: $\myv F(x,y,z)=\myv \grad f(x,y,z)=\langle
  \frac{\del f}{\del x}, \frac{\del f}{\del y}, \frac{\del f}{\del z}\rangle$
  
<p>Integrate it...
$$\begineq \int_C\myv F\cdot d\myv r 

&= \int_C(\myv\grad f)\cdot d\myv r 
  = \int_{t=a}^b (\myv\grad f(\myv r(t))\cdot \myv r'(t)\,dt \\

&=\int_{t=a}^b \langle
  \frac{\del f}{\del x}, \frac{\del f}{\del y}, \frac{\del f}{\del z}\rangle
\cdot 
 \langle 
  \frac{dx}{dt}, \frac{dy}{dt}, \frac{dz}{dt}\rangle
  \rangle \,dt \\

&=\int_{t=a}^b \left(
  \frac{\del f}{\del x}\frac{dx}{dt}+\frac{\del f}{\del y}\frac{dy}{dt}+
   \frac{\del f}{\del z}\frac{dz}{dt}
\right)\,dt
\endeq
$$
<p>But we recognize $(...)$ as $df/dt$ expanded with the chain rule, so we 
conclude that:
$$\int_C\myv F\cdot d\myv r =\int_{t=a}^b \frac{d}{dt}f(t)\,dt=\left.f(t)\right|_a^b=f(\myv r(b))-f(\myv r(a)).$$
<style>
.blink_me {
  animation: blinker 2s linear infinite;
}
@keyframes blinker {
  50% {
    opacity: 0;
  }
}
</style>

<div class="show def incremental">
<h4 class="blink_me" style="text-align:center; font-size:2.5em;line-height:1em;border: 4px dashed magenta; background-color:#af0; color:#06a;border-radius:16px;">the Cosmic shortcut</h4>
For a conservative vector field, $\myv F=\myv \grad f$:
$$\int_C \myv F\cdot d\myv r = f(\,\myv r(b)\,)-f(\,\myv r(a)\,).$$
where $\myv r(a)$ is the position vector of the starting point of the directed path $C$, and $\myv r(b)$ is the position vector of the ending point.
</div>

<p>This is $\Delta f$, the change in "height" of the potential function between $\myv r(b)$ and $\myv r(a)$.

<p>The integral only depends on the locations of the  points at the beginning and end of the path.
<p><i>At no point in what we just calculated did
any details of the path $C$ come into play</i>.  So apparently...
<p>The line integral of this conservative field, $\myv F$ is <b>path independent</b>.

<p>In physics, the potential function often corresponds to a <i>potential energy</i>: Gravitational, electric potentials.

<p>A potential function is like a well-behaved landscape. When a body moves in a conservative field, after a <b>round trip</b>, the body will return to the same  position in the landscape, and thus it will have the same height (potential energy) as it started with.

<p>In terms of the vector function $\myv F$...<br>
<img src="0g/13.3.theorem3.jpg" class="big">
<p>A round trip--same starting and ending point--along a particular path is denoted as $\oint_C$.  So we could also write this as
$$\oint_C\myv F\cdot d\myv r = 0$$
for all round trips $C$.

<p>
<img src="0g/13.3.theorem4.jpg" class="big">

<p>Putting all of these together:
<h2>Conservative fields</h2>
For a conservative field, $\myv F=\myv \grad f=P\uv i+Q\uv j$,
$$\oint_C\myv F\cdot d\myv r=0 \Leftrightarrow \int_C \myv F\cdot d\myv r=f(\myv r(b)-f(\myv r(a))\Leftrightarrow P_y=Q_x.$$




<h3 id="saved"><i>Saved</i> by a conservative field</h3>
<p class="show">Integrate the vector function
$$\myv F = 2xy\uv i +x^2\uv j$$
along this fearsome-looking, 3-segment path:<br>
<img src="0g/13.3.conex.jpg" class="big">

<p>Could this $\myv F$ be the gradient of some function $f$?  Applying our test$ 
\frac{\partial}{\partial y}P
   \stackrel{?}{=}
\frac{\partial}{\partial x}Q$...

$$
\frac{\partial}{\partial y}2xy=2x;
\hspace{3em}
\frac{\partial}{\partial x}x^2=2x;$$

<p>Yes -- it's conservative!
This opens up two simpler possibilities to evaluate the integral:

<ol class="incremental">
<li>Guess the potential--After a little thought
$f=x^2y$ should do the trick--and then just find the difference between the values of the potential at the end and beginning points:  

$$\int \myv F\cdot d\myv r=f(0,-1)-f(-1,0)=(0)^2(-1)-(-1)^2(0)=0.$$



<li>Even if you can't guess the potential, you could still choose some *more convenient* path connecting the beginning and end points to integrate along,
such as the straight line connecting
$(-1,0)\to (0,-1)$.

</ol>


<h3>To Do</h3>
<ul class="todo">
<li>06.3.think  before you integrate
</ul>


<h3>Visually</h3>
<p class="show"><img src="0g/13.3.curly.jpg" class="rightalign">
Will the vector integral along the orange path be same as along the green path?

<p>BTW - The vector integral $$\oint_C \myv F\cdot d\myv r$$ is also called a
<i><b>circulation integral</b></i>.  And a conservative field is also called "irrotational" because any circulation integral is zero.




<h3 id='conservative'>Summary: path independence</h3>
<p class="show">For the vector field $\myv F=P\uv i+ Q\uv j$, the following statements are all equivalent and imply each other...
<ul>
<li>Path independence 
$$\oint_{\text{all } C} \myv F\cdot d\myv r=0$$

<li>The vector field is conservative.

<li>The vector field is irrotational.
$$\myv \grad \times \myv F = 0$$

<li>Cross derivatives equal
$$ 
\frac{\partial}{\partial y}P
   =
\frac{\partial}{\partial x}Q
$$

<li>The vector field is the gradient of some potential function $f$,
$$\myv F=\myv \grad f.$$
</ul>


<h3 id="recipe">How to find the potential $f$ from a conservative $\myv F$</h3>
<p class="show">
<a href="https://flickr.com/photos/foundingfarmers/4749883954"><img src="0g/ChefN.jpg" style="width:200px"  class="leftalign"></a>
(Lab 06)
<br><br>
<b>Recipe</b> to find the potential, $f$, instead of just guessing!
<p>$\myv F=\myv \grad f$ implies that for <b>any path</b> connecting the two points $(a,b)$ and $(x,y)$ this integral will evaluate to
$$\int_{(a,b)}^{(x,y)} \myv F\cdot d\myv r=\int \myv \grad f\cdot d\myv r=
f(x,y)-f(a,b)$$
along *any* path. So, by integrating we'll find  $f(x,y)$ to within a constant.  But any constant can be added to $f$ and we'll still get the same $\myv F$ after taking the gradient.  So, the choice of the point at which to begin does not matter either.

<h4>Example</h4>
<p>Consider the function $\myv F(x,y)=

(\sin (x y)+x y \cos (x y))\uv i+ x^2 \cos (x y)\uv j$.  Is it conservative?
<p><img src="0g/13.3.test.jpg"><br>
Yes!

<p><img src="0g/13.3.path.jpg" class="rightalign">Integrate $\myv F$ along this path from the origin to $(x_0,y_0)$. <br><br> (We're using $x_0$ and $y_0$ instead of $x$ and $y$ so as not to mix up the arguments of the functions being integrated and the integration limits.  We'll go back and replace them at the end.)

<p><b>Along path I</b>: $y=0$ and d$\myv r = dx \uv i$ so
$$\myv F \cdot d\myv r =\left.F_x\right|^{y=0}\,dx=(\sin(x\cdot 0)
   +x\cdot 0 \cos(x\cdot 0))dx = 0$$
So the integral is 
$$\int_I\myv F \cdot d\myv r =\int_0^{x_0}0\,dx = 0.$$

<p><b>Along path II</b>: $x=x_0$ and d$\myv r = dy \uv j$ so
$$\myv F\cdot d\myv r =\left.F_y\right|^{x=x_0}\,dy= x_0^2\cos(x_0 y) \,dy$$
So the integral is
$$\int_{II}\myv F\cdot d\myv r = \int_0^{y_0}x_0^2\cos(x_0 y) \,dy=
\left.x_0\sin(x_0y)\right|_0^{y=y_0}=x_0\sin(x_0y_0).$$
<p>Adding and substituting $x_0\to x$ and $y_0\to y$:
$$\int_I+\int_{II}=x\sin(xy)=f(x,y)-f(0,0).$$
And checking that the gradient of this function gives us our original vector function....<br>
<img src="0g/13.3.gradoff.jpg"><br>
YUP!


<h3 id="checkpath">Checking a few paths</h3>
<p class="show">Let our potential function be...
$$f(x,y)=xy$$
<p>Then $f_x=y$ and $f_y=x$. So the vector function
$$F=y\uv i +x\uv j$$
is conservative.
<p>So, the integral...
$$\int_C \myv F\cdot d\myv r=\int_{\myv r(a)}^{\myv r(b)}(y\,dx+x\,dy)$$
should be independent of the path $C$ taken.

<h3>&nbsp;</h3>
<p class="show">
<img src="0g/13.3.pi1.jpg" class="big">

<h3>&nbsp;</h3>
<p class="show">
<img src="0g/13.3.pi2.jpg" class="big">

<h3>&nbsp;</h3>
<p class="show">
<img src="0g/13.3.pi3.jpg" class="big">




<h4 class="handout">Image credits</h4>
<p class="handout"><a href="https://www.flickr.com/photos/46355638@N00/4120337055">John Carrel`</a>

<?php include "../../classes/3.h" ?>

