<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Div, Grad, Curl [6.G]
</title>
<!-- &#128683; -->
<meta name="week" content="14">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
Gradient, Divergence and Curl...as plumbing [6.G]
</h1>
<p class="show">See <a href="https://openstax.org/books/calculus-volume-3/pages/6-5-divergence-and-curl">Strang, section 6.5, Divergence and Curl</a>

<p class="show"><img src="0g/1.2.plumber.jpg" class="rightalign">
Let's imagine the vectors $\myv F(\myv r)$ in  a vector field in multiple dimensions as representing <b>water flow</b>.  
<ul class="else">
<li><b>Gradient</b>, $\myv \grad$: <i>Which way does water flow in a landscape (=surface)?</i>
<li><b>Curl</b>, $\myv \grad \times$: <i>Any swirling happening?</i>
<li><b>Divergence</b>, $\myv \grad \cdot$: <i>Where are the leaks or faucets?</i>

</ul>

<p>To a good approximation, water is an <b>incompressible fluid</b>.  This means:
<ul>
<li>Even if the  pressure changes, 1 gallon of water will keep the same volume and the same density.
<li>If we put one gallon of water per minute into one end of a pipe of constant diameter, then we expect one gallon per minute to flow out of the other end.
<li>If less than one gallon per minute flows out the other end, then we can be certain that there must be a leak somewhere in the pipe.<br>
<a href=""><img src="0g/6.leak.jpg"><br>
<span class="caption">Flickr user Ibai</span></a>
</ul>


<h3>Gradient and the "nabla" <b>_operator_</b></h3>
<p class="show">[The following ideas will be illustrated with functions of 2 variables, but can be extended to 3 or more variables.]
<p class="show">Consider a function which represents the height, $h(x,y)$, of a surface.  The gradient of $h$:
$$\myv\grad h =h_x \uv i +h_y \uv j,$$
<img src="0g/1.2.gradup.jpg" class="rightalign">points in the steepest "uphill" direction for the landscape $h$: If water is released at $(x,y)$ it should start flowing in the $-\myv \grad h$ direction.

<p>Re-arranging how the gradient is written:
$$\myv \grad h=\uv i \frac{\del}{\del x}h + \uv j \frac{\del}{\del y}h=\left[\uv i \frac{\del}{\del x} + \uv j \frac{\del}{\del y}\right] h,$$
suggests the idea of the *thing* in [...] "operating" on the scalar function, $h$, to produce the gradient vector field.  This operator is called...

<p class="incremental show def">
The <b>nabla operator</b>:
$$\myv \grad \equiv \uv i \frac{\del}{\del x} + \uv j \frac{\del}{\del y}.$$
<ul><li>It's a <i>vector</i> operator.
<li>When nabla <i>operates on</i> a scalar function, $h$, it produces a vector field: the gradient field.
$$\begineq \myv \grad h(x,y) &= \left[\uv i\,\frac{\del }{\del x}+\uv j\,\frac{\del }{\del y}\right]h(x,y)\\
&= \frac{\del h}{\del x}\,\uv i+\frac{\del h}{\del y}\,\uv j \equiv\color{blue}\langle h_x, h_y\rangle.\endeq$$
</ul>


<h3>The Curl</h3>

<p class="show">The cross-product-like object involving $\myv \grad$ and a vector field $\myv F=P(x,y,z)\uv i+Q(x,y,z)\uv j + R(x,y,z)\uv k$ is 
<p class='show incremental def'>The <b>curl of a vector field</b> $\myv F$ is:
$$\begineq\myv \grad \times \myv F &= \begincv \uv{i}& \uv{j}& \uv{k}\\
\frac{\del}{\del x} & \frac{\del}{\del y} & \frac{\del}{\del
  z}\\
P& Q& R\endcv \\
&=
\uv{i}\left(\frac{\del R}{\del y}-\frac{\del Q}{\del z}\right) + \uv{j}\left(\frac{\del P}{\del z}-\frac{\del
R}{\del x}\right) +\uv{k}\left(\frac{\del Q}{\del x}-\frac{\del P}{\del y}\right)\endeq.$$
<p>If $\myv F$ is a function of only $x$ and $y$, then only the $\uv k$ component is non-zero.

<p class='show'>For $\myv F(\myv r) = -y \uv{i} +x \uv{j}$, sketch $\myv F$ in the $x-$, $y-$ plane ($z=0$)...
<p><img src="0g/1.2.curl1.gif" width="339" height="263">
$$\myv \grad \times \myv F = \begincv \uv{i}& \uv{j}& \uv{k}\\
\frac{\del}{\del x}&\frac{\del}{\del y}&\frac{\del}{\del
  z}\\
-y& +x& 0\endcv = 2\uv{z}.$$
<p>For this function, notice that the curl has the same value <i>everywhere</i>, not just at the origin.

<h4>"Swirliness" defined by a paddle-wheel</h4>
<p>Again thinking of $\myv F$ as the field specifying water velocity...
<p>
Imagine placing a <img src="0g/1.2.paddle.gif" width="320" height="285" class="rightalign">paddle-wheel
  with axis oriented in the $\uv{k}$ direction in the water flow represented
  by the vector function $\myv F$ and seeing whether it turns counter-clockwise
  (positive curl) or clockwise (negative curl).  <br>
<p><img src="0g/1.2.curl1.gif" width="339" height="263">
<p>In a 3-d water flow field, we could also try orienting the paddle wheel towards $\uv{j}$ or
  $\uv{k}$ to check for components of the <i>curl</i> in all possible directions.






<h3>Conservative fields and curl</h3>
<p class="show">We saw that fluid flow in a landscape is related to the gradient field.
<p>Can you imagine some kind of landscape/surface that would give rise to this flow?<br>
<img src="0g/1.2.curl1.gif" width="339" height="263">

<p>Howzabout this landscape?...<br>
<img src="0g/1.2.ascendingdescending-flipped.jpg">
<p>Or this somewhat more realistic one?...
<img src="0g/13.spiral.jpg" class="big">

<h4>Curl of a gradient</h4>
<p>If our vector field $F$ is the gradient of a potential function, then we have $\myv F=\myv \grad f = \langle f_x,f_y\rangle$.  The curl of this two-d vector field would be
$$\myv \grad \times \langle f_x,f_y,0 \rangle = \begincv \uv{i}& \uv{j}& \uv{k}\\
\frac{\del}{\del x}&\frac{\del}{\del y}&\frac{\del}{\del
  z}\\
f_x& f_y& 0\endcv = \left( f_{yx}-f_{xy} \right)\uv{z}.$$
So, by Clairault's Theorem, this must be 0 for a smooth, continuous function $f(x,y)$.  More generally, even in 3-d:


<p class="show def incremental">If $f$ is a scalar function of 3 variables, that has continuous second-order partial derivatives, then
$$\myv \grad \times (\myv \grad f) = 0$$
at all points $(x,y,z)$.


<p>Alternative statements:
<ul><li>Any swirliness in the flow $\myv F$?  Sorry, there's no landscape for which $\myv F$ represents the flow. (There's <b>no potential function, $h$</b>.)

<li>A vector field $\myv F$ is conservative if, and only if, $\myv \grad\times \myv F=0$.
</ul>
<p>This is a <i>test</i> we can use on any vector field $\myv F$ to decide whether it's worth looking for a potential function or not!

<p>A field $\myv F$ is said to be <b>irrotational</b> if for all points in space:
$$\myv \grad \times \myv F=0$$



<!--
<ul class="incremental todo">
<li><img src="0g/13.1b.f-xy.jpg" class="rightalign">
At right is the function $\myv F=-y\uv i+x\uv j$.
<li>Irrotational?
<li>Conservative?
</ul>


<h3>Try these</h3>
<ul class="else"><li>$\myv F=-y\uv i+x\uv j$
<li>$\myv F=y\uv i$
<li>$\myv F=x\uv i$
</ul>

<p>Are these functions rotational or irrotational?
<p>Conservative or not?
<p>If a field is conservative, find its potential function, $f(x,y)$.
-->


<h3>The Divergence</h3>

<p class="show">We could form a <b>dot product</b> between the nabla vector operator and...
<p>a vector field, $\myv F(x,y)=P(x,y)\uv i +Q(x,y)\uv j$, where 
 $P$ is the $x$-component of $\myv F$.<!--, *not*  a partial derivative!-->

<p> The dot product of two vectors is a scalar. This defines...
<p class="show incremental def">The <b>divergence of </b> $\myv F(x,y)$ is

$$\begineq \myv \grad \cdot
 \myv F &= \left(\uv{i} \frac{\del}{\del x} +\uv{j} \frac{\del}{\del
    y}\right)
 \cdot \left( P\uv{i} + Q\uv{j}\right)\\
&=\frac{\del P}{\del x} + \frac{\del Q}{\del y}.\endeq$$





<p>For the following sketches of 2-dimensional vector fields, $\myv F(x,y)$, what [pos, neg or 0] is the 2-d divergence, $\frac{\del P}{\del x}+\frac{\del Q}{\del y}$ at the positions marked in purple?




<p>$\myv F(x,y)=3\, \uv j$<br>
<img src="0g/1.2.div2.gif" width="407" height="313">

<p>$\myv F(x,y)=x\uv i +y\uv j$<br>
<img src="0g/1.2.div1.gif" width="326" height="326">


<p>You can estimate visually, without a formula... For the vector field above:
<p class="screencast"><a href="http://youtu.be/YoHcA1hILq8?hd=1">Estimating the divergence of a vector field</a> - Narrated: 2 min.

<p><img src="0g/1.2.div3.gif" width="276" height="302">

<p><img src="0g/13.1.leaky.jpg">

<h4>Where are the leaks (or faucets)?</h4>

<p>Imagine that
the arrows, $\myv F(x,y)$, represent the velocity of 2-d flow of an incompressible fluid (water!). 
<p>Now imagine
  injecting a "cloud" of purple dye at a location you'd like to investigate for "leaks" in your system, places where the water is disappearing.

<p>A place where the cloud gets smaller corresponds to a location where the <b>divergence is negative</b>:  a "leak" (or sink, or drain) where water is leaving your 2-d system <br>
<img src="0g/1.2.drain.jpg" alt="drain" width="500" height="375">
<p>...leaving your 2d system **into another dimension**! <br>

<p>Places where  the cloud gets bigger have <b>positive
    divergence</b>.  There must be a "source" (or faucet) of water **from another dimension**(!).
<br>
<img src="0g/1.2.cuttingboard.jpg" alt="source" width="600" height="194">

<p>Consider again these vector fields, as if $\myv F$ of water flow... What's happening to the size of the purple spot?

<p><img src="0g/1.2.div1.gif" width="326" height="326"><br>
<p><img src="0g/1.2.div3.gif" width="276" height="302"><br>
<p><img src="0g/1.2.div2.gif"><br>


<h3>Divergence means...</h3>
<p class="show"><b>Incompressible</b> flow in 2-d means
$$\myv \grad \cdot \myv F = 0$$
**unless** there are sources (or sinks) bringing in more water from (or taking away some to) "another dimension".

<p>When the fluid flow is incompressible, then, if the vectors represent water flow, just as much water enters any bounded volume (or area in 2d) as exits the volume, **unless** (see above).

<p>$\myv F(x,y)=3\, \uv j$<br>
<img src="0g/1.2.div2.gif" width="407" height="313">

<p>$\myv F(x,y)=x\uv i +y\uv j$<br>
<img src="0g/1.2.div1.gif" width="326" height="326">

<p><b>Electric fields</b> The divergence of the electric field in empty space is zero.  Any divergence of the electric field must be due to <i><b>electric charge</b></i>. So, we say $\myv \grad \cdot \myv E(x,y,z) \propto \rho(x,y,z)$, where $\rho$ is the charge density.  This statement is equivalent to saying: Charges are the sources or sinks of the electric field.

<ul><li>MathInsight.org: the <a href="http://mathinsight.org/divergence_idea">divergence idea</a>.
</ul>

<p class="todo">
In the /mvhandouts/ folder... 06.5.VisualDivCurl.php





<!--
<h4 class="handout">Image credits</h4>
<p class="handout"><a href=""></a>
-->

<?php include "../../classes/3.h" ?>