<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Green: Circulation and Flux forms [06.H]
</title>
<meta name="week" content="14">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
Green's theorem: Circulation and Flux forms [13.H]
</h1>
<p class="show">See <a href="https://openstax.org/books/calculus-volume-3/pages/6-4-greens-theorem">Strang, Section 6.4</a>


<h2>Two Vector forms of Green's theorem</h2>
<p class="show">There are two implications of Green's theorem in terms of vector integrals. One involves the curl and one involves the divergence.


<h3 id="tangential">Tangential component of a vector field</h3>

<p class="show def">
<b>Green's Theorem</b><br><br>
Let $C$ be a positively oriented, piecewise-smooth, simple, closed curve in the plane and let $D$ be the region bounded by $C$. If $P$ and $Q$ have continuous partial derivatives on an open region that contains $D$, then

$$\oint_C P\,dx+Q\,dy=\iint_D\left(\frac{\del Q}{\del x}-\frac{\del P}{\del y} \right)\,dA.$$

<p><img src="0g/13.4.hotdog.jpg" class="rightalign">
We have already seen that the left hand side of Green's theorem is the integral of the <i>tangential</i> component of $\myv F$ around $C$, that is, with $\myv F=P\uv i + Q\uv j$,
$$\oint P\,dx+Q\,dy=\oint \myv F\cdot d\myv r = \oint \myv F\cdot \uv T\,ds$$
where 
$$\uv T=\frac{\myv r'(t)}{|\myv r'(t)|} 
= \frac{x'(t)}{|\myv r'(t)| }\uv i + \frac{y'(t)}{|\myv r'(t)| }\uv j.$$

<p>The right-hand side of the Green's theorem 
$$r.h.s. = \iint_D\left(\frac{\del Q}{\del x}-\frac{\del P}{\del y}\right)\,dA$$
can be expressed in terms of a curl:

<p>Treating $\myv F$ as a three-dimensionsal field with a $z$-component of zero...
$$\myv \grad \times \myv F=\text{det}
\begincv \uv i &\uv j&\uv k \\
\frac{\del}{\del x} & \frac{\del}{\del y} & \frac{\del}{\del z}\\
P & Q & 0
 \endcv
= \left(\frac{\del Q}{\del x}-\frac{\del P}{\del y}\right)\uv k.
$$
So, Green's theorem in terms of the curl of $\myv F$ is...

<p class="show incremental def">
$$\oint_C \myv F\cdot \uv T\,ds = \iint_D \myv \grad \times \myv F \cdot \uv k\,dA.
$$

<p>The integral of the tangential component along the boundary is called the <b>circulation</b>.

<p>In terms of fluid flow, this relates the integral of the curl of a vector field over a domain, $D$ to the circulation on the boundary.  

<p>[<b>Fundamental</b> theorem: relates a differential of a vector function to the value of the vector function on the boundary.]

<h4>Generalizing to 3-dimensions</h4>
<p class="def">
<b>Circulation Form</b> of Green's Theorem:
$$\oint_C \myv F\cdot \uv T\,ds = \iint_S \myv \grad \times \myv F \cdot d\myv S
$$

<ul><li>$d\myv S=\uv n\,dS$, 
<li>$\uv n$ is the local normal unit vector. It's perpendicular to a 3-dimensional surface, $S$/
<li>$dS$ is the differential of surface <b>area</b>, and
<li>The path, $C$, is a curve in space which is the boundary of the surface $S$.
</ul>
<p>Go to <a href="mv06.I.php">06.I - Stokes' theorem</a>.  
 

<h3 id="normal">Normal component of a vector field</h3>
<p class="show">The unit tangent vector was:
$$\uv T=\frac{\myv r'(t)}{|\myv r'(t)|} 
= \frac{x'(t)}{|\myv r'(t)| }\uv i + \frac{y'(t)}{|\myv r'(t)| }\uv j.$$

<p><img src="0g/13.4.hotdog.jpg"><br>
The <b>normal vector</b>, $\uv n$, will be at right angles to $\uv T$, and lies in the $x$-$y$-plane.  We can use this shortcut of just interchanging the $x$ and $y$ components, and multiplying one of them by -1 in order to get a vector at right angles to the tangent vector. There are two choices.  If the normal vector has components $\uv T=\langle a, b\rangle$, then
$$\uv n_1=\langle -b,a\rangle\ \ \ \text{ or }\ \ \
\uv n_2=\langle b,-a\rangle.$$

The <i>outward</i> normal vector is the 2nd one, which has components:
$$\uv n  = \frac{y'(t)}{|\myv r'(t)| }\uv i - \frac{x'(t)}{|\myv r'(t)| }\uv j.$$

<p>So, integrating the normal component over the boundary of $D$...
<img src="0g/13.4.hotdog.derivation.jpg" class="big"><br>
<ul><li>The very last step follows by just using our original statement of Green's theorem, but substituting $P\to-Q$ and $Q\to P$.
<li>The quantity on the right in $(...)$ is the <i>divergence</i> of $\myv F$, so...
</ul>


<p class="show incremental def">
$$\oint_C \myv F\cdot \uv n\,ds = \iint_D \myv \grad \cdot \myv F \,dA.
$$

<p>The integral of the normal component of the vector field over the boundary is called the <b>flux</b>.

<p>In terms of an incompressible fluid, this says that the integral of the divergence (all the faucets minus the  drains) in $D$ is equal to the fluid flux (amount of fluid per second) flowing out of the region.

<h4>Generalizing to 3 dimensions</h4>
<p class="show incremental def">
<b>Flux Form</b> of Green's theorem:
$$\oiint_S\myv F\cdot d\myv S=\iiint_E \myv \grad \cdot \myv F\,dV
$$
<ul><li>The <span style="font-size:3ex">&#x222f;</span> symbol means a surface integral over a <b>closed surface</b>.
<li>$d\myv S=\uv n\,dS$ is a vector differential which is everywhere normal to the surface $S$.
<li>$S$ is the boundary of a 3-d solid, $E$.

</ul>
<p>Go to <a href="mv06.J.php">06.J - the divergence theorem</a>








<h4 class="handout">Image credits</h4>
<p class="handout"><a href="https://www.flickr.com/photos/arenamontanus/3213502484">Anders Sandberg</a>

<?php include "../../classes/3.h" ?>
