<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>

Stokes' Theorem - Circulation [6.I] 
</title>
<meta name="week" content="14">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>
<h2>Stokes' Theorem - Circulation [6.I]</h2>
<p class="show"><img src="0g/13.6.tornado.jpg"><br>
Circulation!

<h3>Green's Theorem in terms of circulation integrals</h3>
<p class="show">Recapping <a href="13.4.php#tangential">Green's Theorem in terms of the tangential component</a> of a vector field $F$ in the $xy$ plane:

<p><img src="0g/13.4.hotdog.jpg"><br>
The left hand side of Green's theorem is the <i>tangential</i> component of $\myv F$ around $C$ (positive sense), that is, with $\myv F=P\uv i + Q\uv j$,
$$\oint P\,dx+Q\,dy=\oint \myv F\cdot d\myv r = \oint \myv F\cdot \uv T\,ds$$

<p>The right-hand side of the Green's theorem 
$$r.h.s. = \iint_D\left(\frac{\del Q}{\del x}-\frac{\del P}{\del y}\right)\,dA$$
can be expressed in terms of a curl, if we treat $\myv F(x,y)$ as a <i>three-dimensionsal field</i> $\myv F(x,y,z)$ with a $z$-component of zero...
$$\myv \grad \times \myv F=\text{det}
\begincv \uv i &\uv j&\uv k \\
\frac{\del}{\del x} & \frac{\del}{\del y} & \frac{\del}{\del z}\\
P & Q & 0
 \endcv
= \left(\frac{\del Q}{\del x}-\frac{\del P}{\del y}\right)\uv k.
$$
Green's theorem in terms of the curl of $\myv F$ was...

<p class="show incremental def">
$$\oint_C \myv F\cdot \uv T\,ds = \iint_D \myv \grad \times \myv F \cdot \uv k\,dA.
$$

<p>This statement turns out to be a <b>special case</b> of <b>Stokes' Theorem</b>:




<p class="incremental show def"><b>Stokes' Theorem</b> Let $S$ be an oriented piecewise-smooth surface that is bounded by a simple, closed, piecewise-smooth boundary curve $C$ with 
positive orientation.  Let $\myv F$ be a vector field whose components have continuous partial derivatives on an open region in $\mathbb{R}^3$ that 
contains $S$.  Then
$$\oint_C\myv F\cdot d\myv r=\iint_S \myv \grad \times \myv F \cdot d\myv S$$

<!--<img src="0g/13.6.Stokes.jpg" class="centeralign">-->

<p><img src="0g/13.6.Stokesdiagram.jpg" class="centeralign">

<br>Since...
$$\oint_C \myv F\cdot d\myv r=\oint_C \myv F\cdot \uv T\,ds$$
and
$$\iint_S\myv \grad \times \myv F \cdot d\myv S=\iint_S\myv \grad \times \myv F\cdot \uv n \,dS,$$
the content of Stokes' theorem is that
<ul><li>The integral of the curl ("circulation density") over a 
surface is equal to...
<li>the circulation around the boundary of the surface.
</ul>

<p>The surface in question can be <i>*any*</i> surface bounded by $C$!
<h3>Meaning of curl / circulation</h3>
<p class="show"><b>Imagine</b> that we <i>zoom in</i> on  a surface in 3-d.  If the surface is smoothly varying, and if $\myv F$ is a smoothly varying, continuous function, then perhaps it is plausible we can eventually zoom in sufficiently such that a small patch of the surface is very nearly flat.

</ul>


<p><img src="0g/13.6.curld1.jpg" class="leftalign">


Stokes' Theorem makes the claim that curl is a measure of <i>circulation per unit area</i>. If the vector field $\myv v$ is the velocity of fluid flow, then the circulation around a circle $C$ is the integral of the tangential component of $\myv v$ around the boundary of the circle.

<p>Circulation is a measure of the extent to which $\myv v$ maintains the direction of the unit tangent $\uv T$ - the extent to which the flow is rotating in the direction of $C$.<br clear="all">

<h3></h3>
<p class="show"><img src="0g/13.6.curld2.jpg" class="leftalign">
Take a point $P$ within the flow and a disk $D$ with unit normal $\uv n$ surrounding $P$.

<p>Stokes' theorem says that the circulation of $\myv v$ around $C$ is approximately equal to the average $\uv n$ component of $\myv \grad \times \myv v$ on $D$ multiplied by the area of $D$.

<p>So the average $\uv n$ component of $\myv \grad \times \myv v$ on $D$ is equal to the circulation around $C$ divided by the area of $D$.

<h3></h3>
<p class="show"><img src="0g/13.6.curld2.jpg" class="leftalign">
Integrating $\myv \grad \times \myv F$ for the region shown.

<ul class="else"><li>Arrows show the circulation for each patch of surface $\Delta S$.
</ul>

<p>Inside the large rectangle the rotations cancel so the integration of curl F for the region is equivalent to integrating the flow along the boundary.
<br clear="all">
<p><img src="0g/13.6.curld4.jpg" class="big">

<h3>Example</h3>

<p class="show">Calculate the surface integral 
$\iint_S \myv \grad \times \myv F \cdot d\myv S$, where
<ul><li>$\myv F(x,y,z)=6y\cos z\uv i +e^x\sin z\uv j+xe^y\uv k$
<li>$S$ is the half-sphere $x^2+y^2+z^2=49$ where  $z\geq 0$, oriented <i>upward</i>.
</ul>

<p>Here's the half-sphere:<br>
<img src="0g/13.7.sphere.jpg"><br>
which is bounded by $C$, a circle of radius 7 centered at the origin.   

<p>The points on the circle are given by 
$$\myv r(t)=x(t)\uv i+y(t)\uv j+z(t)\uv k=7\cos t\uv i+7\sin t\uv j+
0\uv k.$$ 
Traversing $C$ in the counterclockwise direction, $t$ runs from 0 to
 $2\pi$. 

<p>We can write
$$\iint_S \myv \grad \times \myv F \cdot d\myv S=
\oint_C\myv F\cdot d\myv r=
\int_0^{2\pi}\myv F\cdot \myv r'(t)\,dt.$$
where the tangent vector is given by
$\myv r'(t)=\langle x'(t),y'(t),z'(t)\rangle = \langle -7\sin t,7\cos t,0\rangle.$
<p>Along $C$, $z=0$, and so 
$$\myv F(x,y,0)=\langle 6y\cos 0,e^x\sin 0,xe^y\rangle
=\langle 6(7\sin t),0,7\cos t\, e^{7\sin t}\rangle.$$
<p>The integral above becomes...
$$\int_0^{2\pi}\myv F\cdot \myv r'(t)\,dt=\int_0^{2\pi}(42*-7*\sin^2 t+
0+0)\,dt
=-294\pi.$$


<p class="todo">That circle in the x-y plane is also a boundary of the half-sphere <b>below</b> the x-y plane (the mirror image of the sphere pictured).
If we move around the circle in the same way as above, Is the positive or negative *orientation* for the bottom half-sphere?
<p class="todo">Based on your answer above, what is the value of the surface integral of the curl for the bottom half-sphere, with the normal vectors pointing outwards?
<p class="todo">Therefore, What would the integral over the whole sphere be, 
with consistently "outwards" surface normal vectors?
<p class="todo">Can you make a general statement about the surface integral of the curl for all closed surfaces?
<p class="todo">First Edfinity question--"cube"...





<h4 class="handout">Image credits</h4>
<p class="handout"><a href="https://www.flickr.com/photos/fadilfb/2146255462">Fadil Basymeleh</a>
<?php include "../../classes/3.h" ?>
