<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
The Divergence Theorem [06.J]
</title>
<meta name="week" content="15">

<?php include "../../classes/2.h" ?>

<h1>
The Divergence Theorem [06.J]
</h1>

<p class="show">
<img src="0g/13.8.io.jpg"><br>
<span style="font-size: 0.6em">Io passing in front of Jupiter, <i><a href="http://apod.nasa.gov/apod/ap021207.html">NASA - Cassini mission</a></i>.</span>
<br><br>
<h3>Vector fields found in nature...</h3>
<p>Consider the gravitaty field of a mass $M$ at the origin:
$$\myv G(\myv r)=-G\frac{M}{r^2}\uv r$$
The gravitational force on a mass $m$ at $\myv r$ is $\myv F_g=m\myv G$.


<p>The electric field due to a charge $Q$ at the origin is:
$$\myv E_e(\myv r)=\frac{4\pi}{\epsilon_0}\frac Q{r^2}\uv r$$
Electrical force on a charge $q$ at $\myv r$ due to a charge $Q$ at the origin is $\myv F_e=q\myv E$.

<ul><li>Do these fields have any curl?

<li>Isn't that interesting, that <b>2 out of the 4 force fields are $1/r^2$ fields</b>?
<li>The strong force $\propto e^{r/r_0}/r^2$ is <i>almost</i> a $1/r^2$ field too.

</ul>






<h3>Green's Theorem: flux integral</h3>
<p class="show">Recapping <a href="13.4.php#normal">Green's Theorem in terms of the normal component</a> of a vector field $F$ in the $xy$ plane:<br>
<img src="0g/13.4.hotdog.jpg"><br>
We found that
<p class="show incremental def">
$$\oint_C \myv F\cdot \uv n\,ds = \iint_D \myv \grad \cdot \myv F \,dA.
$$
<ul><li>The l.h.s. is the flux of $\myv F$ through the boundary
<li>$\myv \grad\cdot \myv F \equiv \left( \frac{\del P}{\del x}+\frac{\del Q}{\del y}
\right)$ is the divergence of the vector function, $\myv F(x,y)$ in 2 dimensions.
</ul>
<h4>The Divergence Theorem</h4>
<p>...is a generalization of that 2-d result to 3 dimensions:<br><br>
<img src="0g/13.6.divergence.jpg" class="centeralign"><br>Or,
<p class="show incremental def">
$$\oiint_S\myv F\cdot d\myv S
=\iiint_V \myv \grad \cdot \myv F\,dV
$$
<ul><li>The &#x222f; symbol means a surface integral over a <b>closed surface</b>.
<li>$d\myv S=\uv n\,dS$ is a vector differential which is everywhere normal to the surface.
<li>The divergence at a point is something like the local 'flux density'.
</ul>
<h4>Flux, $\Phi$</h4>
<p>Imagine that the vector field $\myv E$ below represents the <i>flow</i> of water.  It points in the direction of flow and has units of density*speed = kg/m^3*m/s= kg/(m^2s).
Therefore in the leftmost diagram, if the flow is in the same direction as a surface normal $\myv A$ (a vector whose magnitude is the red area $A$):
<br><img src="0g/fluxofE.png"></br>
then the flux $\Phi_E=EA$ will have units of kg / sec.  So the flux is the <b>mass of water passing through the surface, per second</b>.

<p>Perhaps you can understand from contemplating the two other  diagrams  that the general expression for this mass flux through the surface depends on the orientation of the surface relative to the flow, according to:
$$\Phi_E=\myv E\cdot\myv A.$$

<h4>"Plumbing" interpretation of the divergence theorem</h4>
<p>Writing the 3-d version of the divergence theorem as...
$$\oiint_S\myv F\cdot d\myv S=\iiint_V \myv \grad \cdot \myv F\,dV
$$
<p>The integrated flux of water in one second through a closed surface (left hand side) is equal to all the water flux in the volume inside the surface that we've injected from (or has leaked out to) "another dimension".

<p>This "water from another dimension" is more generally called <b>sources or sinks</b> of the field and depending on the context, can be electric charge or gravitational mass or quark color charge.

<h4>Electric charge and "Gauss' law"</h4>

<p>In electricity and magnetism, $\myv \grad\cdot \myv E=\rho/\epsilon_0$ where $\rho(\myv r)$, is the electric charge density which varies as a function of position in space.  So, the right-hand-side of the divergence theorem means:
$$\iiint_V \myv \grad \cdot \myv F\,dV=\frac{1}{\epsilon}\iiint_V \rho\,dV=\frac{Q_\text{enc}}{\epsilon_0},$$
where $Q_\text{enc}$ is the total charge in the volume $V$ which is enclosed by $S$.

<p>Then the divergence theorem results in <i>Gauss' law</i>:
<p class="def"><b>Gauss' Law<b>
$$\oiint_S\myv \E\cdot d\myv S=\frac 1{epsilon_0}Q_\text{enc}.$$
The total flux of electric field integrated over an closed surface $S$ is equal to the total electric charge enclosed within the surface.



<h3>Example</h3>
<p class="show"><img src="0g/13.6.triangle.jpg" class="rightalign">
Calculate the total flux, $\oiint_S \myv F\cdot \uv n \,dS$  through *all* the surfaces enclosing  the volume bounded by
 the triangle (which intersects each axis 9 units from the origin), and the planes $x=0$, $y=0$, $z=0$, where the vector field is:

$$\myv F(x,y,z)=(x+y^2)\uv i+(y+z^2)\uv j+(z+x^2)\uv k=P\uv i+Q\uv j+R\uv k.$$


<p>There are 4 surfaces.  
<p>Let's start with the toughest looking, triangular face.  We'd like calculate the flux through the surface<br><br>
$\iint_S \myv F\cdot \uv n \,dS$<br><br>
where $S$ is the surface with vertices $(9,0,0)$, $(0,9,0)$, $(0,0,9)$,


<p>I'll use this form of the surface integral:
$$\iint_S f(x,y,z)\,dS=
\iint_D f(x,y,g(x,y))\sqrt{1 +
\left(\frac{\del g}{\del x}\right)^2
+\left(\frac{\del g}{\del y}\right)^2
}\,dx\,dy.$$

<p>The equation of the plane containing the triangle is..
$$x+y+z=9 \Rightarrow z=g(x,y)=9-x-y$$
<ul><li>$g_x=g_y=-1$ so the square root factor is $\sqrt{3}$
<li> the limits of integration are
$$\iint_D=\int_{x=0}^9\int_{y=0}^{9-x}$$
</ul>

<p>The function $f(x,y,z)=f(x,y,g(x,y))$ in the integral is
$\myv F\cdot\uv n$.
<ul><li>The unit normal vector to the plane is $\uv n=\frac{1}{\sqrt 3}\langle 1,1,1\rangle$, 
<li>so 
$$\myv F\cdot \uv n = \frac{1}{\sqrt 3} \left(x+y^2+y+z^2+z+x^2\right)$$
<li>substituting in $z=9-x-y$ on the triangular surface, Mathematica expands this to...
$$\myv F\cdot\uv n = \frac{1}{\sqrt 3}(90 - 18 x + 2 x^2 - 18 y + 2 x y + 2 y^2)$$
</ul>
<p>Putting this all together...
$$\begineq \iint_D\myv F\cdot \uv n dS
&=
\frac{1}{\sqrt 3}\int_{x=0}^9\int_{y=0}^{9-x}(90 - 18 x + 2 x^2 - 18 y + 2 x y + 2 y^2)\,dy\,dx\\
&=\frac{8019}{4\sqrt 3}\endeq$$

<p>Oh no, I've still got 3 more surfaces to integrate over!!


<h3>Same example, but much easier...</h3>
<p class="show"><img src="0g/13.6.triangle.jpg" class="rightalign">
Calculate the total flux, $\oiint_S \myv F\cdot \uv n \,dS$  through *all* the surfaces enclosing  the volume bounded by
 the triangle (which intersects each axis 9 units from the origin), and the planes $x=0$, $y=0$, $z=0$, where the vector field is:

$$\myv F(x,y,z)=(x+y^2)\uv i+(y+z^2)\uv j+(z+x^2)\uv k=P\uv i+Q\uv j+R\uv k.$$
<p>Using the divergence theorem, we notice that instead of carrying out 4 surface integrals to calculate the desired surface integral we could integrate the divergence instead:


$$\oiint_S
\myv F \cdot \uv n\, dS = \iiint_V \myv \grad \cdot \myv F \,dV.$$

<div class="todo">
<ul><li>Calculate the divergence of this vector function.
<li>Calculate the volume integral of the divergence.
</div>
<a href="#1.1" onclick="toggle_visibility('a1.1');">show / hide</a>
<div id="a1.1" class="answer toggle">


<p>The divergence is
$$\myv \grad \cdot \myv F =\frac{\del P}{\del x}+\frac{\del Q}{\del y}
+\frac{\del R}{\del z}= 1+1+1=3.$$
<p>So, 
$$\iiint_V \myv \grad \cdot \myv F\, dV=3\iiint_V\,dV=3*V=3*(9*9/2)(9)/3=729/2.$$
</div>


<div class="justme">
<h3>The mystical function $\uv r/r^2$</h3>

<p class="show">In that exercise on <a href="../handouts/13.6.php">the flux of a vector field [13.6]</a> we worked with that function:
$$\myv F(x,y,z)=\frac{1}{(x^2+y^2+z^2)^{3/2}}\left(x\uv i+y\uv j+z\uv k\right)
=\frac{\myv r}{r^3}=\frac{1}{r^2}\uv r.$$
<p>In classical field theory,  the electric field, $\myv E(r,\theta,\phi)$ due to a single charge $q$ at the origin is
$$\myv E=\frac{q}{4\pi\epsilon_0r^2}\uv r.$$
<p>You calculated the flux integral over the (closed) surface of a sphere...
$$\oiint_S\myv F \cdot \uv n \,dS=4\pi.$$


<p>According to the divergence theorem,
$$\oiint_S\myv F \cdot \uv n\, dS=4\pi=\iiint_V \myv \grad \cdot \myv F\,dV$$
<p>This was for a sphere of radius $R$, but the answer is independent of the radius.  How can we make the volume larger but not increase *or* decrease the volume integral?? What does that imply about the divergence of $\myv F$?

<p>Calculate the divergence of $\myv F$:
$$\myv \grad \cdot\myv F=
\left( \uv i\frac{\del}{\del x}+\uv j\frac{\del}{\del y}+\uv k\frac{\del}{\del z}
\right)\cdot \frac{1}{(x^2+y^2+z^2)^{3/2}}\left(x\uv i+y\uv j+z\uv k\right) 
$$

Calculate one piece...
$$\begineq
\frac{\del}{\del x}\frac{x}{(x^2+y^2+z^2)^{3/2}}
&= \frac{\del}{\del x}x(x^2+y^2+z^2)^{-3/2}\\
&=(x^2+y^2+z^2)^{-3/2}+x(-3/2)(x^2+y^2+z^2)^{-5/2}(2x)\\
&=(x^2+y^2+z^2)^1
(x^2+y^2+z^2)^{-5/2}-3x^2(x^2+y^2+z^2)^{-5/2}\\
&=\frac{-2x^2+y^2+z^2}{(x^2+y^2+z^2)^{-5/2}}
\endeq
$$

<p>When you calculate all three pieces...
$$\begineq \myv\grad\cdot \myv F&=
\frac{1}{R^5}\left[\right.&(-2x^2+y^2+z^2)+\\
&&&(x^2-2y^2+z^2)+\\
&&&(x^2+y^2-2z^2)\left.\right]=0.\endeq$$


<p>...Everywhere that the function is defined, at least.  

<p>So, why does the surface integral come out to $4\pi$ instead of 0???

<p>It is <b>"as if"</b> $\myv \grad \cdot \myv F(0,0,0)=4\pi$.  All the "flux" in the volume is "spewing out" from that infinitesimal point, precisely where the function itself is undefined!
</div>


<p class="todo">
Check the divergence theorem for our function and box of 13.4.

<!--
<h3>Example</h3>
<p class="show"> &nbsp; &#x222f;${}_S \myv F \cdot \uv n dS = \iiint_E \myv \grad \cdot \myv F dV.$
<p class="show"><img src="0g/13.6.lilbox.jpg" class="rightalign">
For some function $\myv F=P\uv x+Q\uv y+R\uv j$...
<br><br>[Normal vectors?]
-->



<h3>Yukawa potential</h3>

Both the gravitational and electrical force can be derived from a potential function, $f$ that looks like:
$$f(\myv r)=C\frac 1r,$$
where $\myv F(\myv r)=-\myv \grad f(\myv r)$.
It turns out that
<p><b>Hideki Yukawa</b> generalized this potential to encompass nuclear forces as well, which pretty much have no effect beyond a range of order $10^{-15}$m
$$f(\myv r)=C\frac{e^{-r/r_0}}{r}$$
Each field has a <i>boson</i> which is the particle that "mediates" the field. Let $m_b$ be the mass of the boson.   Then Yukawa proposed that  $r_0$ is the "range" of the force and $r_0\propto 1/m_b$.

<ul><li>For electromagnetism, the particle is the photon, which is massless, so $e^{rm_b}\to 1$..
<li>For the gravitational field, the particle would be the graviton....
<li>For nuclear forces, Yukawa was proposing massive mesons.
</ul>


<p>It turns out that if you know the electric field, $\myv E$, you can find the charge density from:
$$\myv \grad\cdot\myv E=\rho(\myv r)/\epsilon_0.$$.






<?php include "../../classes/3.h" ?>