<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Chapter 9 - VECTORS and ANALYTIC GEOMETRY - Learning objectives
</title>
<meta name="week" content="1">
<?php include "../../classes/2.h"; ?>
<h2>Chapter 9</h2>
<h4>Learning objectives</h4>


<h3>Distance formula</h3>
<p class="show">The 2d Pythagoras' theorem is the distance  between two points $P=(x_1,y_1)$ and $Q=(x_2,y_2)$.
<p>Defining the differences $\Delta x \equiv x_2-x_1$ and $\Delta y \equiv y_2-y_1$, the length of the hypotenuse of a right triangle representing the distance is related to the point coordinates by: 
$$h^2 = (\Delta x)^2 + (\Delta y)^2$$

<p>In 3-dimensions, $P=(x_1,y_1,z_1)$ and $Q=(x_2,y_2,z_2)$.  The  Py"<b>three-d</b>"agoras' theorem gives the distance between the points as:
$$h^2 = (\Delta x)^2 + (\Delta y)^2 +(\Delta z)^2.$$


<h3>Vectors</h3>
<p class="show">Vector addition / subtraction / scalar multiple:  Geometrically (visually) and in terms of vector components.
<p>Two vectors are parallel if $\myv a=k\myv b$.  Perpendicular if $\myv a \cdot \myv b=0$.

<h3>Visualizing surfaces and curves: traces / contours / projections</h3>
<p class="show">
Be able to interpret a function of two variables, in terms of a graph of a surface
$f(x,y)=z$.  Be able to estimate the domain and range of such a function.


<p>The intersection of the plane $x=k$ with a surface in 3 dimensions is a curve called <b>an $x=k$ trace</b>.

<p>Be able to calculate and use $x=k$ traces, $y=k$ traces, and $z=k$ traces (or "contours" or "level curves") to envision a surface in 3 dimensions.  -AND- be able to go from a 3-d depiction of a surface to some likely traces.

<p>The projection of a curve $\myv r(x(t), y(t), z(t))$ is a two-dimensional graph obtained by ignoring one of the coordinates, and graphing the other two.  Be able to use projections to visualize and identify the equation for a curve.




<h3>Vectors: Dot product understandings</h3>
<ul><li>$\cos \theta$: "How parallel" are two vectors?
<li>Product of length of two vectors $\times$ "how parallel"?
$$\myv a \cdot \myv b = ab\cos\theta.$$
<li>a <b>scalar</b> number.
<li>Know how to calculate from Cartesian components
$$\myv a\cdot \myv b = a_xb_x +a_yb_y+a_zb_z.$$
And the <i>norm</i> or length of a vector, written as $|\myv a| \equiv a$, obeys:
$$\myv a\cdot \myv a =a^2=a_x^2 +a_y^2+a_z^2.$$
</ul>

<h3>Vectors: Cross product understandings</h3>
<ul>
<li>$\sin\theta$: "How perpendicular" are two vectors?
<li>Product of length of two vectors $\times$ "how perpendicular"
$$\myv a \times \myv b = ab\sin\theta \uv n$$
<li>a <b>vector</b> pointing in the $\uv n$ direction (given by right-hand-rule).
<li>Know how to calculate manually from components.

<li>Interpretation as the <b>area</b> of a parallelagram defined by $\myv a$ and $\myv b$.
</ul>

<p>$$\myv a \times \myv b \cdot \myv c$$
is the <b>volume</b> of the parallelipiped define by $\myv a$, $\myv b$, and $\myv c$.


<h3>Lines</h3>
<p>Two vectors, $\myv a$ and $\myv b$, are <b>parallel</b> if one is a non-zero, scalar multiple of the other:
$$\myv a =k\myv b$$
<p>The parametric equation for a line:
$$\myv r(t)=\myv r_0+t\myv v$$
<ul><li>A line parallel to a <b>direction vector</b> $\myv v$,
<li>passing through a point specified by the <b>position vector</b>, $\myv r_0$, a vector in standard position (with its tail at the origin).
<li>You can find the line through two points, $P=(p_1,p_2,p_3)$ and $Q=(q_1, q_2, q_3)$ by calculating the difference vector
$\myvv{PQ}
= \langle q_1-p_1, q_2-p_2, q_3-p_3\rangle$.  $\myv r_0$ can be either of the position vectors $\myv P$ or $\myv Q$, and the direction vector of the line can be any scalar multiple of $\myvv{PQ}$.
</ul>

<h3>Planes</h3>
<p class="show">
A plane can be determined by
<ul>
<li>a point $P_0$ in the plane and
<li>
 a <b>normal vector</b>, $\myv n$, which is <b>orthogonal</b> (normal) to the plane.
</ul>


<p>In pictures...<br>
<img src="0g/9.5.plane.jpg" class="rightalign">
<ul>
<li>$\myv r_0=\langle x_0, y_0, z_0 \rangle$ is a vector pointing at $P_0$.
<li>$\myv n = \langle\color{blue}a, b, c\color{black} \rangle$ is the normal vector.
<li>$\myv r=\langle x,y,z\rangle$: Some point in the plane, which must satisfy the condition that $\myv r -\myv r_0$ is perpendicular to $\myv n$:
</ul>

<p>With these definitions:
<p class="show def incremental"><b>Equations of a plane</b>:
$$\begineq \text{"vector" eq:}\ \ \ \ 0&=\myv n \cdot (\myv r-\myv r_0)\\
&=\langle \color{blue}a,b,c\color{black} \rangle \cdot \langle x-x_0,y-y_0,z-z_0\rangle\\
\text{"scalar" eq:}\ \ \ \ 0&=\color{blue}a\color{black}
(x-x_0)+\color{blue}b\color{black}(y-y_0)+\color{blue}c\color{black}(z-z_0)\rangle\\
\endeq
$$
</ul>

<h3>Intersections</h3>
<p>Putting together the material on points, lines, planes and traces... you should be able to find
<ul>

<li>The point of intersection of two lines (if they intersect)
<li>The point of intersection of a line and a plane
<li>The line which is the intersection of two planes.
<li>If two lines are parallel or intersect or are skew.
<li>If two planes are parallel or intersect.
</ul>

<h3>Derivatives and Integrals of vector functions</h3>
<p>A vector-valued function is a function whose output is a vector, $\myv r$, (usually a position vector)  with components that are functions of a single parameter, e.g.
$$\myv r(t)=\langle x(t), y(t), z(t)\rangle.$$
Such a function can trace out a path / curve / trajectory in space.

<p>The derivative  of such a function is:
$$\myv r'(t)\equiv \frac{d\myv r(t)}{dt}=\langle x'(t), y'(t), z'(t) \rangle.$$
The derivative is a vector which points in a direction  tangent to the curve at $\myv r(t)$

<p>Think of $\myv r(t)$ as the position of a particle moving in space, as a (parametric) function of time $t$.  The particle follows a <b>trajectory</b>, a curve or path in space parameterized by the variable $t$. Then we can interpret the derivatives of this function:
<ul><li>$\myv r'(t)\equiv\myv v(t)$ is the instantaneous <b>velocity vector</b><li>$\myv r'(t)$ points in a direction <b>tangent</b> to the path of the particle.
<li>The magnitude of the velocity vector,  $|\myv r'(t)|\equiv |\myv v(t)| \equiv v(t)$ is the <b>speed</b> of the moving particle.
<li>$\myv r''(t)\equiv \myv a(t)$ is the <b>acceleration vector</b> of the particle.
</ul>


<h3>Path length &amp; Curvature</h3>

<p>As a particle traverse a path $P$, parameterized as $\myv r(t)=\langle f(t), g(t), h(t)\rangle$ it traces out a path in space.  $s(t)$ represents the "arc length", or <b>distance along the path</b>, which the particle  travels between some initial time (often represented as "0") and some final time (often represented as "t").  Since distance = speed * time, the arc length function is the integral of $ds=v\,dt$:

$$ s(t) = \int_0^t v\,dt= \int_0^t \sqrt{\left(\frac{d f(t)}{d t}\right)^2 +\left(\frac{d g(t)}{d t}\right)^2 +\left(\frac{d h(t)}{d t}\right)^2
}\,dt.$$

Along the curve, the rate of the change of the arclength function with respect to the parameter $t$ (time) is the same as the speed if the vector function tracing out the path:
$$\frac{ds}{dt}=\left|\frac{d\myv r}{dt}\right|=\left|\myv r'(t)\right|.$$

The unit tangent vector is
$$\uv T = \frac{\myv r'}{|\myv r'|},$$
and the curvature, $\kappa$ is defined to be:
$$\kappa = \frac{d\uv T}{ds}= \frac{|\uv T'(t)|}{|\myv r'(t)|} .$$
The curvature of a circle of radius $a$ is $\kappa=1/a$.  So we can draw an "osculating circle" of radius $a=1/\kappa$ on the inside of any curve, at a point $P$ on a curve where the curvature is $\kappa$, and the circle will nestle nicely tangent to the curve at that point.

<p>There is an associated "normal vector", $\uv N$,
$$\uv N(t) \equiv \frac {\uv T'(t)}{|\uv T'(t)|}.$$
which is perpendicular to the curve at point $P$, and points towards the center of the osculating circle at $P$.

<h3>Particle motion interpretation</h3>
<p>If the parameter $t$ is time, then a vector function $\myv r(t)$ can be interpreted as the <b>position</b> of a particle at a time $t$. As $t$ goes forward, $\myv r(t)$ traces out the particle's <i>trajectory</i>, a curve through space.

Other implications<ul>
<li>$\myv r'(t)$ is the <b>velocity</b> $\myv v(t)$ of the particle.
<li>$\myv r''(t)=\myv v'(t)$ is the <b>acceleration</b> $\myv a(t)$ of the particle.
<li>$\kappa = |\hat T'(s)|/ds$ is the curvature, related to the radius of the <i>osculating circle</a> of radius $a=1/\kappa$.

<li>Taking the acceleration "apart" into  tangential and normal components.  (Tangential and normal to the trajectory of a moving particle.
</ul>
<?php include "../../classes/3.h" ?>