<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Multi-variable functions, 3-D coordinates, distance  [9.1] 
</title>
<meta name="week" content="1">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>


<h1>3-dimensional coordinate systems [9.1]</h1>
<p class="show">
<img src="0g/9.1.balloons.jpg" class="big"><br>
<h3>Locating objects in 3-dimensions</h3>

<p class="why show">In single-variable calculus, you can visualize the graph of a <b>function</b> by graphing $y\equiv f(x)$ vs $x$.<br><br>
We will visualize functions of 2 variables by graphing $z\equiv f(x,y)$ vs $x$ and $y$.

<p>You will become familiar with
<ul><li>points in 3-d,
<li>curves and lines in 3-d, which can be represented by 2-d visualizations on screens and pages,  equations, vector functions of 2 or more variables and parametric vector functions of one independent variable.
<li>planes and surfaces, which can often be represented by 2-d visualizations,  vector functions and parametric functions of 2 independent variables.
</ul>

<p>Calculus I and II were largely concerned with functions of one variable...

<p class="def show incremental"><b>A function of one variable</b> is  a <b>rule</b> that assigns exactly one real number (output) to each input real number.
<p>But we are interested in this course in functions that depend on <b>more than one variable</b>.

<p class="def"><b>A function of $n$ variables</b> is a <b>rule</b> that assigns exactly one real number (output) to each input ordered [pair / 3-tuple / 4-tuple .../ $n$-tuple] of real numbers.

<p class="todo">Come up with an example of some quantity (function) that depends on 2 or more independent variables.
<p>&nbsp;
<div class="todo">
<h4><a href="https://activecalculus.org/multi/S-9-1-Functions.html#exercises-1">Schlicker, 9.1 exercises</a></h4>
<p>7,*10*, 11a, 12ab
</div>

<p>We will want to visualize / graph / differentiate / integrate  these functions.  Sometimes it is straightforward to generalize what we did in single-variable calculus to multi-variable calculus.  Sometimes there are new challenges and new concepts that were not needed in single-variable functions.



</p>

<p>Today:
<ul class="else"><li><i>Right-handed</i> Cartesian coordinate systems
<li>Points in 3-D space
<li>Equations of planes
<li>Distance formula in 3 dimensions
<li>Equations of spheres
</ul>

<h3>Rectangular coordinates</h3>
<p class='show center'><img src="0g/9.1.rectanglesystem.jpg">
<p class="show">Also known as <b><a href="http://mathworld.wolfram.com/CartesianCoordinates.html">Cartesian</a></b> coordinates, after Renes Des<b>cartes</b>.
</p>
<ul>
<li>The three coordinate axes are <i>mutually orthogonal</i>, that is, at right angles to each other.
<li>The letters $x$, $y$, and $z$ are placed on the parts of each of the coordinate axes which are <i>positive</i>
</ul>
<p>Does it matter how we arrange the positive $x$, $y$, and $z$ axes?<br>
<div class="big">
<img src="0g/9.1.rectanglesystem.jpg" style="width: 220px">
<img src="0g/rectb.jpg" style="width: 220px">
<img src="0g/rectc.jpg" style="width: 220px">
</div>
<div class="todo">Two
<img src="0g/CHF_200_9_front.jpg" class="rightalign">of the arrangements have the property that one can be *rotated* in space to arrive at the other arrangement.  The other one can not be rotated into either of the other two arrangements.  <b>Which is the odd one out?</b><br><br>
It may help to hold three fingers of your hand at right angles, like this picture on the Swiss 200 Franc banknote.    Write 'x', 'y', and 'z' on your thumb, index, and middle finger and then move them around!  For some of the orientations above you can match up with your right hand (as pictured on the bill).  For some of the orientations you may have to use your left hand instead.
</div>
<p>We say that the two above that can be rotated into each other (with the same hand) have the same '<b>relative orientation</b>'.

<p>If you were to consider all possible permutations of $x$, $y$, and $z$ on the six different directions in the picture, you would find that there are only two possible <i>relative</i> orientations.  One is the right-hand orientation pictured, and the other is with the left hand.  
<p class="why"><b>Does it matter which one we pick?</b><br><br>
<b>Yes</b>:<br><br>
When we get to writing the cross product $\myv a \times \myv b$ in terms of the Cartesian components of $\myv a$ and $\myv b$ the formula for the product in one system will give us a vector which is exactly -1 times the product in the other system.

<p>So which one to pick?  Like driving on the right or the left, either one would be OK.  But it's simpler and safer if everyone agrees to do the same thing!<br>
<img src="0g/9.1.Dagen.H.jpg"><br>
<span class="caption"><a href="https://historyofyesterday.com/the-day-sweden-changed-the-traffic-direction-ae9c478b6e33">Sweden changed from driving on the left</a> to driving on right, 5 AM, September 3, 1967.</span>



<h3>Right-handed coordinate system</h3>
<p class='show center'><img src="0g/9.1.rh.jpg"><br>
Another way, besides carrying around a 200 franc not:
<ol>
<li>Take your <b>right</b> hand...
<li>Point your <b>straight fingers</b> in the <b>positive $\hat x$</b> direction.
<li>Rotate your hand so that you can <b>curl your fingers</b>* 
to point in the <b>positive $\hat y$</b> direction.
<li>Your <b>thumb</b> now points in the $\hat z$ direction.
</ol> 
<p class="show">* You need to be able to curl your fingers through an angle less than $180^o$.

<p class="justme">Try x and y, then x and z and y and z, and figure out which way the other axis points.</p>

<h3>To Do</h3>
<p class="todo">Go to <a href="https://geogebra.org/3d">GeoGebra.org/3d</a>. The <span style="color:blue">blue axis is the $z$ axis</span>. Using your <b>right hand</b>, figure out and identify by color which of the other two axes is $x$ and which one is $y$.

<p class="why"><b>...did I ask you to figure this out?</b><br><br>Your brain and eyes work together to easily (unconsciously) make sense of the 3-d world around you.  It is terrifically useful to take advantage of this system to imagine relations in 3-d space.  But the 2-d pictures on a textbook page or a computer screen can only <i>suggest</i> 3-d reality.  <b>Visualization</b> is a skill worth developing, to look at such a picture and be able to imagine it in 3-d.


<!--
<h3>To Do</h3>
<ul class="todo">
<li>Create a set of coordinate axes [pipecleaners]
<li>Do the <i>Visualizing the xyz coordinate system</i> worksheet (See <a
href="https://people.goshen.edu/~paulmr/physix/213/handouts/09.1.VisualizingXYZ.php">the "handouts" folder</a>):<br>
<b>Write down</b> which color is your $x$-axis, your $y$-axis, and your $z$-axis. 
</ul>
-->


<h3>Coordinates</h3>
<p class='show center'><img src="0g/9.1.coordinates.jpg">

<h3>Coordinate planes</h3>
<p class='show center'><img src="0g/9.1.planes.jpg">

<ul><li>Any point with an $x$-coordinate of zero is in the $yz$ plane.
<li>$y=0$  $\Rightarrow$ A point is in the $xz$ plane.
<li>$z=0$  $\Rightarrow$ A point is in the $xy$ plane.
</ul>

<h3>Geogebra</h3>
<p>All of these graph the same set of points.  The set of points forms a <i>surface</i> in 3 dimensions:
<ul>
<li><b>formulas for $(x,y,z)$:</b> <code>(x, y, x^2+y^2)</code>: Graphs all the points that have x-coordinate=$x$, y-coordinate=$y$, and z-coordinate=$x^2+y^2$.
<li><b>function definition:</b> <code>f(x,y) = x^2+y^2</code>: Graphs all the points with coordinates $(x,y,f(x,y)$. That is, $f(x,y)\equiv z$.
<li><b>an equation:</b><code>x^2+y^2-z = 0</code> or <code>z = x^2+y^2</code>: The surface consists of the points that satisfy the <b>equation</b> that you've typed in. 
</ul>
<h3 id="projections">Projections</h3>
<h4 class="show">...of points</h4>
<p class='show center'><img src="0g/9.1.projections.jpg">
<p class='show'>$S=(a,0,c)$ is the projection of $P$ onto the $xz$ plane.  All of these are equivalent ways to find this projection:
<ul><li>Find the <i>closest</i> point to $P$ on the $xz$ plane. -OR-
<li>Imagine a line from $P$ to the $xz$ plane that is perpendicular to the plane.  The intersection of that line with the $xz$ plane is $S$. -OR-
<li>Imagine a star that is so far away along the $y$ axis that its light rays appear to be mutually parallel, and all hitting the $xz$ plane at a right angle. $S$ is the <i>shadow</i> of point $P$ on the $xz$ plane.
</ul>

<p>$(0,b,0)$ is the projection of $P$ onto the $y$-axis.  These two of the above ways of thinking work for this projection:
<ul class="def">
<li>Find the <i>closest</i> point to $P$ on the $y$ axis. -OR-
<li>Imagine a line from $P$ to the $y$ axis that is perpendicular to the $y$ axis.  The intersection of that line with the $y$ axis is our projection.
</ul>

<h3>The space $\mathbb{R}^3$</h3>
<p class='show'>$\mathbb{R}\equiv$ the real numbers.

<ul>

<li>Cartesian Product:<br>
$\mathbb{R}^3\equiv \mathbb{R}\times\mathbb{R}\times\mathbb{R}=\{(x,y,z) | x,y,z\in \mathbb{R}\}$.
<li>Set of all <i>ordered</i> triples.
</ul>

<!--
<h3>To Do</h3>
<ul class="todo">
<li>
<i>Points in the xyz coordinate system</i> worksheet
</ul>
-->

<h3>Surfaces in $\mathbb{R}^3$</h3>
<p class='show center'><img src="0g/9.1.surf1.jpg"><br>
All points with coordinates $(a,b,c)$ where $c=3$ <br>
[and $a$ and $b$ can be anything]

<p class='show center incremental'><img src="0g/9.1.surf2.jpg"><br>

<p class='show center incremental'><img src="0g/9.1.surf3.jpg"><br>
All points with coordinates $(x,y,z)$ where $y=x$.
<p>Notice that $y=x$ is the definition of a <i>line</i> in 2-d with a slope of 1.  But here??
<p>Anything a bit deceptive about the picture above?</p>
<p class="justme">Should continue to values with x and y less than 0...</p>




<h3  class="justme">To Do</h3>
<ul  class="justme">
<li>Section 9.1 Group Work: Fun with Visualization [missing]
<li>Working with surfaces in 3D space  [missing]
</ul>

<div class="todo">
<h4><a href="https://activecalculus.org/multi/S-9-1-Functions.html#exercises-1">Schlicker, 9.1 exercises</a></h4>
<p>6
</div>


<h3>Distance</h3>
<p class="show">What is the distance $|P_1P_2|$ between two points $P_1(x_1,y_1,z_1)$ and $P_2(x_2,y_2,z_2)$ in three dimensional space?


<div class="todo">

<iframe src="https://www.geogebra.org/3d/pukzw5yn?embed" width="800" height="600" allowfullscreen style="border: 1px solid #e4e4e4;border-radius: 4px;" frameborder="0"></iframe>

With $\Delta x=x_2-x_1$, etc, you can imagine applying Pythagoras' theorem twice [<a href="https://www.geogebra.org/3d/pukzw5yn">at GeoGebra</a><!--, <a href="0g/9.1.distance.nb">9.1.distance.nb</a>-->]:
<br>
<img src="0g/9.1.distance.png"><br>
</div>

<ul class="else">
<li>The <span style="color:blue">blue line</span> is the hypotenuse of the triangle with legs $\Delta x$ and $\Delta y$:  It's length is $\sqrt{(\Delta x)^2+(\Delta y)^2}$.
<li>The <span style="color:green">green line</span> is our <b>distance</b>, and is the hypotenuse of the right triangle with legs of $\Delta z$ and the <span style="color:blue">blue line</span>.
</ul>
<p>So, our distance formula is:
<a href="#d" onclick="toggle_visibility('ad');">show / hide</a>
<div id="ad" class="result toggle">
<p>$$|P_1P_2|=\sqrt{(x_2-x_1)^2+(y_2-y_1)^2+(z_2-z_1)^2}.$$
</div>



<h4>Equation of a sphere</h4>
<p>All the points on a <b>sphere</b> are the same distance, $r$, away from its center, $C(h,k,l)$. Using the distance formula:

$$(x-h)^2+(y-k)^2+(z-l)^2 = r^2.$$


<div class="todo">
<p>For any of the equations below: The <i>set of points</i>,$\{(x,y,z)\}$ that satisfies the equation forms a surface in 3 dimensions.
For each equation, make a guess at the surface corresponding to the equation, then check it by typing the equation into <i>GeoGebra</i>:  [Hint, think about what the distance formula implies.]
<ol>
<li>$$ 9=x^2+y^2+z^2.$$
<li>$$z=\sqrt{ 9-x^2-y^2}.$$
<li>$$9=x^2+y^2.$$
</ol>
</div>

<div class="justme">
<h3>Problem 9.1.038</h3>
<p>Consider a 2-d variation of this problem...<i>Find all the points, $P$, (they form a circle) that are twice as far from $A$ as they are from $B$.</i>
<br>
<img src="0g/9.1.038.jpg"><br>
Well... It ought to be possible to find *some* of the points $P$.  Consider these (leading) questions:

<ol><li>How would you find the coordinates of a point which is <i>halfway</i> between $A$ and $B$?
<li>One of the points in the set $\{P\}$ should be on the line segment between $A$ and $B$.  <i>What fraction of the distance</i> from $A$ to $B$ is that point?
<li>What are the coordinates of that point?
<li>There is one other point in $\{P\}$ along the red line, but not between $A$ and $B$.  What fractional distance would it be?  That is... if the distance from $A$ to $B$ were 1, what would the distance from $A$ to this second point be?

<li>Now we have a segment of the red line that connects two points on a circle.  <i>Either</i> the line segment is a diameter line, or it is not.
Can you make an argument for why the center of the circle could, or could not be away from the line segment?
<li>So, where is the center of the circle? And what is its radius?
</ol>
</div>

<p>
<div class="todo">
<h4><a href="https://activecalculus.org/multi/S-9-1-Functions.html#exercises-1">Schlicker, 9.1 exercises</a></h4>
<p>5, 8, 9
</div>




<h4>Image credits</h4>
<p class="handout"><a href="http://www.flickr.com/photos/71651012@N00/3758383978">Mortimer</a>
<?php include "../../classes/3.h" ?>
