<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
MV functions: domains and traces / contours  [9.1] 
</title>
<meta name="week" content="2">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>


<h1>Functions of two variables</h1>
<p class="show">A <b>function $f$ of two variables</b> is a
<b>rule</b> that assigns to each ordered pair of real numbers $(x,y)$
in a set $D$ a <i>unique</i> real number denoted by $f(x,y)$.

<p class="show">In this topic we'll look at:
<ul class="else"><li>dentifying the domain (and range) of functions of 2 variables.
<li>Traces and contours / contour plots - visualizing functions of 2 variables.
</ul>

<h2>Domains</h2>

<h3>$f(x,y)$ in tabular form</h3>

<p class="show">$h(v,t)$: A table of <span style="color: #0ce;">wave
height, <i>h</i></span> (in feet)  which depends, in the open ocean, on the speed, $v$, (in knots) of the wind and how long, $t$, (in hours) it's been blowing.<br>
<img src="0g/9.6.waveheight.jpg"><br>
[October, 2013 -- <a href="http://www.theguardian.com/world/2013/oct/12/indians-flee-coast-cyclone-phailin-landfall">Cyclone Phailin hits east India</a>]

<h3>Domains - graphically</h3>

<ul class="else">
  <li>The set $D$ is the <b>domain</b> of the function $f$.
  <li>The <b>range</b> of $f$ is the set of values that $f$ takes on, that is, the set:  $\{f(x,y)|(x,y)\in D\}$.
</ul>
<p>Often we write such a relation in terms of a dependent variable $z\equiv f(x,y)$ which is a function of the two independent variables $x$ and $y$.

<p><img src="0g/9.6.graphoff.jpg"><br>
If $f$ is a function of two variables with domain $D$, then the <b>graph</b> of $f$ is the set of all points $(x,y,z)$ in $\mathbb{R}^3$ such that $z=f(x,y)$ and $(x,y)$ is in $D$.

<div class="todo">
<h4><a href="https://activecalculus.org/multi/S-9-1-Functions.html#exercises-1">Schlicker, 9.1 exercises</a></h4>
<p>4, 17a and <a href="https://activecalculus.org/multi/S-9-1-Functions.html#A-9-1-1">Activity 9.1.2*</a>
</div>

<h2>Traces</h2>

<p>Consider a ball launched from "floor level".  Let's assume it's launched with speed $x$ (m/s) at an angle $y$ (radians) above horizontal. To the extent that we can neglect air resistance, the horizontal distance (in meters) that the ball travels, under the influence of the earth's gravity ($g=9.8$ m/s^2) before again landing at floor level is  this function of the launch speed and angle:
$$f(x,y)=\frac{x^2\sin y}{9.8}.$$
If we take the $z$ coordinate to represent $f(x,y)$, then the graph of the points which satisfy this equation $z=\frac{x^2\sin y}{9.8}$ forms a 3-d surface that looks like this:
<br>
<img src="0g/9.1.11.svg" style="height:350px;">
<br>

<p>If we wanted to <b>visualize</b> what this surface looks like without resorting to snazzy plotting programs, a common technique is to set one of the variables to a constant value, and then see what the resulting 2-d graph looks like.  For example:


<p><img src="0g/9.1.11.x.svg" class="leftalign">An <b>x=150 trace</b>: What happens if consider only launching the ball with an initial speed of $x=150$ m/s, but than ask how changing the angle $y$ affects the horizontal distance travelled, $z$?   We substitute 150 in for $x$ in our equation, and are left with a function of just one variable $z(150,y)=\frac{150^2\sin(2y)}{9.8} \approx 2300\sin(2y)$.  This is a sine function which is 0 when $y=0$ or $y=\pi/2$, and reaches a maximum value when $y=\pi/4=45^{0}$. The graph of this $z(y)$ is the red line on the surface graph shown.

<p><img src="0g/9.1.11.y.svg" class="leftalign">A <b>y=0.6 trace</b>: What happens if consider only launching the ball at an initial angle of $y=0.6$ radians, but than ask how changing the launch speed $x$ affects the horizontal distance travelled, $z$?   We'll consider
$z(x,0.6)=\frac{x^2\sin(2\cdot0.6)}{9.8} \approx $.  This is a parabola with it vertex at $x=0$.  The distance, $z$, is proportional to  $x^2$, the square of the initial speed.
The graph of this $z(x)$ is the red line on the surface graph shown.

<h4>Trace as intersection with a plane</h4>
<p>We know that $x=0.6$ is the equation of a plane, consisting of all of the points in 3-d space with an $x$-coordinate of 0.6.  This is a plane parallel to the $y-z$ plane at $x=0$.  So we might call it "a" $y-z$ plane at $x=0.6$

<div class="def incremental show">
<h4>An $x=k$ trace</h4>
<p>For the surface specified by $f(x,y)$, An $x=k$ trace can be thought of as either:
<ul><li>The 2-d graph of $z(y)\equiv \left.f(x,y)\right|^{x=k}=f(k,y)$, -OR-
<li>The curve traced out by the intersection of the surface $f(x,y)=z$ with the plane $x=k$.
</ul>
</div>

<p>I think you can see how to change this, to define a $y=k$ trace.

<h4>Graphing surfaces with Geogebra</h4>
<p>Here's a <a href="https://www.geogebra.org/3d/fw7ztf8c">geogebra graph of the surface $z(x,y)=\frac{x^2\sin(2y)}{9.8}$</a>.  There are at least two ways to graph a function in Geogebra:
<ul><li>Simple: as an <b>equation</b> connecting 1 or more of $x$,$y$ and $z$ which all the points to be graphed must satisfy. For example:
<tt>x^2+y^2=9</tt><br>
or<br>
<tt>z=x^2*sin(2*y)/9.8</tt>
<li>More control: as a <b>parametric plot</b>, specifying equations for $x$, $y$, and $z$ in terms of two independent variables, with limits on their values:<br>
 &nbsp; <tt>Surface(3,y,z,y,-5,5,z,0,5)</tt><br>
or<br>
 &nbsp; <tt>Surface(<span style="color:red">x</span>,<span style="color:green">y</span>,<span style="color:blue">x^2*sin(2*y)/9.8</span>,<span style="color:red">x,0,250</span>,<span style="color:green">y,0,pi/2</span>)</tt><br>
NOTICE that geogebra changes $x\to u$, and $y\to v$ to "coordinate-agnostic" parameters $u$ and $v$.  You are free to specify the points belonging to the surface as $(x(u,v), y(u,v), z(u,v))$.  
<xdiv class="big"<iframe src="https://www.geogebra.org/3d/fw7ztf8c?embed" width="800" height="600" allowfullscreen style="border: 1px solid #e4e4e4;border-radius: 4px;" frameborder="0"></iframe>
</xdiv>
</ul>
<div class="todo">
<ol>
<li>Open the geogebra drawing of our surface at the link above.
<li>Open the left-hand panel (click on "algebra" if it's not open).
<li>In a new cell, add the equation which defines the $x=150$ plane as <tt>x=150</tt>.  Observe the intersection of the two surfaces.
<li>Delete the cell you just created (go to its hamburger menu).
Then add the equation for the $y=0.6$ plane. Does this match the graph in the notes?
<li>Now add a slider in a new cell, called $k$. Start by typing <tt>k=slider(</tt>.  You should see some hints of how to specify a minimu and maximum value.  Set things up so that $0\lt k \lt \pi/2$.  Finally, set up a cell with $y=k$, to control the value of the plane with your slider.
</ol>
</div>

<div class="todo">
<h4>More practice with traces</h4>
<p>For the function...
$$\nonumber z=f(x,y)=y^2-x^2$$
<ul><li>Describe what the $x=k$ traces look like.
<li>Describe what the $y=k$ traces look like.
<li>Can you picture what the surface looks like??
<li>Graph the surface in geogebra.
</ul>


<h4><a href="https://activecalculus.org/multi/S-9-1-Functions.html#exercises-1">Schlicker, 9.1 exercises</a></h4>
<p>12, 13, 15
</div>


<!--
<p>
<img src="0g/9.6.traces1.jpg">
<br><img src="0g/9.6.traces2.jpg">
<p>We can also view an $x$-trace as the intersection of the surface $x=f(x,y)$ with one of the planes $y=k$.<br><br>
We can also view a $y$-trace as the intersection of the surface $x=f(x,y)$ with one of the planes $x=k$.
<p>Try adding a plane <tt>y=k</tt> <a href="https://www.geogebra.org/3d/cfwzp75q">on GeoGebra</a> to see an $x$ trace.
-->


<h3>Level curves and contour plots</h3>
<p class="show">Maybe it occurred to you to look at what the intersection of a $z=k$ plane looked like with either of the surfaces above?
<p>Sure! Why not?!  We could call this is a $z=k$ trace.
<p class="show center incremental"><img src="0g/9.6.reichskuppel.jpg"><br>
<i>The dome atop the <a href="https://en.wikipedia.org/wiki/Reichstag_building#/media/File:Berlin_-_Reichstag_building_at_night_-_2013.jpg">German Reichstag (Parliament)</a> in Berlin.</i> The original dome was burned by the Nazis 
in the run-up to their takeover of the democratic Weimar Republic.  Some parallels with the U.S.  Jan 6 moment!  This replacement dome was completed after German reunification (finished in 1999).
<p class="todo">What would some $z=k$ traces of the surface of the Reichskuppel look like?

<h4>Contour plots</h4>
<p><img src="0g/topo.gif"><br>
<span class="caption">The top of this figure is a contour plot (several labelled $z=k$ traces.  The bottom is a single $y=k$ trace.</span>
<p>A single $z=k$ trace of a surface is also called a <b>contour</b>.
<p>Probably some of you are familiar with a <b>contour plot</b>
which is  a set of contours, which each contour labelled with the value $k$ it represents.

<p>Hikers love "topographic maps".  This is a 2-d (paper or phone screen) representation of the surface of earth, where $k$ usually represents the height of Earth's surface (in meters or feet) above sea level.

<p><b>To calculate a contour</b>: You would set $f(x,y)$ equal to a particular k, and solve for $y(x)$.  For example, for our surface $z=x^2-y^2$, pick $z=k=9$, and consider $9=x^2-y^2$.  Solving for $y$, we get
$$\nonumber y=\pm\sqrt{x^2-9}$$ which looks like...
<br><img src="0g/kEqual3.png">

<div class="todo">
<h4><a href="https://activecalculus.org/multi/S-9-1-Functions.html#exercises-1">Schlicker, 9.1 exercises</a></h4>
<p>2, 3, 8, 15, 17, <a href="https://activecalculus.org/multi/S-9-1-Functions.html#A-9-1-8">Porcupine mountain</a>* (Their contour plot is hard to read, You can use this <a href="https://www.google.com/maps/place/Porcupine+Mountains/@46.7801754,-89.7348473,15.43z/">Google map centered on a point somewhere in the Porcupine Mountains</a> instead.  Just switch to the Terrain view if the contours are not showing.)
</div>

<h4>Image credits</h4>
<p class="handout"><a href="http://www.flickr.com/photos/71651012@N00/3758383978">Mortimer</a>
<?php include "../../classes/3.h" ?>
