<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Vector-valued functions [9.6]
</title>
<meta name="week" content="4">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h2>Vector functions [9.6]</h2>
<p class="show">Curves in space.
<p class="show center"><img src="0g/10.1.bless-soyuz.jpg"><br>
<i>Blessing of the media, Soyuz launch 2013 [<a href="http://www.flickr.com/photos/nasahqphoto/8851892423">NASA</a>]</i></p>
<p class="show key">A <b>curve in space</b> can be described as the path of the tip of a <i>position vector</i> $\myv r(t)$:
$$\myv r(t)=\langle x(t), y(t), z(t)\rangle,$$
which is a function of a <i>single parameter</i>.


<h3>For example: A line</h3>
<p class="show">Animation of the parametric equation,
$$\begineq\myv r(t)&=(-1.34,1.32, 0)+t \langle 2/3,-1/3,2/3 \rangle\\
&=(-1.34,1.32, 0)+t \myv v
\endeq$$
of a <b>line</b>.  We'll often use a parameter named $t$ or $k$.
<div class="big show">
<iframe src="https://www.geogebra.org/3d/uygtvv56?embed" width="800" height="600" allowfullscreen style="border: 1px solid #e4e4e4;border-radius: 4px;" frameborder="0"></iframe>
</div>



<h3>Parametric vector functions</h3>
<p class="show">
But we're not limited to lines.  Consider the animation of the equation for the position vector $\myv r(t)$:
$$\myv r(t)= \langle  \cos t, \sin 2t, 0.3+\sin(t)\cos(t) \rangle$$

<div class="show big">

<iframe src="https://www.geogebra.org/3d/y4kr7rak?embed" width="800" height="600" allowfullscreen style="border: 1px solid #e4e4e4;border-radius: 4px;" frameborder="0"></iframe>

</div>
<p>The <b>position</b> of an object in 
3-d, as a function of time, 
$\myv r(t)$ is an example of a <b>vector function</b>.<br>
<img src="0g/10.1.roft.jpg">
<p class="todo">In GeoGebra type (or copy and paste): <code>(sin(t),cos(t),sin(t) cos(t))</code> and notice the curve that appears, and the way GeoGebra changes what you've typed in, and adds some default values...


<h3>Vector functions and parametric equations</h3>
<p class="show">Consider the 2-d vector function:
$$\myv r(t)=\langle t,t^2\rangle$$
<ul>




<li>
$\myv r(t)=\langle t,t^2 \rangle$
<li>$x(t)=t;\ \ \ y(t)=t^2$
<li><img src="0g/10.1.quadratic.jpg" class="rightalign">In this case we can write $y$ as a function of $x=t$:
$$\nonumber y=x^2$$
and we know what that looks like...
</ul>


<p><b>In GeoGebra</b>: we can make parametric plots, by specifying functions for the $x,\ y$ and $z$ coordinates of a position vector in terms of a common parameter, for example, the parameter $t$, like this
<p align="center"><code>( [x(t)], [y(t)], [z(t)] )</code>
<p>For example
<ul><li><code>(t,t^2,0)</code> is a parametric plot, where $x(t)=t;\ y(t)=t^2;\ z(t)=0$, where $t$ runs over all possible values.
<li><code>Curve(t,t^2,0,  t,0,10)</code> is a portion of the parametric plot above, limited to a restricted domain of parameter values: $0 \lt t \lt 10$.
></ul>
<p>Try it out!


<h3 id="polar">Parametric plotting of expressions in polar coordinates</h3>
<p class="show">Remember polar coordinates?<br>
<img src="0g/polarcoordinates.png"><br>
Going from Cartesian coordinates, $(x,y)$ to polar coordinates:
  $$r=x^2+y^2;\ \ \ \ \theta=\arctan\left(\frac yx\right),$$
and the other way...
  $$x=r\cos\theta;\ \ \ \ y=r\sin\theta$$
It is frequently useful to remember that
  $$\sin^2\theta+\cos^2\theta=1.$$


<h3>Finding a "parameterization" of a curve</h3>

<p>A common problem is:
<p class="def">Given an equation for a curve, say $x=y^2$ or $x^2+y^2=4$... Can you find a way to <b>parameterize</b> the equation?  That is, express it in terms of parametric expressions for each of the coordinates, $\langle x(t),y(t)\rangle$?
<p>For examples above....
<ul><li>E.g. $x=y^2$: If one coordinate is given in terms of the other...Let one of the coordinates be the parameter:
$$ y(t)=y; \ \ \ x(t)=t^2 .$$
<li>E.g. $x^2+y^2=4$.  Use some geometrical relationship:  We know that this is the equation for a circle of radius 2.  We can use polar coordinates to describe the the coordinates of the points on the circle in terms of the angle $\theta\to t$:
$$ x(t)=2\cos t; \ \ y(t)=2\sin t;\ \ 0\lt t \lt 2\pi $$



<p>GeoGebra expects you to specify functions in terms of Cartesian coordinates anyway, and implicitly assumes that the name of your parameter will be '$t$'. So,
<p class="show incremental" align="center"><code>( 2*cos(t), 2*sin(t), 0 )</code>
<p>Will plot a circle in the $xy$ plane of radius 2.

<p class="todo">Can you imagine what these functions look like?<br><br>
Guess first, and then plot in Geogebra to confirm:
$$\myv r(t)=\langle t\cos t, t\sin t, 0\rangle?$$
$$\myv r(t)=\langle \cos t, \sin t, t\rangle?$$

<p class="todo justme">Do <a href="https://activecalculus.org/multi/S-9-6-Vector-Valued-Functions.html#A_9_6_4">the 'paraboloid' activity (9.6.4)</a>.

<br>c.) Use polar coordinates to parameterize this curve in terms of $\theta=t$. 
<br>d.) To find the level curve for $z=25$, use polar coordinates to parameterize in terms of $t=\theta$.  But what to make of their hint???  Instead: Convert $x$ and $y$ to polar coordinates; and then substitute $\cos^2 \theta\to 1-\sin^2\theta$.  Now solve for $r(\theta)$. There's a square root.  What angles is $r(\theta)$ defined for?  For what 4 angles does $r(\theta)\to \infty?$  Now evaluate $r(0)$ and $r(\pi)$ and sketch $r(\theta)$.

<h3>Plotting and visualizing curves in 3 dimensions</h3>
<p>Consider this curve:
$$\myv r(t)=\langle \cos t, \sin t, t\rangle\nonumber$$
If we *ignore* the $z$ coordinate (or, think of just setting it to 0), we'll have this simpler parametric equation: $\myv r(t)=\langle x(t),y(t)\rangle = \langle \cos t, \sin t \rangle$.  You might recognize this as the equation for the unit circle.  The tip of the vector will trace out all the points on a circle of radius 1 as $0 \lt t \lt 2\pi$.

<li>So in 3-d, the path traced out by $\myv r(t)$ must lie on the surface of the <i>cylinder</i> $x^2+y^2=1$<br>
<img src="0g/10.1.helix.jpg">
</ul>


<p>This process of ignoring one coordinate, and seeing how 2 of the coordinates relate to each other without regard to the other one is "<b>projection</b>". Doing this with the other coordinate pairs, we see the familiar-looking relations:
$$\nonumber x=\cos z;\ \ \ y=\sin z$$

<p>
<img src="0g/10.1.helixprojection.jpg">



<h3>To Do</h3>
<ul class="todo"><li>Handout: 09.6.ProjectionsOfCurves
</ul>

<h3>Intersections and projections</h3>
<p>Consider
$$\myv r(t)=\langle t,t^2,t^3 \rangle \nonumber$$
<p>
Since $y(t)=t^2$ and $x(t)=t$ we can combine these equations to get $$\nonumber y=x^2.$$

<p>And similarly 
$$\nonumber z=x^3,$$
 so we could plot the 3-d surfaces
<ul><li>$y=x^2$ (for any $z$), and
<li>$z=x^3$ (for any $y$)
</ul>
 
<p><img src="0g/10.1.intersect.jpg" class="rightalign">The points in $\myv r$ need to be on *both* of those surfaces, so we could look for $\myv r$ as the intersection of the surfaces.<br><br>
<!--See: <a href="0g/10.1.tt2t3.nb">tt2t3.nb</a><br>-->

<h4>Projections of $\langle t,t^2,t^3 \rangle$
<p><img src="0g/10.1.traces.jpg" class="big">




<?php include "../../classes/3.h" ?>