<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Derivatives and integrals of vector functions [9.7]
</title>
<meta name="week" content="4">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h2>Derivatives and integrals of vector functions [9.7]
</h2>
<img src="0g/10.2.rollercoaster.jpg">

<h3>Derivatives</h3>
<p class="show">In Calc I, we defined the derivative as the limit of a  "Difference Quotient":
$$f'(x)=\lim_{h\to 0} \frac{f(x+h)-f(x)}{h}.$$

<p class="show def">For a vector function, $\myv r(t)$, there's a similar difference quotient:
$$\frac{d\myv r}{dt} \equiv 
\myv r'(t) = \lim_{h\to 0} \frac{\myv r(t+h)-\myv r(t)}{h}.$$

<p class="show">
<img src="0g/10.2.dr.jpg" class="center">

<p>
In the limit $h \to 0$, $\myv r'(t)$ is a <b>vector</b> which is <b>tangent</b> to the curve at $\myv r(t)$.<br>
<img src="0g/10.2.rprime.jpg" class="center"><br>
<img src="0g/10.2.tangentv.jpg" class="big">
<p>Try out this <a href="https://www.geogebra.org/3d/tx5qthn6">Difference Quotient (DQ) visualization</a> (GeoGebra).<br><br>
When $t=2.5$,<br>
points $P$ and $Q$ are points at the tip of position vectors:
$$P=\myv r(2.5); \ \ \ Q=\myv r(2.5+h)\nonumber.$$
The difference vector is:
$$\color{blue}\mathsf{diff}=\myvv{PQ}=\myv r(2.5+h)-\myv r(2.5)$$
and the difference quotient is:
$$\color{red}\mathsf{DQ}=\frac{\mathsf{diff}}{h}=\frac{\myv r(2.5+h)-\myv r(2.5)}{h}$$
and the derivative is
$$\left.\myv r'(t)\right|^{t=2.5} = \lim_{h\to 0}\frac{\myv r(2.5+h)-\myv r(2.5)}{h}.$$

<h3>Differentiation - components</h3>
<p class="show def">A theorem: if $\myv r(t)=\langle f(t),g(t),h(t)\rangle = 
f(t)\uv i+g(t)\uv j+h(t) \uv k$, where $f$, $g$, and $h$ are differentiable functions, then
$$\myv r'(t)=\langle f'(t),g'(t),h'(t)\rangle = f'(t)\uv i+g'(t)\uv j+
h'(t)\uv k.$$

<p class="todo">Do <a href="https://activecalculus.org/multi/S-9-7-Vector-Valued-Functions-Derivatives.html#A_9_7_2">9.7.3, Calculating derivatives</a>, a. and d.


<h3>Differentiation rules</h3>
<p class="show">
<img src="0g/10.2.rules.jpg" class="big">


<div class="def show incremental">
if $t$ represents time, and $\myv r(t)$ represents the position of an object, then...
<ul><li>$\myv r'(t)\equiv \myv v(t)$<br>
The first derivative of position with respect to time, $t$,<br>
is the object's <b>velocity</b>, $\myv v(t)$.
<li>$\myv r''(t)=\myv v'(t)\equiv \myv a(t)$<br>
The second derivative of position  wrt $t$, <br>
is the first derivative of velocity wrt $t$,<br>
is the  object's <b>acceleration</b>, $\myv a(t)$.
</ul>
</div>

<p class="todo">Do <a href="https://activecalculus.org/multi/S-9-7-Vector-Valued-Functions-Derivatives.html#A_9_7_8">A 9.7.4, velocity and acceleration</a>

<h3>Cusp?</h3>
<p class="show">
A vector function $\myv r(t)=\myc{f(t),g(t),h(t)}$ might have a 
<b>cusp</b> if, at some time $t$ exists such that $\myv r'(t)$ is a <b>zero vector</b>.
<p><img src="0g/10.2.cusp.jpg" class="rightalign" style='border: 1px solid #666'>At right: $\myv r(t)=\myc{t^2-4t,e^{t-2}-t}$, so
$\myv r'(t)=\myc{2t-4,e^{t-2}-1}$.
<p>And... $\myv r'(2)=\myc{0,0}$.



<h3>Tangent lines</h3>
<p class="show"><img src="0g/10.2.rprime.jpg" class="center">

<p>
The line, $L$,  tangent to the curve at $\myv r(t_0)$ is:
$$\myv L(t) = \myv r(t_0) + t \myv r'(t_0).$$

<p class="todo">
Do <a href="https://activecalculus.org/multi/S-9-7-Vector-Valued-Functions-Derivatives.html#A_9_7_4">A 9.7.5, Tangent line</a>.  Use Geogebra to graph $\myv r(t)$.  Put a point at $\left.\myv r(t)\right|^{t=\pi}$.  Calculate $\myv r'(t)$ by hand.  Then plot the vector $\left.\myv r'(t)\right|^{t=\pi}$, with its tail at $\left.\myv r(t)\right|^{t=\pi}$.





<p>The <b>unit tangent vector</b> is given by:
$$\uv T(t) = \frac{\myv r'(t)}{|\myv r'(t)|}.$$

<p class="show incremental def"><b>Theorem</b>: If a vector function, $\myv r(t)$, has constant length, then its derivative, $\myv r'(t)$, is perpendicular to $\myv r(t)$.

<p><b>Proof:</b><br>
<ol>
<li>We're assuming that the length of $|\myv r(t)|$ is not changing.  That is,
$$\frac{d}{dt}|\myv r(t)|=0.$$
<li>Then,  (length)${}^2$ is also unchanging:
$$\begineq 0&=\frac{d}{dt}|\myv r(t)|^2\\
 &=\frac{d}{dt}(\myv r\cdot\myv r)=\myv r'\cdot \myv r+\myv r\cdot\myv r'\\
0  &=2\myv r'\cdot \myv r\\
\endeq
$$
<li>Since the dot product of $\myv r'$ and $\myv r$ is zero, <span class="answer">$\myv r' \perp \myv r$</span>.
</ol>

<p>Example: $\myv r(t)=\langle cos(t),sin(t)\rangle$.  Taking the derivative of its component functions...
$$\nonumber \myv r'(t)=\langle -\sin(t),\cos(t)\rangle.$$
The magnitude of this derivative vector is
$$|\myv r'(t)|=\sqrt{(-\sin t)^2+\cos t)^2}=\sqrt{\sin^2 t+\cos^2 t} = 1.$$
We see that the magnitude of the derivative is a constant (not changing with $t$).

<p>See <a href="https://www.geogebra.org/3d/ue23pquz">Circular motion</a> (GeoGebra)


<h4>The unit tangent</h4> 
<ul>
<li>The Unit Tangent $\uv T(t)=\frac{\myv r'(t)}{|\myv r'(t)|}$
 has constant length 1.
<li>The only characteristic of $\uv T(t)$ that changes as $t$ changes is its direction.
<li>$|d\uv T/dt|$ measures the <b>rate of change of the <i>direction</i></b> of the unit tangent vector. ["units" are radians per $t$-unit].
</ul>

<p>Example: $\myv r(t)=\langle t^3,t^6\rangle$


<h2>Integrals</h2>


<p class="show def">
$$\begineq \int_a^b \myv r(t)\,dt
 &= \int_a^b \langle f(t),g(t),h(t)\rangle\,dt\\
&= \left(\int_a^b f(t)\,dt\right)\uv i +
\left(\int_a^b g(t)\,dt\right)\uv j +
\left(\int_a^b h(t)\,dt\right)\uv k\\
\equiv& \myv R(t).
\endeq
$$
<p>These are the components of $\myv R(t)$, the anti-derivative of $\myv r(t)$:
$$\int_a^b \myv r(t)\,dt = \left.
\myv R(t)\right|_a^b = \myv R(b)-\myv R(a). $$
And $\myv R'(t)=\myv r(t)$.


<h3>To do</h3>
<p class="todo show">Do (in the mvhandouts folder) 09.7.GrimReaper - the grim reaper.



<h2>Projectile motion</h2>
<p class="show"><img src="0g/10.4.projectile.jpg" class="rightalign"><br>
Acceleration due to gravity is constant, and always *down*.

<p>Newton's law, $\myv F=m\myv a$:  The only force acting on the projectile is gravity.  The gravitational force is the object's weight, $mg$ (where $g=9.8$ m/s${}^2$). 
$$\myv F=
m(a_x(t) \uv i+a_y(t) \uv j=-mg \uv j =\myc{ 0, -mg}.$$

<p>Assuming that a projectile is launched at $t$ from the origin in the diagram above, we have:
$$\myv r(0)=\myc{0,0}$$
$$\myv v(0)=\myc{v_0\cos\alpha,v_0\sin\alpha}.$$

<p>In the vertical direction ($\uv j$ component) this becomes:
$$-g=a_y(t)=v_y'(t)$$
Integrating as above and saying that $t=0$ is the time of launch (so that $v_y(0)=v_0\sin\alpha$
and $v_x(0)=v_0\cos\alpha$) we get:

$$v_y(t)=v_0\sin\alpha-gt.$$
Integrating once more, as above, gives:
$$y(t)=(v_0\sin\alpha) t-\frac12gt^2.$$


<p>Going through a similar process, the horizontal position is found to be:
$$x(t)=(v_0\cos\alpha) t.$$


<h4 class="handout">Image credits</h4>
<p class="handout"><a href="https://www.flickr.com/photos/dirkjankraan/5207612942">Dirk-Jan Kraan</a>

<?php include "../../classes/3.h" ?>