<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Arc length [09.8]
</title>
<meta name="week" content="4">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
Arc length (and curvature) [9.8]
</h1>
<p class="show center"><img src="0g/10.3.Nowitna.jpg" class="big"><br><i>The Nowitna river (Alaska) - How long is it?</i>
a
<ul class="else">
<li>Calculating arclength and curvature
<li>Arclength is independent of  the choice of parameter used to describe a curve.
<li>Re-parameterizing a curve - using the <b>arclength as the parameter</b>.
<li>Geometric definition of curvature.
<li>The TNB frame (Tangent - Normal - Binormal unit vectors).
<li>Tangent and Normal components of acceleration
</ul>

<h2>Arclength</h2>
<p class="show why">You know some special-case formulas for calculating the distance along a straight line between 2 points, or the perimeter of a circle.<br><br>

But now that you know how to describe *any* continuous curve in space with parametric equations, we'll develop a general way to integrate to find the distance along *any* continuous curve in space.
<p>$\myv r(t)$ is a vector function.
$$\myv r(t)=\langle f(t),g(t),h(t)\rangle\nonumber;
\ \  t_i\leq t\leq t_f.$$
where $\myv r(t_i)=\myv a$ and $\myv r(t_f)=\myv b$
The tip of the <b>position vector</b> $\myv r(t)$ traces  a curve (trajectory) in space which
looks schematically like:<br>
<img src="0g/10.3.arclength.jpg">
<ul><li>The <b>arclength</b> is the distance <i>along the curve</i> from $\myv a$ to $\myv b$.
<li>Arclength is a <b>scalar</b>.
<li>It is <b>not the distance</b> "as the crow flows" of a vector starting at $\myv a$ and terminating at $\myv b$.
<li>$\myv a\equiv \myv r(t_i)$ and $\myv b\equiv \myv r(t_f)$.
</ul>

<p>The arclength from $\bf{a}$ to $\bf{b}$ is approximately equal to the sum of the <style="color:pink">pink</a> segments:
$$\text{arclength}\equiv L \approx \sum \Delta L\nonumber.$$

<p>The derivative $\myv r'(t)$ is a vector tangent to the curve.  Its magnitude is the "speed" of a particle moving in time, $t$,  according to $\myv r(t)$.  <br><br>

Since distance = speed (times) time, we can approximate the distance $\Delta L$ moved in a time interval $\Delta t$ as
$$ \Delta L \approx \left| \myv r'\right| \Delta t\nonumber$$
<p>So, the arclength is approximately
$$L\approx \sum |\myv r'(t)|\Delta t\nonumber.$$

In the limit of ever smaller $\Delta t\to dt$, the sum approaches the integral...
$$\begineq L&=\int_{t_i}^{t_f} |\myv r'(t)|\,dt\\
 &=\int_{t_i}^{t_f} \sqrt{\left(\frac{df}{dt}\right)^2 
   + \left(\frac{dg}{dt}\right)^2
   + \left(\frac{dh}{dt}\right)^2
}\,dt
\\
 &=\int_{t_i}^{t_f} \sqrt{\left(f'(t)\right)^2 
   + \left(g'(t)\right)^2
   + \left(h'(t)\right)^2
}\,dt  
\endeq
$$

<h3>Example</h3>
<p class="show todo"><img src="0g/10.3.helix.jpg" class="rightalign">
Find the length of the arc of the helix that obeys the equation
$$\nonumber \myv r(t)=\langle \cos t, \sin t, t \rangle$$
from the point $(1,0,0)$ to $(1,0,2\pi)$.

<br><br>It looks like
$$ 0 \leq t \leq 2\pi.$$

<br><b>Estimating first:</b> Before you do the problem, what is the arclength around $\myc{\cos t, \sin t, 0}$ over that same interval $0\leq t\leq 2\pi$?  Will the answer to your problem above be greater than or less than this answer?
<div class="justme result">
The derivative is
$$ \myv r'(t) = \langle -\sin t, \cos t,1\rangle,\nonumber$$
and so...
$$|\myv r'(t)| = \sqrt{(-\sin t)^2 + (\cos t)^2 +1}=\sqrt 2.\nonumber$$
 
<br><br>Substituting into the arclength expression
$$L =\int_0^{2\pi} \sqrt 2 \,dt=\sqrt 2  2 \pi.\nonumber$$
</div>


<h3>Arclength distance function</h3>

<p class="show">

<p><img src="0g/10.3.soft.jpg" class="rightalign">
The arclength distance function $s(t)$, where $s(0)=0$,

<p class="show incremental def">$$s(t) = \int_0^t |\myv r'(t)|\, dt
=\int_0^t\sqrt{\left(\frac{dx}{dt}\right)^2 +
\left(\frac{dy}{dt}\right)^2+
\left(\frac{dz}{dt}\right)^2
}
\,dt$$.
<p>Taking the derivative w.r.t. $t$ of both sides, this means that 
$$\frac{ds}{dt}=|\myv r'(t)|.$$


<h3>Parameterizations</h3>
<p class="show">...though some 
well-regarded textbooks (Stewart!) write "<a href="http://www.google.com/?q=parametrization">parame<b>tri</b>zation</a>".]

<ul>
  <li>The same curve can be represented in more than one way.
  <li>E.g.
$$\myv r_1(t)=\langle t,t^2,t^3\rangle \nonumber;\ \ 1\leq t\leq 2$$
and
$$\myv r_2(u)=\langle e^u,e^{2u},e^{3u} \rangle;\ \ 0\leq u \leq \ln 2$$
</ul>

<div class="todo">
<p>The two parametric curves above are <a href="https://www.geogebra.org/3d/av9bfzaa">plotted here (GeoGebra)</a> (one as a point, and one as the tip of a position vector).  Discuss with a partner:
<ol>
<li>Moving the $t$ and $u$ sliders back and forth... does it seem like the two functions trace out the same trajectory?  Change the perspective a few times to make sure...
<li>Next, animate the two functions (press the little play button besided each slider) and watch the two functions.  Describe how the motions of the two functions differ.
</ol>
</div>

<h3>Re-parameterization</h3>

<p class="show">It may be useful (and is certainly beautiful) to re-parameterize a curve in terms of
the <b>arclength</b> along a curve
<ul><li> is characteristic of the curve itself,
<li>does not depend on the choice of parameter used to describe the curve,
<li> and does not depend on the coordinate system.
</ul>
<p class="def">We can use the <b>arclength</b> ("distance along the curve") as the <b>parameter</b> to describe a curve.
<p>Use $s$...instead of  time, or angle, or some other parameter.


<p><b>Example</b> -- $\myv r(t)=\langle \cos t,\sin t,t\rangle$: Reparametrize with respect to arc length, beginning at (1,0,0) in direction of increasing $t$.

<ul>
<li>$$|\myv r'(t)| = \sqrt{f'^2+g'^2+h'^2}=\sqrt{(-\sin t)^2+(\cos t)^2+1}=\sqrt 2.$$
<li>$$s(t)=\int_0^t|\myv r'(u)|\,du=\int_0^t\sqrt 2\,du=\sqrt 2 t.$$
<li>Solve for $t$:  $t=s/\sqrt 2$,
<li>and substitute back into original expression:
$$
\myv r(t(s))=\cos(s/\sqrt 2)\uv i+\sin(s/\sqrt 2)\uv j+s/\sqrt 2\uv k.
$$


</ul>
<p>This depends on being able (easily or otherwise) to take $s(t)$ and invert it to $t(s)$.


<p><img src="0g/10.3.arclengthP.jpg"><br>

<p>Our parameterization will result in a vector function $\myv r(s)$ of pathlength, $s$, such that the rate of change of the position function with respect to its parameter  along the curve obeys:

$$|\myv r'| = \frac{ |d\myv r|}{ds}= \lim_{\Delta s\to 0}\frac{|\Delta \myv r|}{\Delta s} = 1
$$
The distance moved along the path divided by the change in arc length is ... 1, since the distances are the same!



<p>This is related to a technique used in General Relativity where we talk about the "proper time" measured along the the space-time trajectory of a particle as a quantity that all observers agree on.






<h4 class="handout">Image credits</h4>
<p class="handout"><a href="http://en.wikipedia.org/wiki/File:Nowitna_river.jpg">Oliver Kurmis</a>

<?php include "../../classes/3.h" ?>