<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Limits and Continuity [10.1]
</title>
<meta name="week" content="5">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
Limits and Continuity [10.1]
</h1>
<!--
<p class="show"><img src="0g/11.2.roofline.jpg"><br>
A <i>discontinuous</i> roof.
-->
<p class="show"><img src="0g/11.2.Malta.jpg"><br>
<span class="caption"><a href="https://www.flickr.com/photos/reupa/21612359432">K. H. Reichert</a></span><br>
<p class="show">Sometimes where you end up depends on how you pursue your goals!</p>

<h3>Limit definition</h3>
<p class='show'>
$$\lim_{(x,y)\to (a,b)} f(x,y)=L$$
Meaning:
<ul>
<li>As $(x,y)$ approaches $(a,b)$...
<li>the limit of $f(x,y)$ is $L$...
<li><b>*if*</b> we can make the value of $f(x,y)$ as close to $L$ as we like...
<li>by taking $(x,y)$ sufficiently close to the point $(a,b)$, <b>but not equal to $(a,b)$</b>!
</ul>

<h3>Examples</h3>
<p class='show'>What happens as both $x$ and $y$ approach 0 for the function...
$$f(x,y)=\frac{\sin(x^2+y^2)}{x^2+y^2}?$$
<p><img src="0g/11.2.fvalues.jpg" class="big">
<p>It appears that we can write:
$$\lim_{(x,y)\to (0,0)} f(x)= 1.$$

<p class='show'>What happens as both $x$ and $y$ approach 0 for the function...
$$g(x,y)=\frac{x^2-y^2}{x^2+y^2}?$$
<p><img src="0g/11.2.gvalues.jpg" class="big">
<p>It appears that:
$$\lim_{(x,y)\to (0,0)} g(x)\ \text{does not exist}.$$
<p>Graphs of the two function<br>
<p><img src="0g/11.2.f+ggraph.jpg" class="big">

<h3>Direction of approach</h3>
<p class="show">
$$\lim_{(x,y)\to (a,b)} f(x,y)=L$$
means that the values of $f(x, y)$ approach the number $L$ as the point $(x, y)$ approaches the point $(a, b)$ <b>along any path</b> that stays within the domain of $f$:
<p><img src="0g/11.2.paths.jpg">

<ul>
<li>Our definition says that the distance between $f(x, y)$ and $L$ can be made arbitrarily small by making the distance from $(x, y)$ to $(a, b)$ sufficiently small (but not 0).
<li>The definition refers only to the distance between $(x, y)$ and $(a, b)$. It does not refer to the direction of approach.
<li>Therefore, if the limit exists, then $f(x, y)$ must approach the same limit no matter how $(x, y)$ approaches 
$(a, b)$.
<li>Thus, <b>if we can find two different paths of approach</b> along which the function has <b>different limits</b>, then $f(x, y)$ <b>has no limit</b> as $(x, y)$ approaches $(a, b)$.
</ul>

<p>For the function $g(x)=(x^2-y^2)/(x^2+y^2)$ the particular directions:
<ul>
<li>Along the $y$-axis, $x=0$, so $g(x,y)\to -y^2/y^2$, so apparently the limit when approaching the origin will be -1.

<li>But along the $x$-axis, $y=0$, so $g(x,y)\to x^2/x^2$, so apparently the limit when approaching the origin will be 1.
</ul>
<p>...So we have two different paths of approach with different limits, and therefore <b>*the*</b> limit of the $g(x,y)$ is not unique near the origin, and does not exist.

<h3>Converse?</h3>
<p class='show'>If we can show the same limit when approaching $(a,b)$ from two different directions, does that mean that a function has a unique limit at $(a,b)$?
 
<p>Consider the function $h(x,y)$
$$h(x,y)=\frac{xy}{x^2+y^2}.$$
Does it have a limit at the origin $(0,0)$ or not?

<ul>
<li><b>along the $x$-axis</b>: to get to the $x$-axis, $y\to 0$, and when this happens $f(x,y)\to 0/x^2\to 0$.

<li><b>along the $y$-axis</b>: to get to the $y$-axis, $x\to 0$, and when this happens $f(x,y)\to 0/y^2\to 0$.

</ul>

<p>So, <b>same limit</b> from <b>two different directions</b>.


<p>But approaching the origin along the line $x=y\equiv t$ [Hey, another use of <b style="color:#fb0">parameterization!</b>]:
$$h(t,t)=t^2/(2 t^2)\to 1/2.$$ 
So the limit along this line is 1/2, and *the* limit of $h$ at $(0,0)$ is not unique.

<p><img src="0g/11.2.hgraph.jpg">
<br>Graphically...
What is the limit as you approach the origin along the line $x=t$ and $y=-t$? (That is... $x=-y$)
<iframe src="https://www.geogebra.org/3d/csyz8qwd?embed" width="800" height="600" allowfullscreen style="border: 1px solid #e4e4e4;border-radius: 4px;" frameborder="0"></iframe>

<p><img src="0g/11.2.limitless.png"><br>


<h3>Continuity</h3>
<p class="show def">A function $f$ of two variables is called <b>continuous at $(a,b)$</b> if
$$\lim_{(x,y)\to (a,b)} = f(a,b).$$

<p>We say $f$ is <b>continuous on $D$</b> if $f$ is continuous at every point 
$(a,b)$ in $D$.

<h3>To do</h3>
<ul class="todo"><li>10.1.Limits handout</li>
</ul>

<h4 class="handout">Image credits</h4>
<p class="handout"><a href="https://www.flickr.com/photos/theenmoy/7549019918">Theen Moy</a>

<?php include "../../classes/3.h" ?>

