<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Partial derivatives [10.2]
</title>
<meta name="week" content="5">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h2>Which way to go?</h2>
<p><img src="0g/11.3.upwego.jpg" class="big">

<h2>The hiking question(s)</h2>
<p class="show"><img src="0g/11.3.upwego.jpg">

<p class="show">Which direction should I go...
<ul>
<li>to go up most steeply?
<li>to go down most steeply?
<li>to keep moving around the mountain while staying at the same altitude?
<li>Also, how steep is the path I'm on right now? 
</ul>
<p>Ummmmm... Actually our brains working with our eyes are pretty good at answering such questions <i>unconsciously</i> with little or no calculus training!
<p>We will instead be trying to answer questions about <b>surfaces</b> for which we have a <b>mathematical description</b> (often a function). The surfaces will mostly be continuous and well behaved.

<h3>The slope...in any direction</h3>
<p class="show"><img src="0g/11.3.upwego.jpg"><br>
For a function, $f(x)$, of one variable, $\frac{df}{dx}$ is <b>*the* slope</b> of the graph at $x$.  
<br><br>
But on a mountain (=<i>surface</i>),  <b>slope depends on the direction</b> of motion.  Or we could say, it depends on the <i>path</i> taken.

<h1>
Partial derivatives [10.2]
</h1>

<p class="def show">If $f$ is a function of two variables, then its <b>partial derivatives</b> are the functions $f_x$ and $f_y$ defined by
$$f_x(x,y)=\lim_{h\to 0}\frac{f(x+h,y)-f(x,y)}{h}$$
$$f_y(x,y)=\lim_{h\to 0}\frac{f(x,y+h)-f(x,y)}{h}$$
In the first definition, $y$ is constant and $x$ varies.  In the second one $x$ is constant and $y$ varies.

<p><b>Notation...</b>
$$f_x(x,y)\equiv f_x\equiv \frac{\del f}{\del x}\equiv \frac{\del}{\del x}f(x,y)\equiv \frac{\del z}{\del x}\equiv D_x f.$$
$$f_y(x,y)\equiv f_y\equiv \frac{\del f}{\del y}\equiv \frac{\del}{\del y}f(x,y)\equiv \frac{\del z}{\del y}\equiv D_y f.$$
with $z=f(x,y)$.

<p>[I have seen $f_1$ or $D_1$ very rarely].

<h3>Rules for calculating partial derivatives</h3>
<ol class="show def incremental">
<li>To find $f_x$, regard $y$ as constant, and differentiate $f(x,y)$ with respect to $x$.
<li>To find $f_y$, regard $x$ as constant, and differentiate $f(x,y)$ with respect to $y$.
</ol>
<p>For example:
$$f(x,y)=3xy^2$$
<p>$$f_x=\frac{\del
}{\del x} (3y^2)x=3y^2$$
<p>$$f_y=\frac{\del 
}{\del y}(3x)y^2=(3x)*2y=6xy$$

<p><img src="0g/11.3.CCdiff.jpg" class="rightalign">In CoCalc (at right):
<p><p><i>Mathematica</i>: <tt>D[f,x]</tt>, <tt>D[f,y]</tt>

<br clear="both">

<p class="todo">Do <a href="https://activecalculus.org/multi/S-10-2-First-Order-Partial-Derivatives.html#A_10_2_11">A 10.2.4, Speed of sound in the ocean</a>.

<h3>Visualizing</h3>
<p class="show"><img src="0g/11.3.tangents.jpg"  class="big">

<p class="show"><img src="0g/11.3.StewartCalculus.gif" class="big">

<div class="todo">
Look for 10.2-3.partials in the <b>handouts</b> folder.  
<ul class="todo">
<li>Tabular data - Just 1-3.
<li>Graphical data - Just 1-3.
</ul>
</div>




<h4 class="handout">Image credits</h4>
<p class="handout"><a href="http://www.flickr.com/photos/24738080@N00/8015267844">Matthiew Lienhart</a>


<?php include "../../classes/3.h" ?><