<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
2nd order partial derivatives [10.3]
</title>
<meta name="week" content="6">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>
<h1>2nd order partial derivatives</h1>
<p class="show"><img src="0g/10.3.solartrough.png" class="big"><br>
<span class="caption"><a href="https://pixels.com/featured/1-parabolic-trough-solar-power-plant-philippe-psaila.html">Philippe Psaila</a> Men working on the parabolic mirror array at <a href="https://www.acciona.no/projects/energy/concentrating-solar-power/thermal-solar-complex-in-palma-del-rio/">Palma Del Rio</a>, Spain</span>
<h4 class="show">Concavity, and beyond!</h4>


<h3>Higher order derivatives</h3>

<p class="show">
$$(f_x)_x=f_{xx}=\frac{\del}{\del x}\left( \frac{\del f}{\del x}\right)=\frac{\del^2 f}{\del x^2} =\frac{\del^2 z}{\del x^2}.$$ 

$$(f_{x})_{y}=f_{\color{blue}x\color{red}y}
=\frac{\del}{\del y}\left( \frac{\del f}{\del x}\right)
=\frac{\del^2 f}{\del {\color{red}y} \del {\color{blue}x}} =\frac{\del^2 z}{\del y \del x}.$$
The two different notations have  $x$ and $y$ occurring in different orders.

$$(f_y)_x=f_{yx}=\frac{\del}{\del x}\left( \frac{\del f}{\del y}\right)=\frac{\del^2 f}{\del x \del y} =\frac{\del^2 z}{\del x \del y}.$$ 


$$f_{yy}=(f_y)_y=\frac{\del}{\del y}\left( \frac{\del f}{\del y}\right)=\frac{\del^2 f}{\del y^2} =\frac{\del^2 z}{\del y^2}.$$ 

<p><b>Interpretation</b>
<p>$f_x$ means...what? <span class="justme result incremental">the slope in the $x$ direction</span>
<p>$f_{xx}$ means...what? <span class="justme result incremental">It is the rate of change...of the $f_y$ as you movin in the $y$ direction--the concavity of the curve of a path in the $y$ direction</span>
<p>$f_{yx}$ means... <span class="justme result incremental">the rate of change of the slope in the $y$ direction, as you increase $x$.</span>
<p>But is there a word like "concavity" to describe what that means graphically?  See this <a href="https://www.geogebra.org/3d/subwve7m">visualization of $f_{yx}$</a> (Move <tt>myx</tt>$\equiv x$ to see how the $y$ slope changes with $x$.)


<h3>Example</h3>

<p class="show">Consider...
$$\nonumber f (x, y) = x^3 + x^2y^3 – 2y^2$$
<p>$$\nonumber f_x=3x^2+2xy^3;\ \ \ f_y=3y^2x^2-4y$$

<p>$$\begineq
f_{xx}=\frac{\del f_x}{\del x}=6x+2y^3; \ \ \ \ & f_{xy}=\frac{\del f_x}{\del y}=6xy^2\\
& f_{yx}=\frac{\del f_y}{\del x}=6xy^2;\ \ \ f_{yy}=\frac{\del f_y}{\del y}=6yx^2-4\\

\nonumber
\endeq$$


<h3>Clairaut's theorem</h3>

<p class="show def">Suppose $f$ is defined on a disk $D$ that contains the point $(a,b)$.  If the functions $f_{xy}$ and $f_{yx}$ are both continuous on $D$, then
$$f_{xy}(a,b)=f_{yx}(a,b).$$
<p>Another way of saying this is
$$\frac{\del}{\del y}\left(\frac{\del f}{\del x}\right)
=\frac{\del}{\del x}\left(\frac{\del f}{\del y}\right).$$


<p>See <a href="11.3c.php">Clairaut's theorem and the meaning of $f_{xy}$</a>.

<h3>To Do</h3>
<ul class="todo">
<li>In the handouts folder... Go back to 10.2-3.partials.pdf.  Do the last page: <b>Mixed partials</b>
</ul>



<?php include "../../classes/3.h" ?>