<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Clairaut and cross derivatives [10.3]
</title>
<meta name="week" content="6">
<meta name="nolink" content="">
<?php include "../../classes/2.h" ?>

<h2>Clairaut's theorem</h2>
<p class="show">...and the meaning of 2nd order derivatives
<p>The point of this topic is to make Clairaut's theorem plausible <i>graphically</i>, and to give you a <i>graphical</i> sense of the meaning of second order derivatives.
<h3>What do they mean?</h3>
<p id="prime">In Calculus I:  What are the graphical meanings of
<ul><li>$$f'(x)\equiv\frac{df(x)}{dx}=?$$
<li>$$f''\equiv\frac{d^2f(x)}{dx^2}=?$$
</ul>
<a href="#prime" onclick="toggle_visibility('aprime');">show / hide</a>
<p id="aprime" class="answer toggle">
These are the  <b>slope</b> and <b>concavity</b> of the function.


<p id="dprime">Generalizing to functions of more than one variable...
<ul><li>$$f_x\equiv \frac{\del f(x,y)}{\del x}=?$$
<li>$$f_{yy}\equiv \frac{\del^2 f(x,y)}{\del y^2}=?$$
</ul>
<a href="#dprime" onclick="toggle_visibility('adprime');">show / hide</a>
<p id="adprime" class="answer toggle">
$f_x$ is the slope of a curve on the surface $f(x,y)$, traced out by increasing $x$, while holding $y$ constant. (The slope of a "$y=k$ trace").
<br><br>
$f_{yy}$ is the concavity of a curve on the surface $f(x,y)$ that's traced out by increasing $y$, while holding $x$ constant.  (The concavity of an "$x=k$ trace").

<p>And what about
<ul><li>$$f_{yx}\equiv \frac{\del}{\del x}\frac{\del f(x,y)}{\del y}=?$$</li>
</ul>
<a href="https://www.geogebra.org/3d/subwve7m">$f_{yx}$ visualization</a> (Geogebra):  Try setting $f_{yx}$ to a non-zero value, and running $x$ (<tt>myx</tt> slider) back and forth.

<h3>Approximating the change, $\Delta z$ of a function.</h3>


<p>Any <i>function</i>, $f(x,y)$ has a <b>unique value</b> for the value of the function, given a particular pair of values $(x,y)$ in its domain.

<p>Clairaut's theorem deals with <i>continuous functions</i>.

<p>Let's say that we start at the origin, $(x,y)=(0,0)$ and that we have a function whose value is 0 at the origin, $f(0,0)=0$.  

<p>We'd like to estimate the value of the function at a nearby position, 
$(x,y)$.

<p>If the surface is continuous, then even if we take different paths to get from (0,0)$\to(x,y)$ along the surface,  when we arrive at $(x,y)$ then we should
 expect to find the same height,  $f(x,y)$ no matter what path we take (in the domain).

<p>Though there are an infinite number of ways to move from (0,0) to (x,y), two that are particularly easy to calculate are these paths, consisting of two straight segments:

<ol>
<li> Moving from $(0,0)\to (x,0) \to (x,y)$.
<li> Moving from $(0,0)\to(0,y)\to(x,y)$.
</ol>
<h4>Linear approximation</h4>
<p>We could start by using just the values for the slopes, $f_x$ and $f_y$ calculated at the origin.  If we change $x$ by $\Delta x$, then the change in the function should be $\Delta f \approx \frac{\del f}{\del x}\Delta x$.

<p>So, using just $f_x$ and $f_y$ and the paths shown, for both paths we get the same result, namely:
$$f(x,y)=f(0,0)+f_x x+f_y y=f_x x+f_y y.$$
(Since we assumed $f(0,0)=0$).

<p>Visually (see the <a href="https://www.geogebra.org/3d/dumnwheh">Clairaut2 graph</a> with $f_{xy}=f_{yx}=0$.)

<p>This result is exact in the limit of small $x$ and $y$.  But to go a bit beyond the linear approximation we might consider using higher order derivatives:


<h4>Concavity</h4>
<p>We can get a better approximation by using not only the first order derivatives, but also these two second order derivatives $f_{xx}$ and $f_{yy}$.

<p>Now, instead of straight segments, we'll get curved segments.  But the value we get for $f(x,y)$ is still the same for both paths:
$$f(x,y)\approx f_x x +f_y y +\frac 12 f_{xx}\, x^2 +\frac 12 f_{yy}\,y^2.$$
Even if  $f_{xx}$ and $f_{yy}$ take on different values each opposite pair of boundaries of the surface patch has the same profile, and so 
we'll get to the same $f(x,y)$ on both paths.

<h4>$f_{xy}$ and $f_{yx}$</h4>

<p>Let's go back, for the sake of simplicity, to forgetting about concavity, and just trying to approximate $f$ using $f_x$, $f_y$, and now $f_{xy}$ and $f_{yx}$, all calculated at the origin.  

<p>Now the situation is different along each path. See the <a href="https://www.geogebra.org/3d/dumnwheh">Clairaut2 visualization</a> 
(GeoGebra).

<p>Color-coding the change in $z=f(x,y)$ according to the visualization,...
<p>Along $(0,0)\to(x,0)\to(xy)$ we have
$$\begineq f(x,y)&=\color{#900}{x f_x }+\color{#090}{y (f_y  + x f_{yx})} 
&=\color{#900}{x f_x }+\color{#090}{y f_y  +[yx f_{yx}] }
\endeq$$

<p>Along $(0,0)\to(0,y)\to(xy)$ we have

$$\begineq f(x,y)&=\color{#090}{y f_y }+\color{#900}{x (f_x  + y f_{xy})} 
&=\color{#090}{y f_y }+\color{#900}{x f_x  +[xyf_{xy}] }
\endeq$$

<p>These two expressions are not the same if $f_{xy}\neq f_{yx}$.

<p>But if $f(x,y)$ is different along two different paths, it is no longer uniquely defined at $(x,y)$, and so it's no longer a <i>continuous function</i>!  

<p>So we see that "to keep the neighborhood together" around (0,0), we will need to restrict $f_{xy}=f_{yx}$, which we calculated at (0,0).  This is the content of Clairaut's theorem:




<h3>Clairaut's theorem</h3>

<p class="show def">Suppose $f$ is defined[*] on a disk $D$ that contains the point $(a,b)$.  If the functions $f_{xy}$ and $f_{yx}$ are both continuous on $D$, then
$$f_{xy}(a,b)=f_{yx}(a,b).$$
<p>[*] for $f$ to be <i>defined</i> it must have a uniquely determined value for every point on the disk.
<p>Another way of saying this is
$$\frac{\del}{\del y}\left(\frac{\del f}{\del x}\right)
=\frac{\del}{\del x}\left(\frac{\del f}{\del y}\right).$$



<div class="justme">
<a href="0g/11.3.twister.nb">This notebook</a> explores the nature of $f_{xy}$ and $f_{yx}$ as used to find nearby points on the surface, and suggests a visual way of thinking about them.
</div>

<p>Paraphrasing this (and generalizing)... <b>for smoothly varying functions, $f(x,y,w,u,...)$, the order of differentiation does not matter.</b>


<!--
<p>The central assumption of Thermodynamics, according to Kerson Huang, is that there exists an equation of state linking the thermodynamics parameters of the form $f(P,V,T)=0$, and that the existence of this equation state is enormously restrictive.

<p>For "ideal" gases that equation is 
$$nRT-PV=0$$
That is to say:
$$PV=nRT$$

he ideal gas law, for a gas in a closed box, is an example of an <b>equation of state</b> that relates three thermodynamic parameters to each other:
$$PV=nRT.$$

This equation of state implies that $P$ is a continuous function of $V$ and $T$:
$$ P(V,T)=\frac{nrT}{V} $$
And so we know, even without working it out, that
$$\frac{ \del P}{\del V}=\frac{\del P}{\del T}$$
and $V$ and $T$ could also be written as functions of the other two.

-->

<?php include "../../classes/3.h" ?>
