<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Double integrals - general regions [11.3]
</title>
<meta name="week" content="9">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
Double integrals over general areas [11.3]
</h1>

<h2>Connecting area and volume views
</h2>

<p class="show">Or...connecting "area between curves" and 
"volume of a solid" interpretations of double-integrals.

<p>Consider the green area in the $xy$ plane
<img src="0g/12.1.order1.jpg">
<p>According to the "area between curves" view, the area in 
green could be given by:
$$\begineq A &= \int_{x=0}^{1}\int_{y=1-x}^{\sqrt{1-x^2}} 
dA\\
&=\int_{x=0}^{1}\left(\int_{y=1-x}^{\sqrt{1-x^2}} \,dy\right)\,dx\\
&=\int_{x=0}^{1}\left(\left.  y\right|_{y=1-x}^{\sqrt{1-x^2}}\right)\,dx\\
&=\int_{x=0}^{1}\left(\sqrt{1-x^2}-(1-x)\right) \,dx\\
&=\frac{\pi}{4} -\frac 12
\endeq
$$

<p>But we could instead think about  that double integral as the volume above a non-rectangular area in the $xy$ plane, going up to the surface $f(x,y)=1$, like this...
$$\begineq V &= \int_{x=0}^{1}\int_{y=1-x}^{\sqrt{1-x^2}} 
dA\\

&= \int_{x=0}^{1}\int_{y=1-x}^{\sqrt{1-x^2}} 
1\,dA\\
\endeq$$

<p>Then the volume corresponds to this solid:<br>
<img src="0g/12.3.vol.jpg"><br>
<ul><li>The base in the $xy$ plane is the green area $A$,
<li>it extends straight up from $A$,
<li>to a height of $1$...
<li>that is, it is bounded above by the surface $f(x,y)=1$.
</ul>

<p>The numerical value of the volume integral:
$$ V = \int_{x=0}^{1}\int_{y=1-x}^{\sqrt{1-x^2}} 1
\,dy\,dz$$
is the same as the numerical value of the area between curves that we first considered.
 

<h2>Double integrals above general areas</h2>

<p class="show">
$$\iint_A f(x,y)\,dA=?$$

Let's generalize our interpretation of this integral as the volume under $f(x,y)=1$ to *any* function $f(x,y)$:  In general this double integral is...
<ul><li>The volume of a solid,
<li>bounded, on the bottom, by a non-rectangular area, $A$, in the $xy$ plane.
<li>going straight up from that area,
<li>bounded above by a surface $f(x,y)$
</ul>

<p>This volume integral is represented in the picture below:
$$V = \int_{x=0}^{1}\int_{y=1-x}^{\sqrt{1-x^2}} 
x\,dA$$
<img src="0g/12.3.volx.jpg"><br>
It's bounded by $f(x,y)=x$ above.


<ul><li>See this <a href="https://www.geogebra.org/3d/memgxezs">view of the surfaces</a> (GeoGebra).
</ul>

<p>We shall find that now, the order of integration *does* affect how we write down the limits of a double integral. 


<h3>Order matters.</h3>
<p class="show"><img src="0g/12.1.order2.jpg" class="rightalign">
$\iint_A f(x,y)\,dA$
<ol class="else">
<li style="color:blue">Integrate first with respect to y
<li>This gives us the area, $A(x)$, of a cross-section through the solid above the blue arrow, <i>which depends on $x$,</i>
$$A(x)=\int_{y=1-x}^{\sqrt{1-x^2}} f(x,y)\,dy.$$


<li style="color:red">Integrate second with respect to x
</ol>
<p class="show">Written...
$$\int_{x=0}^1A(x)\,dx=\int_{x=0}^1\int_{y=1-x}^{\sqrt{1-x^2}} f(x,y)\,dy\,dx$$


<h3>Order matters..</h3>
<p class="show"><img src="0g/12.1.order3.jpg" class="rightalign">
$\iint_A f(x,y)\,dA$
<ol class="else">
<li style="color:red">Integrate first with respect to x, 
<li>This gives us the area, $A(y)$, of a cross section through the solid above the red
 arrow, 
<i>which depends on $y$,</i>
$$A(y)=\int_{x=1-y}^{\sqrt{1-y^2}} f(x,y)\,dx$$
<li style="color:blue">Integrate second with respect to y
</ol>
<p class="show">Written...
$$\int_{y=0}^1A(y)\,dy=\int_{y=0}^1\int_{x=1-y}^{\sqrt{1-y^2}} f(x,y)\,dx\,dy.$$


<h3>Example</h3>
<p class="show"><img src="0g/12.1.4x2.jpg" class="rightalign">
$\iint_A (4x+2)\,dA$

<h3>Regions</h3>
<p class="show">
You should be able to sketch the region of integration in $x$ and $y$ given a double integral. For example:
$$\int_0^1\int_y^\sqrt{y} x^2y^2\,dx\,dy$$
<p>...means
$$\int_{y=0}^1\left(\int_{x=y}^\sqrt{y} x^2y^2\,dx\right)\,dy$$
<p>$\Rightarrow$<br>
<img src="0g/12.1.region1.jpg">

<h3>Changing the order of integration</h3>
<p>$$\int_{x=-1}^0\int_{y=0}^{x+1}e^{x+y}dy\,dx+\int_{x=0}^1\int_{y=0}^{1-x} e^{x+y}dy\,dx$$

<p>$\Rightarrow$<br>
<img src="0g/12.1.region2.jpg">


<p>We could get the same result in one integral, integrating first over $x$ then $y$ like this...<br>
<img src="0g/12.1.region2b.jpg"><br>

<p>The line $y=x+1$ can be re-arranged to $x=y-1$.<br>
The line $y=1-x$ can be re-arranged to $x=1-y$:

$$\int_{y=0}^1\int_{x=y-1}^{1-y} e^{x+y}dx\,dy$$

<h3>To do (/handouts/)</h3>
<ul class="todo">
<li>11.2.practice: Double Integrals Practice: #5-7
<li>mv11.3.limits: Limits on Double Integrals
<li>mv11.3.DI-problems: Double Integrals: Problems
</ul>
<?php include "../../classes/3.h" ?>