<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Polar Integrals
[11.5] 
</title>
<meta name="week" content="10">
<?php include "../../classes/2.h" ?>

<h1>
Polar integrals [11.5]
</h1>
<img src="0g/12.4.igloovillage.jpg"><br>
<i>Kakslauttanen Igloo Village, Finland</i>
<h3>Area in Cartesian coordinates</h3>
<p class="show">In Cartesian coordinates...<br>
<img src="0g/11.4.Cartesian.jpg"><br>
Consider...
<ul><li>the path traced out by increasing the $x$ coordinate of a position vector by an amount $\Delta x$.
<li>the path traced out by increasing the $y$ coordinate of a position vector by an amount $\Delta y$.
</ul>
<p>These two paths define a parallelogram with an area $\Delta A = \Delta x\,\Delta y$<br>

<p>One thing you may take for granted...
<ul><li><b>No matter where we we are in the $xy$ plane, $\Delta A =\Delta x\,\Delta y$</b>
</ul>

<p>As the changes get small--$\Delta x\to dx$ and $\Delta y\to dy$--the differential of area is
$$dx\,dy = dA.$$



<h3>Area in Polar coordinates</h3>
<p>We reviewed <a href="mv09.6.php#polar">polar coordinates (briefly)</a>.
We can readily see that:
$$\Delta \theta\, \Delta r \neq dA,$$
since the units don't work out:  $\Delta r$ is a length (for example, in cm); But $\Delta \theta$ has units of <i>radians</i>.






<p class="show">Considering changes in polar coordinates in more detail...<br>
<img src="0g/11.5.Polar.jpg">
<ul><li>Increasing the coordinate $r$ by an amount $\Delta r$ traces out a path of length $\Delta r$.
<li>But increasing the coordinate $\theta$ by an amount $\Delta \theta$ causes the position vector to trace out a path of length $r\Delta \theta$, which depends on the distance $r$ from the origin.
</ul>

<p>The area of the shaded region is a bit odd-shaped.  But as changes in the coordinates get very small--that is $\Delta \theta \to d\theta$ and $\Delta r\to dr$--the area becomes
more nearly rectangular (see this <a href="https://www.desmos.com/calculator/3fubt1w1xg">desmos diagram</a>), with sides of length $r\,d\theta$ and $dr$, so...
<p class="def show incremental">
Differential of area in polar coordinates:
$$dA=(r\,d\theta)\,dr=r\,dr\,d\theta.$$

<h4>Area of a circle</h4>
<p><b>Wouldn't it be nice?</b> ...if we could find areas in polar coordinates using an iterated double integral together with our recently derived $dA$?

<p>Let's try to find the area of a circle of radius $R$ (you know the answer) like this:
$$\begineq
A &=\iint_A\,dA\endeq$$
<p>We'd have to  define the limits on the integrals in polar coordinates.  <br><br>Think of a position vector in polar coordinates, $\myv r=\myc{ r,\theta}$.  What are all the possible values of $r$ and $\theta$ for points inside a circle of radius $R$?  This leads to the following limits...
$$\begineq \iint_A\,dA&=\int_{\theta=0}^{2\pi}\int_{r=0}^R r\,dr\,d\theta \\
&=\int_{\theta=0}^{2\pi}\left( \left. \frac{r^2}{2} \right|_0^R\right)\,d\theta\\
&=\frac{R^2}{2}\int_{\theta=0}^{2\pi}d\theta=\frac{R^2}{2}2\pi = \pi R^2.
\endeq
$$

<h3>Double polar integrals.</h3>
<p class="show"><img src="0g/12.4.polarint.jpg" class="rightalign"><br>
$A=\iint_A f(r,\theta)\,dA=?$

<h3>Double polar integrals..</h3>
<p class="show"><img src="0g/12.4.polarint2.jpg" class="rightalign"><br>
$A=\iint_A f(r,\theta)\,dA=?$
<p>The line $\sqrt 2=y=r\sin\theta$ becomes<br>
$r(\theta)=\frac{\sqrt 2}{\sin\theta}=\sqrt 2 \csc\theta$.
<p>The double integral becomes:
$$A=\int_{\theta=\pi/4}^{\pi/2}
\int_{r=\sqrt 2\csc\theta}^2 f(r,\theta)\,r\,dr\,d\theta.$$

<h3>Converting...</h3>
<p class="show"><img src="0g/12.4.halfpi.jpg" class="rightalign"><br>
Converting a double-integral in Cartesian coordinates to polar coordinates:
<br><br>
$\iint_A e^{x^2+y^2}dA=\int_{x=-1}^1\int_{y=0}^{\sqrt{1-x^2}}e^{x^2+y^2}dy\,dx=...$
<ul><li>$r$ runs from 0 to 1.
<li>$\theta$ runs from 0 to $\pi$.
<li>ah, $x^2+y^2=r^2$
<li>$dx\,dy=dA=r\,dr\,d\theta$
</ul>

<p>$$\begineq\iint_Ae^{r^2}dA &=\int_{\theta=0}^{\pi}\int_{r=0}^1e^{r^2}r\,dr\,d\theta\\
&=\int_{\theta=0}^{\pi}\left(\left.\frac{e^{r^2}}{2}\right|_{r=0}^1\right)\,d\theta\\

&=
\left(\frac{e-1}{2}\right)\int_{\theta=0}^{\pi}\,d\theta
=
(e-1)\frac\pi 2 \approx 2.70 
\endeq
$$

<h3>ToDo</h3>
<p class="show todo">11.5 Polar - Double integrals in polar coordinates</p>

<h4 class="handout">Image credits</h4>
<p class="handout"><a href="https://www.flickr.com/photos/visitfinland/5263393586">Visit Finland</a>


<?php include "../../classes/3.h" ?>